---
layout: post
title: George.com enhances the mobile customer experience with new Progressive Web App 
date: 2018-02-23
updated: 2018-02-27
tags:
  - blog # blog is a required tag for the article to show up in the blog.
  - case-study
---

[George.com](http://www.george.com) is a leading UK clothing brand, part of ASDA
Walmart. After upgrading their site to a Progressive Web App (PWA), the brand 
saw a 31 percent increase in mobile conversion.

- 3.8x - Faster average page load time
- 2x - Lower bounce rate
- 31% - Increase in Conversion Rate
- 20% - More page views per visit
- 28% - Longer average time on site for visits from Home screen


## Challenge

With consumer expectations around the mobile shopping experience at an all-time 
high, Asda George realized they needed to revamp an outdated mobile solution and
thereby improve the offer for customers. The team embraced a mobile-first approach, 
placing focus on design, speed and functionality to drive mobile conversion.

## Solution

The George.com team recognized that to meet this challenge the business had to
enhance the mobile experience by building a Progressive Web App. Working with 
Isobar UK to assess the end to end customer journey, the team adopted a scrum 
driven, agile approach to the workstream. By incrementally deploying the PWA, the 
Asda George team were able to realize the benefits immediately.

<div class="switcher">
  <figure>
    {% Img src="image/T4FyVKpzu4WKF1kBNvXepbi08t52/Dgw4Dg0zGAdYbkZLtqTY.png", alt="Skeleton screen during page transition", width="300", height="652" %}
    <figcaption>Skeleton screen during page transition</figcaption>
  </figure>
  <figure>
    {% Img src="image/T4FyVKpzu4WKF1kBNvXepbi08t52/5IAPQvot5X1QSDiRppml.png", alt="Page fully rendered after page transition", width="300", height="655" %}
    <figcaption>Page fully rendered after page transition</figcaption>
  </figure>
</div>

Site speed was the most crucial part of the initiative. Following PWA best 
practices, in accordance with Google, Asda George reduced page load time for 
shoppers by **3.8x times**. The business also saw a 31 percent 
increase in conversion and **20 percent more page views** per visit. 

By implementing site wide HTTPS, Asda George now offers a more secure end-to-end
 shopping experience for customers, enabling modern browser capabilities, like 
 Service Worker, and therefore allowing consumers to stay in touch with the brand 
 whilst offline. 

In addition, the brand implemented an “Add to Home Screen” prompt, which resulted
 in an increase in customer time on site by **28 percent**, truly 
 creating a native app like experience on the web.
