---
layout: post
title: AliExpress
date: 2016-05-17
updated: 2016-05-17
tags:
  - blog # blog is a required tag for the article to show up in the blog.
  - case-study
---

### Summary {: .hide-from-toc }

AliExpress increases conversion rate for new users by 104% with new
Progressive Web App

### Results

- 104% for new users across all browsers; 82%
increase in iOS conversion rate
- 2X more pages visited per session per user
across all browsers
- 74% increase in time spent per session
across all browsers

[Download PDF Case study](https://storage.googleapis.com/web-dev-uploads/file/T4FyVKpzu4WKF1kBNvXepbi08t52/ODQ7ENAMWwMMS9SoQxup.pdf)

## About AliExpress

"Smarter shopping, better living!" is the motto of AliExpress, a website where
shoppers can buy everything from baby clothes to refrigerators directly from
China. Part of the Alibaba Group, the global online retail marketplace is now
a popular e-commerce site in America, Russia, and Brazil.

## Challenge

Building great mobile experiences is an indispensable part of AliExpress’
success, as mobile commerce is growing [three times](http://www.demacmedia.com/infographic/mobile-commerce/)
faster than e-commerce. The mobile web is their primary platform for discovery
so they have always focused its design and functionality. But AliExpress found
it difficult to build an engaging experience on the web that was as fast as
their mobile app. They looked at the mobile web as a platform to transition a
non-app user to an app user. Not everyone downloaded their app, however, and
getting users to install and re-engage with it was challenging and costly.

## Solution

AliExpress looked for a way to provide all of their web users with the benefits
of their app, such as performance and the ability to work offline and re-engage
users. They built a cross-browser Progressive Web App ([https://m.aliexpress.com](https://m.aliexpress.com))
to combine the best of their app with the broad reach of the web.

After implementing their Progressive Web App, AliExpress saw conversion rates
for new users increase by 104%. This investment in the mobile web also resulted
in conversion rates on Safari increasing by 82%. The new strategy also
delivered a much better experience. Users now visit twice as many pages per
session, and time spent per session increased an average of 74% across all
browsers.

{% Blockquote 'Lijun Chen, director of AliExpress Mobile Team.' %}
One of the reasons we built a Progressive Web App was to be able to invest
in the web experience across all browsers. Not only did we see huge benefits
on browsers that support the latest features, but we also got to see a bump
across the board. That is the sign of a great investment, and one that will
keep paying for itself as browsers evolve.
{% endBlockquote %}
