---
layout: post
title: Accessibility Week
subhead: >
  Our week celebrating accessibility resources
description: >
  This week we celebrated accessibility work and highlighted
  resources to help you make your sites and applications
  usable by everyone.
date: 2022-11-18
authors:
  - alexandrawhite
  - rachelandrew
hero: image/VbsHyyQopiec0718rMq2kTE1hke2/F6xN4wjE6Y9vgh1m1uCi.png
alt: 'Learn Accessibility! Community highlight.'
thumbnail: image/VbsHyyQopiec0718rMq2kTE1hke2/F6xN4wjE6Y9vgh1m1uCi.png
tags:
  - blog
  - accessibility
---

This week we highlighted accessibility resources to help you make your sites
and applications usable by everyone.

We're continuing to roll out [Learn Accessibility](/learn/accessibility/), a
brand new course written by [Carie Fisher](https://twitter.com/cariefisher)
that will take you through the essentials for building accessible websites and
web apps.

We've had 3 community spotlights:

* [Melanie Sumner](/community-highlight-melanie/) told us about her journey
  into engineering, accessible design, Ember.js, and the importance of funding
  these efforts.
* [Olutimilehin Olushuyi](/community-highlight-shuyi/) told us about his move
  from the law to web development, building accessible community, and creating
  accessible layouts.
* [Albert Kim](/community-highlight-albert-kim/) told us about mental health
  awareness, building for invisible disabilities, the  COGA Accessibility
  Community Group, and more practical wisdom.

## Watch us answer your questions

On Thursday, Alexandra White spoke with Carie Fisher and Melanie Sumner about
accessibility, and we answered some of your questions.

{% YouTube "xvGDgDRWl_E" %}

Have more questions? Ask us on Twitter,
[@ChromiumDev](https://twitter.com/chromiumdev).

## More resources

A solid document structure is a great start for accessible development. Find
out how to really use HTML in  our [Learn HTML](/learn/html) course. Follow it
up with Learn Accessibility's [Content structure module](/learn/accessibility/structure/)
for more on semantic HTML, landmarks, and tables for accessible content.

In [Testing web design color contrast](/testing-web-design-color-contrast/) get
an overview of three tools and techniques to ensure your content is readable by
everyone.

In [Building the main navigation for a website](/website-navigation/) learn how to create accessible navigation using semantic HTML.

## On the web

* The W3C hosts a collection of [courses, training, and certification on digital accessibility](https://www.w3.org/WAI/courses/list/) from different providers.
* Read [Accessibility articles on Smashing Magazine](https://www.smashingmagazine.com/category/accessibility/), including [&lt;article> vs. &lt;section>: How To Choose The Right One](https://www.smashingmagazine.com/2022/07/article-section-elements-accessibility/) by Olushuyi Olutimilehin.
* If you're making a case for accessibility work at your company, check out Melanie Sumner's [pleasefunda11y.com](https://pleasefunda11y.com/).
* If you want to support the Cognitive and Learning Disabilities Accessibility Task Force, join the [COGA Accessibility Community Group](https://www.w3.org/community/coga-community/). This group supplies user needs and feedback to the COGA Task Force.
