---
layout: post
title: "Create a Progressive Web App with the Angular CLI"
subhead: |
  You want to make your Angular app installable? Wait no more!
hero: image/admin/8lEoUW3i1nEU1q10N1YK.jpg
alt: Network cables.
date: 2019-08-15
description: |
  Learn how to create installable progressive Angular applications.
authors:
  - mgechev
tags:
  # - angular
  - progressive-web-apps
feedback:
  - api
---

In this post, you'll learn how to use the Angular command line interface (CLI) to make a [Progressive Web App (PWA)](/discover-installable).

_You can find the code sample from this guide [on GitHub](https://github.com/mgechev/manifest-web-dev)._

{% Aside %}

This post assumes you're already familiar with PWAs and their benefits. If you need a refresher, check out the [Installable](/installable) collection.

{% endAside %}


## Create an installable PWA

To make your Angular application a PWA, all you need to do is run a single command:

```bash
ng add @angular/pwa
```

This command will:

* Create a [service worker](/precaching-with-the-angular-service-worker) with a default caching configuration.
* Create a [manifest file](/add-manifest), which tells the browser how your app should behave when installed on the user's device.
* Add a link to the manifest file in `index.html`.
* Add the [`theme-color`](https://developer.chrome.com/docs/lighthouse/pwa/themed-omnibox/) `<meta>` tag to `index.html`.
* Create app icons in the `src/assets` directory.

By default, your service worker should be registered within a few seconds of the first page load. If it isn't, consider modifying the [`registrationStrategy`](https://angular.io/api/service-worker/SwRegistrationOptions).

## Customize your PWA

The [Precaching with the Angular service worker](/precaching-with-the-angular-service-worker) post explains how to configure the Angular service worker. There you can find how to specify which resources you want the service worker to cache and what strategy it should use to do so.

The manifest file of your app lets you specify your app's name, short name, icons, theme color, and other details. Read about the full set of properties you can set on the [Add a web app manifest](/add-manifest/) post.

Take a peek at the manifest file generated by the Angular CLI:

```json
{
  "name": "manifest-web-dev",
  "short_name": "manifest-web-dev",
  "theme_color": "#1976d2",
  "background_color": "#fafafa",
  "display": "standalone",
  "scope": "/",
  "start_url": "/",
  "icons": [
    {
      "src": "assets/icons/icon-72x72.png",
      "sizes": "72x72",
      "type": "image/png"
    },
    …
    {
      "src": "assets/icons/icon-512x512.png",
      "sizes": "512x512",
      "type": "image/png"
    }
  ]
}
```

You can customize any of these properties by changing the relevant value in `manifest.webmanifest`.

A PWA references its manifest file with a `link` element in `index.html`. Once the browser finds the reference, it'll show the **Add to Home screen** prompt:

<figure>
  {% Img src="image/admin/IgMnFCuRU1Fx9JLZWXuT.png", alt="A progressive web app install prompt", width="344", height="650" %}
</figure>

Since the `ng-add` schematics add everything needed to make your app [installable](/discover-installable/), they generate some shortcut icons that are shown once the user adds the app to their desktop:

<figure>
  {% Img src="image/admin/3h7Yuj3MJPiNzbh2xdlB.png", alt="A progressive web app shortcut icon", width="344", height="650" %}
</figure>

Make sure you customize the manifest properties and icons before you deploy your PWA to production!

{% Aside %}
If you want to change your PWA back to a standard web app, just remove the reference to `manifest.webmanifest` from `index.html`.
{% endAside %}

## Conclusion

To make an installable Angular app:

1. Add `@angular/pwa` to your project using the Angular CLI.
2. Edit the options in the `manifest.webmanifest` file to suit your project.
3. Update the icons in the `src/assets/icons` directory to suit your project.
4. Optionally, edit the `theme-color` in `index.html`.
