---
layout: 'about'
title: 'About web.dev'
banner:
  eyebrow: 'About web.dev'
  title: 'Guidance from Chrome Developer Relations'
  summary: |
    We want to help you build beautiful, accessible, fast, and secure websites that work cross-browser, and for all of your users. This site is our home for content to help you on that journey, written by members of the Chrome team, and external experts.
  image: 'image/jxu1OdD7LKOGIDU7jURMpSH2lyK2/R8GB4ZvgVvy4gimaqrXs.png'
  imageWidth: '546'
  imageHeight: '421'
intro:
  title: 'On this site'
  summary:
    - paragraph: Explore our archive of content, covering subjects across the web development stack. Find the latest news and content on our <a href="/blog/">blog</a>, and discover content by groups on the <a href="/explore">explore</a> page.
    - paragraph: For complete courses on key web development topics, check out <a href="/learn/">Learn</a>. Developed by industry experts, these courses take you right through a subject. They are structured to allow you to just dip into one or two modules of interest too.
    - paragraph: Want some grab and go code? Our <a href="/patterns/">Patterns</a> break down common web development requirements. Whether you want to understand how to approach a certain UI component, or need to know how to copy an image to the <a href="/patterns/clipboard/">clipboard</a>, you’ll find a solution there.
    - paragraph: To help you make a case for work on UI or Performance, we have <a href="/tags/case-study/">case studies</a>. Find out how other companies have used metrics such as Core Web Vitals to see real results. And, if that’s quite enough reading for one day we also have a great archive of <a href="/podcasts/">podcasts</a> and other <a href="/shows/">shows</a>, plus recordings of our <a href="/spaces/">Twitter Space</a> sessions with members of the Chrome team.
    - paragraph: We believe that a web with multiple browser engines is important, and that web sites and applications should work well no matter which browser your visitors use. We know that you care about that too, and so content on this site should have cross-browser status clearly explained. You’ll see that many articles have a component showing browser support—the data comes from our friends at MDN, via the Browser Compat Data project that powers the data on MDN pages.
theTeam:
  title: 'The team'
  subTitle: 'This site is brought to you by the Chrome DevRel team led by:'
  authors:
    - name: paulkinlan
      role: DevRel lead
    - name: rachelandrew
      role: Content lead
    - name: rowan_m
      role: SPPI lead
    - name: andreban
      role: Infrastructure lead
    - name: philipwalton
      role: Performance Lead
    - name: una
      role: CSS and UI lead
    - name: alispivak
      role: Chrome extensions lead
    - name: petelepage
      role: Advanced apps lead
    - name: ewagasperowicz
      role: Tech lead
  primaryButtonText: 'See our authors'
  primaryButtonUrl: '/authors/'
developers:
  title: 'Making the web better for tomorrow'
  summary: |
    We hope web.dev helps you to create high quality web experiences today. The Chrome team is also working to make the web better tomorrow. If you want to learn more about what we are doing, and offer feedback on the features we are developing and contributing to, check out <a href="https://developer.chrome.com/">Chrome Developers</a>.
  primaryButtonText: 'Chrome Developers'
  primaryButtonUrl: 'https://developer.chrome.com/'
coupledColumn:
  - icon: 'icons/spotted.svg'
    title: 'Spotted an error?' 
    summary: |
      Please <a href="https://github.com/GoogleChrome/web.dev/issues">raise an issue</a> with information about the page and what’s wrong, and we’ll take a look.
  - icon: 'icons/edit.svg'
    title: 'Want to contribute?' 
    summary: |
      We feature articles and larger sections of content from external authors. If you would like to pitch an article, <a href="mailto:rachelandrew@google.com">contact Rachel Andrew</a> with an outline of your idea.
---
