const buttons = document.querySelectorAll("[data-carousel-button]")

buttons.forEach(button => {
  button.addEventListener("click", () => {
    const offset = button.dataset.carouselButton === "next" ? 1 : -1
    const slides = button
      .closest("[data-carousel]")
      .querySelector("[data-slides]")

    const activeSlide = slides.querySelector("[data-active]")
    let newIndex = [...slides.children].indexOf(activeSlide) + offset
    if (newIndex < 0) newIndex = slides.children.length - 1
    if (newIndex >= slides.children.length) newIndex = 0

    slides.children[newIndex].dataset.active = true
    delete activeSlide.dataset.active
  })
})




const backToTopBtn = document.querySelector(".back-to-top--btn");
window.addEventListener("scroll", () => {
  if (window.scrollY > 250) {
    // console.log("berks");
    backToTopBtn.setAttribute("data-visible", true);
    // cartSection.setAttribute("data-visible", true);
  } else {
    // console.log("still berks");
    // cartSection.setAttribute("data-visible", false);
    backToTopBtn.setAttribute("data-visible", false);
  }
});

backToTopBtn.addEventListener("click", () =>
  window.scrollTo({ top: 0, behavior: "smooth" })
);

var months = 
['January','February','March','April','May','June','July',
'August','September','October','November','December'];       
var tomorrow = new Date();
/* tomorrow.setTime(tomorrow.getTime() + (1000*3600*24)); */       
document.getElementById("spanDate").innerHTML = 
tomorrow.getDate() + " " + months[tomorrow.getMonth()]+ " " + 
tomorrow.getFullYear();
