!["FileUltimate Logo](fileultimate-logo.png)
# File Manager and File Uploader for ASP.NET
[![GleamTech.FileUltimate Nuget](https://img.shields.io/nuget/v/GleamTech.FileUltimate)](https://www.nuget.org/packages/GleamTech.FileUltimate/ "GleamTech.FileUltimate Nuget")

Integrate a file manager into your ASP.NET application or site rapidly.

- Browse and manage files with access control.
- Accept files with the advanced upload functionality (uploader is also available as a standalone component).
- Offer a structured and neat download area.
- Preview documents (70+ file formats, including PDF & Microsoft Office), images, audios and videos.

![File Manager and File Uploader for ASP.NET](fileultimate-screenshot.png)

**Note:** This project contains a fully working version of the product, however without a license key it will run in trial mode. For more information, please see [ASP.NET File Manager and ASP.NET File Uploader](https://www.gleamtech.com/fileultimate) product page.

### Live Demo:
https://demos.gleamtech.com/fileultimate/

### Adding references to FileUltimate assemblies:
https://docs.gleamtech.com/fileultimate/html/adding-references-to-fileultimate-assemblies.htm

### Using FileUltimate in an ASP.NET Core project:
https://docs.gleamtech.com/fileultimate/html/using-fileultimate-in-an-asp-net-core-project.htm

### Using FileUltimate in an ASP.NET MVC project:
https://docs.gleamtech.com/fileultimate/html/using-fileultimate-in-an-asp-net-mvc-project.htm

### Using FileUltimate in an ASP.NET WebForms project:
https://docs.gleamtech.com/fileultimate/html/using-fileultimate-in-an-asp-net-webforms-project.htm

### Showcase videos:
[![ASP.NET Core File Manager - Getting Started](https://i.ytimg.com/vi/gINbYx-VP2Y/maxresdefault.jpg)](https://youtu.be/gINbYx-VP2Y "ASP.NET Core File Manager - Getting Started")

[![ASP.NET Core File Uploader - Getting Started](https://i.ytimg.com/vi/LWGYuZzYxzg/maxresdefault.jpg)](https://youtu.be/LWGYuZzYxzg "ASP.NET Core File Uploader - Getting Started")

