<p align="center">
  <img src="https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/githubdaily_brand.png">
</p>

<p align="center">
  <a href="https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/weixin.png"><img src="https://img.shields.io/badge/ GitHubDaily-公众号-brightgreen.svg" alt="WeChat"></a>
  <a href="https://weibo.com/GitHubDaily"><img src="https://img.shields.io/badge/%E6%96%B0%E6%B5%AA-%E5%BE%AE%E5%8D%9A-red" alt="Weibo"></a>
  <a href="https://www.zhihu.com/people/githubdaily"><img src="https://img.shields.io/badge/%E7%9F%A5%E4%B9%8E-blue" alt="Zhihu"></a>
  <a href="https://github.com/GitHubDaily/GitHubDaily/stargazers"><img src="https://img.shields.io/github/stars/GitHubDaily/GitHubDaily" alt="GitHub stars"></a>
</p>

## 宗旨

多年以前，我曾看到 GitHub 开源项目作者、全栈工程师 TJ Holowaychunk 说过这么一句话：

"I don't read books, never went to school, I just read other people's code and always wonder how things work"。

从那时起，我便认为，通过阅读源码，站在前辈的角度上，去思考代码架构与程序逻辑，乃是提升编程技巧最好的方式。

因此，GitHub 也自然而然的，成为我最喜爱的开发者平台。

秉着挖掘开源价值的初衷，GitHubDaily 自 2015 年 10 月 10 日正式成立。

我们希望能通过这一举措，帮助开发者们发现当下最火的开源项目，掌控最新技术动态, 扩大技术视野, 并从开源项目的学习中获得编程能力的提升。

目前，GitHubDaily 已累积分享超过 3000 个开源项目，内容包括但不限于 GitHub 上的开源技术资料、开发者工具、编程网站以及成熟应用。

除了 GitHub 之外，我们也开始在下面多个社交媒体平台，帮助开发者传播与分享优质开源项目，挖掘其未来的技术应用前景。

如果你想接收最新的 GitHub 开源项目资讯，可以关注一下👇

- 公众号: [GitHubDaily](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/weixin.png)
- 微博: [@GitHubDaily](https://weibo.com/GitHubDaily)
- 知乎: [@GitHubDaily](https://www.zhihu.com/people/githubdaily)

> 有不错的开源项目，也欢迎到本仓库的 [issues](https://github.com/GitHubDaily/GitHubDaily/issues/new) 推荐或自荐项目，我们期待你的分享。

---

## 2023 年复盘

下面是对 GitHubDaily 在 2023 年所推荐的项目进行分类整理，方便大家查找以往分享过的内容。

> 过往复盘 [2022](https://github.com/GitHubDaily/GitHubDaily/blob/master/2022.md)， [2021](https://github.com/GitHubDaily/GitHubDaily/blob/master/2021.md)，[2020](https://github.com/GitHubDaily/GitHubDaily/blob/master/2020.md)，[2019](https://github.com/GitHubDaily/GitHubDaily/blob/master/2019.md)，[2018](https://github.com/GitHubDaily/GitHubDaily/blob/master/2018.md)

### 目录

- [宗旨](#宗旨)
- [2023 年复盘](#2023-年复盘)
  - [目录](#目录)
  - [AI 绘画](#ai-绘画)
  - [AIGC](#aigc)
  - [AI 工具](#ai-工具)
  - [实用工具](#实用工具)
  - [插件](#插件)
  - [资料集合](#资料集合)
  - [书籍/教程](#书籍教程)
  - [其他](#其他)
- [声明](#声明)


### AI 绘画

名称 | 简述 | 源
---- | ----- | -----
[Stable Diffusion Cheat-Sheet](https://github.com/SupaGruen/StableDiffusion-CheatSheet) | Stable Diffusion 开源速查表，里面拥有超过 700 种经过测试的艺术风格，可快速搜索查找各类艺术家，并支持一键复制 Prompt。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N3Qqdubhy)
[StableStudio](https://github.com/Stability-AI/StableStudio) | 人手一个 Midjourney，Stability AI 开源的 AI 图像生成平台 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N14VOFWKZ)
[Roop](https://github.com/s0md3v/roop) | 一键实现 AI 换脸，仅需一张换脸图像，无需数据集，无需训练，自带敏感图像检测功能。| [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N63U7sEzT)
[pixian.ai](https://pixian.ai/) | 能够利用 AI 一键移除各种图像背景，并支持在线调整图片分辨率、背景颜色等等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N5hJ6bIQ5)
[Inpaint Anything](https://github.com/geekyutao/Inpaint-Anything) | 一个 AI 图像编辑工具，支持一键擦除、替换图像中的指定物品，通过提示词来自动更换背景图。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MCqg6oZvy)
[Segment Anything (SAM)](https://github.com/facebookresearch/segment-anything) | 一个图像分割模型，可自动分割图片或视频中的所有物品，一键完成自动分割，并支持零样本转移到其他分割任务。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MAGpKkHqx)
[Docker 作图咒语生成器](https://github.com/soulteary/docker-prompt-generator) | 支持一键从图片中解析出 Prompt 描述，并能够基于描述进行扩展，以便二次图片生成。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MBvFcy0Mp)
[Plask.ai](https://plask.ai/) | 一个 AI 工具，可以通过 3D 建模，直接生成模特效果图。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MB4AHhvIU)
[MidJourney-Styles-and-Keywords-Reference](https://github.com/willwulfken/MidJourney-Styles-and-Keywords-Reference) | 收录了很多实用的 Midjourney 提示词，包括图像风格样式关键词、分辨率、图像权重等，帮助你更好的完成 AI 绘画。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MyT4yjBL3)
[roomGPT](https://github.com/Nutlope/roomGPT) | 只需上传一张房间照片，即可用 AI 生成对应的梦幻房间效果图。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MwcUOvhgh)


### AIGC

名称 | 简述 | 源
---- | ----- | -----
[AnythingLLM](https://github.com/Mintplex-Labs/anything-llm) | 一个可打造成企业内部知识库的私人专属 GPT！可以将任何文档、资源或内容转换为大语言模型（LLM）知识库，使得在对话过程中可引用到里面的内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NwDwQrO9Y)
[chatgpt_system_prompt](https://github.com/LouisShark/chatgpt_system_prompt) | 有获取 GPTs 的 Prompt、Knowledge 以及如何防护的教程，另外单独对破解官方 GPTs 的 Prompt 进行分类。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NvSp3wtRm)
[GPTs](https://github.com/linexjlin/GPTs) | 收集了超级多被破解的 GPTs Prompt | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NvSp3wtRm)
[Awesome assistants](https://github.com/awesome-assistants/awesome-assistants) | 一份精心收集整理的优秀 AI 助手列表。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NvHARfYTA)
[Animate Anyone](https://github.com/HumanAIGC/AnimateAnyone) | 只需一张角色图片，即可生成与角色一致且动作可控的生动视频。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NvAwuuUz1)
[SillyTavern](https://github.com/SillyTavern/SillyTavern/) | 一个可以安装在电脑（和安卓手机）上的用户界面，让你可以与文本生成的人工智能互动，并与社区创建的角色聊天/玩角色扮演游戏。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Nty2uEtjH)
[Prompt flow](https://github.com/microsoft/promptflow) | 微软在 GitHub 开源的一套 AI 工具，可用于简化大模型应用的开发周期。打通了从项目构思、原型设计、测试、评估到生产部署和监控的全流程，让开发者可以快速构建出高质量的大语言模型应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Nj6Ut6pyi)
[supervision](https://github.com/roboflow/supervision) | 一个在 GitHub 开源的计算机视觉 AI 工具箱，安装简便，可供开发者重复使用，大幅提升效率。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ni2mLvoQ6)
[Code Interpreter API](https://github.com/shroominic/codeinterpreter-api​​​) | ChatGPT 代码解释器开源版，开发者可直接调用 API，在项目使用 AI 来快速处理数据分析、图像处理、股票图表展示等工作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NaH2UpX58)
[RealChar](https://github.com/Shaunwei/RealChar) | 帮助你快速创建、自定义各种 AI 角色。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NaobWifhP)
[MetaGPT](https://github.com/geekan/MetaGPT) | 一个基于 AI 构建的实验性项目。可通过用户需求，直接生成产品分析文档、用户故事、竞品分析、数据结构、项目 API 等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N8znsi6tv)
[GPT Migrate](https://github.com/0xpayne/gpt-migrate) | 一个基于 GPT-4 的大胆尝试，让 AI 重写整个项目代码，实现所有代码框架、编程语言的迁移。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N89Mo5O1R)
[AI Getting Started](https://github.com/) | 一个简单的 AI 入门项目，实现了 AIGC 中常用的图像/文本模型、向量存储、身份验证、项目部署等一整套流程，可作为开发 AI 应用时的项目参考。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N6VXUbzqH)
[Vercel AI SDK](https://github.com/) | Vercel 在 GitHub 开源的一个 AI SDK，可帮你快速构建 AI 应用，包括 AI 对话、聊天界面、流式文本输出等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N61N34NeN)
[Liftoff Interviews](https://github.com/Tameyer41/liftoff) | 让 AI 对你进行技术面试，并给出能力评估，帮助你改善不足之处，提高面试通过率。用户可根据自身能力来选择面试题难度，项目支持自部署。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N4Ykbek0d)
[Audiocraft](https://github.com/facebookresearch/audiocraft) | Meta 开源的一个 Python 库，可直接用 AI 生成音乐 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N4CSIibMS)
[LaWGPT](https://github.com/pengxiao-song/LaWGPT) | 个基于中文法律知识的大语言模型，你可以用它来打造一个 AI 专属法律顾问。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N1J1ioVGI)
[GPT Code UI](https://github.com/ricklamers/gpt-code-ui/) | 简化版的 GPT 代码解释器，可利用大语言模型能力，自动生成与执行代码。另外还支持文件上传、下载，上下文理解，可选 GPT-3.5 和 GPT-4 模型。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N1o8NyGcw)
[Quivr](https://github.com/StanGirard/quivr) | 用 AI 来打造你的第二大脑。作为一个开源的 AI 知识库解决方案，Quivr 支持将文本、图像、视频、代码片段、PPT、Excel 数据表等内容直接上传云端，并通过大语言模型，快速实现信息检索、问答。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N1nUy3Drf)
[Dify.AI](https://github.com/langgenius/dify) | 一个可用于快速创建 AI 应用的开源平台，帮助开发者创建可持续运营的原生 AI 应用。平台提供了多种类型应用的可视化编排，开箱即用，集成了诸多便于使用的 API。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N0Gk398PL)
[Shap-E](https://github.com/openai/shap-e) | OpenAI 开源的一个 3D 模型，可以根据文本或图像，直接生成 3D 对象。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MFDY5rR1t)
[Pandas AI](https://github.com/gventuri/pandas-ai) | 为流行的数据分析和操作工具 Pandas 添加了生成人工智能功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MF2fL4dsY)
[Chart-GPT](https://github.com/whoiskatrin/chart-gpt) | 一个基于 GPT 实现的开源工具，可在几秒内，将文本快速转换为漂亮的图表。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MDTlbwM34)
[Bloop](https://mp.weixin.qq.com/s?__biz=MzAxOTcxNTIwNQ%3D%3D&mid=2457982448&idx=1&sn=aa3c06c76aa67ba2bf77ca32d8967865&chksm=8cb7b01abbc0390c8b8afefc8d4e982430c27a85b1f26719550da1252e33c9d13bbaf6dbd518&token=1761457851&lang=zh_CN#rd) | 一个基于 GPT-4 构建的代码搜索引擎，该工具采用基于 GPT-4 的 AI 智能模型，成功实现用自然语言，语义化的代码搜索方式。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MDn59bLYx)
[Bark](https://mp.weixin.qq.com/s?__biz=MzAxOTcxNTIwNQ%3D%3D&mid=2457982256&idx=1&sn=0db7f60f1d5670a0d9fc1da554f300a4&chksm=8cb7b0dabbc039cca80bc1eed9abe23dbc80aba1ff4c49278488aeda896b7a07674422469fa2&token=1761457851&lang=zh_CN#rd) | Suno 开源的 AI 项目能够生成高度逼真的人类语音（支持多个语种）及音乐。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MDdnFumSh)
[LLaVA](https://github.com/haotian-liu/LLaVA) | 一个拥有类似 GPT-4 的大语言+视觉模型 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MD3zxft0Z)
[Cognosys](http://cognosys.ai/) | 可在线运行 Auto-GPT，，只需在线设定好机器人名称、目标、任务，即可自动运行。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MCgPBlRz3)
[OpenPromptStudio](https://github.com/Moonvy/OpenPromptStudio) | 一款 Prompt（提示词）编辑神器，可以把 AIGC 提示词可视化，并提供在线编辑功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MBsDYszbm)
[Grounded-Segment-Anything](https://github.com/IDEA-Research/Grounded-Segment-Anything) | 可实现自动检测、分割、生成图像与文本。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MBjsaDQBT)
[BingGPT](https://github.com/dice2o/BingGPT) | 一个 Bing 桌面客户端，支持 Windows、macOS、Linux 等主流操作系统，登录 Microsoft 账号即可使用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MAZWSdU8f)
[Spline AI](https://spline.design/ai) | 通过跟 AI 对话，基于文本快速实现 3D 建模。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MAQfI0Gh4)
[OpusAI](https://opus.ai/) | 可通过文本来快速生成 3D 世界，构建一个属于自己的虚拟宇宙。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MA3SRoifJ)
[myGPTReader](https://github.com/madawei2699/myGPTReader) | 一个基于 ChatGPT 搭建的 Slack 机器人，可以完成阅读网页、电子书、视频 (YouTube) 或文档等操作，并使用 ChatGPT 对这些内容进行总结。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MzfsJlgb9)
[Tune-A-Video](https://github.com/showlab/Tune-A-Video) | 可直接通过文本直接生成视频。只需要提供文本 prompt，再利用 Stable Diffusion 的能力，即可快速生成多种不同风格的视频。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MzdJQ3FjI)
[ChatGPT 学术优化](https://github.com/binary-husky/chatgpt_academic) | 中科院科研工作专用，特别优化了学术 Paper 润色体验，支持自定义快捷按钮，支持 markdown 表格显示，Tex 公式双显示，代码显示功能完善，新增本地 Python 工程剖析功能 / 自我剖析功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mz4qLExXR)
[AICommand](https://github.com/keijiro/AICommand) | 将 ChatGPT 功能集成到 Unity 编辑器中。通过对话的方式，可视化动态调整与生成内容，提升游戏开发效率。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MyNbf7iEn)
[The-HustleGPT-Challenge](https://github.com/jtmuller5/The-HustleGPT-Challenge) | 记录了一些可通过 GPT-4 实现的项目，其中有部分项目还实现盈利了。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MyCzGD7eL)
[ChatGPT Shortcut](https://github.com/rockbenben/ChatGPT-Shortcut) | 整理并汇总了多种让生产力加倍的 ChatGPT 快捷指令，按照领域和功能分区，可对提示词（Prompt）进行标签筛选、关键词搜索和一键复制。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MxmNBjBre)
[川虎 ChatGPT](https://github.com/GaiZhenbiao/ChuanhuChatGPT) | 一个开源的 ChatGPT Web UI 应用，为 ChatGPT API 提供了一个 Web 图形界面。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MwseCqYHc)
[ChatGPT Demo](https://github.com/Chanzhaoyu/chatgpt-web) | 一个开源的 ChatGPT 演示网页，基于 Express 和 Vue3 搭建，开发者可以用其搭建一个类似 ChatGPT 的网站。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MvrMlFDmF)
[Edge GPT](https://github.com/acheong08/EdgeGPT) | 微软 Bing Chat 的逆向工程 API，利用该接口，开发者可自行搭建 EdgeGPT 聊天机器人，自定义智能搜索功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MsZhfkrPZ)


### AI 工具

名称 | 简述 | 源
---- | ----- | -----
[clone-voice](https://github.com/jianchang512/clone-voice) | 一个带 Web 界面简单易用的声音克隆工具。可使用任何人类音色，将一段文字合成为使用该音色说话的声音，或者将一个声音使用该音色转换为另一个声音。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NyUSJm4Zu)
[Amphion](https://github.com/open-mmlab/Amphion) | 一个开源的音频、音乐和语音生成整合工具包。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NyBlizeys)
[Lobe Chat](https://github.com/lobehub/lobe-chat) | 一键部署私人 GPT/LLM 的聊天机器人。支持语音合成、多模态和可扩展的插件系统，可以联网、画图、爬虫等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Nxcuzzyku)
[GPT Crawler](https://github.com/BuilderIO/gpt-crawler) | 能够利用爬虫，自动抓取与整合指定 URL 地址中的各种信息，并生成一个`output.json`的数据文件。将其喂给 ChatGPT，便可快速定制你的专属 GPT，打造个人知识库或者智能助理。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NttIAuO1X)
[screenshot-to-code](https://github.com/abi/screenshot-to-code) | 给 AI 看一眼截屏，便能直接生成代码。该项目可借助 GPT-4 Vision 的能力，直接给你将屏幕截图转换为 HTML/Tailwind CSS，并利用 DALL-E 3 的图像生成能力，生成外观相似的图像。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ntsxx9wzI)
[Open Interpreter](https://github.com/KillianLucas/open-interpreter) | 可在命令行终端，直接调用与展示各种大模型能力。实现了视频和照片编辑、系统配置更改、自动生成并运行 Demo 源码，AI 一对一聊天问答等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NhJzrafM0)
[GPT Prompt Engineer](https://github.com/mshumer/gpt-prompt-engineer) | 该工具便会自动帮你生成各种 Prompt，自动对 Prompt 测试和评分，帮你尽可能找到最优项目提示。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N8EazkYv1)
[AIdea](https://github.com/mylxsw/aidea) | 一个在 GitHub 开源的 AI 应用，集成了主流大语言模型以及绘图模型。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Nha6mFPW3)
[go-proxy-bing](https://github.com/adams549659584/go-proxy-bingai) | 让你无需登录，即可直接使用 New Bing。拥有与 Bing 一致的 UI 体验，并支持 ChatGPT 提示词。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N3UK6u76u)
[Background Remover](https://github.com/nadermx/backgroundremover) | 一个开源的命令行工具，，可借助 AI 能力，快速移除图像和视频背景。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MFtZ5A6X1)
[open-chat-video-editor](https://github.com/SCUTlihaoyu/open-chat-video-editor) | 一款短视频生成和编辑工具，结合 ChatGPT，Stable Diffusion 和多模态搜索，实现短句转短视频、网页链接转短视频、长视频转短视频功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MFrCY6STG)
[Chat-with-GitHub-Repo](https://github.com/peterw/Chat-with-Github-Repo) | 一个让你可以跟 GitHub 仓库进行对话的 Python 工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/ME4o9jYBe)
[Chatbot Arena](https://chat.lmsys.org/) | 一个可以在线测试多种开源大语言模型的工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MD7t2pMJg)
[KeepChatGPT](https://githubdaily.gitee.io/posts/2023-04-21-keepchatgpt/) | 一个插件，让你的 ChatGPT 不再报错！ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MD3bAu4A1)
[MiniGPT-4](https://githubdaily.gitee.io/posts/2023-04-17-minigpt-4/) | 一个拥有类似 GPT-4 图像对话能力的项目。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MCrYlzRNl)
[Animated Drawings](https://githubdaily.gitee.io/posts/2023-04-16-animated-drawings/) | 一款很有趣的 AI 工具，可以借助人工智能技术，让绘画作品动起来。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MCiok4UZG)
[CodeWhisperer](https://aws.amazon.com/cn/codewhisperer/) | 一款 AI 编程助手，可集成到 VSCode 和 IntelliJ IDEA 等代码编辑器上使用，个人版对所有开发者免费开放。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MBVZY3W8f)
[ChatPaper](https://github.com/kaixindelele/ChatPaper) | 利用 ChatGPT 进行论文全文总结+专业翻译+润色+审稿+审稿回复 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MBkWJ47D4)
[VideoCrafter](https://github.com/VideoCrafter/VideoCrafter) | 一款开源的 AI 工具，可直接基于文本，快速生成与编辑视频。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MB3pDDgQk)
[Imagica](https://get.imagica.ai/) | 一分钟内，快速创建属于自己的 AI 应用。特点是："零代码、实时数据、多模态、响应快速"。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MAIcwt5uh)
[SpeechGPT](https://github.com/hahahumble/speechgpt) | 一个可以让你与 ChatGPT 进行语音聊天的网站。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MArHECDIs)
[AI Code Translator](https://github.com/mckaywrigley/ai-code-translator) | 用 GPT 做了一款 AI 工具，可实现数十种编程语言的互相切换，支持 GPT-3.5 和 GPT-4。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MAplwsiaS)
[ChatGPT Next Web](https://github.com/Yidadaa/ChatGPT-Next-Web) | 支持一键免费部署你的私人 ChatGPT 网页应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mzn339tqR)
[Play.ht](https://playground.play.ht) | 它可以从 20 秒的音频中快速生成克隆语音，并自动转换为英语。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mzjoh03kw)
[Cursor](https://github.com/getcursor/cursor) | 一个能利用 AI 辅助编程的代码编辑器 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mz3xcdoWB)
[GerevAI](https://github.com/) | 基于 ChatGPT 能力，可在几秒内找到任何聊天记录、文档或代码片段。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MyVqG7ZNG)
[ChatAll](https://github.com/sunner/ChatALL) | 一个可以让你同时与多个 AI 机器人实时聊天的开源工具。支持 ChatGPT、Bing Chat、bard、Alpaca、Vincuna、Claude、ChatGLM、MOSS、iFlytek Spark、ERNIE 等主流 AI 聊天机器人。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N10ktk3O4)
[AI-Products-All-In-One](https://github.com/TheExplainthis/AI-Products-All-In-One) | 整理了一些 ChatGPT 以及 AI 相关的生产力工具。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MyKP8c8dr)
[Shell GPT](https://github.com/TheR1D/shell_gpt) | 该工具直接在命令行中集成了 ChatGPT，通过它，可以帮助你快速编写 shell 命令、代码片段编写、Git 提交信息、文档、注释等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MyJE4mTDI)
[飞书 GPT](https://github.com/Leizhenpeng/feishu-chatgpt) | 集成了飞书 + GPT-3.5 + Dall·E + Whisper 等 API，支持语音对话、角色扮演、多话题讨论、图片创作、表格分析、文档导出 等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MyDKKgfTp)
[ChatPDF](https://github.com/mayooear/gpt4-pdf-chatbot-langchain) | 它可以提取 PDF 文件中的内容，并将内容交给 ChatGPT 进行分析。待解析完成之后，你便可以跟它进行一对一对话交流，就好像它是一个完全理解内容的人一样。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Myukg0Qdo)
[GitHub Copilot X](https://githubdaily.gitee.io/posts/2023-03-23-github-copilot-x/) | 一款基于 AI 驱动的、跨时代代码编辑器，将为开发者带来前所未有的编程体验。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MyyfNDa5k)
[OpenGpt](https://github.com/futantan/OpenGpt) | 一个可以让你快速尝试各种 ChatGPT 应用的开源项目，借助这个项目，你还能在几秒钟内创建属于自己的应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mxwe66eAv)


### 实用工具

名称 | 简述 | 源
---- | ----- | -----
[Stirling-PDF](https://github.com/Frooodle/Stirling-PDF) | 一款强大的本地网页版 PDF 文件处理工具，可 Docker 部署。提供了丰富的 PDF 文件操作功能，包括拆分、合并、格式转换、内容排列、添加图片、旋转、压缩等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Nz3Yy5Stj)
[TikTokDownloader](https://github.com/JoeanAmier/TikTokDownloader) | 一款完全免费开源的 抖音/TikTok 采集工具。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ny9wDsfl6)
[XHS-Downloader](https://github.com/JoeanAmier/XHS-Downloader) | 小红书的 图文/视频 作品采集工具。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ny9wDsfl6)
[Penpot](https://github.com/penpot/penpot) | 一款可平替 Figma 的开源免费工具，它是首个开源的 UI 设计与原型制作平台。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NxPQPc0Su)
[Marker](https://github.com/VikParuchuri/marker) | 一个能够快速且准确地将 PDF、EPUB 和 MOBI 文档转换成 Markdown 格式的工具。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NvG1r1n32)
[Outline](https://github.com/outline/outline) | 一款可平替 Notion 的开源软件，可用于部署搭建团队内部知识库。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Nvyamr8nE)
[Latest](https://github.com/mangerlahn/Latest) | 一款开源免费 Mac 小众工具，用于检查并更新电脑上已安装应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NvwAWfPux)
[雷池 WAF](https://github.com/chaitin/safeline) | 一款简单易用、广受好评的 Web 防火墙工具，可保护你的网站不受黑客攻击。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Nj8EPqUGc)
[Graphite](https://github.com/GraphiteEditor/Graphite) | 一个开源的 2D 矢量图形编辑器，适用于照片编辑、图像处理、图形设计、插图、数据可视化、数字绘画等领域。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NcBhtAAm3)
[OpenResume](https://github.com/xitanggg/open-resume ) | 一个功能强大的开源简历生成器，拥有简洁美观的 UI 设计，并支持导入与解析 PDF 简历文件，实时更新简历数据，帮你快速撰写出清晰直观的个人简历。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N7cduFVGC)
[QR Designer](https://github.com/kochrt/qr-designer) | 一个可用于二维码设计的项目，可以给二维码添加各种图案、文字、图像、更改背景颜色等操作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N3aW86E0t)
[Dev Home](https://github.com/microsoft/devhome) | 微软开源了一款全新的开发工具，可在 Windows 系统中，内置了可视化控制面板。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N24UUwDwF)
[EasySpider](https://github.com/NaiboWang/EasySpider) | 一款可视化爬虫软件。使用图形化界面，无代码设计和执行爬虫任务。开发者只需在网页上选择爬取内容，并根据提示框操作，即可完成爬虫设计和执行。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N1K0G2vP5)
[Spider Suite](https://github.com/3nock/SpiderSuite) | 一款开源的多功能 GUI 网络安全爬虫工具，专为网络安全专业人员设计。目前支持 Windows 和 Linux 操作系统。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MFKEnrGkU)
[RapidAPI for Mac](https://paw.cloud/) | 一款颜值颇高的 HTTP 调试工具，可以用它来编写 API 接口请求、完善 API 描述文档、测试服务器响应、生成客户端代码等工作，并支持多个团队成员实时协作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MCUmtqa1t)
[DataEase](https://github.com/dataease/dataease) | 一款开源的数据可视化分析神器，操作简单易上手，开箱即用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MCPoKEzsE)
[Upscayl](https://github.com/upscayl/upscayl) | 一款 AI 图像无损放大神器，可以快速将模糊图片秒变高清图。我用了挺长一段时间了，效果很不错。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MCvL3mXDE)
[Hidden Bar](https://github.com/dwarvesf/hidden) | 一键折叠 Mac 菜单栏中的图标，长按 Command 对图标进行拖拽，自由调整图标的隐藏状态，非常方便。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MCjTmDixW)
[NotionNext](https://github.com/tangly1024/NotionNext) | 一个开源的静态博客系统，基于 NextJS + Notion API 实现，支持多种部署方案，无需服务器、零门槛搭建网站，为 Notion 和所有创作者设计。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MBCw0lWeu)
[PAG 动效组件](https://github.com/Tencent/libpag) | 腾讯开源的一款设计神器，提供了一套完善的动效设计工作流，可广泛应用于UI 动画、贴纸动画、视频编辑、模板设计等场景。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MBwSbxIfP)
[SQL Translator](https://github.com/whoiskatrin/sql-translator) | 一个可以将人类自然语言转换为 SQL 语言的开源工具，反之亦然，用起来很方便。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MxgUhgdNJ)
[FUXA](https://github.com/frangoteam/FUXA) | 一款开源的流程可视化 Web 应用，可为机器的实时数据，构建多种不同设计风格的可视化流程图。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MwiO8xyhd)
[Memos](https://github.com/usememos/memos) | 一个轻量级开源笔记应用，支持自托管、轻量级、开箱即用、知识管理、社交讨论等特性。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mv8Vl4yuA)
[QGIS](https://github.com/qgis/QGIS) | 一个功能丰富、用户友好、免费开源的跨平台地理信息系统，支持在 macOS、Windows、Linux 等平台运行 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MsI5nx8Cj)
[LocalSend](https://github.com/localsend/localsend) | 一款开源的 AirDrop 替代品，可在附近设备间快速共享文件，跨终端，无需联网。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MqSXqalfr)


### 插件

名称 | 简述 | 源
---- | ----- | -----
[Better Notes](https://github.com/windingwind/zotero-better-notes) | 一个比较实用的笔记插件，需搭配文献管理工具 Zotero 使用。集成了论文阅读、段落注释、做笔记、元数据分析、知识输出、AI 写作等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N6XqG6Z8F)
[CodeCursor](https://github.com/Helixform/CodeCursor) | 你可以利用这个插件将 Cursor 快速集成到 VSCode 上。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MzgfrmwMm)
[CopilotForXcode](https://github.com/intitni/CopilotForXcode) | 该插件可为 Xcode 提供 GitHub Copilot 和 ChatGPT 支持，帮助你更快开发出 iOS/macOS/iPadOS 软件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MzehG7Grn)
[vscode-chatgpt](https://github.com/gencay/vscode-chatgpt) | 一个开源的 VSCode 插件，可将 OpenAI ChatGPT 集成到 VSCode | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MyrY7E70X)
[ChatGPT Box](https://github.com/josStorer/chatGPTBox) | 一个可以将 ChatGPT 深度集成到浏览器中的开源插件。，除了对主流网站进行适配，还内置了诸如翻译、总结、润色、情感分析、段落划分、代码解释、问询等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MybtgAlNl)
[OpenAI Translator](https://github.com/yetone/openai-translator) | 一个基于 ChatGPT API 的划词翻译 Chrome 插件 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mwmljj29i)


### 资料集合

名称 | 简述 | 源
---- | ----- | -----
[awesome-cto](https://github.com/kuchin/awesome-cto) | 一份专为首席技术官（CTO ）设计的资源清单，含有 CTO 角色介绍、招聘技巧、团队管理、职业发展、项目管理实践、开发流程、初创公司指南、产品开发、市场营销等等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NzmZDfDhj)
[SVGL](https://github.com/pheralb/svgl) | 一份 SVG Logo 资源合集，精心收集了所有目前主流行公司以及技术框架工具的 Logo。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NxlV4rGil)
[AI Collection](https://github.com/ai-collection/ai-collection) | 收集了诸多实用的 AI 工具，覆盖编程、金融、创作、教育、市场营销等领域。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/ME78CtvfS)
[zihao_course](https://github.com/) | 一份开源的 AI 技术资料。覆盖计算机视觉、图机器学习、人工智能可解释性、图像分类等领域。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MoBYmeZhU)
[方糖全栈路线图](https://github.com/easychen/stack-roadmap) | 这是一份开源技术路线图，尝试让读者在短时间内补全包括商业模式、设计、开发、运营、增长在内的「最小可行技能栈」，帮助读者完成「从螺丝钉到一人企业」的蜕变。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MmCZwtbaN)


### 书籍/教程

名称 | 简述 | 源
---- | ----- | -----
[GitHubCopilotAI](https://github.com/microsoft/Mastering-GitHub-Copilot-for-Paired-Programming) | 微软出了一期学习 GitHub Copilot 教程。一共有 6 节课程，共 10 个小时。旨在教授如何有效使用 GitHub Copilot 并用于辅助编程。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/NxFSGaC1l)
[ChatGPT 提示工程](https://www.bilibili.com/video/BV1s24y1F7eq/) | 该教程由吴恩达老师与 OpenAI 开发者 Iza Fulford 联手教授。教程总共分为 9 个章节，时长一个多小时，里面主要涵盖：提示词最佳实践、评论情感分类、文本总结、邮件撰写、文本翻译、快速搭建一个聊天机器人等等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MEhkq7gXG)
[JavaScript 新手教程](https://github.com/sumn2u/learn-javascript) | 本书主要介绍 JavaScript 基础知识、如何在 Web 浏览器上用 JavaScript 进行编程，以及 JavaScript 相关的各种重要话题、案例、练习。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MBF7CadeE)
[Midjourney 学习导航](https://learningprompt.wiki/docs/midjourney-learning-path) |  Midjourney 中文教程，能让不同水平的朋友快速了解和学会 Midjourney | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MB13vj0QJ)


### 其他

名称 | 简述 | 源
---- | ----- | -----
[Windows 12 网页版](https://github.com/tjy-gitnub/win12) | 开源的 Windows 12 网页体验版，提供了精美的 UI 设计、丰富流畅的动画、各种功能小组件、动态壁纸、文件系统等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ni4FlyrEl)
[Mojo](https://www.modular.com/mojo) | 一种适用于所有 AI 开发人员的新编程语言，由 LLVM、Swift、Clang 作者 Chris Lattner 发布，被誉为 AI 新时代的编程语言变革者，比 Python 高效 35000 倍。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MF7AUv9AT)
[Spinning Diagrams with CSS](https://x.st/spinning-diagrams-with-css/?continueFlag=a35c5f7ece912457d1540746cbcfe91f) | 不借助 JavaScript，纯使用 CSS 来生成 LateX 数学公式动画，给数学增添点趣味。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MD92sA0XW)
[the-algorithm](https://github.com/twitter/the-algorithm) | Twitter 的推荐算法在 GitHub开源。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)]()
[happyhues.co](https://www.happyhues.co/palettes/11) | 这里提供了诸多 UI 配色方案，各种颜色直接点击就能获取，很方便，可在这里获取到做网站或设计时的主题配色灵感 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MzTcxwjmo)
[Vuestic UI](https://github.com/epicmaxco/vuestic-ui) | 一个开源的 Vue.js 3.0 UI 库，拥有超过 60 个可定制组件，具备简单易用、定制灵活度高等特点。支持国际化、暗黑模式、无缝集成等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MuQ4mgOi2)
[PyGWalker](https://github.com/Kanaries/pygwalker) | 一个最近在 GitHub 上较为流行的 Python 库，可用于简化 Jupyter Notebook 数据分析和数据可视化工作流程。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MuGDQyIL8)
[One Mono](https://github.com/intel/intel-one-mono) | 英特尔在 GitHub 开源的字体，一种富有表现力的等宽字体系列，在构建时考虑到了清晰度、易读性和开发人员的扩展需求。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/N4WI7kJxS)

## 声明
[![](https://licensebuttons.net/l/by-nc-nd/4.0/88x31.png)](https://creativecommons.org/licenses/by-nc-nd/4.0/deed.zh)  
本作品采用[知识共享署名-非商业性使用-禁止演绎 4.0 通用许可协议](https://creativecommons.org/licenses/by-nc-nd/4.0/deed.zh)进行许可。
