<p align="center">
  <img src="https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/githubdaily_brand.png">
</p>

<p align="center">
  <a href="https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/weixin.png"><img src="https://img.shields.io/badge/ GitHubDaily-公众号-brightgreen.svg" alt="WeChat"></a>
  <a href="https://weibo.com/GitHubDaily"><img src="https://img.shields.io/badge/%E6%96%B0%E6%B5%AA-%E5%BE%AE%E5%8D%9A-red" alt="Weibo"></a>
  <a href="https://www.zhihu.com/people/githubdaily"><img src="https://img.shields.io/badge/%E7%9F%A5%E4%B9%8E-blue" alt="Zhihu"></a>
  <a href="https://github.com/GitHubDaily/GitHubDaily/stargazers"><img src="https://img.shields.io/github/stars/GitHubDaily/GitHubDaily" alt="GitHub stars"></a>
</p>

## 宗旨

多年以前，我曾看到 GitHub 开源项目作者、全栈工程师 TJ Holowaychunk 说过这么一句话：

"I don't read books, never went to school, I just read other people's code and always wonder how things work"。

从那时起，我便认为，通过阅读源码，站在前辈的角度上，去思考代码架构与程序逻辑，乃是提升编程技巧最好的方式。

因此，GitHub 也自然而然的，成为我最喜爱的开发者平台。

秉着挖掘开源价值的初衷，GitHubDaily 自 2015 年 10 月 10 日正式成立。

我们希望能通过这一举措，帮助开发者们发现当下最火的开源项目，掌控最新技术动态, 扩大技术视野, 并从开源项目的学习中获得编程能力的提升。

目前，GitHubDaily 已累积分享超过 3000 个开源项目，内容包括但不限于 GitHub 上的开源技术资料、开发者工具、编程网站以及成熟应用。

除了 GitHub 之外，我们也开始在下面多个社交媒体平台，帮助开发者传播与分享优质开源项目，挖掘其未来的技术应用前景。

如果你想接收最新的 GitHub 开源项目资讯，可以关注一下👇

- 公众号: [GitHubDaily](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/weixin.png)
- 微博: [@GitHubDaily](https://weibo.com/GitHubDaily)
- 知乎: [@GitHubDaily](https://www.zhihu.com/people/githubdaily)

> 有不错的开源项目，也欢迎到本仓库的 [issues](https://github.com/GitHubDaily/GitHubDaily/issues/new) 推荐或自荐项目，我们期待你的分享。

---

## 2022 年复盘

下面是对 GitHubDaily 在 2022 年所推荐的项目进行分类整理，方便大家查找以往分享过的内容。

> 过往复盘 [2021](https://github.com/GitHubDaily/GitHubDaily/blob/master/2021.md)，[2020](https://github.com/GitHubDaily/GitHubDaily/blob/master/2020.md)，[2019](https://github.com/GitHubDaily/GitHubDaily/blob/master/2019.md)，[2018](https://github.com/GitHubDaily/GitHubDaily/blob/master/2018.md)

### 目录

- [宗旨](#宗旨)
- [2022 年复盘](#2022-年复盘)
  - [目录](#目录)
  - [Java](#java)
  - [Python](#python)
  - [前端](#前端)
  - [工具](#工具)
  - [插件](#插件)
  - [资料集合](#资料集合)
  - [书籍/教程](#书籍教程)
  - [机器学习/人工智能](#机器学习人工智能)
  - [开源字体](#开源字体)
  - [其他](#其他)
- [声明](#声明)

### Java

名称 | 简述 | 源
---- | ----- | -----
[mall4cloud](https://github.com/gz-yami/mall4cloud) | 一个基于 Spring Cloud 构建的开源电商系统。采用主流微服务技术实现，支持集群部署、服务注册和发现以及拥有完整的订单流程等，是一个适合二次开发的电商平台系统。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LC5Jk3w36)
[RuoYi](https://github.com/yangzongzhuan/RuoYi) | GitHub 上一款开源的权限管理系统：RuoYi，基于 SpringBoot 搭建，代码易读易懂、界面简洁美观。项目可用于所有的 Web 应用程序，如网站管理后台，网站会员中心，CMS，CRM，OA，支持移动客户端访问。核心技术采用 Spring、MyBatis、Shiro，没有任何其它重度依赖，直接运行即可使用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LwBap7sg9)
[Bolo Solo](https://github.com/adlered/bolo-solo) | GitHub 上一个开源的个人博客系统：Bolo Solo，简单易部署，自带精致主题、数据统计表、邮件提醒、自定义图床、功能丰富的 Markdown 编辑器，专为程序员设计。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LqqbdewnY)
[NBlog](https://github.com/Naccl/NBlog) | 一个前后端分离的开源博客系统，基于 Spring Boot + Vue 技术栈开发，界面清新简洁，拥有多个丰富的博客组件，自带管理后台。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LgMIKs1ng)
[algorithms](https://github.com/xingxingzaixian/django-drf-online-exam) | 一个开源的在线考试系统，按照不同功能，可划分为题目管理、答题系统、权限分配、评卷系统等模块。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LgGPqCVrZ)
[JavaSecInterview](https://github.com/4ra1n/JavaSecInterview) | 由国内开发者更新与维护的 Java 面试题库，主要围绕 Java 安全研究与安全开发领域，覆盖了Shiro 和 Spring 框架、Fastjson 和 Log4j2 组件等安全知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LfUI46bDG)

### Python

名称 | 简述 | 源
---- | ----- | -----
[Pynecone](https://github.com/pynecone-io/pynecone) | GitHub 上的开源 Python 全栈开发框架：Pynecone，可让你在短短几分钟内，快速搭建一个 Web 应用。无需任何 Web 开发基础，即可上手使用。非常适合用来构建 AI 模型的 Demo 示例，简单又方便。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mjr16mOmN)
[python-tutorial](https://github.com/shibing624/python-tutorial) | GitHub 上一个开源 Python 实用教程。包括了 Python 基础，Python 高级特性，面向对象编程，多线程，数据库，数据科学，Flask，爬虫开发教程。教程中包含的范例，涵盖了大多数 Python 日常脚本任务，可作为入门学习资料，亦可作为工作中编写脚本的参考实现。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MaegHpKyi)
[PrettyMaps](https://github.com/marceloprates/prettymaps) | 一个在 GitHub 开源的小型 Python 库，可基于 OpenStreetMap 数据，帮助开发者快速绘制简洁美观的地图。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M0eOpztkq)
[pyWhat](https://github.com/bee-san/pyWhat) | 推荐一款比较实用的 Python 脚本工具：pyWhat，能够快速提取信息中的 IP 地址、邮箱、信用卡、数字货币钱包地址、YouTube 视频等内容。不仅如此，pyWhat 还可对文件和目录进行扫描，通过递归搜索，快速获取核心信息，并对结果进行筛选、过滤、排序、导出等操作 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M06z02xGH)
[MLScraper](https://github.com/lorey/mlscraper) | 一个开源的 Python 爬虫脚本，可基于机器学习自动从 HTML 页面中抓取数据。在给爬虫提供输出结果的示例后，它便会自动提取规则，对页面数据进行抓取，整个过程无需指定 CSS 选择器。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LE4hMxRgU)
[《动手开发一个 Python 小项目》](https://inventwithpython.com/bigbookpython/) | 书中收录了 80 多个 Python 项目，每个项目都是一个独立章节，其中包括项目实例、源码、进一步开发建议等内容。书中每个项目代码量最多只有 200 多行，对新手友好，适合快速上手学习。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LBdwuw5KU)
[Kindle_download_helper](https://github.com/yihong0618/Kindle_download_helper) | 一年后，Kindle 将退出中国市场，此前购买的书籍，在 2024 年 6 月 30 日后，将无法进行下载。一个在 GitHub 上开源的 Python 脚本，可用于批量下载往期已购买的 Kindle 电子书，并将其保存到本地。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LwLLWnfmd)
[NannyML](https://github.com/NannyML/nannyml) | 一个适合数据科学开发者使用的 Python 库：NannyML，该项目搭配了拥有简单、易用的可视化界面，让你可以提前预估部署后的模型性能，检测数据漂移。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ltqn287bb)
[PyScript](https://github.com/pyscript/pyscript) | 简单添加几行代码，便能在 HTML 中内嵌 Python 代码，并在浏览器上运行。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LrWscwV7h)
[GDB dashboard](https://github.com/cyrus-and/gdb-dashboard) | GitHub 上开源的 Python 调试工具：GDB dashboard，为 Python GDB 提供了可视化界面，更清晰的显示了程序调试信息，使开发者能专注于 Python 控制流。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LqGG6kbV9)
[NIVOS](https://github.com/TheSadError/NIVOS) | 一个开源的 Python 工具包，可用于深入扫描、破解 WIFI，适用于所有 Linux 系统，部分功能仍在持续升级中。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LqeoBnWyo)
[Greppo](https://github.com/greppo-io/greppo) | GitHub 上的开源 Python 框架，可快速搭建一款可交互式的「地理空间」应用。该框架提供了一整套完整工具包，让你可以轻松打通数据、算法、可视化 UI 等模块，构建一款交互式应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Liw9zejPT)
[algorithms](https://github.com/xingxingzaixian/django-vue3.2-online-exam) | 一个开源的在线考试系统，按照不同功能，可划分为题目管理、答题系统、权限分配、评卷系统等模块。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LgGPqCVrZ)
[Kedro](https://github.com/kedro-org/kedro) | 一个开源 Python 框架，可帮助你创建可复用、可维护、模块化的数据科学代码，支持与 VSCode 和 PyCharm 搭配使用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LgmNn1rJ5)

### 前端

名称 | 简述 | 源
---- | ----- | -----
[「PoseMon 让爷康康」](https://github.com/linyiLYi/pose-monitor) | 国内开发者在 GitHub 开源的一款 Android 应用：「PoseMon 让爷康康」，可借助 AI 技术，实时监测不良坐姿，并及时给出语音提示。应用不需要联网使用，所有 AI 特性均在手机本地运行，不需要将视频画面传输至外部服务器，仅需要摄像头权限用于获取姿态画面。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MecX2f7DZ)
[Magical Spider](https://github.com/lixi5338619/magical_spider​​​) | 神奇的蜘蛛，一个几乎适用于所有 Web 端站点的采集方案 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M1jYX9t87)
[云开发情侣互动小程序](https://github.com/UxxHans/Rainbow-Cats-Personal-WeChat-MiniProgram) | GitHub 上这个情侣互动小程序可以玩一下，给生活增添点趣味。项目基于云开发能力构建，可作为情侣自己的任务和商城系统，主要特性包括做任务，攒积分，换商品等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LFiSO1hRm)
[vuejs-challenges](https://github.com/webfansplz/vuejs-challenges) | 一个 Vue.js 在线挑战平台，里面提供了多道 Vue.js 练习题，帮你一步步掌握 Vue.js 的使用。该项目意在帮助你更好地了解 Vue.js，编写出实用程序，或单纯享受挑战乐趣。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LC2YQimtz)
[Vue Flow](https://github.com/bcakmakoglu/vue-flow) | GitHub 上一个开源的 Web 流程图组件：Vue Flow，支持灵活定制、可应用于 Vue 3，具有丝滑的缩放与拖拽交互，自带 Minimap 和各类实用的图形组件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LyCh8l1Pt)
[WebGAL](https://github.com/MakinoharaShoko/WebGAL) | 这是一款界面美观、易于开发的网页端视觉小说引擎。通过该引擎，你可以快速制作属于自己的小游戏。项目配有使用教程，令你无需网页开发基础，3 分钟即可学会所有的语法。只要你有灵感，便可以立刻开始创作自己的 Galgame。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LwJ1teQwW)
[Chirpy Jekyll Theme](https://github.com/cotes2020/jekyll-theme-chirpy) | 一个轻量级、响应式的个人静态博客主题：Chirpy Jekyll Theme，自带暗黑模式、可自动生成相关帖子，支持语法高亮、数学公式、流程图等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LvylZlO9j)
[PaoPao](https://github.com/rocboss/paopao-ce) | 一个风格类似 Twitter 的开源社区，基于 Gin、Zinc、Vue 等技术栈搭建。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LvrtLyUq7)
[CSS Buttons](https://github.com/eludadev/css-buttons) | 这个 GitHub 项目基于 CSS，实现了 100 种不同的 Web 按钮样式，包括动画效果、外观、转场过渡效果等，脑洞颇大。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LtGtxq7JV)
[Geeker Admin](https://github.com/HalseySpicy/Geeker-Admin) | 推荐 GitHub 上一套开源的后台管理框架：Geeker Admin，项目基于 Vue3.2、TypeScript、Vite2、Pinia、Element-Plus 等技术栈开发而成。拥有数据大屏、统计信息可视化、表格操作 Hooks 封装、组件 UI 动态切换、i18n 国际化多语言、常见 Web 指令定制等诸多功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LtjiEccit)
[Horizon UI](https://github.com/horizon-ui/horizon-ui-chakra) | GitHub 上一个开源的管理后台模板：Horizon UI，内置数百个组件与模块，可帮你快速开发出精美、简洁的网站。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lqddyamna)
[Luckysheet](https://github.com/mengshukeji/Luckysheet) | 一款纯前端实现的，类似 Excel 的在线表格，功能强大、配置简单、完全开源。支持大部分 Excel 功能，如冻结行列、合并单元格、筛选、排序。并内置了透视表、图表、计算函数等数据分析常用功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LoYe9w229)
[Fantastic-admin](https://github.com/hooray/fantastic-admin) | 一款开箱即用的 Vue 中后台管理系统框架，拥有多种布局与主题，动效丰富，可灵活定制，并支持多语言、多级路由缓存、自动生成导航栏等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LnZlhmZjL)
[Instagram MERN](https://github.com/jigar-sable/instagram-mern) | 应该是我见过最全功能复现的 Instagram 克隆版了，基本上覆盖了诸多 ins 常用的前后端功能。支持登录注册、个人信息的增删改查、帖子与私信互动，Emoji 支持等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LkVCh6wku)
[dooringx](https://github.com/H5-Dooring/dooringx) | GitHub 上开源的可视化平台搭建方案：dooringx，通过提供一套数据流事件机制、弹窗等解决方案，让你可以快速定制一个可视化拖拽平台。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LgW9f0ltw)
[Vue vben admin](https://github.com/vbenjs/vue-vben-admin) | GitHub 上一个开源的管理后台模板：Vue vben admin，基于 Vue 构建，开箱即用，拥有多款可配置主题，内置 Mock 数据方案、动态路由权限生成方案。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LeYLR12Zj)
[Medusa](https://github.com/medusajs/medusa) | GitHub 上一个开源的电商建站平台，可基于各种 UI 组件与 API，用模块拼装的方式，快速搭建个人电商平台。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LePllw9iF)
[Olympic](https://github.com/dragonir/3d/tree/master/src/containers/Olympic) | 国内开发者用代码实现的「冰墩墩」，基于 Three.js + React 技术栈构建，代码已在 GitHub 开源。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LeOahodSj)
[Graphics](https://github.com/entronad/graphic) |  GitHub 上一个开源的可视化 Flutter 图表库，提供了一种基于图形语法的声明式定义，可组合出多种图表类型，并拥有丰富的属性配置和交互组件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LbACshpig)
[S2](https://github.com/antvis/S2) | 一款基于数据驱动的多维分析表格，通过提供底层能力库，基础组件，业务场景组件以及自由扩展的能力。具备高性能、高扩展、可交互、开箱即用等特点。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LaJZ0yxiX)
[Mall Cook](https://github.com/wangyuan389/mall-cook) | 一款开源的可视化商城搭建平台，包括多页面可视化构建、JSON Schema 生成器（可视化搭建物料控制面板），实现组件流水线式标准接入平台等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/La8h0y4z3)


### 工具

名称 | 简述 | 源
---- | ----- | -----
[ILLA Builder](https://github.com/illacloud/illa-builder) | GitHub 上最近比较火的一款低代码开发工具：ILLA Builder。可让你在短短几分钟内，快速搭建一个企业内部应用。项目内置了一整套 UI 组件库，通过拖拽组件，即可完成应用搭建。此外，工具还接入了多种数据库和 API，让数据调用更加简单方便。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MkvLkwZ3j)
[Photoshot](https://github.com/shinework/photoshot) | 一款开源的 AI 头像生成器，用户将自己的个人头像上传后，可借助 Stable Diffusion 模型进行训练，并生成一款拥有不同风格的个人头像。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mjgk2lKIG)
[ChatGPT 微信](https://github.com/fuergaosi233/wechat-chatgpt) | 可将 ChatGPT 集成到微信的开源项目，通过发送对话，即可接受到来自 ChatGPT 的结果反馈，玩起来又更方便了，另外一款是 [ChatGPT-wechat-bot](https://github.com/AutumnWhj/ChatGPT-wechat-bot) | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)]()
[Misskey](https://github.com/misskey-dev/misskey) | 一个开源的去中心化微博社交平台：Misskey，完美适配了 PC 与移动端界面。支持丰富且可定制化的 Web UI、Emoji 表情、在线笔记、云存储、多主题、统计图表、实用组件等多种功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mic1I1tiU)
[StockAI](https://www.stockai.com/) | 一款颇有意思的图片搜索引擎：StockAI。输入关键词即可搜索图片，如果图片不存在，则会通过 AI 自动生成近似图片。个人非商业可免费下载小图。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mi4aDBbtZ)
[Lama Cleaner](https://github.com/Sanster/lama-cleaner) | GitHub 上一款开源的图像修复工具：Lama Cleaner，基于 SOTA AI 模型构建，功能颇为齐全。可用于快速去除图像中各种物品、人物、字体、水印等对象，并支持老照片修复、文本替换图像内容等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MftUc9pdK)
[AutoCut](https://github.com/mli/autocut) | GitHub 上一款开源的视频剪辑工具：AutoCut，可通过字幕快速剪切视频。工具支持自动生成字幕，用户无需使用视频编辑软件，仅需编辑文本文件，即可完成剪切。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MfktHxK73)
[GoToSocial](https://github.com/superseriousbusiness/gotosocial) | 一款开源的轻量级社交平台，类似 Twitter 与 Tumblr。支持关注他人、发布推文、点赞分享内容、一键拉黑等操作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MefjaiTnv)
[Stash](https://github.com/stashapp/stash) | 一款开源的视频与图像管理 Web 应用，基于 Go 编写，支持自部署，可将视频和图像按标签进行分类，以及信息提取与统计等功能。项目支持通过 Windows、macOS、Linux、Docker 等方式进行安装部署，并拥有多种 CSS 样式可供定制。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mee86n3KX)
[Memphis](https://github.com/memphisdev/memphis-broker) | GitHub 上一款开源的实时数据处理平台：Memphis，与 Apache Kafka 相比，构建数据流应用程序的速度快 9 倍。该项目提供了功能丰富的命令行与可视化界面，帮助实现快速开发，极大降低成本。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MebnCFcES)
[VHS](https://github.com/charmbracelet/vhs) | 一款开源的命令行 GIF 生成工具，可自动生成命令行的 GIF 动画，并应用到教程、文档、工具演示、测试等场景上。该工具支持自定义配置动画字体、间距、行高、延迟、打字速度、主题、删除与指针移动效果等各种属性，功能非常齐全。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Md0I8aM1M)
[Pake](https://github.com/tw93/Pake) | 一个可将各种网页快速打包成 Mac App 的开源工具。相比 Electron 更加小巧易用，速度更快，同时实现了通用的快捷键透传、沉浸式窗口、拖动、打包样式兼容等特性。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MaZpcf4sH)
[RedEye](https://github.com/cisagov/RedEye) | GitHub 上一款开源的安全可视化分析工具：RedEye，可用于协助红队可视化报告指挥和控制行动。该工具允许操作员评估和展示复杂数据，调整策略，并根据红队评估做出有效决策。支持日志解析，格式化输出数据，对行动进行标注等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MaV5in0Jr)
[Fyrox](https://github.com/FyroxEngine/Fyrox) | 一个基于 Rust 开发的 2D & 3D 游戏引擎。自带功能齐全的可视化操作界面、高度可扩展的渲染器、拥有创建复杂动画的内置系统、高品质双耳音响系统，支持 Windows、Linux、macOS 等主流操作系统。另外，该项目还配套了工具使用教程，帮助你更快的上手游戏开发。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MaicgjMt5)
[Markwhen](https://github.com/kochrt/markwhen) | 一款可快速创建时间线的开源工具：Markwhen。通过类似 Markdown 语法，即可快速生成直观、可视化的时间线内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MafQ8dNRK)
[Umi-OCR](https://github.com/hiroi-sora/Umi-OCR) | 一款功能颇全的开源 OCR 软件，可离线使用，适用于 Win10 x64 平台。该软件支持截屏识别、粘贴图片，支持批量导入本地图片，将 OCR 结果输出到软件面板或本地文件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ma6pD0MW6)
[Sharing](https://github.com/parvardegr/sharing) | 一款开源的命令行工具。无需安装任何移动端 App，即可实现 PC 到移动端的文件共享功能，支持 iOS 和 Android。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M9vSIpEPy)
[Code App](https://github.com/thebaselab/codeapp) | 一款开源的 iPad 代码编辑器：Code App。内置 Node.js、Python、C、C++、PHP 等多种开发环境，自带 Git、Pip、NPM 等工具，可连接并管理远程服务器。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M9t8ekIcm)
[Notes](https://github.com/nuttyartist/notes) | 一款开源的跨平台笔记应用，支持文件夹嵌套与标签管理、可自定义界面主题，采用QT、C++ 原生开发，响应速度快。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M7GyyFDWT)
[Gooey](https://github.com/chriskiehl/Gooey) | 一款可直接将 Python 命令行工具转为 GUI 应用的开源程序，帮助你优化用户体验。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M6vGU7Izk)
[CubyText](https://github.com/vincentdchan/CubyText) | 一个开源的知识管理软件：Cuby Text，通过区块来管理内容，让信息更有条理。软件界面清新、简洁、数据存储在本地，可更快搜索查找，并支持 Windows、Linux、macOS 等主流操作系统。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M6s9Ibq2z)
[Motionity](https://github.com/alyssaxuu/motionity) | 一个开源的动画编辑工具，可在浏览器直接打开使用。支持视频剪切、图像搜索过滤、文本动画库、图层蒙版等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M4KSR1axX)
[Notesnook](https://github.com/streetwriters/notesnook) | 一个开源的端到端加密笔记软件，可用于替代 Evernote，该项目提供笔记共享、历史回溯、个性化主题定制、富文本编辑，并支持导出成 PDF 与 Markdown 等格式的笔记文件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M4BskoKun)
[SurrealDB](https://github.com/surrealdb/surrealdb) | GitHub 上一个开源的云原生数据库：SurrealDB，通过简化数据库和 API 堆栈，以减少项目开发时间，提高生产力。除了处理日常数据事务，该数据库还能当做 API 后端层使用。支持 SQL 查询、GraphQL、ACID 事务、WebSocket 连接、结构化和非结构化数据、图形查询、全文索引等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M2xoVB8yQ)
[WSysMon](https://github.com/SlyFabi/WSysMon) | 一个开源的 Windows 任务管理工具克隆版，可用于 Linux 系统。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M2wdR50H3)
[TerrainDecorator](https://github.com/emrecancubukcu/Terrain-Decorator ) | 一款轻量级 Unity 3D 地形绘制工具：TerrainDecorator，包含了各种坡度、高度、噪声、图像遮罩和混合模式等过滤器，可帮助开发者快速创建地形纹理。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M2v2Nwh3a)
[One Last Image](https://github.com/itorr/one-last-image) | 一个能将「赛璐璐风格」动画截图或插画，转换成 One Last Kiss 封面风格的在线生成器。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M18cku47e)
[pdf-diff](https://github.com/serhack/pdf-diff) | GitHub 上一款开源的 PDF 文件对比工具：pdf-diff。可用于追踪、对比不同 PDF 版本间的差异。像 Git 一样，让你更好的了解 PDF 内容变更情况。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M0prZBkBt)
[Label Studio](https://github.com/heartexlabs/label-studio) | GitHub 上一款开源的数据标注神器：Label Studio，可用于标注音视频、文本、图像、时间序列等数据类型，并导出为多种模型格式。此外，该工具还支持多账号登录、流线型工作模式、可配置标签格式、集成机器学习模型、嵌入数据管道等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M0fZuF2AD)
[AFFiNE](https://github.com/toeverything/AFFiNE) | GitHub 上又一个开源的 Notion 替代品：AFFiNE，一款功能颇为强大的知识库管理工具。界面样式清新简洁、支持所见即所得的编辑和排版，拥有基于 Markdown 的多任务管理、多人实时协作。私密性强，可在本地自部署，目前项目仍在持续更新迭代。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M04e0h98c)
[Wireflow](https://github.com/vanila-io/wireflow) | 一款开源的在线流程图绘制工具，支持使用 100 多种自定义图形、可进行多人协作、权限分配、实时聊天等功能、并拥有丰富的功能组件库。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LE36JxtQd)
[Pixel Art to CSS](https://github.com/jvalen/pixel-art-react) | 一个开源的像素风图像编辑工具，基于 React 开发，通过结合 CSS 的 box-shadow 和 keyframes 特性，实现了在线绘制像素风图像的需求。在绘制完成后，你还能将其导出成 GIF、静态图像或纯代码，并粘贴到自己的网站上。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LDj9ja8ou)
[DBER](https://github.com/findyourmagic/dber) | GitHub 上一个开源的数据库设计工具：DBER，基于实体连接图，支持可视化数据库结构设计、拖拽生成模型引用关系、一键导出 SQL 语句等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LDgoP6gGD)
[Lensm](https://github.com/loov/lensm) | 一款基于 Go 语言开发的汇编及源代码浏览工具，可用于项目性能优化、调试等场景。作者还特地写了一篇文章，阐述了整个项目的开发历程。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LDaTSg1k6)
[Termtyper](https://github.com/kraanzu/termtyper) | 为了提升自己的打字速度，国外一位开发者在 GitHub 开源了一款命令行终端打字游戏，该游戏提供了一个简单直观的可交互界面，支持设置游戏难度、主题样式、游戏时间以及按键声音，最后还能统计打字精准度，帮你快速提升打字速度。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LD8xK6Kvp)
[DiceBear](https://github.com/dicebear/dicebear) | 一个开源的头像生成库，可通过给定的唯一标识，快速帮助开发者与设计师，生成一款简单可爱的用户头像。还提供了 API，供开发者接入调用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LD6YkxV46)
[Navidrome](https://github.com/navidrome/navidrome) | GitHub 上一个开源的跨终端音乐播放器：Navidrome。基于 Material UI 设计风格构建，支持所有主流音乐格式，拥有播放、收藏、专辑管理等功能特性。该播放器兼容 macOS、Linux、Windows 等主流桌面系统与移动端，内置多语言模块，可随时翻译转换为其它语言。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LCTq6fG7a)
[Lively Wallpaper](https://github.com/rocksdanister/lively) | 一个开源的动态壁纸软件，可快速更换、管理桌面动态壁纸，资源占用率极小。应用定制性强，可使用动态和交互式网页、3D 应用、音频可视化工具作为壁纸。支持多种不同分辨率屏幕，内容丰富，使用简单。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LCf9Pzg0N)
[qsv](https://github.com/jqnatividad/qsv) | 一个开源的 CSV 数据文件处理工具，提供了数十种可用的命令行，可以帮助你更加高效的索引、分析、拆分以及验证 CSV 数据。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LCdYLCk3j)
[FontForge](https://github.com/fontforge/fontforge) | GitHub 上一个开源的跨平台字体编辑器：FontForge，可用于创建、编辑、转换其它多种格式的字体。编辑器提供了中文使用指南，方便新手更好入门。客户端支持 Windows、macOS、Linux 等主流桌面系统。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LCcpls5Yj)
[PocketBase](https://github.com/pocketbase/pocketbase) | 一个基于 Go 编写的后端管理系统：PocketBase，集成简单，开箱即用，拥有清新简洁的后台管理面板。该系统内置实时数据库与 REST API，Google、GitHub 等多平台 OAuth 验证功能，文件可存储在本地或第三方平台，灵活性、扩展性强。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LC4yhkJbz)
[massCode](https://github.com/massCodeIO/massCode) | 一个免费开源的跨平台代码片段管理工具，支持组织管理、Markdown 编辑、搜索同步、自动保存、JSON 存储等功能，并提供了 VS Code、Raycast、Alfred 等多个平台插件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LBsQik4mH)
[Tooll 3](https://github.com/still-scene/t3) | GitHub 上一个开源的实时动画工具包：Tooll 3，搭配了简单直观的可视化界面，以及丰富的图形组件，让你可以快速创建实时动态图形。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LBbalBhZn)
[SMSBoom](https://github.com/WhaleFell/SMSBoom) | 一个开源的 Python 压力测试工具：SMSBoom，可用于测压短信轰炸，全自动添加有效接口，支持异步协程等特性。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LAHHNsyvQ)
[wechat-backup](https://github.com/greycodee/wechat-backup) | 一款在 GitHub 开源的微信聊天记录备份工具：wechat-backup，可将聊天记录持久化备份本地硬盘，释放手机存储空间。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LzQFZFcbs)
[Hetty](https://github.com/dstotijn/hetty) | 一款可用于安全研究方向的 HTTP 客户端，针对各类信息安全、漏洞悬赏需求进行量身定制，功能颇为丰富，亦可满足日常接口调试需求。该工具支持 HTTP 高级搜索、日志记录，可手动创建、更改、拦截请求、自带基于项目的数据库存储功能，以及简单易用的 UI 界面。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LyUVX1ZPb)
[Watermark-Removal](https://github.com/zuruoke/watermark-removal) | 一个开源的图片去水印解决方案：Watermark-Removal，可基于机器学习的图像修复方法，自动去除图片水印。经处理后的图片，与原图几乎一致。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LyTKUki45)
[supes.top](https://github.com/kiddin9/OpenWrt_x86-r2s-r4s-r5s-N1) | 给喜欢折腾智能家居和路由的同学，推荐一个 OpenWrt 配置工具：supes.top。可用于快速下载、定制各种设备的 OpenWrt 固件。Web 界面上提供了多种可选配置，包括设备名称和型号、常用软件包、插件、主题风格、宽带信息等，部分功能需付费才能使用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LySzR06g0)
[Redpanda Console](https://github.com/redpanda-data/console) | GitHub 上一款开源的数据流处理工具：Redpanda Console（前身是 Kowl），搭配可视化 UI，可用于快速管理和调试 Kafka/Redpanda 工作负载。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LyMGxy6BC)
[tproxy](https://github.com/kevwan/tproxy) | 一款开源的 TCP 连接分析工具：tproxy，可用于监控网络连接，分析请求内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LyDscu413)
[MiaoYan](https://github.com/tw93/MiaoYan) | 一款颜值颇高的 Markdown 编辑器：MiaoYan（妙言），拥有极简的设计风格，纯本地使用、支持语法高亮、黑暗模式、源文件保存、国际化等功能。项目基于 Swift5 原生开发，用起来比较丝滑，可自定义快捷和编辑器字体。目前仅支持 macOS 操作系统。 ​​​ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LyfGMwxtX)
[BatNoter](https://github.com/batnoter/batnoter) | 一款基于 GitHub 的 Web 笔记应用：BatNoter，可将 GitHub 仓库作为个人笔记存储库，并支持笔记分类、搜索、Markdown 快捷编辑与预览、书签管理等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ly6dG4Pxs)
[Beekeeper Studio](https://github.com/beekeeper-studio/beekeeper-studio) | 一款开源的跨平台 SQL 编辑器，提供 SQL 语法高亮、自动补全、数据表内容筛选与过滤、连接 Web 数据库、存储历史查询记录等功能。该编辑器支持 SQLite、MySQL、MariaDB、Postgres 等主流数据库，并兼容 Windows、macOS、Linux 等桌面操作系统。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LxWrr9vO2)
[Think（云策文档）](https://github.com/fantasticit/think) | 一款开源知识管理工具：Think（云策文档），内置知识库、思维导图、文档模板、在线编辑器等多种工具。可通过独立的知识库空间，结构化地组织在线协作文档，实现知识的积累与沉淀，促进知识的复用与流通。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LxQWueRTz)
[EasyNode](https://github.com/chaos-zhu/easynode) | 一个简易的个人 Linux 服务器管理面板 ：EasyNode，支持多服务器管，可通过 WebSocket 实时更新服务器基本信息，如系统、公网 IP、CPU、内存、硬盘、网卡等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LxPLrhKGK)
[Pingu](https://github.com/sheepla/pingu) | 日本一位开发者开源的命令行网络诊断工具，可用于替代 ping。在使用时，会逐渐出现一只可爱的 ASCII 企鹅图形，并高亮关键字。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LxOAohmAw)
[coolify](https://github.com/coollabsio/coolify) | 一个在 GitHub 开源的项目自托管方案，可用于替代 Heroku 和 Netlify。支持反向代理、免费 SSL 证书配置、多种常用数据库配置、项目一键安装与升级等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LwCls8WV9)
[vCard](https://github.com/codewithsadee/vcard-personal-portfolio) | 一个在 GitHub 开源的个人简历网站：vCard，支持响应式设计，能让你的个人信息、项目经验、工作经验在 Web 页面上，得到最佳的浏览体验。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LwzAZjeYR)
[Gitploy](https://github.com/gitploy-io/gitploy) | 可在几分钟内，快速搭建一个基于 GitHub 的项目部署系统。项目提供了更为直观的可视化界面，让你可以快速针对项目分支、SHA、标签进行部署，并拥有持续交付和持续部署能力。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LwsUX0jwN)
[Slashy](https://github.com/alyssaxuu/slashy) | 一个开源的 Notion 辅助工具：Slashy，可为 Notion 自定义各种快捷命令，如开启摄像头、录音、绘图、创建注释、可复用的内容模块等，进一步提高编辑效率。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LwrJT9XVO)
[dashy](https://github.com/Lissy93/dashy) | 一个高度可定制化、自托管的服务器启动页构建工具，自带可视化编辑器、状态检测系统，并拥有各类丰富的组件及主题。借助该工具，便可为不同应用快速搭建一个服务器管理面板，并基于各种组件、图标、主题，完成自定义配置，项目内置身份验证、状态监测、搜索、备份、可视化配置、多语言支持等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lwqaur6db)
[Wazuh](https://github.com/wazuh/wazuh) | GitHub 上一款免费开源的安全平台：Wazuh，集威胁预防、漏洞检测、风险响应、安全监控于一身。不仅如此，该开源平台还提供了搜索引擎和数据可视化工具，让用户可以更为直观的浏览、配置项目的安全监控信息。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LwkRJ5U8o)
[CogVideo](https://github.com/THUDM/CogVideo) | 一个可基于文本生成视频的开源项目：CogVideo，由清华大学数据挖掘研究小组开源，项目 Repo 中附有论文。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LvF1Z1to8)
[emojied](https://github.com/sekunho/emojied) | 一个可以把任意网址转换为 Emoji 表情符号的开源项目，还挺有意思的。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LuvxzlSBe)
[LetsMarkdown](https://github.com/Cveinnt/LetsMarkdown.com) | 一个轻量级的网页版 Markdown 编辑器，支持实时协作编辑、语法高亮、自动补全、主题设置等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LtI2XBqyG)
[infra](https://github.com/infrahq/infra ) | 一个让你能够快速访问项目基础设施（如 Kubernetes、数据库）的管理工具。集成了简单易用的命令行工具，支持配置同步、权限管理、日志记录、API 扩展等功能。目前项目功能仍在持续更新与迭代。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LtC9FmJvV)
[code996](https://github.com/hellodigua/code996) |  GitHub 上一个开源的命令行脚本。它可以统计 Git 项目的 commit 时间分布，进而推导出你当前的工作强度 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LtyCtBqRJ)
[Lapce](https://github.com/lapce/lapce) | GitHub 上一款开源的轻量级代码编辑器：Lapce，功能强大，运行丝滑，支持 Windows、Linux、macOS 等主流桌面系统。拥有类似 Vim 的模态编辑功能，支持代码自动补全、诊断，并内置了远程开发模式、命令行终端，为你提供顺畅的 "本地编码" 体验。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lti7AuFBl)
[LiveTerm](https://github.com/Cveinnt/LiveTerm) | 可以让你在几分钟内，快速搭建一个拥有命令行风格的网站。项目高度可定制、简单易用。在将项目 clone 到本地之后，只需要编辑项目仓库的 config.json，即可快速完成定制。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LtgWxiaTS)
[cnchar](https://github.com/theajack/cnchar) | GitHub 上一个开源的汉字拼音笔画库：cnchar。功能非常齐全，支持汉字拼音、笔画数解析，多种模式绘制汉字，并能完成语音识别、语音合成等操作。项目支持离线使用，在多端通用，开发者还可进行自定义部署，自定义数据等操作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LsCu3tf3D)
[Modren](https://github.com/RudraSwat/modren) | 一个开源的 Linux 应用商店。安装成功后，便可通过该商店下载、安装各类 Linux 应用。支持 APT、Snap、Flatpaks、DEB 等多种格式的安装包，可用于 Ubuntu、Debian 衍生发行版等系统。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LsvO25LdJ)
[PointLess](https://github.com/kkoomen/pointless) | 一个开源的绘图画布应用：PointLess，开发者可以基于该项目，制作出一些绘画、白板、笔记等应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LsoJGbInk)
[BlogHelper](https://github.com/onblog/BlogHelper) | 一个可帮助国内用户写作的托盘助手，支持将本地文章一键发布到主流博客平台，剪贴板图片一键上传至图床（新浪、GitHub、图壳、腾讯云、阿里云、又拍云、七牛云）。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LrSV0ACzm)
[Obsei](https://github.com/obsei/obsei) | GitHub 上一款开源的低代码工具：Obsei，基于 AI 驱动，可应用于各种开发及业务场景。通过这个工具，可实现社交平台舆论监控、客户投诉预警、自动生成工单、市场调查分析、为 AI 任务生成数据集等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LrRlB38IO)
[HertzBeat](https://github.com/dromara/hertzbeat​​​) | 推荐 GitHub 上一个易用友好的云监控系统：HertzBeat。无需 Agent，拥有强大自定义的监控能力。支持网站监测，PING 连通性，端口可用性，数据库，操作系统，API 监控，阈值告警，告警通知等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LrN1GclDo)
[BallCat](https://github.com/ballcat-projects/ballcat) | GitHub 上一个支持快速开发的后端脚手架，可快速搭建企业级后台管理系统，并提供多种便捷 starter 进行功能扩展。主要包括前后台用户分离、菜单权限、数据权限、定时任务、访问日志、操作日志、异常日志、统一异常处理、XSS 过滤、SQL 防注入、国际化等多种功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LrLQCkU7F)
[AppMaster.io](https://appmaster.io/zh) | 一个无代码应用搭建平台：AppMaster.io，无需编写一行代码，即可快速创造出一个 App，大幅解放生产力。该工具可用于构建本地 Web 和移动端应用程序、自动化业务流程等场景。通过界面拖放，即可构建出可用于生产环境的 App，并支持部署到云端或导出源代码 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LrDNmnxNg)
[DB Fiddle](https://www.db-fiddle.com/) | 一款可在线运行、调试 SQL 数据库的开发者工具。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LrCq8n6VD)
[Actual](https://github.com/actualbudget/actual) | 一个在 GitHub 开源的金融系统，强调「本地优先」原则，可用于管理个人财务，注重安全性和私密性。拥有交易管理、预算跟踪、财务报告生成、交易拆分、跨设备同步、数据导入与迁移、端到端加密等功能。该工具适用于 macOS、Windows、Linux、iOS、Android 等主流操作系统。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LqSEUaD8y)
[JSON Hero](https://github.com/jsonhero-io/jsonhero-web) | 一个实用的 JSON 工具：JSON Hero，提供了简洁直观的 UI 界面，让查阅和理解 JSON 数据变得更为轻松便捷。开发者借助这一工具，能以列表视图、树状视图、编辑器视图等多种方式来查看 JSON 文件，并自动识别数据内容，展示数据预览。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lquv8226L)
[portfolYOU](https://github.com/YoussefRaafatNasry/portfolYOU) | 一个简洁、直观的个人简历主题，可使用 GitHub Pages 快速搭建简历站点。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)]()
[Spacedrive](https://github.com/spacedriveapp/spacedrive) | 一个开源的跨平台文件管理器，内置了虚拟分布式文件系统（VDFS）。支持从云服务到离线硬盘，将设备的存储容量和处理能力整合到个人分布式云中，用起来既安全又直观。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lql4BmjC3)
[MM-Wiki](https://github.com/phachon/mm-wiki) | 一个开源的轻量级知识分享、团队协同软件，可用于快速构建企业 Wiki 和团队知识分享平台。提供方便的安装界面程序，无需任何手动操作。部署方便，使用简单。具备完善的系统权限管理，系统可以自定义角色，可为不同角色授予不同的权限。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LqfzErEAu)
[Perspective](https://github.com/finos/perspective) | 推荐 GitHub 上一个交互式、可视化数据分析工具：Perspective，可用于创建数据报告、数据面板、科研笔记及应用。为了便于开发者与数据科学家上手使用，开发团队还提供了十几个案例供参考学习，其中包含电影、超市、地铁、流媒体等多个分类。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LqbE7EZFp)
[Apifox](https://www.apifox.cn/a1ghdaily) | 一款国产 API 管理工具，该工具基于可视化界面来管理 API 文档，支持 API 自动化测试、CI 持续集成、团队协作，并且它还能根据模型，自动为项目生成 API 代码。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lq3N29znI)
[Video-subtitle-extractor](https://github.com/YaoFANGUK/video-subtitle-extractor) | 一款开源的视频硬字幕提取工具，可自动生成 srt 文件，无需申请第三方 API，本地实现文本识别。基于深度学习的视频字幕提取框架，包含字幕区域检测、字幕内容提取。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lq2dCdEMY)
[LookScanned](https://github.com/rwv/lookscanned.io) | 一个可以将 PDF 转换成扫描文件的开源工具，支持设置文件角度、噪点、模糊度等属性，整个过程无需用到打印机和扫描仪。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lpl0GySm3)
[OpenBBTerminal](https://github.com/OpenBB-finance/OpenBBTerminal) | 一个在 GitHub 开源的股票和加密市场命令行工具。该项目提供了一个基于 Python 的集成环境，允许普通的交易员利用数据科学、机器学习技术来进行交易。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lph59bV0o)
[InvenTree](https://github.com/inventree/InvenTree) | GitHub 上一款开源的库存管理系统：InvenTree，简单易用，可用于跟踪及管理各类库存零件，并支持生成各种报告，可扩展性强。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LpbAcf4Jp)
[DevStream](https://github.com/merico-dev/stream) | 一个开源 DevOps 工具链管理工具，将主流 DevOps 全生命周期的开源工具管理起来，提供了包括安装部署、最佳实践配置等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LoZNznxuU)
[JavaScript Visualizer](https://github.com/Hopding/js-visualizer-9000-client) | 一个开源的 JavaScript 可视化调试工具，运行后，可动态展示任务队列、调用栈、Event Loop 等过程与结果。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LogxyjrsY)
[Blockly ML](https://github.com/chekoduadarsh/BlocklyML) | 一个开源的编程可视化工具，可用于辅助学习 Python 和机器学习，让学习过程变得不再枯燥。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lo7AIkoE7)
[HertzBeat](https://github.com/dromara/hertzbeat) | 一个开源的、友好易用的监控告警系统：HertzBeat，支持网站，API，PING，端口，数据库，操作系统等监控类型，并自带可视化操作界面。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lo5eBEErQ)
[Weylus](https://github.com/H-M-H/Weylus) | 一个颇有意思的开源项目，可将手机、平板电脑屏幕变成电脑的图形输入板与触摸屏。让你在手机、平板电脑上进行绘图，并呈现到电脑屏幕上，相当于给电脑外接了一块触控画板。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LnYae1GmH)
[Amplication](https://github.com/amplication/amplication) | 一个开源的开发者工具，可用于快速构建高质量的前后端项目，提升开发效率。功能包括可视化数据模型管理，自动化批量代码生成，管理面板搭建，生成满足 CRUD 需求的 REST 和 GraphQL API 等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LnVO5mgP8)
[JSON Visio](https://github.com/AykutSarac/jsonvisio.com) | 一个开源的 JSON 数据可视化工具，可通过图表节点，完美呈现 JSON 数据间的结构关系与详情，并支持离线使用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LnPUN7zmG)
[StartPack](https://github.com/tldr-devops/startpack) | 一些可用于早期项目启动和自托管的 devops 工具包，在项目初期时，可通过这些工具降低项目的开发与运维成本。里面包括了数据库存储、项目管理、实时通讯、内容管理、低代码搭建等技术解决方案。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LmCuOCmgx)
[Amazing-QR](https://github.com/x-hw/amazing-qr) | GitHub 上开源的 Python 二维码生成器，可生成普通二维码、带图片的艺术二维码（黑白与彩色）、动态二维码（黑白与彩色） | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LmBjLjhdn)
[Magma Studio](https://magma.com/index) | 一款可用于游戏、动画等艺术创作的平台。支持多人协作绘图，可通过共享画布进行实时绘画，进行头脑风暴和构思。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LmA8Gt6jk)
[Orchest](https://github.com/orchest/orchest) | 一款开源的可视化数据管道构建工具，以更简便的方式，快速构建数据管道，无需框架和 YAML 配置，可直接通过 Python、R、Julia 来编写代码，处理数据。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lmxoc9Qlj)
[alist](https://github.com/Xhofe/alist) | 一个支持多存储的文件列表程序：alist，可配置与对接多个不同存储平台，部署方便，开箱即用，并能在线预览、管理多种不同格式的文件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lmt4iyi5U)
[PicoShare](https://github.com/mtlynch/picoshare) | 一款开源的文件共享系统，简单易用、不限制文件大小、可直接生成下载链接，支持自托管部署，数据安全性可控。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LmjDOmblS)
[Cider](https://github.com/ciderapp/Cider) | 一款开源的跨平台 Apple Music 音乐播放器，基于 Vue.js 和 Electron 构建，内置音频增强、社交分享、远程操控等功能。适用于 Windows、Linux、macOS 等主流桌面操作系统。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LmisKsxbb)
[Obsidian Memos](https://github.com/Quorafind/Obsidian-Memos) | 让你可以用一种全新的方式在 Obsidian 记录日程。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LldicAWdh)
[bbtop](https://github.com/Lakr233/mobilePillowTalkLite) | 一个可在 iOS 端运行的 Linux 服务器监控和管理工具，可通过密码、密钥来验证服务器身份，FaceID/TouchID 保护、可配置文件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ll3RIEf5B)
[regex-vis](https://github.com/Bowen7/regex-vis) | 一个蛮不错的正则表达式可视化工具，作者提供了一系列组件，让你可在 Web 页面上通过配置，快速生成正则表达式，以及对应的可视化图形，并且还支持运行测试，检验结果。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ll2GE6ZHw)
[SteamTools](https://github.com/BeyondDimension/SteamTools) | 一个开源跨平台的多功能 Steam 工具箱，能让你的 Steam 用起来更加丝滑。支持 Windows、Linux、macOS 等主流桌面系统。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LkUre2PTo)
[SystemSix](https://github.com/EngineersNeedArt/SystemSix) | 一款可在树莓派上运行的电子水墨屏，可用于显示日历、天气、操作系统界面等内容，拿来折腾一些小工具应该挺好玩的 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LkTgabpYR)
[ToolJet](https://github.com/ToolJet/ToolJet) | GitHub 上一个开源的低代码开发框架。提供了丰富的可视化工具箱，仅需几步，即可快速构建企业级部署工具。该框架提供了 API，可对接 PostgreSQL、MongoDB、Elasticsearch  等多种外部数据源，以及常用的第三方服务，如 Stripe、Slack、Airtable。  | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LkNmQpCTi)
[Reactive Resume](https://github.com/AmruthPillai/Reactive-Resume) | 一款颇为独特的简历生成器，可通过各种配置，让创建、更新、共享简历的过程变得更加简单便捷。免费开源、支持中文，可同时创建多份简历，并快速打印成 PDF。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LkMbLEXmC)
[CodeEdit](https://github.com/CodeEditApp/CodeEdit) | 一款开源的 IDE 代码编辑器，主要面向 macOS 用户，致力于提供更为丝滑的编程体验，目前功能仍在持续迭代中。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lkhyaeecg)
[Another Redis Desktop Manager](https://github.com/qishibo/AnotherRedisDesktopManager) | 一款更快、更好、更稳定的 Redis 桌面（GUI）管理客户端，兼容 Windows、Mac、Linux 等主流系统。性能出众，轻松加载海量键值。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LkfYKDcxA)
[avvvatars](https://github.com/nusu/avvvatars) | 一款比较火的头像生成器，可快速生成一款独特头像，拥有 40 种颜色、60 种形状搭配，支持自定制，可集成到 Web 项目中。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LkatN62SU)
[ecapture](https://github.com/ehids/ecapture) | 一款无需 CA 证书，就可以进行 HTTPS 通讯明文抓包的工具。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lk9iIE4Hu)
[Visualize Data on Spirals](https://github.com/jokergoo/spiralize) | GitHub 上的一款开源工具包：Visualize Data on Spirals，可快速搭建呈螺旋结构的可视化数据图。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lk2qwzeCE)
[Dasel](https://github.com/TomWright/dasel) | 一款比较实用的命令行工具：Dasel，可通过类似链式语法的方式，对 JSON、YAML、CSV 等文件进行增删改查、转换等操作。该工具支持多种结构化数据文件，如 JSON、YAML、TOML、XML、CSV 等。 ​​​ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LiT8hhbDJ)
[Rayon](https://github.com/Lakr233/Rayon) | 一款开源的服务器监控工具，支持 libssh2 主机连接、密钥认证、远程代码执行、GPU & RAM & 硬盘使用情况监控等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LiNDjtisH)
[Yao](https://github.com/) | 一款蛮不错的开源低代码应用引擎，无需编写一行代码，即可快速创建 Web 服务和管理后台，大幅解放生产力。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LiFA46ss1)
[Plasticity](https://github.com/nkallen/plasticity) | 一款开源的 3D 建模工具，主打小而美的功能，为概念艺术创作而生，可通过各类快捷操作，快速完成 3D 建模工作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LiD1LkfgL)
[Grist](https://github.com/gristlabs/grist-core) | 一款颇为实用的现代化数据表格，不同于其它普通的数据表格，该项目融合了电子表格的灵活性与数据库的稳定性，从用户体验与性能两方面，着重提高互联网用户的办公效率。该表格支持各类 Python 公式与 Excel 函数，拥有可扩展移植的数据格式、轻便的数据编辑功能，并自带可视化数据面板，开发者还可通过 API 与其它数据源对接。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LgQs72lOT)
[TerraForge3D](https://github.com/Jaysmito101/TerraForge3D) | 一款专业的地形生成和建模工具，免费开源，开箱即用，附有多个视频教程供新手入门学习。这款功能包括的功能也颇为齐全，其中有基于 GPU 和 CPU 驱动的地形生成功能、无限制分辨率、可视化节点编辑器、天空和海平面生成器、风雨尘各类物理效果模拟器等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LgEtjp5Y5)
[Cyberbrain](https://github.com/laike9m/Cyberbrain) | Google 工程师在 GitHub 开源的一款 Python 可视化调试工具：Cyberbrain（赛博大脑）。支持回溯代码变量的更改历史，查看程序执行状态（包括变量值），带代码进行循环调试等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LgBIPrQji)
[vCards CN](https://github.com/metowolf/vCards) | 国内开发者在 GitHub 开源的一个项目：vCards CN（中国黄页 ），可为常用联系人导入头像，优化 iOS/macOS 来电、信息界面体验 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LgxoWqPUI)
[Harmonoid](https://github.com/harmonoid/harmonoid​​​) | GitHub 上一款优雅、简洁的开源音乐播放器，基于 Material Design 理念设计，拥有强大的音乐分类管理功能，支持 Windows 和 Linux 系统。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LgwdT7Jir)
[china-holiday-calender](https://github.com/lanceliao/china-holiday-calender) | 国内一名开发者在 GitHub 上维护的假期日历：china-holiday-calender，在客户端订阅后，可以很方便的用于查看国内各种节假日、调休、补班日历。文件为 ICS 格式，可供 iOS、Google Calendar、Outlook 等客户端订阅。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lg2LkBEYD)
[Saikou](https://github.com/saikou-app/saikou) | 一款开源的动漫、漫画客户端：Saikou，名字取自日语 さいこう，有最高、最好之意。该客户端的主要作用，是可用于上传、下载 Anilist 的各类动漫与漫画资源，免费纯净、无广告。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LfVT97mhu)
[Mermaid](https://github.com/mermaid-js/mermaid) | 一款受到 Markdown 语法启发而诞生的 JavaScript 图表工具，由开发者 Knut Sveidqvist 所负责维护，目前在 GitHub 已积累 42000 Star，在技术圈内受众颇广。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LfTKQ2ym2)
[Trilium Notes](https://github.com/zadam/trilium) | 一个免费、开源的笔记应用程序，专注于建立大型个人知识库。支持树状笔记、笔记加密、全文搜索、自托管服务器，还可生成可视化笔记的关系图和链接图。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LeQwqhWcs)
[Gyroflow](https://github.com/gyroflow/gyroflow) | 一款开源应用：Gyroflow，可通过调整陀螺仪、加速度计等数据，让运动视频效果更加稳定。此外，它还支持实时预览、参数调整和各类复杂计算、GPU 处理和渲染等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LeDancTlq)
[Midarr](https://github.com/midarrlabs/midarr-server) | 一款轻量级视频播放器：Midarr，作者称之为「下一代媒体服务器」，提供了清新简洁的界面，支持查看在线用户状态、可自托管。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LeoeWpVV0)
[FireVerse](https://github.com/napthedev/fireverse) | 一款开源的聊天应用：FireVerse，功能齐全，允许一对一聊天、多人群聊。支持发送文字、GIF 图片、贴纸、表情符号等多种不同格式的消息内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Len3RyFBZ)
[DevToys Mac版](https://github.com/ObuchiYuki/DevToysMac) | 里面提供了诸多实用的开发者工具，比如 JSON 格式化、正则表达式测试、Base64 编码与解码、PNG/JPEG 图片压缩、色盲模拟器等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lekjp1SQt)
[tiler](https://github.com/nuno-faria/tiler) | 可以用来生成各种由图片拼接而成的马赛克图像 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LcIxsqoB1)
[Monitor](https://github.com/lxflxfcl/monitor) | 国内一位网络安全人员在 GitHub 开源了一款漏洞监控平台，主要用于监测 GitHub、微软、CNNVD 等各大平台发布的最新技术漏洞信息，并将漏洞按不同危险等级进行划分，最后再通过企业微信和邮箱进行消息推送。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LcEBV4y4R)
[Ansible](https://github.com/ansible/ansible) | 一款开源的自动化运维工具，可让项目和系统变得更加容易部署和维护。通过简单的语法，快速实现从代码部署到网络配置，再到云管理。并使用 SSH 实现一切自动化流程，无需在远程系统上安装代理。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LcxVU1XlF)
[daedalOS](https://github.com/DustinBrett/daedalOS) | 国外一位工程师在 GitHub 上开源的桌面环境系统：daedalOS，可直接在浏览器运行。主要拥有开始菜单、任务栏、动态壁纸、文件系统等功能。此外，系统还内置了各类开发工具、浏览器、命令行终端、视频播放器等应用，功能颇为齐全。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LclKVF9px)
[rnote](https://github.com/flxzt/rnote) | 一款简洁优雅的笔记软件，带有可调整参数的纹理笔触，可用于快速创建手写笔记和绘画。支持插入各类图表、手写注释和文档。你还能将笔记导出成 SVG 或 PDF 格式的文件，与他人分享 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lcf4UiKGA)
[ROAPI](https://github.com/roapi/roapi) | 一款开源的开发者工具：ROAPI，无需编写一行代码，即可自动为静态数据集生成只读 API，快速完成静态数据的加载调用。静态数据集所支持的格式，包括 CSV、JSON、Excel、MySQL、Airtable、GraphQL 等格式。 ​​​ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LbP9xxZKg)
[Agora Flat](https://github.com/netless-io/flat) | 声网在 GitHub 开源的一款白板工具，支持实时交互、多人音视频通讯和消息聊天、房间创建管理、课堂录制回放、课件存储、屏幕共享等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LbNYtB3L3)
[Zetane Viewe](https://github.com/zetane/viewer) | 一款在 GitHub 开源的机器学习模型和内部张量 3D 可视化工具。它的主要作用，是能通过理解模型架构、可视化内部数据（特征图、权重、偏差、图层输出张量），为你打开 AI 黑盒。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LbMNq4Lm3)
[DevToys](https://github.com/veler/DevToys) | 作者将其称之为「开发人员的瑞士军刀」，里面提供了诸多实用的开发者工具，比如 JSON 格式化、正则表达式测试、Base64 编码与解码、PNG/JPEG 图片压缩、色盲模拟器等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LbLCnjM65)
[矩阵乘法计算器](https://github.com/staltz/matrixmultiplication.xyz) | 一个「矩阵乘法计算器」，通过交互式动画，帮助你更好的了解与掌握线性代数中的矩阵乘法。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lbv7ud0NF)
[Text to Handwriting](https://github.com/saurabhdaware/text-to-handwriting) | 可将普通文本转换为手写文本，包括中文字体。支持自定义字体大小、墨水颜色、页面大小、字体间距、纸张背景等属性。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LbtWqzTeR)
[DSQ](https://github.com/multiprocessio/dsq) | 命令行工具：DSQ，除了数据查询外，还支持多个文件合并查询，不同格式的数据源文件转化（比如将 CSV 转为 JSON）等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LbsLn1orh)
[DataStation](https://github.com/multiprocessio/datastation) | 一款颇为实用的开发者工具，可通过 SQL 语句，快速查询 JSON、CSV、Excel、日志记录库等文件中的数据，并创建可视化图表。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LbsLn1orh)
[mometa](https://github.com/imcuttle/mometa) | 一款面向研发的、代码可视设计编辑平台，对低代码平台不形成依赖，二次开发可以无缝进入代码开发模式；支持所见即所得的可视编辑，用于优化开发体验；可自定义物料，提升功能复用率。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LbrbXtF7s)
[Hitomi-Downloader](https://github.com/KurtBestor/Hitomi-Downloader) | GitHub 上一款开源的下载工具，可用于快速下载各大网站的视频、漫画、电影、音乐等内容。拥有简洁易用的 UI 界面，多线程及脚本支持。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LbmS3hNG2)
[Yasso](https://github.com/sairson/Yasso) | 一款开源的内网渗透辅助工具集，集合了大量的常用功能，拥有丰富的 SQL 渗透辅助功能，支持 RDP， SSH，Redis，MongoDB，MySQL，WinRM 等服务爆破，端口扫描，Web 指纹识别功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lb414qKNf)
[Focalboard](https://github.com/mattermost/focalboard) | 一款开源的看板工具，可用于日常工作任务和学习计划的分配、管理，并支持自托管服务器。该项目可作为 Trello、Notion 和 Asana 的开源替代品，支持 Windows、macOS、Linux 等主流操作系统。 ​​​ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lb2PZEYuN)
[Papercups](https://github.com/papercups-io/papercups) | 通过该工具直接对接 Slack，简单几步操作，即可为 Web 应用打造一个在线聊天功能。此外，它还支持电子邮件回复、自定义聊天组件、Markdown 和 Emoji 文本等功能，并适配了 Flutter、React 等前端开发框架。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lb0tT3TjX)
[Movie Robot](https://github.com/pofey/movie_robot) | 给影迷们推荐一款比较实用的工具：电影机器人，可自动从豆瓣电影的想看、在看、看过中获取影音信息，然后去 PT 站智能选种，找到最匹配的资源加入自己的影音库。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LaUAz0vDt)
[sqliteviz](https://github.com/lana-k/sqliteviz) | GitHub 上一款比较实用的开源工具，可为 SQLite 数据库快速生成可视化图表，支持导入 CSV 和 JSON 文件，可离线使用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LaR3nEvxg)
[Multipass](https://github.com/canonical/multipass) | 一款轻量级的虚拟机管理工具，提供了简单易用的命令行工具，可帮助开发者快速搭建 Ubuntu 虚拟机集群，用于开发测试。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](weibo://L9jcZg8z6)
[SeaTunnel](https://github.com/apache/incubator-seatunnel) | 一个简单易用、超高性能的分布式数据集成平台：SeaTunnel，支持海量数据实时同步，每日可稳定高效同步数百亿数据，已在近百家公司生产上使用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L9eT7r3lz)
[Ghostly](https://github.com/patriksvensson/ghostly) | 一款开源的 GitHub 客户端，可用于接收、组织管理 GitHub 通知，包括 issue 追踪、PR 提交、漏洞修复等，支持 Windows 10/11 系统。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L9cwZESyq)
[wechat-report](https://github.com/myth984/wechat-report) | 国内有位开发者在 GitHub 上开源了一个《微信聊天记录年度报告》网页，可用于查看 2021 年与好友的聊天数据报告，项目中附有相关工具与教程。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L9blUhI7P)
[Maui Shell](https://github.com/Nitrux/maui-shell) | 一款重量级 Linux 桌面系统，被国外不少开发者称之为「开启 Linux 桌面新时代」的新系统，项目的最大亮点，在于能同时兼容 Android 与 Linux 系统，跨终端工作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L99MutuhT)


### 插件

名称 | 简述 | 源
---- | ----- | -----
[ChatGPT Chrome Extension](https://github.com/gragland/chatgpt-chrome-extension) | 一款专为 Chrome 用户开发的 ChatGPT 插件。安装后，在任意页面的文本框中点击右键，就会出现「Ask ChatGPT」选项。选中它，ChatGPT 就会根据当前文本框中的内容，帮你完成各种具体任务，比如写推文、修改邮件、修复 Bug 等等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MiO83rqmq)
[「GPT for Google」](https://github.com/wong2/chat-gpt-google-extension) | 一款基于 ChatGPT 构建的 Chrome 插件：「GPT for Google」，还挺好用的。安装之后，除了会在浏览器正常展示 Google 搜索内容，还会在右侧展示 ChatGPT 反馈结果，进一步提升搜索效率。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MiuSHqAla)
[Obsidian Weread Plugin](https://github.com/zhaohongxuan/obsidian-weread-plugin) |  GitHub 上一款开源的 Obsidian 微信读书插件：Obsidian Weread Plugin。可用于同步微信读书中书籍元信息、高亮标注，划线感想、书评等，并将这些信息转换为 markdown 格式保存到 Obsidian 的文件夹中。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mbap6DBB3)
[audio-preview](https://github.com/sukumo28/vscode-audio-preview) | 如果你想在 VSCode 中直接播放或预览音频文件，可以安装下 audio-preview 这个扩展。该扩展支持在 VSCode 中查看各类音频文件，如 wav, aac, mp3, ogg, flac 等音频格式的声波图和音谱图。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ly7rn41bM)
[Motion DevTools](https://motion.dev/tools) | 一个 Chrome 开发者插件：Motion DevTools，可用于快速构建 Web 动画。支持对 CSS 编写的 Web 动画进行审视、编辑、导出等操作，非常方便。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lst3A5YHS)
[AI Doc Writer](https://github.com/mintlify/vscode-docs) | 国外一名小姐姐开源了一款 VSCode 插件，可通过选中代码块，自动为代码生成注释文档。目前支持 JavaScript、TypeScript、Python 等多种语言。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LbCbSuUYJ)
[omni](https://github.com/alyssaxuu/omni) | 一款功能极其强大的 Chrome 插件，拥有 50 多项特性，为提高生产力而生，让你可以像极客一样来使用 Chrome。功能包括快速切换和搜索页面标签，搜索网页浏览记录，多个快捷键配置，并集成了 Notion、Figma、Docs 等多款工具。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LaSerfrF4)


### 资料集合

名称 | 简述 | 源
---- | ----- | -----
[《程序员海外工作 / 英文面试手册》](https://github.com/eliaszon/Programmers-Overseas-Job-Interview-Handbook) | 上面收录了作者长期以来收集的直投海外找工作的技巧，包括简历润色、主流招聘网站、公司风评查询、面试准备、英文表达等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mm1hyir2i)
[《可用于代码面试的数据结构与算法》](https://github.com/SamirPaul1/DSAlgo) | 里面包含了多种基于 Python3 实现的数据结构与算法，覆盖动态规划、排序算法、二叉树、矩阵、哈希表等。| [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MlRR2uU6z)
[Awesome ChatGPT Prompts](https://github.com/f/awesome-chatgpt-prompts) | 里面整理了一系列与 ChatGPT 互动的玩法与技巧。你可以通过这些玩法，让 ChatGPT 变成 Linux 终端、文本翻译与修正、技术面试官、故事家、脱口秀演员、写作指导顾问、心理咨询家等等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mj8a6ofH2)
[《DevOps 2022 技术路线图》](https://github.com/milanm/DevOps-Roadmap) | GitHub 上的开源学习资源：《DevOps 2022 技术路线图》，带你快速了解最新的 DevOps 技术栈。里面包含了 Git、常用编程语言、Linux、网络安全、容器、IaC、CI/CD 等各种 DevOps 相关的学习资料。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MdcuKtXjC)
[《AI 绘画资料合集》](https://github.com/hua1995116/awesome-ai-painting) | 一份开源的技术资源：《AI 绘画资料合集》，作者汇总了国内外可使用的 AI 绘画平台、技术教程、参数教程、部署教程、业界新闻等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Md8XyyKiG)
[Answer](https://github.com/answerdev/answer) | 一个功能齐全的开源问答系统，可应用于产品技术支持、用户交流、工单管理等各种场景。完整适配了移动端，可通过 Docker 快速部署。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Md7o8993M)
[《网络安全工具速查表》](https://github.com/CompassSecurity/Hacking_Tools_Cheat_Sheet) | GitHub 上的开源技术资源：《网络安全工具速查表》，主要整理了信息搜集、网络扫描、嗅探、破解、证书配置等功能的命令行操作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Md34gxgLY)
[《网络游戏开发技术图谱》](https://github.com/gonglei007/GameDevMind) | GitHub 上开源的学习资源：《网络游戏开发技术图谱》，网络游戏开发知识、技术与信息库，可作为游戏研发技术从业者的导航地图。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M6qAigASE)
[GoBypassAV](https://github.com/TideSec/GoBypassAV ) | 整理了基于 Go 的 16 种 API 免杀测试、8 种加密测试、反沙盒测试、编译混淆、加壳、资源修改等免杀技术，并搜集汇总了一些资料和工具。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M0oiYuS7J)
[bigdata_analyse](https://github.com/TurboWay/bigdata_analyse) | 国内一位开发者在 GitHub 开源的数据分析项目库：bigdata_analyse，收集了多个数据分析项目集合。每个项目都会包含一个友好的说明文档，用来阐述和展示整个开发流程。同时也会提供相关的数据集，以供下载练习。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LD9IOF5uD)
[new-grad-positions](https://github.com/upupming/new-grad-positions) | 2023 届互联网公司校招、实习的最新官方招聘信息整理，帮助在校生消除信息不对称带来的劣势。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LChvXi8F7)
[《Papers for Software Engineers》](https://github.com/facundoolano/software-papers) | GitHub 上的开源技术资源，里面收录了一系列计算机大佬撰写的软件工程论文。内容覆盖计算机与智能、集成电路、共享数据库、密码学、软件工程本质、Web 搜索引擎解析、分布式存储系统、智能合约与去中心化平台。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LC6Unlwtz)
[「云计算自学指南」](https://github.com/madebygps/self-taught-guide-to-cloud-computing) | 该指南主要拆分为六大模块，分别对应 Linux 及计算机网络基础、脚本及代码工具、云计算、DevOps 实践、学习资源、附加资源（技术相关话题）等内容。在每个不同时间段，帮你规划不同的学习路线，让你可以更为清晰的掌握云计算基础知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LBXtUCWm8)
[Modern CPP Tricks](https://github.com/rachitiitr/modern-cpp-tricks) | 微软前工程师 Rachit Jain 在 GitHub 上开源的一份 C++ 知识库：Modern CPP Tricks，里面整理了一些 C++ 相关的开发技巧。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LBWiPgSgy)
[Satellite image deep learning](https://github.com/robmarkcole/satellite-image-deep-learning) | 主要整理了深度学习技术在卫星图像领域中的应用知识。仓库中包含了图像分类与分割、在线分析工具、图像标注、图形可视化、地理信息系统等开源软件，相关技术教程、博客文章等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LBvcq7liC)
[《一图胜千言》](https://github.com/girliemac/a-picture-is-worth-a-1000-words) | 由微软工程师 Tomomi 手绘并整理发布。该仓库包含了数据结构与算法、Web 开发、机器学习、Git 开发等编程领域的涂鸦作品，其中有部分被应用到了微软的开源教程。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LyB64suZx)
[《红队知识仓库》](https://github.com/Threekiii/Awesome-Redteam) | 里面收录了一系列网络安全相关的技术文档、开发工具、公开知识库等内容，覆盖漏洞研究、信息收集、内网渗透等领域。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ly8CqBp48)
[SVG Spinners](https://github.com/n3r4zzurr0/svg-spinners) | 这个 GitHub 项目收集了 40 多种不同风格的 SVG 加载动画，可用于网站或 App 项目开发。相对于常规的 GIF 格式图像来说，SVG 的可编辑性、可压缩性更强。因此在最近几年，不少网站都开始广泛采用 SVG 来做页面动画。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LxITe3aSn)
[Cloud-DevOps-Learning-Resources](https://github.com/ahmedtariq01/Cloud-DevOps-Learning-Resources) | 该仓库里面收录了一系列云原生开发学习资料（如 Docker、K8s、Azure），包括技术书籍、速查表、测验题、面试笔记等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LwKATsm3B)
[Machine Learning Interview](https://github.com/khangich/machine-learning-interview) | GitHub 上开源的机器学习面试题库：Machine Learning Interview，收录了世界各大互联网公司的机器学习面试题。仓库中包括概率与统计、大数据、AB 测试、机器学习与深度学习领域的速查表、面试准备、学习指南、项目用例、面试经验等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lwm2Km2tp)
[API Tracker](https://apitracker.io/) | 这个网站整理了非常多的 API 开放接口，包括一些常见的 API 工具、文章、视频等学习教程。覆盖社交媒体、金融、新闻、游戏、人工智能、音视频等领域。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Luumv8rvc)
[Beautify GitHub Profile](https://github.com/rzashakeri/beautify-github-profile) | 这个 GitHub 仓库收录了多种工具及指南，让你的 GitHub 个人页面看起来更为丰富与美观。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ltx33sjk4)
[flutter-tips-and-tricks](https://github.com/vandadnp/flutter-tips-and-trick) | 一份精心收集整理了 Flutter 和 Dart 开发的小技巧资料集合，每个小技巧除了提供代码还贴心的制作图片讲解。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LsHMQ0Buq)
[cs-self-learning](https://github.com/) | GitHub 上的开源 CS 自学指南，项目包含了诸多国外高质量 CS 课程，覆盖数据结构与算法、计算机系统安全、数据科学、人工智能、机器学习等领域。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LsGBLwrnR)
[「100 天编码挑战计划](https://github.com/kallaway/100-days-of-code) | 国外一名程序员在 GitHub 上发起了「100 天编码挑战计划」，规定所有参与的开发者，每天至少写 1 小时的代码，并提交到仓库中。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LsFqHABiq)
[Best-of Machine Learning with Python](https://github.com/ml-tooling/best-of-ml-python) | 里面收录了一些比较实用的机器学习与 Python 开源项目与工具。收录项目共计 900 多个，包括数据可视化、自然语言处理、文本与图像数据、Web 爬虫等分类。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LqRhEtejl)
[《C++ Concurrency in Action 2ed 笔记》](https://github.com/downdemo/Cpp-Concurrency-in-Action-2ed) | C++11/14/17/20 多线程，掌握操作系统原理，解锁并发编程技术。原书籍前五章介绍了线程支持库的基本用法，后六章从实践角度介绍了并发编程的设计思想。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LqmE2CXDT)
[《区块链黑暗森林自救手册》](https://github.com/slowmist/Blockchain-dark-forest-selfguard-handbook) | GitHub 上的开源技术教程：《区块链黑暗森林自救手册》，主要介绍了关于区块链安全相关的攻击手段、技术防控知识等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lq4Y5m4Pi)
[《机器学习笔记》](https://github.com/dair-ai/ML-Notebooks) | 整理了一系列机器学习任务、应用等代码示例。包括计算机图形、构建一个简单的神经网络、PyTorch 介绍、逻辑回归、文本分类、GNN 介绍等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LpXTJxxSl)
[《Rust 新手入门指南》](https://github.com/jondot/rust-how-do-i-start) | GitHub 上的开源技术资源：《Rust 新手入门指南》（Rust 🦀. How do I start?），收录了可供 Rust 新手入门学习的教程、实战项目、开源库、开发者工具等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LpiEzBwJK)
[《程序员延寿指南》](https://github.com/geekan/HowToLiveLonger) | 国内有个开发者撰写了一份《程序员延寿指南》，并开源到了 GitHub，希望通过各种数据与研究分析，进一步探索合理且健康的养生之道。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lpap8kkwd)
[Clone Wars](https://github.com/GorvGoyl/Clone-Wars) | 这个 GitHub 项目收录了 100 多个知名网站的克隆项目，包含教程、源码、Demo 演示、技术栈等内容，非常适合开发者研究学习。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lo3FbheLO)
[AI-RecommenderSystem](https://github.com/zhongqiangwu960812/AI-RecommenderSystem) | 一个开源资料库沉淀了作者自学推荐系统的学习经验。其中包括经典算法模型和技术，各类工具、数据集的参考学习，并尝试用浅显易懂的语言，把每个模型或者算法解释清楚。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LnOJJxJzj)
[SpringBootVulExploit](https://github.com/LandGrey/SpringBootVulExploit) | Spring Boot 相关漏洞学习资料，利用方法和技巧合集，黑盒安全评估 check list。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LmrTf0SNM)
[MHDDoS](https://github.com/MHProDev/MHDDoS) | 一个具有 51 种攻击方法的 Python3 DDoS 开源脚本。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LmqIb3WK5)
[Hacking C++](https://hackingcpp.com/cpp/cheat_sheets.html) | 一份颇为全面的 C++ 速查表与信息图表。覆盖了算法、随机分布、序列、Lambda 表达式、设计指南等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lmpx7t0FO)
[Hacking Tool](https://github.com/Z4nzu/hackingtool) | 作者收录了多款与计算机安全相关的开发者工具，包括网络攻击、DDOS 与 XSS 攻击工具、信息收集、SQL 注入、网络爬虫、哈希破解等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LmhjHxoOu)
[Quantitative-analysis](https://github.com/hugo2046/Quantitative-analysis) | GitHub 上关于量化分析的资料参考：Quantitative-analysis，利用 Python 对国内各大券商的金工研报进行复现。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LlfEkpk3b)
[PeiQi-WIKI-Book](https://github.com/PeiQi0/PeiQi-WIKI-Book) | 一个面向网络安全从业者的知识文库 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LkiJejY3Z)
[Chinese voice corpus](https://github.com/fighting41love/zhvoice) | GitHub 上的开源中文语音语料：Chinese voice corpus，让中文语音更加清晰自然。里面包含了 8 个开源数据集，3200 个说话人，900 小时语音，1300 万字。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LkbR1ro7B)
[Awesome Portfolio Websites](https://github.com/smaranjitghose/awesome-portfolio-websites) | GitHub 上的一个开源网站：Awesome Portfolio Websites，致力于帮助研究人员、开发者、分析师建立一个可用于展示多维度工作信息的网站。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LjeJLxVQn)
[《2022 年杭州购房指南》](https://github.com/zkqiang/hangzhou-house-guide) | 一位在杭州工作的程序员，该指南是根据他个人多年购房选房经历，总结而成的一篇买房攻略，涉及新房摇号和二手房选购，包含大量杭州城市规划资料。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LiVSLCDYb)
[Sec-Interview-4-2023](https://github.com/vvmdx/Sec-Interview-4-2023) | GitHub 上的开源技术资料库：Sec-Interview-4-2023，来自一位 2023 届毕业生收集的各大互联网安全面试题、面试经验。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LgnYs5V0I)
[《程序员做饭指南》](https://github.com/Anduin2017/HowToCook) | 详细介绍了地三鲜、回锅肉、鱼香肉丝等十几道菜品的具体料理方法。作者也希望通过开源的方式，让更多人参与到一本菜谱的改进与维护中来。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LgkrguvFT)
[.NET-Backend-Developer-Roadmap](https://github.com/Elfocrash/.NET-Backend-Developer-Roadmap) | 2022 年 .NET 后端开发者路线图，主要面向微服务架构的后端技术人员，完整高清大图可见 GitHub Repo。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lg1Agc8l6)
[AI-Expert-Roadmap](https://github.com/AMAI-GmbH/AI-Expert-Roadmap) | 人工智能技术 2022 年学习路线，完整高清大图在 GitHub Repo 可见。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LeZWU1rDV)
[Time series resources](https://github.com/lmmentel/awesome-time-series) | 时间序列相关的学习资源整理。覆盖多个常用开发者工具、可视化开源库、技术论文、开源教程等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LeXAOC2td)
[AtHomeWithAI](http://t.cn/A6L1qEWP) | Deepmind 发布的人工智能学习资源，包含线性代数、算法、机器学习、深度学习、自然语言处理等各类视频、PPT、指南、教程。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LeRHt42rE)
[Leetcode-retag](https://github.com/resumejob/Leetcode-retag) | 重新分类 Leetcode 高频题，按照面试频率降序排列题目，增加难度分类，适合开发者从简单开始学习算法。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LeMAS52th)
[《命令行速览》](https://github.com/vastutsav/command-line-quick-reference) | 里面总结了 30 多条命令行的基础知识，可帮你快速了解一些常用的命令行用法与开发技巧。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LcHmpq0qt)
[LeetCode 题解仓库](https://github.com/doocs/leetcode) |  GitHub 上一个开源的 LeetCode 题解仓库，里面涵盖了多种编程语言的 LeetCode 代码实现，其中包括排序算法、链表、二叉树、栈和队列、动态规划等算法知识点。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lcvbrol44)
[《Arch Linux 简明指南》](https://github.com/NakanoMikuOrg/arch-guide) | 提供了从 Arch Linux 安装、显卡驱动、日常软件配置、多媒体制作、编程等所有内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LaTpuzDZg)
[《文言文（古文）- 现代文平行语料》](https://github.com/NiuTrans/Classical-Modern) | 基本涵盖了大部分经典古籍著作，原始爬取的数据是篇章级对齐，经过脚本分句以及人工校对，形成共计约 96 万句对，source 下为文言文，target 下为现代文，文件内容按行对齐。| [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LaG3tvogM)
[《深度学习 500 问》](https://github.com/shliang0603/Awesome-DeepLearning-500FAQ) | 国内开发者整理的一份 AI 学习资源，内容以问答形式，对常用的概率知识、线性代数、机器学习、深度学习、计算机视觉等热点问题进行阐述，以帮助有需要的读者。全书分为 18 个章节，50 余万字。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/La5UToCva)


### 书籍/教程

名称 | 简述 | 源
---- | ----- | -----
[《Comprehensive Rust》](https://github.com/google/comprehensive-rust) | Google 开放的一个 Rust 技术教程，教程为期四天，涵盖了 Rust 基本语法到高级主题，如泛型和错误处理、Android 开发等相关内容。通过这一教程，你将全面学习 Rust 基础语法、编写 Rust 应用、掌握 Rust 常用开发技巧等技术。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MlIqyelZv)
[《标准 C++ 算法指南完整版》](https://github.com/HappyCerberus/book-cpp-algorithms) | GitHub 上的开源技术资源：《标准 C++ 算法指南完整版》，覆盖了该书所有相关的 LaTeX 与代码示例讲解，帮助大家更好的学习与总结。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mlg94gQoL)
[《Hello，算法 》](https://github.com/krahets/hello-algo) | 一本自带动画图解、能运行、可提问的数据结构与算法入门书。带你了解刷题所需的数据结构，介绍算法的设计思想、优势劣势、实现方法，并拥有可一键运行的配套代码，让你更好的深入学习算法。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MjTiAlqr0)
[《矩阵力量》鸢尾花书：从加减乘除到机器学习](https://github.com/Visualize-ML/Book4_Power-of-Matrix) | 主要面向开发者，讲解数学的基础知识。按内容划分为基础、坐标系、函数、解析几何、微积分、概率统计、线性代数等 7 大板块。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MhUK8xWzx)
[《像黑客一样使用命令行》](https://github.com/xuxiaodong/usingcli-book) | 该书将从实际的例子出发，教你从无到有，一步一步学习命令行的使用。除了文字版本之外，亦有配套视频。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MgotbfdaD)
[《Stable Diffusion Book》](https://github.com/sudoskys/StableDiffusionBook) | GitHub 上的开源技术教程：《Stable Diffusion Book》，关于 AI 绘画的全面中文 Wiki、入门教程、开源文档。覆盖 AI 绘画相关的术语解释、安装配置、配置与调试、模型训练等相关内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/McZx4g2Ji)
[《机器学习系统：设计和实现》](https://github.com/openmlsys/openmlsys-zh) | GitHub 上的开源技术书籍：《机器学习系统：设计和实现》，主要讲解现代机器学习系统的设计原理和实现经验。该书覆盖编程接口、计算图基本构成、编译器前后端、模型部署、深度学习推荐系统、机器人系统等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mb8PGvAyK)
[《基于物理的渲染：从理论到实现》](https://github.com/kanition/pbrtbook) | GitHub 上的开源教程：《基于物理的渲染：从理论到实现》中文翻译版。主要讲解几何与变换、成像过程、光的散射、光传输算法等计算机图形学内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mb2Wovblc)
[《数据科学路线图》](https://github.com/Moataz-Elmesmary/Data-Science-Roadmap) | GitHub 上的开源学习资料：《数据科学路线图》，作者整理了一些开放性学习教程，并按照初中高级制定了不同学习路线。里面主要包含统计与概率、Python 基础及工具应用、数据清理与可视化、机器学习与爬虫、深度学习与模型等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Mb0YC6Ahe)
[《Enhance Your English Writing》](https://github.com/yzy1996/English-Writing ) | GitHub 上开源的学习资料：《Enhance Your English Writing》，作者是香港城市大学的一名博士生。主要收录他在阅读论文的过程中，发现的一些好的英语用法。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ma8noyjnF)
[《Solidity 极简入门》](https://github.com/AmazingAng/WTF-Solidity) | 每周更新 1-3 讲，主要讲解 Web3 基础开发技巧、合约安全、数字签名、时间锁，常见开发工具使用等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ma4QdwllJ)
[《手撸解释器》](https://github.com/GuoYaxiang/craftinginterpreters_zh) | 在本书中，作者将悉心拆解解释器相关的概念，在每一章节中逐步进行讲解和实现，并且保证每个章节结束之后都有一个可以运行的解释器版本。该书由一门小型的自创语言 Lox 开始，分别使用 Java 和 C 实现了两种类型的解释器，jlox 和 clox。内容上不会有太过深入的理论，对于普通编程爱好者也可以很容易地上手学习。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M9uHEx8Tl)
[《Data Science: Theories, Models, Algorithms, and Analytics》](https://srdas.github.io/Papers/DSA_Book.pdf) | 主要讲解数据科学的基本知识，并覆盖相关常用算法、模型、R 语言、数据分析、金融应用、神经网络等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M7Fnv1EVp)
[《NLP 新手入门指南》](https://github.com/PKU-TANGENT/nlp-tutorial) | GitHub 上开源的学习资源：《NLP 新手入门指南》，项目作者为北京大学 TANGENT 实验室成员。该指南主要提供了 NLP 学习入门引导、常见任务的开发实现、各大技术教程与文献的相关推荐等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M6tkMkriP)
[《Kubernetes 中文教程》](https://github.com/guangzhengli/k8s-tutorials) | GitHub 上的开源技术教程：《Kubernetes 中文教程》，内容偏向于实战进阶。通过带你渐进式修改代码，从最基础的 container 容器的定义开始，经过 pod, deployment, servcie 等资源来打包部署一套完整服务。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M4Msfkw2E)
[现代统计学概论》](https://github.com/openintrostat/ims) | 一本开放性技术书籍：《现代统计学概论》（Introduction to Modern Statistics），主要讲解数据分析理念与应用、回归建模、统计推断、推理建模等相关知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M2nYrA2He)
[《用 Rust 编写一个 JavaScript 编译器》](https://github.com/Boshen/javascript-compiler-in-rust) | JavaScript、Rust 和编译器都很难学，因此作者想将这三者结合起来，挑战自己，用 Rust 编写一个 JavaScript 编译器。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M1uAwaDtr)
[《Rust 性能优化手册》](https://github.com/nnethercote/perf-book) | 该书面向于 Rust 中级和高级开发者用户，结合理论与实践，讲解多种可以提高 Rust 程序性能的技术和技巧（速度和内存使用）。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M1la120wV)
[《线性代数的艺术》](https://github.com/kenjihiranabe/The-Art-of-Linear-Algebra) | GitHub 上的开源技术教程：《线性代数的艺术》，主要针对 MIT 教授 Gilbert Strang 的《Linear Algebra for Everyone》教程提供了图形注释，让知识更易于吸收理解。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M16CUBr8Q)
[《系统设计》](https://github.com/codersguild/System-Design) | GitHub 上开源的技术学习资源：《系统设计》，里面主要整理了系统设计相关的基础知识、面试技巧、开发指南、最佳实践，以及各个互联网大厂的踩坑经验总结等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M05nUrVPg)
[《带你入门前端工程》](https://github.com/woai3c/introduction-to-front-end-engineering) | 分享一本开源的前端技术书籍：《带你入门前端工程》，主要记录作者在近两年来，在前端工程师实践经验和学习心得方面的总结。 书中大部分内容以理论知识 + 代码示例 + 图片进行讲解，部分章节会提供实践教程。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LFgyIa9dz)
[《数据科学工具学习指南》](https://github.com/shervinea/mit-15-003-data-science-tools) | 麻省理工大学教授在 GitHub 开源的：《数据科学工具学习指南》。主要讲解如何使用 SQL 检索数据，R 语言操作数据，Python 数据可视化，Git 代码版本控制，以及常见的 Bash 脚本使用技巧等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LEcxdvgtN)
[《语音增强初探》](https://github.com/WenzheLiu-Speech/The-guidebook-of-speech-enhancement​) | GitHub 上的开源技术教程：《语音增强初探》，主要讲解语音增强技术相关的技术解析，以及模型应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LE5sQFN7t)
[《操作系统导论》中文版](https://github.com/remzi-arpacidusseau/ostep-translations) | 该书共有 50 个章节，内容深入浅出，围绕操作系统的虚拟化、并发、持久性展开讲解，涉及进程与进程、锁、CPU 调度、文件系统实现、分布式系统等知识点。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LE1xicqHI)
[《Some Assembly Required》](https://github.com/hackclub/some-assembly-required) | GitHub 上一本开源的汇编入门指南：《Some Assembly Required》，主要包括 CPU 工作原理、指令映射、汇编语言与寄存器入门知识介绍等内容。每个章节都比较简短，且配有作者绘制的原理图与代码示例。让技术更易于理解，加深学习印象。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LDlvqFy2g)
[《Effective Debugging》中文翻译版](https://github.com/Celthi/effective-debugging-zh) | GitHub 上的开源技术教程：《Effective Debugging》中文翻译版，主要讲述如何更有效率地调试大型程序（以 C/C++ 为例）的方法和技能。书中例子不仅丰富，而且都是从实际的工作经验提取，观点和方法有效且具有可行性。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LDhYfguVU)
[《BasicSR 中文解读文档》](https://github.com/XPixelGroup/BasicSR-docs) | BasicSR 是一个基于 PyTorch 的开源图像视频复原工具箱，提供了诸如超分辨率、去噪、去模糊、去 JPEG 压缩噪声等功能。该文档提供了关于图像、视频超分复原增强等相关技术知识的解读，以及开源库的使用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LCPGL2v8u)
[《动手构建一个简单数据库》](https://github.com/cstack/db_tutorial) | 作者将基于 C 语言，手把手构建一个类 SQLite 数据库，让你进一步了解数据库的工作原 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LBu1lhaYT)
[《Rust 语言实战》](https://github.com/sunface/rust-by-practice) | 该书将通过有挑战性的示例、练习题、实践项目来提升 Rust 水平，建立从入门学习到上手实战的直通桥梁。书中通过大量的实战练习，帮助大家更好的学习和上手使用 Rust 语言。书中的练习题非常易于使用：你所需的就是在线完成练习，并让它通过编译。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LBrFem2gX)
[《概率数值》](https://www.probabilistic-numerics.org/assets/ProbabilisticNumerics.pdf?continueFlag=1bafdcd5c034def869fecb4f3bdaed70) | 一本免费开放的技术书籍：《概率数值》（Probabilistic Numerics），共 400 多页，由 3 位来自各大高校与行业专家作者，历经 7 年写成。该书主要讲解数学基础、线性代数、积分、概率数值、机器学习模型优化、常微方程解法等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LB9Zj88Qd)
[《动手学习数据可视化》](https://github.com/handsondataviz/book) | GitHub 上的开源技术教程：《动手学习数据可视化》，主要讲解 Excel 数据处理的常用技巧。数据清理、搜索、可视化，数据图表绘制，第三方开源库的开发指南等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LB45Yt7Mj)
[《Python 项目实战》](https://github.com/learnbyexample/practice_python_projects) | 作者将通过 5 个 Python 实战项目，带你一步步了解 Python 的实际应用。其中包含用 Python 计算器优化命令行工具体验、抓取并分析 Reddit 评论数据、扫描 Markdown 和纯文本拼写错误、构建多选择题 GUI 界面、借助 AI 打造一款小游戏。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LATupt21d)
[《2022 年开源操作系统训练营》](https://github.com/LearningOS/rust-based-os-comp2022) | 教程共分为八章，主要展示如何从零开始，用 Rust 语言写一个基于 RISC-V 架构的 类 Unix 内核 。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LAK3UD6yJ)
[《谷歌的软件工程》](https://github.com/qiangmzsx/Software-Engineering-at-Google) | GitHub 上的开源技术资源：《谷歌的软件工程》中文版（Software Engineering at Google），共 25 章，主要讲解 Google 技术团队在「软件工程」领域的实践。该指南覆盖了团队管理、效率测量、代码风格规范、项目测试、版本控制、静态分析、依赖管理、持续交付与集成等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LzPuW8TUC)
[《图解 React 源码系列》](https://github.com/7kms/react-illustration-series) | 作者将尝试通过大量配图，把 react 原理表述清楚。教程主要包含 React 基础概念、运行核心、数据管理、交互、高频算法等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lyif5kWmX)
[《英语论文写作指南》](https://github.com/OpenMindClub/awesome-scholarly-productivity) | 由阳志平团队整理发布。里面包含科技论文制图、数学公式排版、文献分析工具介绍、论文发表技巧、写作工具等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LxY0T5643)
[《Web3 科学家极简入门指南》](https://github.com/gm365/Web3_Tutorial) | 通过学习并使用 Web3.py 模块，实现链上数据查询、转账、合约交互等简单功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LxN0XdUfZ)
[《IPv6 简明指南》](https://github.com/tmplink/ipv6) | GitHub 上的开源学习资源：《IPv6 简明指南》，主要讲解 IPv6 的基础知识，让你进一步理解 IPv6 地址的常见概念，如前缀、子网、接口等。作者还会通过图文说明，带你了解家用场景下的 IPv6 实战。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lwvtf9MlN)
[《C++ Primer 中文版（第 5 版）》](https://github.com/applenob/Cpp_Primer_Practice) | GitHub 上的开源学习资料：《C++ Primer 中文版（第 5 版）》学习仓库，整理了关于此书的笔记和课后练习答案。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lwu62CRVR)
[《基于 JavaScript 的区块链、Solidity、Web3 全栈开发教程》](https://github.com/smartcontractkit/full-blockchain-solidity-course-js) | 通过这个教程，你将学到关于区块链、Web 开发、智能合约、密码学、NFT 等各类技术栈原理与应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LvAI6fRsp)
[《从零开始的 Kubernetes 攻防》](https://github.com/neargle/my-re0-k8s-security) | GitHub 上的开源技术资源：《从零开始的 Kubernetes 攻防》，主要讲解云原生技术的一些攻防技巧。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LuwICnn70)
[《从零开始制作一个操作系统》](https://github.com/yanull/os-guide-cn) | GitHub 上的开源技术教程：《从零开始制作一个操作系统》，教程比较简短，内容讲解不太详细，适合有一定技术基础的人学习。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LtKp6fK6B)
[MLOps Zoomcamp](https://github.com/DataTalksClub/mlops-zoomcamp) | 一份 MLOps  教程，主要讲解 MLOps 基础知识、MLflow 入门、模型部署、模型监控、开发运维、CI/CD、机器学习画布等知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LtzNy6HgN)
[《现代 JavaScript 教程》](https://zh.javascript.info/) | GitHub 上一本开源的 JavaScript 教程，作者将以最新的 JavaScript 标准为基准。通过简单但足够详细的内容，为你讲解从基础到高阶的 JavaScript 相关知识。教程划分为 3 部分，涵盖了 JavaScript 编程语言相关知识和浏览器行为。此外还有正则表达式、动画效果等一系列专题文章。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](javascript-tutorial/en.javascript.info)
[SQLBolt](https://sqlbolt.com/) | 一个 SQL 技术教程：SQLBolt，作者提供了一系列交互式 SQL 教程，共 20 个章节，以及课后作业，帮你快速掌握与运用 SQL 开发。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LsyaacOUC)
[《The Kaggle Book》](https://github.com/PacktPublishing/The-Kaggle-Book) | GitHub 上的开源技术书籍：《The Kaggle Book》，Kaggle 是一个知名的科学竞赛平台，不少开发者会通过参加 Kaggle 上的竞赛，快速提升自己的编码经验。通过这本书，你将熟悉 Kaggle 平台的使用、了解不同建模任务（包括对象检测、NLP、时间序列），进一步学习充分利用 Kaggle Notebook、数据集和论坛来提升个人能力。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)]()
[《动手学习深度学习 - 视频笔记》](https://github.com/HIT-UG-Group/DeepLearning-MuLi-Notes) | 课程视频共 73 节，单个视频平均时长不超过 30 分钟。课程既包含少量的机器学习的基础知识；又有如今前沿应用的 各种深度学习模型，同时每一章节的讲解还配备由 pytorch 实现的代码、教科书等等。该课程可帮助同学在短期内，掌握深度学习的基础模型与前沿知识和并提高实践能力。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LrkKblDb4)
[《给数据科学家看的 SQL 教程》](https://github.com/DataWithDanny/sql-masterclass) | GitHub 上的开源技术教程：《给数据科学家看的 SQL 教程》，作者将基于一个加密货币交易数据库，带你了解 SQL 的常见用法。该教程共分为 13 个章节，每个章节作者都会提供不少习题与答案，以便大家训练学习。 ​​​ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LqFv23rZN)
[《树莓派编程实用教程》](https://github.com/wxlscm/raspberry_tutorial) | 全书共 31000 字，提供 20 多个树莓派应用实例，适合想在树莓派开发项目的工程师、学生参考学习。此外，该书还涵盖 Python，Linux 命令，C/C++，OpenCV，Darknet 等相关知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LqyqFDhTZ)
[《深度强化学习教程》](https://github.com/huggingface/deep-rl-class) | Hugging Face 在 GitHub 开源了一个《深度强化学习教程》，在该教程中，你将通过理论+实践的方式，了解深度强化学习相关的开源库、开发工具、项目发布等基础知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lqw4xfHVq)
[《语音合成：从入门到放弃》](https://github.com/cnlinxi/book-text-to-speech/releases) | 该书主要介绍当前语音合成技术的发展历史、开源资料、详解语音特征提取、声学模型、语音合成知识结构等技术，感兴趣的同学可以看一下。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LmnXId8oh)
[《用 Rust 开发一个操作系统》](https://github.com/phil-opp/blog_os) | 通过这个教程，你将学习如何使用 Rust 来编写一个操作系统，每篇文章都是一个小教程，并且包含了所有代码，你可以跟着一起学习。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LlaxJaW4P)
[《蘑菇书 EasyRL》](https://github.com/datawhalechina/easy-rl) | GitHub 上的深度学习技术书籍，覆盖了强化学习、马尔可夫决策过程、策略梯度、模仿学习等多个知识点。该教程也称为 “蘑菇书”，寓意是希望此书能够为读者注入活力，让读者 “吃” 下这本蘑菇之后，能够饶有兴致地探索强化学习，像马里奥那样愈加强大，继而在人工智能领域觅得意外的收获。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LkRGJpxjI)
[《Rust 从零开发到上线》](https://github.com/LukeMathWalker/zero-to-production) | ，该项目主要教你如何通过 Rust 来开发一个后端 API 项目。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LkjUiwhs3)
[《Rust 异步编程指南》](https://github.com/sunface/async-book) | GitHub 上的开源技术教程：《Rust 异步编程指南》，高质量手翻官方的 Async Book， 是一本非常好的异步编程学习使用教程。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lk6yfrfK8)
[《代码整洁之道》](https://github.com/JuanCrg90/Clean-Code-Notes) | 主要讲解如何编写干净、整洁的代码，合理定义代码名称、单元测试、项目数据结构等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lk16iblci)
[《机器学习系统：设计和实现》](https://github.com/openmlsys/openmlsys-zh) | 主要讲解现代机器学习系统的设计原理以及实现经验。覆盖了编程接口、计算图、编译器前后端、数据处理、模型部署、分布式训练等知识点。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LjbZgE85C)
[《区块链开发指南》](https://github.com/dcbuild3r/blockchain-development-guide) | 一个挺有意思的公益性技术教程，该教程主要讲解 Web 前后端开发、以太坊基础、智能合约、密码学、数据分析等知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lj6ujqM5Y)
[《Rust 数据结构与算法》](https://github.com/QMHTMY/RustBook) | 共分九章，主要介绍计算机科学、基本数据结构与算法分析、递归、查找、排序等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LiMsg7ZgN)
[《Python 设计模式》](https://github.com/faif/python-patterns) | 作者通过编码实现，为多种 Python 设计模式提供了代码参考示例。除了代码之外，项目中还收录了有关 Python 设计模式的视频讲解，适合配套学习。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LiEcOErVK)
[《Rust 练习实践》](https://github.com/sunface/rust-by-practice) | 该教程将通过简单到困难的代码示例，让你学习如何基于小型项目来练习和实践 Rust。目前有提供中、英文两个版本。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LiBQHpvtu)
[《Linux 系统操作手册》](https://github.com/abarrak/linux-sysops-handbook) | 主要介绍了 Linux 系统常用的管理技术与运维工具。书中包括系统用户权限管理、Shell 使用技巧、文件权限设置、后台管理任务设置、日志记录的监控与分析等知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LiuMkmPQm)
[db-tutorial](https://github.com/dunwu/db-tutorial) | 一份数据库相关学习教程，里面含有 MySQL、NoSQL、MongoDB、Elasticsearch、Redis 等学习教程，其中 MySQL 与 Redis 提供了思维导图对学习重点内容进行梳理，以便大家更好学习理解。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LhUrzumpt)
[《NLP 中文学习笔记》](https://github.com/DengBoCong/nlp-paper) | 作者是来自华中科技大学的硕士生，里面主要记录了一些作者在学习过程中阅读过且感觉不错的论文。对于一些经典或思路很新奇的论文，作者会进行精读，并写一些阅读笔记同步上传更新。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LgP4SebE6)
[《深度强化学习：基础、研究与应用 》](https://deepreinforcementlearningbook.org/) | 一本开放的 AI 技术教程，作者为北大助理教授董豪博士。书中主要讲解深度学习入门知识、常用算法、科技前沿研究方向、实际生活应用等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LgiRPEfVn)
[《代码分析与自动化重构》](https://github.com/modernizing/modernization) | GitHub 上的开源技术教程：《代码分析与自动化重构》，主要讲解如何自己动手设计源码解析、构建代码的代码模型、可视化代码、以及进行自动化的重构和守护。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lg57riuYq)
[《概率机器学习》](https://github.com/probml/pml-book) | 作者是 Google 的研究科学家 Kevin P Murphy。来自微软、斯坦福、哈佛等各路大佬对本书的评价如下："这是一本了不起的书，涵盖了概率机器学习的概念、理论和计算基础，从基础开始，无缝过渡到该领域的前沿" | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lg00QipDU)
[《机器人 501：机器人数学》](https://github.com/michiganrobotics/rob501) | 该教程主要是为机器人工程师讲解应用数学相关知识，同时也被用于密歇根大学的研究生教学。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LcRXXkIXb)
[《Everything curl》](https://github.com/bagder/everything-curl/) |  GitHub 上一本开源技术教程，里面讲述了 curl 项目、命令行工具、开发库的发展历史及技术原理。除此之外，你还可以从中学习到网络协议、命令行工具开发、开源项目维护、软件架构等扩展知识，非常值得一读。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LcO2qdbkh)
[《笨方法学 Go 泛型》](https://github.com/akutz/go-generics-the-hard-way) | GitHub 上的 Go 语言开源技术教程，主要包括开发环境安装、Hello World 示例、Go 泛型介绍及代码实现等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lcnkm9qo2)
[《静态程序分析入门》](https://github.com/RangerNJU/Static-Program-Analysis-Book) | 作者将手把手教你编写一个静态程序分析器。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lc3ij614A)
[《用 90 天学 DevOps》](https://github.com/MichaelCade/90DaysOfDevOps) | 里面记录了国外一名开发者学习 DevOps 的 90 天历程。内容包括 DevOps 定义、Linux 基础知识、计算机网络、k8s 及容器的使用、自动化配置管理、日志监控管理与数据可视化等知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LbK2WhptF)
[《Python 中的统计学与机器学习》](https://github.com/duchesnay/pystatsml) | GitHub 上开源人工智能技术教程，主要讲解 Python 基础语法、数据处理以及数据可视化、多元统计、线性代数、特征提取、卷积神经网络等知识点。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LbwiziB52)
[《Rust语言圣经》](https://github.com/sunface/rust-course) | GitHub 上开源的 Rust 中文技术教程，主要包含 Rust 开发环境安装、语法基础入门与高级进阶、异步编程、代码最佳实践、错误处理等内容，对 Rust 进行了全面且深入的讲解。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LblGZkRNB)
[EasyRL](https://github.com/datawhalechina/easy-rl) | GitHub 上开源的 AI 强化学习中文教程，主要包含了强化学习概述、马尔可夫决策过程 、表格型方法、策略梯度、模仿学习等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lb1EWpbwm)
[《算法通关手册》](https://github.com/itcharge/LeetCode-Py) | 提供了超详细的「算法与数据结构」基础讲解教程，「LeetCode」650+ 道题目 Python 版的详细解析。该教程将通过「算法理论学习」和「编程实战练习」相结合的方式，带你从零基础到彻底掌握算法知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LaYUtwaCE)
[《深度学习面试》](https://github.com/BoltzmannEntropy/interviews.ai) | 全书近 400 页，收录了数百道深度学习面试题与答案，附带有精美的插图和图表。该书主要讲解微积分、贝叶斯深度学习、特征提取、逻辑回归等内容，附有 PyTorch、Python 和 C++ 代码示例。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Larea65be)
[《JavaScript 30 天编程挑战》](https://github.com/Asabeneh/30-Days-Of-JavaScript) | 一个前端开源技术教程，作者提供了一个可循序渐进的前端开发指南，带你一步一步入门 JavaScript 开发。内容主要包括前端开发环境配置、VSCode 代码编辑器使用介绍、JavaScript 语法基础、JSON 处理、DOM 对象操作、数据可视化项目编写等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/La4lu6yhC)
[《开源软件指南》](https://github.com/github/opensource.guide) | GitHub 官方发布的一套技术文档：《开源软件指南》，有多个语言版本。主要讲解如何启动一个开源项目、项目维护的最佳实践，怎么通过开源工作获得经济报酬等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L9dI2pSpQ)


### 机器学习/人工智能

名称 | 简述 | 源
---- | ----- | -----
[Paper Picture Writing Code](https://github.com/MLNLP-World/Paper-Picture-Writing-Code) | GitHub 上开源的 LaTeX 画图代码库。里面包含了几种 AI 论文中常用的画图代码，如折线图、柱状图、散点图、注意力可视化以及结构图等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MbcmRFfDL)
[PaddleHub](https://github.com/PaddlePaddle/PaddleHub) | 百度在 GitHub 上开源的一款预训练模型工具包：PaddleHub，涵盖了大模型、CV、NLP、Audio、Video、工业应用等 400+ 预训练模型，代码全部开源，离线可运行。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M5Ici3sxr)
[AiLearning-Theory-Applying](https://github.com/ben1234560/AiLearning-Theory-Applying) | GitHub 上一个开源的 AI 知识库，主要帮助开发者快速上手 AI 理论及应用实战，基础知识、机器学习、深度学习、自然语言处理 BERT，含大量注释及数据集，力求每一位能看懂并复现。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LFfMNz3bo)
[Dot](https://github.com/sensity-ai/dot) | 是 GitHub 上一个开源的 Deepfake AI 换脸攻击工具包。针对身份验证、视频会议系统等渗透测试工作而生，可供安全分析师、红队成员和生物识别研究人员使用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LB8pSEYV1)
[ClearML](https://github.com/allegroai/clearml) | GitHub 上一个开源的机器学习工具包：ClearML，自带简洁美观的可视化界面。该工具可用于简化机器学习开发、运维流程，自动完成实验跟踪与结果记录，并提供了灵活多变的数据管理方案。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LyLvv9lJn)
[Image-Processing-Node-Editor](https://github.com/Kazuhito00/Image-Processing-Node-Editor) | 日本开发者在 GitHub 开源的一款图像处理节点编辑器，通过该工具，可以辅助并完成深度学习的各项图像处理工作，快速验证、对比各个图像在不同条件下的执行结果。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ly9NtmoMG)
[BEVFormer](https://github.com/zhiqi-li/BEVFormer) | GitHub 上一套开源的环视物体检测方案：BEVFormer，实现了在鸟瞰图视角下的特征优化，可应用于汽车自动驾驶场景。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LxZbW6AGc)
[Paper2GUI](https://github.com/Baiyuetribe/paper2gui​​​) | 一款面向普通人的 AI 桌面 APP 工具箱，开箱即用，非常方便，已支持 15+ AI 模型，内容涵盖语音合成、视频补帧、视频超分、目标检测、图片风格化、图片 OCR 识别等领域，兼容 Windows、Mac、Linux 等主流操作系统。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LwMX2DEr6)
[FinRL](https://github.com/AI4Finance-Foundation/FinRL) | GitHub 上一个开源的量化金融自动交易框架：FinRL，附带有完整的深度学习、量化交易技术教程。项目覆盖了各类常用市场，并提供先进的算法核心，支持各种金融任务（投资组合分配、加密货币交易、高频交易）、实时交易等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LwDwv9lEw)
[internet-dataset](https://github.com/RimoChan/internet-dataset) |这个 GitHub 仓库收录了各种通过搜索引擎获取的数据集，整体数据量将近 50G，其中包括域名、网页、反向索引等数据。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lvzx3kXBi)
[Energon-AI](https://github.com/hpcaitech/ColossalAI) | GitHub 上一个开源的大模型推理系统：Energon-AI。仅需对现有项目进行极少量修改，即可完成自定义大模型的推理部署，获得并行扩展的超线性加速。对于 AI 大模型分布式推理加速，相比英伟达 FasterTransformer 可提升 50% 以上。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LvvNF8glt)
[Colossal-AI](https://github.com/hpcaitech/ColossalAI) | 国人在 GitHub 开源的一个项目：Colossal-AI，仅需极少量修改，即可让现有深度学习项目，在单张消费级显卡上，完成大模型训练，极大降低了项目研发成本！简而言之，有了这个开源项目后，每个人都可以在家训练 AI 大模型！尤其是大幅度降低了 AI 大模型微调、推理等下游任务和应用部署的门槛。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LtnCy6sQH)
[Gradio](https://github.com/gradio-app/gradio) | GitHub 上这个名为 Gradio 的开源项目，可在短短几分钟内，为机器学习模型生成一个简洁、优雅的 UI 界面，让你能在浏览器中进行项目演示。通过该界面，你可以完成拖拽上传图像、粘贴文本、声音录制等操作，并查看模型输出内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lr25mDzFw)
[nlp-paper](https://github.com/DengBoCong/nlp-paper ) | 字节跳动工程师在 GitHub 上整理的 NLP 论文列表（附阅读笔记），收录了一些比较经典或思路新奇的论文。其中包含 NLP 领域下的对话语音领域，复现模型以及数据处理等（代码含 TensorFlow 和 PyTorch 两版本） | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LqHRacIRL)
[Goopt](https://github.com/jokenox/Goopt) | 国外有位开发者基于 GPT-3 做了一款 AI 搜索引擎：Goopt，通过该搜索引擎检索到的所有内容，全部都是由 AI 和算法合成的。你可以在上面搜索任意术语，以获取相关结果与内容。通过这种方式，进一步模拟网页浏览体验 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LqDVBBooN)
[AI-Paper-Collector](https://github.com/MLNLP-World/AI-Paper-collector) | GitHub 上一个开源的 Python 脚本：AI-Paper-Collector，可用于查找包含指定关键词的顶会论文列表，涵盖了 2019-2021 自然语言处理，计算机视觉，信息检索等领域的顶会论文。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lq7keozHW)
[ChineseLyrics](https://github.com/dengxiuqi/ChineseLyrics) | GitHub 上开源的中文歌词数据库，作者收录了 10W+ 首歌词数据，给做 NLP 和数据分析领域的朋友们提供参考。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LpWIF3AXx)
[ROS-Face](https://github.com/maHidaka/ros_face) | 一个挺有意思的开源项目。作者希望通过 ROS（机器人操作系统）来控制人脸面部表情，让面部动作听从机械指令  | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lp7EEn4EN)
[nlp-notebook](https://github.com/jasoncao11/nlp-notebook) | GitHub 上开源的 NLP 领域常见任务的实现：nlp-notebook，包括新词发现、以及基于 PyTorch 的词向量、中文文本分类、实体识别、摘要文本生成、句子相似度判断、三元组抽取、预训练模型等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LoicfBjgt)
[funNLP](https://github.com/fighting41love/funNLP) | 几乎最全的中文 NLP 资源库。包括中英文敏感词、语言检测、中外手机 / 电话归属地 / 运营商查询、名字推断性别、手机号抽取、身份证抽取等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lo6pE6Y8x)
[Colossal-AI](https://github.com/hpcaitech/ColossalAI) | GitHub 上一个增长迅猛的国产 AI 开源项目：Colossal-AI，可用于 AI 大规模并行训练，仅需一半数量的 GPU，便能完成相同效果的 GPT-3 训练工作，极大降低了项目研发成本！ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LnUeFy3vP)
[NeuralSpeech](https://github.com/microsoft/NeuralSpeech) | 微软亚洲研究院在 GitHub 开源的一个项目：NeuralSpeech ，提供了基于神经网络的语音处理，包括自动语音识别（ASR）、文本转语音（TTS）等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ll1zDmhT5)
[virtual_try_on_use_deep_learning](https://github.com/hpc203/virtual_try_on_use_deep_learning) | 使用深度学习算法实现虚拟试衣，结合了人体姿态估计、人体分割、几何匹配和 GAN，四种模型，只依赖 opencv 库就能运行。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LklhwuxuG)
[ml4a](https://github.com/ml4a/ml4a) | 如果你正在尝试用 AI 来进行艺术创作，那么可以看下 ml4a 这个开源 Python 库。作者通过代码封装的方式，将 AI 艺术创作类的开源项目整合到了一起，包括图像风格迁移、基于素描的图像生成、图片分辨率增强、图像卡通话等模型。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LiX3Pbnan)
[《AI as an API》](https://github.com/datastaxdevs/workshop-ai-as-api) | GitHub 上的人工智能技术教程：《AI as an API》，主要讲解如何基于 NLP 技术，开发一个文本分类器，并进行持续化数据存储，封装成 API。教程学习时长，约为 50 分钟左右，适合在工作之余的闲暇时间动手学习。 ​​​ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LiUHHaTGV)
[FastFold](https://github.com/hpcaitech/FastFold) | GitHub 上开源了一套训练推理加速方案，通过引入 GPU 优化和大模型训练技术，可将 AlphaFold 总体训练时间 从 11 天减少到 67 小时，且总成本更低，在长序列推理中也实现 9.3 ∼ 11.6 倍提升，加速效果颇为显著。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LiAhibPFD)
[Colossal-AI](https://github.com/hpcaitech/ColossalAI) | 国人在 GitHub 开源的一个深度学习系统：Colossal-AI，可用于 AI 大规模并行训练。仅需一半数量的 GPU，便能完成相同效果的 GPT-3 训练工作，极大降低了项目研发成本！ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lgsil82Rz)
[SofGAN](https://github.com/apchenstu/sofgan) | 作用是可通过计算机视觉和模式识别技术，生成一张支持风格动态调整的人物肖像。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LcGblczJr)
[Hugging Face](https://github.com/) | Hugging Face 对外开放的机器学习任务列表，可以说整理的非常全面了。里面覆盖了自然语言处理、音频、计算机视觉等多个分类，其中包括掩蔽语言填充、智能问答、文本分类、文本翻译、语音识别、图像分割和物体检测等任务。每个任务都附有相对应的使用场景介绍、实际案例、学习指南、模型、数据集等资源。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lcz6XyeZ9)
[NeRF](https://github.com/NVlabs/instant-ngp) | 一款 AI 模型，可借助人工智能技术，把多张 2D 图片进行拼接，进而生成该图片的 3D 模型。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LbExZlG9Q)
[annotated_latex_equations](https://github.com/synercys/annotated_latex_equations) | GitHub 上一个开源的 LaTeX 示例库，教你如何使用 Tikz 创建彩色的 LaTeX 注释，让论文变得更为简洁与美观。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LaINX18aQ)
[动漫肖像魔法](https://waifulabs.com/) | 来自麻省理工大学的工作室 sizigi，发布的一款很有意思的 AI 工具，你可以通过选择头像、滤镜、风格、动作等 4 个步骤，来定制一个专属的二次元老婆 / 老公 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LaHCTp6gA)
[ddddocr](https://github.com/sml2h3/ddddocr) | 一个开源的中文 OCR 通用验证码 Python 识别库，通过大批量生成随机数据，并进行深度网络训练，帮助厂商检验自家验证码的难易强度。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/La75XeXlc)

### 开源字体

名称 | 简述 | 源
---- | ----- | -----
[「得意黑 Smiley Sans」](https://github.com/telier-anchor/smiley-sans) | GitHub 上的中文开源字体：「得意黑 Smiley Sans」，一款在人文观感和几何特征中寻找平衡的中文黑体。整体字身窄而斜，细节融入了取法手绘美术字的特殊造型。字体支持简体中文常用字（覆盖 GB 2312 编码字符集）、拉丁字母、日文假名、阿拉伯数字和各类标点符号。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/MfMLbxreE)
[《辰宇落雁體》](https://github.com/Chenyu-otf/chenyuluoyan_thin) | GitHub 上又一款开源中文字体：《辰宇落雁體》，由刘韦辰和王立宇两名同学联合创作，并基于 OFL 1.1 开源。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M19npcwCE)
[方舟像素字体](https://github.com/TakWolf/ark-pixel-font) | GitHub 上又一款开源的像素风字体：泛中日韩像素字体。支持 10、12 和 16 像素。目标是为开发「像素风游戏」，提供一套开箱即用的字体解决方案。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LuDUBmldF)
[煮豆黑体 Zhudou Sans](https://github.com/Buernia/Zhudou-Sans) | 一款开源的中文字体，支持中日韩标点、全角字母、全角数字及一些特殊符号。标点造型主要来源于 Noto Sans，可以为类似风格的西文字体带来更加协调的中外文混排效果。​​ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lp9e496zx)
[「繁媛黑體」](https://github.com/ayaka14732/FanWunHak) | 一款开源的繁体字体，基于「源样黑体」进行开发设计，整体风格看起来清晰自然，还能满足 "一简对多繁" 的需求。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ll52NDdH7)


### 其他

名称 | 简述 | 源
---- | ----- | -----
[「中国传统色彩」](https://github.com/reorx/cht-colors) | 一个记录了「中国传统色彩」配色的网站，网站代码已在 GitHub 开源。该网站提供了各个色彩的常用名称、别名、RGB 与 HEX 值。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M4D1KbSaY)
[Fluent Emoji](https://github.com/microsoft/fluentui-emoji) | 微软开源的一套简洁、友好、可爱的 Emoji 表情包，基于 MIT 协议开源。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/M2p9tv65f)
[Logto](https://github.com/logto-io/logto) | GitHub 上一个开源的用户登录认证系统：Logto，可在几分钟内，帮你快速构建完整的用户身份及登录体系。项目自带基于 OIDC 的身份服务，支持多个社交平台的登录集成，开箱即用，拥有丰富的图形化管理界面，另外还提供邮箱、短信等多种认证方式。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LCO7kArvE)
[GDevelop](https://github.com/4ian/GDevelop) | 一个开源的跨平台游戏开发引擎，可帮助不懂编程的设计师，快速开发一款能够满足移动端、桌面端、Web 端的游戏。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LB2qwByCQ)
[GreaterWMS](https://github.com/Singosgu/GreaterWMS) | 一个开源的仓储管理系统：GreaterWMS，拥有报表中心、财务中心等系统，支持货物管理、人员管理、订单管理等功能，适可用于多种成品管理环节的货物管理。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LvxaVcMd4)
[Windmill.dev](https://github.com/windmill-labs/windmill) | 一个开源的 OSS 开发者平台。通过编写少量 Python 和 Typescript 脚本，便可快速构建出生产级、多步骤的自动化应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LsnyCFb37)
[SVG Silh](https://svgsilh.com/) | 一个基于 CC0 协议开放的 SVG 素材网站，上面收录了诸多 SVG 图像与图标，所有素材均可免费商用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lrp45CYgH)
[StreamX](https://github.com/streamxhub/streamx) | 一个神奇的开源框架，让流处理更简单。该框架规范了项目配置，鼓励函数式编程，定义了最佳的编程方式，提供了一系列开箱即用的 Connectors。标准化了配置、开发、测试、部署、监控、运维的整个过程，提供了 Scala/Java 两套 API，最终目的是打造一个一站式大数据平台，流批一体，湖仓一体的解决方案。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lrjz8mjH6)
[Kestra](https://github.com/kestra-io/kestra) | 一个可扩展性极强的开源编排和调度平台，可快速创建、运行、调度和监控数百万个复杂管道。支持任意类型的工作流程，易于上手学习，支持从 API、调度、检测、事件来触发执行，可通过界面直接配置流程。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LpjPBuoJf)
[Cook](https://github.com/YunYouJun/cook) | 国内开发者开源的一个菜谱网站：Cook，可自动将各种食材进行组合，生成对应的菜谱，并配套有视频教程。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LpcLeEUNS)
[Cytopia](https://github.com/CytopiaTeam/Cytopia) | 一款具有像素艺术风格的开源城市模拟器，基于 JSON 的自定义 UI 系统，可灵活定制，并通过程序生成多种地形，模拟城市构建。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lp29H5jap)
[elest.io](https://elest.io/) | 在 Hacker New 上看到的一项开源软件托管服务，可在几分钟内，快速部署 150 多种开源软件。此外，该平台还会帮作者处理后续的软件安装、配置、加密、备份、系统更新、实时监控等工作，并将 10% 的收入跟开源作者共享。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LletgqaSO)
[《绝版游戏保护工程》](https://github.com/skywind3000/preserve-cd) | 收录了多款堪称经典的小游戏，让你重回童年。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LgDifjm5j)
[sha256algorithm](https://github.com/dmarman/sha256algorithm) | 这个 GitHub 项目通过可视化的方式，让你更为直观的理解 SHA256 算法原理。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Lf1k8Carf)
[Cubic 11](https://github.com/ACh-K/Cubic-11) | 一个开源的中文字体，像素风，可用于各类游戏及美术作品，支持商用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LcQMTlANS)
[吃掉小鹿乃](https://github.com/arcxingye/EatKano) | 国内开发者做的一款摸鱼小游戏：吃掉小鹿乃。玩家需要在 20 秒内，尽可能点掉更多鹿乃头像。目前该游戏浏览量已突破 1000 万，主要用于训练手指灵活度和反应能力 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LcwKQmBEJ)
[Homelab](https://github.com/khuedoan/homelab) | 由越南一位程序员小哥在 GitHub 开源的家用自托管基础设施，支持自动配置、操作和更新各类自托管服务，可用于打造自己的家庭开发实验室。其中包括代码自托管、证书管理、CI/CD 持续集成与交付、K8s 自动化安装和管理、实时聊天系统、应用监控面板等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LcgfZ3rHA)
[Kvrocks](https://github.com/KvrocksLabs/kvrocks) | 一个开源的 NoSQL 数据库，基于 RocksDB 并兼容 Redis 协议，磁盘类型的 Redis 为降低存储成本而生，存储成本可以降到 Redis 的 1/10 以上。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/LbDmVs22N)

## 声明
[![](https://licensebuttons.net/l/by-nc-nd/4.0/88x31.png)](https://creativecommons.org/licenses/by-nc-nd/4.0/deed.zh)  
本作品采用[知识共享署名-非商业性使用-禁止演绎 4.0 通用许可协议](https://creativecommons.org/licenses/by-nc-nd/4.0/deed.zh)进行许可。
