<p align="center">
  <img src="https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/githubdaily_brand.png">
</p>

<p align="center">
  <a href="https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/weixin.png"><img src="https://img.shields.io/badge/ GitHubDaily-公众号-brightgreen.svg" alt="WeChat"></a>
  <a href="https://weibo.com/GitHubDaily"><img src="https://img.shields.io/badge/%E6%96%B0%E6%B5%AA-%E5%BE%AE%E5%8D%9A-red" alt="Weibo"></a>
  <a href="https://www.zhihu.com/people/githubdaily"><img src="https://img.shields.io/badge/%E7%9F%A5%E4%B9%8E-blue" alt="Zhihu"></a>
  <a href="https://github.com/GitHubDaily/GitHubDaily/stargazers"><img src="https://img.shields.io/github/stars/GitHubDaily/GitHubDaily" alt="GitHub stars"></a>
</p>

## 宗旨

多年以前，我曾看到 GitHub 开源项目作者、全栈工程师 TJ Holowaychunk 说过这么一句话：

"I don't read books, never went to school, I just read other people's code and always wonder how things work"。

从那时起，我便认为，通过阅读源码，站在前辈的角度上，去思考代码架构与程序逻辑，乃是提升编程技巧最好的方式。

因此，GitHub 也自然而然的，成为我最喜爱的开发者平台。

秉着挖掘开源价值的初衷，GitHubDaily 自 2015 年 10 月 10 日正式成立。

我们希望能通过这一举措，帮助开发者们发现当下最火的开源项目，掌控最新技术动态, 扩大技术视野, 并从开源项目的学习中获得编程能力的提升。

目前，GitHubDaily 已累积分享超过 3000 个开源项目，内容包括但不限于 GitHub 上的开源技术资料、开发者工具、编程网站以及成熟应用。

除了 GitHub 之外，我们也开始在下面多个社交媒体平台，帮助开发者传播与分享优质开源项目，挖掘其未来的技术应用前景。

如果你想接收最新的 GitHub 开源项目资讯，可以关注一下👇

- 公众号: [GitHubDaily](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/weixin.png)
- 微博: [@GitHubDaily](https://weibo.com/GitHubDaily)
- 知乎: [@GitHubDaily](https://www.zhihu.com/people/githubdaily)

> 有不错的开源项目，也欢迎到本仓库的 [issues](https://github.com/GitHubDaily/GitHubDaily/issues/new) 推荐或自荐项目，我们期待你的分享。

---

## 2021 年复盘

下面是对 GitHubDaily 在 2021 年所推荐的项目进行分类整理，方便大家查找以往分享过的内容。

> 过往复盘 [2020](https://github.com/GitHubDaily/GitHubDaily/blob/master/2020.md)，[2019](https://github.com/GitHubDaily/GitHubDaily/blob/master/2019.md)，[2018](https://github.com/GitHubDaily/GitHubDaily/blob/master/2018.md)

### 目录

- [宗旨](#宗旨)
- [2021 年复盘](#2021-年复盘)
  - [目录](#目录)
  - [Java](#java)
  - [Python](#python)
  - [Go](#go)
  - [前端](#前端)
  - [移动端](#移动端)
  - [工具](#工具)
  - [插件](#插件)
  - [资料集合](#资料集合)
  - [书籍/教程](#书籍教程)
  - [机器学习/人工智能](#机器学习人工智能)
  - [有趣/实用网站](#有趣实用网站)
  - [其他](#其他)
- [声明](#声明)

### Java

名称 | 简述 | 源
---- | ----- | -----
[Apache Shenyu](https://github.com/apache/incubator-shenyu) | 一个可应用于所有微服务场景的 API 网关解决方案，具备可扩展、高性能、响应式等特点。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L76U9dw8z)
[DWSurvey](https://github.com/wkeyuan/DWSurvey) | 一款简单高效、成熟稳定的开源问卷系统。部署简单、更新便捷，一行命令完成部署，支持多达 40 多种题型，拥有数据实时统计、富文本编辑、多端适配等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L68O16vuH)
[Hippo4J](https://github.com/acmenlt/dynamic-threadpool) | 一个开源的 Java 动态线程池系统，附带监控报警功能（不依赖中间件），遵循了阿里的编码规范。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L4i6CtTFI)
[Spider Flow](https://github.com/ssssssss-team/spider-flow) | 一个高度灵活可配置的爬虫平台，用户无需编写代码，以流程图的方式，即可实现爬虫。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2e3doG8f)
[file-online-preview](https://github.com/kekingcn/kkFileView) | 一个开源的文件文档在线预览项目，支持主流办公文档的在线预览，如 doc、docx、Excel、pdf、txt、zip、rar、 图片等格式。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1zZ6zGb5)
[LogiCommon](https://github.com/didi/LogiCommon) | 滴滴在 GitHub 开源的一套 Java 版认证、鉴权、管理、任务调度通用功能组件 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KApx8iHLr)
[DSA-Bootcamp-Java](https://github.com/kunal-kushwaha/DSA-Bootcamp-Java) | 一个开源的 Java 数据结构与算法代码示例库。整理了油管博主 Kunal Kushwaha 的课程代码示例、作业、视频教程等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KuEFuFnWU)
[《深入浅出 Java 多线程》](https://github.com/RedSpider1/concurrent) | 一本开源的 Java 编程书籍，该书分为基础篇、原理篇、JDK 工具篇等三个篇章，并辅以图片和 Demo，让 Java 工程师可以更加轻松的理解 Java 多线程相关基础知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KtzuY29Fw)
[LeetCode](https://github.com/yuanguangxin/LeetCode) | 国内一位开发者整理的 LeetCode 题目分类与面试题答案解析。涵盖链表、指针遍历、字符串操作、堆栈、递归、动态规划、二叉搜索树等知识点，题解代码基于 Java 实现。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KswuoaQhR)
[yblog](https://github.com/youzhengjie9/yblog) | 来自大二学生开源的一个简单、功能齐全的 SpringBoot 博客系统，主要拥有博文管理、图表统计、接口监控、访问记录、附件管理、用户管理、友链管理、监控管理、博文抓取，以及第三方登录等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ks1QLe7xh)
[《互联网公司常用框架源码赏析》](https://github.com/doocs/source-code-hunter) | 一个 Java 知识库，项目致力于从源码层面，剖析和挖掘互联网行业主流技术的底层实现原理。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kq3ikfwRZ)
[JetLinks](https://github.com/jetlinks/jetlinks-community) | 一个开源的物联网基础平台，该平台基于 Java8、Spring Boot 搭建而成，是一个开箱即用，可二次开发的企业级物联网基础平台。平台实现了物联网相关的众多基础功能， 能帮助你快速建立物联网相关业务系统。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kp0tThWCZ)
[Sa-Token](https://github.com/dromara/Sa-Token) | 一个轻量级 Java 权限认证框架，主要解决了登录认证、权限认证、单点登录、踢人下线、账号封禁、OAuth2.0 等一系列权限相关问题。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KoPSkzsbj)
[Shopizer](https://github.com/shopizer-ecommerce/shopizer) | 一款基于 Java 开发的电商系统，支持商品分类、搜索、查询、下单等基础功能，自带后台管理系统，API 满足 RESTful 规范。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KnDDpAN7Z)
[SpringBootVulExploit](https://github.com/LandGrey/SpringBootVulExploit) | 一份开源的 Spring Boot 相关漏洞学习资料，利用方法和技巧合集，黑盒安全评估 check list。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KiCDCDADg)

### Python

名称 | 简述 | 源
---- | ----- | -----
[TqSdk](https://github.com/shinnytech/tqsdk-python) | 一款开源的 Python 量化交易工具，支持用户使用少量代码，快速构建各种类型的量化交易策略程序。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L8zDWBNBP)
[QPT](https://github.com/QPT-Family/QPT) | 一款开源的 Python 打包工具，最短仅需一行命令，即可将普通的 Python 脚本打包成 EXE 可执行程序，并选择性添加 CUDA 和 NoAVX 的支持。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7WmwyOMG)
[PyWebIO](https://github.com/pywebio/PyWebIO) | 用 Python 开发的一个 Web 应用，它能通过一系列命令式的交互函数，在浏览器上获取用户的输入数据并输出。让你无需编写 HTML 和 JS 代码，即可构建一个小型 Web 应用程序。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L71Nyykki)
[Command2API](https://github.com/gh0stkey/Command2API) | 一款比较实用的后端开发工具，开发者可以通过调用 API，来实时获取命令行的输出结果. | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6O3apMIk)
[turtle](https://github.com/niubiqigai/turtle) | 作者汇总了 12 个小型 Python 项目，其中包括圣诞树绘制、弹簧隧道、贪吃蛇游戏代码等项目，适合新手用于日常练习。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6MS78RAj)
[RedisJSON](https://github.com/RedisJSON/RedisJSON) | 一个允许开发者从 Redis 中存储、更新、获取 JSON 值，该库完全支持 JSON 标准、类似 JSONPath 的语法、以树状结构存储二进制数据。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6t8tCOkk)
[BadagalaAdarsh/Super_Mario](https://github.com/) | 为了让运动和游戏两不误，印度小哥 Adarsh 用 Python 做了一个项目，可通过体感动作来控制超级马里奥游戏，实现游戏中的各个操作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2cSa5AGM)
[Translators](https://github.com/UlionTse/translators) | 一个比较实用的 Python 翻译工具库，该库集成了谷歌、必应、有道、百度等多个翻译平台 API，支持上百种语言翻译，使用便捷，配置灵活。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1LLIiybk)
[H2O Wave](https://github.com/h2oai/wave) | 一个开源的 Web 仪表面板工具，可用于快速构建实时、低延迟、优雅美观的数据分析仪表面板，适用于 Python 与 R 语言。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KzFzIsmXp)
[Python-Mini-Projects](https://github.com/Python-World/python-mini-projects) | 一个适合练手的 Python 项目，里面收集了 100 多个小型 Python 项目，其中包括随机密码生成器、图片批量下载脚本、网站内容抓取、聊天机器人等项目，适合新手用于日常练习。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ky6WExcCV)
[Enaml](https://github.com/nucleic/enaml) | 一个开源的 Python 声明式 UI 框架，可帮助开发者快速搭建 GUI 项目，支持 Windows、Linux、macOS 及移动端等项目。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kw9zex7wo)
[OnlineJudge](https://github.com/QingdaoU/OnlineJudge) | 青岛大学开源的一款在线评测系统，基于 Python 与 Vue 编写而成。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kw1jNkiuz)
[PrettyMaps](https://github.com/marceloprates/prettymaps) | 一个比较不错的小型 Python 开源库，可基于 OpenStreetMap 数据，帮助开发者快速绘制简洁美观的地图。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KvwGcbaJo)
[《30-Days-Of-Python》](https://github.com/Asabeneh/30-Days-Of-Python) | 一个适合新手入门学习的 Python 教程，该教程期望通过为期 30 天的编码学习，手把手教会你 Python 基础编程知识及进阶开发技巧，如 Web 爬虫、数据分析、统计分析、虚拟环境搭建、API 构建等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KvcfM1haT)
[feapder](https://github.com/Boris-code/feapder) | 一款上手简单，功能强大的 Python 爬虫框架。使用方式类似 Scrapy，内置 3 种爬虫，支持分布式、批次采集、数据防丢、断点续爬、监控报警、浏览器渲染下载等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KtPpj09G2)
[PyBoy](https://github.com/Baekalfen/PyBoy) | 一个基于 Python 的 Game Boy 模拟器，像超级马里奥、口袋妖怪等耳熟能详的游戏都可以在上面完美运行。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KtiNVlDaB)
[py](https://github.com/codebasics/py) | 一个 Python 开源库，里面包含诸多 Python 开源脚本及程序代码，覆盖了 Python 基础与进阶、数据科学、调试工具、深度学习等知识点。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KsOaj0xiK)
[《Python 黑魔法手册》](https://github.com/iswbm/magic-python) | 一本开源的 Python 技术书籍，里面主要记录了与 Python 相关的一些语法冷知识、命令行使用技巧、开发技巧、编码习惯、开发工具等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KpWdWiuxV)
[MLScraper](https://github.com/lorey/mlscraper) | 一个开源的 Python 爬虫脚本，可基于机器学习自动从 HTML 页面中抓取数据。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KpMNrpfJW)
[AutoScraper](https://github.com/alirezamika/autoscraper) | 一个智能 Web 爬虫脚本，其主要作用，是能快速且智能获取指定网站上的数据，这些数据可以是网页文本、url 地址或者其它 HTML 元素。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KpbhDALyo)
[pyWhat](https://github.com/bee-san/pyWhat) | 一款比较实用的 Python 脚本工具，能够快速提取信息中的 IP 地址、邮箱、信用卡、数字货币钱包地址、YouTube 视频等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kp7m55ayD)
[Palanteer](https://github.com/dfeneyrou/palanteer) | 一个基于 Python 编写的飞行射击游戏，可玩性还挺高的。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kmp2p1Y4v)
[Gooey](https://github.com/chriskiehl/Gooey) | 一款可直接将 Python 命令行工具转为 GUI 应用的开源程序，优化用户体验。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KkoUw4rZu)
[Ryven](https://github.com/leon-thomm/Ryven) | 一个 Python 脚本可视化工具，该工具支持通过编辑节点来控制 Python 脚本，让开发者可以更为直观的感受脚本的执行过程与输出结果。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JEV6PtlML)

### Go
名称 | 简述 | 源
---- | ----- | -----
[Zinc](https://github.com/prabhatsharma/zinc) | 一款基于 Go 语言开发的搜索引擎，可用于替代 elasticsearch，提供了全文索引、单个二进制文件安装和运行、开箱即用的身份验证等功能，兼容 Elasticsearch API，自带可用于查询数据的 Web UI。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7TdJaBql)
[《Go Web 编程实战》](https://gowebexamples.com/) | 想学 Go 的同学，可以看下这个开放的技术教程，里面整理了多个 Go 编程代码示例，比如经典的 Hello World 程序，编写一个 HTTP 服务器，用 Go 语言查询 MySQL 数据库，JSON 数据的编码与解码。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L80i53xuv)
[《如何避免 Go 语言常见的 100 个错误》](https://github.com/teivah/100-go-mistakes) | 该仓库中收录了 Go 语言在开发过程中，新手会常犯的 100 个错误，并给出了相关解决方案。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L8hY0BfJE)
[ego](https://github.com/gotomicro/ego) | 一个开源的微服务框架，集成了各种工程实践，通过组件化设计模式，让业务能统一调用与启动组件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6q5zg5UD)
[go-fly](https://github.com/taoshihan1991/go-fly) | 一个开源的 Web 在线客服系统，开箱即用，支持私有化部署。网站只需嵌入一段 JavaScript 或跳转直连地址，即可快速接入客服。客户端支持电脑、手机页面自适应。项目基于 Go 语言与 MySQL 实现。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L0J9szkLc)
[CaoGuo](https://github.com/xxjwxc/caoguo) | 一个基于 Go 语言开发的小程序电商平台，支持商品选择、详情、下单、物流信息展示等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L0ylKnTov)
[《从零开发一个 Go 语言编译器》](https://github.com/chai2010/ugo-compiler-book) | 作者将尝试以实现 µGo 编译器为线索，带你一边学习，一边完善开发一个玩具语言。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L0vZEjMvR)
[go-daily-lib](https://github.com/darjun/go-daily-lib) | Go 每日一库，作者会每天跟你介绍一个 Go 语言开源库的用法、场景以及相关代码示例等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L028J4xCM)
[Open-IM-Server](https://github.com/OpenIMSDK/Open-IM-Server) | 一个基于 Go 实现的即时通讯（IM）项目，从服务端到客户端 SDK 开源即时通讯（IM）整体解决方案。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KFs0KxOPi)
[taskcafe](https://github.com/JordanKnott/taskcafe) | 一个基于 Go 与 Typescript 开发的看板开源软件，支持对任务进行筛选过滤、打标签、添加截止日期、分配成员、制定流程等操作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KAg6DolY3)
[learngo](https://github.com/inancgumus/learngo) | 里面包含了共计 1000+ 个 Go 语言相关的代码示例、练习、测验题。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KvlGghMXu)
[Crocodile](https://github.com/labulaka521/crocodile) | 一款开源的分布式任务调度系统，基于 Go 语言开发，支持多调度中心，可实时查看任务运行日志与状态、自定义报警策略、账户权限管理等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KvdPcapJL)
[《How To Code in Go》](https://www.digitalocean.com/community/books/how-to-code-in-go-ebook) | 一本 Go 语言开源书籍，由知名云服务器厂商 Digital Ocean 撰写发布。通过本书你将学会如何使用 Go 语言来编写程序，以及了解一些较为实用的开发者工具。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KqO2DrlcZ)
[《Go 语言精进之路》](https://github.com/golang-minibear2333/golang) | 本书给快速入门学习 Go 语言使用，更偏向于实战，计划扫清 Go 语言一切障碍。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KnKlszvJy)

### 前端

名称 | 简述 | 源
---- | ----- | -----
[Design Patterns Game](https://github.com/zoltantothcom/Design-Patterns-JavaScript) | 一个可以让前端开发者通过玩游戏，来学习设计模式的网站，网站分为设计模式介绍和游戏两部分。在游戏过程中，作者会提供用 JavaScript 实现的设计模式代码，你需要从 4 个答案中，判断代码所属的设计模式类型。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L8y4x5rvA)
[leo](https://github.com/JDFED/leo) | 京东前端技术团队在 GitHub 开源了一款前端脚手架工具，覆盖了前端开发全链路、可扩展、可定制的终端运行功能，并支持模板、构建器、扩展命令等丰富的周边生态扩展。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6V7wDAGr)
[Doom Captcha](https://github.com/vivirenremoto/doomcaptcha) | 西班牙有一位脑洞比较大的开发者，开源了一款游戏验证器：Doom Captcha，只有先通关作者提供的小游戏，才能通过网站验证。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6zw478JR)
[DoodleCSS](https://github.com/chr15m/DoodleCSS) | 一个看起来很可爱的前端 UI 组件库，满满的卡通手绘风格。支持 Web 按钮、下拉菜单、文本框、复选框等多种 UI 组件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6udh0AS0)
[Budibase](https://github.com/Budibase/budibase) | 一个开源的低代码平台，开箱即用、UI 设计简洁精美、功能强大。该项目可帮你更快开发商业级应用，支持单页面项目，具备自动化工作流程、响应式设计、外部数据源对接等特点。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1VcdbNtB)
[e 家宜业](https://github.com/chowa/ejyy) | 一套开源的智慧物业解决方案，主要包含装修登记、维修维护、车辆管理、访客通行、房产及业主档案管理、用户权限分配等功能，打通了小程序、PC、H5、智能硬件等多个终端。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L19u5rCsh)
[TinyWebServer](https://github.com/qinguoyi/TinyWebServer) | 可应用于 Linux 系统下的一款轻量级 Web 服务器，主要目的是帮助新手开发者快速实践网络编程，搭建属于自己的服务器。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L0OQCkTGk)
[Responsive Halloween Website](https://github.com/bedimcode/responsive-halloween-website) | 国外开发者 bedimcode 在 GitHub 开源了一个万圣节网站，该网站主要具备响应式布局、滚动动画、移动端优化、多平台设备兼容等特点。整体设计风格优雅、简洁，感兴趣的同学可以拿去练练手。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KEVByyest)
[Checkboxland](https://github.com/bryanbraun/checkboxland) | 一个比较有意思的 JavaScript 库，可将任意内容转化为 HTML 复选框，用以展示各类动画、文本、图像、视频等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KEmE3vXvj)
[Dim](https://github.com/Dusk-Labs/dim) | 一个可帮助你快速搭建电影网站的媒体管理器，只需简单配置，即可快速组织与美化本地媒体库，让你随时随地播放本地媒体文件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KDUmyzJ9I)
[Music Website](https://github.com/Yin-Hongwei/music-website) | 一个开源的音乐网站管理系统，实现了歌单、播放器、用户及音乐管理等常用功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KDKW42Idl)
[wLogger](https://github.com/jyolo/wLogger) | 一款集日志采集、日志解析持久化存储、Web 流量实时监控，三位一体的 Web 服务流量监控应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KDCGE0KoG)
[Appwrite](https://github.com/appwrite/appwrite) | 一款开源的 Web 服务器，可帮你快速构建用户认证、数据库存储、文件管理、图像操作、地理位置检测等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KDqU0tbF9)
[「剑指前端 Offer」](https://github.com/hzfe/awesome-interview) | 一个开源的前端面试库，由国内多位互联网大厂工程师及前端独立开发者维护。开发者们可借助本书，快速了解面试的高频技术问题与解答，抑或通过书中题目和答案提纲，自主深入学习，查漏补缺。项目来自水友自荐。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KBNyFsRm8)
[YesPlayMusic](https://github.com/qier222/YesPlayMusic) | 一款颜值颇高的第三方网易云播放器，基于 Vue.js 全家桶开发，内置所有音乐播放器基础功能，支持 MV 播放、暗黑模式、自定义快捷键等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KA5v6q9Td)
[Theatre.js](https://github.com/AriaMinaei/theatre) | 一个蛮不错的前端动画设计库，可用于创建、设计酷炫丝滑的 Web 动画交互效果。开发者可通过编程或 Web 交互式组件来完成工作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kzw9djIFq)
[LogicFlow](https://github.com/didi/LogicFlow) | 滴滴在 GitHub 开源的一款流程可视化的前端框架，主要提供了一系列流程图交互、编辑所必需的功能和简单灵活的节点自定义、插件等拓展机制，方便开发者快速在业务系统内满足类流程图的需求。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KyiJewUnQ)
[Browser 2020](https://github.com/luruke/browser-2020) | 一个值得前端开发者收藏学习的 GitHub 项目，里面收集了浏览器中一些较为冷门，却异常实用的接口，如商品支付、社交网络分享、消息推送、视频画中画、剪切板、AR 预览、用户身份凭证管理等多种接口。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ky9iKCpcR)
[7.css](https://github.com/khang-nd/7.css) | 一个小型 CSS 开源框架，可在 Web 页面上添加类似 Windows 7 风格的 UI 组件，其中包括对话框、按钮、下拉菜单、进度条、滚动条等组件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KwiZJ9R66)
[1loc](https://github.com/phuoc-ng/1loc) | 如果你想知道一行 JavaScript 代码能实现哪些比较实用的功能，可以看看这个 GitHub 项目，该项目收集了共计 126 个代码片段，其中包含对数组、日期、函数、DOM 等常见代码模块的组件实现。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kvvv7m6Lj)
[sparrow](https://github.com/sparrow-js/sparrow) | 一个开源的场景化、低代码搭建工作台，可实时输出源代码 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KvoqKyP4j)
[React Chrono](https://github.com/prabhuignoto/react-chrono) | 一个开源的 React 组件，可帮你创建多种样式丰富的时间轴，支持以水平、垂直、树状等不同形式进行渲染，并可用幻灯片交互播放。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KuDur3AUl)
[Online 3D Viewer](https://github.com/kovacsv/Online3DViewer) | 一款可在 Web 页面上查看与调试 3D 模型的开源工具，支持环绕、平移、缩放等交互。开发者还可将 3D 模型内嵌到个人网站上。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KthCSk7yM)
[Eruda](https://github.com/liriliri/eruda) | 一个开源的前端页面调试神器专为手机前端页面设计的调试面板，类似 DevTools 的迷你版，主要功能包括：捕获 console 日志、检查元素状态、捕获 XHR 请求、显示本地存储和 Cookie 信息等等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KtfgKffdx)
[Node.js 集成测试最佳实践](https://github.com/testjavascript/nodejs-integration-tests-best-practices) | 一份开源资料库：Node.js 集成测试最佳实践，主要包含 Node.js 集成测试实践清单、典型的项目实例、以及 Nest.js、Mocha、Jest、Express 等多个平台示例。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KssL0j2R4)
[Webfunny](https://github.com/a597873885/webfunny_monitor) | 一款开源的轻量级前端监控系统，可实时分析前端项目健康状态，并生成数据概览。拥有无埋点监控前端日志、程序错误定位、用户行为记录及排查、性能分析等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Krj4plOii)
[Apollo](https://github.com/amirgamil/apollo) | 一款开源的个人搜索引擎与 Web 爬虫，在收录网站 url 后，程序会自动抓取网站文字内容、视频字幕并存储。而后，用户便可通过搜索，快速查看爬取内容或访问网站源页面。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KqZ2m5exp)
[360-sneakers-viewer](https://github.com/hua1995116/360-sneakers-viewer) | 国内一位前端开发者，基于 Three.js，为鸿星尔克写了一个「360° 全景看鞋展厅」，代码已在 GitHub 开源。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KqXRi8jWG)
[windows11](https://github.com/blueedgetechno/windows11) | 国外一名前端工程师，在 Web 上复现了 Windows 11 的界面及部分功能，项目主要基于 React 搭建而成。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kpv7vE7qf)
[PPTist](https://github.com/pipipi-pikachu/PPTist) | 一个基于 Vue3.x + TypeScript 的在线演示文稿应用，还原了大部分 PPT 常用功能，支持文字、图片、形状、线条、图表、表格等 6 种最常用的元素类型。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KoZiPCBgq)
[Puppy](https://github.com/lmt-swallow/puppy-browser/) | GitHub 上有人基于 JavaScript V8 引擎和 Rust，搭建了一个微型浏览器，适合开发者用于学习和熟悉浏览器基础原理。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KoznsBlK1)
[50projects50days](https://github.com/bradtraversy/50projects50days) | 该项目一共含有 50 个纯使用 HTML、CSS 和 JavaScript 实现的小 Demo，这当中有加载动画、时钟主题、密码生成器、动画倒计时、在线绘图等多个小应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Knt1Rw8wj)
[Fakeflix](https://github.com/Th3Wall/Fakeflix) | 一个比较不错的 Netflix 克隆项目，实现了电影播放、搜索、注册登录、无限滚动等功能。还通过 HTML 与 CSS，实现了其经典的开场动画。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Knn8yiIcc)
[CSS Protips](https://github.com/AllThingsSmitty/css-protips) | 一个前端知识库，里面收集并整理了 CSS 相关的一些开发及使用技巧。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KmjlfjGFK)
[Map of Javascript](https://github.com/mechaniac/Map-of-Javascript) | 开源的 JavaScript、数据结构与算法知识图谱。可用于日常工作或学习时的查漏补缺。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KlsU06OhH)
[Utopia](https://github.com/concrete-utopia/utopia) | 一款比较不错的前端开发工具，可在浏览器上为 React 项目及其组件，提供实时展示的设计与编码环境，进一步优化编程体验。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KkrF07crE)
[playground-macos](https://github.com/Renovamen/playground-macos) | 作者基于 React 和 Tailwind CSS，在 Web 页面上实现了 macOS 的模拟界面 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KjmkCFBRl)
[Revo Grid](https://github.com/revolist/revogrid) | 一款比较实用的前端组件，拥有可高度定制化的虚拟数据智能表格，涵盖了 Excel 上那些优秀特性。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JFfxep6Qz)
[《带你入门前端工程》](https://github.com/woai3c/introduction-to-front-end-engineering) | 一本开源的前端技术书籍，主要记录作者在近两年来，在前端工程师实践经验和学习心得方面的总结。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JENfKdl79)
[iMove](https://github.com/i5ting/imove) | 一个逻辑可复用的，面向函数的，流程可视化的 JavaScript 工具库。拥有流程可视化、逻辑复用、灵活可扩展等特性。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JCZiRlywS)

### 移动端

名称 | 简述 | 源
---- | ----- | -----
[fl_chart](https://github.com/imaNNeoFighT/fl_chart) | 一款开源的 Flutter 图表动画组件库：fl_chart，支持折线图、条形图、饼图、散点图和雷达图等多种图表，并且都拥有不错的动画效果 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](%id/L7NkobNfX)
[Bruno](https://github.com/LianjiaTech/bruno) | 一套开源的企业级移动端 Flutter 组件库，自带 100+ 组件，开箱即用，主题可自定制，并拥有简约大气的交互和视觉风格。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6LH2lZ8j)
[Flipper](https://github.com/facebook/flipper) | 一款移动端调试工具，可在 PC 桌面上可视化调试与控制 iOS、Android 与 React Native 应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KBVO69M7x)
[Scrcpy](https://github.com/Genymobile/scrcpy) | 一个通过 USB（或 TCP / IP）连接到电脑上高清显示和流畅控制 Android 设备的工具，适用于 GNU/Linux、Windows 和 Mac OS，无需 root 权限。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KxYHbjD7W)
[Awesome Flutter Desktop](https://github.com/leanflutter/awesome-flutter-desktop) | 收录了一系列基于 Flutter 开发的组件包与开源项目，其中包括密码管理器、音乐播放器、翻译词典、漫画阅读器等应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KxcnEzg5O)
[Fluent UI System Icons](https://github.com/microsoft/fluentui-system-icons) | 微软发布的一款专注于移动端应用的 UI 图标库，针对 iOS、Android、Flutter 等不同开发平台，微软均提供了可快速安装的方式，集成与使用一气呵成。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KwtBitJ3Y)
[Flutter UME](https://github.com/bytedance/flutter_ume) | 一款 Flutter 应用内调试工具平台，里面内置了 Widget 信息、颜色吸管、对齐标尺、代码查看、日志展示、内存及 CPU 信息等 10 个插件。开发者可自行创建插件，并集成进 UME 平台。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KqWhS0i5W)
[fl_chart](https://github.com/imaNNeoFighT/fl_chart) | 一款开源的 Flutter 图表动画组件库，支持折线图、条形图、饼图、散点图和雷达图等多种图表，并且都拥有不错的动画效果。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7NkobNfX)

### 工具

名称 | 简述 | 源
---- | ----- | -----
[Pure Live](https://github.com/iyear/pure-live-core) | 国人在 GitHub 上开源了一个直播系统，简单纯粹，支持直播、弹幕等功能。跨平台，甚至可以运行在路由器上。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7OvtA3t3)
[sealos](https://github.com/fanux/sealos) | 一款开源的 k8s 部署工具，一条命令离线安装高可用 kubernetes，3min 装完，700M，100 年证书，版本不要太全，生产环境稳如老狗。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7QRAxoed)
[VNote](https://github.com/vnotex/vnote) | 一款开源的 Markdown 编辑器，提供了强大的笔记管理模式，使得 Markdown 记笔记更轻松简单，并支持 Linux、Windows、macOS 等平台。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7XVXggyr)
[markmap](https://github.com/gera2ld/markmap) | 一个蛮实用的 GitHub 开源工具，可快速将 Markdown 文档转为直观可视化的思维导图，并且能集成到 VSCode 上。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L8j95n2eX)
[QingScan](https://github.com/78778443/QingScan) | 一款开源的漏洞挖掘工具，集多个功能于一体，支持 Web 扫描、系统扫描、子域名收集、主机发现、组件识别、URL 爬虫、XRAY 扫描、POC 批量验证，SSH 批量测试、vulmap 等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L8ruJ15R1)
[Fake You](https://fakeyou.com) | 一款很好玩的 AI 工具，可将文本自动转换为动漫角色、明星等名人语音，并为其配上开口说话的视频。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L8szzjJWR)
[PushDeerOS](https://github.com/easychen/pushdeer) | 一个可快速搭建消息推送服务的开源工具，遵循了易用、可控、渐进的产品设计原则。简单便捷，输入 URL 即可完成消息推送。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7vEt3mZg)
[Vue Color Avatar](https://github.com/Codennnn/vue-color-avatar) | 一个开源的卡通头像生成器，纯前端实现，拥有各类头像搭配组件。随机生成头像时，有一定概率会触发彩蛋。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L74y1uDBZ)
[Loaf](https://github.com/DinoChan/Loaf) | 一款摸鱼工具，点击按钮，便会假装弹出 Windows 系统更新界面，然后就能光明正大地摸鱼了。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6Sn3u5iF)
[Yuno](https://github.com/Yuno) | 一款动漫搜番神器，可让 AI 通过文字描述，帮你快速找到相似动漫。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6ba7r5LY)
[Repobeats](https://repobeats.axiom.co/) | 可在 GitHub README 页面上，添加酷炫的可视化统计图表，用以展示项目代码的提交频率、分支合并及 issue 状态。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L5iaytiKP)
[DooTask](https://github.com/kuaifan/dootask) | 一款轻量级的、开源的在线项目任务管理系统，提供各类文档协作工具、在线思维导图、在线流程图、项目管理、任务分发、即时 IM，文件管理等工具。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L4WLf759P)
[appsmith](https://github.com/appsmithorg/appsmith) | 一个开源的低代码构建平台，可对接各类数据源，帮你快速搭建管理后台、开发工具、企业 CRM 系统等各类项目。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L4N8zATDx)
[Image Optimizer](https://github.com/antonreshetov/image-optimizer) | 墨西哥一位前端工程师开源的图像及矢量图压缩工具，可通过拖拽快速完成压缩。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L4uhzCjO8)
[PyTorch Live](https://github.com/pytorch/live) | PyTorch 官方前不久发布了一套工具包，可帮助开发者，快速构建移动端 AI 应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L4t6xxmgs)
[designstripe](https://designstripe.com/) | 国外一款插图绘制工具，让不懂设计的人也能自制插图。完成后的插图，可导出成 PNG、JPG、SVG（付费用户）等格式，并应用到个人项目、博客、图书、周边等场景上。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L4m29vWiz)
[Paper Digest](https://www.paper-digest.com/) | 东京大学发布的一款工具，可利用 AI 为每篇论文生成摘要，将阅读时间缩短为 3 分钟。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L4cBFzeVW)
[Fuso](https://github.com/editso/fuso) | 一款快速，稳定，高效，轻量的内网穿透，端口转发工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L4bqB6pMx)
[VTracer](https://github.com/visioncortex/vtracer) | 可快速将 JPG、PNG 等格式的图片快速转换为 SVG 矢量图，并支持过滤斑点、色彩精度、曲线拟合等多种参数配置。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L3Royre28)
[Connect Papers](https://www.connectedpapers.com/) | 一款论文可视化检索神器，当你搜索论文时，该工具会自动生成直观的可视化图谱，展示多篇论文的关联度、引用度及时间跨度。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L3fGyml8X)
[Dev Lake](https://github.com/merico-dev/lake) | 一款开源的 DevOps 开发工具，可将 DevOps 数据以实用、个性化、可扩展的视图呈现，完成数据的收集、分析和可视化。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L39ZqdlW7)
[Penpot](https://github.com/penpot/penpot) | 首个开源的 UI 设计与原型制作平台，拥有多款 UI 组件与样式、交互式原型以及项目设计示例与模板，帮你更快完成项目设计工作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2Np4cKxH)
[Form Create](https://github.com/xaboy/form-create) | 一个在线动态表单生成器，用户只需上传 JSON 数据，即可快速生成表单。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2DYAaxXw)
[tldraw](https://github.com/tldraw/tldraw) | 一个轻量级，功能强大的绘画 App，自带画笔、橡皮、线框、文字等工具，用户可自定义画笔颜色、线框样式等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2jKl0GqF)
[AppFlowy.IO](https://github.com/AppFlowy-IO/appflowy) | 一个开源的 Notion 替代品，完成了个人笔记 - 知识库 - 任务管理的功能结合。除了具备 Notion 的基础核心功能外，该项目还支持自托管与离线模式，数据与安全性可控。开发者可任意定制项目模板、插件、主题等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1RgHySLX)
[Lorien](https://github.com/mbrlabs/Lorien) | 一款开源的画板与笔记工具，可用于日常文字记录和头脑风暴等场景，也可绘制草图或图标。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1N8WAAEz)
[Loud Reader](https://www.loudreader.com/) | 一个颇为实用的 Web 电子书阅读器，可让你直接在浏览器阅读电子书，支持 epub、azw3、mobi、pdf 等多种文件格式。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1DIrF9fc)
[avataaars-generator](https://github.com/fangpenlin/avataaars-generator) | 一款开源的卡通头像生成器，可自定义发型、眼镜、肤色、衣着、嘴型等属性。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1uhWATTJ)
[natpass](https://github.com/lwch/natpass) | 新一代 NAT 内网穿透工具，支持 TCP 隧道、shell 隧道 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1sUIfzv5)
[ProsePainter](https://github.com/Morphogens/ProsePainter) | 一款比较有意思的工具，可基于机器学习，通过文字描述来生成图像。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1pblje2K)
[SQLime](https://github.com/nalgeon/sqlime) | 一个开源的 SQLite 在线工具，可用于调试与分享 SQL 片段，跟前端开发工具 JSFiddle 有点像。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1kRs3UcQ)
[Rhubarb Lip Sync](https://github.com/DanielSWolf/rhubarb-lip-sync) | 一款比较有意思的开源工具，可通过真实录音，让动漫人物的嘴唇实现音画同步。开发者可将其应用于计算机游戏、动画卡通角色、视频 Vlog 等场景上。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L0Fq82dgy)
[Motor Admin](https://github.com/motor-admin/motor-admin) | 一款项目管理后台搭建工具，无需编码，即可快速为应用搭建简单易用的管理后台。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KFQaxCXTx)
[Uncle 小说](https://github.com/unclezs/uncle-novel) | 一款开源的小说下载与阅读工具目录解析与书源结合，支持有声小说与文本小说，可下载 mobi、epub、txt 格式文本小说，兼容 Windows、macOS、Linux 等操作系统。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KFJux7Br9)
[spy-debugger](https://github.com/wuchangming/spy-debugger) | 一款比较实用的手机页面调试、抓包工具，无需通过 USB 连接设备，即可实现远程调试手机浏览器页面、移动端应用 WebView，支持 HTTP / HTTPS。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KFnT2rkln)
[Shotcut](https://github.com/mltframework/shotcut) | 一款免费开源的视频编辑器，兼容 Windows、macOS、Linux 等主流操作系统。支持最新音视频格式与 4K 分辨率，可实现视频特效添加、内容剪切、时间轴校对、滤镜及色彩调整等操作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KEZx6uCGl)
[Note Garden](https://notegarden.web.app/) | 一款比较实用的笔记工具，可自动为个人学习笔记创建教程，利用算法助你温习笔记内容，双向链接 - 高效检索笔记内容，兼容多种数学公式，生成图片完型填空测试题等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KEXaYlllf)
[ShareX](https://github.com/ShareX/ShareX) | 一款功能颇为强大的 Windows 截图与录屏工具，支持截图、录屏、OCR 文本识别、图像水印添加、内容上传、地址分享、颜色调整、图像编辑、视频格式转换等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KEOVxskOw)
[Perspective](https://github.com/finos/perspective) | 一个交互式、可视化数据分析工具，可用于创建数据报告、数据面板、科研笔记及应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KEMb3lcbz)
[亲戚关系计算器](https://github.com/mumuy/relationship) | 国内一位开发者在 GitHub 开源了「亲戚关系计算器」，只需像计算器一样简单输入，即可推算出亲戚称谓。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KEI3l3I8Y)
[SQLMap](https://github.com/sqlmapproject/sqlmap) | 一款比较实用的 SQL 渗透测试工具，开发者可利用它来完成程序的自动化检测，利用 SQL 注入漏洞，获取数据库服务器的权限。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KEpcl2VdW)
[CleanUp.pictures](https://github.com/initml/cleanup.pictures) | 一款颇为有趣的在线工具，可通过画笔，在线擦除图像中的物品对象。此外，还支持自定义画笔大小、图片还原、素材下载等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KDTbvCDdG)
[RawGraphs](https://github.com/rawgraphs/rawgraphs-app) | 一款比较实用的数据可视化工具，通过粘贴或上传表格数据，即可快速生成数据可视化图形。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KCFLx6yCy)
[henggeFish](https://github.com/SkewwG/henggeFish) | 一款可自动化、批量发送钓鱼邮件的开源工具，主要为了解决 "护网" 中大量目标需要发送钓鱼邮件的痛点。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KCA4o26Cb)
[Vulmap](https://github.com/zhzyker/vulmap) | 一款开源的漏洞扫描工具，可对 Web 容器、Web 服务器、Web 中间件以及 CMS 等 Web 程序进行漏洞扫描，并且具备漏洞利用功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KCmYA1urL)
[NETworkManager](https://github.com/BornToBeRoot/NETworkManager) | 一款开源的 Windows 网络管理工具，拥有 IP 扫描、端口扫描、路由跟踪、DNS 查询等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KC5eBip2F)
[Quickemu](https://github.com/wimpysworld/quickemu) | 由国外 Linux 开发者 Martin 在 GitHub 开源的一款虚拟机安装工具。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KBUD2hdWP)
[Uptime Kuma](https://github.com/louislam/uptime-kuma) | 一款开源的网站监控工具，功能类似「Uptime Robot」，可用于监控当前网站的运行状态。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KBMnBn7dH)
[Xplorer](https://github.com/kimlimjustin/xplorer) | 印尼高中生 Kimlim 开发的一款可定制、现代化的跨平台文件管理器，支持 Windows、Linux、macOS 等主流桌面系统，允许直接预览图片、文档、视频，免费开放，基于 Apache-2.0 许可开源。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KAqIdiN4Z)
[Notion Avatar](https://github.com/Mayandev/notion-avatar) | 作者提供了一系列组件，可让你在线定制类似 Notion 风格的个人头像。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KAmMFaikA)
[MPLG](https://everydayanchovies.github.io/mplg/mplg) | 一款比较实用的 Matplotlib 客户端，支持可视化设计并绘制图形，并将图形导出成 PNG、PDF、SVG 等文件格式。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KAdm9oUKo)
[iroiro](https://github.com/antfu/iroiro) | 一款可在终端运行的色彩查询工具，提供了不少简洁优雅的色系供开发者选择，其数据引用自日本传统色系。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KA6G8wdmP)
[Draw on PDF](https://www.goodannotations.com/tools/draw-on-pdf) | 一款比较实用的 PDF 在线标注工具，可在线对 PDF 文件进行标注、绘制图案。完成后可通过链接分享给其他人，支持 PC 及移动端设备。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KzXfE3Cfi)
[WeChat Export](https://github.com/luin/wechat-export) | 一款开源的微信消息导出工具，可将聊天记录导出成 HTML 文件、支持文本、语音、图片、视频、消息等资源。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KzuY9q5zG)
[btop](https://github.com/aristocratos/btop) | 一个开源的 Linux / OSX / FreeBSD 资源监控工具，支持显示处理器、内存、硬盘存储、网络与进程使用状态等信息，拥有多款可定制主题。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kzo5X4KcG)
[Bili.Uwp](https://github.com/Richasy/Bili.Uwp) | 一款开源的 B 站第三方应用，支持 Windows 10/11 系统，主打设计和易用性，自发布后收到不少用户好评。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KzmIJEBuF)
[darling](https://github.com/darlinghq/darling) | 可让你在 Linux 上无缝运行 macOS 系统软件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KyL0K0n0n)
[x11docker](https://github.com/mviereck/x11docker) | 一款开源工具，可让开发者在 Docker 上跑图形界面程序。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KyApaBRmN)
[youtube-dl-gui](https://github.com/jely2002/youtube-dl-gui) | 如果你平时有下载 YouTube 视频的需求，又不习惯使用命令行，那么可以试下 youtube-dl-gui 这款下载工具。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kyze72gdn)
[SpeechBrain](https://github.com/speechbrain/speechbrain/) | 一个功能齐全的语音工具包，提供语音识别（支持普通话）、语音增强、语音处理、多麦克风信号处理、模块化定制等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KypNCdq4w)
[Kubescape](https://github.com/armosec/kubescape) | 第一款可用于测试 Kubernetes 是否已安全部署的开源工具。测试结果将以 NSA 发布的《Kubernetes 加固指南》为标准。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kygn81kal)
[Code IMG](https://codeimg.io/) | 一款免费在线把源代码生成高逼格的图片工具。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KxpxuA9vU)
[Age](https://github.com/FiloSottile/age) | 一款简单易用的现代化安全加密工具，可基于非对称加密算法，快速给私密文件进行加密。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KxmZctYRL)
[Macast](https://github.com/xfangfang/Macast) | 一个可将手机视频、图片、音乐等资源快速推送到电脑端的开源应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KxlO9pcfg)
[CutefishOS](https://github.com/cutefishos) | 一个基于 Linux 开源的桌面系统，由国内团队开发，注重简洁、美观和实用性，整体 UI 风格跟 macOS 颇为相似。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KxaOetqme)
[git-cliff](https://github.com/orhun/git-cliff) | 一款比较实用的命令行工具，可从日常 Git 提交记录中提取关键信息，自动生成项目更新日志，减少重复性工作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kx48dAJz9)
[Screego](https://github.com/screego/server) | 一款开源的屏幕共享工具，可选择分享电脑全屏、窗口、浏览器标签页等三种分享模式，并拥有更低延迟、更高质量的屏幕共享体验。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KwVSMp1Ue)
[Qwerty Learner](https://github.com/Kaiyiwing/qwerty-learner) | 一款开源的单词记忆与英语肌肉记忆锻炼软件，主要将英语单词的记忆与键盘输入的肌肉记忆相结合，可在背诵单词的同时巩固肌肉记忆。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KwUHIdNhq)
[Airbyte](https://github.com/airbytehq/airbyte) | 一款开源的数据集成平台，可通过 API、应用、命令行工具等方式，在短短几分钟内完成数据集成，以便后续使用与管理。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KwsqdFLi2)
[Kuboard](https://github.com/eip-work/kuboard-press) | 一款专为 Kubernetes 设计的开源管理界面。具备多集群管理、权限管理、监控套件、日志套件等丰富功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KwpFKrQxw)
[exatorrent](https://github.com/varbhat/exatorrent) | 一款开源的 BitTorrent 种子客户端，具备自托管、简单易用、功能丰富、轻量级等特性。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KwhOFvCwZ)
[Sharingan](https://github.com/didi/sharingan) | 一款开源的项目流量录制工具，可录制线上真实请求流量，并进行回放测试。适合项目重构、回归测试等场景。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KvIEYisMy)
[XgeneCloud](https://github.com/xgenecloud/xgenecloud) | 一款较为实用的数据库开源神器 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KvxRfoMox)
[Label Studio](https://github.com/heartexlabs/label-studio) | 一款开源的数据标注神器，可用于标注音视频、文本、图像、时间序列等数据类型，并导出为多种模型格式。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kv6KPqpsl)
[FSNotes](https://github.com/glushchenko/fsnotes) | 一款开源的 macOS / iOS 笔记软件，支持语法高亮、在线图像、标签组织、跨笔记链接、暗黑模式、Git 版本控制等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kv5zLe5b2)
[Low-power Kindle dashboard](https://github.com/pascalw/kindle-dash) | 可将越狱的 Kindle 设备打造为节能仪表面板，面板显示内容为服务器返回的 PNG 图像，因此开发者可自行定制。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KuXkjBKQF)
[gushi_namer](https://github.com/holynova/gushi_namer) | 一款开源工具：「你的名字」，可用诗经、楚辞、唐诗、宋词来随机起名字。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KuNTP4IW8)
[Sherloq](https://github.com/GuidoBartoli/sherloq) | 一款开源的图像取证工具，可对图像具体信息进行提取、分析、比对，并以此检测图像是否被篡改或伪造，功能颇为强大。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KuCjn8RwZ)
[Rhit](https://github.com/Canop/rhit) | 一款开源的 Nginx 日志浏览工具，可将日志文件按照日期、响应状态、存储路径等进行筛选分类，让你更为直观且高效的阅读 Nginx 日志。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KulCl8ldH)
[cxx2flow](https://github.com/Enter-tainer/cxx2flow) | 国内开发者在 GitHub 上开源的一款工具，可将 C/C++ 代码快速转换为流程图，便于增强图表复用率与团队协作效率。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kukrior9u)
[dev-sidecar](https://github.com/docmirror/dev-sidecar) | 一款开源的开发者辅助工具，提供 GitHub、Stack Overflow、NPM 等开发者工具的访问加速功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KuhGNtywK)
[Systemizer](https://github.com/honzaap/Systemizer) | 一款开源的系统设计工具，可用于创建、模拟大规模分布式系统数据流。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KtgrOcaFc)
[Nodes](https://github.com/nodes-io/nodes-io) | 一款比较实用的可视化编程工具，该工具支持快速创建实时 3D 图形、可交互的 Web 应用、自定义和共享工具参数、可视化数据分析、构建复杂应用等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KsYLRwGdM)
[Excalidraw](https://github.com/excalidraw/excalidraw) | 一款开源的笔记手绘工具，支持 Excel 表格导入、内容翻译、图形绘制、加密协作等功能，微博附图为该工具的绘图示例。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KsDyKBRzr)
[RPCS3](https://github.com/RPCS3/rpcs3) | 一款开源的索尼 PS3 模拟器与调试工具，支持在 Windows、Linux 及 BSD 系统上运行 PS3 游戏。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KsBZl2bNh)
[smarGate](https://github.com/lazy-luo/smarGate) | 一款开源的内网穿透工具，基于 C++ 实现，无需公网 IP，拥有小巧，易用，快速，安全，多链路聚合等功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ksu8g4R5K)
[Muboard](https://github.com/susam/muboard) | 一款开源的数学白板工具，可通过编写 Markdown + LaTeX，在 Web 页面上进行展示，方便用于教学、演讲、会议等场景。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ksn3Sprya)
[icones](https://github.com/antfu/icones) | 一款颇为实用的图标库搜索工具，拥有数量丰富的图标库，支持模糊搜索、图标字体打包、SVG 下载、类别过滤、脚本复制等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KslSOtCKp)
[Image to LaTeX](https://github.com/kingyiusuen/image-to-latex) | 一款比较实用的开源工具，可将 LaTeX 公式图片，快速转换为可复制的 LaTeX 代码公式。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KsdDnyoW6)
[Rubick](https://github.com/clouDr-f2e/rubick) | 一款开源桌面工具箱，支持快速搜索当前系统应用、截屏、取色、锁屏、右键增强等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kscskc0SJ)
[Mapus](https://github.com/alyssaxuu/mapus) | 一款具有实时协作功能的地图工具，开发者可通过绘制、标记等方式，与同伴一起规划行程。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ks31P4shw)
[TTSkit](https://github.com/KuangDD/ttskit) | 一款开源的语音合成工具箱，支持文本转语音，可在线配置参数，并拥有多种音色选择。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KrTBkgIu1)
[水泽](https://github.com/0x727/ShuiZe_0x727) | 一款开源的信息收集自动化工具，只需输入根域名，即可全方位收集相关资产，并检测漏洞。也可以输入多个域名、C 段 IP 等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KrLlTjjpr)
[TheBoard](https://github.com/toger5/TheBoard) | 一款开源的白板协作工具，支持用户在 Web 页面上，绘制、涂改、标记并分享白板上的内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KrKaPlh7S)
[DataEase](https://github.com/dataease/dataease) | 一款开源的数据可视化分析工具，可帮助用户快速分析数据并洞察业务趋势，从而实现业务的改进与优化。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kr9DU9SPE)
[macOS Virtualbox](https://github.com/myspaghetti/macos-virtualbox) | 一个可在 VirtualBox 上快速安装 macOS 系统的开源脚本。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KqoHBg1xI)
[Wireflow](https://github.com/vanila-io/wireflow) | 一款开源的在线流程图绘制工具，支持使用 100 多种自定义图形、可进行多人协作、权限分配、实时聊天等功能、并拥有丰富的功能组件库。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kq1ITc3rH)
[tmpmail](https://github.com/sdushantha/tmpmail) | 一个比较实用的命令行工具，可用于快速生成临时电子邮箱。当你需要注册某些不太重要的网站，接收某些临时电子邮件，规避垃圾邮件轰炸时能派上大用场，并且能帮你进一步提升隐私安全性。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KpTROrWeZ)
[CopyTranslator](https://github.com/CopyTranslator/CopyTranslator) | 一个开源的翻译神器，你只需将文本复制到剪贴板，即可快速查看翻译结果，享受所见即所得的快感。在对翻译结果的处理上，还会帮你解决多余的断句和换行所带来的乱码问题，使其更符合阅读习惯。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KpDmWepOO)
[Ventoy](https://github.com/ventoy/Ventoy) | 一款能用于制作可启动 U 盘的装机神器，有了它之后，今后装机无需再反复格式化 U 盘，只需将 ISO/WIM/IMG/EFI 文件拷贝到 U 盘即可启动，无需其他操作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KptWsydn6)
[WiFi Card](https://github.com/bndw/wifi-card) | 一款比较实用的开源工具，作者是来自西雅图的开发者 Ben Woodward，这款工具的作用，是能将 WiFi 名称和密码，快速转化为二维码。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KoINY1PYU)
[File Browser](https://github.com/filebrowser/filebrowser) | 如果你考虑搭建一个私人网盘，在线管理各种文件资源，那么这个开源项目应该能派上用场。该工具内置登录系统，可在线删除、编辑、创建文件，允许分配多个用户权限，在 Web 浏览器上执行自定义命令行。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ko4W1jCW1)
[nginxconfig.io](https://github.com/digitalocean/nginxconfig.io) | 知名云服务器厂商 Digital Ocean 开源的一款后端开发工具。通过更为人性化的可视化界面，帮你快速设置并生成 Nginx 配置文件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KnXFx1XTZ)
[ArchiveBox](https://github.com/ArchiveBox/ArchiveBox) | 一款比较实用的互联网资源存档工具，可离线保存你浏览过网页内容，其中包括 HTML 页面、PDF 文件、图像视频等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KnLSRd95c)
[Mathpix](https://www.cs.usfca.edu/~galles/visualization/Algorithms.html) | 如果你经常用 LaTeX 编写文档，可以试下 Mathpix。这款工具能将带数学公式的截图一键转成 LaTeX 代码，堪称神器！ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KnEOv1vM1)
[Audacity](https://github.com/audacity/audacity) | 一款功能颇为强大的多轨音频编辑及录制工具，可导入导出多种音频格式，通过可视化界面，快速分析音频信号。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KnB5hfOfL)
[Typora LaTeX theme](https://github.com/Keldos-Li/typora-latex-theme) | 为了方便本科生撰写小型论文或实践报告，浙大一名学生在 GitHub 开源了一个仿 LaTeX 主题 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KnrwPefEv)
[SigNoz](https://github.com/SigNoz/signoz) | 一款比较实用的开源工具，作为 DataDog、NewRelic 的开源替代品，可帮助开发者实时监控并分析项目问题 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KmysSDwdM)
[mumble](https://github.com/mumble-voip/mumble) | 一款开源的语音聊天软件，具备低延迟、通信质量高、安全私密性强等特点，适合用于通话或游戏交流。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KmnsYvvmB)
[WhyNotWin11](https://github.com/rcmaehl/WhyNotWin11) | 一款脚本工具，可用于快速检测电脑是否适用于 Windows 11，其中包括主机整体基础架构、CPU 兼容性、硬盘分区类型、RAM、存储空间等属性。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Km8JGBcrW)
[NocoDB](https://github.com/nocodb/nocodb) | 一款开源的在线表格工具，可将各类主流 SQL 数据库转为智能电子表格，作为 Airtable 的开源替代方案，功能颇为强大。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KlNkqdpVd)
[Files](https://github.com/files-community/Files) | 一款在 GitHub 开源的 Windows 文件管理神器，发现该软件的诸多特性挺适合开发者日常处理工作的。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KlGQyzo0Y)
[Yearning](https://github.com/cookieY/Yearning) | 一款可用于 SQL 审核的开源神器，该工具致力于帮助开发者快速完成 SQL 语句的审核、检测、执行、回滚等操作，使日常的 SQL 变动得以更加规范化、标准化。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Klx1HtXSV)
[小白羊](https://github.com/liupan1890/xiaobaiyang2) | 国内一名开发者 GitHub 上开源了一款网盘工具，该工具支持多账号管理、文件在线预览、批量管理、队列上传与下载、任务脚本回调、远程操作访问等核心功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KlbCH6Thy)
[ENScan](https://github.com/wgpsec/ENScan) | 一款开源的企业信息查询工具，可用于更加快速的获取企业信息，减少收集的工作量。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KkCgyxPNT)
[Narakeet](https://github.com/narakeet/examples) | 一款颇为实用的工具，可将 Markdown 或 PPT 文档快速转换为视频，便于应用到项目教程、Demo 或者 Vlog 等场景。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KjGwIAFGP)
[RustDesk](https://github.com/rustdesk/rustdesk/) | 一款开源的远程桌面控制程序，开箱即用，无需配置，可充当 TeamViewer 和 AnyDesk 的替代品。软件数据可自行托管到私有服务器，确保数据安全。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KjvUXb2tt)
[Nettu Meet](https://github.com/fmeringdal/nettu-meet) | 一个开源的视频会议系统，为交互式在线辅导而生。该系统主要支持实时视频会议，屏幕、白板、文件共享，文字消息聊天，数学图形绘画等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KjoQB1B7p)
[Orchest](https://github.com/orchest/orchest) | 一款比较实用的开发工具，里面集成了各类常用的数据科学工具，开箱即用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kjd3Y4ADs)
[Cloudreve](https://github.com/cloudreve/Cloudreve) | 一个开源的公有云文件系统，支持多家云存储驱动，客户端直传、下载限速、文件管理、用户权限分配等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KjbuxAkG6)
[macOCR](https://github.com/schappim/macOCR) | 一款适用于 Mac 的 OCR 命令行工具，开发者可以用它将电脑屏幕上的文本信息转换为剪贴板上的文本，目前已支持多个不同语言文字的识别。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KikSk81Ji)
[termpair](https://github.com/cs01/termpair) | 一个挺有趣的开发工具，开发者可通过浏览器实时访问、使用电脑上的命令行终端，整个访问过程将基于端对端加密 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KijG2AyyZ)
[what-anime-cli](https://github.com/irevenko/what-anime-cli) | 一个挺有意思的命令行工具，可在命令行中通过动漫图片，快速检索出其作品信息，支持多种图片格式。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)]()
[deskreen](https://github.com/pavlobu/deskreen) | 可将电脑屏幕共享到任意带有浏览器的设备上，使之成为电脑的第二块屏幕。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JELGkBbAV)
### 插件

名称 | 简述 | 源
---- | ----- | -----
[Code With Me](https://www.jetbrains.com/code-with-me/) | 因为疫情，国外有不少程序员需要在家远程办公。为此，JetBrains 发布了一款插件，提供了多项功能，以便打造更好的协作开发与结对编程体验。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7Z70ygon)
[ChinesePinyin-CodeCompletionHelper](https://github.com/tuchg/ChinesePinyin-CodeCompletionHelper) | 国内开发者做的一款 IDEA 骚插件，支持用中文来编写代码，享受和英文环境一致的中文智能编码体验。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L60yz3KmQ)
[PaperMemory](https://github.com/vict0rsch/PaperMemory) | 一款可自动管理论文的浏览器插件，可自动存储、标记、搜索、下载曾经阅读过的论文，支持 Arxiv、BioRxiv、OpenReview 等论文平台。插件管理数据均存储在本地，可下载导出为 JSON 文件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L4206fmke)
[huile8](https://github.com/mqycn/huile8) | 一款能帮你背单词的 VSCode 插件，可将代码变量、注释、文档中的陌生英文单词，添加进 VSCode 单词库中，让你在 VSCode 上也能背单词 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1jue4zPT)
[Automa](https://github.com/Kholid060/automa) | 一款颇为实用的 Chrome 神器，可通过连接不同的任务区块，来自定义浏览器工作流。工作流可执行表单填写、屏幕截图、网站数据抓取等各种重复性工作。不仅于此，你还可以设置任务的执行时间，以满足多种不同场景的使用需求。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L0Nhd0CWn)
[Code Tour](https://github.com/microsoft/codetour) | 一款比较实用的 VSCode 插件，由微软技术团队开源。其主要功能，是能用于录制与回放项目代码浏览过程。在浏览代码的过程中，可用该插件插入浏览步骤、文本注释，并且还能设置跳转的代码区块，嵌入能运行的命令行等操作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KzW4BgppD)
[Project Naptha](https://projectnaptha.com/) | 一款颇为实用的 Chrome 插件，可选中、复制、编辑、翻译图片中的内嵌文字。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KxeJLtgM1)
[Visual Python](https://github.com/visualpython/visualpython) | 一个比较有趣的 Jupyter Notebook 插件，实现了Python 可视化编程，可作为面向程序员或非程序员的数据分析解决方案。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kox1lF6Dz)
[anes-repository](https://github.com/gamedilong/anes-repository) | 有个开发者搞了个 VSCode 小霸王插件，里面提供了超级马里奥、魂斗罗、彩虹岛、雪人兄弟、坦克大战等经典游戏供玩家体验。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KnN3Vomur)
[GitHub Copilot](https://copilot.github.com/) | GitHub 与 OpenAI 联手发布了一款开发神器，旨在借助 AI 的力量，帮助开发者快速完成代码编写，大幅提升开发效率。开发者在 VSCode 上安装后，便可使用 Copilot，实现智能代码补全的操作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KmAP0qNan)
[Netease Music for VS Code](https://github.com/YXL76/cloudmusic-vscode) | 一款开源的 VSCode 扩展，开发者可直接使用 VSCode 来播放网易云音乐的歌曲。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KlvP1bNh8)
[intellij-media-player](https://github.com/wuyr/intellij-media-player) | 国内一位开发者为了上班能用代码编辑器看视频，撸了个 IDE 插件，并适配了 JetBrains 全家桶。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KkjpzwSTV)
[papers-with-video](https://github.com/amitness/papers-with-video) | 一款比较实用的 Chrome 扩展，用户在使用 arXiv 查看论文时，可自动链接到论文相关的视频页面上。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JFgJo3nsu)

### 资料集合

名称 | 简述 | 源
---- | ----- | -----
[Unity3DTraining](https://github.com/XINCGer/Unity3DTraining) | 整理了一些 Unity 游戏相关的开源项目、开发者工具、技术教程等内容，方便新手用于日常实践与学习。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L8C032977)
[Magic Tools](https://github.com/ellisonleao/magictools) | 一份开源的游戏开发教程，整理了游戏开发相关的工具、美术素材、项目源码、计算机图形学等资源。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7oA5nYtT)
[Treasure-of-Transformers](https://github.com/ashishpatel26/Treasure-of-Transformers) | 收录了 100 多个高质量的自然语言处理 Transformers 模型，并附有相关的论文、视频、博客、代码仓库等内容介绍。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7np2lnsT)
[The Machine & Deep Learning Compendium](https://github.com/orico/www.mlcompendium.com/) | 一份颇为全面的 AI 学习资源，覆盖了数据科学、概率与统计、博弈论与信息论、数据结构与算法、深度神经网络、全栈工程师等多个领域的学习资料与开发者工具。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6TWv84xt)
[LeetCode](https://github.com/begeekmyfriend/leetcode) | 一个基于纯 C 语言实现的 LeetCode 题解仓库，共有 200 多道题，涵盖链表、队列、堆栈、递归、动态规划、二叉搜索树等知识点。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6DrD8SBj)
[《2021 年优质 AI 论文整理》](https://github.com/louisfb01/best_AI_papers_2021) | designstripe 的首席 AI 研究科学家在 GitHub 开源的，里面摘选的论文，主要探讨图像合成、AI 未来发展方向、海洋垃圾自动检测、人脸生成的真实性、增强现实在游戏中的应用等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L4npnvi3C)
[Tech Interview Cheat Sheet](https://github.com/TSiege/Tech-Interview-Cheat-Sheet) | 一份开源的技术面试清单速查表，主要收录了数据结构与算法的常见面试技术点。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L3SzB8ULf)
[LeetCode company wise](https://github.com/MysteryVaibhav/leetcode_company_wise_questions) | 一名卡内基梅隆大学硕士生开源的 GitHub 项目，把众多知名大厂的 LeetCode 题目整合到一起，并打包成了 PDF，便于大家学习。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L3J96hSF2)
[42_CheatSheet](https://github.com/agavrel/42_CheatSheet) | 一份开源的编程速查表，里面列举了新手开发者的常犯错误、软件编码指南、程序员开发工具配置、计算机编程学习资源（C 语言、算法、网络、黑客与安全）等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L3jpUeswD)
[Docker Cheat Sheet](https://swissarmydevops.com/wp-content/uploads/2020/11/Docker_Cheat_Sheet-1.pdf) | 一份 Docker 速查表，可直接下载 PDF。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2Y2EqJiv)
[free-api](https://github.com/fangzesheng/free-api) | 国内一位开发者在 GitHub 维护的免费 API 文档，每月不定期收录互联网上开放的 API 接口。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2OA8iuo5)
[《深度学习入门学习资源》](https://github.com/Mikoto10032/DeepLearning) | 华南理工大学的一名硕士生整理的，里面包含各类深度学习相关的技术教程、优秀文章、视频教程。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2ntH4TiB)
[useful-sed](https://github.com/adrianscheff/useful-sed) | Linux sed 命令行常用汇总，收集了 sed 命令行的诸多常见用法，可用于快速处理文本文件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2bH52dk4)
[Web Attack Cheat Sheet](https://github.com/riramar/Web-Attack-Cheat-Sheet) | 现任惠普的高级网络安全工程师 Ricardo，在 GitHub 开源了一份 Web 攻击速查表，里面提供了相关开发工具与实现方案。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1Wzr7PAG)
[TH-CPL](https://github.com/bugaosuni59/TH-CPL) | 清华大学计算机学科推荐学术会议和期刊列表。覆盖了高性能计算、计算机网络、网络与信息安全、理论计算机科学、系统软件与软件工程、数据库与数据挖掘、人工智能与模式识别、计算机图形学与多媒体等领域。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1JpAbuBs)
[《Android 工程师进阶手册》](https://github.com/Skykai521/AndroidDeveloperAdvancedManual) | 国内一位 Android 开发者作者开源的，将手册按工程师能力，划分为初级、中级、高级三个阶段。在不同阶段，从技术、职场、学习等方面给出了不同建议。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L0oVfuEsd)
[《KCon 黑客大会演讲 PPT》](https://github.com/knownsec/KCon/) | 2021 年包含了 macOS Big Sur 内核漏洞挖掘、云虚拟化安全、服务器硬件可信与安全实践等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L0kZIaZUv)
[《树莓派防吃灰》](https://github.com/zhaoolee/pi) | 国内一位开发者在 GitHub 开源的树莓派学习资料，主要收录了作者撰写的一些树莓派学习教程与开发技巧。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KFBf50sWL)
[Hacker Game 2021](https://github.com/USTC-Hackergame/hackergame2021-writeups) | 中科大信息安全大赛团队在 GitHub 上开源的赛事题解，主要包含官方与选手们的题目描述、文件、源代码、技术解析文章等内容。包含多种解题思路与实现技巧，颇有参考价值。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KFxjyeUfu)
[Algorithms-Cheatsheet-Resources](https://github.com/starkblaze01/Algorithms-Cheatsheet-Resources) | 印度一位小哥整理的计算机编程资源，主要包含多种编程语言的常用速查表、算法实现库、扩展学习资源等内容。覆盖机器学习、Python、Go、VSCode、JavaScript、Git 等技术领域。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KFeEIiIYY)
[The Algorithms](https://the-algorithms.com/) | GitHub 上最大的算法开源库，网站收录了 Python、Java、C++、JavaScript、Go 等多种主流编程语言的算法代码实现。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KEQ6CxUJb)
[Awesome-ICCV2021-Low-Level-Vision](https://github.com/Kobaayyy/Awesome-ICCV2021-Low-Level-Vision) | 整理了 2021 年 ICCV 中，图像生成与底层视觉相关的论文和代码，包括图像生成，图像编辑，图像风格迁移，图像翻译，图像修复，图像超分及其他底层视觉任务等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KElt0dXLK)
[《深度学习论文精读》](https://github.com/mli/paper-reading) | 里面选取了近 10 年在深度学习领域比较有影响力的必读文章，并为之做视频讲解。文章将覆盖 ResNet、Transformer、BERT、GPT3、GAN、AlphaGo 等深度学习领域的常用框架、算法以及实际应用等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KEeoBBZTT)
[CheatSheetSeries](https://github.com/OWASP/CheatSheetSeries) | OWASP（开放式 Web 程序安全项目）出品的一份技术速查表，覆盖了用户授权验证、访问控制、跨站请求伪造、Docker 安全、会话管理、SQL 注入等 Web 安全领域相关的技术速查表。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KEddyBBDB)
[Cpp-0-1-Resource](https://github.com/AnkerLeng/Cpp-0-1-Resource) | 一份开源的 C++ 入门学习资源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KDM78yRjG)
[《算法・进阶石》](https://github.com/acm-clan/algorithm-stone) | 一位开发者在 GitHub 整理的 ACM / LeetCode 算法竞赛路线图，包含了红黑树、动态规划、堆栈队列、链表、二分查找、几何问题等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KDJKZCWoE)
[《Git 飞行规则》](https://github.com/k88hudson/git-flight-rules/blob/master/README_zh-CN.md) | 一份开源的 Git 学习指南，其理念来自于 NASA 给宇航员的指南，主要用于指导问题出现后的应对之法。指南里面记录了某个事情发生的原因，以及怎样进行流程化处理。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KDE3R7XSW)
[Financial-Knowledge-Graphs](https://github.com/jm199504/Financial-Knowledge-Graphs) | 一份开源的小型金融知识图谱构建流程，可帮助你更好的学习与理解知识图谱的使用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KDiEAp0ZM)
[《A Complete Machine Learning Package》](https://github.com/Nyandwi/machine_learning_complete) | 一份颇为全面的机器学习资源，覆盖 Python 编程、数据分析与可视化、计算机视觉、开发工具、最佳实践等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KD0YEk4Jp)
[《数学建模学习资源》](https://github.com/zhanwen/MathModel) | 主要包含数学建模相关的竞赛优秀论文、算法、LaTeX 论文模板、算法思维导图、书籍、Matlab 教程等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KCX36pSDc)
[Penetration Testing POC](https://github.com/Mr-xn/Penetration_Testing_POC) | 国内开发者 Mr-xn 在 GitHub 发布的一份渗透测试笔记。里面汇总了渗透测试工作中常用的 POC、脚本、工具、学习资源、操作技巧等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KAhhH2BJ9)
[《机器学习自学指南》](https://github.com/python-engineer/ml-study-plan) | 国外一名工程师为 AI 开发者定制的《机器学习自学指南》，内容覆盖线性代数、多元微积分、基础机器学习、深度学习等知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KAeVAq9OQ)
[Reflection Summary](https://github.com/sladesha/Reflection_Summary) | 国内一位 AI 工程师在 GitHub 上开放的一套算法理论基础知识，里面涵盖了数学、数据预处理、机器学习、深度学习、自然语言处理等多个技术领域的面试知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KA3VFsdtM)
[《代码安全指南》](https://github.com/Tencent/secguide) | 腾讯开发人员在 GitHub 上开源的《代码安全指南》，旨在梳理 API 层面的风险点并提供详实可行的安全编码方案。包含 C/C++、JavaScript、Node、Go、Java、Python 等多个不同编程语言版本。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KzGWWw61p)
[《图解 React 源码系列》](https://github.com/7kms/react-illustration-series) | 作者将通过大量配图，把 react 原理表述清楚。主要包含 React 基础概念、运行核心、数据管理、交互、高频算法等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KyIECuHVh)
[《The Machine & Deep Learning Compendium》](https://github.com/orico/www.mlcompendium.com) | 国外工程师 Ori Cohen 在 GitHub 上开源了一个开放式知识共享项目，里面主要整理了其过去 4 年撰写的机器学习与深度学习纲要，共 500 个主题，覆盖机器学习算法、统计、特征选择和工程技术、深度学习、NLP、时间序列、计算机视觉等分类。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KxkeJ2Sh4)
[any-rule](https://github.com/any86/any-rule) | 正则大全， 收录了 70+ 条常用正则表达式，支持 web /vscode/idea / Alfred Workflow 等多个平台。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kx2X9sNIp)
[《一图胜千言》](https://github.com/girliemac/a-picture-is-worth-a-1000-words) | 主要创作了包含数据结构与算法、Web 开发、机器学习等编程领域的涂鸦作品，其中有部分被应用到了微软的开源教程，感兴趣的同学可以收藏学习一下。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kx1nJDtSF)
[《编程、数学、科学》](https://github.com/bobeff/programming-math-science) | 国外一位开发者近期在 GitHub 上开源的资料仓库，里面收录了编程、数学、科学领域相关的工具、书籍、网站等内容，涵盖算法、命令行工具、数据库、设计模式、GUI 编程、操作系统、文本编辑器等分支。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kwrfa2RRb)
[fun-with-computer-graphics](https://github.com/zheng95z/fun-with-computer-graphics) | 国内一位开发者整理的图形学资料，包含各大高校课程、书籍、教程、文章、开源项目、网站等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kwgfflp1n)
[my-mac-os](https://github.com/nikitavoloboev/my-mac-os) | 伦敦一位开发者将自己平时常用的 Mac 软件及工具统一整理后放到 GitHub 上了，其中包括不少可提升生产力和开发效率的工具，不少也是我平时一直在用的，用 macOS 的同学可以看看。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KvYXFsCRN)
[bigdata_analyse](https://github.com/TurboWay/bigdata_analyse) | 国内一位开发者在 GitHub 开源的数据分析项目库，收集了多个数据分析项目集合。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KvXoileok)
[Most influential books for programmers](https://github.com/cs-books/influential-cs-books) | 整理了多本最具影响力的计算机科学 / 编程书籍，书单源自 Stack Overflow 上的一个回答。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KuW9gkQMd)
[《绝妙的个人生产力》](https://github.com/eastlakeside/awesome-productivity-cn) | 一个开源的生产力工具清单，Awesome Productivity 中文版。收录了与生产力相关的各类书籍、网站、工具等内容，包含日常笔记、知识图谱、文件管理、任务管理、任务自动化、密码管理等类别。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KuMIL9ZyY)
[Phosphor](https://github.com/phosphor-icons/phosphor-home) | 一个开源的图标库，里面共提供了 588 个图标，拥有 6 种不同线条展示风格，你可将其应用于图标、演示文稿、网站页面等任意载体上。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KuAJXf93Q)
[Awesome OCR](https://github.com/zacharywhitley/awesome-ocr) | 列举了一系列 OCR 相关的开发工具、开源项目、技术实现方案、数据集等诸多资源。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kujgd1gm6)
[Online_Tools](https://github.com/r0eXpeR/Online_Tools) | 国内一位开发者在 GitHub 整理的在线情报搜集工具。包含企业信息、IP 信息及域名备案查询工具、Web 应用指纹识别、威胁情报平台、在线提权辅助等各类工具。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KuchX8OXl)
[School of SRE](https://github.com/linkedin/school-of-sre) | 由 LinkedIn 在 GitHub 开源的一份企业内部 SRE 技术课程。主要包含 Linux、Git、Python、Web、MySQL、大数据、系统设计、网络安全等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KtAG1AEkS)
[machine-learning-mindmap](https://github.com/dformoso/machine-learning-mindmap) | 一份开源的机器学习思维导图，整理了从数据分析到深度学习相关的开发流程、技术概念、速查清单等知识点。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KtyjTvN0d)
[Today I Learned](https://github.com/jbranchaud/til) | 作者是来自芝加哥的开发者 Josh Branchaud，该仓库的创建目的，在于收集其平日所学的一些碎片化编程知识和开发技巧。其中包括 Git、JavaScript、Linux、VSCode、Devops、Chrome 等不同技术领域的分类。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ktx8PyR8Z)
[oi-slides](https://github.com/huzecong/oi-slides) | 位开发者将其在 2013-2018 年期间的信息学竞赛课件在 GitHub 上开源了。这份课件覆盖了 TopCoder 题目选讲、CodeChef 题目选讲、趣题选讲、网络流模型与例题、NOIp 图论、数据结构及应用等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kt4gP1Sdo)
[CS-Xmind-Note](https://github.com/SSHeRun/CS-Xmind-Note) | 国内一位开发者整理的计算机科学学习笔记，其中包含计算机组成原理、数据结构、计算机网络、操作系统等技术分类。内容整理得十分详细，是份很不错的学习参考资料。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KsWpKjXgJ)
[Cheatsheet for regex syntaxes](https://github.com/remram44/regex-cheatsheet) | 一份开源的正则表达式语法速查清单。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KsUQk7xrW)
[《Linux 内核揭秘》](https://github.com/MintCN/linux-insides-zh) | 收录并翻译了一系列关于 Linux 内核及其内在原理的技术帖，旨在帮助那些对 Linux 内核内在机理感兴趣的人。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KsMZfqHYd)
[Algorithm Guide](https://github.com/Xunzhuo/Algorithm-Guide) | 一份开源的中文算法指南，该仓库主要分为两大分支，主分支为算法和数据结构教程，次分支为算法竞赛、数据结构相关的课件、论文、书籍、网站、习题整理。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KsFUSFCIL)
[Growth Book](https://github.com/growthbook/growthbook) | 一个开源的 A/B 测试平台，拥有贝叶斯统计引擎、测试结果分类、可视化编辑器、电子邮件警报等功能，还可 Snowflake、Redshift、BigQuery、GA 统计等平台拉取数据。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KsEJOtjOU)
[1earn](https://github.com/No-Github/1earn) | 国内一位开发者在 GitHub 维护的安全知识框架，内容包括但不仅限于 Web 安全、工控安全、取证、应急、蓝队设施部署、后渗透、Linux 安全、各类靶机 writup 等。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ks4cTgO6M)
[poetry](https://github.com/sheepzh/poetry) | 一个华语现代诗歌语料库，里面收录了 2K+ 诗人，42K+ 诗歌，8M+ 字，包括五四至今所有流派的华语现代诗歌。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KrkrDk3Er)
[Machine_Learning_Resources](https://github.com/wangyuGithub01/Machine_Learning_Resources) | 一份开源的机器学习面试资源整理，涵盖特征工程、算法基础、机器学习算法、NLP、推荐系统等知识点。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kr8t01quM)
[useful-scripts](https://github.com/oldratlee/useful-scripts) | 为了提升工作效率，阿里一位后端工程师在 GitHub 上开源了一些比较实用的程序脚本。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kqm9j4mVm)
[Play-Leetcode](https://github.com/liuyubobobo/Play-Leetcode) | 一个Leetcode 算法题解代码仓库，重在强调算法一题多解，同时标注简明的算法思想，时间复杂度和空间复杂度。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KpV2YwHbO)
[wstg](https://github.com/OWASP/wstg) | 一份开源的《Web 安全测试指南》，可用于测试与检查 Web 项目的安全性，便于对漏洞作出及时防护。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KpLCmDvgp)
[UCAS_Course_2019](https://github.com/HuangCongQing/UCAS_Course_2019) | 来自国科大的研究生，在 GitHub 上整理了一份资源库，里面收录了中国科学院大学 2019-2020 年的部分课程 PPT，涵盖了图像处理与分析、强化学习、模式识别、自然语言处理、高级算法设计与分析等多个领域。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kp1EX8hd9)
[Vulnerability](https://github.com/EdgeSecurityTeam/Vulnerability) | 一个企业安全漏洞收集库，作者会不定期整理从棱角社区对外公布的最新安全漏洞。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KoR3orZPR)
[Best-websites-a-programmer-should-visit-zh](https://github.com/tuteng/Best-websites-a-programmer-should-visit-zh) | 一个资源库，里面收录了不少程序员在日常生活工作中，经常用于查阅或学习的技术网站。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Koycpjl8S)
[Algorithm Base](https://github.com/chefyuan/algorithm-base) | 一个开源算法知识库，通过动画配图及文字介绍的方式，让开发者可以更加轻松的学习并吸收算法知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KooLUcTXA)
[comments-for-awesome-courses](https://github.com/conanhujinming/comments-for-awesome-courses) | 名校公开课程评价网，由多个 GitHub 开发者共同参与维护的一个开源项目，主要针对各大高校计算机课程在学习难度、课程规划、进阶资源等方面，做出整理与总结。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ko3mBoO6q)
[reverse-engineering](https://github.com/wtsxDev/reverse-engineering) | GitHub 上一位开发者整理的逆向工程学习资源，包含书籍、课程、项目实践、开发工具等多个分类。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KnOf07WLs)
[Doing the PhD](https://github.com/shengyp/doing_the_PhD) | 一份开源的读博指南，其主要目的，在于让博士生掌握更多读博相关信息，从而做出更为准确的判断。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KnCsmkZ20)
[Psyduck](https://github.com/SmartKeyerror/Psyduck) | 国内一位开发者在 GitHub 上开源了技术思维导图，借助 Xmind，绘制并注解了关于 Linux 操作系统、计算机网络、数据库、Redis、C++、Golang 相关的基础知识，便于开发者快速吸收与复习。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Knvo08gha)
[systems-programming-cheat-sheet](https://github.com/jstrieb/systems-programming-cheat-sheet) | 一份开源的系统编程速记清单。该清单是作者在 2019 年春季，在卡内基梅隆大学学习「计算机系统概论」时编写而成，主体内容基于《深入理解计算机系统》一书。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KnlXup4mK)
[campus_recruitmen_questions](https://github.com/0voice/campus_recruitmen_questions) | 一个开源的资料库，收集了 5000 道校招常用面试题，包含 leetcode，校招笔试题，面试题，算法题，语法题，目前仍在持续更新中 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KnkMqteiK)
[Digital-Privacy](https://github.com/ffffffff0x/Digital-Privacy) | 为了保护个人数据安全，GitHub 用户 ffffffff0x 整理了一套关于数字隐私搜集、保护、清理集一体的方案，外加开源信息收集 (OSINT) 对抗。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KnjBmCUlr)
[Modern CPP Tricks](https://github.com/rachitiitr/modern-cpp-tricks) | 微软前工程师 Rachit Jain 在 GitHub 上开源的一份 C++ 知识库。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KmwTt8fqB)
[The Complete FAANG Preparation](https://github.com/AkashSingh3031/The-Complete-FAANG-Preparation) | 一个面试题解仓库，里面包含了数据结构、算法知识点讲解、Facebook、Apple、Google 等互联网公司面试题、基于主流编程语言构建的 Demo 示例等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kll2V3Z99)
[machine-learning-collection](https://github.com/microsoft/machine-learning-collection) | 微软在 GitHub 上开源了一份机器学习相关的资源列表。主要收集微软及其子公司在机器学习领域中常用的一些工具、模型、数据集等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kj5ZJAVwk)
[《代码安全指南》](https://github.com/Tencent/secguide) | 该指南旨在梳理 API 层面的风险点并提供详实可行的安全编码方案。当前已包含 C/C++、JavaScript、Node、Go、Java、Python 等多个不同编程语言版本。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KibqCt5hB)

### 书籍/教程

名称 | 简述 | 源
---- | ----- | -----
[《系统设计面试指南》](https://systemdesign.org) | 由来自 FAANG（Facebook、苹果、亚马逊、奈飞、谷歌）的工程师联合编写。书籍中配套有丰富的插图与面试题，以便帮助开发者更好的掌握系统设计技术，快速通过面试。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L8AOZq5Ub)
[《Learning Patterns》](https://www.patterns.dev/) | 一本开放的前端技术书籍，主要讲解现代 Web 应用的设计模式与组件模式，了解如何使用 vanilla JavaScript 和 React 构建强大的 Web 应用程序。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7mdYcl9Y)
[《从 0 到 1：学习正则表达式》](https://github.com/aykutkardas/regexlearn.com) | 一个很有趣的开源技术教程，与常规技术教程不同，该教程会基于问答的形式，通过可交互式界面与速查表，让你在互动中实践与理解正则表达式，让整个学习过程不再枯燥乏味。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7kVt485S)
[Future Coder](https://github.com/alexmojaki/futurecoder) | 一个开源的可交互式 Python 教程，面向初学者设计，亮点是可以一边在线学习技术，一边敲代码验证结果，强化知识的吸收。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7dYwinIk)
[《Git In The Trenches》](https://cbx33.github.io/gitt/intro.html) | 一本很有趣的技术书籍，作者构建了一家名为 Tamagoyaki 的虚拟公司，通过讲故事的方式，让大家能够有代入感的学习 Git。了解在实际工作中，如何用 Git 来解决问题。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L73mZmnzN)
[《LaTeX 论文写作指南》](https://github.com/xinychen/latex-cookbook) | 主要讲解 LaTeX 发展历史、文本与公式编辑、表格制作、图形绘制与插入等基础用法。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6WiB8SpJ)
[《清华大学计算机系课程攻略》](https://github.com/PKUanonym/REKCARC-TSC-UHT) | 清华学生在 GitHub 上开源的一份学习资料，覆盖了计算机科学导论、数据结构、人工智能导论、计算机组成原理、操作系统、现代密码学、线性代数、微积分等多个领域的资料、课件、参考教材等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6CiHFbjo)
[《Mac 开发环境快速配置指南》](https://github.com/vendasta/setup-new-computer-script) | 国外工程师开源的《Mac 开发环境快速配置指南》，主要包含了命令行、代码编辑器、编程语言开发环境、系统应用等各项配置。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L67ezsvmH)
[《C++ 高性能并行编程与优化》](https://github.com/parallel101/course) | 课程前半段主要介绍现代 C++，后半段主要介绍并行编程与优化。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L5XO5z6my)
[《命令行中的数据科学》](https://github.com/https://datascienceatthecommandline.com/2e/?continueFlag=2b274beee5ac43dac12bbb279065fa2e) | 通过学习，你将掌握如何用命令行工具来获取、清理、探索和建模数据，为了帮你快速入门，作者还提供了一个内置 100 多款 Unix 工具的 Docker 镜像，在主流操作系统上均可使用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L5TGlu2SM)
[《现代 CPU 性能分析与调优》](https://github.com/dendibakh/perf-book/) | 此书是一本 170 页的指南，结合了多个不同行业的专家知识，讲解 CPU 微体系结构、性能分析技巧，以及相关的工具与建议参考等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L5q3EaOwf)
[《动手学深度学习 2.0》](https://github.com/d2l-ai/d2l-zh) | 作为一本面向中文读者的能运行、可讨论的深度学习教科书，已被全球 55 个国家 300 所大学用于教学。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L5oSEtISv)
[MiniTorch](https://github.com/minitorch/minitorch) | 康奈尔科技校区（Cornell Tech）开源的机器学习 DIY 教学库，可帮助工程师更好的了解深度学习系统概念。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L57mNzVgi)
[《图解 NumPy：可视化指南》](https://betterprogramming.pub/numpy-illustrated-the-visual-guide-to-numpy-3b1d4976de1d) | 国外一位名为 Lev Maximov 的工程师写的，通过插图的方式，详细分析并讲解了 NumPy 向量、矩阵、3D 及高维数组的应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L56bKk7xQ)
[《计算机教育中缺失的一课》](https://github.com/missing-semester-cn/missing-semester-cn.github.io) | 麻省理工大学的开源技术教程，该课程主要讲授命令行、文本编辑器、Git 版本控制系统等工具的使用，以及关于元编程、安全和密码学等知识的科普。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L53f6oSRc)
[《Linux 内核模块编程指南》](https://github.com/sysprog21/lkmpg) | 主要讲解 Linux 内核模块简介、模块交互、系统调用、阻塞进程和线程、调度任务、中断处理程序等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L4rx7kW0J)
[《Effective Modern C++ 》](https://github.com/kelthuzadx/EffectiveModernCppChinese) | 作为高效 C++ 丛书之一，通过对复杂技术知识点的清晰阐释，让其成为 C++ 程序设计指南业界标杆。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L43bacj6b)
[《数据科学工具学习指南》](https://github.com/shervinea/mit-15-003-data-science-tools) | 麻省理工大学教授在 GitHub 开源的教程，主要讲解如何使用 SQL 检索数据，R 语言操作数据，Python 数据可视化，Git 代码版本控制，以及常见的 Bash 脚本使用技巧等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L3TKFCQMQ)
[《Spring 实战第六版》](https://github.com/LeonLi0102/spring-in-action-v6-translate) | 一本 Java 技术教程，原作者 Craig Walls 为 VMware 工程师，Spring 团队开发成员。该书主讲 Web 应用程序开发、数据处理、API 开发、REST 服务构建、数据持久化、Spring 管理与部署等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L3PP7D9Xj)
[《My CS Degree - Full-Stack ML Engineering》](https://github.com/logancyang/my-cs-degree) | 一位拥有物理学背景的软件工程师，为了让自己的 CS 专业技能得到更好的提升，设计了一整套 CS 教程，按照不同的学习阶段，教程被划为两块：通识教程（系统性的学习计算机原理知识）和项目教程（实践开发项目）。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L3LHoqfeo)
[《数据科学学习指南》](https://github.com/amitness/learning) | 该指南包含电子表格与数据库的数据处理、命令行工具使用、数据分析与可视化技巧、论文阅读方法，各类模型与算法讲解等知识，另外还有商业思维培养、写作与沟通技巧等非技术类内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L37t8sVfK)
[《Google 工程实践文档》](https://github.com/google/eng-practices) | Google 在 GitHub 开源的一份工程实践文档，此文档为 Google 工程师长期累积的最佳实践，希望通过这份文档，能帮助更多开发者完成代码审查工作，为项目代码提供标准参考。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L36g3wonv)
[《人工智能系统》](https://github.com/) | 微软在 GitHub 开源了一个技术教程，主要讲解支持人工智能的计算机系统设计。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L34GDqA7g)
[《深入浅出现代化Web 编程》](https://github.com/villeheikkila/fullstackopen) | 内容基于赫尔辛基大学的计算机课程编写而成，该课程共有 13 个章节，主要讲解 Web 开发基础知识、服务器端通信、React 项目开发、REST API 编写、单页面应用搭建、CI/CD 与容器使用等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2WPA98Vn)
[《深度学习》](https://github.com/Atcold/NYU-DLSP21) | 主讲人为 2018 年图灵奖得主，卷积网络之父杨立昆（Yann Le Cun），总课时为 14 周，主要讲解深度学习历史、循环和卷积网络、基于能量的模型、图卷积网络等知识点，并开放教程相关的幻灯片、视频、Jupyter notebook、项目代码等资源。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2Vga185w)
[《用聪明的方法学习 Vim》](https://github.com/wsdjeg/Learn-Vim_zh_cn) | 该书将从零开始，着重于 Vim 编辑器的重点功能，教你如何快速上手并使用 Vim。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2GkH8YWT)
[《LaTeX 写作技巧》](https://github.com/guanyingc/latex_paper_writing_tips) | 港中大的一名学生在 GitHub 上开源的，适用于撰写研究论文。项目里面会提供一些已发布论文作为示例，提供表格及图形方面的排版参考 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2F9Cziqd)
[《分布式系统模式》](https://github.com/dreamhead/patterns-of-distributed-systems) | 收录了一系列关于分布式系统实现的文章，主要介绍像 Kafka、Zookeeper 等分布式系统在实现过程中采用的通用模式，是学习分布式系统实现的基础。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2a7FcTAx)
[《科学可视化：Python + Matplotlib》](https://github.com/rougier/scientific-visualization-book) | 主要讲解 Matplotlib 库的介绍与基本原理、图形设计、图形布局与组织、3D 图形与动画等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L22gB5vWx)
[《现代化计算机科学自学指南》](https://github.com/izackwu/TeachYourselfCS-CN) | 中文翻译版，主要面向想自学软件的工程师、在校学生、打算转计算机行业的互联网从业人员。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L20HalQYc)
[《C/C++ 程序设计》](https://github.com/ShiqiYu/CPP) | 作者为南方科技大学计算机系于仕琪副教授，同时也是 OpenCV 中国团队负责人。教程共分为 15 个篇章，覆盖 C/C++ 基础介绍、数据类型与算术运算法、数据结构、内存指针、函数、类等多个知识点的讲解。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1SQ5BIZD)
[《基于深度学习和行人重识别》](https://github.com/michuanhaohao/ReID_tutorial_slides) | 浙江大学罗浩博士开放的一个技术教程，课程主要包括深度学习基础、行人重识别理论基础和行人重识别代码实践三个篇章。内容包含各类课件与视频教程。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1HQby6sO)
[《Data Structures Spring 2021》](https://www.cs.umd.edu/class/spring2021/cmsc420-0101/lectures.html) | 美国马里兰大学开放的数据结构教程，主要讲解数据结构基础、二叉树、红黑树、散列、范围树等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1CldodmK)
[cs_study_plan](https://github.com/spring2go/cs_study_plan) | 一份硬核计算机科学 CS 自学计划，偏向软件工程和系统架构方向。旨在帮助开发者制定一个为期 3～5 年的重学 CS 目标，夯实 CS 基本功，达到美国一流大学 CS 专业本科毕业水平。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1ypG7RxL)
[《前端内参》](https://github.com/coffe1891/frontend-hard-mode-interview/) | 一本开源的前端技术书籍，该书共有 11 章，覆盖了技术面试、JavaScript 特性解析、数据结构与算法、主流框架、开发工具、编程范式、设计原则与编程范式等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1qyCi4g3)
[《30 天精通 Git 版本管理》](https://github.com/doggy8088/Learn-Git-in-30-days) | 一份开源的 Git 教程，主要介绍 Git 的一些常用操作，以及日常工作中实际应用场景讲解。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1fKRoIbm)
[《C++ 11 全套设计模式》](https://github.com/jaredtao/DesignPattern) | 一份开源技术资料，里面包含了工厂方法模型、单例模式、策略模式、观察者模式等 23 种模式的常见用法。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L0WHHg2dl)
[《计算机安全和互联网》](https://people.scs.carleton.ca/~paulv/toolsjewels.html) | 一本免费开放的计算机书籍，主要讲解计算机安全概念与基本原则、身份验证协议、操作系统安全和访问控制、Web 与浏览器安全、软件漏洞利用与提权等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L0zIYBx5n)
[《从零打造一台属于你的数控机床》](https://github.com/maxvfischer/DIY-CNC-machine) | 来自瑞典的工程师 Max Fischer 在 GitHub 开源了一份技术教程，在该教程中，作者将手把手教你如何自制一台自动化数控机床，里面包含完整的物料清单、3D 打印部件、硬件及软件的安装说明等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L03I8lwfT)
[《计算机体系结构基础》](https://github.com/foxsen/archbase) | 一本开源技术书籍，作者将从微处理器设计的角度出发，充分考虑计算机体系结构的学科完整性，强调体系结构、基础软件、电路和器件的融会贯通。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KFGK3736o)
[《同构 - 编程中的数学》](https://github.com/liuxinyu95/unplugged) | 主讲自然数和计算机程序、欧几里得算法、递归的形式与结构、斐波那契数列、罗素悖论、数学基础的分歧等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KDjPD6IjR)
[《自己动手写编译器》](https://github.com/pandolia/tinyc) | 介绍如何通过实现一个简单的编译器（TinyC），并借助实例来描述基本的编译原理及过程。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KCGWAoyac)
[《深入系统》](https://diveintosystems.org/book/index.html) | 国外一本计算机系统教程，作者为来自西点军校与斯沃斯莫尔学院的博士。教程将从 C 语言展开，带你了解 C 语言调试工具、二进制、冯诺依曼结构、汇编、代码优化、共享内存等相关知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KCyH9q2jk)
[《实时渲染第四版》](https://github.com/QianMo/Real-Time-Rendering-4th-Bibliography-Collection) | 该资料可作为研究实时渲染与计算机图形学技术的读物，里面收录了超过 2000 份的参考文献，主要介绍图形渲染管线、图形处理单元、纹理与阴影、图像空间效果、图形硬件等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KCwl2x6BF)
[GeoBlender](https://github.com/JoeWDavies/geoblender) | 一个开源教程，主要教你如何使用 QGIS 和 Blender 软件，制作带有阴影效果的浮雕地图。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KC6pFsxN3)
[《恶意软件逆向工程手册》](https://ccdcoe.org/library/publications/malware-reverse-engineering-handbook/) | 作者是来自 CCDCOE Technology Branch 的研究人员。开放这本手册的目的，在于帮助技术人员更好的利用技术手段，去合理分析 Windows 上那些恶意软件的可执行文件，以便更好的抵御恶意软件的威胁。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KBWZa3oUs)
[《服务器编程指南》](https://github.com/howardlau1999/server-programming-guide) | 主要讲解服务器编程中的程序编译装载、C++ 项目构建、多线程与多进程编程范式使用、程序调试与部署等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KBT3D4EwT)
[《给初学者看的数据科学》](https://github.com/microsoft/Data-Science-For-Beginners) | 微软在 GitHub 上开源了一份数据科学教程，课时为期 10 周，共 20 节，主讲数据科学通用定义、统计与概率导论、使用 SQL 与 NoSQL 处理数据、Python 与数据可视化等知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KBLcyzVAy)
[《机器学习之数学》](https://github.com/mml-book/mml-book.github.io) | 该书主要分为两大部分，一讲数学基础，二讲数学在机器学习算法中的应用。你能从该书中学到线性代数、微积分和概率论等数学基础知识 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KzYqIxykt)
[《深度学习在图像处理中的应用教程》](https://github.com/WZMIAOMIAO/deep-learning-for-image-processing) | 里面主要整理了作者在研究生期间的学习内容，教程将以视频的内容呈现，主要介绍网络结构与创新点、基于 PyTorch / TensorFlow 搭建与训练网络。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KyJPGa2el)
[《Practical Go Lessons》](https://www.practical-go-lessons.com/) | 一个 Go 语言技术教程，由国外一名开发者历经两年多编写而成。作者将通过这个教程，循序渐进的带你了解 Go 语言的基础知识，以及常见的计算机科学概念 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KyH5cjoHV)
[《技术开发指南》](https://techdevguide.withgoogle.com) | 想提升下编程技能，可以看下 Google 开放的这个指南，该指南在于帮助对软件专业感兴趣，或从事本专业的人员更好的掌握计算机科学。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KyBAeg6zt)
[《逸仙 OS 简明教程》](https://github.com/YatSenOS/YatSenOS-Tutorial-Volume-1) | 想了解「如何从零开始编写操作系统」的同学，可以看下中山大学在 GitHub 上的这个开源项目。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KyxEI3YR6)
[《带你入门前端工程》](https://github.com/woai3c/introduction-to-front-end-engineering) | 一本开源的前端技术书籍，主要记录作者在近两年来，在前端工程师实践经验和学习心得方面的总结。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KytwYgwJE)
[《LaTeX 入门教程》](https://www.learnlatex.org/en/) | 一个对新手友好的开源技术教程，主要讲解 LaTeX 基础知识、常见用法、文档布局、错误处理等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KyeNI8HFk)
[《开始机器学习》](https://github.com/louisfb01/start-machine-learning) | 国外一名工程师在 GitHub 开源了他总结的机器学习指南，主要列举了机器学习入门必备的视频、书籍、开放教程等资源，并针对不同编程经验的人群，给出了不同的学习参考建议，有考虑学习机器学习的同学可以看下 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ky87Gr9Mc)
[《Docker 入门教程》](https://github.com/docker/getting-started) |  Docker 官方在 GitHub 开源的教程，主要讲解如何创建、运行并删除容器、数据持久化处理、多容器支持、Compose 的使用等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ky5nck1yv)
[使用 Rust 迈出第一步](https://docs.microsoft.com/zh-cn/learn/paths/rust-first-steps/) | 微软开源的一个 Rust 入门教程，主要讲解 Rust 基础概念、错误处理、内存管理、自动测试、命令行程序编写等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KxZSgjHqv)
[《Design patterns for humans》](https://github.com/guanguans/design-patterns-for-humans-cn) | 中文版，简单解释设计模式！一份超全的设计模式指南，共包含 23 种设计模式的讲解，每一种作者都采用了通俗易懂的方式给大家做讲解，希望能帮助开发者更好的理解设计模式。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KxXw8dIHG)
[《算法》](https://github.com/jeffgerickson/algorithms) | 想学算法的同学可以看下伊利诺伊大学教授 Jeff Erickson 写的《算法》一书。这位老教授在 UIUC 教了 20 年的书，授课内容与经验都浓缩在这本书上了。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KxVWI90rK)
[《Clean Code JavaScript》](https://github.com/ryanmcdermott/clean-code-javascript) | Google 工程师 Ryan McDermott 根据 《Clean Code》总结的一份适用于 JavaScript 的软件工程指导准则，希望能帮你写出易读、易复用、易重构的 JavaScript 代码。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kxoagmw6C)
[Web Development In 2021](https://github.com/andrews1022/web-development-2021-course-list) | 国外一位开发者根据 Udemy 的热门课程，整理了一份 Web 开发者 2021 年学习指南，里面包含常用的 Web 开发工具、设计软件、主流框架、基础知识、后端 & DevOps 技术堆栈等分类。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kx5jgCeQP)
[《C 语言教程》](https://github.com/wangdoc/clang-tutorial) |主要讲解 C 语言的发展历史及一些基础语法，如变量、运算符、指针、函数、命令行环境等内容。  | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KwTwFfBdS)
[Raspberry Pi OS](https://github.com/s-matyukevich/raspberry-pi-os) | 想学操作系统开发的同学可以看下 GitHub 上这个开源教程，该项目将基于树莓派与 Linux 内核，手把手教你创建一个简易版的操作系统：Raspberry Pi OS。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KwkaNzoGc)
[《Bash 脚本教程》](https://github.com/wangdoc/bash-tutorial) | 主要讲解 Bash 的一些基础用法，如变量、字符串操作、算术运算、脚本入门等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KwaKj3uxX)
[《Getting Things Done with Pytorch》](https://github.com/curiousily/Getting-Things-Done-with-Pytorch) | 开发者可从该书中学到有关 PyTorch、神经网络、图像分类、人脸检测、情感分析等基础知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KvHtUr1Nj)
[《Computer Vision Recipes》](https://github.com/microsoft/computervision-recipes) | 微软在 GitHub 上开源的一份计算机视觉指南，提供了诸多可用于构建计算机视觉的代码示例与最佳实践准则。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kvz2j6jgc)
[《A Byte of Vim》](https://github.com/swaroopch/byte-of-vim) | 这本书将会教授你一些与 Vim 相关的基础知识，例如 Vim 的发展历史、安装方式、常用操作与快捷命令，以及如何通过编写脚本与安装插件来扩展更多 Vim 功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kvf0friYp)
[《深入理解 TypeScript》](https://github.com/jkchao/typescript-book-chinese) | 该书将从基础到深入，全面阐述 TypeScript 的各种魔法，并结合实际场景用例，让你更深入的理解 TypeScript。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kv2PhowAd)
[《Web 应用安全》](https://www.nginx.com/resources/library/web-application-security) | 推荐 Nginx 的一本开源技术书籍，该书主要讲解 Web 应用常见漏洞、Web 安全保护措施部署、应用安全性提升具体技巧、Web 应用权限管理等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KuJYn7nmQ)
[IoT Technical Guide](https://github.com/IoT-Technology/IOT-Technical-Guide) | 一份高质量的 IOT 技术教程，包含从零搭建高性能物联网平台、物联网解决方案、以及 Thingsboard 源码分析等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KtQYJ4RSE)
[《algorithm-note》中文版](https://github.com/Dairongpeng/algorithm-note) | 一份开源的算法笔记，，该系列包括数组，链表，树，图，递归，DP，有序表等相关数据结构与算法的讲解及代码实现。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KtJUlbaZO)
[《Kubernetes 加固指南》](https://github.com/rootsongjc/kubernetes-hardening-guidance) | 由 NSA 发布，一名开发者将其译为了中文，主要包含 Kubernetes Pod 安全、网络隔离与加固、认证和授权、日志审计、应用安全实践等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KtdHjyT3R)
[《计算机网络－自顶向下方法》](https://github.com/moranzcw/Computer-Networking-A-Top-Down-Approach-NOTES) | 一份经典的计算机网络书籍《计算机网络－自顶向下方法》笔记，主要有英文版书籍课后习题翻译，以及用 Python 语言解答的代码记录，包含第二章应用层、第四章网络层、Wireshark 实验部分等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ksjkvs07V)
[《计算机系统要素 - 从零开始构建现代计算机》](https://github.com/woai3c/nand2tetris) | 该书主要讲解了计算机原理、编译原理、操作系统相关知识。内容通俗易懂，翻译也很给力。每一章背后都有对应的练习，需要你手写代码去完成，堪称理论与实践结合的经典。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Krfxqj0ig)
[《动手构建一个简单数据库》](https://github.com/cstack/db_tutorial) | 一个开源技术教程，作者将基于 C 语言，手把手构建一个类 SQLite 数据库，让你进一步了解数据库的工作原理。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KqPBR9NeS)
[《PyTorch 基础》](https://docs.microsoft.com/en-us/learn/paths/pytorch-fundamentals/) | 微软开放的一套技术教程，主要讲解 PyTorch 及其实际应用领域的基础内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KpzrpezTO)
[MIT6.S081](https://github.com/huihongxiao/MIT6.S081) | 国内一名开发者在学习 MIT 本科课程《MIT6.S081 操作系统工程》一课时，对其进行了翻译，目前中文版已在 GitHub 开源。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KoSeslCYn)
[《现代统计学导论》](https://github.com/OpenIntroStat/ims) | 该书主讲数据基础、数据分析、回归建模、统计推断、推理建模等知识。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KoHCTxErh)
[《凤凰架构：构建可靠的大型分布式系统》](https://github.com/fenixsoft/awesome-fenix) | 一本开源的后端技术书籍，以 “如何构建一套可靠的分布式大型软件系统” 为叙事主线的开源文档，也是可帮助开发人员整理现代软件架构知识点的技能地图。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KopWYkPGe)
[《给初学者看的 IoT》](https://github.com/microsoft/IoT-For-Beginners) | 微软在 GitHub 上开源了一份物联网教程，课时为期 12 周，共 24 节，主讲物联网通用知识、传感器数据收集、执行器响应处理、硬件联网方式、位置追踪、语音识别等基础知识 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KonAQiakP)
[《现代 C++ 教程》](https://github.com/changkun/modern-cpp-tutorial) | 本书号称『高速上手』，从内容上对二十一世纪二十年代之前产生 C++ 的相关特性做了非常相对全面的介绍，读者可以自行根据下面的目录选取感兴趣的内容进行学习，快速熟悉需要了解的内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KnVjmkGRK)
[《简单粗暴 TensorFlow 2》](https://github.com/snowkylin/tensorflow-handbook) | 本书作为简明的 TensorFlow 2 入门指导手册，基于 Keras 和即时执行模式（Eager Execution），力图让具备一定机器学习及 Python 基础的开发者们快速上手 TensorFlow 2。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KnucVCYgN)
[《给初学者看的机器学习》](https://github.com/microsoft/ML-For-Beginners) | 微软在 GitHub 上开源了一份机器学习教程，课时为期 12 周，共 24 节，主要讲解机器学习简介与历史、自然语言处理、常用 NLP 任务、 语义及情感分析等基础知识，并通过开发南瓜价格预测、美食分类、酒店情感分析等多个项目，带你了解机器学习的实际使用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kni1Xn1bS)
[《设计数据密集型应用》](https://github.com/Vonng/ddia) | 本书将从底层数据结构到顶层架构设计，把数据系统设计中的精髓娓娓道来。其中的宝贵经验无论是对架构师，DBA、还是后端工程师、甚至产品经理都会有帮助。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Km7yDfTVq)
[《给初学者看的 Web 开发教程》](https://github.com/microsoft/Web-Dev-For-Beginners) | 微软在 GitHub 开源了一份 Web 开发教程，课时为期 12 周，共 24 节，主要讲解 JavaScript、CSS、HTML 相关的基础知识，并通过开发打字游戏、浏览器扩展、太空游戏等多个项目，带你了解 Web 开发的整体流程。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KlLKZ7LEg)
[《在 6 个月内掌握云计算的基础知识》](https://github.com/madebygps/self-taught-guide-to-cloud-computing) | 微软工程师 Gwyneth 在 GitHub 上开源了一份「云计算自学指南」，该指南主要拆分为六大模块，分别对应 Linux 及计算机网络基础、脚本及代码工具、云计算、DevOps 实践、学习资源、附加资源（技术相关话题）等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KlEz5wcPP)
[《Go With The Domain》](https://threedots.tech/go-with-the-domain/) | 一本 Go 语言相关的免费电子书，主要教你如何构建一个真实的、开源的、可部署的 Web 应用程序。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Klnp2v0MD)
[《Take your first steps with Rust》](https://docs.microsoft.com/en-us/learn/paths/rust-first-steps/) | 微软免费开放的一个 Rust 新手教程，该课程主要讲解 Rust 基础概念、开发工具、错误处理、内存管理、自动化测试、快速构建第一个命令行程序等内容，比较适合新手入门学习。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KldYxntmo)
[《计算机视觉实战演练：算法与应用》](https://github.com/Charmve/computer-vision-in-action) | 作者为迈微 AI 研习社创始人、CSDN 博客专家。内容有计算机视觉相关的基础知识和预备知识，计算机视觉基础理论（核心部分为神经网络模型）等等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kjq1Dn553)
[《设计可用的电子产品》](http://designingelectronics.com/) | 一本电气工程相关的电子书，作者为 Hunter Scott，现担任 Reach Labs（硅谷科技公司）的硬件工程总监，从事电子产品设计工作十余年，曾创建两家硬件公司，具有颇为丰富的硬件研发经验。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KjnIkz0sJ)
[《JavaScript 二十年》](https://github.com/doodlewind/jshistory-cn) | 一本翻译质量颇高的前端开源书籍，该书自一年前启动翻译，并于前不久出版了纸质书，目前电子版在 GitHub 上已完整开源。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kiqm3EfIa)

### 机器学习/人工智能

名称 | 简述 | 源
---- | ----- | -----
[Animated Drawings](https://sketch.metademolab.com/) | 一款很有趣的 AI 工具，可以借助人工智能技术，让儿童绘画作品动起来。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7be3caHT)
[VNN](https://github.com/joyycom/VNN) | YY 开源的一款高性能、轻量级神经网络部署框架，可将真实人脸快速转换为迪士尼、3D 游戏、油画画像风格的人脸外形，并提供了适配多场景的目标检测、物品分割、对象识别等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L5nHAuA4f)
[MotionPlanning](https://github.com/zhm-real/MotionPlanning) | 来自华为的自动驾驶算法工程师，在 GitHub 开源了一个运动规划算法，里面实现了各类自动驾驶汽车上常用的路径规划 + 路径跟踪算法。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L4vsEo5PJ)
[「NÜWA（女娲）」](https://github.com/microsoft/NUWA) | 微软与北京大学联手，在 GitHub 开源了一个多模态预训练模型，可实现文本/草图转图像、图像补全、文字/草图转视频等任务，功能异常强大。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L3gRDcwqP)
[Qlib](https://github.com/microsoft/qlib) | 一个 AI 量化交易平台，旨在寻求与挖掘 AI 技术在量化投资领域中的价值。里面包含数据处理、模型训练、回溯测试的完整 ML 管道，并且覆盖了量化投资的整个链条：Alpha 探索、风险建模、投资组合优化和交易执行等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2M24EQXi)
[abstreet](https://github.com/a-b-street/abstreet) | 项目可通过软件来模拟街道和十字路口的交通流量，以规划各类车辆的运行网络，进一步改善交通状况。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2l7zjPkT)
[Eiten](https://github.com/tradytics/eiten) | 国外一家热衷于用 AI 与数据分析来做投资分析的企业 Tradytics，在 GitHub 开源的内部工具包，里面主要实现了各种统计与算法投资策略，如最小方差、最大夏普比率和基于遗传算法的投资组合，对这块技术感兴趣的同学可以看下。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L23rE86E2)
[face2comics](https://github.com/Sxela/face2comics) | 外国一位名为 Alex 的开发者整理的人脸转漫画数据集，数据集拥有两个版本，v1 主要为深色调（含 1 万张图片），v2 为深红色调（含 2 万张图片）。漫画风格偏欧美风，可用于训练 pix2pix 或相似网络 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1bqXcRvo)
[KalidoKit](https://github.com/yeemachine/kalidokit) | 来自纽约的开发者 Richard Yee 做了一款人体运动模拟器，通过捕捉人体面部表情、眼睛、姿势、手部动作等元素后，便可自动映射到虚拟人物身上，打通真实世界与虚拟世界的连接。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L0RcJeVUJ)
[Simula](https://github.com/SimulaVR/Simula) | 为了推进 VR 与 AR 技术在 Linux 系统上的应用，国外一家名为 SimulaVR 的机构打造了一款 Linux VR 桌面窗口管理器 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L0Q1FBNSk)
[AnimeGANv2-PyTorc](https://github.com/bryandlee/animegan2-pytorch) | 可借助 AI 技术，快速将图像转换为漫画风格画作，提供 Demo 试用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L0HMg73CA)
[WantWords](https://github.com/thunlp/WantWords) | 清华大学 NLP 实验室在 GitHub 开源的 WantWords（万词王）词典还蛮有意思的。通过指定词义，便可匹配与之描述相近的词汇。比如，当你输入「开心的词」，该工具便会给出 "快乐"、"愉快"、"高兴" 等词汇。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L0uqcocaP)
[Mini Pupper](https://github.com/mangdangroboticsclub/QuadrupedRobot) | 一个开源的机器狗，带有激光雷达、相机传感器，整体成本不到 500 美元。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L0mz8F03G)
[Lite.AI.ToolKit](https://github.com/DefTruth/lite.ai.toolkit) | 一款开箱即用的 C++ AI 模型工具箱，涵盖目标检测、人脸检测、人脸识别、语义分割、抠图等领域。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KFRJWz2NX)
[HandPose X](https://github.com/EricLee2021-72324/handpose_x) | 国内一位开发者在 GitHub 上开源的手势识别项目，支持手部 21 个关键点检测、二维手势姿态、手势识别等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KFIjsjDaw)
[invoice](https://github.com/guanshuicheng/invoice) | 一个开源的增值税发票 OCR 识别项目，可通过 API 接口，快速识别发票代码、发票号码、开票日期、校验码、税后金额等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KFtbPiulP)
[PSGAN](https://github.com/wtjiang98/PSGAN) | 北航与国科大在 2019 年与 GitHub 开源的一项技术，可通过生成对抗网络，快速实现妆容转移、一键上妆等功能。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KFpsu6qUI)
[AI-Writer](https://github.com/BlinkDL/AI-Writer) | 可用 GPT 来生成中文网文小说，模型训练数据来自网文。项目内置基于 Python 运行的网页界面，并通过特殊采样方法，改善了小模型的生成质量。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KFg1XrNtE)
[ChainKnowledgeGraph](https://github.com/liuhuanyong/ChainKnowledgeGraph) | 国内一位开发者在 GitHub 开源的产业链图谱，主要包括 A 股上市公司、行业与产品共 3 类实体。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KENKtwvVc)
[Lichee](https://github.com/Tencent/Lichee) | 腾讯技术团队在 GitHub 开源的一款「多模态内容理解」算法框架，框架采用分层的思想组织模型训练流程，包含了数据处理、预训练模型、常见模型以及模型加速等模块。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KECKz5MN8)
[MuJoCo](https://github.com/deepmind/mujoco) | Deepmind 前不久收购了知名物理引擎 MuJoCo，未来将用于机器人、生物学、图形动画、机器学习等领域，帮助开发者提升产品开发体验。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KDVxDs5Kc)
[LaMa](https://github.com/saic-mdal/lama) | 由莫斯科三星人工智能中心开源，可快速进行图像修复、指定对象移除等操作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KDAkP8csy)
[PathPlanning](https://github.com/zhm-real/PathPlanning) | 一个动画算法库，主要实现多种在机器人领域中，常用到的路径规划算法，其中也包括基于搜索与采样的方法。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KC43xtbgX)
[Fast-Drone-250](https://github.com/ZJU-FAST-Lab/Fast-Drone-250) | 浙江大学 FASTLAB 实验室，在 GitHub 上开源了一套自主导航无人机的硬件组成与搭建方案。该项目可应用于无人机在未知环境中的自主飞行，集群飞行等场景。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KBJD7ASwc)
[Muzic](https://github.com/microsoft/muzic) | 微软最近在 GitHub 上开源了一个 AI 音乐项目，基于深度学习，可自动完成音乐创作。创作过程主要分为两步，一是音乐理解（符号分类、声音识别），二是音乐合成（歌曲歌词创作、音乐旋律生成）。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KAom4FzTk)
[LAION-400-MILLION OPEN DATASET](https://laion.ai/laion-400-open-dataset/) | 国外一家名为 Laion 的人工智能非盈利组织，开放了全球最大的图像文本对（image-text-pair）数据集，共提供了 4 亿样本数据。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)]()
[RobustVideoMatting](https://github.com/PeterL1n/RobustVideoMatting) | 来自字节跳动的工程师在 GitHub 上开源了一项视频自动抠图技术，该技术引入了一种强大、实时、高分辨率的人物视频抠图方法，使用循环神经网络，在处理视频流时有时间记忆，可在任意视频上做实时高清抠像。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KzEoG7ZTy)
[Kornia](https://github.com/kornia/kornia) | 一款基于 PyTorch 的可微分的计算机视觉库。可训练模型来执行图像变换、对极几何、深度估计和低级图像处理。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KzsdGBtxk)
[Tangram（七巧板）](https://github.com/tangramdotdev/tangram) | 一个可帮助 AI 开发者快速训练、部署与监控机器学习模型的开源工具。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kys9JFyt1)
[DataCLUE](https://github.com/CLUEbenchmark/DataCLUE) | 国内首个以数据为中心的 AI 测评（含模型分析报告），可通过系统化改造数据来提升模型效果。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KyhybxBYE)
[Real-time Stock-market](https://github.com/victor369basu/Real-time-stock-market-prediction) | 作者尝试基于机器学习来进行股票市场预测。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KxdyHi36a)
[PersonGraphDataSet](https://github.com/liuhuanyong/PersonGraphDataSet) | 一份开源的人物图谱数据集，收录了近十万的人物关系图谱事实数据库，通过人物关系抽取算法抽取 + 人工整理得出，可用于人物关系搜索、查询、人物关系多跳问答，以及人物关系推理等场景提供基础数据。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kw8obhjbN)
[chineseocr_lite](https://github.com/DayBreak-u/chineseocr_lite) | 一款超轻量级中文 OCR，支持竖排文字识别，总模型仅 4.7M。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KvGiQvb5y)
[SZT-bigdata](https://github.com/geekyouth/SZT-bigdata) | 一个开源的深圳地铁大数据客流分析系统，主要通过分析深圳通刷卡数据，从大数据的技术角度来研究深圳地铁客运能力，探索深圳地铁优化服务的方向。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KvpBOuFRz)
[NARUTO-HandSignDetection](https://github.com/Kazuhito00/NARUTO-HandSignDetection) | 一个开源项目，可用于识别火影忍者中的结印手势。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KvnfItTfP)
[BIFROST](https://datasets.bifrost.ai/) | 给从事 AI 开发的同学分享个数据集搜索神器，该网站当前共计拥有 1900 个数据集，提供人物、自动驾驶汽车、零售、无人机等六大类别。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kv4oHjlCU)
[MLOps-Basics](https://github.com/graviraja/MLOps-Basics) | 一个开源的 MLOps 基础教程，作者将通过 10 周的时间，带你了解 MLOps 的基础知识，如模型构建、监控、配置、测试、打包、部署、CI/CD（GitHub Actions）等内容。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KuToMAN7b)
[CompreFace](https://github.com/exadel-inc/CompreFace) | 一款开源的人脸识别与检测系统，不懂机器学习技术亦可使用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KuLxIbNeV)
[pix2tex](https://github.com/lukas-blecher/LaTeX-OCR) | 一款开源的 LaTeX 代码识别系统，基于深度学习技术，快速识别数学公式的图像，并返回相应的 LaTeX 代码。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kub0Lur6c)
[Realtime-Voice-Clone-Chinese](https://github.com/babysor/Realtime-Voice-Clone-Chinese) | 一个基于深度学习的中文语音合成项目，通过采集分析一段具体的声音样本，可在 5 秒内生成与之类似的克隆语音。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ku8giFNOS)
[AI_Tutorial](https://github.com/cbamls/AI_Tutorial) | 一个开源的 AI 学习资料库，主要整理了人工智能、机器学习、深度学习、搜索系统、推荐系统、广告系统等领域的学习资料。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KtLhAkezp)
[Polaris](https://github.com/ChibaniMohamed/Polaris) | 一款开源的人脸考勤系统，集成了脸部识别技术，拥有颇具未来感的设计风格，可用于尝鲜。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KtIJhvPH0)
[neural_network_papers](https://github.com/curryandsun/neural_network_papers) | 一份开源的 AI 论文笔记，主要记录作者读过的一些论文，给出个人对论文的评分情况并简述论文 insight。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KsvjjnWZg)
[NLPDataSet](https://github.com/liucongg/NLPDataSet) | 国内一名开发者在 GitHub 开源了常用数据集，主要将多个网络数据集进行整理清洗，并将格式统一化。其主要目的，在于构建一个较完善的中文片段抽取式阅读理解数据集。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ks9HQvfzg)
[Lite.AI](https://github.com/DefTruth/lite.ai) | 一个比较丰富的 C++ 库，里面收录了 60 多个实用的 AI 模型，其中包含对象检测、人脸检测、风格迁移、人脸识别、图像分割、图像分类等类别。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KrSqgjMNO)
[AiLearning-Theory-Applying](https://github.com/ben1234560/AiLearning-Theory-Applying) | 一个 AI 知识库，帮助开发者快速上手 AI 理论及应用实战：基础知识、机器学习、深度学习、自然语言处理 BERT，含大量注释及数据集，力求每一位能看懂并复现。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kq5Er9xsW)
[NLPer-Arsenal](https://github.com/TingFree/NLPer-Arsenal) | 一个 NLP 开源知识库，主要收录 NLP 竞赛经验贴、通用工具、学习资料等内容，覆盖文本分类、机器翻译、语义解析、实体识别等类别。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KpSiojUzt)
[DouZero](https://github.com/kwai/DouZero) | 一个 AI 斗地主项目，基于深度学习与深度蒙特卡罗（DMC）算法构建，尝试让 AI 与人类博弈。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KlmdYpi0k)

### 有趣/实用网站

名称 | 简述 | 源
---- | ----- | -----
[Species in pieces](http://www.species-in-pieces.com/) | 作者通过 CSS，实现了 30 种濒危保护动物的动画拼图，其中包括盔犀鸟、小头鼠海豚、金色毒箭蛙、克尼斯纳海马等动物。网站配有干净空灵的背景音乐，目的在于呼吁人们重视生态环境保护。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L89NOkiqA)
[RegexOne](https://regexone.com/) | 推荐一个很不错的正则表达式学习网站：RegexOne，里面配套了完整教程、速查表、练习题等资源，帮助开发者学好正则，一步到位 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7y0AbIxu)
[Analysis Tools](https://github.com/analysis-tools-dev/static-analysis) | 推荐一个比较实用的开发工具网站，上面了汇总了多种编程语言的静 / 动态代码分析工具与 Linter。其主要目的，在于帮助你更好的完善 Code Review 流程，进一步提升代码质量。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L3Kkat6r7)
[「给我画张图（Paint Me a Picture）」](http://gaugan.org/gaugan2) | 英伟达发布了一款蛮有意思的工具，可借助 AI 技术，将文字描述一键转换为逼真画像。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L3e79o3UM)
[Coding Font](https://www.codingfont.com/) | 国外几位开发者搭建的一个在线网站，可通过对比 27 款不同的编程字体，帮你选出编码体验最佳的那一款。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1h85Cm2v)
[Python Tutor](https://pythontutor.com/) | 一个颇有意思的代码可视化网站，可将代码按执行步骤，分段可视化展示，并允许将可视化代码内嵌到网站上。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KC2u7fERF)
[数据可视化工具目录](https://datavizcatalogue.com/ZH/) | 里面收集与汇总了各类数据可视化工具的详细描述、图形示例，以及可上手使用的工具集合与学习资源。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KA7Rcs3Q8)
[图之典](http://tuzhidian.com/) | 给玩数据分析的同学推荐个比较实用的网站，在上面，你能轻松找到饼图、柱形图、桑基图、折线图、热力图、直方图等 22 种常用可视化图形，帮你完成日常的数据可视化工作。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KvF7MDKbm)
[Dev Hints](https://devhints.io) | 一个颇为实用的技术网站，里面整理了各种技术类型的速查表，其中包括 Git、Vim、Go、MySQL、Linux、VSCode、Vue 等各大常用技术的速查表清单。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kpa6zEVJP)

### 其他
名称 | 简述 | 源
---- | ----- | -----
[Learn to Code RPG](https://github.com/freeCodeCamp/LearnToCodeRPG) | 一款交互式视觉小说游戏，可以让你边玩游戏、边学编程。项目里面拥有 600 多道计算机科学相关的测试题，你可以通过探索游戏菜单和解题的方式，来提升编程技巧。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7PGwl3uf)
[text2mesh](https://github.com/threedle/text2mesh) | 你可以通过文字描述，让一件 3D 物体拥有不同皮肤和外观，快速生成其外表细节。比如，你可以给普通的 3D 人物模型，套上钢铁侠的衣服。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L8bub5VSq)
[《大灾变：劫后余生》](https://github.com/CleverRaven/Cataclysm-DDA) | 一款开源的回合制生存游戏，游戏背景设置在僵尸大爆发的末日之下，你需要通过探索获得食物与装备，并找到对应策略生存下来。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L8tKDxa4i)
[Turms](https://github.com/turms-im/turms) | 一套开源的即时通讯引擎，为实时在线用户数为 100K~10M 应用而设计，配套有详细的开发文档。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L7u52fjTv)
[《在拥挤和变化的世界中茁壮成长：C++ 2006–2020》](https://github.com/Cpp-Club/Cxx_HOPL4_zh) | C++ 之父此前在 HOPL 会议上发布了一篇技术论文, 该论文主要讲述了 C++ 从 2006 到 2020 年间的技术演化历史，涵盖了 C++98 之后的所有 C++ 版本，从 C++11 直到 C++20。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6kABFo8i)
[CoNote](https://github.com/phith0n/conote-community) | 一款综合安全测试平台，可以让渗透测试过程变得更加方便，支持命令执行漏洞利用、SSRF 漏洞探测、SQL 注入、DNS 记录等功能，还可以向内网或无 HTTP 服务的平台传输数据与文件。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6jpy96x1)
[物美智能](https://github.com/kerwincui/wumei-smart) | 一套开源的软硬件智能家居系统，可用于二次开发和学习，快速搭建自己的智能家居系统。硬件工程师可以把自己的设备集成到系统；软件工程师可以使用项目中的设备熟悉软硬件交互。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6ieuuRkm)
[microStudio](https://github.com/pmgl/microstudio) | 一个非常实用的游戏开发平台，集搜索、开发、学习、体验、交流等功能于一身。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L6gF4lKIX)
[win-vind](https://github.com/pit-ray/win-vind) | 一个颇有意思的 Windows UI 开源系统，将图形界面与命令行界面两种操作方式进行混合，让开发者可以用一些 Vim 快捷键来操作桌面程序。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L61JCkEGf)
[space-shooter.c](https://github.com/tsherif/space-shooter.c) | 基于 C 语言编写的一款 2D 太空射击游戏，已在 Windows 10 和 Ubuntu Linux 16.04 系统上跑通测试。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L5ZnufMFk)
[《金庸群侠传 3D 重制版》](https://github.com/jynew/jynew) | 开源的游戏项目：《金庸群侠传 3D 重制版》，喜欢怀旧的同学可以玩一下。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L5Svi8JUw)
[matplotx](https://github.com/nschloe/matplotx) | 收录了多个实用的 Matplotlib 扩展，可以满足多种数据可视化的绘图需求。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L5RudxPlx)
[RealSkel](https://github.com/jingma-git/RealSkel) | 浙大一位计算机博士开源的 3D 建模工具，可基于平面草图，快速完成 3D 骨架建模。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L4XWj0J7H)
[The Open Book](https://github.com/joeycastillo/The-Open-Book) |类似于开源版的 Kindle，能帮你打造一个可灵活定制的电子书阅读设备。搭配 4.2" 英寸电子显示器，拥有方向键、选择、翻页等交互按钮，具备 SD 卡检测功能，充电状态 LED 灯显示，带立体音频输出和原始麦克风输入的音频组合插孔等组件。  | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L4kR8gV4j)
[CasaOS](https://github.com/IceWhaleTech/CasaOS) | 一个简洁易用、开源的家庭云系统，基于 Docker 生态系统打造，满足了多种家庭使用场景。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L40P21V79)
[open-mantra-dataset](https://github.com/mantra-inc/open-mantra-dataset) | 东京大学与 Mantra 公司在推进的一项技术研究，尝试使用人工智能来自动翻译日漫文稿。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2ZbG9VX0)
[MrDoc](https://github.com/zmister2016/MrDoc) | 一个开源的在线文档系统，适合作为私有云文档、云笔记和知识管理工具，私有化在线文档部署方案。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L2PLcuPVF)
[Windows 2000 on Docker](https://github.com/hectorm/docker-qemu-win2000) | 一个可用于运行 Windows 2000 系统的 Docker 镜像 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/L1KAEq1gv)
[McDonalds Fries Font](https://github.com/mcdtaiwan/McDonalds_Fries_Font) | 由麦当劳一家授权经营企业开源的字体，带有薯条和番茄酱设计风格。支持应用到 Illustrator、Photoshop、Keynote 、Sketch 等软件上。标注字体名称后，可商用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KFA41qCK2)
[KubePi](https://github.com/KubeOperator/KubePi) | 一款简单易用的开源 Kubernetes 可视化管理面板，可允许管理员导入多个 Kubernetes 集群，并通过权限控制，将不同 cluster、namespace 的权限分配给指定用户。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KEFv4mFEB)
[Semi-UI](https://github.com/DouyinFE/semi-design) | 抖音前端技术团队开源的一个 UI 库，具备现代、全面、灵活的设计系统。可帮助开发者快速搭建简洁、美观的 React 应用。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KEyCPC92v)
[N64Wasm](https://github.com/nbarkhina/N64Wasm) | 国外工程师 Neil 在 GitHub 上开源了任天堂 64 模拟器（N64）。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KDhtvFs5l)
[markdown-css-smartisan](https://github.com/nihaojob/markdown-css-smartisan) | 一个基于锤子便签的 Markdown 主题。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KCZNzw5K4)
[Sogou C++ Workflow](https://github.com/sogou/workflow) | 搜狗在 GitHub 上开源的一款 C++ 服务器引擎，作为一款设计轻盈优雅的企业级程序引擎，可满足大多数 C++ 后端开发需求。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KyoecFH5s)
[《人生重开模拟器》](https://github.com/VickScarlet/lifeRestart) | 在这款游戏里面，你可以选择不同的人生天赋与初始属性，程序将根据这些基本信息，为你生成一条完整的人生轨迹。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KwRXfjGc5)
[Traccar](https://github.com/traccar/traccar) | 一个功能颇为丰富的 GPS 定位系统，支持 170 多种 GPS 协议以及 1500 多种 GPS 定位追踪设备。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kw6OL9ig0)
[Whoogle Search](https://github.com/benbusby/whoogle-search) | 一款开源的元搜索引擎，可为用户提供一个纯净无污染、无广告的 Google 元搜索引擎，注重隐私安全性，支持托管到私有服务器。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kw08KkZWt)
[C-Toy](https://github.com/anael-seghezzi/CToy) | 该项目为开发者提供了可交互式的 C(99) 语言编程环境，能你让在编码过程中，实时看到比较有趣的结果反馈。无需安装编译，下载即可使用，目前已支持 Windows、macOS、Linux 等主流操作系统。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kvgbktze7)
[MeiliSearch](https://github.com/meilisearch/MeiliSearch) | 一款开源免费、功能强大、快速、易于使用和部署的搜索引擎  | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KuUYbxYwJ)
[Erda](https://github.com/erda-project/erda) | 一款开源的 k8s 企业级云原生平台，主要提供 DevOps、微服务治理、多云管理以及快数据管理等云原生服务。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KrMwXsmhi)
[Mycodo](https://github.com/kizniche/Mycodo) | 一个可运行在树莓派上的环境监测与调节系统，支持应用到种植植物，培养微生物，保持蜂蜜蜂房稳态，孵化动物和鸡蛋，维持水生系统等场景。监控收集的数据，能放在Web 界面进行可视化展示。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kq4tndHJq)
[Gorse](https://github.com/zhenghaoz/gorse) | 由国人主导开发的一个开源推荐系统。在将项目、用户与交互数据导入后，系统便会自动训练模型，为每个用户生成推荐内容，大幅提升开发效率。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KpCbSkMpV)
[霞鹜文楷（LXGW WenKai）](https://github.com/lxgw/LxgwWenKai) | 一款开源中文字体，基于日本著名字体厂商 FONTWORKS 开源的 Klee 完善而成，共包含 1.3 万个简繁日汉字，个人用户或企业可免费使用，自由分享。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/KpsLo5mN8)
[rose-pine-matplotlib](https://github.com/h4pZ/rose-pine-matplotlib) | 一款主打「优雅极简主义风」的 Matplotlib 主题样式。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Kim4l37Id)
[Superset](https://github.com/apache/superset) | 数据可视化及数据探索平台，提供了多种可视化模板及交互式仪表，用于更为清晰的展示数据；自带 SQL IDE，可让用户更好的操作数据；API 开放且灵活，可定制性高。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JFe5WqTXM)

## 声明
[![](https://licensebuttons.net/l/by-nc-nd/4.0/88x31.png)](https://creativecommons.org/licenses/by-nc-nd/4.0/deed.zh)  
本作品采用[知识共享署名-非商业性使用-禁止演绎 4.0 通用许可协议](https://creativecommons.org/licenses/by-nc-nd/4.0/deed.zh)进行许可。
