
<p align="center">
   <img src="https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/weixin.png">
</p>

## 宗旨

GitHubDaily 将于每日不定时推送一批 GitHub 上优秀的开源项目给开发者, 帮助开发者们发现当下最火的开源项目, 令开发者们得以掌控技术脉搏, 扩大自己的技术视野, 并从开源项目的学习中获得技术能力的提升。

- [历史文章精选](https://github.com/GitHubDaily/GitHubDaily/tree/master/articles)
- 公众号：[GitHubDaily](https://tva1.sinaimg.cn/large/007S8ZIlgy1geyb6wrwxgj3076076aa5.jpg)
- 微博: [@GitHubDaily](https://weibo.com/GitHubDaily)
- 知乎: [@GitHubDaily](https://www.zhihu.com/people/githubdaily)

> 欢迎到 [Issues](https://github.com/GitHubDaily/GitHubDaily/issues/new) 推荐或自荐项目，让更多人知道你的项目。

---

## 2020 年复盘

下面是对 GitHubDaily 在 2020 年所发的微博进行分类整理，方便粉丝们查找以往分享过的内容。

> 过往复盘 [2019](https://github.com/GitHubDaily/GitHubDaily/blob/master/2019.md)，[2018](https://github.com/GitHubDaily/GitHubDaily/blob/master/2018.md)

### 目录

- [Java](#java)
- [Python](#python)
- [前端](#前端)
- [工具](#工具)
- [移动端](#移动端)
- [命令行工具](#命令行工具)
- [Chrome 插件](#chrome-插件)
- [VSCode 插件](#vscode-插件)
- [资料集合](#资料集合)
- [面试资料](#面试资料)
- [机器学习/人工智能](#机器学习人工智能)
- [开源书籍/教程](#开源书籍教程)
- [图标库](#图标库)
- [有趣网站](#有趣网站)
- [其他](#其他)

### Java

库名 | 简述 | 源
---- | ----- | -----
[newbee-mall](https://github.com/newbee-ltd/newbee-mall) | 一套基于 Spring Boot 2.X 开发的电商系统，含有功能完备、流程完整的前台商城系统及后台管理系统，适合各个阶段的 Java 开发者学习 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JvI0r43EV)
[thingsboard](https://github.com/thingsboard/thingsboard) | 一个基于 Java 编写的物联网开源平台，可用于数据收集、处理、可视化与设备管理等应用场景 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JuWPAiy55)
[Algorithms](https://github.com/williamfiset/Algorithms) | 一个可用于学习算法与数据结构的 Java 项目，里面涵盖了数据结构、动态规划、几何、图论、线性代数、数学、搜索算法、排序算法等常见算法的具体代码实现 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JjG1O2L5O)
[Java-Tutorial](https://github.com/h2pl/Java-Tutorial) | 一份 Java 工程师学习指南，里面涵盖大部分 Java 程序员所需要掌握的核心知识，其中有 Java 基础、JavaWeb、Java进阶、计算机基础、数据库、缓存、消息队列、大后端、分布式、面试资料等等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jj5uSxj8H)
[CodeGuide](https://github.com/fuzhengwei/CodeGuide) | 一份 Java 学习资料，里面包含了手写 RPC 框架、JVM 实现、SpringCloud 入门案例、SpringBoot 中间件开发、服务框架搭建等多个 Java 技术专题 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JbJrRkKXW)
[thingsboard](https://github.com/thingsboard/thingsboard) | 一个基于 Java 编写的物联网开源平台，可用于数据收集、处理、可视化与设备管理等应用场景 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J8pe00N54)
[spring-boot-demo](https://github.com/xkcoding/spring-boot-demo) | 共收录了数十个与 Spring Boot 相关的 Demo 项目，其中包含可视化监控、日志、统一异常处理、模板引擎、ORM 框架、邮件发送、消息队列等分类 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J1nZK4eQC)
[spring-analysis](https://github.com/seaswalker/spring-analysis) | 一位开发者将其整理的 Spring 框架源码阅读笔记，包含了 spring-core、spring-aop、spring-context、spring-task、spring-transaction、spring-mvc、guava-cache 等多个 Spring 组件的源码解读 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J1iGXwsBc)
[hutool](https://github.com/looly/hutool) | 一个比较实用的开源 Java 工具包，对文件、流、加密解密、转码、正则、线程、XML 等 JDK 方法进行合理封装 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IBD8JFxMv)
[JCSprout](https://github.com/crossoverJie/JCSprout) | 一个 Java 核心知识库，内容涉猎集合、多线程、JVM、分布式、架构设计等分类 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IBaRf8xbt)
[technology-talk](https://github.com/aalansehaiyang/technology-talk) | 主要汇总了 Java 生态圈常用技术框架、开源中间件，系统架构、数据库、大公司架构案例、常用三方类库等知识 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IAXvcoK0r)
[newbee-mall](https://github.com/newbee-ltd/newbee-mall) | 一套基于 Spring Boot 2.X 开发的电商系统，含有功能完备、流程完整的前台商城系统及后台管理系统，适合各个阶段的 Java 开发者学习 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IpyrY0ISC)
[dokit](https://github.com/Perye/dokit) | 一个基于 Spring Boot2、Vue 前后端分离的管理系统，支持数据字典与数据权限管理、一键生成前后端代码、支持前端菜单动态路由等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Iofx2eKxD)
[awesome-java](https://github.com/Snailclimb/awesome-java) | 一份收集整理了 GitHub 上非常棒的 Java 开源项目集合 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Io2zlrepJ)
[Recaf](https://github.com/Col-E/Recaf) | 一款简洁易用的现代化 Java 字节码编辑器 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JAJ4stkf9)

### Python

库名 | 简述 | 源
---- | ----- | -----
[Riskfolio-Lib](https://github.com/dcajasn/Riskfolio-Lib) | 可用于定量战略资产配置与投资组合优化 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JAzQ9f2mO)
[jd_seckill](https://github.com/huanghyw/jd_seckill) | 能帮你抢某东上的茅台的 Python 脚本 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JApAiqaJi)
[r0capture](https://github.com/r0ysue/r0capture) | 适用于 Android 系统的开源应用层抓包脚本 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jwt6yvC5T)
[ipycanvas](https://github.com/martinRenou/ipycanvas) | 可应用于 Jupyter 的可交互式画布，通过对接浏览器的 Canvas API，便可使用 Python 绘制简单的文本、线条、多边形、弧线等图形 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JvXhSAH74)
[stock](https://github.com/Rockyzsu/stock) | 一个开源的量化交易代码与策略项目，带你 30 天掌握量化交易，更好的帮助自己炒股 (亏钱 -。-) | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JvxlVoLhn)
[rich](https://github.com/willmcgugan/rich) | 支持在终端输出添加各种颜色和不同风格，绘制各种漂亮的表格、进度条、显示 Markdown 文本、高亮语法代码等功能，完善 Python 控制台的输出体验， | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JvnW1w86A)
[ToolGood.Words](https://github.com/toolgood/ToolGood.Words) | 一款高性能非法词 (敏感词) 检测组件，附带繁体简体互换，支持全角半角互换，获取拼音首字母，获取拼音字母，拼音模糊搜索等功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JuqCyE49D)
[LeetCode](https://github.com/wisdompeak/LeetCode) | 一个基于 C++/Pyhton 相关的 LeetCode 算法题解。包含了二分查找、哈希表、链表、堆栈、动态编程等技术点 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ju7Lzjjvl)
[autoscraper](https://github.com/alirezamika/autoscraper) | 一个智能 Web 爬虫脚本，其主要作用，是能快速且智能获取指定网站上的数据，这些数据可以是网页文本、url 地址或者其它 HTML 元素 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JtH3uBH8h)
[datapane](https://github.com/datapane/datapane) | 开发者可用它快速从常见对象（如 pandas DataFrames）上快速构建数据分析报告 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jt5lvr9OD)
[FundamentalAnalysis](https://github.com/JerBouma/FundamentalAnalysis) | 一个可用于分析公司基本面的 Python 扩展包，里面收集了 13000 多家创办 20 年以上公司的简介、财务报表、各类比率和股票数据等信息 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jn0fFn0x3)
[lux](https://github.com/lux-org/lux) | 一个比较实用的 Python 库，通过自动化数据的探索流程，让你能更轻松的玩转数据科学 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jm5GGunkj)
[jupyter-text2code](https://github.com/deepklarity/jupyter-text2code) | 一款开发者神器，可在 Jupyter 上快速将文本描述转化为 Python 代码，为数据分析人员减少大量编写代码的时间 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JkSgJeDf9)
[autoscraper](https://github.com/alirezamika/autoscraper) | 一个智能 Web 爬虫脚本，其主要作用，是能快速且智能获取指定网站上的数据，这些数据可以是网页文本、url 地址或者其它 HTML 元素 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JjQDm8xbM)
[translators](https://github.com/UlionTse/translators) | 一个比较实用的 Python 翻译工具库，该库集成了谷歌、必应、有道、百度等多个翻译平台 API，支持上百种语言翻译，使用便捷，配置灵活 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ji8zMcAoY)
[handcalcs](https://github.com/connorferster/handcalcs) | 可将 Python 计算公式代码快速转换为 Latex 公式，平方根、三角函数等计算方式一应俱全 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JgriUwb6l)
[latexify_py](https://github.com/odashi/latexify_py) | 可快速将 Python 函数快速转为 LaTeX 数学公式 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JfyjkF8Qy)
[stock](https://github.com/pythonstock/stock) | 一个基于 Python 的股票系统，支持 Docker 部署、数据定时爬取、更新、缓存与可视化展示等操作 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JcvLp9nCo)
[EasyOCR](https://github.com/JaidedAI/EasyOCR) | 让 Python 开发者可以更加高效便捷的集成图像文字识别功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JavDx8D1x)
[python3-in-one-pic](https://github.com/coodict/python3-in-one-pic) | 一张图帮你理清 Python3 的相关知识点 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J98N47HwR)
[real-url](https://github.com/wbt5/real-url) | 可帮助你快速获取当前主流直播平台的真实流媒体地址 (直播源) 和弹幕信息 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J7WWvsgVL)
[twint](https://github.com/twintproject/twint) | 爬取某个 Twitter 用户的公开信息 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J7FgzivDm)
[weiboSpider](https://github.com/dataabc/weiboSpider) | 国内一名开发者在 GitHub 上开源了一个 Python 爬虫，可用于爬取用户公开的微博数据 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J7cZ53MtR)
[PyDebloatX](https://github.com/Teraskull/PyDebloatX) | 一款比较实用的 Python GUI 开源工具，可用于卸载 Windows 10 默认应用程序 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J47GG6fup)
[newscatcher](https://github.com/kotartemiy/newscatcher) | 可用于收集大多数网站的新闻资讯，并统一格式，用户可根据所在地区、语言与主题进行过滤筛选 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J36rGcuc8)
[diagrams](https://github.com/mingrammer/diagrams) | 通过 Python 代码来快速生成系统架构图，使其操作起来更加便捷，可支持 AWS、Azure、GCP、K8s、阿里云、Oracle 云等 6 大主流供应商 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J1Iq9edhL)
[PyBoy](https://github.com/Baekalfen/PyBoy) | 一个基于 Python 的 Game Boy 模拟器，像超级马里奥、口袋妖怪等耳熟能详的游戏都可以在上面完美运行 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IEiU8bShk)
[CPython-Internals](https://github.com/zpoint/CPython-Internals) | 一份 CPython 源码阅读笔记，作者很用心的通过多图来展示底层实现细节，尽可能的给大家讲清楚 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Iow1Ub9ME)
[textdistance](https://github.com/life4/textdistance) | 一个开源库含有 30+ 种纯 Python 算法用于比较两个或多个序列之间的距离 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Io66xo6ns)

### 前端

库名 | 简述 | 源
---- | ----- | -----
[visual-drag-demo](https://github.com/woai3c/visual-drag-demo) | 一个简易版的前端可视化拖拽组件库，主要允许用户在 Web 页面上对各个组件进行拖拽、编辑以及样式调整 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JAhY2rDub)
[luban-h5](https://github.com/ly525/luban-h5) | 鲁班 H5，类似易企秀的 H5 制作、建站工具、可视化搭建系统 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JzOvu1jbI)
[anichart.js](https://github.com/Jannchie/anichart.js) | 可帮助你快速制作数据可视化动画视频 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JzM9mcXFp)
[wave](https://github.com/h2oai/wave) | 一套可用于构建实时 Web 项目与仪表面板的工具，采用 Python 编写，拥有低延迟、优雅美观、实时分析等亮点 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jz3mZqhos)
[wLogger](https://github.com/jyolo/wLogger) | 一款集日志采集、日志解析持久化存储、Web 流量实时监控，三位一体的 Web 服务流量监控应用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JynJtD0wV)
[mapbox-gl-js](https://github.com/mapbox/mapbox-gl-js) | 一个比较实用的 JavaScript 库，可帮助开发者快速构建可交互、可定义的矢量地图 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jyh3sdkxf)
[cypress](https://github.com/cypress-io/cypress) | 一款比较实用的 Web 自动化测试工具，拥有完整的端到端测试流程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jyabiu9b5)
[crater](https://github.com/bytefury/crater) | 一款免费开源的 Web 与移动端发票应用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jxx62bXQx)
[Drawflow](https://github.com/jerosoler/Drawflow) | 可帮你快速创建数据流，支持节点拖拽、多重连接、数据节点同步、数据模块清除、移动端设备友好等功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JxmGHny4n)
[music-website](https://github.com/Yin-Hongwei/music-website) | 一个开源的音乐网站管理系统，实现了歌单、播放器、用户及音乐管理等常用功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JwT1VwRQC)
[procedural-gl-js](https://github.com/felixpalmer/procedural-gl-js) | 一个可用于制作 3D 地图的 JavaScript 开源库 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JvE2xt4ED)
[animockup](https://github.com/alyssaxuu/animockup) | 基于 JavaScript 开发，让用户能在浏览器中快速构建动画模型，且支持导出成视频或 gif 动图，整体功能较完善 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jvp7576Rx)
[heti](https://github.com/sivan/heti) | 国内有位开发者在 GitHub 上设计了一个专用于中文内容展示的排版样式，主要基于通用的中文排版规范 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JtSQ7eUtk)
[sparrow](https://github.com/sparrow-js/sparrow) | 一个开源的场景化、低代码（LowCode）搭建工作台：sparrow，可实时输出源代码 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JtqAIDs2u)
[h5-Dooring](https://github.com/MrXujiang/h5-Dooring) | 一款功能强大的开源 H5 可视化页面配置解决方案，致力于提供一套简单方便、专业可靠、无限可能的 H5 落地页最佳实践 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jt6wzqjL8)
[presenta-lib](https://github.com/presenta-software/presenta-lib) | 一个开源的 JavaScript 库，可帮助你快速制作出富有表现张力的 Web 演示文稿（PPT） | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JsOQDBPOA)
[react-d3-graph](https://github.com/danielcaldas/react-d3-graph) | 可帮助前端开发者轻松使用 React 和 d3 快速创建可交互和可配置的图形，提升开发效率 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JsnWnAnA4)
[vega-lite](https://github.com/vega/vega-lite) | 它提供了一种交互式图形语法，让用户仅需通过几行简单的 JSON 配置，便能生成各种可视化交互数据图 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JrHjZblIi)
[react-chrono](https://github.com/prabhuignoto/react-chrono) |  React 组件可帮你创建多种样式丰富的时间轴，支持以水平、垂直、树状等不同形式进行渲染，并可用幻灯片交互播放 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JqEvAdsFX)
[layoutit-grid](https://github.com/Leniolabs/layoutit-grid) | 可快速生成页面「网格布局」的 CSS 及 HTML 代码，配置灵活，操作简单 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JpWUpE3hU)
[KaTeX](https://github.com/KaTeX/KaTeX) | 一个比较实用的数学公式排版 JavaScript 库，使用简单，无其它依赖，针对数学公式的渲染更快，支持同步呈现其数学运算，无需重新排版页面 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JoRJKogyD)
[10-projects-10-hours](https://github.com/florinpop17/10-projects-10-hours) | 国外有个小哥开启了尝试用 10 小时完成 10 个前端项目的挑战，包含了计时器、问卷调查、食谱应用、笔记应用、待办事项、电影应用、GitHub 个人资料页面、绘图应用、密码生成器和天气应用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JjDhkejtO)
[vanillawebprojects](https://github.com/bradtraversy/vanillawebprojects) | 一共含有 20 个纯使用 HTML5，CSS 和 JavaScript 实现的小 Demo，这当中有表单验证、电影座位预订、汇率计算器、音乐播放器、打字游戏、新年倒计时等等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JjkqkypSJ)
[project-guidelines](https://github.com/elsewhencode/project-guidelines/blob/master/README-zh.md) | 一份 JavaScript 项目规范指南，国外一家公司在自家多个 JavaScript 项目里总结出来最佳实践 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JikmowQTr)
[ts-migrate](https://github.com/airbnb/ts-migrate) | 一款前端工具，其主要作用是可将 JavaScript 代码快速迁移为 TypeScript 代码，以便节省前端工程师的时间成本，统一开发环境 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jh4MteGkC)
[tiper-js](https://github.com/carlelieser/tiper-js) | 一个 JavaScript 库，可在网页上模拟真人打字时的展示动画 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JecDVumeN)
[luckysheet](https://github.com/mengshukeji/luckysheet) | 一款纯前端实现的，类似 Excel 的在线表格，功能强大、配置简单、完全开源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JdRqOgRdu)
[javascript-in-one-pic](https://github.com/coodict/javascript-in-one-pic/blob/master/README-zh.md) | 一张图帮你理清 JavaScript 的相关知识点 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J9tdtjINX)
[responsively-app](https://github.com/responsively-org/responsively-app) | 为了帮助工程师更好的实现 Web 响应式页面开发，提升开发效率 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J37CMrGae)
[1loc](https://github.com/phuoc-ng/1loc) | 收集了共计 126 个 JavaScript 代码片段，其中包含对数组、日期、函数、DOM 等常见代码模块的组件实现 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J1Bv9oQcO)
[eruda](https://github.com/liriliri/eruda/blob/master/doc/README_CN.md) | 开源的前端页面调试神器，一个专为手机前端页面设计的调试面板，类似 DevTools 的迷你版 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IFmTBxo4M)
[Blog](https://github.com/mqyqingfeng/Blog) | 一位前端开发者在 GitHub 上开启了 JavaScript 文章连载创作，内容主要分为：JavaScript 深入系列、JavaScript 专题系列、ES6 系列、React 系列 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IAS0fsGCg)
[30-Days-Of-JavaScript](https://github.com/Asabeneh/30-Days-Of-JavaScript) | 跟着作者一起规划 30 天学会 JavaScript 编程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Iol1ZrK37)
[vue-manage-system](https://github.com/lin-xin/vue-manage-system) | 一个基于 Vue + Element UI 的后台管理系统解决方案，作为一套多功能的后台框架模板，适用于绝大部分的后台管理系统（Web Management System）开发 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/InNfxoYOt)

### 工具

库名 | 简述 | 源
---- | ----- | -----
[volbx](https://github.com/przemek83/volbx) | 一款可用于数据处理的图形工具，拥有数据加载、过滤、选择筛选、可视化、xlsx 与 CSV 格式导出等功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JAQVxdrAY)
[vulmap](https://github.com/zhzyker/vulmap) | 一款开源的 Web 漏洞扫描和验证工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JAxz2BZFR)
[SteamTools](https://github.com/rmbadmin/SteamTools) | 一个包含多种 Steam 工具功能的工具箱，主要支持 Steam 社区反代理、多账号切换、成就统计管理、在 PC 上完成两步身份验证等功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JAfBUmKXM)
[rhubarb-lip-sync](https://github.com/DanielSWolf/rhubarb-lip-sync) | 基于语音让动漫人物嘴唇实现音画同步，开发者可将其应用于计算机游戏、动画卡通角色、视频 Vlog 等领域 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JAeqQpQOW)
[multiavatar-php](https://github.com/multiavatar/multiavatar-php) | 一个开源的头像生成库，可为你生成 120 亿种不同风格的头像 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JA6bq6fHe)
[PandaOCR](https://github.com/miaomiaosoft/PandaOCR) | 一款多功能 OCR 图文识别工具，支持多种识别引擎，可识别图文、公式、表格等内容，还拥有翻译、朗读等功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JA3qVvblh)
[SwiftBar](https://github.com/swiftbar/SwiftBar) | 一款功能较为强大的 macOS 菜单栏定制工具，支持自行编写脚本，并集成到菜单栏上统一进行管理，配置灵活，可定制性强 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JySLrlEpT)
[odiff](https://github.com/dmtrKovalenko/odiff) | 称其为世界上最快的像素级图像对比工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JyB5w7JtL)
[imgdiff](https://github.com/n7olkachev/imgdiff) | 比那个自称世界上最快的图像对比工具还快的图像对比工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JyB5w7JtL)
[meli](https://github.com/getmeli/meli) | 一款开源的静态网站部署工具，支持在主域名下部署无数个静态站点，API 配置灵活，与 Let's Encrypt 证书完美整合 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JyzUrlYOE)
[snapdrop](https://github.com/RobinLinus/snapdrop) | 如果你想在本地多个 WiFi 设备间快速传输文件，那推荐你试下 Snapdrop 这款开源工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JyyJoigAm)
[TinyCheck](https://github.com/KasperskyLab/TinyCheck) | 可用于检测与分析智能手机或 WiFi 关联设备的网络通信，以便快速识别出恶意请求的来源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jyx9YsXc0)
[PlotJuggler](https://github.com/facontidavide/PlotJuggler) | 一款可视化时间序列的工具，通过在编辑器中可视化的处理数据，让你更为直观的进行数据分析 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JyfSpcUv0)
[Depix](https://github.com/beurtschipper/Depix) | 可通过算法，快速移除文字截图上的马赛克，让其原始文本得以重新呈现 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/u/5722964389)
[ContextMenuManager](https://github.com/BluePointLilac/ContextMenuManager) | 一个纯粹的、开源的 Windows 右键菜单管理程序 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JwVo3leAY)
[takenote](https://github.com/taniarascia/takenote) | 一个基于 Web 的 Markdown 笔记应用：takenote，支持 Markdown 预览渲染、笔记之间链接跳转、语法高亮、便签拖拽、所见即所得等功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JwJBqrxaG)
[WeChatExtension-ForMac](https://github.com/MustangYM/WeChatExtension-ForMac) |  Mac 微信插件支持为客户端设置多种界面主题、消息转发与防撤回、账号多开、自定义回复、退群监控等功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JwI2168PB)
[Clean-Me](https://github.com/Kevin-De-Koninck/Clean-Me) | 一款开源的 macOS 系统分析与清理工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JwhjWadgk)
[xray](https://github.com/chaitin/xray) | 一款功能强大且完善的安全评估工具，支持的漏洞检测类型有 XSS 漏洞、SQL 注入、命令/代码注入、文件上传等等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jw0P4wZUc)
[traduora](https://github.com/traduora/traduora) | 一个开源翻译平台 traduora，支持多人协作在线翻译，可导入导出 JSON、CSV、YAML 等多种文本格式 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JvZE0A49X)
[Bob](https://github.com/ripperhe/Bob) | 一款开源的 Mac 端翻译软件，支持划词、截图、输入、插件等多种翻译方式 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JvNt2F0Ug)
[pretty-snap](https://github.com/kangabru/pretty-snap) | 让你为屏幕截图添加更为丰富与酷炫的背景图，并提供了多种配色及花纹图像供你选择，截图位置亦可调整 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jvdksa4nN)
[presenta-lib](https://github.com/presenta-software/presenta-lib) | 通过在页面上编写 Markdown 文档，便可快速生成 PPT 文稿。有需要的话，还能对字体颜色、类型、动画转场效果进行定制 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jv6g63UPj)
[dev-fonts](https://github.com/Gaafar/dev-fonts) | 支持直接在 Web 端实时预览与对比多款编辑器主题、字体及配色，帮你快速挑选一款心仪字体，并应用到实际开发环境中 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jv2ITpnLR)
[siyuan](https://github.com/siyuan-note/siyuan) | 一款 Markdown 笔记应用：思源笔记，拥有块级引用和双向链接的网状特色，支持 Windows、Mac 和 Linux，可在浏览器上直接使用，支持移动端适配 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JuBCtmDHj)
[nodes-io](https://github.com/nodes-io/nodes-io) | 一个可视化编程工具，支持快速创建实时 3D 图形、可交互的 Web 应用、自定义和共享工具参数、可视化数据分析、构建复杂应用等功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JuA33wcga)
[qr-tunnel](https://github.com/coolwill/qr-tunnel) | 如果你觉得远程桌面的小文件传输方式有点繁琐，那么可以试下 QR tunnel 这款开源工具，可一键将文件转为二维码进行传输 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Juuy7gvnE)
[tmpmail](https://github.com/sdushantha/tmpmail) | 可用于快速生成临时电子邮箱 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JtQtZFWMC)
[httptoolkit](https://github.com/httptoolkit/httptoolkit) | 一款开源的 HTTP(S) 调试、测试与构建工具，支持 Windows、Mac、Linux 等主流操作系统 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JtJpCq4jT)
[optimizt](https://github.com/funbox/optimizt) | 一款开源的图片命令压缩工具，支持对 PNG, JPEG, GIF 和 SVG 等多种图片类型，并可将光栅图像转为 WebP 格式 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JtxD01pxc)
[BiliBiliTool](https://github.com/RayWangQvQ/BiliBiliTool) | 一款基于 .Net Core 编写的跨平台的 B 站（哔哩哔哩）任务工具，通过 GitHub Actions 实现每日线上自动运行任务 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JtpnHE6yK)
[Tool-X](https://github.com/rajkumardusad/Tool-X) | 一款 kali Linux 黑客工具安装器，使用后，便可在 termux app 和其它基于 Linux 的发行版中安装近 370 多种黑客工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jth894cYV)
[svg-path-editor](https://github.com/Yqnn/svg-path-editor) | 可让你在浏览器中快速创建或编辑 SVG 图形路径，拥有命令面板、视图框、路径操作等多个组合选项 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JsUJX3OE8)
[HackBrowserData](https://github.com/moonD4rk/HackBrowserData) | 一款可全平台运行的、开源的浏览器数据导出解密工具，支持将密码、历史记录、Cookies、书签等导出内容进行解密 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JsNFA19bl)
[monkey](https://github.com/guardicore/monkey) | 一款开源的安全测试工具，可用于测试数据中心受到内外部攻击后的恢复能力，在进行各项信息收集后会汇总成报告，帮助开发者进一步提升数据安全性 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jss47nQzK)
[notebooker](https://github.com/man-group/notebooker) | 一个可快速将 Jupyter Notebook 内容转换为 Web 报告的开发工具，其转化结果存储在 MongoDB 中，支持在 Web 界面上直接查询 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jskd1zt6b)
[filegogo](https://github.com/a-wing/filegogo) | 一款基于 WebRTC 开发的点对点加密文件传输工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JsiDBob3P)
[Aragorn](https://github.com/njzydark/Aragorn) | 一款开源的对象存储管理工具，基于 Electron + React + TS 开发，可作为图床上传工具使用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JsaMxhSVF)
[histools](https://github.com/thesephist/histools) | 可将浏览器历史记录数据可视化，并生成热力图，让你清楚的看到在不同时间点，对不同网站的访问频率 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Js1m287sl)
[BilibiliTask](https://github.com/srcrs/BilibiliTask) | Bilibili 助手，可自动完成每日任务，投币，点赞，直播签到，自动兑换银瓜子为硬币，自动送出即将过期礼物，漫画 App 签到等任务 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JrJSh10Sy)
[vtracer](https://github.com/visioncortex/vtracer) | 可快速将 jpg、png 等格式的图片快速转换为 svg 矢量图，并支持过滤斑点、色彩精度等多种参数配置 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jrz4xxTIS)
[speedscope](https://github.com/jlfwong/speedscope) | 一款 Web 应用性能测试工具，支持在页面上快速查看页面的堆栈调用情况、内存占比，以便你更为快速的对 Web 应用进行优化 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JrizH6RO6)
[hoppscotch](https://github.com/hoppscotch/hoppscotch) | API 构建工具，满足了所有主流的 API 请求方法，并提供多款主题供用户选择定制，允许离线访问、文件管理、资源分享、文档构建、账户同步、语言国际化等操作 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JrhoDhCE7)
[UserScript](https://github.com/XIU2/UserScript) | 如果你一直对 GitHub 下载速度不甚满意，那么可以试下「GitHub 增强」这个油猴脚本 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jr5dEDeBX)
[eul](https://github.com/gao-sun/eul) | 个开源的系统状态监控器：eul，支持查看 CPU、风扇、内存、电池、网络等各类参数的使用情况，习惯用 macOS 系统的同学可以试用一下 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JqYxDAD8e)
[pandasgui](https://github.com/adamerose/pandasgui) | 一款可用于分析 Pandas DataFrames 的 GUI 工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jqv560g19)
[gitui](https://github.com/extrawurst/gitui) | 一个基于 Rust 开发的 Git 终端工具，可让你更高效率的操作 Git | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JqaEG92Zb)
[beekeeper-studio)](https://github.com/beekeeper-studio/beekeeper-studio) | 一款跨平台的开源 SQL 客户端，支持 Windows、Linux、macOS 等主流操作系统，拥有语法高亮、多任务执行、排序过滤数据、丰富的快捷键、查询历史记录等功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JptrJdWvO)
[ASCII-Generator.site](https://github.com/hermanTenuki/ASCII-Generator.site) | 允许你通过图像或文本快速生成 ASCII 艺术字符图 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jpr5CnbzI)
[iroiro](https://github.com/antfu/iroiro) | 一款可在终端运行的色彩查询工具，提供了不少简洁优雅的色系供开发者选择，其数据引用自日本传统色系 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jpg5HiEn0)
[vditor](https://github.com/Vanessa219/vditor) | 一款开源的 Markdown 编辑器（浏览器端），支持所见即所得（富文本）、实时渲染（类似 Typora）和分屏预览模式 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JpaAKbRgN)
[vulmap](https://github.com/zhzyker/vulmap) | 一款开源的漏洞扫描工具，可对 Web 容器、Web 服务器、Web 中间件以及 CMS 等 Web 程序进行漏洞扫描，并且具备漏洞利用功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jp8aUdn6W)
[Simpdf](https://github.com/shashanoid/Simpdf) | 一款简单易用的 PDF 在线编辑器，可直接在网页上对 PDF 文件进行解析编辑，并保留其文件结构及格式 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JoFX86cC9)
[astrofox](https://github.com/astrofox-io/astrofox) | 一个比较有意思的动态影像应用，支持将音乐处理成可视化动态效果，并导出成视频 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JouXeBLEK)
[anbox](https://github.com/anbox/anbox) | 款比较实用的 Linux 工具，可在 GNU / Linux 系统上轻松运行 Android 系统 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jog1LnF1a)
[server](https://github.com/screego/server) | 一款开源的屏幕共享工具，拥有更低延迟、更高质量的屏幕共享体验 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JoeQH81g8)
[actionsflow](https://github.com/actionsflow/actionsflow) | 一款工作流程自动化辅助工具，可用于构建各类 App、数据、API 之间的工作流程，帮你更好的处理文件同步、信息收集、任务管理等事项 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JodFDdj2l)
[GHunt](https://github.com/mxrch/GHunt) | 一款开源的 OSINT（互联网公开情报） 采集工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JocuzkL0G)
[wireflow](https://github.com/vanila-io/wireflow) | 一款在线流程图绘制工具，支持使用 100 多种自定义图形、可进行多人协作、权限分配、实时聊天等功能、并拥有丰富的功能组件库 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JmYGfr5af)
[DevUtils-app](https://github.com/DevUtilsApp/DevUtils-app) | 一款比较实用的 Mac 开发者工具，提供了 Unix 时间戳解析、URL 编码/解码、JSON 格式化、JWT 调试器、query string 解析等功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JmPfKBbjO)
[bpytop](https://github.com/aristocratos/bpytop) | 一个开源的 Linux / OSX / FreeBSD 资源监控工具，支持显示处理器、内存、硬盘存储、网络与进程使用状态等信息，拥有多款可定制主题 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JlWgc2RMT)
[tunic](https://github.com/mikeslattery/tunic) | 一款比较实用的 Linux 系统安装工具，无需借助 U 盘和更改 BIOS 配置，即可在当前系统下直接安装 Linux 系统（支持双系统） | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JlPbOAFiV)
[playwright-cli](https://github.com/microsoft/playwright-cli) | 一款 Web 调试神器，可将 Web 页面上的用户交互转化为 JavaScript 代码，以便用于后续调试工作 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JlDpcfjRC)
[FreeCAD](https://github.com/FreeCAD/FreeCAD) | 一款开源的 3D 建模工具，可用于构建任意真实世界物件，组件丰富，操作便捷，应用广泛，其主要目的，在于帮你更好的创建高质量工程图 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JlkycyjJg)
[taskcafe](https://github.com/JordanKnott/taskcafe) | 一个基于 Go 与 Typescript 开发的看板开源软件，支持对任务进行筛选过滤、打标签、添加截止日期、分配成员、制定流程等操作 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jl43l1TUx)
[material-shell](https://github.com/material-shell/material-shell) | 给喜欢折腾 Linux 桌面版的同学推荐个 GNOME 插件，它打破了常规桌面工作杂乱无章的布局方式，以提升生产力为导向，对整体操作界面进行了优化 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jl07NEKhT)
[ProcMon-for-Linux](https://github.com/microsoft/ProcMon-for-Linux) | 微软在 GitHub 上开源了一款 Linux 版本的进程监控工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JiUTk2hx7)
[ar-cutpaste](https://github.com/cyrildiagne/ar-cutpaste) | 一款很牛逼的 AR 工具，用户通过 Android 或 iOS 手机安装这款工具，然后对着目标物品进行拍摄，工具就会将物品从周围环境中抠取出来，之后即可将它粘贴到 Photoshop 软件中 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JiKhLCv21)
[present](https://github.com/vinayak-mehta/present) | 一个可以在终端演示幻灯片的工具，而且还可以带颜色和动效 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JiDdodQcM)
[vimac](https://github.com/dexterleng/vimac) | 一款类似 Chrome 插件 Vimium 的 Mac 工具，在不借助鼠标或触摸板下，可通过键盘快捷键操作当前窗口，比如快速选中、上下滚动等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JizhQExYo)
[textshot](https://github.com/ianzhao05/textshot) | 一款高精度免费 OCR 工具，作者开发这款工具仅仅使用 139 行 Python 代码完成，就可快速提取截屏文本内容并复制到剪贴板 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JisBPcGNp)
[Ventoy](https://github.com/ventoy/Ventoy) | 一款能用于制作可启动 U 盘的装机神器 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JhnrifpAG)
[screenshot.rocks](https://github.com/daveearley/screenshot.rocks) | 蛮实用的 Web 工具，可为自己的项目定制一张清新简洁的产品截图，支持设置浏览器边框样式、截图左右间距、背景样式、窗口组件，并提供 Chrome、Firefox、Edge 等主流浏览器插件下载 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JhlRSq4VC)
[InfoSpider](https://github.com/kangvcar/InfoSpider) | 一个集众多数据源于一身的爬虫工具箱，其主要目的，在于帮助用户安全快捷的拿回自己的数据，并提供数据分析功能，基于用户数据生成图表文件，让用户能更直观、深入了解自己的信息 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JgXvVwOmN)
[full-mark-composition-generator](https://github.com/BeautyYuYanli/full-mark-composition-generator) | 满分作文生成器，该工具通过将专业术语与名人名言以随机的方式填入模板，生成一篇只有 "聪明人" 才能看懂的满分作文！ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jfsq1rIbe)
[3d-book-image-css-generator](https://github.com/scastiel/3d-book-image-css-generator) | 可自动为书籍创建 3D 图像，并自动生成指定的 CSS 与 HTML 代码，方便开发者快速将图像嵌入网页中 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JcbkZyEfn)
[Stacer](https://github.com/oguzhaninan/Stacer) | 一个比较实用的 Linux 系统监控与优化工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JbqcvFRWN)
[super-productivity](https://github.com/johannesjo/super-productivity) | 一款开源的清单管理软件，兼容 Linux、MacOS 与 Windows 等主流操作系统，旨在减少重复性工作所浪费的时间，有利于你追踪各项信息，制定好工作计划 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J9amtCi8l)
[sqlmap](https://github.com/sqlmapproject/sqlmap) | 一款比较实用的 SQL 渗透测试工具，开发者可利用它来完成程序的自动化检测，利用 SQL 注入漏洞，获取数据库服务器的权限 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J7Vn5xOgP)
[lens](https://github.com/lensapp/lens) | 一款比较实用的 Kubernetes IDE，支持 Windows、Linux、macOS 等几大主流桌面平台 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JvfGAidtx)
[MisakaTranslator](https://github.com/hanmin0822/MisakaTranslator) | 一款针对文字游戏的机翻工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J7aeBEIhL)
[magnetW](https://github.com/xiandanin/magnetW) | 一键搜全网磁力资源，支持 Window、macOS 系统 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J6LSF28XF)
[xgenecloud](https://github.com/xgenecloud/xgenecloud) | 一款极其实用的数据库开源神器 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J66f8yguu)
[color-copy-paste](https://github.com/sonnylazuardi/color-copy-paste) | 一枚开源的实时取色神器，直接打开摄像头就能实时取色！ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J5GUxzN78)
[penrose](https://github.com/penrose/penrose) | 一款颇为实用的工具，你只需输入数学公式，便可快速生成极具美感的数学图表 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J5fBHFwxn)
[Dango-Translator](https://github.com/PantsuDango/Dango-Translator) | 一款颇为实用的 OCR 翻译软件，当你在屏幕上设定好翻译框后，任何出现框中的外文（英文、日文、韩文），都会被自动识别并快速翻译成中文 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J52fEBCA8)
[sharedrop](https://github.com/cowbell/sharedrop) | 一款基于 WebRTC 技术开发的点对点文件传输工具，支持在相同或不同网络间，快速传输不同格式的文件 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J4UuRqolS)
[CopyTranslator](https://github.com/CopyTranslator/CopyTranslator) | 翻译神器，你只需将文本复制到剪贴板，即可快速查看翻译结果，享受所见即所得的快感 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J4KY55sww)
[ZY-Player](https://github.com/Hunlongyu/ZY-Player) | 一个开源的跨平台视频资源播放器 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J4JoFgSGi)
[image-scrubber](https://github.com/everestpipkin/image-scrubber) | 可快速移除图像中的元数据（EXIF 数据）识别信息，实现局部关键位置的打码操作，以保障图像发布者的隐私安全 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J4BxAdryL)
[glance](https://github.com/samuelmeuli/glance) | 一款开源的 macOS 应用，可用于预览各类默认在 macOS 上不被支持的文件格式，其中包含 .cpp，.js，.json，.py 等代码文件，Markdown、压缩包、Jupyter Notebook 等多种不同文件格式 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J3JkJgRVW)
[beekeeper-studio](https://github.com/beekeeper-studio/beekeeper-studio) | 一款开源的数据库管理工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J158KkLcD)
[text-to-handwriting](https://github.com/saurabhdaware/text-to-handwriting) | 一款文本转手写的转化工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J0dkg9NmV)
[Kanmail](https://github.com/Oxygem/Kanmail) | 一款开源邮件客户端，兼容了 macOS、Linux、Windows 等平台 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IFf2x7ZTA)
[bashtop](https://github.com/aristocratos/bashtop) | 一款 Linux 资源监控器，主要用于展示当前 Linux 系统的处理器、内存、硬盘、网络和进程等各项资源的使用情况与统计报告 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IFdt6FRiQ)
[mkdocs](https://github.com/mkdocs/mkdocs) | 一个可用于快速创建项目文档的开源神器，这款工具希望帮助开发者以更加快速、便捷的方式来创建项目文档，并为其生成更加简洁直观的静态站点 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/ICeQIu8kB)
[Yearning](https://github.com/cookieY/Yearning) | 一款可用于 SQL 审核的开源神器，该工具致力于帮助开发者快速完成 SQL 语句的审核、检测、执行、回滚等操作，使日常的 SQL 变动得以更加规范化、标准化 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IBtMnkTfX)
[darling](https://github.com/darlinghq/darling) | 让你在 Linux 上无缝运行 macOS 系统软件 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IAOt45NSv)
[Bob](https://github.com/ripperhe/Bob) | 一款开源的 Mac 端翻译软件，支持划词、截图、输入、插件等多种翻译方式 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IA72IxYjR)
[showdoc](https://github.com/star7th/showdoc) | 一款非常适合 IT 团队的开源在线 API 文档、技术文档工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IzXrhgiRr)
[Thief-Book](https://github.com/cteamx/Thief-Book) | 一款最强的 Windows、Mac 和 Linux 跨平台摸鱼神器，可以在任务栏、桌面、TouchBar上进行摸鱼，支持小说、股票、按键翻页、鼠标翻页、自动翻页等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ipp1ta8cj)
[gnirehtet](https://github.com/Genymobile/gnirehtet) | 一款免费开源的工具，手机通过 USB 连接电脑，即可使用电脑网络上网 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IoWJYxhCd)
[google-images-download](https://github.com/hardikvasa/google-images-download) | 一款开源免费批量下载 Google 图片的工具，支持 macOS、Windows 及 Linux 系统 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/InDP39g4X)

### 移动端

库名 | 简述 | 源
---- | ----- | -----
[noteless](https://github.com/redsolver/noteless) | 一款开源的 Markdown 安卓编辑器，支持语法高亮、多主题、全文搜索、附件嵌入及多种主流公式图标 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JASuXBVUI)
[flutter_example_apps](https://github.com/bizz84/flutter_example_apps) | 里面收集了多个基于 Flutter 开发的项目，按照不同编程水平，将项目划分为初、中、高三个等级 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JyJkWtwbK)
[DiDiPrism](https://github.com/didi/DiDiPrism) | 滴滴前不久在 GitHub 上开源了一款专注于移动端操作行为的工具，涵盖了 APP 操作回放、操作检测、以及数据可视化能力 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JyrF0j43l)
[AI-Radio](https://github.com/iampawan/AI-Radio) | 一款基于 Flutter 开发音乐 App：AI Radio，自带 AI 智能语音助手 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JxGBYcmHs)
[E-commerce-App-UI-Flutter](https://github.com/abuanwar072/E-commerce-App-UI-Flutter) |一个电商类 Flutter App，仅有最常见的商品列表页及商品详情页，页面非常干净简洁好看且带有过渡动画 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JjvqgsVGI)
[Flutter-Course-Resources](https://github.com/londonappbrewery/Flutter-Course-Resources) | 一份适合新手的 Flutter 教程，教程一共分为 16 节，分别介绍了如何搭建环境、如何创建 Flutter 应用、如何使用 UI 组件等，从入门到完整开发出一个 FLutter 应用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JiARguXBi)
[awesomefluttertips](https://github.com/erluxman/awesomefluttertips) | 里面收集了一些 Flutter 相关的开发技巧 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jc5Q2nufn)
[AndroidKnowledgeSystem](https://github.com/feelschaotic/AndroidKnowledgeSystem) | 一份最全 Android 进阶路线知识图谱 + 干货资料收集 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/InJk0leNr)

### 命令行工具

库名 | 简述 | 源
---- | ----- | -----
[gping](https://github.com/orf/gping) | 一款命令行工具，可为常用 ping 命令添加可视化的图形输出结果 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JutnaaK3y)
[nb](http://github.com/xwmx/nb) | 一个实用的命令行脚本工具，支持在命令中快速存储纯文本内容、内容加密、搜索与过滤，并基于 Git 进行同步、书签化内容管理等功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JtyO3FoE3)
[sqlite-utils](https://github.com/simonw/sqlite-utils) | 如果你想在命令行中比较简便的操作 SQLite 数据库，可以试下 sqlite-utils 这个 Python 库 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JtzZ7wPUk)
[rembg](https://github.com/danielgatis/rembg) | 一款可用于快速移除背景图片的开源工具，安装配置后可在服务器、命令行中对图片进行批量处理 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JtdcB2k0b)
[vdx](https://github.com/yuanqing/vdx) | 如果你平时习惯用 ffmpeg 来处理视频，那不妨试下用 vdx 这款命令行工具来优化下流程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JqXmzFTv0)
[bit](https://github.com/chriswalz/bit) | 一个基于 Go 编写的 Git 命令行工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jp1aeFTZZ)
[duf](https://github.com/muesli/duf) | 一款基于 Go 开发的命令行工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JmS0e5NdD)
[ali](https://github.com/nakabonne/ali) | 一款基于 Go 编写的 HTTP 负载测试工具，可在命令行中实时展示指定 URL 的延迟、速率限制、加载时间、表头信息等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JlCC2kL3w)
[croc](https://github.com/schollz/croc) | 一款命令行文件传输工具，其主要作用，是可在两台计算机上，使用命令行进行端对端加密的文件传输 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JjInVtMLJ)
[useful-scripts](https://github.com/oldratlee/useful-scripts) | 阿里一位后端工程师在 GitHub 上开源了一些比较实用的程序脚本 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JgsSjq4Am)
[ratel](https://github.com/ainilili/ratel) | 可以让你在命令行里面玩斗地主 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J86n194Jk)
[vimwiki](https://github.com/vimwiki/vimwiki) | 给 Vim 党用户推荐一款比较实用的插件，装上此插件可以通过 Vim 完成组织笔记和想法、管理待办事项、编写文档等工作 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J5bG9r4Uk)
[rich](https://github.com/willmcgugan/rich) | 该工具支持对命令行终端上的表格、进度条、Markdown、代码高亮、Emoji 表情等不同文本格式进行渲染 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J0Qdii3K2)
[qrcp](https://github.com/claudiodangelis/qrcp) | 一个文件传输工具，在使用时，只需用命令行为指定传输文件生成一个二维码，然后打开手机扫码，即可通过 WiFi 快速将文件从电脑传至手机上 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IEwgZuDQe)
[corona-cli](https://github.com/ahmadawais/corona-cli) | 支持在命令行中实时查询当前全球最新的疫情报告 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IA4xFljHe)

### Chrome 插件

库名 | 简述 | 源
---- | ----- | -----
[screenity](https://github.com/alyssaxuu/screenity) | 一款比较实用的 Chrome 录屏标记插件，支持在屏幕上任意位置进行录制和标注信息，拥有点击高亮效果，并可将录制视频导出 MP4、gif、webm 等文件格式 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JA50lEjr8)
[BlueSea](https://github.com/jiangqizheng/BlueSea) | 一个有趣的英语学习 Chrome 插件，支持划词翻译、单词高亮、单词弹幕、记忆曲线复习、词频统计等功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jyiew3EKS)
[funds](https://github.com/x2rr/funds) | 自选基金助手，可快速获取指定基金的实时数据，支持实时查看持仓当日估值收益，总收益和收益率，估值、净值、收益等走势图 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JwyBw0N5K)
[daily](https://github.com/dailydotdev/daily) | 一个为开发者而生的信息聚合平台，上面提供了超过 350+ 个开发者资讯来源，汇总了 1 万多个技术标签，是个获取最新开发资讯的好渠道 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JqGRImI5C)
[octoman-weibo-backup](https://github.com/misswell/octoman-weibo-backup) | 微博备份插件支持一键将自己的微博 HTML 页面保存到本地 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JcNrkERDQ)

### VSCode 插件

库名 | 简述 | 源
---- | ----- | -----
[huile8](https://github.com/mqycn/huile8) | 可将代码变量、注释、文档中的陌生英文单词，添加进 VSCode 单词库中，让开发者在 VSCode 中也能背单词 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JzXYbpmEQ)
[vscode-ltex](https://github.com/valentjn/vscode-ltex) | 可用于检测 LaTeX 拼写与语法错误，写论文时能派上用场 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jz9gjsApi)
[vsinder](https://github.com/benawad/vsinder) | 可让你在 VSCode 上，用类型 Tinder 的方式，通过代码来进行社交 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JyeHn6RId)
[ai-docstring](https://github.com/graykode/ai-docstring) | 基于 AI（NLP）技术，快速为 Python 函数生成 docstrings 代码片段，并可在几种不同的 docstring 格式类型中进行切换，支持 args、 kwargs、decorators、errors 和 parameter 等类型 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JvbL2lQKD)
[foam](https://github.com/foambubble/foam) | 可快速帮你组织好各类文章与笔记，生成可访问的内容节点，方便你更好的进行创作。在此之后，你还可以将本地内容快速部署到 GitHub Pages 上，以供他人预览 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JuUtt4HHy)
[vscode-stories](https://github.com/ide-stories/vscode-stories) | 可对当前 VSCode 编码界面进行录屏，并通过 ffmpeg 自动转为 gif 图 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JrZMCjVu6)
[anes-repository](https://github.com/gamedilong/anes-repository) | 可直接在 VSCode 上玩超级马里奥、坦克大战、魂斗罗、超时空要塞等经典游戏 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JpTn6itKR)
[vscode-math-to-image](https://github.com/TeamMeow/vscode-math-to-image) | 可直接将 LaTeX 数学公式转为 SVG 图片，并嵌入在原有位置上，以便在不同文本格式上进行展示 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JoXeI05Fo)
[coderoad-vscode](https://github.com/coderoad/coderoad-vscode) | 支持用户在 VSCode 编辑器中创建一种可交互式编码的技术教程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jon6933mx)
[vscode-react-icons](https://github.com/afzalsayed96/vscode-react-icons) | 可以让你在编辑器中直接搜索并使用 SVG 格式的图标，共支持 20 多个图标库 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JkQHisMGV)
[vscode-debug-visualizer](https://github.com/hediet/vscode-debug-visualizer) | 一款 VS Code 代码调试神器，这款插件用在代码调试时能以图的可视化方式快速展示数据结构，帮你理清数据结构与代码思路，告别枯燥的调试 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jijbl0xO9)
[leek-fund](https://github.com/LeekHub/leek-fund) | 这款插件，你能直接看到各个股票和基金的涨跌情况，股票实时 K 线图，基金历史净值等数据 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JeQ4KmGuc)
[pylance-release](https://github.com/microsoft/pylance-release) | 可用于 Python 的高性能、功能丰富的语言服务器，帮助 Python 开发者提升编码效率与编程体验 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J9Xvy2aOk)
[snipsnap](https://github.com/snipsnapdev/snipsnap) | 可自动显示当前项目每个库的所有可用代码片段。在开发项目时，能快速补全代码片段，提升开发效率 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J9rE3uhLs)
[foam](https://github.com/foambubble/foam) | 可快速帮你组织好各类文章与笔记，生成可访问的内容节点，方便你更好的进行创作 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J8PW4pe6Q)
[vscode-rainbow-fart](https://github.com/saekiraku/vscode-rainbow-fart) | 疯狂吹爆程序员彩虹屁的 VSCode 插件来了！其主要核心功能，就是能在你编程的时候，持续不断的夸你代码写的异常牛逼，前无古人后无来者 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J7thMjNCw)
[Github-Explorer](https://github.com/niudai/Github-Explorer) | 该插件通过一种较为友好的方式，让你能在 VSCode 上直接查看或下载某个 GitHub 项目的源文件，减少你来回折腾的成本 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J4NqJo0ch)
[vscode-realtime-debugging](https://github.com/hediet/vscode-realtime-debugging) | 该插件可更为直观的、实时的展示各项程序调试信息，帮助开发者更好的完成调试工作 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J3GYBp18S)
[vscode-drawio](https://github.com/hediet/vscode-drawio) | 来自德国的一名工程师 Henning Dieterichs 成功将 draw.io 的功能集成进了 VSCode，并打包成了插件供开发者下载使用，让你分分钟用 VSCode 画出完美的流程图、思维导图与 UML 图 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J1yZEqTTf)
[github-vscode-theme](https://github.com/primer/github-vscode-theme) | 一个拥有 GitHub 风格的 VSCode 主题 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J1s9jftqf)

### 资料集合

库名 | 简述 | 源
---- | ----- | -----
[corpus](https://github.com/SimmerChan/corpus) | 一份按 Task 划分的自然语言处理，知识图谱相关语料 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JAXZV9kT1)
[hacker-laws-zh](https://github.com/nusr/hacker-laws-zh) | 国内一名开发者近日在 GitHub 上放出了 Hacker Laws 中文翻译版，里面整合了一些对开发人员有用的定律、理论、原则和模式 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JqeCK4qhx)
[my-cs-degree](https://github.com/logancyang/my-cs-degree) | 一整套 CS 教程，内容主要包含计算机科学基础知识、深度学习、自然语言处理及软件全栈开发等技能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jppwcfb8t)
[awesome-cpp-cn](https://github.com/jobbole/awesome-cpp-cn) | 一份开源的 C++ 资源大全中文版，里面包含了各类 C++ 标准库、Web 应用框架、人工智能、数据库、图片处理、机器学习、日志、代码分析等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jmy29elm2)
[Poetry](https://github.com/Werneror/Poetry) | 一个古诗词项目，里面收录了从先秦到现代的共计 85 万余首古诗词 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JkzpICcPx)
[learning](https://github.com/amitness/learning) | 一份数据科学学习指南，旨在帮你每天提升 1% 的数据科学技能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JkxQj82jD)
[Chinese_Rumor_Dataset](https://github.com/thunlp/Chinese_Rumor_Dataset) | 一个比较有意思的数据集，里面收录了一些被微博判定为谣言的各类数据，其中包含转发、评论、原微博内容等数据 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JkhVXxj3e)
[leetcode_company_wise_questions](https://github.com/MysteryVaibhav/leetcode_company_wise_questions) | 苹果一位工程师 Vaibhav 搞了个 GitHub 项目，把众多知名大厂的 LeetCode 题目整合到一起，并打包成了 PDF | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jkfbu2V8X)
[applied-ml](https://github.com/eugeneyan/applied-ml) | 一份数据科学与机器学习相关的精选论文、技术文章与知名博客，里面覆盖了数据工程、自然语言处理、计算机视觉、强化学习等 24 种技术方向，大多数文章均来自世界各大名校名企 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jk78en6DX)
[100-nlp-papers](https://github.com/mhagiwara/100-nlp-papers) | 一份清单：《100 篇 NLP 必读论文》里面包含了机器学习、神经模型、语言建模、信息提取、机器翻译与问答等相关技术内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JjXHJzmQ2)
[Red-Teaming-Toolkit](https://github.com/infosecn1nja/Red-Teaming-Toolkit) | 一份「Red Team 安全攻防工具清单」，收录了各类情报搜集、漏洞扫描、网络钓鱼、渗透测试、终端远程访问、WiFi 攻击、嵌入式设备后门植入等一系列安全攻防工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JjMHP6sMQ)
[howtheytest](https://github.com/abhivaikar/howtheytest) | 精心整理了一份各大软件公司在社区公开分享的测试资源，含有测试最佳实践、工具、技术及软件测试文化等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jj38L1T00)
[data-engineer-roadmap](https://github.com/datastacktv/data-engineer-roadmap) | 数据工程师 2020 年最新学习路线指南，里面内容含有：CS 基础、数据库基础、关系数据库、集群计算基础、数据处理、监控数据管道、数据安全与隐私等等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jj1zl9gNJ)
[awesome-cpp-cn](https://github.com/jobbole/awesome-cpp-cn) | 一份中文版 C++ 资源大全，内容包括：标准库、Web应用框架、人工智能、数据库、图片处理、机器学习、日志、代码分析等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JiTIgaPOP)
[Awesome-Profile-README-templates](https://github.com/kautukkundan/Awesome-Profile-README-templates) |  GitHub 上一份精心收集整理的个人页 README 模板列表 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JiMEhAcaK)
[CV_Competitions](https://github.com/greathope/CV_Competitions) | 一份收集整理国内有奖金的视觉大赛列表，发起大赛组织有阿里云、华为云、讯飞等等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JirqLj4nN)
[nlp-tutorial](https://github.com/lyeoni/nlp-tutorial) | 一份 NLP 教程列表，内容含有新闻分类、电影评价分类、问答匹配、神经网络机器翻译等等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jii0h3CUy)
[algorithm-pattern](https://github.com/greyireland/algorithm-pattern) | 算法模板，教你最科学最快速的刷题，主要分为四大模块：入门篇、数据结构篇、基础算法篇、算法思维 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JigqRforn)
[CS-Notes](https://github.com/huangrt01/CS-Notes) | 一名来自字节跳动的开发者 huangrt01 在 GitHub 上开源了他的计算机学习笔记 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JhIGgE2PI)
[mit-15-003-data-science-tools](https://github.com/shervinea/mit-15-003-data-science-tools) | 一份数据科学工具指南，里面涵盖了 SQL，R，Python，Git 和 Bash 等常用编程语言和工具的使用指南，其目的在于让开发者更便捷的理解数据检索、数据处理、数据可视化等技术概念 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JhEISanhr)
[Penetration_Testing_POC](https://github.com/Mr-xn/Penetration_Testing_POC) | 一份渗透测试笔记，里面汇总了一些渗透测试工作中常用到的 POC、脚本、工具、学习资源、操作技巧等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jg464ALTR)
[computervision-recipes](https://github.com/microsoft/computervision-recipes) | 一份计算机视觉指南《Computer Vision Recipes》里面提供了可用于构建计算机视觉系统的代码示例与最佳实践准则 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JfRakjXxA)
[AI-research-tools](https://github.com/bighuang624/AI-research-tools) |  AI 科研工具集，里面汇总了包含论文查找、阅读、写作、编码实验等多个不同场景下的工具列表 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JfGapDz66)
[notes-to-cs-freshmen-from-the-future](https://github.com/nushackers/notes-to-cs-freshmen-from-the-future) | 一份给计算机新手看的介绍指南，该指南由新加坡国立大学的教授们为新学所准备，里面提供了计算机科学行业建议、知名程序员介绍、Unix 入门参考、知名 CS 公开课及学习资源等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JfdSWl1JH)
[pytorch-tutorial](https://github.com/yunjey/pytorch-tutorial) | 一份开源的 PyTorch 教程代码，内容主要是为学习 PyTorch 的深度学习研究人员提供的教程代码，其中大多数模型用了不到 30 行代码实现，大家可配套官方 PyTorch 参考学习 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JeDKmuKkU)
[how-to-secure-anything](https://github.com/veeral-patel/how-to-secure-anything) | 一份开源的安全工程指南，这份指南将带你了解安全工程、安全架构、系统防御强化、漏洞排查等计算机网络安全相关的基础知识 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JeCaWhenP)
[QA-Survey](https://github.com/BDBC-KG-NLP/QA-Survey) | 一份在 GitHub 上开源的问答系统调研报告，包括知识图谱问答系统（KBQA）和文本问答系统（TextQA）两类系统的调研，每类系统又各分为学术界和工业界。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JdrDc0wqY)
[cheatsheets](https://github.com/matplotlib/cheatsheets) | 一份速查表清单，里面包含了 Matplotlib 相关的各种常用代码片段、配置方案、使用技巧等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jb7lwgByw)
[gotraining-studyguide](https://github.com/ardanlabs/gotraining-studyguide) | 一份 Go 语言学习指南：《Ultimate Go study guide》作者学习 Go 语言和计算机系统时所作的笔记 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J9uowFVTS)
[deep-learning-drizzle](https://github.com/kmario23/deep-learning-drizzle) | 收集了诸多与深度学习相关的开放性学习资源，其中包括机器学习、自然语言处理、深度神经网络、计算机视觉等多个不同分支的归类 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J9cIBsOpW)
[learnopencv](https://github.com/spmallick/learnopencv) | 收集了不少与计算机视觉、深度学习、人工智能相关的教程文章和示例代码 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J8ilNAW4S)
[TeachYourselfCS-CN](https://github.com/keithnull/TeachYourselfCS-CN/blob/master/TeachYourselfCS-CN.md) | 如何自学计算机科学，这里有份指南可供你参考 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J7LWB2Krs)
[Cpp-0-1-Resource](https://github.com/AnkerLeng/Cpp-0-1-Resource) | 一份开源的 C++ 入门学习资源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J6hf32pI5)
[ml-engineer-roadmap](https://github.com/chris-chris/ml-engineer-roadmap) | 一份机器学习工程师技术路线图，里面整理了与机器学习相关的常用框架、编程语言、实用工具等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J6fFD5SQm)
[the-incredible-pytorch](https://github.com/ritchieng/the-incredible-pytorch) | 收集了许多与 PyTorch 相关的教程、项目、论文、书籍、视频等资源，以便让开发者得以更快上手 PyTorch 开发 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J67Oy9Dgi)
[Algorithm-Guide](https://github.com/Xunzhuo/Algorithm-Guide) | 收集汇总了一些与算法竞赛、数据结构有关的课件、论文、书籍、网站、习题 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J2UgHzI3S)
[awesome-ml-courses](https://github.com/luspr/awesome-ml-courses) | 德国一名工程师在 GitHub 上分享了他所收集汇总的一些机器学习课程资源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J2MpCDbZ8)
[learngo](https://github.com/inancgumus/learngo) | 包含了共计 1000+ 个 Go 语言相关的代码示例、练习、测验题 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J2rZdoSio)
[app-ideas](https://github.com/florinpop17/app-ideas) | 里面收集了共 86 个可供开发者练习参考的项目创意，其中初级项目 34 个、中级 32 个、高级 20 个，每个项目均附有较为详细的项目参考文档 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J2mGqvMRP)
[git-manual](https://github.com/xjh22222228/git-manual) | Git 常用命令参考手册：该 repo 汇总了一些比较常用的 Git 命令，以便于大家查阅使用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J1RQE7Jif)
[awesome-ml-courses](https://github.com/luspr/awesome-ml-courses) | 一份 AI 相关的学习资源汇总清单，里面收纳了斯坦福、加州伯克利、哥伦比亚、华盛顿大学等多个高校的免费开放课程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J1qQGrY0n)
[CPlusPlusThings](https://github.com/Light-City/CPlusPlusThings) | 该资料主要面向 C++ 新手初学者，提供了从入门到进阶的知识点及工具讲解，主要解决面试者与学习者想要深入 C++ 及如何入坑 C++ 的问题 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J17C7fsCO)
[eng-practices](https://github.com/google/eng-practices) | Google 开源的一份工程实践文档，希望通过这份文档，能帮助更多开发者完成代码审查工作，为项目代码提供标准参考 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J0YtkFMbY)
[til](https://github.com/jbranchaud/til) | 收集其平日所学的一些碎片化编程知识和开发技巧，其中包括 Git、JavaScript、Linux、VSCode、Devops、Chrome 等不同技术领域的分类 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IEdpbzdIJ)
[oi-slides](https://github.com/huzecong/oi-slides) | 一位开发者将其在 2013-2018 年期间的信息学竞赛课件在 GitHub 上开源了，覆盖了 TopCoder 题目选讲、CodeChef 题目选讲、趣题选讲、网络流模型与例题、NOIp 图论、数据结构及应用等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IC5qdEwXb)
[fucking-algorithm](https://github.com/labuladong/fucking-algorithm) | 共有 60 多篇基于 LeetCode 为主题撰写的原创文章，涵盖了所有题型和技巧，致力于做到举一反三、通俗易懂，而不是简单的代码堆砌 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IB1qKiBt8)
[CS-Xmind-Note](https://github.com/SSHeRun/CS-Xmind-Note) | 一份计算机科学相关的思维导图与学习笔记，包含计算机组成原理、数据结构、计算机网络、操作系统等常见分类 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IApILuL7A)
[my-mac-os](https://github.com/nikitavoloboev/my-mac-os) | 伦敦一位开发者将自己平时常用的 Mac 软件及工具统一整理后放到 GitHub 上了，其中包括不少可提升生产力和开发效率的工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IzEa93dl3)
[fun-with-graphics](https://github.com/FancyVin/fun-with-graphics) | 一份整理了图形学相关的高校课程、书籍、教程、文章、开源项目、网站等资料集合 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IpsX0tcu1)
[awesome-kotlin](https://github.com/KotlinBy/awesome-kotlin) | 一份精选收集整理 Kotlin 相关资料的集合 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IooXx9vMk)
[programmer-advancement](https://github.com/Snailclimb/programmer-advancement) | 《程序员修炼之路》作者将自己作为一个过来人，总结了自己程序员修炼之路的经验，以及给后辈的一些建议 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/InWG2fRoq)

### 面试资料

库名 | 简述 | 源
---- | ----- | -----
[interview-questions](https://github.com/resumejob/interview-questions) | 一份开源的大厂高频面试题资源整理，根据国内外论坛收集超过 1700 篇真实面经整理的腾讯，阿里，字节跳动，Shopee，美团，滴滴高频面试题 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jrxv8E2eo)
[Tech-Interview-Cheat-Sheet](https://github.com/TSiege/Tech-Interview-Cheat-Sheet) | 一份开源的技术面试清单速查表，主要收录了数据结构与算法的常见面试技术点 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JqFGE9i24)
[data-science-interviews](https://github.com/alexeygrigorev/data-science-interviews) | 一份数据科学相关的面试题，主要分为两部分：知识理论（如线性回归、神经网络、决策树、文字分类等）与技术应用（如 SQL、Python、算法等）内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JlciLluvR)
[FE-Interview](https://github.com/lgwebdream/FE-Interview) | 一个前端面试必备题库，里面共包含 1000+ 道面试真题，覆盖 HTML、CSS、JavaScript、Vue、React、Node、TypeScript、Webpack、算法、网络与安全、浏览器等多个知识点 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JgLJjdFtx)
[God-Of-BigData](https://github.com/wangzhiwubigdata/God-Of-BigData) | 一份大数据面试题解，主要分为大数据开发基础篇、框架学习篇、实战进阶篇等三大篇章，包含了高并发、分布式、Hadoop、Spark、Flink、Kafka 等技术点的高频面试题讲解 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JfTws7cuO)
[LeetCode](https://github.com/yuanguangxin/LeetCode) | 整理的 LeetCode 题目分类与面试题答案解析，涵盖链表、指针遍历、字符串操作、堆栈、递归、动态规划、二叉搜索树等知识点，题解代码基于 Java 实现 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JfnjqgCej)
[Reflection_Summary](https://github.com/sladesha/Reflection_Summary) | 一套算法理论基础知识，里面涵盖了数学、数据预处理、机器学习、深度学习、自然语言处理等多个技术领域的面试知识 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JejjWgty2)
[Data-Science-Interview-Resources](https://github.com/rbhatia46/Data-Science-Interview-Resources) | 一份数据科学相关的面试资源汇总，里面包含了概率统计、SQL 和数据采集、数据可视化、经典机器学习算法、深度学习、数据结构与算法等常见面试高频题的讲解 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JefaVDyHo)
[leetcode](https://github.com/grandyang/leetcode/blob/master/README-CN.md) | 国内一位开发者在 GitHub 上搞了个 LeetCode 题解项目，目前已收录 900 多道题 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JdLHHexum)
[LeetcodeTop](https://github.com/afatcoder/LeetcodeTop) | 汇总了各大互联网公司容易考察的高频 LeetCode 题的热度，以便帮助同学们更加有针对性地准备面试 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JdfktdUpT)
[JavaFamily](https://github.com/AobingJava/JavaFamily) | Java 面试与学习指南，里面涵盖了大部分 Java 程序员所需要掌握的核心知识，其中包括 JVM、并发与多线程、常用工具集、数据结构与算法、消息队列、数据库等知识点 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JcHxn1Zps)
[algorithm-pattern](https://github.com/greyireland/algorithm-pattern) | LeetCode 刷题模板，里面主要记录了他通过各种刷题文章、专栏、视频等内容总结出的刷题心得，仅供参考 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J73yAc4We)
[go-interview](https://github.com/shomali11/go-interview) | 来自纽约的一名开发者 Raed Shomali 在 GitHub 上开放了他所整理的一些 Go 语言面试题及答案 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J4utdaDRp)
[algo](https://github.com/hoanhan101/algo) | 一份含有 107+ 条最常出现的编码面试问题及详细解决方案 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IoE5a7LNi)
[Waking-Up](https://github.com/wolverinn/Waking-Up) | 一份全面总结计算机基础面试问题资料，该资料是作者在两次面试大厂失败后，在进行系统学习计算机网络、操作系统、数据库等知识时，整理出来的常见面试题及答案，最后作者还是拿到了大厂 Offer | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/InSWFA3DA)

### 机器学习/人工智能

库名 | 简述 | 源
---- | ----- | -----
[FGVC](https://github.com/vt-vl-lab/FGVC) | 可基于光流边缘引导的视频补全算法，对视频物品进行自动抠除、补全 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JA7mugoid)
[Real-time-stock-market-prediction](https://github.com/victor369basu/Real-time-stock-market-prediction) | 基于机器学习来进行股票市场预测 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JzWKVgjsS)
[ArtLine](https://github.com/vijishmadhavan/ArtLine) | 基于深度学习，为人物肖像生成线条、卡通、电影海报等多种不同风格的画像 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JzFhoBJRY)
[NL2SQL](https://github.com/yechens/NL2SQL) | 可将自然语言文本转换成结构化查询语言 SQL，致力于打破人与结构化数据之间的壁垒 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JzrIWDl1V)
[BackgroundMattingV2](https://github.com/PeterL1n/BackgroundMattingV2) | 可实时、快速的对高分辨率图像、视频进行自动背景抠图 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JyZrthulI)
[anime_biggan_toy](https://github.com/HighCWu/anime_biggan_toy) | 可使用 BigGAN 生成令人惊叹的动漫图片 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JyI9SvtdJ)
[qlib](https://github.com/microsoft/qlib) | 微软在 GitHub 上开源的一个 AI 量化交易平台 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jy5gPyZqM)
[AnimeGAN](https://github.com/TachibanaYoshino/AnimeGAN) | 可借助 AI 技术，快速将真实图像转换为日漫风格的画作 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JxjJZF2G2)
[U-2-Net](https://github.com/NathanUA/U-2-Net) | 借助 AI 技术为人物肖像生成手绘风格的画像 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JvlbxcTQz)
[machine-learning-cheat-sheet](https://github.com/soulmachine/machine-learning-cheat-sheet) | 一个开源的机器学习速查表清单，里面包含许多关于机器学习的经典方程式和图表，其目的在于帮助开发人员快速回顾关于机器学习的知识和思想，或用于面试复习 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JuDYBaZ10)
[SkyAR](https://github.com/jiupinjia/SkyAR) | 来自密歇根大学博士后研究员 Zhengxia Zou 发布了一项自己的研究，可将某个视频中的真实天空背景，通过 AI 替换成类似科幻片中的电影场景，效果非常震撼 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JusbYuv69)
[Bringing-Old-Photos-Back-to-Life](https://github.com/microsoft/Bringing-Old-Photos-Back-to-Life) | 借助 AI 对老照片快速进行修复，基于 PyTorch 实现，支持划痕检测、面部修饰、全局还原等操作 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Juhc3zPFi)
[pifuhd](https://github.com/facebookresearch/pifuhd) | 由 Facebook 研究室开源，其主要作用，是能通过 AI 快速为人体生成 3D 建模，减少游戏、动画制作人员的工作量 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Juaw2pyQR)
[WebGL-Fluid-Simulation](https://github.com/PavelDoGreat/WebGL-Fluid-Simulation) | 一个 WebGL 流体模拟器，支持设置流体密度、速度扩散范围、压力、飞溅半径、光影效果等属性 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JtRF3kasE)
[PathPlanning](https://github.com/zhm-real/PathPlanning) | 一个实现了多种在机器人领域中常用到的路径规划算法，其中也包括基于搜索与采样的方法 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JteM0nH7e)
[AI-Expert-Roadmap](https://github.com/AMAI-GmbH/AI-Expert-Roadmap) | 一个 AI 技术进阶路线图，由德国一家软件公司 AMAI GmbH 发起，里面包含了 AI 技术领域的相关知识点，每个知识点均附有详细文档 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JsBuCASPQ)
[RedditBot-FastAI](https://github.com/ClarityCoders/RedditBot-FastAI) | 基于 Python 和 FastAI 做了个 NSFW（不宜在工作场所打开）图像分类器，可对黄色暴力图像进行分类筛选 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JsvZEavHI)
[PaddleOCR](https://github.com/PaddlePaddle/PaddleOCR) | 一套丰富、领先、且实用的 OCR 工具库 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JrJ1vz0W8)
[aim](https://github.com/aimhubio/aim) | 可用于快速记录、搜索与比较不同 AI 实验的结果与数据，操作便捷，配置灵活 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JrBqFnngS)
[Map-based-Visual-Localization](https://github.com/TurtleZhong/Map-based-Visual-Localization) | 一款基于地图的视觉定位通用框架 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jq5dpD73P)
[nni](https://github.com/microsoft/nni) | 一个轻量但功能强大的工具包，可帮助用户自动进行特征工程，神经网络架构搜索，超参调优以及模型压缩 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JpBMasirg)
[EssayKiller_V2](https://github.com/EssayKillerBrain/EssayKiller_V2) | 一款基于 GPT2.0 的初代创作型人工智能框架 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JoNOd91nt)
[mona_lisa_eyes](https://github.com/emilyxxie/mona_lisa_eyes) | 基于 TensorFlow.js 和 WebCam 做了个挺有意思的开源项目，画中蒙娜丽莎的眼睛会跟随人体移动轨迹转动 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JmFPh1MAn)
[VisualDL](https://github.com/PaddlePaddle/VisualDL) | 百度在 GitHub 上开源的一款 AI 可视化分析工具，提供了丰富的可视化功能，支持标量、图结构、数据样本可视化、直方图、PR 曲线及高维数据降维呈现等诸多功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jl1x3uHdM)
[tensorflowjs-webcam-transfer-learning](https://github.com/mburakerman/tensorflowjs-webcam-transfer-learning) | 一个基于 Tensorflowjs 开发的小 Demo，可检测摄像头前物体的移动轨迹并控制汽车转向 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JkLcliIMp)
[eiten](https://github.com/tradytics/eiten) | 国外一家热衷于用 AI 与数据分析来做投资分析的企业 Tradytics 开源了他们内部的工具包，里面主要实现了各种统计与算法投资策略，如最小方差、最大夏普比率和基于遗传算法的投资组合 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JkCWU2DLI)
[awesome-project-ideas](https://github.com/NirantK/awesome-project-ideas) | 精心整理了一批机器学习、NLP、计算机视觉及推荐系统相关的开发资源，并提供项目实现思路、产品方向、数据集等资料，就差具体代码实现了 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JjHcRAaax)
[funNLP](https://github.com/fighting41love/funNLP) | 整合较为丰富的中文 NLP 资源库，涵盖了中英文敏感词、语言检测、名字推断性别、手机号抽取、身份证抽取、邮箱抽取、中日文人名库、中文缩写库、拆字词典等等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JjtQPsLSj)
[fancy-nlp](https://github.com/boat-group/fancy-nlp) | 一款用于建设商品画像的文本知识挖掘工具，支持实体提取、文本分类和文本相似度匹配等多种常见 NLP 任务 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JjolSeivg)
[minGPT](https://github.com/karpathy/minGPT) | 特斯拉 AI 总监 Andrej Karpathy 用 300 行 PyTorch 代码实现了 GPT 模型，相对其他大多数 GPT 模型它更加小巧、简洁 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JjnaNFLRM)
[fakeface](https://github.com/hankhank10/fakeface) | 可根据接口参数返回 AI 生成的假脸数据，其数据主要来自于 thispersondoesnotexist 生成的 15000 张 AI 人脸图片，开发者可传递性别、年龄等参数来获取指定 AI 人脸 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JhwRNaQyG)
[machine-learning-roadmap](https://github.com/mrdbourke/machine-learning-roadmap) | GitHub 上有个老哥为机器学习初学者绘制了一份学习路线图，里面主要包含 5 大分支路径 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JdWc1DUtq)
[awesome-production-machine-learning](https://github.com/EthicalML/awesome-production-machine-learning) | 比较实用的机器学习项目汇总清单，包含了一系列优秀的机器学习开源库，可帮你完成项目的监控、部署、安全防护 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jcfh9nOgK)
[genetic-drawing](https://github.com/anopara/genetic-drawing) | 借助遗传算法来完成绘画工作 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J5No8wjdc)
[DeepFaceLab](https://github.com/iperov/DeepFaceLab) | 开发者通过这款软件，可任意替换视频中的人脸、头像，以及进行口型匹配 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J5I5mm7KF)
[data-scientist-roadmap](https://github.com/MrMimic/data-scientist-roadmap) | 一份数据科学家技术修炼图 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J3piFmjFI)
[Background-Matting](https://github.com/senguptaumd/Background-Matting) | 可利用神经网络技术，自动完成视频抠图功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J2BpIuFE0)
[pose-animator](https://github.com/yemount/pose-animator) | 可识别出人类的表情变化与肢体动作，并将其映射到 2D 矢量图型上，让它跟着你的节拍动起来 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J1eXBpaDo)
[scarpet-nn](https://github.com/ashutoshbsathe/scarpet-nn) | 印度有位小哥在「我的世界」上搭建出了一个神经网络 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J054Q5KjJ)
[vt-vl-lab/3d-photo-inpainting](https://github.com/vt-vl-lab/3d-photo-inpainting) | ，可快速将普通照片转为 3D 照片，让人物看起来更有立体感 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IFFKC9bEs)
[photo2cartoon](https://github.com/minivision-ai/photo2cartoon) | 可快速将真实照片转换为卡通风格的非真实感图像 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IEmPH1xCZ)
[zoombot](https://github.com/mcreed/zoombot) | 国外有个小哥因为无法忍受公司永无止境的 Zoom 远程会议，便做了一款工具 - Zoombot 来代替自己去开会，基于 AI 进行开发，用到了诸如语言识别与文本转语音等技术 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IDAUvFtwP)
[chineseocr_lite](https://github.com/ouyanghuiyu/chineseocr_lite) | 一个轻量级中文 OCR，支持竖排文字识别 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Iy4nM2wdQ)

### 开源书籍/教程

库名 | 简述 | 源
---- | ----- | -----
[unplugged](https://github.com/liuxinyu95/unplugged) | 《同构 - 编程中的数学》，有提供中英文两种版本 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JzKzWmxGY)
[missing-semester-cn.github.io](https://github.com/missing-semester-cn/missing-semester-cn.github.io) | 《计算机教育中缺失的一课》中文版，主要讲授命令行、文本编辑器、Git 版本控制系统等工具的使用，以及关于元编程、安全和密码学等知识的科普 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JzB9s4UhA)
[ssh-tutorial](https://github.com/wangdoc/ssh-tutorial) | 一本关于 SSH 相关的技术教程，用于介绍 SSH 的概念和基本用法，也可以当作手册查询 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JyKw0Am3l)
[high-performance-go](https://github.com/geektutu/high-performance-go) | 《Go 语言高性能编程》 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JyGAt2oaN)
[school-of-sre](https://github.com/linkedin/school-of-sre) | LinkedIn 在 GitHub 上开源了其企业内部的 SRE 技术课程，主要包含 Linux、Git、Python、Web、MySQL、大数据、系统设计、网络安全等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JxVrZ31XK)
[introduction-to-bash-scripting](https://github.com/bobbyiliev/introduction-to-bash-scripting) | 《Introduction to Bash Scripting》，里面包含了 Bash 结构、变量、用户输入、注释、条件表达式、函数、调试、脚本编写及应用、Cloudflare API 对接等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JwRsv8niY)
[git-flight-rules](https://github.com/k88hudson/git-flight-rules/blob/master/README_zh-CN.md) | 一份开源的 Git 学习指南，指南里面记录了某个事情发生的原因，以及怎样进行流程化处理。本质上，它们是特定场景的标准处理流程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JvYsXjaRd)
[EffectiveModernCppChinese](https://github.com/kelthuzadx/EffectiveModernCppChinese) | 《Effective Modern C++ 》作为 高效 C++ 丛书之一，通过对复杂技术知识点的清晰阐释，让其成为 C++ 程序设计指南业界标杆 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JsFq8r192)
[build](https://github.com/handsonscala/build) | 《动手学 Scala 编程》作者将会配合一些真实场景与项目案例，如可交互式网站、网络文件同步、Web 爬虫、数据迁移等工具与应用，让新手可以更为直观的认识到 Scala 在现实生产环境中的实际应用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jp9pGzOPY)
[30-Days-Of-Python](https://github.com/Asabeneh/30-Days-Of-Python) | 一个适合新手入门学习的 Python 教程《30-Days-Of-Python》 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JoySKu5Uy)
[beginners-intro-javascript-node](https://github.com/microsoft/beginners-intro-javascript-node) | 为了帮助前端开发者更好的掌握 JavaScript 和 Node.js 技术，微软在 GitHub 上开源了一个教程：《 Intro to JavaScript (Node.js)》 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JowwDfaiX)
[sword-for-offer](https://github.com/darkTianTian/sword-for-offer) | 一个使用了 Python3 实现《剑指 Offer 第二版》题目的开源项目 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JopsfxyuE)
[java-concurrency-in-practice](https://github.com/preslavmihaylov/booknotes/tree/master/java/java-concurrency-in-practice) | 《Java 并发实践》该书主要包括 Java 并发基础介绍、构建并发应用、性能优化与测试以及搭建自定义同步器、Java 内存模型等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JmJKN6dd2)
[gitmagic](https://github.com/blynn/gitmagic) | 《Git 魔法书》该书主要面向初学者讲解 Git 基础知识与使用技巧，如代码提交、版本回滚、分支合并、冲突处理、索引维护及多人开发协作的整个流程等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jm47h1i8b)
[mml-book.github.io](https://github.com/mml-book/mml-book.github.io) | 《机器学习之数学》主要分为两大部分，一讲数学基础，二讲数学在机器学习算法中的应用。你能从该书中学到线性代数、微积分和概率论等数学基础知识 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JkgKTBteH)
[ultimate-python](https://github.com/huangsam/ultimate-python) | 一份开源的 Python 初级入门教程，包含了 Python 基础入门介绍、常用语法、数据结构、类以及部分进阶知识介绍 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jk9umcAft)
[linuxupskillchallenge](https://github.com/snori74/linuxupskillchallenge) | 一份开源的 Linux 教程，该课程旨在通过一个月时间，让开发者快速掌握 Linux 基础使用技巧 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jk03RkqVf)
[Computer-Networking-A-Top-Down-Approach-NOTES](https://github.com/moranzcw/Computer-Networking-A-Top-Down-Approach-NOTES) | 一份经典的计算机网络书籍《计算机网络－自顶向下方法》笔记。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JjlZKnK69)
[convex-optimization.github.io](https://github.com/convex-optimization/convex-optimization.github.io) | 一本免费阅读的凸优化算法书籍《Algorithms for Convex Optimization》 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JiS8Qieau)
[easy_rust](https://github.com/Dhghomon/easy_rust) | 《Easy Rust》该书的最大特点，在于它使用了较为基础的英文语法, 目的是为了让那些母语不是英语的人能更快的学习 Rust，以便降低他们学习的门槛 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JiIIlsh78)
[TLCL](https://github.com/billie66/TLCL) | 一本 Linux 命令行书籍：《The Linux Command Line》，中文翻译版：《快乐的 Linux 命令行》 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JipRm24cb)
[Learn-Vim](https://github.com/iggredible/Learn-Vim) | 《Learn-Vim》从这本书中，你将学到 Vim 窗口、选项卡的管理，快速打开和搜索文件，插入模式、集成外部命令、常用语法等 Vim 相关使用技巧 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JhZ9hpWgR)
[raspberry-pi-os](https://github.com/s-matyukevich/raspberry-pi-os) | 将基于树莓派与 Linux 内核，手把手教你创建一个简易版的操作系统，你能从这门课程中学到关于内核初始化、处理器初始化、进程调度器、虚拟内存管理等基础知识 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jhe0NsJHr)
[fastbook](https://github.com/fastai/fastbook) | 国外非营利性科技组织 fast.ai 最近开放了他们的新版深度学习课程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jh3pfjGSE)
[vim-galore-zh_cn](https://github.com/wsdjeg/vim-galore-zh_cn) | 一本开源的 Vim 入门教程：《Vim Galore》，里面主要包含了 Vim 的基础知识讲解、安装指南、日常开发与调试技巧，以及一些较为实用的插件介绍 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JgAJpm8jm)
[SurviveSJTUManual](https://github.com/SurviveSJTU/SurviveSJTUManual) | 《上海交通大学生存手册》其内容分为立志篇、访谈集、生存技巧等三大篇章，致力于从学术上、工作上、日常生活上给学生以正确指引 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JgjrODqpC)
[Getting-Things-Done-with-Pytorch](https://github.com/curiousily/Getting-Things-Done-with-Pytorch) | 《Getting Things Done with Pytorch》从该书中学到有关 PyTorch、神经网络、图像分类、人脸检测、情感分析等基础知识 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JghSp1x54)
[magic-python](https://github.com/iswbm/magic-python) | 《Python 黑魔法手册》里面主要记录了与 Python 相关的一些语法冷知识、命令行使用技巧、开发技巧、编码习惯、开发工具等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JfoSQ73X2)
[eat_pytorch_in_20_days](https://github.com/lyhue1991/eat_pytorch_in_20_days) | 《20 天内吃掉那只 PyTorch》本书主要基于 Pytorch 官方文档和函数文档整理编著而成，在篇章结构和范例选取上做了大量优化，对用户更加友好 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JfiZwCQRb)
[byte-of-vim](https://github.com/swaroopch/byte-of-vim) | 《A Byte of Vim》这本书将会教授你一些与 Vim 相关的基础知识，例如 Vim 的发展历史、安装方式、常用操作与快捷命令，以及如何通过编写脚本与安装插件来扩展更多 Vim 功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jdjg0yFqK)
[nlp-tutorial](https://github.com/graykode/nlp-tutorial) | NLP 教程，包含了 CNN、RNN、Transformer 等 13 个常用的模型与代码实现，并且大部分都兼容了 TensorFlow 和 PyTorch 两大框架 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JdgTT8LlY)
[dlwpt-code](https://github.com/deep-learning-with-pytorch/dlwpt-code) | 《Deep Learning with PyTorch》全书累积近 500 页，15 个章节，并配以大量形象生动的插图，帮助开发者更好的掌握 PyTorch 技术 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JbrLVt10p)
[Python-Core-50-Courses](https://github.com/jackfrued/Python-Core-50-Courses) | 《Python 语言基础 50 课》你能学到关于 Python 语言元素、分支与循环结构、函数和模块、常用数据结构、列表和元组等基础知识 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J7ea9gHSI)
[ReID_tutorial_slides](https://github.com/michuanhaohao/ReID_tutorial_slides) | 《基于深度学习和行人重识别》主要适合深度学习和行人重识别领域无基础的入门者学习，有基础者无需学习此课程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J7bO1uCmx)
[springcloud-learning](https://github.com/macrozheng/springcloud-learning) | 一个开源的 Spring Cloud 教程，里面涵盖了大部分核心组件的使用教程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J74JEqOs6)
[go-ast-book](https://github.com/chai2010/go-ast-book) | 《Go 语法树入门》主要涵盖 CGO、Go 汇编语言、RPC 实现、Web 框架实现、分布式系统等高阶主题 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J5Scbb0If)
[MTBook](https://github.com/NiuTrans/MTBook) | 《机器翻译：统计建模与深度学习方法》主要对机器翻译的统计建模和深度学习方法进行较为系统的介绍 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J5lv0hH1e)
[Deep-Learning-with-TensorFlow-book](https://github.com/dragen1860/Deep-Learning-with-TensorFlow-book) | 《TensorFlow 2.0 深度学习开源书（龙书）》是一本面向人工智能，特别是深度学习初学者的书 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J4DTIi6FF)
[practical-python](https://github.com/dabeaz-course/practical-python) | 《实用的 Python 编程》课程共分为 10 个章节，向开发者教授 Python 的基础语法、数据处理、打包调试等知识 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J4zYaosR8)
[Statistical-Learning-Method_Code](https://github.com/Dod-o/Statistical-Learning-Method_Code) | 北京大学的一名学生手写实现了李航老师《统计学习方法》书中的全部算法 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J2lxdzbC6)
[DeepLearning](https://github.com/MingchaoZhu/DeepLearning) | 《深度学习》（花书）国内一位来自复旦大学的开发者基于数学推导和产生原理，重新描述书中概念，并用 Python (numpy 库为主) 再次复现了书本内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J1Qhefu3Z)
[InterpretableMLBook](https://github.com/MingchaoZhu/InterpretableMLBook) | 《可解释的机器学习》全书共累计 250 多页、7.8 万词、1200 多次提交 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J1am286xg)
[joyful-pandas](https://github.com/datawhalechina/joyful-pandas) | 《Joyful-Pandas》将从 Pandas 基础、数据分析方法、数据处理类型及动手实践四个模块入手，对 Pandas 进行系统性学习 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IEEw937cx)
[bash-tutorial](https://github.com/wangdoc/bash-tutorial) | 《Bash 脚本教程》作者是 IT 圈知名博主阮一峰，这份课程将向读者讲解 Bash 的一些基础用法，如变量、字符串操作、算术运算、脚本入门等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IDINemF9z)
[effective-java-3rd-chinese)](https://github.com/sjsdfg/effective-java-3rd-chinese) | 《Java 高效编程》该书共包含 90 个条目，每个条目都单独讨论 Java 程序设计中的一条规则，这些规则将从正面反映出优秀程序员在实践工作中的一些做法 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IDsgHiUWr)
[react-naive-book](https://github.com/huzidaha/react-naive-book) | 《React.js 小书》该书为有一点前端基础的并且是 React.js 零基础的同学而作，以帮助他们掌握 React.js 并且灵活地把 React.js 应用到实际项目当中 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/ICH8d436f)
[EffectivePyTorch](https://github.com/vahidk/EffectivePyTorch) | 《Effective PyTorch》这本教程致力于帮助工程师们以正确的方式，更加快速掌握 PyTorch 基础知识与开发技巧 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/ICm1P6977)
[eat_tensorflow2_in_30_days](https://github.com/lyhue1991/eat_tensorflow2_in_30_days) | 《30 天吃掉那只 TensorFlow 2.0 》该工具书既有教程又有指南，并按照内容难易程度、读者检索习惯和 TensorFlow 自身的层次结构来设计内容，让开发者可以循序渐进，层次清晰的按照功能查找相应范例 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/ICaVbbYmG)
[7days-golang](https://github.com/geektutu/7days-golang) | Go 语言教程，教你如何用 Go 在 7 天内做出一些比较实用的东西，如 Web 框架、分布式缓存、ORM 框架等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IxUXh9RlG)

### 图标库
库名 | 简述 | 源
---- | ----- | -----
[phosphor-home)](https://github.com/phosphor-icons/phosphor-home) | 里面共提供了 588 个图标，拥有 6 种不同线条展示风格，你可将其应用于图标、演示文稿、网站页面等任意载体上 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jr6N4tEkm)
[IconPark](https://github.com/bytedance/IconPark) | 里面提供了超过 1200 个高质量图标，并提供界面帮你完成图标定制 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JoohbDWh0)
[tabler-icons](https://github.com/tabler/tabler-icons) | 里面包含了共计 550+ 个高质量 SVG 图标，用户自定义图标的大小、颜色以及线条粗细 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JdsGvu7r2)

### 有趣网站

库名 | 简述 | 源
---- | ----- | -----
[jsonperf](https://github.com/ronlut/jsonperf) | 一个比较实用的测试网站：JSON Perf，可针对不同语言的 JSON 库进行序列化和反序列化 benchmark 性能测试 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JAgMYxZxN)
[图之典](http://tuzhidian.com/) | 给玩数据分析的同学推荐个比较实用的网站，在上面，你能轻松找到饼图、柱形图、桑基图、折线图、热力图、直方图等 22 种常用可视化图形，帮你完成日常的数据可视化工作 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JkUCQ7zw0)
[Studytonight](https://www.studytonight.com/) | 推荐个很不错的编程学习网站，该网站上面提供了许多可免费学习的计算机科学课程，其中包含 Java、Python、C++ 等编程语言，Web 开发、计算机网络、操作系统、游戏开发、数据库操作、Git 使用等系列教程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jg8QgdSQo)
[have i been pwned?](https://haveibeenpwned.com/) | 给你们分享个比较有意思的网站：have i been pwned?（我被卖了吗？）里面收录了超过 470 个网站，100 亿条账号的泄露数据，用户仅凭 email，便能快速评估自己账号的数据泄露情况 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JesKraO9K)
[VisuAlgo.net](https://visualgo.net/zh) | 算法可视化网站，里面包含了排序、链表、哈希表、二叉搜索树、递归树、循环查找等常见算法动画。在动画执行的过程中，还会在网站右下角高亮显示当前动画的代码逻辑 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Je0Rj8YWe)
[RobertElder](https://blog.robertelder.org/regular-expression-visualizer/) |  | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JdyburKlG)
[数据可视化工具目录](https://datavizcatalogue.com/ZH/) | 里面收集与汇总了各类数据可视化工具的详细描述、图形示例以及可上手使用的工具集合与学习资源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JcyhxbTFP)
[DELESIGN](https://delesign.com/) | 很不错的设计资源网站，里面提供了大量可免费商用的插图、邮件、网站、品牌等设计素材及源码 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JaXV1pjpq)
[OpenSource Builders](https://opensource.builders/) | 里面收集了超级多知名软件的开源替代品，像 GitHub、Slack、1Password、Facebook、YouTube、Shopify、Heroku 等产品 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jaq8Rn9PW)
[unscreen](https://www.unscreen.com/) | 一款超级实用的在线视频处理工具，能帮你快速移除视频背景，无需绿幕、无需编辑，轻点鼠标即可一键完成所有操作 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ja3m39c5L)
[Dev Hints](https://devhints.io/) | 里面整理了各种技术类型的速查表，其中包括 Git、Vim、Go、MySQL、Linux、VSCode、Vue 等各大常用技术的速查表清单 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J8Rvueh83)
[i Hate Regex](https://ihateregex.io/) | 一个比较实用的正则表达式网站，可快速检索并匹配到合适的正则表达式，帮你完成如用户名、邮箱、日期、手机号码、密码等常见规则的验证 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J8o2W6IjZ)
[No Design](https://nodesign.dev) | 收集了许多十分便利的 UI 设计工具与设计资源，例如网站图标转换、字体测试、免费资源（图像、图标、设计稿）下载、UI 设计新资讯等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J5OXynCNZ)
[Made With ML](https://madewithml.com/) | 该平台上提供了大量与机器学习相关的文章、教程、工具、开源项目等资源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J0VIfqfXl)
[网站任意门](https://gate.ofo.moe/) | 一个很有趣的网站，首页的按钮点击后，会将你随机传送到某个网站上  | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IEFGFfWPI)
[Semantic Scholar](https://www.semanticscholar.org/) | 超级实用的搜索引擎，其目的在于打造一款专业的学术搜索引擎，让研究人员可以更为快速、精准的检索专业学术论文，力争在学术论文检索领域做到比 Google 更加智能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IB6VHxF8n)

### 其他
库名 | 简述 | 源
---- | ----- | -----
[simple-graph](https://github.com/dpapathanasiou/simple-graph) | GitHub 上一个简易版的 SQLite 图数据库，可应用到社交网络、待办清单、CRM、甘特图等领域上 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JAI9L1n0o)
[next-terminal](https://github.com/dushixiang/next-terminal) | 一款开源的 H5 远程桌面网关，具有小巧、易安装、易使用、资源占用小的特点，支持 RDP、SSH、VNC 和 Telnet 协议的连接和管理 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JAyF4r3qi)
[FlaxEngine](https://github.com/FlaxEngine/FlaxEngine) | 一款基于 C++ 与 C# 开发的现代化 3D 游戏引擎：FlaxEngine，致力于优化现有的游戏工作流程，可采用 Visual Studio 快速安装 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JzvEvwglz)
[owncast](https://github.com/owncast/owncast) | 如果你想保证与朋友进行直播的数据私密性，那么可以用 GitHub 上的 Owncast 项目来搭建属于自己的实时流媒体服务器 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jztin4l1A)
[kbd-audio](https://github.com/ggerganov/kbd-audio) | 通过麦克风捕获到键盘的敲击声，进而推断出具体输入内容，详细操作可看视频演示 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jz2bWoOmr)
[common-regex](https://github.com/cdoco/common-regex) | 里面收集了一些在平时项目开发中经常用到的正则表达式 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JyTWvc0Ee)
[fiction_house](https://github.com/201206030/fiction_house) | 一个开源的小说漫画连载系统，支持 Web、Android 等平台，包含精品小说专区、轻小说专区和漫画专区 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JyRAn4Xy6)
[duckstation](https://github.com/stenzek/duckstation) | 一款 PS1 模拟器，支持在 Windows 10、Linux、macOS、Android 等主流设备上运行 PS1 游戏 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JyCsK2IU7)
[gopup](https://github.com/justinzm/gopup) | 里面采集了互联网上，不同行业的各项公开数据源，以便开发者更好的进行学术研究 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jy8O2sWc8)
[iDataV](https://github.com/yyhsong/iDataV) | 收集了各个大厂，各种类型的大屏数据可视化案例 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JxZnwr32P)
[ImHex](https://github.com/WerWolv/ImHex) | 对知名十六进制编辑软件 Hex 进行逆向工程，让你看看里面究竟长啥样 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JxPZOqLJk)
[996Quant](https://github.com/Rgveda/996Quant) | 一份 35 岁程序员退路之量化投资学习笔记 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JxCAZ1ay6)
[porn-vault](https://github.com/porn-vault/porn-vault) | 一个开源的影片资源管理系统 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JxnFxiKHI)
[privacy](https://github.com/kallydev/privacy) | 一个个人数据泄漏检测网站 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JwfKwhBW4)
[abstreet](https://github.com/dabreegster/abstreet) | 一款开源的公共交通模拟游戏，可让你充分的了解道路的微小变化是如何影响到自行车骑手、搭公交的用户、行人和驾驶员的 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JvmKXlZjH)
[wizard](https://github.com/mylxsw/wizard) | 一个开源的文档管理系统，支持 Markdown、Swagger、Table（类 Excel）等三种文档类型 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jtw3Ac5w6)
[most-frequent-technology-english-words](https://github.com/Wei-Xia/most-frequent-technology-english-words) | 里面收集了计算机书籍、文档、文章中高频常见的英文技术词汇，最终目的是希望程序员集合自身的英语基础，在掌握列表中的词汇后，可以无障碍阅读英语技术文章和文档 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JsEf56NCa)
[running_page](https://github.com/yihong0618/running_page) | 通过 GitHub Actions + Gatsby 自动完成跑步进程的同步管理，并生成一个直观简洁的跑步界面，让用户可以更为方便的记录自己在不同时段、不同日期的跑步频率与旅程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JstDwndYK)
[weibo-public-opinion-datasets](https://github.com/nghuyong/weibo-public-opinion-datasets) | 一个开源的数据集：微博舆论数据集。里面包含了 2000 万微博活跃用户（占用户总数 8%），在某个时间段的推文数据 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JrL3kypNC)
[manim](https://github.com/3b1b/manim) | 通过编程的方式，快速帮助用户创建精美酷炫的数学动画，支持 Linux、macOS、Windows 等主流操作系统 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Jrs0aua6n)
[names.io](https://github.com/Debdut/names.io) |  GitHub 上一个开源的姓名数据库，里面收录了来自不同国家与地区的 16w 个名字、10w 个姓氏，便于开发者进行分析测试，或生成假数据 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JrqQo89RC)
[ferry](https://github.com/lanyulei/ferry) | 一个前后端分离的工单系统 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JmwoLuI4n)
[ARL](https://github.com/TophantTechnology/ARL) | 一个 ARL（资产侦察灯塔系统），支持设定域名爆破、端口扫描、服务识别、SSL 证书获取、站点识别、搜索引擎调用、站点爬虫与截图等 18 项任务 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JlN0d3ed6)
[Mycodo](https://github.com/kizniche/Mycodo) | 一个开源的可运行在树莓派上的自动监控和调节系统，应用在种植植物，培养微生物，保持蜂蜜蜂房稳态，孵化动物和鸡蛋，维持水生系统等等场景 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ji9KQ6cQY)
[MeiliSearch](https://github.com/meilisearch/MeiliSearch) | 一款开源免费、功能强大、快速、易于使用和部署的搜索引擎 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ji70molVF)
[metersphere](https://github.com/metersphere/metersphere) | 一站式持续测试平台，涵盖测试跟踪、接口测试、性能测试、团队协作等功能，全面兼容 JMeter、Postman 等主流标准 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/JdC7IEr29)
[shan-shui-inf](https://github.com/LingDong-/shan-shui-inf) | 可通过程序生成中国山水画 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J6JEiByfd)
[Marketing-for-Engineers](https://github.com/goabstract/Marketing-for-Engineers) | 如果你是一名程序员，却不太懂得做市场营销，那可以关注下这个项目 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J3zUejXcs)
[macos-virtualbox](https://github.com/myspaghetti/macos-virtualbox) | 这个开源脚本可让你在 VirtualBox 上快速安装苹果操作系统 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J3qvOly9m)
[spug](https://github.com/openspug/spug) | 一个面向中小型企业设计的无 Agent 自动化运维平台，整合了主机管理、主机批量执行、主机在线终端、应用发布、任务计划、配置中心、监控、报警等一系列功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/J1ZHJ6AjF)
[wenyan](https://github.com/wenyan-lang/wenyan) | 文言文编程项目，含有官方文档、入门教程、IDE、语法高亮、软件包一应俱全了 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Iyg7twVTI)
[chatwoot](https://github.com/chatwoot/chatwoot) | 一个开源的简洁且漂亮的实时聊天软件，支持一键部署 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IoRf1msYS)
[kratos](https://github.com/go-kratos/kratos) | 一套来自 bilibili 开源的 Go 微服务框架，包含大量微服务相关框架及工具  | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IousujCUA)

## 声明
[![](https://licensebuttons.net/l/by-nc-nd/2.0/88x31.png)](https://creativecommons.org/licenses/by-nc-nd/2.0/deed.zh)  
本作品采用[知识共享署名-非商业性使用-禁止演绎 2.0 通用许可协议](https://creativecommons.org/licenses/by-nc-nd/2.0/deed.zh)进行许可。