
<p align="center">
   <img src="https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/weixin.png">
</p>

## 宗旨

GitHubDaily 将于每日不定时推送一批 GitHub 上优秀的开源项目给开发者, 帮助开发者们发现当下最火的开源项目, 令开发者们得以掌控技术脉搏, 扩大自己的技术视野, 并从开源项目的学习中获得技术能力的提升。

- [历史文章精选](https://github.com/GitHubDaily/GitHubDaily/tree/master/articles)
- 公众号：[GitHubDaily](https://tva1.sinaimg.cn/large/007S8ZIlgy1geyb6wrwxgj3076076aa5.jpg)
- 微博: [@GitHubDaily](https://weibo.com/GitHubDaily)
- 知乎: [@GitHubDaily](https://www.zhihu.com/people/githubdaily)

> 欢迎到 [Issues](https://github.com/GitHubDaily/GitHubDaily/issues/new) 推荐或自荐项目，让更多人知道你的项目。

---

## 2019 年复盘

下面是对 GitHubDaily 在 2019 年所发的微博进行分类整理，方便粉丝们查找以往分享过的内容。

> 过往复盘 [2018](https://github.com/GitHubDaily/GitHubDaily/blob/master/2018.md)。

### 目录


- [Java](#java)
- [Python](#python)
- [前端](#前端)
- [教程](#教程)
- [移动端](#移动端)
- [开源书籍](#开源书籍)
- [资料集合](#资料集合)
- [面试资料](#面试资料)
- [有趣网站](#有趣网站)
- [有趣/实用开源工具](#有趣--实用开源工具)
- [机器学习/人工智能](#机器学习--人工智能)
- [非开源的实用工具](#非开源的实用工具)
- [其它](#其它)

### Java

库名 | 简述 | 源
---- | ----- | -----
[advanced-java](https://github.com/doocs/advanced-java) | 互联网 Java 工程师进阶知识完全扫盲：涵盖高并发、分布式、高可用、微服务等领域知识，后端同学必看，前端同学也可学习 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I7ucNeWbS)
[JustAuth](https://github.com/justauth/JustAuth) | 史上最全的整合第三方登录的 Java 开源库，集成了二十多家国内外常用第三方平台，且提供简单易用的 API 让你快速接入 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I3vtXALCc)
[spring-boot-demo](https://github.com/xkcoding/spring-boot-demo) | 一个集成了 57 个 Spring Boot 常用组件 Demo 的项目，且每个 Demo 均有详细的 README 文件讲解说明，很不错的一份学习 Spring Boot 资料 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I3cCYeuxV)
[halo](https://github.com/halo-dev/halo) | 一款个人独立博客系统，该系统部署简单快捷，并提供 Api 接口拓展行强，支持多款云存储，支持多款主题，支持 Web 端、 App 端管理后台，随时随地记录你的想法 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hx3PscZMt)
[spring-boot-examples](https://github.com/ityouknow/spring-boot-examples) | 一份 Spring Boot 教程、技术栈示例代码，快速简单上手教程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hj4vq2WjP)
[toBeTopJavaer](https://github.com/hollischuang/toBeTopJavaer) | 一份整理了 Java 工程师成神之路所需要掌握的内容知识点 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HiTTRkCTT)
[MyPerf4J](https://github.com/LinShunKang/MyPerf4J) | 一个针对高并发、低延迟应用设计的高性能 Java 性能监控和统计工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HbRuxt1rj)
[advanced-java](https://github.com/doocs/advanced-java) | 互联网 Java 工程师进阶知识完全扫盲 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HbfMyC03g)
[ForestBlog](https://github.com/saysky/ForestBlog) | 一个简单又漂亮的博客系统，该系统由 Spring + SpringMVC + Mybatis 框架实现，适合初学 SSM 和个人博客制作的同学学习 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/ImJg4o9yZ)

### Python

库名 | 简述 | 源
---- | ----- | -----
[30-seconds-of-python](https://github.com/30-seconds/30-seconds-of-python) | 收集了一些简单且实用的 Python 脚本，让开发者可以在 30 秒内搞懂用上一个 Python 知识点 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I7jann0ZG)
[learn_python3_spider](https://github.com/wistbean/learn_python3_spider) | 一份从 0 到 1 学习 Python 爬虫教程，内容含有如何抓包，各种爬虫常用的模块使用，实战教程，最后还教你如何反爬虫 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HDZypo4a5)
[sunfish](https://github.com/thomasahle/sunfish) | 111 行 Python 代码能写出什么？一个简单却强大的国际象棋引擎 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hxlv29mcQ)
[KGQA-Based-On-medicine](https://github.com/YeYzheng/KGQA-Based-On-medicine) | 一个基于医药知识图谱的智能问答系统，支持疾病症状、疾病用药、药品查询等功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HxaTtmRx6)
[python-cheatsheet](https://github.com/gto76/python-cheatsheet) | Python 相关知识点速查表 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hj0zSpaLP)
[fuck_illness](https://github.com/wdkwdkwdk/fuck_illness) | 利用爬虫抓取并分析百万条疾病问答数据。附图是不同年龄段人的常患疾病，挺有意思的 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HizROAB2w)
[amemv-crawler](https://github.com/loadchange/amemv-crawler) | 可爬取某音平台指定账号的所有视频 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HhvSkFkbD)

### 前端

库名 | 简述 | 源
---- | ----- | -----
[DataV](https://github.com/DataV-Team/DataV) | 一个简单易用基于 Vue 的数据可视化组件库，该库提供酷炫的 SVG 边框和装饰，常用的图表、飞线图、轮播表等等组件 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Imqp4ECRw)
[clean-code-javascript](https://github.com/ryanmcdermott/clean-code-javascript) | Google 工程师 Ryan McDermott 根据 《Clean Code》总结了一份适用于 JavaScript 的软件工程指导准则《Clean Code JavaScript》。希望能帮你写出易读、易复用、易重构的 JavaScript 代码 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Il1m5vUnU)
[javascript-algorithms](https://github.com/trekhleb/javascript-algorithms) | 包含了多种基于 JavaScript 的算法与数据结构，每种算法和数据结构都有自己的 README，包含相关说明和链接，以便进一步阅读 (还有 YouTube 视频)  | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IkeuAhZGz)
[zdog](https://github.com/metafizzy/zdog) | 一款可用于 3D 设计与动画制作的 JavaScript 库，设计灵活，操作简单，易于集成与上手 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IkaaGEq68)
[flowy](https://github.com/alyssaxuu/flowy) | 一个轻量级的 JavaScript 库，可用于快速创建流程图 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IjXhccumr)
[G6](https://github.com/antvis/G6) | 一款专业的图形可视化引擎，基于 JavaScript 构建 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IipmD0UiP)
[ddBuy](https://github.com/Geek-James/ddBuy) | 一个基于 Vue 开发的移动端电商项目 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IihvxFp60)
[FE](https://github.com/lefex/FE) | 一个开源的前端课程，教新手从零到一学前端 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IiarbcUeu)
[GitDataV](https://github.com/HongqingCao/GitDataV) | 基于 Vue 框架构建的 GitHub 数据可视化平台 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IcQIyopbn)
[30-seconds-of-code](https://github.com/30-seconds/30-seconds-of-code) | 收集了一些简单且实用的 JavaScript 代码，让开发者可以在 30 秒内搞懂并用上一个 JavaScript 知识点 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IcEHaE5xL)
[Nodejs-Roadmap](https://github.com/Q-Angelo/Nodejs-Roadmap) | 一份学习 Node.js 教程《Node.js 技术栈》，该教程是由一名 Node.js 开发者在学习历程中记录的知识点，侧重于 Node.js 服务端所涉及的技术栈 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HBT8SfgpG)
[filepond](https://github.com/pqina/filepond) | 一个灵活且有趣的 JavaScript 文件上传库 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HyiCk161H)
[picojs](https://github.com/tehnokv/picojs) | 200 行 JavaScript 代码实现人脸检测 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HxW1XCIIW)
[FrontEndNav](https://github.com/Hulkye/FrontEndNav) | 这个网站上面收集了大量高质量的前端相关资源，其中包含前端学习资源、文档 API、模板插件、工具等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hvcl1uZLG)
[javascript](https://github.com/airbnb/javascript) | 一份来自 Airbnb 团队开源的 JavaScript 编码规范指南，前端的同学可以学习下 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hv6DT2yQ9)
[React95](https://github.com/arturbien/React95) | Windows 95 风格的 React 组件库也被整出来了 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HqcOzBIV8)
[front-end-collect](https://github.com/foru17/front-end-collect) | 有位开发者在 GitHub 上整理了一批前端开发相关的优质网站、博客、教程、书籍等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hv1l76MM3)
[grade](https://github.com/benhowdle89/grade) | 一个 JavaScript 库 Grade.js，主要功能是从图片中提取两种主色，并生成互补渐变的背景 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HuK3xidhE)
[react-tetris](https://github.com/chvin/react-tetris) | 有个前端工程师在 GitHub 上用 React 搞了个俄罗斯方块小游戏，不仅好玩，技术实现原理也讲解非常到位 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HtG67xwWF)
[cssfx](https://github.com/jolaleye/cssfx) | 它提供了一些优雅、酷炫的 CSS 动画效果，让你轻点鼠标便能直接复制样式，非常方便。做 Web 开发的同学可以收藏备用一下 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Htv49csRw)
[leetcode](https://github.com/azl397985856/leetcode) | 一个最近比较火的 JavaScript LeetCode 题解项目 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HsvcnzVFx)
[Learn-Web-Hacking](https://github.com/LyleMi/Learn-Web-Hacking) | 一份 Web 安全学习笔记，帮你学点内网渗透、漏洞攻击、安全防御等基础知识 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HrFWbBlrn)
[TNFE-Weekly](https://github.com/Tnfe/TNFE-Weekly) | 腾讯前端团队创办的技术周刊，每周定期分享小程序、H5 等前端领域技术内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HmEPNC6M0)
[instagram.css](https://github.com/picturepan2/instagram.css) | 一个使用纯 CSS 实现 Instagram 滤镜效果类库 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/)
[quicklink](https://github.com/GoogleChromeLabs/quicklink) |  Google 开源的一个前端库，利用空闲时间提前缓存页面上链接，加快链接网站的访问速度 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HjHAEn2mn)
[frontend-bootcamp](https://github.com/microsoft/frontend-bootcamp) | 微软这两天刚开源的前端练习资料 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HiCpnhwN0)
[en.javascript.info](https://github.com/javascript-tutorial/en.javascript.info) | 一份开源的 JavaScript 教程，主要讲解 JavaScript 语言的基本用法，浏览器事件的管理，动画效果及正则表达式的基础使用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HhN9UwwyK)
[apexcharts.js](https://github.com/apexcharts/apexcharts.js) | 一个开源的 JavaScript 图表库，让开发者可以更轻松的构建可交互图表，可视化数据 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hh7x37T3e)
[30-seconds-of-code](https://github.com/30-seconds/30-seconds-of-code) | 收集了一些实用的 JavaScript 代码片段，让你在 30 秒内就能看懂并用上 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HgNSGtCOX)
[css_tricks](https://github.com/QiShaoXuan/css_tricks) | 总结一些常用的 CSS 样式， 以及记录一些 CSS 的新属性和一点奇技淫巧 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HdGCv2vop)
[anime](https://github.com/juliangarnier/anime) | 一款轻量级的 JavaScript 动画库，轻松实现各种酷炫的效果，支持 CSS 属性、SVG 和 DOM 属性等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HdnLwhdhR)
[CSS-Inspiration](https://github.com/chokcoco/CSS-Inspiration) | 一份 CSS 学习资料，以分类的形式，展示不同 CSS 属性或者不同的课题使用 CSS 来解决的各种方法 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HbI43u29l)

### 教程

名称 | 简述 | 源
---- | ----- | -----
[Java 开发手册](https://developer.aliyun.com/special/tech-java) | 始于阿里内部规约，在全球 Java 开发者共同努力下，已成为业界普遍遵循的开发规范。内容涵盖编程规约、异常日志、单元测试、安全规约、MySQL 数据库、工程规约、设计规约共七大维度 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HB6D9qfPV)
[机器学习课程](https://mlcourse.ai/) | 一套免费开放的机器学习课程，由 Open Data Science 组织研发，主要注重理论与实践相结合，采用了特定的激励机制去引导学生深入学习，让学生在探索学习的过程中保有冲劲，不轻易感到枯燥或疲倦 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HASSLfFR2)
[计算机科学速成课](https://www.yuque.com/computer/crush-course) | 免费的计算机视频课程，收集并翻译了 YouTube 上比较热门的计算机课程，内容包含计算机早期历史、中央处理器、编程原理、计算机网络、计算机安全等分类 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HxiKyFd0J)
[机器学习基础](https://mitpress.ublish.com/ereader/7093/?preview=#page/1) | 一套可免费在线阅读的计算机课程，该书由纽约大学计算机科学几位教授共同编写，内容侧重于算法的分析和理论，每章均附有相关练习题 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HwQt4aEdr)
[现代化计算机科学自学指南](https://www.yuque.com/docs/share/97bb24b7-fe20-49aa-96bf-36033cfebe6c) | 中文版，里面收录了许多来自世界知名高校、顶尖教授与技术专家所编著的计算机课程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/)
[零基础学 WordPress](https://www.yuque.com/moeunion/wordpress) | 本教程通过对安装使用 WordPress 搭建自媒体站点的前期、中期、后期进行详细讲解，使读者全面了解和掌握作为一个自媒体网站站长应掌握的域名、服务器、WordPress 等方面的基础知识，同时通过实例站点与图书社区为读者提供了相关资源与服务，是一本绝无仅有、不可多得的技术书籍 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/)
[AI 算法工程师手册](http://www.huaxiaozhuan.com/) | 该手册是作者多年以来学习总结的笔记整理，目前还在不断更新 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Huz3CzASi)
[前端开发者手册2019](https://www.yuque.com/ysfe/ykx/fedhb) | 该手册里面包含了前端开发相关的基础知识、常用工具、学习资源等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HtOjvap8d)
[JavaScript for impatient programmers](https://exploringjs.com/impatient-js/) | 该本书编著于 ES2019 基础之上，将教授新手一些基础的、现代化的 JavaScript 编程知识 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ht2MEEYsD)
[Python-100-Days](https://github.com/jackfrued/Python-100-Days) | 一份学习 Python 教程，涵盖 Python 初中高级知识点，规划在 100 天之内让你从新手到大师级别水平 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HqUNHFAVc)
[py4e](https://github.com/csev/py4e) | 一本免费的 Python 编程教程《Python for Everybody》 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HqDAjfYAg)
[深度学习理论与实战](http://fancyerii.github.io/2019/03/14/dl-book/) | 一本免费的深度学习书籍，该书涵盖听觉、视觉、语言和强化学习四大领域，深入浅出的理论分析和详尽的代码分析 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HpSzi5aI3)
[Front end handbook](https://frontendmasters.com/books/front-end-handbook/2019/) | 一本前端开发手册《Front end handbook》作者 Cody Lindley 是一名拥有 20 多年编程经验的前端工程师，手册包含前端开发的基础知识、常用工具、学习资源等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HpzwErOQQ)
[前端九部](https://www.yuque.com/fe9/basic) | 一本前端中文入门课程《前端九部 - 入门者手册 2019》 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HpbX1gJNQ)
[chrome-plugin-demo](https://github.com/sxei/chrome-plugin-demo) | 一份 Chrome 插件开发完整教程，并配套完整 Demo，可用来学习插件开发 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HiDNlnUCZ)
[os-tutorial](https://github.com/cfenollosa/os-tutorial) | 一份开源教程，教你如何从零开始构建一个操作系统 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HhkSpDdTt)
[TensorFlow-Course](https://github.com/machinelearningmindset/TensorFlow-Course) | 一份清晰简洁、对开发者友好的 TensorFlow 教程。主要讲解 TensorFlow 的基础安装与入门使用，每个步骤都提供了详细的代码与文档讲解 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HgXjb0uRX)
[GitHub Learning Lab](https://lab.github.com/) |  GitHub 官方出的一个交互式学习课程，主要教授 GitHub 新手如何正确的使用 GitHub，如提交 commit、创建分支、发起 Pull Request 等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HceOMc6yT)

### 移动端

库名 | 简述 | 源
---- | ----- | -----
[Best-Flutter-UI-Templates](https://github.com/mitesh77/Best-Flutter-UI-Templates) | GitHub 上开源的这个 Flutter UI 模板好赞啊！拿来做一些 App 应该会很好看 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IcxCNzPam)
[iWeChat](https://github.com/lefex/iWeChat) | 通过这个项目让你学习手机 App 的源码分析与破解过程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I1p4quItW)
[Flutter-Notebook](https://github.com/OpenFlutter/Flutter-Notebook) | 一份超级多 Flutter 相关功能 Demo 的集合，能帮助你快速学习 Flutter，十分适合新手 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HEU7oeXrq)
[About-SwiftUI](https://github.com/Juanpe/About-SwiftUI) | 一份有关 SwiftUI 资料集合，含有文档、例子、视频和教程等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HBAdOv2DB)
[gsy_flutter_book](https://github.com/CarGuo/gsy_flutter_book) | 一份 Flutter 完整开发实战详解系列，手把手教你如何从 0 开发一个完整的 Flutter App | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HxMBt6diY)
[android-developer-roadmap](https://github.com/mobile-roadmap/android-developer-roadmap) | Android 开发者知识技能图谱 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HwiGD1vk8)
[flutter-tutorials](https://github.com/FilledStacks/flutter-tutorials) | 南非一位移动开发者做的 Flutter 教程，内含视频讲解与源码 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hw9g7w4uu)
[Flutter4GitLab](https://github.com/stefanJi/Flutter4GitLab) | 基于 Flutter 开源的 GitLab 客户端，让 GitLab 的一些操作通过 App 完成，方便开发者们使用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hv5gEuZjg)
[InAppViewDebugger](https://github.com/indragiek/InAppViewDebugger) | Facebook 有位开发者最近搞了个视图调试器，实现了类似 Reveal 的基础调试功能，以树状结构展示 App 视图，并能控制视图的显示隐藏 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HsJVEDED9)
[Bagel](https://github.com/yagiz/Bagel) | 一个实用的 iOS 网络调试工具，当你的 iOS 设备与 Mac 连接到同一网络时，便可在该工具上查看、监听手机 App 的网络请求数据，拿来抓包很方便 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HrYNb21LD)
[QMUI_iOS](https://github.com/Tencent/QMUI_iOS) | 一个致力于提高项目 UI 开发效率的解决方案，让开发者能专注于业务需求而无需耗费精力在基础代码的设计上 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hj64PFmqP)
[DoraemonKit](https://github.com/didi/DoraemonKit) | 一款功能齐全的客户端（ iOS 、Android ）研发助手 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HgDFuev5w)
[flutter-go](https://github.com/alibaba/flutter-go) | 一个 Flutter 开发者帮助 App，包含 Flutter 常用 130+ 组件的中文文档与 Demo 演示 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hbpd45cvu)
[Flutter-for-Android-developers](https://github.com/m3sv/Flutter-for-Android-developers) | 一份为 Android 开发者学习 Flutter 准备的教程，适用于初学者 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HaldA979X)

### 开源书籍

库名 | 简述 | 源
---- | ----- | -----
[spellbook-of-modern-webdev](https://github.com/dexteryy/spellbook-of-modern-webdev) | 《Spellbook of Modern Web Dev（现代 Web 开发魔法全书）》作者基于社区经验和数据统计，汇总了现代 web 开发中各个领域的主流项目、资源和经典文章，做了细粒度的分类梳理 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Imxts33ml)
[Learn-Vue-Source-Code](https://github.com/NLRX-WJC/Learn-Vue-Source-Code) | 一份 Vue 源码学习系列《逐行剖析 Vue.js 源码》作者记录其对 Vue 源码分为九大模块逐步学习的整个过程，以及对源码的一些理解 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/ImeCtc8n5)
[modern-cpp-tutorial](https://github.com/changkun/modern-cpp-tutorial) | 《Modern C++ Tutorial》一本开源的 C++ 教程，帮助开发者快速上手现代 C++ 特性 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Il93z8frv)
[advanced-go-programming-book](https://github.com/chai2010/advanced-go-programming-book) | 《Go 语言高级编程》开源图书，涵盖 CGO、Go 汇编语言、RPC 实现、Protobuf 插件实现、Web 框架实现、分布式系统等高阶主题 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IfYwFFElc)
[Dive-into-DL-PyTorch](https://github.com/ShusenTang/Dive-into-DL-PyTorch) | 将《动手学深度学习》（Dive into Deep Learning）原书中的 MXNet 代码实现改为 PyTorch 实现 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I7C1n860O)
[pumpkin-book](https://github.com/datawhalechina/pumpkin-book) | 开源免费机器学习书籍《南瓜书 PumpkinBook》，该书是对机器学习领域的经典入门教材周志华老师的《机器学习》书籍的一些细微补充，比如难理解的公式加以解析，以及补充具体的推导细节 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I3EUstQYR)
[Machine-learning-learning-notes](https://github.com/Vay-keen/Machine-learning-learning-notes) | 周志华《机器学习》西瓜书精炼版笔记 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I1ZGg3zTE)
[OnJava8](https://github.com/LingCoder/OnJava8) | 一本书籍《On Java 8》的中文翻译版 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HDGHq2YZO)
[d2l-zh](https://github.com/d2l-ai/d2l-zh) | 一本开源免费在线阅读教科书《动手学深度学习》，该书是加州大学伯克利分校 2019 年春学期 Introduction to Deep Learning 课程教材的中文翻译版。书籍内容全面介绍深度学习，不仅阐述算法原理，还可以运行它们，以获得交互式的学习体验 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hydjxwex6)
[prometheus-book](https://github.com/yunlzheng/prometheus-book) |《Prometheus 操作指南》该书内容由基础到进阶再到实战一步步深入，每章节后面还有个小结 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HxUQU41K4)
[lihang-code](https://github.com/fengdu78/lihang-code) |《统计学习方法》机器学习的入门宝典，全面系统地介绍了统计学习的主要方法，叙述从具体问题或实例入手，由浅入深，阐明思路，给出必要的数学推导，便于读者掌握统计学习方法的实质，学会运用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hxw6BcxSF)
[data-science-at-the-command-line](https://github.com/jeroenjanssens/data-science-at-the-command-line) | 《命令行中的数据科学》由一名荷兰数据科学家 Jeroen Janssens 所编写，内容主要讲解了 80 多种实用的命令行工具，以及如何使用它们高效地获取、清洗、探索和建模数据 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hxsb3gFW2)
[tensorflow2_tutorials_chinese](https://github.com/czy36mengfei/tensorflow2_tutorials_chinese) | Tensorflow 2 教程 基于官方教程的个人学习笔记，主要借鉴了一些 keras 构造神经网络的方法，中文讲解| [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HwxC525uB)
[research_tao](https://github.com/zibuyu/research_tao) | 《NLP 研究入门之道》该书将系统地向你介绍 NLP（自然语言处理）科研入门、学术圈概貌、文献阅读、实验设计、论文撰写等知识 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/)
[Algorithms](https://github.com/jeffgerickson/algorithms) | 伊利诺伊大学教授 Jeff 写的《算法》一书，这位老教授在 UIUC 教了 20 年的书，授课内容与经验都浓缩在这本书上了 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HoWffv26x)
[nndl.github.io](https://github.com/nndl/nndl.github.io) | 一本开源的深度学习入门书籍《神经网络与深度学习》 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HoQWsE32D)
[the-way-to-go_ZH_CN](https://github.com/unknwon/the-way-to-go_ZH_CN) | 一本 Go 入门教程《Go入门指南》，对于学习 Go 编程语言的爱好者来说，这本书无疑是最适合你的一本书籍，这里包含了当前最全面的学习资源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HogmdbHjb)
[the-road-to-learn-react-chinese](https://github.com/the-road-to-learn-react/the-road-to-learn-react-chinese) | 本免费的电子书《React 学习之道》，最简单、最实用的 React 实战教程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hoftqe0Gh)
[EasyWordPressBook](https://github.com/bestony/EasyWordPressBook) | 一本开源的电子书「人人都能学会的 WordPress 实战课」，这本电子书将会教你最基础的 WordPress 使用、 优化、主题开发、 插件开发，以及如何在其他应用中接入 WordPress | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hm73lArsV)
[interpretable-ml-book](https://github.com/christophM/interpretable-ml-book) | 《可解释的机器学习》由作者 Christoph Molnar 历时两年编写而成。书籍累计 250 多页、7.8 万词、1200 多次提交，感谢作者的无私贡献 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HiR9nAUQR)
[pytorch-handbook](https://github.com/zergtant/pytorch-handbook) | 《PyTorch 中文手册》目标是帮助那些希望和使用 PyTorch 进行深度学习开发和研究的朋友快速入门 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HhgKHlu6f)
[flutter-in-action](https://github.com/flutterchina/flutter-in-action) |  Flutter 中文网开源的电子书《Flutter实战》 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HcVu1oXcO)

### 资料集合

库名 | 简述 | 源
---- | ----- | -----
[any-rule](https://github.com/any86/any-rule) | 一份收集整理 60+ 条常用正则表达式， 并支持 Web / VsCode 插件 2 种查询方式 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/ImmFHEUlL)
[awesome-reverse-engineering](https://github.com/alphaSeclab/awesome-reverse-engineering) | 收集了诸多与逆向工程相关的资源，覆盖了 Windows / Linux / macOS / Android / iOS / IoT 等操作系统 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IkJwyiPMn)
[web-development-2020-course-list](https://github.com/andrews1022/web-development-2020-course-list) | 一份 Web 开发者 2020 年学习指南。其中包含常用的 Web 开发工具、设计软件、主流框架、基础知识、后端 & DevOps 技术堆栈等分类 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IkCm5z0fU)
[project-based-learning](https://github.com/tuvtran/project-based-learning) | 收集了一系列编程教程，教你如何从零开始构建应用，其中包含 C、C++、Java、PHP、JavaScript、Python 等主流编程语言，用于新手练习编程再适合不过了 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IjVDAkDLI)
[iptv](https://github.com/iptv-org/iptv) | 牛逼了，这个 GitHub 项目收集了全球 8000 多个公共的 IPTV 频道，领域覆盖历史、教育、商业、电影、音乐... | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IjjVBszJL)
[awesome-web-security](https://github.com/qazbnm456/awesome-web-security) | 收集汇总了 Web 安全相关的一些资源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IcVYKrm4O)
[KnowledgeGraphData](https://github.com/ownthink/KnowledgeGraphData) | 史上最大规模 1.4 亿中文知识图谱开源下载 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IckF7lj6h)
[Awesome-Interview](https://github.com/Awesome-Interview/Awesome-Interview) | 一份收集整理了各大技术领域面试资料列表，含有前端、后端、客户端等等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I1PMvac0b)
[awesome-creative-coding](https://github.com/terkelg/awesome-creative-coding) | 一份精心整理的创意编码资源列表，主要面向初中级学者，内容含有书籍、课程、工具和学习资源等等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I1nv0BnkQ)
[learn-regex](https://github.com/ziishaned/learn-regex) | GitHub 上开源的一份非常棒的正则教程，每个知识点提供一个通俗易懂的例子说明 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I0LN1ewBb)
[the-art-of-command-line](https://github.com/jlevy/the-art-of-command-line) | 一篇在 GitHub 上拥有 6w+ Star 的文章《命令行的艺术》 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I0jvxiAhD)
[Security-PPT](https://github.com/FeeiCN/Security-PPT) | 一份整理了来自各领域各公司会议分享的关于安全 PPT 的集合 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HFOGmp51T)
[LiteratureDL4Graph](https://github.com/DeepGraphLearning/LiteratureDL4Graph) | 一份收集整理了近百篇关于图深度学习的论文列表集合 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HDeOhpjTO)
[awesome-indie](https://github.com/mezod/awesome-indie) | 国外有一名开发者整理了一份帮助独立开发者赚钱的资源集合 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HCM8rdmFs)
[design-patterns-for-humans-cn](https://github.com/guanguans/design-patterns-for-humans-cn) | 《Design patterns for humans》中文版，这是一份超全的设计模式讲解（共 23 种），每一种设计模式作者都尽可能使用通俗易懂的方式给大家解释，希望能帮助到大家更好的理解 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HCCHWm0CD)
[deeplearning-models](https://github.com/rasbt/deeplearning-models) | 一份汇集了各种深度学习架构、模型和技巧的资料 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HAuIZngCL)
[most-frequent-technology-english-words](https://github.com/Wei-Xia/most-frequent-technology-english-words) | 有位开发者收集整理了一份程序员工作中常见的英语词汇集合，这些都是来自英语类计算机书籍、文档、文章中高频常见的技术词汇 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HAliutbLr)
[from_coder_to_expert](https://github.com/0voice/from_coder_to_expert) | 有位开发者整理了各大公司内部里大牛分享的技术文档 PDF 或者 PPT | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HymK2jbsS)
[deeplearning-models](https://github.com/rasbt/deeplearning-models) | 一份收集整理 TensorFlow 和 PyTorch 的各种深度学习架构、模型和技巧的集合 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HyeSXll5g)
[pure-bash-bible](https://github.com/dylanaraps/pure-bash-bible) | 国外一位开发者将自己常用的任务脚本进行了整理，其中包括空白字符截取、数组翻转、数组循环、文件处理等 bash 代码片段，借助这些片段，可让你更快的搭建好脚本工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HxLqpeRmw)
[Decryption-Tools](https://github.com/jiansiting/Decryption-Tools) | 一份勒索病毒解密工具的整理汇总 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HxtKt6UG0)
[Emergency-Response-Notes](https://github.com/Bypass007/Emergency-Response-Notes) | 收集整理了从系统入侵到事件处理等相关案例的分析报告，其中包含蠕虫病毒、挖矿病毒、移动端劫持等常见案例 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hvvc1d2o6)
[The-Hackers-Hardware-Toolkit](https://github.com/yadox666/The-Hackers-Hardware-Toolkit) | 一份收集整理了有关黑客所使用的工具集合 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hvg4nAXA4)
[Awesome-PyTorch-Chinese](https://github.com/INTERMT/Awesome-PyTorch-Chinese) | 一份 PyTorch 学习资源整理汇总，含有学习教程、手册、视频教程和实战项目等资料 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hu6M8ipk2)
[industry-machine-learning](https://github.com/firmai/industry-machine-learning) | 这个项目收集整理了一些机器学习与数据科学相关的应用，其中包括会计、银行、保险、律师等多个行业的分类 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HsTma7CXX)
[redis-mindmap](https://github.com/Weiwf/redis-mindmap) | 这个项目总结了一些 Redis 常用的知识点 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hswns4D1C)
[golang-developer-roadmap-cn](https://github.com/Quorafind/golang-developer-roadmap-cn) | Go 开发者路线图中文版来 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HrgBls9gL)
[awesome-roadmaps](https://github.com/orsanawwad/awesome-roadmaps) | 你们要的所有编程技能图谱都在这里了 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HqdALlPLn)
[AiLearning](https://github.com/apachecn/AiLearning) | 机器学习、深度学习、自然语言处理相关的学习资料整理 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hq9Fe1s8M)
[datascience](https://github.com/r0f1/datascience) | 一份由维也纳数据科学家 Florian Rohrer 整理的 Python 数据科学清单，包含各种工具、代码片段、教程、博客等资源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hq0eJb0L1)
[git-tips](https://github.com/521xueweihan/git-tips) | 分享一些 Git 相关的使用技巧 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HpgFF42m1)
[linux-command](https://github.com/jaywcjlove/linux-command) | 一份 Linux 命令速查手册，手册共收集了 554+ 个 Linux 命令，用户可通过网站、Chrome 插件、Alfred Workflow 速查命令 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hp7johQa4)
[zju-icicles](https://github.com/QSCTech/zju-icicles) | 浙江大学的课程攻略共享计划 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HoXRl8TDW)
[REKCARC-TSC-UHT](https://github.com/PKUanonym/REKCARC-TSC-UHT) | 清华大学计算机系课程攻略 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HoQogwpbk)
[public-apis](https://github.com/public-apis/public-apis) | 收集了大量公开的 API，让开发者可以快速集成到自己的产品中 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HnSfLv8UL)
[libpku](https://github.com/lib-pku/libpku) | 收集整理了北京大学相关的课程资料，内容包含人工智能、几何学、概率论、电动力学、算法设计与分析、世界通史、自然保护学等，十分全面 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HmhT7cbgF)
[bestofml](https://github.com/RemoteML/bestofml) | 收集汇总了机器学习相关的资源，包括书籍、课程、博客、论文等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HmgtR2q2U)
[interesting-python](https://github.com/Alfred1984/interesting-python) | 有趣的 Python 爬虫和数据分析小项目，可以用 Python 实现有趣的小项目，内容包括 Python 爬虫、Python 数据分析、机器学习、深度学习等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hme7JicmG)
[remote-working](https://github.com/greatghoul/remote-working) | 收集整理主要针对国内远程工作相关的资料集合，含有文章、书籍、工具、招聘网站和远程团队等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HlOcmcmBc)
[TensorFlow-From-Zero-To-One](https://github.com/amusi/TensorFlow-From-Zero-To-One) | 一位 TensorFlow 学习者整理的参考资料、笔记和代码 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HlGlhu6jw)
[Awesome-Linux-Software](https://github.com/luong-komorebi/Awesome-Linux-Software) | 收集整理了一批优质的 Linux 软件，包含电子书工具、命令行工具、文件管理器等多个分类 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HlAQkh97U)
[acm-challenge-workbook](https://github.com/yogykwan/acm-challenge-workbook) | 《挑战程序设计竞赛》习题册攻略，含约 200 道题，可配合书籍或笔记，系统学习算法 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HlhZkiE8d)
[awesome-podcasts](https://github.com/rShetty/awesome-podcasts) | 收集各大编程语言相关的播客列表 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hl4r76YmU)
[best-chinese-front-end-blogs](https://github.com/FrankFang/best-chinese-front-end-blogs) | 收集了许多优质的前端中文博客 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HkTDnF5QV)
[USTC-Course](https://github.com/USTC-Resource/USTC-Course) | 中国科学技术大学课程资源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HknIwaSEK)
[awesome-python-login-model](https://github.com/Kr1s77/awesome-python-login-model) | 收集了各大网站模拟登录的爬虫脚本 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HkdZQiVXK)
[Python](https://github.com/TheAlgorithms/Python) | 收集了许多基于 Python 实现的算法 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hk9S788I2)
[awesome-vscode](https://github.com/viatsko/awesome-vscode) | 收集了许多实用的 VSCode 相关资源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hk8uTrBqG)
[awesome-python-applications](https://github.com/mahmoud/awesome-python-applications) | 收集了许多基于 Python 开发的开源软件 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hjya9dtlT)
[awesome-design-cn](https://github.com/jobbole/awesome-design-cn) | 一份收集整理设计师资源大全，含有 icon、Logo 设计、PhotoShop 插件、交互设计工具、流程图等等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HjsRnjPWq)
[awesome-f2e-libs](https://github.com/sorrycc/awesome-f2e-libs) | 一份收集整理了前端常用的框架、工具和插件等资料集合 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HiLEqp5cR)
[Nodejs-Developer-Roadmap](https://github.com/aliyr/Nodejs-Developer-Roadmap) | 2019 年新发布的 Node.js 开发者技术路线图 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HiyiorPqW)
[architect-awesome](https://github.com/xingshaocheng/architect-awesome) | 后端架构师技术图谱，包含数据结构、常用算法、操作系统、设计模式、运维与技术支持等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hih0Ojmuk)
[thisrepositorydoesnotexist](https://github.com/paubric/thisrepositorydoesnotexist) | 收集了那些使用机器学习合成的内容，包括一些假脸、假猫、假房间、假二次元小姐姐 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hifrp5y1y)
[homemade-machine-learning](https://github.com/trekhleb/homemade-machine-learning) | 一份十分全面的算法资源，主要分为监督学习、无监督学习和神经网络等几大类别，并提供了相关算法的原理介绍与 Demo 实现 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HhzNS51lW)
[awesome-design-patterns](https://github.com/DovAmir/awesome-design-patterns) | 汇总了与软件架构设计模式相关的资源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HhyessUnP)
[awesome-indie](https://github.com/mezod/awesome-indie) | 帮独立开发者赚钱的资源整理，收集了相关社区、播客、书籍等资源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HhfzDr6wh)
[ToolsOfTheTrade](https://github.com/cjbarber/ToolsOfTheTrade) | 收集整理了一批高质量的工具与服务，帮助创业者或开发者快速搭建自己的产品，以金钱换时间。创业必备，重磅推荐！ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HhbrV8xP9)
[php-awesome](https://github.com/shockerli/php-awesome) | PHP 相关资源整理，每周更新 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hh4LU0bFZ)
[awesome-algorithm](https://github.com/apachecn/awesome-algorithm) | 搜集了 LeetCode、HackRank、剑指 offer 等经典算法实现 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hh2BXfxpV)
[Awesome-Design-Tools](https://github.com/LisaDziuba/Awesome-Design-Tools) | 搜集整理了许多设计相关的工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HgWwt2SGc)
[frontendDaily](https://github.com/kujian/frontendDaily) | 前端开发技术日报，每日分享互联网最精彩的前端技术、前端资讯、后端编程、设计和资源等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HgTbsEnXV)
[Computer-Science-Resources](https://github.com/the-akira/Computer-Science-Resources) | 搜集整理了互联网上计算机科学相关的学习资源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HgFeTu6hH)
[deep-learning-drizzle](https://github.com/kmario23/deep-learning-drizzle) | 一份整理深度学习、强化学习、机器学习、自然语言等等国外大学讲座的视频集合 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HgEsbyuA9)
[be-a-professional-programmer](https://github.com/stanzhai/be-a-professional-programmer) | 一份收集了成为专业程序员路上用到的各种优秀资料、神器及框架 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hgr69qtWC)
[awesome-java-cn](https://github.com/jobbole/awesome-java-cn) | 一份 Java 资源大全中文版，内容包括构建工具、数据库、框架、模板、安全等等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hgqjrv3qk)
[Intranet_Penetration_Tips](https://github.com/Ridter/Intranet_Penetration_Tips) | 一位开发者整理的一些内网渗透相关的 Tips，包含信息搜集、隐匿攻击、内网跨边界应用、横向渗透等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HeMboyh3J)
[the-practical-linux-hardening-guide](https://github.com/trimstray/the-practical-linux-hardening-guide) | 一份详细介绍了创建安全 Linux 生产系统所涉及的规划和工具指南 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HerKYFvqG)
[awesome-cheatsheets](https://github.com/skywind3000/awesome-cheatsheets) | 一份收集整理常用的编程语言、框架和开发工具的中文 Cheatsheet （速查表） | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HeikuasF9)
[professional-programming](https://github.com/charlax/professional-programming) | 一份收集了全栈程序员用到的各种优秀资料、工具及框架等资源集合 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/He8U0cnit)
[A-Programmers-Guide-to-English](https://github.com/yujiangshui/A-Programmers-Guide-to-English) | 一份专为程序员编写的英语学习指南 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HbyDyDBW8)
[ChinaMobilePhoneNumberRegex](https://github.com/VincentSit/ChinaMobilePhoneNumberRegex) | 一组匹配中国大陆手机号码的正则表达式 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hb6m462Ju)
[OI-wiki](https://github.com/OI-wiki/OI-wiki) | 一个整合了编程竞赛有趣又实用的知识站点，内容含有竞赛中的基础知识、常见题型、解题思路以及常用工具等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ha2mA8bPA)
[BigData-Notes](https://github.com/heibaiying/BigData-Notes) | 一份大数据入门指南 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/ImOL1yHQo)


### 面试资料

库名 | 简述 | 源
---- | ----- | -----
[awesome-resume](https://github.com/resumejob/awesome-resume) | 一份收集整理了程序员简历常用例句集合 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/ImzPzvFvA)
[google-interview-university](https://github.com/xitu/google-interview-university) | 一套完整的学习手册帮助自己准备 Google 的面试 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Imw6cwlKB)
[reverse-interview](https://github.com/viraptor/reverse-interview) | 一份问题咨询清单，可用于面试时反问你想要面试的那家公司 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I6C28q5Qe)
[fe-interview](https://github.com/haizlin/fe-interview) | 前端面试每日 3+1，作者每天早上 5 点纯手工发布面试题，坚持至今已更新到 127 天 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I3m3t7X9c)
[2019_algorithm_intern_information](https://github.com/HarleysZhang/2019_algorithm_intern_information) | 一份整理了各大公司的算法实习岗位信息集合，大部分岗位都是面向 2020 年毕业的学生，含有常见深度学习算法岗面试题及答案，暑期计算机视觉实习面经和总结 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/)
[interview_internal_reference](https://github.com/0voice/interview_internal_reference) | 一份 2019 年最新总结 BAT 等各大厂的技术面试题目，以及答案，分享给有需要的同学 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HDxgV9EJo)
[leetcode](https://github.com/grandyang/leetcode) | 880 道 LeetCode 题目解题代码 + 中文讲解，另外作者还开发了个 iOS 应用展示题目并提供其对题目的解法 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HD4ZqzX33)
[awesome-resume-for-chinese](https://github.com/dyweb/awesome-resume-for-chinese) | 收集了一些适合中文的简历模板 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HwMllvEjG)
[PHP-Interview-QA](https://github.com/colinlet/PHP-Interview-QA) | 一个 PHP 面试问答项目，作者结合自身开发经验，所给出的 PHP 相关的知识解答。里面包含网络、数据结构与算法、Web 开发、数据库开发、设计模式等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HwIBZrk1a)
[algo](https://github.com/wangzheng0822/algo) | 数据结构和算法必知必会的 50 个代码实现 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HvMRX38sM)
[BAT_interviews](https://github.com/lengyue1024/BAT_interviews) | BAT 大厂面试题及答案的收集与整理，其中包含机器学习、Linux、PHP、大数据、Python、Java、前端等内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HvECw6Bsx)
[leetcode](https://github.com/qiyuangong/leetcode) |  LeetCode 题解项目是英特尔员工写的 Python & Java 实现 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HrdEH2PSi)
[leetcode](https://github.com/haoel/leetcode) | LeetCode 题解项目 @左耳朵耗子 写的 C++ 实现 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HrdEH2PSi)
[Daily-Interview-Question](https://github.com/Advanced-Frontend/Daily-Interview-Question) | 每天一道前端大厂面试题，让你时刻保持危机感，不断精进自己的技能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HmSbQ9gSH)
[front-end-interview-handbook](https://github.com/yangshun/front-end-interview-handbook) | 前端技术面试手册，含答案 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HjGmZ8m4g)
[Front-end-Developer-Interview-Questions](https://github.com/h5bp/Front-end-Developer-Interview-Questions) | 前端开发者面试问题汇总整理 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hjnmpsefu)
[machine-learning-interview-questions](https://github.com/Sroy20/machine-learning-interview-questions) | 汇总了一些与机器学习相关的面试问题 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HhR5rxtxD)
[interview](https://github.com/huihut/interview) | C/C++ 面试基础知识总结，送给准备换工作的开发者 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hh3N16f4P)
[programmer-job-blacklist](https://github.com/shengxinjing/programmer-job-blacklist) | 由多位开发者共同维护的一份程序员找工作黑名单，仅供各位年后找工作参阅，具体实际情况请自行判断 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HeYKJqVfw)
[interview](https://github.com/aylei/interview) | 一份写在 2019 年初的后端社招面试经历，作者写了自己在蚂蚁、头条、PingCAP 三家公司的面试经历，年后打算换工作的后端程序员可以看下 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HeBburdhr)
[leetcode_category](https://github.com/xiaoylu/leetcode_category) | 一份作者在刷 Leetcode 题目时记录下来的解题思路，且提供详细的注释，并且按问题类型整理出来 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/ImSGzcOCc)

### 有趣网站

地址 | 简述 | 源
---- | ----- | -----
[getavatars](https://getavatars.app/) | 一个很有趣的网站可以生成无限多的卡通头像，你总能找到一款适合你的 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IeI4DmAMN)
[bruno-simon](https://bruno-simon.com/) | 我见过的最酷主页，整个页面需要 3D 导航 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Idllq35Wi)
[chinese-colors](https://github.com/zerosoul/chinese-colors) | 可在网页上快速展示各类色系搭配的预览效果，并提供详细的颜色配值参考 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I6ifNowOG)
[鱼塘](https://tophub.fun/main/home/hot) | 整合各大社区平台今日热榜 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/)
[atoolbox](http://www.atoolbox.net/) | 一个收集超多实用在线工具的网站，并且持续收集更新 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HuIStoDVa)
[learnxinyminutes-docs](https://learnxinyminutes.com/) | 一个特别牛逼的编程实训网站，上面拥有算法、数据结构、编程语言、开发工具相关的简短训练教程，部分内容支持中文，开发者们可以用这个网站来快速体验一门新技术，当然深入了解还是建议看官方文档 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HtwzEsYsb)
[yikm](https://www.yikm.net/) | 最近有个开发者搞了个小霸王模拟器，里面提供魂斗罗、冒险岛、热血格斗传送、超级马里奥等经典游戏供玩家体验 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HsUVzlhuC)
[i18ns](https://i18ns.com/) | 有个 Android 开发者花了两年时间，收集了 1500 多万条 App 的翻译数据， 并做成了一个搜索网站，希望能帮助独立开发者以更低的成本、更高质量的完成 App 国际化工作 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HsAHl4qLD)
[在线工具](https://tool.lu/) | 一批实用的在线工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HrPmGt25u)
[highschool](http://socialmedia-class.org/highschool.html) | 一个 Python、NLP、Twitter API 三剑合一的新手入门课程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HrwU3360C)
[爱资料工具](https://www.toolnb.com/) | 收录了许多超实用的工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hrn5cfIgy)
[MikuTools](https://tools.miku.ac/) | 这个网站上面有好多超级实用的工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HqsUz3m4Q)
[Wexond](https://wexond.net/) | 一款精致、简洁、扩展性强的开源 Web 浏览器 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hqj5IxIby)
[GitHub Games](https://likexia.gitee.io/game/index.html#/) | 这个网站把 GitHub 上一些有趣的 HTML 小游戏进行了汉化，然后放到上面供人玩耍 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hn77ibjWI)
[paperswithcode](https://paperswithcode.com/) | 该网站按照计算机的不同应用领域进行划分，收集并整理了众多开源项目，每个项目都包含着相关论文供学习参考，分类涵盖了计算机视觉、自然语言处理、医学、方法论、语音、游戏、机器人等多个领域 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HgKJR1s9z)

### 有趣 / 实用开源工具

库名 | 简述 | 源
---- | ----- | -----
[postwoman](https://github.com/liyasthomas/postwoman) | 一款免费开源、轻量级、快速且美观的 API 调试工具，用于替代 Postman，支持 Postman 绝大部分功能，从 Postman 换过来，基本上也没有什么学习成本 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Imd32rEJE)
[gods-pen](https://github.com/ymm-tech/gods-pen) | 开源运营工具：码良，可用于快速制作 H5 页面，用户无需掌握复杂的编程技术，通过简单拖拽、少量配置即可制作精美的页面，可用于营销场景下的页面制作 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IkZD4xp8t)
[huginn](https://github.com/huginn/huginn) | 一个开源的自动化工具，类似 IFTTT 的开源版应用，可通过开发者设定的某个事件来触发具体操作。比如你可以设定当 GitHubDaily 发送一条微博后，自动给你推送一封邮件提醒："这货又发微博了" | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IkMhdyx5S)
[crater](https://github.com/bytefury/crater) | 一款免费开源的 Web 与移动端发票应用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IkxlzEVBF)
[mkcert](https://github.com/FiloSottile/mkcert) | 使用 mkcert 这款工具，即可零配置，一条命令在本地搭建受信任证书环境 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IkjNmuk4Q)
[Sourcetrail](https://github.com/CoatiSoftware/Sourcetrail) | 一款跨平台开发神器，借助可交互式的图形界面操作，让你可以快速阅读项目源码，提升开发效率 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ik6DvCNOz)
[md](https://github.com/doocs/md) | 一款开源的前端编辑器，主要对微信排版做了适配 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389Ij41gdqvJ)
[monolith](https://github.com/Y2Z/monolith) | 如果你想保存某个网页到电脑上，可以试下这个开源项目，有别于普通页面的保存操作，monolith 会通过命令行一次性打包页面中所有 CSS，图片和 JavaScript 等资源，而后生成一个单独的 HTML5 文档，方便你更好的保存与分享 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ij2M2E29i)
[xray](https://github.com/chaitin/xray) | 一款功能强大且完善的安全评估工具，该工具由多名经验丰富的一线安全从业者呕心打造而成，支持的漏洞检测类型有 XSS 漏洞、SQL 注入、命令/代码注入、文件上传等等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/ImFqCjI0b)
[fiora](https://github.com/yinxin630/fiora) | 一款有趣的在线聊天应用。基于 node.js, mongodb, socket.io 和 react 编写 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Iil2JDvmT)
[jsonbox](https://github.com/vasanthv/jsonbox) | 该工具为开发者提供一个特定链接，通过向这个链接发送 HTTP 请求，可以用来存储、读取、修改 JSON 数据 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I7VgIs9B5)
[nodeppt](https://github.com/ksky521/nodeppt) | 一款能将 Markdown 文档转成高大上 PPT 的开源工具，支持图表、流程图、数学符号、自定义主题配色以及样式等等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I0CZngraF)
[comicgen](https://github.com/gramener/comicgen) | 一个很有趣的库，在线制作漫画人物并可将制作的人物图片放在你的网站中 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HEKGTl4Vv)
[translate-shell](https://github.com/soimort/translate-shell) | 一款可在终端下使用的翻译工具，支持切换 Google Translate、Bing Translator、Yandex.Translate 和 Apertium 翻译引擎 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/)
[readme-md-generator](https://github.com/kefranabg/readme-md-generator) | 一款能帮你生成漂亮的 REAMDE.md 文件小工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HANzZ3oll)
[Love-Gift](https://github.com/idealclover/Love-Gift) | 一位开发者做了个网站，当做送给女朋友的情人节礼物 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HAzY6DatJ)
[mathAI](https://github.com/Roujack/mathAI) | 一个拍照做题程序。输入一张包含数学计算题的图片，输出识别出的数学计算式以及计算结果 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hys2OxDkZ)
[2048.cpp](https://github.com/plibither8/2048.cpp) | 用 C++ 写的一款高逼格在终端玩的 2048 游戏 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HyojrzAP6)
[WebStack-Laravel](https://github.com/hui-ho/WebStack-Laravel) | 一个开源的网址导航项目，拥有完整的前后台，可搭建部署自己收藏的网址导航站点 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HxZXvh8gw)
[the-fucking-github](https://github.com/lvxianchao/the-fucking-github) | 一个高颜值 Chrome 浏览器插件，可以用来很方便地查看、整理、搜索你已经 Star 过的项目和搜索 Github 上的项目 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HxxtPsSHb)
[multrin](https://github.com/sentialx/multrin) | 一款免费开源应用窗口聚合工具，能将 Windows 系统上打开的应用窗口聚合在一起，类似浏览器标签页一样，可以快速管理和切换 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hxo3kAE4k)
[gimp](https://github.com/GNOME/gimp) | 一款功能强大且免费开源的图片处理工具，并支持 macOS、Windows 及 Linux 系统 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hx9k486Vv)
[star-history](https://github.com/timqian/star-history) | 一个在线查看 GitHub Star 历史上涨记录的工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HwCUQD0Kx)
[ds-cheatsheets](https://github.com/FavioVazquez/ds-cheatsheets) | 数据科学相关的速查表 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hws77xZia)
[gsbg](https://github.com/mayneyao/gsbg) | 如果你喜欢如附图一样的随机彩色块图片，那么可以用这款工具来生成 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/)
[youtube-dl-interactive](https://github.com/synox/youtube-dl-interactive) | YouTube 视频终端下载工具，主要在 youtube-dl 基础上优化了用户操作体验 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hwk3RfEwb)
[WeChat-Shelter](https://github.com/YGYOOO/WeChat-Shelter) |  Chrome 插件可以把某信伪装成云笔记，看着挺适合聊天摸鱼的 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hw6U0Bcon)
[scar](https://github.com/cloudkj/scar) | 一键部署你的静态网站，并给其加上 HTTPS、全球 CDN、自定义域名等功能，用这个工具就可以做到！ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HvQp8acI7)
[SpaceVim](https://github.com/SpaceVim/SpaceVim) | SpaceVim 是一个社区驱动的模块化的 Vim IDE，以模块的方式组织管理插件以及相关配置，为不同的语言开发量身定制了相关的开发模块，该模块提供代码自动补全， 语法检查、格式化、调试、REPL 等特性。用户仅需载入相关语言的模块即可得到一个开箱即用的 Vim IDE | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HvO30EQXr)
[DIYGame](https://github.com/Lawliet01/DIYGame) | GitHub 上一款在线游戏设计工具，用户在无任何技术背景的情况下，可随意打造一款属于自己的冒险游戏 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HvD36e4xt)
[gaea-editor](https://github.com/ascoders/gaea-editor) | 可以让你在浏览器上快速设计一个简单的网站，有点像 Strikingly 旗下的一款产品「上线了」的简陋版 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hvxy8pGWJ)
[terminus](https://github.com/Eugeny/terminus) | 一款免费开源、高颜值、可自定义配置的终端 Terminus，并支持 Windows、MacOS、Linux 系统 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HvlLwmWG7)
[logodiy](https://github.com/sherlonWang/logodiy) | 一个简单的在线 Logo 制作工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HuaHFEGTr)
[fusuma](https://github.com/hiroppy/fusuma) | 通过编写 Markdown 来快速生成演讲幻灯片 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HtApLeNo4)
[makegirlsmoe_web](https://github.com/makegirlsmoe/makegirlsmoe_web) | 一个二次元头像生成器，它通过设置发色、肤色、配饰等属性来随机生成一个二次元角色。另外这个项目还上链了，如果你觉得生成的二次元角色比较好看，可以直接到链上跟别人进行交易 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HtlDEmDSG)
[terminal](https://github.com/microsoft/terminal) | 微软发布且开源了一款新的命令行终端工具 Windows Terminal | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ht5Bk8y03)
[auxpi](https://github.com/aimerforreimu/auxpi) | 它通过对多个图床平台进行整合，使得一个图床挂掉的时候，会自动将图片分发到其它图床上，让图片外链成为不死链！ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HsLr1mmg1)
[gameboy.live](https://github.com/HFO4/gameboy.live) | 这个项目在终端上面打造了一个 Gameboy 模拟器，让你可以直接在终端上面玩掌上游戏，牛逼啊！ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hsrt1vVMt)
[quinesnake](https://github.com/taylorconor/quinesnake) | 在代码里面玩贪吃蛇 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hs0iwtuCc)
[jsproxy](https://github.com/EtherDream/jsproxy) | 一个基于 JS 实现的网络调试工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hr6RU2o4C)
[ikonate](https://github.com/mikolajdobrucki/ikonate) | 一个十分牛逼的图标库 Ikonate，上面的所有图标完全开源，皆可商用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HqMWZ92rP)
[dadda-translate-crx](https://github.com/waynecz/dadda-translate-crx) | 一款高颜值的划词翻译插件，自带生词簿及吐司弹词记忆，可与有道、扇贝单词同步 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HqMWDhBCc)
[tool](https://github.com/Louiszhai/tool) | Mac 生产力工具链推荐 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HqkF909yG)
[OpenInTerminal](https://github.com/Ji4n1ng/OpenInTerminal) |  Mac 小工具，它支持一键在终端中打开当前目录或选中目录 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hq1PUkypY)
[xg2xg](https://github.com/jhuangtw-dev/xg2xg) | Google 一名前员工在 GitHub 上分享了他在 Google 工作时日常会使用的一些工具，以及外界对应的替代方案 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HpoIV2PSH)
[yapi](https://github.com/YMFE/yapi) | 一个高效、易用、功能强大、可视化的 API 管理平台 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HoMOKCOmF)
[AutoPiano](https://github.com/WarpPrism/AutoPiano) | GitHub 上开源的这个 Web 钢琴应用（AutoPiano）让音乐爱好者可以在线练琴 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Ho1GJ57x6)
[TinyPNG4Mac](https://github.com/kyleduo/TinyPNG4Mac) | 开源的图片无损压缩客户端 TinyPNG4Mac，该工具提供了 PNG 图片的 “几乎无损” 压缩服务，你可以通过简单的拖拽完成对 PNG 图片的压缩，无需打开浏览器，无需手动下载图片 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HnW69rZjW)
[emoji-mosaic](https://github.com/ericandrewlewis/emoji-mosaic) | 一个有趣的工具，能根据原图配色，将图片转为用 emoji 填充的新图 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HnKoH9RK4)
[nps](https://github.com/cnlh/nps) | 一款轻量级、功能强大的内网穿透代理服务器，支持 TCP、UDP 流量转发，内网 HTTP、Socks5代理等等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HnDkjvfhn)
[PI-REC](https://github.com/youyuge34/PI-REC) | 通过与 AI 结合的方式，帮你快速将手绘草稿转为成品图，随便画几笔就能转成完整画像，简直堪称手残党的福音 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HmXGNkKjt)
[imgurl](https://github.com/helloxz/imgurl) | 一款简单、纯粹的图床程序，支持拽拖、多图、粘贴、URL 上传，可裁剪、压缩、鉴黄图片，自动生成缩略图 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HmAI50BdI)
[mas](https://github.com/mas-cli/mas) | 一个 Mac 应用商店命令行工具，支持搜索、安装、更新应用等操作，用起来很方便 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HmcWFmtbD)
[stegify](https://github.com/DimitarPetrov/stegify) |  一款神奇的命令行工具，能将任意文件隐藏到图片里面 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hm37OeCGp)
[gifify](https://github.com/vvo/gifify) | 一款将视频转换成 GIF 图的工具，支持任何格式的视频以及选取某个时间段转换 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HlXCR2q2k)
[zdict](https://github.com/zdict/zdict) | 一个运行在终端的在线字典工具，支持多款字典切换查询，查询结果高亮等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HlPzB4gWe)
[Github-Monitor](https://github.com/VKSRC/Github-Monitor) | 一个用于监控 GitHub 代码仓库的系统，企业可利用该系统及时发现内部代码泄露 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HlrpPpGWd)
[qrcode](https://github.com/sylnsfar/qrcode) | 二维码生成器，支持生成普通二维码、带图片的艺术二维码和动态二维码 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hlni6uVsd)
[traduora](https://github.com/traduora/traduora) | 一个开源翻译平台，支持多人协作在线翻译，可导入导出 JSON、CSV、YAML 等多种文本格式 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HldVNp97O)
[sherlock](https://github.com/sherlock-project/sherlock) | 一个开源脚本，可在各大社交平台检查用户名是否被占用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hlcunnhqd)
[fx](https://github.com/antonmedv/fx) | 优化终端命令行 JSON 查阅体验，支持展开 JSON 数据，访问单个数据点 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hl8yPqXwl)
[nsfwjs](https://github.com/infinitered/nsfwjs) | 一款开源的黄图鉴别工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hl33SdQfX)
[send](https://github.com/mozilla/send) | 由 mozilla 开源的一款简单、私密的文件分享服务，支持设置分享文件的下载次数、有效天数，并可对文件进行加密 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HkPHQmIW9)
[nodeppt](https://github.com/ksky521/nodeppt) | 可能是迄今为止最好的网页版演示库 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HkGhlvc7R)
[devhub](https://github.com/devhubapp/devhub) | 一款跨平台的 GitHub 通知管理客户端，帮助开发者更好的收集、整理、查看 GitHub 消息 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HkwQQC0xz)
[vscode-maxPlus](https://github.com/AShujiao/vscode-maxPlus) | 一个开源的 VSCode 插件，让你能在 vscode 上划水看游戏资讯 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HksJ8if5F)
[olive](https://github.com/olive-editor/olive) | 一个开源的视频编辑器，支持 Windows、macOS、Linux 等主流桌面平台，推荐给想用 Final Cut Pro 却囊中羞涩的同学 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HkjiCyGxC)
[screenshoteer](https://github.com/vladocar/screenshoteer) |  使用命令行一键截取网页图片 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HjR18Bx9W)
[vsc-netease-music](https://github.com/nondanee/vsc-netease-music) | 一个开源的 VSCode 插件，让你能在 vscode 上划水听音乐 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HjdVUEAAE)
[NodeMail](https://github.com/Vincedream/NodeMail) | 一个基于 Node 的爬虫脚本，每天定时给女朋友发一封暖心邮件，非单身狗的程序员可以试用下  | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hja0nzdXe)
[iSimulator](https://github.com/wigl/iSimulator) | 一款实用的 GUI 工具，可用于控制模拟器和管理模拟器里安装的应用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HiWEl80bW)
[PicGo](https://github.com/Molunerfinn/PicGo) | 一款简单易用的图片上传工具，支持自定义第三方图床 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HiJiiAAEd)
[notable](https://github.com/notable/notable) | 一款开源的高颜值、跨平台的 Markdown 编辑器 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HiHIT4imo)
[mercury-parser](https://github.com/postlight/mercury-parser) | 一款 Web 内容提取工具。开发者可通过 JavaScript 与 CSS 选择器来定制解析器，以获取页面上指定内容 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HisSwz8rP)
[read-vscode-e](https://github.com/zrk1993/read-vscode-e) | 一个开源的 VSCode 插件，让你能在 vscode 上划水看小说 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HiqrjtIFI)
[PPRows](https://github.com/jkpang/PPRows) | 一款在 Mac 上计算你写了多少行代码的工具，支持同时检测多文件夹代码，自定义检测的文件类型等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HijmW7MYE)
[lint-md](https://github.com/hustcc/lint-md) | 一个用于检查中文 Markdown 编写格式规范的命令行工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HibvR77oL)
[douban-movie-extension](https://github.com/Neulana/douban-movie-extension) | 一款 Chrome 浏览器扩展，在豆瓣电影页面增加电影资源模块，帮你轻松找到电影资源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hi60UvUqu)
[BackgroundMusic](https://github.com/kyleneideck/BackgroundMusic) | 一款 Mac 音频工具，可以在播放其他音频时，自动暂停所有背景音乐，播放结束后再次恢复背景音乐，并支持控制单个应用的音量 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hi25mgCCK)
[SwitchHosts](https://github.com/oldj/SwitchHosts) |  一款快速切换 Hosts 工具，支持 Win，Mac 和 Linux | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HhWApFnyu)
[QuickLook](https://github.com/QL-Win/QuickLook) | 给 Windows 用户的福利，让 Windows 用户可以用上 Mac 系统的文件预览功能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HgY5SEElB)
[uppy](https://github.com/transloadit/uppy) | 一个基于 JavaScript 的文件上传工具，可无缝集成到任何应用。支持从本地磁盘、远程 urls、Google Drive、Dropbox、Instagram、snap 等位置上传文件，并在线预览编辑 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HgUalh24R)
[daily-anime](https://github.com/deepred5/daily-anime) | 一个开源的 VSCode 插件，让你能在 VSCode 上划水追番  | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HhHFLwPce)
[Motrix](https://github.com/agalwood/Motrix) | 一款全能的下载工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HgAwExNvV)
[gotop](https://github.com/cjbassi/gotop) | 一个酷炫的命令行活动监视器，基于 Go 语言编写 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hgjf5x6Tb)
[AirtestProject](https://github.com/AirtestProject) | 一个网易开发的 UI 界面自动化测试工具，主要使用图像识别技术来定位页面具体的 UI 元素，这也就意味着它可以在不使用任何代码注入的情况下完成自动化测试 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HdplOtzj1)
[syncd](https://github.com/dreamans/syncd) | 一款使用 Go 语言开发的代码部署工具，它具有简单、高效、易用等特点，可以提高团队的工作效率 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HcjM2jeRb)
[hacknical](https://github.com/ecmadao/hacknical) | 一个生成可视化 GitHub 简历的网站 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HaRqC5A6C)
[BaiduPCS-Go](https://github.com/iikira/BaiduPCS-Go) | 一个仿 Linux shell 文件处理命令的百度网盘命令行客户端，支持 Windows, macOS, linux, 移动设备等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HauE4mekH)
[thefuck](https://github.com/nvbn/thefuck) |  输错命令后，fuck 一下，自动帮你更正命令，解气又实用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HgsFzhOg2)
[RSSHub](https://github.com/DIYgod/RSSHub) | 一个轻量、易于扩展的 RSS 生成器，它可以给任何奇奇怪怪的内容生成 RSS 订阅源 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/He3p24W3S)
[cloudquery](https://github.com/t9tio/cloudquery) | 一款能给任意网站生成 API 的工具，开发者通过点击页面元素即可选择生成内容，非常方便，搞前端的同学可以了解下 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HdyIz2DSx)
[music-dl](https://github.com/0xHJK/music-dl) | 使用 Python 开发的一个可从网易云音乐、QQ音乐、酷狗音乐等搜索和下载最优音质歌曲的工具，支持多线程搜索和下载，还可以对搜索结果去重 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HcM3xbOla)

### 机器学习 / 人工智能

库名 | 简述 | 源
---- | ----- | -----
[BitTigerLab](https://github.com/Fabsqrt/BitTigerLab) | 计算机科学中文学习笔记 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IcH3ipq5C)
[bustag](https://github.com/gxtrobot/bustag) | 基于机器学习的老司机车牌自动推荐系统 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IasqikBsx)
[computer-science](https://github.com/ossu/computer-science) | 一份开源的计算机科学教学资源，可用于自学编程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I6TDmhBfv)
[ai-edu](https://github.com/microsoft/ai-edu) | 微软在 GitHub 上开源了一份 AI 教学资源，主要服务于国内学生、教师以及 IT 从业人员。 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I6LnVBo4e)
[ai-roadmap](https://github.com/apachecn/ai-roadmap) | 来自 ApacheCN 开源组织整理的一份 AI 人工智能路线图 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I0sW28AMe)
[Machine-Learning](https://github.com/shunliz/Machine-Learning) | 机器学习原理笔记整理。前半部分关注数学基础，机器学习和深度学习理论。后半部分关注工程实践和理论应用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HvRMn0al7)
[Chinese-Chatbot-PyTorch-Implementation](https://github.com/Doragd/Chinese-Chatbot-PyTorch-Implementation) | 一个利用有趣中文语料库 qingyun 训练出来的中文聊天机器人 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hu8lydUVK)
[machine-learning-course](https://github.com/machinelearningmindset/machine-learning-course) | 一份机器学习课程 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HtXlDrUaM)
[learning](https://github.com/amitness/learning) | 国外一名开发者分享的数据科学学习计划，旨在每日不断精进学习，以提升自己的技术水平 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HsPere8j6)
[Awesome-Mobile-Machine-Learning](https://github.com/fritzlabs/Awesome-Mobile-Machine-Learning) | 移动端上的机器学习资源整理 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HqLnd9dIF)
[Virgilio](https://github.com/virgili0/Virgilio) | 一份机器学习指南，该指南可作为你机器学习的导师，为你提供完整学习路径，让你了解更多工具的使用，掌握更多技能 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HpW70c0JE)
[libfacedetection](https://github.com/ShiqiYu/libfacedetection) | 堪称史上最快图像中人脸检测的开源库 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HmlYOfcAu)
[deep-painterly-harmonization](https://github.com/luanfujun/deep-painterly-harmonization) | 一个基于深度学习的开源项目，让图片可以毫无违和感的融入到绘画作品中，这波操作太强了！ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HjV8QBljR)
[Deta_Parser](https://github.com/yaoguangluo/Deta_Parser) | 一个每秒高达 2700 万混合分词， 高精准确率，支持病句分析，词性，词频统计，自由扩充词库的快速神经网络中文分词包 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hi7Dxwr7V)
[wukong-robot](https://github.com/wzpan/wukong-robot) | 一个简单、灵活、优雅的中文语音对话机器人/智能音箱项目 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HhSES4lL0)
[edge-connect](https://github.com/knazeri/edge-connect) | 加拿大安大略理工大学开源的图像自动修复方法，可由线到面逐步修复受损或被打码的图像，也可进行图像拼接、移除、编辑等操作 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HhuiVnXVj)
[face_recognition](https://github.com/ageitgey/face_recognition) | 号称世界上最简单的人脸识别库 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HgueYxAsI)
[nlp-tutorial](https://github.com/graykode/nlp-tutorial) | 一份基于 TensorFlow 和 Pytorch 的自然语言处理教程，该课程主要面向深度学习开发者 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HgaBhsYXY)
[HyperDL-Tutorial](https://github.com/zeusees/HyperDL-Tutorial) | 一份深度学习相关的系列文章，作者总结了在深度学习实践中的一些经验 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HeVBT8K8w)
[spinningup](https://github.com/openai/spinningup) | 由 OpenAI 发布的一份深度强化学习教学资源集，内容包括易懂的深度强化学习代码示例、算法、习题、文档和教程等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hdxc0tvmN)
[git-recipes](https://github.com/geeeeeeeeek/git-recipes) | 一份开源的 Git 中文教程，源于国外社区的优秀文章和个人实践 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hdel1pSPz)
[funNLP](https://github.com/fighting41love/funNLP) | 一个作者在文本中抽取结构化信息时，整理出所用到 GitHub 上的资源整合，内容包括：中英文敏感词、语言检测、中外手机/电话归属地/运营商查询、名字推断性别、手机号抽取、身份证抽取等等 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hd4UvDdep)
[awesome-reinforcement-learning-zh](https://github.com/wwxFromTju/awesome-reinforcement-learning-zh) | 一份强化学习从入门到放弃的资料汇总 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HctcwvT2n)


### 非开源的实用工具

地址 | 简述 | 源
---- | ----- | -----
[Project Naptha](https://projectnaptha.com/) | 超级实用的 Chrome 插件，可选中、复制、编辑图片中的内嵌文字！ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IcO7FsbX3)
[Mathpix](https://mathpix.com/) | 这款工具能将带数学公式的截图一键转成 latex 代码 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hozgx9mUC)
[removebg](https://www.remove.bg/) | Google Chrome 的技术经理推荐的一款工具能帮你快速移除任何图片的背景 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HnzoMqRTU)
[OXYGEN](https://jeasonstudio.github.io/oxygen-demo/) | 这个网站可以帮你生成手绘风格的流程图或架构图，写文章的时候随手插入几张应该很有艺术感 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HpaYwf2Pv)
[Firefox Monitor](https://monitor.firefox.com/) | 国内外不少知名企业都曾经被拖库，为此 Firefox 专门搞了这么一个工具，来帮助用户检查自己的信息是否被泄露 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hpq69C8aO)
[codeimg](https://codeimg.io/) | 一款免费在线把源代码生成高逼格的图片工具 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/I0a52r5GX)
[iPic](https://toolinbox.net/iPic/) |  Mac 上一个图床神器，可通过快捷键将本地图片上传到服务器，并自动生成 Markdown 图片格式的排版 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hae4LEBqC)

### 其它

地址 | 简述 | 源
---- | ----- | -----
[语雀 IT 百科](https://www.yuque.com/yuque/blog/yuque-info-tech-encyclopedia) | 一份高质量的 IT 百科知识库，上面涵盖诸多互联网技术领域的内容，具有一定的学习和参考价值 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HweL52O9M)
[go-best-practice](https://github.com/llitfkitfk/go-best-practice) | 一篇对国外文章《Go 语言实战: 编写可维护 Go 语言代码建议》的中文翻译版 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/ImgYA92VY)
[api-guidelines](https://github.com/microsoft/api-guidelines) | 微软官方出品的 REST API 指导规范，希望能帮助开发者更好的设计接口 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IkGYffcVS)
[uber_go_guide_cn](https://github.com/xxjwxc/uber_go_guide_cn) | Uber 团队出的 Go 语言编码规范，有人给翻译了中文版 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IkqCXhIsb)
[home-assistant](https://github.com/home-assistant/home-assistant) | 一款开源的智能家居系统，你可以利用它来追踪并控制家里的智能设备，如灯光、温度、声音等。另外，Home Assistant 还提供了交互友好的管理后台，可自定义控制面板，并支持跨终端使用 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/IknV59FKk)
[NeteaseCloudMusicApi](https://github.com/Binaryify/NeteaseCloudMusicApi) | 有位开发者整了个网易云音乐非官方 API，共有 100 多个接口，感觉还挺全面的 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HwaDmpthI)
[night-reading-go](https://github.com/developer-learning/night-reading-go) | 每周会通过在线直播的方式，向开发者分享 Go 相关的技术话题，于 Slack 上沟通交流编程技术话题 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hv2UwEUtq)
[hacker-laws-zh](https://github.com/nusr/hacker-laws-zh) | 主要收录了一些最常见的定律、原则以及模式，并对它们进行简要的讲解 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HuAD2ss1G)
[battle-city](https://github.com/shinima/battle-city) | GitHub 上开源的这个坦克大战小游戏还原度好高啊，好玩得停不下来！还可以双人组队！ | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HugcDaYy0)
[RemixIcon](https://github.com/Remix-Design/RemixIcon) | 一套开源图标库 Remix Icon，主要面向设计师和开发者的开源图标库 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HtYQZi0eJ)
[synthwave-vscode](https://github.com/robb0wen/synthwave-vscode) |  一款有点骚的 VS Code 主题 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hsj9wsRZj)
[support.996.ICU](https://github.com/MSWorkers/support.996.ICU) | 微软和 GitHub 员工宣布支持 996.ICU 运动！如果你也想支持这一运动，可提交 PR 到该项目的支持者名单中 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HqWvF0wrr)
[cxk-ball](https://github.com/kasuganosoras/cxk-ball) | 有个在 GitHub 上写了个蔡徐坤打篮球的小游戏 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HqO7GxyD8)
[instantbox](https://github.com/instantbox/instantbox) | 让你能在不到 30 秒的时间内得到一个干净、开箱即用的临时 Linux 系统 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HlKgP86Rx)
[gtop](https://github.com/aksakalli/gtop) | 一个使用 Node.js 实现的终端系统监控面板 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HllUSdvDU)
[ChromeAppHeroes](https://github.com/zhaoolee/ChromeAppHeroes) | Chrome 插件英雄榜，为优秀的 Chrome 插件写一本中文说明书 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HkrlT72sv)
[Free-Chinese-Fonts](https://github.com/zenozeng/Free-Chinese-Fonts) | 收录了一些免费的中文字体 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HjChS7CJX)
[chinese-xinhua](https://github.com/pwxcoo/chinese-xinhua) | 中华新华字典数据库，包括常用歇后语、成语、词语和汉字 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HjjqSai6g)
[Micro8](https://github.com/Micropoor/Micro8) | 一份开源的渗透攻击教程，适用于初中级安全从业人员，乙方安全测试，甲方安全自检，网络安全爱好者 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HhOJkpaOi)
[How-To-Secure-A-Linux-Server](https://github.com/imthenachoman/How-To-Secure-A-Linux-Server) | 这份文档将指导你如何让 Linux 服务器更加安全 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/HgbnZ9e8S)
[VBlog](https://github.com/GitHub-Laziji/VBlog) | 一个借助 GitHub Pages 和 GitHub API 搭建的可动态发布文章的博客，如果你还在纠结于自己的博客系统用什么搭建 | [![](https://raw.githubusercontent.com/GitHubDaily/GitHubDaily/master/assets/sina_logo.png)](https://weibo.com/5722964389/Hd6zX0Gv4)

## 声明
[![](https://licensebuttons.net/l/by-nc-nd/2.0/88x31.png)](https://creativecommons.org/licenses/by-nc-nd/2.0/deed.zh)  
本作品采用[知识共享署名-非商业性使用-禁止演绎 2.0 通用许可协议](https://creativecommons.org/licenses/by-nc-nd/2.0/deed.zh)进行许可。








