![banner](https://user-images.githubusercontent.com/42373389/235295056-fc1d7ba7-112d-45e8-a56f-b8cf68d9fa31.png)

# 《ChatGPT Prompt Engineering for Developers》中英双语字幕

该项目主要用于存放《面向开发者的 ChatGPT 提示词工程》非官方版中英双语字幕。

- **中文视频地址：[面向开发者的 ChatGPT 提示词工程](https://www.bilibili.com/video/BV1s24y1F7eq/)**
- **英文原视频地址：[ChatGPT Prompt Engineering for Developers](https://learn.deeplearning.ai/)**
- **配套代码与笔记：[《ChatGPT Prompt Engineering for Developers》课程中文版 Datawhale](https://github.com/datawhalechina/prompt-engineering-for-developers)**

如果你在观看视频的过程中，发现翻译出现错漏、错别字、病句等情况，欢迎向我们提交 Pull Request 以改进字幕翻译质量。

本项目文件夹说明：

- `subtitles`：核心字幕，里面放置了「中英双语字幕」；
- `english_subtitles`：从双语字幕中分离出来的「英文字幕」；
- `chinese_subtitles`：从双语字幕中分离出来的「中文字幕」;
- `course_notebooks`:  从课程中复制至本地的 Notebook。

字幕效果展示：

![image](https://user-images.githubusercontent.com/42373389/235338205-31271b4c-b379-43d1-9b3e-bd5114f9dc09.png)

## 课程介绍

ChatGPT 上线至今，已经快 5 个月了，但是不少人还没真正掌握它的使用技巧。

其实，ChatGPT 的难点，在于 Prompt（提示词）的编写，OpenAI 创始人在今年 2 月时，在 Twitter 上说：「能够出色编写 Prompt 跟聊天机器人对话，是一项能令人惊艳的高杠杆技能」。

因为从 ChatGPT 发布之后，如何写好 Prompt 已经成为了一个分水岭。熟练掌握 Prompt 编写的人，能够很快让 ChatGPT 理解需求，并很好的执行任务。

目前你在网上看到的所有 AI 助理、智能翻译、角色扮演，本质上还是通过编写 Prompt 来实现。

只要你的 Prompt 写的足够好，ChatGPT 可以帮你快速完成很多工作，包括写爬虫脚本、金融数据分析、文案润色与翻译等等，并且这些工作还做的比一般人出色。

为了帮助大家能更好的掌握 Prompt 工程，DeepLearning.ai 创始人吴恩达与 OpenAI 开发者 Iza Fulford 联手推出了一门面向开发者的技术教程：《**ChatGPT 提示工程**》。

<p align="center">
  <a href="https://twitter.com/AndrewYNg/status/1651605660382134274">  <img align="center" src="https://user-images.githubusercontent.com/42373389/235334070-5f0c8715-fafb-4f84-9b78-be5e7da709e5.png" width="500"></a>
</p>

吴恩达老师相信大家都有所耳闻，作为人工智能界的重量级大佬，我们经常能在 AI 技术界看到他活跃的身影。

另一位讲师 Iza Fulford，大家可能不太熟悉，这里重点介绍下。

她是斯坦福本硕高材生，ChatGPT 之前在 GitHub 开源的那个文档搜索插件：**Retrieval**，就是出自她之手。

另外，她还是 OpenAI Cookbook（官方手册）的编撰者，如果你最近有深入了解过 GPT 相关的技术，那这本手册于你而言应该不会陌生。

该手册里面提供了大量 GPT 相关的使用案例，能帮助你快速上手并掌握 GPT 模型的开发与应用。

可以说，这两位大佬联手，推出的教程绝对不会差。更令人振奋的是，这个教程完全对外开放，所有人均可免费学习！

那么，这个教程里面主要讲了什么内容呢？

该教程总共分为 9 个章节，总一个多小时，里面主要涵盖：**提示词最佳实践、评论情感分类、文本总结、邮件撰写、文本翻译、快速搭建一个聊天机器人**等等。

![image](https://user-images.githubusercontent.com/42373389/235334065-97349f08-ac8b-41c5-ad1a-b2ed0bec7f3f.png)

所有当下 ChatGPT 的流行案例，你都能在这个教程里面找到，十分全面！

除了能在这个教程里面学到如何使用 Prompt，你还能学到 GPT 接口调用开发知识。有需要的话，你甚至能在这个教程之上去延伸扩展，搭建出一款令人惊艳的应用。

目前该教程已经在 DeepLearning.ai 正式上线，官网上线提供了可交互式的 Notebook，让你可以一边学习，一边跟着编写代码实践。

不过当下这个教程只有英文版，为了让看不懂英文的同学也能第一时间学习并掌握这项技术。

我花了一天时间，完整翻译了所有英文字幕，并且[将所有视频与字幕同步上传到了 B 站](https://www.bilibili.com/video/BV1s24y1F7eq/)。

大家有时间的话，可以多学一下这个教程，相信整个学习下来，绝对能让你受益匪浅！

## 贡献者

查看 [贡献列表](https://github.com/GitHubDaily/ChatGPT-Prompt-Engineering-for-Developers-in-Chinese/graphs/contributors) 获取更多信息，感谢所有为项目作为贡献的人！

<a href="https://github.com/GitHubDaily/ChatGPT-Prompt-Engineering-for-Developers-in-Chinese/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=GitHubDaily/ChatGPT-Prompt-Engineering-for-Developers-in-Chinese" />
</a>

## 开源协议

项目基于 [CC BY-NC-SA 4.0 协议](https://creativecommons.org/licenses/by-nc-sa/4.0/deed.zh) 发布。

[![CC BY-NC-SA 4.0][cc-by-nc-sa-image]][cc-by-nc-sa]

[cc-by-nc-sa]: http://creativecommons.org/licenses/by-nc-sa/4.0/
[cc-by-nc-sa-image]: https://licensebuttons.net/l/by-nc-sa/4.0/88x31.png
[cc-by-nc-sa-shield]: https://img.shields.io/badge/License-CC%20BY--NC--SA%204.0-lightgrey.svg
