/**
 * Font: Roboto Medium Regular 34
 * Copyright: Copyright 2011 Google Inc. All Rights Reserved.
 * Charcodes: 0x20-0x7e
 */

#include <stdint.h>

#define FONT_ROBOTOM24_1_ASCENT 34
#define FONT_ROBOTOM24_1_DESCENT 9
#define FONT_ROBOTOM24_1_CAP_HEIGHT 24
#define FONT_ROBOTOM24_1_LINE_HEIGHT 43
#define FONT_ROBOTOM24_1_BOUNDINGBOX_LEFT -2
#define FONT_ROBOTOM24_1_BOUNDINGBOX_BOTTOM -8
#define FONT_ROBOTOM24_1_BOUNDINGBOX_WIDTH 32
#define FONT_ROBOTOM24_1_BOUNDINGBOX_HEIGHT 36

const uint8_t font_robotoM24_1[2975] =
{
0x00, 0x18, 0x00, 0x22, 0x00, 0x09, 0xff, 0xfe, 0xff, 0xf8, 0x00, 0x20, 0x00, 0x24, 0x03, 0x06,
0x05, 0x06, 0x05, 0x01, 0x02, 0x02, 0x87, 0x63, 0x20, 0x04, 0x00, 0x00, 0x80, 0x00, 0x0f, 0x02,
0x0a, 0x96, 0x12, 0xf8, 0x93, 0x13, 0xf0, 0x8a, 0x4a, 0xaf, 0x24, 0xc9, 0x49, 0x09, 0x0d, 0x89,
0x52, 0xb2, 0x60, 0x49, 0x51, 0x09, 0xec, 0xc6, 0x86, 0xc6, 0x46, 0x00, 0x30, 0x01, 0x28, 0x56,
0xb1, 0x81, 0x85, 0x8a, 0x2b, 0x34, 0x5e, 0x59, 0x79, 0x83, 0x8a, 0x2b, 0x54, 0x0c, 0xc8, 0xb3,
0x3c, 0x57, 0x56, 0xde, 0xc0, 0xa0, 0xe2, 0x0a, 0x8d, 0x57, 0x68, 0x1c, 0x90, 0x67, 0x79, 0xac,
0x50, 0x71, 0x85, 0xc6, 0x2b, 0x2b, 0x6f, 0x60, 0x50, 0x71, 0x85, 0xca, 0x01, 0x32, 0xe1, 0x23,
0x38, 0x31, 0xd0, 0xf8, 0x46, 0xb7, 0xb4, 0x8d, 0x7d, 0x68, 0xd1, 0x82, 0x65, 0xc7, 0xce, 0xce,
0x95, 0x9d, 0x6e, 0xe1, 0x9a, 0x97, 0x71, 0xcf, 0x6b, 0xb8, 0xa5, 0x3b, 0x5d, 0x92, 0xc3, 0x4e,
0xce, 0x25, 0x49, 0xec, 0x2c, 0xd9, 0xb2, 0x9c, 0xea, 0xb0, 0x86, 0x03, 0x8a, 0x57, 0xf8, 0x01,
0x43, 0x01, 0x2e, 0x96, 0x2d, 0xe9, 0x3d, 0xde, 0xc9, 0xb1, 0x70, 0xf0, 0x14, 0x2a, 0x54, 0x6c,
0x54, 0x59, 0xb9, 0x42, 0x65, 0x83, 0x15, 0x2a, 0x2a, 0xec, 0xe4, 0xa8, 0xb8, 0x47, 0x83, 0x4b,
0x56, 0x7e, 0x85, 0xaf, 0xfc, 0xca, 0x12, 0x6e, 0xac, 0x71, 0x45, 0x27, 0x87, 0x15, 0x15, 0x2a,
0x6c, 0xac, 0xd4, 0xb8, 0x32, 0xa0, 0x54, 0xa1, 0x52, 0xc3, 0x80, 0x42, 0xe5, 0x82, 0x9d, 0x9c,
0xaf, 0xe9, 0x25, 0x03, 0x36, 0x01, 0x2a, 0x66, 0x59, 0xe2, 0x65, 0x5e, 0xc7, 0x25, 0x3a, 0xee,
0x10, 0xcc, 0x61, 0xa7, 0x4e, 0x3b, 0x3b, 0xee, 0x28, 0x79, 0x19, 0xae, 0xf1, 0x16, 0xef, 0xe1,
0x36, 0x3b, 0x4b, 0x04, 0x9c, 0x1d, 0x3a, 0x3a, 0x3b, 0x75, 0x72, 0x74, 0xec, 0xa1, 0x63, 0x0d,
0x9d, 0x4b, 0x6a, 0xd9, 0x53, 0x3f, 0xf6, 0x73, 0xcd, 0x92, 0x00, 0x06, 0x89, 0x48, 0x62, 0xc0,
0x5f, 0x09, 0x1c, 0xc2, 0xd5, 0xc8, 0xb0, 0x70, 0xc5, 0x4e, 0xc1, 0x3a, 0x56, 0x0c, 0x38, 0x56,
0xae, 0xc0, 0x1f, 0x3b, 0xc0, 0x95, 0x3b, 0x06, 0xeb, 0x5c, 0x39, 0xe0, 0x5c, 0x69, 0x21, 0x21,
0xc0, 0xd5, 0xc8, 0x24, 0xb4, 0x72, 0xe7, 0x0a, 0x83, 0x29, 0x77, 0xae, 0x1c, 0x70, 0xec, 0x5c,
0x39, 0xf0, 0x77, 0xac, 0x5c, 0x01, 0xec, 0x60, 0x58, 0xb1, 0x03, 0x58, 0xb1, 0x63, 0xe5, 0x02,
0x03, 0x1c, 0x48, 0xde, 0xf3, 0x18, 0xa8, 0x70, 0xe5, 0xc6, 0x0a, 0x05, 0x9d, 0x94, 0x1c, 0xed,
0xa8, 0x73, 0x89, 0x4b, 0x5a, 0x49, 0xb9, 0xa2, 0x53, 0x67, 0x07, 0xa8, 0xe1, 0x03, 0x10, 0x11,
0xa2, 0x34, 0x5d, 0x81, 0xa7, 0x3b, 0xd7, 0xff, 0x7f, 0x0e, 0xdc, 0xe9, 0x8e, 0x57, 0x0e, 0x0a,
0xd0, 0x8d, 0x72, 0xc0, 0xd1, 0x51, 0xd1, 0x51, 0x59, 0x61, 0x06, 0x41, 0x12, 0xb1, 0xfa, 0xd3,
0x00, 0x07, 0x02, 0x4a, 0xa1, 0x58, 0xc9, 0x26, 0x25, 0x1e, 0xf0, 0x9b, 0xd6, 0xb4, 0x83, 0xd1,
0x8a, 0x2b, 0xae, 0xe0, 0xd1, 0x8a, 0x2b, 0xed, 0x60, 0xb4, 0xe2, 0x8a, 0x2b, 0xad, 0xb8, 0xd2,
0x0e, 0x46, 0x2b, 0xae, 0xb8, 0xd2, 0x8a, 0x03, 0x22, 0x01, 0x22, 0x36, 0xd9, 0xd2, 0x36, 0xf6,
0xa1, 0x64, 0x09, 0x9d, 0x4a, 0xb0, 0xd1, 0xb9, 0x23, 0xd8, 0x3b, 0xec, 0x04, 0xd6, 0xb9, 0xa3,
0x73, 0x67, 0xa7, 0x80, 0x64, 0x49, 0x7d, 0x6c, 0xd3, 0x96, 0x02, 0x0f, 0x02, 0x16, 0x36, 0xb5,
0x61, 0x89, 0x32, 0x40, 0x36, 0x29, 0x03, 0xff, 0xff, 0xce, 0x1d, 0x21, 0x01, 0x24, 0x36, 0xd9,
0xd2, 0x3a, 0x96, 0x53, 0xc9, 0x12, 0x3a, 0x96, 0xec, 0xdc, 0xd1, 0x61, 0x67, 0x85, 0xc1, 0x1c,
0xef, 0x74, 0xa7, 0x03, 0x5f, 0xc2, 0x25, 0xdd, 0xe9, 0x80, 0x1f, 0xfd, 0x04, 0x2b, 0x01, 0x22,
0x36, 0x55, 0xc3, 0x3a, 0x95, 0xb3, 0x65, 0xc9, 0x8e, 0x25, 0x3a, 0x77, 0x54, 0xd8, 0xe9, 0x0e,
0x97, 0xbc, 0xe4, 0x32, 0xec, 0x69, 0x19, 0xa0, 0x4b, 0x80, 0xee, 0xe4, 0xb0, 0x93, 0xe4, 0x8e,
0xce, 0x1d, 0x2d, 0x4b, 0x28, 0xa7, 0x3a, 0xac, 0x29, 0x28, 0x00, 0x26, 0x36, 0xbd, 0x03, 0x78,
0x49, 0xb7, 0x00, 0x5c, 0xf3, 0x1e, 0x77, 0x72, 0x5c, 0xd1, 0x69, 0x47, 0x87, 0x9d, 0x1d, 0x56,
0xe8, 0xdc, 0xa1, 0x63, 0xa7, 0x8e, 0x15, 0x3b, 0x05, 0xe4, 0x51, 0x1e, 0x2e, 0xf1, 0xc0, 0xce,
0x77, 0x08, 0x25, 0x02, 0x20, 0x36, 0x09, 0x94, 0xb3, 0xc3, 0x95, 0xae, 0x40, 0xb8, 0x93, 0xa5,
0x3e, 0x94, 0xb3, 0x64, 0x0b, 0x85, 0x3b, 0x5c, 0x02, 0x70, 0x87, 0x7b, 0xd8, 0x73, 0x49, 0x8e,
0x1d, 0x25, 0x5b, 0xf6, 0xa9, 0x0d, 0x5b, 0x0a, 0x29, 0x01, 0x22, 0x36, 0xb5, 0xf3, 0x96, 0xf6,
0xb0, 0xa6, 0x25, 0x00, 0x77, 0xba, 0xd3, 0x15, 0x2d, 0x95, 0x43, 0x3b, 0x6b, 0xb4, 0x28, 0xb1,
0xa3, 0x73, 0x09, 0x36, 0x39, 0xec, 0xe8, 0x58, 0xa2, 0x63, 0x87, 0x12, 0x2d, 0xf4, 0xb1, 0x4d,
0x5b, 0x0a, 0x17, 0x01, 0x22, 0x36, 0xfb, 0xff, 0x70, 0xc0, 0xe9, 0x0a, 0xd0, 0x1d, 0x6c, 0xb8,
0xd3, 0x1d, 0x2e, 0xc1, 0xc2, 0x9d, 0xee, 0x70, 0xc7, 0x01, 0x2d, 0x01, 0x22, 0x36, 0xd9, 0xd2,
0x36, 0xf6, 0xa1, 0x64, 0x09, 0x9d, 0x4a, 0x94, 0x18, 0xcc, 0xd1, 0xb9, 0xb3, 0x53, 0x40, 0xb2,
0xa4, 0x3a, 0x97, 0xb9, 0x4e, 0x01, 0xc9, 0x12, 0x83, 0x75, 0x74, 0x2e, 0xc9, 0xb9, 0xa3, 0xc4,
0xce, 0x92, 0x2d, 0xcb, 0xa9, 0x0e, 0x6b, 0x0a, 0x22, 0x01, 0x22, 0x36, 0xd5, 0xe2, 0x32, 0xd7,
0x29, 0x20, 0x59, 0x52, 0x67, 0xb0, 0xef, 0xdc, 0x11, 0xb0, 0x6c, 0x87, 0x72, 0x6a, 0xd1, 0xe9,
0x0e, 0x77, 0xba, 0xf3, 0x92, 0xd6, 0xb0, 0xa7, 0x35, 0xee, 0x34, 0x0c, 0x02, 0xca, 0x94, 0x58,
0xc9, 0x26, 0x85, 0xff, 0xaf, 0x64, 0x93, 0x12, 0x11, 0xd0, 0x4f, 0x86, 0x34, 0xe0, 0xec, 0x50,
0xf1, 0xff, 0x7f, 0x05, 0xce, 0xce, 0xca, 0xce, 0x8a, 0x03, 0x18, 0x11, 0x1c, 0x14, 0x75, 0xe1,
0x15, 0xb6, 0xd8, 0x43, 0x99, 0x3d, 0xf4, 0x58, 0xd2, 0x16, 0x96, 0x61, 0x0f, 0xcb, 0x5c, 0xd3,
0x12, 0x6e, 0x78, 0x0b, 0x2a, 0xde, 0x32, 0xf3, 0x7f, 0xf8, 0xff, 0xcb, 0xff, 0xf9, 0x00, 0x18,
0x12, 0x1e, 0x24, 0x83, 0x77, 0xde, 0xd2, 0x9e, 0x96, 0x61, 0x99, 0xd6, 0xbc, 0xd3, 0x96, 0x7b,
0x00, 0xca, 0x54, 0xc3, 0x12, 0x57, 0xfe, 0x01, 0x1d, 0x01, 0x1e, 0x16, 0xd1, 0x72, 0x1b, 0xfa,
0x2c, 0xd1, 0x92, 0xa4, 0x4e, 0x8e, 0x81, 0xce, 0x03, 0x8e, 0x03, 0x25, 0x2d, 0x71, 0xc0, 0x79,
0x87, 0xff, 0x1f, 0xe8, 0xbc, 0x72, 0x55, 0xc1, 0x3b, 0xe8, 0xbd, 0xe7, 0x97, 0xe3, 0xfd, 0x70,
0xc0, 0x71, 0xa7, 0x2b, 0xec, 0x7c, 0xe5, 0x0a, 0xaf, 0x58, 0xb9, 0xc4, 0x0a, 0x95, 0x7b, 0x00,
0x2a, 0x96, 0xa9, 0x81, 0x41, 0xa5, 0x8a, 0x4a, 0x1d, 0x82, 0x9f, 0x52, 0x45, 0xa5, 0x4a, 0xc1,
0x6f, 0xa5, 0x8a, 0x0a, 0x15, 0x2b, 0x55, 0x54, 0xa8, 0x54, 0xb1, 0xb1, 0x42, 0x40, 0xa9, 0xb2,
0x42, 0x67, 0x09, 0x95, 0x95, 0xfa, 0xe4, 0x50, 0xa9, 0x26, 0x8f, 0x95, 0x4a, 0xe8, 0xb0, 0xe2,
0xef, 0xf8, 0x2b, 0xff, 0x80, 0xe3, 0x6f, 0x87, 0x97, 0xf3, 0x7b, 0x1e, 0x88, 0x3e, 0x41, 0x36,
0x00, 0x2e, 0x76, 0xb5, 0xf3, 0x4b, 0x7a, 0x4b, 0xaf, 0xe1, 0x35, 0xdf, 0xf3, 0x9d, 0x1c, 0xaf,
0xe8, 0x74, 0x67, 0xa5, 0x3b, 0x3b, 0xef, 0xd0, 0x79, 0xa7, 0x8e, 0x3b, 0x75, 0xda, 0xb1, 0xd3,
0xce, 0x1d, 0xd6, 0x73, 0x3f, 0x97, 0xa7, 0x92, 0x76, 0xea, 0xb8, 0x84, 0xce, 0x3b, 0x4b, 0xde,
0xd9, 0xe1, 0x92, 0x24, 0xdd, 0x09, 0x29, 0x02, 0x24, 0x56, 0x73, 0xaa, 0x67, 0x3f, 0x4a, 0x6a,
0x51, 0x72, 0x09, 0x96, 0x24, 0xec, 0x24, 0xb9, 0x24, 0x89, 0x25, 0xea, 0xd9, 0x0e, 0xfd, 0x28,
0xb9, 0x24, 0x09, 0x3b, 0x49, 0x60, 0xd8, 0x86, 0x9d, 0x24, 0xd5, 0xe4, 0x47, 0x3d, 0xcb, 0x29,
0x28, 0x01, 0x28, 0x66, 0x5d, 0xf3, 0x3a, 0x2c, 0xc7, 0x1a, 0x2d, 0x94, 0x5c, 0xb2, 0xd3, 0x8e,
0x92, 0x96, 0xe4, 0xbc, 0x13, 0xf0, 0x3b, 0xbc, 0xf3, 0x4e, 0x92, 0x96, 0xe8, 0xb4, 0xb3, 0xe4,
0x12, 0x5a, 0xb6, 0x58, 0x0e, 0xeb, 0xbc, 0xc6, 0x00, 0x24, 0x02, 0x26, 0x66, 0x3b, 0x2c, 0xc7,
0x7a, 0x28, 0xa1, 0x66, 0x89, 0x2d, 0x4a, 0xd8, 0x51, 0xc2, 0x12, 0xec, 0x9f, 0x24, 0xed, 0x24,
0x61, 0x49, 0x92, 0x4b, 0x94, 0xd8, 0xa2, 0x84, 0x9a, 0xf5, 0x50, 0x8e, 0x75, 0x18, 0x10, 0x02,
0x22, 0x36, 0x41, 0x3f, 0x01, 0x5f, 0xc2, 0x81, 0x7a, 0x04, 0x7e, 0x09, 0x07, 0xfa, 0x09, 0x0f,
0x02, 0x20, 0x36, 0xf3, 0xff, 0x81, 0xe7, 0x25, 0x0f, 0xb4, 0x23, 0xf0, 0x5f, 0xf2, 0x00, 0x2c,
0x01, 0x28, 0x76, 0x5d, 0xf3, 0x3a, 0x6c, 0xa7, 0x1a, 0x2d, 0x94, 0x5c, 0xb2, 0xd3, 0x8e, 0x12,
0x77, 0x72, 0xde, 0x09, 0xd8, 0xe1, 0xc1, 0x3a, 0x96, 0xc9, 0x79, 0x27, 0x89, 0x3b, 0x3a, 0xee,
0x28, 0x69, 0x47, 0x0b, 0x3b, 0xc0, 0x1a, 0xea, 0xb1, 0x1c, 0xd7, 0x14, 0x0f, 0x02, 0x28, 0x86,
0x13, 0xf8, 0xe3, 0x36, 0x6e, 0xff, 0xff, 0x81, 0x7f, 0xdc, 0xc6, 0x25, 0x08, 0x02, 0x0a, 0xa6,
0xc0, 0xff, 0xff, 0x4f, 0x0e, 0x14, 0x00, 0x22, 0x36, 0xc1, 0xff, 0x1f, 0x2e, 0x09, 0xcc, 0xb9,
0xa3, 0xa4, 0x92, 0x2d, 0x5a, 0x96, 0x53, 0x1d, 0xd6, 0x14, 0x36, 0x02, 0x28, 0x56, 0x93, 0x96,
0x24, 0x61, 0x89, 0x92, 0x4b, 0x96, 0x58, 0x42, 0x40, 0x52, 0x30, 0x09, 0x25, 0x96, 0x2c, 0xb9,
0x44, 0x09, 0x4b, 0x92, 0xb4, 0x8d, 0x03, 0x3a, 0xed, 0xc3, 0x9a, 0x24, 0xb7, 0x2c, 0xb1, 0x84,
0x12, 0x03, 0x92, 0x4a, 0x2c, 0xa1, 0xe4, 0x0e, 0x25, 0x97, 0x2c, 0x61, 0x89, 0x60, 0x92, 0x96,
0x04, 0x0a, 0x02, 0x20, 0x26, 0xc1, 0xff, 0xff, 0x25, 0xef, 0xff, 0x07, 0x4a, 0x02, 0x34, 0xe6,
0x17, 0x2f, 0xc9, 0xd2, 0xc1, 0x2c, 0x69, 0xb8, 0x05, 0x23, 0x8f, 0x6b, 0xf2, 0x34, 0x78, 0x9e,
0x9c, 0x1c, 0x56, 0xf0, 0x23, 0x27, 0x47, 0xc7, 0x0e, 0x90, 0xb3, 0x52, 0x47, 0x27, 0x67, 0x87,
0x8e, 0x4e, 0x12, 0x1d, 0x2a, 0x3b, 0x49, 0x56, 0x80, 0x9d, 0x24, 0x3b, 0x3a, 0x3b, 0x49, 0x76,
0x54, 0xe8, 0x24, 0xa1, 0x87, 0x4e, 0x12, 0x6a, 0xf0, 0xa8, 0x93, 0xa4, 0x96, 0x3a, 0x49, 0x2a,
0xc1, 0xc3, 0x4e, 0x12, 0x3b, 0x76, 0x02, 0x2b, 0x02, 0x28, 0x86, 0x13, 0x07, 0x74, 0xda, 0x87,
0x01, 0x39, 0x07, 0xec, 0xd8, 0x26, 0xa7, 0x36, 0x49, 0x68, 0xa3, 0x43, 0x9b, 0x9d, 0x6d, 0x96,
0x68, 0x43, 0x47, 0x1b, 0x4a, 0xb2, 0xa9, 0x93, 0x0d, 0x60, 0x3b, 0x97, 0x03, 0xb0, 0x0f, 0xd0,
0x3a, 0x2e, 0x01, 0x30, 0x01, 0x2a, 0x76, 0x5d, 0xc3, 0x75, 0x5a, 0xce, 0xf5, 0xd4, 0x62, 0x09,
0x25, 0x2c, 0x51, 0xe2, 0x60, 0x1d, 0x9d, 0x97, 0xe4, 0xbc, 0x04, 0x23, 0x87, 0x3b, 0x18, 0x39,
0x2f, 0x09, 0xcc, 0x79, 0x47, 0x89, 0x3b, 0x3b, 0x2d, 0x59, 0x72, 0x49, 0x35, 0x69, 0x2e, 0xa7,
0x75, 0xba, 0xe5, 0x00, 0x1d, 0x02, 0x26, 0x66, 0x73, 0xac, 0x87, 0x7e, 0x96, 0xd8, 0xa2, 0x84,
0x25, 0xd8, 0x49, 0xd2, 0x4e, 0x12, 0x96, 0x24, 0xb9, 0x25, 0x79, 0xf4, 0xb3, 0x9d, 0x02, 0x7f,
0x89, 0x07, 0x30, 0xe1, 0x2b, 0x77, 0x5d, 0xc3, 0x75, 0x5a, 0xce, 0xf5, 0x54, 0x72, 0x09, 0x9d,
0x76, 0x96, 0xb4, 0x04, 0x43, 0xe7, 0x1d, 0xc1, 0xde, 0x79, 0x49, 0x60, 0xce, 0x3b, 0x4a, 0xdc,
0xd9, 0x69, 0x87, 0x92, 0x4b, 0xaa, 0x49, 0x73, 0x39, 0xed, 0xf3, 0x3a, 0xbd, 0x85, 0x97, 0xf4,
0xca, 0x2f, 0x0c, 0x30, 0x02, 0x26, 0x56, 0x73, 0xac, 0x87, 0x7e, 0x96, 0x54, 0xa3, 0xe4, 0x12,
0xc1, 0x96, 0xb0, 0x24, 0x09, 0x3b, 0x4a, 0x6c, 0xd1, 0xcf, 0x7a, 0x28, 0xc7, 0x12, 0x02, 0x92,
0x3a, 0x40, 0x25, 0x94, 0xd8, 0xa1, 0xc4, 0x92, 0x25, 0x77, 0x96, 0x5c, 0xa2, 0x84, 0x1d, 0x25,
0x2c, 0x49, 0xd2, 0x12, 0x2c, 0x01, 0x26, 0x56, 0x59, 0xe3, 0x3a, 0x97, 0x53, 0xc0, 0xb2, 0xe4,
0x12, 0x0c, 0x9d, 0x76, 0x74, 0xbe, 0xe4, 0x5b, 0xbc, 0x87, 0xdb, 0xbc, 0x0d, 0xf7, 0x74, 0xcb,
0x97, 0x7c, 0x27, 0x49, 0x3b, 0x3a, 0xed, 0x28, 0xb9, 0x64, 0xcb, 0x9a, 0xf5, 0xd8, 0xa7, 0x35,
0x06, 0x0e, 0x00, 0x28, 0x56, 0x41, 0xd2, 0x87, 0x25, 0x1f, 0xf8, 0xff, 0xef, 0xf0, 0x0e, 0x03,
0x14, 0x02, 0x26, 0x66, 0x61, 0xff, 0xff, 0x8e, 0x3b, 0x49, 0x58, 0xa2, 0xe4, 0xce, 0x9a, 0x2d,
0xb4, 0x63, 0x1f, 0xd7, 0x18, 0x30, 0x00, 0x2c, 0x66, 0x13, 0x2e, 0xc9, 0xe1, 0x8e, 0x12, 0x97,
0x0c, 0xe6, 0xb8, 0x43, 0x09, 0x4b, 0x0a, 0xe6, 0xb0, 0x63, 0x89, 0x25, 0x07, 0x73, 0xec, 0xb0,
0x84, 0x92, 0x76, 0xe8, 0xb8, 0x43, 0xe7, 0xc1, 0x1c, 0x1d, 0xee, 0xe8, 0x74, 0xc0, 0xe3, 0x3d,
0x1f, 0xb0, 0xf0, 0x96, 0xde, 0x69, 0x4b, 0x00, 0x3c, 0xe6, 0x05, 0x9e, 0xc3, 0x0e, 0x3b, 0x02,
0x0e, 0x3b, 0x83, 0xd7, 0xb1, 0xc5, 0x0e, 0x1d, 0x5b, 0xec, 0xd4, 0xa1, 0x07, 0xa8, 0x43, 0x27,
0xf0, 0x53, 0xe8, 0xd8, 0xa1, 0xa2, 0xb3, 0x63, 0x67, 0x47, 0x67, 0xe7, 0x8e, 0x0a, 0x95, 0x15,
0x76, 0x54, 0xa8, 0xe8, 0xb0, 0xa3, 0x42, 0x27, 0x87, 0x9d, 0x1c, 0x3a, 0x39, 0xad, 0xa4, 0x58,
0x49, 0xc1, 0x70, 0x8d, 0x35, 0xae, 0x39, 0x98, 0xe5, 0x25, 0x2c, 0xe1, 0x12, 0x96, 0x70, 0x49,
0x3b, 0x06, 0x35, 0x00, 0x2a, 0x66, 0x25, 0x71, 0x67, 0x09, 0x4b, 0x96, 0x5c, 0x52, 0x40, 0x62,
0xa7, 0x92, 0x4b, 0xe8, 0xb4, 0x44, 0x49, 0x4b, 0x92, 0xbc, 0x4c, 0xf7, 0x74, 0x0d, 0xf0, 0x2d,
0x5e, 0xe3, 0x3d, 0xdc, 0xc6, 0x25, 0x3a, 0xee, 0x2c, 0x61, 0x09, 0x9d, 0x4b, 0x0a, 0x48, 0x2c,
0xa1, 0xe4, 0x12, 0x3a, 0x2d, 0x51, 0xe2, 0x12, 0x28, 0x00, 0x2a, 0x56, 0x93, 0x77, 0x94, 0xb4,
0x44, 0x49, 0x3b, 0x74, 0x58, 0x52, 0xe7, 0x80, 0x63, 0xc9, 0x9d, 0x3a, 0xec, 0x50, 0xd2, 0xce,
0x8e, 0x3b, 0x3a, 0xdc, 0xc9, 0xe1, 0x1e, 0xaf, 0xf1, 0x16, 0x5e, 0xc2, 0x03, 0xbf, 0xd3, 0x3b,
0x0d, 0x1a, 0x01, 0x26, 0x46, 0x81, 0x3d, 0xd9, 0xd3, 0x25, 0x78, 0x78, 0x49, 0x97, 0x78, 0x07,
0x2f, 0xde, 0xf1, 0x92, 0x2e, 0xf1, 0x8e, 0x97, 0x74, 0xa0, 0x3d, 0x01, 0x0b, 0xda, 0x4f, 0x98,
0xf2, 0x03, 0xff, 0xff, 0xff, 0xec, 0x2c, 0x1f, 0x1d, 0xf0, 0x9f, 0xe6, 0x04, 0x9e, 0xf3, 0xce,
0x3b, 0x1c, 0xfc, 0x73, 0xde, 0xe1, 0xce, 0x3b, 0xef, 0x70, 0xe7, 0x1d, 0xae, 0x60, 0x70, 0xe7,
0x9d, 0x77, 0xb8, 0xf3, 0x4e, 0x00, 0x0b, 0xd8, 0x4f, 0x98, 0xf2, 0x81, 0xff, 0xff, 0x7f, 0x76,
0x96, 0x1f, 0x18, 0x60, 0x1c, 0xf3, 0x58, 0x71, 0xc7, 0x25, 0x6c, 0x61, 0xcd, 0x95, 0xc0, 0x14,
0x2b, 0x3a, 0x74, 0x06, 0x14, 0x3a, 0x3a, 0x55, 0x54, 0xac, 0x04, 0x08, 0xe0, 0x21, 0xf1, 0x80,
0x9e, 0xf4, 0xf4, 0x00, 0x08, 0xa0, 0x52, 0xb1, 0x24, 0x29, 0xd0, 0xb1, 0x12, 0x86, 0x5e, 0x61,
0x1d, 0x01, 0xa0, 0x24, 0xd5, 0xc2, 0x36, 0xf5, 0x59, 0x42, 0x89, 0x8e, 0x01, 0x87, 0x3b, 0xb6,
0xa1, 0xcf, 0x72, 0xb0, 0xd1, 0xb1, 0xa3, 0x64, 0x8b, 0x76, 0xb6, 0x43, 0xc9, 0x0e, 0x22, 0x02,
0xa0, 0x36, 0xc1, 0xef, 0x70, 0x47, 0x49, 0x9d, 0x3c, 0xdb, 0xd1, 0xb2, 0x25, 0x89, 0x9d, 0x9c,
0x3b, 0x39, 0xf0, 0xb0, 0xe7, 0x4e, 0x12, 0x3b, 0x59, 0xb6, 0x64, 0x47, 0x27, 0xcf, 0x8e, 0x92,
0x02, 0x20, 0x01, 0xa0, 0x24, 0xd5, 0xd2, 0x32, 0xf5, 0xa1, 0x64, 0x89, 0x92, 0x3a, 0x3a, 0x77,
0x72, 0xae, 0x04, 0x74, 0xb8, 0xd3, 0x1d, 0xee, 0xdc, 0x49, 0x52, 0x07, 0x58, 0xb2, 0x8f, 0x65,
0xd8, 0x52, 0x25, 0x01, 0xa2, 0x36, 0x71, 0xe0, 0x3b, 0xdd, 0xb1, 0x44, 0x87, 0x72, 0xb6, 0xb3,
0x64, 0x8b, 0x92, 0x4a, 0x30, 0x74, 0xee, 0x60, 0x93, 0xc3, 0x0e, 0x86, 0xce, 0x1d, 0x25, 0x05,
0x24, 0x5b, 0xb6, 0x43, 0x39, 0x96, 0xe8, 0x04, 0x1e, 0x01, 0xa2, 0x24, 0xd9, 0xd2, 0x32, 0xd7,
0x29, 0x20, 0x59, 0x52, 0x09, 0x86, 0xce, 0x1d, 0x48, 0x7e, 0x92, 0x00, 0xdd, 0xe9, 0x92, 0x1b,
0xb4, 0x2c, 0xa1, 0x8f, 0x6d, 0xda, 0x52, 0x16, 0x00, 0x9a, 0xc6, 0x5c, 0x62, 0x4d, 0x3d, 0x95,
0xb0, 0xd3, 0x0e, 0xc0, 0x12, 0x03, 0x36, 0xdb, 0x14, 0xf8, 0x7f, 0x09, 0x4b, 0x0a, 0x2e, 0xc9,
0x63, 0x36, 0x55, 0xb2, 0x42, 0x39, 0xdb, 0x59, 0xb2, 0x45, 0x89, 0xc1, 0x1c, 0x9d, 0x3b, 0x49,
0x0e, 0xd6, 0xc9, 0x61, 0x30, 0x47, 0xe7, 0x8e, 0x12, 0x3b, 0x4b, 0xb6, 0x6c, 0x87, 0x72, 0x2c,
0x11, 0x70, 0xba, 0xb3, 0x71, 0xc9, 0x0e, 0x25, 0xf4, 0xb1, 0x4d, 0x5b, 0x0c, 0x15, 0x02, 0x9e,
0x36, 0xc1, 0xef, 0xbc, 0xb3, 0x64, 0x27, 0x8f, 0x76, 0xb2, 0x2c, 0x49, 0x52, 0x19, 0xf8, 0x9f,
0x7b, 0xee, 0x00, 0x0c, 0x02, 0x8a, 0x96, 0x58, 0xc9, 0x26, 0x85, 0x07, 0xfe, 0xff, 0x9d, 0x00,
0x13, 0xce, 0x53, 0x98, 0x74, 0xc0, 0xa9, 0x63, 0x85, 0x7f, 0xe0, 0xff, 0x7f, 0xa7, 0x0e, 0x25,
0x6a, 0xb4, 0xec, 0x10, 0x2a, 0x02, 0xa0, 0x26, 0xc1, 0xef, 0x70, 0xc7, 0x92, 0x9c, 0x4a, 0x74,
0x28, 0xd9, 0x59, 0x42, 0x47, 0x49, 0x9d, 0x24, 0x76, 0x72, 0x80, 0xcb, 0xdc, 0xc6, 0x3a, 0x95,
0xe8, 0xd4, 0x59, 0x42, 0x87, 0x92, 0x9d, 0x3a, 0x3b, 0x76, 0x74, 0x2c, 0xc9, 0xb9, 0x04, 0x08,
0x02, 0x8a, 0x96, 0xc0, 0xff, 0xff, 0xbf, 0x13, 0x1c, 0x02, 0xb4, 0xe4, 0x8f, 0x96, 0x4a, 0xe8,
0xe4, 0x51, 0x46, 0xf9, 0xc9, 0xb2, 0x67, 0x49, 0x92, 0x5a, 0x0a, 0x9e, 0x93, 0x73, 0xc7, 0x60,
0xff, 0x65, 0xee, 0x58, 0x02, 0x12, 0x02, 0x9e, 0x34, 0xcf, 0x92, 0x9d, 0x3c, 0xda, 0xc9, 0xb2,
0x24, 0x49, 0x65, 0xe0, 0x7f, 0xee, 0xb9, 0x03, 0x22, 0x01, 0xa4, 0x34, 0xd9, 0xe2, 0x36, 0xf7,
0xa9, 0x64, 0xcb, 0x12, 0x3b, 0x3b, 0x77, 0x76, 0x18, 0x6c, 0x27, 0xa7, 0x1d, 0x1d, 0x76, 0x74,
0xee, 0x2c, 0xb1, 0x43, 0xc9, 0x12, 0xfb, 0xdc, 0xc6, 0x2d, 0x06, 0x24, 0xca, 0x61, 0x36, 0x8f,
0x92, 0x3a, 0x79, 0xb6, 0xa3, 0x65, 0x4b, 0x92, 0x4a, 0x72, 0xee, 0xe4, 0x5c, 0x06, 0x86, 0x3d,
0x97, 0xb9, 0x93, 0xa4, 0x92, 0x2c, 0x5b, 0xb2, 0xa3, 0x9c, 0x1d, 0x25, 0x05, 0xbe, 0xc3, 0x01,
0x24, 0xc9, 0x63, 0x36, 0x55, 0xa2, 0x43, 0x39, 0xdb, 0x59, 0xb2, 0x45, 0x49, 0x25, 0x18, 0x3a,
0x77, 0xb0, 0xc9, 0x61, 0x07, 0x43, 0xe7, 0x8e, 0x92, 0x02, 0x92, 0x2d, 0xdb, 0xa1, 0x1c, 0x4b,
0x04, 0xbe, 0xd3, 0x9d, 0x00, 0x0e, 0x02, 0x94, 0xc4, 0x8e, 0x0a, 0x90, 0x03, 0x24, 0x93, 0xa4,
0xc0, 0xff, 0x1d, 0x03, 0x22, 0x01, 0xa0, 0x24, 0xd5, 0xc2, 0x36, 0xf5, 0x59, 0x42, 0x89, 0x8e,
0x1d, 0x1d, 0x2b, 0x4b, 0xb8, 0xc6, 0x65, 0xd8, 0xc6, 0x35, 0x2f, 0xc9, 0xb9, 0x93, 0xc4, 0x8e,
0x12, 0x4a, 0xf6, 0xa9, 0x0d, 0x5b, 0x0a, 0x12, 0x00, 0x96, 0xb5, 0x0c, 0x74, 0xee, 0x10, 0xb0,
0xc9, 0x86, 0xc0, 0x7f, 0xe7, 0x92, 0x5b, 0x6a, 0xb1, 0x24, 0x12, 0x01, 0xa0, 0x34, 0x61, 0xff,
0x27, 0xe7, 0x4e, 0x92, 0x4a, 0xb2, 0xa8, 0xd1, 0xce, 0x9e, 0x1c, 0x5a, 0x74, 0x21, 0x00, 0xa2,
0x14, 0x05, 0xe6, 0xdc, 0xd1, 0xb1, 0x64, 0x30, 0xa7, 0x0e, 0x9d, 0x2a, 0x56, 0x08, 0xe6, 0xd8,
0x59, 0x61, 0x45, 0x30, 0x87, 0x9d, 0x14, 0xc0, 0x35, 0x6e, 0x01, 0xb8, 0x84, 0x3b, 0x07, 0x34,
0x00, 0xb2, 0x94, 0xe5, 0x58, 0xb9, 0x93, 0x63, 0x07, 0x8f, 0x3a, 0x3a, 0x95, 0xd4, 0xd9, 0xa1,
0xa4, 0x0a, 0x9d, 0x35, 0x3b, 0x74, 0xf0, 0x63, 0x25, 0x65, 0xa7, 0xca, 0x4a, 0x0e, 0x7e, 0xa8,
0xd8, 0x49, 0x59, 0xc9, 0xb9, 0x66, 0xcf, 0x2d, 0xb5, 0xb0, 0x05, 0xa3, 0x96, 0x96, 0x18, 0xcc,
0x71, 0xe7, 0x4e, 0x01, 0x26, 0x00, 0xa2, 0x14, 0xe5, 0xdc, 0xd9, 0xa9, 0x43, 0xc9, 0x92, 0x3a,
0x3b, 0x96, 0x24, 0xb9, 0x4c, 0x6b, 0x5c, 0xf3, 0x12, 0x2e, 0x79, 0x8d, 0x7b, 0xd8, 0xc9, 0xb9,
0x44, 0xc7, 0xce, 0x80, 0x53, 0x67, 0x49, 0x25, 0x3a, 0x77, 0x02, 0x28, 0xc8, 0x63, 0x16, 0x13,
0x8c, 0x3b, 0x3a, 0x76, 0x96, 0x60, 0xd4, 0xa1, 0x43, 0x30, 0xc7, 0xce, 0x8e, 0x1d, 0xc1, 0x1c,
0x76, 0x72, 0xd8, 0x03, 0xb8, 0xc6, 0x2d, 0x00, 0x97, 0x70, 0xc0, 0xe9, 0x80, 0xc3, 0x25, 0x6e,
0x79, 0x09, 0x77, 0x1e, 0x0f, 0x01, 0x9e, 0x14, 0x41, 0xb2, 0x83, 0x5f, 0x5a, 0xe2, 0x8e, 0x3b,
0x2e, 0x69, 0xf9, 0x3f, 0x1d, 0xd0, 0x57, 0xb8, 0xb4, 0xc0, 0x8e, 0x25, 0x75, 0xee, 0x18, 0xf8,
0x9d, 0x3b, 0x76, 0x2a, 0xb1, 0x73, 0x09, 0xc0, 0x0e, 0xfc, 0xdc, 0x61, 0xe7, 0x0e, 0x4b, 0xee,
0xb4, 0x10, 0x09, 0xe2, 0x09, 0x97, 0xc0, 0xff, 0xff, 0xff, 0xa4, 0x00, 0x1c, 0xd0, 0x57, 0xb8,
0x64, 0xb4, 0x02, 0x61, 0x07, 0x3e, 0x77, 0x58, 0x61, 0x07, 0xb8, 0xe4, 0x8e, 0x25, 0x95, 0xd8,
0xb9, 0x02, 0x3f, 0x77, 0x00, 0x3b, 0x57, 0xd8, 0x60, 0x14, 0x39, 0xe8, 0x71, 0x51, 0xc2, 0x06,
0x35, 0x76, 0xb4, 0xa1, 0xa2, 0x24, 0x0b, 0xa0, 0x43, 0x1b, 0x15, 0x7b, 0xbc, 0x43, 0x00
};
