/**
 * Font: Roboto Medium Regular 25
 * Copyright: Copyright 2011 Google Inc. All Rights Reserved.
 * Charcodes: 0x20-0x7e
 */

#include <stdint.h>

#define FONT_ROBOTOM18_2_ASCENT 25
#define FONT_ROBOTOM18_2_DESCENT 7
#define FONT_ROBOTOM18_2_CAP_HEIGHT 18
#define FONT_ROBOTOM18_2_LINE_HEIGHT 32
#define FONT_ROBOTOM18_2_BOUNDINGBOX_LEFT -1
#define FONT_ROBOTOM18_2_BOUNDINGBOX_BOTTOM -6
#define FONT_ROBOTOM18_2_BOUNDINGBOX_WIDTH 23
#define FONT_ROBOTOM18_2_BOUNDINGBOX_HEIGHT 27

const uint8_t font_robotoM18_2[3196] =
{
0x00, 0x12, 0x00, 0x19, 0x00, 0x07, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x17, 0x00, 0x1b, 0x03, 0x05,
0x05, 0x05, 0x05, 0x02, 0x02, 0x01, 0x88, 0x36, 0x20, 0x03, 0x00, 0x00, 0x18, 0x0f, 0x01, 0x45,
0x1e, 0x02, 0xfc, 0x2d, 0x04, 0xea, 0x44, 0x27, 0x1c, 0x60, 0x21, 0x47, 0x02, 0x0d, 0x69, 0xc7,
0x20, 0x70, 0x5d, 0xe4, 0x08, 0x98, 0x43, 0x47, 0x0e, 0x8d, 0x04, 0x33, 0x01, 0x4e, 0x3e, 0xca,
0x09, 0x1d, 0x77, 0xec, 0x38, 0xf0, 0x39, 0xd4, 0x88, 0x35, 0x22, 0x27, 0xb6, 0x1f, 0xf9, 0x27,
0x74, 0xa8, 0xe3, 0x0e, 0x35, 0x62, 0x8d, 0xc8, 0x09, 0x73, 0x42, 0x17, 0xdb, 0x8f, 0xec, 0x07,
0x1d, 0x6a, 0xc4, 0x3a, 0xe4, 0x88, 0x35, 0x22, 0x27, 0xcc, 0x09, 0x1d, 0x77, 0xec, 0x28, 0x34,
0xe9, 0x0c, 0x3b, 0x2a, 0xc1, 0x44, 0x73, 0xe2, 0x7a, 0x06, 0xfd, 0x42, 0x2e, 0x73, 0xa1, 0x05,
0x79, 0x92, 0x45, 0x2d, 0xb2, 0x28, 0x95, 0x2c, 0x61, 0xbd, 0xb8, 0x36, 0x39, 0xb7, 0xb8, 0x1e,
0xcd, 0x33, 0xc5, 0x96, 0x17, 0xb5, 0x5a, 0x50, 0x8b, 0xbc, 0x72, 0x45, 0xfa, 0x09, 0xf9, 0x8c,
0x03, 0x1c, 0xae, 0x28, 0x3e, 0x01, 0x51, 0x4a, 0xe4, 0x09, 0xf7, 0xe1, 0x1c, 0x91, 0x23, 0x53,
0xe8, 0x42, 0x8d, 0xec, 0xa0, 0x0b, 0x35, 0xa2, 0x0b, 0x72, 0x44, 0x8e, 0xa4, 0x11, 0xfb, 0xd0,
0xc1, 0x3c, 0x91, 0x13, 0x00, 0xef, 0xf0, 0x1a, 0x49, 0x2b, 0xd8, 0x11, 0x37, 0x31, 0x27, 0x72,
0xec, 0xa8, 0x0e, 0x1d, 0xbb, 0x20, 0xc0, 0xb1, 0x8b, 0x39, 0x02, 0xd8, 0x41, 0x0d, 0xe4, 0x26,
0xaf, 0x15, 0x02, 0x39, 0x01, 0x4f, 0x42, 0x96, 0x2b, 0x58, 0x9f, 0xdc, 0xb2, 0x15, 0xd5, 0xc9,
0x4e, 0xaa, 0x8b, 0x9d, 0x54, 0x27, 0xf2, 0xb8, 0x95, 0x27, 0xd7, 0x26, 0xed, 0x45, 0xdb, 0x64,
0x1a, 0x5a, 0x2d, 0xd1, 0x49, 0xbc, 0xd0, 0x8a, 0x9c, 0x64, 0x41, 0xcb, 0x8b, 0x2c, 0xa8, 0x0d,
0x79, 0x42, 0xae, 0x50, 0xcb, 0xf2, 0xc9, 0xda, 0x27, 0xe4, 0x33, 0xb2, 0x02, 0x07, 0x69, 0xc3,
0x90, 0xeb, 0x02, 0x76, 0x04, 0x21, 0xd1, 0x48, 0x27, 0x2a, 0xa9, 0x8e, 0xba, 0x20, 0xf0, 0x9c,
0x50, 0x47, 0x79, 0x20, 0xd4, 0x09, 0xf6, 0xa0, 0x2e, 0x10, 0xea, 0xa4, 0x3c, 0xf0, 0x50, 0x1d,
0x76, 0x62, 0x17, 0xd5, 0x61, 0x49, 0x00, 0x22, 0xd0, 0x48, 0x27, 0x22, 0xd6, 0x61, 0x1e, 0x76,
0x52, 0x1d, 0x76, 0x52, 0x1e, 0xd5, 0x45, 0x9d, 0xd4, 0x02, 0x3d, 0xca, 0xa3, 0x16, 0x75, 0x52,
0x17, 0x78, 0xa0, 0x8e, 0x3a, 0x21, 0x0f, 0xea, 0x30, 0x31, 0x1a, 0x38, 0x6b, 0x2d, 0x08, 0x4c,
0x23, 0xac, 0x11, 0xea, 0x6c, 0xec, 0x6a, 0x2f, 0xd6, 0x0a, 0x73, 0x49, 0x79, 0xe4, 0x84, 0x0e,
0x75, 0x50, 0x32, 0xa3, 0x03, 0x14, 0x10, 0xae, 0x39, 0x2a, 0xb0, 0x5d, 0x38, 0x2f, 0x0c, 0xf0,
0x0f, 0xa9, 0x3e, 0x55, 0x0c, 0x6c, 0x5e, 0xb8, 0x2e, 0x0a, 0x0e, 0xe0, 0xe5, 0x18, 0xd2, 0xa1,
0x2e, 0xd2, 0x21, 0x0f, 0x9d, 0xa4, 0x63, 0x86, 0x00, 0x09, 0x30, 0x68, 0x20, 0x10, 0xf2, 0x45,
0xaa, 0x8a, 0x00, 0x08, 0x01, 0x85, 0x1c, 0x6c, 0x91, 0x16, 0x3a, 0x09, 0x20, 0xf0, 0x8a, 0x2a,
0xf0, 0xc3, 0x1d, 0xe7, 0x71, 0x17, 0xd6, 0x71, 0x8e, 0xdc, 0x85, 0x75, 0x9c, 0x23, 0x77, 0x61,
0x1d, 0xe7, 0xc8, 0x5d, 0x58, 0xc7, 0x39, 0x72, 0xc7, 0x75, 0xdc, 0xc9, 0x01, 0x26, 0x01, 0x4c,
0x3a, 0xd6, 0x93, 0xfa, 0x31, 0x57, 0x3d, 0xb4, 0xa0, 0x55, 0x27, 0xd4, 0x09, 0x8e, 0x17, 0xb5,
0xc0, 0xe6, 0x61, 0x0b, 0x1c, 0x2f, 0x6a, 0x75, 0x42, 0x9d, 0x64, 0x41, 0x2b, 0xe2, 0xaa, 0xc7,
0x7e, 0x54, 0x4f, 0x06, 0x12, 0x02, 0x48, 0x3a, 0xaa, 0x89, 0xb5, 0x22, 0x6e, 0xed, 0x3a, 0x89,
0x57, 0x0c, 0xec, 0x7f, 0x5e, 0x90, 0x17, 0x26, 0x00, 0x4e, 0x3a, 0xc8, 0x27, 0xd6, 0x2f, 0xe8,
0xd5, 0x63, 0x9e, 0xd0, 0x0a, 0x2d, 0xaa, 0x13, 0xa9, 0x54, 0x17, 0xce, 0x0b, 0x80, 0x5b, 0xd1,
0x3c, 0x41, 0x68, 0x2e, 0xd0, 0x68, 0x2d, 0xab, 0x2a, 0xe4, 0xbe, 0x88, 0xfb, 0x02, 0x2b, 0x00,
0x4d, 0x3a, 0xc8, 0x27, 0xd5, 0x0f, 0x5a, 0xd6, 0x43, 0x9e, 0xd0, 0x8a, 0x78, 0x14, 0x18, 0x2f,
0xda, 0xa2, 0x79, 0x62, 0x20, 0x9b, 0x5c, 0xf5, 0x70, 0x5e, 0xb4, 0x4e, 0xb2, 0xa8, 0x4e, 0xb2,
0x82, 0x3c, 0x49, 0xcb, 0x7a, 0xcc, 0x5f, 0x94, 0x4f, 0x06, 0x2e, 0x00, 0x4e, 0x3a, 0xd8, 0x8a,
0xe6, 0x8a, 0xf6, 0x82, 0x6d, 0x71, 0x6d, 0x71, 0xa7, 0x17, 0xe6, 0x11, 0x2f, 0xaa, 0x8b, 0x78,
0x51, 0x0b, 0x79, 0x41, 0x1d, 0xf3, 0x82, 0x4e, 0xe6, 0xc5, 0x3c, 0xc8, 0x0b, 0x81, 0xf4, 0x4f,
0x52, 0x55, 0x79, 0x46, 0x03, 0xe3, 0x85, 0xf3, 0x42, 0x28, 0x01, 0x4d, 0x3a, 0x04, 0xb2, 0x27,
0x5b, 0xaa, 0x1a, 0x02, 0xd3, 0x45, 0xf3, 0x70, 0x9e, 0x2f, 0xc8, 0x9f, 0x6c, 0x59, 0x2e, 0x40,
0x90, 0x40, 0x0b, 0xb7, 0x48, 0x27, 0xb5, 0xd0, 0x82, 0x5c, 0xc8, 0x65, 0xae, 0x98, 0xbb, 0xa8,
0x5c, 0x42, 0x2d, 0x01, 0x4d, 0x3a, 0x2a, 0x4f, 0x6e, 0x13, 0x7b, 0x1a, 0xb5, 0x84, 0x75, 0xd2,
0x16, 0xee, 0xcc, 0x15, 0x6b, 0x4f, 0xd4, 0x33, 0x57, 0xc4, 0x05, 0x09, 0x9e, 0x45, 0xbc, 0xa8,
0x45, 0x3a, 0xc1, 0x50, 0x0b, 0xad, 0x98, 0x27, 0x6a, 0x99, 0x0b, 0x6a, 0x17, 0xe6, 0x12, 0x02,
0x1d, 0x00, 0x4e, 0x3a, 0x02, 0xf8, 0x87, 0x80, 0x55, 0xe0, 0x59, 0xb8, 0x2e, 0xdc, 0xc2, 0x75,
0xe2, 0x16, 0xef, 0x04, 0x0f, 0xce, 0x0b, 0xb7, 0xc0, 0x83, 0xeb, 0xc4, 0xad, 0x38, 0x30, 0x01,
0x4c, 0x3a, 0xd6, 0x93, 0xfa, 0x31, 0x57, 0x3d, 0xb4, 0xa0, 0x55, 0x27, 0xe4, 0xd5, 0x09, 0x75,
0x91, 0x05, 0x79, 0x11, 0x4f, 0xd4, 0x62, 0xee, 0xa0, 0x3e, 0x99, 0xab, 0x5c, 0xa4, 0x13, 0xf2,
0x02, 0xc7, 0x8b, 0x5a, 0x9e, 0x90, 0x27, 0x79, 0xe5, 0x8a, 0xf4, 0x13, 0xf2, 0xc9, 0x00, 0x2d,
0x01, 0x4c, 0x3a, 0xe6, 0x8b, 0xda, 0xc9, 0x5e, 0xad, 0x48, 0x0b, 0x5a, 0xc4, 0x0b, 0xf2, 0x5a,
0x54, 0xe7, 0xc2, 0x4e, 0x4f, 0xa8, 0xb3, 0x15, 0x6a, 0x49, 0xdc, 0x13, 0xf9, 0xec, 0xa4, 0x42,
0x5e, 0xb0, 0x05, 0xeb, 0xe4, 0x5a, 0x54, 0xbe, 0xa0, 0xb6, 0xa8, 0xce, 0x28, 0x0e, 0x01, 0xc5,
0x1d, 0xec, 0x24, 0x2d, 0x74, 0xd2, 0x7f, 0x27, 0x69, 0xa1, 0x93, 0x00, 0x13, 0xe0, 0x45, 0x1a,
0xac, 0x8b, 0x78, 0xa2, 0x8b, 0xfe, 0x03, 0xb9, 0xd0, 0x45, 0xba, 0x88, 0x87, 0x2e, 0xa4, 0x08,
0x17, 0x08, 0x8b, 0x35, 0x5a, 0xc3, 0xb5, 0x28, 0x37, 0xe6, 0x26, 0xda, 0x0c, 0x5a, 0x72, 0x4f,
0xce, 0x2d, 0xcc, 0x4d, 0xac, 0x07, 0xeb, 0x78, 0x0f, 0x21, 0x0c, 0x39, 0x10, 0xf2, 0x17, 0x01,
0xae, 0xf0, 0x07, 0xf2, 0x17, 0x01, 0xae, 0x08, 0x19, 0x09, 0x8c, 0xb5, 0xc4, 0x75, 0xc6, 0xb5,
0x85, 0xe5, 0x26, 0x97, 0x4f, 0x98, 0x0b, 0xcb, 0x07, 0xb9, 0xc9, 0xbe, 0xa0, 0x96, 0x61, 0x8d,
0xf4, 0x01, 0x21, 0x00, 0x4c, 0x32, 0xe6, 0x93, 0xfa, 0x31, 0x10, 0x97, 0x68, 0x41, 0x0b, 0x9d,
0x10, 0x60, 0xd1, 0x16, 0x6c, 0x05, 0xc2, 0x2d, 0xb9, 0x16, 0xcc, 0x0b, 0xe6, 0xd1, 0x3f, 0x8f,
0xb6, 0x82, 0x75, 0x14, 0x5a, 0xd1, 0xf5, 0x5a, 0x2e, 0x9f, 0xf1, 0xfc, 0x0b, 0xb6, 0xc4, 0x3c,
0xb1, 0x85, 0xbb, 0x20, 0x0f, 0xee, 0xa0, 0xa3, 0x5c, 0x31, 0x27, 0xe4, 0xc8, 0xfa, 0x64, 0x87,
0x0e, 0x3a, 0x91, 0x23, 0x3b, 0x12, 0xc8, 0x31, 0x27, 0xe6, 0x10, 0x47, 0x10, 0x76, 0x31, 0x87,
0x38, 0xb2, 0x83, 0x2e, 0xe6, 0x80, 0xff, 0x10, 0x27, 0xd4, 0x41, 0x07, 0x1d, 0x71, 0x42, 0x20,
0x1d, 0x6b, 0x24, 0x8e, 0xec, 0x24, 0x2d, 0x76, 0x91, 0x8e, 0x7d, 0x9e, 0x27, 0x3b, 0xc8, 0x13,
0xb9, 0x82, 0x2e, 0x7c, 0x1d, 0x80, 0xdf, 0x12, 0x93, 0xe7, 0x5e, 0x70, 0x6e, 0xc6, 0x01, 0x89,
0x2a, 0x41, 0x35, 0x00, 0x51, 0x46, 0xac, 0x45, 0xe7, 0x0a, 0xee, 0xc9, 0x6b, 0xe3, 0x79, 0x5e,
0xb8, 0x93, 0x2c, 0x5a, 0x17, 0xf1, 0x68, 0x0b, 0x75, 0xc2, 0x4e, 0xb6, 0x38, 0x2f, 0xe6, 0x85,
0x2d, 0xa8, 0x93, 0x6a, 0x1f, 0xe5, 0xbe, 0xa0, 0x55, 0x55, 0x2e, 0xd6, 0xc9, 0x2d, 0xb6, 0x60,
0x9e, 0x68, 0xc1, 0x5a, 0xc4, 0x93, 0xb6, 0x02, 0x2f, 0x01, 0x4e, 0x42, 0xf2, 0x33, 0xe8, 0x4f,
0xb6, 0x2a, 0x5f, 0x68, 0x51, 0x82, 0x59, 0x68, 0x61, 0x0b, 0x2d, 0xaa, 0x85, 0x16, 0xd4, 0x0a,
0xfd, 0xc5, 0xfe, 0x64, 0xab, 0xaa, 0x25, 0x5a, 0xd8, 0x42, 0xe0, 0x59, 0x98, 0x17, 0x59, 0xd8,
0x8a, 0xac, 0x2a, 0x1f, 0xda, 0xc7, 0xf6, 0x62, 0x26, 0x01, 0x4f, 0x42, 0x28, 0x5f, 0xdc, 0x1e,
0xf5, 0xd4, 0xc7, 0x5c, 0x94, 0x27, 0x5a, 0xdc, 0x22, 0x9d, 0xdc, 0x0a, 0xec, 0x79, 0xf1, 0x3a,
0xb9, 0x15, 0x59, 0xdc, 0x42, 0x2e, 0xca, 0x93, 0x3d, 0xf5, 0x51, 0x7b, 0x5c, 0xbe, 0x20, 0x2a,
0x01, 0x4f, 0x42, 0xb2, 0x33, 0x6c, 0x4f, 0x6a, 0x95, 0x3e, 0x68, 0x51, 0x4b, 0xb6, 0xb0, 0xc5,
0x16, 0xe6, 0x09, 0x76, 0x68, 0x71, 0x0b, 0x2d, 0xac, 0x85, 0x16, 0xe6, 0x89, 0x16, 0xb6, 0xd8,
0xa2, 0x96, 0x6c, 0x95, 0x3e, 0x68, 0x4f, 0x6a, 0x67, 0x14, 0x1b, 0x01, 0x4d, 0x3a, 0x10, 0xb2,
0x2f, 0xb2, 0x80, 0x15, 0x02, 0xb6, 0x70, 0x80, 0x3f, 0xb6, 0xaa, 0x2a, 0x06, 0xdc, 0xc2, 0x2d,
0x60, 0x85, 0xf6, 0x45, 0xf6, 0x05, 0x16, 0x01, 0x4d, 0x3a, 0x02, 0xd8, 0x87, 0x16, 0xb0, 0x42,
0xc0, 0x2d, 0x1c, 0xe0, 0x8f, 0xad, 0xaa, 0x8a, 0x01, 0x6f, 0xe1, 0x16, 0x0d, 0x31, 0x01, 0x4f,
0x46, 0x28, 0x9f, 0xdc, 0x5e, 0xd0, 0x53, 0x1f, 0x73, 0x51, 0x2e, 0xb4, 0xb8, 0x45, 0x5a, 0x9c,
0x4a, 0x3c, 0xc1, 0xe2, 0x79, 0xb1, 0xbe, 0xbc, 0x58, 0x5f, 0x9e, 0x50, 0x20, 0xb5, 0x38, 0x2f,
0xb2, 0xc2, 0xbc, 0x48, 0x0b, 0x5b, 0xa1, 0xa7, 0xf9, 0x62, 0xee, 0x85, 0xf9, 0x8c, 0x01, 0x13,
0x01, 0x4f, 0x4a, 0xb0, 0x8f, 0x2c, 0xd8, 0x02, 0x90, 0xff, 0xc8, 0xaa, 0xaa, 0x04, 0xfb, 0x2d,
0xb2, 0x60, 0x0b, 0x09, 0x01, 0x45, 0x1e, 0x02, 0xfc, 0xff, 0x2d, 0xb4, 0x08, 0x18, 0x00, 0x4d,
0x3a, 0x1a, 0xf0, 0xdf, 0xc2, 0x2d, 0x54, 0xd8, 0x22, 0x9d, 0xd4, 0x42, 0x0b, 0x72, 0xa1, 0xa7,
0xae, 0xd8, 0x4f, 0xaa, 0x27, 0x04, 0x34, 0x01, 0x4f, 0x42, 0xb2, 0x30, 0x17, 0x5a, 0x54, 0x2b,
0xb4, 0xa0, 0x56, 0x6c, 0x41, 0x4b, 0x68, 0xb1, 0x47, 0x2d, 0xe4, 0xc2, 0x16, 0x71, 0x71, 0xab,
0x15, 0xb7, 0x8b, 0xfb, 0x71, 0xcf, 0x25, 0xb6, 0x44, 0x2b, 0x6a, 0x31, 0x17, 0xb5, 0xa0, 0x07,
0x2d, 0x6a, 0xc5, 0x16, 0xd5, 0x62, 0x0b, 0x7b, 0x68, 0x71, 0x4b, 0x0d, 0x01, 0x4c, 0x3a, 0x02,
0xfc, 0x7f, 0x8b, 0xb6, 0x80, 0x15, 0x80, 0xec, 0x03, 0x4e, 0x01, 0x54, 0x5a, 0xf2, 0x70, 0x0f,
0xbd, 0x60, 0x3e, 0xf4, 0x84, 0x6d, 0x68, 0xe3, 0xda, 0xd0, 0x16, 0xe6, 0x86, 0xce, 0x85, 0x9d,
0x0b, 0x9d, 0x1e, 0xd5, 0xb5, 0xd0, 0x49, 0x4e, 0xc8, 0x23, 0x0b, 0x9d, 0x64, 0x41, 0x27, 0x59,
0x68, 0x91, 0x2e, 0xd4, 0x01, 0xd0, 0x42, 0x27, 0x10, 0x5a, 0xc8, 0x43, 0x17, 0x00, 0x2d, 0xd4,
0xe5, 0xb1, 0x85, 0x16, 0xdb, 0x64, 0x0b, 0x2d, 0xe6, 0x8b, 0x2d, 0xb4, 0xa0, 0x07, 0x2d, 0xb4,
0xa0, 0x25, 0xb4, 0xd0, 0x82, 0x3a, 0x6a, 0x11, 0x37, 0x01, 0x4f, 0x4a, 0xb2, 0x60, 0x8b, 0x3c,
0x6e, 0x91, 0x17, 0x18, 0x6c, 0x91, 0x4d, 0x6a, 0x91, 0x2f, 0x68, 0x91, 0xd5, 0x82, 0x00, 0x8b,
0x78, 0xb2, 0x45, 0x16, 0x5a, 0x6c, 0x91, 0x85, 0x5a, 0x68, 0x91, 0xc5, 0x56, 0x00, 0xb2, 0x20,
0xc0, 0x22, 0x0b, 0x12, 0xcc, 0x47, 0x16, 0xd5, 0x46, 0x16, 0x26, 0x98, 0x47, 0x16, 0xd7, 0x02,
0x2c, 0x01, 0x4f, 0x46, 0x28, 0x5f, 0x9c, 0x3f, 0xea, 0xa9, 0x8f, 0xb5, 0xa8, 0x25, 0x5a, 0x61,
0x8b, 0xb4, 0x38, 0x4f, 0x4f, 0x2e, 0x70, 0x5b, 0x5e, 0xb0, 0xe5, 0xc9, 0xb5, 0x5a, 0x9c, 0x27,
0x59, 0xdc, 0x42, 0x2e, 0xca, 0x93, 0x3d, 0xf5, 0x51, 0xfe, 0xb8, 0x7c, 0x41, 0x25, 0x01, 0x4f,
0x42, 0xb2, 0x17, 0xb5, 0x0f, 0x5a, 0x55, 0x3e, 0xb6, 0xb0, 0x25, 0x5a, 0x58, 0x60, 0x16, 0x5a,
0xdc, 0x42, 0x0b, 0x6b, 0xa1, 0x45, 0xb5, 0x42, 0xff, 0xd8, 0x9f, 0xd0, 0xaa, 0x2a, 0x0c, 0xb8,
0x05, 0xb7, 0x78, 0x34, 0xe9, 0xaf, 0x46, 0x28, 0x97, 0x71, 0x7b, 0xd4, 0x53, 0x1f, 0x73, 0x51,
0x4b, 0xb4, 0xb8, 0x45, 0x3a, 0x39, 0x2f, 0x2f, 0xae, 0xd3, 0x03, 0x09, 0xf6, 0x81, 0x13, 0x6c,
0x79, 0x71, 0xad, 0x4e, 0xce, 0x93, 0x2c, 0x6e, 0x21, 0x17, 0xb5, 0x64, 0x4f, 0x7d, 0xd4, 0x1e,
0x97, 0x3b, 0xb8, 0x17, 0xcf, 0x0b, 0xae, 0x08, 0x33, 0x01, 0x4f, 0x42, 0xf2, 0x33, 0xea, 0x4f,
0x68, 0x55, 0x3e, 0xd9, 0xa2, 0x5a, 0x6c, 0x61, 0x0b, 0x3c, 0xa1, 0x85, 0x79, 0xa1, 0x85, 0x2d,
0xb6, 0xa0, 0x96, 0x6c, 0x1f, 0xb4, 0x27, 0xb5, 0xaa, 0x25, 0xb5, 0xa0, 0x45, 0x2d, 0xc8, 0x05,
0x2d, 0x6a, 0xc5, 0x16, 0xd5, 0x62, 0x0b, 0x5b, 0xa1, 0x85, 0xb5, 0x08, 0x30, 0x00, 0x4f, 0x3e,
0x28, 0x9f, 0xdc, 0x5e, 0xd0, 0x53, 0x1f, 0x6b, 0x51, 0x2e, 0xe4, 0x89, 0x2d, 0xd4, 0x89, 0x55,
0x6c, 0xc9, 0xf3, 0x19, 0xad, 0x4f, 0x9a, 0x5f, 0xb4, 0x7c, 0xf1, 0x5c, 0x48, 0xe5, 0x16, 0x5a,
0xdc, 0x42, 0x2e, 0xaa, 0xc5, 0x9e, 0xe9, 0x12, 0xda, 0x13, 0xcb, 0x67, 0x0c, 0x10, 0x00, 0x4f,
0x3e, 0x90, 0xf6, 0x93, 0x54, 0xb5, 0xac, 0x0a, 0x03, 0xfe, 0xdf, 0x82, 0x5b, 0x18, 0x16, 0x01,
0x4e, 0x42, 0xf0, 0xfe, 0xaf, 0x13, 0x6b, 0xb5, 0x30, 0x4f, 0xb2, 0xa4, 0x56, 0xa4, 0xa7, 0x2e,
0x59, 0x3f, 0x31, 0x9f, 0x31, 0x33, 0x00, 0x50, 0x42, 0x17, 0xcc, 0xd5, 0x82, 0xad, 0xc8, 0x8a,
0x5b, 0xc8, 0x13, 0xf3, 0x64, 0x0b, 0x5b, 0xb1, 0x15, 0xb5, 0xa0, 0x4e, 0xc8, 0x93, 0x5a, 0xd0,
0x8a, 0x5a, 0xb1, 0x85, 0x75, 0xa2, 0x4e, 0x6e, 0xa1, 0x05, 0xf3, 0xd0, 0x82, 0x75, 0x76, 0xd2,
0x3e, 0x9c, 0x1b, 0xae, 0x17, 0xef, 0xc1, 0xb9, 0x30, 0x55, 0x00, 0x56, 0xda, 0x16, 0xd5, 0x49,
0x79, 0x91, 0x45, 0xb9, 0xa8, 0x85, 0x16, 0xf5, 0xa8, 0x85, 0xbc, 0xa0, 0x17, 0x74, 0xa2, 0x4e,
0xd6, 0x93, 0x75, 0xb2, 0xc5, 0x3c, 0x8f, 0x79, 0xb1, 0xc5, 0xce, 0x8e, 0x2d, 0xc8, 0x63, 0x17,
0x39, 0xb6, 0xa0, 0x2e, 0xd2, 0xa1, 0x0b, 0x9d, 0xd4, 0x49, 0x3c, 0xe4, 0x48, 0xba, 0xa8, 0x45,
0x4e, 0xd4, 0x11, 0x0f, 0x5b, 0xe4, 0x62, 0x47, 0x16, 0xe6, 0x79, 0xd0, 0x79, 0x62, 0x6d, 0x90,
0x2f, 0xee, 0x09, 0xf5, 0x60, 0x2f, 0xea, 0xc1, 0x5c, 0xd8, 0x83, 0xb5, 0x30, 0x4f, 0x08, 0x32,
0x00, 0x50, 0x42, 0xb2, 0xc2, 0x5c, 0xa8, 0x85, 0xad, 0x18, 0xc8, 0x12, 0x6a, 0xb1, 0x16, 0xe6,
0x42, 0x4b, 0x6e, 0xe5, 0x82, 0xf5, 0x45, 0xdb, 0xc4, 0x81, 0xf4, 0x78, 0x1f, 0xcd, 0x2f, 0xd8,
0xaa, 0xc5, 0x2d, 0xd1, 0x92, 0x6a, 0xb1, 0x16, 0xb5, 0x84, 0x5c, 0xcc, 0x85, 0xad, 0xd0, 0x0a,
0x73, 0x11, 0x26, 0x00, 0x50, 0x3e, 0x17, 0xe7, 0x42, 0x8b, 0x5b, 0x21, 0x4f, 0xca, 0x05, 0x2d,
0x6a, 0x05, 0x79, 0xb2, 0x16, 0xb6, 0xd8, 0xe2, 0x3c, 0x49, 0x27, 0x6c, 0x91, 0x45, 0x6b, 0x13,
0xb7, 0xf1, 0x5a, 0xc2, 0x01, 0x6f, 0xd1, 0x2d, 0x0e, 0x1e, 0x00, 0x4f, 0x3e, 0x02, 0xd8, 0x0f,
0x01, 0x2b, 0xc1, 0xcf, 0x12, 0xe7, 0xe2, 0x2d, 0x1e, 0xf8, 0xb3, 0xc2, 0xb9, 0x70, 0x2d, 0xde,
0x0a, 0xe7, 0x02, 0x56, 0x01, 0xd0, 0x7e, 0x04, 0x10, 0xe1, 0x06, 0x1f, 0x90, 0x9e, 0x9d, 0x11,
0xb0, 0xff, 0x7f, 0x9d, 0xa8, 0x33, 0x02, 0xd2, 0x13, 0x24, 0xf0, 0x8b, 0x2a, 0x2f, 0xd8, 0x09,
0x5b, 0xb0, 0x2e, 0xd8, 0x82, 0x79, 0xb0, 0x4e, 0xd8, 0x82, 0x79, 0xc1, 0x4e, 0xd8, 0x82, 0x75,
0xc1, 0x16, 0xcc, 0x83, 0x75, 0xc2, 0x16, 0xcc, 0x8b, 0xeb, 0x84, 0x2d, 0x98, 0x17, 0x0f, 0xe0,
0x06, 0x1f, 0xc0, 0x46, 0x0a, 0xf8, 0xff, 0xb7, 0xd8, 0x22, 0xb5, 0x00, 0x64, 0x23, 0x18, 0x48,
0x2b, 0x2d, 0xe8, 0xe4, 0x5a, 0x9c, 0x2b, 0x6c, 0xa3, 0x3c, 0x72, 0xd4, 0x45, 0x4e, 0xd6, 0xa1,
0x8e, 0x9d, 0xec, 0x42, 0x17, 0xf3, 0x08, 0x09, 0xe8, 0x6c, 0x2c, 0xc0, 0x3e, 0x02, 0x5c, 0x45,
0x00, 0x0a, 0x78, 0x87, 0x20, 0xb2, 0x82, 0x16, 0xd4, 0x09, 0x39, 0x12, 0x86, 0x7c, 0x61, 0x22,
0x01, 0xac, 0x39, 0xe6, 0x0b, 0xea, 0xc7, 0x56, 0xb5, 0x24, 0x5d, 0xd0, 0xa2, 0x2d, 0x96, 0x3b,
0xe4, 0x1e, 0x71, 0x41, 0x8b, 0x2c, 0x6a, 0x91, 0x05, 0xb5, 0x88, 0xab, 0x7c, 0xe8, 0x8f, 0xb9,
0x24, 0x5e, 0x21, 0x01, 0x6d, 0x3a, 0xb0, 0xd7, 0x45, 0xeb, 0xea, 0xc5, 0xda, 0x13, 0xf5, 0xec,
0xa1, 0x16, 0xe4, 0x09, 0xde, 0x91, 0x2e, 0x6a, 0x91, 0x16, 0xe4, 0x49, 0x7a, 0xf6, 0x50, 0x7b,
0xa1, 0x8e, 0xf4, 0x62, 0x1e, 0x00, 0xad, 0x35, 0xc8, 0x17, 0xf6, 0x83, 0x5e, 0x2d, 0x91, 0x27,
0xb4, 0xd0, 0xa2, 0x52, 0x04, 0xb4, 0x70, 0x0b, 0x2b, 0xe4, 0x09, 0x2d, 0xf6, 0x6a, 0x09, 0xfd,
0x30, 0x5f, 0x0c, 0x22, 0x00, 0x6d, 0x3a, 0xb0, 0x47, 0xeb, 0x84, 0x5c, 0x75, 0xa2, 0xf6, 0x44,
0xaf, 0x9e, 0xc4, 0x13, 0x12, 0xbc, 0x3b, 0xc9, 0xa2, 0x3a, 0x89, 0x27, 0xe4, 0x89, 0x5e, 0x3d,
0x51, 0x7b, 0x42, 0xae, 0xc8, 0x09, 0x1d, 0x01, 0xac, 0x35, 0xd6, 0x93, 0xfa, 0xb1, 0x57, 0x8f,
0x74, 0x42, 0x1e, 0xf1, 0xa8, 0x2e, 0xc0, 0x3e, 0x41, 0x56, 0xb0, 0x16, 0x15, 0x7b, 0xd6, 0x62,
0x3f, 0xa1, 0x9e, 0x21, 0x17, 0x00, 0x69, 0x26, 0x28, 0x4f, 0xd6, 0xc6, 0x96, 0x85, 0x5a, 0x60,
0xa8, 0x4e, 0xd6, 0x8e, 0xb4, 0x63, 0x82, 0xfd, 0x3b, 0xa9, 0x4e, 0x06, 0x2c, 0xd9, 0x4c, 0x3a,
0xe6, 0x92, 0x9c, 0xa4, 0x3d, 0xc9, 0xab, 0xa7, 0x0b, 0xf2, 0x5c, 0x41, 0xe0, 0xea, 0x5c, 0x54,
0xe7, 0x0a, 0xea, 0x6c, 0x41, 0x9e, 0xe4, 0xd5, 0x93, 0xb4, 0x27, 0x73, 0xd5, 0x09, 0xeb, 0x24,
0x49, 0xad, 0xc8, 0x2a, 0x1f, 0xf2, 0x47, 0xf9, 0x62, 0x17, 0x01, 0x6c, 0x3a, 0xb0, 0xe7, 0x05,
0xf3, 0x22, 0xae, 0x90, 0x7b, 0x12, 0x9f, 0x3d, 0xe2, 0x82, 0x16, 0xf8, 0xfe, 0xf2, 0x82, 0xbc,
0x00, 0x0b, 0x01, 0x64, 0x1a, 0xea, 0x6c, 0x91, 0x0b, 0x06, 0xfa, 0xbf, 0x4e, 0x13, 0xdf, 0x06,
0x1b, 0x58, 0x17, 0xf2, 0x64, 0x17, 0x1e, 0xd8, 0xff, 0xeb, 0x44, 0x9d, 0xb9, 0xda, 0xc8, 0x12,
0x01, 0x2c, 0x01, 0x6d, 0x36, 0xb0, 0xd7, 0x49, 0xeb, 0x64, 0x2d, 0xd4, 0x89, 0x5a, 0xa1, 0x4e,
0xb4, 0x62, 0x9d, 0x64, 0x05, 0x75, 0x2e, 0xa9, 0x3e, 0xac, 0x4f, 0xaa, 0x1d, 0xd5, 0x49, 0x5a,
0x50, 0x27, 0xf2, 0x64, 0x9d, 0x6c, 0x85, 0x3a, 0x59, 0x0b, 0x75, 0x42, 0x2e, 0x02, 0x07, 0x01,
0x64, 0x1a, 0xd0, 0xff, 0x7f, 0x9d, 0x22, 0x01, 0xb4, 0xd9, 0xae, 0x5c, 0xa1, 0x5e, 0xa8, 0x3d,
0xfd, 0x22, 0xbd, 0xfa, 0xf2, 0x91, 0x4e, 0xe8, 0x81, 0x7f, 0xa0, 0x45, 0xba, 0x20, 0x2f, 0xf0,
0xdf, 0x07, 0x79, 0xa4, 0x0b, 0xf2, 0x82, 0x3c, 0x02, 0x14, 0x01, 0xac, 0x39, 0x2f, 0xe2, 0x0a,
0x79, 0x7e, 0x12, 0x9f, 0x3d, 0xe2, 0x82, 0x16, 0xf8, 0xfe, 0xf2, 0x82, 0xbc, 0x00, 0x23, 0x00,
0xae, 0x39, 0xa8, 0x27, 0xf7, 0x0b, 0x7a, 0xe5, 0x62, 0x2d, 0xc8, 0x13, 0x0c, 0x5a, 0xd8, 0x42,
0x0b, 0xf3, 0xd0, 0xc2, 0x16, 0x5a, 0x51, 0x0b, 0xb5, 0x20, 0x4f, 0xf6, 0xca, 0x45, 0xfd, 0xc2,
0x7a, 0x42, 0x21, 0xd9, 0x4d, 0xba, 0xae, 0x5e, 0xac, 0xbd, 0x50, 0xaf, 0x1e, 0xea, 0x84, 0x3c,
0xc1, 0x3b, 0xd2, 0x45, 0x2d, 0xd2, 0x09, 0x79, 0x92, 0x5e, 0xb9, 0x50, 0x7b, 0xa1, 0xae, 0x5e,
0x0c, 0xec, 0xba, 0x68, 0x22, 0xd8, 0x4d, 0x3a, 0xc8, 0x15, 0x39, 0x51, 0x7b, 0xa2, 0x57, 0x4f,
0xe2, 0x09, 0x09, 0xde, 0x9d, 0x64, 0x51, 0x9d, 0xc4, 0x13, 0xf2, 0x44, 0xaf, 0x9e, 0xa8, 0x3d,
0x21, 0x57, 0x60, 0xd7, 0x49, 0xeb, 0x04, 0x0f, 0x01, 0xa8, 0xa5, 0xae, 0x0e, 0xa4, 0xbe, 0x5a,
0xb1, 0x4e, 0xb0, 0x1f, 0xd4, 0x05, 0x01, 0x22, 0x00, 0xac, 0x35, 0x96, 0xcb, 0x20, 0x77, 0xa2,
0x56, 0xb5, 0x22, 0x5e, 0xac, 0x93, 0x78, 0xd2, 0x36, 0xc3, 0xfc, 0xc2, 0xf2, 0x05, 0x6b, 0x91,
0x45, 0x2d, 0xe2, 0x8a, 0xb4, 0x44, 0xfe, 0xa0, 0x7c, 0x21, 0x15, 0x00, 0x08, 0x22, 0x04, 0xe2,
0x51, 0x1e, 0x03, 0xec, 0x44, 0x2b, 0x08, 0xf4, 0x3c, 0xca, 0x0b, 0x72, 0x15, 0x7b, 0xb2, 0x96,
0x13, 0x01, 0xac, 0x39, 0xf0, 0xfd, 0x79, 0x41, 0x5e, 0x9d, 0xd0, 0x8a, 0x2c, 0xf3, 0x45, 0xdc,
0x0b, 0xf5, 0xea, 0x02, 0x24, 0x00, 0xad, 0x31, 0x2f, 0x6a, 0xa1, 0x05, 0x75, 0xa2, 0x05, 0x2d,
0xd6, 0xc5, 0x16, 0x74, 0xa2, 0x2e, 0x68, 0x21, 0x8f, 0xea, 0x22, 0x27, 0x76, 0x76, 0x61, 0x9e,
0xc7, 0xf5, 0x84, 0xbd, 0x60, 0x2e, 0x5a, 0x27, 0x05, 0x38, 0x00, 0xb3, 0xcd, 0x2e, 0xe8, 0x84,
0x16, 0x3a, 0x59, 0x0b, 0x3a, 0xd1, 0x62, 0x2e, 0xd6, 0x85, 0x3c, 0xf6, 0x42, 0x1e, 0xeb, 0x42,
0xe7, 0xa1, 0x05, 0x9d, 0xc4, 0xeb, 0xd0, 0x09, 0x2d, 0x10, 0x72, 0x75, 0x41, 0x1e, 0x39, 0xe4,
0xe8, 0x61, 0x1b, 0x6a, 0xc3, 0x9e, 0xec, 0x85, 0xb9, 0x20, 0x17, 0xd7, 0x82, 0x5a, 0xb0, 0x93,
0x3a, 0x21, 0x24, 0x00, 0xad, 0x35, 0xb2, 0x20, 0x17, 0xf2, 0x64, 0x0b, 0x5a, 0xc8, 0x0b, 0x6a,
0xb5, 0x30, 0x37, 0xd8, 0x13, 0xe6, 0xa2, 0x3d, 0xb9, 0x2f, 0xaa, 0x93, 0x2c, 0x6a, 0x21, 0x30,
0x9e, 0x6c, 0x45, 0x5a, 0x50, 0x8b, 0x00, 0x2b, 0xd8, 0x4c, 0x32, 0x4f, 0xa8, 0xd5, 0x82, 0xbc,
0xc8, 0x82, 0x16, 0xf2, 0x42, 0x9d, 0x6c, 0x21, 0x2f, 0xb6, 0xd0, 0x82, 0xba, 0xc8, 0x49, 0xad,
0x2e, 0xea, 0xc3, 0x7a, 0x72, 0x0f, 0xe6, 0x82, 0x75, 0xc2, 0x3c, 0xda, 0xc2, 0x72, 0x85, 0x3d,
0x39, 0x4f, 0x0e, 0x17, 0x01, 0xab, 0x35, 0xc0, 0x5f, 0x55, 0x25, 0x60, 0x71, 0x2b, 0xcc, 0x13,
0x04, 0x6b, 0x71, 0x2b, 0x6c, 0x89, 0xb9, 0xaa, 0x2a, 0xc0, 0x9f, 0x1e, 0xe0, 0x09, 0x23, 0x4c,
0xa9, 0x00, 0x8b, 0xf2, 0x80, 0xc3, 0x16, 0x76, 0x52, 0x2b, 0xd6, 0x0a, 0x6a, 0x45, 0xb5, 0xb8,
0x13, 0x38, 0x6c, 0x61, 0x1e, 0xb7, 0xb0, 0x16, 0xa7, 0x04, 0x08, 0xea, 0xa3, 0x1a, 0xe0, 0xff,
0xff, 0x8e, 0x00, 0x23, 0xe0, 0x08, 0xa3, 0x26, 0xca, 0x93, 0xf2, 0xa2, 0x16, 0xe5, 0x51, 0x60,
0xeb, 0x82, 0x3a, 0xa9, 0x15, 0xb5, 0x84, 0x96, 0x6c, 0xc5, 0x3a, 0xc1, 0x06, 0x75, 0x41, 0x1e,
0xb5, 0xa0, 0x4e, 0xe6, 0x09, 0x35, 0x51, 0x13, 0x29, 0xaf, 0x44, 0xd4, 0x8a, 0x52, 0xe4, 0xc7,
0x3a, 0x04, 0xb2, 0x74, 0x91, 0x8e, 0xf5, 0xa1, 0x8c, 0xf2, 0x64, 0x00
};
