﻿using StreamChat.Core.Helpers;
using StreamChat.Core.InternalDTO.Events;
using StreamChat.Core.LowLevelClient.Models;

namespace StreamChat.Core.LowLevelClient.Events
{
    public sealed class EventNotificationChannelDeleted : EventBase,
        ILoadableFrom<NotificationChannelDeletedEventInternalDTO, EventNotificationChannelDeleted>
    {
        public Channel Channel { get; set; }

        public string ChannelId { get; set; }

        public string ChannelType { get; set; }

        public string Cid { get; set; }

        public string Team { get; set; }

        public string Type { get; set; }

        EventNotificationChannelDeleted
            ILoadableFrom<NotificationChannelDeletedEventInternalDTO, EventNotificationChannelDeleted>.LoadFromDto(
                NotificationChannelDeletedEventInternalDTO dto)
        {
            Channel = Channel.TryLoadFromDto(dto.Channel);
            ChannelId = dto.ChannelId;
            ChannelType = dto.ChannelType;
            Cid = dto.Cid;
            CreatedAt = dto.CreatedAt;
            Team = dto.Team;
            Type = dto.Type;
            AdditionalProperties = dto.AdditionalProperties;

            return this;
        }
    }
}