export default {
    selector: '#post-editor',
    file_picker_types: 'image',
    contextmenu: false,
    plugins: "advlist autolink autosave codesample link image lists hr pagebreak searchreplace media table paste autoresize emoticons textpattern toc",
    toolbar1: "bold italic underline strikethrough forecolor publiilink unlink emoticons blockquote alignleft aligncenter alignright bullist numlist image gallery media table toc",
    toolbar2: "styleselect formatselect codesample searchreplace hr readmore undo redo restoredraft removeformat sourcecode",
    toolbar3: "",
    icons: "publii",
    block_formats: 'Paragraph=p;Heading 1=h1;Heading 2=h2;Heading 3=h3;Heading 4=h4;Heading 5=h5;Heading 6=h6;Address=address;Pre=pre;Code=code;Blockquote=blockquote',
    extended_valid_elements: "a[*],altGlyph[*],altGlyphDef[*],altGlyphItem[*],animate[*],animateColor[*],animateMotion[*],animateTransform[*],circle[*],clipPath[*],color-profile[*],cursor[*],defs[*],desc[*],discard[*],ellipse[*],feBlend[*],feColorMatrix[*],feComponentTransfer[*],feComposite[*],feConvolveMatrix[*],feDiffuseLighting[*],feDisplacementMap[*],feDistantLight[*],feDropShadow[*],feFlood[*],feFuncA[*],feFuncB[*],feFuncG[*],feFuncR[*],feGaussianBlur[*],feImage[*],feMerge[*],feMergeNode[*],feMorphology[*],feOffset[*],fePointLight[*],feSpecularLighting[*],feSpotLight[*],feTile[*],feTurbulence[*],filter[*],font[*],font-face[*],font-face-format[*],font-face-name[*],font-face-src[*],font-face-uri[*],foreignObject[*],g[*],glyph[*],glyphRef[*],hatch[*],hatchpath[*],hkern[*],iframe[*],image[*],line[*],linearGradient[*],marker[*],mask[*],mesh[*],meshgradient[*],meshpatch[*],meshrow[*],metadata[*],missing-glyph[*],mpath[*],path[*],pattern[*],polygon[*],polyline[*],radialGradient[*],rect[*],set[*],solidcolor[*],stop[*],style[*],svg[*],switch[*],symbol[*],text[*],textPath[*],title[*],tref[*],tspan[*],unknown[*],use[*],view[*],vkern[*],publii-amp,publii-non-amp,script[*],i[*],video[*],audio[*],source[*],stream[*]",
    valid_children: '+a[div|p|figure|pre|h1|h2|h3|h4|h5|h6|header|footer|article|aside|section|table|blockquote|video]',
    formats: {
        alignleft: { selector: 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,table,img', classes: 'align-left' },
        aligncenter: { selector: 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,table,img', classes: 'align-center' },
        alignright: { selector: 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,table,img', classes: 'align-right' },
        alignjustify: { selector: 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,table,img', classes: 'align-justify' }
    },
    preview_styles: false,
    resize: false,
    menubar: false,
    forced_root_block : "",
    force_br_newlines : false,
    force_p_newlines : true,
    paste_as_text: false,
    keep_styles: false,
    image_class_list: [
        {title: 'None', value: 'post__image'},
        {title: 'Full image', value: 'post__image post__image--full'},
        {title: 'Wide image', value: 'post__image post__image--wide'},
        {title: 'Left-aligned image', value: 'post__image post__image--left'},
        {title: 'Right-aligned image', value: 'post__image post__image--right'},
        {title: 'Centered image', value: 'post__image post__image--center'}
    ],
    codesample_languages: [
        { text: 'Apache Configuration', value: 'apacheconf' },
        { text: 'ASP.NET', value: 'aspnet' },
        { text: 'Bash', value: 'bash' },
        { text: 'BASIC', value: 'basic' },
        { text: 'Batch', value: 'batch' },
        { text: 'BBcode', value: 'bbcode' },
        { text: 'C', value: 'c' },
        { text: 'C++', value: 'cpp' },
        { text: 'ColdFusion Script', value: 'cfscript' },
        { text: 'C#', value: 'csharp' },
        { text: 'C-like', value: 'clike' },
        { text: 'CSS', value: 'css' },
        { text: 'Dart', value: 'dart' },
        { text: 'Docker', value: 'docker' },
        { text: 'Elixir', value: 'elixir' },
        { text: 'Elm', value: 'elm' },
        { text: 'GDScript', value: 'gdscript' },
        { text: 'Git', value: 'git' },
        { text: 'GLSL', value: 'glsl' },
        { text: 'Go', value: 'go' },
        { text: 'GraphQL', value: 'graphql' },
        { text: 'HAML', value: 'haml' },
        { text: 'Handlebars', value: 'handlebars' },
        { text: 'Haskell', value: 'haskell' },
        { text: 'HTML', value: 'html' },
        { text: 'HTTP', value: 'http' },
        { text: 'INI', value: 'ini' },
        { text: 'Java', value: 'java' },
        { text: 'JavaScript', value: 'javascript' },
        { text: 'JSON', value: 'json' },
        { text: 'JSONP', value: 'jsonp' },
        { text: 'JSX', value: 'jsx' },
        { text: 'Kotlin', value: 'kotlin' },
        { text: 'LaTeX', value: 'latex' },
        { text: 'LESS', value: 'less' },
        { text: 'Lisp', value: 'lisp' },
        { text: 'Lua', value: 'lua' },
        { text: 'Makefile', value: 'makefile' },
        { text: 'Markdown', value: 'markdown' },
        { text: 'MATLAB', value: 'matlab' },
        { text: 'NASM', value: 'nasm' },
        { text: 'Nginx', value: 'nginx' },
        { text: 'Objective-C', value: 'objectivec' },
        { text: 'Pascal', value: 'pascal' },
        { text: 'Perl', value: 'perl' },
        { text: 'PHP', value: 'php' },
        { text: 'Pug', value: 'pug' },
        { text: 'Python', value: 'python' },
        { text: 'R', value: 'r' },
        { text: 'Regex', value: 'regex' },
        { text: 'Ruby', value: 'ruby' },
        { text: 'Rust', value: 'rust' },
        { text: 'Sass', value: 'sass' },
        { text: 'SCSS', value: 'scss' },
        { text: 'Scala', value: 'scala' },
        { text: 'SQL', value: 'sql' },
        { text: 'Swift', value: 'swift' },
        { text: 'Twig', value: 'twig' },
        { text: 'TypeScript', value: 'typescript' },
        { text: 'VB.NET', value: 'vbnet' },
        { text: 'Visual Basic', value: 'visual-basic' },
        { text: 'YAML', value: 'yaml' }
    ],
    element_format : 'html',
    fix_list_elements : true,
    image_caption: true,
    autosave_ask_before_unload: false,
    autosave_interval: "10s",
    autosave_restore_when_empty: false,
    autosave_retention: "30m",
    entity_encoding: "raw",
    allow_script_urls: true,
    convert_urls: false,
    textpattern_patterns: [
        {start: '*', end: '*', format: 'italic'},
        {start: '**', end: '**', format: 'bold'},
        {start: '##', format: 'h2'},
        {start: '###', format: 'h3'},
        {start: '####', format: 'h4'},
        {start: '#####', format: 'h5'},
        {start: '######', format: 'h6'},
        {start: '1. ', cmd: 'InsertOrderedList'},
        {start: '* ', cmd: 'InsertUnorderedList'},
        {start: '- ', cmd: 'InsertUnorderedList'}
   ],
   toc_depth: 6,
   toc_header: "h3",
   toc_class: "post__toc",
   rel_list: [
    {title: 'noreferrer', value: 'noreferrer'},
    {title: 'nofollow', value: 'nofollow'},
    {title: 'noopener', value: 'noopener'},
    {title: 'sponsored', value: 'sponsored'},
    {title: 'ugc', value: 'ugc'},
   ],
   link_context_toolbar: false,
   link_quicklink: false,
   codesample_global_prismjs: true
};
