import 'package:brick_core/core.dart';
import 'package:brick_supabase/brick_supabase.dart';
import 'package:supabase/supabase.dart';

/// This class and code is always generated.
/// It is included here as an illustration.
/// Supabase adapters are generated by domains that utilize the brick_supabase_generators package,
/// such as brick_offline_first_with_supabase_build
class UserAdapter extends SupabaseAdapter<User> {
  @override
  Future<User> fromSupabase(data, {required provider, repository}) async {
    return User(
      name: data['name'],
    );
  }

  @override
  Future<Map<String, dynamic>> toSupabase(instance, {required provider, repository}) async {
    return {
      'name': instance.name,
    };
  }

  @override
  final defaultToNull = false;

  @override
  final fieldsToSupabaseColumns = {
    'name': RuntimeSupabaseColumnDefinition(columnName: 'name'),
  };

  @override
  final ignoreDuplicates = false;

  @override
  final onConflict = null;

  @override
  final tableName = 'users';

  @override
  final uniqueFields = {};
}

/// This value is always generated.
/// It is included here as an illustration.
/// Import it from `lib/brick/brick.g.dart` in your application.
final dictionary = SupabaseModelDictionary({
  User: UserAdapter(),
});

/// A model is unique to the end implementation (e.g. a Flutter app)
class User extends SupabaseModel {
  final String name;

  User({
    required this.name,
  });
}

class MyRepository extends SingleProviderRepository<SupabaseModel> {
  MyRepository(String apiUrl, String supabaseAnonKey)
      : super(
          SupabaseProvider(
            SupabaseClient(apiUrl, supabaseAnonKey),
            modelDictionary: dictionary,
          ),
        );
}

void main() async {
  final repository = MyRepository('http://localhost:8080', 'YOUR_API_KEY_HERE');

  final users = await repository.get<User>();
  print(users);
}
