## Unreleased

## 3.0.4

- Access `FieldRename` from `brick_core` instead of declaring within this package

## 3.0.3

- Apply standardized lints
- Upgrade minimum Dart to 2.18
- Update minimum HTTP to 1.0.0

## 3.0.2

- Support Dart 3

## 3.0.1

- Support accessing `supplementalTopLevelData` from any REST request that accepts a body (`PUT`, `PATCH`, `POST`). Additionally, include `supplementalTopLevelData` defined within `RestRequest` instances defined outside `providerArgs`

## 3.0.0

Please follow the [v3 migration guide](https://github.com/GetDutchie/brick/issues/325) to easily upgrade.

- **BREAKING CHANGE** Rename main export file to `brick_rest.dart`
- **BREAKING CHANGE** replace `RestSerializable(endpoint:)` with `RestSerializable(requestTransformer:)`
- Add `RestAdapter#restRequest`
- **BREAKING CHANGE** `providerArgs['topLevelKey']` and `providerArgs['headers']` and `providerArgs['supplementalTopLevelData']` have been removed (use `'request'`) and `providerArgs['request']` now accepts a `RestRequest` instead of the HTTP method string.
- Use Dart 2.15's `.byName` accessor for iterable enum values and remove `RestAdapter.enumValueFromName` and `RestAdapter.firstWhereOrNull`. Instead use `<Enum>.values.byName` and `import 'package:collection/collection.dart'`'s `.firstWhereOrNull` respectively.

## 1.1.1

- Upgrade `brick_core`

## 1.1.0

- Add Dart Lints
- Change `instance` and `data` positional arguments in `RestAdapter` to `input` to match generator variable

## 1.0.1

- Add support for PATCH requests (#188)

## 1.0.0+3

- Improve code hint documentation
- Move `RestProvider#statusCodeIsSuccessful` to `RestProvider.statusCodeIsSuccessful`
- Require `provider` in `RestAdapter#fromRest` and `RestAdapter#toRest`

## 1.0.0+2

- Require provider in adapter methods `fromRest` and `toRest`

## 1.0.0+1

- Add static methods `.firstWhereOrNull` and `.enumValueFromName` to `RestAdapter` to support null safe building

## 1.0.0

- Null safety

## 0.0.8

- Add `GZipHttpClient`. When instantiating the `RestProvider`, optionally compose `client` with a `GZipHttpClient` to [gzip all requests](README.md#gzipping-requests).

## 0.0.7+1

- Change `_convertJson` to protected method `convertJsonFromGet` (#57)

## 0.0.7

- When `url` is `null` in `RestProvider#upsert` and `RestProvider#delete`, return `null` and do not attempt to perform the action
- On `upsert` invocations, specify `supplementalTopLevelData` to include other information outside the `topLevelKey`/`toKey`. This inserts a map alongside the data generated by the adapter.

## 0.0.5

- Carry rename from `Query#params` to `Query#providerArgs` from brick_core

## 0.0.4

- `Rest#defaultValue` updated to reflect `FieldSerializable#defaultValue` change

## 0.0.2

- Fix linter hints
