import 'package:brick_core/core.dart';
import 'package:brick_graphql/brick_graphql.dart';
import 'package:gql_http_link/gql_http_link.dart';

class UserQueryOperationTransformer extends GraphqlQueryOperationTransformer {
  GraphqlOperation get get => GraphqlOperation(document: '''query AllUsers {
      allUsers {}
    }''');

  const UserQueryOperationTransformer(Query? query, GraphqlModel? instance)
      : super(query, instance);
}

/// This class and code is always generated.
/// It is included here as an illustration.
/// Graphql adapters are generated by domains that utilize the brick_graphql_generators package,
/// such as brick_offline_first_with_graphql_build
class UserAdapter extends GraphqlAdapter<User> {
  @override
  final queryOperationTransformer = UserQueryOperationTransformer.new;

  @override
  Map<String, RuntimeGraphqlDefinition> get fieldsToGraphqlRuntimeDefinition => {
        'name': const RuntimeGraphqlDefinition(
          association: false,
          documentNodeName: 'full_name',
          iterable: false,
          type: String,
        ),
      };

  @override
  Future<User> fromGraphql(data, {required provider, repository}) async {
    return User(
      name: data['name'],
    );
  }

  @override
  Future<Map<String, dynamic>> toGraphql(instance, {required provider, repository}) async {
    return {
      'name': instance.name,
    };
  }
}

/// This value is always generated.
/// It is included here as an illustration.
/// Import it from `lib/app/brick.g.dart` in your application.
final dictionary = GraphqlModelDictionary({
  User: UserAdapter(),
});

/// A model is unique to the end implementation (e.g. a Flutter app)
class User extends GraphqlModel {
  final String name;

  User({
    required this.name,
  });
}

class MyRepository extends SingleProviderRepository<GraphqlModel> {
  MyRepository(String baseApiUrl)
      : super(
          GraphqlProvider(
            link: HttpLink(baseApiUrl),
            modelDictionary: dictionary,
          ),
        );
}

/// Run with a simple Apollo GraphQL Server:
/*
const { ApolloServer } = require("apollo-server");

const typeDefs = gql`
  type User {
    name: String
  }
  type Query {
    allUsers: [User]
  }
`;

const user = { name: 'Thomas' };

const resolvers = {
  Query: {
    allUsers: () => [user],
  }
}
server.listen().then(({ url }) => {
  console.log(`🚀  Server ready at ${url}`);
});
*/
void main() async {
  final repository = MyRepository('http://localhost:4000');

  final users = await repository.get<User>();
  print(users);
}
