# Contributing to iNetStorm

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## Code of Conduct

Please read our [Code of Conduct](CODE_OF_CONDUCT.md) before contributing.

## We Develop with Github

We use github to host code, to track issues and feature requests, as well as accept pull requests.

## We Use [Github Flow](https://guides.github.com/introduction/flow/index.html), So All Code Changes Happen Through Pull Requests

## How to Contribute

### Reporting Bugs

If you find a bug, please open an issue on GitHub. Include:

- A clear and concise description of the bug.
- Steps to reproduce the bug.
- Information about your environment (operating system, Python version, etc.).

### Requesting Features

We would love to hear your ideas for new features. To request a new feature, open an issue on GitHub and provide:

- A detailed description of the feature.
- Use cases and why the feature would be beneficial.
- Any additional information or context.

### Submitting Changes

1. Fork the repository and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. Ensure the test suite passes.
4. Make sure your code lints.
5. Submit a pull request.

### Pull Request Process

1. Ensure your changes pass all tests and linting.
2. Provide a clear description of your changes and the problem they address.
3. Reference any related issues in your pull request.
4. Wait for a project maintainer to review your changes. You may be asked to make additional changes before your pull request is merged.

### Coding Style

- Follow PEP 8 guidelines for Python code.
- Write clear, concise commit messages.
- Include comments and documentation as necessary.

## Community

Join our community discussions on [Discussion Board](link-to-discussion-board) to ask questions, share ideas, and connect with other contributors.

## Any contributions you make will be under the BSD 3-Clause License

In short, when you submit code changes, your submissions are understood to be under the same [BSD 3-Clause License](https://opensource.org/licenses/BSD-3-Clause) that covers the project. Feel free to contact the maintainers if that's a concern.

## License

By contributing, you agree that your contributions will be licensed under its BSD License.

## References

This document was adapted from the open-source contribution guidelines for [Facebook's Draft](https://github.com/facebook/draft-js)
