/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

public class OracleTypeDATE
extends OracleType
implements Serializable {
    static final long serialVersionUID = -5858803341118747965L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_26_18:10:24_PDT_2010";
    public static final boolean TRACE = false;

    public OracleTypeDATE() {
    }

    public OracleTypeDATE(int n2) {
        super(n2);
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        DATE dATE = null;
        if (object != null) {
            try {
                dATE = object instanceof DATE ? (DATE)object : (object instanceof TIMESTAMP ? new DATE(((TIMESTAMP)object).timestampValue()) : new DATE(object));
            }
            catch (SQLException sQLException) {
                SQLException sQLException2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
                sQLException2.fillInStackTrace();
                throw sQLException2;
            }
        }
        return dATE;
    }

    @Override
    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n3 = (int)(n2 == -1 ? (long)cArray.length : Math.min((long)cArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    datumArray[i2] = this.toDatum(new String(cArray[(int)l2 + i2 - 1]), oracleConnection);
                }
            } else {
                if (object instanceof Object[]) {
                    return super.toDatumArray(object, oracleConnection, l2, n2);
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return datumArray;
    }

    @Override
    public int getTypeCode() {
        return 91;
    }

    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        if (n2 == 1) {
            return new DATE(byArray);
        }
        if (n2 == 2) {
            return DATE.toTimestamp(byArray);
        }
        if (n2 == 3) {
            return byArray;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, byArray);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

