/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIdcb;

class T4CResultSetAccessor
extends ResultSetAccessor {
    T4CMAREngine mare;
    OracleStatement[] newstmt = new OracleStatement[10];
    byte[] empty = new byte[]{0};
    boolean underlyingLongRaw = false;
    final int[] meta = new int[1];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_26_18:10:24_PDT_2010";
    public static final boolean TRACE = false;

    T4CResultSetAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, s2, n3, bl);
        this.mare = t4CMAREngine;
    }

    T4CResultSetAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2, int n8, int n9, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2 == -1 ? n9 : n2, bl, n3, n4, n5, n6, n7, s2);
        this.mare = t4CMAREngine;
        this.definedColumnType = n8;
        this.definedColumnSize = n9;
        if (n2 == -1) {
            this.underlyingLongRaw = true;
        }
    }

    void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.statement.sqlKind != 32 && this.statement.sqlKind != 64) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind == 32 || this.statement.sqlKind == 64 || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    @Override
    String getString(int n2) throws SQLException {
        String string = super.getString(n2);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize) {
            string = string.substring(0, this.definedColumnSize);
        }
        return string;
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        Object object;
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            byte[] byArray = new byte[16000];
            this.mare.unmarshalCLR(byArray, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int n2 = this.indicatorIndex + this.lastRowProcessed;
        int n3 = this.lengthIndex + this.lastRowProcessed;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[n2] = -1;
            this.rowSpaceIndicator[n3] = 0;
            ++this.lastRowProcessed;
            this.processIndicator(0);
            return false;
        }
        int n4 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        if (this.newstmt.length <= this.lastRowProcessed) {
            object = new OracleStatement[this.newstmt.length * 4];
            System.arraycopy(this.newstmt, 0, object, 0, this.newstmt.length);
            this.newstmt = object;
        }
        this.newstmt[this.lastRowProcessed] = this.statement.connection.RefCursorBytesToStatement(this.empty, this.statement);
        this.newstmt[this.lastRowProcessed].needToSendOalToFetch = true;
        object = new T4CTTIdcb((T4CConnection)this.statement.connection);
        ((T4CTTIdcb)object).init(this.newstmt[this.lastRowProcessed], 0);
        this.newstmt[this.lastRowProcessed].accessors = ((T4CTTIdcb)object).receiveFromRefCursor(this.newstmt[this.lastRowProcessed].accessors);
        this.newstmt[this.lastRowProcessed].numberOfDefinePositions = this.newstmt[this.lastRowProcessed].accessors.length;
        this.newstmt[this.lastRowProcessed].describedWithNames = true;
        this.newstmt[this.lastRowProcessed].described = true;
        int n5 = (int)this.mare.unmarshalUB4();
        this.newstmt[this.lastRowProcessed].setCursorId(n5);
        if (n5 > 0) {
            this.rowSpaceByte[n4] = 1;
            this.rowSpaceByte[n4 + 1] = (byte)n5;
            this.meta[0] = 2;
        } else {
            this.newstmt[this.lastRowProcessed].close();
            this.newstmt[this.lastRowProcessed] = null;
            this.meta[0] = 0;
        }
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[n2] = -1;
            this.rowSpaceIndicator[n3] = 0;
        } else {
            this.rowSpaceIndicator[n3] = (short)this.meta[0];
            this.rowSpaceIndicator[n2] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        int n2 = this.lastRowProcessed == 0 ? this.statement.rowPrefetchInLastFetch - 1 : this.lastRowProcessed - 1;
        int n3 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int n4 = this.columnIndex + n2 * this.byteLength;
        int n5 = this.indicatorIndex + this.lastRowProcessed;
        int n6 = this.indicatorIndex + n2;
        int n7 = this.lengthIndex + this.lastRowProcessed;
        int n8 = this.lengthIndex + n2;
        short s2 = this.rowSpaceIndicator[n8];
        int n9 = this.metaDataIndex + this.lastRowProcessed * 1;
        int n10 = this.metaDataIndex + n2 * 1;
        this.rowSpaceIndicator[n7] = s2;
        this.rowSpaceIndicator[n5] = this.rowSpaceIndicator[n6];
        System.arraycopy(this.rowSpaceByte, n4, this.rowSpaceByte, n3, s2);
        System.arraycopy(this.rowSpaceMetaData, n10, this.rowSpaceMetaData, n9, 1);
        ++this.lastRowProcessed;
    }

    @Override
    void saveDataFromOldDefineBuffers(byte[] byArray, char[] cArray, short[] sArray, int n2, int n3) throws SQLException {
        int n4 = this.columnIndex + (n3 - 1) * this.byteLength;
        int n5 = this.columnIndexLastRow + (n2 - 1) * this.byteLength;
        int n6 = this.indicatorIndex + n3 - 1;
        int n7 = this.indicatorIndexLastRow + n2 - 1;
        int n8 = this.lengthIndex + n3 - 1;
        int n9 = this.lengthIndexLastRow + n2 - 1;
        short s2 = sArray[n9];
        this.rowSpaceIndicator[n8] = s2;
        this.rowSpaceIndicator[n6] = sArray[n7];
        if (s2 != 0) {
            System.arraycopy(byArray, n5, this.rowSpaceByte, n4, s2);
        }
    }

    @Override
    ResultSet getCursor(int n2) throws SQLException {
        if (this.newstmt[n2] != null) {
            for (int i2 = 0; i2 < this.newstmt[n2].numberOfDefinePositions; ++i2) {
                this.newstmt[n2].accessors[i2].initMetadata();
            }
        } else {
            throw new SQLException("Cursor is closed.");
        }
        this.newstmt[n2].prepareAccessors();
        OracleResultSetImpl oracleResultSetImpl = new OracleResultSetImpl(this.newstmt[n2].connection, this.newstmt[n2]);
        oracleResultSetImpl.close_statement_on_close = true;
        this.newstmt[n2].currentResultSet = oracleResultSetImpl;
        OracleResultSetImpl oracleResultSetImpl2 = oracleResultSetImpl;
        return oracleResultSetImpl2;
    }
}

