/*
 * Decompiled with CFR 0.152.
 */
package pool;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import pool.ConnectionObject;

public class DBConnectionMgr {
    private Vector connections = new Vector(10);
    private String _driver = "oracle.jdbc.driver.OracleDriver";
    private String _url = "jdbc:oracle:thin:@localhost:1521:xe";
    private String _user = "scott";
    private String _password = "1111";
    private boolean _traceOn = false;
    private boolean initialized = false;
    private int _openConnections = 10;
    private static DBConnectionMgr instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBConnectionMgr getInstance() {
        if (instance != null) return instance;
        Class<DBConnectionMgr> clazz = DBConnectionMgr.class;
        synchronized (DBConnectionMgr.class) {
            if (instance != null) return instance;
            instance = new DBConnectionMgr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setOpenConnectionCount(int count) {
        this._openConnections = count;
    }

    public void setEnableTrace(boolean enable) {
        this._traceOn = enable;
    }

    public Vector getConnectionList() {
        return this.connections;
    }

    public synchronized void setInitOpenConnections(int count) throws SQLException {
        Connection c = null;
        ConnectionObject co = null;
        int i = 0;
        while (i < count) {
            c = this.createConnection();
            co = new ConnectionObject(c, false);
            this.connections.addElement(co);
            this.trace("ConnectionPoolManager: Adding new DB connection to pool (" + this.connections.size() + ")");
            ++i;
        }
    }

    public int getConnectionCount() {
        return this.connections.size();
    }

    public synchronized Connection getConnection() throws Exception {
        Object c;
        if (!this.initialized) {
            c = Class.forName(this._driver);
            DriverManager.registerDriver((Driver)((Class)c).newInstance());
            this.initialized = true;
        }
        c = null;
        ConnectionObject co = null;
        boolean badConnection = false;
        int i = 0;
        while (i < this.connections.size()) {
            co = (ConnectionObject)this.connections.get(i);
            if (!co.inUse) {
                try {
                    badConnection = co.connection.isClosed();
                    if (!badConnection) {
                        badConnection = co.connection.getWarnings() != null;
                    }
                }
                catch (Exception e) {
                    badConnection = true;
                    e.printStackTrace();
                }
                if (badConnection) {
                    this.connections.removeElementAt(i);
                    this.trace("ConnectionPoolManager: Remove disconnected DB connection #" + i);
                } else {
                    c = co.connection;
                    co.inUse = true;
                    this.trace("ConnectionPoolManager: Using existing DB connection #" + (i + 1));
                    break;
                }
            }
            ++i;
        }
        if (c == null) {
            c = this.createConnection();
            co = new ConnectionObject((Connection)c, true);
            this.connections.addElement(co);
            this.trace("ConnectionPoolManager: Creating new DB connection #" + this.connections.size());
        }
        return c;
    }

    public synchronized void freeConnection(Connection c) {
        if (c == null) {
            return;
        }
        ConnectionObject co = null;
        int i = 0;
        while (i < this.connections.size()) {
            co = (ConnectionObject)this.connections.get(i);
            if (c == co.connection) {
                co.inUse = false;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.connections.size()) {
            co = (ConnectionObject)this.connections.get(i);
            if (i + 1 > this._openConnections && !co.inUse) {
                this.removeConnection(co.connection);
            }
            ++i;
        }
    }

    public void freeConnection(Connection c, PreparedStatement p, ResultSet r) {
        try {
            if (r != null) {
                r.close();
            }
            if (p != null) {
                p.close();
            }
            this.freeConnection(c);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void freeConnection(Connection c, Statement s, ResultSet r) {
        try {
            if (r != null) {
                r.close();
            }
            if (s != null) {
                s.close();
            }
            this.freeConnection(c);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void freeConnection(Connection c, PreparedStatement p) {
        try {
            if (p != null) {
                p.close();
            }
            this.freeConnection(c);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void freeConnection(Connection c, Statement s) {
        try {
            if (s != null) {
                s.close();
            }
            this.freeConnection(c);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public synchronized void removeConnection(Connection c) {
        if (c == null) {
            return;
        }
        ConnectionObject co = null;
        int i = 0;
        while (i < this.connections.size()) {
            co = (ConnectionObject)this.connections.get(i);
            if (c == co.connection) {
                try {
                    c.close();
                    this.connections.removeElementAt(i);
                    this.trace("Removed " + c.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            ++i;
        }
    }

    private Connection createConnection() throws SQLException {
        Connection con = null;
        try {
            if (this._user == null) {
                this._user = "";
            }
            if (this._password == null) {
                this._password = "";
            }
            Properties props = new Properties();
            props.put("user", this._user);
            props.put("password", this._password);
            con = DriverManager.getConnection(this._url, props);
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
        return con;
    }

    public void releaseFreeConnections() {
        this.trace("ConnectionPoolManager.releaseFreeConnections()");
        Object c = null;
        ConnectionObject co = null;
        int i = 0;
        while (i < this.connections.size()) {
            co = (ConnectionObject)this.connections.get(i);
            if (!co.inUse) {
                this.removeConnection(co.connection);
            }
            ++i;
        }
    }

    public void finalize() {
        this.trace("ConnectionPoolManager.finalize()");
        Object c = null;
        ConnectionObject co = null;
        int i = 0;
        while (i < this.connections.size()) {
            co = (ConnectionObject)this.connections.get(i);
            try {
                co.connection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            co = null;
            ++i;
        }
        this.connections.removeAllElements();
    }

    private void trace(String s) {
        if (this._traceOn) {
            System.err.println(s);
        }
    }
}

