// BSD 3-Clause License
// Copyright ©2022, GM Consult Pty Ltd
// All rights reserved

part of 'english.dart';

/// Constants used by the [English] text analyzer.
abstract class _EnglishConstants {
  //

  // /// The default lemmatizer returns the [term] unchanged.
  // static String kLemmatizer(String term) => term;

  /// The default stemmer returns the [term] unchanged.
  static String kStemmer(String term) => term.stemPorter2();

  // /// Matches all instances of a posessive apostrophy, e.g. "Mary's".
  // static const rPosessiveApostrophe = r"(?<=\w)'[sS]{1}(?=\W|$)";

  /// A collection of stop-words excluded from tokenization.
  static const kStopWords = {
    'a',
    'abaft',
    'abafter',
    'abaftest',
    'about',
    'abouter',
    'aboutest',
    'abov',
    'above',
    'abover',
    'abovest',
    'accord',
    'accordingly',
    'across',
    'aer',
    'aest',
    'afor',
    'afore',
    'after',
    'afterer',
    'afterest',
    'afterward',
    'afterwards',
    'again',
    'against',
    'aid',
    'ain',
    'albeit',
    'all',
    'aller',
    'allest',
    'alls',
    'allyou',
    'almost',
    'along',
    'alongsid',
    'alongside',
    'alreadi',
    'already',
    'also',
    'although',
    'alway',
    'always',
    'am',
    'amid',
    'amidst',
    'among',
    'amongst',
    'an',
    'and',
    'andor',
    'anear',
    'anent',
    'ani',
    'anoth',
    'another',
    'any',
    'anybodi',
    'anybody',
    'anyhow',
    'anyon',
    'anyone',
    'anyth',
    'anything',
    'anywher',
    'anywhere',
    'apart',
    'aparter',
    'apartest',
    'appear',
    'appeared',
    'appearing',
    'appears',
    'appropri',
    'appropriat',
    'appropriate',
    'appropriated',
    'appropriater',
    'appropriates',
    'appropriatest',
    'appropriating',
    'are',
    'ares',
    'around',
    'as',
    'ase',
    'ases',
    'asid',
    'aside',
    'asides',
    'aslant',
    'astraddl',
    'astraddle',
    'astraddler',
    'astraddlest',
    'astrid',
    'astride',
    'astrider',
    'astridest',
    'at',
    'athwart',
    'atop',
    'atween',
    'aught',
    'aughts',
    'avail',
    'availabl',
    'available',
    'availabler',
    'availablest',
    'aw',
    'awfully',
    'b',
    'be',
    'becam',
    'became',
    'becaus',
    'because',
    'becom',
    'become',
    'becomes',
    'becoming',
    'becominger',
    'becomingest',
    'becomings',
    'been',
    'befor',
    'before',
    'beforehand',
    'beforehander',
    'beforehandest',
    'behind',
    'behinds',
    'being',
    'below',
    'beneath',
    'besid',
    'beside',
    'besides',
    'better',
    'bettered',
    'bettering',
    'betters',
    'between',
    'betwixt',
    'beyond',
    'bist',
    'both',
    'but',
    'buts',
    'by',
    'byandbi',
    'byandby',
    'by-and-by',
    'c',
    'can',
    'cannot',
    'canst',
    'cant',
    'canted',
    'cantest',
    'canting',
    'cants',
    'case',
    'cer',
    'certain',
    'certainer',
    'certainest',
    'cest',
    'chez',
    'circa',
    'co',
    'comeon',
    'come-on',
    'comeons',
    'come-ons',
    'concern',
    'concerning',
    'concerninger',
    'concerningest',
    'consequ',
    'consequently',
    'consid',
    'considering',
    'could',
    'couldst',
    'cum',
    'd',
    'dday',
    'ddays',
    'describ',
    'describe',
    'described',
    'describes',
    'describing',
    'despit',
    'despite',
    'despited',
    'despites',
    'despiting',
    'did',
    'differ',
    'different',
    'differenter',
    'differentest',
    'do',
    'doe',
    'does',
    'doing',
    'doings',
    'don',
    'done',
    'doner',
    'dones',
    'donest',
    'dos',
    'dost',
    'doth',
    'down',
    'downs',
    'downward',
    'downwarder',
    'downwardest',
    'downwards',
    'dure',
    'during',
    'e',
    'each',
    'eg',
    'eight',
    'either',
    'els',
    'else',
    'elsewher',
    'elsewhere',
    'enough',
    'ere',
    'et',
    'etc',
    'even',
    'evened',
    'evenest',
    'evens',
    'evenser',
    'evensest',
    'event',
    'ever',
    'everi',
    'every',
    'everybodi',
    'everybody',
    'everyon',
    'everyone',
    'everyth',
    'everything',
    'everywher',
    'everywhere',
    'ex',
    'except',
    'excepted',
    'excepting',
    'excepts',
    'exe',
    'exes',
    'f',
    'fact',
    'facts',
    'fail',
    'failing',
    'failings',
    'few',
    'fewer',
    'fewest',
    'figupon',
    'figuponed',
    'figuponing',
    'figupons',
    'five',
    'follow',
    'following',
    'followthrough',
    'for',
    'forbi',
    'forby',
    'forbye',
    'fore',
    'forer',
    'fores',
    'forev',
    'forever',
    'former',
    'formerer',
    'formerest',
    'formerly',
    'formers',
    'fornenst',
    'forwhi',
    'forwhy',
    'four',
    'fourscor',
    'fourscore',
    'frae',
    'from',
    'fs',
    'further',
    'furthered',
    'furtherer',
    'furtherest',
    'furthering',
    'furthermor',
    'furthermore',
    'furthers',
    'g',
    'get',
    'gets',
    'getting',
    'go',
    'gone',
    'good',
    'got',
    'gotta',
    'gotten',
    'h',
    'had',
    'hadst',
    'hae',
    'hard',
    'hardly',
    'has',
    'hast',
    'hath',
    'have',
    'haves',
    'having',
    'he',
    'henc',
    'hence',
    'her',
    'here',
    'hereaft',
    'hereafter',
    'hereafters',
    'herebi',
    'hereby',
    'herein',
    'hereupon',
    'hers',
    'herself',
    'him',
    'himself',
    'his',
    'hither',
    'hitherer',
    'hitherest',
    'hoo',
    'hoos',
    'how',
    'howbeit',
    'howdoyoudo',
    'how-do-you-do',
    'howev',
    'however',
    'huh',
    'humph',
    'i',
    'idem',
    'idemer',
    'idemest',
    'ie',
    'if',
    'ifs',
    'immedi',
    'immediat',
    'immediate',
    'immediately',
    'immediater',
    'immediatest',
    'in',
    'inasmuch',
    'inc',
    'includ',
    'including',
    'inde',
    'indeed',
    'indic',
    'indicate',
    'indicated',
    'indicates',
    'indicating',
    'info',
    'inform',
    'information',
    'insofar',
    'instead',
    'into',
    'inward',
    'inwarder',
    'inwardest',
    'inwards',
    'is',
    'it',
    'its',
    'itself',
    'j',
    'just',
    'k',
    'l',
    'last',
    'latter',
    'latterer',
    'latterest',
    'latterly',
    'latters',
    'layabout',
    'layabouts',
    'least',
    'less',
    'lest',
    'like',
    'littl',
    'little',
    'long',
    'lot',
    'lots',
    'lotted',
    'lotting',
    'm',
    'main',
    'make',
    'mani',
    'many',
    'mauger',
    'maugr',
    'maugre',
    'mayest',
    'me',
    'meanwhil',
    'meanwhile',
    'meanwhiles',
    'midst',
    'midsts',
    'might',
    'mights',
    'mine',
    'more',
    'moreov',
    'moreover',
    'most',
    'mostly',
    'much',
    'mucher',
    'muchest',
    'must',
    'musth',
    'musths',
    'musts',
    'my',
    'myself',
    'n',
    'natheless',
    'nathless',
    'naught',
    'near',
    'neath',
    'neaths',
    'necessari',
    'necessarier',
    'necessariest',
    'necessary',
    'neither',
    'neth',
    'nethe',
    'nethermost',
    'never',
    'nevertheless',
    'next',
    'nigh',
    'nigher',
    'nighest',
    'nine',
    'no',
    'nobodi',
    'nobodies',
    'nobody',
    'noe',
    'noes',
    'none',
    'noon',
    'no-on',
    'noone',
    'no-one',
    'nor',
    'nos',
    'not',
    'noth',
    'nothing',
    'nothings',
    'notwithstand',
    'notwithstanding',
    'nought',
    'now',
    'nowher',
    'nowhere',
    'nowheres',
    'o',
    'of',
    'off',
    'offest',
    'offs',
    'often',
    'oftener',
    'oftenest',
    'oh',
    'on',
    'onc',
    'once',
    'one',
    'oneself',
    'onest',
    'only',
    'ons',
    'onto',
    'or',
    'order',
    'orer',
    'orest',
    'other',
    'others',
    'otherwis',
    'otherwise',
    'otherwiser',
    'otherwisest',
    'ought',
    'oughts',
    'our',
    'ours',
    'ourself',
    'ourselv',
    'ourselves',
    'out',
    'outed',
    'outest',
    'outs',
    'outsid',
    'outside',
    'outwith',
    'over',
    'overal',
    'overall',
    'overaller',
    'overallest',
    'overalls',
    'overs',
    'own',
    'owned',
    'owning',
    'owns',
    'owt',
    'p',
    'particular',
    'particularer',
    'particularest',
    'particularly',
    'particulars',
    'past',
    'per',
    'perhap',
    'perhaps',
    'plaintiff',
    'pleas',
    'please',
    'pleased',
    'pleases',
    'plenti',
    'plenties',
    'plenty',
    'plus',
    'pro',
    'probabl',
    'probably',
    'provid',
    'provide',
    'provided',
    'provides',
    'providing',
    'q',
    'qua',
    'que',
    'quit',
    'quite',
    'r',
    'rath',
    'rathe',
    'rather',
    'rathest',
    're',
    'realli',
    'really',
    'regard',
    'regarding',
    'relat',
    'relate',
    'related',
    'relatively',
    'res',
    'respect',
    'respecting',
    'respectively',
    's',
    'said',
    'saider',
    'saidest',
    'same',
    'samer',
    'sames',
    'samest',
    'san',
    'sans',
    'sanserif',
    'sanserifs',
    'sanses',
    'save',
    'saved',
    'sayid',
    'sayyid',
    'seem',
    'seemed',
    'seeming',
    'seeminger',
    'seemingest',
    'seemingly',
    'seemings',
    'seems',
    'send',
    'sent',
    'senza',
    'serious',
    'seriouser',
    'seriousest',
    'seven',
    'sever',
    'several',
    'severaler',
    'severalest',
    'shall',
    'shalled',
    'shalling',
    'shalls',
    'she',
    'should',
    'shoulded',
    'shoulding',
    'shoulds',
    'sinc',
    'since',
    'sine',
    'sines',
    'sith',
    'six',
    'so',
    'sobeit',
    'soer',
    'soest',
    'some',
    'somebodi',
    'somebody',
    'somehow',
    'someon',
    'someone',
    'someth',
    'something',
    'sometim',
    'sometime',
    'sometimer',
    'sometimes',
    'sometimest',
    'somewhat',
    'somewher',
    'somewhere',
    'soon',
    'stop',
    'stopped',
    'such',
    'suchlik',
    'suchlike',
    'suffici',
    'sufficient',
    'summat',
    'sup',
    'supped',
    'supping',
    'suppos',
    'supposing',
    'sups',
    'syn',
    'syne',
    't',
    'ten',
    'than',
    'that',
    'the',
    'thee',
    'their',
    'theirs',
    'theirself',
    'theirselv',
    'theirselves',
    'them',
    'themself',
    'themselv',
    'themselves',
    'then',
    'thenc',
    'thence',
    'thener',
    'thenest',
    'there',
    'thereaft',
    'thereafter',
    'therebi',
    'thereby',
    'therefor',
    'therefore',
    'therein',
    'therer',
    'therest',
    'thereupon',
    'these',
    'they',
    'thi',
    'thine',
    'thing',
    'things',
    'this',
    'thise',
    'thises',
    'thorough',
    'thorougher',
    'thoroughest',
    'thoroughly',
    'those',
    'thou',
    'though',
    'thous',
    'thouses',
    'three',
    'thro',
    'through',
    'througher',
    'throughest',
    'throughout',
    'thru',
    'thruer',
    'thruest',
    'thus',
    'thy',
    'thyself',
    'till',
    'tilled',
    'tilling',
    'tills',
    'time',
    'to',
    'togeth',
    'together',
    'too',
    'toward',
    'towarder',
    'towardest',
    'towards',
    'two',
    'u',
    'umpteen',
    'under',
    'underneath',
    'unless',
    'unlik',
    'unlike',
    'unliker',
    'unlikest',
    'until',
    'unto',
    'up',
    'upon',
    'uponed',
    'uponing',
    'upons',
    'upped',
    'upping',
    'ups',
    'us',
    'use',
    'used',
    'usedest',
    'usernam',
    'username',
    'usual',
    'usually',
    'v',
    'various',
    'variouser',
    'variousest',
    'veri',
    'verier',
    'veriest',
    'versus',
    'very',
    'via',
    'vis-a-vi',
    'vis-a-vis',
    'vis-a-viser',
    'vis-a-visest',
    'viz',
    'vs',
    'w',
    'was',
    'wast',
    'we',
    'were',
    'wert',
    'what',
    'whatev',
    'whatever',
    'whateverer',
    'whateverest',
    'whatnot',
    'whatsoev',
    'whatsoever',
    'whatsoeverer',
    'whatsoeverest',
    'wheen',
    'when',
    'whena',
    'whenas',
    'whenc',
    'whence',
    'whencesoev',
    'whencesoever',
    'whenev',
    'whenever',
    'whensoev',
    'whensoever',
    'where',
    'wherea',
    'whereaft',
    'whereafter',
    'whereas',
    'wherebi',
    'whereby',
    'wherefrom',
    'wherein',
    'whereinto',
    'whereof',
    'whereon',
    'wheresoev',
    'wheresoever',
    'whereto',
    'whereunto',
    'whereupon',
    'wherev',
    'wherever',
    'wherewith',
    'wherewithal',
    'whether',
    'whi',
    'which',
    'whichev',
    'whichever',
    'whichsoev',
    'whichsoever',
    'while',
    'whiles',
    'whilst',
    'whither',
    'whithersoev',
    'whithersoever',
    'who',
    'whoever',
    'whom',
    'whomev',
    'whomever',
    'whomso',
    'whomsoev',
    'whomsoever',
    'whose',
    'whosesoev',
    'whosesoever',
    'whosev',
    'whosever',
    'whoso',
    'whosoev',
    'whosoever',
    'why',
    'will',
    'with',
    'withal',
    'within',
    'without',
    'would',
    'woulded',
    'woulding',
    'woulds',
    'x',
    'y',
    'ye',
    'yet',
    'yon',
    'yond',
    'yonder',
    'you',
    'your',
    'yours',
    'yourself',
    'yourselv',
    'yourselves',
    'z',
    'zillion',
  };

  /// A list of English abbreviations.
  static const kAbbreviations = {
    'a': 'ante',
    'A.D.': 'Anno Domini',
    'A.V.': 'Authorized Version',
    'abbrev.': 'abbreviation',
    'Abbrev.': 'abbreviations',
    'Abd.': 'Aberdeen',
    'Aberd.': 'Aberdeen',
    'Aberdeensh.': 'Aberdeenshire',
    'abl.': 'ablative',
    'Abol.': 'abolition',
    'Aborig.': 'aboriginal',
    'Abp.': 'archbishop',
    'Abr.': 'abridged',
    'Abridg.': 'abridged',
    'Abridgem.': 'abridgement',
    'absol.': 'absolutely',
    'Absol.': 'absolute',
    'Abst.': 'abstracts',
    'Abstr.': 'abstracts',
    'abstr.': 'abstract',
    'Acad.': 'academia, academy, academical',
    'acc.': 'accusative, according',
    'Acc.': 'accounts',
    'Accept.': 'acceptance',
    'Accomm.': 'accommodation',
    'Accompl.': 'accomplished',
    'Accs.': 'accounts',
    'Acct.': 'account',
    'Accts.': 'accounts',
    'accus.': 'accusative',
    'Achievem.': 'achievement',
    'ad.': 'adaptation of',
    'Add.': 'addendum, addenda',
    'Addit.': 'additions',
    'Addr.': 'address',
    'adj.': 'adjective, adjectival',
    'adj. phr.': 'adjectival phrase',
    'adjs.': 'adjectives',
    'Adm.': 'admiral, admiralty',
    'Admin.': 'administration, administrative',
    'Admir.': 'admiralty',
    'Admon.': 'admonition',
    'Admonit.': 'admonition',
    'Adv.': 'advices, advances, adventures',
    'adv.': 'adverb, adverbially',
    'Advancem.': 'advancements',
    'advb.': 'adverb, adverbially',
    'Advert.': 'advertisement',
    'Advoc.': 'advocate',
    'advs.': 'adverbs',
    'Advt.': 'advertisement',
    'Advts.': 'advertisements',
    'Aerodynam.': 'aerodynamics',
    'Aeronaut.': 'aeronautics, aeronautical',
    'Aff.': 'affairs',
    'Affect.': 'affecting, affections',
    'Afr.': 'African',
    'Agric.': 'agriculture, agricultural',
    'agst.': 'against',
    'Alch.': 'alchemy',
    'Alg.': 'algebra',
    'Alleg.': 'allegiance',
    'Allit.': 'alliterative',
    'Alm.': 'almanac',
    'Alph.': 'alphabet, alphabetical',
    'alt.': 'alteration',
    'Amer.': 'America, American',
    'Anal.': 'analysis',
    'Analyt.': 'analytical',
    'Anat.': 'anatomy, anatomical',
    'Anc.': 'ancient',
    'Anecd.': 'anecdotes',
    'Ang.': 'Anglian',
    'Angl.': 'Anglian',
    'Anglo-Ind.': 'Anglo-Indian',
    'Anim.': 'animals',
    'Ann.': 'annals, annual',
    'Anniv.': 'anniversary',
    'Annot.': 'annotation',
    'Anon.': 'Anonymous',
    'Answ.': 'answer',
    'Ant.': 'antiquities',
    'Anthrop.': 'anthropology',
    'Anthropol.': 'anthropology, anthropological',
    'Antiq.': 'antiquity, antiquities',
    'aphet.': 'aphetic, aphetized',
    'Apoc.': 'apocalyptical',
    'Apol.': 'apology, apologies',
    'App.': 'appendix',
    'app.': 'apparently',
    'Appl.': 'applied',
    'Applic.': 'applications',
    'appos.': 'appositively',
    'Apr.': 'April',
    'Arab.': 'Arabic',
    'Arb.': 'Arber',
    'Arch.': 'architecture, archives',
    'arch.': 'archaic',
    'Archaeol.': 'archaeology, archaeological',
    'Archipel.': 'archipelago',
    'Archit.': 'architecture, architectural',
    'Argt.': 'argument',
    'Arith.': 'arithmetic',
    'Arithm.': 'arithmetic, arithmetical',
    'Arrangem.': 'arrangement',
    'art.': 'article',
    'Artic.': 'articulation',
    'Artific.': 'artificial',
    'Artill.': 'artillery',
    'Ashm.': 'Ashmole',
    'Assemb.': 'assembly, assemblies',
    'Assoc.': 'association',
    'Assoc. Football': 'Association Football',
    'Assyriol.': 'Assyriology',
    'Astr.': 'astronomy',
    'Astrol.': 'astrology',
    'Astron.': 'astronomy, astronomical',
    'Astronaut.': 'astronautics, astronautical',
    'Att.': 'Attic',
    'attrib.': 'attributively',
    'Attrib.': 'attributes',
    'Aug.': 'August',
    'Austral.': 'Australian',
    'Auth.': 'authors',
    'Autobiog.': 'autobiography',
    'Autobiogr.': 'autobiography, autobiographical',
    'Ayrsh.': 'Ayrshire',
    'B.C.': 'Before Christ, British Columbia',
    'Bacteriol.': 'bacteriology, bacteriological',
    'Bedford.': 'Bedfordshire',
    'Bedfordsh.': 'Bedfordshire',
    'bef.': 'before',
    'Bel & Dr.': 'Bel and the Dragon',
    'Belg.': 'Belgian',
    'Berks.': 'Berkshire',
    'Berksh.': 'Berkshire',
    'Berw.': 'Berwickshire',
    'Berwicksh.': 'Berwickshire',
    'betw.': 'between',
    'Bibliogr.': 'bibliography',
    'Biochem.': 'biochemistry, biochemical',
    'Biog.': 'biography',
    'Biogr.': 'biography, biographical',
    'Biol.': 'biology, biological',
    'Bk.': 'book',
    'Bks.': 'books',
    'BNC': 'British National Corpus',
    'Bord.': 'border',
    'Bot.': 'botany, botanical',
    'Bp.': 'Bishop',
    'Braz.': 'Brazilian',
    'Brit.': 'Britain, British',
    'Bucks.': 'Buckinghamshire',
    'Build.': 'building',
    'Bull.': 'bulletin',
    'Bur.': 'bureau',
    'c': 'circa',
    'C.': 'county, counties',
    'c.': 'century',
    'Cal.': 'calendar',
    'Calc.': 'calculus',
    'Calend.': 'calendar',
    'Calif.': 'California',
    'Calligr.': 'calligraphy',
    'Camb.': 'Cambridge',
    'Cambr.': 'Cambridge',
    'Campanol.': 'campanology',
    'Canad.': 'Canadian',
    'Canterb.': 'Canterbury',
    'Capt.': 'captain',
    'Cartogr.': 'cartography, cartographical',
    'Catal.': 'catalogue',
    'Catech.': 'catechism',
    'Cath.': 'Catholic',
    'Cent.': 'central, Century',
    'cent.': 'century',
    'Ceram.': 'ceramics',
    'Cert.': 'certificate',
    'Certif.': 'certificate',
    'cf.': 'confer, compare',
    'Ch.': 'Church',
    'Ch. Hist.': 'Church history',
    'Chamb.': 'chamber',
    'Char.': 'character',
    'Charac.': 'character',
    'Chas.': 'Charles',
    'Chem.': 'chemistry, chemical',
    'Chem. Engin.': 'chemical engineering',
    'Chesh.': 'Cheshire',
    'Chr.': 'Chronicles, Christian',
    'Chron.': 'Chronicles, chronology, chronicle',
    'Chronol.': 'chronology',
    'Chrons.': 'chronicles',
    'Cinematogr.': 'cinematography, cinematographical',
    'Circ.': 'circle',
    'Civ. Law': 'civil law',
    'Civil Engin.': 'civil engineering',
    'Cl.': 'club',
    'cl.': 'clause',
    'Class.': 'classical',
    'Class. Antiq.': 'classical antiquities',
    'Classif.': 'classification',
    'Climatol.': 'climatology',
    'Clin.': 'clinical',
    'cogn. w.': 'cognate with',
    'Col.': 'Colossians, colonel',
    'Coll.': 'collected, collection, college',
    'collect.': 'collectively',
    'Collect.': 'collection',
    'Colloq.': 'colloquies',
    'colloq.': 'colloquially',
    'Coloss.': 'Colossians',
    'Com.': 'commission, common',
    'Comb.': 'combinations',
    'comb. form': 'combining form',
    'Combs.': 'combinations',
    'Comm.': 'committee, commission',
    'Comm. Law': 'commercial law',
    'Commandm.': 'commandment',
    'Commend.': 'commendation',
    'Commerc.': 'commercial',
    'Commiss.': 'commission',
    'Commonw.': 'commonwealth',
    'Communic.': 'communications',
    'comp.': 'comparative, compound, composition',
    'Comp.': 'companion, company',
    'Comp. Anat.': 'comparative anatomy',
    'Compan.': 'companions',
    'compar.': 'comparative',
    'Compar.': 'comparative',
    'Compend.': 'compendium, compendious',
    'Compl.': 'complete',
    'compl.': 'complement',
    'Compos.': 'composition',
    'Conc.': 'concise',
    'conc.': 'concerning',
    'Conch.': 'conchology',
    'Concl.': 'conclusion',
    'concr.': 'concretely',
    'Conf.': 'conference, confession',
    'Confid.': 'confidential',
    'Confl.': 'conflict',
    'Confut.': 'confutation',
    'Congr.': 'congress',
    'Congreg.': 'congregation',
    'Congress.': 'congressional',
    'conj.': 'conjugation, conjunction',
    'Conn.': 'Connecticut',
    'cons.': 'consonant',
    'Consc.': 'conscience',
    'Consecr.': 'consecrated, consecration',
    'Consid.': 'considerations',
    'Consol.': 'consolation',
    'const.': 'construction, construed with',
    'Constit.': 'constitutional',
    'Constit. Hist.': 'constitutional history',
    'Constr.': 'construction',
    'Contemp.': 'contemporary',
    'Contempl.': 'contemplation',
    'contempt.': 'contemptuously',
    'Contend.': 'contendings',
    'Content.': 'contention',
    'Contin.': 'continuation',
    'contr.': 'contracted, contraction, contrasted',
    'Contradict.': 'contradiction',
    'Contrib.': 'contribution',
    'Controv.': 'controversial, controversy',
    'Conv.': 'convention',
    'Convent.': 'convention',
    'Conversat.': 'conversation',
    'Convoc.': 'convocation',
    'Cor.': 'Corinthians',
    'Cornw.': 'Cornwall',
    'Coron.': 'coronation',
    'Corr.': 'correspondence',
    'corresp.': 'corresponding',
    'Corresp.': 'correspondence',
    'Counc.': 'council',
    'Courtsh.': 'courtship',
    'cpd.': 'compound',
    'Craniol.': 'craniology',
    'Craniom.': 'craniometry',
    'Crim.': 'criminal',
    'Crim. Law': 'criminal law',
    'Crit.': 'critical, criticism',
    'Crt.': 'court',
    'Crts.': 'courts',
    'Cryptogr.': 'cryptography',
    'Crystallogr.': 'crystallography',
    'Ct.': 'count, court',
    'Cumb.': 'Cumberland',
    'Cumberld.': 'Cumberland',
    'Cumbld.': 'Cumberland',
    'Cycl.': 'cyclopaedia',
    'Cytol.': 'cytology, cytological',
    'D.C.': 'District of Columbia',
    'Dan.': 'Daniel',
    'dat.': 'dative',
    'Dau.': 'daughter',
    'Deb.': 'debate',
    'Dec.': 'December',
    'Declar.': 'declaration',
    'Ded.': 'dedicated, dedication',
    'def.': 'definite, definition',
    'Def.': 'defence',
    'Deliv.': 'deliverance',
    'dem.': 'demonstrative',
    'Demonstr.': 'demonstration',
    'Dep.': 'department, deputy',
    'Depred.': 'depredation',
    'Depredat.': 'depredation',
    'Dept.': 'department',
    'Derbysh.': 'Derbyshire',
    'deriv.': 'derivative',
    'derog.': 'derogatory',
    'Descr.': 'description, descriptive',
    'Deut.': 'Deuteronomy',
    'Devel.': 'development',
    'Devonsh.': 'Devonshire',
    'dial.': 'dialect',
    'Dial.': 'dialect',
    'Dict.': 'dictionary',
    'Diffic.': 'difficult, difficulty',
    'dim.': 'diminutive',
    'Direct.': 'direction',
    'Dis.': 'diseases',
    'Disc.': 'discourse',
    'Discipl.': 'discipline',
    'Discov.': 'discovery',
    'Discrim.': 'discrimination',
    'Discuss.': 'discussion',
    'Diss.': 'dissertation',
    'Dist.': 'district',
    'Distemp.': 'distemper',
    'Distill.': 'distilling',
    'Distrib.': 'distribution',
    'Div.': 'divinity, division',
    'Divers.': 'diversity',
    'Dk.': 'Duke',
    'Doc.': 'documents',
    'Doctr.': 'doctrine',
    'Domest.': 'domestic',
    'Durh.': 'Durham',
    'dyslog.': 'dyslogistic',
    'E.': 'east, eastern',
    'e.': 'east',
    'E. Afr.': 'East African',
    'E. Angl.': 'East Anglian',
    'E. Anglian': 'East Anglian',
    'E. Ind.': 'East Indies, East Indian',
    'e. midl.': 'east midland',
    'E.D.D.': 'English Dialect Dictionary',
    'E.E.T.S.': 'Early English Text Society',
    'East Ind.': 'East Indies, East Indian',
    'east.': 'eastern',
    'Eccl.': 'Ecclesiastes, ecclesiastical',
    'Eccl. Hist.': 'ecclesiastical history',
    'Eccl. Law': 'ecclesiastical law',
    'Eccles.': 'Ecclesiastes, ecclesiastical',
    'Ecclus.': 'Ecclesiasticus',
    'Ecol.': 'ecology, ecological',
    'Econ.': 'economics, economical',
    'Ed.': 'Edward, edition',
    'ed.': 'edition',
    'Edin.': 'Edinburgh',
    'Edinb.': 'Edinburgh',
    'Educ.': 'education, educational',
    'Edw.': 'Edward',
    'Egypt.': 'Egyptian',
    'Egyptol.': 'Egyptology',
    'Electr.': 'electricity, electrical',
    'Electr. Engin.': 'electrical engineering',
    'Electro-magn.': 'electro-magnetism',
    'Electro-physiol.': 'electro-physiology',
    'Elem.': 'elements, elementary',
    'Eliz.': 'Elizabeth',
    'Elizab.': 'Elizabethan',
    'ellipt.': 'elliptically',
    'Emb.': 'embassy',
    'Embryol.': 'embryology, embryological',
    'emph.': 'emphatically',
    'Encycl.': 'encyclopaedia, encyclopaedic',
    'Encycl. Brit.': 'Encyclopaedia Britannica',
    'Encycl. Metrop.': 'Encyclopaedia Metropolitana',
    'Eng.': 'England, English',
    'Engin.': 'engineering',
    'Englishw.': 'Englishwomen',
    'Enq.': 'enquiry',
    'Ent.': 'entomology, entomological',
    'Enthus.': 'enthusiasm',
    'Entom.': 'entomology, entomological',
    'Entomol.': 'entomology, entomological',
    'Enzymol.': 'enzymology',
    'eOE': 'early Old English',
    'Ep.': 'epistle',
    'Eph.': 'Ephesians',
    'Ephes.': 'Ephesians',
    'Epil.': 'epilogue',
    'Episc.': 'episcopacy',
    'Epist.': 'epistle',
    'Epit.': 'epitaph',
    'Equip.': 'equipment',
    'erron.': 'erroneously',
    'Esd.': 'Esdras',
    'esp.': 'especially',
    'Ess.': 'essays',
    'Essent.': 'essential',
    'Establ.': 'establishment',
    'Esth.': 'Esther',
    'Ethnol.': 'ethnology',
    'etym.': 'etymology',
    'Etymol.': 'etymology, etymological',
    'etymol.': 'etymologically',
    'euphem.': 'euphemistically',
    'Eval.': 'evaluation',
    'Evang.': 'evangelical',
    'Even.': 'evening',
    'Evid.': 'evidence',
    'Evol.': 'evolution, evolutionary',
    'Ex. doc.': 'executive document',
    'Exalt.': 'exaltation',
    'Exam.': 'examination',
    'exc.': 'except',
    'Exch.': 'exchange, exchequer',
    'Exec.': 'execution, executive',
    'Exerc.': 'exercises',
    'Exhib.': 'exhibition, exhibits',
    'Exod.': 'Exodus',
    'Exped.': 'expedition',
    'Exper.': 'experiment, experimental',
    'Explan.': 'explanation',
    'Explic.': 'explication',
    'Explor.': 'exploration',
    'Expos.': 'exposition, expository',
    'Ezek.': 'Ezekiel',
    'f.': 'feminine, folio',
    'Fab.': 'fables',
    'Fam.': 'family',
    'fam.': 'familiarly',
    'famil.': 'familiarly',
    'Farew.': 'farewell',
    'Feb.': 'February',
    'fem.': 'feminine',
    'Ff.': 'folios',
    'Fifesh.': 'Fifeshire',
    'fig.': 'figuratively',
    'fl.': 'floruit, flourished',
    'Footpr.': 'footprint',
    'Forfarsh.': 'Forfarshire',
    'Fortif.': 'fortification',
    'Fortn.': 'fortnightly',
    'Found.': 'foundations',
    'Fr.': 'French, father',
    'Fragm.': 'fragments',
    'Fratern.': 'fraternity',
    'freq.': 'frequently',
    'Friendsh.': 'friendship',
    'Fund.': 'fundamentals',
    'Furnit.': 'furniture',
    'fut.': 'future',
    'Gal.': 'Galatians',
    'Gard.': 'garden, gardening',
    'Gastron.': 'gastronomy',
    'Gaz.': 'gazette',
    'Gd.': 'good',
    'gen.': 'generally, genetive',
    'Gen.': 'Genesis, general',
    'Geo.': 'George',
    'Geog.': 'geography',
    'Geogr.': 'geography, geographical',
    'Geol.': 'geology, geological',
    'Geom.': 'geometry, geometrical',
    'Geomorphol.': 'geomorphology',
    'Ger.': 'German',
    'gerund.': 'gerundial',
    'Glac.': 'glaciers',
    'Glasg.': 'Glasgow',
    'Glos.': 'Gloucestershire',
    'Gloss.': 'glossary',
    'Glouc.': 'Gloucestershire',
    'Gloucestersh.': 'Gloucestershire',
    'Gosp.': 'gospels',
    'Gov.': 'government',
    'Govt.': 'government',
    'Gr.': 'grammar',
    'Gram.': 'grammar',
    'Gramm. Analysis': 'grammatical analysis',
    'Gt.': 'great',
    'Gynaecol.': 'gynaecology',
    'Hab.': 'Habakkuk',
    'Haematol.': 'haematology',
    'Hag.': 'Haggai',
    'Hampsh.': 'Hampshire',
    'Handbk.': 'handbook',
    'Hants.': 'Hampshire',
    'Heb.': 'Hebrews, Hebrew',
    'Hebr.': 'Hebrews',
    'Hen.': 'Henry',
    'Her.': 'heraldry',
    'Herb.': 'herbalism',
    'Heref.': 'Herefordshire',
    'Hereford.': 'Herefordshire',
    'Herefordsh.': 'Herefordshire',
    'Hertfordsh.': 'Hertfordshire',
    'Hierogl.': 'Hieroglyphic',
    'Hist.': 'history, historical',
    'hist.': 'historical',
    'Histol.': 'histology, histological',
    'Hom.': 'homilies',
    'Horol.': 'horology',
    'Hort.': 'horticulture, horticultural',
    'Hos.': 'Hosea',
    'Hosp.': 'hospital',
    'Househ.': 'household',
    'Housek.': 'housekeeping',
    'Husb.': 'husbandry',
    'Hydraul.': 'hydraulic',
    'Hydrol.': 'hydrology, hydrological',
    'Ichth.': 'ichthyology',
    'Icthyol.': 'icthyology',
    'Ideol.': 'ideology, ideological',
    'Idol.': 'idolatry',
    'Illustr.': 'illustrated, illustrations',
    'Imag.': 'imaginary, imagination',
    'imit.': 'imitative',
    'Immunol.': 'immunology',
    'imp.': 'imperative',
    'imperf.': 'imperfect',
    'impers.': 'impersonal',
    'impf.': 'imperfect',
    'Impr.': 'imprint, impressions',
    'improp.': 'improperly',
    'Inaug.': 'inaugural',
    'Inclos.': 'inclosure',
    'ind.': 'indicative, indirect',
    'Ind.': 'industry, Indian',
    'indef.': 'indefinite',
    'indic.': 'indicative',
    'indir.': 'indirect',
    'Industr.': 'industrial',
    'Industr. Rel.': 'industrial relations',
    'infin.': 'infinitive',
    'infl.': 'influenced',
    'Infl.': 'influence',
    'Innoc.': 'innocence, innocent',
    'Inorg.': 'inorganic',
    'Inq.': 'inquiry',
    'Inst.': 'institute, institution',
    'instr.': 'instrumental',
    'Instr.': 'instruction',
    'int.': 'interjection',
    'Intell.': 'intelligence, intelligent',
    'Intellect.': 'intellectual',
    'Interc.': 'intercourse',
    'interj.': 'interjection',
    'Interl.': 'interlude',
    'Internat.': 'international',
    'Interpr.': 'interpretation',
    'interrog.': 'interrogative',
    'intr.': 'intransitive',
    'intrans.': 'intransitive',
    'Intro.': 'introduction',
    'Introd.': 'introduction, introductory',
    'Inv.': 'inventory, inventories',
    'Invent.': 'inventions, inventory, inventories',
    'Invert. Zool.': 'invertebrate zoology',
    'Invertebr.': 'invertebrate, invertebrated',
    'Investig.': 'investigation',
    'Investm.': 'investment',
    'Invoc.': 'invocation',
    'Ir.': 'Irish',
    'Irel.': 'Ireland',
    'iron.': 'ironically',
    'irreg.': 'irregularly',
    'Isa.': 'Isaiah',
    'Ital.': 'Italian',
    'Jahrb.': 'Jahrbuch',
    'Jam.': 'Jamieson, James',
    'Jan.': 'January',
    'Jap.': 'Japanese',
    'Jas.': 'James, James',
    'Jer.': 'Jeremiah',
    'joc.': 'jocularly',
    'Josh.': 'Joshua',
    'Jrnl.': 'journal',
    'Jrnls.': 'journals',
    'Jud.': 'Judges',
    'Judg.': 'Judges',
    'Jul.': 'July',
    'Jun.': 'June, junior',
    'Jurisd.': 'jurisdiction',
    'Jurisdict.': 'jurisdiction',
    'Jurispr.': 'jurisprudence',
    'Justif.': 'justification',
    'Justific.': 'justification',
    'K.': 'king',
    'Kent.': 'Kentish',
    'Kgs.': 'Kings',
    'King\'s Bench Div.': 'King\'s Bench Division',
    'Kingd.': 'kingdom',
    'Knowl.': 'knowledge',
    'Kpr.': 'keeper',
    'l.': 'line',
    'Lab.': 'laboratory',
    'Lam.': 'Lamentations',
    'Lament': 'lamentation',
    'Lament.': 'Lamentations',
    'Lanc.': 'Lancashire',
    'Lancash.': 'Lancashire',
    'Lancs.': 'Lancashire',
    'Lang.': 'language',
    'Langs.': 'languages',
    'Lat.': 'Latin',
    'Ld.': 'Lord',
    'Lds.': 'Lords',
    'Lect.': 'lectures',
    'Leechd.': 'leechdom',
    'Leg.': 'legends',
    'Leicest.': 'Leicestershire',
    'Leicester.': 'Leicestershire',
    'Leicestersh.': 'Leicestershire',
    'Leics.': 'Leicestershire',
    'Let.': 'letter',
    'Lett.': 'letters',
    'Lev.': 'Leviticus',
    'Lex.': 'lexicon',
    'Libr.': 'library',
    'Limnol.': 'limnology',
    'Lincolnsh.': 'Lincolnshire',
    'Lincs.': 'Lincolnshire',
    'Ling.': 'linguistics',
    'Linn.': 'Linnean',
    'Lit.': 'literary, literature',
    'lit.': 'literally',
    'Lithogr.': 'lithography',
    'Lithol.': 'lithology',
    'Liturg.': 'liturgy',
    'll.': 'lines',
    'lOE': 'late Old English',
    'Lond.': 'London',
    'LXX': 'Septuagint',
    'm.': 'masculine',
    'Macc.': 'Maccabees',
    'Mach.': 'machinery, machines',
    'Mag.': 'magazine',
    'Magn.': 'magnetism, magnetic',
    'Mal.': 'Malachi',
    'Man.': 'manual',
    'Managem.': 'management',
    'Manch.': 'Manchester',
    'Manip.': 'manipulation',
    'Manuf.': 'manufacturing, manufactures',
    'Mar.': 'March',
    'masc.': 'masculine',
    'Mass.': 'Massachussets',
    'Math.': 'mathematics, mathematical',
    'Matt.': 'Matthew',
    'Meas.': 'measure',
    'Measurem.': 'measurement',
    'Mech.': 'mechanics, mechanical',
    'med.': 'medieval',
    'Med.': 'medicine, medical',
    'Medit.': 'meditation',
    'Mem.': 'memoirs',
    'Merc.': 'mercury',
    'Merch.': 'merchants',
    'Metall.': 'metallurgy',
    'Metallif.': 'metalliferous',
    'Metallogr.': 'metallography, metallography, metallographical',
    'Metamorph.': 'metamorphosis',
    'Metaph.': 'metaphysics',
    'metaphor.': 'metaphorically',
    'Meteorol.': 'meteorology, meteorological',
    'Meth.': 'methods',
    'metr. gr.': 'metri gratia',
    'Metrop.': 'metropolitan, metropolis',
    'Mex.': 'Mexican',
    'Mic.': 'Micah',
    'Mich.': 'Michigan',
    'Microbiol.': 'microbiology',
    'Microsc.': 'microscopical',
    'midl.': 'midlands',
    'Mil.': 'military',
    'Milit.': 'military',
    'Min.': 'mineralogy',
    'Mineral.': 'mineralogy, minaralogical',
    'Misc.': 'miscellaneous, miscellany',
    'Miscell.': 'miscellany',
    'mispr.': 'misprinted',
    'mod.': 'modern',
    'Mod.': 'modern',
    'Monum.': 'monument',
    'Morphol.': 'morphology',
    'MS.': 'manuscript',
    'MSS.': 'manuscripts',
    'Mt.': 'mount',
    'Mtg.': 'meeting',
    'Mts.': 'mountains',
    'Munic.': 'municipal',
    'Munif.': 'munificence',
    'Munim.': 'muniment',
    'Mus.': 'museum, music, musical',
    'Myst.': 'mystery',
    'Myth.': 'mythology',
    'Mythol.': 'mythology',
    'n.': 'neuter, noun, north',
    'N.': 'north, northern',
    'N. Afr.': 'North African',
    'N. Amer.': 'North American',
    'N. Carolina': 'North Carolina',
    'N. Dakota': 'North Dakota',
    'N. Ir.': 'Northern Irish',
    'N. Irel.': 'Northern Ireland',
    'n.e.': 'north-eastern',
    'N.E.': 'north-east, north-eastern',
    'N.E.D.': 'New English Dictionary',
    'N.S. Wales': 'New South Wales',
    'N.S.W.': 'New South Wales',
    'NSW': 'New South Wales',
    'N.T.': 'New Testament',
    'NT': ' Northern Territory',
    'n.w.': 'north-western',
    'N.W.': 'north-west, north-western',
    'N.Y.': 'New York',
    'N.Z.': 'New Zealand',
    'Nah.': 'Nahum',
    'Narr.': 'narrative',
    'Narrat.': 'narrative',
    'Nat.': 'natural',
    'Nat. Hist.': 'natural history',
    'Nat. Philos.': 'natural philosophy',
    'Nat. Sci.': 'natural science',
    'Naut.': 'nautical',
    'Nav.': 'naval, navigation',
    'Navig.': 'navigation',
    'Neh.': 'Nehemiah',
    'Neighb.': 'neighbours, neighbourhood',
    'Nerv.': 'nervous',
    'Neurol.': 'neurology, neurological',
    'Neurosurg.': 'neurosurgery',
    'New Hampsh.': 'New Hampshire',
    'Newc.': 'Newcastle',
    'Newspr.': 'newsprint',
    'No.': 'number',
    'nom.': 'nominative',
    'nonce-wd.': 'nonce-word',
    'Nonconf.': 'nonconformists',
    'Non-conf.': 'nonconformists',
    'Norf.': 'Norfolk',
    'north.': 'northern',
    'Northamptonsh.': 'Northamptonshire',
    'Northants.': 'Northamptonshire',
    'Northumb.': 'Northumberland, Northumbrian',
    'Northumbld.': 'Northumberland',
    'Northumbr.': 'Northumbrian',
    'Norw.': 'Norwegian',
    'Norweg.': 'Norwegian',
    'Notts.': 'Nottinghamshire',
    'Nov.': 'November',
    'ns.': 'nouns',
    'Nucl.': 'nuclear',
    'Num.': 'Numbers',
    'Numism.': 'numismatics',
    'O.E.D.': 'Oxford English Dictionary',
    'O.T.': 'Old Testament',
    'Obad.': 'Obadiah',
    'Obed.': 'obedience',
    'Obj.': 'objects',
    'obj.': 'object, objective',
    'obl.': 'oblique',
    'obs.': 'obsolete',
    'Obs.': 'obsolete',
    'Observ.': 'observations',
    'Obstet.': 'obstetrics',
    'Obstetr.': 'obstetrics',
    'Obstetr. Med.': 'obstetric medicine',
    'occas.': 'occasionally',
    'Occas.': 'occasional',
    'Occup.': 'occupational',
    'Occurr.': 'occurrence',
    'Oceanogr.': 'oceanography, oceanographical',
    'Oct.': 'October',
    'OE': 'Old English',
    'Off.': 'official, office',
    'Offic.': 'official',
    'Okla.': 'Oklahoma',
    'Ont.': 'Ontario',
    'Ophthalm.': 'ophthalmology',
    'Ophthalmol.': 'ophthalmology, ophtalmological',
    'opp.': 'opposed, opposite',
    'Oppress.': 'oppression',
    'Opt.': 'optics',
    'Orac.': 'oracles',
    'Ord.': 'orders, ordinances',
    'Org.': 'organic',
    'Org. Chem.': 'organic chemistry',
    'Organ. Chem.': 'organic chemistry',
    'orig.': 'originally',
    'Orig.': 'original',
    'Orkn.': 'Orkney',
    'Ornith.': 'ornithology',
    'Ornithol.': 'ornithology, ornithological',
    'Orthogr.': 'orthography',
    'Outl.': 'outline',
    'Oxf.': 'Oxford',
    'Oxfordsh.': 'Oxfordshire',
    'Oxon.': 'Oxfordshire',
    'p.': 'page',
    'P. R.': 'public records',
    'Pa.': 'Pennsylvania',
    'pa.': 'past',
    'pa. pple.': 'passive participle, past participle',
    'pa. t.': 'past tense',
    'Palaeobot.': 'palaeobotany',
    'Palaeogr.': 'palaeography',
    'Palaeont.': 'palaeontology',
    'Palaeontol.': 'palaeontology, palaeontological',
    'Paraphr.': 'paraphrase, paraphrased',
    'Parasitol.': 'parasitology',
    'Parl.': 'parliament, parliamentary',
    'Parnass.': 'Parnassus',
    'pass.': 'passively',
    'Path.': 'pathology, pathological',
    'Pathol.': 'pathology, pathological',
    'Peculat.': 'peculations',
    'Penins.': 'peninsula',
    'Perf.': 'perfect, perfection',
    'perf.': 'perfect',
    'perh.': 'perhaps',
    'Periodontol.': 'periodontology, periodontological',
    'Pers.': 'personal, Persian',
    'pers.': 'personal',
    'Persec.': 'persecutions',
    'personif.': 'personified',
    'Perthsh.': 'Perthshire',
    'Pet.': 'Peter',
    'Petrogr.': 'petrography, petrographical',
    'Petrol.': 'petrology, petrological',
    'pf.': 'perfect',
    'Pharm.': 'pharmacology',
    'Pharmaceut.': 'pharmaceutical',
    'Pharmacol.': 'pharmacology, pharmacological',
    'Phil.': 'Philippians, philosophy, philosophical',
    'Philad.': 'Philadelphia',
    'Philem.': 'Philemon',
    'Philipp.': 'Philippians',
    'Philol.': 'philology, philological',
    'Philos.': 'philosophy, philosophical',
    'Phoen.': 'Phoenician',
    'phonet.': 'phonetically',
    'Phonol.': 'phonology',
    'Photog.': 'photography',
    'Photogr.': 'photography, photographical',
    'phr.': 'phrase',
    'Phrenol.': 'phrenology',
    'Phys.': 'physiology',
    'Physical Chem.': 'physical chemistry',
    'Physical Geogr.': 'physical geography',
    'Physiogr.': 'physiography',
    'Physiol.': 'physiology, physiological',
    'Pict.': 'pictorial, pictures',
    'pl.': 'plural',
    'plur.': 'plural',
    'Poet.': 'poetical',
    'poet.': 'poetical',
    'Pol.': 'politics, political',
    'Pol. Econ.': 'political economy',
    'Polit.': 'politics, political',
    'Polytechn.': 'polytechnical',
    'pop.': 'popularly',
    'Pop.': 'popular',
    'Porc.': 'porcelain',
    'Port.': 'Portuguese',
    'poss.': 'possessive, possible, possibly',
    'Posth.': 'posthumously',
    'Postm.': 'postmaster',
    'Pott.': 'pottery',
    'ppl.': 'participial',
    'ppl. a.': 'participial adjective',
    'ppl. adj.': 'participial adjective',
    'ppl. adjs.': 'participial adjectives',
    'pple.': 'participle',
    'pples.': 'participles',
    'pr.': 'present',
    'pr. pple.': 'present participle',
    'Pract.': 'practical, practice',
    'prec.': 'preceding',
    'pred.': 'predicate',
    'predic.': 'predicate, predicatively',
    'Predict.': 'prediction',
    'pref.': 'prefix',
    'Pref.': 'preface',
    'Preh.': 'prehistoric',
    'Prehist.': 'prehistory, prehistoric',
    'prep.': 'prepositional',
    'Prerog.': 'prerogative',
    'pres.': 'present',
    'Pres.': 'present',
    'pres. pple.': 'present participle',
    'Presb.': 'Presbyterian, presbytery',
    'Preserv.': 'preservation',
    'Prim.': 'primers',
    'Princ.': 'principles',
    'Print.': 'printing',
    'priv.': 'privative',
    'prob.': 'probably',
    'Probab.': 'probability, probabilities',
    'Probl.': 'problem',
    'Proc.': 'proceedings',
    'Prod.': 'products',
    'Prol.': 'prologue',
    'pron.': 'pronoun, pronunciation',
    'pronunc.': 'pronunciation',
    'Pronunc.': 'pronunciation',
    'Prop.': 'property, properties',
    'prop.': 'properly',
    'propr.': 'proprietary',
    'Pros.': 'prosody',
    'Prov.': 'Proverbs, proverb',
    'prov.': 'proverb, proverbial, proverbially',
    'Provid.': 'providences',
    'Provinc.': 'provincial',
    'Provis.': 'provisional',
    'Ps.': 'Psalms',
    'pseudo-arch.': 'pseudo-archaic',
    'pseudo-dial.': 'pseudo-dialect',
    'pseudo-Sc.': 'pseudo-Scots',
    'Psych.': 'psychology',
    'Psychoanal.': 'psychoanalysis',
    'Psychoanalyt.': 'psychoanalytic',
    'Psychol.': 'psychology, psychological',
    'Psychopathol.': 'psychopathology, psychopathological',
    'Pt.': 'part',
    'Publ.': 'public, publication',
    'Purg.': 'purgatory',
    'Q.': 'quarterly, queen',
    'Q. Eliz.': 'Queen Elizabeth',
    'q.v.': 'quod vide, which see',
    'Qld.': 'Queensland',
    'Quantum Mech.': 'quantum mechanics',
    'Queen\'s Bench Div.': 'Queen\'s Bench Division',
    'quot.': 'quotation',
    'quots.': 'quotations',
    'R.': 'royal',
    'R.A.F.': 'Royal Air Force',
    'R.C.': 'Roman Catholic',
    'R.C. Church': 'Roman Catholic Church',
    'R.N.': 'Royal Navy',
    'Radiol.': 'radiology',
    'Reas.': 'reasons',
    'Reb.': 'rebellion',
    'Rebell.': 'rebellion',
    'Rec.': 'records',
    'Reclam.': 'reclamation',
    'Recoll.': 'recollection',
    'Redempt.': 'redemption',
    'redupl.': 'reduplicating',
    'Ref.': 'reference, reformation',
    'refash.': 'refashioned, refashioning',
    'refl.': 'reflexive',
    'Refl.': 'reflections',
    'Refus.': 'refusal',
    'Refut.': 'refutation',
    'reg.': 'regular',
    'Reg.': 'register',
    'Regic.': 'regicide',
    'Regist.': 'register',
    'Regr.': 'register',
    'rel.': 'relative, related',
    'Rel.': 'relating',
    'Relig.': 'religion, religious',
    'Reminisc.': 'reminiscences',
    'Remonstr.': 'remonstrance',
    'Renfrewsh.': 'Renfrewshire',
    'Rep.': 'report',
    'repr.': 'representative, representing',
    'Reprod.': 'reproduction, reproductive',
    'Rept.': 'report',
    'Repub.': 'republic',
    'Res.': 'research',
    'Resid.': 'residence, residential',
    'Ret.': 'return',
    'Retrosp.': 'retrospective',
    'Rev.': 'review, Revelation',
    'Revol.': 'revolution',
    'rhet.': 'rhetorically',
    'Rhet.': 'rhetoric',
    'Rhode Isl.': 'Rhode Island',
    'Rich.': 'Richard',
    'Rom.': 'Roman, Romans',
    'Rom. Antiq.': 'Roman antiquities',
    'Ross-sh.': 'Ross-shire',
    'Roxb.': 'Roxburgh',
    'Roy.': 'royal',
    'Rudim.': 'rudiments',
    'Russ.': 'Russia, Russian',
    'S.': 'south, southern',
    's.': 'south',
    'S. Afr.': 'South African',
    'SA': 'South Australia',
    'S. Carolina': 'South Carolina',
    'S. Dakota': 'South Dakota',
    's.e.': 'south-eastern',
    'S.E.': 'south-east, south-eastern',
    'S.T.S.': 'Scottish Text Society',
    's.v.': 'sub verbo, under the word',
    's.w.': 'south-western dialect',
    'S.W.': 'south-west, south-western',
    'Sam.': 'Samuel',
    'Sask.': 'Saskatchewan',
    'Sat.': 'Saturday',
    'Sax.': 'Saxon',
    'Sc.': 'Scottish, Scots',
    'sc.': 'scilicet, understand or supply',
    'Scand.': 'Scandinavia, Scandinavian',
    'Sch.': 'school',
    'Sci.': 'sciences, scientific',
    'Scot.': 'Scottish',
    'Scotl.': 'Scotland',
    'Script.': 'scripture',
    'Sculpt.': 'sculpture',
    'Seismol.': 'seismology',
    'Sel.': 'selected',
    'Sel. comm.': 'select committee',
    'Select.': 'selection',
    'Sept.': 'September',
    'Ser.': 'series',
    'Serm.': 'sermons',
    'Sess.': 'session',
    'Settlem.': 'settlement',
    'Sev.': 'several',
    'Shakes.': 'Shakespeare',
    'Shaks.': 'Shakespeare',
    'Sheph.': 'shepherd',
    'Shetl.': 'Shetland',
    'Shropsh.': 'Shropshire',
    'sing.': 'singular',
    'Soc.': 'society',
    'Sociol.': 'sociology, sociological',
    'Som.': 'Somerset',
    'Song of Sol.': 'Song of Solomon',
    'Song Sol.': 'Song of Solomon',
    'Sonn.': 'sonnet',
    'south.': 'southern',
    'sp.': 'spelling',
    'Span.': 'Spanish',
    'Spec.': 'specimens, special',
    'spec.': 'specifically, special',
    'Specif.': 'specifications',
    'Specim.': 'specimens',
    'Spectrosc.': 'spectroscopy',
    'SS.': 'saints',
    'St.': 'Saint, street',
    'Staff.': 'Staffordshire',
    'Stafford.': 'Staffordshire',
    'Staffordsh.': 'Staffordshire',
    'Staffs.': 'Staffordshire',
    'Stand.': 'standard',
    'Stat.': 'statistical',
    'Statist.': 'statistical',
    'Stock Exch.': 'stock exchange',
    'str.': 'strong',
    'Stratigr.': 'stratigraphy, stratigraphical',
    'Struct.': 'structure, structural',
    'Stud.': 'studies',
    'subj.': 'subjunctive, subject',
    'Subj.': 'subjects',
    'subjunct.': 'subjunctive',
    'subord.': 'subordinate',
    'subord. cl.': 'subordinate clause',
    'Subscr.': 'subscription',
    'Subscript.': 'subscription',
    'subseq.': 'subsequently',
    'subst.': 'substantively',
    'Suff.': 'Suffolk',
    'suff.': 'suffix',
    'superl.': 'superlative',
    'Suppl.': 'supplement, supplementary',
    'Supplic.': 'supplications',
    'Suppress.': 'suppression',
    'Surg.': 'surgery, surgical',
    'Surv.': 'survey, surveying',
    'Sus.': 'Susanna',
    'syll.': 'syllable',
    'Symmetr.': 'symmetrical',
    'Symp.': 'symposium',
    'Syst.': 'system',
    't.': 'tense',
    'Taxon.': 'taxonomy, taxonomic',
    'techn.': 'technical',
    'Techn.': 'technical',
    'Technol.': 'technology, technological',
    'Tel.': 'telegraph',
    'Telecomm.': 'telecommunications',
    'Telegr.': 'telegraph, telegraphy, telegraphical',
    'Teleph.': 'telephony, telephonic',
    'Teratol.': 'teratology',
    'Terminol.': 'terminology, terminological',
    'Terrestr.': 'terrestrial',
    'Test.': 'testament',
    'Textbk.': 'textbook',
    'Theat.': 'theatre, theatrical',
    'Theatr.': 'theatre, theatrical',
    'Theol.': 'theology, theological',
    'Theoret.': 'theoretical',
    'Thermonucl.': 'thermonuclear',
    'Thes.': 'thesaurus',
    'Thess.': 'Thessalonians',
    'Tim.': 'Timothy',
    'Tit.': 'Titus',
    'Topogr.': 'topography, topographical',
    'tr.': 'translation, translating',
    'Trad.': 'tradition, traditional',
    'Trag.': 'tragedy',
    'trans.': 'transitive',
    'Trans.': 'transactions',
    'transf.': 'transferred sense',
    'transl.': 'translation, translating',
    'Transl.': 'translation',
    'Transubstant.': 'transubstantiation',
    'Trav.': 'travels',
    'Treas.': 'treasurer, treasury',
    'Treat.': 'treatise',
    'Treatm.': 'treatment',
    'Trib.': 'tribune',
    'Trig.': 'trigonometry',
    'Trigonom.': 'trigonometry',
    'Trop.': 'tropical',
    'Troub.': 'troublesome',
    'Troubl.': 'troublesome',
    'Typog.': 'typography',
    'Typogr.': 'typography',
    'U.K.': 'United Kingdom',
    'U.S.': 'United States',
    'U.S.A.': 'United States of America',
    'U.S.A.F.': 'United States Air Force',
    'U.S.S.R.': 'Union of Soviet Socialist Republics',
    'UK': 'United Kingdom',
    'US': 'United States',
    'USA': 'United States of America',
    'USAF': 'United States Air Force',
    'USSR': 'Union of Soviet Socialist Republics',
    'ult.': 'ultimately',
    'Univ.': 'university',
    'unkn.': 'unknown',
    'Unnat.': 'unnatural',
    'Unoffic.': 'unofficial',
    'unstr.': 'unstressed',
    'Urin.': 'urinary',
    'usu.': 'usually',
    'Utilit.': 'utilitarian',
    'v.': 'verb',
    'v.r.': 'variant reading',
    'v.rr.': 'variant readings',
    'Va.': 'Virginia',
    'Vac.': 'vacation',
    'Valedict.': 'valediction',
    'var.': 'variant',
    'varr.': 'variants',
    'vars.': 'variants',
    'vb.': 'verb',
    'vbl.': 'verbal',
    'vbl. ns.': 'verbal nouns',
    'vbl.n.': 'verbal noun',
    'vbs.': 'verbs',
    'Veg.': 'vegetable',
    'Veg. Phys.': 'vegetable physiology',
    'Veg. Physiol.': 'vegetable physiology',
    'Venet.': 'Venetian',
    'Vertebr.': 'vertebrate',
    'Vet.': 'veterinary, veterinary science',
    'Vet. Med.': 'veterinary medicine',
    'Vet. Path.': 'veterinary pathology',
    'Vet. Sci.': 'veterinary science',
    'Vet. Surg.': 'veterinary surgery',
    'Vic.': 'Victoria',
    'Vic': 'Victoria',
    'Vict.': 'Victoria',
    'Vind.': 'vindication, vindicated',
    'Vindic.': 'vindication, vindicated',
    'Virg.': 'virgins',
    'Virol.': 'virology',
    'viz.': 'videlicet, namely',
    'Voc.': 'vocabulary',
    'Vocab.': 'vocabulary',
    'Vol.': 'volume',
    'Vols.': 'volumes',
    'Voy.': 'voyages',
    'Vulg.': 'Vulgate, vulgar',
    'vulg.': 'vulgarly',
    'W.': 'west, western',
    'w.': 'west',
    'W. Afr.': 'West African',
    'W. Ind.': 'West Indies, West Indian',
    'W. Indies': 'West Indies',
    'W. Va.': 'West Virginia',
    'WA': 'Western Australia',
    'Warwicksh.': 'Warwickshire',
    'wd.': 'word',
    'Wd.': 'word',
    'west.': 'western',
    'Westm.': 'Westminster',
    'Westmld.': 'Westmoreland',
    'Westmorld.': 'Westmoreland',
    'Westmrld.': 'Westmoreland',
    'Will.': 'William',
    'Wilts.': 'Wiltshire',
    'Wiltsh.': 'Wiltshire',
    'Wis.': 'Wisconsin',
    'Wisd.': 'Wisdom of Solomon, wisdom',
    'Wk.': 'week, work',
    'wk.': 'weak',
    'Wkly.': 'weekly',
    'Wks.': 'works',
    'Wonderf.': 'wonderful',
    'Worc.': 'Worcestershire',
    'Worcestersh.': 'Worcestershire',
    'Worcs.': 'Worcestershire',
    'Writ.': 'writings',
    'Yearbk.': 'yearbook',
    'Yng.': 'young',
    'Yorks.': 'Yorkshire',
    'Yorksh.': 'Yorkshire',
    'Yr.': 'year',
    'Yrs.': 'years',
    'Zech.': 'Zechariah',
    'Zeitschr.': 'Zeitschrift',
    'Zeph.': 'Zephaniah',
    'Zoogeogr.': 'zoogeography',
    'Zool.': 'zoology, zoological',
  };
}
