// BSD 3-Clause License
// Copyright ©2022, GM Consult Pty Ltd
// Copyright ©2022, [Princeton University](https://wordnet.princeton.edu/license-and-commercial-use)
// All rights reserved
/// The lexicon was taken from Brill's rule based tagger v1.14,
/// trained on Brown corpus and Penn Treebank.
///
/// Eric Brill (1992). A simple rule-based part of speech tagger.
/// In Proceedings of the workshop on Speech and Natural Language (pp. 112-116).
/// Association for Computational Linguistics.
///
/// Copyright 1993 by the Massachusetts Institute of Technology and the
/// University of Pennsylvania. All rights reserved. MIT license.
///
/// Additional words were added from the Twitter Part-of-Speech Annotated Data,
/// available under the Creative Commons Attribution 3.0 Unported license ("CC-BY").
/// Carnegie Mellon University. http://www.ark.cs.cmu.edu/TweetNLP
///
/// Kevin Gimpel, Nathan Schneider, Brendan O'Connor, et al. (2011).
/// Part-of-Speech Tagging for Twitter: Annotation, Features, and Experiments.
/// In Proceedings of the Annual Meeting of the ACL, Portland, OR, June 2011.
/// English lexicon with Part-of-Speech tags from WordNet® data.
const englishLexicon = {
  '!': ['.'],
  '!!': ['.'],
  '!!!': ['.'],
  '!!!!': ['.'],
  '!!!!!': ['.'],
  '!!!!!!': ['.'],
  '!!!!!!!': ['.'],
  '!!!!!!!!': ['.'],
  '!.': ['.'],
  '!?': ['.'],
  '"': ['"'],
  '#': ['#'],
  '#1': ['CD'],
  '#2': ['CD'],
  '#GLEE': ['NNP'],
  '#Glee': ['NNP'],
  '#celtics': ['NNPS'],
  '#fail': ['NN'],
  '#fb': ['NNP'],
  '#glee': ['NNP'],
  '#howcome': ['VB'],
  '#lakers': ['NNPS'],
  '#shoutout': ['NN'],
  '#teamceltics': ['NNPS'],
  '#teamlakers': ['NNPS'],
  '#win': ['NN'],
  '\$': ['\$'],
  '\$200': ['CD'],
  '\$25': ['CD'],
  '%': ['NN'],
  '%...': [':'],
  '%CHG': ['NN'],
  '&': ['CC'],
  '&0C.': ['NN'],
  '\'': ['POS'],
  '\'\'': ['\'\''],
  '\'\'\$': ['\$'],
  '\'\'.': ['NN'],
  '\',': [','],
  '\'.': ['.'],
  '\'/\'\'...': [':'],
  '\'/POS...': [':'],
  '\'13': ['CD'],
  '\'20\'s': ['CD'],
  '\'20s': ['NNPS'],
  '\'25': ['CD'],
  '\'30s': ['CD'],
  '\'31': ['CD'],
  '\'38': ['CD'],
  '\'40\'s': ['CD'],
  '\'40s': ['NNS'],
  '\'48': ['CD'],
  '\'49': ['CD'],
  '\'50': ['CD'],
  '\'50\'s': ['CD'],
  '\'50s': ['NNS'],
  '\'51': ['CD'],
  '\'52': ['CD'],
  '\'53': ['CD'],
  '\'54': ['CD'],
  '\'55': ['CD'],
  '\'58': ['CD'],
  '\'60': ['CD'],
  '\'60s': ['NNS'],
  '\'61': ['CD'],
  '\'68': ['CD'],
  '\'70s': ['NNS'],
  '\'71': ['CD'],
  '\'76': ['CD'],
  '\'78': ['CD'],
  '\'79': ['CD'],
  '\'80\'s': ['CD'],
  '\'80s': ['NNS'],
  '\'80s-style': ['JJ'],
  '\'81': ['CD'],
  '\'82': ['CD'],
  '\'85': ['CD'],
  '\'86': ['CD'],
  '\'87': ['CD'],
  '\'89': ['CD'],
  '\'89s': ['NNS'],
  '\'90s': ['NNS'],
  '\'92': ['CD'],
  '\':': [':'],
  '\'A': ['NN'],
  '\'All': ['DT'],
  '\'Are': ['VBP'],
  '\'As': ['RB'],
  '\'BS': ['NNP'],
  '\'Big': ['JJ'],
  '\'Cause': ['IN'],
  '\'Channel': ['NN'],
  '\'Chief': ['NNP'],
  '\'Christian': ['JJ'],
  '\'Come': ['VB'],
  '\'D': ['NNP'],
  '\'Damn': ['VB'],
  '\'Dividend': ['NN'],
  '\'Do': ['NNP'],
  '\'Does': ['VBZ'],
  '\'Don\'t': ['VB'],
  '\'Em': ['NNP'],
  '\'Europeans': ['NNPS'],
  '\'Forget': ['VB'],
  '\'God': ['NNP'],
  '\'Goodison': ['NNP'],
  '\'Guesstimates': ['NNS'],
  '\'Hagura': ['NNP'],
  '\'Happy': ['NNP'],
  '\'Have': ['VB'],
  '\'He': ['PRP'],
  '\'Hear': ['VB'],
  '\'Here\'s': ['NNS'],
  '\'Hey': ['UH'],
  '\'Hot': ['JJ'],
  '\'How': ['WRB'],
  '\'I': ['PRP'],
  '\'I\'d': ['VB'],
  '\'I\'m': ['VBP'],
  '\'I\'ve': ['NN'],
  '\'Il': ['NNP'],
  '\'Is': ['VBP'],
  '\'It\'s': ['PRP'],
  '\'Just': ['RB'],
  '\'K': ['NNP'],
  '\'Kick': ['VB'],
  '\'Lady': ['NN'],
  '\'Let\'s': ['PRP'],
  '\'Look': ['VB'],
  '\'MTV': ['NNP'],
  '\'Ma': ['NNP'],
  '\'My': ['PRP'],
  '\'N': ['NNP'],
  '\'Nightline': ['NNP'],
  '\'No': ['UH'],
  '\'OK': ['UH'],
  '\'Oh': ['UH'],
  '\'Okay': ['UH'],
  '\'Onward': ['RB'],
  '\'Ounce': ['NNP'],
  '\'P': ['JJ'],
  '\'People': ['NNS'],
  '\'Poltergeist': ['NN'],
  '\'Preventive': ['JJ'],
  '\'R': ['NNP'],
  '\'RED': ['JJ'],
  '\'Recovering': ['VBG'],
  '\'S': ['VBZ'],
  '\'Son': ['NN'],
  '\'Sorry': ['JJ'],
  '\'Struggling': ['VBG'],
  '\'Sweets': ['NNP'],
  '\'T-': ['PRP'],
  '\'Tahiti': ['NNP'],
  '\'That\'s': ['VBZ'],
  '\'The': ['NNP'],
  '\'This': ['VBZ'],
  '\'Three\'s': ['NNP'],
  '\'Tide': ['NNP'],
  '\'To': ['NNP'],
  '\'Today': ['NNP'],
  '\'Unsolved': ['NNP'],
  '\'Wadoo': ['UH'],
  '\'War': ['NNP'],
  '\'Watch': ['VB'],
  '\'We': ['PRP'],
  '\'We\'ve': ['PRP'],
  '\'Well': ['RB'],
  '\'What': ['WP'],
  '\'Which': ['NN'],
  '\'Who': ['NN'],
  '\'Why': ['WRB'],
  '\'Will': ['MD'],
  '\'X': ['NN'],
  '\'Yeah': ['UH'],
  '\'Yes': ['UH'],
  '\'You': ['NN'],
  '\'Yuk': ['UH'],
  '\'``': ['``'],
  '\'bout': ['IN'],
  '\'ceptin': ['VBG'],
  '\'d': ['MD'],
  '\'d.': ['NN'],
  '\'ello': ['UH'],
  '\'em': ['PRP'],
  '\'emselves': ['PRP'],
  '\'fess': ['VB'],
  '\'fore': ['IN'],
  '\'im': ['PRP'],
  '\'ll': ['MD'],
  '\'low': ['VB'],
  '\'m': ['VBP'],
  '\'mon': ['UH'],
  '\'most': ['IN'],
  '\'n': ['IN'],
  '\'nother': ['DT'],
  '\'nough': ['JJ'],
  '\'nuff': ['RB'],
  '\'pache': ['NN'],
  '\'re': ['VBP'],
  '\'re...': [':'],
  '\'round': ['RB'],
  '\'s': ['POS'],
  '\'s.': ['POS'],
  '\'scuse': ['VB'],
  '\'stead': ['IN'],
  '\'t-': ['PRP'],
  '\'thirties': ['NNS'],
  '\'till': ['IN'],
  '\'ve': ['VBP'],
  '\'way': ['RB'],
  '\'we\'d': ['MD'],
  '(': ['('],
  '(!)': ['SYM'],
  '(3/26': ['1991)'],
  '(9/9': ['1991)'],
  '(:': ['SYM'],
  '(@': ['SYM'],
  ')': [')'],
  ').': ['SYM'],
  '):': ['SYM'],
  '*': ['SYM'],
  '+': ['SYM'],
  ',': [','],
  ',\'cept': ['IN'],
  ',\'t-': ['PRP'],
  ',.': ['SYM'],
  ',..': ['NN'],
  ',...': [':'],
  '-': [':'],
  '-\$': ['\$'],
  '--': [':'],
  '--\$': ['\$'],
  '--\'cause': ['JJ'],
  '--271,124': ['CD'],
  '--33': ['CD'],
  '--4.8': ['CD'],
  '--Boca': ['NNP'],
  '--Bordeaux': ['NNP'],
  '--China': ['NNP'],
  '--Dell': ['NNP'],
  '--Dorothy': ['NNP'],
  '--George': ['NNP'],
  '--Hitachi': ['NNP'],
  '--Mrs': ['NNP'],
  '--Of': ['IN'],
  '--Thailand': ['NNP'],
  '--Tokyo': ['NNP'],
  '--William': ['NNP'],
  '--a': ['DT'],
  '--about': ['IN'],
  '--agreed': ['NN'],
  '--all': ['DT'],
  '--and': ['CC'],
  '--are': ['VBP'],
  '--at': ['IN'],
  '--awarding': ['VBG'],
  '--changed': ['VBD'],
  '--combined': ['VBN'],
  '--complicated': ['IN'],
  '--consented': ['VBD'],
  '--considered': ['VBN'],
  '--despite': ['IN'],
  '--didn\'t': ['VBD', 'RB'],
  '--dividends': ['NNS'],
  '--especially': ['RB'],
  '--even': ['JJ'],
  '--fawning': ['VBG'],
  '--fell': ['VBD'],
  '--for': ['IN'],
  '--forcing': ['JJ'],
  '--grows': ['VBZ'],
  '--had': ['VBD'],
  '--has': ['VBP'],
  '--here': ['RB'],
  '--how': ['WRB'],
  '--if': ['IN'],
  '--in': ['NN'],
  '--including': ['IN'],
  '--it': ['PRP'],
  '--like': ['IN'],
  '--meal': ['NN'],
  '--mortgage-backed': ['JJ'],
  '--of': ['IN'],
  '--offer': ['VBP'],
  '--one': ['CD'],
  '--players': ['NNS'],
  '--plus': ['RB'],
  '--presumably': ['RB'],
  '--products': ['NNS'],
  '--since': ['IN'],
  '--some': ['DT'],
  '--subjects': ['NNS'],
  '--such': ['JJ'],
  '--teetering': ['VBG'],
  '--telegraph': ['VBP'],
  '--the': ['JJ'],
  '--they': ['PRP'],
  '--those': ['DT'],
  '--to': ['IN'],
  '--twice': ['RB'],
  '--unlike': ['JJ'],
  '--vs.': ['IN'],
  '--was': ['VBD'],
  '--were': ['VBD'],
  '--what': ['WP'],
  '--when': ['WRB'],
  '--which': ['WDT'],
  '--who': ['WP'],
  '--will': ['MD'],
  '--wines': ['NN'],
  '--with': ['IN'],
  '--would': ['MD'],
  '--you': ['JJ'],
  '-.10': ['CD'],
  '-.5': ['CD'],
  '-.50': ['CD'],
  '-0.06': ['CD'],
  '-1': ['CD'],
  '-16-degrees': ['CD', 'NNS'],
  '-20-degrees': ['CD', 'NNS'],
  '-20-degrees-C': ['CD', 'NN', 'NP'],
  '-300': ['CD'],
  '-5': ['CD'],
  '-500': ['CD'],
  '-57.6': ['CD'],
  '-78-degrees': ['CD', 'NN'],
  '-LCB-': ['('],
  '-LRB-': ['('],
  '-RCB-': [')'],
  '-RRB-': [')'],
  '-Samuel': ['NNP'],
  '-Yr.': ['NN'],
  '-_-': ['SYM'],
  '-__-': ['SYM'],
  '-aminometha': ['NN'],
  '-axis': ['NN'],
  '-c': ['NN'],
  '-ing': ['JJ'],
  '-ism': ['NN'],
  '.': ['.'],
  '.\'crack': ['NN'],
  '..': ['.'],
  '...': [':'],
  '....': [':'],
  '.....': [':'],
  '......': [':'],
  '........': [':'],
  '.01': ['CD'],
  '.02': ['CD'],
  '.025': ['CD'],
  '.027': ['CD'],
  '.03': ['CD'],
  '.05': ['CD'],
  '.054': ['CD'],
  '.07': ['CD'],
  '.076': ['CD'],
  '.09': ['CD'],
  '.10-a-minute': ['JJ'],
  '.10.07': ['CD'],
  '.105': ['CD'],
  '.12': ['CD'],
  '.125': ['CD'],
  '.16': ['CD'],
  '.23': ['CD'],
  '.270': ['CD'],
  '.292': ['CD'],
  '.30': ['CD'],
  '.337': ['CD'],
  '.357': ['CD'],
  '.375': ['CD'],
  '.38': ['CD'],
  '.4': ['CD'],
  '.40': ['CD'],
  '.45': ['CD'],
  '.5': ['CD'],
  '.50': ['CD'],
  '.50-caliber': ['JJ'],
  '.500': ['CD'],
  '.6': ['CD'],
  '.65': ['CD'],
  '.75': ['CD'],
  '.8': ['CD'],
  '.80': ['CD'],
  '.86': ['CD'],
  '.9.76': ['CD'],
  '.9.82': ['CD'],
  '.9.92': ['CD'],
  '.90': ['CD'],
  '.:': [':'],
  '.Not': ['RB'],
  '.fundamentally': ['RB'],
  '.to': ['TO'],
  '.what': ['WDT'],
  '/': ['CC'],
  '0': ['CD'],
  '0-1': ['CD'],
  '09': ['CD'],
  '1': ['CD'],
  '1,000': ['CD'],
  '1-0': ['CD'],
  '1/2': ['CD'],
  '10': ['CD'],
  '10.27': ['CD'],
  '106': ['CD'],
  '11': ['CD'],
  '12': ['CD'],
  '15': ['CD'],
  '17': ['CD'],
  '17th': ['CD'],
  '1st': ['JJ'],
  '2': ['IN'],
  '20': ['CD'],
  '2008': ['CD'],
  '2010': ['CD'],
  '2011': ['CD'],
  '21st': ['JJ'],
  '26': ['CD'],
  '27': ['CD'],
  '27th': ['CD'],
  '29': ['CD'],
  '2day': ['NN'],
  '2nd': ['CD'],
  '3': ['CD'],
  '30': ['CD'],
  '31': ['CD'],
  '4': ['IN'],
  '40': ['CD'],
  '48': ['CD'],
  '4th': ['CD'],
  '5': ['CD'],
  '6': ['CD'],
  '7': ['CD'],
  '7:30': ['CD'],
  '8': ['CD'],
  '8:30': ['CD'],
  '9': ['CD'],
  ':': [':'],
  ':(': ['SYM'],
  ':)': ['SYM'],
  ':))': ['SYM'],
  ':-P': ['SYM'],
  ':/': ['SYM'],
  ':35.3': ['CD'],
  '::': [':'],
  ':D': ['SYM'],
  ':P': ['SYM'],
  ';': [':'],
  ';)': ['SYM'],
  ';-)': ['SYM'],
  '<': ['SYM'],
  '<3': ['SYM'],
  '<333': ['SYM'],
  '=': ['SYM'],
  '=)': ['SYM'],
  '======================================ll': ['NN'],
  '=D': ['SYM'],
  '=]': ['SYM'],
  '>': ['SYM'],
  '?': ['.'],
  '?!': ['.'],
  '?!?': ['.'],
  '??': ['.'],
  '??!!': ['.'],
  '???': ['.'],
  '????': ['.'],
  '@': ['IN'],
  '@BarackObama': ['NNP'],
  '@DailySexTips': ['NNP'],
  '@NICKIMINAJ': ['NNP'],
  '@NickiMinaj': ['NNP'],
  '@justinbieber': ['NNP'],
  '@kylieminogue': ['NNP'],
  '@youtube': ['NNP'],
  'A': ['DT'],
  'A\$': ['\$'],
  'A&E': ['NNP'],
  'A&M': ['NNP'],
  'A&P': ['NNP'],
  'A&W': ['NNP'],
  'A*/NNP&S': ['NN'],
  'A,B,C,D': ['NNP'],
  'A-1': ['JJ'],
  'A-1-plus': ['JJ'],
  'A-12': ['NNP'],
  'A-2': ['NN'],
  'A-26': ['CD'],
  'A-300-600': ['NNP'],
  'A-310-300': ['NN'],
  'A-320': ['NN'],
  'A-320-200': ['NN'],
  'A-320s': ['NNP'],
  'A-321': ['NN'],
  'A-330': ['NNP'],
  'A-330s': ['NNS'],
  'A-340s': ['NNS'],
  'A-6': ['NN'],
  'A-B': ['NNP'],
  'A-D': ['NNP'],
  'A-Team': ['NNP'],
  'A-Z': ['NNP'],
  'A-body': ['JJ'],
  'A-bombs': ['NNS'],
  'A-men': ['NNS'],
  'A-plus': ['JJ'],
  'A.': ['NNP'],
  'A.-controlled': ['JJ'],
  'A.A.': ['NNP'],
  'A.A.U.': ['NNP'],
  'A.B.': ['NNP'],
  'A.C.': ['NNP'],
  'A.D': ['NN'],
  'A.D.': ['NNP'],
  'A.D.L.': ['NNP'],
  'A.E.': ['NNP'],
  'A.F.': ['NNP'],
  'A.G.': ['NNP'],
  'A.H.': ['NNP'],
  'A.I.D.': ['NN'],
  'A.I.R.': ['NNP'],
  'A.J.': ['NNP'],
  'A.J.C.': ['NNP'],
  'A.K.C.': ['NNP'],
  'A.L.': ['NNP'],
  'A.L.A.M.': ['NNP'],
  'A.L/NNP.S/NNP.A.C.': ['NNP'],
  'A.M': ['RB'],
  'A.M.': ['NNP'],
  'A.M.A': ['NNP'],
  'A.M.A.': ['NNP'],
  'A.M.E.': ['NNP'],
  'A.N.': ['NNP'],
  'A.O.': ['NNP'],
  'A.P.': ['NNP'],
  'A.R.': ['NNP'],
  'A.R.A.': ['NNP'],
  'A.S.': ['NNP'],
  'A.T.B.': ['NNP'],
  'A.V.': ['NNP'],
  'A.W.': ['NNP'],
  'A12': ['NN'],
  'A135': ['NN'],
  'A3': ['CD'],
  'A300-600R': ['NNP'],
  'A310-300s': ['NNP'],
  'A320': ['NN'],
  'A321': ['CD'],
  'A321s': ['NNS'],
  'A330': ['NN'],
  'A330-300s': ['NNS'],
  'A340': ['NN'],
  'A40-AjK': ['NN'],
  'A5': ['NN'],
  'AA': ['JJ'],
  'AAA': ['NNP'],
  'AARP': ['NNP'],
  'AAb': ['NNP'],
  'AB': ['NNP'],
  'ABA': ['NNP'],
  'ABB': ['NNP'],
  'ABBIE': ['NNP'],
  'ABC': ['NNP'],
  'ABC-TV': ['NNP'],
  'ABCs': ['NNS'],
  'ABG-Semca': ['NNP'],
  'ABIOMED': ['NNP'],
  'ABM': ['NN'],
  'ABM.': ['NNP'],
  'ABO': ['NNP'],
  'ABORTION': ['NN'],
  'ABS': ['NNP'],
  'ABUSE': ['NN'],
  'AC&R': ['NNP'],
  'AC&R\\\'/CCL': ['NNP'],
  'AC-130U': ['NN'],
  'ACCEPTANCES': ['NNS'],
  'ACCO': ['NNP'],
  'ACCOUNT': ['NN'],
  'ACCOUNTANTS': ['NNS'],
  'ACCOUNTING': ['NN'],
  'ACCOUNTS': ['NNS'],
  'ACLU': ['NNP'],
  'ACQUISITION': ['NN'],
  'ACQUISITIONS': ['NNS'],
  'ACRES': ['NNP'],
  'ACS': ['NNP'],
  'ACT': ['NNP'],
  'ACTH': ['NNP'],
  'ACTING': ['JJ'],
  'AD': ['NN'],
  'ADB': ['NNP'],
  'ADC': ['NNP'],
  'ADDED': ['VBD'],
  'ADIA': ['NNP'],
  'ADMAN': ['NN'],
  'ADMINISTRATION\'S': ['NN'],
  'ADMITTED': ['VBD'],
  'ADN': ['NNP'],
  'ADOPTED': ['VBD'],
  'ADR': ['NNP'],
  'ADRs': ['NNS'],
  'ADS': ['NNPS'],
  'ADT': ['NNP'],
  'ADV': ['NNP'],
  'ADVANCED': ['NNP'],
  'ADVANCEMENT': ['NNP'],
  'ADVANCES': ['NNS'],
  'ADVERTISERS': ['NNS'],
  'ADVERTISING': ['NNP'],
  'AD\\\'': ['NNP'],
  'AEC': ['NNP'],
  'AEG': ['NNP'],
  'AEI': ['NNP'],
  'AEP': ['NNP'],
  'AES': ['NNP'],
  'AEW': ['NNP'],
  'AF': ['NNP'],
  'AFDC': ['NNP'],
  'AFFLUENT': ['JJ'],
  'AFL-CIO': ['NNP'],
  'AFP': ['NNP'],
  'AFRICA': ['NNP'],
  'AFRICA\'S': ['NNP'],
  'AFRICAN-AMERICAN': ['JJ'],
  'AFTERMATH': ['NNP'],
  'AFTERSHOCKS': ['NNS'],
  'AG': ['NNP'],
  'AGA': ['NNP'],
  'AGAIN': ['RB'],
  'AGE': ['NNP'],
  'AGENCIES': ['NNS'],
  'AGENCY': ['NNP'],
  'AGF': ['NNP'],
  'AGI': ['NNP'],
  'AGIP': ['NNP'],
  'AGREED': ['VBD'],
  'AGREES': ['VBZ'],
  'AGS': ['NNP'],
  'AH-64': ['NN'],
  'AH6': ['CD'],
  'AHEAD': ['RB'],
  'AHHHHH': ['UH'],
  'AHSC': ['NNP'],
  'AIA': ['NNP'],
  'AIB': ['NNP'],
  'AIB.PR': ['NNP'],
  'AIChE': ['NNP'],
  'AID': ['NNP'],
  'AIDS': ['NNP'],
  'AIDS-drug': ['JJ'],
  'AIDS-infected': ['JJ'],
  'AIDS-inspired': ['JJ'],
  'AIDS-like': ['JJ'],
  'AIDS-prevention': ['JJ'],
  'AIDS-related': ['JJ'],
  'AIDS-research': ['JJ'],
  'AIDS-treatment': ['NN'],
  'AIEE': ['NNP'],
  'AIG': ['NNP'],
  'AIM': ['NNP'],
  'AIMO': ['NNP'],
  'AIR': ['NNP'],
  'AIR\'S': ['NNP'],
  'AIRCOA': ['NNP'],
  'AIRLINES': ['NNPS'],
  'AIW': ['NNP'],
  'AK-47': ['NNP'],
  'AL': ['NNP'],
  'ALAMCO': ['NNP'],
  'ALBERTA': ['NNP'],
  'ALCEE': ['NNP'],
  'ALCOHOL': ['NNP'],
  'ALERT': ['NN'],
  'ALII': ['NNP'],
  'ALL': ['PDT'],
  'ALLIANCE': ['NNP'],
  'ALLOWED': ['VBD'],
  'ALLWASTE': ['NNP'],
  'ALLY': ['NN'],
  'ALPA': ['NNP'],
  'ALQ-135': ['NN'],
  'ALQ-178': ['NNP'],
  'ALT': ['NNP'],
  'ALU': ['NNP'],
  'ALUMINUM': ['NNP'],
  'AM': ['NNP'],
  'AMA': ['NNP'],
  'AMBASSADOR': ['NN'],
  'AMC': ['NNP'],
  'AMCA': ['NNP'],
  'AMDAHL': ['NNP'],
  'AMERICA\'S': ['NNP'],
  'AMERICAN': ['NNP'],
  'AMERICANS': ['NNS'],
  'AMES': ['NNP'],
  'AMEX': ['NNP'],
  'AMF': ['NNP'],
  'AMI': ['NNP'],
  'AMNESTY': ['NN'],
  'AMONG': ['IN'],
  'AMP': ['NNP'],
  'AMR': ['NNP'],
  'AMR-Delta': ['NNP'],
  'AMRO': ['NNP'],
  'AMT': ['NNP'],
  'AMUSEMENT': ['JJ'],
  'AMVISC': ['NNP'],
  'AMs': ['NNS'],
  'AN': ['DT'],
  'ANACOMP': ['NNP'],
  'ANB': ['NNP'],
  'ANC': ['NNP'],
  'ANCHORAGE': ['NNP'],
  'AND': ['CC'],
  'ANDERSEN': ['NNP'],
  'ANF': ['NNP'],
  'ANF-Industrie': ['NNP'],
  'ANGELES': ['NNP'],
  'ANIMAL-RIGHTS': ['NNS'],
  'ANN': ['NNP'],
  'ANNOUNCED': ['VBD'],
  'ANNUAL': ['JJ'],
  'ANNUITIES': ['NNS'],
  'ANNUITY': ['NNP'],
  'ANP': ['NNP'],
  'ANR': ['NNP'],
  'ANSA': ['NNP'],
  'ANTHEM': ['NNP'],
  'ANZ': ['NNP'],
  'AON': ['NNP'],
  'AP': ['NNP'],
  'AP-Dow': ['NNP'],
  'AP600': ['NN'],
  'APARTHEID': ['NNP'],
  'API': ['NNP'],
  'APM': ['NNP'],
  'APMS': ['NNP'],
  'APPB': ['NNP'],
  'APPEARS': ['VBZ'],
  'APPELLATE': ['NN'],
  'APPLE': ['NNP'],
  'APPLIANCES': ['NNPS'],
  'APPLIED': ['NNP'],
  'APPROVED': ['VBD'],
  'APPROVES': ['VBZ'],
  'APS': ['NNP'],
  'APT': ['NNP'],
  'APV': ['NNP'],
  'ARA': ['NNP'],
  'ARAL-88': ['NNP'],
  'ARBITRAGE': ['NN'],
  'ARCO': ['NNP'],
  'ARE': ['VBP'],
  'AREA': ['NN'],
  'ARF': ['NNP'],
  'ARISE': ['VBP'],
  'ARM': ['NNP'],
  'ARMs': ['NNS'],
  'ARNOLD': ['NNP'],
  'ARRESTED': ['VBD'],
  'ARRIVED': ['VBD'],
  'ARTICLE': ['NN'],
  'ARTY': ['NNP'],
  'ART\\\'/artifact': ['NN'],
  'AS': ['NNP'],
  'ASA': ['NNP'],
  'ASARCO': ['NNP'],
  'ASC': ['NNP'],
  'ASCAP': ['NNP'],
  'ASDA': ['NNP'],
  'ASDIC': ['NNP'],
  'ASEA': ['NNP'],
  'ASEAN': ['NNP'],
  'ASHTON-TATE': ['NNP'],
  'ASK': ['NNP'],
  'ASKO': ['NNP'],
  'ASKS': ['VBZ'],
  'ASLACTON': ['NNP'],
  'ASME': ['NNP'],
  'ASP': ['NNP'],
  'ASPIS': ['FW'],
  'ASPR': ['NNP'],
  'ASSETS': ['NNP'],
  'ASSOCIATES': ['NNP'],
  'ASSOCIATION': ['NNP'],
  'ASSOCIATION-COLLEGE': ['NNP'],
  'AST': ['NNP'],
  'ASW': ['NN'],
  'AS\\\'': ['NNP'],
  'AT': ['IN'],
  'AT&T': ['NNP'],
  'AT&T-sponsored': ['JJ'],
  'AT*': ['NNP'],
  'AT*/NNP&T': ['NN'],
  'ATARI': ['NNP'],
  'ATHLONE': ['NNP'],
  'ATI': ['NNP'],
  'ATLANTIC': ['NNP'],
  'ATM': ['NN'],
  'ATMs': ['NNS'],
  'ATP': ['NN'],
  'ATS\\\'': ['NNP'],
  'ATTACK': ['NN'],
  'ATTORNEY': ['NNP'],
  'ATTRACTS': ['VBZ'],
  'AUDITS': ['NNS'],
  'AUS': ['NNP'],
  'AUSTIN': ['NNP'],
  'AUTO': ['NNP'],
  'AUTOMOBILES': ['NNPS'],
  'AVC': ['NNP'],
  'AVOIDED': ['VBD'],
  'AVON': ['NNP'],
  'AVX': ['NNP'],
  'AWA': ['NNP'],
  'AWAY': ['RP'],
  'AWE': ['NNP'],
  'AWOC': ['NNP'],
  'AYER': ['NNP'],
  'AZT': ['NNP'],
  'AZT-resistant': ['JJ'],
  'AZT-treated': ['JJ'],
  'AZTR': ['NNP'],
  'A[fj]': ['SYM'],
  'A\\\'': ['JJ'],
  'A\\\'/S': ['NNP'],
  'Aaa': ['JJ'],
  'Aaa-ee': ['UH'],
  'Aaawww': ['UH'],
  'Aah': ['UH'],
  'Aalseth': ['NNP'],
  'Aaron': ['NNP'],
  'Aaronson': ['NNP'],
  'Aarvik': ['NNP'],
  'Ab1,040': ['NNP'],
  'Ab4,500': ['CD'],
  'Ab63711-r': ['CD'],
  'Ababa': ['NNP'],
  'Abalkin': ['NNP'],
  'Abandon': ['VB'],
  'Abandoning': ['VBG'],
  'Abatuno': ['NNP'],
  'Abba': ['NNP'],
  'Abbas': ['NNP'],
  'Abbe': ['NNP'],
  'Abbe-Direct': ['NNP'],
  'Abbe-Scotch': ['NNP'],
  'Abbenhaus': ['NNP'],
  'Abbett': ['NNP'],
  'Abbey': ['NNP'],
  'Abbie': ['NNP'],
  'Abbot': ['NNP'],
  'Abbott': ['NNP'],
  'Abboud': ['NNP'],
  'Abby': ['NNP'],
  'Abd-al-Aziz': ['NNP'],
  'Abdallah': ['NNP'],
  'Abderahmane': ['NNP'],
  'Abdul': ['NNP'],
  'Abdul-Raheem': ['NNP'],
  'Abdullah': ['NNP'],
  'Abe': ['NNP'],
  'Abel': ['NNP'],
  'Abell': ['NNP'],
  'Abello': ['NNP'],
  'Abelson': ['NNP'],
  'Abend': ['NNP'],
  'Aber': ['FW'],
  'Abercrombie': ['NNP'],
  'Aberdeen': ['NNP'],
  'Abernathy': ['NNP'],
  'Abernathys': ['NNPS'],
  'Abex': ['NNP'],
  'Abide': ['NNP'],
  'Abie': ['NNP'],
  'Abigail': ['NNP'],
  'Abilene': ['NNP'],
  'Abingdon': ['NNP'],
  'Abiomed': ['NNP'],
  'Abitibi-Price': ['NNP'],
  'Ablard': ['NNP'],
  'Able': ['NNP'],
  'Abner': ['NNP'],
  'Abney': ['NNP'],
  'Abnormal': ['JJ'],
  'Aboff': ['NNP'],
  'Abolition': ['NNP'],
  'Abolitionists': ['NNS'],
  'Aborted': ['JJ'],
  'Abortion': ['NNP'],
  'Abortion-rights': ['NNS'],
  'About': ['IN'],
  'Above': ['IN'],
  'Aboveground': ['JJ'],
  'Abra': ['NNP'],
  'Abraham': ['NNP'],
  'Abrahams': ['NNP'],
  'Abrahamson': ['NNP'],
  'Abramowitz': ['NNP'],
  'Abrams': ['NNP'],
  'Abramson': ['NNP'],
  'Abreaction': ['NN'],
  'Abreast': ['NNP'],
  'Abroad': ['RB'],
  'Abrupt': ['JJ'],
  'Abruptly': ['RB'],
  'Abscam-indicted': ['JJ'],
  'Absent': ['VB'],
  'Absent-minded': ['JJ'],
  'Absenteeism': ['NN'],
  'Absolute': ['JJ'],
  'Absolutely': ['RB'],
  'Absolution': ['NN'],
  'Absorbed': ['VBN'],
  'Absorbing': ['VBG'],
  'Abstract': ['NNP'],
  'Abstraction': ['NNP'],
  'Abstractionists': ['NNS'],
  'Abstractions': ['NNS'],
  'Abstracts': ['NNP'],
  'Abt': ['NNP'],
  'Abu': ['NNP'],
  'Abuse': ['NNP'],
  'Abyss': ['NN'],
  'Abyssinians': ['NNPS'],
  'Aca': ['NNP'],
  'Academic': ['NNP'],
  'Academically': ['RB'],
  'Academicianship': ['NN'],
  'Academics': ['NNS'],
  'Academy': ['NNP'],
  'Acadia': ['NNP'],
  'Acala': ['NNP'],
  'Acapulco': ['NNP'],
  'Acarbose': ['NNP'],
  'Accacia': ['NNP'],
  'Accademia': ['NNP'],
  'Accardo': ['NNP'],
  'Accelerated': ['VBN'],
  'Accept': ['VB'],
  'Acceptable': ['JJ'],
  'Acceptance': ['NNP'],
  'Accepted': ['JJ'],
  'Accepting': ['VBG'],
  'Access': ['NN'],
  'Accessories': ['NNS'],
  'Accident': ['NNP'],
  'Accidental': ['JJ'],
  'Acclaim': ['NNP'],
  'Accompanied': ['VBN'],
  'Accomplishing': ['VBG'],
  'Accomplishments': ['NNS'],
  'Accor': ['NNP'],
  'Accord': ['NNP'],
  'Accord-fighter': ['JJ'],
  'According': ['VBG'],
  'Accordingly': ['RB'],
  'Accords': ['NNPS'],
  'Account': ['NNP'],
  'Accountants': ['NNPS'],
  'Accountemps': ['NNP'],
  'Accounting': ['NNP'],
  'Accounting-profession': ['NN'],
  'Accounts': ['NNS'],
  'Accounts-a': ['NNP'],
  'Accrued': ['VBN'],
  'Accudyne': ['NNP'],
  'Accumaster': ['NNP'],
  'Accumulation': ['NNP'],
  'Accuracy': ['NN'],
  'Accurate': ['JJ'],
  'Accused': ['NNP'],
  'Accustomed': ['JJ'],
  'Accutane': ['NNP'],
  'Ace': ['NNP'],
  'Aces': ['NNS'],
  'Acey': ['NNP'],
  'Achaeans': ['NNPS'],
  'Achenbaum': ['NNP'],
  'Acheson': ['NNP'],
  'Achievement': ['NNP'],
  'Achieving': ['VBG'],
  'Achilles': ['NNP'],
  'Acid': ['JJ'],
  'Acid-washed': ['JJ'],
  'Ackerley': ['NNP'],
  'Ackerly': ['NNP'],
  'Ackerman': ['NNP'],
  'Ackermann': ['NNP'],
  'Acknowledges': ['VBZ'],
  'Ackroyd': ['NNP'],
  'Acme-Cleveland': ['NNP'],
  'Acorn': ['NNP'],
  'Acorns': ['NNS'],
  'Acourse': ['NN'],
  'Acoustic': ['NNP'],
  'Acoustical': ['JJ'],
  'Acquired': ['VBN'],
  'Acquirer': ['NN'],
  'Acquirers': ['NNS'],
  'Acquiring': ['VBG'],
  'Acquisition': ['NNP'],
  'Acquisitions': ['NNS'],
  'Acreage': ['NN'],
  'Acres': ['NNP'],
  'Acropolis': ['NNP'],
  'Across': ['IN'],
  'Acrylic': ['NNP'],
  'Act': ['NNP'],
  'Acting': ['NNP'],
  'Acting-President': ['NNP'],
  'Action': ['NNP'],
  'Actions': ['NNS'],
  'Active': ['JJ'],
  'Actively': ['RB'],
  'Activists': ['NNS'],
  'Activities': ['NNP'],
  'Activity': ['NN'],
  'Acton': ['NNP'],
  'Actor-Crooner': ['NNP'],
  'Actress': ['NNP'],
  'Acts': ['NNPS'],
  'Actual': ['JJ'],
  'Actually': ['RB'],
  'Acura': ['NNP'],
  'Acushnet': ['NNP'],
  'Acustar': ['NNP'],
  'Acuvue': ['NNP'],
  'Ad': ['NN'],
  'Ad-Unit': ['NN'],
  'Ada': ['NNP'],
  'Adagio': ['NNP'],
  'Adair': ['NNP'],
  'Adalbert': ['NNP'],
  'Adam': ['NNP'],
  'Adame': ['NNP'],
  'Adamec': ['NNP'],
  'Adamo': ['NNP'],
  'Adams': ['NNP'],
  'Adamski': ['NNP'],
  'Adamson': ['NNP'],
  'Adaptaplex': ['NNP'],
  'Adaptation': ['NN'],
  'Adaptations': ['NNS'],
  'Adaptec': ['NNP'],
  'Adapted': ['VBN'],
  'Adcock': ['NNP'],
  'Add': ['VB'],
  'Addabbo': ['NNP'],
  'Adde': ['NNP'],
  'Added': ['VBD'],
  'Addict': ['NNP'],
  'Addicted': ['NNP'],
  'Addicts': ['NNS'],
  'Adding': ['VBG'],
  'Addington': ['NNP'],
  'Addis': ['NNP'],
  'Addison': ['NNP'],
  'Addiss': ['NNP'],
  'Addition': ['NN'],
  'Additional': ['JJ'],
  'Additionally': ['RB'],
  'Additive': ['NN'],
  'Additives': ['NNPS'],
  'Address': ['NNP'],
  'Addressing': ['VBG'],
  'Adds': ['VBZ'],
  'Addwest': ['NNP'],
  'Ade': ['NNP'],
  'Adelaide': ['NNP'],
  'Adele': ['NNP'],
  'Adelia': ['NNP'],
  'Adella': ['NNP'],
  'Adelman': ['NNP'],
  'Adelos': ['NNP'],
  'Aden': ['NNP'],
  'Adenauer': ['NNP'],
  'Adens': ['NNP'],
  'Adequate': ['JJ'],
  'Aderholds': ['NNPS'],
  'Adherence': ['NN'],
  'Adi': ['NNP'],
  'Adia': ['NNP'],
  'Adios': ['NNP'],
  'Adios-Direct': ['NNP'],
  'Adios-On': ['NNP'],
  'Adios-Rena': ['NNP'],
  'Adios-Trustful': ['NNP'],
  'Adirondack': ['NNP'],
  'Adirondacks': ['NNPS'],
  'Adjoining': ['VBG'],
  'Adjournment': ['NN'],
  'Adjust': ['VB'],
  'Adjusted': ['NNP'],
  'Adjusters': ['NNS'],
  'Adjusting': ['VBG'],
  'Adjustment': ['NNP'],
  'Adlai': ['NNP'],
  'Adler': ['NNP'],
  'Adley': ['NNP'],
  'Adm.': ['NNP'],
  'Admarketing': ['NNP'],
  'Admassy': ['NNP'],
  'Administration': ['NNP'],
  'Administration-insured': ['JJ'],
  'Administrative': ['NNP'],
  'Administrator': ['NNP'],
  'Administrators': ['NNPS'],
  'Admirably': ['RB'],
  'Admiralty': ['NN'],
  'Admirers': ['NNS'],
  'Admission': ['NN'],
  'Admissions': ['NNP'],
  'Admistration': ['NNP'],
  'Admittedly': ['RB'],
  'Admitting': ['VBG'],
  'Adnan': ['NNP'],
  'Ado': ['NNP'],
  'Adobe': ['NNP'],
  'Adolescents': ['NNS'],
  'Adolf': ['NNP'],
  'Adolph': ['NNP'],
  'Adolphus': ['NNP'],
  'Adoniram': ['NNP'],
  'Adonis': ['NNP'],
  'Adopting': ['VBG'],
  'Adoption': ['NN'],
  'Adoptions': ['NNS'],
  'Adrar': ['NNP'],
  'Adrian': ['NNP'],
  'Adrianople': ['NN'],
  'Adriatic': ['NNP'],
  'Adrien': ['NNP'],
  'Adrienne': ['NNP'],
  'Ads': ['NNS'],
  'Adsi': ['NNP'],
  'Adult': ['NN'],
  'Adultery': ['NNP'],
  'Adults': ['NNS'],
  'Advance': ['NNP'],
  'Advanced': ['NNP'],
  'Advancement': ['NNP'],
  'Advancers': ['NNS'],
  'Advances': ['NNS'],
  'Advancing': ['VBG'],
  'Advani': ['NNP'],
  'Advantages': ['NNS'],
  'Advent': ['NNP'],
  'Adventists': ['NNP'],
  'Adventure': ['NNP'],
  'Adventurers': ['NNS'],
  'Adventures': ['NNS'],
  'Adverbial': ['JJ'],
  'Adverse': ['JJ'],
  'Advertiser': ['NNP'],
  'Advertisers': ['NNS'],
  'Advertising': ['NNP'],
  'Advertising\\\'/San': ['NNP'],
  'Advest': ['NNP'],
  'Advice': ['NNP'],
  'Advil': ['NNP'],
  'Advise': ['NNP'],
  'Adviser': ['NNP'],
  'Advisers': ['NNPS'],
  'Advises': ['VBZ'],
  'Advisor': ['NNP'],
  'Advisors': ['NNPS'],
  'Advisory': ['NNP'],
  'Advocate': ['NNP'],
  'Advocates': ['NNS'],
  'Aegean': ['NNP'],
  'Aegis': ['NNP'],
  'Aegis-class': ['JJ'],
  'Aegon': ['NNP'],
  'Aeneid': ['NNP'],
  'Aer': ['NNP'],
  'Aeritalia': ['NNP'],
  'Aermacchi': ['NNP'],
  'Aero': ['NNP'],
  'Aero-Space': ['NNP'],
  'Aerobacter': ['NN'],
  'Aeroflot': ['NNP'],
  'Aerojet': ['NNP'],
  'Aeromexico': ['NNP'],
  'Aeronautical': ['NNP'],
  'Aeronauticas': ['NNP'],
  'Aeronautics': ['NNP'],
  'Aeroquip': ['NNP'],
  'Aerospace': ['NNP'],
  'Aerospace-Thomson': ['NNP'],
  'Aerospatiale': ['NNP'],
  'Aeschbacher': ['NNP'],
  'Aeschylus': ['NNP'],
  'Aetna': ['NNP'],
  'Af-fold': ['JJ'],
  'Af-inch': ['JJ'],
  'Af-stage': ['JJ'],
  'Af-values': ['NNS'],
  'Af.': ['NNP'],
  'Afanasyev': ['NNP'],
  'Afanasyeva': ['NNP'],
  'Affair': ['NNP'],
  'Affaire': ['NNP'],
  'Affaires': ['NNP'],
  'Affairs': ['NNP'],
  'Affect': ['VB'],
  'Affected': ['VBN'],
  'Affidavits': ['NNS'],
  'Affiliated': ['NNP'],
  'Affiliates': ['NNP'],
  'Affirmative': ['JJ'],
  'Affirmatively': ['RB'],
  'Affirmed': ['NNP'],
  'Affliction': ['NNP'],
  'Afford': ['VB'],
  'Affordable': ['NNP'],
  'Afghan': ['JJ'],
  'Afghan-Pakistan': ['JJ'],
  'Afghanistan': ['NNP'],
  'Afghanistan\\\'/Southwest': ['NNP'],
  'Afghans': ['NNPS'],
  'Afield': ['NNP'],
  'Afif': ['NNP'],
  'Aflatoxin': ['NN'],
  'Afnasjev': ['NNP'],
  'Afraid': ['JJ'],
  'Afranio': ['NNP'],
  'Africa': ['NNP'],
  'Africaine': ['NNP'],
  'African': ['JJ'],
  'African-Americans': ['NNPS'],
  'African-controlled': ['JJ'],
  'African-safari': ['JJ'],
  'Africanist': ['NNP'],
  'Africans': ['NNPS'],
  'Afrika': ['NNP'],
  'Afrikaaner': ['NNP'],
  'Afrikaner': ['JJ'],
  'Afrikanerdom': ['NNP'],
  'Afrikaners': ['NNPS'],
  'Afrique': ['NNP'],
  'Afro-Asian': ['NNP'],
  'Afro-Cuban': ['JJ'],
  'After': ['IN'],
  'After-the-fact': ['JJ'],
  'Aftereffects': ['NNS'],
  'Afternoon': ['UH'],
  'Aftershocks': ['NNS'],
  'Afterward': ['RB'],
  'Afterwards': ['RB'],
  'AgResource': ['NNP'],
  'Aga': ['NNP'],
  'Again': ['RB'],
  'Against': ['IN'],
  'Agamemnon': ['NNP'],
  'Aganbegyan': ['NNP'],
  'Agatha': ['NNP'],
  'Age': ['NNP'],
  'Agee': ['NNP'],
  'Agence': ['NNP'],
  'Agencies': ['NNS'],
  'Agency': ['NNP'],
  'Agenda': ['NNP'],
  'Agent': ['NNP'],
  'Agents': ['NNS'],
  'Ageny': ['NNP'],
  'Ages': ['NNPS'],
  'Agfa': ['NNP'],
  'Aggie': ['NNP'],
  'Aggies': ['NNP'],
  'Aggregate': ['JJ'],
  'Aggressive': ['NNP'],
  'Aggressively': ['RB'],
  'Aggrieved': ['JJ'],
  'Aghanistan': ['NNP'],
  'Aghazadeh': ['NNP'],
  'Agile': ['FW'],
  'Agin': ['NNP'],
  'Aging': ['NNP'],
  'Agins': ['NNP'],
  'Agip': ['NNP'],
  'Agitato': ['NNP'],
  'Agius': ['NNP'],
  'Agnelli': ['NNP'],
  'Agnelli-related': ['JJ'],
  'Agnellis': ['NNPS'],
  'Agnes': ['NNP'],
  'Agnese': ['NNP'],
  'Agnew': ['NNP'],
  'Agnos': ['NNP'],
  'Ago': ['RB'],
  'Agoeng': ['NNP'],
  'Agoglia': ['NNP'],
  'Agonale': ['NNP'],
  'Agone': ['NNP'],
  'Agoura': ['NNP'],
  'Agouron': ['NNP'],
  'Agree': ['VBP'],
  'Agreeable': ['NNP'],
  'Agreed': ['VBD'],
  'Agreement': ['NNP'],
  'Agreements': ['NNS'],
  'Agrees': ['VBZ'],
  'Agri': ['NNP'],
  'Agricola': ['NNP'],
  'Agricole': ['NNP'],
  'Agricoles': ['NNP'],
  'Agricultural': ['NNP'],
  'Agriculture': ['NNP'],
  'Agriculture-ministry': ['NN'],
  'Agrippa': ['NNP'],
  'Agro': ['NNP'],
  'Agrobacterium': ['NN'],
  'Agua': ['NNP'],
  'Aguais': ['NNP'],
  'Aguiar': ['NNP'],
  'Aguilar': ['NNP'],
  'Aguirre': ['NNP'],
  'Aguirre-Sacasa': ['NNP'],
  'Agura': ['NNP'],
  'Ah': ['UH'],
  'Ah-ah': ['UH'],
  'Ahah': ['UH'],
  'Ahead': ['RB'],
  'Ahern': ['NNP'],
  'Ahh': ['UH'],
  'Ahlerich': ['NNP'],
  'Ahm': ['PRP'],
  'Ahmad': ['NNP'],
  'Ahmanson': ['NNP'],
  'Ahmet': ['NNP'],
  'Ahmiri': ['NNP'],
  'Aho': ['NNP'],
  'Ahold': ['NNP'],
  'Ahoy': ['NNP'],
  'Ahrens': ['NNP'],
  'Ahsan': ['NNP'],
  'Ai': ['VBP'],
  'Ai-': ['NNP'],
  'Aichi': ['NNP'],
  'Aid': ['NNP'],
  'Aida': ['NNP'],
  'Aidan': ['NNP'],
  'Aide': ['NNP'],
  'Aided': ['VBN'],
  'Aiden': ['NNP'],
  'Aides': ['NNS'],
  'Aiding': ['NNP'],
  'Aids': ['NNS'],
  'Aikawa': ['NNP'],
  'Aiken': ['NNP'],
  'Aikin': ['NNP'],
  'Aikman': ['NNP'],
  'Ailes': ['NNP'],
  'Ailey': ['NNP'],
  'Ailing': ['VBG'],
  'Aim': ['VB'],
  'Aimed': ['VBN'],
  'Aims': ['VBZ'],
  'Ainsley': ['NNP'],
  'Ainslie': ['NNP'],
  'Ainsworth': ['NNP'],
  'Ainu': ['NNP'],
  'Ainus': ['NNPS'],
  'Air': ['NNP'],
  'Air-drifts': ['CD'],
  'Air-freight': ['NN'],
  'Air-raid': ['JJ'],
  'Air-to-ground': ['JJ'],
  'Air-traffic': ['NN'],
  'AirCal': ['NNP'],
  'AirMalta': ['NNP'],
  'AirTran': ['NNP'],
  'Airborne': ['NNP'],
  'Airbus': ['NNP'],
  'Aircoa': ['NNP'],
  'Aircraft': ['NNP'],
  'Airedale': ['NNP'],
  'Airedales': ['NNPS'],
  'Aires': ['NNP'],
  'Airfone': ['NNP'],
  'Airfones': ['NNS'],
  'Airgas': ['NNP'],
  'Airless': ['JJ'],
  'Airlie': ['NNP'],
  'Airline': ['NNP'],
  'Airlines': ['NNPS'],
  'Airmail': ['NN'],
  'Airman': ['NNP'],
  'Airpark': ['NNP'],
  'Airplanes': ['NNS'],
  'Airport': ['NNP'],
  'Airports': ['NNP'],
  'Airways': ['NNPS'],
  'Airy': ['JJ'],
  'Ait-Laoussine': ['NNP'],
  'Aitken': ['NNP'],
  'Aiwa': ['NNP'],
  'Aj.': ['NNP'],
  'AjA': ['NNP'],
  'AjB': ['NNP'],
  'Ajax': ['NNP'],
  'Ajinomoto': ['NNP'],
  'Ajit': ['NNP'],
  'Akademie': ['NNP'],
  'Ake': ['NNP'],
  'Akerfeldt': ['NNP'],
  'Akers': ['NNP'],
  'Akerson': ['NNP'],
  'Akin': ['NNP'],
  'Akio': ['NNP'],
  'Akita': ['NNP'],
  'Akiva': ['NNP'],
  'Akron': ['NNP'],
  'Akros': ['NNP'],
  'Aktiebolaget': ['NNP'],
  'Aktiengesellschaft': ['NNP'],
  'Akzo': ['NNP'],
  'Al': ['NNP'],
  'Al-Chalabi': ['NNP'],
  'Al-Faqih': ['NNP'],
  'Al-Rowas': ['NNP'],
  'Al-Sabah': ['NNP'],
  'Al-Seyassah': ['NNP'],
  'Ala': ['NNP'],
  'Ala.': ['NNP'],
  'Alabama': ['NNP'],
  'Alabama-Coushatta': ['JJ'],
  'Alabamans': ['NNS'],
  'Alabamas': ['NNPS'],
  'Alabamian': ['NN'],
  'Alacrity': ['NNP'],
  'Aladdin': ['NNP'],
  'Alagoas': ['NNP'],
  'Alai': ['NNP'],
  'Alain': ['NNP'],
  'Alakshak': ['NNP'],
  'Alameda': ['NNP'],
  'Alamein': ['NNP'],
  'Alamito': ['NNP'],
  'Alamo': ['NNP'],
  'Alamogordo': ['NNP'],
  'Alamos': ['NNP'],
  'Alan': ['NNP'],
  'Alaouite': ['JJ'],
  'Alar': ['NN'],
  'Alar-style': ['JJ'],
  'Alarcon': ['NNP'],
  'Alarm': ['NNP'],
  'Alarmed': ['JJ'],
  'Alas': ['UH'],
  'Alasdair': ['NNP'],
  'Alaska': ['NNP'],
  'Alaska-based': ['JJ'],
  'Alaskan': ['JJ'],
  'Alastair': ['NNP'],
  'Alastor': ['NNP'],
  'Alba': ['NNP'],
  'Albacore': ['NNP'],
  'Albanese': ['NNP'],
  'Albania': ['NNP'],
  'Albanian': ['NNP'],
  'Albanians': ['NNPS'],
  'Albany': ['NNP'],
  'Alberding': ['NNP'],
  'Alberg': ['NNP'],
  'Albers': ['NNP'],
  'Albert': ['NNP'],
  'Alberta': ['NNP'],
  'Albertine': ['NNP'],
  'Alberto': ['NNP'],
  'Albertson': ['NNP'],
  'Albertville': ['NNP'],
  'Albion': ['NNP'],
  'Albrecht': ['NNP'],
  'Albright': ['NNP'],
  'Albrights': ['NNPS'],
  'Album': ['NN'],
  'Albuquerque': ['NNP'],
  'Alcan': ['NNP'],
  'Alcarria': ['NNP'],
  'Alcatel': ['NNP'],
  'Alcatraz': ['NNP'],
  'Alcee': ['NNP'],
  'Alceste': ['NNP'],
  'Alcibiades': ['NNP'],
  'Alcinous': ['JJ'],
  'Alco': ['NNP'],
  'Alcoa': ['NNP'],
  'Alcohol': ['NN'],
  'Alcoholic': ['NNP'],
  'Alcoholics': ['NNPS'],
  'Alcorn': ['NNP'],
  'Alcott': ['NNP'],
  'Alda': ['NNP'],
  'Alden': ['NNP'],
  'Aldermen': ['NNS'],
  'Alderson': ['NNP'],
  'Aldo': ['NNP'],
  'Aldomet': ['NNP'],
  'Aldrich': ['NNP'],
  'Aldridge': ['NNP'],
  'Aldrin': ['NNP'],
  'Aldus': ['NNP'],
  'Alec': ['NNP'],
  'Alejandro': ['NNP'],
  'Aleksei': ['NNP'],
  'Alemagna': ['NNP'],
  'Alert': ['NNP'],
  'Alesio': ['NNP'],
  'Alessio': ['NNP'],
  'Alex': ['NNP'],
  'Alexander': ['NNP'],
  'Alexandra': ['NNP'],
  'Alexandre': ['NNP'],
  'Alexandria': ['NNP'],
  'Alexandrine': ['JJ'],
  'Alexei': ['NNP'],
  'Alexeyeva': ['NNP'],
  'Alexia': ['NNP'],
  'Alexis': ['NNP'],
  'Alf': ['NNP'],
  'Alfa': ['NNP'],
  'Alferon': ['NNP'],
  'Alfieri': ['NNP'],
  'Alfons': ['NNP'],
  'Alfonse': ['NNP'],
  'Alfonso': ['NNP'],
  'Alfred': ['NNP'],
  'Alfredo': ['NNP'],
  'Algemene': ['NNP'],
  'Alger': ['NNP'],
  'Algeria': ['NNP'],
  'Algerian': ['JJ'],
  'Algiers': ['NNP'],
  'Algol': ['NNP'],
  'Algom': ['NNP'],
  'Algonquin': ['NNP'],
  'Ali': ['NNP'],
  'Aliah': ['NNP'],
  'Aliber': ['NNP'],
  'Alice': ['NNP'],
  'Alicia': ['NNP'],
  'Alida': ['NNP'],
  'Alien': ['NNP'],
  'Alienated': ['NNP'],
  'Alienus': ['NNP'],
  'Aligning': ['VBG'],
  'Aliksanian': ['NNP'],
  'Alisarda': ['NNP'],
  'Alisky': ['NNP'],
  'Alison': ['NN'],
  'Alistair': ['NNP'],
  'Alito': ['NNP'],
  'Alix': ['NNP'],
  'Aljian': ['NNP'],
  'Alkylate': ['NNP'],
  'All': ['DT'],
  'All-American': ['NNP'],
  'All-Star': ['NNP'],
  'All-Union': ['NNP'],
  'All-You-Can-Eat': ['NNP'],
  'All-weather': ['JJ'],
  'Alla': ['NNP'],
  'Allah': ['NNP'],
  'Allan': ['NNP'],
  'Allay': ['NN'],
  'Allday': ['NNP'],
  'Allegany': ['NNP'],
  'Alleged': ['JJ'],
  'Alleghany': ['NNP'],
  'Alleghenies': ['NNPS'],
  'Allegheny': ['NNP'],
  'Allegiance': ['NNP'],
  'Allegra': ['NNP'],
  'Allegretti': ['NNP'],
  'Allegro': ['NNP'],
  'Allemands': ['NNP'],
  'Allen': ['NNP'],
  'Allen-film': ['NN'],
  'Allendale': ['NNP'],
  'Allende': ['NNP'],
  'Allenport': ['NNP'],
  'Allentown': ['NNP'],
  'Allergan': ['NNP'],
  'Alley': ['NNP'],
  'Allgemeine': ['NNP'],
  'Alliance': ['NNP'],
  'Alliant': ['NNP'],
  'Allianz': ['NNP'],
  'Allie': ['NNP'],
  'Allied': ['NNP'],
  'Allied-Lyons': ['NNP'],
  'Allied-Signal': ['NNP'],
  'Allies': ['NNPS'],
  'Alligood': ['NNP'],
  'Allingham': ['NNP'],
  'Allis-Chalmers': ['NNP'],
  'Allison': ['NNP'],
  'Allocation': ['NN'],
  'Allons': ['FW'],
  'Allotments': ['NNS'],
  'Allou': ['NNP'],
  'Allow': ['VB'],
  'Allowed': ['VBN'],
  'Allowing': ['VBG'],
  'Alloy': ['NN'],
  'Allso': ['RB'],
  'Allstate': ['NNP'],
  'Allstates': ['NNP'],
  'Allstates-Zenith': ['NNP'],
  'Alltel': ['NNP'],
  'Allumettes': ['NNP'],
  'Allure': ['NN'],
  'Allwaste': ['NNP'],
  'Ally': ['VBP'],
  'Alma': ['NNP'],
  'Almaden': ['NNP'],
  'Almagest': ['NNP'],
  'Almanac': ['NNP'],
  'Almighty': ['NNP'],
  'Almond': ['NN'],
  'Almonds': ['NNS'],
  'Almost': ['RB'],
  'Aloe': ['NNP'],
  'Aloft': ['JJ'],
  'Aloha': ['NNP'],
  'Alois': ['NNP'],
  'Alokut': ['NNP'],
  'Alone': ['RB'],
  'Along': ['IN'],
  'Alongside': ['IN'],
  'Alonso': ['NNP'],
  'Alors': ['FW'],
  'Aloud': ['RB'],
  'Aloys': ['NNP'],
  'Alper': ['NNP'],
  'Alpers': ['NNP'],
  'Alperstein': ['NNP'],
  'Alpert': ['NNP'],
  'Alperts': ['NNS'],
  'Alpha': ['NNP'],
  'Alphametrics': ['NNP'],
  'Alpharetta': ['NNP'],
  'Alphonse': ['NNP'],
  'Alphonsus': ['NNP'],
  'Alpine': ['NNP'],
  'Alpo': ['NNP'],
  'Alps': ['NNP'],
  'Alquist': ['NNP'],
  'Already': ['RB'],
  'Alsagoray': ['NNP'],
  'Alsatian': ['NNP'],
  'Alsatians': ['NNPS'],
  'Alsing': ['NNP'],
  'Also': ['RB'],
  'Also...': [':'],
  'Alson': ['NNP'],
  'Alsop': ['NNP'],
  'Alsthom': ['NNP'],
  'Alstyne': ['NNP'],
  'Alt': ['NNP'],
  'Alta': ['NNP'],
  'Altair': ['NNP'],
  'Altairians': ['NNPS'],
  'Altama': ['NNP'],
  'Altar': ['NNP'],
  'Altenburg': ['NNP'],
  'Alter': ['VB'],
  'Alterman': ['NNP'],
  'Alternate': ['JJ'],
  'Alternately': ['RB'],
  'Alternating': ['VBG'],
  'Alternative': ['JJ'],
  'Alternative-operator': ['NN'],
  'Alternatively': ['RB'],
  'Alternatives': ['NNP'],
  'Althaus': ['NNP'],
  'Althea': ['NNP'],
  'Although': ['IN'],
  'Altimari': ['NNP'],
  'Altman': ['NNP'],
  'Alto': ['NNP'],
  'Altogether': ['RB'],
  'Alton': ['NNP'],
  'Altos': ['NNP'],
  'Altron': ['NNP'],
  'Alumina': ['NNP'],
  'Aluminium': ['NNP'],
  'Aluminum': ['NNP'],
  'Aluminum-Bat': ['NN'],
  'Aluminum-ingot': ['NN'],
  'Alumni': ['NNPS'],
  'Alun-Jones': ['NNP'],
  'AlunJones': ['NNP'],
  'Alurralde': ['NNP'],
  'Alusik': ['NNP'],
  'Alusuisse': ['NNP'],
  'Alva': ['NNP'],
  'Alvan': ['NNP'],
  'Alvarez': ['NNP'],
  'Alvear': ['NNP'],
  'Alvero-Cruz': ['NNP'],
  'Alvin': ['NNP'],
  'Alvise': ['NNP'],
  'Always': ['RB'],
  'Alwin': ['NNP'],
  'Alyce': ['NNP'],
  'Alysia': ['NNP'],
  'Alzheimer': ['NNP'],
  'Am': ['NNP'],
  'AmBase': ['NNP'],
  'AmBrit': ['NNP'],
  'Amabile': ['NNP'],
  'Amada': ['NNP'],
  'Amadee': ['NNP'],
  'Amadeus': ['NN'],
  'Amado': ['NNP'],
  'Amador': ['NNP'],
  'Amadou-Mahtar': ['NNP'],
  'Amalgamated': ['NNP'],
  'Amana': ['NNP'],
  'Amando': ['NNP'],
  'Amaral': ['NNP'],
  'Amarillo': ['NNP'],
  'Amatayakul': ['NNP'],
  'Amateur': ['NNP'],
  'Amaury': ['NNP'],
  'Amax': ['NNP'],
  'Amazing': ['JJ'],
  'Amazon': ['NNP'],
  'Amazonia': ['NNP'],
  'Amazonian': ['JJ'],
  'Ambassador': ['NNP'],
  'Ambassador-at-Large': ['NNP'],
  'Ambassador-designate': ['NNP'],
  'Amber': ['NNP'],
  'Ambigua': ['NNP'],
  'Ambiguan': ['JJ'],
  'Ambiguity': ['NN'],
  'Ambler': ['NNP'],
  'Amboy': ['NNP'],
  'Ambridge': ['NNP'],
  'Ambroise': ['NNP'],
  'Ambrose': ['NNP'],
  'Ambrosiano': ['NNP'],
  'Ambulances': ['NNS'],
  'Ambushes': ['NNS'],
  'Amca': ['NNP'],
  'Amcap': ['NNP'],
  'Amcast': ['NNP'],
  'Amclyde': ['NNP'],
  'Amcor': ['NNP'],
  'Amcore': ['NNP'],
  'Amdahl': ['NNP'],
  'Amdec': ['NNP'],
  'Amdura': ['NNP'],
  'Ameaux': ['NNP'],
  'Amee': ['NNP'],
  'Amelia': ['NNP'],
  'Amen': ['UH'],
  'Amending': ['VBG'],
  'Amendment': ['NNP'],
  'Amendments': ['NNPS'],
  'Amenities': ['NNS'],
  'Amenitskii': ['NNP'],
  'Amer': ['NNP'],
  'Amerace': ['NNP'],
  'Amerada': ['NNP'],
  'Ameri-Cable': ['NNP'],
  'AmeriGas': ['NNP'],
  'AmeriTrust': ['NNP'],
  'America': ['NNP'],
  'America.': ['NNP'],
  'America\\\'/International': ['NNP'],
  'American': ['NNP'],
  'American-China': ['NNP'],
  'American-Jewish': ['JJ'],
  'American-Negro': ['NNP'],
  'American-built': ['JJ'],
  'American-developed': ['JJ'],
  'American-made': ['JJ'],
  'American-style': ['JJ'],
  'American-trained': ['JJ'],
  'Americana': ['NNS'],
  'Americanized': ['VBD'],
  'Americano': ['NNP'],
  'Americans': ['NNPS'],
  'Americas': ['NNP'],
  'Ameritas': ['NNP'],
  'Ameritech': ['NNP'],
  'Amerman': ['NNP'],
  'Ameron': ['NNP'],
  'Amerongen': ['NNP'],
  'Ames': ['NNP'],
  'Ametek': ['NNP'],
  'Amex': ['NNP'],
  'Amfac': ['NNP'],
  'Amfesco': ['NNP'],
  'Amgen': ['NNP'],
  'Amharas': ['NNPS'],
  'Amherst': ['NNP'],
  'Amhowitz': ['NNP'],
  'Amicable': ['NNP'],
  'Amicam': ['NNP'],
  'Amici': ['FW'],
  'Amid': ['IN'],
  'Amidst': ['IN'],
  'Amiel': ['NNP'],
  'Amiga': ['NNP'],
  'Amin': ['NNP'],
  'Amira': ['NNP'],
  'Amis': ['NNP'],
  'Amish': ['NNP'],
  'Amitai': ['NNP'],
  'Amityville': ['NNP'],
  'Amityvilles': ['NNPS'],
  'Amman': ['NNP'],
  'Ammann': ['NNP'],
  'Ammonium': ['NN'],
  'Ammunition': ['NNP'],
  'Amneris': ['NNP'],
  'Amoco': ['NNP'],
  'Amoco-led': ['JJ'],
  'Amomng': ['JJ'],
  'Amon': ['NNP'],
  'Amonasro': ['NNP'],
  'Among': ['IN'],
  'Amor': ['FW'],
  'Amorim': ['NNP'],
  'Amory': ['NNP'],
  'Amos': ['NNP'],
  'Amoskeag': ['NNP'],
  'Amounts': ['NNS'],
  'Amp': ['NNP'],
  'Amparano': ['NNP'],
  'Amperex': ['NNP'],
  'Amra': ['NN'],
  'Amram': ['NNP'],
  'Amro': ['NNP'],
  'Amschel': ['NNP'],
  'Amstel': ['NNP'],
  'Amsterdam': ['NNP'],
  'Amsterdam-Rotterdam': ['NNP'],
  'Amstrad': ['NNP'],
  'Amt': ['FW'],
  'Amtech': ['NNP'],
  'Amtrak': ['NNP'],
  'Amtran': ['NNP'],
  'Amudarya': ['NNP'],
  'Amundsen': ['NNP'],
  'Amusement': ['NN'],
  'Amusements': ['NNPS'],
  'Amusing': ['JJ'],
  'Amvest': ['NNP'],
  'Amway': ['NNP'],
  'Amy': ['NNP'],
  'Amylin': ['NNP'],
  'An': ['DT'],
  'An-12': ['NN'],
  'Ana': ['NNP'],
  'AnaMor': ['NNP'],
  'Anabaptist': ['NN'],
  'Anabaptists': ['NNPS'],
  'Anabel': ['NNP'],
  'Anac': ['NNP'],
  'Anacomp': ['NNP'],
  'Anaconda': ['NN'],
  'Anadarko': ['NNP'],
  'Anaheim': ['NNP'],
  'Anaheim-Santa': ['NNP'],
  'Analog': ['NNP'],
  'Analogously': ['RB'],
  'Analyses': ['NNS'],
  'Analysis': ['NNP'],
  'Analyst': ['NN'],
  'Analysts': ['NNS'],
  'Analytic': ['NNP'],
  'Analytical': ['NNP'],
  'Analytrol': ['NNP'],
  'Analyzer': ['NNP'],
  'Anand': ['NNP'],
  'Anania': ['NNP'],
  'Anarcho-Syndicalists': ['NNPS'],
  'Anastasio': ['NNP'],
  'Anat': ['NNP'],
  'Anatol': ['NNP'],
  'Anatole': ['NNP'],
  'Anatoly': ['NNP'],
  'Anatomically': ['RB'],
  'Ancel': ['NNP'],
  'Anchisi': ['NNP'],
  'Anchor': ['NNP'],
  'Anchorage': ['NNP'],
  'Anchorite': ['NN'],
  'Ancient': ['NNP'],
  'Ancinec': ['NNP'],
  'Ancistrodon': ['NNP'],
  'Anctil': ['NNP'],
  'And': ['CC'],
  'Andalusians': ['NNPS'],
  'Andean': ['JJ'],
  'Andee': ['NNP'],
  'Andel': ['NNP'],
  'Anderlini': ['NNP'],
  'Anders': ['NNP'],
  'Andersen': ['NNP'],
  'Andersen-Price': ['NNP'],
  'Anderson': ['NNP'],
  'Andersson': ['NNP'],
  'Andes': ['NNPS'],
  'Andi': ['NNP'],
  'Andover': ['NNP'],
  'Andras': ['NNP'],
  'Andre': ['NNP'],
  'Andrea': ['NNP'],
  'Andreas': ['NNP'],
  'Andreassen': ['NNP'],
  'Andree': ['NNP'],
  'Andrei': ['NNP'],
  'Andrena': ['NNP'],
  'Andreotti': ['NNP'],
  'Andres': ['NNP'],
  'Andress': ['NNP'],
  'Andrew': ['NNP'],
  'Andrews': ['NNP'],
  'Andriessen': ['NNP'],
  'Andris': ['NNP'],
  'Androfski': ['NNP'],
  'Androgyny': ['NN'],
  'Andromache': ['NNP'],
  'Andrus': ['NNP'],
  'Andruses': ['NNPS'],
  'Andrzej': ['NNP'],
  'Andy': ['NNP'],
  'Anfia': ['NNP'],
  'Angel': ['NNP'],
  'Angel\\\'': ['NNP'],
  'Angela': ['NNP'],
  'Angelenos': ['NNP'],
  'Angeles': ['NNP'],
  'Angeles-Pasadena': ['NNP'],
  'Angeles-area': ['JJ'],
  'Angeles-based': ['JJ'],
  'Angelica': ['NNP'],
  'Angelico': ['NNP'],
  'Angelina': ['NNP'],
  'Angell': ['NNP'],
  'Angellism': ['NNP'],
  'Angelo': ['NNP'],
  'Angels': ['NNPS'],
  'Angenics': ['NNP'],
  'Anger': ['VBP'],
  'Angers': ['NNP'],
  'Angevine': ['NNP'],
  'Angie': ['NNP'],
  'Angier': ['NNP'],
  'Angkor': ['NNP'],
  'Angleterre': ['FW'],
  'Anglia': ['NNP'],
  'Anglian': ['JJ'],
  'Anglican': ['NNP'],
  'Anglicanism': ['NN'],
  'Anglicans': ['NNS'],
  'Anglo': ['NNP'],
  'Anglo-American': ['NNP'],
  'Anglo-Americans': ['NNPS'],
  'Anglo-Argentine': ['NNP'],
  'Anglo-Dutch': ['JJ'],
  'Anglo-French': ['JJ'],
  'Anglo-Irish': ['JJ'],
  'Anglo-Jewish': ['JJ'],
  'Anglo-North': ['JJ'],
  'Anglo-Protestant': ['JJ'],
  'Anglo-Saxon': ['NNP'],
  'Anglo-Saxons': ['NNS'],
  'Anglo\\\'': ['JJ'],
  'Anglo\\\'/Dutch': ['NNP'],
  'Anglophilia': ['NNP'],
  'Anglophobia': ['NN'],
  'Angola': ['NNP'],
  'Angolan': ['JJ'],
  'Angotti': ['NNP'],
  'Angrily': ['RB'],
  'Angrist': ['NNP'],
  'Angry': ['JJ'],
  'Angst': ['NN'],
  'Angus': ['NNP'],
  'Anhalt-Bernburg': ['NNP'],
  'Anheuser': ['NNP'],
  'Anheuser-Busch': ['NNP'],
  'Anhwei': ['NNP'],
  'Animal': ['NN'],
  'Animals': ['NNS'],
  'Animated': ['JJ'],
  'Aniseikonic': ['JJ'],
  'Aniskovich': ['NNP'],
  'Anita': ['NNP'],
  'Anjelica': ['NNP'],
  'Ankara': ['NNP'],
  'Ankeny': ['NNP'],
  'Anker': ['NNP'],
  'Anku': ['NNP'],
  'Anlage': ['NNP'],
  'Ann': ['NNP'],
  'Anna': ['NNP'],
  'Annalee': ['NNP'],
  'Annamorena': ['NNP'],
  'Annandale': ['NNP'],
  'Annapolis': ['NNP'],
  'Annaud': ['NNP'],
  'Anne': ['NNP'],
  'Anne-Marie': ['NNP'],
  'Annenberg': ['NNP'],
  'Annex': ['NNP'],
  'Annicchino': ['NNP'],
  'Annie': ['NNP'],
  'Annihilate': ['VB'],
  'Annisberg': ['NNP'],
  'Anniston': ['NNP'],
  'Anniversary': ['NNP'],
  'Announced': ['JJ'],
  'Announcement': ['NN'],
  'Announces': ['VBZ'],
  'Annual': ['JJ'],
  'Annualized': ['VBN'],
  'Annuities': ['NNS'],
  'Annuity': ['NNP'],
  'Anointing': ['VBG'],
  'Anonymous': ['NNP'],
  'Another': ['DT'],
  'Anouilh': ['NNP'],
  'Anschluss': ['FW'],
  'Ansco': ['NNP'],
  'Ansel': ['NNP'],
  'Anselm': ['NNP'],
  'Anselmo': ['NNP'],
  'Ansley': ['NNP'],
  'Anson': ['NN'],
  'Anspach': ['NNP'],
  'Answer': ['NN'],
  'Answers': ['VBZ'],
  'Ant': ['NN'],
  'Anta': ['NNP'],
  'Antar': ['NNP'],
  'Antarctic': ['NNP'],
  'Antarctica': ['NNP'],
  'Antares': ['NNP'],
  'Ante': ['NN'],
  'Antenne': ['NNP'],
  'Anterior': ['NNP'],
  'Anthea': ['NNP'],
  'Anthem': ['NNP'],
  'Anthology': ['NNP'],
  'Anthong': ['NNP'],
  'Anthony': ['NNP'],
  'Anthropic': ['NNP'],
  'Anthropologists': ['NNS'],
  'Anthropology': ['NNP'],
  'Anti': ['NNP'],
  'Anti-A': ['NNP'],
  'Anti-American': ['JJ'],
  'Anti-Americanism': ['NNP'],
  'Anti-Ballistic': ['NNP'],
  'Anti-Ballistic-Missile': ['JJ'],
  'Anti-Christ': ['NNP'],
  'Anti-Communist': ['JJ'],
  'Anti-Deficiency': ['NNP'],
  'Anti-Jones': ['JJ'],
  'Anti-Semite': ['NN'],
  'Anti-Semitic': ['JJ'],
  'Anti-Swapo': ['JJ'],
  'Anti-Wrinkle': ['NNP'],
  'Anti-abortion': ['JJ'],
  'Anti-apartheid': ['JJ'],
  'Anti-dumping': ['JJ'],
  'Anti-nuclear': ['JJ'],
  'Anti-recession': ['NN'],
  'Anti-union': ['JJ'],
  'Antibody': ['NN'],
  'Anticipated': ['VBN'],
  'Anticipating': ['VBG'],
  'Anticipation': ['NN'],
  'Antietam': ['NNP'],
  'Antigone': ['NNP'],
  'Antigua': ['NNP'],
  'Antilles': ['NNPS'],
  'Antinomians': ['NNS'],
  'Antinori': ['NNP'],
  'Antioquia': ['NNP'],
  'Antique': ['NNP'],
  'Antiques': ['NNPS'],
  'Antiquity': ['NN'],
  'Antisubmarine': ['JJ'],
  'Antithyroid': ['JJ'],
  'Antitrust': ['NNP'],
  'Antler': ['NNP'],
  'Antoine': ['NNP'],
  'Antoinette': ['NNP'],
  'Antolini': ['NNP'],
  'Anton': ['NNP'],
  'Antone': ['NNP'],
  'Antoni': ['NNP'],
  'Antonia': ['NNP'],
  'Antonin': ['NNP'],
  'Antonini': ['NNP'],
  'Antonio': ['NNP'],
  'Antonio-based': ['JJ'],
  'Antonovich': ['NNP'],
  'Antony': ['NNP'],
  'Antori': ['NNP'],
  'Ants': ['NNS'],
  'Antwerp': ['NNP'],
  'Antwerp-based': ['JJ'],
  'Antwerpsche': ['NNP'],
  'Anwar': ['NN'],
  'Anxiety': ['NNP'],
  'Anxious': ['JJ'],
  'Any': ['DT'],
  'Anybody': ['NN'],
  'Anyhow': ['RB'],
  'Anyone': ['NN'],
  'Anything': ['NN'],
  'Anytime': ['RB'],
  'Anyway': ['RB'],
  'Anywhere': ['RB'],
  'Anzilotti': ['NNP'],
  'Aoki': ['NNP'],
  'Aon': ['NNP'],
  'Aouelloul': ['NNP'],
  'Aoun': ['NNP'],
  'Aoyama': ['NNP'],
  'Apache': ['NNP'],
  'Apaches': ['NNPS'],
  'Apalachicola': ['NNP'],
  'Apar': ['NNP'],
  'Aparicio': ['NNP'],
  'Apart': ['RB'],
  'Apartheid': ['NNP'],
  'Apartment': ['NN'],
  'Apartments': ['NNP'],
  'Ape': ['NNP'],
  'Apergillus': ['NN'],
  'Apex': ['NNP'],
  'Aphrodite': ['NNP'],
  'Apicella': ['NNP'],
  'Apocalypse': ['NNP'],
  'Apocalyptic': ['NNP'],
  'Apocrypha': ['NNPS'],
  'Apogee': ['NNP'],
  'Apollinaire': ['NNP'],
  'Apollo': ['NNP'],
  'Apollonian': ['JJ'],
  'Apolo': ['NNP'],
  'Apologia': ['NN'],
  'Apologie': ['NNP'],
  'Apologies': ['NNS'],
  'Apology': ['NNP'],
  'Apostles': ['NNPS'],
  'Apostolakis': ['NNP'],
  'App': ['NNP'],
  'App.': ['NNP'],
  'Appalachia': ['NNP'],
  'Appalachian': ['NNP'],
  'Appalachians': ['NNPS'],
  'Appalled': ['JJ'],
  'Appaloosas': ['NNPS'],
  'Apparatus': ['NN'],
  'Apparel': ['NN'],
  'Apparently': ['RB'],
  'Appeal': ['NNP'],
  'Appealing': ['VBG'],
  'Appeals': ['NNPS'],
  'Appear': ['VBP'],
  'Appearance': ['NN'],
  'Appel': ['NNP'],
  'Appelbaum': ['NNP'],
  'Appell': ['NNP'],
  'Appellate': ['NNP'],
  'Appendix': ['NN'],
  'Appendixes': ['NNS'],
  'Appert': ['NNP'],
  'Appian': ['NNP'],
  'Appignanesi': ['NNP'],
  'Applause': ['NN'],
  'Apple': ['NNP'],
  'Apple-Microsoft': ['NNP'],
  'Applebaum': ['NNP'],
  'Applebee': ['NNP'],
  'Appleby': ['NNP'],
  'Apples': ['NNS'],
  'Appleseed': ['NNP'],
  'Appleseeds': ['NNPS'],
  'Appleton': ['NNP'],
  'Appleyard': ['NNP'],
  'Appliances': ['NNPS'],
  'Application': ['NNP'],
  'Applications': ['NNS'],
  'Applied': ['NNP'],
  'Applying': ['VBG'],
  'Appointed': ['VBN'],
  'Appointment': ['NN'],
  'Appraisers': ['NNPS'],
  'Appreciation': ['NNP'],
  'Apprehensively': ['RB'],
  'Apprentice': ['NNP'],
  'Approach': ['NNP'],
  'Approached': ['VBN'],
  'Approaches': ['NNS'],
  'Approaching': ['VBG'],
  'Appropriate': ['JJ'],
  'Appropriately': ['RB'],
  'Appropriation': ['NNP'],
  'Appropriations': ['NNP'],
  'Approval': ['NN'],
  'Approvals': ['NNS'],
  'Approved': ['VBN'],
  'Approximately': ['RB'],
  'April': ['NNP'],
  'April-June': ['NNP'],
  'Aprile': ['NNP'],
  'Apropos': ['RB'],
  'Aprotinine': ['NNP'],
  'Apt': ['JJ'],
  'Aptitude': ['NNP'],
  'Aqazadeh': ['NNP'],
  'Aqua': ['NNP'],
  'Aqua-Ban': ['NNP'],
  'Aquacutie': ['NNP'],
  'Aqualon': ['NNP'],
  'Aquidneck': ['NNP'],
  'Aquifers': ['NNS'],
  'Aquinas': ['NNP'],
  'Aquino': ['NNP'],
  'Aquitaine': ['NNP'],
  'Ara': ['NNP'],
  'Arab': ['NNP'],
  'Arab-Israeli': ['JJ'],
  'Arab-sponsored': ['JJ'],
  'Arabia': ['NNP'],
  'Arabian': ['NNP'],
  'Arabian-American': ['NNP'],
  'Arabians': ['NNPS'],
  'Arabic': ['NNP'],
  'Arabist': ['JJ'],
  'Arabs': ['NNPS'],
  'Araby': ['NNP'],
  'Arafat': ['NNP'],
  'Aragon': ['NNP'],
  'Arai': ['NNP'],
  'Arakawa': ['NNP'],
  'Aral': ['NNP'],
  'Aral\'sk': ['NNP'],
  'Aramis': ['NNP'],
  'Aran': ['NNP'],
  'Aransas': ['NNP'],
  'Arapacis': ['NNP'],
  'Araskog': ['NNP'],
  'Arata': ['NNP'],
  'Arau': ['NNP'],
  'Arbeitskommando': ['NNP'],
  'Arbel': ['NNP'],
  'Arbitrage': ['NN'],
  'Arbitrage-related': ['JJ'],
  'Arbitragers': ['NNS'],
  'Arbitraging': ['VBG'],
  'Arbitrary': ['NNP'],
  'Arbitration': ['NN'],
  'Arbogast': ['NNP'],
  'Arbor': ['NNP'],
  'Arboretum': ['NNP'],
  'Arbs': ['NNS'],
  'Arbuckle': ['NNP'],
  'Arby': ['NNP'],
  'Arc': ['NNP'],
  'Arcadian': ['NNP'],
  'Arcadipane': ['NNP'],
  'Arcata': ['NNP'],
  'Arch': ['NNP'],
  'Archaeology': ['NNP'],
  'Archangel': ['NNP'],
  'Archbishop': ['NNP'],
  'Archbishops': ['NNS'],
  'Archer': ['NNP'],
  'Archer-Daniels-Midland': ['NNP'],
  'Archey': ['NNP'],
  'Archibald': ['NNP'],
  'Archie': ['NNP'],
  'Archimedes': ['NNP'],
  'Archipelago': ['NNP'],
  'Architect': ['NNP'],
  'Architects': ['NNS'],
  'Architecture': ['NNP'],
  'Archive': ['NNP'],
  'Archives': ['NNPS'],
  'Archuleta': ['NNP'],
  'Arcilla': ['NNP'],
  'Arco': ['NNP'],
  'Arctic': ['NNP'],
  'Arden': ['NNP'],
  'Ardent': ['NNP'],
  'Ardito': ['NNP'],
  'Ardito-Barletta': ['NNP'],
  'Ardmore': ['NNP'],
  'Are': ['VBP'],
  'Area': ['NNP'],
  'Areas': ['NNS'],
  'Arena': ['NNP'],
  'Arenberg': ['NNP'],
  'Arens': ['NNP'],
  'Arenula': ['NNP'],
  'Arequipa': ['NNP'],
  'Ares': ['NNP'],
  'Arfeen': ['NNP'],
  'Argabright': ['NNP'],
  'Argas': ['NNP'],
  'Argent': ['NNP'],
  'Argentina': ['NNP'],
  'Argentine': ['JJ'],
  'Argentines': ['NNPS'],
  'Argentinian': ['JJ'],
  'Arger': ['NNP'],
  'Argiento': ['NNP'],
  'Argive': ['NNP'],
  'ArgoSystems': ['NNPS'],
  'Argon': ['NN'],
  'Argonauts': ['NNPS'],
  'Argonne': ['NNP'],
  'Argos': ['NNP'],
  'Arguably': ['RB'],
  'Arguing': ['VBG'],
  'Arguments': ['NNS'],
  'Argumenty': ['NNP'],
  'Argus': ['NNP'],
  'Argyll': ['NNP'],
  'Argyros': ['NNP'],
  'Arhat': ['NNP'],
  'Arhats': ['NNPS'],
  'Ariadne': ['NNP'],
  'Ariail': ['NNP'],
  'Ariane': ['NNP'],
  'Arianespace': ['NNP'],
  'Arianism': ['NNP'],
  'Arianist': ['NNP'],
  'Arianists': ['NNS'],
  'Arias': ['NNP'],
  'Aricaras': ['NNPS'],
  'Ariel': ['NNP'],
  'Arigato': ['FW'],
  'Arighi': ['NNP'],
  'Aril': ['NNP'],
  'Arimathea': ['NNP'],
  'Aristech': ['NNP'],
  'Aristide': ['NNP'],
  'Aristotelean-Thomistic': ['JJ'],
  'Aristotelian': ['JJ'],
  'Aristotle': ['NNP'],
  'Arithmetic': ['NNP'],
  'Ariz': ['NNP'],
  'Ariz.': ['NNP'],
  'Ariz.-based': ['JJ'],
  'Arizona': ['NNP'],
  'Arizona-related': ['JJ'],
  'Ark': ['NNP'],
  'Ark.': ['NNP'],
  'Ark.-based': ['JJ'],
  'Arkabutla': ['NNP'],
  'Arkansas': ['NNP'],
  'Arkansas-based': ['JJ'],
  'Arkhangelsk': ['NNP'],
  'Arkhipov': ['NNP'],
  'Arkla': ['NNP'],
  'Arkoma': ['NNP'],
  'Arland': ['NNP'],
  'Arlauskas': ['NNP'],
  'Arleigh': ['NNP'],
  'Arlen': ['NNP'],
  'Arlene': ['NNP'],
  'Arles': ['NN'],
  'Arlin': ['NNP'],
  'Arlington': ['NNP'],
  'Arlt': ['NNP'],
  'Arm': ['NN'],
  'Armada': ['NNP'],
  'Armageddon': ['NN'],
  'Armand': ['NNP'],
  'Armani': ['NNP'],
  'Armas': ['NNP'],
  'Armbro': ['NNP'],
  'Armco': ['NNP'],
  'Armed': ['NNP'],
  'Armen': ['NNP'],
  'Armenia': ['NNP'],
  'Armenian': ['JJ'],
  'Armenians': ['NNPS'],
  'Armentieres': ['NNP'],
  'Armide': ['NN'],
  'Armies': ['NNP'],
  'Armin': ['NNP'],
  'Armisteads': ['NNPS'],
  'Armistice': ['NNP'],
  'Armitage': ['NNP'],
  'Armond': ['NNP'],
  'Armonk': ['NNP'],
  'Armor': ['NNP'],
  'Armored': ['NNP'],
  'Armory': ['NNP'],
  'Armour': ['NNP'],
  'Arms': ['NNP'],
  'Armstrong': ['NNP'],
  'Armuelles': ['NNP'],
  'Army': ['NNP'],
  'Arnault': ['NNP'],
  'Arne': ['NNP'],
  'Arnell': ['NNP'],
  'Arnell\\\'/Bickford': ['NNP'],
  'Arney': ['NNP'],
  'Arnhem': ['NNP'],
  'Arnold': ['NNP'],
  'Arnold-Foster': ['NNP'],
  'Arnolphe': ['NNP'],
  'Arnott': ['NNP'],
  'Aro': ['NNP'],
  'Aromatiques': ['NNP'],
  'Aronson': ['NNP'],
  'Aroostook': ['NNP'],
  'Aros': ['NNP'],
  'Around': ['IN'],
  'Aroused': ['VBN'],
  'Arp': ['NNP'],
  'Arpanet': ['NNP'],
  'Arpege': ['NNP'],
  'Arpino': ['NNP'],
  'Arps': ['NNP'],
  'Arrack': ['NN'],
  'Arragon': ['NNP'],
  'Arraignment': ['NN'],
  'Arraignments': ['NNS'],
  'Arrange': ['VB'],
  'Arrangement': ['NNP'],
  'Arrangements': ['NNS'],
  'Arranging': ['VBG'],
  'Arrayed': ['VBN'],
  'Arrest': ['NN'],
  'Arrested': ['VBN'],
  'Arrington': ['NNP'],
  'Arriving': ['VBG'],
  'Arrow': ['NNP'],
  'Arrowhead': ['NNP'],
  'Arroyo': ['NNP'],
  'Arseneault': ['NNP'],
  'Arsenio': ['NNP'],
  'Arseny': ['NNP'],
  'Arshinkoff': ['NNP'],
  'Art': ['NNP'],
  'Arte': ['NNP'],
  'Artemis': ['NNP'],
  'Artemisia': ['NNP'],
  'Arterial': ['JJ'],
  'Arteries': ['NN'],
  'Artesia': ['NNP'],
  'Artfully': ['RB'],
  'Arthritis': ['NNP'],
  'Arthur': ['NNP'],
  'Arthurian': ['JJ'],
  'Article': ['NN'],
  'Articles': ['NNPS'],
  'Artie': ['NNP'],
  'Artificer': ['NN'],
  'Artificial': ['JJ'],
  'Artillery': ['NN'],
  'Artisans': ['NNS'],
  'Artist': ['NNP'],
  'Artistes': ['NNP'],
  'Artistic': ['JJ'],
  'Artists': ['NNPS'],
  'Artkino': ['NNP'],
  'Artois': ['NNP'],
  'Artra': ['NNP'],
  'Arts': ['NNP'],
  'Artur': ['NNP'],
  'Arturo': ['NNP'],
  'Artzt': ['NNP'],
  'Aruba': ['NNP'],
  'Arundel': ['NNP'],
  'Arvey': ['NNP'],
  'Arvin': ['NNP'],
  'Arvind': ['NNP'],
  'Arx': ['NNP'],
  'As': ['IN'],
  'Asada': ['NNP'],
  'Asahi': ['NNP'],
  'Asahipen': ['NNP'],
  'Asarco': ['NNP'],
  'Asbestos': ['NNP'],
  'Asbury': ['NNP'],
  'Ascent': ['NNP'],
  'Asch': ['NNP'],
  'Aschenbach': ['NNP'],
  'Ascii': ['NNP'],
  'Asea': ['NNP'],
  'Asean': ['JJ'],
  'Asensio': ['NNP'],
  'Ash': ['NNP'],
  'Ash-Can': ['NNP'],
  'Ashamed': ['JJ'],
  'Ashcroft': ['NNP'],
  'Ashenberg': ['NNP'],
  'Asher': ['NNP'],
  'Asher\\\'/Gould': ['NNP'],
  'Asheville': ['NNP'],
  'Ashikaga': ['NNP'],
  'Ashington-Pickett': ['NNP'],
  'Ashkhabad': ['NNP'],
  'Ashland': ['NNP'],
  'Ashley': ['NNP'],
  'Ashman': ['NNP'],
  'Ashmolean': ['NNP'],
  'Ashok': ['NNP'],
  'Ashtabula': ['NN'],
  'Ashton': ['NNP'],
  'Ashton-Tate': ['NNP'],
  'Ashurst': ['NNP'],
  'Ashwood': ['NNP'],
  'Asia': ['NNP'],
  'Asia-Pacific': ['NNP'],
  'Asia\\\'': ['JJ'],
  'Asia\\\'/Pacific': ['JJ'],
  'Asian': ['JJ'],
  'Asian-American': ['JJ'],
  'Asian-Americans': ['NNPS'],
  'Asian-owned': ['JJ'],
  'Asians': ['NNPS'],
  'Asiatic': ['JJ'],
  'Aside': ['RB'],
  'Asides': ['NNP'],
  'Asil': ['NNP'],
  'Asilomar': ['NNP'],
  'Asilone': ['NNP'],
  'Asimov': ['NNP'],
  'Ask': ['VB'],
  'Aska': ['NNP'],
  'Asked': ['VBN'],
  'Askin': ['NNP'],
  'Askington': ['NNP'],
  'Asks': ['VBZ'],
  'Aslacton': ['NNP'],
  'Aslanian': ['NNP'],
  'Asleep': ['RB'],
  'Asman': ['NNP'],
  'Asmara': ['NNP'],
  'Aspe': ['NNP'],
  'Aspects': ['NNPS'],
  'Aspen': ['NNP'],
  'Aspencade': ['NNP'],
  'Aspencades': ['NNPS'],
  'Aspenstrom': ['NNP'],
  'Aspercreme': ['NNP'],
  'Aspilia': ['NN'],
  'Aspin': ['NNP'],
  'Aspirin': ['NNP'],
  'Asquith': ['NNP'],
  'Asra': ['NNP'],
  'Ass\'n': ['NNP'],
  'Ass\'ns': ['NNP'],
  'Assab': ['NNP'],
  'Assad': ['NNP'],
  'Assam': ['NNP'],
  'Assassination': ['NNP'],
  'Assemble': ['VB'],
  'Assemblies': ['NNP'],
  'Assembly': ['NNP'],
  'Assemblyman': ['NNP'],
  'Assemblywoman': ['NNP'],
  'Asser': ['NNP'],
  'Asserts': ['VBZ'],
  'Asses': ['NNS'],
  'Assess': ['VB'],
  'Assessment': ['NNP'],
  'Assessors': ['NNS'],
  'Asset': ['NNP'],
  'Asset-Backed': ['JJ'],
  'Asset-backed': ['JJ'],
  'Asset-management': ['JJ'],
  'Assets': ['NNS'],
  'Assicurazioni': ['NNP'],
  'Assign': ['VB'],
  'Assignation': ['NN'],
  'Assimilation': ['NNP'],
  'Assiniboia': ['NNP'],
  'Assiniboine': ['NNP'],
  'Assist': ['NNP'],
  'Assistance': ['NNP'],
  'Assistant': ['NNP'],
  'Assisting': ['VBG'],
  'Assn': ['NNP'],
  'Assn.': ['NNP'],
  'Associate': ['NNP'],
  'Associated': ['NNP'],
  'Associates': ['NNPS'],
  'Association': ['NNP'],
  'Association-College': ['NNP'],
  'Associations': ['NNP'],
  'Assonance': ['NN'],
  'Assume': ['VB'],
  'Assuming': ['VBG'],
  'Assumption': ['NN'],
  'Assurance': ['NNP'],
  'Assurances': ['NNP'],
  'Assuredly': ['RB'],
  'Assyrian': ['NNP'],
  'Assyriology': ['NN'],
  'Asta': ['NNP'],
  'Astaires': ['NNPS'],
  'Astarte': ['NNP'],
  'Astec': ['NNP'],
  'Asteria': ['NNP'],
  'Asteroidal': ['JJ'],
  'Asti': ['NNP'],
  'Astin': ['NNP'],
  'Aston': ['NNP'],
  'Astonishingly': ['RB'],
  'Astor': ['NNP'],
  'Astoria': ['NNP'],
  'Astra': ['NNP'],
  'Astrid': ['NNP'],
  'Astrodome': ['NNP'],
  'Astronaut': ['NN'],
  'Astronauts': ['NNS'],
  'Astronomy': ['NN'],
  'Astrophysicist': ['NN'],
  'Astros': ['NNPS'],
  'Astwood': ['NNP'],
  'Aswara': ['NNP'],
  'Asylum': ['NNP'],
  'At': ['IN'],
  'Atala': ['NNP'],
  'Atalanta\\\'/Sosnoff': ['NNP'],
  'Atari': ['NNP'],
  'Atchinson': ['NNP'],
  'Atco': ['NNP'],
  'Ate': ['VBD'],
  'Ateliers': ['NNP'],
  'Aterman': ['NNP'],
  'Ath.': ['NNP'],
  'Athabascan': ['NNP'],
  'Athalie': ['NNP'],
  'Athanassiades': ['NNP'],
  'Athearn': ['NNP'],
  'Atheist': ['NNP'],
  'Athena': ['NNP'],
  'Athenaeum': ['NNP'],
  'Athenian': ['JJ'],
  'Athenians': ['NNPS'],
  'Athens': ['NNP'],
  'Atherton': ['NNP'],
  'Athlete': ['NNP'],
  'Athletic': ['NNP'],
  'Athletics': ['NNP'],
  'Athlone': ['NNP'],
  'Atkins': ['NNP'],
  'Atkinson': ['NNP'],
  'Atkisson': ['NNP'],
  'Atkissons': ['NNPS'],
  'Atlanta': ['NNP'],
  'Atlanta-Chicago': ['NNP'],
  'Atlanta-based': ['JJ'],
  'Atlantans': ['NNPS'],
  'Atlantes': ['NN'],
  'Atlantic': ['NNP'],
  'Atlantica': ['NNP'],
  'Atlantis': ['NNP'],
  'Atlas': ['NNP'],
  'Atlas-Centaur': ['NNP'],
  'Atlee': ['NNP'],
  'Atmospheric': ['NNP'],
  'Atomic': ['NNP'],
  'Atomics\\\'/Combustion': ['NNP'],
  'Atone': ['VB'],
  'Atonement': ['NN'],
  'Atonio': ['NNP'],
  'Atop': ['IN'],
  'Atorino': ['NNP'],
  'Atra': ['NNP'],
  'Atreus': ['NNP'],
  'Atrium': ['NNP'],
  'Atsushi': ['NNP'],
  'Atta': ['NN'],
  'Attack': ['NNP'],
  'Attacks': ['VBZ'],
  'Attakapas': ['NNP'],
  'Attali': ['NNP'],
  'Attanasio': ['NNP'],
  'Attempts': ['NNS'],
  'Attendance': ['NN'],
  'Attendants': ['NNPS'],
  'Attending': ['VBG'],
  'Attention': ['NN'],
  'Attermann': ['NNP'],
  'Attic': ['NNP'],
  'Attica': ['NNP'],
  'Attila': ['NNP'],
  'Attilio': ['NNP'],
  'Attitude': ['NN'],
  'Attitudes': ['NNS'],
  'Attlee': ['NNP'],
  'Attopeu': ['NNP'],
  'Attorney': ['NNP'],
  'Attorneys': ['NNS'],
  'Attorneys-at-Large': ['NNP'],
  'Attracted': ['VBN'],
  'Attraction': ['NNP'],
  'Attractions': ['NNPS'],
  'Attribute': ['NNP'],
  'Attributes': ['NNS'],
  'Attridge': ['NNP'],
  'Attrition': ['NN'],
  'Attu': ['NNP'],
  'Attwood': ['NNP'],
  'Atty.': ['NNP'],
  'Atwell': ['NNP'],
  'Atwells': ['NNP'],
  'Atwood': ['NNP'],
  'Atzez': ['NNP'],
  'Au': ['FW'],
  'AuCoin': ['NNP'],
  'Auberge': ['NNP'],
  'Aubr.': ['NNP'],
  'Aubrey': ['NNP'],
  'Auburn': ['NN'],
  'Auckland': ['NNP'],
  'Auction': ['NN'],
  'Auctions': ['NNS'],
  'Audi': ['NNP'],
  'Audience': ['NN'],
  'Audio': ['NNP'],
  'Audiovisual': ['NNP'],
  'Audit': ['NNP'],
  'Auditorium': ['NNP'],
  'Auditors': ['NNS'],
  'Audits': ['NNPS'],
  'Audrey': ['NNP'],
  'Audubon': ['NNP'],
  'Auerbach': ['NNP'],
  'Auf': ['NNP'],
  'Aug.': ['NNP'],
  'Auger': ['NNP'],
  'August': ['NNP'],
  'Augusta': ['NNP'],
  'Augustan': ['NNP'],
  'Augustin': ['NNP'],
  'Augustine': ['NNP'],
  'Augustines': ['NNPS'],
  'Augusto': ['NNP'],
  'Augustus': ['NNP'],
  'Aul': ['NNP'],
  'Aulnay': ['NNP'],
  'Aung': ['NNP'],
  'Aunt': ['NNP'],
  'Auntie': ['NNP'],
  'Aunts': ['NNS'],
  'Aureliano': ['NNP'],
  'Aurelius': ['NNP'],
  'Aureomycin': ['NN'],
  'Aurora': ['NNP'],
  'Auschwitz': ['NNP'],
  'Aussedat': ['NNP'],
  'Austin': ['NNP'],
  'Austins': ['NNPS'],
  'Australasian': ['JJ'],
  'Australia': ['NNP'],
  'Australia-based': ['JJ'],
  'Australia-wide': ['JJ'],
  'Australian': ['JJ'],
  'Australian-American': ['JJ'],
  'Australian-Chinese': ['JJ'],
  'Australian-based': ['JJ'],
  'Australians': ['NNS'],
  'Australites': ['NNS'],
  'Austria': ['NNP'],
  'Austrian': ['JJ'],
  'Austrian-Argentine': ['JJ'],
  'Austro-Hungarian': ['JJ'],
  'Authenticated': ['VBN'],
  'Authentication': ['NNP'],
  'Author': ['NNP'],
  'Authorities': ['NNS'],
  'Authority': ['NNP'],
  'Authority-Garden': ['NNP'],
  'Authors': ['NNS'],
  'Auto': ['NN'],
  'Auto-Europe': ['NNP'],
  'Auto-parts': ['JJ'],
  'AutoPacific': ['NNP'],
  'AutoWorld': ['NNP'],
  'Autobiographies': ['NNS'],
  'Autobiography': ['NNP'],
  'Autocamiones': ['NNP'],
  'Autocoder': ['NN'],
  'Autocollimator': ['NN'],
  'Autocracies': ['NNPS'],
  'Autodesk': ['NNP'],
  'Autolatina': ['NNP'],
  'Automated': ['NNP'],
  'Automatic': ['NNP'],
  'Automatically': ['RB'],
  'Automation': ['NNP'],
  'Automax': ['NNP'],
  'Automobile': ['NNP'],
  'Automobiles': ['NNS'],
  'Automobili': ['NNP'],
  'Automotive': ['NNP'],
  'Autorapido': ['NNP'],
  'Autos': ['NNS'],
  'Autosuggestibility': ['NN'],
  'Autozam': ['NNP'],
  'Autry': ['NNP'],
  'Autumnal': ['JJ'],
  'Auvil': ['NNP'],
  'Auxiliaries': ['NNPS'],
  'Auxiliary': ['NNP'],
  'Av': ['NNP'],
  'Av.': ['NNP'],
  'Ava': ['NNP'],
  'Available': ['JJ'],
  'Avalon': ['NNP'],
  'Avant-garde': ['NN'],
  'Avantor': ['NNP'],
  'Avco': ['NNP'],
  'Avdel': ['NNP'],
  'Ave': ['NNP'],
  'Ave.': ['NNP'],
  'Avedisian': ['NNP'],
  'Avelar': ['NNP'],
  'Avena': ['NNP'],
  'Aventine': ['NNP'],
  'Aventino': ['NNP'],
  'Avenue': ['NNP'],
  'Avenues': ['NNP'],
  'Averae': ['NNP'],
  'Average': ['NNP'],
  'Averages': ['NNP'],
  'Averell': ['NNP'],
  'Avery': ['NNP'],
  'Avi': ['NNP'],
  'Aviacion': ['NNP'],
  'Avianca': ['NNP'],
  'Aviation': ['NNP'],
  'Aviazione': ['NNP'],
  'Aviion': ['NNP'],
  'Avions': ['NNP'],
  'Avis': ['NNP'],
  'Aviv': ['NNP'],
  'Aviva': ['NNP'],
  'Avmark': ['NNP'],
  'Avner': ['NNP'],
  'Avnet': ['NNP'],
  'Avocado': ['NNP'],
  'Avocados': ['NNS'],
  'Avoid': ['VB'],
  'Avoidance': ['NNP'],
  'Avoiding': ['VBG'],
  'Avoids': ['VBZ'],
  'Avon': ['NNP'],
  'Avondale': ['NNP'],
  'Avowed': ['JJ'],
  'Avrett': ['NNP'],
  'Aw': ['UH'],
  'Awad': ['NNP'],
  'Awake': ['NNP'],
  'Awakening': ['NNP'],
  'Award': ['NNP'],
  'Awarding': ['VBG'],
  'Awards': ['NNP'],
  'Aware': ['JJ'],
  'Awareness': ['NN'],
  'Away': ['RB'],
  'Awe': ['NN'],
  'Awesome': ['JJ'],
  'Awkwardly': ['RB'],
  'Awww': ['UH'],
  'Ax': ['NNP'],
  'Axa': ['NNP'],
  'Axa-Midi': ['NNP'],
  'Axe': ['NNP'],
  'Axel': ['NNP'],
  'Axelrod': ['NNP'],
  'Axioms': ['NNS'],
  'Axis': ['NNP'],
  'Axxess': ['NNP'],
  'Ayala': ['NNP'],
  'Ayatollah': ['NNP'],
  'Aycock': ['NNP'],
  'Aye-yah-ah-ah': ['UH'],
  'Ayer': ['NNP'],
  'Ayers': ['NNP'],
  'Aylesbury': ['NNP'],
  'Ayob': ['NNP'],
  'Ayres': ['NNP'],
  'Aysshom': ['NNP'],
  'Ayub': ['NNP'],
  'Azabu': ['NNP'],
  'Azalea': ['NNP'],
  'Azara': ['NNP'],
  'Azcuenaga': ['NNP'],
  'Azem': ['NNP'],
  'Azerbaijan': ['NNP'],
  'Azerbaijani': ['NNP'],
  'Azioni': ['NNP'],
  'Aziz': ['NNP'],
  'Aziza': ['NNP'],
  'Azlant': ['NNP'],
  'Azoff': ['NNP'],
  'Aztar': ['NNP'],
  'Aztec': ['JJ'],
  'Azucena': ['NNP'],
  'Azusa': ['NNP'],
  'B': ['NNP'],
  'B&B': ['NNP'],
  'B&H': ['NNP'],
  'B&W': ['NNP'],
  'B\'Gosh': ['NNP'],
  'B\'dikkat': ['NNP'],
  'B\'dikkat\'s': ['NNS'],
  'B\'nai': ['NNP'],
  'B\'rith': ['NNP'],
  'B-1': ['NNP'],
  'B-1B': ['NNP'],
  'B-1s': ['NNPS'],
  'B-2': ['NNP'],
  'B-2s': ['NNPS'],
  'B-3': ['JJ'],
  'B-4': ['NNP'],
  'B-47': ['NN'],
  'B-52': ['NNP'],
  'B-52H': ['NN'],
  'B-52s': ['CD'],
  'B-58': ['NN'],
  'B-70': ['NNP'],
  'B-As': ['IN'],
  'B-I-G': ['NNP'],
  'B-cell': ['NN'],
  'B-cells': ['NNS'],
  'B-flat': ['NN'],
  'B-movie': ['NN'],
  'B-scale': ['NN'],
  'B.': ['NNP'],
  'B.A.': ['NNP'],
  'B.A.T': ['NNP'],
  'B.A.T...': [':'],
  'B.B.': ['NNP'],
  'B.B.C.': ['NNP'],
  'B.C': ['NN'],
  'B.C.': ['NN'],
  'B.C.-based': ['JJ'],
  'B.D.': ['NNP'],
  'B.F.': ['NNP'],
  'B.G.': ['NNP'],
  'B.J.': ['NNP'],
  'B.M.': ['NNP'],
  'B.S.': ['NNP'],
  'B.U.': ['NNP'],
  'B.V': ['NNP'],
  'B.V.': ['NNP'],
  'B.t.u.': ['NN'],
  'B2': ['NN'],
  'B70': ['NN'],
  'BA': ['NNP'],
  'BACK': ['RB'],
  'BACKED': ['VBD'],
  'BAHAMIAN': ['JJ'],
  'BAII': ['NNP'],
  'BAKER': ['NNP'],
  'BAKKER': ['NNP'],
  'BALANCES': ['NNS'],
  'BALKS': ['VBZ'],
  'BALLOT': ['NN'],
  'BALLOTS': ['NNS'],
  'BALLY\'S': ['NNP'],
  'BAM': ['NNP'],
  'BANCORP': ['NNP'],
  'BANCORPORATION': ['NNP'],
  'BANK': ['NNP'],
  'BANKAMERICA': ['NNP'],
  'BANKERS': ['NNS'],
  'BANKS': ['NNS'],
  'BARKER': ['NNP'],
  'BAROMETER': ['NN'],
  'BART': ['NNP'],
  'BASF': ['NNP'],
  'BATTLE': ['NN'],
  'BATTLED': ['VBD'],
  'BAY': ['NNP'],
  'BAe': ['NNP'],
  'BBB': ['NNP'],
  'BBC': ['NNP'],
  'BBDO': ['NNP'],
  'BBN': ['NNP'],
  'BCA': ['NNP'],
  'BCD': ['NNP'],
  'BCE': ['NNP'],
  'BCED': ['NNP'],
  'BCI': ['NNP'],
  'BCS': ['NNP'],
  'BDDP': ['NNP'],
  'BDO': ['NNP'],
  'BE': ['VB'],
  'BE&K': ['NNP'],
  'BEA': ['NNP'],
  'BEAM': ['NNP'],
  'BEARS': ['NNP'],
  'BEAT': ['NN'],
  'BEAVER': ['NNP'],
  'BECHTEL': ['NNP'],
  'BECOME': ['VB'],
  'BEEN': ['VBN'],
  'BEER': ['NN'],
  'BEGAN': ['VBD'],
  'BEI': ['NNP'],
  'BEING': ['VBG'],
  'BELEAGUERED': ['JJ'],
  'BELL': ['NNP'],
  'BENEFITS': ['NNS'],
  'BENTSEN': ['NNP'],
  'BERNARD': ['NNP'],
  'BEST': ['JJS'],
  'BET': ['NNP'],
  'BEVERLY': ['NNP'],
  'BEWARE': ['VB'],
  'BG': ['NNP'],
  'BGS': ['NNP'],
  'BHP': ['NNP'],
  'BIA-COR': ['NNP'],
  'BICC': ['NNP'],
  'BID': ['NNP'],
  'BIG': ['NNP'],
  'BIGGER': ['JJR'],
  'BILL': ['NN'],
  'BILLS': ['NNS'],
  'BILZERIAN\'S': ['NNP'],
  'BIO-RAD': ['NNP'],
  'BIOTECHNOLOGY': ['NN'],
  'BIP': ['NNP'],
  'BIRDS': ['NNS'],
  'BITCH': ['NN'],
  'BK': ['NNP'],
  'BL': ['NNP'],
  'BLACK': ['JJ'],
  'BLAME': ['VB'],
  'BLAST': ['NN'],
  'BLIP': ['NNP'],
  'BLOCK': ['NNP'],
  'BLOCKBUSTER': ['NNP'],
  'BLOEDEL': ['NNP'],
  'BLOOD': ['NN'],
  'BLOW': ['NNP'],
  'BLS': ['NNP'],
  'BLUE': ['JJ'],
  'BLUES': ['NNPS'],
  'BMA': ['NNP'],
  'BMC': ['NNP'],
  'BMEWS': ['NNP'],
  'BMI': ['NNP'],
  'BMIRs': ['NNPS'],
  'BMP': ['NN'],
  'BMP-1': ['NN'],
  'BMT': ['NNP'],
  'BMW': ['NNP'],
  'BMWs': ['NNS'],
  'BNL': ['NNP'],
  'BNP': ['NNP'],
  'BOARD': ['NNP'],
  'BOARD\'S': ['NNP'],
  'BOAST': ['VB'],
  'BOC': ['NNP'],
  'BOD': ['NN'],
  'BOD1,000': ['NN'],
  'BOEING': ['NNP'],
  'BOGGS': ['NNP'],
  'BOJ': ['NNP'],
  'BOND': ['NN'],
  'BONDS': ['NNS'],
  'BONO': ['FW'],
  'BONUSES': ['NNS'],
  'BOOSTS': ['NNS'],
  'BORLAND': ['NNP'],
  'BOSSES': ['NNP'],
  'BOSTON': ['NNP'],
  'BOTH': ['DT'],
  'BOTTLED': ['VBN'],
  'BOZELL': ['NNP'],
  'BP': ['NNP'],
  'BPB': ['NNP'],
  'BPC': ['NNP'],
  'BPCA': ['NNP'],
  'BPD': ['NNP'],
  'BRACED': ['NNP'],
  'BRADSTREET': ['NNP'],
  'BRAINTRUSTERS': ['NNS'],
  'BRAMALEA': ['NNP'],
  'BRANDS': ['NNPS'],
  'BRANIFF\'S': ['NNP'],
  'BREADBOX': ['NN'],
  'BREAKERS': ['NNP'],
  'BREWERS': ['NNS'],
  'BREWS': ['VBZ'],
  'BRIDGEPORT': ['NNP'],
  'BRIEFS': ['NNS'],
  'BRING': ['VB'],
  'BRISTOL-MYERS': ['NNP'],
  'BRITANNICA': ['NNP'],
  'BRITISH': ['JJ'],
  'BRK': ['NNP'],
  'BRNF': ['NNP'],
  'BROAD': ['NNP'],
  'BROADCASTING': ['NNP'],
  'BROKERAGE': ['NN'],
  'BROWN-FORMAN': ['NNP'],
  'BRUT': ['NNP'],
  'BS': ['NNP'],
  'BSB': ['NNP'],
  'BSN': ['NNP'],
  'BSPP': ['NNP'],
  'BT': ['NNP'],
  'BTL': ['NNP'],
  'BTR': ['NNP'],
  'BTU': ['NNP'],
  'BUELL': ['NNP'],
  'BUFFALO': ['NNP'],
  'BUILDING': ['NNP'],
  'BULL': ['NNP'],
  'BUNDY\'S': ['NNP'],
  'BURBANK': ['NNP'],
  'BURNHAM': ['NNP'],
  'BUSH': ['NNP'],
  'BUSINESS': ['NN'],
  'BUSINESSLAND': ['NNP'],
  'BUSY': ['JJ'],
  'BUT': ['CC'],
  'BUY-OUT': ['NN'],
  'BUYERS': ['NNS'],
  'BUYING': ['NN'],
  'BV': ['NNP'],
  'BVI': ['NNP'],
  'BVI-based': ['JJ'],
  'BVIslander': ['NN'],
  'BVIslanders': ['NNS'],
  'BW': ['NNP'],
  'B\\\'/C': ['NN'],
  'B\\\'/T': ['NNP'],
  'Ba-1': ['JJ'],
  'Ba-2': ['JJ'],
  'Ba-3': ['JJ'],
  'Ba2': ['JJ'],
  'Ba3': ['JJ'],
  'Baa-1': ['JJ'],
  'Baa-2': ['JJ'],
  'Baa-3': ['JJ'],
  'Baa1': ['JJ'],
  'Baa2': ['JJ'],
  'Baa3': ['JJ'],
  'Baar': ['NNP'],
  'Babatunde': ['NNP'],
  'Babbitt': ['NNP'],
  'Babble': ['NN'],
  'Babcock': ['NNP'],
  'Babe': ['NNP'],
  'Babel': ['NNP'],
  'Babelists': ['NNS'],
  'Babies': ['NNS'],
  'Babin': ['NNP'],
  'Babin-Festival': ['NNP'],
  'Babson': ['NNP'],
  'Baby': ['NNP'],
  'Baby-dear': ['NNP'],
  'Babylon': ['NNP'],
  'Babylonian': ['JJ'],
  'Babylonians': ['NNPS'],
  'Bacardi': ['NNP'],
  'Bacarella': ['NNP'],
  'Baccarat': ['NNP'],
  'Bacchus': ['NNP'],
  'Bach': ['NNP'],
  'Bacharach': ['NNP'],
  'Bache': ['NNP'],
  'Bachelor': ['NNP'],
  'Baches': ['NNPS'],
  'Bachlund': ['NNP'],
  'Bachman': ['NNP'],
  'Bachmann': ['NNP'],
  'Bachtold': ['NNP'],
  'Bacillus': ['NN'],
  'Back': ['RB'],
  'Back-of-the-envelope': ['JJ'],
  'Back-to-back': ['JJ'],
  'Backbends': ['NNS'],
  'Backe': ['NNP'],
  'Backed': ['VBN'],
  'Backer': ['NNP'],
  'Backers': ['NNS'],
  'Background': ['NN'],
  'Backhaus': ['NNP'],
  'Backing': ['VBG'],
  'Backlog': ['NN'],
  'Backs': ['VBZ'],
  'Backseat': ['NN'],
  'Backstage': ['RB'],
  'Backstairs': ['NNS'],
  'Backstitch': ['VB'],
  'Backstitching': ['VBG'],
  'Backup': ['JJ'],
  'Backward': ['NNP'],
  'Backyard': ['NN'],
  'Bacon': ['NNP'],
  'Bacteria': ['NNS'],
  'Bacterial': ['JJ'],
  'Bad': ['JJ'],
  'Badder': ['NNP'],
  'Baden-Baden': ['NNP'],
  'Baden-Wuerttemberg': ['NNP'],
  'Baden-Wuerttemburg': ['NNP'],
  'Bader': ['NNP'],
  'Badges': ['NNS'],
  'Badin': ['NNP'],
  'Badlands': ['NNS'],
  'Badly': ['RB'],
  'Badrawi': ['NNP'],
  'Badura-Skoda-Vienna': ['NNP'],
  'Baer': ['NNP'],
  'Baeyens': ['NNP'],
  'Baeyenses': ['NNP'],
  'Baffin': ['NNP'],
  'Bafflers': ['NNPS'],
  'Bag': ['NN'],
  'Bagatelles': ['NNPS'],
  'Bagcraft': ['NNP'],
  'Baggage': ['NN'],
  'Bagging': ['VBG'],
  'Bagh': ['NNP'],
  'Baghdad': ['NNP'],
  'Bagley': ['NNP'],
  'Bagneaux': ['NNP'],
  'Bagnoli': ['NNP'],
  'Bags': ['NNS'],
  'Bah': ['UH'],
  'Bahamas': ['NNPS'],
  'Bahamian': ['JJ'],
  'Bahar': ['NNP'],
  'Bahcall': ['NNP'],
  'Bahi': ['NNP'],
  'Bahia': ['NNP'],
  'Bahr': ['NNP'],
  'Bahrain': ['NNP'],
  'Bahre': ['NNP'],
  'Bahrenburg': ['NNP'],
  'Baiba': ['NNP'],
  'Bailard': ['NNP'],
  'Baileefe': ['NNP'],
  'Bailey': ['NNP'],
  'Bailiffs': ['NNS'],
  'Bailit': ['NNP'],
  'Bailkin': ['NNP'],
  'Bailly': ['NNP'],
  'Bailout': ['NNP'],
  'Baily': ['NNP'],
  'Baim': ['NNP'],
  'Bain': ['NNP'],
  'Bainbridge': ['NNP'],
  'Baines': ['NNP'],
  'Baird': ['NNP'],
  'Bairnco': ['NNP'],
  'Bait': ['NNP'],
  'Baja': ['NNP'],
  'Bajakian': ['NNP'],
  'Bake': ['NNP'],
  'Bake-Off': ['NNP'],
  'Bake-off': ['NNP'],
  'Baker': ['NNP'],
  'Baker-Shevardnadze': ['NNP'],
  'Bakeries': ['NNP'],
  'Bakersfield': ['NNP'],
  'Bakery': ['NNP'],
  'Bakes': ['NNP'],
  'Bakhtiari': ['NNP'],
  'Baking': ['NNP'],
  'Bakker': ['NNP'],
  'Bakkers': ['NNPS'],
  'Baku': ['NNP'],
  'Bal': ['NNP'],
  'Bala': ['NNP'],
  'Balafrej': ['NNP'],
  'Balag': ['NNP'],
  'Balaguer': ['NNP'],
  'Balance': ['NNP'],
  'Balanced': ['VBN'],
  'Balances': ['NNP'],
  'Balanchine': ['NNP'],
  'Balcerowicz': ['NNP'],
  'Balch': ['NNP'],
  'Balcolm': ['NNP'],
  'Balcor': ['NNP'],
  'Bald': ['NNP'],
  'Baldness': ['NN'],
  'Baldor': ['NNP'],
  'Baldrige': ['NNP'],
  'Baldry': ['NNP'],
  'Baldwin': ['NNP'],
  'Baldy': ['NNP'],
  'Balenciaga': ['NNP'],
  'Bales': ['NNP'],
  'Balfour': ['NNP'],
  'Bali': ['NNP'],
  'Baliles': ['NNP'],
  'Balinese': ['NNP'],
  'Balkan': ['NNP'],
  'Balkanize': ['VB'],
  'Balkanized': ['JJ'],
  'Balkanizing': ['VBG'],
  'Balkans': ['NNPS'],
  'Balking': ['VBG'],
  'Ball': ['NNP'],
  'Ballad': ['NNP'],
  'Balladur': ['NNP'],
  'Ballantine': ['NNP'],
  'Ballantine\\\'/Del': ['NNP'],
  'Ballard': ['NNP'],
  'Ballenger': ['NNP'],
  'Ballestre': ['NNP'],
  'Ballet': ['NNP'],
  'Ballets': ['NNP'],
  'Balletto': ['NNP'],
  'Ballhaus': ['NNP'],
  'Ballinger': ['NNP'],
  'Ballistic': ['NNP'],
  'Ballon': ['NNP'],
  'Balloon': ['NNP'],
  'Ballooning': ['NN'],
  'Ballot': ['NN'],
  'Ballou': ['NNP'],
  'Ballroom': ['NNP'],
  'Ballwin': ['NNP'],
  'Bally': ['NNP'],
  'Balmain': ['NNP'],
  'Balmer': ['NNP'],
  'Balmy': ['JJ'],
  'Balogh': ['NNP'],
  'Balsbaugh': ['NNP'],
  'Baltasar': ['NNP'],
  'Baltensweiler': ['NNP'],
  'Baltic': ['JJ'],
  'Baltimore': ['NNP'],
  'Baltimore-Washington': ['NNP'],
  'Baltimore-based': ['JJ'],
  'Baltimorean': ['NNP'],
  'Balts': ['NNPS'],
  'Baluchis': ['NNPS'],
  'Baly': ['NNP'],
  'Balzac': ['NNP'],
  'Bam': ['UH'],
  'Bamberger': ['NNP'],
  'Bambi': ['NNP'],
  'Bambi-syndronists': ['NNS'],
  'Bamboo': ['JJ'],
  'Bamford': ['NNP'],
  'Bamsi': ['NNP'],
  'BanPonce': ['NNP'],
  'Banana': ['NNP'],
  'Bananas': ['NNS'],
  'Banawan': ['NNP'],
  'Banawans': ['NNPS'],
  'Banbury': ['NNP'],
  'Banc': ['NNP'],
  'BancNewEngland': ['NNP'],
  'BancOklahoma': ['NNP'],
  'Banca': ['NNP'],
  'Bancaire': ['NNP'],
  'Bancario': ['NNP'],
  'Banco': ['NNP'],
  'Bancorp': ['NNP'],
  'Bancorp.': ['NNP'],
  'Bancroft': ['NNP'],
  'Bancshares': ['NNPS'],
  'Band': ['NNP'],
  'Band-Aid': ['NNP'],
  'Banda': ['NNP'],
  'Bandaging': ['NNP'],
  'Bandar': ['NNP'],
  'Bandini': ['NNP'],
  'Bandish': ['NNP'],
  'Bandit': ['NN'],
  'Bandler': ['NNP'],
  'Bandon': ['NNP'],
  'Bandow': ['NNP'],
  'Bandstand': ['NN'],
  'Bane': ['NNP'],
  'Banerian': ['NNP'],
  'Banfield': ['NNP'],
  'Bang': ['NNP'],
  'Bang-Jensen': ['NNP'],
  'Bangalore': ['NNP'],
  'Bangemann': ['NNP'],
  'Bangkok': ['NNP'],
  'Bangkok-Rangoon': ['NNP'],
  'Bangkok-based': ['JJ'],
  'Bangladesh': ['NNP'],
  'Bangles': ['NNPS'],
  'Bangs': ['NNP'],
  'Bani': ['NNP'],
  'Banjo': ['NNP'],
  'Bank': ['NNP'],
  'Bank-America': ['NNP'],
  'Bank-Texas': ['NNP'],
  'BankAmerica': ['NNP'],
  'BankTexas': ['NNP'],
  'BankWatch': ['NNP'],
  'Bank\\\'/IMF': ['NNP'],
  'Bank\\\'/Tidewater': ['NNP'],
  'Bankcard': ['NNP'],
  'Banker': ['NNP'],
  'Bankers': ['NNPS'],
  'Bankhaus': ['NNP'],
  'Bankhead': ['NNP'],
  'Banking': ['NNP'],
  'Bankler': ['NNP'],
  'Banknote': ['NNP'],
  'Bankrolled': ['VBN'],
  'Bankruptcy': ['NNP'],
  'Bankruptcy-court': ['NN'],
  'Bankrupty': ['NNP'],
  'Banks': ['NNP'],
  'Bankshares': ['NNPS'],
  'Bankverein': ['NNP'],
  'Banner': ['NNP'],
  'Banners': ['NNS'],
  'Banning': ['VBG'],
  'Bannister': ['NNP'],
  'Banoun': ['NNP'],
  'Banque': ['NNP'],
  'Banquet': ['NNP'],
  'Bans': ['NNP'],
  'Banstar': ['NNP'],
  'Bantam': ['NNP'],
  'Bante': ['NNP'],
  'Bantu': ['NNP'],
  'Bantus': ['NNPS'],
  'Banvel': ['NNP'],
  'Banxquote': ['NNP'],
  'Bapepam': ['NNP'],
  'Bapilly': ['NNP'],
  'Baptist': ['NNP'],
  'Baptiste': ['NNP'],
  'Baptists': ['NNS'],
  'Bar': ['NNP'],
  'Bar-H': ['NNP'],
  'Bar-Shavit': ['NNP'],
  'Barabba': ['NNP'],
  'Barabolak': ['NNP'],
  'Baraclough': ['NNP'],
  'Barakat': ['NNP'],
  'Baranovichi': ['NNP'],
  'Barasch': ['NNP'],
  'Barataria': ['NNP'],
  'Barba': ['NNP'],
  'Barbados': ['NNP'],
  'Barbakow': ['NNP'],
  'Barbanell': ['NNP'],
  'Barbara': ['NNP'],
  'Barbaresco': ['NNP'],
  'Barbarians': ['NNP'],
  'Barbariccia': ['NNP'],
  'Barbary': ['JJ'],
  'Barbaud': ['NNP'],
  'Barbecued': ['JJ'],
  'Barbee': ['NNP'],
  'Barber': ['NNP'],
  'Barber-Greene': ['NNP'],
  'Barbera': ['NNP'],
  'Barberini': ['NNP'],
  'Barberis': ['NNP'],
  'Barberton': ['NNP'],
  'Barbie': ['NNP'],
  'Barbier-Mueller': ['NNP'],
  'Barbour': ['NNP'],
  'Barbra': ['NNP'],
  'Barbudos': ['NNPS'],
  'Barcalounger': ['NNP'],
  'Barcelona': ['NNP'],
  'Barcelona-based': ['JJ'],
  'Barclay': ['NNP'],
  'Barclays': ['NNP'],
  'Barco': ['NNP'],
  'Barcus': ['NNP'],
  'Bard': ['NNP'],
  'Bard\\\'/EMS': ['NNP'],
  'Bardagy': ['NNP'],
  'Bardall': ['NNP'],
  'Bardell': ['NNP'],
  'Bare': ['JJ'],
  'Bare-Faced': ['NNP'],
  'Barell': ['NNP'],
  'Barely': ['RB'],
  'Barend': ['NNP'],
  'Barenholtz': ['NNP'],
  'Barfield': ['NNP'],
  'Bargain': ['NN'],
  'Bargain-hunters': ['NNS'],
  'Bargain-hunting': ['NN'],
  'Barge': ['NNP'],
  'Bargen': ['NNP'],
  'Bargerter': ['NNP'],
  'Barges': ['NNS'],
  'Bari': ['NNP'],
  'Barilla': ['NNP'],
  'Baring': ['NNP'],
  'Baringer': ['NNP'],
  'Barings': ['NNPS'],
  'Baris': ['NNP'],
  'Barker': ['NNP'],
  'Barkin': ['NNP'],
  'Barkley': ['NNP'],
  'Barksdale': ['NNP'],
  'Barletta': ['NNP'],
  'Barlow': ['NNP'],
  'Barmore': ['NNP'],
  'Barn': ['NNP'],
  'Barnaba': ['NNP'],
  'Barnabas': ['NNP'],
  'Barnard': ['NNP'],
  'Barnes': ['NNP'],
  'Barnet': ['NNP'],
  'Barnett': ['NNP'],
  'Barnevik': ['NNP'],
  'Barney': ['NNP'],
  'Barneys': ['NNP'],
  'Barnhardt': ['NNP'],
  'Barnhill': ['NNP'],
  'Barnicle': ['NNP'],
  'Barnum': ['NNP'],
  'Barnumville': ['NNP'],
  'Barokocy': ['NNP'],
  'Baron': ['NNP'],
  'Baroque': ['JJ'],
  'Barr': ['NNP'],
  'Barrah': ['NNP'],
  'Barre': ['NNP'],
  'Barre-Montpelier': ['NNP'],
  'Barred': ['VBN'],
  'Barreiro': ['NNP'],
  'Barrel': ['NN'],
  'Barren': ['NNP'],
  'Barret': ['NNP'],
  'Barrett': ['NNP'],
  'Barrette': ['JJ'],
  'Barrick': ['NNP'],
  'Barrie': ['NNP'],
  'Barrier': ['NNP'],
  'Barriers': ['NNS'],
  'Barring': ['VBG'],
  'Barrington': ['NNP'],
  'Barrio': ['NNP'],
  'Barrios': ['NNP'],
  'Barris': ['NNP'],
  'Barrister': ['NNP'],
  'Barristers': ['NNS'],
  'Barron': ['NNP'],
  'Barrow': ['NNP'],
  'Barry': ['NNP'],
  'Barrymores': ['NNPS'],
  'Bars': ['NNP'],
  'Barsacs': ['NNPS'],
  'Barshop': ['NNP'],
  'Barsky': ['NNP'],
  'Barstow': ['NNP'],
  'Barsuki': ['NNP'],
  'Bart': ['NNP'],
  'Barter': ['NN'],
  'Barth': ['NNP'],
  'Bartha': ['NNP'],
  'Bartholf': ['NNP'],
  'Bartholow': ['NNP'],
  'Bartleby': ['NNP'],
  'Bartlesville': ['NNP'],
  'Bartlett': ['NNP'],
  'Bartok': ['NNP'],
  'Bartol': ['NNP'],
  'Bartoli': ['NNP'],
  'Barton': ['NNP'],
  'Bartville': ['NNP'],
  'Baruch': ['NNP'],
  'Baruschke': ['NNP'],
  'Bas': ['NNP'],
  'Bascom': ['NNP'],
  'Base': ['NNP'],
  'Baseball': ['NN'],
  'Based': ['VBN'],
  'Basel': ['NNP'],
  'Basel-based': ['JJ'],
  'Baseman': ['NN'],
  'Basement': ['NN'],
  'Basf': ['NNP'],
  'Basham': ['NNP'],
  'Bashaw': ['NNP'],
  'Bashers': ['NNP'],
  'Bashing': ['VBG'],
  'Bashir': ['NNP'],
  'Basho': ['NNP'],
  'Basic': ['NNP'],
  'Basically': ['RB'],
  'Basics': ['NNP'],
  'Basie': ['NNP'],
  'Basil': ['NNP'],
  'Basile': ['NNP'],
  'Basin': ['NNP'],
  'Basing': ['VBG'],
  'Basinger': ['NNP'],
  'Basir': ['NNP'],
  'Baskerville': ['NNP'],
  'Basket': ['NNP'],
  'Basketball': ['NNP'],
  'Baskets': ['NNS'],
  'Baskin': ['NNP'],
  'Baskin-Robbins': ['NNP'],
  'Basking': ['NNP'],
  'Basler': ['NNP'],
  'Baslot': ['NNP'],
  'Basques': ['NNPS'],
  'Basra': ['NNP'],
  'Bass': ['NNP'],
  'Basse': ['NNP'],
  'Basses': ['NNPS'],
  'Bassi': ['NNP'],
  'Bassis': ['NNPS'],
  'Basso': ['NNP'],
  'Bast': ['NNP'],
  'Bastards': ['NNS'],
  'Bastianini': ['NNP'],
  'Bastin': ['NNP'],
  'Basu': ['NNP'],
  'Bataan': ['NNP'],
  'Batallion': ['NNP'],
  'Batallion-2000': ['NNP'],
  'Batangas': ['NNP'],
  'Batavia': ['NNP'],
  'Batch': ['NN'],
  'Batchelder': ['NNP'],
  'Batchelor': ['NNP'],
  'Bateman': ['NNP'],
  'Bates': ['NNP'],
  'Bath': ['NNP'],
  'Bathar-on-Walli': ['NNP'],
  'Bather': ['NN'],
  'Bathing': ['NN'],
  'Baths': ['NNPS'],
  'Bathurst': ['NNP'],
  'Bathyran': ['NNP'],
  'Bathyrans': ['NNPS'],
  'Batibot': ['NNP'],
  'Batista': ['NNP'],
  'Batman': ['NNP'],
  'Baton': ['NNP'],
  'Battalion': ['NNP'],
  'Battalion-2000': ['NN'],
  'Battat': ['NNP'],
  'Battelle': ['NNP'],
  'Batten': ['NNP'],
  'Battenkill': ['NNP'],
  'Battered': ['VBN'],
  'Battery': ['NNP'],
  'Batterymarch': ['NNP'],
  'Battista': ['NNP'],
  'Battle': ['NNP'],
  'Battle-tested': ['JJ'],
  'Baubles': ['NNPS'],
  'Baucus': ['NNP'],
  'Baudelaire': ['NNP'],
  'Bauer': ['NNP'],
  'Bauer-Ecsy': ['NNP'],
  'Bauernfeind': ['NNP'],
  'Bauhaus': ['NNP'],
  'Baulieu': ['NNP'],
  'Baullari': ['NNP'],
  'Baum': ['NNP'],
  'Bauman': ['NNP'],
  'Baumgarten': ['NNP'],
  'Bausch': ['NNP'],
  'Bauser': ['NNP'],
  'Bavaria': ['NNP'],
  'Bavarian': ['JJ'],
  'Bawer': ['NNP'],
  'Baxley': ['NNP'],
  'Baxter': ['NNP'],
  'Bay': ['NNP'],
  'Bay-area': ['JJ'],
  'Bay-front': ['JJ'],
  'Bayaderka': ['NNP'],
  'Bayanihan': ['NNP'],
  'Bayer': ['NNP'],
  'Bayerische': ['NNP'],
  'Bayezit': ['NNP'],
  'Baykal': ['NNP'],
  'Baylor': ['NNP'],
  'Bayne': ['NNP'],
  'Bayonne': ['NNP'],
  'Bayou': ['NNP'],
  'Bayreuth': ['NNP'],
  'Bays': ['NNP'],
  'Baytos': ['NNP'],
  'Baz': ['NNP'],
  'Bazaar': ['NNP'],
  'Bazy-Sire': ['NNP'],
  'Be': ['VB'],
  'Bea': ['NNP'],
  'Beach': ['NNP'],
  'Beachfront': ['NNP'],
  'Beacon': ['NNP'],
  'Bead': ['NN'],
  'Beadle': ['NNP'],
  'Beadles': ['NNP'],
  'Beadleston': ['NNP'],
  'Beads': ['NNPS'],
  'Beady': ['JJ'],
  'Beahrs': ['NNP'],
  'Beairsto': ['NNP'],
  'Beal': ['NNP'],
  'Beale': ['NNP'],
  'Beall': ['NNP'],
  'Beallsville': ['NNP'],
  'Beam': ['NNP'],
  'Beaman': ['NNP'],
  'Beame': ['NNP'],
  'Beaming': ['VBG'],
  'Bean': ['NNP'],
  'Beantown': ['NNP'],
  'Bear': ['NNP'],
  'Beard': ['NNP'],
  'Bearden': ['NNP'],
  'Beardens': ['NNPS'],
  'Beardslee': ['NNP'],
  'Beardsley': ['NNP'],
  'Beare': ['NNP'],
  'Bearer': ['NN'],
  'Bearings': ['NNP'],
  'Bearishness': ['NN'],
  'Bearman': ['NNP'],
  'Bears': ['NNPS'],
  'Bears-Cleveland': ['NNP'],
  'Beast': ['NNP'],
  'Beat': ['NNP'],
  'Beaten': ['VBN'],
  'Beatie': ['NNP'],
  'Beatitudes': ['NNPS'],
  'Beatlemania': ['NN'],
  'Beatles': ['NNPS'],
  'Beatrice': ['NNP'],
  'Beatty': ['NNP'],
  'Beau': ['NNP'],
  'Beaubien': ['NNP'],
  'Beauchamps': ['NNPS'],
  'Beauclerk': ['NNP'],
  'Beaufort': ['NNP'],
  'Beaujolais': ['NNP'],
  'Beaulieu': ['NNP'],
  'Beaumont': ['NNP'],
  'Beauregard': ['NNP'],
  'Beautiful': ['JJ'],
  'Beauty': ['NNP'],
  'Beaux': ['NNP'],
  'Beaux-Arts': ['NNP'],
  'Beaver': ['NNP'],
  'Beaverton': ['NNP'],
  'Beazer': ['NNP'],
  'Bebe': ['NNP'],
  'Bebear': ['NNP'],
  'Bebey': ['NNP'],
  'Bebop': ['NNP'],
  'Becalmed': ['VBN'],
  'Became': ['VBD'],
  'Because': ['IN'],
  'Becca': ['NNP'],
  'Beccaria': ['NNP'],
  'Bechhofer': ['NNP'],
  'Becht': ['NNP'],
  'Bechtel': ['NNP'],
  'Beck': ['NNP'],
  'Becker': ['NNP'],
  'Becket': ['NNP'],
  'Beckett': ['NNP'],
  'Beckman': ['NNP'],
  'Beckstrom': ['NNP'],
  'Beckwith': ['NNP'],
  'Beckworth': ['NNP'],
  'Become': ['VB'],
  'Becoming': ['VBG'],
  'Becton': ['NNP'],
  'Bed': ['NN'],
  'Bedbugs': ['NNS'],
  'Beddall': ['NNP'],
  'Bede': ['NNP'],
  'Bedfellows': ['NNS'],
  'Bedford': ['NNP'],
  'Bedford-Stuyvesant...': [':'],
  'Bedminster': ['NNP'],
  'Bedouins': ['NNS'],
  'Bedridden': ['JJ'],
  'Bedtime': ['NN'],
  'Bee': ['NNP'],
  'Bee-Hunter': ['NNP'],
  'Beebe': ['NNP'],
  'Beebes': ['NNPS'],
  'Beech': ['NNP'],
  'Beech-Nut': ['NNP'],
  'BeechNut': ['NNP'],
  'Beecham': ['NNP'],
  'Beecher': ['NNP'],
  'Beechnut': ['NNP'],
  'Beef': ['NN'],
  'Beefeater': ['NNP'],
  'Beefing': ['VBG'],
  'Beefsteak': ['NNP'],
  'Been': ['VBN'],
  'Beep': ['NNP'],
  'Beer': ['NN'],
  'Beermann': ['NNP'],
  'Beers': ['NNP'],
  'Beesemyers': ['NNP'],
  'Beet': ['NNP'],
  'Beethoven': ['NNP'],
  'Before': ['IN'],
  'Begbick': ['NNP'],
  'Begelman': ['NNP'],
  'Beggiato': ['NNP'],
  'Begging': ['VBG'],
  'Beghin': ['NNP'],
  'Beghin-Say': ['NNP'],
  'Begin': ['VB'],
  'Beginners': ['NNS'],
  'Beginning': ['VBG'],
  'Begins': ['VBZ'],
  'Begley': ['NNP'],
  'Behague': ['NNP'],
  'Behan': ['NNP'],
  'Behavior': ['NN'],
  'Behaviour': ['NN'],
  'Beheading': ['VBG'],
  'Behind': ['IN'],
  'Behind-the-scenes': ['JJ'],
  'Behold': ['VB'],
  'Behrendt': ['NNP'],
  'Behrens': ['NNP'],
  'Behringwerke': ['NNP'],
  'Beiderbecke': ['NNP'],
  'Beige': ['NNP'],
  'Beigel': ['NNP'],
  'Beijing': ['NNP'],
  'Being': ['VBG'],
  'Beira': ['NNP'],
  'Beirut': ['NNP'],
  'Beirut-on-Hudson': ['NNP'],
  'Beise': ['NNP'],
  'Beismortier': ['NNP'],
  'Beit': ['NNP'],
  'Bekaa': ['NNP'],
  'Bekkai': ['NNP'],
  'Bel': ['NNP'],
  'Bel-Air': ['NNP'],
  'Bela': ['NNP'],
  'Belafonte': ['NNP'],
  'Belanger': ['NNP'],
  'Belasco': ['NNP'],
  'Belated': ['JJ'],
  'Belatedly': ['RB'],
  'Belding': ['NNP'],
  'Belfast': ['NNP'],
  'Belge': ['NNP'],
  'Belgian': ['JJ'],
  'Belgians': ['NNPS'],
  'Belgique': ['NNP'],
  'Belgium': ['NNP'],
  'Belgrade': ['NNP'],
  'Belief': ['NN'],
  'Belier': ['NNP'],
  'Believe': ['VB'],
  'Believing': ['VBG'],
  'Belin': ['NNP'],
  'Belinda': ['NNP'],
  'Belisle': ['NNP'],
  'Belk': ['NNP'],
  'Belknap': ['NNP'],
  'Bell': ['NNP'],
  'BellSouth': ['NNP'],
  'BellSouth-LIN': ['NNP'],
  'BellSouth\\\'': ['JJ'],
  'Bella': ['NNP'],
  'Bellamy': ['NNP'],
  'Bellarosa': ['NNP'],
  'Bellas': ['NNP'],
  'Bellcore': ['NNP'],
  'Belle': ['NNP'],
  'Belletch': ['NNP'],
  'Belleville': ['NNP'],
  'Bellevue': ['NNP'],
  'Belli': ['NNP'],
  'Bellinger': ['NNP'],
  'Bellingham': ['NNP'],
  'Bellini': ['NNP'],
  'Bellman': ['NNP'],
  'Bello': ['NNP'],
  'Bellomo-McGee': ['NNP'],
  'Bellow': ['NNP'],
  'Bellows': ['NNP'],
  'Bells': ['NNPS'],
  'Bellwood': ['NNP'],
  'Belmont': ['NNP'],
  'Belmonts': ['NNPS'],
  'Belo': ['NNP'],
  'Belo-Universal': ['NNP'],
  'Belorussian': ['NNP'],
  'Beloved': ['NNP'],
  'Below': ['IN'],
  'Belshazzar': ['NNP'],
  'Belt': ['NNP'],
  'Belth': ['NNP'],
  'Belton': ['NNP'],
  'Beltway': ['NNP'],
  'Beltway-itis': ['NN'],
  'Belvedere': ['NNP'],
  'Belvidere': ['NNP'],
  'Belvieu': ['NNP'],
  'Belway': ['NNP'],
  'Belz': ['NNP'],
  'Belzberg': ['NNP'],
  'Belzbergs': ['NNPS'],
  'Belzec': ['NNP'],
  'Beman': ['NNP'],
  'Ben': ['NNP'],
  'Ben-Gurion': ['NNP'],
  'Ben-hadad': ['NNP'],
  'Benackova': ['NNP'],
  'Benanav': ['NNP'],
  'Benazir': ['NNP'],
  'Bench': ['NNP'],
  'Benched': ['NNP'],
  'Benchley': ['NNP'],
  'Benchmark': ['JJ'],
  'Bend': ['NNP'],
  'Benda': ['NNP'],
  'Bendectin': ['NNP'],
  'Bendix\\\'/King': ['NNP'],
  'Bendjedid': ['NNP'],
  'Beneath': ['IN'],
  'Benedek': ['NNP'],
  'Benedetti': ['NNP'],
  'Benedetto': ['NNP'],
  'Benedick': ['NNP'],
  'Benedictine': ['JJ'],
  'Benediction': ['NNP'],
  'Benefactor': ['NNP'],
  'Beneficial': ['NNP'],
  'Beneficiaries': ['NNS'],
  'Beneficiary': ['NN'],
  'Benefit': ['NNP'],
  'Benefits': ['NNS'],
  'Benelli': ['NNP'],
  'Benelux': ['NNP'],
  'Benes': ['NNP'],
  'Benesi': ['NNP'],
  'Benet': ['NNP'],
  'Benets': ['NNPS'],
  'Benetton': ['NNP'],
  'Beng': ['NNP'],
  'Bengal': ['NNP'],
  'Bengali': ['JJ'],
  'Bengalis': ['NNPS'],
  'Bengals': ['NNPS'],
  'Bengals-Browns': ['JJ'],
  'Bengt': ['NNP'],
  'Benham': ['NNP'],
  'Benigno': ['NNP'],
  'Benin': ['NNP'],
  'Benington': ['NNP'],
  'Benita': ['NNP'],
  'Benito': ['NNP'],
  'Benj': ['NNP'],
  'Benjamin': ['NNP'],
  'Bennett': ['NNP'],
  'Bennett-Bloom': ['NNP'],
  'Bennigsen-Foerder': ['NNP'],
  'Benninger': ['NNP'],
  'Bennington': ['NNP'],
  'Bennis': ['NNP'],
  'Benno': ['NNP'],
  'Benny': ['NNP'],
  'Benoit': ['NNP'],
  'Bens': ['NNP'],
  'Benson': ['NNP'],
  'Bensonhurst': ['NNP'],
  'Bensten': ['NNP'],
  'Bent': ['NNP'],
  'Bent-Arm': ['NNP'],
  'Bentham': ['NNP'],
  'Bentley': ['NNP'],
  'Bentleys': ['NNPS'],
  'Benton': ['NNP'],
  'Bentsen': ['NNP'],
  'Benz': ['NNP'],
  'Benzedrine': ['NNP'],
  'Benzell': ['NNP'],
  'Benzes': ['NNP'],
  'Benzinger': ['NNP'],
  'Beowulf': ['NNP'],
  'Berard': ['NNP'],
  'Berardi': ['NNP'],
  'Berber': ['JJ'],
  'Berbera': ['NNP'],
  'Berche': ['NNP'],
  'Berea': ['NNP'],
  'Berean': ['NNP'],
  'Beregevoy': ['NNP'],
  'Beregovoy': ['NNP'],
  'Berens': ['NNP'],
  'Beresford': ['NNP'],
  'Berets': ['NNPS'],
  'Beretta': ['NNP'],
  'Berettas': ['NNS'],
  'Bereuter': ['NNP'],
  'Berg': ['NNP'],
  'Bergamaschi': ['NNP'],
  'Bergelt': ['NNP'],
  'Bergen': ['NNP'],
  'Berger': ['NNP'],
  'Bergman': ['NNP'],
  'Bergsma': ['NNP'],
  'Bergson': ['NNP'],
  'Bergsten': ['NNP'],
  'Bering': ['NNP'],
  'Beringer': ['NNP'],
  'Berkeley': ['NNP'],
  'Berkely': ['NNP'],
  'Berkley': ['NNP'],
  'Berkman': ['NNP'],
  'Berko': ['NNP'],
  'Berkowitz': ['NNP'],
  'Berks': ['NNP'],
  'Berkshire': ['NNP'],
  'Berkshires': ['NNP'],
  'Berlack': ['NNP'],
  'Berland': ['NNP'],
  'Berlaymont': ['NNP'],
  'Berle': ['NNP'],
  'Berlin': ['NNP'],
  'Berlin-West': ['NNP'],
  'Berliner': ['NNP'],
  'Berliners': ['NNP'],
  'Berlioz': ['NNP'],
  'Berlitz': ['NNP'],
  'Berlusconi': ['NNP'],
  'Berman': ['NNP'],
  'Bermuda': ['NNP'],
  'Bermuda-based': ['JJ'],
  'Bermuda-registered': ['JJ'],
  'Bermudez': ['NNP'],
  'Bern': ['NNP'],
  'Bernadine': ['NNP'],
  'Bernard': ['NNP'],
  'Bernardin': ['NNP'],
  'Bernardine': ['NNP'],
  'Bernardo': ['NNP'],
  'Berndt': ['NNP'],
  'Berne': ['NNP'],
  'Berner': ['NNP'],
  'Bernet': ['NNP'],
  'Bernhard': ['NNP'],
  'Bernhardt': ['NNP'],
  'Bernie': ['NNP'],
  'Berniece': ['NNP'],
  'Bernini': ['NNP'],
  'Bernoulli': ['NNP'],
  'Bernstein': ['NNP'],
  'Bernstein-Macaulay': ['NNP'],
  'Bernz-O-Matic': ['NN'],
  'Berol': ['NNP'],
  'Beronio': ['NNP'],
  'Berra': ['NNP'],
  'Berrellez': ['NNP'],
  'Berri': ['NNP'],
  'Berridge': ['NNP'],
  'Berrigan': ['NNP'],
  'Berry': ['NNP'],
  'Bershad': ['NNP'],
  'Berson': ['NNP'],
  'Bert': ['NNP'],
  'Berte': ['NNP'],
  'Bertelsmann': ['NNP'],
  'Berteros': ['NNPS'],
  'Berth': ['NNP'],
  'Bertha': ['NNP'],
  'Berthelier': ['NNP'],
  'Berthold': ['NNP'],
  'Bertie': ['NNP'],
  'Bertin': ['NNP'],
  'Berto': ['NNP'],
  'Bertoia': ['NNP'],
  'Bertoli': ['NNP'],
  'Bertolotti': ['NNP'],
  'Bertolt': ['NNP'],
  'Berton': ['NNP'],
  'Bertorelli': ['NNP'],
  'Bertram': ['NNP'],
  'Bertrand': ['NNP'],
  'Bertussi': ['NNP'],
  'Beryl': ['NNP'],
  'Beseler': ['NNP'],
  'Beset': ['VBN'],
  'Besher': ['NNP'],
  'Beside': ['IN'],
  'Besides': ['IN'],
  'Bess': ['NNP'],
  'Bessarabia': ['NNP'],
  'Bessemer': ['NNP'],
  'Besset': ['NNP'],
  'Bessie': ['NNP'],
  'Bessie\\\'/Harper': ['NNP'],
  'Best': ['JJS'],
  'Bester': ['NNP'],
  'Bestimmung': ['FW'],
  'Bet': ['NNP'],
  'Beta': ['NNP'],
  'BetaWest': ['NNP'],
  'Betancourt': ['NNP'],
  'Beth': ['NNP'],
  'BethForge': ['NNP'],
  'Bethea': ['NNP'],
  'Bethel': ['NNP'],
  'Bethesda': ['NNP'],
  'Bethle': ['NN'],
  'Bethlehem': ['NNP'],
  'Betrayed': ['NNP'],
  'Bets': ['NNS'],
  'Betsey': ['NNP'],
  'Betsy': ['NNP'],
  'Bette': ['NNP'],
  'Bettencourt': ['NNP'],
  'Better': ['NNP'],
  'Better-educated': ['JJ'],
  'Betting': ['NNP'],
  'Bettner': ['NNP'],
  'Betts': ['NNP'],
  'Betty': ['NNP'],
  'Between': ['IN'],
  'Beulah': ['NNP'],
  'Beutel': ['NNP'],
  'Bevel': ['VB'],
  'Beverage': ['NNP'],
  'Beverages': ['NNP'],
  'Beverly': ['NNP'],
  'Bevmark': ['NNP'],
  'Bevo': ['NNP'],
  'Bew': ['NNP'],
  'Beware': ['VB'],
  'Bewitched': ['NNP'],
  'Bewkes': ['NNP'],
  'Bexar': ['NNP'],
  'Bey': ['NNP'],
  'Beyeler': ['NNP'],
  'Beyer': ['NNP'],
  'Beyond': ['IN'],
  'Bfree': ['NNP'],
  'Bhabani': ['NNP'],
  'Bhagat': ['NNP'],
  'Bharat': ['NNP'],
  'Bharati': ['NNP'],
  'Bhd.': ['NNP'],
  'Bhirud': ['NNP'],
  'Bhojani': ['NNP'],
  'Bhutan': ['NNP'],
  'Bhutto': ['NNP'],
  'Biafra': ['NNP'],
  'Biaggi': ['NNP'],
  'Biagi': ['NNP'],
  'Bialystok': ['NNP'],
  'Bianchi': ['NNP'],
  'Bianco': ['NNP'],
  'Bias': ['NNP'],
  'Bib': ['NNP'],
  'Bibb': ['NNP'],
  'Bible': ['NNP'],
  'Bible-emancipated': ['JJ'],
  'Bible-loving': ['JJ'],
  'Bibles': ['NNPS'],
  'Biblical': ['JJ'],
  'Biblically': ['RB'],
  'Bibliography': ['NN'],
  'Bic': ['NNP'],
  'Bick': ['NNP'],
  'Bickel': ['NNP'],
  'Bickford': ['NNP'],
  'Bickwit': ['NNP'],
  'Bicycle': ['NNP'],
  'Bicycling': ['NNP'],
  'Bicyclists': ['NNPS'],
  'Bid': ['NNP'],
  'Bidard': ['NNP'],
  'Bidding': ['NN'],
  'Biddle': ['NNP'],
  'Biden': ['NNP'],
  'Bidermann': ['NNP'],
  'Bids': ['NNS'],
  'Bieber': ['NNP'],
  'Biederman': ['NNP'],
  'Biedermann': ['NNP'],
  'Biedermeier': ['FW'],
  'Biehl': ['NNP'],
  'Bielas': ['NNP'],
  'Bien': ['NNP'],
  'Bienville': ['NNP'],
  'Bierbower': ['NNP'],
  'Bierce': ['NNP'],
  'Bietnar': ['NNP'],
  'Bifutek-san': ['FW'],
  'Big': ['NNP'],
  'Big-bucks': ['JJ'],
  'Bigelow': ['NNP'],
  'Bigfoot': ['NNP'],
  'Bigg': ['NNP'],
  'Bigger': ['JJR'],
  'Biggest': ['JJS'],
  'Biggio': ['NNP'],
  'Biggs': ['NNP'],
  'Bigness': ['NN'],
  'BiiN': ['NNP'],
  'Bike': ['NNP'],
  'Bikers': ['NNS'],
  'Biking': ['NNP'],
  'Bikini': ['NNP'],
  'Bila': ['NNP'],
  'Bilanz': ['NNP'],
  'Bilbao': ['NNP'],
  'Bilbrey': ['NNP'],
  'Bill': ['NNP'],
  'Billard': ['NNP'],
  'Billboard': ['NNP'],
  'Billboarding': ['NNP'],
  'Billed': ['VBN'],
  'Billerica': ['NNP'],
  'Billheimer': ['NNP'],
  'Billiards': ['NNP'],
  'Billie': ['NNP'],
  'Billiken': ['NNP'],
  'Billikens': ['NNP'],
  'Billing': ['NN'],
  'Billings': ['NNS'],
  'Billion': ['CD'],
  'Billionaire': ['NN'],
  'Billions': ['NNS'],
  'Billmeyer': ['NNP'],
  'Billock': ['NNP'],
  'Bills': ['NNS'],
  'Billy': ['NNP'],
  'Bilzerian': ['NNP'],
  'Bimini': ['NNP'],
  'Binary': ['JJ'],
  'Bince': ['NNP'],
  'Bindal': ['NNP'],
  'Binder': ['NNP'],
  'Bing': ['NNP'],
  'Bingaman': ['NNP'],
  'Binghamton': ['NNP'],
  'Bingles': ['NNS'],
  'Bingley': ['NNP'],
  'Bini': ['NNP'],
  'Binn': ['NNP'],
  'Binning': ['NNP'],
  'Binomial': ['NN'],
  'Biny': ['NNP'],
  'Bio-Dynamic': ['NNP'],
  'Bio-Products': ['NNP'],
  'Bio-Response': ['NNP'],
  'Bio-Technology': ['NNP'],
  'Bio-Trends': ['NNP'],
  'BioScience': ['NNP'],
  'BioSciences': ['NNP'],
  'BioVentures': ['NNP'],
  'Bioanalytical': ['NNP'],
  'Biochemical': ['NNP'],
  'Biochemistry': ['NNP'],
  'Biodegradable': ['JJ'],
  'Bioengineers': ['NNS'],
  'Biofeedback': ['NNP'],
  'Biogen': ['NNP'],
  'Biographical': ['NNP'],
  'Bioline': ['NNP'],
  'Biological': ['JJ'],
  'Biologicals': ['NNP'],
  'Biologico': ['NNP'],
  'Biologics': ['NNP'],
  'Biologique': ['NNP'],
  'Biology': ['NNP'],
  'Biomedicals': ['NNP'],
  'Biomet': ['NNP'],
  'Biondi': ['NNP'],
  'Biondi-Santi': ['NNP'],
  'Biopharm': ['NNP'],
  'Biopure': ['NNP'],
  'Biosciences': ['NNP'],
  'Biosite': ['NNP'],
  'Biosource': ['NNP'],
  'Biosystems': ['NNP'],
  'Biotech': ['NNP'],
  'Biotechnical': ['NNP'],
  'Biotechnology': ['NNP'],
  'Biovest': ['NNP'],
  'Bipartisan': ['JJ'],
  'Birch': ['NNP'],
  'Bird': ['NNP'],
  'Birdie': ['NNP'],
  'Birdpark': ['NNP'],
  'Birds': ['NNP'],
  'Birdwhistell': ['NNP'],
  'Birdwood': ['NNP'],
  'Birenbaum': ['NNP'],
  'Birgfeld': ['NNP'],
  'Birgit': ['NNP'],
  'Birgitta': ['NNP'],
  'Birinyi': ['NNP'],
  'Birk': ['NNP'],
  'Birkel': ['NNP'],
  'Birkelund': ['NNP'],
  'Birkhead': ['NNP'],
  'Birmingham': ['NNP'],
  'Birnbaum': ['NNP'],
  'Birney': ['NNP'],
  'Birns': ['NNP'],
  'Birr': ['NNP'],
  'Birtcher': ['NNP'],
  'Birth': ['NNP'],
  'Birthday': ['NN'],
  'Births': ['NNS'],
  'Bis': ['NNP'],
  'Biscayne': ['NNP'],
  'Bischofberger': ['NNP'],
  'Biscuit': ['NNP'],
  'Biscuits': ['NNP'],
  'Bish': ['NNP'],
  'Bishop': ['NNP'],
  'Bishops': ['NNP'],
  'Bishopsgate': ['NNP'],
  'Bishun': ['NNP'],
  'Bisi': ['NNP'],
  'Bisiewicz': ['NNP'],
  'Bismarck': ['NNP'],
  'Bismarckian': ['JJ'],
  'Bismark': ['NNP'],
  'Bisque': ['NN'],
  'Bissell': ['NNP'],
  'Bissett': ['NNP'],
  'Bisson': ['NNP'],
  'Bit': ['NN'],
  'Bits': ['NNS'],
  'Bittania': ['NNP'],
  'Bitten': ['VBN'],
  'Bitter': ['JJ'],
  'Bitterness': ['NN'],
  'Bitting': ['NNP'],
  'Bittker': ['NNP'],
  'Bix': ['NNP'],
  'Bixby': ['NNP'],
  'BizMart': ['NNP'],
  'Bizarre': ['JJ'],
  'Bizerte': ['NNP'],
  'Bizet': ['NNP'],
  'Bjerre': ['NNP'],
  'Blaber': ['NNP'],
  'Black': ['NNP'],
  'Black-and-white': ['JJ'],
  'Blackberry': ['NNP'],
  'Blackboard': ['NNP'],
  'Blackburn': ['NNP'],
  'Blackfeet': ['NNPS'],
  'Blackfriar': ['NNP'],
  'Blackhawk': ['NNP'],
  'Blackjack': ['NNP'],
  'Blackman': ['NNP'],
  'Blackmer': ['NNP'],
  'Blackmun': ['NNP'],
  'Blackpool': ['NNP'],
  'Blacks': ['NNS'],
  'Blackstock': ['NNP'],
  'Blackstone': ['NNP'],
  'Blackwell': ['NNP'],
  'Blackwells': ['NNPS'],
  'Blackwill': ['NNP'],
  'Blade': ['NNP'],
  'Blaggs': ['NNP'],
  'Blaikie': ['NNP'],
  'Blain': ['NNP'],
  'Blaine': ['NNP'],
  'Blair': ['NNP'],
  'Blaise': ['NNP'],
  'Blake': ['NNP'],
  'Blakes': ['NNS'],
  'Blakey': ['NNP'],
  'Blame': ['VB'],
  'Blamed': ['VBN'],
  'Blaming': ['VBG'],
  'Blampied': ['NNP'],
  'Blanc': ['NNP'],
  'Blanchard': ['NNP'],
  'Blanche': ['NNP'],
  'Blanched': ['VBN'],
  'Blanco': ['NNP'],
  'Blancs': ['NNP'],
  'Bland': ['JJ'],
  'Blandings': ['NNPS'],
  'Blandon': ['NNP'],
  'Blank': ['NNP'],
  'Blankenship': ['NNP'],
  'Blanton': ['NNP'],
  'Blasi': ['NNP'],
  'Blasingame': ['NNP'],
  'Blasphemers': ['NNS'],
  'Blasphemous': ['JJ'],
  'Blass': ['NNP'],
  'Blast': ['NNP'],
  'Blasts': ['NNS'],
  'Blatz': ['NNP'],
  'Blauberman': ['NNP'],
  'Blaustein': ['NNP'],
  'Blaydon': ['NNP'],
  'Blazer': ['NNP'],
  'Bldg': ['NNP'],
  'Bldg.': ['NNP'],
  'Bleach': ['NN'],
  'Bleacher': ['NN'],
  'Bleaching': ['VBG'],
  'Bleak': ['NNP'],
  'Blechman': ['NNP'],
  'Bleckley': ['NNP'],
  'Bleckner': ['NNP'],
  'Bledsoe': ['NNP'],
  'Bleeker': ['NNP'],
  'Bleier': ['NNP'],
  'Blend': ['VB'],
  'Blendax': ['NNP'],
  'Blenheim': ['NNP'],
  'Bless': ['NNP'],
  'Blessed': ['NNP'],
  'Blessings': ['NNS'],
  'Bleus': ['NNP'],
  'Blevins': ['NNPS'],
  'Blier': ['NNP'],
  'Blimp': ['NNP'],
  'Blind': ['JJ'],
  'Blinder': ['NNP'],
  'Blish': ['NNP'],
  'Blistered': ['VBN'],
  'Blitz': ['NNP'],
  'Bloc': ['NNP'],
  'Bloch': ['NNP'],
  'Block': ['NNP'],
  'Blockade': ['NN'],
  'Blockbuster': ['NNP'],
  'Blocked': ['VBN'],
  'Blodgett': ['NNP'],
  'Bloedel': ['NNP'],
  'Bloeser': ['NNP'],
  'Blohm': ['NNP'],
  'Blois': ['NNP'],
  'Blomdahl': ['NNP'],
  'Blomfield': ['NNP'],
  'Blondes': ['NNP'],
  'Blood': ['NNP'],
  'Bloody': ['NNP'],
  'Bloom': ['NNP'],
  'Bloomberg': ['NNP'],
  'Bloomfield': ['NNP'],
  'Bloomingdale': ['NNP'],
  'Bloomingdales': ['NNP'],
  'Bloomington': ['NNP'],
  'Bloopers': ['NNS'],
  'Blossom': ['NNP'],
  'Blot': ['NNP'],
  'Blount': ['NNP'],
  'Blowers': ['NNS'],
  'Blowing': ['NN'],
  'Blue': ['NNP'],
  'Blue-chip': ['JJ'],
  'Blue-chips': ['NNS'],
  'Bluebird': ['NNP'],
  'Bluebonnet': ['NNP'],
  'Bluefield': ['NNP'],
  'Blueger': ['NNP'],
  'Blueprints': ['VBZ'],
  'Blues': ['NNPS'],
  'Bluff': ['NNP'],
  'Blum': ['NNP'],
  'Blumberg': ['NNP'],
  'Blume': ['NNP'],
  'Blumenfeld': ['NNP'],
  'Blumenkrantz': ['NNP'],
  'Blumenthal': ['NNP'],
  'Blumstein': ['NNP'],
  'Blunt': ['NNP'],
  'Bluntly': ['RB'],
  'Blush': ['NNP'],
  'Bluthenzweig': ['NNP'],
  'Blvd': ['NNP'],
  'Blvd.': ['NNP'],
  'Blyth': ['NNP'],
  'Blythe': ['NNP'],
  'Bo': ['NNP'],
  'Boa': ['NN'],
  'Boadicea': ['NNP'],
  'Boake': ['NNP'],
  'Boal': ['NNP'],
  'Board': ['NNP'],
  'Board-listed': ['JJ'],
  'Board-traded': ['JJ'],
  'Boardman': ['NNP'],
  'Boardrooms': ['NNS'],
  'Boards': ['NNPS'],
  'Boardwalk': ['NNP'],
  'Boarts': ['NNP'],
  'Boase': ['NNP'],
  'Boasts': ['VBZ'],
  'Boat': ['NNP'],
  'Boatel': ['NN'],
  'Boating': ['NNP'],
  'Boatmen': ['NNPS'],
  'Boats': ['NNS'],
  'Boatyards': ['NNS'],
  'Boaz': ['NNP'],
  'Bob': ['NNP'],
  'Bobar': ['NNP'],
  'Bobbie': ['NNP'],
  'Bobbsey': ['NNP'],
  'Bobby': ['NNP'],
  'Bobettes': ['NNS'],
  'Bobo': ['NNP'],
  'Boca': ['NNP'],
  'Bocas': ['NNP'],
  'Boccone': ['NNP'],
  'Bochniarz': ['NNP'],
  'Bock': ['NNP'],
  'Bockius': ['NNP'],
  'Bockris': ['NNP'],
  'Boddington': ['NNP'],
  'Bode': ['NNP'],
  'Bodenheim': ['NNP'],
  'Bodenseewerk': ['NNP'],
  'Bodhisattva': ['NNP'],
  'Bodily': ['NNP'],
  'Bodin': ['NNP'],
  'Bodleian': ['NNP'],
  'Bodmer': ['NNP'],
  'Bodner': ['NNP'],
  'Body': ['NNP'],
  'Body-building': ['JJ'],
  'Boehlert': ['NNP'],
  'Boehm': ['NNP'],
  'Boehmer': ['NNP'],
  'Boehringer': ['NNP'],
  'Boehringer-Ingleheim': ['NNP'],
  'Boeing': ['NNP'],
  'Boeings': ['NNPS'],
  'Boeotian': ['NNP'],
  'Boersen-Zeitung': ['NNP'],
  'Boesel': ['NNP'],
  'Boesky': ['NNP'],
  'Boesky-greed-is-good': ['JJ'],
  'Boeskys': ['NNP'],
  'Boettcher': ['NNP'],
  'Bofors': ['NNP'],
  'Boga': ['NNP'],
  'Bogacheva': ['NNP'],
  'Bogart': ['NNP'],
  'Bogartian': ['JJ'],
  'Bogdan': ['NNP'],
  'Bogdanor': ['NNP'],
  'Boggs': ['NNP'],
  'Bogle': ['NNP'],
  'Bognato': ['NNP'],
  'Bogner': ['NNP'],
  'Bogota': ['NNP'],
  'Bohane': ['NNP'],
  'Bohart': ['NNP'],
  'Boheme': ['NNP'],
  'Bohemia': ['NNP'],
  'Bohemian': ['NNP'],
  'Bohemians': ['NNPS'],
  'Bohlen': ['NNP'],
  'Bohmerwald': ['FW'],
  'Bohn': ['NNP'],
  'Bohrer': ['NNP'],
  'Boies': ['NNP'],
  'Boil': ['VB'],
  'Boils': ['NNS'],
  'Boily': ['NNP'],
  'Bois': ['NNP'],
  'Boisbriant': ['NNP'],
  'Boise': ['NNP'],
  'Boise-Cascade': ['NNP'],
  'Boismassif': ['NNP'],
  'Boissoneault': ['NNP'],
  'Boisvert': ['NNP'],
  'Bokat': ['NNP'],
  'Boksen': ['NNP'],
  'Bol': ['NNP'],
  'Boland': ['NNP'],
  'Bolanos': ['NNP'],
  'Bolar': ['NNP'],
  'Bold': ['NNP'],
  'Bolduc': ['NNP'],
  'Bolet': ['NNP'],
  'Boley': ['NNP'],
  'Bolger': ['NNP'],
  'Boliden': ['NNP'],
  'Bolinas': ['NNP'],
  'Bolinder': ['NNP'],
  'Bolingbroke': ['NNP'],
  'Boliou': ['NNP'],
  'Bolivar': ['NNP'],
  'Bolivia': ['NNP'],
  'Bolivian': ['JJ'],
  'Bolker': ['NNP'],
  'Boll': ['NNP'],
  'Bolling': ['NNP'],
  'Bollinger': ['NNP'],
  'Bologna': ['NNP'],
  'Bolotin': ['NNP'],
  'Bolovens': ['NNP'],
  'Bolsa': ['NNP'],
  'Bolsheviks': ['NNPS'],
  'Bolshevism': ['NNP'],
  'Bolshevistic': ['JJ'],
  'Bolshoi': ['NNP'],
  'Bolstered': ['VBN'],
  'Bolstering': ['VBG'],
  'Bolton': ['NNP'],
  'Boltz': ['NNP'],
  'Boltzmann': ['NNP'],
  'Bomb': ['VB'],
  'Bombardier': ['NNP'],
  'Bombay': ['NNP'],
  'Bombeck': ['NNP'],
  'Bombers': ['NNS'],
  'Bombieri': ['NNP'],
  'Bombus': ['NNP'],
  'Bon': ['NNP'],
  'Bonaccolta': ['NNP'],
  'Bonacquist': ['NNP'],
  'Bonanno': ['NNP'],
  'Bonanza': ['NNP'],
  'Bonaparte': ['NNP'],
  'Bonasorte': ['NNP'],
  'Bonaventure': ['NNP'],
  'Bonavia': ['NNP'],
  'Bond': ['NNP'],
  'Bondholder': ['NN'],
  'Bondholders': ['NNS'],
  'Bondi': ['NNP'],
  'Bonds': ['NNS'],
  'Bonds-b': ['NNP'],
  'Bonecrusher': ['NNP'],
  'Boneh': ['NNP'],
  'Bonenfant': ['NNP'],
  'Bones': ['NNS'],
  'Bonett': ['NNP'],
  'Bonfiglio': ['NNP'],
  'Bonfire': ['NN'],
  'Bong': ['UH'],
  'Bongo': ['NNP'],
  'Bonham': ['NNP'],
  'Bonhoeffer': ['NNP'],
  'Bonhoffer': ['NNP'],
  'Boni': ['NNP'],
  'Boniface': ['NNP'],
  'Bonilla': ['NNP'],
  'Bonita': ['NNP'],
  'Bonito': ['NNP'],
  'Bonjour': ['FW'],
  'Bonn': ['NNP'],
  'Bonn-sponsored': ['NNP'],
  'Bonne': ['NNP'],
  'Bonnell': ['NNP'],
  'Bonner': ['NNP'],
  'Bonnet': ['NNP'],
  'Bonneville': ['NNP'],
  'Bonnie': ['NNP'],
  'Bonnier': ['NNP'],
  'Bonnierforetagen': ['NNP'],
  'Bonniers': ['NNP'],
  'Bonnor': ['NNP'],
  'Bonomo': ['NNP'],
  'Bonso': ['NNP'],
  'Bontempo': ['NNP'],
  'Bonus': ['NNP'],
  'Bonuses': ['NNS'],
  'Bonwit': ['NNP'],
  'Booby': ['JJ'],
  'Boogaard': ['NNP'],
  'Boogie': ['NNP'],
  'Book': ['NNP'],
  'Book-of-the-Month': ['NNP'],
  'Booker': ['NNP'],
  'Bookies': ['NNS'],
  'Bookin': ['NNP'],
  'Bookings': ['NNS'],
  'Bookman': ['NNP'],
  'Books': ['NNS'],
  'Bookshop': ['NNP'],
  'Bookwalter': ['NNP'],
  'Boole': ['NNP'],
  'Boom': ['NNP'],
  'Boom-city': ['NNP'],
  'Booming': ['JJ'],
  'Boon': ['NNP'],
  'Boon-Sanwa': ['NNP'],
  'Boondael': ['NNP'],
  'Boone': ['NNP'],
  'Boonton': ['NNP'],
  'Boorse': ['NNP'],
  'Boorstyn': ['NNP'],
  'Boost': ['VB'],
  'Boot': ['NNP'],
  'Booth': ['NNP'],
  'Boothby': ['NNP'],
  'Booths': ['NNS'],
  'Bootle': ['NNP'],
  'Boots': ['NNP'],
  'Booty': ['NN'],
  'Booz': ['NNP'],
  'Booz-Allen': ['NNP'],
  'Borak': ['NNP'],
  'Borax': ['NNP'],
  'Bordeau': ['NNP'],
  'Bordeaux': ['NNP'],
  'Bordel': ['NNP'],
  'Borden': ['NNP'],
  'Bordens': ['NNPS'],
  'Border': ['NNP'],
  'Bordetella': ['NN'],
  'Bordner': ['NNP'],
  'Bore': ['VB'],
  'Boredom': ['NN'],
  'Boren': ['NNP'],
  'Borg-Warner': ['NNP'],
  'Borge': ['NNP'],
  'Borges': ['NNP'],
  'Borgeson': ['NNP'],
  'Borghese': ['NNP'],
  'Borglum': ['NNP'],
  'Borie': ['NNP'],
  'Boris': ['NNP'],
  'Borja': ['NNP'],
  'Bork': ['NNP'],
  'Borland': ['NNP'],
  'Born': ['VBN'],
  'Born-again': ['JJ'],
  'Borneo': ['NNP'],
  'Borner': ['NNP'],
  'Bornholm': ['NNP'],
  'Boron': ['NNP'],
  'Borough': ['NNP'],
  'Borrioboola-Gha': ['NNP'],
  'Borromini': ['NNP'],
  'Borrowed': ['VBN'],
  'Borrower': ['NN'],
  'Borrowers': ['NNS'],
  'Borrowing': ['VBG'],
  'Borscht': ['NNP'],
  'Bortel': ['NNP'],
  'Borten': ['NNP'],
  'Bosak': ['NNP'],
  'Bosch': ['NNP'],
  'Bosco': ['NNP'],
  'Boseki': ['NNP'],
  'Bosh': ['NNP'],
  'Bosis': ['NNP'],
  'Bosket': ['NNP'],
  'Boskin': ['NNP'],
  'Boslego': ['NNP'],
  'Bosler': ['NNP'],
  'Bosley': ['NNP'],
  'Bosphorus': ['NNP'],
  'Bosque': ['NNP'],
  'Boss': ['NNP'],
  'Bosses': ['NNS'],
  'Bostian': ['NNP'],
  'Bostic': ['NNP'],
  'Bostik': ['NNP'],
  'Bostitch': ['NNP'],
  'Boston': ['NNP'],
  'Boston-area': ['JJ'],
  'Boston-based': ['JJ'],
  'Bostonian': ['NNP'],
  'Bostonians': ['NNPS'],
  'Boswell': ['NNP'],
  'Bosworth': ['NNP'],
  'Both': ['DT'],
  'Botswana': ['NNP'],
  'Bottega': ['NNP'],
  'Bottineau': ['NNP'],
  'Bottlers': ['NNP'],
  'Bottling': ['NNP'],
  'Bottom': ['NNP'],
  'Bottoms': ['NNS'],
  'Bottorff': ['NNP'],
  'Botts': ['NNP'],
  'Botulinal': ['JJ'],
  'Bouchard': ['NNP'],
  'Boucher': ['NNP'],
  'Boucherie': ['NNP'],
  'Boucheron': ['NNP'],
  'Boudreau': ['NNP'],
  'Bougainville': ['NNP'],
  'Bougie': ['NNP'],
  'Bouillaire': ['NNP'],
  'Boulder': ['NNP'],
  'Boulet': ['NNP'],
  'Boulevard': ['NNP'],
  'Boulez': ['NNP'],
  'Boulle': ['NNP'],
  'Boulroud': ['NNP'],
  'Boun': ['NNP'],
  'Bouncing': ['NNP'],
  'Boundary': ['NN'],
  'Bouquet': ['NNP'],
  'Bourassa': ['NNP'],
  'Bourbon': ['NNP'],
  'Bourbons': ['NNPS'],
  'Bourcier': ['NNP'],
  'Bourgeois': ['NNP'],
  'Bourguiba': ['NNP'],
  'Bourke': ['NNP'],
  'Bourke-White': ['NNP'],
  'Bourn': ['NNP'],
  'Boursault': ['NNP'],
  'Bourse': ['NNP'],
  'Bourses': ['NNP'],
  'Boursin': ['NNP'],
  'Boutflower': ['NNP'],
  'Bouton': ['NNP'],
  'Boutwell': ['NNP'],
  'Bouvardier': ['NNP'],
  'Bouvier': ['NNP'],
  'Bouwer': ['NNP'],
  'Bouygues': ['NNP'],
  'Bovard': ['NNP'],
  'Bovenzi': ['NNP'],
  'Boveri': ['NNP'],
  'Bovin': ['NNP'],
  'Bovine': ['NNP'],
  'Bow': ['NNP'],
  'Bowan': ['NNP'],
  'Bowater': ['NNP'],
  'Bowden': ['NNP'],
  'Bowder': ['NNP'],
  'Bowdoin': ['NNP'],
  'Bowen': ['NNP'],
  'Bowenized': ['VBN'],
  'Bowers': ['NNP'],
  'Bowery': ['NNP'],
  'Bowes': ['NNP'],
  'Bowie': ['NNP'],
  'Bowing': ['VBG'],
  'Bowker': ['NNP'],
  'Bowl': ['NNP'],
  'Bowlers': ['NNPS'],
  'Bowles': ['NNP'],
  'Bowling': ['NNP'],
  'Bowls': ['NNP'],
  'Bowman': ['NNP'],
  'Bowne': ['NNP'],
  'Bowser': ['NNP'],
  'Bowsher': ['NNP'],
  'Box': ['NNP'],
  'Boxell': ['NNP'],
  'Boxer': ['NNP'],
  'Boxes': ['NNP'],
  'Boxford': ['NNP'],
  'Boxing': ['NN'],
  'Boxwood': ['NNP'],
  'Boxy': ['JJ'],
  'Boy': ['NN'],
  'Boy-Lady': ['NNP'],
  'Boy-Marquita': ['NNP'],
  'Boy/NNP...': [':'],
  'Boyce': ['NNP'],
  'Boyd': ['NNP'],
  'Boyde': ['NNP'],
  'Boyden': ['NNP'],
  'Boyeki': ['NNP'],
  'Boyer': ['NNP'],
  'Boykins': ['NNP'],
  'Boylan': ['NNP'],
  'Boylston': ['NNP'],
  'Boym': ['NNP'],
  'Boys': ['NNPS'],
  'Bozell': ['NNP'],
  'Bozeman': ['NNP'],
  'Bozic': ['NNP'],
  'Bozicevich': ['NNP'],
  'Braathens': ['NNP'],
  'Brace': ['NNP'],
  'Brachfeld': ['NNP'],
  'Bracken': ['NNP'],
  'Bracknell': ['NNP'],
  'Brad': ['NNP'],
  'Bradbury': ['NNP'],
  'Braddock': ['NNP'],
  'Braddock-against-the-Indians': ['NNP'],
  'Braden': ['NNP'],
  'Bradford': ['NNP'],
  'Bradford-White': ['NNP'],
  'Bradlee': ['NNP'],
  'Bradley': ['NNP'],
  'Bradsby': ['NNP'],
  'Bradsher': ['NNP'],
  'Bradstreet': ['NNP'],
  'Brady': ['NNP'],
  'Brady-type': ['JJ'],
  'Brae': ['NNP'],
  'Braeuer': ['NNP'],
  'Bragg': ['NNP'],
  'Braggadocio': ['NNP'],
  'Brahm': ['NNP'],
  'Brahmaputra': ['NNP'],
  'Brahmin': ['NNP'],
  'Brahms': ['NNP'],
  'Brahmsian': ['JJ'],
  'Braidwood': ['NNP'],
  'Braille': ['NNP'],
  'Brailsford': ['NNP'],
  'Brain': ['NN'],
  'Brainard': ['NNP'],
  'Brainards': ['NNPS'],
  'Brains': ['NNS'],
  'Braintree': ['NNP'],
  'Braitman': ['NNP'],
  'Brake': ['NNP'],
  'Brakes': ['NNS'],
  'Braking': ['NNP'],
  'Brakke': ['NN'],
  'Bramah': ['NNP'],
  'Bramalea': ['NNP'],
  'Bramante': ['NNP'],
  'Brambles': ['NNP'],
  'Bramwell': ['NNP'],
  'Bran': ['NNP'],
  'Branagan': ['NNP'],
  'Branca': ['NNP'],
  'Brancato': ['NNP'],
  'Branch': ['NNP'],
  'Branchburg': ['NNP'],
  'Branches': ['NNS'],
  'Branching': ['NNP'],
  'Branchville': ['NNP'],
  'Brand': ['NN'],
  'Brand-Name': ['NN'],
  'Brande': ['NNP'],
  'Brandeis': ['NNP'],
  'Brandel': ['NNP'],
  'Brandenburg': ['NNP'],
  'Brandes': ['NNP'],
  'Brandhorst': ['NNP'],
  'Brando': ['NNP'],
  'Brandon': ['NNP'],
  'Brands': ['NNP'],
  'Brandt': ['NNP'],
  'Brandy': ['NNP'],
  'Brandywine': ['NNP'],
  'Branford': ['NNP'],
  'Braniff': ['NNP'],
  'Branigan': ['NNP'],
  'Branman': ['NNP'],
  'Brannigan': ['NNP'],
  'Brannon': ['NNP'],
  'Branson': ['NNP'],
  'Brant': ['NNP'],
  'Brantford': ['NNP'],
  'Branum': ['NNP'],
  'Braque': ['NNP'],
  'Braques': ['NNPS'],
  'Brascade': ['NNP'],
  'Brash': ['NNP'],
  'Brasil': ['JJ'],
  'Brasilia': ['NNP'],
  'Brasiliaaircraft': ['NNP'],
  'Brass': ['NNP'],
  'Brassbound': ['NNP'],
  'Brassica': ['NNP'],
  'Brassnose': ['NNP'],
  'Brasstown': ['NNP'],
  'Bratislava': ['NNP'],
  'Brauchli': ['NNP'],
  'Braud': ['NNP'],
  'Brauer': ['NNP'],
  'Brauerei': ['NNP'],
  'Braumeisters': ['NNPS'],
  'Braun': ['NNP'],
  'Braunreuther': ['NNP'],
  'Bravado': ['NNP'],
  'Brave': ['NNP'],
  'Braverman': ['NNP'],
  'Braves': ['NNP'],
  'Braving': ['VBG'],
  'Bravo': ['NNP'],
  'Brawer': ['NNP'],
  'Brawley': ['NNP'],
  'Brawls': ['NNS'],
  'Braye': ['NNP'],
  'Brazelton': ['NNP'],
  'Brazen': ['NNP'],
  'Brazil': ['NNP'],
  'Brazilian': ['JJ'],
  'Brazilians': ['NNPS'],
  'Brazos': ['NNP'],
  'Brea': ['NNP'],
  'Bread': ['NNP'],
  'Break': ['NN'],
  'Breakers': ['NNP'],
  'Breakey': ['NNP'],
  'Breakfast': ['NN'],
  'Breaking': ['VBG'],
  'Breaks': ['NNP'],
  'Breakthrough': ['NNP'],
  'Brealey': ['NNP'],
  'Brean': ['NNP'],
  'Breasted': ['NNP'],
  'Breath': ['NN'],
  'Breathing': ['NN'],
  'Breaux': ['NNP'],
  'Brecht': ['NNP'],
  'Brechtian': ['JJ'],
  'Breckenridge': ['NNP'],
  'Breda': ['NNP'],
  'Breed': ['NNP'],
  'Breeden': ['NNP'],
  'Breeder': ['NNP'],
  'Breeders': ['NNP'],
  'Breeding': ['NNP'],
  'Breen': ['NNP'],
  'Breene': ['NNP'],
  'Breger': ['NNP'],
  'Bregman': ['NNP'],
  'Brelin': ['NNP'],
  'Bremen': ['NNP'],
  'Bremerton': ['NNP'],
  'Bremner': ['NNP'],
  'Bremsstrahlung': ['NN'],
  'Brenda': ['NNP'],
  'Brendan': ['NNP'],
  'Brendel': ['NNP'],
  'Brendle': ['NNP'],
  'Brenham': ['NNP'],
  'Brenmor': ['NNP'],
  'Brenna': ['NNP'],
  'Brennan': ['NNP'],
  'Brenner': ['NNP'],
  'Brent': ['NNP'],
  'Brentwood': ['NNP'],
  'Breslin': ['NNP'],
  'Bressler': ['NNP'],
  'Brest': ['NNP'],
  'Brest-Silevniov': ['NNP'],
  'Brestowe': ['NNP'],
  'Brethen': ['NNP'],
  'Bretherick': ['NNP'],
  'Breton': ['NNP'],
  'Brett': ['NNP'],
  'Bretton': ['NNP'],
  'Bretz': ['NNP'],
  'Breuer': ['NNP'],
  'Breuners': ['NNP'],
  'Brevard': ['NNP'],
  'Breve': ['NNP'],
  'Brevet': ['NNP'],
  'Brevetti': ['NNP'],
  'Brew': ['NNP'],
  'Brewer': ['NNP'],
  'Breweries': ['NNP'],
  'Brewers': ['NNS'],
  'Brewery': ['NNP'],
  'Brewing': ['NNP'],
  'Brezhnev': ['NNP'],
  'Brezhnevite': ['NNP'],
  'Brezinski': ['NNP'],
  'Brian': ['NNP'],
  'Briar': ['NNP'],
  'Briarcliff': ['NNP'],
  'Bribe': ['NN'],
  'Brice': ['NNP'],
  'Brick': ['NNP'],
  'Bricker': ['NNP'],
  'Bricklayers': ['NNPS'],
  'Bricks': ['NNS'],
  'Bricktop': ['NNP'],
  'Bricom': ['NNP'],
  'Bride': ['NNP'],
  'Brideshead': ['NNP'],
  'Bridewell': ['NNP'],
  'Bridge': ['NNP'],
  'Bridgeport': ['NNP'],
  'Bridgers': ['NNP'],
  'Bridges': ['NNP'],
  'Bridgestone': ['NNP'],
  'Bridgestone\\\'/Firestone': ['NNP'],
  'Bridget': ['NNP'],
  'Bridgeton': ['NNP'],
  'Bridgetown': ['NNP'],
  'Bridgeview': ['NNP'],
  'Bridgeville': ['NNP'],
  'Bridgewater': ['NNP'],
  'Brief': ['NNP'],
  'Briefer': ['NNP'],
  'Brieff': ['NNP'],
  'Briefly': ['RB'],
  'Brien': ['NNP'],
  'Brierley': ['NNP'],
  'Brierley-controlled': ['JJ'],
  'Brig.': ['NNP'],
  'Brigade': ['NNP'],
  'Brigadier': ['NNP'],
  'Brigadoon': ['NNP'],
  'Brigantine': ['NNP'],
  'Briggs': ['NNP'],
  'Brigham': ['NNP'],
  'Brighetti': ['NNP'],
  'Bright': ['NNP'],
  'Brightman': ['NNP'],
  'Brighton': ['NNP'],
  'Briksa': ['NNP'],
  'Brill': ['NNP'],
  'Brillo': ['NN'],
  'Brindisi': ['NNP'],
  'Bring': ['VB'],
  'Bringing': ['NNP'],
  'Brink': ['NNP'],
  'Brinker': ['NNP'],
  'Brinkley': ['NNP'],
  'Brinkman': ['NNP'],
  'Brinsley': ['NNP'],
  'Brinson': ['NNP'],
  'Brisbane': ['NNP'],
  'Briscoe': ['NNP'],
  'Brisk': ['JJ'],
  'Brissette': ['NNP'],
  'Bristol': ['NNP'],
  'Bristol-Meyers': ['NNP'],
  'Bristol-Myers': ['NNP'],
  'Brit': ['NNP'],
  'Britain': ['NNP'],
  'Britain-U.S.': ['JJ'],
  'Britain-dominated': ['JJ'],
  'Britannia': ['NNP'],
  'Britannic': ['JJ'],
  'Britannica': ['NNP'],
  'Britches': ['NNS'],
  'British': ['JJ'],
  'British-American': ['NNP'],
  'British-Dutch': ['JJ'],
  'British-French-Israeli': ['JJ'],
  'British-based': ['JJ'],
  'British-born': ['JJ'],
  'British-built': ['JJ'],
  'British-owned': ['JJ'],
  'Britisher': ['NNP'],
  'Britoil': ['NNP'],
  'Briton': ['NNP'],
  'Britons': ['NNPS'],
  'Britta': ['NNP'],
  'Brittan': ['NNP'],
  'Brittany': ['NNP'],
  'Britten': ['NNP'],
  'Britto': ['NNP'],
  'Britton': ['NNP'],
  'Brizola': ['NNP'],
  'Broad': ['NNP'],
  'BroadBeach': ['NNP'],
  'Broadbeach': ['NNP'],
  'Broadbent': ['NNP'],
  'Broadcast': ['NNP'],
  'Broadcasters': ['NNS'],
  'Broadcasting': ['NNP'],
  'Broadcasts': ['NNS'],
  'Broader': ['JJR'],
  'Broadly': ['RB'],
  'Broadstar': ['NNP'],
  'Broadview': ['NNP'],
  'Broadway': ['NNP'],
  'Broberg': ['NNP'],
  'Brochures': ['NNS'],
  'Brock': ['NNP'],
  'Brocklin': ['NNP'],
  'Brockman': ['NNP'],
  'Brockville': ['NNP'],
  'Brockway': ['NNP'],
  'Brod': ['NNP'],
  'Brodbeck': ['NNP'],
  'Broder': ['NNP'],
  'Broderick': ['NNP'],
  'Brodie': ['NNP'],
  'Brodsky': ['NNP'],
  'Brodsly': ['NNP'],
  'Brody': ['NNP'],
  'Broe': ['NNP'],
  'Broeg': ['NNP'],
  'Broglie': ['NNP'],
  'Broglio': ['NNP'],
  'Broil': ['VB'],
  'Broiled': ['VBN'],
  'Broiler': ['NN'],
  'Brokaw': ['NNP'],
  'Broke': ['NNP'],
  'Broken': ['NNP'],
  'Broker': ['NNP'],
  'Brokerage': ['NN'],
  'Brokerage-firm': ['JJ'],
  'Brokers': ['NNS'],
  'Bromagen': ['NNP'],
  'Bromfield': ['NNP'],
  'Bromley': ['NNP'],
  'Bromwich': ['NNP'],
  'Bron': ['NNP'],
  'Bronces': ['NNP'],
  'Bronco': ['NNP'],
  'Broncos': ['NNP'],
  'Broncs': ['NNP'],
  'Broner': ['NNP'],
  'Bronfman': ['NNP'],
  'Bronfmans': ['NNP'],
  'Bronislava': ['NNP'],
  'Bronislaw': ['NNP'],
  'Bronner': ['NNP'],
  'Bronson': ['NNP'],
  'Bronston': ['NNP'],
  'Bronx': ['NNP'],
  'Bronzavia-Air': ['NNP'],
  'Brooding': ['NNP'],
  'Brook': ['NNP'],
  'Brooke': ['NNP'],
  'Brookfield': ['NNP'],
  'Brookhaven': ['NNP'],
  'Brookings': ['NNP'],
  'Brookland': ['NNP'],
  'Brookline': ['NNP'],
  'Brooklyn': ['NNP'],
  'Brooklyn-born': ['JJ'],
  'Brookmeyer': ['NNP'],
  'Brookmont': ['NNP'],
  'Brooks': ['NNP'],
  'Broome': ['NNP'],
  'Broomfield': ['NNP'],
  'Brophy': ['NNP'],
  'Bros': ['NNP'],
  'Bros.': ['NNP'],
  'Brosterman': ['NNP'],
  'Brother': ['NNP'],
  'Brotherhood': ['NNP'],
  'Brothers': ['NNPS'],
  'Brougham': ['NNP'],
  'Brought': ['VBN'],
  'Broughten': ['NNP'],
  'Broughton': ['NNP'],
  'Broun': ['NNP'],
  'Brouwer': ['NNP'],
  'Broward': ['NNP'],
  'Browder': ['NNP'],
  'Brown': ['NNP'],
  'Brown-Forman': ['NNP'],
  'Brown-tobacco': ['JJ'],
  'Brownapopolus': ['NNP'],
  'Browne': ['NNP'],
  'Brownell': ['NNP'],
  'Browning': ['NNP'],
  'Brownings': ['NNP'],
  'Brownlow': ['NNP'],
  'Browns': ['NNP'],
  'Brownstein': ['NNP'],
  'Broxodent': ['NNP'],
  'Broyd': ['NNP'],
  'Brozman': ['NNP'],
  'Brubaker': ['NNP'],
  'Bruccoli': ['NNP'],
  'Bruce': ['NNP'],
  'Bruch': ['NNP'],
  'Bruck': ['NNP'],
  'Bruckheimer': ['NNP'],
  'Bruckmann': ['NNP'],
  'Bruckner': ['NNP'],
  'Brudzinski': ['NNP'],
  'Bruegel': ['NNP'],
  'Bruges': ['NNP'],
  'Bruhn': ['NNP'],
  'Bruises': ['NNS'],
  'Brumbaugh': ['NNP'],
  'Brumby': ['NNP'],
  'Brumidi': ['NNP'],
  'Brumidi-Costaggini': ['NNP'],
  'Brumley': ['NNP'],
  'Brundtland': ['NNP'],
  'Brunei': ['NNP'],
  'Brunello': ['NNP'],
  'Bruner': ['NNP'],
  'Brunk': ['NNP'],
  'Brunner': ['NNP'],
  'Bruno': ['NNP'],
  'Bruns': ['NNP'],
  'Brunsdon': ['NNP'],
  'Brunswick': ['NNP'],
  'Brunswig': ['NNP'],
  'Brusca': ['NNP'],
  'Bruser': ['NNP'],
  'Brush': ['NNP'],
  'Brush-off': ['NN'],
  'Brussels': ['NNP'],
  'Brut': ['NNP'],
  'Bruwer': ['NNP'],
  'Bruxelles': ['NNP'],
  'Bruyette': ['NNP'],
  'Bryan': ['NNP'],
  'Bryant': ['NNP'],
  'Bryce': ['NNP'],
  'Bryn': ['NNP'],
  'Bryner': ['NNP'],
  'Bryson': ['NNP'],
  'Buaford': ['NNP'],
  'Bubba': ['NNP'],
  'Bubenik': ['NNP'],
  'Buber': ['NNP'],
  'Buber-think': ['NNP', 'VB'],
  'Bucaramanga': ['NNP'],
  'Bucay': ['NNP'],
  'Buccaneers': ['NNS'],
  'Bucchino': ['NNP'],
  'Bucer': ['NNP'],
  'Buchanan': ['NNP'],
  'Bucharest': ['NNP'],
  'Buchbinder': ['NNP'],
  'Buchenwald': ['NNP'],
  'Buchheister': ['NNP'],
  'Buchner': ['NNP'],
  'Buchwald': ['NNP'],
  'Buck': ['NNP'],
  'Buckenham': ['NNP'],
  'Buckeridge': ['NNP'],
  'Buckets': ['NNS'],
  'Buckeye': ['NNP'],
  'Buckhannon': ['NN'],
  'Buckhead': ['NNP'],
  'Buckhorn': ['NN'],
  'Bucking': ['VBG'],
  'Buckingham': ['NNP'],
  'Buckles': ['NNP'],
  'Buckley': ['NNP'],
  'Buckman': ['NNP'],
  'Bucknell': ['NNP'],
  'Buckra': ['NNP'],
  'Bucks': ['NNP'],
  'Bucky': ['NNP'],
  'Bucs': ['NNP'],
  'Bud': ['NNP'],
  'Budapest': ['NNP'],
  'Budd': ['NNP'],
  'Buddha': ['NNP'],
  'Buddhism': ['NNP'],
  'Buddhist': ['JJ'],
  'Buddhists': ['NNP'],
  'Buddy': ['NNP'],
  'Budget': ['NNP'],
  'Budgetary': ['NNP'],
  'Budgeting': ['NN'],
  'Budieshein': ['NNP'],
  'Budlong': ['NNP'],
  'Buds': ['NNPS'],
  'Budweiser': ['NNP'],
  'Budweisers': ['NNS'],
  'Budzyn': ['NNP'],
  'Buechel': ['NNP'],
  'Bueky': ['NNP'],
  'Buell': ['NNP'],
  'Buena': ['NNP'],
  'Buenas': ['NNP'],
  'Bueno': ['FW'],
  'Buenos': ['NNP'],
  'Buente': ['NNP'],
  'Buffalo': ['NNP'],
  'Buffet': ['NNP'],
  'Buffeted': ['VBN'],
  'Buffets': ['NNS'],
  'Buffett': ['NNP'],
  'Buffetts': ['NNPS'],
  'Buffton': ['NNP'],
  'Bufton': ['NNP'],
  'Bug': ['NN'],
  'Bugatti': ['NNP'],
  'Bugle': ['NNP'],
  'Bugs': ['NNP'],
  'Buhrmann-Tetterode': ['NNP'],
  'Buick': ['NNP'],
  'Buick-Oldsmobile-Cadillac': ['NNP'],
  'Build': ['VB'],
  'Builder': ['NNP'],
  'Builders': ['NNPS'],
  'Building': ['NNP'],
  'Buildings': ['NNS'],
  'Builds': ['VBZ'],
  'Built': ['VBN'],
  'Buker': ['NNP'],
  'Buksbaum': ['NNP'],
  'Bul\'ba': ['NNP'],
  'Bulba': ['NNP'],
  'Bulgaria': ['NNP'],
  'Bulgarian': ['JJ'],
  'Bulgarians': ['NNPS'],
  'Bulge': ['NNP'],
  'Bull': ['NNP'],
  'Bullet': ['NNP'],
  'Bulletin': ['NNP'],
  'Bullets': ['NNS'],
  'Bullfinch': ['NN'],
  'Bullion': ['NNP'],
  'Bullish': ['JJ'],
  'Bulloch': ['NNP'],
  'Bullock': ['NNP'],
  'Bullocks': ['NNP'],
  'Bulls': ['NNS'],
  'Bullshit': ['UH'],
  'Bully': ['VB'],
  'Bulow': ['NNP'],
  'Bulseco': ['NNP'],
  'Bultmann': ['NNP'],
  'Bum': ['NNP'],
  'Bumblebees': ['NNS'],
  'Bumbry': ['NNP'],
  'Bumiputra': ['NNP'],
  'Bumkins': ['NNP'],
  'Bumpers': ['NNP'],
  'Bums': ['NNS'],
  'Bun': ['NN'],
  'Bunch': ['NN'],
  'Bund': ['NN'],
  'Bundesbank': ['NNP'],
  'Bundesbank-meeting': ['NN'],
  'Bundesnachrichtendienst': ['NNP'],
  'Bundestag': ['NNP'],
  'Bundle': ['NN'],
  'Bundy': ['NNP'],
  'Bunker': ['NNP'],
  'Bunks': ['NNS'],
  'Bunny': ['NNP'],
  'Bunting': ['NNP'],
  'Bunyan': ['NNP'],
  'Buoy': ['NNP'],
  'Buoyed': ['VBN'],
  'Burbank': ['NNP'],
  'Burch': ['NNP'],
  'Burchette': ['NNP'],
  'Burchuladze': ['NNP'],
  'Burckhardt': ['NNP'],
  'Burden': ['NNP'],
  'Burdened': ['VBN'],
  'Burdens': ['NNS'],
  'Burdett': ['NNP'],
  'Burdines': ['NNPS'],
  'Bureau': ['NNP'],
  'Bureaucrat': ['NN'],
  'Bureaucratic': ['JJ'],
  'Bureaucrats': ['NNS'],
  'Bureaus': ['NNP'],
  'Buren': ['NNP'],
  'Burford': ['NNP'],
  'Burge': ['NNP'],
  'Burgee': ['NNP'],
  'Burgeoning': ['VBG'],
  'Burger': ['NNP'],
  'Burgess': ['NNP'],
  'Burgesses': ['NNS'],
  'Burghardt': ['NNP'],
  'Burgher': ['NNP'],
  'Burghley': ['NNP'],
  'Burgsteinfurt': ['NNP'],
  'Burgundian': ['JJ'],
  'Burgundies': ['NNPS'],
  'Burgundy': ['NNP'],
  'Buri': ['NNP'],
  'Burial': ['NN'],
  'Buried': ['VBN'],
  'Buries': ['VBZ'],
  'Burk': ['NNP'],
  'Burke': ['NNP'],
  'Burke-Rostagno': ['NNP'],
  'Burkes': ['NNPS'],
  'Burkette': ['NNP'],
  'Burkhardt': ['NNP'],
  'Burkina': ['NNP'],
  'Burl': ['NNP'],
  'Burle': ['NNP'],
  'Burleson': ['NNP'],
  'Burling': ['NNP'],
  'Burlingame': ['NNP'],
  'Burlingham': ['NNP'],
  'Burlington': ['NNP'],
  'Burly': ['JJ'],
  'Burma': ['NNP'],
  'Burma-Shave': ['NNP'],
  'Burmah': ['NNP'],
  'Burman': ['NNP'],
  'Burmans': ['NNPS'],
  'Burmese': ['JJ'],
  'Burnand': ['NNP'],
  'Burned': ['VBN'],
  'Burnes': ['NNP'],
  'Burnet': ['NNP'],
  'Burnett': ['NNP'],
  'Burnham': ['NNP'],
  'Burning': ['VBG'],
  'Burnison': ['NNP'],
  'Burnley': ['NNP'],
  'Burns': ['NNP'],
  'Burnside': ['NNP'],
  'Burnsides': ['NNPS'],
  'Burnsville': ['NNP'],
  'Burnt': ['NNP'],
  'Burr': ['NNP'],
  'Burrill': ['NNP'],
  'Burrillville': ['NNP'],
  'Burritt': ['NNP'],
  'Burro': ['NNP'],
  'Burroughs': ['NNP'],
  'Burroughs-Wellcome': ['NNP'],
  'Burry': ['NNP'],
  'Burst': ['VBD'],
  'Bursting': ['VBG'],
  'Bursts': ['VBZ'],
  'Burt': ['NNP'],
  'Burton': ['NNP'],
  'Burts': ['NNPS'],
  'Burwell': ['NNP'],
  'Bury': ['NNP'],
  'Burzon': ['NNP'],
  'Bus': ['NN'],
  'Busby': ['NNP'],
  'Busch': ['NNP'],
  'Buser': ['NNP'],
  'Busey': ['NNP'],
  'Bush': ['NNP'],
  'Bush-Gorbachev': ['NNP'],
  'Bush-Salinas': ['NNP'],
  'Bush-supported': ['JJ'],
  'Bushby': ['NNP'],
  'Bushell': ['NNP'],
  'Bushels': ['NNS'],
  'Bushes': ['NNPS'],
  'Bushnell': ['NNP'],
  'Business': ['NNP'],
  'Businesses': ['NNS'],
  'Businessland': ['NNP'],
  'Businessmen': ['NNS'],
  'Buskirk': ['NNP'],
  'Bussey': ['NNP'],
  'Bussieres': ['NNP'],
  'Bust': ['NNP'],
  'Bustard': ['NN'],
  'Buster': ['NNP'],
  'But': ['CC'],
  'Butane': ['NN'],
  'Butch': ['NNP'],
  'Butcher': ['NNP'],
  'Butler': ['NNP'],
  'Butlers': ['NNPS'],
  'Butowsky': ['NNP'],
  'Butt': ['NNP'],
  'Buttacavoli': ['NNP'],
  'Buttavacoli': ['NNP'],
  'Butte': ['NNP'],
  'Butter': ['NN'],
  'Butter-Nut': ['NNP'],
  'Butterfield': ['NNP'],
  'Butterfinger': ['NNP'],
  'Butterworth': ['NNP'],
  'Butterwyn': ['NNP'],
  'Button': ['NNP'],
  'Buttrick': ['NNP'],
  'Butts': ['NNP'],
  'Butz': ['NNP'],
  'Buxtehude': ['NNP'],
  'Buxton': ['NNP'],
  'Buy': ['VB'],
  'Buy\'em': ['VB'],
  'Buy-Back': ['NNP'],
  'Buy-out': ['NN'],
  'Buyer': ['NNP'],
  'Buyers': ['NNS'],
  'Buying': ['VBG'],
  'Buzz': ['NNP'],
  'Buzzell': ['NNP'],
  'Buzzy': ['NNP'],
  'By': ['IN'],
  'By-Products': ['NNP'],
  'By-passing': ['VBG'],
  'By-the-Book': ['JJ'],
  'By-the-Sea': ['NNP'],
  'By-word': ['JJ'],
  'Bye': ['UH'],
  'Byelorussia': ['NNP'],
  'Byer-Rolnick': ['NNP'],
  'Byers': ['NNP'],
  'Bygdeman': ['NNP'],
  'Byler': ['NNP'],
  'Bylot': ['NNP'],
  'Bynoe': ['NNP'],
  'Byrd': ['NNP'],
  'Byrne': ['NNP'],
  'Byrnes': ['NNP'],
  'Byron': ['NNP'],
  'Byronic': ['JJ'],
  'Byronism': ['NN'],
  'Byrum': ['NNP'],
  'Bystrzyca': ['NNP'],
  'Byting': ['VBG'],
  'Byzantine': ['JJ'],
  'Byzantium': ['NNP'],
  'Byzas': ['NNP'],
  'C': ['NN'],
  'C\$': ['\$'],
  'C&D': ['NNP'],
  'C&P': ['NNP'],
  'C&W': ['NNP'],
  'C\'est': ['FW'],
  'C\'mon': ['VB'],
  'C\'un': ['NNP'],
  'C-12': ['NN'],
  'C-12F': ['NN'],
  'C-130': ['NN'],
  'C-141': ['NNP'],
  'C-17': ['NNP'],
  'C-20': ['NNP'],
  'C-5B': ['NN'],
  'C-90': ['NN'],
  'C-S': ['NNP'],
  'C-SPAN': ['NNP'],
  'C-Span': ['NNP'],
  'C-V': ['NNP'],
  'C-minus': ['JJ'],
  'C-plane': ['NN'],
  'C-word': ['NN'],
  'C.': ['NNP'],
  'C.A.I.P.': ['NNP'],
  'C.B.': ['NNP'],
  'C.C.': ['NNP'],
  'C.C.B': ['NNP'],
  'C.C.B.': ['NNP'],
  'C.C.N.Y.': ['NNP'],
  'C.D.': ['NNP'],
  'C.D.s': ['NNS'],
  'C.E.': ['NNP'],
  'C.H.': ['NNP'],
  'C.J.': ['NNP'],
  'C.J.B.': ['NNP'],
  'C.K.': ['NNP'],
  'C.M.': ['NNP'],
  'C.O.G.': ['NNP'],
  'C.P.': ['NNP'],
  'C.R.': ['NNP'],
  'C.S.': ['NNP'],
  'C.W.': ['NNP'],
  'C/NNP.A.J.': ['NNP'],
  'C1': ['NNP'],
  'C13532': ['NNP'],
  'C415': ['CD'],
  'CAAC': ['NNP'],
  'CABBAGE': ['NN'],
  'CABLE': ['NN'],
  'CAC': ['NNP'],
  'CACI': ['NNP'],
  'CAE': ['NNP'],
  'CAE-Link': ['NNP'],
  'CAHNERS': ['NNP'],
  'CALFED': ['NNP'],
  'CALIFORNIA': ['NNP'],
  'CALL': ['NN'],
  'CALLED': ['VBD'],
  'CALLIOPE': ['NNP'],
  'CALLS': ['NNPS'],
  'CAMBREX': ['NNP'],
  'CAMPAIGN': ['NNP'],
  'CAMPEAU': ['NNP'],
  'CAN': ['VB'],
  'CANADA': ['NNP'],
  'CANADIAN': ['JJ'],
  'CANCER': ['NNP'],
  'CANDIDATES': ['NNS'],
  'CAPITAL': ['NNP'],
  'CAPITAL-GAINS': ['NNP'],
  'CAPITALIST': ['JJ'],
  'CAR': ['NN'],
  'CARE': ['NNP'],
  'CAREER': ['NNP'],
  'CARIPLO': ['NNP'],
  'CAROLG': ['NNP'],
  'CARTER': ['NNP'],
  'CARTER-WALLACE': ['NNP'],
  'CASE': ['NNP'],
  'CASES': ['NNS'],
  'CASSETTE': ['NN'],
  'CASTLE': ['NNP'],
  'CAT': ['NNP'],
  'CATFISH': ['NNS'],
  'CATV': ['NN'],
  'CB': ['NNP'],
  'CB-radio-style': ['JJ'],
  'CBC': ['NNP'],
  'CBI': ['NNP'],
  'CBO': ['NNP'],
  'CBOE': ['NNP'],
  'CBOT': ['NNP'],
  'CBS': ['NNP'],
  'CBS-K': ['NNP'],
  'CBS-TV': ['NNP'],
  'CBS-Turner': ['NNP'],
  'CBS-owned': ['JJ'],
  'CBS\\\'': ['NNP'],
  'CCC': ['NNP'],
  'CCD': ['NNP'],
  'CCK': ['NNP'],
  'CCK-related': ['JJ'],
  'CCT': ['NNP'],
  'CD': ['NNP'],
  'CD+DVD': ['NN'],
  'CD-4': ['NNP'],
  'CD-I': ['NNP'],
  'CD-ROM': ['NNP'],
  'CD-type': ['JJ'],
  'CDA': ['NNP'],
  'CDBG': ['NNP'],
  'CDC': ['NNP'],
  'CDK': ['NNP'],
  'CDL': ['NNP'],
  'CDT': ['NNP'],
  'CDU': ['NNP'],
  'CDs': ['NNS'],
  'CELEBRATIONS': ['NNP'],
  'CELTICS': ['NNPS'],
  'CENTERIOR': ['NNP'],
  'CENTRUST': ['NNP'],
  'CEO': ['NNP'],
  'CEO-designate': ['NN'],
  'CEOs': ['NNS'],
  'CERA': ['NNP'],
  'CEREAL': ['NNP'],
  'CERTIFICATES': ['NNS'],
  'CF': ['NNP'],
  'CF6-6': ['NNP'],
  'CF66': ['NN'],
  'CF680C2': ['NNP'],
  'CFC': ['NNP'],
  'CFC-11': ['NN'],
  'CFC-12': ['NN'],
  'CFCs': ['NNS'],
  'CFD': ['NNP'],
  'CFM': ['NNP'],
  'CFM56': ['NN'],
  'CFM56-3C': ['NN'],
  'CFM56-56s': ['NNS'],
  'CFP': ['NNP'],
  'CFTC': ['NNP'],
  'CG': ['NNP'],
  'CGE': ['NNP'],
  'CGP': ['NNP'],
  'CH': ['NN'],
  'CH-47D': ['NNP'],
  'CHALLENGED': ['VBN'],
  'CHAMBERS': ['NNP'],
  'CHANGED': ['VBD'],
  'CHANGES': ['NNS'],
  'CHARIOT': ['NNP'],
  'CHARITABLE': ['JJ'],
  'CHARLES': ['NNP'],
  'CHASE': ['NNP'],
  'CHECKOFF': ['NN'],
  'CHECKUPS': ['NNS'],
  'CHEMICAL': ['NNP'],
  'CHEVRON': ['NNP'],
  'CHEWING': ['VBG'],
  'CHICAGO': ['NNP'],
  'CHIEF': ['JJ'],
  'CHILDREN': ['NNS'],
  'CHIMPS': ['NNS'],
  'CHINA': ['NNP'],
  'CHIPPING': ['VBG'],
  'CHRISTMAS': ['NNP'],
  'CHW': ['NNP'],
  'CI': ['NNP'],
  'CIA': ['NNP'],
  'CICS': ['NNP'],
  'CIM': ['NNP'],
  'CIR': ['NNP'],
  'CIRCUIT': ['NNP'],
  'CIT': ['NNP'],
  'CITIC': ['NNP'],
  'CITIES\\\'/ABC': ['NNP'],
  'CITIZEN': ['NNP'],
  'CITIZENS': ['NNS'],
  'CITY': ['NNP'],
  'CITY\'S': ['NNP'],
  'CJS': ['NNP'],
  'CL': ['NNP'],
  'CLAIMANTS': ['NNS'],
  'CLAIMS': ['VBZ'],
  'CLARK': ['NNP'],
  'CLASHED': ['VBD'],
  'CLAUSE': ['NN'],
  'CLAUSTROPHOBIC': ['JJ'],
  'CLEARED': ['VBD'],
  'CLEARS': ['VBZ'],
  'CLK': ['NNP'],
  'CLOROX': ['NNP'],
  'CLOSE': ['NN'],
  'CLUBBING': ['VBG'],
  'CLUBS': ['NNS'],
  'CMA': ['NNP'],
  'CME': ['NNP'],
  'CMI': ['NNP'],
  'CMK': ['NNP'],
  'CML': ['NNP'],
  'CMOS': ['NNP'],
  'CMS': ['NNP'],
  'CMZ': ['NNP'],
  'CNA': ['NNP'],
  'CNBC': ['NNP'],
  'CNCA': ['NNP'],
  'CNN': ['NNP'],
  'CNW': ['NNP'],
  'CO': ['NNP'],
  'CO.': ['NNP'],
  'COAHR': ['NNP'],
  'COAST': ['NNP'],
  'COASTAL': ['NNP'],
  'COB': ['NNP'],
  'COCA-COLA': ['NNP'],
  'COCAINE': ['NNP'],
  'COCOA': ['NN'],
  'CODE,DTF': ['NN'],
  'CODE-NAMED': ['VBN'],
  'COFFEE': ['NN'],
  'COHERENT': ['NNP'],
  'COKE': ['NNP'],
  'COLGATE-PALMOLIVE': ['NNP'],
  'COLH': ['NNP'],
  'COLLAPSE': ['NN'],
  'COLLATERAL': ['NN'],
  'COLLECTING': ['NN'],
  'COLOGNE': ['NNP'],
  'COM': ['NNP'],
  'COME': ['VBN'],
  'COMMENTS': ['NNS'],
  'COMMERCIAL': ['JJ'],
  'COMMITTEE': ['NNP'],
  'COMMUNICATIONS': ['NNPS'],
  'COMMUNISTS': ['NNS'],
  'COMMUTERS': ['NNS'],
  'COMPANIES': ['NNS'],
  'COMPANY': ['NN'],
  'COMPARE': ['VB'],
  'COMPLETED': ['VBD'],
  'COMPUTER': ['NN'],
  'COMPUTERS': ['NNS'],
  'CONCORDE': ['NNP'],
  'CONELRAD': ['NNP'],
  'CONFIRMED': ['VBD'],
  'CONFRONTATIONS': ['NNS'],
  'CONGRESS': ['NNP'],
  'CONGRESSIONAL': ['JJ'],
  'CONSERVATIVES': ['NNS'],
  'CONSOLIDATED': ['NNP'],
  'CONSULTING': ['NNP'],
  'CONSUMER': ['NN'],
  'CONSUMERS': ['NNS'],
  'CONTACT': ['NN'],
  'CONTAIN': ['VB'],
  'CONTAMINATION': ['NN'],
  'CONTINENTAL': ['NNP'],
  'CONTROL': ['NNP'],
  'CONVICTION': ['NN'],
  'CONVICTS': ['VBZ'],
  'COOKE': ['NNP'],
  'COOPER': ['NNP'],
  'COOPERATION': ['NN'],
  'COPE': ['VB'],
  'COPPER': ['NN'],
  'CORNFELD': ['NNP'],
  'CORNUCOPIA': ['NN'],
  'CORP': ['NNP'],
  'CORP.': ['NNP'],
  'CORPORATE': ['JJ'],
  'CORTES': ['NNP'],
  'COS.': ['NNP'],
  'COTTON': ['NN'],
  'COULDN\'T': ['NNP'],
  'COUNSEL': ['NN'],
  'COUNTRY': ['NN'],
  'COUP': ['NN'],
  'COURT': ['NNP'],
  'COURTS': ['NNS'],
  'COVER': ['NN'],
  'COVERAGE': ['NNP'],
  'CP': ['NNP'],
  'CP486': ['NNP'],
  'CPA': ['NNP'],
  'CPAs': ['NNS'],
  'CPB': ['NNP'],
  'CPC': ['NNP'],
  'CPI': ['NNP'],
  'CPR': ['NNP'],
  'CPT': ['NN'],
  'CPTs': ['NNS'],
  'CR103': ['NNP'],
  'CRA': ['NNP'],
  'CRAF-Cassini': ['NNP'],
  'CRASHED': ['VBD'],
  'CRAY': ['NNP'],
  'CREAM': ['NNP'],
  'CREATIVE': ['JJ'],
  'CREATOR\'S': ['NN'],
  'CREDIT': ['NNP'],
  'CREDITS': ['NNS'],
  'CRESTMONT': ['NNP'],
  'CRI': ['NNP'],
  'CRIME': ['NN'],
  'CRIMINAL': ['JJ'],
  'CRITICAL': ['NNP'],
  'CROSS-BRED': ['VBD'],
  'CROWDED': ['JJ'],
  'CRRES': ['NNP'],
  'CRS': ['NNP'],
  'CRSS': ['NNP'],
  'CRT': ['NNP'],
  'CRX': ['NNP'],
  'CRs': ['NNS'],
  'CS': ['NNP'],
  'CSC': ['NNP'],
  'CSF': ['NNP'],
  'CSFB': ['NNP'],
  'CSI': ['NNP'],
  'CSK': ['NNP'],
  'CSO': ['NNP'],
  'CSR': ['NNP'],
  'CSS': ['NNP'],
  'CST': ['NNP'],
  'CSV': ['NNP'],
  'CSX': ['NNP'],
  'CT': ['NN'],
  'CTA': ['NNP'],
  'CTAs': ['NNS'],
  'CTB': ['NNP'],
  'CTBS': ['NNP'],
  'CTCA': ['NNP'],
  'CTS': ['NNP'],
  'CULPA': ['NNP'],
  'CUNA': ['NNP'],
  'CURBING': ['VBG'],
  'CUTTY': ['NNP'],
  'CV': ['NNP'],
  'CVB': ['NNP'],
  'CVN': ['NNP'],
  'CW': ['NNP'],
  'CW-capable': ['JJ'],
  'CWA': ['NNP'],
  'CWP': ['NNP'],
  'Ca': ['MD'],
  'Ca.': ['NNP'],
  'Caa': ['NNP'],
  'Cab': ['NNP'],
  'Cabana': ['NNP'],
  'Cabanne': ['NNP'],
  'Cabbage': ['NNP'],
  'Cabernet': ['NNP'],
  'Cabernets': ['NNPS'],
  'Cabin': ['NNP'],
  'Cabinet': ['NNP'],
  'Cable': ['NNP'],
  'Cable-system': ['NN'],
  'Cabletron': ['NNP'],
  'Cablevision': ['NNP'],
  'Cabot': ['NNP'],
  'Cabrera': ['NNP'],
  'Cabria': ['NNP'],
  'Cabrini': ['NNP'],
  'Cacao': ['NNP'],
  'Caccappolo': ['NNP'],
  'Cacophonist': ['NNP'],
  'Cadam': ['NNP'],
  'Cadbury': ['NNP'],
  'Cadbury-Schweppes': ['NNP'],
  'Caddy': ['NNP'],
  'Caddyshack': ['NNP'],
  'Cadesi': ['NNP'],
  'Cadet': ['NNP'],
  'Cadillac': ['NNP'],
  'Cadillacs': ['NNPS'],
  'Cadiz': ['NNP'],
  'Cadnetix': ['NNP'],
  'Cadre': ['NNP'],
  'Cadwalader': ['NNP'],
  'Cadwell': ['NNP'],
  'Cady': ['NNP'],
  'Caere': ['NNP'],
  'Caesar': ['NNP'],
  'Caesarean': ['JJ'],
  'Caesars': ['NNP'],
  'Caetani': ['NNP'],
  'Cafe': ['NNP'],
  'Cafeteria': ['NNP'],
  'Caffedrine': ['NNP'],
  'Cafferarelli': ['NNP'],
  'Caffrey': ['NNP'],
  'Cafritz': ['NNP'],
  'Cagayan': ['NNP'],
  'Cage': ['NNP'],
  'Cagliari': ['NNP'],
  'Cahill': ['NNP'],
  'Cahn': ['NNP'],
  'Cahners': ['NNP'],
  'Cahoon': ['NNP'],
  'Cain': ['NNP'],
  'Cairenes': ['NNPS'],
  'Cairns': ['NNP'],
  'Cairo': ['NNP'],
  'Cairo-sponsored': ['JJ'],
  'Cairoli': ['NNP'],
  'Caisse': ['NNP'],
  'Caitlin': ['NNP'],
  'Caius': ['NNP'],
  'Caja': ['NNP'],
  'Cal': ['NNP'],
  'Cal-Neva': ['NNP'],
  'Cal.': ['NN'],
  'CalComp': ['NNP'],
  'CalFed': ['NNP'],
  'CalMat': ['NNP'],
  'CalTech': ['NNP'],
  'Calabasas': ['NNP'],
  'Calabrese': ['NNP'],
  'Calabria': ['NNP'],
  'Calais': ['NNP'],
  'Calamity': ['NNP'],
  'Calaveras': ['NNS'],
  'Calcium': ['NN'],
  'Calculated': ['VBN'],
  'Calculating': ['VBG'],
  'Calculations': ['NNS'],
  'Calcutta': ['NNP'],
  'Calder': ['NNP'],
  'Caldera': ['NNP'],
  'Calderon': ['NNP'],
  'Calderone': ['NNP'],
  'Calderwood': ['NNP'],
  'Caldor': ['NNP'],
  'Caldwell': ['NNP'],
  'Cale': ['NNP'],
  'Caleb': ['NNP'],
  'Calenda': ['NNP'],
  'Calf': ['NNP'],
  'Calgary': ['NNP'],
  'Calgary-based': ['JJ'],
  'Calgene': ['NNP'],
  'Calgon': ['NNP'],
  'Calhoun': ['NNP'],
  'Cali': ['NNP'],
  'Calif': ['NNP'],
  'Calif.': ['NNP'],
  'Calif.-based': ['JJ'],
  'Califano': ['NNP'],
  'Califon': ['NNP'],
  'California': ['NNP'],
  'California-backed': ['JJ'],
  'California-based': ['JJ'],
  'California-bashing': ['JJ'],
  'Californian': ['NN'],
  'Californians': ['NNS'],
  'Californication': ['NN'],
  'Caligula': ['NNP'],
  'Calimala': ['NNP'],
  'Caliphobia': ['NNP'],
  'Calisto': ['NNP'],
  'Call': ['VB'],
  'Call-In': ['NN'],
  'Callable': ['JJ'],
  'Callahan': ['NNP'],
  'Callan': ['NNP'],
  'Callas': ['NNP'],
  'Callaway': ['NNP'],
  'Called': ['VBN'],
  'Callender': ['NNP'],
  'Callers': ['NNS'],
  'Calling': ['VBG'],
  'Calloused': ['JJ'],
  'Calloway': ['NNP'],
  'Calls': ['NNS'],
  'Callum': ['NNP'],
  'Calm': ['JJ'],
  'Calmat': ['NNP'],
  'Calmer': ['JJR'],
  'Calmly': ['RB'],
  'Calor': ['NNP'],
  'Calpers': ['NNP'],
  'Caltech': ['NNP'],
  'Caltrans': ['NNP'],
  'Calude': ['NNP'],
  'Calvary': ['NNP'],
  'Calverley': ['NNP'],
  'Calvert': ['NNP'],
  'Calves': ['NNS'],
  'Calvet': ['NNP'],
  'Calvi': ['NNP'],
  'Calvin': ['NNP'],
  'Calvinist': ['NNP'],
  'Cam': ['NNP'],
  'Camaret': ['NNP'],
  'Camarillo': ['NNP'],
  'Camaro': ['NNP'],
  'Camaro-Firebird': ['NNP'],
  'Camaros': ['NNS'],
  'Cambodia': ['NNP'],
  'Cambodian': ['JJ'],
  'Cambodians': ['NNPS'],
  'Cambrex': ['NNP'],
  'Cambria': ['NNP'],
  'Cambrian': ['NNP'],
  'Cambridge': ['NNP'],
  'Cambridgeport': ['NNP'],
  'Camden': ['NNP'],
  'Camdessus': ['NNP'],
  'Came': ['VBD'],
  'Camel': ['NNP'],
  'Camelot': ['NNP'],
  'Camels': ['NNS'],
  'Cameo': ['NNP'],
  'Camera': ['NNP'],
  'Cameras': ['NNS'],
  'Camerino': ['NNP'],
  'Cameron': ['NNP'],
  'Cami': ['NNP'],
  'Camilla': ['NNP'],
  'Camille': ['NNP'],
  'Camilli': ['NNP'],
  'Camillo': ['NNP'],
  'Camilo': ['NNP'],
  'Camino': ['NNP'],
  'Cammack': ['NNP'],
  'Camp': ['NNP'],
  'Campagnoli': ['NNP'],
  'Campaign': ['NNP'],
  'Campaigne': ['NNP'],
  'Campaigning': ['VBG'],
  'Campaneris': ['NNP'],
  'Campania': ['NNP'],
  'Campbell': ['NNP'],
  'Campbell-Mithun': ['NNP'],
  'Campbell-Mithun-Esty': ['NNP'],
  'Campbell-brand': ['JJ'],
  'Campbelll': ['NNP'],
  'Campeau': ['NNP'],
  'Campeau-owned': ['JJ'],
  'Campeau-related': ['JJ'],
  'Campeau-unit': ['JJ'],
  'Campenhout': ['NNP'],
  'Campestre': ['NNP'],
  'Campground': ['NNP'],
  'Camping': ['NN'],
  'Campion': ['NNP'],
  'Campitelli': ['NNP'],
  'Campo': ['NNP'],
  'Campobello': ['NNP'],
  'Campus': ['NNP'],
  'Campuses': ['NNS'],
  'Camry': ['NNP'],
  'Camrys': ['NNPS'],
  'Camusfearna': ['NNP'],
  'Can': ['MD'],
  'Can\'t': ['VB'],
  'Canaan': ['NNP'],
  'Canada': ['NNP'],
  'Canada-Newfoundland': ['NNP'],
  'Canada-North': ['NNP'],
  'Canada-U.S.': ['NNP'],
  'Canadian': ['JJ'],
  'Canadian-U.S.': ['JJ'],
  'Canadian-dollar': ['JJ'],
  'Canadian-fisheries': ['NNS'],
  'Canadian-owned': ['JJ'],
  'CanadianImmigration': ['NNP'],
  'Canadians': ['NNPS'],
  'Canal': ['NNP'],
  'Canam': ['NNP'],
  'Canandaigua': ['NNP'],
  'Cananea': ['NNP'],
  'Canard': ['NNP'],
  'Canary': ['NNP'],
  'Canastels': ['NNP'],
  'Canaveral': ['NNP'],
  'Canberra': ['NNP'],
  'Cancer': ['NNP'],
  'Candace': ['NNP'],
  'Candela': ['NNP'],
  'Candice': ['NNP'],
  'Candid': ['JJ'],
  'Candidate': ['NN'],
  'Candidates': ['NNS'],
  'Candide': ['NNP'],
  'Candle': ['NNP'],
  'Candlelight': ['NNP'],
  'Candlestick': ['NNP'],
  'Candu': ['NNP'],
  'Candy': ['NN'],
  'Cane': ['NNP'],
  'Caneli': ['NNP'],
  'Canellos': ['NNP'],
  'Canelo': ['NNP'],
  'Canepa': ['NNP'],
  'Canestrani': ['NNP'],
  'Canfield': ['NNP'],
  'Canfor': ['NNP'],
  'Caniglia': ['NNP'],
  'Caning': ['NNP'],
  'Canion': ['NNP'],
  'Cannavino': ['NNP'],
  'Canned': ['JJ'],
  'Cannell': ['NNP'],
  'Canner': ['NNP'],
  'Canneries': ['NNP'],
  'Cannes': ['NNP'],
  'Cannibal': ['NNP'],
  'Canning': ['NNP'],
  'Cannistraro': ['NNP'],
  'Cannon': ['NNP'],
  'Canny': ['NNP'],
  'Cano': ['NNP'],
  'Canoe': ['NNP'],
  'Canoga': ['NNP'],
  'Canon': ['NNP'],
  'Canonie': ['NNP'],
  'Canseco': ['NNP'],
  'Canteloube': ['NNP'],
  'Canter': ['NNP'],
  'Canterbury': ['NNP'],
  'Canticle': ['NNP'],
  'Cantobank': ['NNP'],
  'Canton': ['NNP'],
  'Cantonese': ['NNP'],
  'Cantoni': ['NNP'],
  'Cantor': ['NNP'],
  'Cantwell': ['NNP'],
  'Canute': ['NNP'],
  'Canyon': ['NNP'],
  'Cap': ['NNP'],
  'Capable': ['JJ'],
  'Capacitors': ['NNP'],
  'Capacity': ['NN'],
  'Capcom': ['NNP'],
  'Cape': ['NNP'],
  'Capek': ['NNP'],
  'Capel': ['NNP'],
  'Capellan': ['NNP'],
  'Capello': ['NNP'],
  'Caper': ['NNP'],
  'Capet': ['NNP'],
  'Capetown': ['NNP'],
  'Capetronic': ['NNP'],
  'Capistrano': ['NNP'],
  'Capital': ['NNP'],
  'Capitalincludes': ['NNS'],
  'Capitalism': ['NN'],
  'Capitalist': ['NNP'],
  'Capitalists': ['NNPS'],
  'Capitalizing': ['VBG'],
  'Capitan': ['NNP'],
  'Capitol': ['NNP'],
  'Capitol-EMI': ['NNP'],
  'Capitoline': ['NNP'],
  'Caplan': ['NNP'],
  'Capo': ['NNP'],
  'Capone': ['NNP'],
  'Caporale': ['NNP'],
  'Capote': ['NNP'],
  'Capoten': ['NNP'],
  'Capping': ['VBG'],
  'Capps': ['NNP'],
  'Cappy': ['NNP'],
  'Capra': ['NNP'],
  'Capri': ['NNP'],
  'Caprice': ['NNP'],
  'Capricorn': ['NNP'],
  'Capshaw': ['NNP'],
  'Capt.': ['NNP'],
  'Captain': ['NNP'],
  'Captured': ['VBN'],
  'Captures': ['NNP'],
  'Capwell': ['NNP'],
  'Car': ['NNP'],
  'CarCool': ['NNP'],
  'Cara': ['NNP'],
  'Caracas': ['NNP'],
  'Caradon': ['NNP'],
  'Caraiba': ['NNP'],
  'Carat': ['NNP'],
  'Carausius': ['NNP'],
  'Caravaggio': ['NNP'],
  'Caravaggio.': ['NNP'],
  'Caravan': ['NNP'],
  'Caravans': ['NNPS'],
  'Carballo': ['NNP'],
  'Carberry': ['NNP'],
  'Carbide': ['NNP'],
  'Carboloy': ['NNP'],
  'Carbon': ['NNP'],
  'Carbondale': ['NNP'],
  'Carbones': ['NNPS'],
  'Carboni': ['NNP'],
  'Card': ['NNP'],
  'Cardboard': ['NN'],
  'Carden': ['NNP'],
  'Cardenas': ['NNP'],
  'Carder': ['NNP'],
  'Cardiac': ['NNP'],
  'Cardiff': ['NNP'],
  'Cardillo': ['NNP'],
  'Cardin': ['NNP'],
  'Cardinal': ['NNP'],
  'Cardinals': ['NNP'],
  'Cardiovascular': ['NNP'],
  'Cardiovasculatory': ['NNP'],
  'Cardizem': ['NNP'],
  'Cardoso': ['NNP'],
  'Cards': ['NNP'],
  'Care': ['NNP'],
  'Care-Unit': ['NNP'],
  'Career': ['NNP'],
  'Careers': ['NNS'],
  'Careful': ['JJ'],
  'Carefully': ['RB'],
  'Careless': ['NNP'],
  'Carena': ['NNP'],
  'Cares': ['VBZ'],
  'Carew': ['NNP'],
  'Carews': ['NNPS'],
  'Carey': ['NNP'],
  'Cargill': ['NNP'],
  'Cargo': ['NNP'],
  'Cariaga': ['NNP'],
  'Caribbean': ['NNP'],
  'Caribe': ['NNP'],
  'Caring': ['VBG'],
  'Carisbrook': ['NNP'],
  'Carl': ['NNP'],
  'Carla': ['NNP'],
  'Carleton': ['NNP'],
  'Carletonian': ['NNP'],
  'Carli': ['NNP'],
  'Carlile': ['NNP'],
  'Carlin': ['NNP'],
  'Carliner': ['NNP'],
  'Carlisle': ['NNP'],
  'Carlo': ['NNP'],
  'Carlos': ['NNP'],
  'Carlsbad': ['NNP'],
  'Carlson': ['NNP'],
  'Carlsson': ['NNP'],
  'Carlta': ['NNP'],
  'Carlton': ['NNP'],
  'Carltons': ['NNPS'],
  'Carlucci': ['NNP'],
  'Carlyle': ['NNP'],
  'Carlzon': ['NNP'],
  'Carmack': ['NNP'],
  'Carmel': ['NNP'],
  'Carmelite': ['JJ'],
  'Carmelites': ['NNPS'],
  'Carmen': ['NNP'],
  'Carmer': ['NNP'],
  'Carmichael': ['NNP'],
  'Carmine': ['NNP'],
  'Carmody': ['NNP'],
  'Carmon': ['NNP'],
  'Carnarvon': ['NNP'],
  'Carnegey': ['NNP'],
  'Carnegie': ['NNP'],
  'Carnegie-Illinois': ['NNP'],
  'Carnegie-Mellon': ['NNP'],
  'Carneigie': ['NNP'],
  'Carnevale': ['NNP'],
  'Carney': ['NNP'],
  'Carnival': ['NNP'],
  'Carnochan': ['NNP'],
  'Carol': ['NNP'],
  'Carolco': ['NNP'],
  'Carole': ['NNP'],
  'Caroli': ['NNP'],
  'Carolina': ['NNP'],
  'Carolinas': ['NNPS'],
  'Caroline': ['NNP'],
  'Carolingian': ['JJ'],
  'Carolinian': ['NNP'],
  'Carolinians': ['NNPS'],
  'Carols': ['NNPS'],
  'Carolus': ['NNP'],
  'Carolyn': ['NNP'],
  'Carolyne': ['NNP'],
  'Caron': ['NNP'],
  'Caronia': ['NNP'],
  'Carothers': ['NNP'],
  'Carpathians': ['NNPS'],
  'Carpenter': ['NNP'],
  'Carpenters': ['NNPS'],
  'Carpentier': ['NNP'],
  'Carpeting': ['NN'],
  'Carr': ['NNP'],
  'Carr-Lowrey': ['NNP'],
  'Carrara': ['NNP'],
  'Carraway': ['NNP'],
  'Carre': ['NNP'],
  'Carrel': ['NNP'],
  'Carreon': ['NNP'],
  'Carriages': ['NNS'],
  'Carrie': ['NNP'],
  'Carried': ['VBN'],
  'Carrier': ['NNP'],
  'Carriers': ['NNP'],
  'Carrington': ['NNP'],
  'Carrion': ['NNP'],
  'Carroll': ['NNP'],
  'Carrollton': ['NNP'],
  'Carrot': ['NNP'],
  'Carrots': ['NNPS'],
  'Carrozza': ['NN'],
  'Carruthers': ['NNP'],
  'Carry': ['NNP'],
  'Carrying': ['VBG'],
  'Cars': ['NNPS'],
  'Carson': ['NNP'],
  'Carsten': ['NNP'],
  'Carstens': ['NNP'],
  'Cartagena': ['NNP'],
  'Cartel': ['NNP'],
  'Carter': ['NNP'],
  'Carters': ['NNPS'],
  'Cartesian': ['JJ'],
  'Carthage': ['FW'],
  'Carthago': ['FW'],
  'Cartier': ['NNP'],
  'Cartons': ['NNS'],
  'Cartoon': ['NN'],
  'Cartoonist': ['NN'],
  'Cartoonists': ['NNP'],
  'Cartoons': ['NNS'],
  'Cartridge': ['NNP'],
  'Cartusciello': ['NNP'],
  'Cartwright': ['NNP'],
  'Carty': ['NNP'],
  'Caruso': ['NNP'],
  'Carvain': ['NNP'],
  'Carvalho': ['NNP'],
  'Carved': ['JJ'],
  'Carver': ['NNP'],
  'Carvey': ['NNP'],
  'Carving': ['NN'],
  'Carwood': ['NNP'],
  'Cary': ['NNP'],
  'Caryl': ['NNP'],
  'Casa': ['NNP'],
  'Casablanca': ['NNP'],
  'Casals': ['NNP'],
  'Casanova': ['NNP'],
  'Casanovas': ['NNPS'],
  'Casassa': ['NNP'],
  'Casbah': ['NNP'],
  'Casca': ['NN'],
  'Cascade': ['NNP'],
  'Cascaded': ['VBN'],
  'Cascades': ['NNP'],
  'Cascading': ['VBG'],
  'Case': ['NNP'],
  'Cases': ['NNS'],
  'Casey': ['NNP'],
  'Cash': ['NNP'],
  'Cash-heavy': ['JJ'],
  'Cash-pressed': ['JJ'],
  'Cash-strapped': ['JJ'],
  'Cashiering': ['VBG'],
  'Cashin': ['NNP'],
  'Cashion': ['NNP'],
  'Cashman': ['NNP'],
  'Cashways': ['NNPS'],
  'Casino': ['NNP'],
  'Casinos': ['NNS'],
  'Cask': ['NNP'],
  'Caskey': ['NNP'],
  'Cason': ['NNP'],
  'Caspar': ['NNP'],
  'Casper': ['NNP'],
  'Caspi': ['NNP'],
  'Caspita': ['NNP'],
  'Caspita-brand': ['JJ'],
  'Cass': ['NNP'],
  'Cassa': ['NNP'],
  'Cassandras': ['NNPS'],
  'Cassatt': ['NNP'],
  'Cassell': ['NNP'],
  'Cassim': ['NNP'],
  'Cassiopeia': ['NNP'],
  'Cassite': ['NNP'],
  'Cassius': ['NNP'],
  'Casson': ['NNP'],
  'Cast': ['VBN'],
  'Castaneda': ['NNP'],
  'Castel': ['NNP'],
  'Castellanos': ['NNP'],
  'Castile': ['NNP'],
  'Castillo': ['NNP'],
  'Casting': ['VBG'],
  'Castings': ['NNP'],
  'Castle': ['NNP'],
  'Castlegar': ['NNP'],
  'Castleman': ['NNP'],
  'Castles': ['NNS'],
  'Castor': ['JJ'],
  'Castparts': ['NNP'],
  'Castro': ['NNP'],
  'Castro-Medellin': ['NNP'],
  'Castro-held': ['JJ'],
  'Castro-led': ['JJ'],
  'Castroism': ['NNP'],
  'Castrol': ['NNP'],
  'Castros': ['NNPS'],
  'Casualties': ['NNS'],
  'Casualty': ['NNP'],
  'Cat': ['NNP'],
  'Catalina': ['NNP'],
  'Catalog': ['NNP'],
  'Catalonians': ['NNPS'],
  'Catalyst': ['NNP'],
  'Catalysts': ['NNS'],
  'Catania': ['NNP'],
  'Cataracts': ['NNS'],
  'Catastrophe': ['NN'],
  'Catastrophic': ['NNP'],
  'Catastrophic-health': ['NN'],
  'Catatonia': ['NNP'],
  'Catch': ['NN'],
  'Catch-22': ['NN'],
  'Catcher': ['NNP'],
  'Catching': ['VBG'],
  'Cate': ['NNP'],
  'Cater': ['NNP'],
  'Caterpillar': ['NNP'],
  'Caters': ['NNP'],
  'Catfish': ['NNP'],
  'Cathay': ['NNP'],
  'Cathcart': ['NNP'],
  'Cathedral': ['NNP'],
  'Catherall': ['NNP'],
  'Catherine': ['NNP'],
  'Catherwood': ['NNP'],
  'Catheter': ['NNP'],
  'Cathleen': ['NNP'],
  'Cathodic': ['NNP'],
  'Catholic': ['NNP'],
  'Catholic-Jewish': ['JJ'],
  'Catholicism': ['NNP'],
  'Catholics': ['NNPS'],
  'Cathryn': ['NNP'],
  'Cathy': ['NNP'],
  'Catinari': ['NNP'],
  'Cato': ['NNP'],
  'Caton': ['NNP'],
  'Cats': ['NNP'],
  'Catskill': ['NNP'],
  'Catskills': ['NNPS'],
  'Catt': ['NNP'],
  'Cattle': ['NNS'],
  'Cattleguard': ['NNP'],
  'Cattlemen': ['NNPS'],
  'Cattolica': ['NNP'],
  'Cattrall': ['NNP'],
  'Catz': ['NNP'],
  'Caucasian': ['NNP'],
  'Caucasians': ['NNS'],
  'Caucasus': ['NN'],
  'Caucus': ['NNP'],
  'Caucusing': ['VBG'],
  'Cauff': ['NNP'],
  'Cauffman': ['NNP'],
  'Caufield': ['NNP'],
  'Caught': ['VBN'],
  'Caulfield': ['NNP'],
  'Cause': ['NNP'],
  'Caused': ['VBN'],
  'Causes': ['NNP'],
  'Caution': ['NN'],
  'Cautions': ['NNPS'],
  'Cautious': ['JJ'],
  'Cautiously': ['RB'],
  'Cav': ['NNP'],
  'Cavalier': ['NNP'],
  'Cavaliere': ['NNP'],
  'Cavaliers': ['NNS'],
  'Cavalli': ['NNP'],
  'Cavallinis': ['NNS'],
  'Cavallo': ['NNP'],
  'Cavalry': ['NNP'],
  'Cavanagh': ['NNP'],
  'Cavarretta': ['NNP'],
  'Cavazos': ['NNP'],
  'Cave': ['NNP'],
  'Cavenee': ['NNP'],
  'Caverns': ['NNP'],
  'Caves': ['NNP'],
  'Cavett': ['NNP'],
  'Cavin-Morris': ['NNP'],
  'Cavour': ['NNP'],
  'Cawdron': ['NNP'],
  'Cawley': ['NNP'],
  'Cawthorn': ['NNP'],
  'Cay': ['NNP'],
  'Caygill': ['NNP'],
  'Cayman': ['NNP'],
  'Cayne': ['NNP'],
  'Cays': ['NNP'],
  'Ceartaine': ['JJ'],
  'Cecchini': ['NNP'],
  'Cecconi': ['NNP'],
  'Cece': ['NNP'],
  'Cecelia': ['NNP'],
  'Cech': ['NNP'],
  'Cecil': ['NNP'],
  'Cecilia': ['NNP'],
  'Cecin': ['NNP'],
  'Ceco': ['NNP'],
  'Cedar': ['NNP'],
  'Cedars': ['NNPS'],
  'Cedergren': ['NNP'],
  'Cedric': ['NNP'],
  'Cedvet': ['NNP'],
  'Ceecee': ['NNP'],
  'Cefiro': ['NNP'],
  'Ceil': ['NNP'],
  'Ceilings': ['NNS'],
  'Cela': ['NNP'],
  'Celanese': ['NNP'],
  'Celebes': ['NNPS'],
  'Celebrating': ['NNP'],
  'Celebration': ['NNP'],
  'Celebrities': ['NNS'],
  'Celebrity': ['NNP'],
  'Celestial': ['NNP'],
  'Celestino': ['NNP'],
  'Celgar': ['NNP'],
  'Celia': ['NNP'],
  'Celica': ['NNP'],
  'Celie': ['NNP'],
  'Celimene': ['NNP'],
  'Celine': ['NNP'],
  'Cell': ['NNP'],
  'Cell-free': ['JJ'],
  'Cellar': ['NNP'],
  'Cellars': ['NNP'],
  'Cellist': ['NNP'],
  'Cellular': ['NNP'],
  'Cellulose': ['NN'],
  'Celnicker': ['NNP'],
  'Celsius': ['NNP'],
  'Celso': ['NNP'],
  'Celtic': ['JJ'],
  'Celtics': ['NNPS'],
  'Celtona': ['NNP'],
  'Cemal': ['NNP'],
  'Cement': ['NNP'],
  'Cementing': ['VBG'],
  'Cementos': ['NNP'],
  'Cemetery': ['NNP'],
  'Cen-Tennial': ['NNP'],
  'CenTrust': ['NNP'],
  'Cennini': ['NNP'],
  'Cennino': ['NNP'],
  'Censorship': ['NN'],
  'Census': ['NNP'],
  'Centaur': ['NNP'],
  'Centel': ['NNP'],
  'Centennial': ['NNP'],
  'Center': ['NNP'],
  'Center-punch': ['VB'],
  'Centerbank': ['NNP'],
  'Centering': ['VBG'],
  'Centerior': ['NNP'],
  'Centerre': ['NNP'],
  'Centers': ['NNPS'],
  'Centigrade': ['NN'],
  'Centocor': ['NNP'],
  'Centoxin': ['NNP'],
  'Central': ['NNP'],
  'Central-bank': ['NN'],
  'Centrale': ['NNP'],
  'Centralia': ['NNP'],
  'Centrality': ['NN'],
  'Centralizing': ['VBG'],
  'Centrally': ['RB'],
  'Centre': ['NNP'],
  'Centredale': ['NNP'],
  'Centrex': ['NNP'],
  'Centronics': ['NNP'],
  'Centrum': ['NNP'],
  'Cents': ['NNP'],
  'Centurion': ['NNP'],
  'Century': ['NNP'],
  'Century-Fox': ['NNP'],
  'Cepeda': ['NNP'],
  'Cepheus': ['NNP'],
  'Ceramic': ['JJ'],
  'Ceramics': ['NNPS'],
  'Cereal': ['NN'],
  'Cerebral': ['NNP'],
  'Ceremonial': ['NNP'],
  'Cerf': ['NNP'],
  'Cerinvest': ['NNP'],
  'Cerise': ['NNP'],
  'Cernuda': ['NNP'],
  'Certain': ['JJ'],
  'Certainly': ['RB'],
  'Certificate': ['NN'],
  'Certificates': ['NNS'],
  'Certificates-a': ['NNP'],
  'Certification': ['NNP'],
  'Certified': ['NNP'],
  'Certs': ['NNP'],
  'Certus': ['NNP'],
  'Cerus': ['NNP'],
  'Cerv': ['NNP'],
  'Cervantes': ['NNP'],
  'Cervetto': ['NNP'],
  'Cesar': ['NNP'],
  'Cesare': ['NNP'],
  'Cessna': ['NNP'],
  'Cestre': ['NNP'],
  'Cetron': ['NNP'],
  'Cetus': ['NNP'],
  'Ceylon': ['NNP'],
  'Cezanne': ['NNP'],
  'Cezannes': ['NNPS'],
  'Cf.': ['VB'],
  'Ch': ['NNP'],
  'Ch\'an': ['NNP'],
  'Ch\'in': ['NNP'],
  'Ch.': ['NN'],
  'Chablis': ['NNPS'],
  'Chabrier': ['NNP'],
  'Chabrol': ['NNP'],
  'Chace': ['NNP'],
  'Chad': ['NNP'],
  'Chadbourne': ['NNP'],
  'Chadha': ['NNP'],
  'Chadli': ['NNP'],
  'Chadroe': ['NNP'],
  'Chadwick': ['NNP'],
  'Chaffey': ['NNP'],
  'Chafic': ['NNP'],
  'Chafin': ['NNP'],
  'Chagall': ['NNP'],
  'Chahar': ['NNP'],
  'Chai': ['NNP'],
  'Chaikoff': ['NNP'],
  'Chain': ['NN'],
  'Chains': ['NNS'],
  'Chair': ['NNP'],
  'Chairman': ['NNP'],
  'Chairman-Elect': ['NNP'],
  'Chairmen': ['NNS'],
  'Chairperson': ['NNP'],
  'Chairs': ['NNS'],
  'Chajet': ['NNP'],
  'Chalidale': ['NNP'],
  'Challenge': ['NNP'],
  'Challenger': ['NNP'],
  'Challenges': ['NNPS'],
  'Challenging': ['VBG'],
  'Chalmers': ['NNP'],
  'Chalon-sur-Saone': ['NNP'],
  'Chamber': ['NNP'],
  'Chamberlain': ['NNP'],
  'Chambers': ['NNP'],
  'Chambre': ['NNP'],
  'Chamorro': ['NNP'],
  'Champ': ['NNP'],
  'Champagne': ['NNP'],
  'Champagnes': ['NNS'],
  'Champassak': ['NNP'],
  'Champion': ['NNP'],
  'Championship': ['NNP'],
  'Champlain': ['NNP'],
  'Champs': ['NNP'],
  'Chan': ['NNP'],
  'Chance': ['NN'],
  'Chancellor': ['NNP'],
  'Chancellorsville': ['NNP'],
  'Chancery': ['NNP'],
  'Chances': ['NNS'],
  'Chandler': ['NNP'],
  'Chandra': ['NNP'],
  'Chandross': ['NNP'],
  'Chane': ['NNP'],
  'Chanel': ['NNP'],
  'Chang': ['NNP'],
  'Change': ['NNP'],
  'Change-ringing': ['NN'],
  'Changeable': ['JJ'],
  'Changes': ['NNS'],
  'Changing': ['VBG'],
  'Changyi': ['NNP'],
  'Changyong': ['NNP'],
  'Channel': ['NNP'],
  'Channel-type': ['NN'],
  'Channing': ['NNP'],
  'Chanos': ['NNP'],
  'Chans': ['NNS'],
  'Chant': ['NNP'],
  'Chantal': ['NNP'],
  'Chantilly': ['NNP'],
  'Chao': ['NNP'],
  'Chaos': ['NNP'],
  'Chapdelaine': ['NNP'],
  'Chapel': ['NNP'],
  'Chapelles': ['NNPS'],
  'Chapin': ['NNP'],
  'Chaplain': ['NNP'],
  'Chaplin': ['NNP'],
  'Chaplin-like': ['JJ'],
  'Chapman': ['NNP'],
  'Chappaqua': ['NNP'],
  'Chappell': ['NNP'],
  'Chapter': ['NN'],
  'Chapters': ['NNS'],
  'Character': ['NN'],
  'Characteristically': ['RB'],
  'Characteristics': ['NNS'],
  'Characterizing': ['VBG'],
  'Characters': ['NNS'],
  'Charade': ['NNP'],
  'Charcoal': ['NN'],
  'Chardon': ['NNP'],
  'Chardonnay': ['NNP'],
  'Chardonnay-sipping': ['JJ'],
  'Chardonnays': ['NNPS'],
  'Charge': ['NNP'],
  'Chargers': ['NNPS'],
  'Charges': ['NNS'],
  'Chargeurs': ['NNP'],
  'Charging': ['VBG'],
  'Chariots': ['NNS'],
  'Charisma': ['NNP'],
  'Charitable': ['JJ'],
  'Charities': ['NNS'],
  'Charity': ['NN'],
  'Charlayne': ['NNP'],
  'Charlemagne': ['NNP'],
  'Charlene': ['NNP'],
  'Charles': ['NNP'],
  'Charleston': ['NNP'],
  'Charlestonians': ['NNPS'],
  'Charlet': ['NNP'],
  'Charley': ['NNP'],
  'Charlie': ['NNP'],
  'Charlotte': ['NNP'],
  'Charlottesville': ['NNP'],
  'Charls': ['NNP'],
  'Charlton': ['NNP'],
  'Charm': ['NNP'],
  'Charmer': ['NNP'],
  'Charming': ['JJ'],
  'Charnock': ['NNP'],
  'Chart': ['NN'],
  'Charta': ['NNP'],
  'Charter': ['NNP'],
  'Chartered': ['NNP'],
  'Charterhouse': ['NNP'],
  'Charters': ['NNP'],
  'Chartres': ['NNP'],
  'Charts': ['NNS'],
  'Chartwell': ['NNP'],
  'Chase': ['NNP'],
  'Chaseman': ['NNP'],
  'Chases': ['NNPS'],
  'Chastened': ['VBN'],
  'Chateau': ['NNP'],
  'Chateaubriand': ['NNP'],
  'Chateauvallon': ['NNP'],
  'Chatha': ['NNP'],
  'Chatham': ['NNP'],
  'Chatset': ['NNP'],
  'Chatsworth': ['NNP'],
  'Chattanooga': ['NNP'],
  'Chatter-Proofed': ['JJ'],
  'Chatterji': ['NNP'],
  'Chatterton': ['NNP'],
  'Chatwal': ['NNP'],
  'Chaucer': ['NNP'],
  'Chauncey': ['NNP'],
  'Chausson': ['NNP'],
  'Chautauqua': ['NNP'],
  'Chavanne-Ketin': ['NNP'],
  'Chaves': ['NNP'],
  'Chavez': ['NNP'],
  'Chavis': ['NNP'],
  'Chayefsky': ['NNP'],
  'Chayet': ['NNP'],
  'Chazanoff': ['NNP'],
  'Che': ['NNP'],
  'Cheap': ['JJ'],
  'Cheat': ['NNP'],
  'Chebrikov': ['NNP'],
  'Checchi': ['NNP'],
  'Checchi-Skinner': ['NNP'],
  'Checci': ['NNP'],
  'Check': ['VB'],
  'Check-List': ['NNP'],
  'Checked': ['VBN'],
  'Checkit': ['NNP'],
  'Checkrobot': ['NNP'],
  'Checks': ['NNS'],
  'Cheddi': ['NNP'],
  'Cheer': ['NNP'],
  'Cheered': ['VBN'],
  'Cheerful': ['JJ'],
  'Cheerios': ['NNPS'],
  'Cheerios-brand': ['JJ'],
  'Cheers': ['NNP'],
  'Cheese': ['NNP'],
  'Cheeseheads': ['NNS'],
  'Cheeses': ['NNPS'],
  'Cheetham': ['NNP'],
  'Cheez': ['NNP'],
  'Chef': ['NNP'],
  'Chehel': ['NNP'],
  'Cheil': ['NNP'],
  'Chekhov': ['NNP'],
  'Chekhovian': ['JJ'],
  'Chekovian': ['JJ'],
  'Chelmno': ['NNP'],
  'Chelmsford': ['NNP'],
  'Chelsea': ['NNP'],
  'Chem': ['NNP'],
  'Chem-Con': ['NNP'],
  'ChemPlus': ['NNP'],
  'Chemcat': ['NNP'],
  'Chemex': ['NNP'],
  'Chemfix': ['NNP'],
  'Chemical': ['NNP'],
  'Chemicals': ['NNPS'],
  'Chemische': ['NNP'],
  'Chemistry': ['NNP'],
  'Chemists': ['NNS'],
  'Chen': ['NNP'],
  'Chenevix-Trench': ['NNP'],
  'Cheney': ['NNP'],
  'Cheng': ['NNP'],
  'Chengdu': ['NNP'],
  'Chennault': ['NNP'],
  'Chenoweth': ['NNP'],
  'Chequers': ['NNP'],
  'Cher': ['NNP'],
  'Cheri': ['NNP'],
  'Cherkasov': ['NNP'],
  'Chernishev': ['NNP'],
  'Chernobyl': ['NNP'],
  'Chernobyl-type': ['JJ'],
  'Cherokee': ['NNP'],
  'Cherokees': ['NNPS'],
  'Cherry': ['NNP'],
  'Cherwell': ['NNP'],
  'Cheryl': ['NNP'],
  'Ches': ['NNP'],
  'Chesaning': ['NNP'],
  'Chesapeake': ['NNP'],
  'Chesebrough-Pond': ['NNP'],
  'Cheshire': ['NNP'],
  'Chesley': ['NNP'],
  'Chesly': ['NNP'],
  'Chesshire': ['NNP'],
  'Chessman': ['NNP'],
  'Chester': ['NNP'],
  'Chesterfield': ['NNP'],
  'Chesterton': ['NNP'],
  'Chestman': ['NNP'],
  'Chestnut': ['NNP'],
  'Chestnuts': ['NNS'],
  'Chet': ['NNP'],
  'Chetta': ['NNP'],
  'Cheung': ['NNP'],
  'Cheval': ['NNP'],
  'Chevalier': ['NNP'],
  'Chevaline': ['NNP'],
  'Chevenement': ['NNP'],
  'Cheveralls': ['NNP'],
  'Chevrolet': ['NNP'],
  'Chevrolet-Pontiac-GM': ['NNP'],
  'Chevrolets': ['NNPS'],
  'Chevron': ['NNP'],
  'Chevy': ['NNP'],
  'Chewing': ['VBG'],
  'Chex': ['NNP'],
  'Cheyenne': ['NNP'],
  'Cheyennes': ['NNPS'],
  'Chez': ['NNP'],
  'Chg': ['NN'],
  'Chi': ['NNP'],
  'Chiang': ['NNP'],
  'Chiappa': ['NNP'],
  'Chiaromonte': ['NNP'],
  'Chiat': ['NNP'],
  'Chiat\\\'': ['NNP'],
  'Chiat\\\'/Day': ['NNP'],
  'Chiat\\\'/Day\\\'/Mojo': ['NNP'],
  'Chiba': ['NNP'],
  'Chica': ['NNP'],
  'Chicago': ['NNP'],
  'Chicago-Helsinki': ['NNP'],
  'Chicago-Manchester': ['NNP'],
  'Chicago-Montreal': ['NNP'],
  'Chicago-Paris': ['NNP'],
  'Chicago-Warsaw': ['NNP'],
  'Chicago-area': ['JJ'],
  'Chicago-based': ['JJ'],
  'Chicago-centric': ['JJ'],
  'Chicago-style': ['JJ'],
  'Chicagoan': ['NNP'],
  'Chicagoans': ['NNPS'],
  'Chick': ['NN'],
  'Chickasaws': ['NNPS'],
  'Chicken': ['NNP'],
  'Chickens': ['NNS'],
  'Chico': ['NNP'],
  'Chicopee': ['NNP'],
  'Chief': ['NNP'],
  'Chiefly': ['RB'],
  'Chiefs': ['NNPS'],
  'Chieftains': ['NNP'],
  'Chien': ['NNP'],
  'Chien-Min': ['NNP'],
  'Chieti': ['NNP'],
  'Chiggers': ['NNS'],
  'Chiharu': ['NNP'],
  'Chihuahua': ['NNP'],
  'Chilblains': ['NNS'],
  'Child': ['NNP'],
  'Childe': ['NNP'],
  'Childhood': ['NNP'],
  'Children': ['NNS'],
  'Childs': ['NNP'],
  'Chile': ['NNP'],
  'Chilean': ['JJ'],
  'Chili': ['NNP'],
  'Chill': ['NN'],
  'Chill.``': ['``'],
  'Chiller': ['NNP'],
  'Chilly': ['JJ'],
  'Chilmark': ['NNP'],
  'Chilver': ['NNP'],
  'Chim': ['NNP'],
  'Chimanbhai': ['NNP'],
  'Chimerine': ['NNP'],
  'Chimicles': ['NNP'],
  'Chimie': ['NNP'],
  'Chin': ['NNP'],
  'Chin-Use': ['VB'],
  'China': ['NNP'],
  'China-bound': ['JJ'],
  'China-investment': ['JJ'],
  'China-watcher': ['NN'],
  'Chinaman': ['NNP'],
  'Chinchon': ['NNP'],
  'Chinese': ['JJ'],
  'Chinese-American': ['JJ'],
  'Chinese-American-Canadian': ['JJ'],
  'Chinese-British': ['JJ'],
  'Chinese-Soviet': ['NNP'],
  'Chinese-inspired': ['JJ'],
  'Chinese-style': ['JJ'],
  'Ching': ['NNP'],
  'Chinn': ['NNP'],
  'Chino': ['NNP'],
  'Chinook': ['NNP'],
  'Chinooks': ['NNS'],
  'Chiodo': ['NNP'],
  'Chion': ['NNP'],
  'Chip': ['NNP'],
  'Chip-o': ['NNP'],
  'Chipello': ['NNP'],
  'Chipmunks': ['NNPS'],
  'Chippendale': ['NNP'],
  'Chipping': ['VBG'],
  'Chips': ['NNPS'],
  'Chirac': ['NNP'],
  'Chiriqui': ['NNP'],
  'Chiron': ['NNP'],
  'Chisholm': ['NNP'],
  'Chiuchow': ['NNP'],
  'Chiusano': ['NNP'],
  'Chivas': ['NNP'],
  'Chlorothiazide': ['NN'],
  'Chlortetracycline': ['NN'],
  'Chmn.': ['NNP'],
  'Cho-Liang': ['NNP'],
  'Choctaw': ['NNP'],
  'Choctaws': ['NNPS'],
  'Chodorow': ['NNP'],
  'Choice': ['NN'],
  'Choices': ['NNS'],
  'Choir': ['NN'],
  'Chojnowski': ['NNP'],
  'Chok': ['NNP'],
  'Choking': ['VBG'],
  'Cholesterol': ['NN'],
  'Cholet': ['NNP'],
  'Cholet-Dupont': ['NNP'],
  'Chong': ['NNP'],
  'Chong-sik': ['NNP'],
  'Chongju': ['NNP'],
  'Choong': ['NNP'],
  'Choose': ['VB'],
  'Choosing': ['VBG'],
  'Chopin': ['NNP'],
  'Choral': ['NNP'],
  'Chorale': ['NNP'],
  'Chore': ['NN'],
  'Choreographed': ['VBN'],
  'Chores': ['NNS'],
  'Chorney': ['NNP'],
  'Chorrillos': ['NNP'],
  'Chorus': ['NNP'],
  'Chosen': ['NNP'],
  'Chou': ['NNP'],
  'Chow': ['NNP'],
  'Chris': ['NNP'],
  'Chris-Craft': ['NNP'],
  'Chrisanthopoulos': ['NNP'],
  'Chriss': ['NNP'],
  'Chrissake': ['UH'],
  'Christ': ['NNP'],
  'Christ-like': ['JJ'],
  'Christendom': ['NNP'],
  'Christensen': ['NNP'],
  'Christer': ['NNP'],
  'Christi': ['NNP'],
  'Christian': ['NNP'],
  'Christian-Democratic': ['NNP'],
  'Christian-Moslem': ['JJ'],
  'Christian-dominated': ['JJ'],
  'Christiana': ['NNP'],
  'Christiane': ['NNP'],
  'Christiania': ['NNP'],
  'Christianity': ['NNP'],
  'Christians': ['NNPS'],
  'Christiansen': ['NNP'],
  'Christianson': ['NNP'],
  'Christic': ['NNP'],
  'Christie': ['NNP'],
  'Christies': ['NNP'],
  'Christiev': ['NNP'],
  'Christina': ['NNP'],
  'Christine': ['NNP'],
  'Christmas': ['NNP'],
  'Christmas-like': ['JJ'],
  'Christmas-season': ['NN'],
  'Christmas-time': ['JJ'],
  'Christmas-tree': ['JJ'],
  'Christmastime': ['NNP'],
  'Christoph': ['NNP'],
  'Christopher': ['NNP'],
  'Christophers': ['NNPS'],
  'Christopoulos': ['NNP'],
  'Christos': ['NNP'],
  'Christrian': ['NNP'],
  'Christsake': ['NN'],
  'Christy': ['NNP'],
  'Chromatography': ['NN'],
  'Chrome': ['NNP'],
  'Chromium': ['NN'],
  'Chromosome': ['NN'],
  'Chromspun': ['NNP'],
  'Chronicle': ['NNP'],
  'Chronicles': ['NNP'],
  'Chronometer': ['NNP'],
  'Chrysalis': ['NNP'],
  'Chrysler': ['NNP'],
  'Chrysler-Plymouth': ['NNP'],
  'Chrysler-brand': ['JJ'],
  'Chu': ['NNP'],
  'Chubb': ['NNP'],
  'Chubu': ['NNP'],
  'Chucas': ['NNP'],
  'Chuck': ['NNP'],
  'Chugai': ['NNP'],
  'Chugoku': ['NNP'],
  'Chukchi': ['NNP'],
  'Chula': ['NNP'],
  'Chun': ['NNP'],
  'Chung': ['NNP'],
  'Church': ['NNP'],
  'Churches': ['NNP'],
  'Churchill': ['NNP'],
  'Churchillian': ['JJ'],
  'Churchilliana': ['NNPS'],
  'Churchyard': ['NNP'],
  'Churning': ['NN'],
  'Churpek': ['NNP'],
  'Chye': ['NNP'],
  'Chyron': ['NNP'],
  'Cia.': ['NNP'],
  'Ciao': ['FW'],
  'Ciardi': ['NNP'],
  'Ciavarella': ['NNP'],
  'Ciba': ['NNP'],
  'Ciba-Geigy': ['NNP'],
  'Ciba-Geigy\\\'': ['JJ'],
  'Cibula': ['NNP'],
  'Cicero': ['NNP'],
  'Ciceronian': ['JJ'],
  'Cichan': ['NNP'],
  'Cici': ['NNP'],
  'Ciciulla': ['NNP'],
  'Cicognani': ['NNP'],
  'Cid': ['NNP'],
  'Cie': ['NNP'],
  'Cie.': ['NNP'],
  'Cieca': ['NNP'],
  'Ciera': ['NNP'],
  'Cif': ['NNP'],
  'Cigarette': ['NN'],
  'Cigarette-vending': ['JJ'],
  'Cigna': ['NNP'],
  'Cilcorp': ['NNP'],
  'Cilluffo': ['NNP'],
  'Cima': ['NNP'],
  'Cimabue': ['NNP'],
  'Cimflex': ['NNP'],
  'Ciminero': ['NNP'],
  'Cimoli': ['NNP'],
  'Cinalli': ['NNP'],
  'Cincinnati': ['NNP'],
  'Cincinnati-based': ['JJ'],
  'Cinderella': ['NNP'],
  'Cindy': ['NNP'],
  'Cinegrill': ['NNP'],
  'Cinema': ['NNP'],
  'Cinemactor': ['NNP'],
  'Cinematografica': ['NNP'],
  'Cinematographer': ['NN'],
  'Cinemax': ['NNP'],
  'Cineplex': ['NNP'],
  'Cinerama': ['NN'],
  'Cinnaminson': ['NNP'],
  'Cinnamon': ['NNP'],
  'Cinq': ['NNP'],
  'Cinzano': ['NNP'],
  'Cioffi': ['NNP'],
  'Cipher': ['NNP'],
  'Cipolla': ['NNP'],
  'Ciporkin': ['NNP'],
  'Cipriani': ['NNP'],
  'Cipriano': ['NNP'],
  'Cir': ['NNP'],
  'Cir.': ['NNP'],
  'Circle': ['NNP'],
  'Circles': ['NNS'],
  'Circuit': ['NNP'],
  'Circuit-breaker': ['JJ'],
  'Circular': ['NNP'],
  'Circulation': ['NN'],
  'Circulations': ['NNP'],
  'Circumstance': ['NNP'],
  'Circumstances': ['NNS'],
  'Circus': ['NNP'],
  'Circus-Circus': ['NNP'],
  'Ciriaco': ['NNP'],
  'Cirillo': ['NNP'],
  'Cirino': ['NNP'],
  'Cirona': ['NNP'],
  'Cirrus': ['NNP'],
  'Cisneros': ['NNP'],
  'Citadel': ['NNP'],
  'Citation': ['NNP'],
  'Cite': ['VBP'],
  'Cited': ['VBN'],
  'Cites': ['VBZ'],
  'Citibank': ['NNP'],
  'Citic': ['NNP'],
  'Citicorp': ['NNP'],
  'Cities': ['NNPS'],
  'Cities-ABC': ['NNP'],
  'Cities\\\'/ABC': ['NNP'],
  'Citing': ['VBG'],
  'Citizen': ['NNP'],
  'Citizen\\\'/Labor': ['NNP'],
  'Citizens': ['NNPS'],
  'Citroen': ['NN'],
  'Citrus': ['NNP'],
  'City': ['NNP'],
  'City-based': ['JJ'],
  'City-type': ['JJ'],
  'CityFed': ['NNP'],
  'Ciudad': ['NNP'],
  'Civ.': ['NNP'],
  'Civic': ['NNP'],
  'Civics': ['NNPS'],
  'Civil': ['NNP'],
  'Civil-rights': ['NNS'],
  'Civilian': ['NNP'],
  'Civilian-groups': ['NNPS'],
  'Civilization': ['NN'],
  'Civilized': ['JJ'],
  'Clabir': ['NNP'],
  'Clad': ['VBN'],
  'Claeson': ['NNP'],
  'Claeys': ['NNP'],
  'Claiborne': ['NNP'],
  'Claim': ['VB'],
  'Claimants': ['NNPS'],
  'Claiming': ['VBG'],
  'Claims': ['NNPS'],
  'Clair': ['NNP'],
  'Claire': ['NNP'],
  'Clairol': ['NNP'],
  'Clairson': ['NNP'],
  'Clairton': ['NNP'],
  'Clams': ['NNS'],
  'Clan': ['NNP'],
  'Clanahan': ['NNP'],
  'Clancy': ['NNP'],
  'Clandestine': ['JJ'],
  'Clapp': ['NNP'],
  'Clapper': ['NNP'],
  'Clapping': ['VBG'],
  'Clara': ['NNP'],
  'Clarcor': ['NNP'],
  'Clardy': ['NNP'],
  'Clare': ['NNP'],
  'Claremont': ['NNP'],
  'Clarence': ['NNP'],
  'Clarendon': ['NNP'],
  'Clarice': ['NNP'],
  'Claridge': ['NNP'],
  'Clarinet': ['NN'],
  'Clarion': ['NNP'],
  'Clarita': ['NNP'],
  'Clark': ['NNP'],
  'Clarke': ['NNP'],
  'Clarks': ['NNS'],
  'Clarksburg': ['NNP'],
  'Clarkson': ['NNP'],
  'Clashes': ['NNS'],
  'Clasping': ['VBG'],
  'Class': ['NNP'],
  'Class-D': ['NNP'],
  'Classes': ['NNS'],
  'Classic': ['NNP'],
  'Classical': ['NNP'],
  'Classicist': ['NN'],
  'Classics': ['NNS'],
  'Classified': ['JJ'],
  'Classroom': ['NNP'],
  'Classy': ['NNP'],
  'Claude': ['NNP'],
  'Claude-Eric': ['NNP'],
  'Claudia': ['NN'],
  'Claudio': ['NNP'],
  'Claus': ['NNP'],
  'Clause': ['NN'],
  'Clausen': ['NNP'],
  'Clavier': ['NN'],
  'Claws': ['NNS'],
  'Clay': ['NNP'],
  'Clays': ['NNP'],
  'Clayt': ['NNP'],
  'Clayton': ['NNP'],
  'Clayton-Pedersen': ['NNP'],
  'Claytor': ['NNP'],
  'Clean': ['NNP'],
  'Cleaned': ['VBN'],
  'Cleaner': ['NNP'],
  'Cleaning': ['VBG'],
  'Cleanth': ['NNP'],
  'Clear': ['NNP'],
  'Clearance': ['NN'],
  'Clearasil': ['NNP'],
  'Clearer': ['JJR'],
  'Clearing': ['NNP'],
  'Clearly': ['RB'],
  'Clearwater': ['NNP'],
  'Cleary': ['NNP'],
  'Cleave': ['NNP'],
  'Cleaver': ['NNP'],
  'Cleburne': ['NNP'],
  'Cleland': ['NNP'],
  'Clemence': ['NN'],
  'Clemenceau': ['NNP'],
  'Clemens': ['NNP'],
  'Clemensen': ['NNP'],
  'Clement': ['NNP'],
  'Clemente': ['NNP'],
  'Clements': ['NNP'],
  'Clemson': ['NNP'],
  'Clendenin': ['NNP'],
  'Cleo': ['NNP'],
  'Cleopatra': ['NNP'],
  'Cleota': ['NNP'],
  'Clerfayt': ['NNP'],
  'Clericis': ['NNP'],
  'Clerk': ['NNP'],
  'Clerks': ['NNS'],
  'Cleva': ['NNP'],
  'Cleve': ['NNP'],
  'Cleveland': ['NNP'],
  'Cleveland-Cliffs': ['NNP'],
  'Cleveland-based': ['JJ'],
  'Clever': ['JJ'],
  'Cliburn': ['NNP'],
  'Clients': ['NNS'],
  'Cliff': ['NNP'],
  'Clifford': ['NNP'],
  'Cliffs': ['NNP'],
  'Clifton': ['NNP'],
  'Climate': ['NNP'],
  'Climb': ['VB'],
  'Climbing': ['VBG'],
  'Cline': ['NNP'],
  'Clinic': ['NNP'],
  'Clinical': ['NNP'],
  'Clinico-pathologic': ['NNP'],
  'Clinics': ['NNP'],
  'Clinique': ['NNP'],
  'Clint': ['NNP'],
  'Clinton': ['NNP'],
  'Clintonville': ['NNP'],
  'Clipper': ['NNP'],
  'Clive': ['NNP'],
  'Cloquet': ['NNP'],
  'Clorets': ['NNP'],
  'Clorox': ['NNP'],
  'Close': ['RB'],
  'Close-up': ['NNP'],
  'Closed': ['VBN'],
  'Closed-end': ['JJ'],
  'Closely': ['RB'],
  'Closen': ['NNP'],
  'Closer': ['RBR'],
  'Closes': ['VBZ'],
  'Closing': ['NN'],
  'Clostridium': ['NN'],
  'Cloth': ['NNP'],
  'Clothes': ['NNS'],
  'ClothesTime': ['NNP'],
  'Clothestime': ['NNP'],
  'Clothiers': ['NNP'],
  'Clothing': ['NN'],
  'Cloud': ['NNP'],
  'Cloudcroft': ['NNP'],
  'Clouds': ['NNP'],
  'Clough': ['NNP'],
  'Clov': ['NNP'],
  'Clow': ['NNP'],
  'Clozapine': ['NNP'],
  'Clozaril': ['NNP'],
  'Club': ['NNP'],
  'Clubhouse': ['NNP'],
  'Clubs': ['NNPS'],
  'Cluck': ['NNP'],
  'Clue': ['NNP'],
  'Clueless': ['NNP'],
  'Cluett': ['NNP'],
  'Cluff': ['NNP'],
  'Cluggish': ['NNP'],
  'Clumps': ['NNS'],
  'Clurman': ['NNP'],
  'Clyde': ['NNP'],
  'Clyfford': ['NNP'],
  'Cmdr.': ['NNP'],
  'Co': ['NNP'],
  'Co-Chief': ['NNP'],
  'Co-Renitec': ['NNP'],
  'Co-author': ['NN'],
  'Co-authors': ['NNS'],
  'Co-cola': ['NNP'],
  'Co-op': ['NN'],
  'Co-operative': ['NNP'],
  'Co-optation': ['NN'],
  'Co-sponsoring': ['NNP'],
  'Co.': ['NNP'],
  'Co.``': ['``'],
  'CoAdvil': ['NNP'],
  'CoGen': ['NNP'],
  'Coach': ['NNP'],
  'Coaching': ['NN'],
  'Coal': ['NNP'],
  'Coalition': ['NNP'],
  'Coan': ['NNP'],
  'Coast': ['NNP'],
  'Coast-based': ['JJ'],
  'CoastAmerica': ['NNP'],
  'Coastal': ['NNP'],
  'Coastline': ['NNP'],
  'Coasts': ['NNPS'],
  'Coat': ['NNP'],
  'Coatedboard': ['NNP'],
  'Coates': ['NNP'],
  'Coatings': ['NNP'],
  'Coats': ['NNP'],
  'Cobb': ['NNP'],
  'Cobbs': ['NNS'],
  'Coble': ['NNP'],
  'Cobo': ['NNP'],
  'Cobra': ['NNP'],
  'Coburg': ['NNP'],
  'Coburn': ['NNP'],
  'Coca': ['NNP'],
  'Coca-Cola': ['NNP'],
  'Cocaine': ['NN'],
  'Coche-Dury': ['NNP'],
  'Cochran': ['NNP'],
  'Cochrane': ['NNP'],
  'Cockburn': ['NNP'],
  'Cockerel': ['NNP'],
  'Cocktail': ['NN'],
  'Cocktails': ['NNS'],
  'Cocoa': ['NNP'],
  'Cocom': ['NNP'],
  'Coconut': ['NNP'],
  'Coconuts': ['NNPS'],
  'Cocoons': ['NNS'],
  'Cocteau': ['NNP'],
  'Cod': ['NNP'],
  'Coda': ['NNP'],
  'Coddington': ['NNP'],
  'Code': ['NNP'],
  'Code-Alarm': ['NNP'],
  'Codevilla': ['NNP'],
  'Codification': ['NN'],
  'Codifying': ['VBG'],
  'Cody': ['NNP'],
  'Coe': ['NNP'],
  'Coeditors': ['NNS'],
  'Coelho': ['NNP'],
  'Coen': ['NNP'],
  'Coesfeld': ['NNP'],
  'Coeur': ['NNP'],
  'Coffee': ['NNP'],
  'Coffee-House': ['NNP'],
  'Coffee-shop': ['NN'],
  'Coffey': ['NNP'],
  'Coffield': ['NNP'],
  'Coffin': ['NNP'],
  'Cofide': ['NNP'],
  'Cogan': ['NNP'],
  'Cogefar': ['NNP'],
  'Cogen': ['NNP'],
  'Cogeneration': ['NNP'],
  'Cognex': ['NNP'],
  'Cognos': ['NNP'],
  'Cohen': ['NNP'],
  'Cohens': ['NNPS'],
  'Coherent': ['NNP'],
  'Cohn': ['NNP'],
  'Cohodes': ['NNP'],
  'Coiffet': ['NNP'],
  'Coin': ['NNP'],
  'Coincidences': ['NNPS'],
  'Coincident': ['JJ'],
  'Coincidentally': ['RB'],
  'Coke': ['NNP'],
  'Cokely': ['NNP'],
  'Cokes': ['NNS'],
  'Col.': ['NNP'],
  'Cola': ['NNP'],
  'Colavito': ['NNP'],
  'Colbert': ['NNP'],
  'Colby': ['NNP'],
  'Colcord': ['NNP'],
  'Cold': ['NNP'],
  'Colder': ['JJR'],
  'Coldwater': ['NNP'],
  'Coldwell': ['NNP'],
  'Cole': ['NNP'],
  'Coleco': ['NNP'],
  'Colee': ['NNP'],
  'Colefax': ['NNP'],
  'Coleman': ['NNP'],
  'Coleridge': ['NNP'],
  'Coles': ['NNP'],
  'Coletta': ['NNP'],
  'Colfax': ['NNP'],
  'Colgate': ['NNP'],
  'Colgate-Palmolive': ['NNP'],
  'Colin': ['NNP'],
  'Colinas': ['NNP'],
  'Coliseum': ['NNP'],
  'Collaborative': ['NNP'],
  'Collagen': ['NNP'],
  'Collateral': ['NN'],
  'Collateralized': ['NNP'],
  'Colleagues': ['NNS'],
  'Collected': ['NNP'],
  'Collectibles': ['NNS'],
  'Collecting': ['NNP'],
  'Collection': ['NNP'],
  'Collections': ['NNS'],
  'Collective': ['NNP'],
  'Collectively': ['RB'],
  'Collector': ['NNP'],
  'Collectors': ['NNS'],
  'Colleen': ['NNP'],
  'College': ['NNP'],
  'Colleges': ['NNP'],
  'Collegiate': ['NNP'],
  'Collett': ['NNP'],
  'Collier': ['NNP'],
  'Collingwood': ['NNP'],
  'Collins': ['NNP'],
  'Collinsville': ['NNP'],
  'Collischon': ['NNP'],
  'Collision': ['NNP'],
  'Collor': ['NNP'],
  'Colloton': ['NNP'],
  'Collyer': ['NNP'],
  'Colman': ['NNP'],
  'Colmans': ['NNPS'],
  'Colmer': ['NNP'],
  'Colnaghi': ['NNP'],
  'Colo': ['NNP'],
  'Colo.': ['NNP'],
  'Colodny': ['NNP'],
  'Cologne': ['NNP'],
  'Colombatto': ['NNP'],
  'Colombia': ['NNP'],
  'Colombian': ['JJ'],
  'Colombians': ['NNPS'],
  'Colombo': ['NNP'],
  'Colon': ['NN'],
  'Colonel': ['NNP'],
  'Colonia': ['NNP'],
  'Colonial': ['NNP'],
  'Colonialism': ['NN'],
  'Colonna': ['NNP'],
  'Colonsville': ['NNP'],
  'Colonus': ['NNP'],
  'Colony': ['NNP'],
  'Color': ['NNP'],
  'Colorado': ['NNP'],
  'Colorado-Ute': ['NNP'],
  'ColoradoUte': ['NNP'],
  'Colorama': ['NN'],
  'Colorcoat': ['NNP'],
  'Colored': ['NNP'],
  'Colorful': ['JJ'],
  'Colorliner': ['NNP'],
  'Colorocs': ['NNP'],
  'Colors': ['NNS'],
  'Colosseum': ['NNP'],
  'Colossians': ['NNPS'],
  'Colossus': ['NNP'],
  'Colquitt': ['NNP'],
  'Cols': ['NNP'],
  'Colson': ['NNP'],
  'Colston': ['NNP'],
  'Colt': ['NNP'],
  'Colton': ['NNP'],
  'Colts': ['NNP'],
  'Coltsman': ['NN'],
  'Colucci': ['NNP'],
  'Columbia': ['NNP'],
  'Columbiana': ['NNP'],
  'Columbus': ['NNP'],
  'Column': ['NN'],
  'Columnist': ['NNP'],
  'Columnists': ['NNS'],
  'Columns': ['NNS'],
  'Colvin': ['NNP'],
  'Colzani': ['NNP'],
  'Com': ['NNP'],
  'ComFed': ['NNP'],
  'Comair': ['NNP'],
  'Comanche': ['NNP'],
  'Comanches': ['NNPS'],
  'Comany': ['NNP'],
  'Combat': ['NNP'],
  'Combatting': ['VBG'],
  'Combe': ['NNP'],
  'Combellack': ['NNP'],
  'Combine': ['VB'],
  'Combined': ['VBN'],
  'Combining': ['VBG'],
  'Combis': ['NNPS'],
  'Combo': ['NNP'],
  'Combs': ['NNP'],
  'Combses': ['NNPS'],
  'Combustion': ['NNP'],
  'Comcast': ['NNP'],
  'Comdisco': ['NNP'],
  'Come': ['VB'],
  'Comeau': ['NNP'],
  'Comeback': ['NNP'],
  'Comecon': ['NNP'],
  'Comedian': ['NN'],
  'Comedie': ['NNP'],
  'Comedy': ['NNP'],
  'Comend': ['VB'],
  'Comenico': ['NNP'],
  'Comer': ['NNP'],
  'Comerica': ['NNP'],
  'Comes': ['VBZ'],
  'Comet': ['NNP'],
  'Comex': ['NNP'],
  'Comfed': ['NNP'],
  'Comfort': ['NNP'],
  'Comfortably': ['RB'],
  'Comic': ['NNP'],
  'Comics': ['NNPS'],
  'Comin': ['VBG'],
  'Cominco': ['NNP'],
  'Cominform': ['NNP'],
  'Coming': ['VBG'],
  'Comique': ['NNP'],
  'Comiskey': ['NNP'],
  'Comission': ['NNP'],
  'Comissioner': ['NNP'],
  'Commack': ['NNP'],
  'Command': ['NNP'],
  'Commandeering': ['VBG'],
  'Commander': ['NNP'],
  'Commander-in-Chief': ['NNP'],
  'Commander-in-Chief...': [':'],
  'Commanders': ['NNPS'],
  'Commanding': ['VBG'],
  'Commandment': ['NN'],
  'Commands': ['NNS'],
  'Commemorative': ['NNP'],
  'Commencing': ['VBG'],
  'Comment': ['NN'],
  'Commentaries': ['NNPS'],
  'Commentary': ['NNP'],
  'Commentators': ['NNS'],
  'Commenting': ['VBG'],
  'Comments': ['NNS'],
  'Commercants': ['NNP'],
  'Commerce': ['NNP'],
  'CommerceBancorp': ['NNP'],
  'Commercial': ['NNP'],
  'Commerciale': ['NNP'],
  'Commercializing': ['VBG'],
  'Commercials': ['NNS'],
  'Commerzbank': ['NNP'],
  'Commies': ['NNPS'],
  'Commisioner': ['NNP'],
  'Commissary': ['NNP'],
  'Commission': ['NNP'],
  'Commission-controlled': ['JJ'],
  'Commission.': ['NNP'],
  'Commissioned': ['VBN'],
  'Commissioner': ['NNP'],
  'Commissioners': ['NNPS'],
  'Commissioning': ['VBG'],
  'Commissions': ['NNS'],
  'Commitment': ['NNP'],
  'Committed': ['VBN'],
  'Committee': ['NNP'],
  'Committeeman': ['NNP'],
  'Committeemen': ['NNS'],
  'Committees': ['NNS'],
  'Commodities': ['NNS'],
  'Commodity': ['NNP'],
  'Commodore': ['NNP'],
  'Common': ['NNP'],
  'Common-law': ['JJ'],
  'Commoner': ['NNP'],
  'Commonly': ['RB'],
  'Commons': ['NNP'],
  'Commonweal': ['NNP'],
  'Commonwealth': ['NNP'],
  'Commune': ['NNP'],
  'Communese': ['NNP'],
  'Communication': ['NNP'],
  'Communications': ['NNPS'],
  'Communion': ['NNP'],
  'Communism': ['NNP'],
  'Communisn': ['NN'],
  'Communist': ['NNP'],
  'Communist-designed': ['JJ'],
  'Communist-inspired': ['JJ'],
  'Communist-led': ['JJ'],
  'Communist-type': ['JJ'],
  'Communistic': ['JJ'],
  'Communists': ['NNPS'],
  'Communities': ['NNPS'],
  'Community': ['NNP'],
  'Compact': ['NNP'],
  'Compagnie': ['NNP'],
  'Compania': ['NNP'],
  'Companies': ['NNS'],
  'Companion': ['NN'],
  'Company': ['NNP'],
  'Compaore': ['NNP'],
  'Compaq': ['NNP'],
  'Comparable': ['JJ'],
  'Comparable-store': ['JJ'],
  'Comparative': ['JJ'],
  'Compare': ['VB'],
  'Compared': ['VBN'],
  'Comparing': ['VBG'],
  'Compassion': ['NNP'],
  'Compassionately': ['RB'],
  'Compelled': ['VBN'],
  'Compensation': ['NNP'],
  'Competent': ['JJ'],
  'Competes': ['VBZ'],
  'Competing': ['VBG'],
  'Competition': ['NN'],
  'Competitive': ['JJ'],
  'Competitors': ['NNS'],
  'Compeyson': ['NNP'],
  'Compiegne': ['NNP'],
  'Compilation': ['NN'],
  'Compiled': ['VBN'],
  'Compiler': ['NN'],
  'Complaint': ['NN'],
  'Complaints': ['NNS'],
  'Complementing': ['VBG'],
  'Complete': ['JJ'],
  'Completed': ['VBN'],
  'Completes': ['VBZ'],
  'Completing': ['VBG'],
  'Completion': ['NN'],
  'Completions': ['NNS'],
  'Complex': ['NNP'],
  'Complexity': ['NN'],
  'Compliance': ['NNP'],
  'Complicating': ['VBG'],
  'Complicity': ['NN'],
  'Complying': ['VBG'],
  'Components': ['NNP'],
  'Composer': ['NN'],
  'Composers': ['NNPS'],
  'Composite': ['NNP'],
  'Compound': ['JJ'],
  'Compounding': ['VBG'],
  'Comprecin': ['NNP'],
  'Comprehensive': ['NNP'],
  'Compress': ['VB'],
  'Compression': ['NN'],
  'Comprised': ['VBN'],
  'Compromise': ['NNP'],
  'Compromises': ['NNS'],
  'Compromising': ['VBG'],
  'Compson': ['NNP'],
  'Compton': ['NNP'],
  'Comptroller': ['NNP'],
  'CompuChem': ['NNP'],
  'CompuServe': ['NNP'],
  'Compulsions': ['NNP'],
  'Compulsive': ['JJ'],
  'Compulsory': ['JJ'],
  'Compumat': ['NNP'],
  'Computation': ['NNP'],
  'Computations': ['NNS'],
  'Compute': ['VB'],
  'Computer': ['NNP'],
  'Computer-generated': ['JJ'],
  'Computer-guided': ['JJ'],
  'Computer-peripherals': ['NNS'],
  'ComputerLand': ['NNP'],
  'ComputerWorld': ['NNP'],
  'Computerized': ['JJ'],
  'Computers': ['NNPS'],
  'Computerworld': ['NNP'],
  'Computing': ['VBG'],
  'Comrade': ['NN'],
  'Comrades': ['NNPS'],
  'Comroe': ['NNP'],
  'Comsat': ['NNP'],
  'Comstock': ['NNP'],
  'Comstron': ['NNP'],
  'Comtes': ['NNP'],
  'Comus': ['NNP'],
  'Comvik': ['NNP'],
  'Con': ['NNP'],
  'ConAgra': ['NNP'],
  'Conable': ['NNP'],
  'Conalco': ['NNP'],
  'Conan': ['NNP'],
  'Conant': ['NNP'],
  'Conasupo': ['NNP'],
  'Conaway': ['NNP'],
  'Conceding': ['VBG'],
  'Conceivably': ['RB'],
  'Conceived': ['VBN'],
  'Concept': ['NNP'],
  'Conception': ['NNP'],
  'Conceptions': ['NNS'],
  'Concepts': ['NNP'],
  'Conceptually': ['RB'],
  'Concern': ['NN'],
  'Concerned': ['NNP'],
  'Concerning': ['VBG'],
  'Concerns': ['NNS'],
  'Concert': ['NNP'],
  'Concert-Disc': ['NNP'],
  'Concertante': ['NNP'],
  'Concerto': ['NNP'],
  'Concerts': ['NNPS'],
  'Concessionaires': ['NNS'],
  'Concetta': ['NNP'],
  'Conchita': ['NNP'],
  'Concise': ['JJ'],
  'Concludes': ['VBZ'],
  'Concluding': ['VBG'],
  'Conclusions': ['NNS'],
  'Concocts': ['VBZ'],
  'Concord': ['NNP'],
  'Concordance': ['NN'],
  'Concorde': ['NNP'],
  'Concordes': ['NNP'],
  'Concrete': ['NNP'],
  'Concurrence': ['NN'],
  'Concurrent': ['JJ'],
  'Concurrently': ['RB'],
  'Conde': ['NNP'],
  'Condensation': ['NN'],
  'Conder': ['NNP'],
  'Condit': ['NNP'],
  'Condition': ['NN'],
  'Conditions': ['NNS'],
  'Condliffe': ['NNP'],
  'Condominium': ['NNP'],
  'Condoms': ['NNS'],
  'Condor': ['NNP'],
  'Condos': ['NNS'],
  'Conduct': ['NNP'],
  'Conducted': ['VBN'],
  'Conductor': ['NN'],
  'Conduit': ['NNP'],
  'Conduits': ['NNS'],
  'Cone': ['NNP'],
  'Conestoga': ['NNP'],
  'Coney': ['NNP'],
  'Confabulation': ['NN'],
  'Confair': ['NNP'],
  'Confectioner': ['NNP'],
  'Confectionery': ['JJ'],
  'Confederacy': ['NNP'],
  'Confederate': ['NNP'],
  'Confederates': ['NNS'],
  'Confederation': ['NNP'],
  'Confederations': ['NNPS'],
  'Confer': ['NNP'],
  'Conferees': ['NNS'],
  'Conference': ['NNP'],
  'Conferences': ['NNPS'],
  'Confess': ['VB'],
  'Confession': ['NN'],
  'Confessions': ['NNPS'],
  'Confidence': ['NN'],
  'Confident': ['JJ'],
  'Confidential': ['NNP'],
  'Confidently': ['RB'],
  'Confiding': ['VBG'],
  'Confindustria': ['NNP'],
  'Confirmation': ['NN'],
  'Confirming': ['VBG'],
  'Confiscated': ['VBN', 'JJ'],
  'Conflict': ['NN'],
  'Conforming': ['NN'],
  'Confrontation': ['NN'],
  'Confronted': ['VBN'],
  'Confucian': ['NNP'],
  'Confucianism': ['NNP'],
  'Confucius': ['NNP'],
  'Confused': ['VBN'],
  'Confusion': ['NN'],
  'Confutatis': ['FW'],
  'Confuted': ['NNP'],
  'Cong': ['NNP'],
  'Congdon': ['NNP'],
  'Congel': ['NNP'],
  'Conger': ['NNP'],
  'Congo': ['NNP'],
  'Congolese': ['NNP'],
  'Congratulations': ['NNS'],
  'Congregation': ['NNP'],
  'Congregational': ['NNP'],
  'Congregational-Baptist': ['NNP'],
  'Congregationalism': ['NNP'],
  'Congregationalist': ['NN'],
  'Congregationalists': ['NNS'],
  'Congress': ['NNP'],
  'Congress\'s': ['NNP'],
  'Congresses': ['NNS'],
  'Congressional': ['NNP'],
  'Congressman': ['NNP'],
  'Congressmen': ['NNS'],
  'Congresswoman': ['NNP'],
  'Coniston': ['NNP'],
  'Conklin': ['NNP'],
  'Conlin': ['NNP'],
  'Conlon': ['NNP'],
  'Conlow': ['NNP'],
  'Conmel': ['NNP'],
  'Conn': ['NNP'],
  'Conn.': ['NNP'],
  'Conn.-based': ['JJ'],
  'Conn.based': ['JJ'],
  'Connall': ['NNP'],
  'Connally': ['NNP'],
  'Connaught': ['NNP'],
  'Conneaut': ['NNP'],
  'Connectables': ['NNP'],
  'Connecticut': ['NNP'],
  'Connecting': ['NNP'],
  'Connection': ['NN'],
  'Connections': ['NNS'],
  'Connectors': ['NNP'],
  'Connell': ['NNP'],
  'Connelly': ['NNP'],
  'Conner': ['NNP'],
  'Connery': ['NNP'],
  'Connick': ['NNP'],
  'Connie': ['NNP'],
  'Conning': ['NNP'],
  'Connoisseur': ['NNP'],
  'Connoisseurs': ['NNS'],
  'Connolly': ['NNP'],
  'Connor': ['NNP'],
  'Connors': ['NNP'],
  'Conoco': ['NNP'],
  'Conquering': ['NNP'],
  'Conquest': ['NNP'],
  'Conquete': ['NNP'],
  'Conrac': ['NNP'],
  'Conrad': ['NNP'],
  'Conrades': ['NNP'],
  'Conradically': ['RB'],
  'Conradie': ['NNP'],
  'Conradies': ['NNP'],
  'Conrail': ['NNP'],
  'Conran': ['NNP'],
  'Conreid': ['NNP'],
  'Conroe': ['NNP'],
  'Conroy': ['NNP'],
  'Conscience': ['NN'],
  'Consciousness': ['NN'],
  'Conseco': ['NNP'],
  'Conseil': ['NNP'],
  'Consensus': ['NNP'],
  'Consent': ['NNP'],
  'Consequence': ['NN'],
  'Consequences': ['NNS'],
  'Consequently': ['RB'],
  'Conservancy': ['NNP'],
  'Conservation': ['NNP'],
  'Conservationists': ['NNS'],
  'Conservatism': ['NN'],
  'Conservative': ['NNP'],
  'Conservative-Communist': ['JJ'],
  'Conservatives': ['NNS'],
  'Conservatory': ['NNP'],
  'Consider': ['VB'],
  'Considerable': ['JJ'],
  'Consideration': ['NN'],
  'Considered': ['VBN'],
  'Considering': ['VBG'],
  'Consistent': ['JJ'],
  'Consistently': ['RB'],
  'Consisting': ['VBG'],
  'Consitutional': ['JJ'],
  'Consob': ['NNP'],
  'Consolidated': ['NNP'],
  'Consolidation': ['NN'],
  'Consolo': ['NNP'],
  'Consonantal': ['JJ'],
  'Consort': ['NNP'],
  'Consortium': ['NNP'],
  'Conspicuous': ['JJ'],
  'Conspicuously': ['RB'],
  'Conspiracy': ['NNP'],
  'Constable': ['NNP'],
  'Constance': ['NNP'],
  'Constant': ['JJ'],
  'Constantin': ['NNP'],
  'Constantine': ['NNP'],
  'Constantino': ['NNP'],
  'Constantinople': ['NNP'],
  'Constantinos': ['NNP'],
  'Constants': ['NNS'],
  'Constar': ['NNP'],
  'Constellation': ['NNP'],
  'Constitution': ['NNP'],
  'Constitutional': ['NNP'],
  'Constitutions': ['NNS'],
  'Constraints': ['NNS'],
  'Construcciones': ['NNP'],
  'Construct': ['VB'],
  'Constructeurs': ['NNP'],
  'Construction': ['NN'],
  'Constructions': ['NNP'],
  'Constructors': ['NNPS'],
  'Consul': ['NNP'],
  'Consulate-General': ['NNP'],
  'Consultant': ['NNP'],
  'Consultants': ['NNP'],
  'Consultation': ['NN'],
  'Consulting': ['NNP'],
  'Consumer': ['NNP'],
  'Consumer-electronics': ['NNS'],
  'Consumers': ['NNS'],
  'Consuming': ['VBG'],
  'Consumption': ['NN'],
  'Contact': ['NN'],
  'Contacted': ['VBN'],
  'Contacts': ['NNPS'],
  'Container': ['NNP'],
  'Containers': ['NNPS'],
  'Containment': ['NN'],
  'Contant': ['NNP'],
  'Conte': ['NNP'],
  'Contel': ['NNP'],
  'Contemplating': ['VBG'],
  'Contemplation': ['NN'],
  'Contemporary': ['NNP'],
  'Contempt': ['NN'],
  'Contend': ['VBP'],
  'Content': ['JJ'],
  'Contest': ['NNP'],
  'Context': ['NN'],
  'ContiTrade': ['NNP'],
  'Continent': ['NN'],
  'Continental': ['NNP'],
  'Continentals': ['NNS'],
  'Continential': ['NNP'],
  'Continuation': ['NN'],
  'Continue': ['VB'],
  'Continued': ['VBN'],
  'Continues': ['VBZ'],
  'Continuing': ['VBG'],
  'Continuity': ['NN'],
  'Continuous': ['JJ'],
  'Continuum': ['NN'],
  'Contra': ['NNP'],
  'Contract': ['NNP'],
  'Contracting': ['VBG'],
  'Contraction': ['NN'],
  'Contractors': ['NNS'],
  'Contracts': ['NNS'],
  'Contradictions': ['NNP'],
  'Contrarian': ['JJ'],
  'Contrarily': ['RB'],
  'Contrary': ['JJ'],
  'Contras': ['NNPS'],
  'Contrast': ['NN'],
  'Contrasted': ['VBN'],
  'Contrasts': ['NNS'],
  'Contribute': ['VB'],
  'Contributing': ['VBG'],
  'Contribution': ['NNP'],
  'Contributions': ['NNS'],
  'Control': ['NNP'],
  'Controller': ['NNP'],
  'Controls': ['NNP'],
  'Conus': ['NNP'],
  'Convair': ['NNP'],
  'Convenience': ['NNP'],
  'Conveniently': ['RB'],
  'Convention': ['NNP'],
  'Conventional': ['JJ'],
  'Conversation': ['NN'],
  'Conversations': ['NNS'],
  'Conversely': ['RB'],
  'Conversion': ['NNP'],
  'Convertible': ['JJ'],
  'Converts': ['NNS'],
  'Convex': ['NNP'],
  'Conveyance': ['NN'],
  'Convict': ['NNP'],
  'Conviction': ['NN'],
  'Convinced': ['VBN'],
  'Convincing': ['VBG'],
  'Convocation': ['NN'],
  'Convocations': ['NNS'],
  'Convulsively': ['RB'],
  'Conway': ['NNP'],
  'Conyers': ['NNP'],
  'Cooch': ['NNP'],
  'Coogan': ['NNP'],
  'Cook': ['NNP'],
  'Cooke': ['NNP'],
  'Cooked': ['VBN'],
  'Cooker': ['NNP'],
  'Cookie': ['NNP'],
  'Cookie-Crisp': ['NNP'],
  'Cookies': ['NNS'],
  'Cooking': ['NNP'],
  'Cool': ['JJ'],
  'Cooler': ['NNP'],
  'Coolers': ['NNS'],
  'Coolest': ['JJS'],
  'Coolidge': ['NNP'],
  'Coolidges': ['NNPS'],
  'Cooling': ['NN'],
  'Coombs': ['NNP'],
  'Coons': ['NNP'],
  'Coontz': ['NNP'],
  'Cooper': ['NNP'],
  'Cooperation': ['NNP'],
  'Cooperative': ['NNP'],
  'Cooperatives': ['NNP'],
  'Cooperman': ['NNP'],
  'Coopers': ['NNP'],
  'Coopersmith': ['NNP'],
  'Coor': ['NNP'],
  'Coordinated': ['VBN'],
  'Coordinating': ['NNP'],
  'Coordination': ['NN'],
  'Coors': ['NNP'],
  'Coors-Stroh': ['NNP'],
  'Coosa': ['NNP'],
  'Cop': ['NNP'],
  'Copaken': ['NNP'],
  'Copeland': ['NNP'],
  'Copenhagen': ['NNP'],
  'Copernican': ['JJ'],
  'Copernicus': ['NNP'],
  'Copernicus-the-astronomer': ['NN'],
  'Copersucar': ['NNP'],
  'Copiague': ['NNP'],
  'Copie': ['NNP'],
  'Copies': ['NNS'],
  'Coping': ['VBG'],
  'Copland': ['NNP'],
  'Coplandesque': ['JJ'],
  'Copley': ['NNP'],
  'Copp': ['NNP'],
  'Copper': ['NN'],
  'Copperman': ['NNP'],
  'Copperweld': ['NNP'],
  'Coproduction': ['NNP'],
  'Copy': ['NNP'],
  'Copycat': ['NN'],
  'Copying': ['NNP'],
  'Copyright': ['NNP'],
  'Corabi': ['NNP'],
  'Coral': ['NNP'],
  'Corash': ['NNP'],
  'Corault': ['NNP'],
  'Corazon': ['NNP'],
  'Corbehem': ['NNP'],
  'Corbin': ['NN'],
  'Corby': ['NNP'],
  'Corcoran': ['NNP'],
  'Cordell': ['NNP'],
  'Corder': ['NNP'],
  'Cordier': ['NNP'],
  'Cordis': ['NNP'],
  'Cordoba': ['NNP'],
  'Cordova': ['NNP'],
  'Core': ['NNP'],
  'CoreStates': ['NNP'],
  'Corelli': ['NNP'],
  'Corestates': ['NNP'],
  'Corey': ['NNP'],
  'Corinne': ['NNP'],
  'Corinth': ['NNP'],
  'Corinthian': ['JJ'],
  'Corinthians': ['NNPS'],
  'Coriolanus': ['NNP'],
  'Corlopam': ['NNP'],
  'Cormack': ['NNP'],
  'Corn': ['NN'],
  'Corne': ['NNP'],
  'Corneilus': ['NNP'],
  'Cornel': ['NNP'],
  'Cornelius': ['NNP'],
  'Cornell': ['NNP'],
  'Cornell-Dubilier': ['NNP'],
  'Corner': ['NNP'],
  'Cornerback': ['NN'],
  'Corners': ['NNPS'],
  'Corney': ['NNP'],
  'Cornfeld': ['NNP'],
  'Cornfield': ['NNP'],
  'Corning': ['NNP'],
  'Cornish': ['NNP'],
  'Cornona': ['NNP'],
  'Cornwall': ['NNP'],
  'Cornwallis': ['NNP'],
  'Corolla': ['NNP'],
  'Corollary': ['NN'],
  'Corollas': ['NNPS'],
  'Corona': ['NNP'],
  'Coronado': ['NNP'],
  'Coronation': ['NNP'],
  'Coroner': ['NN'],
  'Coronets': ['NNPS'],
  'Corot': ['NNP'],
  'Corp': ['NNP'],
  'Corp.': ['NNP'],
  'Corp.-Toyota': ['JJ'],
  'Corp.-USA': ['NNP'],
  'Corp.-compatible': ['JJ'],
  'Corp.:8.30': ['NNP'],
  'Corp.:8.50': ['NNP'],
  'Corp.:8.725': ['NNP'],
  'Corp.\\\'/Europe': ['NNP'],
  'Corp.s': ['NNP'],
  'Corporal': ['NNP'],
  'Corporate': ['JJ'],
  'Corporate\\\'/investor': ['NN'],
  'Corporation': ['NNP'],
  'Corporations': ['NNS'],
  'Corps': ['NNP'],
  'Corpus': ['NNP'],
  'Corr': ['NNP'],
  'Corrado': ['NNP'],
  'Correct': ['JJ'],
  'Correcting': ['VBG'],
  'Correction': ['NN'],
  'Correctional': ['NNP'],
  'Corrections': ['NNP'],
  'Corrective': ['JJ'],
  'Correctly': ['RB'],
  'Correggio': ['NNP'],
  'Correlations': ['NNS'],
  'Correlatively': ['RB'],
  'Correll': ['NNP'],
  'Correspondence': ['NN'],
  'Correspondents': ['NNPS'],
  'Corresponding': ['VBG'],
  'Corrette': ['NNP'],
  'Corrigan': ['NNP'],
  'Corroborating': ['VBG'],
  'Corroon': ['NNP'],
  'Corrupt': ['NNP'],
  'Corruption': ['NN'],
  'Corry': ['NNP'],
  'Corsi': ['NNP'],
  'Corsia': ['NNP'],
  'Corsica': ['NNP'],
  'Corsicas': ['NNS'],
  'Corso': ['NNP'],
  'Cort': ['NNP'],
  'Cortes': ['NNP'],
  'Cortese': ['NNP'],
  'Cortex': ['NNP'],
  'Cortizone-5': ['NNP'],
  'Cortland': ['NNP'],
  'Cortlandt': ['NNP'],
  'Corton-Charlemagne': ['NNP'],
  'Corvallis': ['NNP'],
  'Corvette': ['NNP'],
  'Corvettes': ['NNS'],
  'Corvus': ['NNP'],
  'Corzine': ['NNP'],
  'Cos': ['NNP'],
  'Cos.': ['NNP'],
  'Cosby': ['NNP'],
  'Cosgrove': ['NNP'],
  'Cosgrove-Meurer': ['NNP'],
  'Cosma': ['NNP'],
  'Cosmair': ['NNP'],
  'Cosmetic': ['NNP'],
  'Cosmetics': ['NNS'],
  'Cosmic': ['NNP'],
  'Cosmo': ['NNP'],
  'Cosmology': ['NNP'],
  'Cosmopolitan': ['NNP'],
  'Cosmopulos': ['NNP'],
  'Cosmos': ['NNP'],
  'Cossack': ['NNP'],
  'Cossacks': ['NNPS'],
  'Cossiga': ['NNP'],
  'Cost': ['NN'],
  'Cost-effective': ['JJ'],
  'Costa': ['NNP'],
  'Costaggini': ['NNP'],
  'Costantine': ['NNP'],
  'Costanza': ['NNP'],
  'Costar': ['NNP'],
  'Costco': ['NNP'],
  'Costello': ['NNP'],
  'Costley': ['NNP'],
  'Costly': ['JJ'],
  'Costner': ['NNP'],
  'Costs': ['NNS'],
  'Cote': ['NNP'],
  'Cotillion': ['NNP'],
  'Cotman': ['NNP'],
  'Cotran': ['NNP'],
  'Cott': ['NNP'],
  'Cotten': ['NNP'],
  'Cotter': ['NNP'],
  'Cottle': ['NNP'],
  'Cotton': ['NNP'],
  'Cottrell': ['NNP'],
  'Cotty': ['NNP'],
  'Couch-potato': ['NN'],
  'Coudersport': ['NNP'],
  'Coudert': ['NNP'],
  'Cougar': ['NNP'],
  'Cougars': ['NNPS'],
  'Coughlin': ['NNP'],
  'Coulas': ['NNP'],
  'Could': ['MD'],
  'Coulomb': ['NNP'],
  'Coulson': ['NNP'],
  'Council': ['NNP'],
  'Councilman': ['NNP'],
  'Councils': ['NNPS'],
  'Councilwoman': ['NNP'],
  'Counsel': ['NNP'],
  'Counsel/NNP...': [':'],
  'Counseling': ['NN'],
  'Counselor': ['NNP'],
  'Counselors': ['NNPS'],
  'Count': ['NNP'],
  'Count-Duke': ['NNP'],
  'Countach': ['NNP'],
  'Counter': ['NNP'],
  'Countered': ['VBD'],
  'Countering': ['VBG'],
  'Counterpoint': ['NN'],
  'Counters': ['VBZ'],
  'Counties': ['NNPS'],
  'Countin': ['VBG'],
  'Counting': ['VBG'],
  'Countries': ['NNPS'],
  'Country': ['NNP'],
  'Countrymen': ['NNPS'],
  'Countrywide': ['NNP'],
  'County': ['NNP'],
  'Coupal': ['NNP'],
  'Coupe': ['NNP'],
  'Couperin': ['NNP'],
  'Coupes': ['NNP'],
  'Couple': ['JJ'],
  'Coupled': ['VBN'],
  'Couples': ['NNS'],
  'Coupling': ['VBG'],
  'Coupon': ['NN'],
  'Coupons': ['NNS'],
  'Courant': ['NNP'],
  'Courbet': ['NNP'],
  'Courcy': ['NNP'],
  'Courier': ['NNP'],
  'Courier-Journal': ['NNP'],
  'Course': ['NNP'],
  'Courses': ['NNS'],
  'Court': ['NNP'],
  'Court-awarded': ['JJ'],
  'Court-packing': ['JJ'],
  'Courtaulds': ['NNP'],
  'Courtenay': ['NNP'],
  'Courter': ['NNP'],
  'Courter...': [':'],
  'Courthouse': ['NN'],
  'Courtier': ['NNP'],
  'Courtis': ['NNP'],
  'Courtney': ['NNP'],
  'Courtrai': ['NNP'],
  'Courts': ['NNPS'],
  'Cousin': ['NNP'],
  'Couturier': ['NNP'],
  'Couve': ['NNP'],
  'Covas': ['NNP'],
  'Cove': ['NNP'],
  'Covell': ['NNP'],
  'Covent': ['NNP'],
  'Coventry': ['NNP'],
  'Cover': ['NNP'],
  'Cover-Up': ['NNP'],
  'Coverage': ['NNP'],
  'Covered': ['JJ'],
  'Covering': ['NNP'],
  'Covert': ['NNP'],
  'Covey': ['NNP'],
  'Covia': ['NNP'],
  'Covington': ['NNP'],
  'Covitz': ['NNP'],
  'Cow': ['NNP'],
  'Cowan': ['NNP'],
  'Coward': ['NNP'],
  'Cowbird': ['NNP'],
  'Cowboy': ['NN'],
  'Cowboys': ['NNPS'],
  'Cowboys-owned': ['JJ'],
  'Cowen': ['NNP'],
  'Cowessett': ['NNP'],
  'Cowessett-East': ['NNP'],
  'Cowles': ['NNP'],
  'Cowley': ['NNP'],
  'Cowper': ['NNP'],
  'Cowrtiers': ['NNS'],
  'Cows': ['NNS'],
  'Cox': ['NNP'],
  'Coxon': ['NNP'],
  'Coykendall': ['NNP'],
  'Coyotes': ['NNS'],
  'Cozen': ['NNP'],
  'Cozumel': ['NNP'],
  'Cozying': ['VBG'],
  'Cr': ['NNP'],
  'Cr--spe': ['NNP'],
  'Crab': ['NNP'],
  'Crabb': ['NNP'],
  'Crabs': ['NNP'],
  'Crabtree': ['NNP'],
  'Crack': ['NN'],
  'Cracking': ['VBG'],
  'Cracklin': ['NNP'],
  'Craddock': ['NNP'],
  'Cradle': ['NNP'],
  'Craft': ['NN'],
  'Crafton-Preyer': ['NNP'],
  'Crafts': ['NNPS'],
  'Craftsmen': ['NNPS'],
  'Craig': ['NNP'],
  'Crain': ['NNP'],
  'Cralin': ['NNP'],
  'Cramer': ['NNP'],
  'Crampton': ['NNP'],
  'Crandall': ['NNP'],
  'Crane': ['NNP'],
  'Cranes': ['NNPS'],
  'Cranston': ['NNP'],
  'Cranston-D\'Amato': ['JJ'],
  'Cranston-Mitchell': ['NNP'],
  'Crary': ['NNP'],
  'Crash': ['NNP'],
  'Crashing': ['VBG'],
  'Craton': ['NNP'],
  'Cravath': ['NNP'],
  'Craven': ['NNP'],
  'Craving': ['VBG'],
  'Crawford': ['NNP'],
  'Crawford-Browne': ['NNP'],
  'Crawfordsville': ['NNP'],
  'Cray': ['NNP'],
  'Cray*/NNP-3': ['CD'],
  'Cray-3': ['NNP'],
  'Crazy': ['NNP'],
  'Cream': ['NNP'],
  'Creamer': ['NNP'],
  'Creamery': ['NNP'],
  'Creamette': ['NNP'],
  'Crean': ['NNP'],
  'Create': ['VB'],
  'Created': ['VBN'],
  'Creates': ['VBZ'],
  'Creating': ['VBG'],
  'Creation': ['NN'],
  'Creations': ['NNPS'],
  'Creative': ['NNP'],
  'Creator': ['NNP'],
  'Creators': ['NNS'],
  'Credibility': ['NN'],
  'Credietbank': ['NNP'],
  'Credit': ['NNP'],
  'Credit-Card': ['NN'],
  'Credit-card': ['NN'],
  'CreditWatch': ['NNP'],
  'Creditanstalt': ['NNP'],
  'Creditanstalt-Bankverein': ['NNP'],
  'Creditbank': ['NNP'],
  'Creditbanken': ['NNP'],
  'Credito': ['NNP'],
  'Creditor': ['NN'],
  'Creditors': ['NNS'],
  'Credo': ['NN'],
  'Cree': ['NNP'],
  'Creed': ['NNP'],
  'Creedon': ['NNP'],
  'Creek': ['NNP'],
  'Creek-Turn': ['JJ'],
  'Creepers': ['UH'],
  'Creighton': ['NNP'],
  'Creme': ['NNP'],
  'Cremonie': ['NNP'],
  'Creole': ['NNP'],
  'Creon': ['NNP'],
  'Crescent': ['NNP'],
  'Crescott': ['NNP'],
  'Cress': ['NNP'],
  'Cressidas': ['NNPS'],
  'Cresson': ['NNP'],
  'Cresswell': ['NNP'],
  'Crest': ['NNP'],
  'Crest-Colgate': ['JJ'],
  'Crested': ['NNP'],
  'Crestmont': ['NNP'],
  'Creston': ['NNP'],
  'Creswell': ['NNP'],
  'Cretaceous': ['NNP'],
  'Crete': ['NNP'],
  'Creusot': ['NNP'],
  'Crew': ['NN'],
  'Crewmembers': ['NNP'],
  'Crews': ['NNP'],
  'Cricket': ['NNP'],
  'Cried': ['VBD'],
  'Crier': ['NNP'],
  'Crime': ['NN'],
  'Crimea': ['NNP'],
  'Crimean': ['NNP'],
  'Crimes': ['NNP'],
  'Criminal': ['NNP'],
  'Criminal-defense': ['NN'],
  'Criminalization': ['NN'],
  'Criminals': ['NNS'],
  'Criminologists': ['NNS'],
  'Crip': ['NNP'],
  'Crippled': ['NNP'],
  'Crippling': ['JJ'],
  'Cris': ['NNP'],
  'Crisanti': ['NNP'],
  'Crisco': ['NNP'],
  'Crises': ['NNS'],
  'Crisis': ['NNP'],
  'Crisman': ['NNP'],
  'Crisp': ['NNP'],
  'Crispin': ['NNP'],
  'Cristal': ['NNP'],
  'Cristiani': ['NNP'],
  'Cristini': ['NNP'],
  'Cristo': ['NNP'],
  'Criteria': ['NNP'],
  'Criterion': ['NNP'],
  'Critic': ['NNP'],
  'Critical': ['NNP'],
  'Criticality': ['NN'],
  'Critically': ['RB'],
  'Criticism': ['NN'],
  'Criticisms': ['NNP'],
  'Critics': ['NNS'],
  'Crittenden': ['NNP'],
  'Croasdale': ['NNP'],
  'Crobsy': ['NNP'],
  'Crockett': ['NNP'],
  'Crocodile': ['NNP'],
  'Croissier': ['NNP'],
  'Croix': ['NNP'],
  'Croma': ['NNP'],
  'Crombie': ['NNP'],
  'Cromwell': ['NNP'],
  'Cromwellian': ['JJ'],
  'Cronin': ['NNP'],
  'Cronkite': ['NNP'],
  'Crooked': ['JJ'],
  'Croom-Helm': ['NNP'],
  'Croonen': ['NNP'],
  'Crop': ['NNP'],
  'Crosbie': ['NNP'],
  'Crosby': ['NNP'],
  'Crosbys': ['NNPS'],
  'Crosfield': ['NNP'],
  'Cross': ['NNP'],
  'Cross-Purposes': ['NNPS'],
  'Cross-border': ['JJ'],
  'Cross-margining': ['NN'],
  'Crossair': ['NNP'],
  'Crosse': ['NNP'],
  'Crosser': ['NNP'],
  'Crossfire': ['NNP'],
  'Crossing': ['VBG'],
  'Crossland': ['NNP'],
  'Crossman': ['NNP'],
  'Crosson': ['NNP'],
  'Crotale': ['JJ'],
  'Crouch': ['NNP'],
  'Crouched': ['VBN'],
  'Crovitz': ['NNP'],
  'Crow': ['NNP'],
  'Crowd': ['NNP'],
  'Crowder': ['NNP'],
  'Crowds': ['NNS'],
  'Crowe': ['NNP'],
  'Crowell': ['NNP'],
  'Crowley': ['NNP'],
  'Crown': ['NNP'],
  'Crowntuft': ['NNP'],
  'Crows': ['NNPS'],
  'Croydon': ['NNP'],
  'Crozier': ['NNP'],
  'Cru': ['NNP'],
  'Crucial': ['JJ'],
  'Crucians': ['NNPS'],
  'Crucible': ['NNP'],
  'Crude': ['JJ'],
  'Crude-goods': ['NNS'],
  'Cruel': ['JJ'],
  'Cruelty': ['NNP'],
  'Cruger': ['NNP'],
  'Cruickshank': ['NNP'],
  'Cruise': ['NNP'],
  'Cruiser': ['NNP'],
  'Crum': ['NNP'],
  'Crumb': ['NNP'],
  'Crumble': ['NNP'],
  'Crumley': ['NNP'],
  'Crumlish': ['NNP'],
  'Crump': ['NNP'],
  'Crunch': ['VB'],
  'Crupi': ['NNP'],
  'Crus': ['NNP'],
  'Crusade': ['NNP'],
  'Crusader': ['NNP'],
  'Crusaders': ['NNPS'],
  'Crusades': ['NNPS'],
  'Crush': ['NNP'],
  'Crutcher': ['NNP'],
  'Crutzen': ['NNP'],
  'Cruz': ['NNP'],
  'Cruzan': ['NNP'],
  'Cruze': ['NNP'],
  'Cry': ['NN'],
  'Cryptic': ['JJ'],
  'Crystal': ['NNP'],
  'Crystallographic': ['JJ'],
  'Crystallography': ['NNP'],
  'Csathy': ['NNP'],
  'Ct': ['NNP'],
  'Ct.': ['NNP'],
  'CuK': ['JJ'],
  'Cuatrecasas': ['NNP'],
  'Cuauhtemoc': ['NNP'],
  'Cub': ['NNP'],
  'Cuba': ['NNP'],
  'Cuban': ['JJ'],
  'Cuban-American': ['NNP'],
  'Cuban-assisted': ['JJ'],
  'Cubans': ['NNPS'],
  'Cube': ['NNP'],
  'Cubism': ['NN'],
  'Cubist': ['NN'],
  'Cubs': ['NNPS'],
  'Cucamonga': ['NNP'],
  'Cuckoo': ['NN'],
  'Cudahy': ['NNP'],
  'Cuddeford': ['NNP'],
  'Cuddihy': ['NNP'],
  'Cuddleback': ['NNP'],
  'Cuddles': ['NNP'],
  'Cudkowicz': ['NNP'],
  'Cudmore': ['NNP'],
  'Cuellar': ['NNP'],
  'Cuisinart': ['NNP'],
  'Cuisinarts': ['NNPS'],
  'Cuisine': ['NNP'],
  'Cujo': ['NNP'],
  'Culbertson': ['NNP'],
  'Culkin': ['NNP'],
  'Cullen\\\'/Frost': ['NNP'],
  'Culligan': ['NNP'],
  'Cullinet': ['NNP'],
  'Cullowhee': ['NNP'],
  'Culmone': ['NNP'],
  'Culp': ['NNP'],
  'Cult': ['NNP'],
  'Cultor': ['NNP'],
  'Cultural': ['NNP'],
  'Culturally': ['RB'],
  'Culture': ['NNP'],
  'Cultures': ['NNS'],
  'Culver': ['NNP'],
  'Culvers': ['NNPS'],
  'Cumbancheros': ['NNP'],
  'Cumberland': ['NNP'],
  'Cumhuriyet': ['NNP'],
  'Cummings': ['NNP'],
  'Cummins': ['NNP'],
  'Cumulative': ['JJ'],
  'Cunard': ['NNP'],
  'Cuneo': ['NNP'],
  'Cunha': ['NNP'],
  'Cunin': ['NNP'],
  'Cunningham': ['NNP'],
  'Cuoco': ['NNP'],
  'Cuomo': ['NNP'],
  'Cup': ['NNP'],
  'Cup-Tote': ['NNP'],
  'Cupboard': ['NN'],
  'Cupertino': ['NNP'],
  'Cupply': ['NNP'],
  'Curacao': ['NNP'],
  'Curb': ['VB'],
  'Curcio': ['NNP'],
  'Curdling': ['NNP'],
  'Curia': ['NNP'],
  'Curiae': ['FW'],
  'Curie': ['NNP'],
  'Curie-Weiss': ['NNP'],
  'Curiosity': ['NN'],
  'Curious': ['JJ'],
  'Curiously': ['RB'],
  'Curl': ['NNP'],
  'Curley': ['NNP'],
  'Curling': ['NNP'],
  'Curly': ['JJ'],
  'Curragh': ['NNP'],
  'Curran': ['NNP'],
  'Currency': ['NN'],
  'Current': ['JJ'],
  'Currently': ['RB'],
  'Curriculum': ['NN'],
  'Currie': ['NNP'],
  'Currier': ['NNP'],
  'Curry': ['NNP'],
  'Currys': ['NNP'],
  'Cursed': ['VBN'],
  'Cursing': ['VBG'],
  'Curt': ['NNP'],
  'Curtain': ['NNP'],
  'Curteis': ['NNP'],
  'Curtin': ['NNP'],
  'Curtis': ['NNP'],
  'Curtiss': ['NNP'],
  'Curtiss-Wright': ['NNP'],
  'Cury': ['NNP'],
  'Curzio': ['NNP'],
  'Curzon': ['NNP'],
  'Cusa': ['NNP'],
  'Cushing': ['NNP'],
  'Cushman': ['NNP'],
  'Custer': ['NNP'],
  'Custodian': ['NNP'],
  'Custom': ['NNP'],
  'Customarily': ['RB'],
  'Customary': ['NNP'],
  'Customer': ['NN'],
  'Customer-access': ['NN'],
  'Customers': ['NNS'],
  'Customhouse': ['NNP'],
  'Customized': ['JJ'],
  'Customs': ['NNPS'],
  'Cut': ['VB'],
  'Cutbacks': ['NNP'],
  'Cutbush': ['NNP'],
  'Cutlass': ['NNP'],
  'Cutler': ['NNP'],
  'Cutrer': ['NNP'],
  'Cutrere': ['NNP'],
  'Cuts': ['NNS'],
  'Cutter': ['NNP'],
  'Cutting': ['VBG'],
  'Cutty': ['NNP'],
  'Cuyahoga': ['NNP'],
  'Cuyler': ['NNP'],
  'Cy': ['NNP'],
  'CyCare': ['NNP'],
  'Cyanamid': ['NNP'],
  'Cyanocitta': ['FW'],
  'Cyber': ['NNP'],
  'Cybex': ['NNP'],
  'Cybill': ['NNP'],
  'Cycads': ['NNS'],
  'Cyclades': ['NNS'],
  'Cycle': ['NNP'],
  'Cycling': ['NNP'],
  'Cyclone': ['NNP'],
  'Cycly': ['NNP'],
  'Cyd': ['NNP'],
  'Cydonia': ['NNP'],
  'Cygne': ['NNP'],
  'Cygnus': ['NNP'],
  'Cylinder': ['NN'],
  'Cynewulf': ['NNP'],
  'Cynical': ['JJ'],
  'Cynthia': ['NNP'],
  'Cynwyd': ['NNP'],
  'Cyoctol': ['NNP'],
  'Cypress': ['NNP'],
  'Cyprian': ['NNP'],
  'Cyprus': ['NNP'],
  'Cyr': ['NNP'],
  'Cyriac': ['NNP'],
  'Cyril': ['NNP'],
  'Cyrus': ['NNP'],
  'Cytel': ['NNP'],
  'Cytogen': ['NNP'],
  'Czar': ['NNP'],
  'Czarina': ['NNP'],
  'Czarship': ['NNP'],
  'Czech': ['JJ'],
  'Czechoslovak': ['JJ'],
  'Czechoslovak-made': ['JJ'],
  'Czechoslovakia': ['NNP'],
  'Czechoslovaks': ['NNPS'],
  'Czechs': ['NNPS'],
  'Czerny': ['NNP'],
  'Czeslaw': ['NNP'],
  'Czestochwa': ['NNP'],
  'D': ['NN'],
  'D&B': ['NNP'],
  'D&H': ['NNP'],
  'D\'Agostino': ['NNP'],
  'D\'Agosto': ['NNP'],
  'D\'Albert': ['NNP'],
  'D\'Amato': ['NNP'],
  'D\'Amico': ['NNP'],
  'D\'Amours': ['NNP'],
  'D\'Ancona': ['NNP'],
  'D\'Arcy': ['NNP'],
  'D\'Argent': ['NNP'],
  'D\'Arlay': ['NNP'],
  'D\'Art': ['NNP'],
  'D\'Artaguette': ['NNP'],
  'D\'Aumont': ['NNP'],
  'D\'Urbervilles': ['NNP'],
  'D*': ['NNP'],
  'D*/NNP&B': ['NN'],
  'D-5': ['NNP'],
  'D-Mass.': ['NNP'],
  'D-marks': ['NNS'],
  'D-night': ['NN'],
  'D.': ['NNP'],
  'D.,Calif': ['NNP'],
  'D.,Calif.': ['NN'],
  'D.,Texas': ['NNS'],
  'D.A.': ['NNP'],
  'D.C': ['NNP'],
  'D.C.': ['NNP'],
  'D.C.-based': ['JJ'],
  'D.D.': ['NNP'],
  'D.D.S.': ['NNP'],
  'D.H.': ['NNP'],
  'D.J.': ['NNP'],
  'D.K': ['NNP'],
  'D.K.': ['NNP'],
  'D.L.': ['NNP'],
  'D.N.': ['NNP'],
  'D.O.A.': ['JJ'],
  'D.S.': ['NNP'],
  'D.T.': ['NNP'],
  'D.W.': ['NNP'],
  'D.s': ['NNPS'],
  'D/NNP.A.': ['NN'],
  'D2': ['NN'],
  'D8': ['CD'],
  'DA': ['NN'],
  'DAF': ['NNP'],
  'DALIS': ['NNPS'],
  'DALKON': ['NNP'],
  'DALLAS': ['NNP'],
  'DAMAGES': ['NNS'],
  'DANIEL': ['NNP'],
  'DARMAN\'S': ['NNP'],
  'DARPA': ['NNP'],
  'DAT': ['NNP'],
  'DATA': ['NNP'],
  'DAWDLING': ['NN'],
  'DAX': ['NNP'],
  'DAY': ['NNP'],
  'DAYAC': ['NNP'],
  'DAYTON': ['NNP'],
  'DB2': ['CD'],
  'DBC': ['NNP'],
  'DBL': ['NNP'],
  'DBS': ['NNP'],
  'DC': ['NN'],
  'DC-10': ['NNP'],
  'DC-10s': ['NNPS'],
  'DC-8-62': ['NN'],
  'DC-9': ['JJ'],
  'DC10-30': ['NN'],
  'DD': ['NNP'],
  'DDB': ['NNP'],
  'DDG-51': ['NNP'],
  'DDI': ['NNP'],
  'DDR': ['NNP'],
  'DDT': ['NNP'],
  'DE': ['NNP'],
  'DEA': ['NNP'],
  'DEAE': ['NNP'],
  'DEAE-cellulose': ['NNP'],
  'DEAE-cellulose-treated': ['NN'],
  'DEAL': ['NNP'],
  'DEALERS': ['NNPS'],
  'DEBT': ['NN'],
  'DEC': ['NNP'],
  'DECstation': ['NNP'],
  'DEFECT': ['VBP'],
  'DEFECTOR': ['NN'],
  'DEFENSE': ['NN'],
  'DEFERRED': ['JJ'],
  'DEFICIT': ['NNP'],
  'DELAYED': ['VBN'],
  'DELAYS': ['VBZ'],
  'DELIGHT': ['VBP'],
  'DEMAND': ['NN'],
  'DEMOCRATS': ['NNS'],
  'DEPARTMENT': ['NNP'],
  'DEPOSIT': ['NN'],
  'DES': ['NNP'],
  'DESIGNATING': ['VBG'],
  'DESPITE': ['IN'],
  'DEVELOPMENT': ['NNP'],
  'DEVELOPMENTS': ['NNPS'],
  'DEVICES': ['NNP'],
  'DFC': ['NNP'],
  'DFS\\\'/Pacific': ['NNP'],
  'DG': ['NNP'],
  'DGAULT': ['NNP'],
  'DGII': ['NNP'],
  'DHAWK': ['NNP'],
  'DHL': ['NNP'],
  'DIAL-A-PIANO-LESSON': ['NNP'],
  'DIALING': ['VBG'],
  'DIAPER': ['NN'],
  'DIASONICS': ['NNP'],
  'DID': ['VB'],
  'DIED': ['VBD'],
  'DIET': ['NNP'],
  'DIFFERENCE': ['NNP'],
  'DIG': ['NNP'],
  'DIGITAL': ['NNP'],
  'DIGS': ['NNS'],
  'DILLARD': ['NNP'],
  'DIOCS': ['NN'],
  'DIRECTORS': ['NNS'],
  'DIRECTORY': ['NN'],
  'DISAPPOINTMENTS': ['NNS'],
  'DISASTER': ['NN'],
  'DISCIPLINARY': ['NN'],
  'DISCOUNT': ['NN'],
  'DISNEY': ['NNP'],
  'DISPLAYED': ['VBD'],
  'DISTRESSFUL': ['JJ'],
  'DISTRICT': ['JJ'],
  'DJ': ['NNP'],
  'DJIA': ['NNP'],
  'DJS': ['NNP'],
  'DJS-Inverness': ['NNP'],
  'DJS\\\'/Inverness': ['NNP'],
  'DKB': ['NNP'],
  'DKNY': ['NNP'],
  'DLC': ['NNP'],
  'DLINE': ['NN'],
  'DLJ': ['NNP'],
  'DLX': ['NNP'],
  'DM': ['VB'],
  'DM1,200': ['CD'],
  'DM10,000': ['CD'],
  'DM100': ['CD'],
  'DM2,000': ['CD'],
  'DM2,300': ['CD'],
  'DM2,800': ['CD'],
  'DM200': ['CD'],
  'DM235': ['CD'],
  'DM3,500': ['CD'],
  'DM33': ['CD'],
  'DM5,000': ['CD'],
  'DM6,000': ['CD'],
  'DM7,000': ['CD'],
  'DM850-a-month': ['JJ'],
  'DMB&B\\\'/International': ['JJ'],
  'DMB&B\\\'/New': ['NNP'],
  'DNA': ['NNP'],
  'DNX': ['NNP'],
  'DO': ['VB'],
  'DOC-IN-A-BOX': ['NNP'],
  'DOCTORS': ['NNS'],
  'DOE': ['NNP'],
  'DOE-site': ['NN'],
  'DOG': ['NN'],
  'DOGS': ['NNS'],
  'DOLLAR': ['NN'],
  'DOLLAR\'S': ['NN'],
  'DOLLARS': ['NNPS'],
  'DON\'T': ['NNP'],
  'DONORS': ['NNS'],
  'DONT': ['VB'],
  'DOONESBURY': ['NNP'],
  'DOORS': ['NNS'],
  'DOS': ['NNP'],
  'DOT': ['NNP'],
  'DOW': ['NNP'],
  'DOWN': ['RB'],
  'DOWNEY': ['NNP'],
  'DOWNLOAD': ['VB'],
  'DOWNSIZING': ['NN'],
  'DPC': ['NNP'],
  'DPL': ['NNP'],
  'DPS': ['NNP'],
  'DPT': ['NNP'],
  'DPW': ['NNP'],
  'DPX\\\'': ['NNP'],
  'DRACULA\'S': ['NNP', 'VBZ'],
  'DRAM': ['NNP'],
  'DRAMs': ['NNS'],
  'DRDW': ['NN'],
  'DREXEL': ['NNP'],
  'DREYER\'S': ['NNP'],
  'DRG': ['NNP'],
  'DRI': ['NNP'],
  'DRILLING': ['NN'],
  'DRI\\\'/McGraw': ['NNP'],
  'DRI\\\'/McGraw-Hill': ['NNP'],
  'DRUG': ['NN'],
  'DRUGS': ['NNPS'],
  'DSG': ['NNP'],
  'DSL': ['NNP'],
  'DSM': ['NNP'],
  'DSP': ['NNP'],
  'DSW': ['NN'],
  'DTF': ['NN'],
  'DTH': ['NNP'],
  'DU': ['NNP'],
  'DUF': ['NN'],
  'DUN': ['NNP'],
  'DWG': ['NNP'],
  'DX': ['NNP'],
  'Da': ['NNP'],
  'Da-da-da-dum': ['JJ'],
  'DaPuzzo': ['NNP'],
  'Dabbling': ['VBG'],
  'Daberko': ['NNP'],
  'Dabney': ['NNP'],
  'Dachshund': ['NN'],
  'Dactyls': ['NNPS'],
  'Dad': ['NNP'],
  'Dada': ['NNP'],
  'Dadaism': ['NNP'],
  'Daddy': ['NNP'],
  'Dade': ['NNP'],
  'Dads': ['NNP'],
  'Dae': ['NNP'],
  'Daer': ['NNP'],
  'Daewoo': ['NNP'],
  'Daffynition': ['NN'],
  'Dag': ['NNP'],
  'Dagens': ['NNP'],
  'Daggs': ['NNP'],
  'Dahl': ['NNP'],
  'Dahlen': ['NNP'],
  'Dahlia': ['NNP'],
  'Dahmane': ['NNP'],
  'Dai': ['NNP'],
  'Dai-Ichi': ['NNP'],
  'Dai-Ichi\\\'/Nippon': ['NNP'],
  'Dai-Tokyo': ['NNP'],
  'Dai-ichi': ['NNP'],
  'DaiIchi': ['NNP'],
  'Daiei': ['NNP'],
  'Daignault': ['NNP'],
  'Daihatsu': ['NNP'],
  'Daikin': ['NNP'],
  'Dailey': ['NNP'],
  'Daily': ['NNP'],
  'Daim': ['NNP'],
  'Daimler': ['NNP'],
  'Daimler-Benz': ['NNP'],
  'Dain': ['NNP'],
  'Dain-sponsored': ['JJ'],
  'Dainippon': ['NNP'],
  'Dairies': ['NNPS'],
  'Dairl': ['NNP'],
  'Dairy': ['NNP'],
  'Dairymen': ['NNP'],
  'Daisy': ['NNP'],
  'Daisy-Cadnetix': ['NNP'],
  'Daiwa': ['NNP'],
  'Dak': ['NNP'],
  'Dak.': ['NNP'],
  'Dakin': ['NNP'],
  'Dakota': ['NNP'],
  'Dakotas': ['NNPS'],
  'Dalai': ['NNP'],
  'Dalbar': ['NNP'],
  'Dale': ['NNP'],
  'Daley': ['NNP'],
  'Dalfen': ['NNP'],
  'Dalgety': ['NNP'],
  'Dali': ['NNP'],
  'Dali-esque': ['JJ'],
  'Dalian': ['NNP'],
  'Dalkon': ['NNP'],
  'Dallara': ['NNP'],
  'Dallas': ['NNP'],
  'Dallas-Barcelona': ['NNP'],
  'Dallas-Fort': ['NNP'],
  'Dallas-based': ['JJ'],
  'Dallas-headquartered': ['JJ'],
  'Dallasites': ['NNPS'],
  'Dalldorf': ['NNP'],
  'Dalles': ['NNP'],
  'Dalloway': ['NNP'],
  'Dalrymple': ['NNP'],
  'Dalton': ['NNP'],
  'Daly': ['NNP'],
  'Dalzell-Cousin': ['NNP'],
  'Damage': ['NN'],
  'Damages': ['NNS'],
  'Damas': ['NNP'],
  'Damascus': ['NNP'],
  'Dame': ['NNP'],
  'Dame-Michigan': ['NNP'],
  'Dames': ['NNPS'],
  'Damian': ['NNP'],
  'Dammit': ['UH'],
  'Damn': ['VB'],
  'Damned': ['JJ'],
  'Damon': ['NNP'],
  'Damonne': ['NNP'],
  'Damp': ['JJ'],
  'Dams': ['NNS'],
  'Dan': ['NNP'],
  'Dan\'l': ['NNP'],
  'Dana': ['NNP'],
  'Dana-Farber': ['NNP'],
  'Danaher': ['NNP'],
  'Danbury': ['NNP'],
  'Dance': ['NNP'],
  'Dancer': ['NNP'],
  'Dancers': ['NNP'],
  'Dances': ['NNS'],
  'Danchin': ['NNP'],
  'Dancing': ['NN'],
  'Danco': ['NNP'],
  'Dandy': ['NNP'],
  'Dane': ['NNP'],
  'Danehy': ['NNP'],
  'Danes': ['NNPS'],
  'Danforth': ['NNP'],
  'Dang': ['NNP'],
  'Danger': ['NNP'],
  'Dangerous': ['JJ'],
  'Dangers': ['NNS'],
  'Dangling': ['VBG'],
  'Daniel': ['NNP'],
  'Daniele': ['NNP'],
  'Danieli': ['NNP'],
  'Daniels': ['NNP'],
  'Daniil': ['NNP'],
  'Danilo': ['NNP'],
  'Danilow': ['NNP'],
  'Danis': ['NNP'],
  'Danish': ['JJ'],
  'Danish-American': ['NNP'],
  'Dannehower': ['NNP'],
  'Dannemiller': ['NNP'],
  'Danny': ['NNP'],
  'Danske': ['NNP'],
  'Danssesse': ['NNP'],
  'Dantchik': ['NNP'],
  'Dante': ['NNP'],
  'Danube': ['NNP'],
  'Danubian': ['JJ'],
  'Danvers': ['NNP'],
  'Danville': ['NNP'],
  'Danza': ['NNP'],
  'Danzig': ['NNP'],
  'Daolet': ['NNP'],
  'Daphne': ['NNP'],
  'Dappertutto': ['NNP'],
  'Darak': ['NNP'],
  'Daralee': ['NNP'],
  'Darby': ['NNP'],
  'Darcy': ['NNP'],
  'Dardalla': ['NNP'],
  'Dare': ['VB'],
  'Dare-Base': ['NNP'],
  'Daremblum': ['NNP'],
  'Dares': ['NNP'],
  'Dargene': ['NNP'],
  'Darien': ['NNP'],
  'Darin': ['NNP'],
  'Darius': ['NNP'],
  'Dark': ['NNP'],
  'Darkhorse': ['NNP'],
  'Darkling': ['NNP'],
  'Darkness': ['NN'],
  'Darla': ['NNP'],
  'Darlene': ['NNP'],
  'Darlin': ['NNP'],
  'Darling': ['NNP'],
  'Darlington': ['NNP'],
  'Darlow': ['NNP'],
  'Darman': ['NNP'],
  'Darn': ['VB'],
  'Darnell': ['NNP'],
  'Darrell': ['NNP'],
  'Darrow': ['NNP'],
  'Darryl': ['NNP'],
  'Dart': ['NNP'],
  'Dartboard': ['NN'],
  'Darth': ['NNP'],
  'Dartmouth': ['NNP'],
  'Darvocet-N': ['NNP'],
  'Darvon': ['NNP'],
  'Darwen': ['NNP'],
  'Darwin': ['NNP'],
  'Darwinian': ['JJ'],
  'Darwinism': ['NNP'],
  'Das': ['NNP'],
  'Daschle': ['NNP'],
  'Dash': ['NNP'],
  'Dasher': ['NNP'],
  'Dashiell': ['NNP'],
  'Dashitchev': ['NNP'],
  'Dashwood': ['NNP'],
  'Dasibi': ['NNP'],
  'Dass': ['FW'],
  'Dassault': ['NNP'],
  'Dassault-Breguet': ['NNP'],
  'Data': ['NNP'],
  'Data-destroying': ['JJ'],
  'DataComm': ['NNP'],
  'DataPlan': ['NNP'],
  'DataQuest': ['NNP'],
  'DataTimes': ['NNP'],
  'Datacomputer': ['NNP'],
  'Datacrime': ['NNP'],
  'Datafleet': ['NNP'],
  'Datapoint': ['NNP'],
  'Dataproducts': ['NNP'],
  'Dataquest': ['NNP'],
  'Datas': ['NNP'],
  'Datastream': ['NNP'],
  'Datatech': ['NNP'],
  'Datatronic': ['NNP'],
  'Date': ['NN'],
  'Dating': ['NNP'],
  'Datson': ['NNP'],
  'Datsun': ['NNP'],
  'Datsuns': ['NNPS'],
  'Datuk': ['NNP'],
  'Dauchy': ['NNP'],
  'Daugherty': ['NNP'],
  'Daughter': ['NN'],
  'Dauntless': ['NNP'],
  'Dauphin': ['NNP'],
  'Dauphine': ['NNP'],
  'Dauster': ['NNP'],
  'Davao': ['NNP'],
  'Dave': ['NNP'],
  'Davenport': ['NNP'],
  'David': ['NNP'],
  'David-Weill': ['NNP'],
  'Davidge': ['NNP'],
  'Davidow': ['NNP'],
  'Davidowitz': ['NNP'],
  'Davidowitz.': ['NNP'],
  'Davids': ['NNP'],
  'Davidson': ['NNP'],
  'Davies': ['NNP'],
  'Davila': ['NNP'],
  'Davis': ['NNP'],
  'Davis\\\'/Zweig': ['NNP'],
  'Davises': ['NNPS'],
  'Davison': ['NNP'],
  'Davy': ['NNP'],
  'Dawkins': ['NNP'],
  'Dawn': ['NNP'],
  'Dawson': ['NNP'],
  'Dax-Pontonx': ['NNP'],
  'Day': ['NNP'],
  'Day-to-day': ['JJ'],
  'Dayan': ['NNP'],
  'Daybreak': ['NNP'],
  'Daylight': ['NNP'],
  'Dayna': ['NNP'],
  'Days': ['NNP'],
  'Daytime': ['NNP'],
  'Dayton': ['NNP'],
  'Daytona': ['NNP'],
  'Daytonas': ['NNP'],
  'Daywatch': ['NNP'],
  'Daze': ['NNP'],
  'Dazed': ['JJ'],
  'De': ['NNP'],
  'De-Kooning': ['NNP'],
  'DeBakey': ['NNP'],
  'DeBartolo': ['NNP'],
  'DeBat': ['NNP'],
  'DeBeauvoir': ['NNP'],
  'DeCicco': ['NNP'],
  'DeConcini': ['NNP'],
  'DeFazio': ['NNP'],
  'DeForest': ['NNP'],
  'DeGeurin': ['NNP'],
  'DeGol': ['NNP'],
  'DeGregorio': ['NNP'],
  'DeGroot': ['NNP'],
  'DeHaviland': ['NNP'],
  'DeKalb': ['NNP'],
  'DeLay': ['NNP'],
  'DeLuca': ['NNP'],
  'DeMar': ['NNP'],
  'DeMeo': ['NNP'],
  'DeMontez': ['NNP'],
  'DeMoss': ['NNP'],
  'DeMoulin': ['NNP'],
  'DeMunn': ['NNP'],
  'DeMyer': ['NNP'],
  'DePaul': ['NNP'],
  'DePauw': ['NNP'],
  'DePugh': ['NNP'],
  'DeRita': ['NNP'],
  'DeScenza': ['NNP'],
  'DeShano': ['NNP'],
  'DeSio': ['NNP'],
  'DeSoto': ['NNP'],
  'DeTomaso': ['NNP'],
  'DeVillars': ['NNP'],
  'DeVille': ['NNP'],
  'DeVoe': ['NNP'],
  'DeVon': ['NNP'],
  'DeVos': ['NNP'],
  'DeVries': ['NNP'],
  'DeWalt': ['NNP'],
  'DeWitt': ['NNP'],
  'Deacon': ['NNP'],
  'Deaconess': ['NNP'],
  'Deacons': ['NNS'],
  'Deactivation': ['NN'],
  'Dead': ['NNP'],
  'Deadlock': ['NN'],
  'Deadly': ['JJ'],
  'Deadwood': ['NNP'],
  'Deaf': ['JJ'],
  'Deafening': ['VBG'],
  'Deak': ['NNP'],
  'Deal': ['NNP'],
  'Dealer': ['NNP'],
  'Dealers': ['NNS'],
  'Dealing': ['VBG'],
  'Deals': ['NNS'],
  'Dean': ['NNP'],
  'Deane': ['NNP'],
  'Deanna': ['NNP'],
  'Deans': ['NNP'],
  'Dear': ['NNP'],
  'Dearborn': ['NNP'],
  'Deardorff': ['NNP'],
  'Dearie': ['NNP'],
  'Dearly': ['RB'],
  'Death': ['NN'],
  'Death\'s-Head': ['NNP'],
  'Deatherage': ['NNP'],
  'Deaths': ['NNP'],
  'Deauville': ['NNP'],
  'Deaver': ['NNP'],
  'Deb': ['NNP'],
  'Debate': ['NN'],
  'Debates': ['NNS'],
  'Debating': ['NNP'],
  'Debban': ['NNP'],
  'Debbie': ['NNP'],
  'Debenture': ['NN'],
  'Debevoise': ['NNP'],
  'Debonnie': ['NNP'],
  'Debora': ['NNP'],
  'Deborah': ['NNP'],
  'Debra': ['NNP'],
  'Debt': ['NN'],
  'Debt-Burdened': ['JJ'],
  'Debt-free': ['JJ'],
  'Debts': ['NNP'],
  'Debugging': ['VBG'],
  'Debussy': ['NNP'],
  'Debutante': ['NNP'],
  'Dec': ['NNP'],
  'Dec.': ['NNP'],
  'Decades': ['NNS'],
  'Decanting': ['VBG'],
  'Decathlon': ['NNP'],
  'Decatur': ['NNP'],
  'Decay': ['NNP'],
  'Decca': ['NNP'],
  'December': ['NNP'],
  'Decent': ['JJ'],
  'Decentralization': ['NN'],
  'Decide': ['VB'],
  'Deciding': ['VBG'],
  'Decimalists': ['NNPS'],
  'Decimus': ['NNP'],
  'Decision': ['NNP'],
  'Decisionline': ['NNP'],
  'Decisions': ['NNS'],
  'Deck': ['NNP'],
  'Decker': ['NNP'],
  'Declan': ['NNP'],
  'Declaration': ['NNP'],
  'Declarative': ['JJ'],
  'Declares': ['VBZ'],
  'Declaring': ['VBG'],
  'Declinations': ['NNS'],
  'Decline': ['NN'],
  'Decliners': ['NNS'],
  'Declines': ['NNS'],
  'Declining': ['VBG'],
  'Decoma': ['NNP'],
  'Decorated': ['VBN'],
  'Decorating': ['VBG'],
  'Decorators': ['NNP'],
  'Decreasing': ['VBG'],
  'Decries': ['VBZ'],
  'Decrying': ['VBG'],
  'Dederick': ['NNP'],
  'Dedham': ['NNP'],
  'Dedication': ['NN'],
  'Deductible': ['JJ'],
  'Deducting': ['VBG'],
  'Deduction': ['NN'],
  'Deductions': ['NNS'],
  'Dee': ['NNP'],
  'Deed': ['NNP'],
  'Deegan': ['NNP'],
  'Deemed': ['VBN'],
  'Deep': ['NNP'],
  'Deepak': ['NNP'],
  'Deeper': ['JJR'],
  'Deeply': ['RB'],
  'Deer': ['NNP'],
  'Deere': ['NNP'],
  'Deerfield': ['NNP'],
  'Deering': ['NNP'],
  'Deerstalker': ['NN'],
  'Dees': ['NNP'],
  'Deets': ['NNP'],
  'Def': ['NNP'],
  'Defamation': ['NNP'],
  'Default': ['NNP'],
  'Defaults': ['NNS'],
  'Defeat': ['NNP'],
  'Defect': ['NN'],
  'Defections': ['NNS'],
  'Defectors': ['NNS'],
  'Defects': ['NNPS'],
  'Defence': ['NN'],
  'Defendant': ['NN'],
  'Defendants': ['NNS'],
  'Defenders': ['NNS'],
  'Defending': ['VBG'],
  'Defends': ['NNS'],
  'Defense': ['NNP'],
  'Defensive': ['JJ'],
  'Deficiency': ['NNP'],
  'Deficit': ['NNP'],
  'Define': ['VB'],
  'Defining': ['VBG'],
  'Definite': ['JJ'],
  'Definitely': ['RB'],
  'Definition': ['NN'],
  'Definitive': ['JJ'],
  'Defoe': ['NNP'],
  'Defrost': ['VB'],
  'Defuse': ['VB'],
  'Defying': ['VBG'],
  'Degas': ['NNP'],
  'Degree': ['NN'],
  'Dehmelt': ['NNP'],
  'Dei': ['NNP'],
  'Deidre': ['NNP'],
  'Deity': ['NN'],
  'Del': ['NNP'],
  'Del.': ['NNP'],
  'Del.-based': ['JJ'],
  'Delacre': ['NNP'],
  'Delahanty': ['NNP'],
  'Delamuraz': ['NNP'],
  'Delancy': ['NNP'],
  'Deland': ['NNP'],
  'Delaney': ['NNP'],
  'Delano': ['NNP'],
  'Delaunay': ['NNP'],
  'Delaware': ['NNP'],
  'Delaware-based': ['JJ'],
  'Delawareans': ['NNPS'],
  'Delawares': ['NNS'],
  'Delay': ['NNP'],
  'Delayed': ['JJ'],
  'Delays': ['NNS'],
  'Delbert': ['NNP'],
  'Delbridge': ['NNP'],
  'Delchamps': ['NNP'],
  'Delco': ['NNP'],
  'Deleage': ['NNP'],
  'Delegate': ['NNP'],
  'Delegates': ['NNPS'],
  'Delegation': ['NNP'],
  'Delegations': ['NNS'],
  'Delfim': ['NNP'],
  'Delhi': ['NNP'],
  'Deli': ['NNP'],
  'Delia': ['NNP'],
  'Deliberately': ['RB'],
  'Deliberations': ['NNP'],
  'Delicious': ['NNP'],
  'Delight': ['NNP'],
  'Delinquency': ['NNP'],
  'Delio': ['NNP'],
  'Delius': ['NNP'],
  'Deliver': ['VB'],
  'Deliveries': ['NNS'],
  'Delivery': ['NN'],
  'Dell': ['NNP'],
  'Dell\'Arca': ['NNP'],
  'Della': ['NNP'],
  'Deller': ['NNP'],
  'Delloye': ['NNP'],
  'Dells': ['NNP'],
  'Dellums': ['NNP'],
  'Dellwood': ['NNP'],
  'Delmed': ['NNP'],
  'Delmont': ['NNP'],
  'Delmore': ['NNP'],
  'Deloitte': ['NNP'],
  'Deloitte-Touche': ['NNP'],
  'Delon': ['NNP'],
  'Deloris': ['NNP'],
  'Delors': ['NNP'],
  'Delphi': ['NNP'],
  'Delphine': ['NNP'],
  'Delray': ['NNP'],
  'Delta': ['NNP'],
  'Deltacorp': ['NNP'],
  'Deltec': ['NNP'],
  'Deluge': ['NN'],
  'Deluged': ['VBN'],
  'Delusion': ['NNP'],
  'Deluxe': ['NNP'],
  'Delvin': ['NNP'],
  'Delving': ['VBG'],
  'Delwin': ['NNP'],
  'Demagogues': ['NNS'],
  'Demand': ['NN'],
  'Demanded': ['VBD'],
  'Demanding': ['VBG'],
  'Demands': ['NNS'],
  'Demented': ['JJ'],
  'Demery': ['NNP'],
  'Demetrius': ['NNP'],
  'Demi': ['NNP'],
  'Deminex': ['NNP'],
  'Demisch': ['NNP'],
  'Demler': ['NNP'],
  'Demme': ['NNP'],
  'Democracy': ['NNP'],
  'Democrat': ['NNP'],
  'Democratic': ['JJ'],
  'Democratic-controlled': ['JJ'],
  'Democratic-endorsed': ['JJ'],
  'Democratic-led': ['JJ'],
  'Democratic-sounding': ['JJ'],
  'Democratic-sponsored': ['JJ'],
  'Democratic-style': ['JJ'],
  'Democratique': ['NNP'],
  'Democratization': ['NN'],
  'Democrats': ['NNPS'],
  'Demodocus': ['NNP'],
  'Demographics': ['NNS'],
  'Demographie': ['NNP'],
  'Demoiselles': ['NNP'],
  'Demon': ['NNP'],
  'Demons': ['NNS'],
  'Demonstrating': ['VBG'],
  'Demonstrations': ['NNS'],
  'Dempsey': ['NNP'],
  'Demus-Schubert': ['NNP'],
  'Den': ['NNP'],
  'Denali': ['NNP'],
  'Denenchofu': ['NNP'],
  'Deng': ['NNP'],
  'Denials': ['NNS'],
  'Denied': ['VBN'],
  'Denis': ['NNP'],
  'Denise': ['NNP'],
  'Denison': ['NNP'],
  'Denizens': ['NNS'],
  'Denko': ['NNP'],
  'Denlea': ['NNP'],
  'Denman': ['NNP'],
  'Denmark': ['NNP'],
  'Dennehy': ['NNP'],
  'Dennis': ['NNP'],
  'Dennison': ['NNP'],
  'Denny': ['NNP'],
  'Deno': ['NNP'],
  'Denouncing': ['VBG'],
  'Denrees': ['NNP'],
  'Denshi': ['NNP'],
  'Densmore': ['NNP'],
  'Dent': ['NNP'],
  'Dental': ['NNP'],
  'Dentistry': ['NNP'],
  'Denton': ['NNP'],
  'Dentsu': ['NNP'],
  'Denver': ['NNP'],
  'Denver-area': ['NN'],
  'Denver-based': ['JJ'],
  'Denverite': ['NNP'],
  'Deo': ['NNP'],
  'Deor': ['NNP'],
  'Deparment': ['NNP'],
  'Departing': ['VBG'],
  'Department': ['NNP'],
  'Department-sponsored': ['JJ'],
  'Department-store': ['JJ'],
  'Departments': ['NNPS'],
  'Departmentstore': ['NNP'],
  'Departure': ['NN'],
  'Departures': ['NNP'],
  'Dependency': ['NNP'],
  'Dependent': ['NNP'],
  'Depending': ['VBG'],
  'Depew': ['NNP'],
  'Depicted': ['VBN'],
  'Depicting': ['VBG'],
  'Depictions': ['NNS'],
  'Depletions': ['NNS'],
  'Deployment': ['NNP'],
  'Deportees': ['NNS'],
  'Deposit': ['NNP'],
  'Depositary': ['NNP'],
  'Depositors': ['NNS'],
  'Depository': ['NNP'],
  'Deposits': ['NNS'],
  'Deposits-a': ['NNP'],
  'Depot': ['NNP'],
  'Deppy': ['NNP'],
  'Depression': ['NNP'],
  'Depression-era': ['JJ'],
  'Depressive': ['NNP'],
  'Dept.': ['NNP'],
  'Deputies': ['NNPS'],
  'Deputy': ['NNP'],
  'Dequindre': ['NNP'],
  'Der': ['NNP'],
  'Derails': ['NNS'],
  'Derby': ['NNP'],
  'Derchin': ['NNP'],
  'Derck': ['NNP'],
  'Deregulation': ['NN'],
  'Derek': ['NNP'],
  'Derel': ['NNP'],
  'Derivative': ['JJ'],
  'Deriving': ['VBG'],
  'Derr': ['NNP'],
  'Dershowitz': ['NNP'],
  'Dervish': ['NN'],
  'Derwin': ['NNP'],
  'Deryck': ['NNP'],
  'Des': ['NNP'],
  'DesRosiers': ['NNP'],
  'Desai': ['NNP'],
  'Desarrollo': ['NNP'],
  'Desc': ['NNP'],
  'Descartes': ['NNP'],
  'Descendants': ['NNS'],
  'Descending': ['VBG'],
  'Descent': ['NN'],
  'Describing': ['VBG'],
  'Description': ['NNP'],
  'Descriptive': ['JJ'],
  'Dese': ['NNP'],
  'Desegregation': ['NN'],
  'Deseret': ['NNP'],
  'Desert': ['NNP'],
  'Desheng': ['NNP'],
  'Design': ['NNP'],
  'Designated': ['NNP'],
  'Designcraft': ['NNP'],
  'Designed': ['VBN'],
  'Designer': ['NN'],
  'Designers': ['NNPS'],
  'Designing': ['NNP'],
  'Designs': ['NNS'],
  'Desir': ['NNP'],
  'Desire': ['NN'],
  'Desiring': ['VBG'],
  'Desk': ['NNP'],
  'Desktop': ['NNP'],
  'Deslonde': ['NNP'],
  'Desmond': ['NNP'],
  'Desolation': ['NNP'],
  'Despair': ['NN'],
  'Desperate': ['JJ'],
  'Desperately': ['RB'],
  'Despina': ['NNP'],
  'Despising': ['VBG'],
  'Despite': ['IN'],
  'Desprez': ['NNP'],
  'Desrosiers': ['NNP'],
  'Destec': ['NNP'],
  'Destinations': ['NNS'],
  'Destler': ['NNP'],
  'Destroy': ['NNP'],
  'Destroyer': ['NN'],
  'Destruction': ['NN'],
  'Detached': ['VBN'],
  'Detachment': ['NNP'],
  'Detail': ['NNP'],
  'Detailed': ['VBN'],
  'Details': ['NNS'],
  'Detecting': ['VBG'],
  'Detective': ['NNP'],
  'Detectives': ['NNP'],
  'Detente': ['NN'],
  'Detention': ['NNP'],
  'Detergent': ['NN'],
  'Deterioration': ['NN'],
  'Determine': ['VB'],
  'Determined': ['VBN'],
  'Determining': ['VBG'],
  'Deterrent': ['NN'],
  'Detractors': ['NNS'],
  'Detrex': ['NNP'],
  'Detroit': ['NNP'],
  'Detroit-area': ['JJ'],
  'Detroit-based': ['JJ'],
  'Detroit-over-San': ['JJ'],
  'Detroit-to-Tokyo': ['JJ'],
  'Detroiters': ['NNS'],
  'Deukmejian': ['NNP'],
  'Deus': ['FW'],
  'Deutsch': ['NNP'],
  'Deutsche': ['NNP'],
  'Devans': ['NNP'],
  'Devario': ['NNP'],
  'Devastation': ['NN'],
  'Devcon': ['NNP'],
  'Develop': ['VB'],
  'DevelopMate': ['NNP'],
  'Developed': ['VBN'],
  'Developer': ['NNP'],
  'Developers': ['NNS'],
  'Developing': ['VBG'],
  'Development': ['NNP'],
  'Developments': ['NNPS'],
  'Develops': ['NNPS'],
  'Devens': ['NNP'],
  'Dever': ['NNP'],
  'Devereux': ['NNP'],
  'Devery': ['NNP'],
  'Devesa': ['NNP'],
  'Devey': ['NNP'],
  'Device': ['NN'],
  'Devices': ['NNPS'],
  'Devil': ['NNP'],
  'Devils': ['NNPS'],
  'Devin': ['NNP'],
  'Devine': ['NNP'],
  'Devitt': ['NNP'],
  'Devlin': ['NNP'],
  'Devol': ['NNP'],
  'Devon': ['NNP'],
  'Devonshire': ['NNP'],
  'Devoted': ['VBN'],
  'Devotees': ['NNS'],
  'Devout': ['JJ'],
  'Dewar': ['NNP'],
  'Dewey': ['NNP'],
  'Dewhurst': ['NNP'],
  'Dexatrim': ['NNP'],
  'Dexedrine': ['NNP'],
  'Dexter': ['NNP'],
  'Dey': ['NNP'],
  'Deyo': ['NNP'],
  'Dhabi': ['NNP'],
  'Dharma': ['NNP'],
  'Dhofaris': ['NNPS'],
  'Dhuu': ['NNP'],
  'Di': ['NNP'],
  'DiCara': ['NNP'],
  'DiFilippo': ['NNP'],
  'DiGiorgio': ['NNP'],
  'DiIulio': ['NNP'],
  'DiLeo': ['NNP'],
  'DiLorenzo': ['NNP'],
  'DiLoreto': ['NNP'],
  'DiLuzio': ['NNP'],
  'DiMaggio': ['NNP'],
  'DiNardo': ['NNP'],
  'DiSimone': ['NNP'],
  'DiVall': ['NNP'],
  'DiVarco': ['NNP'],
  'Diabetes': ['NNP'],
  'Diabetic': ['NNP'],
  'Diaghileff': ['NNP'],
  'Diaghilev': ['NNP'],
  'Diagnoses': ['NNPS'],
  'Diagnosis': ['NNP'],
  'Diagnostic': ['NNP'],
  'Diagnostics': ['NNPS'],
  'Dial': ['NNP'],
  'Dialogue': ['NNP'],
  'Dialogues': ['NNP'],
  'Diamandis': ['NNP'],
  'Diamanti': ['NNP'],
  'Diametric': ['JJ'],
  'Diamond': ['NNP'],
  'Diamond-Star': ['NNP'],
  'Dian': ['NNP'],
  'Diana': ['NNP'],
  'Diane': ['NNP'],
  'Dianne': ['NNP'],
  'Diaper': ['NNP'],
  'Diario': ['NNP'],
  'Diary': ['NNP'],
  'Diasonics': ['NNP'],
  'Diaz': ['NNP'],
  'Dicarban': ['NN'],
  'Dice': ['NNS'],
  'Dicello': ['NNP'],
  'Diceon': ['NNP'],
  'Dick': ['NNP'],
  'Dicke': ['NNP'],
  'Dickel': ['NNP'],
  'Dickens': ['NNP'],
  'Dickensian': ['JJ'],
  'Dickey': ['NNP'],
  'Dickie': ['NNP'],
  'Dickinson': ['NNP'],
  'Dickman': ['NNP'],
  'Dicks': ['NNP'],
  'Dickson': ['NNP'],
  'Dictaphone': ['NNP'],
  'Dictates': ['NNS'],
  'Dictation': ['NN'],
  'Dictator': ['NNP'],
  'Dictionaries': ['NNS'],
  'Dictionary': ['NNP'],
  'Did': ['VBD'],
  'Did-': ['NNP'],
  'Didi': ['NNP'],
  'Didion': ['NNP'],
  'Die': ['NNP'],
  'Die-hard': ['JJ'],
  'DieHard': ['JJ'],
  'Diebel': ['NNP'],
  'Diebold': ['NNP'],
  'Died': ['VBD'],
  'Diefenbach': ['NNP'],
  'Diego': ['NNP'],
  'Diego-area': ['JJ'],
  'Diego-based': ['JJ'],
  'Diehards': ['NNS'],
  'Diehl': ['NNP'],
  'Diem': ['NNP'],
  'Dienbienphu': ['NNP'],
  'Dieppe': ['NNP'],
  'Dierker': ['NNP'],
  'Diery': ['NNP'],
  'Dies': ['NNP'],
  'Diesel': ['NNP'],
  'Diest': ['NNP'],
  'Diet': ['NNP'],
  'Dietary': ['JJ'],
  'Dieter': ['NNP'],
  'Dietetic': ['NNP'],
  'Diethylstilbestrol': ['NN'],
  'Dietisa': ['NNP'],
  'Dietrich': ['NNP'],
  'Diets': ['NNS'],
  'Diety': ['NNP'],
  'Dietz': ['NNP'],
  'Dietzer': ['NNP'],
  'Dieu': ['FW'],
  'Dieux': ['NNP'],
  'Diff': ['NN'],
  'Differ': ['VBP'],
  'Differences': ['NNS'],
  'Different': ['JJ'],
  'Differential': ['JJ'],
  'Difficult': ['JJ'],
  'Diffring': ['NNP'],
  'Dig': ['VB'],
  'Digate': ['NNP'],
  'Digby': ['NNP'],
  'Digest': ['NNP'],
  'Diggers\\\'/Noise': ['NNP'],
  'Digges': ['NNP'],
  'Digi': ['NNP'],
  'Digital': ['NNP'],
  'Dignitaries': ['NNS'],
  'Dignity': ['NNP'],
  'Dijon': ['NNP'],
  'Dilantin': ['NNP'],
  'Dilenschneider': ['NNP'],
  'Dili': ['NNP'],
  'Diligence': ['NNP'],
  'Dilip': ['NNP'],
  'Dill': ['NNP'],
  'Dillard': ['NNP'],
  'Diller': ['NNP'],
  'Dillinger': ['NNP'],
  'Dillingham': ['NNP'],
  'Dillmann': ['NNP'],
  'Dillon': ['NNP'],
  'Dillow': ['NNP'],
  'Dilly': ['NNP'],
  'Dilthey': ['NNP'],
  'Dilworth': ['NNP'],
  'Dilys': ['NNP'],
  'Dilzem': ['NNP'],
  'Dim': ['VBP'],
  'Dimaggio': ['NNP'],
  'Diman': ['NNP'],
  'Dime': ['NNP'],
  'Dimensions': ['NNP'],
  'Dimes': ['NNP'],
  'Dimitri': ['NNP'],
  'Dimitriadis': ['NNP'],
  'Dimitris': ['NNP'],
  'Dimly': ['RB'],
  'Dineen': ['NNP'],
  'Diners': ['NNP'],
  'Dinerstein': ['NNP'],
  'Dines': ['NNP'],
  'Ding': ['NNP'],
  'Dingell': ['NNP'],
  'Dingell-Waxman': ['NNP'],
  'Dingle': ['NNP'],
  'Dingman': ['NNP'],
  'Dingwall': ['NNP'],
  'Dingy-looking': ['JJ'],
  'Dinh': ['NNP'],
  'Dining': ['NNP'],
  'Dinkins': ['NNP'],
  'Dinner': ['NN'],
  'Dino': ['NNP'],
  'Dinosaur': ['NNP'],
  'Dinsa': ['NNP'],
  'Dinsmore': ['NNP'],
  'Diocesan': ['JJ'],
  'Diocese': ['NNP'],
  'Diodati': ['NNP'],
  'Dion': ['NNP'],
  'Dionie': ['NNP'],
  'Dionigi': ['NNP'],
  'Dionne': ['NNP'],
  'Dionysian': ['JJ'],
  'Dionysus': ['NNP'],
  'Dior': ['NNP'],
  'Dioxins': ['NNS'],
  'Dip': ['VB'],
  'Diplomatic': ['JJ'],
  'Diplomats': ['NNS'],
  'Diprivan': ['NNP'],
  'Dipylon': ['NNP'],
  'Dire': ['JJ'],
  'Direct': ['JJ'],
  'Direct-mail': ['JJ'],
  'Directed': ['VBN'],
  'Direction': ['NNP'],
  'Directionality': ['NN'],
  'Directions': ['NNP'],
  'Directive': ['NNP'],
  'Directly': ['RB'],
  'Director': ['NNP'],
  'Director-General': ['NNP'],
  'Directorate': ['NNP'],
  'Directors': ['NNS'],
  'Directory': ['NNP'],
  'Dirion': ['NNP'],
  'Dirk': ['NNP'],
  'Dirks': ['NNP'],
  'Dirksen': ['NNP'],
  'Diron': ['NNP'],
  'Dirt': ['NN'],
  'Dirty': ['JJ'],
  'Dirvin': ['NNP'],
  'Disabilities': ['NNP'],
  'Disabled': ['JJ'],
  'Disadvantaged': ['NNP'],
  'Disadvantages': ['NNS'],
  'Disaffiliation': ['NN'],
  'Disagreement': ['NN'],
  'Disappointing': ['JJ'],
  'Disappointment': ['NN'],
  'Disappointments': ['NNS'],
  'Disapproval': ['NN'],
  'Disarmament': ['NNP'],
  'Disaster': ['NN'],
  'Disasters': ['NNS'],
  'Disc': ['NNP'],
  'Disciplinary': ['NNP'],
  'Discipline': ['NN'],
  'Disciplined': ['VBN'],
  'Disclosed': ['VBN'],
  'Disclosure': ['NN'],
  'Disclosures': ['NNS'],
  'Discontinue': ['VB'],
  'Discos': ['NNS'],
  'Discount': ['NNP'],
  'Discounts': ['NNS'],
  'Discouraged': ['VBN'],
  'Discouragement': ['NN'],
  'Discours': ['NNP'],
  'Discourse': ['NNP'],
  'Discover': ['NNP'],
  'Discovered': ['VBN'],
  'Discoveries': ['NNS'],
  'Discovering': ['VBG'],
  'Discovery': ['NNP'],
  'Discovision': ['NNP'],
  'Discreet': ['JJ'],
  'Discrepancies': ['NNS'],
  'Discretion': ['NN'],
  'Discrimination': ['NNP'],
  'Discs': ['NNP'],
  'Discussed': ['VBN'],
  'Discussing': ['VBG'],
  'Discussion': ['NN'],
  'Discussions': ['NNS'],
  'Disease': ['NNP'],
  'Diseases': ['NNPS'],
  'Disgrace': ['NN'],
  'Disgruntled': ['JJ'],
  'Disgusted': ['VBN'],
  'Dish': ['NNP'],
  'Dishonesty': ['NN'],
  'Disk': ['NN'],
  'Disk\\\'/Trend': ['NNP'],
  'Dismal': ['JJ'],
  'Dismantle': ['VB'],
  'Dismay': ['NN'],
  'Dismissing': ['VBG'],
  'Dismounting': ['VBG'],
  'Disney': ['NNP'],
  'Disney\\\'/MGM': ['NNP'],
  'Disneyland': ['NNP'],
  'Disorderly': ['JJ'],
  'Dispatch': ['NNP'],
  'Dispensing': ['VBG'],
  'Dispersals': ['NNS'],
  'Displacement': ['NN'],
  'Display': ['NN'],
  'Displayed': ['VBN'],
  'Displaying': ['VBG'],
  'Disposable': ['JJ'],
  'Disposables': ['NNS'],
  'Disposal': ['NNP'],
  'Disposition': ['NNP'],
  'Disposti': ['NNP'],
  'Disputada': ['NNP'],
  'Disputado': ['NNP'],
  'Disputes': ['NNP'],
  'Disquisition': ['NNP'],
  'Disregarding': ['VBG'],
  'Dissect': ['VB'],
  'Dissenting': ['JJ'],
  'Dissident': ['NNP'],
  'Dissidents': ['NNS'],
  'Dist': ['NNP'],
  'Dist.': ['NN'],
  'Distally': ['RB'],
  'Distance': ['NNP'],
  'Distances': ['NNS'],
  'Distant': ['JJ'],
  'Distilled': ['NNP'],
  'Distiller': ['NN'],
  'Distillers': ['NNPS'],
  'Distinguished': ['NNP'],
  'Distorts': ['NNP'],
  'Distracted': ['VBN'],
  'Distressed': ['JJ'],
  'Distributed': ['VBN'],
  'Distributing': ['VBG'],
  'Distribution': ['NNP'],
  'Distributive': ['NNP'],
  'Distributors': ['NNS'],
  'District': ['NNP'],
  'Districts': ['NNS'],
  'Ditch': ['NNP'],
  'Ditka': ['NNP'],
  'Ditlow': ['NNP'],
  'Ditmar': ['NNP'],
  'Ditmars': ['NNP'],
  'Dittamore': ['NNP'],
  'Ditto': ['NN'],
  'Divergent': ['JJ'],
  'Divers': ['NNP'],
  'Diversey': ['NNP'],
  'Diversification': ['NN'],
  'Diversified': ['NNP'],
  'Diversify': ['VB'],
  'Diversity': ['NN'],
  'Divertimento': ['NNP'],
  'Dives': ['NNS'],
  'Divesting': ['VBG'],
  'Divestiture': ['NN'],
  'Divi': ['NNP'],
  'Divide': ['VB'],
  'Divided': ['VBN'],
  'Dividend': ['NN'],
  'Dividend-related': ['JJ'],
  'Dividends': ['NNS'],
  'Divine': ['NNP'],
  'Diving': ['NN'],
  'Divinity': ['NNP'],
  'Division': ['NNP'],
  'Divisional': ['NNP'],
  'Divisions': ['NNS'],
  'Divorced': ['NNP'],
  'Dixie': ['NNP'],
  'Dixiecrat': ['NNP'],
  'Dixiecrats': ['NNS'],
  'Dixieland': ['NNP'],
  'Dixon': ['NNP'],
  'Dixons': ['NNP'],
  'Dizzy': ['NNP'],
  'Djakarta': ['NNP'],
  'Django': ['NNP'],
  'Djangology': ['NNP'],
  'Djemaa': ['NNP'],
  'Djurdjevic': ['NNP'],
  'Dludsky': ['NNP'],
  'Dmitri': ['NNP'],
  'DnC': ['NNP'],
  'Dnieper': ['NNP'],
  'Dniepr': ['NNP'],
  'Do': ['VBP'],
  'Doak': ['NNP'],
  'Doaty': ['NNP'],
  'Dobbins': ['NNP'],
  'Dobbs': ['NNP'],
  'Doberman': ['NN'],
  'Dobi': ['NNP'],
  'Dobson': ['NNP'],
  'Doc': ['NNP'],
  'Docherty': ['NNP'],
  'Dock': ['NNP'],
  'Dockray': ['NNP'],
  'Dockweiler': ['NNP'],
  'Doctor': ['NNP'],
  'Doctors': ['NNS'],
  'Doctrine': ['NNP'],
  'Document': ['NNP'],
  'Documentary': ['NNP'],
  'Documentation': ['NNP'],
  'Documents': ['NNS'],
  'Dodd': ['NNP'],
  'Dodd-type': ['NNP'],
  'Dodds': ['NNP'],
  'Dodge': ['NNP'],
  'Dodger': ['NNP'],
  'Dodgers': ['NNP'],
  'Dodington': ['NNP'],
  'Dods': ['NNP'],
  'Dodson': ['NNP'],
  'Doe': ['NNP'],
  'Doerflinger': ['NNP'],
  'Doerig': ['NNP'],
  'Doerner': ['NNP'],
  'Does': ['VBZ'],
  'Dog': ['NNP'],
  'Dogberry': ['NNP'],
  'Dogs': ['NNS'],
  'Dogtown': ['NNP'],
  'Dogumenti': ['FW'],
  'Doherty': ['NNP'],
  'Dohnanyi': ['NNP'],
  'Doi': ['NNP'],
  'Doing': ['NNP'],
  'Dolan': ['NNP'],
  'Dolce': ['NNP'],
  'Dole': ['NNP'],
  'Doll': ['NNP'],
  'Dollar': ['NN'],
  'Dollar-Britten': ['NNP'],
  'Dollar-De': ['NNP'],
  'Dollar-yen': ['JJ'],
  'Dollars': ['NNPS'],
  'Dolley': ['NNP'],
  'Dolls': ['NNP'],
  'Dolly': ['NNP'],
  'Dolmabahce': ['NNP'],
  'Dolora': ['NNP'],
  'Dolores': ['NNP'],
  'Dolphin': ['NNP'],
  'Dolphins': ['NNPS'],
  'Dom': ['NNP'],
  'Domaine': ['NNP'],
  'Doman': ['NNP'],
  'Dome': ['NNP'],
  'Domeier': ['NNP'],
  'Domenici': ['NNP'],
  'Domesday': ['NNP'],
  'Domestic': ['JJ'],
  'Domestically': ['RB'],
  'Domicilium': ['NNP'],
  'Domina': ['NNP'],
  'Dominant': ['JJ'],
  'Dominated': ['VBN'],
  'Domingo': ['NNP'],
  'Domingos': ['NNP'],
  'Dominguez': ['NNP'],
  'Dominic': ['NNP'],
  'Dominica': ['NNP'],
  'Dominican': ['NNP'],
  'Dominici': ['NNP'],
  'Dominick': ['NNP'],
  'Dominion': ['NNP'],
  'Dominique': ['NNP'],
  'Domino': ['NNP'],
  'Dominus': ['NNP'],
  'Domitian': ['NNP'],
  'Domokous': ['NNP'],
  'Dompierre': ['NNP'],
  'Domtar': ['NNP'],
  'Don': ['NNP'],
  'Don\'t': ['VB'],
  'Dona': ['NNP'],
  'Donaghy': ['NNP'],
  'Donahue': ['NNP'],
  'Donald': ['NNP'],
  'Donaldson': ['NNP'],
  'Donaldsonville': ['NNP'],
  'Donating': ['VBG'],
  'Donations': ['NNS'],
  'Donato': ['NNP'],
  'Donbas': ['NNP'],
  'Done': ['VBN'],
  'Doner': ['NNP'],
  'Dong': ['NNP'],
  'Dong-A': ['NNP'],
  'Dongen': ['NNP'],
  'Donics': ['NNP'],
  'Donizetti': ['NNP'],
  'Donna': ['NNP'],
  'Donnan': ['NNP'],
  'Donnay': ['NNP'],
  'Donnell': ['NNP'],
  'Donnelley': ['NNP'],
  'Donnelly': ['NNP'],
  'Donner': ['NNP'],
  'Donning': ['VBG'],
  'Donnybrook': ['NNP'],
  'Donofrio': ['NNP'],
  'Donoghue': ['NNP'],
  'Donohoo': ['NNP'],
  'Donohue': ['NNP'],
  'Donor': ['NN'],
  'Donors': ['NNS'],
  'Donovan': ['NNP'],
  'Donut': ['NNP'],
  'Donuts': ['NNP'],
  'Doo': ['NNP'],
  'Doobie': ['NNP'],
  'Dookiyoon': ['NNP'],
  'Dooley': ['NNP'],
  'Dooleys': ['NNPS'],
  'Doolin': ['NNP'],
  'Dooling': ['NNP'],
  'Doolittle': ['NNP'],
  'Doonesbury': ['NNP'],
  'Door': ['NNP'],
  'Doordarshan': ['NNP'],
  'Doorne': ['NNP'],
  'Doors': ['NNS'],
  'Doosan': ['NNP'],
  'Doppler': ['NNP'],
  'Dor': ['NNP'],
  'Dora': ['NNP'],
  'Dorado': ['NNP'],
  'Doran': ['NNP'],
  'Doraville': ['NNP'],
  'Dorcas': ['NNP'],
  'Dorena': ['NNP'],
  'Dorens': ['NNP'],
  'Dorenzo': ['NNP'],
  'Dorfman': ['NNP'],
  'Dorgan': ['NNP'],
  'Dorgen': ['NNP'],
  'Doria': ['NNP'],
  'Dorian': ['NNP'],
  'Doric': ['JJ'],
  'Doris': ['NNP'],
  'Doritos': ['NNS'],
  'Dormitory': ['NNP'],
  'Dornan': ['NNP'],
  'Dorney': ['NNP'],
  'Dornier': ['NNP'],
  'Doron': ['NNP'],
  'Doronfeld': ['NNP'],
  'Dorothee': ['NNP'],
  'Dorothy': ['NNP'],
  'Dorr': ['NNP'],
  'Dorrance': ['NNP'],
  'Dorrances': ['NNPS'],
  'Dorsch': ['NNP'],
  'Dorset': ['NNP'],
  'Dorsey': ['NNP'],
  'Dorsten': ['NNP'],
  'Dort': ['NNP'],
  'Dortch': ['NNP'],
  'Dortmund': ['NNP'],
  'Dos': ['NNP'],
  'Doskocil': ['NNP'],
  'Dostoevski': ['NNP'],
  'Dostoevsky': ['NNP'],
  'Doswell': ['NNP'],
  'Dotson': ['NNP'],
  'Dotzler': ['NNP'],
  'Double': ['NNP'],
  'Double-Figure': ['NNP'],
  'Double-Jointed': ['NNP'],
  'Double-digit': ['JJ'],
  'Doubled': ['VBD'],
  'Doubleday': ['NNP'],
  'Doubles': ['NNP'],
  'Doubt': ['NN'],
  'Doubtful': ['JJ'],
  'Doubtless': ['RB'],
  'Doubts': ['NNS'],
  'Douce': ['NNP'],
  'Doug': ['NNP'],
  'Dough': ['NN'],
  'Dougherty': ['NNP'],
  'Doughnuttery': ['NN'],
  'Douglas': ['NNP'],
  'Douglass': ['NNP'],
  'Doulgas': ['NNP'],
  'Dousman': ['NNP'],
  'Dov': ['NNP'],
  'Dove': ['NN'],
  'Dover': ['NNP'],
  'Dow': ['NNP'],
  'Dow-Jones': ['NNP'],
  'DowBrands': ['NNP'],
  'Dowager': ['NNP'],
  'Dowd': ['NNP'],
  'Dowex-2-chloride': ['NN'],
  'Dowguard': ['NNP'],
  'Dowie': ['NNP'],
  'Dowling': ['NNP'],
  'Down': ['IN'],
  'Downbeat': ['NNP'],
  'Downers': ['NNP'],
  'Downey': ['NNP'],
  'Downfall': ['NNP'],
  'Downgraded': ['VBN'],
  'Downgrades': ['NNS'],
  'Downham': ['NNP'],
  'Downing': ['NNP'],
  'Downs': ['NNP'],
  'Downside': ['JJ'],
  'Downstairs': ['NN'],
  'Downtown': ['NN'],
  'Dowty': ['NNP'],
  'Doxiadis': ['NNP'],
  'Doyle': ['NNP'],
  'Dozen': ['NNP'],
  'Dozens': ['NNS'],
  'Dr': ['NNP'],
  'Dr.': ['NNP'],
  'Drabble': ['NNP'],
  'Drabinsky': ['NNP'],
  'Draco': ['NNP'],
  'Draconian': ['JJ'],
  'Dracula': ['NNP'],
  'Draft': ['NNP'],
  'Drafted': ['VBN'],
  'Draftula': ['NNP'],
  'Drag': ['VB'],
  'Dragging': ['VBG'],
  'Dragnet': ['NNP'],
  'Drago': ['NNP'],
  'Dragon': ['NNP'],
  'Dragonetti': ['NNP'],
  'Dragons': ['NNP'],
  'Dragoslav': ['NNP'],
  'Dragoumis': ['NNP'],
  'Drahuschak': ['NNP'],
  'Drain': ['VB'],
  'Drake': ['NNP'],
  'Dramatic': ['JJ'],
  'Draper': ['NNP'],
  'Drastic': ['JJ'],
  'Dravo': ['NNP'],
  'Draw': ['VB'],
  'Draw-file': ['NN'],
  'Drawbacks': ['NNS'],
  'Drawers': ['NNS'],
  'Drawing': ['VBG'],
  'Drawn': ['VBN'],
  'Dread': ['NNP'],
  'Dreadnought': ['NNP'],
  'Dream': ['NNP'],
  'Dream-Lusty': ['NNP'],
  'Dream-Miss': ['NNP'],
  'Dream-Next': ['NNP'],
  'Dream-Sweetmite': ['NNP'],
  'Dream-Torkin': ['NNP'],
  'Dream-Way': ['NNP'],
  'Dreamboat': ['NNP'],
  'Dreamers': ['NNS'],
  'Dreams': ['NNS'],
  'Dred': ['NNP'],
  'Dreieich': ['NNP'],
  'Dreiser': ['NNP'],
  'Dreisers': ['NNPS'],
  'Drell': ['NNP'],
  'Dreman': ['NNP'],
  'Drenched': ['JJ'],
  'Drennen': ['NNP'],
  'Dresbach': ['NNP'],
  'Dresbachs': ['NNPS'],
  'Dresden': ['NNP'],
  'Dresdner': ['NNP'],
  'Dresdner-ABD': ['NNP'],
  'Dress': ['NNP'],
  'Dressed': ['VBN'],
  'Dresser': ['NNP'],
  'Dresses': ['NNS'],
  'Dresylon': ['NNP'],
  'Drew': ['NNP'],
  'Drexel': ['NNP'],
  'Drexel-managed': ['JJ'],
  'Drexel-underwritten': ['JJ'],
  'Drexler': ['NNP'],
  'Dreyer': ['NNP'],
  'Dreyfus': ['NNP'],
  'Dried': ['VBN'],
  'Driesell': ['NNP'],
  'Drift': ['NNP'],
  'Drifting': ['VBG'],
  'Drifts': ['NNS'],
  'Drill': ['VB'],
  'Drilling': ['NNP'],
  'Drink': ['VB'],
  'Drinker': ['NN'],
  'Drinkhouse': ['NNP'],
  'Drinking': ['VBG'],
  'Driscoll': ['NNP'],
  'Driskill': ['NNP'],
  'Drive': ['NNP'],
  'Drive-in': ['NNP'],
  'Driven': ['VBN'],
  'Driver': ['NNP'],
  'Drivers': ['NNS'],
  'Driving': ['VBG'],
  'Drivon': ['NNP'],
  'Drobnick': ['NNP'],
  'Drobny': ['NNP'],
  'Drogerias': ['NNP'],
  'Drogoul': ['NNP'],
  'Droid': ['NNP'],
  'Droll': ['NNP'],
  'Dromey': ['NNP'],
  'Dronk': ['NNP'],
  'Drop': ['VB'],
  'Dropouts': ['NNS'],
  'Dropping': ['VBG'],
  'Drought': ['NN'],
  'Drouot': ['NNP'],
  'Drovers': ['NNS'],
  'Droz': ['NNP'],
  'Drs.': ['NNP'],
  'Dru': ['NNP'],
  'Drubbing': ['NN'],
  'Drug': ['NNP'],
  'Drug-Treatment': ['JJ'],
  'Drug-industry': ['JJ'],
  'Druggan-Lake': ['NNP'],
  'Drugs': ['NNS'],
  'Drugstore': ['NNP'],
  'Druid': ['NN'],
  'Druin': ['NNP'],
  'Drum': ['NNP'],
  'Drummer': ['NN'],
  'Drums': ['NNS'],
  'Drunk': ['JJ'],
  'Drunkard': ['NNP'],
  'Drunken': ['JJ'],
  'Drunkenness': ['NN'],
  'Drury': ['NNP'],
  'Druse': ['JJ'],
  'Dry': ['NNP'],
  'Drybred': ['NNP'],
  'Dryden': ['NNP'],
  'Drye': ['NNP'],
  'Dryer': ['NN'],
  'Dryfoos': ['NNP'],
  'Drying': ['NN'],
  'Dryja': ['NNP'],
  'Ds': ['NNS'],
  'Du': ['NNP'],
  'DuCharme': ['NNP'],
  'DuComb': ['NNP'],
  'DuPont': ['NNP'],
  'DuVol': ['NNP'],
  'Dual': ['JJ'],
  'Duane': ['NNP'],
  'Duarte': ['NNP'],
  'Dubai': ['NNP'],
  'Dubaih': ['NNP'],
  'Dubbed': ['VBN'],
  'Dubilier': ['NNP'],
  'Dubin': ['NNP'],
  'Dubinin': ['NNP'],
  'Dubinsky': ['NNP'],
  'Dublin': ['NNP'],
  'Dubnow': ['NNP'],
  'Dubois': ['NNP'],
  'Dubose': ['NNP'],
  'Dubovskoi': ['NNP'],
  'Duchenne': ['NNP'],
  'Duchess': ['NNP'],
  'Duchossois': ['NNP'],
  'Duchy': ['NNP'],
  'Duck': ['NNP'],
  'Ducking': ['VBG'],
  'Ducky': ['NNP'],
  'Duclos': ['NNP'],
  'Dudley': ['NNP'],
  'Due': ['JJ'],
  'Duel': ['NNP'],
  'Duero': ['NNP'],
  'Duesseldorf': ['NNP'],
  'Duff': ['NNP'],
  'Duffey': ['NNP'],
  'Duffield': ['NNP'],
  'Duffus': ['NNP'],
  'Duffy': ['NNP'],
  'Dufresne': ['NNP'],
  'Dugan': ['NNP'],
  'Dugan\\\'/Farley': ['NNP'],
  'Dugdale': ['NNP'],
  'Duhagon': ['NNP'],
  'Dukakis': ['NNP'],
  'Dukakises': ['NNP'],
  'Duke': ['NNP'],
  'Duke-EPA': ['JJ'],
  'Dukes': ['NNPS'],
  'Dulaney': ['NNP'],
  'Dulles': ['NNP'],
  'Dulude': ['NNP'],
  'Duluth': ['NNP'],
  'Dumas': ['NNP'],
  'Dumb': ['JJ'],
  'Dumbo': ['NNP'],
  'Dumez': ['NNP'],
  'Dummkopf': ['NN'],
  'Dumont': ['NNP'],
  'Dumping': ['NN'],
  'Dumpster': ['NNP'],
  'Dumpty': ['NNP'],
  'Dun': ['NNP'],
  'Dunaway': ['NNP'],
  'Dunbar': ['NNP'],
  'Duncan': ['NNP'],
  'Dunde': ['NNP'],
  'Dundee': ['NNP'],
  'Dundeen': ['NNP'],
  'Dunes': ['NNPS'],
  'Dung': ['NNP'],
  'Dunham': ['NNP'],
  'Dunkel': ['NNP'],
  'Dunkelberg': ['NNP'],
  'Dunker': ['NNP'],
  'Dunkin': ['NNP'],
  'Dunkirk': ['NNP'],
  'Dunlaevy': ['NNP'],
  'Dunlap': ['NNP'],
  'Dunlop': ['NNP'],
  'Dunn': ['NNP'],
  'Dunn-Atherton': ['NNP'],
  'Dunne': ['NNP'],
  'Dunston': ['NNP'],
  'Dunton': ['NNP'],
  'Duplicate': ['NN'],
  'Duplicating': ['VBG'],
  'Dupont': ['NNP'],
  'Duponts': ['NNPS'],
  'Dupps': ['NNP'],
  'Dupuy': ['NNP'],
  'Duque': ['NNP'],
  'Duquesne': ['NNP'],
  'Durable': ['JJ'],
  'Durable-goods': ['JJ'],
  'Durables': ['NNPS'],
  'Duracell': ['NNP'],
  'Durakon': ['NNP'],
  'Durant': ['NNP'],
  'Durante': ['NNP'],
  'Duration': ['NN'],
  'Durban': ['NNP'],
  'Durcan': ['NNP'],
  'Duren': ['NNP'],
  'Durenberger': ['NNP'],
  'Durer': ['NNP'],
  'Durgin': ['NNP'],
  'Durham': ['NNP'],
  'During': ['IN'],
  'Duriron': ['NNP'],
  'Durk': ['NNP'],
  'Durkheim': ['NNP'],
  'Durkin': ['NNP'],
  'Durlach': ['NNP'],
  'Durmoy': ['NNP'],
  'Durney': ['NNP'],
  'Durning': ['NNP'],
  'Duro-Test': ['NNP'],
  'DuroTest': ['NNP'],
  'Durocher': ['NNP'],
  'Durrell': ['NNP'],
  'Durwood': ['NNP'],
  'Duse': ['NNP'],
  'Dussa': ['NNP'],
  'Dusseldorf': ['NNP'],
  'Dust': ['NNP'],
  'Dustin': ['NNP'],
  'Duston': ['NNP'],
  'Dusty': ['NNP'],
  'Dutch': ['JJ'],
  'Dutch-based': ['JJ'],
  'Dutch-descended': ['JJ'],
  'Dutch-elm-disease': ['NN'],
  'Dutch\\\'/Shell': ['NNP'],
  'Dutchess': ['NNP'],
  'Dutchman': ['NNP'],
  'Duties': ['NNP'],
  'Dutil': ['NNP'],
  'Dutton': ['NNP'],
  'Duty': ['NNP'],
  'Duty-Free': ['NNP'],
  'Duty-free': ['JJ'],
  'Duvalier': ['NNP'],
  'Duverger': ['NNP'],
  'Duy': ['NNP'],
  'Duyvil': ['NNP'],
  'Duzan': ['NNP'],
  'Dvorak': ['NNP'],
  'Dwarfing': ['VBG'],
  'Dwellers': ['NNS'],
  'Dwight': ['NNP'],
  'Dwor': ['NNP'],
  'Dworkin': ['NNP'],
  'Dworkin-Cosell': ['NNP'],
  'Dwyer': ['NNP'],
  'DyDee': ['NNP'],
  'Dyazide': ['NNP'],
  'Dycom': ['NNP'],
  'Dyer': ['NNP'],
  'Dyerear': ['NNP'],
  'Dying': ['NNP'],
  'Dyk': ['NNP'],
  'Dyke': ['NNP'],
  'Dylan': ['NNP'],
  'Dylan-influenced': ['JJ'],
  'Dylex': ['NNP'],
  'Dyna': ['NNP'],
  'Dynabook': ['NNP'],
  'Dynafac': ['NN'],
  'Dynamic': ['NNP'],
  'Dynamics': ['NNP'],
  'Dynamite': ['NNP'],
  'Dynapert': ['NNP'],
  'Dynascan': ['NNP'],
  'Dynasts': ['NNPS'],
  'Dynasty': ['NNP'],
  'Dyncorp': ['NNP'],
  'Dyncorp.': ['NNP'],
  'Dynoriders': ['NNP'],
  'Dysan': ['NNP'],
  'Dyson': ['NNP'],
  'E': ['NN'],
  'E&J': ['NNP'],
  'E&P': ['NNP'],
  'E-1': ['CD'],
  'E-2': ['CD'],
  'E-2C': ['NN'],
  'E-6A': ['NN'],
  'E-71': ['NNP'],
  'E-II': ['NNP'],
  'E-Systems': ['NNP'],
  'E-Z': ['JJ'],
  'E-mail': ['NN'],
  'E.': ['NNP'],
  'E.B.': ['NNP'],
  'E.C.': ['NNP'],
  'E.D.': ['NNP'],
  'E.E.': ['NNP'],
  'E.F.': ['NNP'],
  'E.G.': ['NNP'],
  'E.G.T.': ['NNP'],
  'E.H.': ['NNP'],
  'E.M.': ['NNP'],
  'E.O.': ['NNP'],
  'E.P.': ['NN'],
  'E.R.': ['NNP'],
  'E.T.': ['NNP'],
  'E.T.C': ['NNP'],
  'E.W.': ['NNP'],
  'E.Y.': ['NNP'],
  'E5': ['NNP'],
  'EAC': ['NNP'],
  'EARNINGS': ['NNS'],
  'EARTHQUAKE': ['NN'],
  'EAST': ['NNP'],
  'EASTERN': ['NNP'],
  'EBPI': ['NNP'],
  'EBS': ['NNP'],
  'EC': ['NNP'],
  'EC-1': ['NN'],
  'EC-made': ['JJ'],
  'EC-wide': ['JJ'],
  'ECA': ['NNP'],
  'ECI': ['NNP'],
  'ECONOMIC': ['JJ'],
  'ECONOMY': ['NN'],
  'ECP': ['NNP'],
  'ECPA': ['NNP'],
  'ECU': ['NNP'],
  'ECU-based': ['JJ'],
  'ECU-denominated': ['JJ'],
  'ECUs': ['NNS'],
  'EDA': ['NNP'],
  'EDI': ['NNP'],
  'EDISON': ['NNP'],
  'EDMOV': ['NN'],
  'EDS': ['NNP'],
  'EDT': ['NNP'],
  'EDUCATION': ['NN'],
  'EEAE-cellulose': ['NN'],
  'EEG': ['NNP'],
  'EEOC': ['NNP'],
  'EFFECT': ['NN'],
  'EFPs': ['NNS'],
  'EG&G': ['NNP'],
  'EGA': ['NNP'],
  'EGA-VGA': ['JJ'],
  'EGYPT': ['NNP'],
  'EISA': ['NNP'],
  'EITC': ['NNP'],
  'EK': ['NNP'],
  'EL-10': ['NNP'],
  'ELDERLY': ['JJ'],
  'ELECTED': ['VBD'],
  'ELECTIONS': ['NNS'],
  'ELECTRIC': ['NNP'],
  'ELECTRONICS': ['NNP'],
  'ELP': ['NNP'],
  'ELSINORE': ['NNP'],
  'ELWOOD': ['NNP'],
  'EMA': ['NNP'],
  'EMC': ['NNP'],
  'EMI': ['NNP'],
  'EMPIRE': ['NNP'],
  'EMPLOYEE': ['NN'],
  'EMPLOYEES': ['NNS'],
  'EMS': ['NNP'],
  'ENCYCLOPAEDIA': ['NNP'],
  'ENDED': ['VBD'],
  'ENERGY': ['NN'],
  'ENFIELD': ['NNP'],
  'ENG': ['NNP'],
  'ENGLAND': ['NNP'],
  'ENGRAPH': ['NNP'],
  'ENI': ['NNP'],
  'ENTEL': ['NNP'],
  'ENTERED': ['VBD'],
  'ENTERPRISES': ['NNP'],
  'ENTERS': ['VBZ'],
  'ENTERTAINMENT': ['NNP'],
  'ENTREPRENEURSHIP': ['NN'],
  'ENVIRONMENTAL': ['JJ'],
  'EOG': ['NNP'],
  'EP-3E': ['NNP'],
  'EPA': ['NNP'],
  'EPC': ['NNP'],
  'EPO': ['NNP'],
  'EPO-treated': ['JJ'],
  'EQU': ['NN'],
  'EQUIPMENT': ['NNP'],
  'EQUITIES': ['NNPS'],
  'EQUITY': ['NNP'],
  'ERC': ['NNP'],
  'ERG': ['NNP'],
  'ERISA': ['NNP'],
  'ERNST': ['NNP'],
  'ES': ['NNP'],
  'ES250': ['NNP'],
  'ESB': ['NNP'],
  'ESL': ['NNP'],
  'ESN': ['NN'],
  'ESOP': ['NNP'],
  'ESOPs': ['NNS'],
  'ESP': ['NNP'],
  'ESPN': ['NNP'],
  'ESPs': ['NNPS'],
  'EST': ['NNP'],
  'ESTABLISHMENT': ['NN'],
  'ESTATE': ['NN'],
  'ESystems': ['NNP'],
  'ET': ['NNP'],
  'ETA': ['NNP'],
  'ETHICS': ['NNS'],
  'ETR': ['NNP'],
  'ETV': ['NNP'],
  'EUMMELIHS': ['NNP'],
  'EURODOLLARS': ['NNS'],
  'EUROP': ['NNP'],
  'EUROPE': ['NNP'],
  'EVER': ['RB'],
  'EVEREX': ['NNP'],
  'EVERYONE': ['NN'],
  'EWC': ['NN'],
  'EWDB': ['NNP'],
  'EX': ['NNP'],
  'EX-OFFICIALS': ['NNS'],
  'EXAMINE': ['VB'],
  'EXBT': ['NNP'],
  'EXCHANGE': ['NN'],
  'EXE': ['NNP'],
  'EXECUTIVES': ['NNPS'],
  'EXP': ['NNP'],
  'EXPANDS': ['VBZ'],
  'EXPECT': ['VBP'],
  'EXPENSES': ['NNS'],
  'EXPENSIVE': ['JJ'],
  'EXPRESS': ['NNP'],
  'EXPRESSED': ['VBD'],
  'EXTEND': ['VB'],
  'EXXON': ['NNP'],
  'EYEWEAR': ['NN'],
  'EYP': ['NNP'],
  'EZ': ['NNP'],
  'Each': ['DT'],
  'Eades': ['NNP'],
  'Eager': ['JJ'],
  'Eagle': ['NNP'],
  'Eagle-Berol': ['NNP'],
  'Eagle-Picher': ['NNP'],
  'Eagleburger': ['NNP'],
  'Eagles': ['NNP'],
  'Eagleton': ['NNP'],
  'Eagleton-Newark': ['NNP'],
  'Eakle': ['NNP'],
  'Ealy': ['NNP'],
  'Eamonn': ['NNP'],
  'Ear': ['NNP'],
  'Ear-Muffs': ['NNPS'],
  'Earl': ['NNP'],
  'Earle': ['NNP'],
  'Earlham': ['NNP'],
  'Earlier': ['RBR'],
  'Earls': ['NNP'],
  'Early': ['RB'],
  'Early-morning': ['JJ'],
  'Early-retirement': ['NN'],
  'Earning': ['NN'],
  'Earnings': ['NNS'],
  'Earns': ['VBZ'],
  'Earp': ['NNP'],
  'Ears': ['NNS'],
  'Earth': ['NNP'],
  'Earth-quake': ['NN'],
  'Earth-week': ['NN'],
  'Earth-weeks': ['NNS'],
  'Earthbeat': ['NNP'],
  'Earthlings': ['NNS'],
  'Earthmen': ['NNPS'],
  'Earthquake': ['NN'],
  'Earthquake-related': ['JJ'],
  'Earthquakes': ['NNS'],
  'Ease': ['VB'],
  'Easier': ['JJR'],
  'Easily': ['RB'],
  'East': ['NNP'],
  'East-West': ['NNP'],
  'Eastate': ['NNP'],
  'Eastchester': ['NNP'],
  'Easter': ['NNP'],
  'Easterbrook': ['NNP'],
  'Eastern': ['NNP'],
  'Easterners': ['NNS'],
  'Easthampton': ['NNP'],
  'Eastland': ['NNP'],
  'Eastman': ['NNP'],
  'Easton': ['NNP'],
  'Eastwick': ['NNP'],
  'Easy': ['NNP'],
  'EasyLink': ['NNP'],
  'Eat': ['NNP'],
  'Eaters': ['NNS'],
  'Eating': ['NN'],
  'Eaton': ['NNP'],
  'Eats': ['NNS'],
  'Eaux': ['NNP'],
  'Eavesdropping': ['NN'],
  'Ebasco': ['NNP'],
  'Ebaugh': ['NNP'],
  'Ebbetts': ['NNP'],
  'Ebbutt': ['NNP'],
  'Ebel': ['NNP'],
  'Eben': ['NNP'],
  'Ebensburg': ['NNP'],
  'Eber': ['NNP'],
  'Eberly': ['NNP'],
  'Ebersol': ['NNP'],
  'Ebert': ['NNP'],
  'Ebrahim': ['NNP'],
  'Ebury': ['NNP'],
  'Eccles': ['NNP'],
  'Ecclesiastical': ['NNP'],
  'Ecco': ['NNP'],
  'Echeandia': ['NNP'],
  'Echelon': ['NNP'],
  'Echo': ['NNP'],
  'Echoing': ['VBG'],
  'Eckart': ['NNP'],
  'Eckenfelder': ['NNP'],
  'Eckerd': ['NNP'],
  'Eckersley': ['NNP'],
  'Eckhard': ['NNP'],
  'Eckhardt': ['NNP'],
  'Eclectic': ['JJ'],
  'Eclipse': ['NNP'],
  'Ecogen': ['NNP'],
  'Ecolab': ['NNP'],
  'Ecole': ['NNP'],
  'Ecological': ['NNP'],
  'Ecology': ['NN'],
  'Econoclast': ['NNP'],
  'Economdis': ['NNP'],
  'Econometric': ['NNP'],
  'Economic': ['NNP'],
  'Economically': ['RB'],
  'Economics': ['NNP'],
  'Economidis': ['NNP'],
  'Economies': ['NNS'],
  'Economique': ['NNP'],
  'Economist': ['NNP'],
  'Economists': ['NNS'],
  'Economizers': ['NNS'],
  'Economy': ['NNP'],
  'Ecuador': ['NNP'],
  'Ecumenical': ['NNP'],
  'Ed': ['NNP'],
  'Ed.': ['NNP'],
  'Eddie': ['NNP'],
  'Eddies': ['NNP'],
  'Eddington': ['NNP'],
  'Eddy': ['NNP'],
  'Eddyman': ['NNP'],
  'Ede': ['NNP'],
  'Edelman': ['NNP'],
  'Edelmann': ['NNP'],
  'Edelson': ['NNP'],
  'Edelstein': ['NNP'],
  'Eden': ['NNP'],
  'Eder': ['NNP'],
  'Edgar': ['NNP'],
  'Edgardo': ['NN'],
  'Edge': ['NNP'],
  'Edgerton': ['NNP'],
  'Edgewater': ['NNP'],
  'Edict': ['NNP'],
  'Edinburgh': ['NNP'],
  'Edison': ['NNP'],
  'Edisto': ['NNP'],
  'Edita': ['NNP'],
  'Edith': ['NNP'],
  'Editing': ['NN'],
  'Edition': ['NNP'],
  'Editions': ['NNPS'],
  'Editor': ['NNP'],
  'Editorial': ['JJ'],
  'Editorials': ['NNS'],
  'Editors': ['NNS'],
  'Edley': ['NNP'],
  'Edmar': ['NNP'],
  'Edmiston': ['NNP'],
  'Edmond': ['NNP'],
  'Edmondson': ['NNP'],
  'Edmonia': ['NN'],
  'Edmonton': ['NNP'],
  'Edmund': ['NNP'],
  'Edmunston': ['NNP'],
  'Edna': ['NNP'],
  'Ednee': ['NNP'],
  'Ednie': ['NNP'],
  'Edouard': ['NNP'],
  'Edsel': ['NNP'],
  'Edson': ['NNP'],
  'Eduard': ['NNP'],
  'Eduardo': ['NNP'],
  'Educate': ['VB'],
  'Education': ['NNP'],
  'Educational': ['NNP'],
  'Educator': ['NNP'],
  'Educators': ['NNP'],
  'Edw': ['NNP'],
  'Edward': ['NNP'],
  'Edwardes': ['NNP'],
  'Edwardh': ['NNP'],
  'Edwards': ['NNP'],
  'Edwardsville': ['NNP'],
  'Edwin': ['NNP'],
  'Edwina': ['NNP'],
  'Edwviges': ['NNP'],
  'Edythe': ['NNP'],
  'Edzard': ['NNP'],
  'Effect': ['NN'],
  'Effective': ['JJ'],
  'Effectively': ['RB'],
  'Effects': ['NNPS'],
  'Efficiencies': ['NNS'],
  'Efficiency': ['NN'],
  'Effie': ['NNP'],
  'Effjohn': ['NNP'],
  'Effoa': ['NNP'],
  'Efforts': ['NNS'],
  'Egad': ['UH'],
  'Egalitarianism': ['NNP'],
  'Egan': ['NNP'],
  'Egerton': ['NNP'],
  'Egg': ['NNP'],
  'Egg-industry': ['NN'],
  'Egger': ['NNP'],
  'Eggers': ['NNP'],
  'Eggs': ['NNP'],
  'Eggum': ['NNP'],
  'Egil': ['NNP'],
  'Egils': ['NNP'],
  'Egnuss': ['NNP'],
  'Egon': ['NNP'],
  'Egypt': ['NNP'],
  'Egyptian': ['JJ'],
  'Egyptians': ['NNPS'],
  'Eh': ['UH'],
  'Ehlers': ['NNP'],
  'Ehman': ['NNP'],
  'Ehrhardt': ['NNP'],
  'Ehrlich': ['NNP'],
  'Ehrlichman': ['NNP'],
  'Ehrman': ['NNP'],
  'Eicher': ['NNP'],
  'Eichler': ['NNP'],
  'Eichmann': ['NNP'],
  'Eichner': ['NNP'],
  'Eichof': ['NNP'],
  'Eidsmo': ['NNP'],
  'Eiffel': ['NNP'],
  'Eigen': ['NNP'],
  'Eight': ['CD'],
  'Eight-foot-tall': ['JJ'],
  'Eighteen': ['CD'],
  'Eighteenth': ['NNP'],
  'Eighteenth-century': ['JJ'],
  'Eighth': ['NNP'],
  'Eighties': ['NNP'],
  'Eighty': ['CD'],
  'Eighty-Eight': ['NNP'],
  'Eighty-Four': ['NNP'],
  'Eighty-five': ['CD'],
  'Eighty-seventh': ['NNP'],
  'Eighty-three': ['CD'],
  'Eiji': ['NNP'],
  'Eileen': ['NNP'],
  'Einar': ['NNP'],
  'Einhorn': ['NNP'],
  'Einsatzkommandos': ['NNP'],
  'Einstein': ['NNP'],
  'Einsteinian': ['JJ'],
  'Eire': ['NNP'],
  'Eisai': ['NNP'],
  'Eisenach': ['NNP'],
  'Eisenberg': ['NNP'],
  'Eisenhhower': ['NNP'],
  'Eisenhower': ['NNP'],
  'Eisenstat': ['NNP'],
  'Eishi': ['NNP'],
  'Eisler': ['NNP'],
  'Eiszner': ['NNP'],
  'Either': ['CC'],
  'Eizenstat': ['NNP'],
  'Ejaculated': ['VBD'],
  'Ek': ['NNP'],
  'Ekaterinoslav': ['NNP'],
  'Ekberg': ['NNP'],
  'Ekco': ['NNP'],
  'Ekman': ['NNP'],
  'Ekonomicheskaya': ['NNP'],
  'Ekstrohm': ['NNP'],
  'Ekwanok': ['NNP'],
  'El': ['NNP'],
  'El-Abed': ['NNP'],
  'El-Sadr': ['NNP'],
  'Elaborate': ['JJ'],
  'Elaborating': ['VBG'],
  'Elaine': ['NNP'],
  'Elan': ['NNP'],
  'Elanco': ['NNP'],
  'Elavil': ['NNP'],
  'Elba': ['NNP'],
  'Elbaum': ['NNP'],
  'Elbaz': ['NNP'],
  'Elbe': ['NNP'],
  'Elbow': ['NN'],
  'Elburn': ['NNP'],
  'Elco': ['NNP'],
  'Elcotel': ['NNP'],
  'Elder': ['NNP'],
  'Elderly': ['JJ'],
  'Elders': ['NNP'],
  'Eldest': ['JJS'],
  'Eldon': ['NNP'],
  'Eldred': ['NNP'],
  'Eleanor': ['NNP'],
  'Eleazar': ['NNP'],
  'Elec': ['NNP'],
  'Elecktra': ['NNP'],
  'Elected': ['VBN'],
  'Election': ['NNP'],
  'Elections': ['NNS'],
  'Elector': ['NNP'],
  'Electoral': ['NNP'],
  'Electra': ['NNP'],
  'Electress': ['NNP'],
  'Electric': ['NNP'],
  'Electrical': ['NNP'],
  'Electricity': ['NNP'],
  'Electrification': ['NNP'],
  'Electro': ['NNP'],
  'Electro-Optical': ['NNP'],
  'Electro-Optics': ['NNP'],
  'Electrochemical': ['NNP'],
  'Electrolux': ['NNP'],
  'Electromyography': ['NN'],
  'Electron': ['NNP'],
  'Electron-microscopical': ['NN'],
  'Electronic': ['NNP'],
  'Electronics': ['NNP'],
  'Electrostatic': ['JJ'],
  'Electrosurgery': ['NNP'],
  'Elegance': ['NN'],
  'Elegant': ['NNP'],
  'Elegies': ['NNP'],
  'Elektronik': ['NNP'],
  'Elemental': ['JJ'],
  'Elementary': ['NNP'],
  'Elements': ['NNS'],
  'Elemer': ['NNP'],
  'Elena': ['NNP'],
  'Elephant': ['NNP'],
  'Elephants': ['NNS'],
  'Elevated': ['NNP'],
  'Eleven': ['CD'],
  'Elf': ['NNP'],
  'Elfner': ['NNP'],
  'Elgin': ['NNP'],
  'Eli': ['NNP'],
  'Eliades': ['NNP'],
  'Elianti': ['NNP'],
  'Elias': ['NNP'],
  'Elie': ['NNP'],
  'Eliezer': ['NNP'],
  'Eligibility': ['NN'],
  'Eligio': ['NNP'],
  'Elijah': ['NNP'],
  'Eliminate': ['VB'],
  'Eliminating': ['VBG'],
  'Elimination': ['NN'],
  'Elinor': ['NNP'],
  'Elinsky': ['NNP'],
  'Elios': ['NNP'],
  'Eliot': ['NNP'],
  'Eliot-or-Martin': ['NNP', 'CC', 'NP'],
  'Elisa': ['NNP'],
  'Elisabeth': ['NNP'],
  'Elise': ['NNP'],
  'Elisha': ['NNP'],
  'Elite': ['NNP'],
  'Elizabeth': ['NNP'],
  'Elizabethan': ['JJ'],
  'Elizabethans': ['NNS'],
  'Elizario': ['NNP'],
  'Eljer': ['NNP'],
  'Elkan': ['NNP'],
  'Elkhorn': ['NNP'],
  'Elkin': ['NNP'],
  'Elkind': ['NNP'],
  'Elkins': ['NNP'],
  'Elks': ['NNP'],
  'Elkus': ['NNP'],
  'Ella': ['NNP'],
  'Ellamae': ['NNP'],
  'Elle': ['NNP'],
  'Ellen': ['NNP'],
  'Ellerman': ['NNP'],
  'Ellesmere': ['NNP'],
  'Ellie': ['NNP'],
  'Elliman': ['NNP'],
  'Ellington': ['NNP'],
  'Elliot': ['NNP'],
  'Elliott': ['NNP'],
  'Ellis': ['NNP'],
  'Ellison': ['NNP'],
  'Ellman': ['NNP'],
  'Ellmann': ['NNP'],
  'Ellsaesser': ['NNP'],
  'Ellsworth': ['NNP'],
  'Ellwood': ['NNP'],
  'Elm': ['NNP'],
  'Elman': ['NNP'],
  'Elmer': ['NNP'],
  'Elmgrove': ['NNP'],
  'Elmhurst': ['NNP'],
  'Elmira': ['NNP'],
  'Elmsford': ['NNP'],
  'Eloi': ['NNP'],
  'Eloise': ['NNP'],
  'Eloy': ['NNP'],
  'Elrick': ['NNP'],
  'Elsa': ['NNP'],
  'Else': ['RB'],
  'Elsevier': ['NNP'],
  'Elsewhere': ['RB'],
  'Elshtain': ['NNP'],
  'Elsie': ['NNP'],
  'Elsinore': ['NNP'],
  'Elton': ['NNP'],
  'Eluard': ['NNP'],
  'Elusive': ['NNP'],
  'Elvador': ['NNP'],
  'Elvekrog': ['NNP'],
  'Elvira': ['NNP'],
  'Elvis': ['NNP'],
  'Ely': ['NNP'],
  'Elyria': ['NNP'],
  'Elysees': ['NNP'],
  'Emancipation': ['NNP'],
  'Emanuel': ['NNP'],
  'Emanuele': ['NNP'],
  'Embarcadero': ['NNP'],
  'Embarcaderothe': ['NNP'],
  'Embarrassed': ['JJ'],
  'Embassy': ['NNP'],
  'Embedded': ['VBN'],
  'Embittered': ['JJ'],
  'Emboldened': ['JJ'],
  'Embraer': ['NNP'],
  'Embry': ['NNP'],
  'Embryo': ['NN'],
  'Embryogen': ['NNP'],
  'Embryos': ['NNS'],
  'Emcee': ['NNP'],
  'Emerald': ['NNP'],
  'Emergency': ['NNP'],
  'Emerging': ['VBG'],
  'Emeritus': ['NNP'],
  'Emerson': ['NNP'],
  'Emery': ['NNP'],
  'Emeryville': ['NNP'],
  'Emhart': ['NNP'],
  'Emigrant': ['NNP'],
  'Emigration': ['NN'],
  'Emil': ['NNP'],
  'Emile': ['NNP'],
  'Emilio': ['NNP'],
  'Emily': ['NNP'],
  'Eminase': ['NNP'],
  'Eminonu': ['NNP'],
  'Emirates': ['NNPS'],
  'Emission': ['NN'],
  'Emlyn': ['NNP'],
  'Emma': ['NNP'],
  'Emmanuel': ['NNP'],
  'Emmaus': ['NNP'],
  'Emmerich': ['NNP'],
  'Emmert': ['NNP'],
  'Emmett': ['NNP'],
  'Emmies': ['NNPS'],
  'Emmons': ['NNP'],
  'Emmy': ['NN'],
  'Emory': ['NNP'],
  'Emotional': ['JJ'],
  'Emotionally': ['RB'],
  'Empedocles': ['NNP'],
  'Emperor': ['NNP'],
  'Emperors': ['NNS'],
  'Emphasis': ['NN'],
  'Empire': ['NNP'],
  'Empire-Berol': ['NNP'],
  'Empirically': ['RB'],
  'Employee': ['NNP'],
  'Employee-benefit': ['JJ'],
  'Employee-owned': ['JJ'],
  'Employees': ['NNS'],
  'Employer': ['NN'],
  'Employers': ['NNS'],
  'Employes': ['NNS'],
  'Employment': ['NNP'],
  'Emporium': ['NNP'],
  'Empresa': ['NNP'],
  'Emptied': ['VBD'],
  'Empty': ['JJ'],
  'Emshwiller': ['NNP'],
  'Emulex': ['NNP'],
  'Emyanitoff': ['NNP'],
  'En': ['NNP'],
  'En-lai': ['NNP'],
  'EnClean': ['NNP'],
  'Enasa': ['NNP'],
  'Encare': ['NNP'],
  'Enchaine': ['NNP'],
  'Encino': ['NNP'],
  'Enclosed': ['VBN'],
  'Encompassing': ['VBG'],
  'Encore': ['NNP'],
  'Encourage': ['VB'],
  'Encouraged': ['VBN'],
  'Encouragement': ['NNP'],
  'Encouraging': ['VBG'],
  'Encyclopaedia': ['NNP'],
  'Encyclopedia': ['NNP'],
  'Encylopedia': ['NN'],
  'End': ['NN'],
  'Endangered': ['NNP'],
  'Endara': ['NNP'],
  'Endeavor': ['VB'],
  'Ended': ['NNP'],
  'Endgame': ['NNP'],
  'Endicott': ['NNP'],
  'Ending': ['VBG'],
  'Endless': ['JJ'],
  'Endo': ['NNP'],
  'Endowment': ['NNP'],
  'Ends': ['NNS'],
  'Endure': ['VBP'],
  'Enel': ['NNP'],
  'Enemies': ['NNS'],
  'Enemy': ['NN'],
  'Energetic': ['JJ'],
  'Energie': ['NNP'],
  'Energieproduktiebedrijf': ['NNP'],
  'Energies': ['NNP'],
  'Energized': ['VBN'],
  'Energy': ['NNP'],
  'Enersen': ['NNP'],
  'Enfield': ['NNP'],
  'Enforce': ['VB'],
  'Enforcement': ['NNP'],
  'Enforcers': ['NNS'],
  'Eng': ['NNP'],
  'Engaged': ['VBN'],
  'Engages': ['NNS'],
  'Engaging': ['VBG'],
  'Engel': ['NNP'],
  'Engelhard': ['NNP'],
  'Engelken': ['NNP'],
  'Engh': ['NNP'],
  'Engine': ['NNP'],
  'Engineer': ['NNP'],
  'Engineered': ['NNP'],
  'Engineering': ['NNP'],
  'Engineers': ['NNPS'],
  'Engines': ['NNPS'],
  'Engisch': ['NNP'],
  'England': ['NNP'],
  'England-based': ['JJ'],
  'England-born': ['NNP', 'VBN'],
  'Englander': ['NNP'],
  'Englanders': ['NNPS'],
  'Engle': ['NNP'],
  'Engler': ['NNP'],
  'Engles': ['NNP'],
  'Englewood': ['NNP'],
  'English': ['NNP'],
  'English-Danish': ['NNP'],
  'English-Dutch': ['JJ'],
  'English-Scottish-French': ['NNP'],
  'English-born': ['JJ'],
  'English-dialogue': ['JJ'],
  'English-language': ['JJ'],
  'English-rights': ['JJ'],
  'English-speakers': ['NNS'],
  'English-speaking': ['JJ'],
  'Englishman': ['NNP'],
  'Englishmen': ['NNS'],
  'Englishwoman': ['NNP'],
  'Englishy': ['JJ'],
  'Englund': ['NNP'],
  'Engraph': ['NNP'],
  'Engraving': ['NNP'],
  'Engrg': ['NNP'],
  'Enhance': ['NNP'],
  'Enhanced': ['NNP'],
  'Enhancement': ['NNP'],
  'Enhancements': ['NNP'],
  'Enholme': ['NNP'],
  'EniChem': ['NNP'],
  'Enichem': ['NNP'],
  'Enid': ['NNP'],
  'Enimont': ['NNP'],
  'Enjoy': ['VB'],
  'Enjoying': ['VBG'],
  'Enlargement': ['NN'],
  'Ennis': ['NNP'],
  'Enoch': ['NNP'],
  'Enormous': ['JJ'],
  'Enos': ['NNP'],
  'Enough': ['JJ'],
  'Enquirer': ['NNP'],
  'Enrico': ['NNP'],
  'Enright': ['NNP'],
  'Enrique': ['NNP'],
  'Enron': ['NNP'],
  'Ensemble': ['NNP'],
  'Enserch': ['NNP'],
  'Ensign': ['NNP'],
  'Enskilda': ['NNP'],
  'Ensolite': ['NN'],
  'Ensrud': ['NNP'],
  'Ente': ['NNP'],
  'Entenmann': ['NNP'],
  'Enter': ['VB'],
  'Entergy': ['NNP'],
  'Entering': ['NNP'],
  'Enterprise': ['NNP'],
  'Enterprises': ['NNPS'],
  'Entertaining': ['NNP'],
  'Entertainment': ['NNP'],
  'Entex': ['NNP'],
  'Enthoven': ['NNP'],
  'Enthusiasm': ['NN'],
  'Enthusiast': ['NNP'],
  'Enthusiastic': ['JJ'],
  'Enthusiastically': ['RB'],
  'Enthusiasts': ['NNS'],
  'Entirely': ['RB'],
  'Entitlements': ['NNS'],
  'Entombment': ['NN'],
  'Entrance': ['NN'],
  'Entre': ['NNP'],
  'Entree': ['NNP'],
  'Entrekin': ['NNP'],
  'Entrenched': ['VBN'],
  'Entrepreneur': ['NN'],
  'Entrepreneurs': ['NNS'],
  'Entries': ['NNS'],
  'Entry': ['NN'],
  'Entwhistle': ['NNP'],
  'Enver': ['NNP'],
  'Envigado': ['NNP'],
  'Enviro-Gro': ['NNP'],
  'Environment': ['NNP'],
  'Environmental': ['NNP'],
  'Environmentalism': ['NNP'],
  'Environmentalists': ['NNS'],
  'Enviropact': ['NNP'],
  'Enzo': ['NNP'],
  'Enzor': ['NNP'],
  'Enzymatic': ['JJ'],
  'Enzytech': ['NNP'],
  'Epes': ['NNP'],
  'Eph': ['NNP'],
  'Ephesians': ['NNPS'],
  'Ephesus': ['NNP'],
  'Ephlin': ['NNP'],
  'Ephron': ['NNP'],
  'Epicurean': ['JJ'],
  'Epicurus': ['NNP'],
  'Epidemiological': ['JJ'],
  'Epigraph': ['NN'],
  'Epilady': ['NNP'],
  'Epilepsy': ['NNP'],
  'Epinal': ['NNP'],
  'Epinalers': ['NNPS'],
  'Epiphany': ['NNP'],
  'Episcopal': ['NNP'],
  'Episcopalians': ['NNPS'],
  'Episodes': ['NNS'],
  'Epistles': ['NNPS'],
  'Epitaph': ['NNP'],
  'Epp': ['NNP'],
  'Eppel': ['NNP'],
  'Eppelmann': ['NNP'],
  'Eppler': ['NNP'],
  'Epplers': ['NNP'],
  'Eppner': ['NNP'],
  'Epps': ['NNP'],
  'Eprex': ['NNP'],
  'Epsilon': ['NNP'],
  'Epsom': ['NNP'],
  'Epson': ['NNP'],
  'Epstein': ['NNP'],
  'Eq.': ['NN'],
  'Equal': ['NNP'],
  'Equality': ['NNP'],
  'Equalizer': ['NNP'],
  'Equally': ['RB'],
  'Equate': ['VB'],
  'Equations': ['NNS'],
  'Equator': ['NNP'],
  'Equestrian': ['NNP'],
  'Equibank': ['NNP'],
  'Equifax': ['NNP'],
  'Equimark': ['NNP'],
  'Equinox': ['NNP'],
  'Equipement': ['NNP'],
  'Equipment': ['NNP'],
  'Equipped': ['VBN'],
  'Equitable': ['NNP'],
  'Equitec': ['NNP'],
  'Equities': ['NNPS'],
  'Equity': ['NNP'],
  'Equity-Income': ['NNP'],
  'Equivalent': ['NN'],
  'Equivalents': ['NNS'],
  'Equus': ['NNP'],
  'Era': ['NNP'],
  'Erasing': ['VBG'],
  'Erasmus': ['NNP'],
  'Erath': ['NNP'],
  'Erbamont': ['NNP'],
  'Erburu': ['NNP'],
  'Erde': ['NNP'],
  'Erdman': ['NNP'],
  'Erdmann': ['NN'],
  'Erdolversorgungs': ['NNP'],
  'Erdos': ['NNP'],
  'Erected': ['VBN'],
  'Erection': ['NNP'],
  'Erensel': ['NNP'],
  'Erfurt': ['NNP'],
  'Erhart': ['NNP'],
  'Eric': ['NNP'],
  'Erich': ['NNP'],
  'Erickson': ['NNP'],
  'Ericson': ['NNP'],
  'Erie': ['NNP'],
  'Erik': ['NNP'],
  'Erikson': ['NNP'],
  'Erin': ['NNP'],
  'Eriskay': ['NNP'],
  'Erithmatic': ['NN'],
  'Eritrea': ['NNP'],
  'Eritrean': ['JJ'],
  'Eritreans': ['NNPS'],
  'Erjun': ['NNP'],
  'Erle': ['NNP'],
  'Erlenborn': ['NNP'],
  'Erlenmeyer': ['NN'],
  'Erling': ['NNP'],
  'Erma': ['NNP'],
  'Ermanno': ['NNP'],
  'Ernest': ['NNP'],
  'Ernesto': ['NNP'],
  'Ernie': ['NNP'],
  'Ernst': ['NNP'],
  'Erodes': ['VBZ'],
  'Eromonga': ['NNP'],
  'Eros': ['NNP'],
  'Erosion': ['NN'],
  'Erotic': ['NNP'],
  'Err': ['VB'],
  'Errol': ['NNP'],
  'Erroll': ['NNP'],
  'Errors': ['NNS'],
  'Erskin': ['NNP'],
  'Erskine': ['NNP'],
  'Ervin': ['NNP'],
  'Erwin': ['NNP'],
  'Esber': ['NNP'],
  'Escadrille': ['NNP'],
  'Escalante': ['NNP'],
  'Escalation': ['NN'],
  'Escanaba': ['NNP'],
  'Escape': ['NNP'],
  'Eschewing': ['VBG'],
  'Escobar': ['NNP'],
  'Escort': ['NNP'],
  'Escorts': ['NNS'],
  'Escudome': ['NNP'],
  'Esher': ['NNP'],
  'Eshleman': ['NNP'],
  'Eskandarian': ['NNP'],
  'Eskenazi': ['NNP'],
  'Eskimo': ['NNP'],
  'Eskimos': ['NNPS'],
  'Eskridge': ['NNP'],
  'Eslinger': ['NNP'],
  'Esmarch': ['NNP'],
  'Esnard': ['NNP'],
  'Esnards': ['NNPS'],
  'Esopus': ['NNP'],
  'Espagnol': ['NNP'],
  'Espana': ['NNP'],
  'Espanol': ['NNP'],
  'Especially': ['RB'],
  'Espectador': ['NNP'],
  'Espenhain': ['NNP'],
  'Esperanza': ['NNP'],
  'Espinosa': ['NNP'],
  'Esplanade': ['NNP'],
  'Espre': ['NNP'],
  'Esprit': ['NNP'],
  'Espy': ['NNP'],
  'Esquire': ['NNP'],
  'Esquivel': ['NNP'],
  'Esrey': ['NNP'],
  'Essar': ['NNP'],
  'Esselte': ['NNP'],
  'Essen': ['NNP'],
  'Essentially': ['RB'],
  'Essex': ['NNP'],
  'Esso': ['NNP'],
  'Establish': ['VB'],
  'Established': ['VBN'],
  'Establishing': ['VBG'],
  'Establishment': ['NNP'],
  'Estancieros': ['NNS'],
  'Estate': ['NNP'],
  'Estates': ['NNP'],
  'Esteban': ['NNP'],
  'Estee': ['NNP'],
  'Esteli': ['NNP'],
  'Estella': ['NNP'],
  'Estep': ['NNP'],
  'Estes': ['NNP'],
  'Esther': ['NNP'],
  'Estherson': ['NNP'],
  'Estimate': ['NNP'],
  'Estimated': ['VBN'],
  'Estimates': ['NNS'],
  'Estimating': ['VBG'],
  'Estonia': ['NNP'],
  'Estonian': ['JJ'],
  'Estonian-language': ['JJ'],
  'Estonians': ['NNPS'],
  'Estuary': ['NNP'],
  'Eta': ['NNP'],
  'Etablissements': ['NNP'],
  'Etc.': ['NNP'],
  'Etch-a-Sketch': ['NNP'],
  'Eternal': ['NNP'],
  'Eternity': ['NN'],
  'Etess': ['NNP'],
  'Ethan': ['NNP'],
  'Ethane': ['NN'],
  'Ethel': ['NNP'],
  'Ethel-Jane': ['NNP'],
  'Ethernet': ['NNP'],
  'Ethical': ['NNP'],
  'Ethicist': ['NN'],
  'Ethics': ['NNP'],
  'Ethiopia': ['NNP'],
  'Ethiopian': ['JJ'],
  'Ethiopians': ['NNPS'],
  'Ethocyn': ['NNP'],
  'Ethyl': ['NNP'],
  'Etienne-Emile': ['NNP'],
  'Etruscan': ['JJ'],
  'Etsuko': ['NNP'],
  'Etsuro': ['NNP'],
  'Etsy': ['NNP'],
  'Ettore': ['NNP'],
  'Etudes': ['NNP'],
  'Etzioni': ['NNP'],
  'Eubank': ['NNP'],
  'Eubanks': ['NNP'],
  'Eubie': ['NNP'],
  'Euclid': ['NNP'],
  'Eugene': ['NNP'],
  'Eugenia': ['NNP'],
  'Euler': ['NNP'],
  'Euphoria': ['NNP'],
  'Euralliance': ['NNP'],
  'Eurasian': ['NNP'],
  'Euratom': ['NNP'],
  'Eureka': ['NNP'],
  'Euripides': ['NNP'],
  'Euro': ['NNP'],
  'Euro-Belge': ['NNP'],
  'Euro-Communist': ['NNP'],
  'Euro-TV': ['NNP'],
  'Euro-ashtrays': ['NNS'],
  'Euro-banners': ['NNS'],
  'Euro-barbecue': ['NN'],
  'Euro-beach': ['NN'],
  'Euro-caps': ['NNS'],
  'Euro-cards': ['NNS'],
  'Euro-cigarette': ['NN'],
  'Euro-consumers': ['NNPS'],
  'Euro-enthusiasts': ['NNS'],
  'Euro-factories': ['NNS'],
  'Euro-housewife': ['NN'],
  'Euro-jogging': ['JJ'],
  'Euro-pillows': ['NNS'],
  'Euro-playing': ['JJ'],
  'Euro-products': ['NNS'],
  'Euro-son': ['NN'],
  'Euro-that': ['NN'],
  'Euro-this': ['NN'],
  'Euro-watches': ['NNS'],
  'EuroBelge': ['NNP'],
  'EuroTV': ['NNP'],
  'Eurobond': ['NNP'],
  'Eurobonds': ['NNS'],
  'Eurocell': ['NNP'],
  'Eurocom': ['NNP'],
  'Eurocommercial': ['JJ'],
  'Euroconsumer': ['NN'],
  'Euroconvertible': ['JJ'],
  'Eurocops': ['NNPS'],
  'Eurocracy': ['NN'],
  'Eurocrat': ['NN'],
  'Eurocrats': ['NNS'],
  'Eurocrooks': ['NNPS'],
  'Eurodebentures': ['NNS'],
  'Eurodebt': ['NNP'],
  'Eurodollar': ['NN'],
  'Eurodynamics': ['NNPS'],
  'Eurofighter': ['NNP'],
  'Eurofima': ['NNP'],
  'Euroflics': ['NNPS'],
  'Euroissues': ['NNS'],
  'Eurokitsch': ['NN'],
  'Euromark': ['NN'],
  'Euromarket': ['NNP'],
  'Euronotes': ['NNS'],
  'Europa': ['NNP'],
  'Europalia': ['NNP'],
  'Europe': ['NNP'],
  'Europe-based': ['JJ'],
  'Europe-wide': ['JJ'],
  'European': ['JJ'],
  'European-American': ['NNP'],
  'European-based': ['JJ'],
  'European-branch': ['JJ'],
  'European-made': ['JJ'],
  'European-minded': ['JJ'],
  'Europeanish': ['JJ'],
  'Europeanization': ['NN'],
  'Europeanized': ['VBN'],
  'Europeans': ['NNPS'],
  'Europhoria': ['NN'],
  'Euroshuttle': ['NNP'],
  'Eurostat': ['NNP'],
  'Eurotempo': ['NNP'],
  'Eurotunnel': ['NNP'],
  'Eurovision': ['NNP'],
  'Euroyen': ['NNP'],
  'Eurydice': ['NNP'],
  'Eustis': ['NNP'],
  'Euthanasia': ['NN'],
  'Euzhan': ['NNP'],
  'Evadna': ['NNP'],
  'Evaluating': ['VBG'],
  'Evaluation': ['NN'],
  'Evaluations': ['NNS'],
  'Evan': ['NNP'],
  'Evangelical': ['JJ'],
  'Evangelicalism': ['NNP'],
  'Evangeline': ['NNP'],
  'Evangelism': ['NNP'],
  'Evangelista': ['NNP'],
  'Evans': ['NNP'],
  'Evans-Black': ['NNP'],
  'Evanston': ['NNP'],
  'Evansville': ['NNP'],
  'Evarsito': ['NNP'],
  'Eve': ['NNP'],
  'Evegeni': ['NNP'],
  'Evelyn': ['NNP'],
  'Even': ['RB'],
  'Evenflo': ['NNP'],
  'Evening': ['NNP'],
  'Evenings': ['RB'],
  'Evensen': ['NNP'],
  'Event': ['NN'],
  'Events': ['NNS'],
  'Eventually': ['RB'],
  'Ever': ['RB'],
  'Ever-confident': ['JJ'],
  'Ever-more': ['RB'],
  'Eveready': ['NNP'],
  'Everest': ['NNP'],
  'Everett': ['NNP'],
  'Everglades': ['NNP'],
  'Evergreen': ['NNP'],
  'Everhart': ['NNP'],
  'Everly': ['NNP'],
  'Everlys': ['NNS'],
  'Evershed': ['NNP'],
  'Every': ['DT'],
  'Everybody': ['NN'],
  'Everyman': ['NNP'],
  'Everyone': ['NN'],
  'Everything': ['NN'],
  'Everytime': ['RB'],
  'Everywhere': ['RB'],
  'Evian': ['NNP'],
  'Evidence': ['NN'],
  'Evidences': ['NNS'],
  'Evident': ['JJ'],
  'Evidently': ['RB'],
  'Evil': ['NNP'],
  'Evolution': ['NNP'],
  'Evolving': ['VBG'],
  'Evren': ['NNP'],
  'Evry': ['NNP'],
  'Evzone': ['NNP'],
  'Ewan': ['NNP'],
  'Eward': ['NNP'],
  'Ewe': ['NNP'],
  'Ewen': ['NNP'],
  'Ewing': ['NNP'],
  'Ex-Cub': ['JJ'],
  'Ex-Im': ['NNP'],
  'Ex-Oriole': ['NNP'],
  'Ex-Premier': ['NNP'],
  'Ex-Presidents': ['NNS'],
  'Ex-Wells': ['NNP'],
  'Ex-smokers': ['NNS'],
  'ExPe': ['NNP'],
  'Exabyte': ['NNP'],
  'Exact': ['JJ'],
  'Exactly': ['RB'],
  'Exaggerated': ['VBN'],
  'Examination': ['NN'],
  'Examiner': ['NNP'],
  'Examiners': ['NNP'],
  'Example': ['NN'],
  'Examples': ['NNS'],
  'Exboyfriend': ['NN'],
  'Excalibur': ['NNP'],
  'Exceed': ['VBD'],
  'Excel': ['NNP'],
  'Excell': ['NNP'],
  'Excellence': ['NN'],
  'Excellency': ['NNP'],
  'Excellent': ['JJ'],
  'Excels': ['NNS'],
  'Excelsior': ['NNP'],
  'Except': ['IN'],
  'Exceptional': ['NNP'],
  'Exceptions': ['NNS'],
  'Excerpts': ['NNS'],
  'Excess': ['JJ'],
  'Exch': ['NN'],
  'Exchange': ['NNP'],
  'Exchange-listed': ['JJ'],
  'Exchange-rate': ['JJ'],
  'Exchange-sponsored': ['JJ'],
  'Exchangeable': ['NNP'],
  'Exchanges': ['NNS'],
  'Exchequer': ['NNP'],
  'Exchnage': ['NNP'],
  'Excise-tax': ['JJ'],
  'Excision': ['NN'],
  'Excited': ['JJ'],
  'Excitement': ['NN'],
  'Exclaimed': ['VBD'],
  'Excluded': ['VBN'],
  'Excludes': ['VBZ'],
  'Excluding': ['VBG'],
  'Exclusion': ['NN'],
  'Exclusive': ['JJ'],
  'Excuse': ['VB'],
  'Excuses': ['NNPS'],
  'Executed': ['VBD'],
  'Execution': ['NNP'],
  'Executioner': ['NN'],
  'Executions': ['NNS'],
  'Executive': ['NNP'],
  'Executive-branch': ['JJ'],
  'Executives': ['NNS'],
  'Exegete': ['NNP'],
  'Exemption': ['NN'],
  'Exercise': ['NN'],
  'Exeter': ['NNP'],
  'Exhausted': ['JJ'],
  'Exhibit': ['NN'],
  'Exhibited': ['VBN'],
  'Exhibition': ['NNP'],
  'Exhibits': ['NNPS'],
  'Existence': ['NN'],
  'Existentialism': ['NNP'],
  'Existentialists': ['NNS'],
  'Existing': ['VBG'],
  'Exit': ['NN'],
  'Exitosa': ['NNP'],
  'Exocet': ['NNP'],
  'Exodus': ['NNP'],
  'Expand': ['NNP'],
  'Expanded': ['VBN'],
  'Expanding': ['VBG'],
  'Expands': ['VBZ'],
  'Expansion': ['NN'],
  'Expect': ['VB'],
  'Expectations': ['NNS'],
  'Expected': ['VBN'],
  'Expecting': ['VBG'],
  'Expects': ['NNS'],
  'Expedition': ['NNP'],
  'Expenditure': ['NNP'],
  'Expenditures': ['NNS'],
  'Expense': ['NN'],
  'Expenses': ['NNS'],
  'Experience': ['NN'],
  'Experienced': ['VBN'],
  'Experiencing': ['VBG'],
  'Experiment': ['NN'],
  'Experimental': ['JJ'],
  'Experimentally': ['RB'],
  'Experimenting': ['VBG'],
  'Experiments': ['NNS'],
  'Experts': ['NNS'],
  'Explain': ['VB'],
  'Explained': ['NNP'],
  'Explaining': ['VBG'],
  'Explains': ['VBZ'],
  'Explanations': ['NNS'],
  'Explicit': ['JJ'],
  'ExploiTech': ['NNP'],
  'Explonaft': ['NNP'],
  'Exploracion': ['NNP'],
  'Exploration': ['NNP'],
  'Exploratory': ['JJ'],
  'Explorer': ['NNP'],
  'Explosion': ['NN'],
  'Explosions': ['NNS'],
  'Expo': ['NNP'],
  'Exponents': ['NNS'],
  'Export': ['NNP'],
  'Export-Import': ['NNP'],
  'Exporters': ['NNPS'],
  'Exporting': ['NNP'],
  'Exportkredit': ['NNP'],
  'Exports': ['NNS'],
  'Expos': ['NNPS'],
  'Exposition': ['NNP'],
  'Exposure': ['NN'],
  'Express': ['NNP'],
  'Express-Buick': ['NNP'],
  'Expressed': ['VBN'],
  'Expresses': ['VBZ'],
  'Expressing': ['VBG'],
  'Expressionism': ['NNP'],
  'Expressions': ['NNS'],
  'Expressway': ['NNP'],
  'Expressways': ['NNP'],
  'Extend': ['VB'],
  'Extended': ['NNP'],
  'Extending': ['VBG'],
  'Extension': ['NNP'],
  'Extensions': ['NNS'],
  'Extensive': ['JJ'],
  'Extensor': ['NNP'],
  'Exterior': ['NNP'],
  'Exteriors': ['NNS'],
  'Exterminatin': ['VBG'],
  'External': ['JJ'],
  'Extinction': ['NNP'],
  'Exton': ['NNP'],
  'Extra': ['NNP'],
  'Extractor': ['NN'],
  'Extracts': ['NNS'],
  'Extraordinary': ['JJ'],
  'Extrapolation': ['NN'],
  'Extremadura': ['NNP'],
  'Extreme': ['JJ'],
  'Extricating': ['VBG'],
  'Extruded': ['VBN'],
  'Exxon': ['NNP'],
  'Exxon-Valdez': ['JJ'],
  'Exxon-owned': ['JJ'],
  'Eye': ['NNP'],
  'Eyes': ['NNP'],
  'Eyewear': ['NNP'],
  'Eyke': ['NNP'],
  'Ezekiel': ['NNP'],
  'Ezra': ['NNP'],
  'F': ['NN'],
  'F-108': ['NN'],
  'F-14': ['NN'],
  'F-14s': ['NNS'],
  'F-15': ['NNP'],
  'F-16': ['NNP'],
  'F-16s': ['NNPS'],
  'F-18': ['NN'],
  'F-18s': ['NNS'],
  'F-20': ['NNP'],
  'F-20s': ['NNPS'],
  'F-4': ['NNP'],
  'F-A-18': ['NN'],
  'F-major': ['NN'],
  'F-series': ['NNPS'],
  'F.': ['NNP'],
  'F.A.': ['NNP'],
  'F.A.O.': ['NNP'],
  'F.B.': ['NNP'],
  'F.B.I.': ['NN'],
  'F.C': ['NNP'],
  'F.D.': ['NNP'],
  'F.D.R.': ['NNP'],
  'F.E.': ['NNP'],
  'F.E.L.': ['NNP'],
  'F.G.': ['NNP'],
  'F.H.': ['NNP'],
  'F.J.': ['NNP'],
  'F.L.': ['NNP'],
  'F.N.': ['NNP'],
  'F.O.': ['NNP'],
  'F.O.O.D.': ['NNP'],
  'F.R': ['NN'],
  'F.R.': ['NN'],
  'F.S.B.': ['NNP'],
  'F.S.C.': ['NNP'],
  'F.S.L.I.C': ['NNP'],
  'F.Supp.235': ['CD'],
  'F.W.': ['NNP'],
  'F100-PW-200': ['NNP'],
  'F111': ['NN'],
  'F16s': ['NNS'],
  'F18s': ['NNS'],
  'FAA': ['NNP'],
  'FAC': ['NNP'],
  'FACES': ['VBZ'],
  'FACING': ['VBG'],
  'FADA': ['NNP'],
  'FADE': ['VBP'],
  'FAI': ['NNP'],
  'FAILED': ['VBD'],
  'FAKE': ['JJ'],
  'FALL': ['NN'],
  'FALTERS': ['NNP'],
  'FAMILY': ['NN'],
  'FAN': ['NN'],
  'FAR': ['RB'],
  'FARGO': ['NNP'],
  'FARM': ['NN'],
  'FARMER\'S': ['NN'],
  'FARMERS': ['NNS'],
  'FARMING': ['NNP'],
  'FASB': ['NNP'],
  'FAST': ['NNP'],
  'FAST-FOOD': ['NN'],
  'FATHER': ['NN'],
  'FAX': ['NNP'],
  'FAXM': ['NNP'],
  'FB': ['NNP'],
  'FBI': ['NNP'],
  'FCB\\\'': ['NNP'],
  'FCB\\\'/Leber': ['NNP'],
  'FCC': ['NNP'],
  'FDA': ['NNP'],
  'FDA-NIH-industry': ['JJ'],
  'FDA-approved': ['JJ'],
  'FDA-defined': ['JJ'],
  'FDA-regulated': ['JJ'],
  'FDC': ['NNP'],
  'FDIC': ['NNP'],
  'FDR': ['NNP'],
  'FE': ['NNP'],
  'FEAR': ['VBP'],
  'FEARS': ['NNS'],
  'FED': ['NNP'],
  'FEDERAL': ['NNP'],
  'FELA': ['NNP'],
  'FELLED': ['VBD'],
  'FELLOWSHIP': ['NN'],
  'FEMA': ['NNP'],
  'FEMALES': ['NNS'],
  'FERC': ['NNP'],
  'FEWER': ['JJR'],
  'FFA': ['NNP'],
  'FFr1': ['NNP'],
  'FFr27.68': ['NN'],
  'FH-77B': ['NNP'],
  'FHA': ['NNP'],
  'FHA-backed': ['JJ'],
  'FHA-insured': ['JJ'],
  'FHLBB': ['NNP'],
  'FHP': ['NNP'],
  'FIAT': ['NNP'],
  'FICO': ['NNP'],
  'FICOs': ['NNS'],
  'FIDELITY': ['NNP'],
  'FIG': ['NNP'],
  'FIGHT': ['NNP'],
  'FII': ['NNP'],
  'FINAL': ['JJ'],
  'FINANCES': ['NNS'],
  'FINANCIAL': ['NNP'],
  'FIRM': ['NN'],
  'FIRMS': ['NNS'],
  'FIRST': ['NNP'],
  'FIRST-TIME': ['JJ'],
  'FIT': ['NNP'],
  'FITC': ['NNP'],
  'FIVE': ['CD'],
  'FK-506': ['NNP'],
  'FLAG': ['NN'],
  'FLARE': ['VBP'],
  'FLARE-OFF': ['NN'],
  'FLIGHT': ['NN'],
  'FLN': ['NNP'],
  'FLORIDA': ['NNP'],
  'FLYING': ['VBG'],
  'FM': ['NNP'],
  'FM12.6': ['CD'],
  'FM21': ['CD'],
  'FM9.4': ['CD'],
  'FMC': ['NNP'],
  'FMI': ['NNP'],
  'FMR': ['NNP'],
  'FN': ['NNP'],
  'FNMA': ['NNP'],
  'FOES': ['NNS'],
  'FOILED': ['VBD'],
  'FOMC': ['NNP'],
  'FOOD': ['NNP'],
  'FOOTNOTE': ['NNP'],
  'FOR': ['IN'],
  'FORCE': ['VBP'],
  'FORCES': ['NNS'],
  'FORD': ['NNP'],
  'FOREAMI': ['NNP'],
  'FOREIGN': ['JJ'],
  'FORGN': ['NNP'],
  'FORMER': ['JJ'],
  'FORMERLY': ['RB'],
  'FOUNDER': ['NN'],
  'FOUR': ['CD'],
  'FOX': ['NN'],
  'FPA': ['NNP'],
  'FPL': ['NNP'],
  'FRANCHISE': ['NN'],
  'FRANCISCO\'S': ['NNP'],
  'FRANKENBERRY': ['NNP'],
  'FRANKFURT': ['NNP'],
  'FRANKLIN': ['NNP'],
  'FRAUDS': ['NNS'],
  'FRE': ['NNP'],
  'FREDERICK\'S': ['NNP'],
  'FREED': ['VBD'],
  'FREEZE': ['VB'],
  'FREIGHTWAYS': ['NNP'],
  'FRICTION': ['NN'],
  'FRINGE-BENEFIT': ['JJ'],
  'FROG-7B': ['NN'],
  'FROM': ['IN'],
  'FSLIC': ['NNP'],
  'FSX': ['NNP'],
  'FT': ['NNP'],
  'FT-SE': ['NNP'],
  'FTC': ['NNP'],
  'FUCK': ['NN'],
  'FUND': ['NNP'],
  'FUNDS': ['NNS'],
  'FUTURES': ['NNS'],
  'FXTV': ['NNP'],
  'F\\\'': ['NN'],
  'F\\\'/A18': ['NNP'],
  'Fab': ['NNP'],
  'Fabbri': ['NNP'],
  'Faber': ['NNP'],
  'Faberge': ['NNP'],
  'Fabi': ['NNP'],
  'Fabian': ['NNP'],
  'Fable': ['NNP'],
  'Fabric': ['NN'],
  'Fabricius': ['NNP'],
  'Fabrics': ['NNP'],
  'Fabrri': ['NNP'],
  'Fabulous': ['NNP'],
  'Face': ['NNP'],
  'Facebook': ['NNP'],
  'Faced': ['VBN'],
  'Faces': ['NNPS'],
  'Facetious': ['NNP'],
  'Facilitatory': ['JJ'],
  'Facilities': ['NNPS'],
  'Facility': ['NNP'],
  'Facing': ['VBG'],
  'Factions': ['NNS'],
  'Factor': ['NNP'],
  'Factor-VIII': ['NNP'],
  'Factorex': ['NNP'],
  'Factories': ['NNS'],
  'Factoring': ['NN'],
  'Factors': ['NNS'],
  'Factory': ['NN'],
  'Factory-to-You': ['NNP'],
  'Facts': ['NNP'],
  'Faculty': ['NN'],
  'Fads': ['NNS'],
  'Fagan': ['NNP'],
  'Fagenson': ['NNP'],
  'Fagershein': ['NNP'],
  'Faget': ['NNP'],
  'Fahd': ['NNP'],
  'Fahey': ['NNP'],
  'Fahlgren': ['NNP'],
  'Fahrenheit': ['NNP'],
  'Faight': ['NNP'],
  'Fail': ['NNP'],
  'Failing': ['VBG'],
  'Fails': ['NNS'],
  'Failure': ['NN'],
  'Failures': ['NNS'],
  'Fain': ['NNP'],
  'Faint': ['JJ'],
  'Fair': ['NNP'],
  'Fair-priced': ['JJ'],
  'Fairbanks': ['NNP'],
  'Fairbrothers': ['NNP'],
  'Fairchild': ['NNP'],
  'Fairfax': ['NNP'],
  'Fairfield': ['NNP'],
  'Fairing': ['NN'],
  'Fairlawn': ['NNP'],
  'Fairless': ['NNP'],
  'Fairly': ['RB'],
  'Fairmont': ['NNP'],
  'Fairmount': ['NNP'],
  'Fairness': ['NNP'],
  'Fairview': ['NNP'],
  'Fairy': ['NNP'],
  'Faith': ['NNP'],
  'Faithful': ['NN'],
  'Fake': ['JJ'],
  'Fakty': ['NNP'],
  'Falb': ['NNP'],
  'Falco': ['NNP'],
  'Falcon': ['NNP'],
  'Falconbridge': ['NNP'],
  'Falconer': ['NNP'],
  'Falconry': ['NNP'],
  'Falcons': ['NNS'],
  'Falegnami': ['NNP'],
  'Falin': ['NNP'],
  'Falkland': ['NNP'],
  'Falklands': ['NNP'],
  'Fall': ['NNP'],
  'Fall-in': ['NNP'],
  'Falla': ['NNP'],
  'Fallen': ['NNP'],
  'Fallick': ['NNP'],
  'Falling': ['VBG'],
  'Fallon': ['NNP'],
  'Fallout': ['NNP'],
  'Falls': ['NNP'],
  'Falmouth': ['NNP'],
  'False': ['NNP'],
  'Falstaff': ['NNP'],
  'Falvey': ['NNP'],
  'Falwell': ['NNP'],
  'Falwell-Robertson': ['NNP'],
  'Falwell-like': ['JJ'],
  'Famcorp': ['NNP'],
  'Fame': ['NNP'],
  'Famed': ['JJ'],
  'Familia': ['NNP'],
  'Families': ['NNS'],
  'Familism': ['NN'],
  'Family': ['NNP'],
  'Family-owned': ['JJ'],
  'Famine': ['NN'],
  'Famous': ['NNP'],
  'Famous-Barr': ['NNP'],
  'Fan': ['NNP'],
  'Fancy': ['NNP'],
  'Faneuil': ['NNP'],
  'Fang': ['NNP'],
  'Fannie': ['NNP'],
  'Fanning': ['NNP'],
  'Fanny': ['NNP'],
  'Fans': ['NNS'],
  'Fanshawe': ['NNP'],
  'Fantasia': ['NNP'],
  'Fantastic': ['JJ'],
  'Fantastico': ['NNP'],
  'Fantasy': ['NNP'],
  'Fanuc': ['NNP'],
  'Far': ['NNP'],
  'Far-reaching': ['JJ'],
  'Faraday': ['NNP'],
  'Farberware': ['NNP'],
  'Fardulli': ['NNP'],
  'Fare': ['VBP'],
  'Farentino': ['NNP'],
  'Fares': ['NNS'],
  'Farewell': ['NNP'],
  'Farge': ['NNP'],
  'Fargo': ['NNP'],
  'Farina': ['NNP'],
  'Farley': ['NNP'],
  'Farm': ['NNP'],
  'Farm-machine': ['NN'],
  'Farmaco': ['NNP'],
  'Farmboy': ['NNP'],
  'Farmer': ['NNP'],
  'Farmer-in-the-Dell': ['NNP'],
  'Farmers': ['NNP'],
  'Farming': ['VBG'],
  'Farmingdale': ['NNP'],
  'Farmington': ['NNP'],
  'Farmland': ['NNP'],
  'Farms': ['NNP'],
  'Farmwife': ['NNP'],
  'Farnell': ['NNP'],
  'Farnese': ['NNP'],
  'Farneses': ['NNPS'],
  'Farney': ['NNP'],
  'Farnham': ['NNP'],
  'Farnum': ['NNP'],
  'Farnworth': ['NNP'],
  'Farooquee': ['NNP'],
  'Farouk': ['NNP'],
  'Farr': ['NNP'],
  'Farra': ['NNP'],
  'Farragut': ['NNP'],
  'Farrar': ['NNP'],
  'Farrell': ['NNP'],
  'Farrells': ['NNPS'],
  'Farren': ['NNP'],
  'Farrow': ['NNP'],
  'Farther': ['RB'],
  'Farthing': ['NNP'],
  'Farvel-Topsy': ['NNP'],
  'Farwell': ['NNP'],
  'Fas-antigen': ['NN'],
  'Fascio-Communist': ['JJ'],
  'Fascism': ['NNP'],
  'Fascist': ['NNP'],
  'Fascists': ['NNPS'],
  'Fashion': ['NNP'],
  'Fashions': ['NNPS'],
  'Fasken': ['NNP'],
  'Faso': ['NNP'],
  'Fassbinder': ['NNP'],
  'Fast': ['NNP'],
  'Fast-food': ['NN'],
  'Fastenal': ['NNP'],
  'Faster': ['JJR'],
  'Fat': ['NNP'],
  'Fatah': ['NNP'],
  'Fatal': ['NNP'],
  'Fatalities': ['NNS'],
  'Fate': ['NNP'],
  'Father': ['NNP'],
  'Father-God': ['NNP'],
  'Fathers': ['NNPS'],
  'Fathi': ['NNP'],
  'Fatima': ['NNP'],
  'Fatimata': ['NNP'],
  'Fatman': ['NNP'],
  'Fats': ['NNP'],
  'Fatso': ['NN'],
  'Faulder': ['NNP'],
  'Faulding': ['NNP'],
  'Faulk': ['NNP'],
  'Faulkner': ['NNP'],
  'Faulknerian': ['JJ'],
  'Fault': ['NNP'],
  'Fault-tolerant': ['JJ'],
  'Fauntleroy': ['NNP'],
  'Fauntroy': ['NNP'],
  'Faust': ['NNP'],
  'Faustian': ['JJ'],
  'Fausto': ['NNP'],
  'Faustus': ['NNP'],
  'Favor': ['VB'],
  'Favorable': ['JJ'],
  'Favored': ['JJ'],
  'Favorite': ['NNP'],
  'Favorites': ['NNPS'],
  'Favour': ['NN'],
  'Favre': ['NNP'],
  'Fawaz': ['NNP'],
  'Fawcett': ['NNP'],
  'Fawell': ['NNP'],
  'Fawkes': ['NNP'],
  'Fawn': ['NNP'],
  'Fawzi': ['NNP'],
  'Fawzy': ['NNP'],
  'Fax': ['NNP'],
  'Faxes': ['NNS'],
  'Fay': ['NNP'],
  'Faye': ['NNP'],
  'Fayette': ['NNP'],
  'Fayetteville': ['NNP'],
  'Fazio': ['NNP'],
  'Fe': ['NNP'],
  'Fear': ['NN'],
  'Fear-maddened': ['JJ'],
  'Feared': ['VBN'],
  'Fearful': ['JJ'],
  'Fearing': ['VBG'],
  'Fearless': ['NNP'],
  'Fearon': ['NNP'],
  'Fears': ['NNS'],
  'Featherbed': ['NN'],
  'Featherston': ['NNP'],
  'Feathertop': ['NNP'],
  'Featherweight': ['NN'],
  'Feature': ['NNP'],
  'Features': ['NNPS'],
  'Feb.': ['NNP'],
  'February': ['NNP'],
  'Fed': ['NNP'],
  'Fed-bashing': ['NN'],
  'Fed-watching': ['JJ'],
  'Fedders': ['NNP'],
  'Federal': ['NNP'],
  'Federal-Mogul': ['NNP'],
  'Federal-Tiger': ['NNP'],
  'Federal-court': ['JJ'],
  'Federalist': ['NNP'],
  'Federals': ['NN'],
  'Federated': ['NNP'],
  'Federation': ['NNP'],
  'Federico': ['NNP'],
  'Feders': ['NNP'],
  'Feds': ['NNPS'],
  'Fee': ['NN'],
  'Feebly': ['RB'],
  'Feed': ['VB'],
  'Feedback': ['NN'],
  'Feeder': ['NN'],
  'Feeding': ['NNP'],
  'Feedlots': ['NNS'],
  'Feeds': ['NNS'],
  'Feelers': ['NNS'],
  'Feeley': ['NNP'],
  'Feeling': ['VBG'],
  'Feelings': ['NNS'],
  'Feels': ['VBZ'],
  'Feenberg': ['NNP'],
  'Feeney': ['NNP'],
  'Fees': ['NNS'],
  'Feess': ['NNP'],
  'Fegersheim': ['NNP'],
  'Fehr': ['NNP'],
  'Fei': ['NNP'],
  'Feick': ['NNP'],
  'Feigen': ['NNP'],
  'Feigenbaum': ['NNP'],
  'Feiner': ['NNP'],
  'Feinman': ['NNP'],
  'Feinstein': ['NNP'],
  'Feis': ['NNP'],
  'Fel-Pro': ['NNP'],
  'Feld': ['NNP'],
  'Feldberg': ['NNP'],
  'Feldemuehle': ['NNP'],
  'Feldene': ['NNP'],
  'Feldman': ['NNP'],
  'Feldstein': ['NNP'],
  'Felec': ['NNP'],
  'Felice': ['NNP'],
  'Feliciano': ['NNP'],
  'Felicity': ['NNP'],
  'Felipe': ['NNP'],
  'Felix': ['NNP'],
  'Fell': ['NNP'],
  'Fella': ['UH'],
  'Fellini': ['NNP'],
  'Fellow': ['NN'],
  'Fellows': ['NNS'],
  'Fellowship': ['NNP'],
  'Fellowships': ['NNS'],
  'Felons': ['NNS'],
  'Felsenthal': ['NNP'],
  'Felsher': ['NNP'],
  'Felske': ['NNP'],
  'Felten': ['NNP'],
  'Feltes': ['NNP'],
  'Female': ['JJ'],
  'Females': ['NNPS'],
  'Femina': ['NNP'],
  'Feminism': ['NN'],
  'Feminist': ['NNP'],
  'Femmes': ['NNP'],
  'Fence-line': ['JJ'],
  'Fendi': ['NNP'],
  'Fending': ['VBG'],
  'Fendrick': ['NNP'],
  'Fenerty': ['NNP'],
  'Feng-hsiung': ['NNP'],
  'Feniger': ['NNP'],
  'Fenimore': ['NNP'],
  'Fenn': ['NNP'],
  'Fenner': ['NNP'],
  'Fennessy': ['NNP'],
  'Fenster': ['NNP'],
  'Fenton': ['NNP'],
  'Fenway': ['NNP'],
  'Fenwick': ['NNP'],
  'Feodor': ['NNP'],
  'Feralloys': ['NNP'],
  'Ferber': ['NNP'],
  'Ferdinand': ['NNP'],
  'Ferdinando': ['NNP'],
  'Ferembal': ['NNP'],
  'Ferenc': ['NNP'],
  'Ferencik': ['NNP'],
  'Fergeson': ['NNP'],
  'Fergus': ['NNP'],
  'Ferguson': ['NNP'],
  'Fergusson': ['NNP'],
  'Feringa': ['NNP'],
  'Ferlenghetti': ['NNP'],
  'Fermate': ['NNP'],
  'Ferment': ['NN'],
  'Fernald': ['NNP'],
  'Fernand': ['NNP'],
  'Fernandes': ['NNP'],
  'Fernandez': ['NNP'],
  'Fernando': ['NNP'],
  'Fernberger': ['NNP'],
  'Ferranti': ['NNP'],
  'Ferranti-led': ['JJ'],
  'Ferrara': ['NNP'],
  'Ferrari': ['NNP'],
  'Ferraro': ['NNP'],
  'Ferraros': ['NNPS'],
  'Ferre': ['NNP'],
  'Ferreira': ['NNP'],
  'Ferrell': ['NNP'],
  'Ferrer': ['NNP'],
  'Ferrero': ['NNP'],
  'Ferrier': ['NNP'],
  'Ferris': ['NNP'],
  'Ferro': ['NNP'],
  'Ferrofluidics': ['NNP'],
  'Ferron': ['NNP'],
  'Ferruzzi': ['NNP'],
  'Ferry': ['NNP'],
  'Fertitta': ['NNP'],
  'Feruzzi': ['NNP'],
  'Fery': ['NNP'],
  'Feshbach': ['NNP'],
  'Festiva': ['NNP'],
  'Festival': ['NNP'],
  'Festivals': ['NNS'],
  'Fetch': ['VB'],
  'Fete': ['NNP'],
  'Fetzer': ['NNP'],
  'Feuchtwanger': ['NNP'],
  'Feud': ['NN'],
  'Feuer': ['NNP'],
  'Feuermann': ['NNP'],
  'Fever': ['NN'],
  'Feverishly': ['RB'],
  'Feversham': ['NNP'],
  'Few': ['JJ'],
  'Fewer': ['JJR'],
  'Fey': ['NNP'],
  'Feyer': ['NNP'],
  'Ffortescue': ['NNP'],
  'Fiala': ['NNP'],
  'Fialkow': ['NNP'],
  'Fiap': ['NNP'],
  'Fiasco': ['NNP'],
  'Fiat': ['NNP'],
  'Fiats': ['NNPS'],
  'Fiber': ['NNP'],
  'FiberCom': ['NNP'],
  'FiberWorld': ['NNP'],
  'Fiberall': ['NNP'],
  'Fiberglas': ['JJ'],
  'Fibre': ['NNP'],
  'Fibreboard': ['NNP'],
  'Fichte': ['NNP'],
  'Fiddler': ['NNP'],
  'Fiddles': ['NNS'],
  'Fiddlesticks': ['NNS'],
  'Fidel': ['NNP'],
  'Fidelity': ['NNP'],
  'Fidis': ['NNP'],
  'Fidler': ['NNP'],
  'Fiechter': ['NNP'],
  'Fiedler': ['NNP'],
  'Field': ['NNP'],
  'Field-Fisher': ['NNP'],
  'Fieldcrest': ['NNP'],
  'Fielder': ['NNP'],
  'Fielding': ['NN'],
  'Fields': ['NNP'],
  'Fienberg': ['NNP'],
  'Fierce': ['JJ'],
  'Fiering': ['NNP'],
  'Fiero': ['NNP'],
  'Fiery': ['JJ'],
  'Fiesta': ['NNP'],
  'Fife': ['NNP'],
  'Fifield': ['NNP'],
  'Fifteen': ['CD'],
  'Fifteenth': ['NNP'],
  'Fifth': ['NNP'],
  'Fifties': ['NNPS'],
  'Fifty': ['CD'],
  'Fifty-fifth': ['NNP'],
  'Fifty-ninth': ['NNP'],
  'Fifty-seven': ['CD'],
  'Fifty-three': ['JJ'],
  'Fifty-two': ['JJ'],
  'Fig': ['NN'],
  'Fig.': ['NN'],
  'Figaro': ['NNP'],
  'Figger': ['VB'],
  'Figgie': ['NNP'],
  'Fight': ['VB'],
  'Fighter': ['NNP'],
  'Fighters': ['NNP'],
  'Fighting': ['NNP'],
  'Fights': ['NNS'],
  'Figlewski': ['NNP'],
  'Figone': ['NNP'],
  'Figs.': ['NNS'],
  'Figura': ['NNP'],
  'Figure': ['NN'],
  'Figures': ['NNS'],
  'Figurines': ['NNS'],
  'Figuring': ['VBG'],
  'Fike': ['NNP'],
  'Fil': ['NNP'],
  'Fila': ['NNP'],
  'File': ['NN'],
  'FileNet': ['NNP'],
  'Filed': ['VBN'],
  'Filene': ['NNP'],
  'Filigreed': ['JJ'],
  'Filipino': ['NNP'],
  'Filipinos': ['NNPS'],
  'Filippo': ['NNP'],
  'Fill': ['VB'],
  'Fill-Or-Kill': ['NNP'],
  'Filling': ['VBG'],
  'Fillmore': ['NNP'],
  'Film': ['NNP'],
  'Filmakers': ['NNPS'],
  'Filmdom': ['NNP'],
  'Filmed': ['VBN'],
  'Filming': ['NN'],
  'Films': ['NNS'],
  'Filmstar': ['NNP'],
  'Filmworks': ['NNP'],
  'Filofax': ['NNP'],
  'Filofaxes': ['NNPS'],
  'Filter': ['NNP'],
  'Filtered': ['VBN'],
  'Filtertek': ['NNP'],
  'Fin-syn': ['JJ'],
  'Fina': ['NNP'],
  'Final': ['JJ'],
  'Final-hour': ['JJ'],
  'Finalists': ['NNS'],
  'Finally': ['RB'],
  'Finals': ['NNS'],
  'Finan': ['NNP'],
  'Finance': ['NNP'],
  'Financial': ['NNP'],
  'Financial-service': ['NN'],
  'Financially': ['RB'],
  'Financials': ['NNPS'],
  'Financiere': ['NNP'],
  'Financieros': ['NNP'],
  'Financiers': ['NNS'],
  'Financing': ['NNP'],
  'Financings': ['NNS'],
  'Financo': ['NNP'],
  'Finanziaria': ['NNP'],
  'Finanziario': ['NNP'],
  'Finberg': ['NNP'],
  'Find': ['VB'],
  'Finder': ['NNP'],
  'Finders': ['NNP'],
  'Finding': ['VBG'],
  'Findings': ['NNS'],
  'Findlay': ['NNP'],
  'Finds': ['VBZ'],
  'Fine': ['NNP'],
  'Finerman': ['NNP'],
  'Fines': ['NNP'],
  'Finevest': ['NNP'],
  'Fing': ['NNP'],
  'Finger': ['NNP'],
  'Fingered': ['NNP'],
  'Fingerprints': ['NNS'],
  'Fingers': ['NNP'],
  'Fininvest': ['NNP'],
  'Finis': ['NNP'],
  'Finish': ['VB'],
  'Finished': ['VBN'],
  'Finishing': ['VBG'],
  'Fink': ['NNP'],
  'Finkbiner': ['NNP'],
  'Finkel': ['NNP'],
  'Finkelstein': ['NNP'],
  'Finkelsteins': ['NNPS'],
  'Finks': ['NNP'],
  'Finland': ['NNP'],
  'Finley': ['NNP'],
  'Finmeccanica': ['NNP'],
  'Finn': ['NNP'],
  'Finnair': ['NNP'],
  'Finnegan': ['NNP'],
  'Finnerty': ['NNP'],
  'Finney': ['NNP'],
  'Finnie': ['NNP'],
  'Finnish': ['JJ'],
  'Finns': ['NNPS'],
  'Finnsburg': ['NNP'],
  'Finot': ['NNP'],
  'Finsbury': ['NNP'],
  'Finsilver': ['NNP'],
  'Finucane': ['NNP'],
  'Fio': ['NNP'],
  'Fiore': ['NNP'],
  'Fiorello': ['NNP'],
  'Fiori': ['NNP'],
  'Fiorina': ['NNP'],
  'Fiorini': ['NNP'],
  'Fire': ['NNP'],
  'Firearms': ['NNP'],
  'Firebird': ['NNP'],
  'Fired': ['VBN'],
  'Fireman': ['NNP'],
  'Firemen': ['NNS'],
  'Fires': ['NNP'],
  'Fireside': ['NNP'],
  'Fireside\\\'/Simon': ['NNP'],
  'Firestone': ['NNP'],
  'Firm': ['NN'],
  'Firms': ['NNS'],
  'First': ['NNP'],
  'First-Born': ['NNP'],
  'First-half': ['JJ'],
  'First-hand': ['JJ'],
  'First-round': ['JJ'],
  'First-section': ['JJ'],
  'FirstSouth': ['NNP'],
  'Firzite': ['NN'],
  'Fiscal': ['JJ'],
  'Fiscal-year': ['JJ'],
  'Fischbach': ['NNP'],
  'Fischer': ['NNP'],
  'Fish': ['NNP'],
  'Fishback': ['NNP'],
  'Fisher': ['NNP'],
  'Fisheries': ['NNP'],
  'Fishermen': ['NNS'],
  'Fishery': ['NNP'],
  'Fishing': ['NNP'],
  'Fishkill': ['NNP'],
  'Fishman': ['NNP'],
  'Fisk': ['NNP'],
  'Fiske': ['NNP'],
  'Fisons': ['NNP'],
  'Fistoulari': ['NNP'],
  'Fists': ['NNS'],
  'Fit': ['JJ'],
  'Fitch': ['NNP'],
  'Fitchburg': ['NNP'],
  'Fitness': ['NNP'],
  'Fitting': ['VBG'],
  'Fittingly': ['RB'],
  'Fittro': ['NNP'],
  'Fitts': ['NNP'],
  'Fitz': ['NNP'],
  'Fitzgerald': ['NNP'],
  'Fitzgibbon': ['NNP'],
  'Fitzhugh': ['NNP'],
  'Fitzpatrick': ['NNP'],
  'Fitzpatrick-Davis': ['NNP'],
  'Fitzroy': ['NNP'],
  'Fitzsimmons': ['NNP'],
  'Fitzwater': ['NNP'],
  'Fitzwilliam': ['NNP'],
  'Fitzwilliams': ['NNP'],
  'Five': ['CD'],
  'Five-Elements': ['NNP'],
  'Five-O': ['NNP'],
  'Five-Year': ['NNP'],
  'Fix': ['VB'],
  'Fixed': ['VBN'],
  'Fixed-income': ['JJ'],
  'Fixed-rate': ['JJ'],
  'Fixing': ['VBG'],
  'Fixit': ['NNP'],
  'Fixture': ['NNP'],
  'Fixx': ['NNP'],
  'Fizkultura': ['NNP'],
  'Fjelstad': ['NNP'],
  'Fla': ['NNP'],
  'Fla.': ['NNP'],
  'Fla.-based': ['JJ'],
  'Flag': ['NN'],
  'Flagg': ['NNP'],
  'Flagler': ['NNP'],
  'Flags': ['NNS'],
  'Flaherty': ['NNP'],
  'Flair': ['NNP'],
  'Flake': ['NN'],
  'Flakes': ['NNPS'],
  'Flameco': ['NNP'],
  'Flames': ['NNPS'],
  'Flaming': ['NNP'],
  'Flamingo': ['NNP'],
  'Flanagan': ['NNP'],
  'Flanders': ['NNP'],
  'Flanked': ['VBN'],
  'Flannagan': ['NNP'],
  'Flannagans': ['NNPS'],
  'Flash': ['NN'],
  'Flashdance': ['NNP'],
  'Flashed': ['VBN'],
  'Flashlight': ['NN'],
  'Flat': ['JJ'],
  'Flatiron': ['NN'],
  'Flatley': ['NNP'],
  'Flatness': ['NN'],
  'Flats': ['NNP'],
  'Flattau': ['NNP'],
  'Flaum': ['NNP'],
  'Flav-O-Rich': ['NNP'],
  'Flavel': ['NNP'],
  'Flavell': ['NNP'],
  'Flavio': ['NNP'],
  'Flavus': ['NNP'],
  'Flaws': ['NNS'],
  'Flax': ['NNP'],
  'Flaxseed': ['NN'],
  'Flea': ['NNP'],
  'Fleckenstein': ['NNP'],
  'Fledermaus': ['NNP'],
  'Fledgling': ['NN'],
  'Flee': ['VBP'],
  'Fleece': ['NNP'],
  'Fleet': ['NNP'],
  'Fleet\\\'/Norstar': ['NNP'],
  'Fleeting': ['JJ'],
  'Fleetwood': ['NNP'],
  'Fleischer': ['NNP'],
  'Fleischman': ['NNP'],
  'Fleischmann': ['NNP'],
  'Fleischmanns': ['NNP'],
  'Fleisher': ['VB'],
  'Flem': ['NNP'],
  'Fleming': ['NNP'],
  'Flemings': ['NNP'],
  'Flemish': ['NNP'],
  'Flesh': ['NN'],
  'Flesher': ['NNP'],
  'Fletch': ['NNP'],
  'Fletcher': ['NNP'],
  'Fleury': ['NNP'],
  'Flexibility': ['NN'],
  'Flexible': ['JJ'],
  'Flexicokers': ['NNS'],
  'Flexural': ['JJ'],
  'Flick': ['NN'],
  'Flier': ['NN'],
  'Fliers': ['NNPS'],
  'Flies': ['NNS'],
  'Flight': ['NNP'],
  'Flights': ['NNS'],
  'Flint': ['NNP'],
  'Flip': ['NNP'],
  'Flippo': ['NNP'],
  'Flite-King': ['JJ'],
  'Floating': ['VBG'],
  'Floats': ['VBZ'],
  'Flock': ['NNP'],
  'Flocks': ['NNS'],
  'Floey': ['NNP'],
  'Flom': ['NNP'],
  'Flood': ['NNP'],
  'Floodlights': ['NNP'],
  'Floor': ['NNP'],
  'Flor': ['NNP'],
  'Floradora': ['NNP'],
  'Floral': ['NNP'],
  'Florence': ['NNP'],
  'Florentine': ['NNP'],
  'Flores': ['NNP'],
  'Floresville': ['NNP'],
  'Florian': ['NNP'],
  'Florican-Inverness': ['NNP'],
  'Florican-My': ['NNP'],
  'Florida': ['NNP'],
  'Floridabanc': ['NNP'],
  'Floridian': ['NN'],
  'Floridians': ['NNP'],
  'Florido': ['NNP'],
  'Florio': ['NNP'],
  'Flory': ['NNP'],
  'Floss': ['NNP'],
  'Flotilla': ['NNP'],
  'Flotte': ['NNP'],
  'Flottl': ['NNP'],
  'Flour': ['NN'],
  'Flow': ['NNP'],
  'Flow-Mole': ['NNP'],
  'Flower': ['NNP'],
  'Flowering': ['NN'],
  'Flowers': ['NNPS'],
  'Floyd': ['NNP'],
  'Fluctuation': ['NN'],
  'Fluent': ['JJ'],
  'Flugdienst': ['NNP'],
  'Flugel': ['NNP'],
  'Flugleasing': ['NNP'],
  'Flumenbaum': ['NNP'],
  'Flumenophobe': ['NNP'],
  'Fluor': ['NNP'],
  'Fluorescence': ['NN'],
  'Fluorescent': ['JJ'],
  'Flush': ['JJ'],
  'Flushing': ['NNP'],
  'Flushing-Main': ['NNP'],
  'Flusser': ['NNP'],
  'Flustered': ['JJ'],
  'Flute': ['NN'],
  'Fly': ['VB'],
  'Flyer': ['NNP'],
  'Flyer-Castle': ['NNP'],
  'Flygplanet': ['NNP'],
  'Flying': ['NNP'],
  'Flynn': ['NNP'],
  'FmHA': ['NNP'],
  'Foamed': ['NNP'],
  'Foamy': ['NNP'],
  'Focus': ['NNP'],
  'Focusing': ['VBG'],
  'Foe': ['NNP'],
  'Foerster': ['NNP'],
  'Fog': ['NN'],
  'Fogelman': ['NNP'],
  'Fogelson': ['NNP'],
  'Fogg': ['NNP'],
  'Foggia': ['NNP'],
  'Foggs': ['NNP'],
  'Foggy': ['NNP'],
  'Fogle': ['NNP'],
  'Fogler': ['NNP'],
  'Foglio': ['NNP'],
  'Foil': ['NNP'],
  'Foiled': ['VBN'],
  'Foiles': ['NNP'],
  'Fokine': ['NNP'],
  'Fokker': ['NNP'],
  'Folcroft': ['NNP'],
  'Fold': ['VB'],
  'Folded': ['NNP'],
  'Folding': ['VBG'],
  'Foley': ['NNP'],
  'Folgers': ['NNP'],
  'Foliage': ['NN'],
  'Folk': ['NNP'],
  'Folk-lore': ['NN'],
  'Folkerts': ['NNP'],
  'Folklore': ['NN'],
  'Folks': ['NNS'],
  'Folkston': ['NNP'],
  'Follow': ['VB'],
  'Follow-through': ['JJ'],
  'Follow-up': ['JJ'],
  'Followin': ['VBG'],
  'Following': ['VBG'],
  'Follows': ['NNP'],
  'Folly': ['NNP'],
  'Folmar': ['NNP'],
  'Folonari': ['NNP'],
  'Folsom': ['NNP'],
  'Foncier': ['NNP'],
  'Fond': ['NNP'],
  'Fonda': ['NNP'],
  'Fonds': ['NNP'],
  'Fonseca': ['NNP'],
  'Fonstein': ['NNP'],
  'Fonta': ['NNP'],
  'Fontainbleau': ['NNP'],
  'Fontaine': ['NNP'],
  'Fontainebleau': ['NNP'],
  'Fontana': ['NNP'],
  'Fonz': ['NNP'],
  'Food': ['NNP'],
  'Food-price': ['JJ'],
  'Foodmaker': ['NNP'],
  'Foods': ['NNPS'],
  'Fooled': ['VBN'],
  'Fools': ['NNS'],
  'Foont': ['NNP'],
  'Foot': ['NNP'],
  'Football': ['NNP'],
  'Foote': ['NNP'],
  'Foothills': ['NNP'],
  'Footnotes': ['NNS'],
  'For': ['IN'],
  'For...': [':'],
  'Forand': ['NNP'],
  'Forbes': ['NNP'],
  'Forbidden': ['NNP'],
  'Force': ['NNP'],
  'Forced': ['VBN'],
  'Forces': ['NNPS'],
  'Ford': ['NNP'],
  'Ford-Kissinger': ['NNP'],
  'Fordham': ['NNP'],
  'Fords': ['NNS'],
  'Forebearing': ['NNP'],
  'Forecast': ['NNP'],
  'Forecaster': ['NNP'],
  'Forecasters': ['NNS'],
  'Forecasting': ['NN'],
  'Forecasts': ['NNPS'],
  'Foreclosed': ['VBN'],
  'Foreclosure': ['NNP'],
  'Foreclosures': ['NNS'],
  'Foreign': ['NNP'],
  'Foreign-exchange': ['JJ'],
  'Foreign-registered': ['JJ'],
  'Foreigners': ['NNS'],
  'Forellen': ['NNP'],
  'Foremost': ['RB'],
  'Forensic': ['NNP'],
  'Forerunner': ['NNP'],
  'Foreseeing': ['VBG'],
  'Foresight': ['NN'],
  'Foresman': ['NNP'],
  'Forest': ['NNP'],
  'Forest-products': ['NNS'],
  'Forester': ['NNP'],
  'Foresters': ['NNS'],
  'Forests': ['NNPS'],
  'Foret': ['NNP'],
  'Forever': ['NNP'],
  'Forfeiture': ['NNP'],
  'Forge': ['NNP'],
  'Forget': ['VB'],
  'Forgive': ['VB'],
  'Forgiveness': ['NN'],
  'Forgoing': ['VBG'],
  'Forgot': ['VBN'],
  'Forgotten': ['NNP'],
  'Fork': ['NNP'],
  'Forked': ['NNP'],
  'Forks': ['NNS'],
  'Form': ['NN'],
  'FormBase': ['NNP'],
  'Formally': ['RB'],
  'Forman': ['NNP'],
  'Format': ['NN'],
  'Formation': ['NNP'],
  'Formby': ['NNP'],
  'Formed': ['VBN'],
  'Former': ['JJ'],
  'Formerly': ['RB'],
  'Formica': ['NNP'],
  'Formosa': ['NNP'],
  'Formosan': ['JJ'],
  'Forms': ['NNPS'],
  'Formula': ['NN'],
  'Forney': ['NNP'],
  'Forrest': ['NNP'],
  'Forrestal': ['NNP'],
  'Forrester': ['NNP'],
  'Forsan': ['FW'],
  'Forseth': ['NNP'],
  'Forst': ['NNP'],
  'Forster': ['NNP'],
  'Forstmann': ['NNP'],
  'Forsyth': ['NNP'],
  'Forsythe': ['NNP'],
  'Fort': ['NNP'],
  'Fortas': ['NNP'],
  'Forte': ['NNP'],
  'Fortenbaugh': ['NNP'],
  'Fortescue': ['NNP'],
  'Fortier': ['NNP'],
  'Forties': ['NNP'],
  'Fortified': ['VBN'],
  'Fortin': ['NNP'],
  'Fortman': ['NNP'],
  'Fortney': ['NNP'],
  'Fortress': ['NNP'],
  'FortressEurope': ['NN'],
  'Fortunate': ['JJ'],
  'Fortunately': ['RB'],
  'Fortune': ['NNP'],
  'Forty': ['CD'],
  'Forty-Four': ['CD'],
  'Forty-five': ['CD'],
  'Forty-four': ['CD'],
  'Forty-nine': ['JJ'],
  'Forty-one': ['JJ'],
  'Forty-second': ['JJ'],
  'Forty-seven': ['JJ'],
  'Forty-six': ['CD'],
  'Forty-third': ['JJ'],
  'Forty-three': ['CD'],
  'Forum': ['NNP'],
  'Forward': ['NNP'],
  'Forwarding': ['NNP'],
  'Fosback': ['NNP'],
  'Fosdick': ['NNP'],
  'Foss': ['NNP'],
  'Fossan': ['NNP'],
  'Fosset': ['NNP'],
  'Fossett': ['NNP'],
  'Fossey': ['NNP'],
  'Foster': ['NNP'],
  'Foster\'s-brand': ['JJ'],
  'Fosterite': ['NNP'],
  'Fosterites': ['NNP'],
  'Fought': ['VBN'],
  'Foul': ['NNP'],
  'Foulds': ['NNP'],
  'Foundation': ['NNP'],
  'Founded': ['VBN'],
  'Founder': ['NN'],
  'Founders': ['NNPS'],
  'Founding': ['NNP'],
  'Foundry': ['NNP'],
  'Fountain': ['NNP'],
  'Four': ['CD'],
  'Four-fifths': ['NNS'],
  'Fournier': ['NNP'],
  'Fourteen': ['CD'],
  'Fourteenth': ['NNP'],
  'Fourth': ['NNP'],
  'Fourth-of-July': ['NNP'],
  'Fourth-quarter': ['JJ'],
  'Fourtou': ['NNP'],
  'Fowler': ['NNP'],
  'Fox': ['NNP'],
  'Fox-Meyer': ['NNP'],
  'Fox-Pitt': ['NNP'],
  'Foxboro': ['NNP'],
  'Foxmoor': ['NNP'],
  'Foxx': ['NNP'],
  'Foy': ['NNP'],
  'Fra': ['NNP'],
  'Fraas': ['NNP'],
  'Frabotta': ['NNP'],
  'Fraction': ['NNP'],
  'Fractions': ['NNS'],
  'Fracturing': ['NNP'],
  'Fraga': ['NNP'],
  'Fragile': ['NNP'],
  'Fragin': ['NNP'],
  'Fragment': ['NN'],
  'Fragonard': ['NNP'],
  'Fragua': ['NNP'],
  'Frail': ['JJ'],
  'Framatome': ['NNP'],
  'Frame': ['NN'],
  'Framework': ['NNP'],
  'Framingham': ['NNP'],
  'Frampton': ['NNP'],
  'Fran': ['NNP'],
  'Francais': ['NNP'],
  'Francaise': ['NNP'],
  'Francaises': ['NNP'],
  'France': ['NNP'],
  'France-Germany': ['NNP'],
  'France-Presse': ['NNP'],
  'France.': ['NNP'],
  'Frances': ['NNP'],
  'Francesca': ['NNP'],
  'Francesco': ['NNP'],
  'Francesville': ['NNP'],
  'Franchise': ['NNP'],
  'Franchisee': ['NN'],
  'Franchisees': ['NNS'],
  'Franchising': ['NNP'],
  'Francie': ['NNP'],
  'Francis': ['NNP'],
  'Franciscan': ['JJ'],
  'Franciscans': ['NNP'],
  'Francisco': ['NNP'],
  'Francisco-Oakland': ['NNP'],
  'Francisco-area': ['JJ'],
  'Francisco-based': ['JJ'],
  'Franciso': ['NNP'],
  'Franck': ['NNP'],
  'Franco': ['NNP'],
  'Franco-German': ['NNP'],
  'Franco-Irishman': ['NNP'],
  'Franco-Japanese': ['NNP'],
  'Francois': ['NNP'],
  'Francois-Poncet': ['NNP'],
  'Francoise': ['NNP'],
  'Francoisette': ['NNP'],
  'Francona': ['NNP'],
  'Franconia': ['NNP'],
  'Francophone': ['JJ'],
  'Frank': ['NNP'],
  'Franke': ['NNP'],
  'Frankel': ['NNP'],
  'Frankenberry': ['NNP'],
  'Frankenstein': ['NNP'],
  'Frankford': ['NNP'],
  'Frankfort': ['NNP'],
  'Frankfurt': ['NNP'],
  'Frankfurt-based': ['JJ'],
  'Frankfurter': ['NNP'],
  'Frankie': ['NNP'],
  'Franklin': ['NNP'],
  'Franklin-Trout': ['NNP'],
  'Frankly': ['RB'],
  'Franklyn': ['NNP'],
  'Franks': ['NNPS'],
  'Franny': ['NNP'],
  'Frans': ['NNP'],
  'Frantisek': ['NNP'],
  'Franyo': ['NNP'],
  'Franz': ['NNP'],
  'Fraser': ['NNP'],
  'Fraternal': ['NNP'],
  'Fraud': ['NNP'],
  'Frauds': ['NNPS'],
  'Fraumeni': ['NNP'],
  'Frawley': ['NNP'],
  'Fray': ['NN'],
  'Frayne': ['NNP'],
  'Frazee': ['NNP'],
  'Frazer': ['NNP'],
  'Frazier': ['NNP'],
  'Frazzano': ['NNP'],
  'Fred': ['NNP'],
  'Freddie': ['NNP'],
  'Freddy': ['NNP'],
  'Frederic': ['NNP'],
  'Frederick': ['NNP'],
  'Fredericksburg': ['NNP'],
  'Fredericton': ['NNP'],
  'Frederik': ['NNP'],
  'Fredonia': ['NNP'],
  'Fredric': ['NNP'],
  'Fredrick': ['NNP'],
  'Fredrico': ['NNP'],
  'Fredrik': ['NNP'],
  'Fredrikshall': ['NNP'],
  'Free': ['NNP'],
  'Free-Will': ['NNP'],
  'Free-marketeers': ['NNS'],
  'Free-trade': ['JJ'],
  'Freeberg': ['NNP'],
  'Freebies': ['NNS'],
  'Freed': ['VBN'],
  'Freedman': ['NNP'],
  'Freedom': ['NNP'],
  'Freeholder': ['NNP'],
  'Freeman': ['NNP'],
  'Freeport': ['NNP'],
  'Freeport-McMoRan': ['NNP'],
  'Freeway': ['NNP'],
  'Freeze': ['NN'],
  'Freiburghouse': ['NNP'],
  'Freida': ['NNP'],
  'Freie': ['NNP'],
  'Freight': ['NNP'],
  'Freightways': ['NNP'],
  'Freind': ['NNP'],
  'Freinkel': ['NNP'],
  'Frelinghuysen': ['NNP'],
  'Fremantle': ['NNP'],
  'Fremont': ['NNP'],
  'French': ['JJ'],
  'French-Canadian': ['NNP'],
  'French-Canadians': ['NNPS'],
  'French-English': ['NNP'],
  'French-Italian': ['JJ'],
  'French-born': ['JJ'],
  'French-franc': ['NN'],
  'French-government-owned': ['JJ'],
  'French-language': ['JJ'],
  'French-made': ['JJ'],
  'French-modeled': ['JJ'],
  'French-polished': ['JJ'],
  'French-speaking': ['JJ'],
  'Frenchman': ['NNP'],
  'Frenchmen': ['NNPS'],
  'Frenchwoman': ['NNP'],
  'Freni': ['NNP'],
  'Frenzel': ['NNP'],
  'Frenzy': ['NNP'],
  'Freon': ['NN'],
  'Frequency': ['NNP'],
  'Frequent': ['JJ'],
  'Frequent-flier': ['JJ'],
  'Frequently': ['RB'],
  'Freres': ['NNP'],
  'Fresca': ['NNP'],
  'Fresenius': ['NNP'],
  'Fresh': ['JJ'],
  'Freshbake': ['NNP'],
  'Freshman': ['NN'],
  'Freshmen': ['NNS'],
  'Freshwater': ['NNP'],
  'Fresnel': ['NNP'],
  'Fresno': ['NNP'],
  'Freston': ['NNP'],
  'Fret': ['VB'],
  'Fretting': ['VBG'],
  'Freud': ['NNP'],
  'FreudToy': ['NNP'],
  'Freudenberger': ['NNP'],
  'Freudian': ['JJ'],
  'Freund': ['NNP'],
  'Frey': ['NNP'],
  'Freya': ['NNP'],
  'Fri': ['NNP'],
  'Friar': ['NN'],
  'Friars': ['NNS'],
  'Frick': ['NNP'],
  'Fricke': ['NNP'],
  'Friday': ['NNP'],
  'Friday-the-13th': ['JJ'],
  'Fridays': ['NNPS'],
  'Fridge': ['NNP'],
  'Fridman': ['NNP'],
  'Fried': ['NNP'],
  'Friedberg': ['NNP'],
  'Friede': ['NNP'],
  'Friedenwald': ['NNP'],
  'Friedman': ['NNP'],
  'Friedmann': ['NNP'],
  'Friedreich': ['NNP'],
  'Friedrich': ['NNP'],
  'Friedrichs': ['NNP'],
  'FriedrichsInc.': ['NNP'],
  'Friend': ['NNP'],
  'Friendly': ['NNP'],
  'Friends': ['NNS'],
  'Fries': ['NNP'],
  'Friesen': ['NNP'],
  'Frills': ['NNP'],
  'Frisbee': ['NNP'],
  'Frisch': ['NNP'],
  'Frisco': ['NNP'],
  'Frist': ['FW'],
  'Frito': ['NNP'],
  'Frito-Lay': ['NNP'],
  'Frits': ['NNP'],
  'Fritz': ['NNP'],
  'Fritze': ['NNP'],
  'Fritzie': ['NNP'],
  'Fritzsche': ['NNP'],
  'Froelich': ['NNP'],
  'Frog-marched': ['JJ'],
  'Frohock': ['NNP'],
  'Froissart': ['NNP'],
  'From': ['IN'],
  'Fromm': ['NNP'],
  'Fromstein': ['NNP'],
  'Frondel': ['NNP'],
  'Front': ['NNP'],
  'Front-line': ['JJ'],
  'Front-runners': ['NNS'],
  'Frontage': ['NN'],
  'Frontier': ['NNP'],
  'Frontieres': ['FW'],
  'Frontiers': ['NNS'],
  'Frost': ['NNP'],
  'Frost-Debby': ['NNP'],
  'Frostbite': ['NN'],
  'Frosted': ['NNP'],
  'Frosts': ['NNPS'],
  'Frothingham': ['NNP'],
  'Frothy': ['JJ'],
  'Frowning': ['VBG'],
  'Frozen': ['VBN'],
  'Frucher': ['NNP'],
  'Fruehauf': ['NNP'],
  'Fruit': ['NNP'],
  'Frum': ['NNP'],
  'Frumil': ['NNP'],
  'Frustrate': ['VBP'],
  'Frustrated': ['JJ'],
  'Frustration': ['NN'],
  'Fry': ['VB'],
  'Fryar': ['NNP'],
  'Ft.': ['NNP'],
  'Fu': ['NNP'],
  'Fuchs': ['NNP'],
  'Fuck': ['VB'],
  'Fudo': ['NNP'],
  'Fudomae': ['NNP'],
  'Fudosan': ['NNP'],
  'Fuel': ['NNP'],
  'Fueled': ['VBN'],
  'Fueling': ['VBG'],
  'Fueloil': ['NNP'],
  'Fuentes': ['NNP'],
  'Fuhrer': ['NNP'],
  'Fuhrmann': ['NNP'],
  'Fuji': ['NNP'],
  'Fuji-apple': ['JJ'],
  'Fujii': ['NNP'],
  'Fujimoto': ['NNP'],
  'Fujis': ['NNPS'],
  'Fujisankei': ['NNP'],
  'Fujisawa': ['NNP'],
  'Fujita': ['NNP'],
  'Fujitsu': ['NNP'],
  'Fukuda': ['NNP'],
  'Fukuoka': ['NNP'],
  'Fukuyama': ['NNP'],
  'Fulbright': ['NNP'],
  'Fulcrum': ['NNP'],
  'Fuld': ['NNP'],
  'Fulfills': ['VBZ'],
  'Fulghum': ['NNP'],
  'Fulgoni': ['NNP'],
  'Fulham': ['NNP'],
  'Fulke': ['NNP'],
  'Full': ['JJ'],
  'Full-time': ['JJ'],
  'Fuller': ['NNP'],
  'Fullerton': ['NNP'],
  'Fully': ['RB'],
  'Fulmar': ['NNP'],
  'Fulson': ['NNP'],
  'Fulton': ['NNP'],
  'Fultz': ['NNP'],
  'Fulwood': ['NNP'],
  'Fuming': ['VBG'],
  'Fumio': ['NN'],
  'Fun': ['NNP'],
  'Funari': ['NNP'],
  'Functionalism': ['NN'],
  'Functionally': ['RB'],
  'Functions': ['NNPS'],
  'Fund': ['NNP'],
  'Fund-Raisers': ['NNS'],
  'FundTrust': ['NNP'],
  'Fundamental': ['JJ'],
  'Fundamentalists': ['NNS'],
  'Fundamentally': ['RB'],
  'Fundamentals': ['NNS'],
  'Funded': ['VBN'],
  'Fundidora': ['NNP'],
  'Funding': ['NNP'],
  'Funds': ['NNS'],
  'Funeral': ['NNP'],
  'Fung': ['NNP'],
  'Fungi': ['NNP'],
  'Fungible': ['JJ'],
  'Funk': ['NNP'],
  'Funny': ['JJ'],
  'Funston': ['NNP'],
  'Fuqua': ['NNP'],
  'Fur': ['NNP'],
  'Furey': ['NNP'],
  'Furhmann': ['NNP'],
  'Furies': ['NNS'],
  'Furillo': ['NNP'],
  'Furious': ['NNP'],
  'Furiouser': ['RBR'],
  'Furlaud': ['NNP'],
  'Furlett': ['NNP'],
  'Furman': ['NNP'],
  'Furnace': ['NN'],
  'Furnaces': ['NNP'],
  'Furnishes': ['VBZ'],
  'Furniture': ['NNP'],
  'Furs': ['NNP'],
  'Further': ['RB'],
  'Furthermore': ['RB'],
  'Furukawa': ['NNP'],
  'Furuta': ['NNP'],
  'Fury': ['NNP'],
  'Furze': ['NNP'],
  'Fuss': ['VB'],
  'Fuster': ['NNP'],
  'Futhermore': ['NN'],
  'Futotsu': ['FW'],
  'Futter': ['NNP'],
  'Future': ['NNP'],
  'Futures': ['NNS'],
  'Futures-related': ['JJ'],
  'Fuzzy': ['JJ'],
  'Fyffes': ['NNP'],
  'Fyodor': ['NNP'],
  'G': ['NN'],
  'G\'ahn': ['VB'],
  'G-2': ['NN'],
  'G-24': ['NNP'],
  'G-7': ['NNP'],
  'G-R-H': ['NNP'],
  'G.': ['NNP'],
  'G.B.S.': ['NN'],
  'G.D.': ['NNP'],
  'G.E.': ['NNP'],
  'G.J.': ['NNP'],
  'G.L.': ['NNP'],
  'G.N.': ['NNP'],
  'G.O.': ['NNP'],
  'G.O.P.': ['NN'],
  'G.P.': ['NNP'],
  'G.S.': ['NNP'],
  'G.W.': ['NNP'],
  'G.m.b': ['NNP'],
  'G7': ['NNP'],
  'GA': ['NNP'],
  'GABLE': ['NNP'],
  'GAF': ['NNP'],
  'GAG': ['NNP'],
  'GALAXY': ['NN'],
  'GAMBLE': ['NNP'],
  'GANNETT': ['NNP'],
  'GAO': ['NNP'],
  'GAP': ['NNP'],
  'GAR': ['NNP'],
  'GARY': ['NNP'],
  'GAS': ['NNP'],
  'GASB': ['NNP'],
  'GATT': ['NNP'],
  'GBL': ['NNP'],
  'GD': ['NNP'],
  'GDL': ['NNP'],
  'GDP': ['NNP'],
  'GDR': ['NNP'],
  'GE': ['NNP'],
  'GEC': ['NNP'],
  'GENENTECH': ['NNP'],
  'GENERAL': ['NNP'],
  'GENERIC-DRUG': ['NN'],
  'GERMAN': ['JJ'],
  'GERMANS': ['NNPS'],
  'GERMANY': ['NNP'],
  'GERMANY\'S': ['NNP'],
  'GET': ['VB'],
  'GE\\\'': ['NNP'],
  'GEnie': ['NNP'],
  'GF': ['NNP'],
  'GFSA': ['NNP'],
  'GHKM': ['NNP'],
  'GHR': ['NNP'],
  'GHS': ['NNP'],
  'GI': ['NNP'],
  'GIMMEE': ['UH'],
  'GIPPER': ['NN'],
  'GIS': ['NNP'],
  'GIVE': ['VBP'],
  'GL': ['NNP'],
  'GLASNOST': ['NNP'],
  'GLI': ['NNP'],
  'GLITTER': ['NN'],
  'GLITTERS': ['VBZ'],
  'GLS': ['NNP'],
  'GM': ['NNP'],
  'GM-10': ['NN'],
  'GM-10s': ['NNP'],
  'GM-CSF': ['NNP'],
  'GM-Jaguar': ['JJ'],
  'GM-Toyota': ['JJ'],
  'GMA': ['NNP'],
  'GMAC': ['NNP'],
  'GMC': ['NNP'],
  'GMr': ['NN'],
  'GNP': ['NNP'],
  'GNP-based': ['JJ'],
  'GO': ['VB'],
  'GOD': ['UH'],
  'GOLD': ['NN'],
  'GOLDEN': ['NNP'],
  'GOLF': ['NN'],
  'GOOD': ['JJ'],
  'GOODY': ['NNP'],
  'GOP': ['NNP'],
  'GORBACHEV': ['NNP'],
  'GOULD': ['NNP'],
  'GOVERNMENT': ['NN'],
  'GP': ['NNP'],
  'GPA': ['NNP'],
  'GQ': ['NNP'],
  'GR8FLRED': ['CD'],
  'GRAB': ['NNP'],
  'GRAINS': ['NNS'],
  'GRAND': ['JJ'],
  'GRANTING': ['VBG'],
  'GRE': ['NNP'],
  'GREAT': ['NNP'],
  'GREW': ['VBD'],
  'GREY': ['NNP'],
  'GROUP': ['NNP'],
  'GROUP\'S': ['NNP'],
  'GROVE': ['NNP'],
  'GROWING': ['VBG'],
  'GROWS': ['VBZ'],
  'GROWTH': ['NN'],
  'GRP': ['NNP'],
  'GRX': ['NNP'],
  'GRiD': ['NNP'],
  'GRiDPad': ['NNP'],
  'GS': ['NNP'],
  'GSA': ['NNP'],
  'GSD&M': ['NNP'],
  'GSI': ['NNP'],
  'GSP': ['NNP'],
  'GSX': ['NNP'],
  'GT': ['NNP'],
  'GTE': ['NNP'],
  'GTG': ['NNP'],
  'GTI': ['NNP'],
  'GUIDE': ['NNP'],
  'GUN': ['NNP'],
  'Ga': ['NNP'],
  'Ga.': ['NNP'],
  'Gaafer': ['NNP'],
  'Gabe': ['NNP'],
  'Gabele': ['NNP'],
  'Gabelli': ['NNP'],
  'Gabelman': ['NNP'],
  'Gable': ['NNP'],
  'Gabler': ['NNP'],
  'Gables': ['NNP'],
  'Gabon': ['NNP'],
  'Gabor': ['NNP'],
  'Gabriel': ['NNP'],
  'Gabriela': ['NNP'],
  'Gabriele': ['NNP'],
  'Gabrielle': ['NNP'],
  'Gachinger': ['NNP'],
  'Gadhafi': ['NNP'],
  'Gadsden': ['NNP'],
  'Gadwani': ['NNP'],
  'Gaechinger': ['NNP'],
  'Gaelic': ['JJ'],
  'Gaetan': ['NNP'],
  'Gaffney': ['NNP'],
  'Gaga': ['NNP'],
  'Gagarin': ['NNP'],
  'Gagliardini': ['NNP'],
  'Gagne': ['NNP'],
  'Gaieties': ['NNPS'],
  'Gail': ['NNP'],
  'Gaillard': ['NNP'],
  'Gain': ['NN'],
  'Gainen': ['NNP'],
  'Gainers': ['NNP'],
  'Gaines': ['NNP'],
  'Gainesville': ['NNP'],
  'Gaining': ['VBG'],
  'Gains': ['NNS'],
  'Gaisman': ['NNP'],
  'Gaither': ['NNP'],
  'Gaithersburg': ['NNP'],
  'Gaja': ['NNP'],
  'Gajda': ['NNP'],
  'Gal': ['NNP'],
  'Gala': ['NNP'],
  'Galahad': ['NNP'],
  'Galamian': ['NNP'],
  'Galan': ['NNP'],
  'Galant': ['NNP'],
  'Galanter': ['NNP'],
  'Galantuomo': ['NNP'],
  'Galapagos': ['NNP'],
  'Galata': ['NNP'],
  'Galatians': ['NNPS'],
  'Galax': ['NNP'],
  'Galaxy': ['NN'],
  'Galbani': ['NNP'],
  'Galbraith': ['NNP'],
  'Gale': ['NNP'],
  'Galecke': ['NNP'],
  'Galen': ['NNP'],
  'Galena': ['NNP'],
  'Galicia': ['NNP'],
  'Galicians': ['NNPS'],
  'Galilee': ['NNP'],
  'Galileo': ['NNP'],
  'Galina': ['NNP'],
  'Galindez': ['NNP'],
  'Galipault': ['NNP'],
  'Gallagher': ['NNP'],
  'Galland': ['NNP'],
  'Gallant': ['NNP'],
  'Galle': ['NNP'],
  'Gallen': ['NNP'],
  'Galleria': ['NNP'],
  'Gallery': ['NNP'],
  'Galles': ['NNP'],
  'Gallet': ['NN'],
  'Galli': ['NNP'],
  'Galligan': ['NNP'],
  'Gallitano': ['NNP'],
  'Gallitzin': ['NNP'],
  'Gallium': ['NN'],
  'Gallo': ['NNP'],
  'Gallon': ['NNP'],
  'Gallon-Loren': ['NNP'],
  'Galloway': ['NNP'],
  'Gallup': ['NNP'],
  'Galoob': ['NNP'],
  'Galophone-Kimberly': ['NNP'],
  'Galophone-Prissy': ['NNP'],
  'Galsworthy': ['NNP'],
  'Galt': ['NNP'],
  'Galtier': ['NNP'],
  'Galveston': ['NNP'],
  'Galveston-Houston': ['NNP'],
  'Galveston-Port': ['NNP'],
  'Galvin': ['NNP'],
  'Galway': ['NNP'],
  'Gambit': ['NNP'],
  'Gamble': ['NNP'],
  'Gambling': ['NN'],
  'Game': ['NN'],
  'Game-Boy': ['NN'],
  'Gamecock': ['NNP'],
  'Gamel': ['NNP'],
  'Games': ['NNPS'],
  'Gaming': ['NNP'],
  'Gamma': ['NNP'],
  'Gamper': ['NNP'],
  'Ganado': ['NNP'],
  'Gandalf': ['NNP'],
  'Gander': ['NNP'],
  'Gandhi': ['NNP'],
  'Gandois': ['NNP'],
  'Gandy': ['NNP'],
  'Ganes': ['NNP'],
  'Ganessa': ['NNP'],
  'Gang': ['NNP'],
  'Ganges': ['NNP'],
  'Ganis': ['NNP'],
  'Gann': ['NNP'],
  'Gannett': ['NNP'],
  'Gannon': ['NNP'],
  'Gansevoort': ['NNP'],
  'Gant': ['NNP'],
  'Gantos': ['NNP'],
  'Gantry': ['NNP'],
  'Gaon': ['NNP'],
  'Gap': ['NNP'],
  'Gar-Dene': ['NNP'],
  'Garamendi': ['NNP'],
  'Garanti': ['NNP'],
  'Garbage': ['NNP'],
  'Garber': ['NNP'],
  'Garbutt': ['NNP'],
  'Garcia': ['NNP'],
  'Garcias': ['NNPS'],
  'Gardelin': ['NNP'],
  'Garden': ['NNP'],
  'Garden-variety': ['NN'],
  'Gardena': ['NNP'],
  'Gardening': ['NNP'],
  'Gardens': ['NNPS'],
  'Gardiner': ['NNP'],
  'Gardini': ['NNP'],
  'Gardner': ['NNP'],
  'Gardner-Denver': ['NNP'],
  'Garea': ['NNP'],
  'Garfield': ['NNP'],
  'Gargan': ['NNP'],
  'Gargantuan': ['JJ'],
  'Gargery': ['NNP'],
  'Gargle': ['NNP'],
  'Gari': ['NNP'],
  'Garibaldi': ['NNP'],
  'Garin': ['NNP'],
  'Garine': ['NNP'],
  'Garish': ['JJ'],
  'Garland': ['NNP'],
  'Garman': ['NNP'],
  'Garment': ['NNP'],
  'Garments': ['NNS'],
  'Garn': ['NNP'],
  'Garner': ['NNP'],
  'Garnett': ['NNP'],
  'Garonzik': ['NNP'],
  'Garpian': ['JJ'],
  'Garrard': ['NNP'],
  'Garratt': ['NNP'],
  'Garret': ['NNP'],
  'Garrett': ['NNP'],
  'Garrick': ['NNP'],
  'Garrick-Aug': ['NNP'],
  'Garrin': ['NNP'],
  'Garrison': ['NNP'],
  'Garrisonian': ['NN'],
  'Garry': ['NNP'],
  'Garryowen': ['NNP'],
  'Garson': ['NNP'],
  'Garstung': ['NNP'],
  'Garth': ['NNP'],
  'Gartner': ['NNP'],
  'Garvey': ['NNP'],
  'Garvier': ['NNP'],
  'Gary': ['NNP'],
  'Garza': ['NNP'],
  'Garzarelli': ['NNP'],
  'Gas': ['NNP'],
  'Gas-cooled': ['JJ'],
  'Gas-reactor': ['JJ'],
  'Gasch': ['NNP'],
  'Gascony': ['NNP'],
  'Gases': ['NNS'],
  'Gasich': ['NNP'],
  'Gaskin': ['NNP'],
  'Gaslight': ['NN'],
  'Gasoline': ['NN'],
  'Gaspard': ['NNP'],
  'Gaspee': ['NNP'],
  'Gasse': ['NNP'],
  'Gassee': ['NNP'],
  'Gasset': ['NNP'],
  'Gassman': ['NNP'],
  'Gastineau': ['NNP'],
  'Gaston': ['NNP'],
  'Gastronomes': ['NNS'],
  'Gastronomie': ['NNP'],
  'Gastronomy': ['NNP'],
  'Gate': ['NNP'],
  'Gates': ['NNP'],
  'Gates-Warren': ['NNP'],
  'Gateway': ['NNP'],
  'Gather': ['VB'],
  'Gathered': ['VBN'],
  'Gatherer': ['NNP'],
  'Gathering': ['NN'],
  'Gati': ['NNP'],
  'Gatlinburg': ['NNP'],
  'Gato': ['NNP'],
  'Gatoil': ['NNP'],
  'Gator': ['JJ'],
  'Gatos': ['NNP'],
  'Gatsby': ['NNP'],
  'Gatsby-in-reverse': ['NN'],
  'Gatward': ['NNP'],
  'Gatwick': ['NNP'],
  'Gaubert': ['NNP'],
  'Gauchos': ['NNS'],
  'Gauer': ['NNP'],
  'Gauged': ['VBN'],
  'Gauguin': ['NNP'],
  'Gaul': ['NNP'],
  'Gauleiter': ['NNP'],
  'Gaulle': ['NNP'],
  'Gauloises': ['NNP'],
  'Gaunt': ['JJ'],
  'Gauntlett': ['NNP'],
  'Gauntley': ['NNP'],
  'Gaussian': ['JJ'],
  'Gautier': ['NNP'],
  'Gave': ['VBD'],
  'Gaveston': ['NNP'],
  'Gavin': ['NNP'],
  'Gavrilov': ['NNP'],
  'Gawdamighty': ['UH'],
  'Gay': ['NNP'],
  'Gaydon': ['NNP'],
  'Gayle': ['NNP'],
  'Gaylor': ['NNP'],
  'Gaylord': ['NNP'],
  'Gaynor': ['NNP'],
  'Gays': ['NNS'],
  'Gaza': ['NNP'],
  'Gazdag': ['NNP'],
  'Gazeta': ['NNP'],
  'Gazette': ['NNP'],
  'Gazettes': ['NNP'],
  'Gazing': ['VBG'],
  'Gazinosu': ['NNP'],
  'Gear': ['NNP'],
  'Geary': ['NNP'],
  'Geatish': ['JJ'],
  'Gebhard': ['NNP'],
  'Gebrueder': ['NNP'],
  'Gecker': ['NNP'],
  'Geddes': ['NNP'],
  'Geduld': ['NNP'],
  'Gee': ['UH'],
  'Geech': ['NNP'],
  'Geeks': ['NNPS'],
  'Geely': ['NNP'],
  'Geer': ['NNP'],
  'Geertz': ['NNP'],
  'Geffen': ['NNP'],
  'Gehl': ['NNP'],
  'Gehrig': ['NNP'],
  'Geico': ['NNP'],
  'Geier': ['NNP'],
  'Geiger': ['NNP'],
  'Geingob': ['NNP'],
  'Geisha': ['NN'],
  'Geissinger': ['NNP'],
  'Gel': ['NNP'],
  'Gelb': ['NNP'],
  'Gelbart': ['NNP'],
  'Geld': ['NNP'],
  'Gelder': ['NNP'],
  'Geldermann': ['NNP'],
  'Gell': ['NNP'],
  'Geller': ['NNP'],
  'Gellert': ['NNP'],
  'Gelles': ['NNP'],
  'Gelly': ['NNP'],
  'Gelman': ['NNP'],
  'Gem': ['NNP'],
  'Geman': ['NNP'],
  'Gemayel': ['NNP'],
  'Gemeinschaft': ['FW'],
  'Gemina': ['NNP'],
  'Gems': ['NNS'],
  'Gen': ['NNP'],
  'Gen-Probe': ['NNP'],
  'Gen.': ['NNP'],
  'GenCorp': ['NNP'],
  'GenProbe': ['NN'],
  'Gencor': ['NNP'],
  'Gendron': ['NNP'],
  'Gene': ['NNP'],
  'Gene-Princess': ['NNP'],
  'Gene-Spliced': ['JJ'],
  'Gene-splicing': ['NN'],
  'Genel': ['NNP'],
  'Genelabs': ['NNPS'],
  'Genentech': ['NNP'],
  'General': ['NNP'],
  'Generale': ['NNP'],
  'Generales': ['NNP'],
  'Generali': ['NNP'],
  'Generalissimo': ['NNP'],
  'Generalizations': ['NNS'],
  'Generalized': ['NNP'],
  'Generally': ['RB'],
  'Generating': ['NNP'],
  'Generation': ['NNP'],
  'Generic': ['NNP'],
  'Generic-Drug': ['JJ'],
  'Generic-industry': ['JJ'],
  'Generics': ['NNS'],
  'Genesee': ['NNP'],
  'Genesis': ['NNP'],
  'Genetic': ['NNP'],
  'Geneticist': ['NNP'],
  'Genetics': ['NNP'],
  'Geneva': ['NNP'],
  'Geneva-based': ['JJ'],
  'Genevieve': ['NNP'],
  'Genghis': ['NNP'],
  'Genie': ['NNP'],
  'Genigraphics': ['NNP'],
  'Genius': ['NN'],
  'Gennaro': ['NNP'],
  'Geno': ['NNP'],
  'Genocide': ['NN'],
  'Genome': ['NNP'],
  'Genossenschafts': ['NNP'],
  'Genossenschaftsbank': ['NNP'],
  'Genova': ['NNP'],
  'Genscher': ['NNP'],
  'Gensichen': ['NNP'],
  'Genson': ['NNP'],
  'Gentile': ['NNP'],
  'Gentile-Jewish': ['NNP'],
  'Gentiles': ['NNPS'],
  'Gentility': ['NN'],
  'Gentleman': ['NN'],
  'Gentlemen': ['NNS'],
  'Genuine': ['NNP'],
  'Genzyme': ['NNP'],
  'Geo': ['NNP'],
  'Geo.': ['NNP'],
  'Geocentricism': ['NN'],
  'Geocryology': ['NNP'],
  'Geodetic': ['NNP'],
  'Geoff': ['NNP'],
  'Geoffrey': ['NNP'],
  'Geoffrie': ['NNP'],
  'Geoffrion': ['NNP'],
  'Geographic': ['NNP'],
  'Geographical': ['JJ'],
  'Geolite': ['NN'],
  'Geological': ['NNP'],
  'Geologists': ['NNS'],
  'Geology': ['NNP'],
  'Geometric': ['NNP'],
  'Georg': ['NNP'],
  'Georgano': ['NNP'],
  'George': ['NNP'],
  'George-Barden': ['NNP'],
  'George-Creque': ['NNP'],
  'Georgene': ['NNP'],
  'Georges': ['NNP'],
  'Georgescu': ['NNP'],
  'Georgeson': ['NNP'],
  'Georgetown': ['NNP'],
  'Georgette': ['NNP'],
  'Georgi': ['NNP'],
  'Georgia': ['NNP'],
  'Georgia-Pacific': ['NNP'],
  'Georgia-based': ['JJ'],
  'Georgian': ['JJ'],
  'Georgians': ['NNPS'],
  'Geos': ['NNS'],
  'Geothermal': ['NNP'],
  'Gephardt': ['NNP'],
  'Gephardtian': ['JJ'],
  'Geraetetechnik': ['NNP'],
  'Geraghty': ['NNP'],
  'Geraghtys': ['NNPS'],
  'Gerald': ['NNP'],
  'Geraldine': ['NNP'],
  'Geraldo': ['NNP'],
  'Gerard': ['NNP'],
  'Gerardo': ['NNP'],
  'Gerber': ['NNP'],
  'Gerbig': ['NNP'],
  'Gerbrandt': ['NNP'],
  'Gerby': ['NNP'],
  'Gerd': ['NNP'],
  'Gerdes': ['NNP'],
  'Geren': ['NNP'],
  'Gerhard': ['NNP'],
  'Gericault': ['NNP'],
  'Gerlinger': ['NNP'],
  'Germain': ['NNP'],
  'German': ['JJ'],
  'German-French': ['JJ'],
  'German-Italian': ['JJ'],
  'German-born': ['JJ'],
  'German-built': ['JJ'],
  'German-language': ['JJ'],
  'German-made': ['JJ'],
  'German-speaking': ['JJ'],
  'Germania': ['NNP'],
  'Germanic': ['JJ'],
  'Germanized': ['VBN'],
  'Germano-Slavic': ['JJ'],
  'Germans': ['NNPS'],
  'Germans.': ['NNS'],
  'Germantown': ['NNP'],
  'Germany': ['NNP'],
  'Germany-based': ['JJ'],
  'Germanys': ['NNS'],
  'Germeten': ['NNP'],
  'Germont': ['NNP'],
  'Gero': ['NNP'],
  'Geroge': ['NNP'],
  'Gerolamo': ['NNP'],
  'Gerold': ['NNP'],
  'Gerome': ['NNP'],
  'Gerosa': ['NNP'],
  'Gerrard': ['NNP'],
  'Gerraughty': ['NNP'],
  'Gerry': ['NNP'],
  'Gershen': ['NNP'],
  'Gershman': ['NNP'],
  'Gershwin': ['NNP'],
  'Gershwins': ['NNP'],
  'Gersony': ['NNP'],
  'Gerstacker': ['NNP'],
  'Gerstenblatt': ['NNP'],
  'Gerstner': ['NNP'],
  'Gertrude': ['NNP'],
  'Gesamtkunstwerke': ['FW'],
  'Gesangverein': ['NNP'],
  'Gesell': ['NNP'],
  'Gestapo': ['NNP'],
  'Gestapo-style': ['JJ'],
  'Geste': ['NNP'],
  'Gesualdo': ['NNP'],
  'Get': ['VB'],
  'Gethsemane': ['NN'],
  'Getrudis': ['NNP'],
  'Gets': ['VBZ'],
  'Getting': ['VBG'],
  'Gettinger': ['NNP'],
  'Gettleman': ['NNP'],
  'Getty': ['NNP'],
  'Gettysburg': ['NNP'],
  'Getulio': ['NNP'],
  'Getz': ['NNP'],
  'Geva': ['NNP'],
  'Gevergeyev': ['NNP'],
  'Gevergeyeva': ['NNP'],
  'Gevurtz': ['NNP'],
  'Gewirtz': ['NNP'],
  'Geza': ['NNP'],
  'Ghadiali': ['NNP'],
  'Ghana': ['NNP'],
  'Ghanaian': ['JJ'],
  'Ghazel': ['NNP'],
  'Ghent': ['NNP'],
  'Gherlein': ['NNP'],
  'Ghettos': ['NNPS'],
  'Ghez': ['NNP'],
  'Ghiberti': ['NNP'],
  'Gholamreza': ['NNP'],
  'Ghoreyeb': ['NNP'],
  'Ghormley': ['NNP'],
  'Ghose': ['NNP'],
  'Ghost': ['NN'],
  'Ghostbusters': ['NNS'],
  'Giacometti': ['NNP'],
  'Giacomo': ['NNP'],
  'Giamatti': ['NNP'],
  'Giampiero': ['NNP'],
  'Gian': ['NNP'],
  'Giancarlo': ['NNP'],
  'Gianicolo': ['NNP'],
  'Gianni': ['NNP'],
  'Giannini': ['NNP'],
  'Giant': ['NNP'],
  'Giants': ['NNP'],
  'Giants-Houston': ['NNP'],
  'Giaour': ['NN'],
  'Giardini\\\'/Russell': ['NNP'],
  'Gibault': ['NNP'],
  'Gibbon': ['NNP'],
  'Gibbons': ['NNP'],
  'Gibbs': ['NNP'],
  'Gibby': ['NNP'],
  'Giblen': ['NNP'],
  'Gibraltar': ['NNP'],
  'Gibson': ['NNP'],
  'Giddings': ['NNP'],
  'Gide': ['NNP'],
  'Gideon': ['NNP'],
  'Gidwani': ['NNP'],
  'Gie': ['NNP'],
  'Gienow': ['NNP'],
  'Giffen': ['NNP'],
  'Gifford': ['NNP'],
  'Gift': ['NNP'],
  'Gifting': ['NN'],
  'Gifts': ['NNS'],
  'Gigenza': ['NNP'],
  'Giggey': ['NNP'],
  'Gignac': ['NNP'],
  'Gignoux': ['NNP'],
  'Gigot': ['NNP'],
  'Giguiere': ['NNP'],
  'Gil': ['NNP'],
  'Gilbert': ['NNP'],
  'Gilbertie': ['NNP'],
  'Gilberto': ['NNP'],
  'Gilborn': ['NNP'],
  'Gilbraltar': ['NNP'],
  'Gilchrist': ['NNP'],
  'Gilda': ['NNP'],
  'Gildas': ['NNP'],
  'Gilded': ['NNP'],
  'Gilder': ['NNP'],
  'Gildersleeve': ['NNP'],
  'Gilels': ['NNP'],
  'Giles': ['NNP'],
  'Gilgore': ['NNP'],
  'Gilhooley': ['NNP'],
  'Gilkson': ['NNP'],
  'Gill': ['NNP'],
  'Gilleland': ['NNP'],
  'Gillers': ['NNP'],
  'Gilles': ['NNP'],
  'Gillespie': ['NNP'],
  'Gillett': ['NNP'],
  'Gillette': ['NNP'],
  'Gilley': ['NNP'],
  'Gillian': ['NNP'],
  'Gillis': ['NNP'],
  'Gilman': ['NNP'],
  'Gilmartin': ['NNP'],
  'Gilmore': ['NNP'],
  'Gilroy': ['NNP'],
  'Gilsbar': ['NNP'],
  'Gilt': ['NNP'],
  'Gilts': ['NNS'],
  'Gim-': ['NNP'],
  'Gimbel': ['NNP'],
  'Gimenez': ['NNP'],
  'Gimpy': ['NNP'],
  'Gin': ['NNP'],
  'Ginandjar': ['NNP'],
  'Gingerly': ['RB'],
  'Ginghams': ['NNS'],
  'Gingl': ['NNP'],
  'Gingrich': ['NNP'],
  'Ginn': ['NNP'],
  'Ginner': ['NNP'],
  'Ginnie': ['NNP'],
  'Ginning': ['NNP'],
  'Gino': ['NNP'],
  'Ginsberg': ['NNP'],
  'Ginsburg': ['NNP'],
  'Gintel': ['NNP'],
  'Ginza': ['NN'],
  'Gioconda': ['NNP'],
  'Giolito': ['NNP'],
  'Giordano': ['NNP'],
  'Giorgetta': ['NNP'],
  'Giorgio': ['NNP'],
  'Giorgios': ['NNP'],
  'Giovanni': ['NNP'],
  'Giraffe': ['NNP'],
  'Giraldi': ['NNP'],
  'Girard': ['NNP'],
  'Giraud': ['NNP'],
  'Girl': ['NNP'],
  'Girls': ['NNP'],
  'Giroldi': ['NNP'],
  'Giroux': ['NNP'],
  'Girozentrale': ['NNP'],
  'Gisele': ['NNP'],
  'Giselle': ['NNP'],
  'Gisors': ['NNP'],
  'Git': ['VB'],
  'Gitanes': ['NNP'],
  'Gitano': ['NNP'],
  'Gitter': ['NNP'],
  'Giubbonari': ['NNP'],
  'Giuffrida': ['NNP'],
  'Giuliani': ['NNP'],
  'Giulietta': ['NNP'],
  'Giulio': ['NNP'],
  'Giurleo': ['NNP'],
  'Giuseppe': ['NNP'],
  'Giustiniani': ['NNP'],
  'Givaudan': ['NNP'],
  'Give': ['VB'],
  'Giveaways': ['NNS'],
  'Given': ['VBN'],
  'Givens': ['NNP'],
  'Givers': ['NNP'],
  'Gives': ['VBZ'],
  'Giving': ['VBG'],
  'Gizenga': ['NNP'],
  'Glacier': ['NNP'],
  'Glaciology': ['NNP'],
  'Glad': ['JJ'],
  'Gladden': ['NNP'],
  'Gladdy': ['NNP'],
  'Gladiator': ['NNP'],
  'Gladius': ['NNP'],
  'Gladys': ['NNP'],
  'Glamorous': ['JJ'],
  'Glance': ['VB'],
  'Glantz': ['NNP'],
  'Glaris': ['NNP'],
  'Glaser': ['NNP'],
  'Glasgow': ['NNP'],
  'Glasnost': ['FW'],
  'Glasow': ['NNP'],
  'Glass': ['NNP'],
  'Glass-Steagall': ['NNP'],
  'Glassell': ['NNP'],
  'Glasser': ['NNP'],
  'Glasses': ['NNS'],
  'Glasswork': ['NNP'],
  'Glassworks': ['NNP'],
  'Glauber': ['NNP'],
  'Glavin': ['NNP'],
  'Glaxo': ['NNP'],
  'Glayre': ['NNP'],
  'Glaze': ['VB'],
  'Glazed': ['VBN'],
  'Glazer': ['NNP'],
  'Glazer-Fine': ['NNP'],
  'Glazes': ['NNS'],
  'Glazier': ['NNP'],
  'Gleacher': ['NNP'],
  'Gleason': ['NNP'],
  'Glee': ['NN'],
  'Gleeson': ['NNP'],
  'Glemp': ['NNP'],
  'Glen': ['NNP'],
  'Glenbrook': ['NNP'],
  'Glenda': ['NNP'],
  'Glendale': ['NNP'],
  'Glendora': ['NNP'],
  'Glenham': ['NNP'],
  'Glenn': ['NNP'],
  'Glenne': ['NNP'],
  'Glennon': ['NNP'],
  'Glenview': ['NNP'],
  'Glick': ['NNP'],
  'Glickman': ['NNP'],
  'Gliedman': ['NNP'],
  'Glimco': ['NNP'],
  'Glison': ['NNP'],
  'Glo': ['NNP'],
  'Global': ['NNP'],
  'Globalization': ['NNP'],
  'Globaliztion': ['NN'],
  'Globally': ['RB'],
  'Globe': ['NNP'],
  'Globe-Democrat': ['NNP'],
  'Globex': ['NNP'],
  'Globo': ['NNP'],
  'Globocnik': ['NNP'],
  'Glocester': ['NNP'],
  'Gloeilampenfabrieken': ['NNP'],
  'Gloom': ['NN'],
  'Gloomy': ['JJ'],
  'Gloria': ['NNP'],
  'Gloriana': ['NNP'],
  'Glorioso': ['NNP'],
  'Glorious': ['JJ'],
  'Glory': ['NN'],
  'Glossy': ['JJ'],
  'Gloucester': ['NNP'],
  'Glove': ['NNP'],
  'Glover': ['NNP'],
  'Gloversville': ['NNP'],
  'Gloves': ['NNP'],
  'Glow': ['NNP'],
  'Glowering': ['VBG'],
  'Gluck': ['NNP'],
  'Glucksman': ['NNP'],
  'Glue': ['NN'],
  'Glumly': ['RB'],
  'Glycerinated': ['JJ'],
  'Glynis': ['NNP'],
  'Gnu-Emacs': ['NNP'],
  'Go': ['VB'],
  'Go-Go': ['NN'],
  'Goa': ['NNP'],
  'Goals': ['NNPS'],
  'Gobain': ['NNP'],
  'Gobbee': ['NNP'],
  'God': ['NNP'],
  'God-curst': ['JJ'],
  'God-forsaken': ['JJ'],
  'God-given': ['JJ'],
  'Goddammit': ['UH'],
  'Goddamn': ['UH'],
  'Goddard': ['NNP'],
  'Goddess': ['NNP'],
  'Godfather': ['NNP'],
  'Godfrey': ['NNP'],
  'Godiva': ['NNP'],
  'Godkin': ['NNP'],
  'Godot': ['NNP'],
  'Godown': ['NNP'],
  'Gods': ['NNP'],
  'Godspeed': ['NN'],
  'Godunov': ['NNP'],
  'Godwin': ['NNP'],
  'Goebbels': ['NNP'],
  'Goebel': ['NNP'],
  'Goering': ['NNP'],
  'Goes': ['VBZ'],
  'Goethe': ['NNP'],
  'Goetz': ['NNP'],
  'Goffstein': ['NNP'],
  'Gog': ['NNP'],
  'Gogh': ['NNP'],
  'Gogo': ['NNP'],
  'Gogol': ['NNP'],
  'Goh': ['NNP'],
  'Going': ['VBG'],
  'Goizueta': ['NNP'],
  'Golan': ['NNP'],
  'Golar': ['NNP'],
  'Gold': ['NNP'],
  'Gold-backed': ['JJ'],
  'Gold-oriented': ['JJ'],
  'GoldCard': ['NNP'],
  'Gold\\\'/Minerals': ['NNP'],
  'Golda': ['NNP'],
  'Goldang': ['UH'],
  'Goldberg': ['NNP'],
  'Golden': ['NNP'],
  'Goldenberg': ['NNP'],
  'Goldenthal': ['NNP'],
  'Goldfein': ['NNP'],
  'Goldie': ['NNP'],
  'Goldin': ['NNP'],
  'Goldinger': ['NNP'],
  'Goldline': ['NNP'],
  'Goldman': ['NNP'],
  'Goldome': ['NNP'],
  'Goldscheider': ['NNP'],
  'Goldschmidt': ['NNP'],
  'Goldsmith': ['NNP'],
  'Goldstar': ['NNP'],
  'Goldstein': ['NNP'],
  'Goldston': ['NNP'],
  'Goldwag': ['NNP'],
  'Goldwater': ['NNP'],
  'Goldwin': ['NNP'],
  'Goldwyn': ['NNP'],
  'Golenbock': ['NNP'],
  'Golf': ['NNP'],
  'Golfers': ['NNP'],
  'Goliath': ['NNP'],
  'Goliaths': ['NNPS'],
  'Gollich': ['NNP'],
  'Gollust': ['NNP'],
  'Golly': ['UH'],
  'Golomb': ['NNP'],
  'Golovanov': ['NNP'],
  'Goloven': ['NNP'],
  'Golub': ['NNP'],
  'Gomel': ['NNP'],
  'Gomez': ['NNP'],
  'Gompachi': ['NNP'],
  'Gon': ['VBG'],
  'Goncharov': ['NNP'],
  'Gone': ['VBN'],
  'Gong': ['NNP'],
  'Gontran': ['NNP'],
  'Gonzaga': ['NNP'],
  'Gonzales': ['NNP'],
  'Gonzalez': ['NNP'],
  'Good': ['JJ'],
  'Good-by': ['UH'],
  'Good-bye': ['UH'],
  'Good-faith': ['NN'],
  'Goodbody': ['NNP'],
  'Goodby': ['NNP'],
  'Goodbye': ['NNP'],
  'Goodchild': ['NNP'],
  'Goode': ['NNP'],
  'Goodfellow': ['NNP'],
  'Goodfriend': ['NNP'],
  'Gooding': ['NNP'],
  'Goodis': ['NNP'],
  'Goodison': ['NNP'],
  'Goodkind': ['NNP'],
  'Goodman': ['NNP'],
  'Goodmorning': ['UH'],
  'Goodrich': ['NNP'],
  'Goods': ['NNP'],
  'Goodson': ['NNP'],
  'Goodwill': ['NNP'],
  'Goodwills': ['NNPS'],
  'Goodwin': ['NNP'],
  'Goody': ['UH'],
  'Goodyear': ['NNP'],
  'Google': ['NNP'],
  'Goolick': ['NN'],
  'Goose': ['NNP'],
  'Gorbachev': ['NNP'],
  'Gorbachev-era': ['NN'],
  'Gorboduc': ['NNP'],
  'Gorby': ['NNP'],
  'Gorce': ['NNP'],
  'Gord': ['NNP'],
  'Gordan': ['NNP'],
  'Gordin': ['NNP'],
  'Gordon': ['NNP'],
  'Gordon\\\'/Pick': ['NNP'],
  'Gore': ['NNP'],
  'Gorenstein': ['NNP'],
  'Gorgeous': ['NNP'],
  'Gorham': ['NNP'],
  'Gorilla': ['NNP'],
  'Gorillas': ['NNP'],
  'Goriot': ['NNP'],
  'Gorky': ['NNP'],
  'Gorman': ['NNP'],
  'Gorney': ['NNP'],
  'Gornto': ['NNP'],
  'Gorshek': ['NNP'],
  'Gorshin': ['NNP'],
  'Gorski': ['NNP'],
  'Gortari': ['NNP'],
  'Gorton': ['NNP'],
  'Gortonists': ['NNS'],
  'Gosbank': ['NNP'],
  'Gosh': ['UH'],
  'Gosheim': ['NNP'],
  'Goshen': ['NNP'],
  'Gospel': ['NNP'],
  'Gospel-singer': ['NN'],
  'Gospelers': ['NNS'],
  'Gospels': ['NNP'],
  'Gosplan': ['NNP'],
  'Gossage': ['NNP'],
  'Gosset': ['NNP'],
  'Gossip': ['NN'],
  'Gossiping': ['NNP'],
  'Gossips': ['NNS'],
  'Gossnab': ['NNP'],
  'Gosson': ['NNP'],
  'Gostomski': ['NNP'],
  'Got': ['VBD'],
  'Gotaas-Larsen': ['NNP'],
  'Gotham': ['VB'],
  'Gothic': ['JJ'],
  'Gothicism': ['NNP'],
  'Gotlieb': ['NNP'],
  'Gotschall': ['NNP'],
  'Gotshal': ['NNP'],
  'Gott': ['FW'],
  'Gotta': ['VB'],
  'Gotterdammerung': ['NNP'],
  'Gottesfeld': ['NNP'],
  'Gottesman': ['NNP'],
  'Gottfried': ['NNP'],
  'Gottingen': ['NNP'],
  'Gottlieb': ['NNP'],
  'Gottschalk': ['NNP'],
  'Gottshall': ['NNP'],
  'Goudsmit': ['NNP'],
  'Gouge': ['VB'],
  'Gough': ['NNP'],
  'Gould': ['NNP'],
  'Goulde': ['NNP'],
  'Goulding': ['NNP'],
  'Gouldings': ['NNPS'],
  'Gouldoid': ['JJ'],
  'Goupil': ['NNP'],
  'Gourlay': ['NNP'],
  'Gourman': ['NNP'],
  'Gourmet': ['NNP'],
  'Gouvernement': ['NNP'],
  'Gov.': ['NNP'],
  'Goverman': ['NNP'],
  'Govern': ['VB'],
  'Governali': ['NNP'],
  'Governed': ['JJ'],
  'Governer': ['NNP'],
  'Government': ['NNP'],
  'Government-Sponsored': ['NNP'],
  'Government-blessed': ['JJ'],
  'Government-mandated': ['JJ'],
  'Government-owned': ['JJ'],
  'Governmental': ['NNP'],
  'Governments': ['NNS'],
  'Governor': ['NNP'],
  'Governor-General': ['NNP'],
  'Governors': ['NNP'],
  'Govett': ['NNP'],
  'Govette': ['NNP'],
  'Govs.': ['NNP'],
  'Goya': ['NNP'],
  'Goyette': ['NNP'],
  'Grab': ['VB'],
  'Grabbing': ['VBG'],
  'Grabe': ['NNP'],
  'Grabowiec': ['NNP'],
  'Grabski': ['NNP'],
  'Grace': ['NNP'],
  'Grace-Sierra': ['NNP'],
  'Graceful': ['JJ'],
  'Gracias': ['FW'],
  'Gracie': ['NNP'],
  'Graciela': ['NNP'],
  'Grad': ['NNP'],
  'Gradco': ['NNP'],
  'Grade': ['NNP'],
  'Gradison': ['NNP'],
  'Gradmann': ['NNP'],
  'Grads': ['NNS'],
  'Gradual': ['JJ'],
  'Gradually': ['RB'],
  'Graduate': ['NNP'],
  'Graduate-student': ['NN'],
  'Graduates': ['NNS'],
  'Grady': ['NNP'],
  'Graedel': ['NNP'],
  'Graeme': ['NNP'],
  'Graf': ['NNP'],
  'Graff': ['NNP'],
  'Grafil': ['NNP'],
  'Grafin': ['NNP'],
  'Graft': ['NN'],
  'Grafton': ['NNP'],
  'Graham': ['NNP'],
  'Grahams': ['NNPS'],
  'Grahamstown': ['NNP'],
  'Grail': ['NNP'],
  'Grain': ['NNP'],
  'Grains': ['NNS'],
  'Grais': ['NNP'],
  'Gram': ['JJ'],
  'Gram-negative': ['JJ'],
  'Gramercy': ['NNP'],
  'Gramm': ['NNP'],
  'Gramm-Rudman': ['NNP'],
  'Gramm-Rudman-Hollings': ['NNP'],
  'Grammar': ['NNP'],
  'Grammophon': ['NNP'],
  'Grammys': ['NNS'],
  'Gran': ['NNP'],
  'Granada': ['NNP'],
  'Granath': ['NNP'],
  'Grand': ['NNP'],
  'Grand-Clement': ['NNP'],
  'Grande': ['NNP'],
  'Grande-Bretagne': ['FW'],
  'Grandeur': ['NN'],
  'Grandis': ['NNP'],
  'Grandma': ['NNP'],
  'Grandmother': ['NNP'],
  'Grandmothers': ['NNP'],
  'Grandparent': ['NNP'],
  'Grandparents': ['NNP'],
  'Grands': ['NNP'],
  'Grandsire': ['NNP'],
  'Grandson': ['NNP'],
  'Grange': ['NNP'],
  'Granger': ['NNP'],
  'Granges': ['NNP'],
  'Granin': ['NNP'],
  'Granite': ['NNP'],
  'Grannell': ['NNP'],
  'Grannies': ['NNPS'],
  'Grannon': ['NNP'],
  'Granny': ['NNP'],
  'Grano': ['NNP'],
  'Grant': ['NNP'],
  'Granted': ['VBN'],
  'Granther': ['NNP'],
  'Grantor': ['NNP'],
  'Grants': ['NNPS'],
  'Grants-in-aid': ['NNS'],
  'Granville': ['NNP'],
  'Grapefruit': ['NNP'],
  'Grapes': ['NNP'],
  'Graph': ['NN'],
  'Graphic': ['NNP'],
  'Graphics': ['NNP'],
  'Grappelly': ['NNP'],
  'Grappely': ['NNP'],
  'Gras': ['NNP'],
  'Grass': ['NNP'],
  'Grass-roots': ['JJ'],
  'Grasslands': ['NNPS'],
  'Grassley': ['NNP'],
  'Grasso': ['NNP'],
  'Grassy': ['NNP'],
  'Grateful': ['NNP'],
  'Gratified': ['JJ'],
  'Gratt': ['NNP'],
  'Grattan': ['NNP'],
  'Graubart': ['NNP'],
  'Grauer': ['NNP'],
  'Grauman': ['NNP'],
  'Gravelle': ['NNP'],
  'Gravely': ['NNP'],
  'Graves': ['NNP'],
  'Gravesend': ['NNP'],
  'Gravity': ['NN'],
  'Gray': ['NNP'],
  'Grayhound': ['NNP'],
  'Grayson': ['NNP'],
  'Graziano': ['NNP'],
  'Grazie': ['NNP'],
  'Gre\'t': ['JJ'],
  'Gre.': ['NNP'],
  'Greaney': ['NNP'],
  'Grease': ['NN'],
  'Greases': ['NNS'],
  'Greasies': ['NNS'],
  'Greasy': ['JJ'],
  'Great': ['NNP'],
  'Greater': ['NNP'],
  'Greatest': ['JJS'],
  'Greatly': ['RB'],
  'Greatness': ['NNP'],
  'Grecian': ['JJ'],
  'Greco': ['NNP'],
  'Greece': ['NNP'],
  'Greed': ['NN'],
  'Greedily': ['RB'],
  'Greek': ['NNP'],
  'Greek-Americans': ['NNPS'],
  'Greek-Canadian': ['JJ'],
  'Greek-Danish': ['NNP'],
  'Greek-born': ['JJ'],
  'Greek-speaking': ['JJ'],
  'Greekfest': ['NNP'],
  'Greeks': ['NNPS'],
  'Green': ['NNP'],
  'Green-labeled': ['JJ'],
  'Greenall': ['NNP'],
  'Greenback': ['NNP'],
  'Greenbelt': ['NNP'],
  'Greenberg': ['NNP'],
  'Greenberger': ['NNP'],
  'Greene': ['NNP'],
  'Greene\\\'/Worldwide': ['NNP'],
  'Greener': ['JJR'],
  'Greenery': ['NNP'],
  'Greenfield': ['NNP'],
  'Greenhill': ['NNP'],
  'Greenhouse': ['NN'],
  'Greeniaus': ['NNP'],
  'Greening': ['NN'],
  'Greenland': ['NNP'],
  'Greenleaf': ['NNP'],
  'Greenmoss': ['NNP'],
  'Greenness': ['NN'],
  'Greenock': ['NNP'],
  'Greenpeace': ['NNP'],
  'Greens': ['NNPS'],
  'Greensboro': ['NNP'],
  'Greenshields': ['NNP'],
  'Greenspan': ['NNP'],
  'Greenspon': ['NNP'],
  'Greenstein': ['NNP'],
  'Greensville': ['NNP'],
  'Greentree': ['NNP'],
  'Greenville': ['NNP'],
  'Greenwald': ['NNP'],
  'Greenwich': ['NNP'],
  'Greenwich-Potowomut': ['NNP'],
  'Greenwood': ['NNP'],
  'Greer': ['NNP'],
  'Greetings': ['NNP'],
  'Greg': ['NNP'],
  'Gregg': ['NNP'],
  'Gregoire': ['NNP'],
  'Gregorio': ['NNP'],
  'Gregorius': ['NNP'],
  'Gregory': ['NNP'],
  'Greif': ['NNP'],
  'Greiff': ['NNP'],
  'Greifswald': ['NNP'],
  'Greiner': ['NNP'],
  'Greisler': ['NNP'],
  'Grenada': ['NNP'],
  'Grenadian': ['JJ'],
  'Grenfell': ['NNP'],
  'Grenier': ['NNP'],
  'Grenoble': ['NNP'],
  'Grenville': ['NNP'],
  'Gresham': ['NNP'],
  'Gressette': ['NNP'],
  'Gretchen': ['NNP'],
  'Grev.': ['NNP'],
  'Greve': ['NNP'],
  'Grevile': ['NNP'],
  'Greville': ['NNP'],
  'Grevyles': ['NNP'],
  'Grew': ['VBD'],
  'Grey': ['NNP'],
  'Greyhound': ['NNP'],
  'Greylag': ['NNP'],
  'Grgich': ['NNP'],
  'Gribbin': ['NNP'],
  'Gribin': ['NNP'],
  'Grid': ['NNP'],
  'Gridley': ['NNP'],
  'Grieco': ['NNP'],
  'Grien': ['NNP'],
  'Griesa': ['NNP'],
  'Grievances': ['NNP'],
  'Griffin': ['NNP'],
  'Griffin-Byrd': ['NNP'],
  'Griffith': ['NNP'],
  'Griffith-Jones': ['NNP'],
  'Griffith-Joyner': ['NNP'],
  'Griggs': ['NNP'],
  'Grigoli': ['NNP'],
  'Grigori': ['NNP'],
  'Grigoriy': ['NNP'],
  'Grigorss': ['NNP'],
  'Grigory': ['NNP'],
  'Grigsby': ['NNP'],
  'Grill': ['NNP'],
  'Grimaldi': ['NNP'],
  'Grimes': ['NNP'],
  'Grimesby': ['NNP'],
  'Grimm': ['NNP'],
  'Grindlay': ['NNP'],
  'Grinevsky': ['NNP'],
  'Gringo': ['NN'],
  'Grinned': ['VBD'],
  'Grinsfelder': ['NNP'],
  'Grinten': ['NNP'],
  'Gripen': ['NNP'],
  'Gripped': ['VBN'],
  'Grippo': ['NNP'],
  'Grips': ['NNS'],
  'Gris': ['NNP'],
  'Grisebach': ['NNP'],
  'Griselda': ['NNP'],
  'Grisha-class': ['JJ'],
  'Grishaw-Mueller': ['NNP'],
  'Grisoni': ['NNP'],
  'Grist': ['NNP'],
  'Griston': ['NNP'],
  'Griswold': ['NNP'],
  'Grits': ['NNP'],
  'Gritten': ['NNP'],
  'Grizzlies': ['NNS'],
  'Gro': ['NNP'],
  'Gro-Lites': ['NNPS'],
  'Groat': ['NNP'],
  'Groben': ['NNP'],
  'Grobstein': ['NNP'],
  'Grocer': ['NNP'],
  'Grocery': ['NNP'],
  'Grodnik': ['NNP'],
  'Groep': ['NNP'],
  'Groff': ['NNP'],
  'Groggins': ['NNP'],
  'Grohl': ['NNP'],
  'Grohowski': ['NNP'],
  'Grolier': ['NNP'],
  'Gromov': ['NNP'],
  'Groom': ['NNP'],
  'Grooms': ['NNP'],
  'Groopman': ['NNP'],
  'Groot': ['NNP'],
  'Gross': ['NNP'],
  'Grosse': ['NNP'],
  'Grosset': ['NNP'],
  'Grossinger': ['NNP'],
  'Grossman': ['NNP'],
  'Grossner': ['NNP'],
  'Grosvenor': ['NNP'],
  'Grote': ['NNP'],
  'Groth': ['NNP'],
  'Groton': ['NNP'],
  'Groucho': ['NNP'],
  'Ground': ['NNP'],
  'Grounds': ['NNPS'],
  'Groundwater': ['NNP'],
  'Group': ['NNP'],
  'Group-of-Seven': ['NN'],
  'Group\\\'/Business': ['NNP'],
  'Groupe': ['NNP'],
  'Groupement': ['NNP'],
  'Groups': ['NNS'],
  'Groused': ['VBD'],
  'Grove': ['NNP'],
  'Grove\\\'/Weidenfeld': ['NN'],
  'Grover': ['NNP'],
  'Grovers': ['NNP'],
  'Groves': ['NNP'],
  'Grow': ['NNP'],
  'Growers': ['NNPS'],
  'Growing': ['VBG'],
  'Grows': ['VBZ'],
  'Growth': ['NN'],
  'GrubHub': ['NNP'],
  'Grubb': ['NNP'],
  'Gruber': ['NNP'],
  'Gruberova': ['NNP'],
  'Grubman': ['NNP'],
  'Grudges': ['NNS'],
  'Gruene': ['NNP'],
  'Gruller': ['NNP'],
  'Grumble': ['NNP'],
  'Grumbled': ['VBD'],
  'Grumman': ['NNP'],
  'Grunberg': ['NNP'],
  'Grundfest': ['NNP'],
  'Grune': ['NNP'],
  'Grunfeld': ['NNP'],
  'Grunnfeu': ['NNP'],
  'Gruntal': ['NNP'],
  'Grupo': ['NNP'],
  'Gruppe': ['NNP'],
  'Grusin': ['NNP'],
  'Gruss': ['NNP'],
  'Grzesiak': ['NNP'],
  'Gtech': ['NNP'],
  'Guadalajara': ['NNP'],
  'Guadalcanal': ['NNP'],
  'Guadalupe': ['NNP'],
  'Guadalupes': ['NNPS'],
  'Guadeloupe': ['NNP'],
  'Guam': ['NNP'],
  'Guandong': ['NNP'],
  'Guangdong': ['NNP'],
  'Guar': ['JJ'],
  'Guarana': ['NNP'],
  'Guarantee': ['NN'],
  'Guaranteed': ['VBN'],
  'Guaranty': ['NNP'],
  'Guarascio': ['NNP'],
  'Guard': ['NNP'],
  'Guardia': ['NNP'],
  'Guardian': ['NNP'],
  'Guardini': ['NNP'],
  'Guardino': ['NNP'],
  'Guards': ['NNPS'],
  'Guardsmen': ['NNPS'],
  'Guarini': ['NNP'],
  'Guatemala': ['NNP'],
  'Guatemalan': ['JJ'],
  'Guber': ['NNP'],
  'Guber-Peter': ['NNP'],
  'Guber-Peters': ['NNP'],
  'Guber\\\'/Peters': ['NNP'],
  'Gubers': ['NNP'],
  'Gucci': ['NNP'],
  'Guccione': ['NNP'],
  'Guderian': ['NNP'],
  'Guenter': ['NNP'],
  'Guerbet': ['NNP'],
  'Guerin': ['NNP'],
  'Guerneville': ['NNP'],
  'Guerrilla': ['NN'],
  'Guerrillas': ['NNS'],
  'Guess': ['NNP'],
  'Guesstimates': ['NNS'],
  'Guest': ['NNP'],
  'Guests': ['NNS'],
  'Guevara': ['NNP'],
  'Guffey': ['NNP'],
  'Guggenheim': ['NNP'],
  'Guglielmo': ['NNP'],
  'Guiana': ['NNP'],
  'Guidance': ['NN'],
  'Guide': ['NNP'],
  'Guidelines': ['NNS'],
  'Guideposts': ['NNPS'],
  'Guides': ['NNS'],
  'Guidi': ['NNP'],
  'Guido': ['NNP'],
  'Guiftes': ['NNS'],
  'Guigal': ['NNP'],
  'Guignol': ['NNP'],
  'Guild': ['NNP'],
  'Guildford': ['NNP'],
  'Guilford': ['NNP'],
  'Guilford-Martin': ['NNP'],
  'Guilherme': ['NNP'],
  'Guilin': ['NNP'],
  'Guillaume': ['NNP'],
  'Guillermin': ['NNP'],
  'Guillermo': ['NNP'],
  'Guimet': ['NNP'],
  'Guinea': ['NNP'],
  'Guinness': ['NNP'],
  'Guiseppe': ['NNP'],
  'Guitar': ['NNP'],
  'Guitarist': ['NNP'],
  'Guizot': ['NNP'],
  'Gujarat': ['NN'],
  'Gulag': ['NNP'],
  'Gulbuddin': ['NNP'],
  'Gulch': ['NNP'],
  'Gulf': ['NNP'],
  'Gulfstream': ['NNP'],
  'Gulick': ['NNP'],
  'Gullah': ['NNP'],
  'Gulliver': ['NNP'],
  'Gumbel': ['NNP'],
  'Gumbel\\\'/Walt': ['NNP'],
  'Gumi': ['NNP'],
  'Gumkowski': ['NNP'],
  'Gummi-Werke': ['NNP'],
  'Gump': ['NNP'],
  'Gumpel': ['NNP'],
  'Gumport': ['NNP'],
  'Gums': ['NNS'],
  'Gumucio': ['NNP'],
  'Gun': ['NNP'],
  'Gunder': ['NNP'],
  'Gundle': ['NNP'],
  'Gundy': ['NNP'],
  'Gunfire': ['NN'],
  'Gunlocke': ['NNP'],
  'Gunmen': ['NNS'],
  'Gunnar': ['NNP'],
  'Gunner': ['NNP'],
  'Gunny': ['NNP'],
  'Guns': ['NNS'],
  'Gunter': ['NNP'],
  'Gunther': ['NNP'],
  'Gunthrop-Warren': ['NNP'],
  'Gunton': ['NNP'],
  'Guofeng': ['NNP'],
  'Guppy': ['NNP'],
  'Gupta': ['NNP'],
  'Gur': ['NNP'],
  'Guralnick': ['NNP'],
  'Gurion': ['NNP'],
  'Gurkhas': ['NNP'],
  'Gurla': ['NNP'],
  'Gurria': ['NNP'],
  'Gursel': ['NNP'],
  'Gurtz': ['NNP'],
  'Gurus': ['NNS'],
  'Gus': ['NNP'],
  'Gustaf': ['NNP'],
  'Gustafson': ['NNP'],
  'Gustafsson': ['NNP'],
  'Gustav': ['NNP'],
  'Gustave': ['NNP'],
  'Gustavo': ['NNP'],
  'Gustavus': ['NNP'],
  'Guste': ['NNP'],
  'Gute': ['FW'],
  'Gutenberghus': ['NNP'],
  'Guterman': ['NNP'],
  'Gutermann': ['NNP'],
  'Gutfeld': ['NNP'],
  'Gutfreund': ['NNP'],
  'Gutfreund-Postel': ['NNP'],
  'Gutfreunds': ['NNPS'],
  'Guth': ['NNP'],
  'Guthman': ['NNP'],
  'Guthrie': ['NNP'],
  'Guttmacher': ['NNP'],
  'Guttman': ['NNP'],
  'Guttman-type': ['JJ'],
  'Gutwein': ['NNP'],
  'Gutzon': ['NNP'],
  'Guy': ['NNP'],
  'Guyana': ['NNP'],
  'Guyon': ['NNP'],
  'Guys': ['NNS'],
  'Guzewich': ['NNP'],
  'Guzman': ['NNP'],
  'Guzzi': ['NNP'],
  'Gwen': ['NNP'],
  'Gwendolyn': ['NNP'],
  'Gwyn': ['NNP'],
  'Gyi': ['NNP'],
  'Gyllensten': ['NNP'],
  'Gymnasium': ['NNP'],
  'Gynecologists': ['NNS'],
  'Gyp': ['NNP'],
  'Gypsum': ['NNP'],
  'Gypsy': ['NN'],
  'Gyrocompass': ['NN'],
  'Gyula': ['NNP'],
  'H': ['NNP'],
  'H&M': ['NNP'],
  'H&Q': ['NNP'],
  'H&R': ['NNP'],
  'H\'all': ['DT'],
  'H-2': ['NNP'],
  'H-P': ['NNP'],
  'H.': ['NNP'],
  'H.A.': ['NNP'],
  'H.C.': ['NNP'],
  'H.E.': ['NNP'],
  'H.F.': ['NNP'],
  'H.G.': ['NNP'],
  'H.H.': ['NNP'],
  'H.J.': ['NNP'],
  'H.K.': ['NNP'],
  'H.L.': ['NNP'],
  'H.M.': ['NNP'],
  'H.M.S.': ['NNP'],
  'H.M.S.S': ['NNP'],
  'H.M.S.S.': ['NNP'],
  'H.N.': ['NNP'],
  'H.P.R.': ['NNP'],
  'H.R.': ['NNP'],
  'H.S.': ['NNP'],
  'H.T.': ['NNP'],
  'H.V.': ['NNP'],
  'H.W.': ['NNP'],
  'H/NNP.A.': ['NN'],
  'H2Owner': ['NNP'],
  'HA': ['UH'],
  'HAD': ['VBD'],
  'HAHAHA': ['UH'],
  'HAL': ['NNP'],
  'HALE': ['NNP'],
  'HALT': ['NNP'],
  'HANDICAPPED': ['VBN'],
  'HANNIFIN': ['NNP'],
  'HANOVER': ['NNP'],
  'HAPPY': ['JJ'],
  'HARD': ['JJ'],
  'HAS': ['VBZ'],
  'HASTINGS': ['NNP'],
  'HATER': ['NN'],
  'HATS': ['NNS'],
  'HAVE': ['VB'],
  'HAWLEY': ['NNP'],
  'HBJ': ['NNP'],
  'HBO': ['NNP'],
  'HCA': ['NNP'],
  'HCC': ['NNP'],
  'HCF': ['NNP'],
  'HCFA': ['NNP'],
  'HCFCs': ['NNS'],
  'HCS': ['NNP'],
  'HD': ['NNP'],
  'HDI': ['NNP'],
  'HDM': ['NNP'],
  'HDTV': ['NN'],
  'HDTV-screen': ['JJ'],
  'HDTVs': ['NNS'],
  'HE': ['PRP'],
  'HEADED': ['VBD'],
  'HEALTH': ['NN'],
  'HEALTH-CARE': ['NN'],
  'HEALTHDYNE': ['NNP'],
  'HEALTHY': ['JJ'],
  'HEARS': ['VBZ'],
  'HEAVY': ['JJ'],
  'HEFTY': ['NNP'],
  'HEI': ['NNP'],
  'HELD': ['VBD'],
  'HELPS': ['VBZ'],
  'HENRI': ['NNP'],
  'HENRY': ['NNP'],
  'HERE\'S': ['VB'],
  'HERITAGE': ['NNP'],
  'HERO': ['NN'],
  'HERS': ['NNP'],
  'HEUBLEIN': ['NNP'],
  'HEWLETT-PACKARD': ['NNP'],
  'HEXCEL': ['NNP'],
  'HEXX': ['NNP'],
  'HEYNOW': ['NNP'],
  'HF': ['NNP'],
  'HFC': ['NNP'],
  'HG': ['NNP'],
  'HHS': ['NNP'],
  'HI': ['NNP'],
  'HIAA': ['NNP'],
  'HIB': ['NNP'],
  'HIGH': ['NNP'],
  'HIGH-SCHOOL': ['NN'],
  'HIGHER': ['JJR'],
  'HIGHEST': ['JJS'],
  'HILLS': ['NNP'],
  'HIRING': ['NN'],
  'HIS': ['NNP'],
  'HISPANIC': ['JJ'],
  'HIV': ['NNP'],
  'HIV-1': ['NNP'],
  'HIV-infected': ['JJ'],
  'HIV-related': ['JJ'],
  'HIV\\\'': ['NNP'],
  'HIV\\\'/AIDS': ['JJ'],
  'HK': ['NNP'],
  'HK\$': ['\$'],
  'HLR': ['NNP'],
  'HLTs': ['NNS'],
  'HM': ['NNP'],
  'HMA': ['NNP'],
  'HMOs': ['NNP'],
  'HMS': ['NNP'],
  'HMSS': ['NNP'],
  'HN': ['NNP'],
  'HNSX': ['NNP'],
  'HOBBY': ['NN'],
  'HOCKEY': ['NN'],
  'HOFI': ['NNP'],
  'HOLD': ['VB'],
  'HOLDING': ['NNP'],
  'HOLDINGS': ['NNPS'],
  'HOLIDAY': ['NNP'],
  'HOLLYWOOD': ['NNP'],
  'HOME': ['NNP'],
  'HOME-SALE': ['JJ'],
  'HOMEOWNERS': ['NNS'],
  'HOMESTAKE': ['NNP'],
  'HOMESTEAD': ['NNP'],
  'HONECKER': ['NNP'],
  'HOPE': ['VBP'],
  'HOPES': ['NNS'],
  'HOSPITALS': ['NNS'],
  'HOT': ['JJ'],
  'HOTEL': ['NNP'],
  'HOTELS': ['NNPS'],
  'HOUSE': ['NNP'],
  'HOUSTON': ['NNP'],
  'HOUSTON-CALGARY': ['NNP'],
  'HP': ['NNP'],
  'HPB': ['NNP'],
  'HRB': ['NNP'],
  'HRE': ['NNP'],
  'HRH': ['NNP'],
  'HRT': ['NNP'],
  'HUCKSTER\'S': ['NN'],
  'HUD': ['NNP'],
  'HUD-backed': ['JJ'],
  'HUD-related': ['JJ'],
  'HUD-subsidized': ['JJ'],
  'HUD-supervised': ['JJ'],
  'HUDSON': ['NNP'],
  'HUGE': ['JJ'],
  'HUGO': ['NNP'],
  'HUGO\'S': ['NNP'],
  'HUH': ['NNP'],
  'HUNGARY': ['NNP'],
  'HUNGARY\'S': ['NNP'],
  'HUNTING': ['NN'],
  'HUNTLEY': ['NNP'],
  'HURRICANE': ['NNP'],
  'HUSBANDS': ['NNS'],
  'HUTTON': ['NNP'],
  'HYATT': ['NNP'],
  'Ha': ['NNP'],
  'Haack': ['NNP'],
  'Haaek': ['NNP'],
  'Haag': ['NNP'],
  'Haagen': ['NNP'],
  'Haagen-Dazs': ['NNP'],
  'Haake': ['NNP'],
  'Haan': ['NNP'],
  'Haarlem': ['NNP'],
  'Haas': ['NNP'],
  'Haase': ['NNP'],
  'Haavelmo': ['NNP'],
  'Habeas': ['FW'],
  'Haber': ['NNP'],
  'Haberle': ['NNP'],
  'Habib': ['NNP'],
  'Habicht': ['NNP'],
  'Habitat': ['NNP'],
  'Habla': ['NNP'],
  'Habomai': ['NNP'],
  'Habsburg': ['NNP'],
  'Hacche': ['NNP'],
  'Hachette': ['NNP'],
  'Hachiya': ['NNP'],
  'Hachiyas': ['NNPS'],
  'Hachuel': ['NNP'],
  'Hacienda': ['NNP'],
  'Hack': ['NNP'],
  'Hackel': ['NNP'],
  'Hackensack': ['NNP'],
  'Hackett': ['NNP'],
  'Hackettstown': ['NNP'],
  'Hacking': ['VBG'],
  'Hackman': ['NNP'],
  'Hackmann': ['NNP'],
  'Hackney': ['NNP'],
  'Hacksaw': ['NNP'],
  'Hackstaff': ['NNP'],
  'Had': ['VBD'],
  'Hadassah': ['NNP'],
  'Haddad': ['NNP'],
  'Haddix': ['NNP'],
  'Haden': ['NNP'],
  'Hadera': ['NNP'],
  'Hadhazy': ['NNP'],
  'Hadley': ['NNP'],
  'Hadrian': ['NNP'],
  'Hadson': ['NNP'],
  'Haementeria': ['FW'],
  'Haestier': ['NNP'],
  'Hafer': ['NNP'],
  'Haferkamp': ['NNP'],
  'Hafetz': ['NNP'],
  'Hafez': ['NNP'],
  'Hafif': ['NNP'],
  'Hafiz': ['NNP'],
  'Hafner': ['NNP'],
  'Hage': ['NNP'],
  'Hagen': ['NNP'],
  'Hager': ['NNP'],
  'Hagerty': ['NNP'],
  'Haggard': ['NNP'],
  'Hagner': ['NNP'],
  'Hagood': ['NNP'],
  'Hagoshrim': ['NNP'],
  'Hague': ['NNP'],
  'Hagura': ['NNP'],
  'Haha': ['UH'],
  'Hahaha': ['UH'],
  'Hahn': ['NNP'],
  'Hahnemann': ['NNP'],
  'Haig': ['NNP'],
  'Haight': ['NNP'],
  'Haigler': ['NNP'],
  'Haijac': ['NNP'],
  'Hail': ['NNP'],
  'Haile': ['NNP'],
  'Hainan': ['NNP'],
  'Haines': ['NNP'],
  'Hair': ['NN'],
  'Haislip': ['NNP'],
  'Haislmaier': ['NNP'],
  'Haiti': ['NNP'],
  'Haitian': ['JJ'],
  'Hajak': ['NNP'],
  'Hajime': ['NNP'],
  'Hakim': ['NNP'],
  'Hakko': ['NNP'],
  'Hakuhodo': ['NNP'],
  'Hal': ['NNP'],
  'Halas': ['NNP'],
  'Halcion': ['NNP'],
  'Halda': ['NNP'],
  'Haldeman': ['NNP'],
  'Hale': ['NNP'],
  'Halebian': ['NNP'],
  'Half': ['NN'],
  'Half-man': ['JJ'],
  'Half-time': ['JJ'],
  'Half-year': ['JJ'],
  'Halfback': ['NNP'],
  'Halfway': ['RB'],
  'Haliburton': ['NNP'],
  'Halis': ['NNP'],
  'Halkett': ['NNP'],
  'Hall': ['NNP'],
  'Hall-Mills': ['NNP'],
  'Hallador': ['NNP'],
  'Hallbauer': ['NNP'],
  'Halle': ['NNP'],
  'Halleck': ['NNP'],
  'Hallelujah': ['NNP'],
  'Hallett': ['NNP'],
  'Halliburton': ['NNP'],
  'Hallingby': ['NNP'],
  'Hallman': ['NNP'],
  'Hallmark': ['NNP'],
  'Halloran': ['NNP'],
  'Halloween': ['NNP'],
  'Hallowell': ['NNP'],
  'Halls': ['NNP'],
  'Hallucigenia': ['NNP'],
  'Hallwood': ['NNP'],
  'Halma': ['NNP'],
  'Halo': ['NNP'],
  'Halperin': ['NNP'],
  'Halpern': ['NNP'],
  'Halprin': ['NNP'],
  'Hals': ['NNP'],
  'Halsey': ['NNP'],
  'Halsmuseum': ['NNP'],
  'Halstead': ['NNP'],
  'Halsted': ['NNP'],
  'Halting': ['VBG'],
  'Halva-Neubauer': ['NNP'],
  'Ham': ['NNP'],
  'Hama': ['NNP'],
  'Hama-style': ['JJ'],
  'Hamakua': ['NN'],
  'Hambrecht': ['NNP'],
  'Hambric': ['NNP'],
  'Hambros': ['NNP'],
  'Hamburg': ['NNP'],
  'Hamburger': ['NN'],
  'Hamburgers': ['NNP'],
  'Hamer': ['NNP'],
  'Hamey': ['NNP'],
  'Hamilton': ['NNP'],
  'Hamilton-Dorgan': ['NNP'],
  'Hamilton-oriented': ['JJ'],
  'Hamiltonian': ['JJ'],
  'Hamiltonians': ['NNPS'],
  'Hamish': ['NNP'],
  'Hamlet': ['NNP'],
  'Hamlin': ['NNP'],
  'Hamm': ['NNP'],
  'Hammacher': ['NNP'],
  'Hammack': ['NNP'],
  'Hammacks': ['NNP'],
  'Hammarskjold': ['NNP'],
  'Hammer': ['NNP'],
  'Hammer.``': ['``'],
  'Hammers': ['VBZ'],
  'Hammerschmidt': ['NNP'],
  'Hammersla': ['NNP'],
  'Hammersmith': ['NNP'],
  'Hammerstein': ['NNP'],
  'Hammerton': ['NNP'],
  'Hammett': ['NNP'],
  'Hammond': ['NNP'],
  'Hammons': ['NNP'],
  'Hampshire': ['NNP'],
  'Hampster': ['NNP'],
  'Hampton': ['NNP'],
  'Hamrick': ['NNP'],
  'Han': ['NNP'],
  'Hanao': ['NNP'],
  'Hanaspur': ['NNP'],
  'Hanauer': ['NNP'],
  'Hanch': ['NNP'],
  'Hancock': ['NNP'],
  'Hand': ['NN'],
  'Hand-holding': ['NN'],
  'Handbook': ['NN'],
  'Handel': ['NNP'],
  'Handels': ['NNP'],
  'Handelsbank': ['NNP'],
  'Handelsbanken': ['NNP'],
  'Handelsman': ['NNP'],
  'Handguns': ['NNS'],
  'Handicapped': ['NNP'],
  'Handing': ['VBG'],
  'Handle': ['VB'],
  'Handled': ['VBN'],
  'Handler': ['NNP'],
  'Handlers': ['NNP'],
  'Handley': ['NNP'],
  'Handling': ['VBG'],
  'Handmade': ['NNP'],
  'Handmaid': ['NNP'],
  'Hands': ['NNP'],
  'Hands-off': ['JJ'],
  'Hands-on': ['JJ'],
  'Handsome': ['JJ'],
  'Handsomest': ['JJS'],
  'Handstands': ['NNS'],
  'Handy': ['NNP'],
  'Handyman': ['NNP'],
  'Handzlik': ['NNP'],
  'Hanes': ['NNP'],
  'Haney': ['NNP'],
  'Hanford': ['NNP'],
  'Hanfsaengl': ['NNP'],
  'Hanft': ['NNP'],
  'Hang': ['NNP'],
  'Hanging': ['VBG'],
  'Hangman': ['NNP'],
  'Hani': ['NNP'],
  'Hanifen': ['NNP'],
  'Hank': ['NNP'],
  'Hanks': ['NNP'],
  'Hanley': ['NNP'],
  'Hanlon': ['NNP'],
  'Hann': ['NNP'],
  'Hannah': ['NNP'],
  'Hannam': ['NNP'],
  'Hannes': ['NNP'],
  'Hannibal': ['NNP'],
  'Hannifin': ['NNP'],
  'Hannon': ['NNP'],
  'Hannover': ['NNP'],
  'Hanoi': ['NNP'],
  'Hanoi-backed': ['JJ'],
  'Hanover': ['NNP'],
  'Hanover-Bertie': ['NNP'],
  'Hanover-Ceyway': ['NNP'],
  'Hanover-Chalidale': ['NNP'],
  'Hanover-Justitia': ['NNP'],
  'Hanover-Lucy': ['NNP'],
  'Hanover-Mauri': ['NNP'],
  'Hanover-Misty': ['NNP'],
  'Hanover-Pebble': ['NNP'],
  'Hanover-Precious': ['NNP'],
  'Hanover-Sally': ['NNP'],
  'Hanover-Supermarket': ['NNP'],
  'Hanoverian': ['NNP'],
  'Hans': ['NNP'],
  'Hans-Dietrich': ['NNP'],
  'Hans-Peter': ['NNP'],
  'Hans-Ulrich': ['NNP'],
  'HansGeorg': ['NNP'],
  'Hansen': ['NNP'],
  'Hanshin': ['NNP'],
  'Hansmann': ['NNP'],
  'Hanson': ['NNP'],
  'Hanukkah': ['NNP'],
  'Hanwa': ['NNP'],
  'Haole': ['FW'],
  'Hap': ['NNP'],
  'Hapgood': ['NNP'],
  'Hapoalim': ['NNP'],
  'Happened': ['VBD'],
  'Happens': ['VBZ'],
  'Happily': ['RB'],
  'Happiness': ['NN'],
  'Happy': ['NNP'],
  'Hapsburg': ['NNP'],
  'Haqvin': ['NNP'],
  'Har-Lev': ['NNP'],
  'Hara': ['NNP'],
  'Harapiak': ['NNP'],
  'Harassed': ['JJ'],
  'Harassment': ['NN'],
  'Harbanse': ['NNP'],
  'Harbert': ['NNP'],
  'Harbison': ['NNP'],
  'Harbor': ['NNP'],
  'Harbor\\\'/Save': ['NNP'],
  'Harbors': ['NNPS'],
  'Harbour': ['NNP'],
  'Harbridge': ['NNP'],
  'Harburg': ['NNP'],
  'Harch': ['NNP'],
  'Harco': ['NNP'],
  'Harcourt': ['NNP'],
  'Hard': ['NNP'],
  'Hard-Hearted': ['NNP'],
  'Hard-Line': ['JJ'],
  'Hard-hitting': ['JJ'],
  'Hard-surface': ['JJ'],
  'Hardart': ['NNP'],
  'Hardball': ['NNP'],
  'Hardee': ['NNP'],
  'Hardest': ['JJS'],
  'Hardiman': ['NNP'],
  'Harding': ['NNP'],
  'Hardings': ['NNPS'],
  'Hardis': ['NNP'],
  'Hardly': ['RB'],
  'Hardscrabble': ['NNP'],
  'Hardshell': ['NNP'],
  'Hardware': ['NNP'],
  'Hardwick': ['NNP'],
  'Hardwicke': ['NNP'],
  'Hardwicke-Etter': ['NNP'],
  'Hardy': ['NNP'],
  'Hare': ['NNP'],
  'Harel': ['NNP'],
  'Harford': ['NNP'],
  'Hargett': ['NNP'],
  'Hargitay': ['NNP'],
  'Hargrave': ['NNP'],
  'Hargrove': ['NNP'],
  'Hark': ['NNP'],
  'Harken': ['NNP'],
  'Harkess': ['NNP'],
  'Harkin': ['NNP'],
  'Harkins': ['NNP'],
  'Harkinson': ['NNP'],
  'Harlan': ['NNP'],
  'Harlan-Hickory': ['NNP'],
  'Harlan-Marcia': ['NNP'],
  'Harland': ['NNP'],
  'Harlem': ['NNP'],
  'Harlequins': ['NNPS'],
  'Harley': ['NNP'],
  'Harley-Davidson': ['NNP'],
  'Harlin': ['NNP'],
  'Harlingen': ['NNP'],
  'Harlow': ['NNP'],
  'Harm': ['NNP'],
  'Harman': ['NNP'],
  'Harmas': ['NNP'],
  'Harmful': ['JJ'],
  'Harmless': ['JJ'],
  'Harmon': ['NNP'],
  'Harmonia': ['NNP'],
  'Harmonizing': ['NNP'],
  'Harmony': ['NNP'],
  'Harms': ['NNP'],
  'Harnack': ['NNP'],
  'Harnessing': ['VBG'],
  'Harnick': ['NNP'],
  'Harnischfeger': ['NNP'],
  'Haro': ['NNP'],
  'Harold': ['NNP'],
  'Harpener': ['NNP'],
  'Harper': ['NNP'],
  'Harperner': ['NNP'],
  'Harpers': ['NNP'],
  'Harpo': ['NNP'],
  'Harpoon': ['NNP'],
  'Harrah': ['NNP'],
  'Harrell': ['NNP'],
  'Harrier': ['NNP'],
  'Harriers': ['NNPS'],
  'Harriet': ['NNP'],
  'Harrigan': ['NNP'],
  'Harriman': ['NNP'],
  'Harrington': ['NNP'],
  'Harris': ['NNP'],
  'Harrisburg': ['NNP'],
  'Harrison': ['NNP'],
  'Harriton': ['NNP'],
  'Harrity': ['NNP'],
  'Harro': ['UH'],
  'Harrold': ['NNP'],
  'Harrow': ['NNP'],
  'Harrows': ['NNPS'],
  'Harry': ['NNP'],
  'Harsco': ['NNP'],
  'Hart': ['NNP'],
  'Hart-Scott': ['NNP'],
  'Hart-Scott-Rodino': ['NNP'],
  'Harte-Hanks': ['NNP'],
  'Hartfield-Zodys': ['NNP'],
  'Hartford': ['NNP'],
  'Hartford-based': ['JJ'],
  'Hartford\\\'/Springfield': ['NNP'],
  'Hartigan': ['NNP'],
  'Hartley': ['NNP'],
  'Hartley-Leonard': ['NNP'],
  'Hartlib': ['NNP'],
  'Hartman': ['NNP'],
  'Hartmarx': ['NNP'],
  'Hartnett': ['NNP'],
  'Hartselle': ['NNP'],
  'Hartsfield': ['NNP'],
  'Hartt': ['NNP'],
  'Hartung': ['NNP'],
  'Hartweger': ['NNP'],
  'Hartwell': ['NNP'],
  'Harty': ['NNP'],
  'Hartz': ['NNP'],
  'Hartzog': ['NNP'],
  'Haruki': ['NNP'],
  'Haruo': ['NNP'],
  'Haruyuki': ['NNP'],
  'Harvard': ['NNP'],
  'Harve': ['NNP'],
  'Harvest': ['NNP'],
  'Harvester': ['NNP'],
  'Harvesting': ['NN'],
  'Harvey': ['NNP'],
  'Harveys': ['NNPS'],
  'Harvie': ['NNP'],
  'Harwood': ['NNP'],
  'Has': ['VBZ'],
  'Hasbro': ['NNP'],
  'Hasbrouck': ['NNP'],
  'Hasbrouk': ['NNP'],
  'Haselhoff': ['NNP'],
  'Hasenauer': ['NNP'],
  'Hash': ['NNP'],
  'Hashers': ['NNS'],
  'Hashidate': ['NNP'],
  'Hashimoto': ['NNP'],
  'Hashing': ['NN'],
  'Hasidic': ['JJ'],
  'Haskayne': ['NNP'],
  'Haskell': ['NNP'],
  'Haskin': ['NNP'],
  'Haskins': ['NNP'],
  'Hassan': ['NNP'],
  'Hasse': ['NNP'],
  'Hasseltine': ['NNP'],
  'Hassenberg': ['NNP'],
  'Hassenfeld': ['NNP'],
  'Hassenfelt': ['NNP'],
  'Hassey': ['NNP'],
  'Haste': ['NN'],
  'Hastening': ['VBG'],
  'Hastert': ['NNP'],
  'Hastily': ['RB'],
  'Hasting': ['NNP'],
  'Hastings': ['NNP'],
  'Hastings-on-Hudson': ['NNP'],
  'Hat': ['NNP'],
  'Hatakeyama': ['NNP'],
  'Hatch': ['NNP'],
  'Hatched': ['VBN'],
  'Hatchet': ['NNP'],
  'Hatchett': ['NNP'],
  'Hatching': ['NNP'],
  'Hatfield': ['NNP'],
  'Hathaway': ['NNP'],
  'Hathcock': ['NNP'],
  'Hating': ['VBG'],
  'Hatless': ['JJ'],
  'Hatred': ['NN'],
  'Hatteras': ['NNP'],
  'Hatters': ['NNP'],
  'Hattie': ['NNP'],
  'Hattiesburg': ['NNP'],
  'Hatton': ['NNP'],
  'Hattori': ['NNP'],
  'Hauer': ['NNP'],
  'Haugh': ['NNP'],
  'Haughey': ['NNP'],
  'Haughton': ['NNP'],
  'Hauling': ['VBG'],
  'Haumd': ['NNP'],
  'Haun': ['NNP'],
  'Hauptman': ['NNP'],
  'Haupts': ['NNP'],
  'Hauser': ['NNP'],
  'Hausman': ['NNP'],
  'Haussmann': ['NNP'],
  'Haut': ['NNP'],
  'Haut-Brion': ['NNP'],
  'Havana': ['NNP'],
  'Have': ['VBP'],
  'Havel': ['NNP'],
  'Haven': ['NNP'],
  'Havens': ['NNP'],
  'Haverfield': ['NNP'],
  'Haverhill': ['NNP'],
  'Havilland': ['NNP'],
  'Having': ['VBG'],
  'Havisham': ['NNP'],
  'Haw': ['UH'],
  'Hawaii': ['NNP'],
  'Hawaiian': ['NNP'],
  'Hawaiian-Americans': ['NNPS'],
  'Hawaiian\\\'/Japanese': ['JJ'],
  'Hawes': ['NNP'],
  'Hawesville': ['NNP'],
  'Hawk': ['NNP'],
  'Hawke': ['NNP'],
  'Hawker': ['NNP'],
  'Hawkes': ['NNP'],
  'Hawking': ['NNP'],
  'Hawkins': ['NNP'],
  'Hawkinses': ['NNPS'],
  'Hawks': ['NNPS'],
  'Hawksley': ['NNP'],
  'Hawksworth': ['NNP'],
  'Hawley': ['NNP'],
  'Hawn': ['NNP'],
  'Haworth': ['NNP'],
  'Hawthorne': ['NNP'],
  'Hay': ['NNP'],
  'Hayasaka': ['NNP'],
  'Hayden': ['NNP'],
  'Haydn': ['NNP'],
  'Haydon': ['NNP'],
  'Hayek': ['NNP'],
  'Hayes': ['NNP'],
  'Hayeses': ['NNPS'],
  'Haying': ['NN'],
  'Hayne': ['NNP'],
  'Haynes': ['NNP'],
  'Haynie': ['NNP'],
  'Hays': ['NNP'],
  'Hayter': ['NNP'],
  'Hayward': ['NNP'],
  'Haywood': ['NNP'],
  'Hazard': ['NNP'],
  'Hazardous': ['JJ'],
  'Hazards': ['NNS'],
  'Hazel': ['NNP'],
  'Hazell': ['NNP'],
  'Hazeltine': ['NNP'],
  'Hazelwood': ['NNP'],
  'Hazlett': ['NNP'],
  'Hazlitt': ['NNP'],
  'Hazy': ['NNP'],
  'Hazzard': ['NNP'],
  'He': ['PRP'],
  'He\'s': ['VBZ'],
  'Head': ['NNP'],
  'Headed': ['VBN'],
  'Heading': ['VBG'],
  'Headland': ['NNP'],
  'Headley': ['NNP'],
  'Headline': ['NNP'],
  'Headlines': ['NNS'],
  'Headly': ['NNP'],
  'Headquarters': ['NNP'],
  'Headrests': ['NNS'],
  'Heads': ['NNS'],
  'Heady': ['NNP'],
  'Healey': ['NNP'],
  'Health': ['NNP'],
  'Health-Chem': ['NNP'],
  'Health-care': ['JJ'],
  'Health-insurance': ['NN'],
  'HealthAmerica': ['NNP'],
  'HealthCare': ['NNP'],
  'HealthVest': ['NNP'],
  'Healthcare': ['NNP'],
  'Healthco': ['NNP'],
  'Healthdyne': ['NNP'],
  'Healthier': ['JJR'],
  'Healthsource': ['NNP'],
  'Healthvest': ['NNP'],
  'Healthy': ['JJ'],
  'Healy': ['NNP'],
  'Hear': ['VB'],
  'Heard': ['NNP'],
  'Hearing': ['NNP'],
  'Hearings': ['NNS'],
  'Hearn': ['NNP'],
  'Hearst': ['NNP'],
  'Heart': ['NNP'],
  'Heart-measuring': ['JJ'],
  'Heartburn': ['NNP'],
  'Heartland': ['NNP'],
  'Hearts': ['NNPS'],
  'Heartwise': ['NNP'],
  'Heat': ['NN'],
  'Heath': ['NNP'],
  'Heather': ['NNP'],
  'Heatherington': ['NNP'],
  'Heathrow': ['NNP'],
  'Heating': ['NN'],
  'Heatwole': ['NNP'],
  'Heave': ['VB'],
  'Heaven': ['NNP'],
  'Heavenly': ['NNP'],
  'Heavily': ['RB'],
  'Heavy': ['NNP'],
  'Heavy-coated': ['JJ'],
  'Heber': ['NNP'],
  'Hebert': ['NNP'],
  'Heberto': ['NNP'],
  'Hebraic': ['JJ'],
  'Hebrew': ['NNP'],
  'Hebrews': ['NNPS'],
  'Hebron': ['NNP'],
  'Hecht': ['NNP'],
  'Heck': ['NNP'],
  'Heckman': ['NNP'],
  'Hecla': ['NNP'],
  'Hector': ['NNP'],
  'Hedda': ['NNP'],
  'Hedding': ['NNP'],
  'Hedge': ['NNP'],
  'Hedges': ['NNP'],
  'Hedison': ['NNP'],
  'Hedman': ['NNP'],
  'Hedquist': ['NNP'],
  'Hedrick': ['NNP'],
  'Hee': ['UH'],
  'Heebner': ['NNP'],
  'Heed': ['VB'],
  'Heeding': ['VBG'],
  'Heel-Beryl': ['NNP'],
  'Heel-Betty': ['NNP'],
  'Heel-Holiday': ['NNP'],
  'Heel-Kaola': ['NNP'],
  'Heel-Lotus': ['NNP'],
  'Heel-Miracle': ['NNP'],
  'Heel-Terka': ['NNP'],
  'Heels': ['NNS'],
  'Heem': ['NNP'],
  'Heenan': ['NNP'],
  'Heerden': ['NNP'],
  'Hees': ['NNP'],
  'Heffer': ['NNP'],
  'Heffernan': ['NNP'],
  'Heffner': ['NNP'],
  'Heflin': ['NNP'],
  'Hefner': ['NNP'],
  'Hefter': ['NNP'],
  'Hegel': ['NNP'],
  'Hegelian': ['NNP'],
  'Heidegger': ['NNP'],
  'Heidelberg': ['NNP'],
  'Heideman': ['NNP'],
  'Heidenstam': ['NNP'],
  'Heidi': ['NNP'],
  'Heidrick': ['NNP'],
  'Heifetz': ['NNP'],
  'Heigh-ho': ['UH'],
  'Height': ['NN'],
  'Heightened': ['JJ'],
  'Heights': ['NNP'],
  'Heikes': ['NNP'],
  'Heiko': ['NNP'],
  'Heilbron': ['NNP'],
  'Heileman': ['NNP'],
  'Heilman': ['NNP'],
  'Heimbold': ['NNP'],
  'Heimers': ['NNP'],
  'Hein': ['NNP'],
  'Heinbockel': ['NNP'],
  'Heine': ['NNP'],
  'Heineken': ['NNP'],
  'Heinemann': ['NNP'],
  'Heinhold': ['NNP'],
  'Heinkel': ['NNP'],
  'Heinrich': ['NNP'],
  'Heintze': ['NNP'],
  'Heinz': ['NNP'],
  'Heinze': ['NNP'],
  'Heinzes': ['NNPS'],
  'Heisbourg': ['NNP'],
  'Heisch': ['NNP'],
  'Heiser': ['NNP'],
  'Heitman': ['NNP'],
  'Heitschmidt': ['NNP'],
  'Heiwa': ['NNP'],
  'Heiwado': ['NNP'],
  'Hekhmatyar': ['NNP'],
  'Helaba': ['NNP'],
  'Helane': ['NNP'],
  'Held': ['VBN'],
  'Heldring': ['NNP'],
  'Helen': ['NNP'],
  'Helena': ['NNP'],
  'Helene': ['NNP'],
  'Helfman': ['NNP'],
  'Helga': ['NNP'],
  'Helibor': ['NN'],
  'Helicopter': ['NNP'],
  'Helicopters': ['NNP'],
  'Helion': ['NNP'],
  'Helionetics': ['NNP'],
  'Heliopolis': ['NNP'],
  'Helix': ['NNP'],
  'Hell': ['UH'],
  'Hellene': ['NNP'],
  'Hellenic': ['NNP'],
  'Heller': ['NNP'],
  'Heller\\\'': ['NNP'],
  'Hellfire': ['NNP'],
  'Helliesen': ['NNP'],
  'Hellinger': ['NNP'],
  'Hellisen': ['NNP'],
  'Hellman': ['NNP'],
  'Hello': ['UH'],
  'Hells': ['NNP'],
  'Helm': ['NNP'],
  'Helmerich': ['NNP'],
  'Helmet': ['NN'],
  'Helms': ['NNP'],
  'Helmsley': ['NNP'],
  'Helmsley-Spear': ['NNP'],
  'HelmsleySpear': ['NNP'],
  'Helmut': ['NNP'],
  'Helmuth': ['NNP'],
  'Help': ['VB'],
  'Help-wanted': ['JJ'],
  'Helped': ['VBN'],
  'Helper': ['NNP'],
  'Helpern': ['NNP'],
  'Helping': ['VBG'],
  'Helpless': ['NNP'],
  'Helpline': ['NNP'],
  'Helps': ['VBZ'],
  'Helsinki': ['NNP'],
  'Helsinki-based': ['JJ'],
  'Helton': ['NNP'],
  'Helva': ['NNP'],
  'Hemant': ['NNP'],
  'Hemel': ['NNP'],
  'Hemenway': ['NNP'],
  'Hemingway': ['NNP'],
  'Hemisphere': ['NNP'],
  'Hemispheric': ['NNP'],
  'Hemmed': ['VBN'],
  'Hemmer': ['NNP'],
  'Hemming': ['NNP'],
  'Hemorrhage': ['NNP'],
  'Hempel': ['NNP'],
  'Hemphill': ['NNP'],
  'Hempstead': ['NNP'],
  'Hemus': ['NNP'],
  'Hemweg': ['NNP'],
  'Hen': ['NN'],
  'Hence': ['RB'],
  'Henceforth': ['RB'],
  'Henderson': ['NNP'],
  'Hendersonville': ['NNP'],
  'Hendl': ['NNP'],
  'Hendricks': ['NNP'],
  'Hendrik': ['NNP'],
  'Hendry': ['NNP'],
  'Heng-Shan': ['NNP'],
  'Hengeler': ['NNP'],
  'Hengesbach': ['NNP'],
  'Hengst': ['NNP'],
  'Henh': ['UH'],
  'Henley': ['NNP'],
  'Hennefeld': ['NNP'],
  'Hennessey': ['NNP'],
  'Hennessy': ['NNP'],
  'Henney': ['NNP'],
  'Henning': ['NNP'],
  'Henri': ['NNP'],
  'Henrich': ['NNP'],
  'Henrietta': ['NNP'],
  'Henrik': ['NNP'],
  'Henritze': ['NNP'],
  'Henry': ['NNP'],
  'Hens': ['NNS'],
  'Henson': ['NNP'],
  'Hentoff': ['NNP'],
  'Henze': ['NNP'],
  'Heorot': ['NNP'],
  'Hepatitis': ['NNP'],
  'Hephzibah': ['NNP'],
  'Hepker': ['NNP'],
  'Her': ['PRP\$'],
  'Heraclitus': ['NNP'],
  'Herald': ['NNP'],
  'Herald-American': ['NNP'],
  'Herald-Examiner': ['NNP'],
  'Herald-Post': ['NNP'],
  'Herald-Tribune': ['NNP'],
  'Herb': ['NNP'],
  'Herber': ['NNP'],
  'Herberet': ['NNP'],
  'Herbert': ['NNP'],
  'Herbig': ['NNP'],
  'Hercule': ['NNP'],
  'Herculean': ['JJ'],
  'Hercules': ['NNP'],
  'Herder': ['NNP'],
  'Herdman': ['NNP'],
  'Here': ['RB'],
  'Hereby': ['RB'],
  'Heredity': ['NN'],
  'Hereford': ['NNP'],
  'Heresy': ['NNP'],
  'Heretic': ['NN'],
  'Heretofore': ['RB'],
  'Herford': ['NNP'],
  'Herger': ['NNP'],
  'Hergesheimer': ['NNP'],
  'Hering': ['NNP'],
  'Heritage': ['NNP'],
  'Herman': ['NNP'],
  'Hermann': ['NNP'],
  'Hermanovski': ['NNP'],
  'Hermione': ['NNP'],
  'Hermitage': ['NNP'],
  'Hernandez': ['NNP'],
  'Hernando': ['NNP'],
  'Hero': ['NNP'],
  'Herod': ['NNP'],
  'Heroic': ['NNP'],
  'Herold': ['NNP'],
  'Heron': ['NNP'],
  'Herr': ['NNP'],
  'Herrera': ['NNP'],
  'Herrick': ['NNP'],
  'Herridge': ['NNP'],
  'Herrin-Murphysboro-West': ['NNP'],
  'Herring': ['NNP'],
  'Herrington': ['NNP'],
  'Herrman': ['NNP'],
  'Herrmann': ['NNP'],
  'Herron': ['NNP'],
  'Herry': ['NNP'],
  'Hers': ['JJ'],
  'Hersant': ['NNP'],
  'Herschel': ['NNP'],
  'Herscu': ['NNP'],
  'Hersey': ['NNP'],
  'Hersh': ['NNP'],
  'Hershel': ['NNP'],
  'Hershey': ['NNP'],
  'Hershhenson': ['NNP'],
  'Hershiser': ['NNP'],
  'Herslow': ['NNP'],
  'Hersly': ['NNP'],
  'Herter': ['NNP'],
  'Hertz': ['NNP'],
  'Herwick': ['NNP'],
  'Herwig': ['NNP'],
  'Herzenberg': ['NNP'],
  'Herzfeld': ['NNP'],
  'Herzlinger': ['NNP'],
  'Herzog': ['NNP'],
  'Hesburgh': ['NNP'],
  'Hesiometer': ['NN'],
  'Hesperus': ['NNP'],
  'Hess': ['NNP'],
  'Hessan': ['NNP'],
  'Hesse': ['NNP'],
  'Hesse-Darmstadt': ['NNP'],
  'Hessian': ['JJ'],
  'Hessians': ['NNS'],
  'Hessische': ['NNP'],
  'Hester': ['NNP'],
  'Heston': ['NNP'],
  'Hetman': ['NNP'],
  'Hettie': ['NNP'],
  'Hettinger': ['NNP'],
  'Hetty': ['NNP'],
  'Heublein': ['NNP'],
  'Heumann': ['NNP'],
  'Heusen': ['NNP'],
  'Heuvelmans': ['NNP'],
  'Hewett': ['NNP'],
  'Hewitt': ['NNP'],
  'Hewlett': ['NNP'],
  'Hewlett-Packard': ['NNP'],
  'Hewlett-Woodmere': ['NNP'],
  'Hewlitt': ['NNP'],
  'Hexen': ['FW'],
  'Hey': ['UH'],
  'Heyden': ['NNP'],
  'Heydrich': ['NNP'],
  'Heyford': ['NNP'],
  'Heylin': ['NNP'],
  'Heyman': ['NNP'],
  'Heymann': ['NNP'],
  'Heymeyer': ['NNP'],
  'Heyward': ['NNP'],
  'Heywood': ['NNP'],
  'Hez': ['NNP'],
  'Hi': ['UH'],
  'Hi-Country': ['NNP'],
  'HiPro': ['NNP'],
  'Hiatt': ['NNP'],
  'Hiawatha': ['NNP'],
  'Hibbard': ['NNP'],
  'Hibben': ['NNP'],
  'Hibernia': ['NNP'],
  'Hibler': ['NNP'],
  'Hibor': ['NNP'],
  'Hichens': ['NNP'],
  'Hickey': ['NNP'],
  'Hickman': ['NNP'],
  'Hickok': ['NNP'],
  'Hickory': ['NNP'],
  'Hicks': ['NNP'],
  'Hid': ['NNP'],
  'Hidden': ['VBN'],
  'Hideaki': ['NNP'],
  'Hideous': ['NNP'],
  'Hiding': ['VBG'],
  'Hieber': ['NNP'],
  'Hieronymus': ['NNP'],
  'Higgins': ['NNP'],
  'High': ['NNP'],
  'High-Grade': ['NNP'],
  'High-Tech': ['JJ'],
  'High-Yield': ['NNP'],
  'High-definition': ['JJ'],
  'High-end': ['JJ'],
  'High-gain': ['JJ'],
  'High-grade': ['JJ'],
  'High-level': ['JJ'],
  'High-priced': ['JJ'],
  'High-ranking': ['JJ'],
  'High-speed': ['JJ'],
  'High-tech': ['JJ'],
  'High-technologies': ['NNS'],
  'High-tension': ['JJ'],
  'High-yield': ['JJ'],
  'High-yielding': ['JJ'],
  'Higher': ['JJR'],
  'Higher-income': ['JJR'],
  'Highest': ['JJS'],
  'Highfield': ['NNP'],
  'Highland': ['NNP'],
  'Highlander': ['NNP'],
  'Highlands': ['NNP'],
  'Highlights': ['NNS'],
  'Highly': ['RB'],
  'Highness': ['NNP'],
  'Highway': ['NNP'],
  'Highways': ['NNS'],
  'Hijet': ['NNP'],
  'Hiker': ['NN'],
  'Hilary': ['NNP'],
  'Hilboldt': ['NNP'],
  'Hildebrandt': ['NNP'],
  'Hildegard': ['NNP'],
  'Hilder': ['NNP'],
  'Hildy': ['NNP'],
  'Hilger': ['NNP'],
  'Hilkert': ['NNP'],
  'Hill': ['NNP'],
  'Hillary': ['NNP'],
  'Hillcrest': ['NNP'],
  'Hillel': ['NNP'],
  'Hiller': ['NNP'],
  'Hillerich': ['NNP'],
  'Hillhaven': ['NNP'],
  'Hilliard': ['NNP'],
  'Hillis': ['NNP'],
  'Hillman': ['NNP'],
  'Hills': ['NNP'],
  'Hills-Hollywood': ['JJ'],
  'Hillsboro': ['NNP'],
  'Hillsborough': ['NNP'],
  'Hillsdale': ['NNP'],
  'Hillsdown': ['NNP'],
  'Hillstrom': ['NNP'],
  'Hillyard': ['NNP'],
  'Hillyer': ['NNP'],
  'Hilo': ['NNP'],
  'Hilprecht': ['NNP'],
  'Hilton': ['NNP'],
  'Hiltons': ['NNPS'],
  'Hiltunen': ['NNP'],
  'Him': ['PRP'],
  'Himalayan': ['JJ'],
  'Himalayas': ['NNPS'],
  'Hime': ['NNP'],
  'Himebaugh': ['NNP'],
  'Himmler': ['NNP'],
  'Himont': ['NNP'],
  'Himself': ['PRP'],
  'Hinchliff': ['NNP'],
  'Hinckley': ['NNP'],
  'Hindelong': ['NNP'],
  'Hindemith': ['NN'],
  'Hindenburg': ['NNP'],
  'Hindes': ['NNP'],
  'Hindle': ['NNP'],
  'Hindoo': ['NNP'],
  'Hindu': ['NNP'],
  'Hinduish': ['JJ'],
  'Hinduism': ['NNP'],
  'Hindus': ['NNP'],
  'Hine': ['NNP'],
  'Hines': ['NNP'],
  'Hingham': ['NNP'],
  'Hingorani': ['NNP'],
  'Hinkle': ['NNP'],
  'Hinman': ['NNP'],
  'Hino': ['NNP'],
  'Hinsdale': ['NNP'],
  'Hint': ['NN'],
  'Hinton': ['NNP'],
  'Hints': ['NNS'],
  'Hintz': ['NNP'],
  'Hinzack': ['NNP'],
  'Hip': ['NN'],
  'Hip-pocket': ['JJ'],
  'Hippie': ['NNP'],
  'Hippocrates': ['NNP'],
  'Hippodrome': ['NNP'],
  'Hippophagique': ['NNP'],
  'Hiram': ['NNP'],
  'Hirano': ['NNP'],
  'Hired': ['JJ'],
  'Hires': ['NNP'],
  'Hirey': ['NNP'],
  'Hiring': ['VBG'],
  'Hiroaki': ['NNP'],
  'Hirohito': ['NNP'],
  'Hironaka': ['NNP'],
  'Hiroshi': ['NNP'],
  'Hiroshima': ['NNP'],
  'Hiroyuki': ['NNP'],
  'Hirsch': ['NNP'],
  'Hirschey': ['NNP'],
  'Hirschfeld': ['NNP'],
  'Hirschman': ['NNP'],
  'Hirudo': ['FW'],
  'Hirzy': ['NNP'],
  'His': ['PRP\$'],
  'Hisao': ['NNP'],
  'Hisaya': ['NNP'],
  'Hisham': ['NNP'],
  'Hismanal': ['NNP'],
  'Hispanic': ['JJ'],
  'Hispanic-market': ['JJ'],
  'Hispanics': ['NNPS'],
  'Hispano': ['NNP'],
  'Hispanoil': ['NNP'],
  'Hiss': ['NNP'],
  'Histadrut': ['NNP'],
  'Histochemistry': ['NNP'],
  'Historian': ['NN'],
  'Historians': ['NNS'],
  'Historical': ['NNP'],
  'Historically': ['RB'],
  'Histories': ['NNP'],
  'History': ['NN'],
  'Histrionix': ['NNP'],
  'Hit': ['VBN'],
  'Hitachi': ['NNP'],
  'Hitch': ['NNP'],
  'Hitchcock': ['NNP'],
  'Hitching': ['VBG'],
  'Hitler': ['NNP'],
  'Hitlers': ['NNPS'],
  'Hits': ['NNS'],
  'Hitter': ['NN'],
  'Hitting': ['VBG'],
  'Hittner': ['NNP'],
  'Hive': ['NNP'],
  'Hixson': ['NNP'],
  'Hmm': ['NN'],
  'Hmmm': ['UH'],
  'Hmong': ['JJ'],
  'Hmpf': ['UH'],
  'Hnilica': ['NNP'],
  'Ho': ['NNP'],
  'Hoa': ['NNP'],
  'Hoa-whup': ['UH'],
  'Hoag': ['NNP'],
  'Hoagy': ['NNP'],
  'Hoak': ['NNP'],
  'Hoaps': ['NNP'],
  'Hoare': ['NNP'],
  'Hobart': ['NNP'],
  'Hobbes': ['NNP'],
  'Hobday': ['NNP'],
  'Hoboken': ['NNP'],
  'Hobson': ['NNP'],
  'Hoc': ['NNP'],
  'Hochiminh': ['NNP'],
  'Hochman': ['NNP'],
  'Hock': ['NNP'],
  'Hockaday': ['NNP'],
  'Hocke': ['NNP'],
  'Hockett': ['NNP'],
  'Hockey': ['NNP'],
  'Hockney': ['NNP'],
  'Hodel': ['NNP'],
  'Hodge': ['NNP'],
  'Hodgepodge': ['NN'],
  'Hodges': ['NNP'],
  'Hodgkin': ['NNP'],
  'Hodgson': ['NNP'],
  'Hodosh': ['NNP'],
  'Hodson': ['NNP'],
  'Hoe': ['VB'],
  'Hoe-Down': ['NNP'],
  'Hoechst': ['NNP'],
  'Hoelterhoff': ['NNP'],
  'Hoelzer': ['NNP'],
  'Hoemke': ['NNP'],
  'Hoenemeyer': ['NNP'],
  'Hoenlein': ['NNP'],
  'Hoeve': ['NNP'],
  'Hoexum': ['NNP'],
  'Hof': ['NNP'],
  'Hoff': ['NNP'],
  'Hoffa': ['NNP'],
  'Hoffer': ['NNP'],
  'Hoffman': ['NNP'],
  'Hoffmann-La': ['NNP'],
  'Hoffmann-LaRoche': ['NNP'],
  'Hofstad': ['NNP'],
  'Hofstra': ['NNP'],
  'Hog': ['NN'],
  'Hogan': ['NNP'],
  'Hoge': ['NNP'],
  'Hogg': ['NNP'],
  'Hogs': ['NNS'],
  'Hogue': ['NNP'],
  'Hogwash': ['NN'],
  'Hohlbein': ['NNP'],
  'Hoijer': ['NNP'],
  'Hokan': ['NNP'],
  'Hokey': ['JJ'],
  'Hokkaido': ['NNP'],
  'Hokuriku': ['NNP'],
  'Holabird': ['NNP'],
  'Holbrook': ['NNP'],
  'Holch': ['NNP'],
  'Holcomb': ['NNP'],
  'Holcombe': ['NNP'],
  'Hold': ['VB'],
  'Holden': ['NNP'],
  'Holderbank': ['NNP'],
  'Holderlin': ['NNP'],
  'Holders': ['NNS'],
  'Holding': ['NNP'],
  'Holdings': ['NNP'],
  'Holds': ['NNP'],
  'Hole': ['NNP'],
  'Holen': ['NNP'],
  'Holes': ['NNS'],
  'Holewinski': ['NNP'],
  'Holgerson': ['NNP'],
  'Holguin': ['NNP'],
  'Holiday': ['NNP'],
  'Holidays': ['NNS'],
  'Holien': ['NNP'],
  'Holies': ['NNPS'],
  'Holiness': ['NN'],
  'Holla': ['UH'],
  'Holland': ['NNP'],
  'Hollandale': ['NNP'],
  'Hollander': ['NNP'],
  'Holler': ['NNP'],
  'Holleran': ['NNP'],
  'Holley': ['NNP'],
  'Holliday': ['NNP'],
  'Holliger': ['NNP'],
  'Hollinger': ['NNP'],
  'Hollings': ['NNP'],
  'Hollingshead': ['NNP'],
  'Hollingsworth': ['NNP'],
  'Hollins': ['NNP'],
  'Hollis': ['NNP'],
  'Hollister': ['NNP'],
  'Holliston': ['NNP'],
  'Holloway': ['NNP'],
  'Hollowell': ['NNP'],
  'Hollsworth': ['NNP'],
  'Holly': ['NNP'],
  'Hollywood': ['NNP'],
  'Holman': ['NNP'],
  'Holmberg': ['NNP'],
  'Holmes': ['NNP'],
  'Holocaust': ['NNP'],
  'Holstein': ['NNP'],
  'Holston': ['NNP'],
  'Holt': ['NNP'],
  'Holty': ['NNP'],
  'Holtz': ['NNP'],
  'Holtzman': ['NNP'],
  'Holy': ['NNP'],
  'Holynskyj': ['NNP'],
  'Holyoke': ['NNP'],
  'Holz': ['NNP'],
  'Holzfaster': ['NNP'],
  'Holzman': ['NNP'],
  'Homart': ['NNP'],
  'Hombre': ['NNP'],
  'Hombrecher': ['NNP'],
  'Home': ['NNP'],
  'Home-keeping': ['JJ'],
  'Home-made': ['JJ'],
  'HomeCare': ['NNP'],
  'HomeFed': ['NNP'],
  'Homebrew': ['NNP'],
  'Homebuilders': ['NNPS'],
  'Homecoming': ['NN'],
  'Homeland': ['NN'],
  'Homeless': ['NNP'],
  'Homemade': ['NNP'],
  'Homemakers': ['NNP'],
  'Homemaster': ['JJ'],
  'Homeowner': ['NNP'],
  'Homeowners': ['NNP'],
  'Homer': ['NNP'],
  'Homeric': ['NNP'],
  'Homerists': ['NNS'],
  'Homeroom': ['NNP'],
  'Homerun': ['NN'],
  'Homes': ['NNP'],
  'Homestake': ['NNP'],
  'Homestead': ['NNP'],
  'Homewood': ['NNP'],
  'Homework': ['NN'],
  'Homicide': ['NNP'],
  'Homma': ['NNP'],
  'Homo': ['NN'],
  'Homosexuals': ['NNS'],
  'Homozygous': ['JJ'],
  'Hon': ['NNP'],
  'Hon\'ble': ['NNP'],
  'Hon.': ['NNP'],
  'HonFed': ['NNP'],
  'Honan': ['NNP'],
  'Honda': ['NNP'],
  'Hondas': ['NNPS'],
  'Hondius': ['NNP'],
  'Hondo': ['NNP'],
  'Honduran': ['JJ'],
  'Hondurans': ['NNS'],
  'Honduras': ['NNP'],
  'Hone': ['NNP'],
  'Honecker': ['NNP'],
  'Honest': ['UH'],
  'Honestly': ['RB'],
  'Honey': ['NNP'],
  'Honeybee': ['NNP'],
  'Honeysuckle': ['NNP'],
  'Honeywell': ['NNP'],
  'Honfed': ['NNP'],
  'Hong': ['NNP'],
  'Hongkong': ['NNP'],
  'Honiss': ['NNP'],
  'Honjo': ['NNP'],
  'Honolulu': ['NNP'],
  'Honolulu-based': ['JJ'],
  'Honor': ['NNP'],
  'Honorable': ['NNP'],
  'Honored': ['VBN'],
  'Honors': ['NNP'],
  'Honotassa': ['NNP'],
  'Honshu': ['NNP'],
  'Hooch': ['NNP'],
  'Hood': ['NNP'],
  'Hoof': ['NNP'],
  'Hooghli': ['NNP'],
  'Hoogli': ['NNP'],
  'Hook': ['NNP'],
  'Hooked': ['VBD'],
  'Hooker': ['NNP'],
  'Hooks': ['NNP'],
  'Hooper': ['NNP'],
  'Hoopla': ['NNP'],
  'Hooray': ['UH'],
  'Hoosier': ['NNP'],
  'Hoot': ['NNP'],
  'Hoover': ['NNP'],
  'Hope': ['NNP'],
  'Hoped-for': ['JJ'],
  'Hopedale': ['NNP'],
  'Hopefully': ['RB'],
  'Hopei': ['NNP'],
  'Hopes': ['NNS'],
  'Hopi': ['NNP'],
  'Hoping': ['VBG'],
  'Hopis': ['NNPS'],
  'Hopkins': ['NNP'],
  'Hopkinsian': ['NNP'],
  'Hopley': ['NNP'],
  'Hoppe': ['NNP'],
  'Hopson': ['NNP'],
  'Hopwood': ['NNP'],
  'Horace': ['NNP'],
  'Horatio': ['NNP'],
  'Hord': ['NNP'],
  'Hordern': ['NNP'],
  'Hori': ['NNP'],
  'Horicon': ['NNP'],
  'Horizon': ['NNP'],
  'Horizons': ['NNP'],
  'Hormats': ['NNP'],
  'Hormel': ['NNP'],
  'Horn': ['NNP'],
  'Hornaday': ['NNP'],
  'Hornbeck': ['NNP'],
  'Horne': ['NNP'],
  'Horner': ['NNP'],
  'Hornet': ['NNP'],
  'Hornets': ['NNPS'],
  'Horns': ['NNS'],
  'Hornung': ['NNP'],
  'Horowitz': ['NNP'],
  'Horrigan': ['NNP'],
  'Horror': ['NNP'],
  'Horry': ['NNP'],
  'Horse': ['NNP'],
  'Horsehead': ['NNP'],
  'Horsely': ['NNP'],
  'Horseman': ['NN'],
  'Horses': ['NNS'],
  'Horsham': ['NNP'],
  'Horst': ['NNP'],
  'Horstman': ['NNP'],
  'Horta': ['NNP'],
  'Horten': ['NNP'],
  'Horticultural': ['NNP'],
  'Horton': ['NNP'],
  'Horwath': ['NNP'],
  'Horwitz': ['NNP'],
  'Hosaka': ['NNP'],
  'Hose': ['NNP'],
  'Hosea': ['NNP'],
  'Hoses': ['NNS'],
  'Hoskyns': ['NNP'],
  'Hosni': ['NNP'],
  'Hosogane': ['NNP'],
  'Hosokawa': ['NNP'],
  'Hosomi': ['NNP'],
  'Hospice': ['NNP'],
  'Hospital': ['NNP'],
  'Hospital-Cornell': ['NNP'],
  'Hospitality': ['NNP'],
  'Hospitalization': ['NN'],
  'Hospitals': ['NNS'],
  'Host': ['NNP'],
  'Hostage': ['NNP'],
  'Hostaria': ['NNP'],
  'Hostess': ['NNP'],
  'Hostetter': ['NNP'],
  'Hostile': ['JJ'],
  'Hosting': ['VBG'],
  'Hot': ['NNP'],
  'Hotei': ['NNP'],
  'Hotel': ['NNP'],
  'Hotel-casino': ['NN'],
  'Hotelecopy': ['NNP'],
  'Hotels': ['NNPS'],
  'Hotham': ['NNP'],
  'Hotline': ['NNP'],
  'Houdaille': ['NNP'],
  'Houdini': ['NNP'],
  'Hough': ['NNP'],
  'Houghton': ['NNP'],
  'Houk': ['NNP'],
  'Houlian': ['NNP'],
  'Hound': ['NNP'],
  'Hounds': ['NNPS'],
  'Hourly': ['JJ'],
  'Hours': ['NNS'],
  'House': ['NNP'],
  'House-Senate': ['NNP'],
  'House-floor': ['JJ'],
  'House-passed': ['JJ'],
  'House.': ['NNP'],
  'Housed': ['VBN'],
  'Household': ['NNP'],
  'Households': ['NNS'],
  'Housekeeping': ['NN'],
  'Houses': ['NNS'],
  'Housewares': ['NNPS'],
  'Housewives': ['NNS'],
  'Housing': ['NNP'],
  'Housings': ['NNS'],
  'Housman': ['NNP'],
  'Houston': ['NNP'],
  'Houston-Dallas': ['JJ'],
  'Houston-Galveston': ['NNP'],
  'Houston-Montgomery': ['NNP'],
  'Houston-area': ['JJ'],
  'Houston-based': ['JJ'],
  'Houten': ['NNP'],
  'Houtz': ['NNP'],
  'Hovarter': ['NNP'],
  'Hovdingar': ['FW'],
  'Hovercraft': ['NNP'],
  'Hovis': ['NNP'],
  'Hovnanian': ['NNP'],
  'How': ['WRB'],
  'How\'s': ['NNS'],
  'How-2': ['NNP'],
  'Howard': ['NNP'],
  'Howda': ['WRB'],
  'Howdy': ['UH'],
  'Howe': ['NNP'],
  'Howell': ['NNP'],
  'However': ['RB'],
  'Howick': ['NNP'],
  'Howie': ['NNP'],
  'Howl': ['NNP'],
  'Howley': ['NNP'],
  'Howmet': ['NNP'],
  'Howorth': ['NNP'],
  'Howry': ['NNP'],
  'Howsabout': ['RB'],
  'Howsam': ['NNP'],
  'Howser': ['NNP'],
  'Howson-Algraphy': ['NNP'],
  'Howzit': ['NN'],
  'Hoxa': ['NNP'],
  'Hoxan': ['NNP'],
  'Hoy': ['NNP'],
  'Hoylake': ['NNP'],
  'Hoylake\\\'': ['JJ'],
  'Hoyle': ['NNP'],
  'Hoyt': ['NNP'],
  'Hoyte': ['NNP'],
  'Hoyvald': ['NNP'],
  'Hrothgar': ['NNP'],
  'Hsieh': ['NNP'],
  'Hsu': ['NNP'],
  'Hu': ['NNP'],
  'Hua': ['NNP'],
  'Huai': ['NNP'],
  'Hualien': ['NNP'],
  'Huang-ti': ['NNP'],
  'Huaqiong': ['NNP'],
  'Huard': ['NNP'],
  'Hub': ['NNP'],
  'Hubacher': ['NNP'],
  'Hubay': ['NNP'],
  'Hubba': ['UH'],
  'Hubbard': ['NNP'],
  'Hubbell': ['NNP'],
  'Hubble': ['NNP'],
  'Hubel': ['NNP'],
  'Huber': ['NNP'],
  'Hubermann': ['NNP'],
  'Hubert': ['NNP'],
  'Hubie': ['NNP'],
  'Huck': ['NNP'],
  'Hucksters': ['NNP'],
  'Hudbay': ['NNP'],
  'Huddle': ['NN'],
  'Hudnut': ['NNP'],
  'Hudson': ['NNP'],
  'Hue': ['NN'],
  'Hueglin': ['NNP'],
  'Huerta': ['NNP'],
  'Huey': ['NNP'],
  'Huff': ['NNP'],
  'Huffman': ['NNP'],
  'Huge': ['JJ'],
  'Hugely': ['RB'],
  'Huggies': ['NNPS'],
  'Huggins': ['NNP'],
  'Hugh': ['NNP'],
  'Hughes': ['NNP'],
  'Hughey': ['NNP'],
  'Hugo': ['NNP'],
  'Hugoton': ['NNP'],
  'Huhmun': ['NNP'],
  'Huichol': ['NNP'],
  'Huitotoes': ['NNS'],
  'Hulbert': ['NNP'],
  'Hulings': ['NNP'],
  'Hulks': ['NNS'],
  'Hull': ['NNP'],
  'Hulse': ['NNP'],
  'Hultberg': ['NNP'],
  'Human': ['NNP'],
  'Human-rights': ['NNS'],
  'Humana': ['NNP'],
  'Humanism': ['NNP'],
  'Humanist': ['NNP'],
  'Humanities': ['NNP'],
  'Humanity': ['NNP'],
  'Humberto': ['NNP'],
  'Humble': ['NNP'],
  'Humboldt': ['NNP'],
  'Hume': ['NNP'],
  'Humidity': ['NN'],
  'Humiliation': ['NN'],
  'Humility': ['NNP'],
  'Hummerstone': ['NNP'],
  'Humor': ['NN'],
  'Hump': ['NNP'],
  'Humphrey': ['NNP'],
  'Humphreys': ['NNP'],
  'Humphries': ['NNP'],
  'Humpty': ['NNP'],
  'Humulin': ['NNP'],
  'Hun': ['NNP'],
  'Hund': ['FW'],
  'Hundred': ['CD'],
  'Hundreds': ['NNS'],
  'Hung': ['NNP'],
  'Hungarian': ['JJ'],
  'Hungarian-born': ['NNP'],
  'Hungarians': ['NNPS'],
  'Hungary': ['NNP'],
  'Hungary-Suez': ['NNP'],
  'Hungerfords': ['NNP'],
  'Hungry': ['JJ'],
  'Hunkerish': ['JJ'],
  'Hunsucker': ['NNP'],
  'Hunt': ['NNP'],
  'Hunter': ['NNP'],
  'Hunterdon': ['NNP'],
  'Hunters': ['NNPS'],
  'Hunting': ['NN'],
  'Huntington': ['NNP'],
  'Huntingtons': ['NNPS'],
  'Huntley': ['NNP'],
  'Huntley-Brinkley': ['NNP'],
  'Huntsman': ['NNP'],
  'Huntsville': ['NNP'],
  'Huntz': ['NNP'],
  'Huo-Shan': ['NNP'],
  'Huppert': ['NNP'],
  'Hurd': ['NNP'],
  'Huricane': ['NNP'],
  'Hurley': ['NNP'],
  'Hurok': ['NNP'],
  'Huron': ['NNP'],
  'Hurrah': ['UH'],
  'Hurray': ['NNP'],
  'Hurrays': ['NNP'],
  'Hurrican': ['NNP'],
  'Hurricane': ['NNP'],
  'Hurricanes': ['NNPS'],
  'Hurry': ['VB'],
  'Hurst': ['NNP'],
  'Hurt': ['NNP'],
  'Hurtado': ['NNP'],
  'Hurter': ['NNP'],
  'Hurts': ['VBZ'],
  'Hurwitt': ['NNP'],
  'Hurwitz': ['NNP'],
  'Husak': ['NNP'],
  'Husbandry': ['NN'],
  'Hush': ['NN'],
  'Husk': ['NNP'],
  'Husker': ['NNP'],
  'Huskers': ['NNPS'],
  'Huskins': ['NNP'],
  'Husky': ['NNP'],
  'Hussein': ['NNP'],
  'Hussman': ['NNP'],
  'Hustead': ['NNP'],
  'Hustle': ['VB'],
  'Hustler': ['NN'],
  'Huston': ['NNP'],
  'Hut': ['NNP'],
  'Hutchings': ['NNP'],
  'Hutchins': ['NNP'],
  'Hutchinson': ['NNP'],
  'Hutchison': ['NNP'],
  'Hutton': ['NNP'],
  'Huwa': ['NNP'],
  'Hux': ['NNP'],
  'Huxley': ['NNP'],
  'Huxtable': ['NNP'],
  'Huy': ['NNP'],
  'Hwa-Shan': ['NNP'],
  'Hwan': ['NNP'],
  'Hwang': ['NNP'],
  'Hyannis': ['NNP'],
  'Hyatt': ['NNP'],
  'Hyatt-Clark': ['NNP'],
  'Hybrid': ['NNP'],
  'Hybritech': ['NNP'],
  'Hyde': ['NNP'],
  'Hyde-to-Jekyll': ['JJ'],
  'Hydra-matic': ['JJ'],
  'Hydraulic': ['NNP'],
  'Hydro': ['NNP'],
  'Hydro-Electric': ['NNP'],
  'Hydro-Quebec': ['NNP'],
  'Hydrochlorothiazides': ['NNS'],
  'Hydrogen': ['NN'],
  'Hydroxazine': ['NN'],
  'Hydroxides': ['NNS'],
  'Hyena': ['NN'],
  'Hygene': ['NNP'],
  'Hygiene': ['NNP'],
  'Hyman': ['NNP'],
  'Hymen': ['NN'],
  'Hymn': ['NN'],
  'Hymowitz': ['NNP'],
  'Hyndman': ['NNP'],
  'Hyon-hui': ['NNP'],
  'HyperCard': ['NNP'],
  'Hyperlite': ['NN'],
  'Hypnosis': ['NN'],
  'Hypocrisy': ['NN'],
  'Hypothalamic': ['JJ'],
  'Hypotheekkas': ['NNP'],
  'Hypotheses': ['NNPS'],
  'Hypothesis': ['NN'],
  'Hypothesizing': ['VBG'],
  'Hyun': ['NNP'],
  'Hyundai': ['NNP'],
  'I': ['PRP'],
  'I\'d': ['MD'],
  'I\'ll': ['MD'],
  'I\'m': ['VBP'],
  'I\'m-coming-down-your-throat': ['JJ'],
  'I\'ve': ['VBP'],
  'I-5': ['NNP'],
  'I-75': ['NN'],
  'I-880': ['NN'],
  'I-E': ['NNP'],
  'I.': ['NNP'],
  'I...': [':'],
  'I.A.': ['NN'],
  'I.A.P/NNP.A.': ['NN'],
  'I.B.M.': ['NNP'],
  'I.C.H': ['NNP'],
  'I.C.H.': ['NNP'],
  'I.D.': ['NN'],
  'I.E.P.': ['NNP'],
  'I.L.': ['NN'],
  'I.M.': ['NNP'],
  'I.M.F.': ['NNP'],
  'I.N.D.': ['NNP'],
  'I.P.': ['NNP'],
  'I.Q.': ['NNP'],
  'I.R.S': ['NNP'],
  'I.R.S.': ['NNP'],
  'I.S.': ['NNP'],
  'I.W.': ['NNP'],
  'IAFP': ['NNP'],
  'IATA': ['NNP'],
  'IBC': ['NNP'],
  'IBCA': ['NNP'],
  'IBC\\\'': ['NNP'],
  'IBC\\\'/Donoghue': ['NN'],
  'IBEW': ['NNP'],
  'IBJ': ['NNP'],
  'IBM': ['NNP'],
  'IBM-based': ['JJ'],
  'IBM-bashing': ['NN'],
  'IBM-compatible': ['JJ'],
  'IBM-oriented': ['JJ'],
  'IBM-remarketer': ['JJ'],
  'IBM\\\'': ['NNP'],
  'IBRD': ['NNP'],
  'IBT': ['NNP'],
  'IC': ['NNP'],
  'ICA': ['NNP'],
  'ICAO': ['NNP'],
  'ICBM': ['NNP'],
  'ICBMs': ['NNPS'],
  'ICC': ['NNP'],
  'ICCO': ['NNP'],
  'ICE': ['NNP'],
  'ICG': ['NNP'],
  'ICI': ['NNP'],
  'ICL-GE': ['NNP'],
  'ICM': ['NNP'],
  'ICN': ['NNP'],
  'ICS': ['NNP'],
  'IDA': ['NNP'],
  'IDB': ['NNP'],
  'IDD': ['NNP'],
  'IDEC': ['NNP'],
  'IDS': ['NNP'],
  'IDs': ['NNS'],
  'IF': ['IN'],
  'IFA': ['NNP'],
  'IFAR': ['NNP'],
  'IFC': ['NNP'],
  'IFI': ['NNP'],
  'IFIL': ['NNP'],
  'IFO': ['NNP'],
  'IG': ['NNP'],
  'IGS': ['NNP'],
  'IH.': ['NNP'],
  'II': ['NNP'],
  'IIGS': ['NNP'],
  'III': ['NNP'],
  'IIT': ['NNP'],
  'IIci': ['NNP'],
  'IIcx': ['NNP'],
  'IIs': ['NNPS'],
  'IJAL': ['NNP'],
  'IL-2': ['NNP'],
  'IL-4': ['NN'],
  'ILA': ['NNP'],
  'ILLINOIS': ['NNP'],
  'IMA': ['NNP'],
  'IMEDE': ['NNP'],
  'IMELDA': ['NNP'],
  'IMF': ['NNP'],
  'IMF-World': ['NNP'],
  'IMF-approved': ['JJ'],
  'IMF-guided': ['JJ'],
  'IMO': ['NNP'],
  'IMREG': ['NNP'],
  'IMS': ['NNP'],
  'IMSAI': ['NNP'],
  'IN': ['IN'],
  'INA': ['NNP'],
  'INB': ['NNP'],
  'INC': ['NNP'],
  'INC.': ['NNP'],
  'INCOME': ['NN'],
  'INCREASING': ['VBG'],
  'IND': ['NNP'],
  'INDEX': ['NN'],
  'INDIAN': ['JJ'],
  'INDUSTRIES': ['NNPS'],
  'INFLATION': ['NN'],
  'INFORMATION': ['NNP'],
  'INGERSOLL-RAND': ['NNP'],
  'INMAC': ['NNP'],
  'INPS': ['NNP'],
  'INQUIRY': ['NN'],
  'INRA': ['NNP'],
  'INS': ['NNP'],
  'INSEAD': ['NNP'],
  'INSTITUTE': ['NNP'],
  'INSURANCE': ['NNP'],
  'INSURERS': ['NNS'],
  'INT-1': ['CD'],
  'INTEL': ['NNP'],
  'INTENSIVE': ['JJ'],
  'INTER-TEL': ['NNP'],
  'INTERBANK': ['NNP'],
  'INTEREST': ['NN'],
  'INTEREST-RATE': ['NN'],
  'INTERMARK': ['NNP'],
  'INTERNATIONAL': ['NNP'],
  'INTERPUBLIC': ['NNP'],
  'INTERVOICE': ['NNP'],
  'INVESTIGATION': ['NNP'],
  'INVESTMENT': ['NNP'],
  'INVESTMENTS': ['NNPS'],
  'INVESTORS': ['NNS'],
  'IOC': ['NNP'],
  'IOCS': ['NN'],
  'IOCSIXF': ['NN'],
  'IOCSIXG': ['NN'],
  'IOS': ['NNP'],
  'IOU': ['NNP'],
  'IOUs': ['NNS'],
  'IOWA': ['NNP'],
  'IPM': ['NNP'],
  'IPO': ['NNP'],
  'IPOs': ['NNPS'],
  'IPTAY': ['NNP'],
  'IQ': ['NNP'],
  'IRA': ['NNP'],
  'IRA-Plus': ['NN'],
  'IRAN': ['NNP'],
  'IRAs': ['NNS'],
  'IRI': ['NNP'],
  'IRNA': ['NNP'],
  'IRONY': ['NN'],
  'IRS': ['NNP'],
  'IRS-HHS': ['JJ'],
  'IRSAC': ['NNP'],
  'IS': ['VBZ'],
  'ISC': ['NNP'],
  'ISC\\\'/Bunker': ['NNP'],
  'ISI': ['NNP'],
  'ISN\'T': ['VBZ'],
  'ISO': ['NNP'],
  'ISRAEL': ['NNP'],
  'ISSUE': ['NN'],
  'ISSUES': ['NNS'],
  'ISTAT': ['NNP'],
  'IT': ['PRP'],
  'IT\'S': ['VBZ'],
  'ITC': ['NNP'],
  'ITEL': ['NNP'],
  'ITG': ['NNP'],
  'ITO': ['NNP'],
  'ITS': ['PRP\$'],
  'ITT': ['NNP'],
  'IUD': ['NNP'],
  'IV': ['NNP'],
  'IV-drug-free': ['JJ'],
  'IVF': ['NNP'],
  'IX': ['CD'],
  'IXL': ['NNP'],
  'I\\\'': ['NNP'],
  'Iaciofano': ['NNP'],
  'Iacocca': ['NNP'],
  'Iain': ['NNP'],
  'Ian': ['NNP'],
  'Iard': ['NNP'],
  'Ibaraki': ['NNP'],
  'Ibbotson': ['NNP'],
  'Iberia': ['NNP'],
  'Iberian': ['NNP'],
  'Ibias': ['NNP'],
  'Ibn': ['NNP'],
  'Ibos': ['NNP'],
  'Ibrahim': ['NNP'],
  'Ibsen': ['NNP'],
  'Ica': ['NN'],
  'Icahn': ['NNP'],
  'Icahns': ['NNP'],
  'Ice': ['NNP'],
  'Iceland': ['NNP'],
  'Icelandic': ['NNP'],
  'Icelandic-speaking': ['JJ'],
  'Ich': ['FW'],
  'Ichi': ['NNP'],
  'Ichiro': ['NNP'],
  'Icterus': ['FW'],
  'Id': ['NN'],
  'Ida': ['NNP'],
  'Idaho': ['NNP'],
  'Idaho-based': ['JJ'],
  'Idal': ['NNP'],
  'Idea': ['FW'],
  'Ideal': ['NNP'],
  'Idealist': ['NN'],
  'Ideally': ['RB'],
  'Ideas': ['NNS'],
  'Idec': ['NNP'],
  'Identification': ['NNP'],
  'Identifying': ['VBG'],
  'Ideologues': ['NNS'],
  'Idex': ['NNP'],
  'Idiot': ['NN'],
  'Idje': ['NNP'],
  'Idle': ['JJ'],
  'Idol': ['NNP'],
  'Idols': ['NNS'],
  'Idris': ['NNP'],
  'Idrissa': ['NNP'],
  'Idrocarburi': ['NNP'],
  'Ierulli': ['NNP'],
  'If': ['IN'],
  'Ifint': ['NNP'],
  'Ifni': ['NNP'],
  'Ifo': ['NNP'],
  'IgG': ['NNP'],
  'Igaras': ['NNP'],
  'Igbo': ['NNP'],
  'Igdaloff': ['NNP'],
  'Iglehart': ['NNP'],
  'Ignacio': ['NNP'],
  'Ignatius': ['NNP'],
  'Ignazio': ['NNP'],
  'Ignition': ['NN'],
  'Ignorance': ['NN'],
  'Ignore': ['VB'],
  'Ignoring': ['VBG'],
  'Igor': ['NNP'],
  'Iguana': ['NNP'],
  'Ihmsen': ['NNP'],
  'Ihor': ['NNP'],
  'Iijima': ['NNP'],
  'Ike': ['NNP'],
  'Ikegai': ['NNP'],
  'Ikegai-Goss': ['NNP'],
  'Iken': ['NNP'],
  'Ikle': ['NNP'],
  'Il': ['FW'],
  'Ila': ['NNP'],
  'Ilford': ['NNP'],
  'Iliad': ['NNP'],
  'Ilka': ['NNP'],
  'Ilkka': ['NNP'],
  'Ill': ['NNP'],
  'Ill-considered': ['JJ'],
  'Ill.': ['NNP'],
  'Ill.-based': ['JJ'],
  'Ille': ['NNP'],
  'Illeman': ['NNP'],
  'Illick': ['NNP'],
  'Illingworth': ['NNP'],
  'Illinois': ['NNP'],
  'Illinois-based': ['JJ'],
  'Illiterate': ['JJ'],
  'Illuminating': ['NNP'],
  'Illusion': ['NNP'],
  'Illustrated': ['NNP'],
  'Illustration': ['NNP'],
  'Illustrations': ['NNS'],
  'Ilminster': ['NNP'],
  'Ilona': ['NNP'],
  'Ilotycin': ['NNP'],
  'Ilva': ['NNP'],
  'Ilyushin': ['NN'],
  'Ilyushins': ['NNPS'],
  'Im': ['VBP'],
  'Image': ['NN'],
  'Image-processing': ['NN'],
  'Images': ['NNP'],
  'Imaginary': ['NNP'],
  'Imagine': ['VB'],
  'Imaging': ['NNP'],
  'Imai': ['NNP'],
  'Imam': ['NNP'],
  'Imasco': ['NNP'],
  'Imasdounian': ['NNP'],
  'Imboden': ['NNP'],
  'Imbrium': ['NNP'],
  'Imelda': ['NNP'],
  'Imhoff': ['NNP'],
  'Imitation': ['NN'],
  'Imma': ['VBP'],
  'Immaculate': ['NNP'],
  'Immanuel': ['NNP'],
  'Immediate': ['NNP'],
  'Immediately': ['RB'],
  'Immigrant': ['JJ'],
  'Immigration': ['NNP'],
  'Immoderate': ['NNP'],
  'Immortal': ['NNP'],
  'Immune': ['NNP'],
  'Immunetech': ['NNP'],
  'Immunex': ['NNP'],
  'ImmunoGen': ['NNP'],
  'Imo': ['NNP'],
  'Impact': ['NNP'],
  'Impartiality': ['NN'],
  'Impasse': ['NNP'],
  'Impatiently': ['RB'],
  'Impco': ['NNP'],
  'Impediments': ['NNP'],
  'Imperial': ['NNP'],
  'Imperiales': ['NNPS'],
  'Imperials': ['NNPS'],
  'Impersonal': ['JJ'],
  'Impetus': ['NN'],
  'Implementation': ['NN'],
  'Implements': ['NNS'],
  'Implores': ['VBZ'],
  'Import': ['NN'],
  'Importance': ['NN'],
  'Important': ['JJ'],
  'Imported': ['NNP'],
  'Importers': ['NNP'],
  'Imports': ['NNS'],
  'Impose': ['VB'],
  'Imposed': ['VBN'],
  'Imposition': ['NN'],
  'Impossible': ['JJ'],
  'Impressed': ['VBN'],
  'Impressionism': ['NN'],
  'Impressionist': ['JJ'],
  'Impressionists': ['NNPS'],
  'Impressions': ['NNS'],
  'Impressive': ['JJ'],
  'Imprimis': ['NNP'],
  'Imprisoned': ['VBN'],
  'Improper': ['JJ'],
  'Improprieties': ['NNS'],
  'Improve': ['VB'],
  'Improved': ['VBN'],
  'Improvement': ['NNP'],
  'Improvements': ['NNP'],
  'Improves': ['VBZ'],
  'Improving': ['VBG'],
  'Imre': ['NNP'],
  'Imreg': ['NNP'],
  'Imrene': ['NNP'],
  'In': ['IN'],
  'InCide': ['NNP'],
  'Inability': ['NN'],
  'Inacio': ['NNP'],
  'Inada': ['NNP'],
  'Inadequate': ['JJ'],
  'Inamori': ['NNP'],
  'Inasmuch': ['RB'],
  'Inaugural': ['NNP'],
  'Inaugurates': ['VBZ'],
  'Inauguration': ['NNP'],
  'Inc': ['NNP'],
  'Inc.': ['NNP'],
  'Inca': ['NNP'],
  'Incapable': ['JJ'],
  'Incarnation': ['NNP'],
  'Incentives': ['NNS'],
  'Incest': ['NN'],
  'Incident': ['NN'],
  'Incidentally': ['RB'],
  'Incidents': ['NNS'],
  'Incinerator': ['NNP'],
  'Incline': ['NNP'],
  'Include': ['VB'],
  'Included': ['VBN'],
  'Includes': ['VBZ'],
  'Including': ['VBG'],
  'Inco': ['NNP'],
  'Income': ['NNP'],
  'Inconsistent': ['JJ'],
  'Incorporated': ['NNP'],
  'Incorrect': ['JJ'],
  'Increase': ['VB'],
  'Increased': ['VBN'],
  'Increases': ['NNS'],
  'Increasing': ['VBG'],
  'Increasingly': ['RB'],
  'Incredibly': ['RB'],
  'Incredulous': ['JJ'],
  'Incrementally': ['RB'],
  'Incumbent': ['NNP'],
  'Incurably': ['RB'],
  'Ind': ['NNP'],
  'Ind.': ['NNP'],
  'Ind.-based': ['JJ'],
  'Ind.-investment': ['NN'],
  'Indebted': ['JJ'],
  'Indecon': ['NNP'],
  'Indeed': ['RB'],
  'Indefinite': ['JJ'],
  'Indelicato': ['NNP'],
  'Indemnity': ['NNP'],
  'Indentical': ['JJ'],
  'Independence': ['NNP'],
  'Independent': ['NNP'],
  'Independents': ['NNPS'],
  'Inderbinen': ['NNP'],
  'Indeterminate': ['NNP'],
  'Index': ['NNP'],
  'Index-arbitrage': ['NN'],
  'Index-linked': ['JJ'],
  'Index-related': ['JJ'],
  'Indexed': ['JJ'],
  'Indexes': ['NNS'],
  'Indexing': ['NN'],
  'India': ['NNP'],
  'India-Pakistan': ['NNP'],
  'India-born': ['JJ'],
  'Indian': ['NNP'],
  'Indian-summer': ['JJ'],
  'Indiana': ['NNP'],
  'Indiana-Ohio': ['NNP'],
  'Indianapolis': ['NNP'],
  'Indianapolis-based': ['JJ'],
  'Indians': ['NNPS'],
  'Indicated': ['VBD'],
  'Indicating': ['VBG'],
  'Indication': ['NN'],
  'Indications': ['NNS'],
  'Indicator': ['NN'],
  'Indicators': ['NNP'],
  'Indicted': ['VBN'],
  'Indies': ['NNPS'],
  'Indigenes': ['NNP'],
  'Indigestion': ['NN'],
  'Indignantly': ['RB'],
  'Indigo': ['NNP'],
  'Indio': ['NNP'],
  'Indira': ['NNP'],
  'Indirect': ['JJ'],
  'Indirectly': ['RB'],
  'Individual': ['JJ'],
  'Individuals': ['NNS'],
  'Indo-China': ['NNP'],
  'Indo-German': ['NNP'],
  'IndoSuez': ['NNP'],
  'Indochina': ['NNP'],
  'Indochinese': ['JJ'],
  'Indocin': ['NNP'],
  'Indonesia': ['NNP'],
  'Indonesian': ['JJ'],
  'Indonesians': ['NNPS'],
  'Indoor': ['JJ'],
  'Indosuez': ['NNP'],
  'Indulgence': ['NNP'],
  'Indulgers': ['NNS'],
  'Industri': ['NNP'],
  'Industria': ['NNP'],
  'Industrial': ['NNP'],
  'Industriale': ['NNP'],
  'Industriali': ['NNP'],
  'Industrialistes': ['NNP'],
  'Industrials': ['NNP'],
  'Industrias': ['NNP'],
  'Industrie': ['NNP'],
  'Industriel': ['FW'],
  'Industrielle': ['NNP'],
  'Industriels': ['NNPS'],
  'Industries': ['NNPS'],
  'Industries-developed': ['NNP'],
  'Industrikredit': ['NNP'],
  'Industry': ['NN'],
  'Industrywide': ['JJ'],
  'Ineffective': ['JJ'],
  'Inefficient': ['JJ'],
  'Inefficient-Market': ['NNP'],
  'Inevitably': ['RB'],
  'Inexpensive': ['JJ'],
  'Inexplicably': ['RB'],
  'Inez': ['NNP'],
  'Infamous': ['NNP'],
  'Infant': ['JJ'],
  'Infantry': ['NNP'],
  'Infants': ['NNS'],
  'Infection': ['NN'],
  'Infectious': ['JJ'],
  'Inferential': ['NNP'],
  'Inferiority': ['NN'],
  'Inferno': ['NN'],
  'Infertility': ['NNP'],
  'Infighting': ['NN'],
  'Infinite': ['JJ'],
  'Infiniti': ['NNP'],
  'Infirmary': ['NNP'],
  'Inflammatory': ['JJ'],
  'Inflate': ['VB'],
  'Inflation': ['NN'],
  'Inflation-adjusted': ['JJ'],
  'Inflationary': ['JJ'],
  'Inflow': ['NN'],
  'Inflows': ['NNS'],
  'Influenced': ['NNP'],
  'Influential': ['JJ'],
  'InfoCorp': ['NNP'],
  'InfoCorp.': ['NNP'],
  'Infocorp.': ['NNP'],
  'Inform': ['NNP'],
  'Informal': ['JJ'],
  'Information': ['NNP'],
  'Informed': ['VBN'],
  'Informix': ['NNP'],
  'Infotab': ['NNP'],
  'Infotechnology': ['NNP'],
  'Infrared': ['JJ'],
  'Infrequently': ['RB'],
  'Infusion': ['NN'],
  'Ing': ['NNP'],
  'Ingalls': ['NNP'],
  'Ingbar': ['NNP'],
  'Ingeniera': ['NNP'],
  'Ingersoll': ['NNP'],
  'Ingham': ['NNP'],
  'Ingleside': ['NNP'],
  'Inglewood': ['NNP'],
  'Ingo': ['NNP'],
  'Ingot': ['NN'],
  'Ingram': ['NNP'],
  'Ingrassia': ['NNP'],
  'Ingrid': ['NNP'],
  'Inhalation': ['NNP'],
  'Inherently': ['RB'],
  'Inheritance': ['NN'],
  'Inheriting': ['VBG'],
  'Inhouse': ['JJ'],
  'Inisel': ['NNP'],
  'Initial': ['JJ'],
  'Initially': ['RB'],
  'Initiating': ['VBG'],
  'Initiation': ['NN'],
  'Initiative': ['NNP'],
  'Inject': ['VB'],
  'Injection': ['NNP'],
  'Inju': ['NNP'],
  'Injun': ['NNP'],
  'Injuns': ['NNPS'],
  'Injury': ['NNP'],
  'Inland': ['NNP'],
  'Inlet': ['NNP'],
  'Inmac': ['NNP'],
  'Inman': ['NNP'],
  'Inmate': ['NNP'],
  'Inmates': ['NNS'],
  'Inn': ['NNP'],
  'Inna': ['NNP'],
  'Inner': ['NNP'],
  'Innes': ['NNP'],
  'Innesfree': ['NNP'],
  'Inning': ['NN'],
  'Innis-Maggiore-Olson': ['NNP'],
  'Innocent': ['JJ'],
  'Innocenti': ['NNP'],
  'Innopac': ['NNP'],
  'Innovation': ['NNP'],
  'Innovative': ['JJ'],
  'Inns': ['NNPS'],
  'Innuendos': ['NNS'],
  'Innumerable': ['JJ'],
  'Inorganic': ['JJ'],
  'Inoue': ['NNP'],
  'Inouye': ['NNP'],
  'Inpatient': ['NN'],
  'Inpex': ['NNP'],
  'Input': ['NN'],
  'Inquirer': ['NNP'],
  'Inquiry': ['NNP'],
  'Inquisition': ['NNP'],
  'Inquisitor-General': ['NNP'],
  'Inquisitors': ['NNS'],
  'Insam': ['NNP'],
  'Inscribed': ['VBN'],
  'Insect': ['NN'],
  'Insects': ['NNS'],
  'Insecures': ['NNPS'],
  'Inside': ['IN'],
  'Insider': ['NNP'],
  'Insiders': ['NNS'],
  'Insight': ['NNP'],
  'Insights': ['NNPS'],
  'Insilco': ['NNP'],
  'Insinuations': ['NNS'],
  'Insisting': ['VBG'],
  'Insitutional': ['JJ'],
  'Insofar': ['RB'],
  'Insomnia': ['NN'],
  'Inspect': ['VB'],
  'Inspection': ['NNP'],
  'Inspections': ['NNP'],
  'Inspector': ['NNP'],
  'Inspectorate': ['NNP'],
  'Inspectorate-Adia': ['NNP'],
  'Inspectors': ['NNS'],
  'Inspects': ['VBZ'],
  'Inspire': ['NNP'],
  'Inspired': ['VBN'],
  'Inspiring': ['VBG'],
  'Insta-Care': ['NNP'],
  'Install': ['VB'],
  'Installation': ['NN'],
  'Installed': ['VBN'],
  'Installing': ['VBG'],
  'Instances': ['NNS'],
  'Instant': ['JJ'],
  'Instantaneously': ['RB'],
  'Instantly': ['RB'],
  'Instead': ['RB'],
  'Instinctively': ['RB'],
  'Institue': ['NNP'],
  'Institut': ['NNP'],
  'Institute': ['NNP'],
  'Institutes': ['NNPS'],
  'Institutio': ['NNP'],
  'Institution': ['NNP'],
  'Institutional': ['JJ'],
  'Institutional-type': ['JJ'],
  'Institutionalization': ['NN'],
  'Institutions': ['NNS'],
  'Instituto': ['NNP'],
  'Institutue': ['NNP'],
  'Instructions': ['NNS'],
  'Instructor': ['NNP'],
  'Instructors': ['NNS'],
  'Instrument': ['NNP'],
  'Instrumental': ['NNP'],
  'Instruments': ['NNPS'],
  'Insulate': ['VB'],
  'Insurance': ['NNP'],
  'Insurance-industry': ['NN'],
  'Insurance-reform': ['NN'],
  'Insurance-related': ['JJ'],
  'Insurances': ['NNPS'],
  'Insureres': ['NNS'],
  'Insurers': ['NNS'],
  'Insurgent': ['JJ'],
  'Insuring': ['VBG'],
  'Insurrecto': ['FW'],
  'Intair': ['NNP'],
  'Intan': ['NNP'],
  'Intangible': ['JJ'],
  'Intangibles': ['NNS'],
  'Intar': ['NNP'],
  'Intech': ['NNP'],
  'Intecknings': ['NNP'],
  'Intecom': ['NNP'],
  'Integra': ['NNP'],
  'Integra-A': ['NNP'],
  'Integraph': ['NNP'],
  'Integrated': ['NNP'],
  'Integration': ['NN'],
  'Integrator': ['NNP'],
  'Intek': ['NNP'],
  'Intel': ['NNP'],
  'Intellectual': ['NNP'],
  'Intelligence': ['NNP'],
  'Intelligent': ['NNP'],
  'Intelogic': ['NNP'],
  'Intelsat': ['NNP'],
  'Intense': ['JJ'],
  'Intensification': ['NN'],
  'Intent': ['NN'],
  'Inter': ['NNP'],
  'Inter-American': ['NNP'],
  'Inter-Canadian': ['NNP'],
  'Inter-City': ['NNP'],
  'Inter-american': ['NNP'],
  'InterMarket': ['NNP'],
  'InterMedia': ['NNP'],
  'InterNorth': ['NNP'],
  'InterVoice': ['NNP'],
  'Interactive': ['NNP'],
  'Interagency': ['NNP'],
  'Interair': ['NNP'],
  'Interama': ['NNP'],
  'Interbank': ['NNP'],
  'Intercable': ['NNP'],
  'Intercede': ['VB'],
  'Intercepting': ['VBG'],
  'Intercity': ['JJ'],
  'Interco': ['NNP'],
  'Intercollegiate': ['NNP'],
  'Intercontinental': ['NNP'],
  'Interest': ['NN'],
  'Interest-rate': ['JJ'],
  'Interested': ['VBN'],
  'Interesting': ['JJ'],
  'Interestingly': ['RB'],
  'Interface': ['NNP'],
  'Interfaith': ['JJ'],
  'Interference': ['NNP'],
  'Interfering': ['VBG'],
  'Interferon': ['NNP'],
  'Interfinance': ['NNP'],
  'Interfinancial': ['NNP'],
  'Interfunding': ['NNP'],
  'Intergovernmental': ['NNP'],
  'Intergraph': ['NNP'],
  'Intergroup': ['NNP'],
  'Interhash': ['NNP'],
  'Interhome': ['NNP'],
  'Interim': ['JJ'],
  'Interior': ['NNP'],
  'Interiors': ['NNS'],
  'Interlake': ['NNP'],
  'Interleaf': ['NNP'],
  'Interleukin-3': ['NN'],
  'Interlink': ['NNP'],
  'Interlochen': ['NNP'],
  'Interlocking': ['VBG'],
  'Interlude': ['NNP'],
  'Intermarco': ['NNP'],
  'Intermark': ['NNP'],
  'Intermarriage': ['NN'],
  'Intermec': ['NNP'],
  'Intermediate': ['NNP'],
  'Intermediates': ['NNPS'],
  'Intermoda': ['NNP'],
  'Internaional': ['NNP'],
  'Internal': ['NNP'],
  'International': ['NNP'],
  'Internationale': ['NNP'],
  'Internationalist': ['NNP'],
  'Internatonal': ['NNP'],
  'Internet': ['NNP'],
  'Interpersonal': ['JJ'],
  'Interpoint': ['NNP'],
  'Interpore': ['NNP'],
  'Interpretation': ['NNP'],
  'Interprovincial': ['NNP'],
  'Interpublic': ['NNP'],
  'Interruptions': ['NNS'],
  'Interscience': ['NNP'],
  'Interspec': ['NNP'],
  'Interspersed': ['VBN'],
  'Interstate': ['NNP'],
  'Interstate\\\'/Johnson': ['NNP'],
  'Intertan': ['NNP'],
  'Intertech': ['NNP'],
  'Intertrade': ['NNP'],
  'Intervenes': ['VBZ'],
  'Intervention': ['NN'],
  'Interview': ['NNP'],
  'Interviewed': ['VBN'],
  'Interviewing': ['NN'],
  'Interviews': ['NNS'],
  'Interviu': ['NNP'],
  'Intervoice': ['NNP'],
  'Interwoven': ['JJ'],
  'Intimations': ['NNS'],
  'Intl': ['NNP'],
  'Into': ['IN'],
  'Intolerable': ['JJ'],
  'Intouch': ['NNP'],
  'Intourist': ['NNP'],
  'Intra-European': ['JJ'],
  'Intrapreneurship': ['NN'],
  'Intrepid': ['NNP'],
  'Intriguing': ['JJ'],
  'Introduce': ['VB'],
  'Introduced': ['VBN'],
  'Introduces': ['VBZ'],
  'Introducing': ['VBG'],
  'Introduction': ['NN'],
  'Intuition': ['NN'],
  'Inuit': ['NNP'],
  'Invacare': ['NNP'],
  'Invalid': ['NNP'],
  'Invariably': ['RB'],
  'Invasion': ['NNP'],
  'Inventions': ['NNS'],
  'Inventor': ['NNP'],
  'Inventories': ['NNS'],
  'Inventors': ['NNS'],
  'Inventory': ['NN'],
  'Invercalt': ['NNP'],
  'Invercon': ['NNP'],
  'Inverness': ['NNP'],
  'InvesTech': ['NNP'],
  'Invest': ['VB'],
  'Invest\\\'': ['NNP'],
  'Investcorp': ['NNP'],
  'Investigating': ['VBG'],
  'Investigation': ['NNP'],
  'Investigations': ['NNS'],
  'Investigators': ['NNS'],
  'Investing': ['VBG'],
  'Investment': ['NNP'],
  'Investment-Grade': ['NNP'],
  'Investment-grade': ['JJ'],
  'Investments': ['NNPS'],
  'Investor': ['NNP'],
  'Investors': ['NNS'],
  'Invictus': ['NNP'],
  'Invisible': ['NNP'],
  'Invitation': ['NNP'],
  'Invitations': ['NNS'],
  'Invite': ['NNP'],
  'Invoking': ['VBG'],
  'Involved': ['VBN'],
  'Involving': ['VBG'],
  'Inward': ['NNP'],
  'Inwood': ['NNP'],
  'Inx': ['NNP'],
  'Io': ['NNP'],
  'Iodinated': ['VBN'],
  'Iodination': ['NN'],
  'Ion': ['NNP'],
  'Ione': ['NNP'],
  'Ionic': ['JJ'],
  'Ionizing': ['VBG'],
  'Iosola': ['NNP'],
  'Iowa': ['NNP'],
  'Iowa-based': ['JJ'],
  'Ipswich': ['NNP'],
  'Ira': ['NNP'],
  'Iraj': ['NNP'],
  'Iran': ['NNP'],
  'Iran-Contra': ['NNP'],
  'Iran-Iraq': ['NNP'],
  'IranU.S': ['NNP'],
  'Iran\\\'': ['NNP'],
  'Iranian': ['JJ'],
  'Iranian-backed': ['JJ'],
  'Iranians': ['NNPS'],
  'Iraq': ['NNP'],
  'Iraqi': ['JJ'],
  'Iraqis': ['NNPS'],
  'Iraqw': ['NNP'],
  'Irec': ['NNP'],
  'Ireland': ['NNP'],
  'Irelands': ['NNP'],
  'Irenaeus': ['NNP'],
  'Irene': ['NNP'],
  'Irian': ['NNP'],
  'Irimajiri': ['NNP'],
  'Irina': ['NNP'],
  'Iris': ['NNP'],
  'Irises': ['NNP'],
  'Irish': ['JJ'],
  'Irish-Soviet': ['JJ'],
  'Irish-made': ['JJ'],
  'Irishman': ['NN'],
  'Irishmen': ['NNPS'],
  'Irma': ['NNP'],
  'Iron': ['NNP'],
  'Ironic': ['JJ'],
  'Ironically': ['RB'],
  'Ironpants': ['NNP'],
  'Ironside': ['NNP'],
  'Ironweed': ['NN'],
  'Iroquois': ['NNP'],
  'Irradiation': ['NN'],
  'Irrawaddy': ['NNP'],
  'Irretrievably': ['RB'],
  'Irrigation': ['NN'],
  'Irv': ['NN'],
  'Irvin': ['NNP'],
  'Irvine': ['NNP'],
  'Irving': ['NNP'],
  'Irwin': ['NNP'],
  'Is': ['VBZ'],
  'Isaac': ['NNP'],
  'Isaacs': ['NNP'],
  'Isaacson': ['NNP'],
  'Isaam': ['NNP'],
  'Isabel': ['NNP'],
  'Isabell': ['NNP'],
  'Isabella': ['NNP'],
  'Isabelle': ['NNP'],
  'Isacsson': ['NNP'],
  'Isadora': ['NNP'],
  'Isadore': ['NNP'],
  'Isaiah': ['NNP'],
  'Isaly': ['NNP'],
  'Isao': ['NNP'],
  'Isetan': ['NNP'],
  'Isfahan': ['NNP'],
  'Isgur': ['NNP'],
  'Isham': ['NNP'],
  'Ishida': ['NNP'],
  'Ishiguro': ['NNP'],
  'Ishihara': ['NNP'],
  'Ishii': ['NNP'],
  'Ishtar': ['NNP'],
  'Isikoff': ['NNP'],
  'Isis': ['NNP'],
  'Islam': ['NNP'],
  'Islamabad': ['NNP'],
  'Islamic': ['NNP'],
  'Island': ['NNP'],
  'Island-based': ['JJ'],
  'Islander': ['NNP'],
  'Islanders': ['NNPS'],
  'Islandia': ['NN'],
  'Islands': ['NNPS'],
  'Isle': ['NNP'],
  'Isler': ['NNP'],
  'Isles': ['NNP'],
  'Ismail': ['NNP'],
  'Ismaili': ['NNP'],
  'Ismet': ['NNP'],
  'Isoda': ['NNP'],
  'Isodine': ['NNP'],
  'Isola': ['NNP'],
  'Isolated': ['JJ'],
  'Isolating': ['VBG'],
  'Isolde': ['FW'],
  'Isosceles': ['NNP'],
  'Isotechnologies': ['NNPS'],
  'Isquith': ['NNP'],
  'Israel': ['NNP'],
  'Israeli': ['JJ'],
  'Israeli-Palestinian': ['JJ'],
  'Israeli-born': ['JJ'],
  'Israeli-occupied': ['JJ'],
  'Israeli\\\'/Palestinian': ['JJ'],
  'Israelis': ['NNPS'],
  'Israelite': ['NNP'],
  'Israelites': ['NNPS'],
  'Issak': ['NNP'],
  'Issam': ['NNP'],
  'Isselbacher': ['NNP'],
  'Issuance': ['NN'],
  'Issue': ['NN'],
  'Issuers': ['NNS'],
  'Issues': ['NNS'],
  'Issuing': ['VBG'],
  'Istanbul': ['NNP'],
  'Istat': ['NNP'],
  'Istel': ['NNP'],
  'Istel-type': ['JJ'],
  'Isthmus': ['NN'],
  'Istiqlal': ['NNP'],
  'Istiqlal-sponsored': ['JJ'],
  'Istituto': ['NNP'],
  'Istvan': ['NNP'],
  'Isuzu': ['NNP'],
  'It': ['PRP'],
  'It\'s': ['NNP'],
  'It-wit': ['NN'],
  'Itagaki': ['NNP'],
  'Italia': ['NNP'],
  'Italian': ['JJ'],
  'Italian-American': ['JJ'],
  'Italian-based': ['JJ'],
  'Italian-cut': ['JJ'],
  'Italian-led': ['JJ'],
  'Italian-made': ['JJ'],
  'Italian-style': ['JJ'],
  'Italiana': ['NNP'],
  'Italianate': ['JJ'],
  'Italians': ['NNPS'],
  'Italics': ['NNS'],
  'Italo': ['NNP'],
  'Italo-American': ['NNP'],
  'Italtel': ['NN'],
  'Italy': ['NNP'],
  'Itasca': ['NNP'],
  'Itch': ['VB'],
  'Itching': ['VBG'],
  'Itel': ['NNP'],
  'Item-Categories': ['NNPS'],
  'Items': ['NNS'],
  'Ithaca': ['NNP'],
  'Ithacan': ['NNP'],
  'Ito': ['NNP'],
  'Ito-Yokado': ['NNP'],
  'Itoh': ['NNP'],
  'Itoiz': ['NNP'],
  'Its': ['PRP\$'],
  'Itself': ['PRP'],
  'Itsuo': ['NNP'],
  'Ittleson': ['NNP'],
  'Iturup': ['NNP'],
  'Itzhak': ['NNP'],
  'Ivan': ['NNP'],
  'Iveco': ['NNP'],
  'Ivern': ['NNP'],
  'Iverson': ['NNP'],
  'Ives': ['NNP'],
  'Ivey': ['NNP'],
  'Ivies': ['NNPS'],
  'Ivory': ['NNP'],
  'Ivy': ['NNP'],
  'Iwai': ['NNP'],
  'Iwatare': ['NNP'],
  'Iwo': ['NNP'],
  'Izaak': ['NNP'],
  'Izquierda': ['NNP'],
  'Izvestia': ['NNP'],
  'J': ['NNP'],
  'J&B': ['NNP'],
  'J&C': ['NNP'],
  'J&J': ['NNP'],
  'J&L': ['NNP'],
  'J\'ai': ['FW'],
  'J-2': ['NNP'],
  'J.': ['NNP'],
  'J.A.': ['NNP'],
  'J.B.': ['NNP'],
  'J.C.': ['NNP'],
  'J.D.': ['NNP'],
  'J.D.H.': ['NNP'],
  'J.E.': ['NNP'],
  'J.F.': ['NNP'],
  'J.G.': ['NNP'],
  'J.H.': ['NNP'],
  'J.I.': ['NNP'],
  'J.J': ['NNP'],
  'J.J.': ['NNP'],
  'J.J.G.M.': ['NNP'],
  'J.K.': ['NNP'],
  'J.L.': ['NNP'],
  'J.M.': ['NNP'],
  'J.MBB': ['NNP'],
  'J.N.': ['NNP'],
  'J.NTT': ['NNP'],
  'J.P': ['NNP'],
  'J.P.': ['NNP'],
  'J.R.': ['NNP'],
  'J.T.': ['NNP'],
  'J.V': ['NNP'],
  'J.V.': ['NNP'],
  'J.W.': ['NNP'],
  'J.X.': ['NNP'],
  'J.Y.': ['NNP'],
  'J/NNP.A.': ['NN'],
  'J/NNP.A.C.': ['NNP'],
  'J/NNP.A.W.': ['NNP'],
  'J/NNP.G.L.': ['NNP'],
  'J/NNP.I.': ['JJ'],
  'J/NNP.J/NNP.A.': ['NN'],
  'JA': ['NNP'],
  'JAC': ['NNP'],
  'JACKPOT': ['NNP'],
  'JACUZZI': ['NNP'],
  'JAGRY': ['NNP'],
  'JAILED': ['VBN'],
  'JAL': ['NNP'],
  'JAMES': ['NNP'],
  'JAPAN': ['NNP'],
  'JAPAN\'S': ['NNP'],
  'JAPANESE': ['JJ'],
  'JAS': ['NNP'],
  'JAUNTS': ['NNS'],
  'JCKC': ['NNP'],
  'JCP': ['NNP'],
  'JEDEC': ['NN'],
  'JERSEY': ['NNP'],
  'JERSEY\'S': ['NNP'],
  'JFK': ['NNP'],
  'JH': ['NNP'],
  'JIM': ['NNP'],
  'JKD': ['NNP'],
  'JMB': ['NNP'],
  'JNR': ['NNP'],
  'JOB': ['NN'],
  'JOIN': ['VB'],
  'JOINS': ['VBZ'],
  'JOINT': ['JJ'],
  'JOKE': ['NN'],
  'JONES': ['NNP'],
  'JP': ['NNP'],
  'JPI': ['NNP'],
  'JROE': ['NNP'],
  'JSP': ['NNP'],
  'JSP-supported': ['JJ'],
  'JT8D-200': ['NN'],
  'JUDGE': ['NN'],
  'JUDGE\'S': ['NN'],
  'JUDGES': ['NNS'],
  'JUDICIAL': ['JJ'],
  'JUDICIARY': ['NNP'],
  'JUICE': ['NN'],
  'JUMBO': ['JJ'],
  'JUMPING': ['NNP'],
  'JUNK': ['NN'],
  'JURORS': ['NNS'],
  'JURY': ['NN'],
  'JUST': ['RB'],
  'JVC': ['NNP'],
  'JVC\\\'/Victor': ['NNP'],
  'JWP': ['NNP'],
  'JYJ': ['NN', 'SYM'],
  'JYM': ['NN', 'SYM'],
  'Jaap': ['NNP'],
  'Jabe': ['NNP'],
  'Jacchia': ['NNP'],
  'Jachmann': ['NNP'],
  'Jacinto': ['NNP'],
  'Jack': ['NNP'],
  'Jack-an-Apes': ['NN'],
  'Jack-of-all-trades': ['NN'],
  'Jackals': ['NNS'],
  'Jackets': ['NNS'],
  'Jacki': ['NNP'],
  'Jackie': ['NNP'],
  'Jackman': ['NNP'],
  'Jackpot': ['NNP'],
  'Jackson': ['NNP'],
  'Jackson-Cross': ['NNP'],
  'Jackson-Vanick': ['JJ'],
  'Jacksonian': ['NNP'],
  'Jacksons': ['NNPS'],
  'Jacksonville': ['NNP'],
  'Jackstadt': ['NNP'],
  'Jacky': ['NNP'],
  'Jaclyn': ['NNP'],
  'Jacob': ['NNP'],
  'Jacobean': ['JJ'],
  'Jacobite': ['NNP'],
  'Jacobius': ['NNP'],
  'Jacoboski': ['NNP'],
  'Jacobs': ['NNP'],
  'Jacobsen': ['NNP'],
  'Jacobson': ['NNP'],
  'Jacoby': ['NNP'],
  'Jacopo': ['NNP'],
  'Jacqueline': ['NNP'],
  'Jacquelyn': ['NN'],
  'Jacques': ['NNP'],
  'Jacques-Francois': ['NNP'],
  'Jacquette': ['NNP'],
  'Jacuzzi': ['NNP'],
  'Jacuzzis': ['NNS'],
  'Jadwiga': ['NNP'],
  'Jaeger': ['NNP'],
  'Jaffe': ['NNP'],
  'Jaffray': ['NNP'],
  'Jagan': ['NNP'],
  'Jager': ['NNP'],
  'Jaggers': ['NNP'],
  'Jagt': ['NNP'],
  'Jaguar': ['NNP'],
  'Jaguar-GM': ['NNP'],
  'Jaguars': ['NNPS'],
  'Jahn': ['NNP'],
  'Jahr': ['FW'],
  'Jai': ['NNP'],
  'Jail': ['NNP'],
  'Jaime': ['NNP'],
  'Jakarta': ['NNP'],
  'Jake': ['NNP'],
  'Jakes': ['NNP'],
  'Jalaalwalikraam': ['NNP'],
  'Jalalabad': ['NNP'],
  'Jam': ['NNP'],
  'Jamaica': ['NNP'],
  'Jamaican': ['JJ'],
  'James': ['NNP'],
  'James-the-Less': ['NNP'],
  'Jameses': ['NNP'],
  'Jameson': ['NNP'],
  'Jamestown': ['NNP'],
  'Jamie': ['NNP'],
  'Jamieson': ['NNP'],
  'Jamiesson': ['NNP'],
  'Jan': ['NNP'],
  'Jan.': ['NNP'],
  'Jana': ['NNP'],
  'Janachowski': ['NNP'],
  'Jane': ['NNP'],
  'Jane\\\'': ['NNP'],
  'Janeiro': ['NNP'],
  'Janes': ['NNPS'],
  'Janesville': ['NNP'],
  'Janet': ['NNP'],
  'Janice': ['NNP'],
  'Janis': ['NNP'],
  'Janissaries': ['NNS'],
  'Janitsch': ['NNP'],
  'Janizsewski': ['NNP'],
  'Janlori': ['NNP'],
  'Jannequin': ['NNP'],
  'Janney': ['NNP'],
  'Jannsen': ['NNP'],
  'Janofsky': ['NNP'],
  'Jansen': ['NNP'],
  'Jansenist': ['NNP'],
  'Jansky': ['NNP'],
  'Janson': ['NNP'],
  'Janssen': ['NNP'],
  'Jansz.': ['NNP'],
  'January': ['NNP'],
  'January-August': ['NNP'],
  'January-June': ['JJ'],
  'January-March': ['NNP'],
  'January-to-August': ['NNP'],
  'Janus': ['NNP'],
  'Janus-faced': ['JJ'],
  'Jap': ['NNP'],
  'Japan': ['NNP'],
  'Japan-U.S': ['NNP'],
  'Japan-U.S.': ['JJ'],
  'Japan-made': ['JJ'],
  'Japanese': ['JJ'],
  'Japanese-American': ['JJ'],
  'Japanese-Americans': ['NNPS'],
  'Japanese-South': ['NNP'],
  'Japanese-based': ['JJ'],
  'Japanese-financed': ['JJ'],
  'Japanese-language': ['JJ'],
  'Japanese-made': ['JJ'],
  'Japanese-managed': ['JJ'],
  'Japanese-owned': ['JJ'],
  'Japanese-style': ['JJ'],
  'Japanese-supplied': ['JJ'],
  'Japanese-type': ['JJ'],
  'Japanese\\\'/Chinese': ['JJ'],
  'Japs': ['NNPS'],
  'Jaques': ['NNP'],
  'Jardin': ['NNP'],
  'Jardine': ['NNP'],
  'Jarmusch': ['NNP'],
  'Jaross': ['NNP'],
  'Jarrell': ['NNP'],
  'Jarrett': ['NNP'],
  'Jarrodsville': ['NNP'],
  'Jars': ['NNS'],
  'Jartran': ['NNP'],
  'Jarvik': ['NNP'],
  'Jarvis': ['NNP'],
  'Jas': ['NNP'],
  'Jascha': ['NNP'],
  'Jase': ['NNP'],
  'Jasmine': ['NNP'],
  'Jason': ['NNP'],
  'Jasper': ['NNP'],
  'Jastrow': ['NNP'],
  'Jath': ['NNP'],
  'Java': ['NNP'],
  'Javanese': ['JJ'],
  'Javert': ['NNP'],
  'Javier': ['NNP'],
  'Jawaharlal': ['NNP'],
  'Jaworski': ['NNP'],
  'Jaws': ['NNPS'],
  'Jay': ['NNP'],
  'Jaya': ['NNP'],
  'Jayark': ['NNP'],
  'Jaycee': ['NNP'],
  'Jaycees': ['NNPS'],
  'Jays': ['NNPS'],
  'Jazz': ['NNP'],
  'Jean': ['NNP'],
  'Jean-Claude': ['NNP'],
  'Jean-Honore': ['NNP'],
  'Jean-Jacques': ['NNP'],
  'Jean-Louis': ['NNP'],
  'Jean-Luc': ['NNP'],
  'Jean-Marie': ['NNP'],
  'Jean-Michel': ['NNP'],
  'Jean-Pascal': ['NNP'],
  'Jean-Paul': ['NNP'],
  'Jean-Pierre': ['NNP'],
  'Jean-Rene': ['NNP'],
  'Jeancourt-Galignani': ['NNP'],
  'Jeane': ['NNP'],
  'Jeanene': ['NNP'],
  'Jeanette': ['NNP'],
  'Jeanne': ['NNP'],
  'Jeannie': ['NNP'],
  'Jeans': ['NNPS'],
  'Jeb': ['NNP'],
  'Jed': ['NNP'],
  'Jee-sus': ['UH'],
  'Jeep': ['NN'],
  'Jeep-Eagle': ['NNP'],
  'Jeep-brand': ['JJ'],
  'Jeep-like': ['JJ'],
  'Jeep\\\'': ['NNP'],
  'Jeep\\\'/Eagle': ['NNP'],
  'Jeepers': ['UH'],
  'Jeeps': ['NNS'],
  'Jeff': ['NNP'],
  'Jefferies': ['NNP'],
  'Jefferson': ['NNP'],
  'Jeffersonian': ['JJ'],
  'Jeffersonians': ['NNPS'],
  'Jeffersons': ['NNPS'],
  'Jeffery': ['NNP'],
  'Jeffrey': ['NNP'],
  'Jeffry': ['NNP'],
  'Jehovah': ['NNP'],
  'Jekyll': ['NNP'],
  'Jelenic': ['NNP'],
  'Jelinski': ['NNP'],
  'Jelke': ['NNP'],
  'Jell-O': ['NNP'],
  'Jellinek': ['NNP'],
  'Jellison': ['NNP'],
  'Jelly': ['NNP'],
  'Jellyby': ['NNP'],
  'Jemela': ['NNP'],
  'Jemima': ['NNP'],
  'Jen': ['NNP'],
  'JenMar': ['NNP'],
  'Jena': ['NNP'],
  'Jenco': ['NNP'],
  'Jenkins': ['NNP'],
  'Jenkinson': ['NNP'],
  'Jenks': ['NNP'],
  'Jenner': ['NNP'],
  'Jenni': ['NNP'],
  'Jennie': ['NNP'],
  'Jennifer': ['NNP'],
  'Jenning': ['NNP'],
  'Jennings': ['NNP'],
  'Jennison': ['NNP'],
  'Jenny': ['NNP'],
  'Jenrette': ['NNP'],
  'Jens': ['NNP'],
  'Jens-Uwe': ['NNP'],
  'Jensen': ['NNP'],
  'Jeopardize': ['VB'],
  'Jeopardy': ['NNP'],
  'Jepson': ['NNP'],
  'Jerald': ['NNP'],
  'Jerebohm': ['NNP'],
  'Jerebohms': ['NNP'],
  'Jerell': ['NNP'],
  'Jeremiah': ['NNP'],
  'Jeremy': ['NNP'],
  'Jerez': ['NNP'],
  'Jergens': ['NNP'],
  'Jeri': ['NNP'],
  'Jericho': ['NNP'],
  'Jerky': ['NNP'],
  'Jeroboam': ['NN'],
  'Jeroboams': ['NNPS'],
  'Jerome': ['NNP'],
  'Jerr-Dan': ['NNP'],
  'Jerral': ['NNP'],
  'Jerrico': ['NNP'],
  'Jerritts': ['NNP'],
  'Jerrold': ['NNP'],
  'Jerry': ['NNP'],
  'Jersey': ['NNP'],
  'Jersey-Salem': ['NNP'],
  'Jersey-based': ['JJ'],
  'Jerseyite': ['NNP'],
  'Jerusalem': ['NNP'],
  'Jervase': ['NNP'],
  'Jervis': ['NNP'],
  'Jesperson': ['NNP'],
  'Jess': ['NNP'],
  'Jesse': ['NNP'],
  'Jessey': ['NNP'],
  'Jessica': ['NNP'],
  'Jessie': ['NNP'],
  'Jessy': ['NNP'],
  'Jessye': ['NNP'],
  'Jesuit': ['NNP'],
  'Jesuits': ['NNPS'],
  'Jesus': ['NNP'],
  'Jet': ['NNP'],
  'Jets': ['NNP'],
  'Jetta': ['NNP'],
  'Jetway': ['NNP'],
  'Jeux': ['FW'],
  'Jew': ['NNP'],
  'Jew-as-enemy': ['NN'],
  'Jew-baiter': ['NN'],
  'Jew-haters': ['NNS'],
  'Jewboy': ['NN'],
  'Jewel': ['NNP'],
  'Jewelers': ['NNPS'],
  'Jewelery': ['NNP'],
  'Jewell': ['NNP'],
  'Jewelry': ['NN'],
  'Jewett': ['NNP'],
  'Jewish': ['JJ'],
  'Jewish-Gentile': ['NNP'],
  'Jewishness': ['NN'],
  'Jewry': ['NNP'],
  'Jews': ['NNPS'],
  'Jeyes': ['NNP'],
  'Jiang': ['NNP'],
  'Jiangsu': ['NNP'],
  'Jianying': ['NNP'],
  'Jiaqi': ['NNP'],
  'Jibril': ['NNP'],
  'Jidge': ['NNP'],
  'Jif': ['NNP'],
  'Jiffy': ['NNP'],
  'Jiffy-Couch-a-Bed': ['NNP'],
  'Jihad': ['NNP'],
  'Jihong': ['NNP'],
  'Jill': ['NNP'],
  'Jim': ['NNP'],
  'Jima': ['NNP'],
  'Jimbo': ['NNP'],
  'Jimenez': ['NNP'],
  'Jimmie': ['NNP'],
  'Jimmy': ['NNP'],
  'Jin': ['NNP'],
  'Jin-Shung': ['NNP'],
  'Jindo': ['NNP'],
  'Jingoism': ['NN'],
  'Jingsheng': ['NNP'],
  'Jinny': ['NNP'],
  'Jinshajiang': ['NNP'],
  'Jiotto': ['NNP'],
  'Jiri': ['NNP'],
  'Jist': ['RB'],
  'Jittery': ['JJ'],
  'Jno': ['NNP'],
  'Jo': ['NNP'],
  'JoAnn': ['NNP'],
  'Joachim': ['NNP'],
  'Joan': ['NNP'],
  'Joann': ['NNP'],
  'Joanna': ['NNP'],
  'Joanne': ['NNP'],
  'Joannie': ['NNP'],
  'Joao': ['NNP'],
  'Joaquin': ['NNP'],
  'Job': ['NNP'],
  'Job-Bias': ['JJ'],
  'Joban': ['NNP'],
  'Jobs': ['NNP'],
  'Jobson': ['NNP'],
  'Jocelyn': ['NNP'],
  'Jock': ['NNP'],
  'Jockey': ['NNP'],
  'Jodi': ['NNP'],
  'Jody': ['NNP'],
  'Joe': ['NNP'],
  'Joel': ['NNP'],
  'Joerg': ['NNP'],
  'Joes': ['NNS'],
  'Joey': ['NNP'],
  'Joffre': ['NNP'],
  'Joffrey': ['NNP'],
  'Jogjakarta': ['NN'],
  'Johan': ['NNP'],
  'Johann': ['NNP'],
  'Johanna': ['NNP'],
  'Johannesburg': ['NNP'],
  'Johansen': ['NNP'],
  'Johanson': ['NNP'],
  'Johansson': ['NNP'],
  'John': ['NNP'],
  'John-Henry': ['NNP'],
  'John-and-Linda': ['NNP'],
  'Johnnie': ['NNP'],
  'Johnny': ['NNP'],
  'Johns': ['NNP'],
  'Johns-Manville': ['NNP'],
  'Johnson': ['NNP'],
  'Johnson-Merck': ['NNP'],
  'Johnson-era': ['NN'],
  'Johnston': ['NNP'],
  'Johnstone': ['NNP'],
  'Johnstown': ['NNP'],
  'Johsen': ['NNP'],
  'Join': ['VB'],
  'Joined': ['VBN'],
  'Joiners': ['NNPS'],
  'Joining': ['VBG'],
  'Joint': ['NNP'],
  'Joint-research': ['JJ'],
  'Joint-venture': ['JJ'],
  'Joker': ['NNP'],
  'Jokes': ['NNS'],
  'Joking': ['VBG'],
  'Jolas': ['NNP'],
  'Jolivet': ['NNP'],
  'Jolla': ['NNP'],
  'Jolliffe': ['NNP'],
  'Jolly': ['JJ'],
  'Jolt': ['NNP'],
  'Jon': ['NNP'],
  'Jonas': ['NNP'],
  'Jonathan': ['NNP'],
  'Jones': ['NNP'],
  'Jones-Imboden': ['NNP'],
  'Jones-Irwin': ['NNP'],
  'Jonesborough': ['NNP'],
  'Joneses': ['NNPS'],
  'Jong': ['NNP'],
  'Joni': ['NNP'],
  'Jonni': ['NNP'],
  'Jonquieres': ['NNP'],
  'Joon': ['NNP'],
  'Joplin': ['NN'],
  'Jorda': ['NNP'],
  'Jordan': ['NNP'],
  'Jordan\\\'/Zalaznick': ['NNP'],
  'Jordanian': ['JJ'],
  'Jordon': ['NNP'],
  'Jordonelle': ['NNP'],
  'Jorge': ['NNP'],
  'Jorio': ['NNP'],
  'Jorndt': ['NNP'],
  'Jos': ['NNP'],
  'Jose': ['NNP'],
  'Jose-Maria': ['NNP'],
  'Josef': ['NNP'],
  'Joseph': ['NNP'],
  'Joseph-Daniel': ['NNP'],
  'Josephine': ['NNP'],
  'Josephson': ['NNP'],
  'Josephthal': ['NNP'],
  'Josephus': ['NNP'],
  'Josh': ['NNP'],
  'Joshi': ['NNP'],
  'Joshua': ['NNP'],
  'Joshual': ['NNP'],
  'Josiah': ['NNP'],
  'Jossy': ['NNP'],
  'Jotaro': ['NNP'],
  'Jour': ['NNP'],
  'Journal': ['NNP'],
  'Journal-American': ['NNP'],
  'Journal-Bulletin': ['NNP'],
  'Journal\\\'': ['NNP'],
  'Journal\\\'/Europe': ['NNP'],
  'Journal\\\'/NBC': ['NNP'],
  'Journalism': ['NN'],
  'Journalist': ['NNP'],
  'Journalists': ['NNS'],
  'Journals': ['NNPS'],
  'Journey': ['NNP'],
  'Journeys': ['NNS'],
  'Jouvet': ['NNP'],
  'Jovanovich': ['NNP'],
  'Jovanovich\\\'/Bruccoli': ['NNP'],
  'Jovi': ['NNP'],
  'Joviality': ['NN'],
  'Jovian': ['JJ'],
  'Joy': ['NNP'],
  'Joyce': ['NNP'],
  'Joynt': ['NNP'],
  'Joyo': ['NNP'],
  'Jozef': ['NNP'],
  'Jr': ['NNP'],
  'Jr.': ['NNP'],
  'Juan': ['NNP'],
  'Juanita': ['NNP'],
  'Juarez': ['NNP'],
  'Juarez-area': ['NN'],
  'Jubal': ['NNP'],
  'Judah': ['NNP'],
  'Judaism': ['NNP'],
  'Judas': ['NNP'],
  'Judd-Boston': ['NNP'],
  'Jude': ['NNP'],
  'Judea': ['NNP'],
  'Judeo-Christian': ['JJ'],
  'Judge': ['NNP'],
  'Judges': ['NNS'],
  'Judging': ['VBG'],
  'Judgment': ['NNP'],
  'Judgments': ['NNS'],
  'Judi': ['NNP'],
  'Judicial': ['NNP'],
  'Judiciary': ['NNP'],
  'Judie': ['NNP'],
  'Judith': ['NNP'],
  'Judson': ['NNP'],
  'Judsons': ['NNPS'],
  'Judy': ['NNP'],
  'Juergen': ['NNP'],
  'Juet': ['NNP'],
  'Juge': ['NNP'],
  'Jugend': ['NNP'],
  'Juice': ['NN'],
  'Juilliard': ['NNP'],
  'Jujo': ['NNP'],
  'Jukes': ['NNP'],
  'Jules': ['NNP'],
  'Julia': ['NNP'],
  'Julian': ['NNP'],
  'Juliano': ['NNP'],
  'Juliber': ['NNP'],
  'Julie': ['NNP'],
  'Juliet': ['NNP'],
  'Juliette': ['NNP'],
  'Julio': ['NNP'],
  'Julius': ['NNP'],
  'July': ['NNP'],
  'July-September': ['JJ'],
  'Jump': ['NN'],
  'Jumping': ['VBG'],
  'Juncal': ['NNP'],
  'Junction': ['NNP'],
  'June': ['NNP'],
  'June-to-September': ['NNP'],
  'June.': ['NN'],
  'Juneau': ['NNP'],
  'Jung': ['NNP'],
  'Junge': ['NNP'],
  'Jungho': ['NNP'],
  'Jungian': ['NNP'],
  'Jungle': ['NNP'],
  'Junid': ['NNP'],
  'Junior': ['JJ'],
  'Juniors': ['NNS'],
  'Junius': ['NNP'],
  'Junk': ['NN'],
  'Junk-Bond': ['NN'],
  'Junk-bond': ['JJ'],
  'Junk-fund': ['NN'],
  'Junk-holders': ['NNS'],
  'Junk-portfolio': ['NN'],
  'Junkerdom': ['NNP'],
  'Junkers': ['NNPS'],
  'Junkholders': ['NNS'],
  'Junkins': ['NNP'],
  'Junor': ['NNP'],
  'Junsheng': ['NNP'],
  'Jupiter': ['NNP'],
  'Jupiter-bound': ['JJ'],
  'Juras': ['NNP'],
  'Jurgen': ['NNP'],
  'Jurisdiction': ['NNP'],
  'Jurisprudence': ['NN'],
  'Jurists': ['NNP'],
  'Jurong': ['NNP'],
  'Jurors': ['NNP'],
  'Jury': ['NNP'],
  'Jussel': ['NNP'],
  'Just': ['RB'],
  'Justice': ['NNP'],
  'Justices': ['NNPS'],
  'Justin': ['NNP'],
  'Justine': ['NNP'],
  'Justinian': ['NNP'],
  'Justino': ['NNP'],
  'Jute': ['NN'],
  'Jutish': ['JJ'],
  'Jutting': ['VBG'],
  'Juvenile': ['NNP'],
  'Jyoti': ['NNP'],
  'K': ['NNP'],
  'K\'ang-si': ['FW'],
  'K-9': ['NNP'],
  'K-H': ['NNP'],
  'K-resin': ['NN'],
  'K.': ['NNP'],
  'K.B.': ['NNP'],
  'K.C.': ['NN'],
  'K.G.': ['NNP'],
  'K.J.P.': ['NNP'],
  'K.L.': ['NNP'],
  'KAISER': ['NNP'],
  'KAL': ['NNP'],
  'KANEB': ['NNP'],
  'KARL': ['NNP'],
  'KB': ['NNP'],
  'KC': ['NNP'],
  'KC-10': ['NNP'],
  'KC-135': ['NNP'],
  'KC-135s': ['NNS'],
  'KCRA': ['NNP'],
  'KCS': ['NNP'],
  'KCs': ['NNS'],
  'KEARNEY': ['NNP'],
  'KEEPING': ['VBG'],
  'KEISHI': ['NNP'],
  'KETV': ['NNP'],
  'KEY': ['JJ'],
  'KFAC-FM': ['NNP'],
  'KFC': ['NNP'],
  'KGB': ['NNP'],
  'KGF': ['NNP'],
  'KHAD\\\'/WAD': ['NN'],
  'KICKING': ['VBG'],
  'KID': ['NNP'],
  'KIM': ['NNP'],
  'KIPPUR': ['NNP'],
  'KISSINGER': ['NNP'],
  'KK': ['NNP'],
  'KKK': ['NNP'],
  'KKR': ['NNP'],
  'KLA': ['NNP'],
  'KLERK': ['NNP'],
  'KLM': ['NNP'],
  'KLM-Northwest': ['NNP'],
  'KLM-controlled': ['JJ'],
  'KLUC': ['NNP'],
  'KLUC-FM': ['NNP'],
  'KMW': ['NNP'],
  'KN': ['NNP'],
  'KNOW': ['VB'],
  'KOBE': ['NNP'],
  'KODAK': ['NNP'],
  'KOFY': ['NNP'],
  'KOFY-FM': ['NNP'],
  'KOREAN': ['JJ'],
  'KPMG': ['NNP'],
  'KQED': ['NNP'],
  'KRAFT': ['NNP'],
  'KRAFT\'S': ['NNP'],
  'KRC': ['NNP'],
  'KRENZ': ['NNP'],
  'KRON': ['NNP'],
  'KSAN': ['NNP'],
  'KSI': ['NNP'],
  'KTXL': ['NNP'],
  'KUHN': ['NNP'],
  'KV': ['NNP'],
  'KVA': ['NNP'],
  'KVDA': ['NNP'],
  'KWU': ['NNP'],
  'Kabalevsky': ['NNP'],
  'Kabel': ['NNP'],
  'Kaboom': ['NN'],
  'Kabul': ['NNP'],
  'Kacy': ['NNP'],
  'Kadane': ['NNP'],
  'Kaddish': ['NNP'],
  'Kaddurah-Daouk': ['NNP'],
  'Kader': ['NNP'],
  'Kadonada': ['NNP'],
  'Kafaroff': ['NNP'],
  'Kafka': ['NNP'],
  'Kafkaesque': ['JJ'],
  'Kagakushi': ['NNP'],
  'Kagan': ['NNP'],
  'Kaganovich': ['NNP'],
  'Kageyama': ['NNP'],
  'Kahan': ['NNP'],
  'Kahiltna': ['NNP'],
  'Kahler': ['NNP'],
  'Kahler-Craft': ['NNP'],
  'Kahn': ['NNP'],
  'Kahwaty': ['NNP'],
  'Kai': ['NNP'],
  'Kai-shek': ['NNP'],
  'Kaifu': ['NNP'],
  'Kailin': ['NNP'],
  'Kaina': ['NNP'],
  'Kaiparowits': ['NNP'],
  'Kaiser': ['NNP'],
  'Kaisers': ['NNPS'],
  'Kaisha': ['NNP'],
  'Kaitaia': ['NNP'],
  'Kaixi': ['NNP'],
  'Kajar': ['NNP'],
  'Kajima': ['NNP'],
  'Kakadu': ['NN'],
  'Kakita': ['NNP'],
  'Kakuei': ['NNP'],
  'Kakumaru': ['NNP'],
  'Kakutani': ['NNP'],
  'Kal': ['NNP'],
  'Kalamazoo': ['NNP'],
  'Kaldahl': ['NNP'],
  'Kalentiev': ['NNP'],
  'Kalevi': ['NNP'],
  'Kali': ['VBP'],
  'Kalikow': ['NNP'],
  'Kalin': ['NNP'],
  'Kaliniak': ['NNP'],
  'Kalinowski': ['NNP'],
  'Kalipharma': ['NNP'],
  'Kalison': ['NNP'],
  'Kalman': ['NNP'],
  'Kalmuk': ['NNP'],
  'Kalmus': ['NNP'],
  'Kalonji': ['NNP'],
  'Kaltschmitt': ['NNP'],
  'Kalyagin': ['NNP'],
  'Kalyani': ['NNP'],
  'Kamal': ['NNP'],
  'Kaman': ['NNP'],
  'Kamchatka': ['NNP'],
  'Kamehameha': ['NNP'],
  'Kamel': ['NNP'],
  'Kamemura': ['NNP'],
  'Kamens': ['NNP'],
  'Kamieniec': ['NNP'],
  'Kamin': ['NNP'],
  'Kaminski': ['NNP'],
  'Kaminsky': ['NNP'],
  'Kamloops': ['NNP'],
  'Kamm': ['NNP'],
  'Kamp': ['NNP'],
  'Kampen': ['NNP'],
  'Kan': ['NNP'],
  'Kan.': ['NNP'],
  'Kan.-based': ['JJ'],
  'Kanab': ['NNP'],
  'Kanaday': ['NNP'],
  'Kanan': ['NNP'],
  'Kandahar': ['NNP'],
  'Kandemir': ['NNP'],
  'Kandinsky': ['NNP'],
  'Kandu': ['NNP'],
  'Kane': ['NNP'],
  'Kaneb': ['NNP'],
  'Kanebo': ['NN'],
  'Kanegafuchi': ['NNP'],
  'Kang': ['NNP'],
  'KangaROOS': ['NNP'],
  'Kangaroo': ['NN'],
  'Kangas': ['NNP'],
  'Kangyo': ['NNP'],
  'Kanin': ['NNP'],
  'Kanjorski': ['NNP'],
  'Kankakee': ['NNP'],
  'Kann': ['NNP'],
  'Kanner': ['NNP'],
  'Kano': ['NNP'],
  'Kanoff': ['NNP'],
  'Kanon': ['NNP'],
  'Kans.': ['NNP'],
  'Kansai': ['NNP'],
  'Kansallis': ['NNP'],
  'Kansan': ['NNP'],
  'Kansas': ['NNP'],
  'Kansas-Nebraska': ['NNP'],
  'Kanska': ['NNP'],
  'Kant': ['NNP'],
  'Kanter': ['NNP'],
  'Kanto': ['NNP'],
  'Kantorei': ['NNP'],
  'Kao': ['NNP'],
  'Kaolin': ['NNP'],
  'Kapadia': ['NNP'],
  'Kaplan': ['NNP'],
  'Kapnek': ['NNP'],
  'Kapoor': ['NNP'],
  'Kappa': ['NNP'],
  'Kappil': ['NNP'],
  'Kara': ['NNP'],
  'Karacan': ['NNP'],
  'Karalis': ['NNP'],
  'Karamazov': ['NNP'],
  'Karan': ['NNP'],
  'Karangelen': ['NNP'],
  'Karate': ['NN'],
  'Karatz': ['NNP'],
  'Karcher': ['NNP'],
  'Karcher-Everly': ['NNP'],
  'Karches': ['NNP'],
  'Kare': ['NNP'],
  'Karel': ['NNP'],
  'Karen': ['NNP'],
  'Karene': ['NNP'],
  'Karet': ['NNP'],
  'Karim': ['NNP'],
  'Karin': ['NNP'],
  'Karipo': ['NNP'],
  'Karkazis': ['NNP'],
  'Karl': ['NNP'],
  'Karl-Birger': ['NNP'],
  'Karlheinz': ['NNP'],
  'Karlis': ['NNP'],
  'Karlsruhe': ['NNP'],
  'Karnak': ['NNP'],
  'Karnes': ['NNP'],
  'Karns': ['NNP'],
  'Karnsund': ['NNP'],
  'Karo': ['NNP'],
  'Karol': ['NN'],
  'Karolinerna': ['NNP'],
  'Karolinska': ['NNP'],
  'Karos': ['NNP'],
  'Karp': ['NNP'],
  'Karpa': ['NNP'],
  'Karpov': ['NNP'],
  'Karre': ['NNP'],
  'Karshilama': ['NNP'],
  'Karsner': ['NNP'],
  'Karstadt': ['NNP'],
  'Kartalia': ['NNP'],
  'Kartasasmita': ['NNP'],
  'Kary': ['NNP'],
  'Kas': ['NNP'],
  'Kasai': ['NNP'],
  'Kasavubu': ['NNP'],
  'Kasen': ['NNP'],
  'Kashing': ['NNP'],
  'Kashpirovsky': ['NNP'],
  'Kasiva': ['NNP'],
  'Kaskaskia': ['NNP'],
  'Kasler': ['NNP'],
  'Kasparov': ['NNP'],
  'Kasper': ['NNP'],
  'Kasriel': ['NNP'],
  'Kass': ['NNP'],
  'Kass-Pedone': ['NNP'],
  'Kassal': ['NNP'],
  'Kassan': ['NNP'],
  'Kassar': ['NNP'],
  'Kassebaum': ['NNP'],
  'Kassem': ['NNP'],
  'Kasten': ['NNP'],
  'Kaster': ['NNP'],
  'Katanga': ['NNP'],
  'Katangan': ['JJ'],
  'Katangans': ['NNPS'],
  'Katcher': ['NNP'],
  'Kate': ['NNP'],
  'Katharina': ['NNP'],
  'Katharine': ['NNP'],
  'Kathe': ['NNP'],
  'Katherine': ['NNP'],
  'Kathie': ['NNP'],
  'Kathleen': ['NNP'],
  'Kathryn': ['NNP'],
  'Kathy': ['NNP'],
  'Katie': ['NNP'],
  'Katims': ['NNP'],
  'Katmandu': ['NNP'],
  'Kato': ['NNP'],
  'Katonah': ['NNP'],
  'Katow': ['NNP'],
  'Katsanos': ['NNP'],
  'Katsive': ['NNP'],
  'Katsuya': ['NNP'],
  'Kattus': ['NNP'],
  'Katutura': ['NNP'],
  'Katy': ['NNP'],
  'Katya': ['NNP'],
  'Katz': ['NNP'],
  'Katzenjammer': ['NNP'],
  'Katzenstein': ['NNP'],
  'Kauffeld': ['NNP'],
  'Kauffmann': ['NNP'],
  'Kaufhaus': ['NNP'],
  'Kaufhof': ['NNP'],
  'Kaufman': ['NNP'],
  'Kaufmann': ['NNP'],
  'Kaufnabb': ['NNP'],
  'Kaul': ['NNP'],
  'Kaulentis': ['NNP'],
  'Kavanagh': ['NNP'],
  'Kawasaki': ['NNP'],
  'Kawasaki-Rikuso': ['NNP'],
  'Kawecki': ['NNP'],
  'Kay': ['NNP'],
  'Kay-Bee': ['NNP'],
  'Kayabashi': ['NNP'],
  'Kayabashi-san': ['NNP'],
  'Kaydon': ['NNP'],
  'Kaye': ['NNP'],
  'Kayne': ['NNP'],
  'Kaysersberg': ['NNP'],
  'Kayton': ['NNP'],
  'Kaza': ['NNP'],
  'Kazakh': ['NNP'],
  'Kazakhstan': ['NNP'],
  'Kazan': ['NNP'],
  'Kazikaev': ['NNP'],
  'Kazis': ['NNP'],
  'Kazuhiko': ['NNP'],
  'Kazuo': ['NNP'],
  'Kazushige': ['NNP'],
  'Kchessinska': ['NNP'],
  'Ke': ['NNP'],
  'Kean': ['NNP'],
  'Keane': ['NNP'],
  'Keansburg': ['NNP'],
  'Kearney': ['NNP'],
  'Kearns': ['NNP'],
  'Kearny': ['NNP'],
  'Kearton': ['NNP'],
  'Keath': ['NNP'],
  'Keating': ['NNP'],
  'Keatingland': ['NNP'],
  'Keats': ['NNP'],
  'Keck': ['NNP'],
  'Kedgeree': ['NN'],
  'Kedzie': ['NNP'],
  'Kee-reist': ['UH'],
  'Keebler': ['NNP'],
  'Keeeerist': ['UH'],
  'Keefe': ['NNP'],
  'Keegan': ['NNP'],
  'Keehn': ['NNP'],
  'Keeler': ['NNP'],
  'Keeling': ['NNP'],
  'Keen': ['NNP'],
  'Keenan': ['NNP'],
  'Keene': ['NNP'],
  'Keeny': ['NNP'],
  'Keep': ['VB'],
  'Keepers': ['NNS'],
  'Keeping': ['VBG'],
  'Keeps': ['VBZ'],
  'Keerist': ['UH'],
  'Keeshond': ['NN'],
  'Keffer': ['NNP'],
  'Keg': ['NNP'],
  'Kegham': ['NNP'],
  'Kegler': ['NNP'],
  'Kehl': ['NNP'],
  'Keidanren': ['NNP'],
  'Keihin': ['NNP'],
  'Keilin': ['NNP'],
  'Keillor': ['NNP'],
  'Keio': ['NNP'],
  'Keith': ['NNP'],
  'Keiyo': ['NNP'],
  'Keizai': ['NNP'],
  'Keizaikai': ['NNP'],
  'Keizer': ['NNP'],
  'Kekisheva': ['NNP'],
  'Kel': ['NNP'],
  'Kell': ['NNP'],
  'Kellar': ['NNP'],
  'Kellaway': ['NNP'],
  'Kelleher': ['NNP'],
  'Keller': ['NNP'],
  'Kelley': ['NNP'],
  'Kelli': ['NNP'],
  'Kellmer': ['NNP'],
  'Kellner': ['NNP'],
  'Kellogg': ['NNP'],
  'Kellogg-Briand': ['NNP'],
  'Kellum': ['NNP'],
  'Kellwood': ['NNP'],
  'Kelly': ['NNP'],
  'Kelly\\\'': ['NNP'],
  'Kelly\\\'/David': ['NNP'],
  'Kelman': ['NNP'],
  'Kelsey': ['NNP'],
  'Kelsey-Hayes': ['NNP'],
  'Kelseyville': ['NNP'],
  'Kelton': ['NNP'],
  'Kelts': ['NNP'],
  'Kemble': ['NNP'],
  'Kemchenjunga': ['NNP'],
  'Kemm': ['NNP'],
  'Kemp': ['NNP'],
  'Kempe': ['NNP'],
  'Kemper': ['NNP'],
  'Kempinski': ['NNP'],
  'Kempner': ['NNP'],
  'Kemps': ['NNP'],
  'Ken': ['NNP'],
  'Kenan': ['NNP'],
  'Kendall': ['NNP'],
  'Kendrick': ['NNP'],
  'Keng': ['NNP'],
  'Kenilworth': ['NNP'],
  'Kenji': ['NNP'],
  'Kenlake': ['NNP'],
  'Kenmare': ['NNP'],
  'Kenmore': ['NNP'],
  'Kennametal': ['NNP'],
  'Kennan': ['NNP'],
  'Kennard': ['NNP'],
  'Kennedy': ['NNP'],
  'Kennedy\'joie': ['NN'],
  'Kennedy-Waxman': ['NNP'],
  'Kennedy-wordsmith': ['NNP'],
  'Kennedyesque': ['JJ'],
  'Kennel': ['NNP'],
  'Kennelly': ['NNP'],
  'Kenner': ['NNP'],
  'Kenneth': ['NNP'],
  'Kennett': ['NNP'],
  'Kennewick': ['NNP'],
  'Kenney': ['NNP'],
  'Kennington': ['NNP'],
  'Kennon': ['NNP'],
  'Kenny': ['NNP'],
  'Kenosha': ['NNP'],
  'Kensetsu': ['NNP'],
  'Kensington': ['NNP'],
  'Kent': ['NNP'],
  'Kentfield': ['NNP'],
  'Kenton': ['NNP'],
  'Kentuck': ['NNP'],
  'Kentucky': ['NNP'],
  'Kenworthy': ['NNP'],
  'Kenya': ['NNP'],
  'Kenyan': ['JJ'],
  'Kenyans': ['NNPS'],
  'Kenyon': ['NNP'],
  'Kenzo': ['NNP'],
  'Keo': ['NNP'],
  'Keogh': ['NNP'],
  'Keough': ['NNP'],
  'Kepler': ['NNP'],
  'Kerby': ['NNP'],
  'Kercheval': ['NNP'],
  'Kerensky': ['NNP'],
  'Kerich': ['NNP'],
  'Kerkorian': ['NNP'],
  'Kerkorian-owned': ['JJ'],
  'Kerlone': ['NNP'],
  'Kermit': ['NNP'],
  'Kern': ['NNP'],
  'Kernel': ['NNP'],
  'Kerner': ['NNP'],
  'Kerosene': ['NN'],
  'Kerouac': ['NNP'],
  'Kerr': ['NNP'],
  'Kerr-McGee': ['NNP'],
  'Kerr-Mills': ['NNP'],
  'KerrMcGee': ['NNP'],
  'Kerrey': ['NNP'],
  'Kerrville': ['NNP'],
  'Kerry': ['NNP'],
  'Kerschner': ['NNP'],
  'Kershbaum': ['NNP'],
  'Kersley': ['NNP'],
  'Kerson': ['NNP'],
  'Kerstin': ['NNP'],
  'Keschl': ['NNP'],
  'Keshtmand': ['NNP'],
  'Kessler': ['NNP'],
  'Kestner': ['NNP'],
  'Keswick': ['NNP'],
  'Ketchikan': ['NNP'],
  'Ketchum': ['NNP'],
  'Ketelsen': ['NNP'],
  'Keteyian': ['NNP'],
  'Keul': ['NNP'],
  'Kevah': ['NNP'],
  'Kevin': ['NNP'],
  'Kevlar': ['NNP'],
  'Key': ['NNP'],
  'Keye\\\'/Donna\\\'/Pearlstein': ['NN'],
  'Keyes': ['NNP'],
  'Keynes': ['NNP'],
  'Keynesian': ['JJ'],
  'Keynesians': ['NNPS'],
  'Keynotes': ['NNS'],
  'Keys': ['NNP'],
  'Keystone': ['NNP'],
  'Kezar': ['NNP'],
  'Kezziah': ['NNP'],
  'Khaju': ['NNP'],
  'Khalifa': ['NNP'],
  'Khan': ['NNP'],
  'Khare': ['NNP'],
  'Khartoum': ['NNP'],
  'Khasi': ['NNP'],
  'Kheel': ['NNP'],
  'Khin': ['NNP'],
  'Khivrich': ['NNP'],
  'Khmer': ['NNP'],
  'Khomeini': ['NNP'],
  'Khomeni': ['NNP'],
  'Khost': ['NNP'],
  'Khouja': ['NNP'],
  'Khrush': ['NNP'],
  'Khrushchev': ['NNP'],
  'Khrushchevs': ['NNPS'],
  'Khustndinov': ['NNP'],
  'Kia': ['NNP'],
  'Kiam': ['NNP'],
  'Kian': ['NNP'],
  'Kiang': ['NNP'],
  'Kiarti': ['NNP'],
  'Kibbutz': ['NNP'],
  'Kibbutzim': ['NNS'],
  'Kibbutzniks': ['NNS'],
  'Kid': ['NNP'],
  'Kid-Isoletta': ['NNP'],
  'Kidd': ['NNP'],
  'Kidder': ['NNP'],
  'Kiddie': ['NNP'],
  'Kidnaper': ['NN'],
  'Kidnapper': ['NN'],
  'Kids': ['NNP'],
  'Kieffer': ['NNP'],
  'Kiefferm': ['NNP'],
  'Kiel': ['NNP'],
  'Kiep': ['NNP'],
  'Kieran': ['NNP'],
  'Kieslowski': ['NNP'],
  'Kiev': ['NNP'],
  'Kihei': ['NNP'],
  'Kika': ['NNP'],
  'Kiki': ['NNP'],
  'Kikiyus': ['NNPS'],
  'Kikkoman': ['NNP'],
  'Kiko': ['NNP'],
  'Kikuyu': ['NNP'],
  'Kildare': ['NNP'],
  'Kilduff': ['NNP'],
  'Kiley': ['NNP'],
  'Kilhour': ['NNP'],
  'Kililngsworth': ['NNP'],
  'Kill': ['VB'],
  'Killebrew': ['NNP'],
  'Killeen': ['NNP'],
  'Killelea': ['NNP'],
  'Killen': ['NNP'],
  'Killer': ['NNP'],
  'Killers': ['NNPS'],
  'Killing': ['NN'],
  'Killingsworth': ['NNP'],
  'Killington': ['NNP'],
  'Killion': ['NNP'],
  'Killips': ['NNP'],
  'Killory': ['NNP'],
  'Killow': ['NNP'],
  'Killpath': ['NNP'],
  'Kilpatrick': ['NNP'],
  'Kilty': ['NNP'],
  'Kim': ['NNP'],
  'Kimba': ['NNP'],
  'Kimball': ['NNP'],
  'Kimbark': ['NNP'],
  'Kimbell-Diamond': ['NNP'],
  'Kimberly': ['NNP'],
  'Kimberly-Clark': ['NNP'],
  'Kimbolton': ['NNP'],
  'Kimbrough': ['NNP'],
  'Kimco': ['NNP'],
  'Kimihide': ['NNP'],
  'Kimmel': ['NNP'],
  'Kimmell': ['NNP'],
  'Kimmelman': ['NNP'],
  'Kimpton': ['NNP'],
  'Kims': ['NNPS'],
  'Kimsong': ['NNP'],
  'Kincannon': ['NNP'],
  'Kind': ['NN'],
  'Kinda': ['RB'],
  'Kinder-Care': ['NNP'],
  'KinderCare': ['NNP'],
  'Kindergarten': ['NN'],
  'Kindertotenlieder': ['FW'],
  'King': ['NNP'],
  'Kingan': ['NNP'],
  'Kingdom': ['NNP'],
  'Kingdom-based': ['JJ'],
  'Kingdome': ['NNP'],
  'Kingfisher': ['NNP'],
  'Kingman': ['NNP'],
  'Kingpin': ['NN'],
  'Kings': ['NNP'],
  'Kingsbridge': ['NNP'],
  'Kingsepp': ['NNP'],
  'Kingsford': ['NNP'],
  'Kingsley': ['NNP'],
  'Kingston': ['NNP'],
  'Kingstown': ['NNP'],
  'Kingsville': ['NNP'],
  'Kingwood': ['NNP'],
  'Kinji': ['NNP'],
  'Kinkaid': ['NNP'],
  'Kinnard': ['NNP'],
  'Kinnear': ['NNP'],
  'Kinnett': ['NNP'],
  'Kinnevik': ['NNP'],
  'Kinney': ['NNP'],
  'Kinnock': ['NNP'],
  'Kinsell': ['NNP'],
  'Kinsey': ['NNP'],
  'Kinsley': ['NNP'],
  'Kiowa': ['NNP'],
  'Kip': ['NNP'],
  'Kipling': ['NNP'],
  'Kipp': ['NNP'],
  'Kippur': ['NNP'],
  'Kira': ['NNP'],
  'Kiran': ['NNP'],
  'Kirby': ['NNP'],
  'Kirchberger': ['NNP'],
  'Kirghiz': ['NNP'],
  'Kirgizia': ['NNP'],
  'Kirin': ['NNP'],
  'Kirk': ['NNP'],
  'Kirkendall': ['NNP'],
  'Kirkland': ['NNP'],
  'Kirkpatrick': ['NNP'],
  'Kirkwood': ['NNP'],
  'Kirnan': ['NNP'],
  'Kirov': ['NNP'],
  'Kirsch': ['NNP'],
  'Kirschbaum': ['NNP'],
  'Kirschner': ['NNP'],
  'Kiryat': ['NNP'],
  'Kis': ['NNP'],
  'Kisen': ['NNP'],
  'Kisha': ['FW'],
  'Kishimoto': ['NNP'],
  'Kiss': ['VB'],
  'Kissak': ['NNP'],
  'Kisscorni': ['NNP'],
  'Kissick': ['NNP'],
  'Kissin': ['NNP'],
  'Kissing': ['VBG'],
  'Kissinger': ['NNP'],
  'Kit': ['NN'],
  'Kita': ['NNP'],
  'Kitada': ['NNP'],
  'Kitamura': ['NNP'],
  'Kitaro': ['NNP'],
  'Kitcat': ['NNP'],
  'Kitchen': ['NNP'],
  'Kitchin': ['NNP'],
  'Kitti': ['NNP'],
  'Kittler': ['NNP'],
  'Kittredge': ['NNP'],
  'Kitty': ['NNP'],
  'Kivu': ['NNP'],
  'Kiwanis': ['NNP'],
  'Kiyoi': ['NNP'],
  'Kiyotaka': ['NNP'],
  'Kiz': ['NNP'],
  'Kizzie': ['NNP'],
  'Klamath': ['NNP'],
  'Klan': ['NNP'],
  'Klansmen': ['NNPS'],
  'Klass': ['NNP'],
  'Klatman': ['NNP'],
  'Klatsky': ['NNP'],
  'Klauber': ['NNP'],
  'Klauer': ['NNP'],
  'Klaus': ['NNP'],
  'Klauser': ['NNP'],
  'Klawitter': ['NNP'],
  'Kleber': ['NNP'],
  'Kleenex': ['NNP'],
  'Klees': ['NNP'],
  'Kleiber': ['NNP'],
  'Kleiman': ['NNP'],
  'Klein': ['NNP'],
  'Kleinaitis': ['NNP'],
  'Kleiner': ['NNP'],
  'Kleinman': ['NNP'],
  'Kleinwort': ['NNP'],
  'Kleissas': ['NNP'],
  'Kleist': ['NNP'],
  'Klejna': ['NNP'],
  'Klemperer': ['NNP'],
  'Klerk': ['NNP'],
  'Klesken': ['NNP'],
  'Klette': ['NNP'],
  'Kligman': ['NNP'],
  'Klimpl': ['NNP'],
  'Klimt': ['NNP'],
  'Kline': ['NNP'],
  'Klineberg': ['NNP'],
  'Klinger': ['NNP'],
  'Klinico': ['NNP'],
  'Klinsky': ['NNP'],
  'Klipstein': ['NNP'],
  'Kloeckner': ['NNP'],
  'Kloman': ['NNP'],
  'Klondike': ['NNP'],
  'Kloner': ['NNP'],
  'Klopfenstein': ['NNP'],
  'Kloske': ['NNP'],
  'Kloves': ['NNP'],
  'Kluckhohn': ['NNP'],
  'Kluge': ['NNP'],
  'Klugt': ['NNP'],
  'Klute': ['NNP'],
  'Klux': ['NNP'],
  'Knapek': ['NNP'],
  'Knapp': ['NNP'],
  'Knappertsbusch': ['NNP'],
  'Knauer': ['NNP'],
  'Knead': ['VB'],
  'Kneale': ['NNP'],
  'Knecht': ['NNP'],
  'Knee': ['NN'],
  'Kneeling': ['VBG'],
  'Knesset': ['NNP'],
  'Knickerbocker': ['NNP'],
  'Knife': ['NNP'],
  'Knife-grinder': ['NNP'],
  'Knight': ['NNP'],
  'Knight-Ridder': ['NNP'],
  'Knightes': ['NNP'],
  'Knightfall': ['NNP'],
  'Knights': ['NNP'],
  'Knightsbridge': ['NNP'],
  'Knill': ['NNP'],
  'Knit': ['VB'],
  'Knitwear': ['NNP'],
  'Knock': ['VB'],
  'Knogo': ['NNP'],
  'Knoll': ['NNP'],
  'Knopf': ['NNP'],
  'Knorr': ['NNP'],
  'Knots': ['NNP'],
  'Know': ['VB'],
  'Know-Nothing': ['JJ'],
  'Know-nothings': ['NNS'],
  'Knowing': ['VBG'],
  'Knowledge': ['NN'],
  'KnowledgeWare': ['NNP'],
  'Knowledgeable': ['JJ'],
  'Knowledgeware': ['NNP'],
  'Knowlton': ['NNP'],
  'Known': ['VBN'],
  'Knows': ['VBZ'],
  'Knox': ['NNP'],
  'Knox-like': ['JJ'],
  'Knoxville': ['NNP'],
  'Knudsen': ['NNP'],
  'Knudson': ['NNP'],
  'Knuettel': ['NNP'],
  'Knupp': ['NNP'],
  'Knute': ['NNP'],
  'Knutz': ['NNP'],
  'Ko': ['NNP'],
  'Koa': ['NNP'],
  'Kobacker': ['NNP'],
  'Kobayashi': ['NNP'],
  'Kobe': ['NNP'],
  'Kobrand': ['NNP'],
  'Koch': ['NNP'],
  'Kochan': ['NNP'],
  'Kochanek': ['NNP'],
  'Kochaneks': ['NNPS'],
  'Kochis': ['NNP'],
  'Kochitov': ['NNP'],
  'Kochola': ['NNP'],
  'Kodak': ['NNP'],
  'Kodaks': ['NNPS'],
  'Kodama': ['NNP'],
  'Kodansha': ['NNP'],
  'Kodiak': ['NNP'],
  'Kodyke': ['NNP'],
  'Koehler': ['NNP'],
  'Koenig': ['NNP'],
  'Koenigsberg': ['NNP'],
  'Koepf': ['NNP'],
  'Koeppel': ['NNP'],
  'Koerner': ['NNP'],
  'Kofanes': ['NNS'],
  'Kofcoh': ['NNP'],
  'Koffman': ['NNP'],
  'Kogan': ['NNP'],
  'Kogyo': ['NNP'],
  'Koh': ['NNP'],
  'Kohi': ['FW'],
  'Kohl': ['NNP'],
  'Kohlberg': ['NNP'],
  'Kohler': ['NNP'],
  'Kohnstamm': ['NNP'],
  'Kohnstamm-negative': ['JJ'],
  'Kohnstamm-positive': ['JJ'],
  'Kohrs': ['NNP'],
  'Kohut': ['NNP'],
  'Koito': ['NNP'],
  'Koizumi': ['NNP'],
  'Koji': ['NNP'],
  'Kok': ['NNP'],
  'Kokoschka': ['NNP'],
  'Kokubu': ['NNP'],
  'Kokusai': ['NNP'],
  'Kolakowski': ['NNP'],
  'Kolb': ['NNP'],
  'Kolber': ['NNP'],
  'Kolberg': ['NNP'],
  'Kolff': ['NNP'],
  'Kollmorgen': ['NNP'],
  'Kolman': ['NNP'],
  'Kolpakova': ['NNP'],
  'Kolsrud': ['NNP'],
  'Kolstad': ['NNP'],
  'Komatsu': ['NNP'],
  'Kombo': ['NNP'],
  'Komleva': ['NNP'],
  'Komori': ['NNP'],
  'Kompakt': ['NNP'],
  'Komsomol': ['NNP'],
  'Komsomolskaya': ['NNP'],
  'Komurasaki': ['NNP'],
  'Kon': ['NNP'],
  'Kona': ['NNP'],
  'Kondo': ['NNP'],
  'Kondratas': ['NNP'],
  'Kong': ['NNP'],
  'Kong-based': ['JJ'],
  'Kong-dollar': ['NN'],
  'Kongsberg': ['NNP'],
  'Konheim': ['NNP'],
  'Konigsberg': ['NNP'],
  'Konikow': ['NNP'],
  'Koninklijke': ['NNP'],
  'Konishi': ['NNP'],
  'Konitz': ['NNP'],
  'Konner': ['NNP'],
  'Konopnicki': ['NNP'],
  'Konowitch': ['NNP'],
  'Konrad': ['NNP'],
  'Konstantin': ['NNP'],
  'Kontrollbank': ['NNP'],
  'Konzerthaus': ['NNP'],
  'Kooks': ['NNPS'],
  'Kool-Aid': ['NNP'],
  'Kooning': ['NNP'],
  'Koop': ['NNP'],
  'Koopman': ['NNP'],
  'Koor': ['NNP'],
  'Kooten': ['NNP'],
  'Kopcke': ['NNP'],
  'Kopp': ['NNP'],
  'Koppel': ['NNP'],
  'Koppers': ['NNP'],
  'Kopstein': ['NNP'],
  'Koran': ['NNP'],
  'Korando': ['NNP'],
  'Korbich': ['NNP'],
  'Korbin': ['NNP'],
  'Korda': ['NNP'],
  'Korea': ['NNP'],
  'Korea-basher': ['NN'],
  'Koreagate': ['NNP'],
  'Korean': ['JJ'],
  'Korean-American': ['JJ'],
  'Korean-Americans': ['NNPS'],
  'Korean-U.S.': ['NNP'],
  'Koreans': ['NNPS'],
  'Korff': ['NNP'],
  'Kori': ['NNP'],
  'Korman': ['NNP'],
  'Korn': ['NNP'],
  'Korn\\\'/Ferry': ['NNP'],
  'Kornbluth': ['NNP'],
  'Kornevey': ['NNP'],
  'Korneyev': ['NNP'],
  'Korneyeva': ['NNP'],
  'Kornfield': ['NNP'],
  'Korngold': ['NNP'],
  'Kornick': ['NNP'],
  'Kornreich': ['NNP'],
  'Korobytsin': ['NNP'],
  'Korobytsins': ['NNS'],
  'Korotich': ['NNP'],
  'Korowin': ['NNP'],
  'Korps': ['NNP'],
  'Korra': ['NNP'],
  'Kors': ['NNP'],
  'Kortunov': ['NNP'],
  'Kory': ['NNP'],
  'Kos': ['NNP'],
  'Kosan': ['NNP'],
  'Kosar': ['NNP'],
  'Koshare': ['NNP'],
  'Koshland': ['NNP'],
  'Koskotas': ['NNP'],
  'Kosonen': ['NNP'],
  'Kosovo': ['NNP'],
  'Kossuth': ['NNP'],
  'Kostelanetz': ['NNP'],
  'Kotman': ['NNP'],
  'Kotobuki': ['NNP'],
  'Kots': ['NNP'],
  'Kouji': ['NNP'],
  'Koussevitzky': ['NNP'],
  'Kovacic': ['NNP'],
  'Kowa': ['NNP'],
  'Kowalski': ['NNP'],
  'Koyata': ['NNP'],
  'Koyo': ['NNP'],
  'Kozak': ['NNP'],
  'Kozinski': ['NNP'],
  'Kozintsev': ['NNP'],
  'Kozloff': ['NNP'],
  'Kozuo': ['NNP'],
  'Kraemer': ['NN'],
  'Kraft': ['NNP'],
  'Krakatoa': ['NNP'],
  'Krakow': ['NNP'],
  'Krakowiak': ['NNP'],
  'Kramer': ['NNP'],
  'Krampe': ['NNP'],
  'Krane': ['NNP'],
  'Krapels': ['NNP'],
  'Krapp': ['NNP'],
  'Krasnik': ['NNP'],
  'Krasnow': ['NNP'],
  'Krasnoyarsk': ['NNP'],
  'Krat': ['NNP'],
  'Krause': ['NNP'],
  'Krauss': ['NNP'],
  'Krauss-Maffei': ['NNP'],
  'Krauts': ['NNS'],
  'Kravis': ['NNP'],
  'Kravitz': ['NNP'],
  'Krebs': ['NNP'],
  'Kredietbank': ['NNP'],
  'Kreditanstalt': ['NNP'],
  'Kreditkasse': ['NNP'],
  'Kreisler': ['NNP'],
  'Kremlin': ['NNP'],
  'Krenz': ['NNP'],
  'Krepon': ['NNP'],
  'Kresa': ['NNP'],
  'Kress': ['NNP'],
  'Kretchmer': ['NNP'],
  'Kreuter': ['NNP'],
  'Kreutzer': ['NNP'],
  'Krick': ['NNP'],
  'Krieger': ['NNP'],
  'Krim': ['NNP'],
  'Krims': ['NNPS'],
  'Kringle': ['NNP'],
  'Krisher': ['NNP'],
  'Krishna': ['NNP'],
  'Krishnaists': ['NNS'],
  'Krishnamurthy': ['NNP'],
  'Krishnaswami': ['NNP'],
  'Krispies': ['NNPS'],
  'Kriss': ['NNP'],
  'Krist': ['UH'],
  'Kristallstrukturen': ['FW'],
  'Kristen': ['NNP'],
  'Kristiansen': ['NNP'],
  'Kristin': ['NNP'],
  'Kristine': ['NNP'],
  'Kristol': ['NNP'],
  'Kriz': ['NNP'],
  'Kroc': ['NNP'],
  'Kroczek': ['NNP'],
  'Kroening': ['NNP'],
  'Kroger': ['NNP'],
  'Krogers': ['NNPS'],
  'Krohley': ['NNP'],
  'Krohn': ['NNP'],
  'Kroll': ['NNP'],
  'Kroller-Muller': ['NNP'],
  'Kromy': ['NNP'],
  'Kron': ['NNP'],
  'Kronenberger': ['NNP'],
  'Kronish': ['NNP'],
  'Kropp': ['NNP'],
  'Krueger': ['NNP'],
  'Krug': ['NNP'],
  'Kruger': ['NNP'],
  'Kruk': ['NNP'],
  'Krumpp': ['NNP'],
  'Krupa': ['NNP'],
  'Krupp': ['NNP'],
  'Krutch': ['NNP'],
  'Krutchensky': ['NNP'],
  'Krys': ['NNP'],
  'Krysalis': ['NNP'],
  'Krystallographie': ['NNP'],
  'Kryuchkov': ['NNP'],
  'Krzysztof': ['NNP'],
  'Krzywy-Rog': ['NNP'],
  'Ku': ['NNP'],
  'Kuala': ['NNP'],
  'Kuan': ['NNP'],
  'Kubek': ['NNP'],
  'Kucharski': ['NNP'],
  'Kudlow': ['NNP'],
  'Kuehler': ['NNP'],
  'Kuehn': ['NNP'],
  'Kueneke': ['NNP'],
  'Kuhlke': ['NNP'],
  'Kuhlman': ['NNP'],
  'Kuhn': ['NNP'],
  'Kuhns': ['NNP'],
  'Kuiper': ['NNP'],
  'Kulani': ['NNP'],
  'Kulongoski': ['NNP'],
  'Kulturbund': ['NNP'],
  'Kum': ['NNP'],
  'Kumagai': ['NNP'],
  'Kumagai-Gumi': ['NNP'],
  'Kumble': ['NNP'],
  'Kume': ['NNP'],
  'Kummerfeld': ['NNP'],
  'Kunashir': ['NNP'],
  'Kung': ['NN'],
  'Kuniji': ['NNP'],
  'Kunkel': ['NNP'],
  'Kunste': ['NNP'],
  'Kunz': ['NNP'],
  'Kunze': ['NNP'],
  'Kuomintang': ['NNP'],
  'Kuparuk': ['NNP'],
  'Kupcinet': ['NNP'],
  'Kupelian': ['NNP'],
  'Kuperberg': ['NNP'],
  'Kupor': ['NNP'],
  'Kurabo': ['NNP'],
  'Kuraray': ['NNP'],
  'Kurd': ['NNP'],
  'Kurdish': ['JJ'],
  'Kurds': ['NNPS'],
  'Kurigalzu': ['NNP'],
  'Kurile': ['NNP'],
  'Kuriles': ['NNP'],
  'Kurlak': ['NNP'],
  'Kurland': ['NNP'],
  'Kurlander': ['NNP'],
  'Kurnit': ['NNP'],
  'Kurosaki': ['NNP'],
  'Kursk': ['NNP'],
  'Kurt': ['NNP'],
  'Kurtanjek': ['NNP'],
  'Kurth': ['NNP'],
  'Kurtwood': ['NNP'],
  'Kurtz': ['NNP'],
  'Kurtzig': ['NNP'],
  'Kurzweil': ['NNP'],
  'Kuse': ['NNP'],
  'Kuser': ['NNP'],
  'Kushkin': ['NNP'],
  'Kushnick': ['NNP'],
  'Kuster': ['NNP'],
  'Kutak': ['NNP'],
  'Kutney': ['NNP'],
  'Kuttner': ['NNP'],
  'Kutz': ['NNP'],
  'Kutzke': ['NNP'],
  'Kuvin': ['NNP'],
  'KuwAm': ['NNP'],
  'Kuwait': ['NNP'],
  'Kuwaiti': ['JJ'],
  'Kwaishinsha': ['NNP'],
  'Kwame': ['NNP'],
  'Kwan': ['NNP'],
  'Kwang': ['NNP'],
  'Kwango': ['NNP'],
  'Kwasha': ['NNP'],
  'Kweisi': ['NNP'],
  'Kwek': ['NNP'],
  'Kwik': ['NNP'],
  'Kwon': ['NNP'],
  'Kwong': ['NNP'],
  'Ky': ['NNP'],
  'Ky.': ['NNP'],
  'Ky.-based': ['JJ'],
  'Kyi': ['NNP'],
  'Kylberg': ['NNP'],
  'Kyle': ['NNP'],
  'Kymberly': ['NNP'],
  'Kyne': ['NNP'],
  'Kynikos': ['NNP'],
  'Kyo': ['NNP'],
  'Kyo-zan': ['NN'],
  'Kyocera': ['NNP'],
  'Kyodo': ['NNP'],
  'Kyong': ['NNP'],
  'Kyoto': ['NNP'],
  'Kyowa': ['NNP'],
  'Kysor': ['NNP'],
  'Kyu': ['NNP'],
  'Kyushu': ['NNP'],
  'Kyzyl': ['NNP'],
  'L': ['NNP'],
  'L&N': ['NNP'],
  'L\'Arcade': ['NNP'],
  'L\'Astree': ['NNP'],
  'L\'Heureux': ['NNP'],
  'L\'Imperiale': ['NNP'],
  'L\'Institut': ['NN'],
  'L\'Oreal': ['NNP'],
  'L\'Turu': ['NNP'],
  'L\'Union': ['NNP'],
  'L\'Unita': ['NNP'],
  'L\'incoronazione': ['FW'],
  'L\'orchestre': ['NNP'],
  'L-1011': ['NNP'],
  'L-5-vinyl-2-thio-oxazolidone': ['NN'],
  'L-P': ['NNP'],
  'L-shaped': ['JJ'],
  'L.': ['NNP'],
  'L.A': ['NNP'],
  'L.A.': ['NNP'],
  'L.B.': ['NNP'],
  'L.C.': ['NNP'],
  'L.E.': ['NNP'],
  'L.F.': ['NNP'],
  'L.H.': ['NNP'],
  'L.J.': ['NNP'],
  'L.L.': ['NNP'],
  'L.M.': ['NNP'],
  'L.P': ['NNP'],
  'L.P.': ['NNP'],
  'L.P.V': ['NNP'],
  'L.R.': ['NNP'],
  'L.S.U.': ['NNP'],
  'L.T.': ['NNP'],
  'LA': ['NNP'],
  'LABOR': ['NNP'],
  'LABORATORIES': ['NNP'],
  'LAC': ['NNP'],
  'LAMBERT': ['NNP'],
  'LAN': ['NNP'],
  'LAND': ['NNP'],
  'LANDOR': ['NNP'],
  'LARGEST': ['JJS'],
  'LASHED': ['VBD'],
  'LAST': ['JJ'],
  'LATE': ['JJ'],
  'LATE-BREAKING': ['JJ'],
  'LATEST': ['JJS'],
  'LAW': ['NN'],
  'LAWMAKERS': ['NNS'],
  'LAWSON': ['NNP'],
  'LAWYER': ['NN'],
  'LAWYERS': ['NNS'],
  'LAYOFFS': ['NNS'],
  'LBJ': ['NNP'],
  'LBO': ['NNP'],
  'LBO-related': ['JJ'],
  'LBOs': ['NNS'],
  'LD': ['NN'],
  'LD056': ['NN'],
  'LD060': ['NN'],
  'LDC': ['NNP'],
  'LDCs': ['NNPS'],
  'LDI': ['NNP'],
  'LDP': ['NNP'],
  'LDS': ['NNP'],
  'LEADER': ['NN'],
  'LEADERS': ['NNS'],
  'LEAVE': ['NN'],
  'LEAVING': ['VBG'],
  'LEBANESE': ['JJ'],
  'LEHMAN': ['NNP'],
  'LENSES': ['NNS'],
  'LETTER': ['NN'],
  'LEVERAGED': ['VBN'],
  'LEVINE': ['NNP'],
  'LIBERTY': ['NNP'],
  'LIBOR': ['NNP'],
  'LICENSE': ['NN'],
  'LIES': ['VBZ'],
  'LIFETIME': ['NNP'],
  'LIKE': ['IN'],
  'LIL': ['NNP'],
  'LIMB': ['NN'],
  'LIMITED': ['JJ'],
  'LIN': ['NNP'],
  'LIN-BellSouth': ['JJ'],
  'LINCOLN': ['NNP'],
  'LINK-UP': ['NN'],
  'LINTAS': ['NNP'],
  'LISA': ['NNP'],
  'LIT': ['NNP'],
  'LITORIGIN': ['NN'],
  'LIVE': ['JJ'],
  'LIVERPOOL': ['NNP'],
  'LIVESTOCK': ['NNP'],
  'LJH': ['NNP'],
  'LJN': ['NNP'],
  'LLerena': ['NNP'],
  'LM': ['NNP'],
  'LMAO': ['UH'],
  'LMBO': ['UH'],
  'LME': ['NNP'],
  'LMEYER': ['NNP'],
  'LMFAO': ['UH'],
  'LOAN': ['NNP'],
  'LOBBIES': ['VBZ'],
  'LOBSTERS': ['NNS'],
  'LOC': ['NNP'],
  'LOCKHEED': ['NNP'],
  'LOGIC': ['NNP'],
  'LOL': ['UH'],
  'LONDON': ['NNP'],
  'LONG-TERM': ['JJ'],
  'LONGS': ['NNP'],
  'LOOKING': ['VBG'],
  'LOOM': ['VBZ'],
  'LOS': ['NNP'],
  'LOSES': ['VBZ'],
  'LOSSES': ['NNS'],
  'LOSS\\\'': ['NN'],
  'LOT': ['NNP'],
  'LOTUS': ['NNP'],
  'LOUIS': ['NNP'],
  'LOVE': ['VB'],
  'LOW': ['RB'],
  'LOWER': ['JJR'],
  'LP': ['NNP'],
  'LPL': ['NNP'],
  'LS': ['NNP'],
  'LS400': ['NNP'],
  'LSC': ['NNP'],
  'LSI': ['NNP'],
  'LSO': ['NNP'],
  'LSU': ['NNP'],
  'LSX': ['NNP'],
  'LTCB': ['NNP'],
  'LTD': ['NNP'],
  'LTV': ['NNP'],
  'LUTHER': ['NNP'],
  'LUXURY': ['NN'],
  'LVI': ['NNP'],
  'LVMH': ['NNP'],
  'LX': ['NNP'],
  'LXI': ['NNP'],
  'LXi': ['NNP'],
  'LYNCH': ['NNP'],
  'LYONs': ['NNS'],
  'La': ['NNP'],
  'La-la-landers': ['NNS'],
  'La.': ['NNP'],
  'LaBella': ['NNP'],
  'LaBerge': ['NNP'],
  'LaBonte': ['NNP'],
  'LaBoon': ['NNP'],
  'LaBow': ['NNP'],
  'LaCroix': ['NNP'],
  'LaFalce': ['NNP'],
  'LaGow': ['NNP'],
  'LaGrange': ['NNP'],
  'LaGuardia': ['NNP'],
  'LaLonde': ['NNP'],
  'LaMacchia': ['NNP'],
  'LaMantia': ['NNP'],
  'LaMore': ['NNP'],
  'LaMothe': ['NNP'],
  'LaRiviere': ['NNP'],
  'LaRosa': ['NNP'],
  'LaSalle': ['NNP'],
  'LaWare': ['NNP'],
  'LaWarre': ['NNP'],
  'Lab': ['NNP'],
  'Laban': ['NNP'],
  'Laband': ['NNP'],
  'Labans': ['NNP'],
  'Labaton': ['NNP'],
  'Labatt': ['NNP'],
  'Labe': ['NNP'],
  'Labeling': ['VBG'],
  'Labor': ['NNP'],
  'Laboratories': ['NNPS'],
  'Laboratorium': ['NNP'],
  'Laboratory': ['NNP'],
  'Laboring': ['VBG'],
  'Labothe': ['NNP'],
  'Labouisse': ['NNP'],
  'Labour': ['NNP'],
  'Labovitz': ['NNP'],
  'Labow': ['NNP'],
  'Labrador': ['NNP'],
  'Labs': ['NNPS'],
  'Lac': ['NNP'],
  'Lacey': ['NNP'],
  'Lachica': ['NNP'],
  'Lack': ['NN'],
  'Lackey': ['NNP'],
  'Lacking': ['VBG'],
  'Lackland': ['NNP'],
  'Lackluster': ['JJ'],
  'Lacroix': ['NNP'],
  'Lacy': ['NNP'],
  'Lada': ['NNP'],
  'Ladas': ['NNP'],
  'Ladbroke': ['NNP'],
  'Ladd': ['NNP'],
  'Ladehoff': ['NNP'],
  'Ladenburg': ['NNP'],
  'Ladgham': ['NNP'],
  'Ladies': ['NNP'],
  'Ladislav': ['NNP'],
  'Lady': ['NNP'],
  'Laenderbank': ['NNP'],
  'Lafarge': ['NNP'],
  'Lafayette': ['NNP'],
  'Lafe': ['NNP'],
  'Laff': ['NNP'],
  'Lafite-Rothschild': ['NNP'],
  'Lafontant': ['NNP'],
  'Lag': ['NN'],
  'Lagerlof': ['NNP'],
  'Lagnado': ['NNP'],
  'Lagonda': ['NNP'],
  'Lagoon': ['NNP'],
  'Lagrange': ['NNP'],
  'Lags': ['VBZ'],
  'Laguerre': ['NNP'],
  'Laguna': ['NNP'],
  'Lahan': ['NNP'],
  'Lahus': ['NNP'],
  'Lai': ['NNP'],
  'Laicos': ['NNP'],
  'Laidig': ['NNP'],
  'Laidlaw': ['NNP'],
  'Laima': ['NNP'],
  'Laing': ['NNP'],
  'Laird': ['NNP'],
  'Lake': ['NNP'],
  'Lakeland': ['NNP'],
  'Laker': ['NNP'],
  'Lakers': ['NNP'],
  'Lakes': ['NNPS'],
  'Lakeshore': ['NNP'],
  'Lakewood': ['NNP'],
  'Lakshmipura': ['NNP'],
  'Lal': ['NNP'],
  'Lalaurie': ['NNP'],
  'Lalauries': ['NNPS'],
  'Lama': ['NNP'],
  'Lamalie': ['NNP'],
  'Lamar': ['NNP'],
  'Lamarche': ['NNP'],
  'Lamb': ['NNP'],
  'Lambarene': ['NNP'],
  'Lambda': ['NNP'],
  'Lamberjack': ['NNP'],
  'Lambert': ['NNP'],
  'Lamberth': ['NNP'],
  'Lambeth': ['NNP'],
  'Lamborghini': ['NNP'],
  'Lamentation': ['NNP'],
  'Lamle': ['NNP'],
  'Lamm': ['NNP'],
  'Lamma': ['NNP'],
  'Lammermoor': ['NNP'],
  'Lamon': ['NNP'],
  'Lamos': ['NNP'],
  'Lampe': ['NNP'],
  'Lamphere': ['NNP'],
  'Lampoon': ['NNP'],
  'Lamson': ['NNP'],
  'Lamy': ['NNP'],
  'Lamy-Lutti': ['NNP'],
  'Lana': ['NNP'],
  'Lancashire': ['NNP'],
  'Lancaster': ['NNP'],
  'Lance': ['NNP'],
  'Lancet': ['NNP'],
  'Lancia': ['NNP'],
  'Lancome': ['NNP'],
  'Lancret': ['NNP'],
  'Land': ['NNP'],
  'Land-O-Sun': ['NNP'],
  'Land-Rover': ['NNP'],
  'Land-based': ['JJ'],
  'Landa': ['NNP'],
  'Landau': ['NNP'],
  'Lande': ['NNP'],
  'Lander': ['NNP'],
  'Landerbank': ['NNP'],
  'Landers': ['NNP'],
  'Landesbank': ['NNP'],
  'Landesbank-Girozentrale': ['NNP'],
  'Landesco': ['NNP'],
  'Landesrentenbank': ['NNP'],
  'Landfill': ['NN'],
  'Landing': ['NNP'],
  'Landini': ['NNP'],
  'Landis': ['NNP'],
  'Landmark': ['NNP'],
  'Landon': ['NNP'],
  'Landonne': ['NNP'],
  'Landor': ['NNP'],
  'Landover': ['NNP'],
  'Landowners': ['NNS'],
  'Landrieu': ['NNP'],
  'Landrum-Griffin': ['NNP'],
  'Landry': ['NNP'],
  'Lands': ['NNPS'],
  'Landscape': ['NNP'],
  'Lane': ['NNP'],
  'Lanes': ['NNS'],
  'Lanese': ['NNP'],
  'Lanesmanship': ['NN'],
  'Lanesville': ['NNP'],
  'Lang': ['NNP'],
  'Langbo': ['NNP'],
  'Langeland': ['NNP'],
  'Langendorf': ['NNP'],
  'Langer': ['NNP'],
  'Langevin': ['NNP'],
  'Langford': ['NNP'],
  'Langhorne': ['NNP'],
  'Langley': ['NNP'],
  'Langner': ['NNP'],
  'Langsdorf': ['NNP'],
  'Langstaff': ['NNP'],
  'Langton': ['NNP'],
  'Language': ['NN'],
  'Languages': ['NNP'],
  'Lanham': ['NNP'],
  'Lanier': ['NNP'],
  'Lanin': ['NNP'],
  'Lanka': ['NNP'],
  'Lankford': ['NNP'],
  'Lannon': ['NNP'],
  'Lanny': ['NNP'],
  'Lansbury': ['NNP'],
  'Lansing': ['NNP'],
  'Lanston': ['NNP'],
  'Lante': ['NNP'],
  'Lantos': ['NNP'],
  'Lantz': ['NNP'],
  'Lanvin': ['NNP'],
  'Lanvin-owned': ['JJ'],
  'Lanyi': ['NNP'],
  'Lanza': ['NNP'],
  'Lanzhou': ['NNP'],
  'Lao': ['NNP'],
  'Lao-tse': ['NNP'],
  'Laodicean': ['JJ'],
  'Laos': ['NNP'],
  'Laotian': ['JJ'],
  'Laotians': ['NNS'],
  'Lap': ['NNP'],
  'Lapham': ['NNP'],
  'Laphroaig': ['NNP'],
  'Lapides': ['NNP'],
  'Lapin': ['FW'],
  'Laplace': ['NNP'],
  'Lapointe': ['NNP'],
  'Laporte': ['NNP'],
  'Lapp': ['NNP'],
  'Lappenberg': ['NNP'],
  'Lappenburg-Kemble': ['NNP'],
  'Lapps': ['NNPS'],
  'Laptev': ['NNP'],
  'Laptop': ['NN'],
  'Laptops': ['NNS'],
  'Lara': ['NNP'],
  'Laramie': ['NNP'],
  'Larchmont': ['NNP'],
  'Laredo': ['NNP'],
  'Large': ['JJ'],
  'Large-deposit': ['JJ'],
  'Large-package': ['JJ'],
  'Large-screen': ['JJ'],
  'Largely': ['RB'],
  'Larger': ['JJR'],
  'Largo': ['NNP'],
  'Larimer': ['NNP'],
  'Larisa': ['NNP'],
  'Larish': ['NNP'],
  'Lark': ['NNP'],
  'Larkin': ['NNP'],
  'Larkins': ['NNP'],
  'Larkspur': ['NNP'],
  'Laro': ['NNP'],
  'Larry': ['NNP'],
  'Lars': ['NNP'],
  'Lars-Erik': ['NNP'],
  'Larsen': ['NNP'],
  'Larson': ['NNP'],
  'Larsson': ['NNP'],
  'Las': ['NNP'],
  'Lascar': ['NNP'],
  'Lascivious': ['NNP'],
  'Lasco': ['NNP'],
  'Laser': ['NNP'],
  'LaserTripter': ['NNP'],
  'LaserWriter': ['NNP'],
  'Lasers': ['NNS'],
  'Laserscope': ['NNP'],
  'Lashof': ['NNP'],
  'Lasker': ['NNP'],
  'Lasmo': ['NNP'],
  'Lasorda': ['NNP'],
  'Lass': ['NNP'],
  'Lassie': ['NNP'],
  'Lassila': ['NNP'],
  'Lassus': ['NNP'],
  'Lasswitz': ['NNP'],
  'Last': ['JJ'],
  'Lastly': ['RB'],
  'Laswick': ['NNP'],
  'Laszlo': ['NNP'],
  'Latchford': ['NNP'],
  'Late': ['RB'],
  'Late-night': ['JJ'],
  'Lateiner': ['NNP'],
  'Lately': ['RB'],
  'Later': ['RB'],
  'Lateral': ['NNP'],
  'Lateran': ['NNP'],
  'Latest': ['JJS'],
  'Latest-quarter': ['JJ'],
  'Latham': ['NNP'],
  'Lathouris': ['NNP'],
  'Latin': ['NNP'],
  'Latino': ['JJ'],
  'Latinovich': ['NNP'],
  'Latour': ['NNP'],
  'Latowski': ['NNP'],
  'Latter': ['NN'],
  'Latter-day': ['JJ'],
  'Lattice': ['NNP'],
  'Lattimer': ['NNP'],
  'Latvia': ['NNP'],
  'Latvian': ['JJ'],
  'Latvians': ['NNPS'],
  'Lauber': ['NNP'],
  'Lauchli': ['NNP'],
  'Laudably': ['RB'],
  'Laude': ['NNP'],
  'Lauder': ['NNP'],
  'Lauderdale': ['NNP'],
  'Lauderhill': ['NNP'],
  'Laue': ['NNP'],
  'Lauer': ['NNP'],
  'Laufenberg': ['NNP'],
  'Laugh': ['NNP'],
  'Laughing': ['NNP'],
  'Laughlin': ['NNP'],
  'Launch': ['NN'],
  'Launched': ['VBN'],
  'Launches': ['VBZ'],
  'Launching': ['VBG'],
  'Launder': ['NNP'],
  'Launder-Ometer': ['NNP'],
  'Laundered': ['VBN'],
  'Laura': ['NNP'],
  'Laurance': ['NNP'],
  'Laurel': ['NNP'],
  'Lauren': ['NNP'],
  'Laurence': ['NNP'],
  'Laurene': ['NNP'],
  'Laurent': ['NNP'],
  'Laurentian': ['NNP'],
  'Laurentiis': ['NNP'],
  'Laurents': ['NNP'],
  'Lauri': ['NNP'],
  'Laurie': ['NNP'],
  'Lauritsen': ['NNP'],
  'Lauritz': ['NNP'],
  'Lauro': ['NNP'],
  'Lausanne': ['NNP'],
  'Lautenbach': ['NNP'],
  'Lautenberg': ['NNP'],
  'Lautner': ['NNP'],
  'Laux': ['NNP'],
  'Laval': ['NNP'],
  'Lavallade': ['NNP'],
  'Lavaro': ['NN'],
  'Lavato': ['NNP'],
  'Lavaughn': ['NNP'],
  'Lavelle': ['NNP'],
  'Laventhol': ['NNP'],
  'Laverne\\\'': ['JJ'],
  'Laverty': ['NNP'],
  'Lavery': ['NNP'],
  'Lavidge': ['NNP'],
  'Lavin': ['NNP'],
  'Lavity': ['NNP'],
  'Lavoisier': ['NNP'],
  'Lavoro': ['NNP'],
  'Law': ['NNP'],
  'Law-enforcement': ['JJ'],
  'Lawford': ['NNP'],
  'Lawful': ['JJ'],
  'Lawless': ['NNP'],
  'Lawmakers': ['NNS'],
  'Lawmaking': ['JJ'],
  'Lawn': ['NNP'],
  'Lawn-Boy': ['NNP'],
  'Lawrence': ['NNP'],
  'Lawrenceville': ['NNP'],
  'Lawrenson': ['NNP'],
  'Laws': ['NNS'],
  'Lawson': ['NNP'],
  'Lawson-Walters': ['NNP'],
  'Lawsuit': ['NNP'],
  'Lawsuits': ['NNS'],
  'Lawton': ['NNP'],
  'Lawyer': ['NNP'],
  'Lawyers': ['NNS'],
  'Lay': ['NNP'],
  'Laying': ['VBG'],
  'Layman': ['NNP'],
  'Layout': ['NN'],
  'Layton': ['NNP'],
  'Lazar': ['NNP'],
  'Lazard': ['NNP'],
  'Lazare': ['NNP'],
  'Lazarus': ['NNP'],
  'Lazy': ['NNP'],
  'Lazybones': ['NNP'],
  'Lazzaroni': ['NNP'],
  'Lazzeri': ['NNP'],
  'Le': ['NNP'],
  'LeBaron': ['NNP'],
  'LeBoutillier': ['NNP'],
  'LeBow': ['NNP'],
  'LeBron': ['NNP'],
  'LeBrun': ['NNP'],
  'LeCarre': ['NNP'],
  'LeCave': ['NNP'],
  'LeClair': ['NNP'],
  'LeCompte': ['NNP'],
  'LeFevre': ['NNP'],
  'LeFrere': ['NNP'],
  'LeGere': ['NNP'],
  'LeMans': ['NNP'],
  'LeMasters': ['NNP'],
  'LeMay': ['NNP'],
  'LePatner': ['NNP'],
  'LeRoy': ['NNP'],
  'LeSabre': ['NNP'],
  'LeSourd': ['NNP'],
  'LeVecke': ['NNP'],
  'Lea': ['NNP'],
  'Leach': ['NNP'],
  'Lead': ['JJ'],
  'Leadbetter': ['NNP'],
  'Leader': ['NNP'],
  'Leaders': ['NNS'],
  'Leadership': ['NN'],
  'Leading': ['VBG'],
  'Leads': ['VBZ'],
  'Leaf': ['NN'],
  'League': ['NNP'],
  'League-sponsored': ['JJ'],
  'Leaguers': ['NNP'],
  'Leagues': ['NNPS'],
  'Leahy': ['NNP'],
  'Leale': ['NNP'],
  'Leamington': ['NNP'],
  'Lean': ['NNP'],
  'Leaning': ['VBG'],
  'Leap': ['NNP'],
  'Leaping': ['VBG'],
  'Lear': ['NNP'],
  'Learn': ['VB'],
  'Learned': ['NNP'],
  'Learning': ['NNP'],
  'Leary': ['NNP'],
  'Leasco': ['NNP'],
  'Lease': ['NNP'],
  'Leaseway': ['NNP'],
  'Leasing': ['NNP'],
  'Leason': ['NNP'],
  'Least': ['JJS'],
  'Least-cost': ['JJ'],
  'Leasure': ['NN'],
  'Leath': ['NNP'],
  'Leather': ['NNP'],
  'Leatherman': ['NNP'],
  'Leatherneck': ['NNP'],
  'Leave': ['VB'],
  'Leavenworth': ['NNP'],
  'Leaves': ['NNS'],
  'Leaving': ['VBG'],
  'Leavitt': ['NNP'],
  'Lebanese': ['JJ'],
  'Lebanese-controlled': ['JJ'],
  'Lebanon': ['NNP'],
  'Lebans': ['NNP'],
  'Leben': ['NNP'],
  'Leber': ['NNP'],
  'Leblanc': ['NNP'],
  'Leblang': ['NNP'],
  'Lebo': ['NNP'],
  'Lebow': ['NNP'],
  'Lebron': ['NNP'],
  'LecTec': ['NNP'],
  'Lech': ['NNP'],
  'Leche': ['NNP'],
  'Lecheria': ['NNP'],
  'Lecky': ['NNP'],
  'Lectec': ['NNP'],
  'Lecture': ['NNP'],
  'Lecturer': ['NNP'],
  'Lectures': ['NNPS'],
  'Led': ['VBN'],
  'Lederberg': ['NNP'],
  'Lederer': ['NNP'],
  'Lederle': ['NNP'],
  'Ledford': ['NNP'],
  'Ledge': ['NN'],
  'Ledger': ['NNP'],
  'Ledoux': ['NNP'],
  'Ledyard': ['NNP'],
  'Lee': ['NNP'],
  'Lee-based': ['JJ'],
  'Leech': ['NNP'],
  'Leeches': ['NNS'],
  'Leeds': ['NNP'],
  'Leemans': ['NNP'],
  'Leery': ['JJ'],
  'Lees': ['NNP'],
  'Leesona': ['NNP'],
  'Leesona-Holt': ['NNP'],
  'Leet': ['NNP'],
  'Leeward': ['NNP'],
  'Leeza': ['NNP'],
  'Lefcourt': ['NNP'],
  'Lefebvre': ['NNP'],
  'Lefevre': ['NNP'],
  'Lefferts': ['NNP'],
  'Left': ['NNP'],
  'Left-Wing': ['NNP'],
  'Left-stream': ['JJ'],
  'Leftist': ['JJ'],
  'Leftovers': ['NNP'],
  'Lefty': ['NNP'],
  'Leg': ['NNP'],
  'Legal': ['NNP'],
  'Legalization': ['NN'],
  'Legalizing': ['VBG'],
  'Legally': ['RB'],
  'Legend': ['NNP'],
  'Legends': ['NNPS'],
  'Legent': ['NNP'],
  'Leger': ['NNP'],
  'Legers': ['NNPS'],
  'Legg': ['NNP'],
  'Leggett': ['NNP'],
  'Legion': ['NNP'],
  'Legionnaire': ['NNP'],
  'Legislating': ['VBG'],
  'Legislation': ['NN'],
  'Legislative': ['NNP'],
  'Legislators': ['NNS'],
  'Legislature': ['NNP'],
  'Legislatures': ['NNS'],
  'Legitimate': ['JJ'],
  'Legittino': ['NNP'],
  'Lego': ['NNP'],
  'Legs': ['NNS'],
  'Lehar': ['NNP'],
  'Lehder': ['NNP'],
  'Lehigh': ['NNP'],
  'Lehman': ['NNP'],
  'Lehman\\\'/American': ['NNP'],
  'Lehmann': ['NNP'],
  'Lehmans': ['NNPS'],
  'Lehn': ['NNP'],
  'Lehne': ['NNP'],
  'Lehner': ['NNP'],
  'Lehtinen': ['NNP'],
  'Leibler': ['NNP'],
  'Leibowitz': ['NNP'],
  'Leiby': ['NNP'],
  'Leica': ['NNP'],
  'Leichtman': ['NNP'],
  'Leiden': ['NN'],
  'Leigh': ['NNP'],
  'Leigh-Pemberton': ['NNP'],
  'Leighfield': ['NNP'],
  'Leighton': ['NNP'],
  'Leila': ['NNP'],
  'Leinberger': ['NNP'],
  'Leinoff': ['NNP'],
  'Leinonen': ['NNP'],
  'Leipzig': ['NNP'],
  'Leish': ['NNP'],
  'Leisire': ['NNP'],
  'Leisure': ['NNP'],
  'Leisurely': ['RB'],
  'Leitz': ['NNP'],
  'Leixlip': ['NNP'],
  'Lek': ['NNP'],
  'Lekberg': ['NNP'],
  'Leland': ['NNP'],
  'Leleiohaku': ['NNP'],
  'Lelogeais': ['NNP'],
  'Lemanowicz': ['NNP'],
  'Lemans': ['NNP'],
  'Leming': ['NNP'],
  'Lemma': ['NN'],
  'Lemme': ['VB'],
  'Lemmon': ['NNP'],
  'Lemon': ['NNP'],
  'Lemont': ['NNP'],
  'Lempesis': ['NNP'],
  'Lemuel': ['NNP'],
  'Len': ['NNP'],
  'Lena': ['NNP'],
  'Lenaghan': ['NNP'],
  'Lencioni': ['NNP'],
  'Lend': ['VB'],
  'Lender': ['NNP'],
  'Lenders': ['NNS'],
  'Lending': ['NN'],
  'Lendrum': ['NNP'],
  'Leng': ['NNP'],
  'Length': ['NN'],
  'Lengthening': ['VBG'],
  'Lengwin': ['NNP'],
  'Leni': ['NNP'],
  'Lenin': ['NNP'],
  'Leningrad': ['NNP'],
  'Leningrad-Kirov': ['NNP'],
  'Leninism-Marxism': ['NNP'],
  'Leninist': ['NNP'],
  'Leninskoye': ['NNP'],
  'Lennie': ['NNP'],
  'Lennon': ['NNP'],
  'Lennox': ['NNP'],
  'Lenny': ['NNP'],
  'Leno': ['NNP'],
  'Lenobel': ['NNP'],
  'Lens': ['NNP'],
  'Lent': ['NNP'],
  'Lentjes': ['NNP'],
  'Lenwood': ['NNP'],
  'Leny': ['NNP'],
  'Lenygon': ['NNP'],
  'Leo': ['NNP'],
  'Leobardo': ['NNP'],
  'Leominster': ['NNP'],
  'Leon': ['NNP'],
  'Leona': ['NNP'],
  'Leonard': ['NNP'],
  'Leonardo': ['NNP'],
  'Leonato': ['NNP'],
  'Leone': ['NNP'],
  'Leonel': ['NNP'],
  'Leong': ['NNP'],
  'Leonid': ['NNP'],
  'Leonidas': ['NNP'],
  'Leonore': ['NNP'],
  'Leontief': ['NNP'],
  'Leopard': ['NNP'],
  'Leopold': ['NNP'],
  'Leopoldville': ['NNP'],
  'Lep': ['NNP'],
  'Lepercq': ['NNP'],
  'Leperq': ['NNP'],
  'Leponex': ['NNP'],
  'Leppard': ['NNP'],
  'Lerach': ['NNP'],
  'Lerman': ['NNP'],
  'Lermer': ['NNP'],
  'Lerner': ['NNP'],
  'Leroy': ['NNP'],
  'Les': ['NNP'],
  'Lesbian': ['NNP'],
  'Lescaut': ['NNP'],
  'Lescaze': ['NNP'],
  'Lesch-Nyhan': ['NNP'],
  'Leschly': ['NNP'],
  'Leser': ['NNP'],
  'Leshem': ['NNP'],
  'Lesk': ['NNP'],
  'Lesko': ['NNP'],
  'Lesley': ['NNP'],
  'Lesley-Anne': ['NNP'],
  'Leslie': ['NNP'],
  'Lespinasse': ['NNP'],
  'Less': ['RBR'],
  'Less-than-truckload': ['JJ'],
  'Lessening': ['VBG'],
  'Lesser': ['NNP'],
  'Lessing': ['NNP'],
  'Lessner': ['NNP'],
  'Lesson': ['NN'],
  'Lessons': ['NNS'],
  'Lester': ['NNP'],
  'Lestoil': ['NNP'],
  'Lesutis': ['NNP'],
  'Leszek': ['NNP'],
  'Let': ['VB'],
  'Let\'s': ['VB'],
  'Letch': ['NNP'],
  'Lethal': ['NNP'],
  'Lethcoe': ['NNP'],
  'Letitia': ['NNP'],
  'Lets': ['VB'],
  'Lett': ['NNP'],
  'Letter': ['NNP'],
  'Letterman': ['NNP'],
  'Letters': ['NNS'],
  'Letting': ['VBG'],
  'Leu': ['NNP'],
  'Leubert': ['NNP'],
  'Leucadia': ['NNP'],
  'Leuffer': ['NNP'],
  'Leukemia': ['NNP'],
  'Leumi': ['NNP'],
  'Leuzzi': ['NNP'],
  'Lev': ['NNP'],
  'Leval': ['NNP'],
  'Levamisole': ['NN'],
  'Level': ['NNP'],
  'Leven': ['NNP'],
  'Levenson': ['NNP'],
  'Leventhal': ['NNP'],
  'Lever': ['NNP'],
  'Leverage': ['NN'],
  'Leveraged': ['JJ'],
  'Leverett': ['NNP'],
  'Leverkuhn': ['NNP'],
  'Leverkusen': ['NNP'],
  'Levert': ['NNP'],
  'Levesque': ['NNP'],
  'Levi': ['NNP'],
  'Levin': ['NNP'],
  'Levina': ['NNP'],
  'Levine': ['NNP'],
  'Levinger': ['NNP'],
  'Levinson': ['NNP'],
  'Levitt': ['NNP'],
  'Levittown': ['NNP'],
  'Levki': ['NNP'],
  'Levy': ['NNP'],
  'Lew': ['NNP'],
  'Lewala': ['NNP'],
  'Lewco': ['NNP'],
  'Lewellen': ['NNP'],
  'Lewelleyn': ['NNP'],
  'Lewellyn': ['NNP'],
  'Lewin': ['NNP'],
  'Lewinton': ['NNP'],
  'Lewis': ['NNP'],
  'Lewisohn': ['NNP'],
  'Lewiston': ['NNP'],
  'Lewtas': ['NNP'],
  'Lex': ['NNP'],
  'Lexington': ['NNP'],
  'Lexington-based': ['JJ'],
  'Lexus': ['NNP'],
  'Leyden': ['NN'],
  'Leyland': ['NNP'],
  'Leyse': ['NNP'],
  'Leyte': ['NNP'],
  'Leyva': ['NNP'],
  'Lezovich': ['NNP'],
  'Li': ['NNP'],
  'Li\'l': ['JJ'],
  'Liability': ['NN'],
  'Liaison': ['NNP'],
  'Liaisons': ['NNS'],
  'Liang': ['NNP'],
  'Liar': ['NN'],
  'Libel': ['NNP'],
  'Liber': ['NNP'],
  'Libera': ['FW'],
  'Liberace': ['NNP'],
  'Liberal': ['NNP'],
  'Liberal-Radical': ['NNP'],
  'Liberalism': ['NN'],
  'Liberals': ['NNPS'],
  'Liberated': ['VBN'],
  'Liberating': ['VBG'],
  'Liberation': ['NNP'],
  'Liberia': ['NNPS'],
  'Liberian': ['JJ'],
  'Liberman': ['NNP'],
  'Liberties': ['NNPS'],
  'Libertines': ['NNS'],
  'Liberty': ['NNP'],
  'Liberty-and-Union': ['NN'],
  'Libor': ['NNP'],
  'Librarians': ['NNS'],
  'Library': ['NNP'],
  'Librium': ['NNP'],
  'Libya': ['NNP'],
  'Libyan': ['JJ'],
  'Libyans': ['NNPS'],
  'License': ['NN'],
  'Licenses': ['NNP'],
  'Licht': ['NNP'],
  'Lichtblau': ['NNP'],
  'Lichtenstein': ['NNP'],
  'Licks': ['NNP'],
  'Liddell': ['NNP'],
  'Liddle': ['NNP'],
  'Lidex': ['NNP'],
  'Lidgerwood': ['NNP'],
  'Lido': ['NNP'],
  'Lidov': ['NNP'],
  'Lids': ['NNS'],
  'Lie': ['NNP'],
  'Lieb': ['NNP'],
  'Liebenow': ['NNP'],
  'Lieber': ['NNP'],
  'Lieberman': ['NNP'],
  'Lieberthal': ['NNP'],
  'Liebler': ['NNP'],
  'Liebowitz': ['NNP'],
  'Liechtenstein': ['NNP'],
  'Lied': ['NNP'],
  'Lien': ['NN'],
  'Lieppe': ['NNP'],
  'Lies': ['NN'],
  'Lieut': ['NN'],
  'Lieutenant': ['NNP'],
  'Lieutenant-Colonel': ['NNP'],
  'Lieutenant-Governor': ['NNP'],
  'Life': ['NNP'],
  'Life-preservers': ['NNS'],
  'LifeSavers': ['NNPS'],
  'LifeSpan': ['NNP'],
  'Lifeboat': ['NNP'],
  'Lifeco': ['NNP'],
  'Lifecodes': ['NNPS'],
  'Lifeguard': ['NN'],
  'Lifeguards': ['NNS'],
  'Lifestyle': ['NNP'],
  'Lifestyles': ['NNPS'],
  'Lifetime': ['NNP'],
  'Liffe': ['NNP'],
  'Lifland': ['NNP'],
  'Lifson': ['NNP'],
  'Lift': ['VB'],
  'Lifting': ['VBG'],
  'Ligachev': ['NNP'],
  'Ligget': ['NNP'],
  'Liggett': ['NNP'],
  'Light': ['NNP'],
  'Lighted': ['VBN'],
  'Lighter': ['JJR'],
  'Lightfoot': ['NNP'],
  'Lighthouse': ['NNP'],
  'Lighting': ['NNP'],
  'Lightly': ['RB'],
  'Lightning': ['NN'],
  'Lights': ['NNS'],
  'Lightstone': ['NNP'],
  'Lightweight': ['JJ'],
  'Ligne': ['NNP'],
  'Liipfert': ['NNP'],
  'Like': ['IN'],
  'Likely': ['JJ'],
  'Likening': ['VBG'],
  'Likewise': ['RB'],
  'Likins': ['NNP'],
  'Likud': ['NNP'],
  'Lil': ['NNP'],
  'Lila': ['NNP'],
  'Lilac': ['NNP'],
  'Lili': ['NNP'],
  'Lilian': ['NNP'],
  'Lilien': ['NNP'],
  'Liliputian': ['NNP'],
  'Lillard': ['NNP'],
  'Lille': ['NNP'],
  'Lillehammer': ['NNP'],
  'Lilley': ['NNP'],
  'Lillian': ['NNP'],
  'Lilliputian': ['JJ'],
  'Lillo': ['NNP'],
  'Lilly': ['NNP'],
  'Lily': ['NNP'],
  'Lim': ['NNP'],
  'Lima': ['NNP'],
  'Liman': ['NNP'],
  'Limbo': ['NNP'],
  'Lime': ['NNP'],
  'Limerick': ['NNP'],
  'Liming': ['NNP'],
  'Limit': ['VB'],
  'Limitation': ['NNP'],
  'Limitations': ['NNS'],
  'Limited': ['NNP'],
  'Limiting': ['VBG'],
  'Limits': ['NNPS'],
  'Lin': ['NNP'],
  'Linage': ['NN'],
  'Lincoln': ['NNP'],
  'Lincoln-Douglas': ['NNP'],
  'Lincoln-Mercury': ['NNP'],
  'Lincoln-Mercury-Merkur': ['NNP'],
  'Lincolnshire': ['NNP'],
  'Lind': ['NNP'],
  'Lind-Waldock': ['NNP'],
  'Linda': ['NNP'],
  'Lindamood': ['NNP'],
  'Lindbergh': ['NN'],
  'Lindemann': ['NNP'],
  'Lindemanns': ['NNPS'],
  'Linden': ['NNP'],
  'Lindens': ['NNPS'],
  'Linder': ['NNP'],
  'Lindner': ['NNP'],
  'Lindsay': ['NNP'],
  'Lindsey': ['NNP'],
  'Lindskog': ['NNP'],
  'Lindy': ['NNP'],
  'Lindzen': ['NNP'],
  'Line': ['NNP'],
  'Line-item': ['JJ'],
  'Linear': ['NNP'],
  'Liner': ['NNP'],
  'Lines': ['NNPS'],
  'Lines-Trans': ['NNP'],
  'Linger': ['NNP'],
  'Lingering': ['JJ'],
  'Lingo': ['NN'],
  'Linguistic': ['JJ'],
  'Linguists': ['NNS'],
  'Lingus': ['NNP'],
  'Linh': ['NNP'],
  'Link': ['NNP'],
  'Linked': ['VBN'],
  'Linker': ['NNP'],
  'Linking': ['VBG'],
  'Links': ['NNP'],
  'Linsenberg': ['NNP'],
  'Linsert': ['NNP'],
  'Linsey': ['NNP'],
  'Linsley': ['NNP'],
  'Lint': ['NNP'],
  'Lintas': ['NNP'],
  'Lintas:Campbell-Ewald': ['NNP'],
  'Lintas:New': ['NNP'],
  'Linter': ['NNP'],
  'Lintner': ['NNP'],
  'Linus': ['NNP'],
  'Linville': ['NNP'],
  'Linvure': ['NNP'],
  'Linwick': ['NNP'],
  'Linwood': ['NNP'],
  'Linz': ['NNP'],
  'Lion': ['NNP'],
  'Lionel': ['NNP'],
  'Lions': ['NNP'],
  'Lionville': ['NNP'],
  'Lior': ['NNP'],
  'Lipchitz': ['NNP'],
  'Lipman': ['NNP'],
  'Lipner': ['NNP'],
  'Lipowa': ['NNP'],
  'Lippens': ['NNP'],
  'Lipper': ['NNP'],
  'Lippi': ['NNP'],
  'Lippincott': ['NNP'],
  'Lippman': ['NNP'],
  'Lippmann': ['NNP'],
  'Lipps': ['NNP'],
  'Lips': ['NNS'],
  'Lipshie': ['NNP'],
  'Lipsky': ['NNP'],
  'Lipson': ['NNP'],
  'Lipstein': ['NNP'],
  'Liptak': ['NNP'],
  'Lipton': ['NNP'],
  'Liqueur': ['NNP'],
  'Liquid': ['NNP'],
  'Liquidating': ['NNP'],
  'Liquidation': ['NNP'],
  'Liquidity': ['NN'],
  'Liquor': ['NNP'],
  'Liriano': ['NNP'],
  'Liro': ['NNP'],
  'Lisa': ['NNP'],
  'Lisbeth': ['NNP'],
  'Lisbon': ['NNP'],
  'Lish': ['NNP'],
  'Lisle': ['NNP'],
  'Liss': ['NNP'],
  'Lissa': ['NNP'],
  'List': ['NNP'],
  'Listed': ['VBN'],
  'Listen': ['VB'],
  'Listeners': ['NNS'],
  'Listenin': ['NN'],
  'Listening': ['NN'],
  'Lister': ['NNP'],
  'Listerine': ['NNP'],
  'Liston': ['NNP'],
  'Lita': ['NNP'],
  'Litchfield': ['NNP'],
  'Lite': ['NNP'],
  'Liter': ['NN'],
  'Literacy': ['NN'],
  'Literal': ['JJ'],
  'Literally': ['RB'],
  'Literary': ['NNP'],
  'Literature': ['NNP'],
  'Literaturnaya': ['NNP'],
  'Lithe': ['JJ'],
  'Lithell': ['NNP'],
  'Lithograph': ['NNP'],
  'Lithox': ['NNP'],
  'Lithuanian': ['JJ'],
  'Lithuanians': ['NNPS'],
  'Litigants': ['NNS'],
  'Litigation': ['NNP'],
  'Litman\\\'/Gregory': ['NNP'],
  'Litowski': ['NNP'],
  'Litta': ['NNP'],
  'Littau': ['NNP'],
  'Littell': ['NNP'],
  'Little': ['NNP'],
  'Littleboy': ['NNP'],
  'Littlefield': ['NNP'],
  'Littlepage': ['NNP'],
  'Littleton': ['NNP'],
  'Littman': ['NNP'],
  'Litton': ['NNP'],
  'Litvack': ['NNP'],
  'Litvinchuk': ['NNP'],
  'Litz': ['NNP'],
  'Liu': ['NNP'],
  'Live': ['NNP'],
  'Live-In': ['NN'],
  'Lived': ['VBD'],
  'Livermore': ['NNP'],
  'Liverpool': ['NNP'],
  'Liverpudlians': ['NNPS'],
  'Livery': ['JJ'],
  'Lives': ['NNS'],
  'Livestock': ['NN'],
  'Living': ['NNP'],
  'Livingston': ['NNP'],
  'Livshitz': ['NNP'],
  'Liz': ['NNP'],
  'Liza': ['NNP'],
  'Lizhi': ['NNP'],
  'Lizt': ['NNP'],
  'Lizzie': ['NNP'],
  'Lizzy': ['NNP'],
  'Llewellyn': ['NNP'],
  'Llosa': ['NNP'],
  'Lloyd': ['NNP'],
  'Lloyds': ['NNP'],
  'Lmao': ['UH'],
  'Lo': ['NNP'],
  'Lo-Jack': ['NNP'],
  'LoSpam': ['NNP'],
  'Load': ['NN'],
  'Loan': ['NNP'],
  'Loan-loss': ['JJ'],
  'Loans': ['NNS'],
  'Loantech': ['NNP'],
  'Loathing': ['NN'],
  'Lobar': ['NNP'],
  'Lobby': ['NNP'],
  'Lobbying': ['NN'],
  'Lobbyist': ['NN'],
  'Lobbyists': ['NNS'],
  'Lobl': ['NNP'],
  'Lobo': ['NNP'],
  'Lobsenz': ['NNP'],
  'Lobster': ['NN'],
  'Lobularity': ['NN'],
  'Local': ['JJ'],
  'Localism': ['NN'],
  'Locally': ['RB'],
  'Locate': ['VB'],
  'Located': ['VBN'],
  'Location': ['NNP'],
  'Lock': ['NNP'],
  'Lock-Up': ['NN'],
  'Locke': ['NNP'],
  'Locked': ['VBN'],
  'Locker': ['NNP'],
  'Locker-room': ['NN'],
  'Lockerbie': ['NNP'],
  'Lockhart': ['NNP'],
  'Lockheed': ['NNP'],
  'Lockian': ['JJ'],
  'Lockies': ['NNPS'],
  'Locking': ['VBG'],
  'Lockman': ['NNP'],
  'Locks': ['NNP'],
  'Lockwood': ['NNP'],
  'Loco': ['NNP'],
  'Locust': ['NN'],
  'Lodestar': ['NNP'],
  'Lodge': ['NNP'],
  'Lodging': ['NN'],
  'Lodley': ['NNP'],
  'Lodowick': ['NNP'],
  'Loeb': ['NNP'],
  'Loen': ['NNP'],
  'Loeser': ['NNP'],
  'Loesser': ['NNP'],
  'Loevner': ['NNP'],
  'Loew': ['NNP'],
  'Loewe': ['NNP'],
  'Loewenson': ['NNP'],
  'Loewenstern': ['NNP'],
  'Loewi': ['NNP'],
  'Loews': ['NNP'],
  'Loewy': ['NNP'],
  'Loftier': ['JJR'],
  'Loftus': ['NNP'],
  'Logan': ['NNP'],
  'Loggia': ['NNP'],
  'Logging': ['NN'],
  'Logic': ['NNP'],
  'Logica': ['NNP'],
  'Logically': ['RB'],
  'Logistics': ['NNP'],
  'Logsdon': ['NNP'],
  'Lohman': ['NNP'],
  'Lohmans': ['NNP'],
  'Loire': ['NNP'],
  'Lois': ['NNP'],
  'Lojack': ['NNP'],
  'Lok': ['NNP'],
  'Lokey': ['NNP'],
  'Lol': ['UH'],
  'Lola': ['NNP'],
  'Lolita': ['NNP'],
  'Lollipops': ['NNS'],
  'Lolly': ['NNP'],
  'Lolotte': ['NNP'],
  'Loma': ['NNP'],
  'Loman': ['NNP'],
  'Lomas': ['NNP'],
  'Lomax': ['NNP'],
  'Lomb': ['NNP'],
  'Lombard': ['NNP'],
  'Lombarde': ['NNP'],
  'Lombardi': ['NNP'],
  'Lombardo': ['NNP'],
  'Lompoc': ['NNP'],
  'Lond.': ['NNP'],
  'Londe': ['NNP'],
  'London': ['NNP'],
  'London-based': ['JJ'],
  'London-bred': ['JJ'],
  'Londonderry': ['NNP'],
  'Londoner': ['NN'],
  'Londono': ['NNP'],
  'Londontowne': ['NNP'],
  'Lone': ['NNP'],
  'Loneliness': ['NNP'],
  'Lonesome': ['JJ'],
  'Loney': ['NNP'],
  'Long': ['NNP'],
  'Long-Term': ['NNP'],
  'Long-debated': ['JJ'],
  'Long-distance': ['NN'],
  'Long-haul': ['JJ'],
  'Long-lived': ['JJ'],
  'Long-range': ['JJ'],
  'Long-term': ['JJ'],
  'Longer': ['JJR'],
  'Longer-term': ['JJ'],
  'Longest': ['NNP'],
  'Longevity': ['NN'],
  'Longfellow': ['NNP'],
  'Longhorn': ['NNP'],
  'Longhorns': ['NNP'],
  'Longinotti': ['NNPS'],
  'Longley': ['NNP'],
  'Longman': ['NNP'],
  'Longmont': ['NNP'],
  'Longshoremen': ['NNS'],
  'Longstreet': ['NNP'],
  'Longtime': ['JJ'],
  'Longue': ['NNP'],
  'Longview': ['NNP'],
  'Longwood': ['NNP'],
  'Lonnie': ['NNP'],
  'Lonrho': ['NNP'],
  'Lonsdale': ['NNP'],
  'Lonski': ['NNP'],
  'Look': ['VB'],
  'Looked': ['VBD'],
  'Looking': ['VBG'],
  'Lookit': ['VB'],
  'Lookout': ['NNP'],
  'Looks': ['VBZ'],
  'Looky': ['VB'],
  'Loom': ['NNP'],
  'Loomans': ['NNP'],
  'Looming': ['VBG'],
  'Loomis': ['NNP'],
  'Loon': ['NNP'],
  'Loop': ['NNP'],
  'Loopholes': ['NNS'],
  'Loose': ['NNP'],
  'Loosli': ['NNP'],
  'Lopatnikoff': ['NNP'],
  'Loper': ['NNP'],
  'Lopez': ['NNP'],
  'Lopid': ['NNP'],
  'Lopukhov': ['NNP'],
  'Lora': ['NNP'],
  'Lorain': ['NNP'],
  'Loraine': ['NNP'],
  'Loral': ['NNP'],
  'Loran': ['NNP'],
  'Lorca': ['NNP'],
  'Lord': ['NNP'],
  'Lorde': ['NNP'],
  'Lords': ['NNPS'],
  'Lordstown': ['NNP'],
  'Lorelei': ['NNPS'],
  'Loren': ['NNP'],
  'Lorena': ['NNP'],
  'Lorentz': ['NNP'],
  'Lorenz': ['NNP'],
  'Lorenzo': ['NNP'],
  'Lorex': ['NNP'],
  'Lori': ['NNP'],
  'Lorillard': ['NNP'],
  'Lorimar': ['NNP'],
  'Lorin': ['NNP'],
  'Lorincze': ['NNP'],
  'Lorinda': ['NNP'],
  'Loring': ['NNP'],
  'Lorlyn': ['NNP'],
  'Lorna': ['NNP'],
  'Lorne': ['NNP'],
  'Lorrain': ['NNP'],
  'Lorraine': ['NNP'],
  'Lortie': ['NNP'],
  'Los': ['NNP'],
  'Losec': ['NNP'],
  'Loser': ['JJ'],
  'Losers': ['NNS'],
  'Loses': ['VBZ'],
  'Losing': ['VBG'],
  'Loss': ['NN'],
  'Losses': ['NNS'],
  'Lost': ['JJ'],
  'Lot': ['NN'],
  'Lothario': ['NN'],
  'Lothson': ['NNP'],
  'Lotos': ['NNP'],
  'Lots': ['NNS'],
  'Lott': ['NNP'],
  'Lotte': ['NNP'],
  'Lotteries': ['NNS'],
  'Lottery': ['NNP'],
  'Lottie': ['NNP'],
  'Lotus': ['NNP'],
  'Lou': ['NNP'],
  'Louchheim': ['NNP'],
  'Loud': ['JJ'],
  'Loudermilk': ['NNP'],
  'Loudon': ['NNP'],
  'Loudspeakers': ['NNS'],
  'Louella': ['NNP'],
  'Loughlin': ['NNP'],
  'Loughman': ['NNP'],
  'Louis': ['NNP'],
  'Louis-Dreyfus': ['NNP'],
  'Louis-based': ['JJ'],
  'Louisa': ['NNP'],
  'Louise': ['NNP'],
  'Louisiana': ['NNP'],
  'Louisiana-Pacific': ['NNP'],
  'Louisianan': ['NN'],
  'Louisiane': ['NNP'],
  'Louisville': ['NNP'],
  'Lounge': ['NNP'],
  'Lourie': ['NNP'],
  'Lousie': ['NNP'],
  'Lousiness': ['NN'],
  'Lousy': ['JJ'],
  'Louvre': ['NNP'],
  'Love': ['NNP'],
  'Lovejoy': ['NNP'],
  'Lovelace': ['NNP'],
  'Loveless': ['NNP'],
  'Lovell': ['NNP'],
  'Lovely': ['NNP'],
  'Lovenberg': ['NNP'],
  'Lover': ['NNP'],
  'Lovering': ['NNP'],
  'Lovers': ['NNPS'],
  'Loves': ['VBZ'],
  'Lovett': ['NNP'],
  'Loveways': ['NNP'],
  'Lovie': ['UH'],
  'Loving': ['NNP'],
  'Lovingly': ['RB'],
  'Lovingood': ['NNP'],
  'Lovington': ['NNP'],
  'Low': ['NNP'],
  'Low-Income': ['NNP'],
  'Low-flying': ['JJ'],
  'Low-interest-rate': ['JJ'],
  'Low-paying': ['JJ'],
  'Lowe': ['NNP'],
  'Lowell': ['NNP'],
  'Lowenstein': ['NNP'],
  'Lowenthal': ['NNP'],
  'Lower': ['JJR'],
  'Lower-than-expected': ['JJ'],
  'Lowery': ['NNP'],
  'Lown': ['NNP'],
  'Lowndes': ['NNP'],
  'Lowry': ['NNP'],
  'Loy': ['NNP'],
  'Loyal': ['JJ'],
  'Loyalist': ['JJ'],
  'Loyalties': ['NNS'],
  'Loyalty': ['NN'],
  'Loyola': ['NNP'],
  'Lt.': ['NNP'],
  'Ltd': ['NNP'],
  'Ltd.': ['NNP'],
  'Ltee': ['NNP'],
  'Lu': ['NNP'],
  'Luang': ['NNP'],
  'Lubar': ['NNP'],
  'Lubars': ['NNP'],
  'Lubberlanders': ['NNS'],
  'Lubbock': ['NNP'],
  'Lube': ['NNP'],
  'Lubell': ['NNP'],
  'Luber': ['NNP'],
  'Lubkin': ['NNP'],
  'Lublin': ['NNP'],
  'Lubowski': ['NNP'],
  'Lubriderm': ['NNP'],
  'Lubrizol': ['NNP'],
  'Lubyanka': ['NNP'],
  'Luc': ['NNP'],
  'Lucas': ['NNP'],
  'Lucassen': ['NNP'],
  'Lucca': ['NNP'],
  'Luce': ['NNP'],
  'Lucerne': ['NNP'],
  'Luci': ['NNP'],
  'Lucia': ['NNP'],
  'Lucian': ['NNP'],
  'Luciano': ['NNP'],
  'Lucie': ['NNP'],
  'Lucien': ['NNP'],
  'Lucifer': ['NNP'],
  'Lucille': ['NNP'],
  'Lucinda': ['NNP'],
  'Lucio': ['NNP'],
  'Lucisano': ['NNP'],
  'Lucite': ['NNP'],
  'Lucius': ['NNP'],
  'Luck': ['NNP'],
  'Luckily': ['RB'],
  'Lucky': ['NNP'],
  'Lucky-Goldstar': ['NNP'],
  'Lucretia': ['NNP'],
  'Lucretius': ['NNP'],
  'Lucullan': ['JJ'],
  'Lucy': ['NNP'],
  'Ludcke': ['NNP'],
  'Ludden': ['NNP'],
  'Ludie': ['NNP'],
  'Ludlow': ['NNPS'],
  'Ludlum': ['NNP'],
  'Ludmilla': ['NNP'],
  'Ludwick': ['NNP'],
  'Ludwig': ['NNP'],
  'Ludwigshafen': ['NNP'],
  'Ludwin': ['NNP'],
  'Luechtefeld': ['NNP'],
  'Lueger': ['NNP'],
  'Luehrs': ['NNP'],
  'Luerssen': ['NNP'],
  'Luette': ['NNP'],
  'Lufkin': ['NNP'],
  'Luft': ['NNP'],
  'Luftfahrt': ['NNP'],
  'Lufthansa': ['NNP'],
  'Luftwaffe': ['NNP'],
  'Lugar': ['NNP'],
  'Luger': ['NNP'],
  'Lugosi': ['NNP'],
  'Luigi': ['NNS'],
  'Luis': ['NNP'],
  'Luisa': ['NNP'],
  'Luise': ['NNP'],
  'Lujan': ['NNP'],
  'Lukas': ['NNP'],
  'Lukassen': ['NNP'],
  'Luke': ['NNP'],
  'Lukens': ['NNP'],
  'Lukman': ['NNP'],
  'Luksik': ['NNP'],
  'Lukuklu': ['NNP'],
  'Lullaby': ['NN'],
  'Lullwater': ['NNP'],
  'Lully': ['NNP'],
  'Lumber': ['NNP'],
  'Lumbera': ['NNP'],
  'Lumex': ['NNP'],
  'Lumia': ['NNP'],
  'Lumiere': ['NNP'],
  'Lumina': ['NNP'],
  'Lummus': ['NNP'],
  'Lumpe': ['NNP'],
  'Lumped': ['VBN'],
  'Lumpur': ['NNP'],
  'Lumsden': ['NNP'],
  'Lumumba': ['NNP'],
  'Luna': ['NNP'],
  'Lunch': ['NN'],
  'Luncheon': ['NNP'],
  'Lund': ['NNP'],
  'Lunday': ['NNP'],
  'Lundberg': ['NNP'],
  'Lundeen': ['NNP'],
  'Lundy': ['NNP'],
  'Luneburg': ['NNP'],
  'Lung': ['NNP'],
  'Lung-cancer': ['NN'],
  'Lunge': ['NNP'],
  'Lupatkin': ['NNP'],
  'Lupe': ['NNP'],
  'Lupel': ['NNP'],
  'Lupo': ['NNP'],
  'Lupton': ['NNP'],
  'Lura': ['NNP'],
  'Luray': ['NNP'],
  'Lurcat': ['NNP'],
  'Lure': ['VBP'],
  'Lureen': ['NNP'],
  'Lurgi': ['NNP'],
  'Lurie': ['NNP'],
  'Lusaka': ['NNP'],
  'Lusignan': ['NNP'],
  'Lusser': ['NNP'],
  'Lust': ['NNP'],
  'Lustgarten': ['NNP'],
  'Luth': ['NNP'],
  'Luther': ['NNP'],
  'Lutheran': ['NNP'],
  'Luthringshausen': ['NNP'],
  'Luthuli': ['NNP'],
  'Lutsenko': ['NNP'],
  'Lutte': ['NNP'],
  'Lutz': ['NNP'],
  'Luvs': ['NNPS'],
  'Lux': ['FW'],
  'Luxco': ['NNP'],
  'Luxembourg': ['NNP'],
  'Luxembourg-based': ['JJ'],
  'Luxembourg-registered': ['JJ'],
  'Luxemburg': ['NNP'],
  'Luxor': ['NNP'],
  'Luxuries': ['NNP'],
  'Luxurious': ['JJ'],
  'Luxury': ['NN'],
  'Luz': ['NNP'],
  'Luzon': ['NNP'],
  'Lvov': ['NNP'],
  'Lvovna': ['NNP'],
  'Lyaki': ['NNP'],
  'Lybrand': ['NNP'],
  'Lyceum': ['NNP'],
  'Lycidas': ['NNP'],
  'Lycra': ['NNP'],
  'Lydall': ['NNP'],
  'Lydia': ['NNP'],
  'Lyford': ['NNP'],
  'Lying': ['VBG'],
  'Lyle': ['NNP'],
  'Lyman': ['NNP'],
  'Lyme': ['NNP'],
  'Lyme-disease': ['JJ'],
  'Lymington': ['NNP'],
  'Lyn': ['NNP'],
  'Lynch': ['NNP'],
  'Lynch-led': ['JJ'],
  'Lynchburg': ['NNP'],
  'Lynde': ['NNP'],
  'Lynden': ['NNP'],
  'Lyndhurst': ['NNP'],
  'Lyndon': ['NNP'],
  'Lynes': ['NNP'],
  'Lyneses': ['NNP'],
  'Lynford': ['NNP'],
  'Lynn': ['NNP'],
  'Lynne': ['NNP'],
  'Lynnwood': ['NNP'],
  'Lynx': ['NNP'],
  'Lyon': ['NNP'],
  'Lyondell': ['NNP'],
  'Lyonnais': ['NNP'],
  'Lyons': ['NNP'],
  'Lyphomed': ['NNP'],
  'Lyric': ['NNP'],
  'Lyrics': ['NNS'],
  'Lys': ['NNP'],
  'Lysle': ['NNP'],
  'Lysol': ['NNP'],
  'Lyster': ['NNP'],
  'Lyttleton': ['NNP'],
  'Lytton': ['NNP'],
  'Lyubov': ['NNP'],
  'M': ['NNP'],
  'M\$': ['\$'],
  'M&A': ['NNP'],
  'M&H': ['NNP'],
  'M&Ms': ['NNS'],
  'M\'Bow': ['NNP'],
  'M-1': ['NNP'],
  'M-19': ['NN'],
  'M-4': ['NNP'],
  'M-CSF': ['NNP'],
  'M-K': ['NNP'],
  'M-Whatever': ['NNP'],
  'M-m-m': ['UH'],
  'M.': ['NNP'],
  'M.A.': ['NNP'],
  'M.B.A.': ['NNP'],
  'M.B.A.s': ['NNPS'],
  'M.C.': ['NNP'],
  'M.D': ['NNP'],
  'M.D.': ['NNP'],
  'M.D.-speak': ['JJ'],
  'M.D.C': ['NNP'],
  'M.D.C.': ['NNP'],
  'M.D.s': ['NNS'],
  'M.E.': ['NNP'],
  'M.Ed': ['NNP'],
  'M.G.': ['NNP'],
  'M.I.M.': ['NNP'],
  'M.I.T.-trained': ['JJ'],
  'M.J.': ['NNP'],
  'M.L.': ['NNP'],
  'M.P.': ['NNP'],
  'M.R.': ['NNP'],
  'M.S.': ['NNP'],
  'M.T.': ['NNP'],
  'M.W.': ['NNP'],
  'M2': ['CD'],
  'M3': ['CD'],
  'M30': ['NNP'],
  'M4': ['NNP'],
  'M8.7sp': ['NNP'],
  'MAC': ['NNP'],
  'MACHINES': ['NNP'],
  'MACMILLAN': ['NNP'],
  'MACPOST': ['NNP'],
  'MACY': ['NNP'],
  'MADD': ['NNP'],
  'MAGURNO': ['NNP'],
  'MAI': ['NNP'],
  'MAILINGS': ['NNS'],
  'MAINTENANCE': ['NNP'],
  'MAITRE\'D': ['NNP'],
  'MAJOR': ['JJ'],
  'MAKE': ['VB'],
  'MAKERS': ['NNS'],
  'MAKES': ['VBZ'],
  'MAKING': ['VBG'],
  'MALAISE': ['NNP'],
  'MAN': ['NNP'],
  'MANAGEMENT': ['NNP'],
  'MANAGER': ['NN'],
  'MANAGERS': ['NNS'],
  'MANEUVERS': ['NNS'],
  'MANHATTAN': ['NNP'],
  'MANUALS': ['NNS'],
  'MANUFACTURERS': ['NNPS'],
  'MANUFACTURING': ['NNP'],
  'MANY': ['JJ'],
  'MAPCO': ['NNP'],
  'MARCHED': ['VBD'],
  'MARCOS': ['NNP'],
  'MARCUS': ['NNP'],
  'MARGIN': ['NN'],
  'MARK': ['NNP'],
  'MARKET': ['NNP'],
  'MARKETING': ['NN'],
  'MARKS': ['NNS'],
  'MARYLAND': ['NNP'],
  'MAT': ['NNP'],
  'MATERIALS': ['NNP'],
  'MATTEL': ['NNP'],
  'MAY': ['MD'],
  'MB': ['NNP'],
  'MB-339': ['NNP'],
  'MBA': ['NN'],
  'MBAs': ['NNS'],
  'MBB': ['NNP'],
  'MBE': ['NNP'],
  'MBI': ['NNP'],
  'MBIA': ['NNP'],
  'MBK': ['NNP'],
  'MBOs': ['NNPS'],
  'MC': ['NNP'],
  'MC68030': ['NNP'],
  'MC88200': ['NNP'],
  'MCA': ['NNP'],
  'MCC': ['NNP'],
  'MCI': ['NNP'],
  'MCV': ['NNP'],
  'MCorp': ['NNP'],
  'MD-11': ['NNP'],
  'MD-80': ['NN'],
  'MD-80-series': ['NN'],
  'MD-80s': ['NNS'],
  'MD-81': ['NN'],
  'MD-82s': ['NNPS'],
  'MD-90': ['NN'],
  'MD-90s': ['NNS'],
  'MD11': ['NNP'],
  'MD90': ['NN'],
  'MDC': ['NNP'],
  'MDL-1': ['NN'],
  'MDT': ['NNP'],
  'ME': ['PRP'],
  'MEA': ['NNP'],
  'MEASUREX': ['NNP'],
  'MEATS': ['NNPS'],
  'MEDIA': ['NNP'],
  'MEDICINE': ['NNP'],
  'MEDUSA': ['NNP'],
  'MEI': ['NNP'],
  'MEMOS': ['NNS'],
  'MEN': ['NNS'],
  'MERCHANTS': ['NNPS'],
  'MERGER': ['NN'],
  'MERGING': ['VBG'],
  'MERRILL': ['NNP'],
  'MET': ['VBD'],
  'METALS': ['NNS'],
  'MEXICAN': ['JJ'],
  'MEXICO': ['NNP'],
  'MF': ['NNP'],
  'MFA': ['NNP'],
  'MFS': ['NNP'],
  'MG': ['NNP'],
  'MGM': ['NNP'],
  'MGM-UA': ['NNP'],
  'MGM\\\'': ['NNP'],
  'MGM\\\'/UA': ['NNP'],
  'MH-60K': ['NN'],
  'MHz': ['NNS'],
  'MICRO': ['NNP'],
  'MICROPOLIS': ['NNP'],
  'MICROSYSTEMS': ['NNP'],
  'MIDDLEMAN': ['NN'],
  'MIDLANTIC': ['NNP'],
  'MIG-1': ['JJ'],
  'MIG-1\\\'': ['JJ'],
  'MIG-2': ['JJ'],
  'MIG-2\\\'': ['NN'],
  'MIGHT': ['MD'],
  'MILEAGE': ['NN'],
  'MINIMUM-WAGE': ['NN'],
  'MINING': ['NNP'],
  'MINISTER': ['NN'],
  'MINISTER\'S': ['NN'],
  'MINOR': ['JJ'],
  'MINORITY': ['NN'],
  'MIPS': ['NNP'],
  'MIPS-based': ['JJ'],
  'MIPs': ['NNP'],
  'MISFIRE': ['NN'],
  'MISUSE': ['NNP'],
  'MIServer': ['NNP'],
  'MIT': ['NNP'],
  'MITI': ['NNP'],
  'MJ': ['NNP'],
  'MK-Ferguson': ['NNP'],
  'MKI': ['NNP'],
  'MLD': ['NNP'],
  'MLPI': ['NNP'],
  'MLR': ['NNP'],
  'MLSS': ['NN'],
  'MLX': ['NNP'],
  'MMC': ['NNP'],
  'MMG': ['NNP'],
  'MMI': ['NNP'],
  'MMS': ['NNP'],
  'MNB': ['NNP'],
  'MNC': ['NNP'],
  'MO': ['NNP'],
  'MOB': ['NNP'],
  'MOHAWK': ['NNP'],
  'MONEY': ['NN'],
  'MONITORED': ['VBD'],
  'MONTHLY': ['JJ'],
  'MORE': ['JJR'],
  'MORGAN': ['NNP'],
  'MORTGAGE': ['NNP'],
  'MOST': ['JJS'],
  'MOTOR': ['NNP'],
  'MOTORISTS': ['NNS'],
  'MOTORS': ['NNP'],
  'MOVE': ['NN'],
  'MOVED': ['VBD'],
  'MOVES': ['VBZ'],
  'MP': ['NNP'],
  'MPD': ['NNP'],
  'MPH': ['NNP'],
  'MPI': ['NNP'],
  'MPl': ['NNP'],
  'MPs': ['NNS'],
  'MR': ['NNP'],
  'MRA': ['NNP'],
  'MRC': ['NNP'],
  'MRCA': ['NNP'],
  'MRI': ['NNP'],
  'MRI-type': ['JJ'],
  'MS': ['NNP'],
  'MS-DOS': ['NNP'],
  'MSD-200': ['NNP'],
  'MSP': ['NNP'],
  'MSU': ['NNP'],
  'MSX': ['NNP'],
  'MSX-run': ['JJ'],
  'MTCR': ['NNP'],
  'MTM': ['NNP'],
  'MTU': ['NNP'],
  'MTV': ['NNP'],
  'MUBARAK\'S': ['NNP'],
  'MUMBO': ['NN'],
  'MUNICIPALS': ['NNS'],
  'MURDER': ['NN'],
  'MUST': ['MD'],
  'MUST-SIGN': ['JJ'],
  'MUTUAL': ['JJ'],
  'MV40000': ['NN'],
  'MVL': ['NNP'],
  'MVP': ['NNP'],
  'MVestment': ['NNP'],
  'MX': ['NNP'],
  'MX-6': ['NNP'],
  'MX-6s': ['NNPS'],
  'MX-missile': ['NN'],
  'MY': ['DT'],
  'MYERSON': ['NNP'],
  'MYSTERY': ['NNP'],
  'M\\\'*A\\\'*S\\\'*H': ['NNP'],
  'M\\\'/A-Com': ['NNP'],
  'M\\\'/I': ['NNP'],
  'Ma': ['NNP'],
  'Ma\'am': ['NNP'],
  'Maack': ['NNP'],
  'Maalox': ['NNP'],
  'Maanen': ['NNP'],
  'Mabellini': ['NNP'],
  'Mabon': ['NNP'],
  'Mac': ['NNP'],
  'Mac-Laren': ['NNP'],
  'Mac-Reynolds': ['NNP'],
  'MacAllister': ['NNP'],
  'MacAndrews': ['NNP'],
  'MacArthur': ['NNP'],
  'MacArthur-Helen': ['NNP'],
  'MacDonald': ['NNP'],
  'MacDougall': ['NNP'],
  'MacDowell': ['NNP'],
  'MacFarlanes': ['NNP'],
  'MacGregor': ['NNP'],
  'MacGregors': ['NNPS'],
  'MacGyver': ['NNP'],
  'MacInnis': ['NNP'],
  'MacIsaacs': ['NNP'],
  'MacKinnon': ['NNP'],
  'MacLean': ['NNP'],
  'MacLeishes': ['NNPS'],
  'MacLellan': ['NNP'],
  'MacMillan': ['NNP'],
  'MacNamara': ['NNP'],
  'MacNeil-Lehrer': ['NNP'],
  'MacNeil\\\'': ['NNP'],
  'MacNeil\\\'/Lehrer': ['NNP'],
  'MacPhail': ['NNP'],
  'MacPherson': ['NNP'],
  'MacReady': ['NNP'],
  'MacSharry': ['NNP'],
  'MacWeek': ['NNP'],
  'MacWhorter': ['NNP'],
  'Macao': ['NNP'],
  'Macare': ['NNP'],
  'Macari': ['NNP'],
  'Macaroni': ['NNP'],
  'Macassar': ['NNP'],
  'Macaulay': ['NNP'],
  'Macbeth': ['NNP'],
  'Maccabee': ['NNP'],
  'Maccabeus': ['NNP'],
  'Maccaquano': ['NNP'],
  'Maccario': ['NNP'],
  'Macchiarola': ['NNP'],
  'Mace': ['NNP'],
  'Macedon': ['NNP'],
  'Macel': ['NNP'],
  'Macfadden': ['NNP'],
  'Macfarlane': ['NNP'],
  'Mach': ['NN'],
  'Mach\'t': ['FW'],
  'Machado': ['NNP'],
  'Machelle': ['NNP'],
  'Macheski': ['NNP'],
  'Machiavelli': ['NNP'],
  'Machiavellian': ['JJ'],
  'Machida': ['NNP'],
  'Machiguenga': ['NNP'],
  'Machiguengas': ['NNS'],
  'Machine': ['NNP'],
  'Machine-tool': ['JJ'],
  'Machine-vision': ['JJ'],
  'Machineries': ['NNP'],
  'Machinery': ['NNP'],
  'Machines': ['NNPS'],
  'Machinist': ['NNP'],
  'Machinist-union': ['NNP'],
  'Machinists': ['NNS'],
  'Macho': ['FW'],
  'Machold': ['NNP'],
  'Machon': ['NNP'],
  'Machos': ['FW'],
  'Macintosh': ['NNP'],
  'Mack': ['NNP'],
  'Mackenzie': ['NNP'],
  'Mackey': ['NNP'],
  'Mackinac': ['NNP'],
  'Mackinack': ['NNP'],
  'Macklin': ['NNP'],
  'Macksey': ['NNP'],
  'Maclaine': ['NNP'],
  'Maclean': ['NNP'],
  'Macmillan': ['NNP'],
  'Macmillan\\\'': ['NNP'],
  'Macmillan\\\'/McGraw': ['NNP'],
  'Macmillan\\\'/McGraw-Hill': ['NNP'],
  'Macneff': ['NNP'],
  'Macomber': ['NNP'],
  'Macon': ['NNP'],
  'Macquarie': ['NNP'],
  'MacroChem': ['NNP'],
  'Macrodantin': ['NNP'],
  'Macropathological': ['NNP'],
  'Macropathology': ['NN'],
  'Macrophages': ['NNS'],
  'Macwhyte': ['NNP'],
  'Macy': ['NNP'],
  'Mad': ['NNP'],
  'Madagascar': ['NNP'],
  'Madam': ['NNP'],
  'Madama': ['NNP'],
  'Madame': ['NNP'],
  'Madaripur': ['NNP'],
  'Maddalena': ['NNP'],
  'Madden': ['NNP'],
  'Maddie': ['NNP'],
  'Madding': ['NNP'],
  'Maddox': ['NNP'],
  'Maddry': ['NNP'],
  'Made': ['VBN'],
  'Madeira': ['NNP'],
  'Madeleine': ['NNP'],
  'Madelon': ['NNP'],
  'Mademoiselle': ['NNP'],
  'Madison': ['NNP'],
  'Madonna': ['NNP'],
  'Madre': ['NNP'],
  'Madrid': ['NNP'],
  'Madrid-based': ['JJ'],
  'Madrigal': ['NNP'],
  'Madsen': ['NNP'],
  'Madson': ['NNP'],
  'Mae': ['NNP'],
  'Mae-backed': ['JJ'],
  'Maecker': ['NNP'],
  'Maeda': ['NNP'],
  'Maersk': ['NNP'],
  'Maestro': ['NNP'],
  'Maeterlinck': ['NNP'],
  'Maffei': ['NNP'],
  'Mafia': ['NNP'],
  'Mafia-tainted': ['JJ'],
  'Mag': ['NNP'],
  'Magadan': ['NNP'],
  'Magarity': ['NNP'],
  'Magarrell': ['NNP'],
  'Magazine': ['NNP'],
  'Magazines': ['NNS'],
  'Magdalena': ['NNP'],
  'Magdalene': ['NNP'],
  'Maged': ['NNP'],
  'Magee': ['NNP'],
  'Magellan': ['NNP'],
  'Mager': ['NNP'],
  'Maggart': ['NNP'],
  'Maggetto': ['NNP'],
  'Maggie': ['NNP'],
  'Maggot': ['NNP'],
  'Magi': ['NNP'],
  'Magic': ['NNP'],
  'Magleby': ['NNP'],
  'Magma': ['NNP'],
  'Magna': ['NNP'],
  'Magnascreen': ['NNP'],
  'Magnatek': ['NNP'],
  'Magnavox': ['NNP'],
  'Magnet': ['NNP'],
  'Magnetic': ['JJ'],
  'Magnetics': ['NNPS'],
  'Magnetism': ['NNP'],
  'Magnier': ['NNP'],
  'Magnificent': ['JJ'],
  'Magnin': ['NNP'],
  'Magnolias': ['NNS'],
  'Magnum': ['NN'],
  'Magnums': ['NNS'],
  'Magnus': ['NNP'],
  'Magnusson': ['NNP'],
  'Magog': ['NNP'],
  'Magoon': ['NNP'],
  'Magoun': ['NNP'],
  'Magpie': ['NNP'],
  'Magruder': ['NNP'],
  'Magten': ['NNP'],
  'Maguire': ['NNP'],
  'Maguires': ['NNPS'],
  'Magurno': ['NNP'],
  'Magwitch': ['NNP'],
  'Mahagonny': ['NNP'],
  'Mahal': ['NNP'],
  'Mahal-flavor': ['NNP'],
  'Mahan': ['NNP'],
  'Maharashtra': ['NNP'],
  'Mahathir': ['NNP'],
  'Mahatma': ['NNP'],
  'Mahayana': ['NNP'],
  'Mahayanist': ['NN'],
  'Mahe': ['NNP'],
  'Maher': ['NNP'],
  'Mahfouz': ['NNP'],
  'Mahler': ['NNP'],
  'Mahmoud': ['NNP'],
  'Mahoganny': ['NNP'],
  'Mahone': ['NNP'],
  'Mahoney': ['NNP'],
  'Mahran': ['NNP'],
  'Mahwah': ['NNP'],
  'Mahzeer': ['NNP'],
  'Mai': ['NNP'],
  'Maid': ['NNP'],
  'Maiden': ['NNP'],
  'Maidenform': ['NNP'],
  'Maidens': ['NNPS'],
  'Maier': ['NNP'],
  'Mail': ['NNP'],
  'Mail-Order': ['JJ'],
  'Mail-order': ['NN'],
  'Mailer': ['NNP'],
  'Mailing': ['NNP'],
  'Mailings': ['NNS'],
  'Mailloux': ['NNP'],
  'Mailson': ['NNP'],
  'Main': ['NNP'],
  'Main-d\'Oeuvre': ['NNP'],
  'Maine': ['NNP'],
  'Mainland': ['NNP'],
  'Mainliner-Highland': ['NNP'],
  'Mainly': ['RB'],
  'Mainstay': ['NN'],
  'Mainstream': ['NN'],
  'Maintain': ['VBP'],
  'Maintaining': ['VBG'],
  'Maintenance': ['NNP'],
  'Mainz': ['NNP'],
  'Maiorana': ['NNP'],
  'Mais': ['FW'],
  'Maitland': ['NNP'],
  'Maitres': ['NNP'],
  'Maize': ['NNP'],
  'Maize-Products': ['NNPS'],
  'Maj.': ['NNP'],
  'Majdan-Tartarski': ['NNP'],
  'Majdanek': ['NNP'],
  'Majestic': ['NNP'],
  'Majesties': ['NNPS'],
  'Majesty': ['NNP'],
  'Major': ['NNP'],
  'Major-League': ['NNP'],
  'Majority': ['NNP'],
  'Makato': ['NNP'],
  'Make': ['VB'],
  'Makepeace': ['NNP'],
  'Maker': ['NN'],
  'Makers': ['NNPS'],
  'Makes': ['VBZ'],
  'Makin': ['NNP'],
  'Makinac': ['NNP'],
  'Making': ['VBG'],
  'Makoto': ['NNP'],
  'Makro': ['NNP'],
  'Maksoud': ['NNP'],
  'Makwah': ['NNP'],
  'Mal': ['NNP'],
  'Malabar': ['NNP'],
  'Malacca': ['NNP'],
  'Malamud': ['NNP'],
  'Malapai': ['NNP'],
  'Malapi': ['NNP'],
  'Malaria': ['NN'],
  'Malato': ['NNP'],
  'Malawi': ['NNP'],
  'Malay': ['NNP'],
  'Malay-based': ['JJ'],
  'Malays': ['NNP'],
  'Malaysia': ['NNP'],
  'Malaysian': ['JJ'],
  'Malaysian-based': ['JJ'],
  'Malcolm': ['NNP'],
  'Malcom': ['NNP'],
  'Malden': ['NNP'],
  'Maldutis': ['NNP'],
  'Male': ['JJ'],
  'Malec': ['NNP'],
  'Malek': ['NNP'],
  'Malenkov': ['NNP'],
  'Males': ['NNPS'],
  'Malesherbes': ['NNP'],
  'Mali': ['NNP'],
  'Malia': ['NNP'],
  'Malibu': ['NNP'],
  'Malignant': ['NN'],
  'Malik': ['NNP'],
  'Malin': ['NNP'],
  'Malinovsky': ['NNP'],
  'Malizia': ['NNP'],
  'Malknecht': ['NNP'],
  'Malkovich': ['NNP'],
  'Mall': ['NNP'],
  'Mallet-Prevost': ['NNP'],
  'Mallinckrodt': ['NNP'],
  'Mallory': ['NNP'],
  'Malloy': ['NNP'],
  'Malmesbury': ['NNP'],
  'Malmo': ['NNP'],
  'Malmros': ['NNP'],
  'Malmud': ['NNP'],
  'Malocclusion': ['NN'],
  'Malone': ['NNP'],
  'Maloney': ['NNP'],
  'Maloof': ['NNP'],
  'Malott': ['NNP'],
  'Malpass': ['NNP'],
  'Malpede': ['NNP'],
  'Malpractice': ['NN'],
  'Malraux': ['NNP'],
  'Malson': ['NNP'],
  'Malt': ['NNP'],
  'Malta': ['NNP'],
  'Maltese': ['NNP'],
  'Maluf': ['NNP'],
  'Malvenius': ['NNP'],
  'Malvern': ['NNP'],
  'Mama': ['NNP'],
  'Mamaroneck': ['NNP'],
  'Mambelli': ['NNP'],
  'Mambo': ['NNP'],
  'Mame': ['NNP'],
  'Mamma': ['NNP'],
  'Mammograms': ['NNS'],
  'Man': ['NN'],
  'Man-Made': ['JJ'],
  'Mana': ['NNP'],
  'Manac': ['NNP'],
  'Manafort': ['NNP'],
  'Managed': ['VBN'],
  'Management': ['NNP'],
  'Management\\\'': ['JJ'],
  'Manager': ['NNP'],
  'Managerial': ['JJ'],
  'Managers': ['NNS'],
  'Managing': ['NNP'],
  'Managua': ['NNP'],
  'Manaifatturiera': ['NNP'],
  'Manalapan': ['NNP'],
  'Manas': ['NNP'],
  'Manassas': ['NNP'],
  'Manchester': ['NNP'],
  'Mancini': ['NNP'],
  'Mancuso': ['NNP'],
  'Mandarin': ['NNP'],
  'Mandate': ['NN'],
  'Mandel': ['NNP'],
  'Mandela': ['NNP'],
  'Mandelbaum': ['NNP'],
  'Mandell': ['NNP'],
  'Manderbach': ['NNP'],
  'Manderscheid': ['NNP'],
  'Mandhata': ['NNP'],
  'Mandina': ['NNP'],
  'Mandle': ['NNP'],
  'Mando': ['NNP'],
  'Mandolin': ['NNP'],
  'Mandom': ['NNP'],
  'Mandresh': ['NNP'],
  'Mandy': ['NNP'],
  'Maneret': ['NNP'],
  'Manet': ['NNP'],
  'Maneuvers': ['NNS'],
  'Manfred': ['NNP'],
  'Manganese': ['NNP'],
  'Mangano': ['NNP'],
  'Manger': ['NNP'],
  'Manges': ['NNP'],
  'Mangino': ['NNP'],
  'Manhattan': ['NNP'],
  'Manhattan-based': ['JJ'],
  'Maniago': ['NNP'],
  'Manic': ['NNP'],
  'Manifatture': ['NNP'],
  'Maniffature': ['NNP'],
  'Manigat': ['NNP'],
  'Manila': ['NNP'],
  'Manila-based': ['JJ'],
  'Manin': ['NNP'],
  'Manion': ['NNP'],
  'Manitoba': ['NNP'],
  'Manitoba-based': ['JJ'],
  'Manjucri': ['NNP'],
  'Mankiewicz': ['NNP'],
  'Mankind': ['NNP'],
  'Manko': ['NNP'],
  'Mankowski': ['NNP'],
  'Manley': ['NNP'],
  'Manlove': ['NNP'],
  'Manly': ['NNP'],
  'Mann': ['NNP'],
  'Manned': ['NNP'],
  'Mannerhouse': ['NNP'],
  'Manners': ['NNP'],
  'Mannesmann': ['NNP'],
  'Mannheim': ['NNP'],
  'Manning': ['NNP'],
  'Manningham': ['NNP'],
  'Mannington': ['NNP'],
  'Mannix': ['NNP'],
  'Manny': ['NNP'],
  'Manon': ['NNP'],
  'Manoplax': ['NNP'],
  'Manor': ['NNP'],
  'Manos': ['NNP'],
  'Manpower': ['NNP'],
  'Mansfield': ['NNP'],
  'Mansion': ['NNP'],
  'Manske': ['NNP'],
  'Manson': ['NNP'],
  'Mantegna': ['NNP'],
  'Mantha': ['NNP'],
  'Manthey': ['NNP'],
  'Mantle': ['NNP'],
  'Mantua': ['NNP'],
  'Manu': ['NNP'],
  'Manual': ['JJ'],
  'Manuel': ['NNP'],
  'Manuela': ['NNP'],
  'Manufacture': ['NN'],
  'Manufactured': ['JJ'],
  'Manufacturer': ['NNP'],
  'Manufacturers': ['NNPS'],
  'Manufacturing': ['NNP'],
  'Manuscript': ['NNP'],
  'Manute': ['NNP'],
  'Manville': ['NNP'],
  'Many': ['JJ'],
  'Manya': ['NNP'],
  'Manzanec': ['NNP'],
  'Manzanola': ['NNP'],
  'Manzella': ['NNP'],
  'Manzi': ['NNP'],
  'Manzoni': ['NNP'],
  'Mao': ['NNP'],
  'Maoist': ['JJ'],
  'Maoist-style': ['JJ'],
  'Maoists': ['NNPS'],
  'Map': ['NNP'],
  'Mapco': ['NNP'],
  'Maple': ['NNP'],
  'Maplecrest': ['NNP'],
  'Mapplethorpe': ['NNP'],
  'Maquet': ['NNP'],
  'Maquila': ['NN'],
  'Maquilas': ['NNP'],
  'Mar': ['NNP'],
  'Mar.': ['NNP'],
  'MarCor': ['NNP'],
  'Mara': ['NNP'],
  'Marantz': ['NNP'],
  'Marathon': ['NNP'],
  'Marble': ['NNP'],
  'Marc': ['NNP'],
  'Marcel': ['NNP'],
  'Marcella': ['NNP'],
  'Marcello': ['NNP'],
  'Marcellus': ['NNP'],
  'March': ['NNP'],
  'Marchand': ['NNP'],
  'Marche': ['NNP'],
  'Marchers': ['NNPS'],
  'Marches': ['NNPS'],
  'Marchese': ['NNP'],
  'Marching': ['NNP'],
  'Marcia': ['NNP'],
  'Marciano': ['NNP'],
  'Marcile': ['NNP'],
  'Marcilio': ['NNP'],
  'Marcius': ['NNP'],
  'Marckesano': ['NNP'],
  'Marcmann': ['NNP'],
  'Marco': ['NNP'],
  'Marcom': ['NNP'],
  'Marconi': ['NNP'],
  'Marcor': ['NNP'],
  'Marcos': ['NNP'],
  'Marcoses': ['NNPS'],
  'Marcus': ['NNP'],
  'Marcy': ['NNP'],
  'Marder': ['NNP'],
  'Mardi': ['NNP'],
  'Mardis': ['NNP'],
  'Mardon': ['NNP'],
  'Mare': ['NNP'],
  'Mareb': ['NNP'],
  'Mareham': ['NNP'],
  'Marella': ['NNP'],
  'Marenzio': ['NNP'],
  'Marer': ['NNP'],
  'Margaret': ['NNP'],
  'Margaretville': ['NN'],
  'Margarito': ['NNP'],
  'Margaux': ['NNP'],
  'Marge': ['NNP'],
  'Margenau': ['NNP'],
  'Margeotes': ['NNP'],
  'Margery': ['NNP'],
  'Margie': ['NNP'],
  'Margin': ['NN'],
  'Marginal': ['JJ'],
  'Margins': ['NNS'],
  'Margler': ['NNP'],
  'Margo': ['NNP'],
  'Margolin': ['NNP'],
  'Margolis': ['NNP'],
  'Margret': ['NNP'],
  'Marguerite': ['NNP'],
  'Margulies': ['NNP'],
  'Maria': ['NNP'],
  'Mariam': ['NNP'],
  'Marian': ['NNP'],
  'Mariana': ['NNP'],
  'Mariano': ['NNP'],
  'Marico': ['NNP'],
  'Maricopa': ['NNP'],
  'Marie': ['NNP'],
  'Marie-Louise': ['NNP'],
  'Mariel': ['NNP'],
  'Marietta': ['NNP'],
  'Marijuana': ['NN'],
  'Marilee': ['NNP'],
  'Marilyn': ['NNP'],
  'Marin': ['NNP'],
  'Marina': ['NNP'],
  'Marinaro': ['NNP'],
  'Marinas': ['NNS'],
  'Marine': ['NNP'],
  'Mariners': ['NNPS'],
  'Marines': ['NNPS'],
  'Marino': ['NNP'],
  'Marinvest': ['NNP'],
  'Mario': ['NNP'],
  'Marion': ['NNP'],
  'Mariotta': ['NNP'],
  'Maris': ['NNP'],
  'Marist': ['NNP'],
  'Maritain': ['NNP'],
  'Maritime': ['NNP'],
  'Marjorie': ['NNP'],
  'Mark': ['NNP'],
  'Markel': ['NNP'],
  'Markese': ['NNP'],
  'Market': ['NNP'],
  'Market-If-Touched': ['NNP'],
  'Market-based': ['JJ'],
  'Market-if-touched': ['JJ'],
  'Market-leader': ['NN'],
  'Market-research': ['NN'],
  'Marketed': ['VBN'],
  'Marketers': ['NNS'],
  'Marketing': ['NNP'],
  'Marketplace': ['NNP'],
  'Markets': ['NNPS'],
  'Markey': ['NNP'],
  'Markham': ['NNP'],
  'Markoe': ['NNP'],
  'Markovic': ['NNP'],
  'Markovitz': ['NNP'],
  'Markowitz': ['NNP'],
  'Markrud': ['NNP'],
  'Marks': ['NNP'],
  'Marksmanship': ['NN'],
  'Markus': ['NNP'],
  'Marla': ['NNP'],
  'Marlboro': ['NNP'],
  'Marlboros': ['NNPS'],
  'Marlborough': ['NNP'],
  'Marlene': ['NNP'],
  'Marley': ['NNP'],
  'Marlin': ['NNP'],
  'Marlo': ['NNP'],
  'Marlon': ['NNP'],
  'Marlow': ['NNP'],
  'Marlowe': ['NNP'],
  'Marlys': ['NNP'],
  'Marmalstein': ['NNP'],
  'Marmara': ['NNP'],
  'Marmee': ['NNP'],
  'Marmi': ['NNP'],
  'Marmon': ['NNP'],
  'Marne': ['NNP'],
  'Marne-la-Vallee': ['NNP'],
  'Marni': ['NNP'],
  'Maroc': ['NNP'],
  'Marocaine': ['NNP'],
  'Maronite': ['JJ'],
  'Maronites': ['NNPS'],
  'Marous': ['NNP'],
  'Maroy': ['NNP'],
  'Marques': ['NNP'],
  'Marquess': ['NNP'],
  'Marquet': ['NNP'],
  'Marquette': ['NNP'],
  'Marquez': ['NNP'],
  'Marquis': ['NNP'],
  'Marr': ['NNP'],
  'Marra': ['NNP'],
  'Marrakesh': ['NNP'],
  'Marriage': ['NNP'],
  'Marrie': ['NNP'],
  'Married': ['VBN'],
  'Marrill': ['NNP'],
  'Marriott': ['NNP'],
  'Marron': ['NNP'],
  'Marrow-Tech': ['NNP'],
  'Marry': ['NNP'],
  'Mars': ['NNP'],
  'Marsam': ['NNP'],
  'Marschalk': ['NNP'],
  'Marsden': ['NNP'],
  'Marseillaise': ['NNP'],
  'Marseilles': ['NNP'],
  'Marsh': ['NNP'],
  'Marsha': ['NNP'],
  'Marshal': ['NNP'],
  'Marshall': ['NNP'],
  'Marshalls': ['NNP'],
  'Marshes': ['NNP'],
  'Marsicano': ['NNP'],
  'Marsico': ['NNP'],
  'Marskmen': ['NNP'],
  'Marston': ['NNP'],
  'Mart': ['NNP'],
  'Martek': ['NNP'],
  'Martens': ['NNP'],
  'Martex': ['NNP'],
  'Martha': ['NNP'],
  'Marthe': ['NNP'],
  'Martian': ['NNP'],
  'Martians': ['NNP'],
  'Martin': ['NNP'],
  'Martin-type': ['JJ'],
  'Martinair': ['NNP'],
  'Martineau': ['NNP'],
  'Martinelli': ['NNP'],
  'Martinez': ['NNP'],
  'Martini': ['NN'],
  'Martinique': ['NNP'],
  'Martinsburg': ['NNP'],
  'Martinsek': ['NNP'],
  'Martinsville': ['NNP'],
  'Martoche': ['NNP'],
  'Marty': ['NNP'],
  'Martyn': ['NNP'],
  'Martyrs': ['NNP'],
  'Marubeni': ['NNP'],
  'Marulanda': ['NNP'],
  'Marum': ['NNP'],
  'Marunouchi': ['NNP'],
  'Marushita': ['NNP'],
  'Maruwa': ['NNP'],
  'Maruzen': ['NNP'],
  'Marv': ['NNP'],
  'Marvellee': ['NNP'],
  'Marvelon': ['NNP'],
  'Marvelous': ['JJ'],
  'Marver': ['NNP'],
  'Marvin': ['NNP'],
  'Marvis': ['NNP'],
  'Marwick': ['NNP'],
  'Marx': ['NNP'],
  'Marxism': ['NNP'],
  'Marxist': ['JJ'],
  'Marxist-Leninist': ['JJ'],
  'Marxist-dominated': ['JJ'],
  'Marxist-leaning': ['NNP'],
  'Marxists': ['NNPS'],
  'Mary': ['NNP'],
  'Maryann': ['NNP'],
  'Maryanne': ['NNP'],
  'Maryinsky': ['NN'],
  'Maryland': ['NNP'],
  'Marylanders': ['NNPS'],
  'Marysville': ['NNP'],
  'Maryville': ['NNP'],
  'Masaaki': ['NNP'],
  'Masada': ['NNP'],
  'Masahiko': ['NNP'],
  'Masahiro': ['NNP'],
  'Masaki-Schatz': ['NNP'],
  'Masami': ['NNP'],
  'Masaryk': ['NNP'],
  'Masato': ['NNP'],
  'Mascarita': ['NNP'],
  'Mascotte': ['NNP'],
  'Maser': ['NNP'],
  'Maserati': ['NNP'],
  'Masillon': ['NNP'],
  'Masius': ['NNP'],
  'Mask': ['NNP'],
  'Masket': ['NNP'],
  'Masks': ['VBZ'],
  'Maslyukov': ['NNP'],
  'Masnadieri': ['NNP'],
  'Mason': ['NNP'],
  'Masonic': ['NNP'],
  'Masonry': ['NNP'],
  'Masons': ['NNPS'],
  'Masque': ['NNP'],
  'Mass': ['NNP'],
  'Mass.': ['NNP'],
  'Mass.-based': ['JJ'],
  'MassMutual': ['NNP'],
  'Mass\\\'/Amherst': ['NNP'],
  'Massa': ['NNP'],
  'Massachusetts': ['NNP'],
  'Massachussets': ['NNP'],
  'Massacre': ['NNP'],
  'Massacres': ['NNS'],
  'Massage': ['NN'],
  'Masse': ['NNP'],
  'Massell': ['NNP'],
  'Massenet': ['NNP'],
  'Massey': ['NNP'],
  'Massey-Ferguson': ['NNP'],
  'Massicotte': ['NNP'],
  'Massimi': ['NNP'],
  'Massimo': ['NNP'],
  'Massive': ['JJ'],
  'Masson': ['NNP'],
  'Masssachusetts': ['NNP'],
  'Master': ['NNP'],
  'MasterCard': ['NNP'],
  'MasterCards': ['NNS'],
  'Mastergate': ['NNP'],
  'Mastering': ['VBG'],
  'Masterpiece': ['NNP'],
  'Masterpieces': ['NNPS'],
  'Masters': ['NNP'],
  'Masterson': ['NNP'],
  'Masterworks': ['NNPS'],
  'Mastro': ['NNP'],
  'Masu': ['NNP'],
  'Masuda': ['NNP'],
  'Masur': ['NNP'],
  'Matagorda': ['NNP'],
  'Matais': ['NNP'],
  'Matamoras': ['NNP'],
  'Matamoros': ['NNP'],
  'Matanky': ['NNP'],
  'Match': ['NNP'],
  'Matchbook-sized': ['JJ'],
  'Matchbox': ['NNP'],
  'Matchett': ['NNP'],
  'Matching': ['VBG'],
  'Mateo': ['NNP'],
  'Mater': ['NNP'],
  'Material': ['NNP'],
  'Materialism': ['NN'],
  'Materials': ['NNPS'],
  'Mateyo': ['NNP'],
  'Math': ['NNP'],
  'Mathavious': ['NNP'],
  'Mathematical': ['JJ'],
  'Mathematically': ['RB'],
  'Mathematics': ['NNP'],
  'Mather': ['NNP'],
  'Matheson': ['NNP'],
  'Mathews': ['NNP'],
  'Mathewson': ['NNP'],
  'Mathias': ['NNP'],
  'Mathilde': ['NNP'],
  'Mathis': ['NNP'],
  'Mathues': ['NNP'],
  'Matilda': ['NNP'],
  'Matisse': ['NNP'],
  'Matisses': ['NNPS'],
  'Matlock': ['NNP'],
  'Matlowsky': ['NNP'],
  'Matos': ['NNP'],
  'Matra': ['NNP'],
  'Matra-Harris': ['NNP'],
  'Matrimonial': ['NNP'],
  'Matritech': ['NNP'],
  'Matrix': ['NNP'],
  'Matsing': ['NNP'],
  'Matson': ['NNP'],
  'Matsu': ['NNP'],
  'Matsuda': ['NNP'],
  'Matsui': ['NNP'],
  'Matsunaga': ['NNP'],
  'Matsuo': ['NNP'],
  'Matsushita': ['NNP'],
  'Matsushita-made': ['JJ'],
  'Matsushita-owned': ['JJ'],
  'Matsuura': ['NNP'],
  'Matt': ['NNP'],
  'Mattathias': ['NNP'],
  'Mattausch': ['NNP'],
  'Mattei': ['NNP'],
  'Mattel': ['NNP'],
  'Matter': ['NN'],
  'Matters': ['NNP'],
  'Mattes': ['NNP'],
  'Matteson': ['NNP'],
  'Matthew': ['NNP'],
  'Matthews': ['NNP'],
  'Matthias': ['NNP'],
  'Matthies': ['NNP'],
  'Mattia': ['NNP'],
  'Mattie': ['NNP'],
  'Mattis': ['NNP'],
  'Mattison': ['NNP'],
  'Mattone': ['NNP'],
  'Mattox': ['NNP'],
  'Mattress': ['NNP'],
  'Mattsson': ['NNP'],
  'Matunuck': ['NNP'],
  'Maturities': ['NNS'],
  'Maturity': ['NN'],
  'Matuschka': ['NNP'],
  'Matz': ['NNP'],
  'Mauch': ['NNP'],
  'Maude': ['NNP'],
  'Maugham': ['NNP'],
  'Maughan': ['NNP'],
  'Maui': ['NNP'],
  'Mauldin': ['NNP'],
  'Maumee': ['NNP'],
  'Maung': ['NNP'],
  'Maura': ['NNP'],
  'Maureen': ['NNP'],
  'Maurer': ['NNP'],
  'Maurice': ['NNP'],
  'Maurier': ['NNP'],
  'Maurine': ['NNP'],
  'Mauritania': ['NNP'],
  'Maurits': ['NNP'],
  'Maury': ['NNP'],
  'Mauve-colored': ['JJ'],
  'Mavis': ['NNP'],
  'Mawr': ['NNP'],
  'Max': ['NNP'],
  'Maxell': ['NNP'],
  'Maxentius': ['NNP'],
  'Maxhuette': ['NNP'],
  'Maxicare': ['NNP'],
  'Maxim': ['NNP'],
  'Maxima': ['NNP'],
  'Maximilian': ['NNP'],
  'Maximizing': ['VBG'],
  'Maximum': ['NNP'],
  'Maxine': ['NNP'],
  'Maxtor': ['NNP'],
  'Maxus': ['NNP'],
  'Maxwell': ['NNP'],
  'Maxxam': ['NNP'],
  'May': ['NNP'],
  'May\\\'': ['NNP'],
  'Maya': ['FW'],
  'Mayan': ['JJ'],
  'Mayans': ['NNS'],
  'Maybe': ['RB'],
  'Maybelline': ['NNP'],
  'Mayberry': ['NNP'],
  'Mayer': ['NNP'],
  'Mayfair': ['NNP'],
  'Mayfield': ['NNP'],
  'Mayflower': ['NNP'],
  'Mayhap': ['RB'],
  'Mayland': ['NNP'],
  'Maynard': ['NNP'],
  'Mayne': ['NNP'],
  'Maynor': ['NNP'],
  'Mayo': ['NNP'],
  'Mayor': ['NNP'],
  'Mayor-elect': ['NNP'],
  'Mayor-nominate': ['NNP'],
  'Mayoral': ['JJ'],
  'Mayors': ['NNS'],
  'Mays': ['NNP'],
  'Maytag': ['NNP'],
  'Mayumi': ['NNP'],
  'Maywood': ['NNP'],
  'Mazda': ['NNP'],
  'Mazeroski': ['NNP'],
  'Mazilo': ['NNP'],
  'Mazowiecki': ['NNP'],
  'Mazowsze': ['NNP'],
  'Mazza': ['NNP'],
  'Mazzera': ['NNP'],
  'Mazzone': ['NNP'],
  'Mazzoni': ['NNP'],
  'Mazzorana': ['NNP'],
  'Mc': ['NNP'],
  'McAbee': ['NNP'],
  'McAfee': ['NNP'],
  'McAlester': ['NNP'],
  'McAlinden': ['NNP'],
  'McAlister': ['NNP'],
  'McAllen': ['NNP'],
  'McAllister': ['NNP'],
  'McAlpine': ['NNP'],
  'McArthur': ['NNP'],
  'McArtor': ['NNP'],
  'McAuley': ['NNP'],
  'McAuliffe': ['NNP'],
  'McAvity': ['NNP'],
  'McBee': ['NNP'],
  'McBride': ['NNP'],
  'McCabe': ['NNP'],
  'McCafferty': ['NNP'],
  'McCaffrey': ['NNP'],
  'McCain': ['NNP'],
  'McCall': ['NNP'],
  'McCamant': ['NNP'],
  'McCammon': ['NNP'],
  'McCann': ['NNP'],
  'McCann-Erickson': ['NNP'],
  'McCann-Erikson': ['NNP'],
  'McCanna': ['NNP'],
  'McCarran': ['NNP'],
  'McCarran-Ferguson': ['NNP'],
  'McCarthy': ['NNP'],
  'McCarthy-era': ['JJ'],
  'McCarthyite': ['JJ'],
  'McCartin': ['NNP'],
  'McCartney': ['NNP'],
  'McCarty': ['NNP'],
  'McCarver': ['NNP'],
  'McCaskey': ['NNP'],
  'McCaskill': ['NNP'],
  'McCaughan': ['NNP'],
  'McCaughey': ['NNP'],
  'McCauley': ['NNP'],
  'McCauliffe': ['NNP'],
  'McCaw': ['NNP'],
  'McCay': ['NNP'],
  'McChesney': ['NNP'],
  'McChicken': ['NNP'],
  'McClatchy': ['NNP'],
  'McClave': ['NNP'],
  'McClellan': ['NNP'],
  'McClelland': ['NNP'],
  'McClements': ['NNP'],
  'McCleod': ['NNP'],
  'McClintick': ['NNP'],
  'McClintock': ['NNP'],
  'McCloy': ['NNP'],
  'McClure': ['NNP'],
  'McCluskey': ['NNP'],
  'McColl': ['NNP'],
  'McCollum': ['NNP'],
  'McColm': ['NNP'],
  'McCombs': ['NNP'],
  'McCone': ['NNP'],
  'McConnell': ['NNP'],
  'McCord': ['NNP'],
  'McCormack': ['NNP'],
  'McCormick': ['NNP'],
  'McCovey': ['NNP'],
  'McCoy': ['NNP'],
  'McCracken': ['NNP'],
  'McCrady': ['NNP'],
  'McCraw': ['NNP'],
  'McCrory': ['NNP'],
  'McCullers': ['NNP'],
  'McCulley': ['NNP'],
  'McCullough': ['NNP'],
  'McCurdy': ['NNP'],
  'McCurry': ['NNP'],
  'McCutchen': ['NNP'],
  'McDLT': ['NNP'],
  'McDade': ['NNP'],
  'McDaniel': ['NNP'],
  'McDermid': ['NNP'],
  'McDermott': ['NNP'],
  'McDonald': ['NNP'],
  'McDonalds': ['NNP'],
  'McDonnell': ['NNP'],
  'McDonough': ['NNP'],
  'McDougall': ['NNP'],
  'McDowell': ['NNP'],
  'McDuffie': ['NNP'],
  'McEachern': ['NNP'],
  'McElroy': ['NNP'],
  'McElvaney': ['NNP'],
  'McElyee': ['NNP'],
  'McEnaney': ['NNP'],
  'McEnany': ['NNP'],
  'McEnroe': ['NNP'],
  'McFadden': ['NNP'],
  'McFall': ['NNP'],
  'McFarlan': ['NNP'],
  'McFarland': ['NNP'],
  'McFee': ['NNP'],
  'McFeeley': ['NNP'],
  'McFeely': ['RB'],
  'McGann': ['NNP'],
  'McGee': ['NNP'],
  'McGehee': ['NNP'],
  'McGeorge': ['NNP'],
  'McGhie': ['NNP'],
  'McGill': ['NNP'],
  'McGillicuddy': ['NNP'],
  'McGillivray': ['NNP'],
  'McGinley': ['NNP'],
  'McGinty': ['NNP'],
  'McGlade': ['NNP'],
  'McGlothlin': ['NNP'],
  'McGlynn': ['NNP'],
  'McGonagle': ['NNP'],
  'McGovern': ['NNP'],
  'McGowan': ['NNP'],
  'McGrath': ['NNP'],
  'McGraw': ['NNP'],
  'McGraw-Hill': ['NNP'],
  'McGregor': ['NNP'],
  'McGrevin': ['NNP'],
  'McGroarty': ['NNP'],
  'McGruder': ['NNP'],
  'McGuane': ['NNP'],
  'McGuigan': ['NNP'],
  'McGuire': ['NNP'],
  'McGuirk': ['NNP'],
  'McGurk': ['NNP'],
  'McGwire': ['NNP'],
  'McHenry': ['NNP'],
  'McInerney': ['NNP'],
  'McInnes': ['NNP'],
  'McInroy': ['NNP'],
  'McIntosh': ['NNP'],
  'McIntyre': ['NNP'],
  'McIver': ['NNP'],
  'McKENZIE': ['NNP'],
  'McKay': ['NNP'],
  'McKee': ['NNP'],
  'McKeever': ['NNP'],
  'McKellar': ['NNP'],
  'McKenna': ['NNP'],
  'McKennon': ['NNP'],
  'McKenzie': ['NNP'],
  'McKeon': ['NNP'],
  'McKeown': ['NNP'],
  'McKesson': ['NNP'],
  'McKibben': ['NNP'],
  'McKid': ['NNP'],
  'McKim': ['NNP'],
  'McKinley': ['NNP'],
  'McKinleyville': ['NNP'],
  'McKinney': ['NNP'],
  'McKinnon': ['NNP'],
  'McKinsey': ['NNP'],
  'McKinzie': ['NNP'],
  'McKnight': ['NNP'],
  'McKusick': ['NNP'],
  'McLauchlan': ['NNP'],
  'McLauchlin': ['NNP'],
  'McLaughlin': ['NNP'],
  'McLean': ['NNP'],
  'McLelland': ['NNP'],
  'McLemore': ['NNP'],
  'McLendon': ['NNP'],
  'McLendon-Ebony': ['NNP'],
  'McLennan': ['NNP'],
  'McLeod': ['NNP'],
  'McLish': ['NNP'],
  'McLoughlin': ['NNP'],
  'McLuhan': ['NNP'],
  'McMahon': ['NNP'],
  'McManus': ['NNP'],
  'McMaster': ['NNP'],
  'McMeel': ['NNP'],
  'McMillen': ['NNP'],
  'McMillin': ['NNP'],
  'McMoRan': ['NNP'],
  'McMullan': ['NNP'],
  'McMullin': ['NNP'],
  'McN': ['NNP'],
  'McNabb': ['NNP'],
  'McNair': ['NNP'],
  'McNally': ['NNP'],
  'McNamar': ['NNP'],
  'McNamara': ['NNP'],
  'McNamee': ['NNP'],
  'McNaughton': ['NNP'],
  'McNeal': ['NNP'],
  'McNealy': ['NNP'],
  'McNear': ['NNP'],
  'McNeil': ['NNP'],
  'McNeill': ['NNP'],
  'McNerney': ['NNP'],
  'McNichols': ['NNP'],
  'McPherson': ['NNP'],
  'McQueen': ['NNP'],
  'McQuillan': ['NNP'],
  'McQuown': ['NNP'],
  'McRae': ['NNP'],
  'McRaney': ['NNP'],
  'McRoberts': ['NNP'],
  'McShane': ['NNP'],
  'McSorley': ['NNP'],
  'McToxics': ['NNP'],
  'McVay': ['NNP'],
  'McVities': ['NNP'],
  'McWhinney': ['NNP'],
  'McWilliams': ['NNP'],
  'Mcdonald': ['NNP'],
  'Md': ['NNP'],
  'Md.': ['NNP'],
  'Me': ['PRP'],
  'Me\'a': ['NNP'],
  'Me-210': ['NNP'],
  'Mead': ['NNP'],
  'Meaden': ['NNP'],
  'Meador': ['NNP'],
  'Meadow': ['NNP'],
  'Meadowland': ['NNP'],
  'Meadows': ['NNP'],
  'Meager': ['JJ'],
  'Meagher': ['NNP'],
  'Meals': ['NNP'],
  'Mean': ['VB'],
  'Meana': ['NNP'],
  'Meaney': ['NNP'],
  'Meaning': ['NN'],
  'Meaningful': ['JJ'],
  'Meanings': ['NNS'],
  'Means': ['NNP'],
  'Meantime': ['RB'],
  'Meanwhile': ['RB'],
  'Meanwile': ['RB'],
  'Mears': ['NNP'],
  'Measure': ['NN'],
  'Measured': ['VBN'],
  'Measurement': ['NNP'],
  'Measurements': ['NNS'],
  'Measures': ['NNS'],
  'Measuring': ['VBG'],
  'Meat': ['NNP'],
  'Meatheads': ['NNS'],
  'Meats': ['NNS'],
  'Mecaniques': ['NNP'],
  'Mecca': ['NNP'],
  'Mechanics': ['NNP'],
  'Mechanicsburg': ['NNP'],
  'Mechanisms': ['NNPS'],
  'Mechanix': ['NNP'],
  'Mechanized': ['VBN'],
  'Mecholyl': ['NNP'],
  'Mecklenberg': ['NNP'],
  'Med-Chemical': ['NNP'],
  'MedChem': ['NNP'],
  'Medal': ['NNP'],
  'Medco': ['NNP'],
  'Medea': ['NNP'],
  'Medecine': ['NNP'],
  'Medellin': ['NNP'],
  'Medfield': ['NNP'],
  'Medford': ['NNP'],
  'Medgyessy': ['NNP'],
  'Medi-Mail': ['NNP'],
  'MediVision': ['NNP'],
  'Media': ['NNP'],
  'Media-buying': ['NN'],
  'Medialink': ['NNP'],
  'Median': ['JJ'],
  'Mediation': ['NNP'],
  'Medibank': ['NNP'],
  'Medicaid': ['NNP'],
  'Medicaid-covered': ['JJ'],
  'Medicaid-paid': ['JJ'],
  'Medical': ['NNP'],
  'Medical-instrument': ['JJ'],
  'Medical-supply': ['JJ'],
  'Medicale': ['NNP'],
  'Medicare': ['NNP'],
  'Medicare-approved': ['JJ'],
  'Medicare-catastrophic-care': ['JJ'],
  'Medicare-eligible': ['JJ'],
  'Medici': ['NNPS'],
  'Medicine': ['NNP'],
  'Medicines': ['NNP'],
  'Medicis': ['NNPS'],
  'Medicus': ['NNP'],
  'Medieval': ['NNP'],
  'Mediobanca': ['NNP'],
  'Meditations': ['NNPS'],
  'Mediterranean': ['NNP'],
  'Mediterranean-inspired': ['JJ'],
  'Mediumistic': ['JJ'],
  'Medlin': ['NNP'],
  'Medmenham': ['NNP'],
  'Mednis': ['NNP'],
  'Medstone': ['NNP'],
  'Medtronic': ['NNP'],
  'Medtronics': ['NNP'],
  'Medusa': ['NN'],
  'Medvedev': ['NNP'],
  'Meech': ['NNP'],
  'Meehan': ['NNP'],
  'Meek': ['NNP'],
  'Meeker': ['NNP'],
  'Meekison': ['NNP'],
  'Meese': ['NNP'],
  'Meet': ['VB'],
  'Meeting': ['VBG'],
  'Meetings': ['NNS'],
  'Meets': ['NNP'],
  'Meg': ['NNP'],
  'MegEcon': ['NNP'],
  'Mega': ['JJ'],
  'Mega-hits': ['NNS'],
  'Megamarketing': ['NN'],
  'Megane': ['NNP'],
  'Megargel': ['NNP'],
  'Megarians': ['NNPS'],
  'Megat': ['NNP'],
  'Megdal': ['NNP'],
  'Meggs': ['NNP'],
  'Meharry': ['NNP'],
  'Mehitabel': ['NNP'],
  'Mehl': ['NNP'],
  'Mehrens': ['NNP'],
  'Mehta': ['NNP'],
  'Meidinger': ['NNP'],
  'Meigher': ['NNP'],
  'Meils': ['NNP'],
  'Meinckian': ['NNP'],
  'Meinders': ['NNP'],
  'Meineke': ['NNP'],
  'Meinung': ['FW'],
  'Meir': ['NNP'],
  'Meisenheimer': ['NNP'],
  'Meissner': ['NNP'],
  'Meister': ['NNP'],
  'Meistersinger': ['NNP'],
  'Mekong': ['NNP'],
  'Mel': ['NNP'],
  'Melamed': ['NNP'],
  'Melamine': ['JJ'],
  'Melancholy': ['JJ'],
  'Melanesian': ['NNP'],
  'Melanie': ['NNP'],
  'Melanto': ['NNP'],
  'Melbourne': ['NNP'],
  'Melbourne-based': ['JJ'],
  'Melcher': ['NNP'],
  'Melies': ['NNP'],
  'Melinda': ['NNP'],
  'Melisande': ['NNP'],
  'Melissa': ['NNP'],
  'Mellal': ['NNP'],
  'Mellanby': ['NNP'],
  'Mellen': ['NNP'],
  'Meller': ['NNP'],
  'Melling': ['NNP'],
  'Mello': ['NNP'],
  'Melloan': ['NNP'],
  'Mellon': ['NNP'],
  'Mellor': ['NNP'],
  'Mellow': ['JJ'],
  'Melodious': ['JJ'],
  'Melodramatic': ['JJ'],
  'Melody': ['NNP'],
  'Melott': ['NNP'],
  'Melrose': ['NNP'],
  'Melsungen': ['NNP'],
  'Melted': ['VBN'],
  'Meltex': ['NNP'],
  'Meltnomah': ['NNP'],
  'Melton': ['NNP'],
  'Meltzer': ['NNP'],
  'Melville': ['NNP'],
  'Melvin': ['NNP'],
  'Melvyn': ['NNP'],
  'Melzi': ['NNP'],
  'Member': ['NN'],
  'Members': ['NNS'],
  'Membership': ['NNP'],
  'Mementoes': ['NNS'],
  'Memoir': ['NN'],
  'Memoirs': ['NNP'],
  'Memorex': ['NNP'],
  'Memorial': ['NNP'],
  'Memorials': ['NNP'],
  'Memories': ['NNPS'],
  'Memory': ['NN'],
  'Memotec': ['NNP'],
  'Memphis': ['NNP'],
  'Men': ['NNS'],
  'Menagerie': ['NNP'],
  'Menahem': ['NNP'],
  'Menas': ['NNP'],
  'Mencius': ['NNP'],
  'Mencken': ['NNP'],
  'Mendell': ['NNP'],
  'Mendelsohn': ['NNP'],
  'Mendelson': ['NNP'],
  'Mendelssohn': ['NNP'],
  'Menderes': ['NNP'],
  'Mendes': ['NNP'],
  'Mendez': ['NNP'],
  'Mendoza': ['NNP'],
  'Menelaus': ['NNP'],
  'Menell': ['NNP'],
  'Menem': ['NNP'],
  'Menendez': ['NNP'],
  'Menenendez': ['NNP'],
  'Menet': ['NNP'],
  'Menfolk': ['NNS'],
  'Mengistu': ['NNP'],
  'Mengitsu': ['NNP'],
  'Menilmontant': ['NNP'],
  'Meninas': ['NNP'],
  'Menlo': ['NNP'],
  'Mennen': ['NNP'],
  'Mennis': ['NNP'],
  'Mennonite': ['JJ'],
  'Mennonites': ['NNPS'],
  'Menomonee': ['NNP'],
  'Menshikov': ['NNP'],
  'Ment': ['NNP'],
  'Mental': ['NNP'],
  'Mentality': ['NN'],
  'Menton': ['NNP'],
  'Mentor': ['NNP'],
  'Mentum': ['NNP'],
  'Mentz': ['NNP'],
  'Menu': ['NNP'],
  'Menuhin': ['NNP'],
  'Menuhin-Amadeus': ['NNP'],
  'Menzel': ['NNP'],
  'Mephistopheles': ['NNP'],
  'Meps': ['NNP'],
  'MeraBank': ['NNP'],
  'Merabank': ['NNP'],
  'Merapi': ['NNP'],
  'Merc': ['NNP'],
  'Mercantile': ['NNP'],
  'Mercantilists': ['NNS'],
  'Merce': ['NNP'],
  'Merced': ['NNP'],
  'Mercedes': ['NNP'],
  'Mercedes-Benz': ['NNP'],
  'Mercedes-Benzes': ['NNPS'],
  'Mercenary': ['NN'],
  'Mercer': ['NNP'],
  'Mercer-Meidinger-Hansen': ['NNP'],
  'Mercers': ['NNPS'],
  'Merchandise': ['NNP'],
  'Merchandising': ['NNP'],
  'Merchant': ['NNP'],
  'Merchants': ['NNP'],
  'MerchantsBank': ['NNP'],
  'Mercier': ['NNP'],
  'Merciful': ['JJ'],
  'Mercifully': ['RB'],
  'Merck': ['NNP'],
  'Mercury': ['NNP'],
  'Mercy': ['NNP'],
  'Meredith': ['NNP'],
  'Merely': ['RB'],
  'Mergens': ['NNP'],
  'Merger': ['NN'],
  'Mergers': ['NNPS'],
  'Merhige': ['NNP'],
  'Meriden': ['NNP'],
  'Meridian': ['NNP'],
  'Merieux': ['NNP'],
  'Merieux-Connaught': ['NNP'],
  'Merigan': ['NNP'],
  'Merighi': ['NNP'],
  'Merill': ['NNP'],
  'Merion': ['NNP'],
  'Merit': ['NNP'],
  'Merited': ['JJ'],
  'Meritor': ['NNP'],
  'Merits': ['NNS'],
  'Meriwether': ['NNP'],
  'Merkel': ['NNP'],
  'Merksamer': ['NNP'],
  'Merkur': ['NNP'],
  'Merkurs': ['NNPS'],
  'Merle': ['NNP'],
  'Merleau-Ponty': ['NNP'],
  'Merlis': ['NNP'],
  'Merlo': ['NNP'],
  'Merner': ['NNP'],
  'Merola': ['NNP'],
  'Merom': ['NNP'],
  'Merrell': ['NNP'],
  'Merriam-Webster': ['NNP'],
  'Merrick': ['NNP'],
  'Merrill': ['NNP'],
  'Merrill-Lynch': ['NNP'],
  'Merrimac': ['NNP'],
  'Merrimack': ['NNP'],
  'Merritt': ['NNP'],
  'Merritt-Chapman': ['NNP'],
  'Merry': ['NNP'],
  'Merry-Go-Round': ['NNP'],
  'Merry-go-round': ['NNP'],
  'Merryman': ['NNP'],
  'Mersa': ['NNP'],
  'Mertle': ['NNP'],
  'Merton': ['NNP'],
  'Merv': ['NNP'],
  'Mervin': ['NNP'],
  'Mervyn': ['NNP'],
  'Meryl': ['NNP'],
  'Merz': ['NNP'],
  'Mesa': ['NNP'],
  'Mesaba': ['NNP'],
  'Mescalero': ['NNP'],
  'Meselson': ['NNP'],
  'Meshulam': ['NNP'],
  'Mesirov': ['NNP'],
  'Mesnil': ['NNP'],
  'Meson': ['NNP'],
  'Mess': ['NN'],
  'Messa': ['FW'],
  'Message': ['NN'],
  'Messaggero': ['NNP'],
  'Messelt': ['NNP'],
  'Messenger': ['NNP'],
  'Messengers': ['NNPS'],
  'Messerschmitt': ['NN'],
  'Messerschmitt-Boelkow': ['NNP'],
  'Messerschmitt-Boelkow-Blohm': ['NNP'],
  'Messerschmitt-Bolkow': ['NNP'],
  'Messiaen': ['NNP'],
  'Messiah': ['NNP'],
  'Messina': ['NNP'],
  'Messinesi': ['NNP'],
  'Messing': ['VBG'],
  'Messinger': ['NNP'],
  'Messner': ['NNP'],
  'Messrs': ['NNPS'],
  'Messrs.': ['NNPS'],
  'Mesta': ['NNP'],
  'Met': ['NNP'],
  'MetWest': ['NNP'],
  'Meta': ['NNP'],
  'Metabolite': ['NN'],
  'Metal': ['NNP'],
  'Metall': ['NNP'],
  'Metallgesellschaft': ['NNP'],
  'Metallurgical': ['NNP'],
  'Metals': ['NNP'],
  'Metamorphose': ['NNP'],
  'Metamorphosis': ['NN'],
  'Metamucil': ['NNP'],
  'Metaphysics': ['NNS'],
  'Metatrace': ['NNP'],
  'Metcalf': ['NNP'],
  'Meteorological': ['NNP'],
  'Methanol': ['NN'],
  'Method': ['NN'],
  'Methodism': ['NNP'],
  'Methodist': ['NNP'],
  'Methodists': ['NNPS'],
  'Methods': ['NNS'],
  'Methuselah': ['NNP'],
  'Methuselahs': ['NNPS'],
  'Methyl': ['NN'],
  'Methylene': ['NN'],
  'Metier': ['NNP'],
  'Metrecal': ['NNP'],
  'Metric': ['NNP'],
  'Metrically': ['RB'],
  'Metro': ['NNP'],
  'Metro-Goldwyn-Mayer': ['NNP'],
  'MetroCorp': ['NNP'],
  'Metrocorp': ['NNP'],
  'Metromedia': ['NNP'],
  'Metromedia-ITT': ['NNP'],
  'Metronic': ['NNP'],
  'Metronome': ['NNP'],
  'Metroplex': ['NNP'],
  'Metropolian': ['NNP'],
  'Metropolis': ['NNP'],
  'Metropolitan': ['NNP'],
  'Metruh': ['NNP'],
  'Mets': ['NNP'],
  'Metschan': ['NNP'],
  'Metter': ['NNP'],
  'Metz': ['NNP'],
  'Metzenbaum': ['NNP'],
  'Metzenbaums': ['NNPS'],
  'Metzler': ['NNP'],
  'Meurer': ['NNP'],
  'Meurons': ['NNS'],
  'Mevacor': ['NNP'],
  'Mevalotin': ['NN'],
  'Mexicali': ['NNP'],
  'Mexican': ['JJ'],
  'Mexican-food': ['JJ'],
  'Mexicana': ['NNP'],
  'Mexicanos': ['NNP'],
  'Mexicans': ['NNPS'],
  'Mexico': ['NNP'],
  'Mexico-United': ['NNP'],
  'Mexico-based': ['JJ'],
  'Mexico-watchers': ['NNS'],
  'Meyer': ['NNP'],
  'Meyerbeer': ['NNP'],
  'Meyers': ['NNP'],
  'Meyerson': ['NNP'],
  'Meyle': ['NNP'],
  'Meynell': ['NNP'],
  'Meyner': ['NNP'],
  'Meyohas': ['NNP'],
  'Mezzanine': ['NNP'],
  'Mezzogiorno': ['NNP'],
  'Mfg.': ['NNP'],
  'Mfume': ['NNP'],
  'Mi': ['NNP'],
  'MiG-23': ['NNP'],
  'MiG-23BN': ['NN'],
  'MiG-26': ['NNP'],
  'MiG-29': ['NNP'],
  'MiG-29s': ['NNS'],
  'MiGs': ['NNPS'],
  'Mia': ['NNP'],
  'Miami': ['NNP'],
  'Miami-Madrid': ['NNP'],
  'Miami-based': ['JJ'],
  'Miantonomi': ['NNP'],
  'Micawber': ['NNP'],
  'Mice': ['NNS'],
  'Micelles': ['NNS'],
  'Micelli': ['NNP'],
  'Mich': ['NNP'],
  'Mich.': ['NNP'],
  'Mich.-based': ['JJ'],
  'Micha': ['NNP'],
  'Michael': ['NNP'],
  'Michaelcheck': ['NNP'],
  'Michaels': ['NNP'],
  'Michaelson': ['NNP'],
  'Michel': ['NNP'],
  'Michel-Etienne': ['NNP'],
  'Michelangelo': ['NNP'],
  'Michelangelos': ['NNPS'],
  'Michele': ['NNP'],
  'Michelin': ['NNP'],
  'Michelin\\\'': ['NNP'],
  'Michelle': ['NNP'],
  'Michelman': ['NNP'],
  'Michelob': ['NNP'],
  'Michels': ['NNP'],
  'Michelson': ['NNP'],
  'Michigan': ['NNP'],
  'Michigan-based': ['JJ'],
  'Michilimackinac': ['NNP'],
  'Michio': ['NNP'],
  'Mick': ['NNP'],
  'Mickelberry': ['NNP'],
  'Mickey': ['NNP'],
  'Mickie': ['NNP'],
  'Micro': ['NNP'],
  'Micro-Economics': ['NNPS'],
  'MicroAge': ['NNP'],
  'MicroBilt': ['NNP'],
  'MicroGeneSys': ['NNP'],
  'Microamerica': ['NNP'],
  'Microbilt': ['NNP'],
  'Microbiological': ['NNP'],
  'Microbiology': ['NNP'],
  'Microchannel': ['NNP'],
  'Microcom': ['NNP'],
  'Microdyne': ['NNP'],
  'Microelectronics': ['NNPS'],
  'Microlog': ['NNP'],
  'Micron': ['NNP'],
  'Micronic': ['NNP'],
  'Micronics': ['NNP'],
  'Micronite': ['NN'],
  'Micronyx': ['NNP'],
  'Microorganisms': ['NNS'],
  'Microphones': ['NNS'],
  'Micropolis': ['NNP'],
  'Microprocessor': ['NNP'],
  'Microscopes': ['NNS'],
  'Microscopic': ['JJ'],
  'Microscopically': ['RB'],
  'Microsoft': ['NNP'],
  'Microsoft-Apple': ['NNP'],
  'Microsystems': ['NNPS'],
  'Microwave': ['NNP'],
  'Microwaves': ['NNS'],
  'Mid': ['NNP'],
  'Mid-America': ['NNP'],
  'Mid-Atlantic': ['NN'],
  'Mid-Century': ['NNP'],
  'Mid-Continent': ['NNP'],
  'Mid-State': ['NNP'],
  'Mid-sized': ['JJ'],
  'Midas': ['NNP'],
  'Midco': ['NNP'],
  'Middenstandsbank': ['NNP'],
  'Middle': ['NNP'],
  'Middle-Eastern': ['JJ'],
  'Middle-South': ['NNP'],
  'Middle-aged': ['JJ'],
  'Middle-class': ['JJ'],
  'Middlebury': ['NNP'],
  'Middlefield': ['NNP'],
  'Middleman': ['NN'],
  'Middleness': ['NN'],
  'Middlesex': ['NNP'],
  'Middletown': ['NNP'],
  'Mideast': ['NNP'],
  'Mideastern': ['JJ'],
  'Midge': ['NNP'],
  'Midgetman': ['NNP'],
  'Midi': ['NNP'],
  'Midland': ['NNP'],
  'Midlantic': ['NNP'],
  'Midler': ['NNP'],
  'Midmorning': ['NN'],
  'Midnight': ['NNP'],
  'Midshipman': ['NNP'],
  'Midsized': ['JJ'],
  'Midvale': ['NNP'],
  'Midway': ['NNP'],
  'Midwesco': ['NNP'],
  'Midwest': ['NNP'],
  'Midwestern': ['JJ'],
  'Midwesterners': ['NNS'],
  'Midwood': ['NNP'],
  'Miert': ['NN'],
  'Mifepristone': ['NNP'],
  'Mifflin': ['NNP'],
  'Mig': ['NN'],
  'Might': ['MD'],
  'Mighty': ['NNP'],
  'Miglia': ['NNP'],
  'Migliorino': ['NNP'],
  'Mignanelli': ['NNP'],
  'Mignon': ['NNP'],
  'Mignott': ['NNP'],
  'Migrant': ['NNP'],
  'Migs': ['NNS'],
  'Miguel': ['NNP'],
  'Mihalek': ['NNP'],
  'Mihaly': ['NNP'],
  'Mij': ['NNP'],
  'Mijbil': ['NNP'],
  'Mikado': ['NNP'],
  'Mike': ['NNP'],
  'Mikeen': ['NNP'],
  'Mikhail': ['NNP'],
  'Mikie': ['NNP'],
  'Miklos': ['NNP'],
  'Mikoyan': ['NNP'],
  'Mikulich': ['NNP'],
  'Mikulski': ['NNP'],
  'Mil-Spec': ['NNP'],
  'Milacron': ['NNP'],
  'Milan': ['NNP'],
  'Milan-based': ['JJ'],
  'Milano': ['NNP'],
  'Milanoff': ['NNP'],
  'Milbank': ['NNP'],
  'Milbankes': ['NNPS'],
  'Milbauer': ['NNP'],
  'Milberg': ['NNP'],
  'Milburn': ['NNP'],
  'Milcote': ['NNP'],
  'Mildner': ['NNP'],
  'Mile': ['NNP'],
  'Mileage': ['NN'],
  'Milenoff': ['NNP'],
  'Miles': ['NNP'],
  'Milford': ['NNP'],
  'Milgrim': ['NNP'],
  'Milhaud': ['NNP'],
  'Militant': ['JJ'],
  'Military': ['NNP'],
  'Militia': ['NNS'],
  'Milk': ['NN'],
  'Milka': ['NNP'],
  'Milkaukee': ['NNP'],
  'Milken': ['NNP'],
  'Milkens': ['NNPS'],
  'Milko': ['NNP'],
  'Milky': ['NNP'],
  'Mill': ['NNP'],
  'Millard': ['NNP'],
  'Millay': ['NNP'],
  'Millbrae': ['NNP'],
  'Millburn': ['NNP'],
  'Mille': ['NNP'],
  'Milledgeville': ['NNP'],
  'Millen': ['NNP'],
  'Millenarianism': ['NN'],
  'Millenbruch': ['NNP'],
  'Millennium': ['NN'],
  'Miller': ['NNP'],
  'Miller-Studds': ['NNP'],
  'Millers': ['NNPS'],
  'Millicent': ['NNP'],
  'Millicom': ['NNP'],
  'Millie': ['NNP'],
  'Milling': ['NNP'],
  'Milling-Stanley': ['NNP'],
  'Million': ['CD'],
  'Million-dollar': ['JJ'],
  'Millions': ['NNS'],
  'Millipore': ['NNP'],
  'Millis': ['NNP'],
  'Millkens': ['NNP'],
  'Millo': ['NNP'],
  'Mills': ['NNP'],
  'Millstein': ['NNP'],
  'Millstone': ['NNP'],
  'Milman': ['NNP'],
  'Milne': ['NNP'],
  'Milos': ['NNP'],
  'Milpitas': ['NNP'],
  'Milquetoasts': ['NNS'],
  'Milstar': ['NNP'],
  'Milstein': ['NNP'],
  'Milt': ['NNP'],
  'Milties': ['NNP'],
  'Milton': ['NNP'],
  'Miltonic': ['JJ'],
  'Milunovich': ['NNP'],
  'Milwaukee': ['NNP'],
  'Milwaukee-based': ['JJ'],
  'Mimesis': ['NN'],
  'Mimi': ['NNP'],
  'Mimieux': ['NNP'],
  'MinHa': ['NNP'],
  'Minato-Mirai': ['NNP'],
  'Mind': ['VB'],
  'Mindanao': ['NNP'],
  'Minden': ['NNP'],
  'Mindlin': ['NNP'],
  'Minds': ['NNPS'],
  'Mindscape': ['NNP'],
  'Mindy': ['NNP'],
  'Mine': ['NNP'],
  'Minella': ['NNP'],
  'Mineola': ['NNP'],
  'Miner': ['NNP'],
  'Minera': ['NNP'],
  'Mineral': ['NNP'],
  'Mineralogies': ['NNPS'],
  'Mineralogy': ['NNP'],
  'Minerals': ['NNPS'],
  'Minero': ['NNP'],
  'Miners': ['NNP'],
  'Minerva': ['NNP'],
  'Mines': ['NNPS'],
  'Mineworkers': ['NNPS'],
  'Ming': ['NNP'],
  'Mingo': ['NNP'],
  'Mingus': ['NNP'],
  'Minh': ['NNP'],
  'MiniScribe': ['NNP'],
  'MiniSport': ['NNP'],
  'Minicar': ['JJ'],
  'Minikes': ['NNP'],
  'Minimum': ['NNP'],
  'Mining': ['NNP'],
  'MinisPort': ['NNP'],
  'Miniscribe': ['NNP'],
  'Minister': ['NNP'],
  'Ministers': ['NNPS'],
  'Ministries': ['NNP'],
  'Ministry': ['NNP'],
  'Minitruck': ['NN'],
  'Miniver': ['NNP'],
  'Minkow': ['NNP'],
  'Minks': ['NNP'],
  'Minn': ['NNP'],
  'Minn.': ['NNP'],
  'Minn.-based': ['JJ'],
  'Minna': ['NNP'],
  'Minneapolis': ['NNP'],
  'Minneapolis-St': ['NNP'],
  'Minneapolis-based': ['JJ'],
  'Minnelli': ['NNP'],
  'Minnery': ['NNP'],
  'Minnesota': ['NNP'],
  'Minnesotan': ['NNP'],
  'Minnesotans': ['NNPS'],
  'Minnetonka': ['NNP'],
  'Minnett': ['NNP'],
  'Minnie': ['NNP'],
  'Minns': ['NNP'],
  'Minny': ['NNP'],
  'Minoan-Mycenaean': ['NNP'],
  'Minolta': ['NNP'],
  'Minor': ['NNP'],
  'Minorco': ['NNP'],
  'Minority': ['NNP'],
  'Minors': ['NNS'],
  'Minoru': ['NNP'],
  'Minoso': ['NNP'],
  'Minot': ['NNP'],
  'Minpeco': ['NNP'],
  'Minpeco-Manufacturers': ['NNPS'],
  'Minsk': ['NNP'],
  'Minster': ['NNP'],
  'Mint': ['NNP'],
  'Mintel': ['NNP'],
  'Minter': ['NNP'],
  'Mints': ['NNS'],
  'Mintz': ['NNP'],
  'Minuses': ['NNS'],
  'Minute': ['NNP'],
  'Minuteman': ['NNP'],
  'Minutemen': ['NNPS'],
  'Minutes': ['NNPS'],
  'Minwax': ['NNP'],
  'Mio': ['NNP'],
  'Mips': ['NNP'],
  'Mira': ['NNP'],
  'Mirabella': ['NNP'],
  'Mirabello': ['NNP'],
  'Miracle': ['NNP'],
  'Miraculously': ['RB'],
  'Miraflores': ['NNP'],
  'Mirage': ['NNP'],
  'Miranda': ['NNP'],
  'Mirante': ['NNP'],
  'Mired': ['NNP'],
  'Mirek': ['NNP'],
  'Mirella': ['NNP'],
  'Miriam': ['NNP'],
  'Miriani': ['NNP'],
  'Miringoff': ['NNP'],
  'Miro': ['NNP'],
  'Miron': ['NNP'],
  'Mironenko': ['NNP'],
  'Mirror': ['NNP'],
  'Mirsky': ['NNP'],
  'Mis-ter': ['NNP'],
  'Misa': ['NNP'],
  'Misanthrope': ['NN'],
  'Misawa': ['NNP'],
  'Misbegotten': ['NNP'],
  'Miscellaneous': ['JJ'],
  'Miscellany': ['NNP'],
  'Mischa': ['NNP'],
  'Misconceptions': ['NNS'],
  'Misdemeanors': ['NNS'],
  'Miser': ['NNP'],
  'Miserables': ['FW'],
  'Misery': ['NN'],
  'Mises': ['NNP'],
  'Mishelevka': ['NNP'],
  'Mishkin': ['NNP'],
  'Misinformation': ['NN'],
  'Miss': ['NNP'],
  'Miss.': ['NNP'],
  'Missa': ['NNP'],
  'Missail': ['NNP'],
  'Misses': ['NNPS'],
  'Missett': ['NNP'],
  'Missile': ['NNP'],
  'Missiles': ['NNP'],
  'Missing': ['JJ'],
  'Mission': ['NNP'],
  'Missionary': ['JJ'],
  'Missions': ['NNP'],
  'Mississippi': ['NNP'],
  'Mississippian': ['NNP'],
  'Mississippians': ['NNS'],
  'Missoula': ['NNP'],
  'Missouri': ['NNP'],
  'Missouri-Illinois': ['NNP'],
  'Missy': ['NNP'],
  'Mist': ['NNP'],
  'Mistake': ['NNP'],
  'Mister': ['NNP'],
  'Mistsubishi': ['NNP'],
  'Misubishi': ['NNP'],
  'Misunderstanding': ['VBG'],
  'Mita': ['NNP'],
  'Mitch': ['NNP'],
  'Mitchel': ['NNP'],
  'Mitchell': ['NNP'],
  'Mitchells': ['NNP'],
  'Mite': ['NNP'],
  'Mitofksy': ['NNP'],
  'Mitofsky': ['NNP'],
  'Mitre': ['NNP'],
  'Mitropoulos': ['NNP'],
  'Mitsotakis': ['NNP'],
  'Mitsu': ['NNP'],
  'Mitsubishi': ['NNP'],
  'Mitsui': ['NNP'],
  'Mitsukoshi': ['NNP'],
  'Mitsuo': ['NNP'],
  'Mitsuoka': ['NNP'],
  'Mitsuru': ['NNP'],
  'Mittag': ['NNP'],
  'Mitterrand': ['NNP'],
  'Mityukh': ['NNP'],
  'Mitzel': ['NNP'],
  'Miullo': ['NNP'],
  'Mix': ['NNP'],
  'Mix-Up': ['NN'],
  'Mixed': ['NNP'],
  'Mixte': ['NNP'],
  'Mixtec': ['JJ'],
  'Miyagi': ['NNP'],
  'Miyata': ['NNP'],
  'Miyazaki': ['NNP'],
  'Miyoshi': ['NNP'],
  'Mizell': ['NNP'],
  'Mizuno': ['NNP'],
  'Mlangeni': ['NNP'],
  'Mlle': ['NNP'],
  'Mme': ['NNP'],
  'Mmes': ['NNPS'],
  'Mmes.': ['NNPS'],
  'Mmm': ['UH'],
  'Mmmm': ['UH'],
  'Mnemosyne': ['NNP'],
  'Mnouchkine': ['NNP'],
  'Mnuchin': ['NNP'],
  'Mo': ['NNP'],
  'Mo.': ['NNP'],
  'Mo.-based': ['JJ'],
  'Mob': ['NN'],
  'MobiTel': ['NNP'],
  'Mobil': ['NNP'],
  'Mobile': ['NNP'],
  'Mobilfunk': ['NNP'],
  'Mobilia': ['NNP'],
  'Mobilization': ['NNP'],
  'Mobs': ['NNS'],
  'Mobutu': ['NNP'],
  'Moby': ['NNP'],
  'Moccasin': ['NNP'],
  'Mochida': ['NNP'],
  'Mocking': ['NNP'],
  'Mockler': ['NNP'],
  'Mockowiczes': ['NNPS'],
  'Mode': ['NNP'],
  'Model': ['NN'],
  'Modeling': ['NNP'],
  'Modell': ['NNP'],
  'Models': ['NNS'],
  'Moderate': ['JJ'],
  'Moderating': ['VBG'],
  'Modern': ['NNP'],
  'Modest': ['JJ'],
  'Modestly': ['RB'],
  'Modesto': ['NNP'],
  'Modifications': ['NNS'],
  'Modigliani': ['NNP'],
  'Modrall': ['NNP'],
  'Modrow': ['NNP'],
  'Modular': ['NNP'],
  'Modzelewski': ['NNP'],
  'Moe': ['NNP'],
  'Moehn': ['NNP'],
  'Moeller': ['NNP'],
  'Moertel': ['NNP'],
  'Moet': ['NNP'],
  'Moet-Hennessy': ['NNP'],
  'Moffett': ['NNP'],
  'Moffitt': ['NNP'],
  'Mogadishu': ['NNP'],
  'Mogan': ['NNP'],
  'Mogavero': ['NNP'],
  'Mogg': ['NNP'],
  'Mogul': ['NNP'],
  'Mohamad': ['NNP'],
  'Mohamed': ['NNP'],
  'Mohammad': ['NNP'],
  'Mohammed': ['NNP'],
  'Mohammedanism': ['NNP'],
  'Mohan': ['NNP'],
  'Mohandas': ['NNP'],
  'Mohasco': ['NNP'],
  'Mohawk': ['NNP'],
  'Mohlere': ['NNP'],
  'Moineau': ['NNP'],
  'Moines': ['NNP'],
  'Moines-based': ['JJ'],
  'Moira': ['NNP'],
  'Moise': ['NNP'],
  'Moises': ['NNP'],
  'Moiseyev': ['NNP'],
  'Moiseyeva': ['NNP'],
  'Moisture': ['NN'],
  'Mojave': ['NNP'],
  'Mokaba': ['NNP'],
  'Mokae': ['NNP'],
  'Mokhiber': ['NNP'],
  'Molard': ['NNP'],
  'Mold': ['NN'],
  'Moldavia': ['NNP'],
  'Moldavian': ['NNP'],
  'Molding': ['NN'],
  'Mole': ['NNP'],
  'Molecular': ['NNP'],
  'Moleculon': ['NNP'],
  'Molesworth': ['NNP'],
  'Moliere': ['NNP'],
  'Molinari': ['NNP'],
  'Molinaro': ['NNP'],
  'Moline': ['NNP'],
  'Moll': ['NNP'],
  'Moller': ['NNP'],
  'Mollica': ['NNP'],
  'Mollie': ['NNP'],
  'Molloy': ['NNP'],
  'Mollusks': ['NNS'],
  'Molly': ['NNP'],
  'Moloch': ['NNP'],
  'Molokai': ['NNP'],
  'Molotov': ['NNP'],
  'Molson': ['NNP'],
  'Molten': ['JJ'],
  'Moluccas': ['NNP'],
  'Molvar': ['NNP'],
  'Mom': ['NN'],
  'Momentarily': ['RB'],
  'Moments': ['NNS'],
  'Momentum': ['NN'],
  'Momma': ['NNP'],
  'Mommor': ['NNP'],
  'Mommy': ['NNP'],
  'Momoyama': ['NNP'],
  'Mon': ['NNP'],
  'Mon-Columbia': ['NNP'],
  'Mon-Fay': ['NNP'],
  'Mon-Goddess': ['NNP'],
  'Mon-Khmer': ['NNP'],
  'Mona': ['NNP'],
  'Monaco': ['NNP'],
  'Monagan': ['NNP'],
  'Monahan': ['NNP'],
  'Monarch': ['NNP'],
  'Monarque': ['FW'],
  'Monastery': ['NNP'],
  'Monchecourt': ['NNP'],
  'Mondale': ['NNP'],
  'Monday': ['NNP'],
  'Monday\'s': ['NNP'],
  'Monday-Friday': ['NNP'],
  'Monday-morning': ['JJ'],
  'Mondays': ['NNPS'],
  'Monde': ['NNP'],
  'Mondonville': ['NNP'],
  'Mondrian': ['NNP'],
  'Mondry': ['NNP'],
  'Mondschein': ['NNP'],
  'Monel': ['NNP'],
  'Monet': ['NNP'],
  'Monetary': ['NNP'],
  'Monets': ['NNPS'],
  'Monetta': ['NNP'],
  'Monex': ['NNP'],
  'Money': ['NNP'],
  'Money-fund': ['NN'],
  'Money-making': ['JJ'],
  'Money-market': ['NN'],
  'Money-saving': ['JJ'],
  'Moneyed': ['NNP'],
  'Moneyletter': ['NNP'],
  'Mongan': ['NNP'],
  'Mongi': ['NNP'],
  'Mongolia': ['NNP'],
  'Monica': ['NNP'],
  'Monier': ['NNP'],
  'Monieson': ['NNP'],
  'Monilia': ['NN'],
  'Monitor': ['NNP'],
  'Monitoring': ['NN'],
  'Monitors': ['NNP'],
  'Moniuszko': ['NNP'],
  'Monk': ['NNP'],
  'Monkey': ['NNP'],
  'Monmouth': ['NNP'],
  'Mono-unsaturated': ['JJ'],
  'Monocite': ['NNP'],
  'Monoclonal': ['JJ'],
  'Monogamy': ['NN'],
  'Monogram': ['NNP'],
  'Monopolies': ['NNPS'],
  'Monopoly': ['NN'],
  'Monorail': ['NNP'],
  'Monroe': ['NNP'],
  'Monsanto': ['NNP'],
  'Monsieur': ['NNP'],
  'Monsky': ['NNP'],
  'Monster': ['NN'],
  'Mont': ['NNP'],
  'Mont.': ['NNP'],
  'Montagu': ['NNP'],
  'Montaigne': ['NNP'],
  'Montana': ['NNP'],
  'Montbrial': ['NNP'],
  'Monte': ['NNP'],
  'Monteath': ['NNP'],
  'Montedision': ['NN'],
  'Montedison': ['NNP'],
  'Monteith': ['NNP'],
  'Montenegrin': ['NNP'],
  'Monterey': ['NNP'],
  'Montero': ['NNP'],
  'Monterrey': ['NNP'],
  'Monterrey-based': ['JJ'],
  'Montesano': ['NNP'],
  'Monteverdi': ['NNP'],
  'Montevideo': ['NNP'],
  'Montfaucon': ['NNP'],
  'Montgolfier': ['NNP'],
  'Montgomery': ['NNP'],
  'Montgoris': ['NNP'],
  'Month': ['NNP'],
  'Monthly': ['NNP'],
  'Months': ['NNS'],
  'Monticciolo': ['NNP'],
  'Monticello': ['NNP'],
  'Montle': ['NNP'],
  'Montmartre': ['NNP'],
  'Montpelier': ['NNP'],
  'Montrachet': ['NNP'],
  'Montreal': ['NNP'],
  'Montreal-Toronto': ['JJ'],
  'Montreal-based': ['JJ'],
  'Montreux': ['NNP'],
  'Montrose': ['NNP'],
  'Montserrat': ['NNP'],
  'Montvale': ['NNP'],
  'Monty': ['NNP'],
  'Monument': ['NNP'],
  'Mony': ['NNP'],
  'Mood': ['NNP'],
  'Moods': ['NNP'],
  'Moody': ['NNP'],
  'Moog': ['NNP'],
  'Moon': ['NNP'],
  'Moon-faced': ['JJ'],
  'Moonachie': ['NNP'],
  'Moonan': ['NNP'],
  'Mooney': ['NNP'],
  'Moonie': ['NN'],
  'Moonies': ['NNPS'],
  'Moonlighting': ['NN'],
  'Moore': ['NNP'],
  'Moorhead': ['NNP'],
  'Moorish': ['JJ'],
  'Moors': ['NNPS'],
  'Moos': ['NNP'],
  'Moosilauke': ['NNP'],
  'Mor-ee-air-teeeee': ['NNP'],
  'Moraine': ['NNP'],
  'Moral': ['NNP'],
  'Morale': ['NN'],
  'Morals': ['NNS'],
  'Moran': ['NNP'],
  'Morarji': ['NNP'],
  'Moravcsik': ['NNP'],
  'Moravian': ['NNP'],
  'Morbid': ['JJ'],
  'Morcott': ['NNP'],
  'More': ['RBR'],
  'More-detailed': ['JJR'],
  'Moreau': ['NNP'],
  'Morehouse': ['NNP'],
  'Moreira': ['NNP'],
  'Morel': ['NNP'],
  'Moreland': ['NNP'],
  'Morelli': ['NNP'],
  'Moreno': ['NNP'],
  'Moreover': ['RB'],
  'Moreton': ['NNP'],
  'Morever': ['RB'],
  'Morey': ['NNP'],
  'Morfey': ['NNP'],
  'Morgan': ['NNP'],
  'Morgantown': ['NNP'],
  'Morgart': ['NNP'],
  'Morgenthau': ['NNP'],
  'Morgenzon': ['NNP'],
  'Mori': ['NNP'],
  'Moriarty': ['NNP'],
  'Morikawa': ['NNP'],
  'Morimoto': ['NNP'],
  'Morin': ['NNP'],
  'Morinaga': ['NNP'],
  'Morino': ['NNP'],
  'Morishita': ['NNP'],
  'Morison': ['NNP'],
  'Morita': ['NNP'],
  'Moritz': ['NNP'],
  'Morley': ['NNP'],
  'Mormon': ['NNP'],
  'Morning': ['NNP'],
  'MorningStar': ['NNP'],
  'Morningstar': ['NNP'],
  'Moroccan': ['NNP'],
  'Morocco': ['NNP'],
  'Moross': ['NNP'],
  'Morover': ['JJR'],
  'Morozov': ['NNP'],
  'Morphophonemic': ['JJ'],
  'Morrell': ['NNP'],
  'Morrill': ['NNP'],
  'Morris': ['NNP'],
  'Morrison': ['NNP'],
  'Morrissey': ['NNP'],
  'Morristown': ['NNP'],
  'Morrow': ['NNP'],
  'Morse': ['NNP'],
  'Mort': ['NNP'],
  'Mortage': ['NNP'],
  'Mortality': ['NN'],
  'Mortals': ['NNS'],
  'Mortar': ['NNP'],
  'Mortars': ['NNS'],
  'Mortgage': ['NNP'],
  'Mortgage-Backed': ['JJ'],
  'Mortgage-backed': ['JJ'],
  'Mortimer': ['NNP'],
  'Morton': ['NNP'],
  'Morvillo': ['NNP'],
  'Mory': ['NNP'],
  'Mosbacher': ['NNP'],
  'Moscom': ['NNP'],
  'Moscone': ['NNP'],
  'Moscow': ['NNP'],
  'Moscow-Shannon': ['JJ'],
  'Moscow-allied': ['JJ'],
  'Moscow-based': ['JJ'],
  'Mose': ['NNP'],
  'Moselle': ['NNP'],
  'Moses': ['NNP'],
  'Mosettig': ['NNP'],
  'Moshe': ['NNP'],
  'Mosher': ['NNP'],
  'Mosk': ['NNP'],
  'Moskovskaya': ['NNP'],
  'Mosle': ['NNP'],
  'Moslem': ['NNP'],
  'Moslems': ['NNPS'],
  'Mosnier': ['NN'],
  'Mosque': ['NNP'],
  'Moss': ['NNP'],
  'Mossberg': ['JJ'],
  'Mossman': ['NNP'],
  'Mossoviet': ['NNP'],
  'Most': ['JJS'],
  'Most-Favored': ['JJS'],
  'Most-Remarkable': ['JJS'],
  'Most-recommended': ['JJ'],
  'Mostly': ['RB'],
  'Motel': ['NNP'],
  'Mother': ['NNP'],
  'Mothers': ['NNPS'],
  'Motherwell': ['NNP'],
  'Motif': ['NN'],
  'Motion': ['NNP'],
  'Motion-picture': ['JJ'],
  'Motivated': ['VBN'],
  'Motive': ['NN'],
  'Motley': ['NNP'],
  'Moto': ['NNP'],
  'Motor': ['NNP'],
  'Motorcars': ['NNPS'],
  'Motorcycle': ['NNP'],
  'Motorcycles': ['NNS'],
  'Motoren': ['NNP'],
  'Motoren-und': ['NNP'],
  'Motorfair': ['NNP'],
  'Motorists': ['NNS'],
  'Motorized': ['NNP'],
  'Motorola': ['NNP'],
  'Motors': ['NNPS'],
  'Motown': ['NNP'],
  'Motoyuki': ['NNP'],
  'Motsoaledi': ['NNP'],
  'Mott': ['NNP'],
  'Mottice': ['NNP'],
  'Mottram': ['NNP'],
  'Mottus': ['NNP'],
  'Mouchet': ['NNP'],
  'Moudy': ['NNP'],
  'Mough': ['NN'],
  'Moulin': ['NNP'],
  'Moulinex': ['NNP'],
  'Moulins': ['NNP'],
  'Moulton': ['NNP'],
  'Moultons': ['NNPS'],
  'Mound': ['NNP'],
  'Moune': ['NNP'],
  'Mount': ['NNP'],
  'Mountain': ['NNP'],
  'Mountain-Hi': ['NNP'],
  'MountainBikes': ['NNPS'],
  'Mountaineer': ['NNP'],
  'Mountaineering': ['NNP'],
  'Mountains': ['NNPS'],
  'Mounted': ['NNP'],
  'Mourning': ['VBG'],
  'Mouse': ['NNP'],
  'Mousie': ['NNP'],
  'Mouth': ['NNP'],
  'Mouvement': ['NNP'],
  'Movable': ['JJ'],
  'Movats': ['NNP'],
  'Move': ['VB'],
  'Movement': ['NNP'],
  'Movements': ['NNS'],
  'Moves': ['NNS'],
  'Movie': ['NNP'],
  'Movieline': ['NNP'],
  'Movies': ['NNP'],
  'Movietime\\\'/Alfalfa': ['NNP'],
  'Moving': ['VBG'],
  'Moxley': ['NNP'],
  'Moynihan': ['NNP'],
  'Mozambiquans': ['NNS'],
  'Mozambique': ['NNP'],
  'Mozart': ['NNP'],
  'Mr': ['NNP'],
  'Mr.': ['NNP'],
  'Mrad': ['NN'],
  'Mrads': ['NNS'],
  'Mrs': ['NNP'],
  'Mrs.': ['NNP'],
  'Ms': ['NNP'],
  'Ms.': ['NNP'],
  'Msec.': ['NNS'],
  'Mt': ['NNP'],
  'Mt.': ['NNP'],
  'Mts.': ['NNP'],
  'Muammar': ['NNP'],
  'Mubarak': ['NNP'],
  'Much': ['RB'],
  'Muck': ['NNP'],
  'Mud': ['NNP'],
  'Mudd': ['NNP'],
  'Mudge': ['NNP'],
  'Mudugno': ['NNP'],
  'Mueller': ['NNP'],
  'Muench': ['NNP'],
  'Muenchen': ['NNP'],
  'Muenchmeyer': ['NNP'],
  'Mueslix': ['NNP'],
  'Muffin': ['NNP'],
  'Muffler': ['NNP'],
  'Muffling': ['VBG'],
  'Mugabe': ['NNP'],
  'Muggeridge': ['NNP'],
  'Muhammad': ['NNP'],
  'Muir': ['NNP'],
  'Mukachevo': ['NNP'],
  'Mukherjee': ['NNP'],
  'Muki': ['NNP'],
  'Mulberry': ['NNP'],
  'Mulcahy': ['NNP'],
  'Muldoon': ['NNP'],
  'Mulford': ['NNP'],
  'Mulhouse': ['NNP'],
  'Mullaney': ['NNP'],
  'Mullen': ['NNP'],
  'Mullenax': ['NNP'],
  'Mullendore': ['NNP'],
  'Muller': ['NNP'],
  'Mullerin': ['NNP'],
  'Mulligan': ['NNP'],
  'Mulligatawny': ['NNP'],
  'Mullins': ['NNP'],
  'Mulloy': ['NNP'],
  'Mulroney': ['NNP'],
  'Mulrooney': ['NNP'],
  'Multi-Income': ['NNP'],
  'Multi-employer': ['JJ'],
  'MultiMedia': ['NNP'],
  'Multiflow': ['NNP'],
  'Multifoods': ['NNP'],
  'Multilateral': ['NNP'],
  'Multimate': ['NNP'],
  'Multimedia': ['NNP'],
  'Multinational': ['JJ'],
  'Multiphastic': ['NNP'],
  'Multiple': ['NNP'],
  'Multiples': ['NNPS'],
  'Multiplexers': ['NNS'],
  'Multiplication': ['NN'],
  'Multiply': ['VB'],
  'Multiplying': ['VBG'],
  'Multnomah': ['NNP'],
  'Mulvoy': ['NNP'],
  'Mumford': ['NNP'],
  'Munchen': ['NNP'],
  'Munching': ['VBG'],
  'Muncie': ['NNP'],
  'Muncie-Peru': ['NNP'],
  'Muncipal': ['NNP'],
  'Muncke': ['NNP'],
  'Mundo': ['NNP'],
  'Mundt': ['NNP'],
  'Munger': ['NNP'],
  'Muni': ['JJ'],
  'Muniak': ['NNP'],
  'Munich': ['NNP'],
  'Munich-based': ['JJ'],
  'Municipal': ['JJ'],
  'Municipalities': ['NNS'],
  'Municipals': ['NNS'],
  'Muniz': ['NNP'],
  'Munk': ['NNP'],
  'Munoz': ['NNP'],
  'Munro': ['NNP'],
  'Munroe': ['NNP'],
  'Munsell': ['NNP'],
  'Munster': ['NNP'],
  'Munsters': ['NNPS'],
  'Muong': ['NNP'],
  'Murai': ['NNP'],
  'Murakami': ['NNP'],
  'Muramatsu': ['NNP'],
  'Murasawa': ['NNP'],
  'Murat': ['NNP'],
  'Murata': ['NNP'],
  'Muratore': ['NNP'],
  'Murder': ['NN'],
  'Murderers': ['NNS'],
  'Murderous': ['JJ'],
  'Murders': ['NNS'],
  'Murdoch': ['NNP'],
  'Murfreesboro': ['NNP'],
  'Murguia': ['NNP'],
  'Murilo': ['NNP'],
  'Murjani': ['NNP'],
  'Murkland': ['NNP'],
  'Murmann': ['NNP'],
  'Murphy': ['NNP'],
  'Murray': ['NNP'],
  'Murrin': ['NNP'],
  'Murrow': ['NNP'],
  'Murtaugh': ['NNP'],
  'Murville': ['NNP'],
  'Muscat': ['NNP'],
  'Muscatine': ['NNP'],
  'Muscle': ['NN'],
  'Muscolina': ['NNP'],
  'Muscovite': ['NNP'],
  'Muscovites': ['NNS'],
  'Muscovy': ['NNP'],
  'Muscular': ['NNP'],
  'Muse': ['NNP'],
  'Musee': ['NNP'],
  'Muses': ['NNP'],
  'Museum': ['NNP'],
  'Museums': ['NNS'],
  'Mushkat': ['NNP'],
  'Mushr': ['NN'],
  'Musial': ['NNP'],
  'Music': ['NNP'],
  'Musica': ['NNP'],
  'Musical': ['NNP'],
  'Musicale': ['NNP'],
  'Musically': ['RB'],
  'Musician': ['NN'],
  'Musicians': ['NNS'],
  'Musil': ['NNP'],
  'Musique': ['NNP'],
  'Muskegon': ['NNP'],
  'Muskoka': ['NNP'],
  'Muslim': ['NNP'],
  'Muslims': ['NNPS'],
  'Musmanno': ['NNP'],
  'Muss': ['NNP'],
  'Mussett': ['NNP'],
  'Mussolini': ['NNP'],
  'Mussolini-like': ['JJ'],
  'Mussolinis': ['NNPS'],
  'Mussorgsky': ['NNP'],
  'Must': ['MD'],
  'Mustafa': ['NNP'],
  'Mustain': ['NNP'],
  'Mustang': ['NNP'],
  'Mustangs': ['NNP'],
  'Mustard': ['NN'],
  'Mutant': ['NNP'],
  'Mutants': ['NNS'],
  'Mutchin': ['NNP'],
  'Mutinies': ['NNS'],
  'Mutsch': ['NNP'],
  'Mutton': ['NNP'],
  'Mutual': ['NNP'],
  'Mutual-fund': ['JJ'],
  'Mutuelles': ['NNP'],
  'Muynak': ['NNP'],
  'Muzak': ['NNP'],
  'Muzo': ['NNP'],
  'Muzyka': ['NNP'],
  'Muzzling': ['JJ'],
  'My': ['PRP\$'],
  'Mycenae': ['NNP'],
  'Myers': ['NNP'],
  'Myerson': ['NNP'],
  'Mylan': ['NNP'],
  'Mylanta': ['NNP'],
  'Mylar': ['NNP'],
  'Mynheer': ['NNP'],
  'Myra': ['NNP'],
  'Myrdal': ['NNP'],
  'Myron': ['NNP'],
  'Myrtle': ['NNP'],
  'Myself': ['NNP'],
  'Mysteries': ['NNP'],
  'Mysterious': ['JJ'],
  'Mystery': ['NN'],
  'Myth': ['NNP'],
  'Mythical': ['JJ'],
  'Mythological': ['JJ'],
  'Mytton': ['NNP'],
  'Myung': ['NNP'],
  'N': ['NN'],
  'N\'Djamena': ['NNP'],
  'N-W': ['NNP'],
  'N-acetylcysteine': ['NNP'],
  'N-no': ['UH'],
  'N.': ['NNP'],
  'N.A': ['NN'],
  'N.A.': ['NNP'],
  'N.C': ['NNP'],
  'N.C.': ['NNP'],
  'N.C.-based': ['JJ'],
  'N.D': ['NNP'],
  'N.D.': ['NNP'],
  'N.E.': ['NNP'],
  'N.F.': ['NNP'],
  'N.H': ['NNP'],
  'N.H.': ['NNP'],
  'N.J': ['NNP'],
  'N.J.': ['NNP'],
  'N.J.-based': ['JJ'],
  'N.L.': ['NNP'],
  'N.M': ['NNP'],
  'N.M.': ['NNP'],
  'N.M.-based': ['JJ'],
  'N.R.': ['NNP'],
  'N.V': ['NNP'],
  'N.V.': ['NNP'],
  'N.Y': ['NNP'],
  'N.Y.': ['NNP'],
  'N.Y.-based': ['JJ'],
  'N.Y.U.': ['NNP'],
  'N/NNP.Y.C.': ['NNP'],
  'NAACP': ['NNP'],
  'NAB': ['NNP'],
  'NAC': ['NNP'],
  'NAEBM': ['NNP'],
  'NAFTA': ['NNP'],
  'NAHB': ['NNP'],
  'NAIR': ['NNP'],
  'NAIRO': ['NNP'],
  'NALU': ['NNP'],
  'NAM': ['NNP'],
  'NAR': ['NNP'],
  'NAREB': ['NNP'],
  'NAS': ['NNP'],
  'NASA': ['NNP'],
  'NASA-Air': ['NNP'],
  'NASAA': ['NNP'],
  'NASD': ['NNP'],
  'NASDA': ['NNP'],
  'NASDAQ': ['NNP'],
  'NATION\'S': ['NN'],
  'NATIONAL': ['NNP'],
  'NATIONWIDE': ['NNP'],
  'NATO': ['NNP'],
  'NATO-Warsaw': ['NNP'],
  'NAV:22.15': ['NN'],
  'NB': ['NNP'],
  'NBA': ['NNP'],
  'NBC': ['NNP'],
  'NBC-Sears': ['NNP'],
  'NBC-TV': ['NNP'],
  'NBC-owned': ['JJ'],
  'NBI': ['NNP'],
  'NBS': ['NNP'],
  'NC': ['NNP'],
  'NCAA': ['NNP'],
  'NCAAs': ['NNS'],
  'NCB': ['NNP'],
  'NCI': ['NNP'],
  'NCNB': ['NNP'],
  'NCR': ['NNP'],
  'NCTA': ['NNP'],
  'NDN': ['NNP'],
  'NE': ['NNP'],
  'NEA': ['NNP'],
  'NEARLY': ['JJ'],
  'NEATNESS': ['NN'],
  'NEC': ['NNP'],
  'NEC-compatible': ['JJ'],
  'NED': ['NNP'],
  'NEEDS': ['NNS'],
  'NEG': ['NNP'],
  'NEKOOSA': ['NNP'],
  'NESB': ['NNP'],
  'NET': ['JJ'],
  'NETWORK': ['NN'],
  'NEVER': ['RB'],
  'NEW': ['JJ'],
  'NEWHALL': ['NNP'],
  'NEWS': ['NN'],
  'NEWSPAPERS': ['NNS'],
  'NEWT': ['NN'],
  'NFA': ['NNP'],
  'NFC': ['NNP'],
  'NFIB': ['NNP'],
  'NFL': ['NNP'],
  'NGL': ['NNP'],
  'NH': ['NNP'],
  'NHI': ['NNP'],
  'NHL': ['NNP'],
  'NHTSA': ['NNP'],
  'NIAGARA': ['NNP'],
  'NICHOLS': ['NNP'],
  'NIGHT': ['NN'],
  'NIH': ['NNP'],
  'NIH-appointed': ['JJ'],
  'NJ': ['NNP'],
  'NKF': ['NNP'],
  'NKK': ['NNP'],
  'NL': ['NNP'],
  'NL.': ['NNP'],
  'NLD': ['NNP'],
  'NLO': ['NNP'],
  'NLRB': ['NNP'],
  'NLRDA': ['NNP'],
  'NMB': ['NNP'],
  'NME': ['NNP'],
  'NMR': ['NNP'],
  'NMS': ['NNP'],
  'NMTBA': ['NNP'],
  'NO': ['DT'],
  'NOC': ['NNP'],
  'NOP': ['NN'],
  'NORAD': ['NNP'],
  'NORC': ['NNP'],
  'NORDSTROM': ['NNP'],
  'NORIEGA': ['NNP'],
  'NORIEGA\'S': ['NNP'],
  'NORTH': ['NNP'],
  'NORTHEAST': ['NN'],
  'NORTHERN': ['NNP'],
  'NOT': ['RB'],
  'NOT-GUILTY': ['JJ'],
  'NOTE': ['NN'],
  'NOTES': ['NNS'],
  'NOVA': ['NNP'],
  'NOVEMBER': ['NNP'],
  'NOW': ['RB'],
  'NP': ['NNP'],
  'NP-27': ['NNP'],
  'NPD': ['NNP'],
  'NPL': ['NNP'],
  'NRA': ['NNP'],
  'NRC': ['NNP'],
  'NRDC': ['NNP'],
  'NRL': ['NNP'],
  'NRLDA': ['NNP'],
  'NRM': ['NNP'],
  'NS': ['NNP'],
  'NS-X': ['NNP'],
  'NSA': ['NNP'],
  'NSBU': ['NNP'],
  'NSC': ['NNP'],
  'NSM': ['NNP'],
  'NSPA': ['NNP'],
  'NT&SA': ['NNP'],
  'NT&SA-run': ['JJ'],
  'NTC': ['NNP'],
  'NTG': ['NNP'],
  'NTSB': ['NNP'],
  'NTT': ['NNP'],
  'NU': ['NNP'],
  'NUCLEAR': ['NN'],
  'NUM': ['NNP'],
  'NUMBER': ['NN'],
  'NUMBERS': ['NNS'],
  'NURSING': ['NN'],
  'NUS': ['NNP'],
  'NV': ['NNP'],
  'NW': ['NNP'],
  'NWA': ['NNP'],
  'NY': ['NNP'],
  'NYC': ['NNP'],
  'NYSE': ['NNP'],
  'NYU': ['NNP'],
  'NZ\$': ['\$'],
  'NZI': ['NNP'],
  'Nabisco': ['NNP'],
  'Nabokov': ['NNP'],
  'Nac': ['NNP'],
  'Nacchio': ['NNP'],
  'Nachman': ['NNP'],
  'Nachmany': ['NNP'],
  'Nacht': ['FW'],
  'Nacion': ['NNP'],
  'Nacional': ['NNP'],
  'Naclerio': ['NNP'],
  'Nadeau': ['NNP'],
  'Nadelmann': ['NNP'],
  'Nader': ['NNP'],
  'Naderite': ['NNP', 'JJ'],
  'Naderites': ['NNS'],
  'Nadine': ['NNP'],
  'Nadir': ['NNP'],
  'Nadja': ['NNP'],
  'Nae': ['UH'],
  'Naess': ['NNP'],
  'Naftalis': ['NNP'],
  'Naga': ['NNPS'],
  'Nagamo': ['NNP'],
  'Naganawa': ['NNP'],
  'Nagano': ['NNP'],
  'Nagasaki': ['NNP'],
  'Nagayama': ['NNP'],
  'Nagel': ['NNP'],
  'Nagelvoort': ['NNP'],
  'Nagin': ['NNP'],
  'Nagle': ['NNP'],
  'Nagorno-Karabakh': ['NNP'],
  'Nagorski': ['NNP'],
  'Nagoya': ['NNP'],
  'Nagrin': ['NNP'],
  'Naguib': ['NNP'],
  'Nagy': ['NNP'],
  'NagyAntal': ['NNP'],
  'Nagykanizsa': ['NNP'],
  'Nagymaros': ['NNP'],
  'Nahas': ['NNP'],
  'Nail': ['NNP'],
  'Naiman': ['NNP'],
  'Nairne': ['NNP'],
  'Nairobi': ['NNP'],
  'Naive': ['JJ'],
  'Najarian': ['NNP'],
  'Naji': ['NNP'],
  'Nakagawa': ['NNP'],
  'Nakajima': ['NNP'],
  'Nakamura': ['NNP'],
  'Nakasone': ['NNP'],
  'Nakayasu': ['NNP'],
  'Nakazato': ['NNP'],
  'Naked': ['JJ'],
  'Nakhamkin': ['NNP'],
  'Nakoma': ['NNP'],
  'Naktong': ['NNP'],
  'Nalbone': ['NNP'],
  'Nalcor': ['NNP'],
  'Nalick': ['NNP'],
  'Nam': ['NNP'],
  'Name': ['NN'],
  'Name-dropping': ['NN'],
  'Named': ['VBN'],
  'Nameless': ['NNP'],
  'Namely': ['RB'],
  'Names': ['NNS'],
  'Namib': ['NNP'],
  'Namibia': ['NNP'],
  'Namibian': ['JJ'],
  'Namibian-independence': ['NN'],
  'Nan': ['NNP'],
  'Nana': ['NNP'],
  'Nancy': ['NNP'],
  'Nando': ['NNP'],
  'Nanjing': ['NNP'],
  'Nanofilm': ['NNP'],
  'Nanook': ['NNP'],
  'Nantucket': ['NNP'],
  'Naomi': ['NNP'],
  'Nap': ['NNP'],
  'Napa': ['NNP'],
  'Naperville': ['NNP'],
  'Naphta': ['NNP'],
  'Napkin': ['NN'],
  'Napkins': ['NNS'],
  'Naples': ['NNP'],
  'Naples-born': ['JJ'],
  'Napoleon': ['NNP'],
  'Napoleonic': ['JJ'],
  'Napolitan': ['NNP'],
  'Nara': ['NNP'],
  'Narberth': ['NNP'],
  'Narbonne': ['NNP'],
  'Narcotics': ['NNPS'],
  'Naren': ['NNP'],
  'Narita': ['NNP'],
  'Narragansett': ['NNP'],
  'Narrative': ['JJ'],
  'Narrow': ['JJ'],
  'Narrow-gauged': ['JJ'],
  'Narrowing': ['VBG'],
  'Narrowly': ['NNP'],
  'Narver': ['NNP'],
  'Nary': ['NNP'],
  'Nasdaq': ['NNP'],
  'Nasdaq-traded': ['JJ'],
  'Nasdaq\\\'/National': ['NNP'],
  'Nash': ['NNP'],
  'Nashua': ['NNP'],
  'Nashville': ['NNP'],
  'Nasional': ['NNP'],
  'Nassau': ['NNP'],
  'Nassau-Suffolk': ['NNP'],
  'Nasser': ['NNP'],
  'Nast': ['NNP'],
  'Naster': ['NNP'],
  'Nastro': ['NNP'],
  'Nasty': ['JJ'],
  'Nat': ['NNP'],
  'NatWest': ['NNP'],
  'Natalia': ['NNP'],
  'Natalie': ['NNP'],
  'Natcher': ['NNP'],
  'Natchez': ['NNP'],
  'Nate': ['NNP'],
  'Nath': ['NNP'],
  'Nathan': ['NNP'],
  'Nathan-Bond': ['NNP'],
  'Nathanael': ['NNP'],
  'Nathaniel': ['NNP'],
  'Natick': ['NNP'],
  'Nation': ['NN'],
  'National': ['NNP'],
  'Nationalcar': ['NNP'],
  'Nationale': ['NNP'],
  'Nationalism': ['NN'],
  'Nationalist': ['JJ'],
  'Nationalistic': ['JJ'],
  'Nationalists': ['NNPS'],
  'Nationalized': ['VBN'],
  'Nationally': ['RB'],
  'Nations': ['NNPS'],
  'Nations-monitored': ['JJ'],
  'Nationwide': ['NNP'],
  'Native': ['NNP'],
  'Natrona': ['NNP'],
  'Nattily': ['RB'],
  'Natural': ['NNP'],
  'Naturalization': ['NNP'],
  'Naturally': ['RB'],
  'Naturals': ['NNPS'],
  'Naturam': ['FW'],
  'Nature': ['NNP'],
  'Natwest': ['NNP'],
  'Nauman': ['NNP'],
  'Naumberg': ['NNP'],
  'Nausea': ['NN'],
  'Nautilus': ['NNP'],
  'Navajo': ['NNP'],
  'Navajos': ['NNPS'],
  'Naval': ['NNP'],
  'Navcom': ['NNP'],
  'NavforJapan': ['NNP'],
  'Navigation': ['NNP'],
  'Navin': ['NNP'],
  'Navistar': ['NNP'],
  'Navona': ['NNP'],
  'Navy': ['NNP'],
  'Naw': ['UH'],
  'Nawal': ['NNP'],
  'Nawbo': ['NNP'],
  'Naxos': ['NNP'],
  'Nazal': ['NNP'],
  'Nazar': ['NNP'],
  'Nazarene': ['NNP'],
  'Nazario': ['NNP'],
  'Nazarova': ['NNP'],
  'Nazem': ['NNP'],
  'Nazer': ['NNP'],
  'Nazi': ['NNP'],
  'Nazi-minded': ['JJ'],
  'Nazi-occupied': ['JJ'],
  'Nazia': ['NNP'],
  'Nazionale': ['NNP'],
  'Nazis': ['NNPS'],
  'Nazism': ['NNP'],
  'Nazzella': ['NNP'],
  'Ndola': ['NNP'],
  'Ne': ['NNP'],
  'Neal': ['NNP'],
  'Neanderthal': ['JJ'],
  'Neanderthals': ['NNS'],
  'Neapolitan': ['NNP'],
  'Near': ['IN'],
  'Near-Term': ['RB'],
  'Near-term': ['JJ'],
  'Nearby': ['RB'],
  'Nearing': ['VBG'],
  'Nearly': ['RB'],
  'Nearness': ['NN'],
  'Neas': ['NNP'],
  'Neave': ['NNP'],
  'Neb': ['NNP'],
  'Neb.': ['NNP'],
  'Neb.-based': ['JJ'],
  'Neblett': ['NNP'],
  'Nebraska': ['NNP'],
  'Nec': ['FW'],
  'Necci': ['NNP'],
  'Necesarily': ['NNP'],
  'Necessary': ['JJ'],
  'Necessity': ['NN'],
  'Neck': ['NNP'],
  'Necklace': ['NNP'],
  'Ned': ['NNP'],
  'Nedelman': ['NNP'],
  'Nedelya': ['NNP'],
  'Nederland': ['NNP'],
  'Nederlanden': ['NNP'],
  'Nederlander': ['NNP'],
  'Nederlandsche': ['NNP'],
  'Nederlandse': ['NNP'],
  'Nedlloyd': ['NNP'],
  'Neece': ['NNP'],
  'Need': ['VB'],
  'Needham': ['NNP'],
  'Needing': ['VBG'],
  'Needless': ['JJ'],
  'Needs': ['NNS'],
  'Needy': ['NNP'],
  'Neesen': ['NNP'],
  'Neff': ['NNP'],
  'Negas': ['NNP'],
  'Negative': ['JJ'],
  'Neglect': ['VBP'],
  'Neglected': ['NNP'],
  'Neglecting': ['VBG'],
  'Negligence': ['NN'],
  'Negmegan': ['NNP'],
  'Negotiable': ['JJ'],
  'Negotiating': ['VBG'],
  'Negotiation': ['NN'],
  'Negotiations': ['NNS'],
  'Negotiators': ['NNS'],
  'Negro': ['NNP'],
  'Negro-appeal': ['JJ'],
  'Negroes': ['NNPS'],
  'Negroid': ['JJ'],
  'Negus': ['NNP'],
  'Nehf': ['NNP'],
  'Nehru': ['NNP'],
  'Neibart': ['NNP'],
  'Neidl': ['NNP'],
  'Neighbor': ['NN'],
  'Neihart': ['NNP'],
  'Neil': ['NNP'],
  'Neill': ['NNP'],
  'Neils': ['NNP'],
  'Neilson': ['NNP'],
  'Neiman': ['NNP'],
  'Neiman-Marcus': ['NNP'],
  'Neinas': ['NNP'],
  'Neisse': ['NNP'],
  'Neisse-Oder': ['NNP'],
  'Neither': ['CC'],
  'Neitzbohr': ['NNP'],
  'Nekoosa': ['NNP'],
  'Nell': ['NNP'],
  'Nellcor': ['NNP'],
  'Nellie': ['NNP'],
  'Nellies': ['NNPS'],
  'Nelms': ['NNP'],
  'Nelson': ['NNP'],
  'Nelson-Atkins': ['NNP'],
  'Nemesis': ['NNP'],
  'Nemeth': ['NNP'],
  'Nennius': ['NNP'],
  'Neo-Classicism': ['NNP'],
  'Neo-Classicists': ['NNPS'],
  'Neo-Ecclesiasticism': ['NNP'],
  'Neo-Jazz': ['NNP'],
  'Neo-Paganism': ['NNP'],
  'Neo-Popularism': ['NNP'],
  'Neo-Romanticism': ['NNP'],
  'Neoax': ['NNP'],
  'Neodata': ['NNP'],
  'Neoliberal': ['JJ'],
  'Neon': ['NNP'],
  'Nepal': ['NNP'],
  'Nepalese': ['NNPS'],
  'Neptune': ['NNP'],
  'Nerds': ['NNS'],
  'Nerien': ['NNP'],
  'Nerio': ['NNP'],
  'Nernst': ['NNP'],
  'Nero': ['NNP'],
  'Nerves': ['NNS'],
  'Nervous': ['JJ'],
  'Nervousness': ['NN'],
  'Nesbit': ['NNP'],
  'Nesbitt': ['NNP'],
  'Nesconset': ['NNP'],
  'Nesi': ['NNP'],
  'Nessel': ['NNP'],
  'Nessen': ['NNP'],
  'Nest': ['NNP'],
  'Neste': ['NNP'],
  'Nestle': ['NNP'],
  'Nestled': ['VBN'],
  'Nestor': ['NNP'],
  'Net': ['JJ'],
  'NetFrame': ['NNP'],
  'NetWare': ['NNP'],
  'Netherland': ['NNP'],
  'Netherlands': ['NNP'],
  'Netherlands-based': ['JJ'],
  'Netsch': ['NNP'],
  'Nett': ['NNP'],
  'Nettleton': ['NNP'],
  'Netto': ['NNP'],
  'Netty': ['NNP'],
  'Network': ['NNP'],
  'Network-access': ['JJ'],
  'Networks': ['NNP'],
  'Neubauer': ['NNP'],
  'Neuberger': ['NNP'],
  'Neue': ['NNP'],
  'Neuharth': ['NNP'],
  'Neuharths': ['NNPS'],
  'Neuhaus': ['NNP'],
  'Neumann': ['NNP'],
  'Neurenschatz': ['NNP'],
  'Neurex': ['NNP'],
  'Neurological': ['NNP'],
  'Neurosciences': ['NNP'],
  'Neurotron': ['NNP'],
  'Neusteter': ['NNP'],
  'Neusteters': ['NNP'],
  'Neutral': ['NNP'],
  'Nev': ['NNP'],
  'Nev.': ['NNP'],
  'Nevada': ['NNP'],
  'Nevah': ['NNP'],
  'Neveh': ['NNP'],
  'Never': ['RB'],
  'Nevermind': ['VB'],
  'Neversink': ['NNP'],
  'Nevertheless': ['RB'],
  'Neveu': ['NNP'],
  'Neville': ['NNP'],
  'Nevsky': ['NNP'],
  'New': ['NNP'],
  'New-England': ['NNP'],
  'New-Waver': ['NNP'],
  'New-York': ['NNP'],
  'New-construction': ['NN'],
  'New-home': ['JJ'],
  'New-issue': ['JJ'],
  'NewVector': ['NNP'],
  'Newall': ['NNP'],
  'Newark': ['NNP'],
  'Newarker': ['NNP'],
  'Newberg': ['NNP'],
  'Newbery': ['NNP'],
  'Newbiggin': ['NNP'],
  'Newbold': ['NNP'],
  'Newbridge': ['NNP'],
  'Newburger': ['NNP'],
  'Newburgh': ['NNP'],
  'Newbury': ['NNP'],
  'Newburyport': ['NNP'],
  'Newcastle': ['NNP'],
  'Newcomb': ['NNP'],
  'Newcomers': ['NNS'],
  'Newell': ['NNP'],
  'Newells': ['NNPS'],
  'Newer': ['JJR'],
  'Newest': ['JJS'],
  'Newfoundland': ['NNP'],
  'Newgate': ['NNP'],
  'Newhart': ['NNP'],
  'Newhouse': ['NNP'],
  'Newitt': ['NNP'],
  'Newkirk': ['NNP'],
  'Newly': ['RB'],
  'Newlywed': ['NNP'],
  'Newman': ['NNP'],
  'Newmark': ['NNP'],
  'Newmont': ['NNP'],
  'Newport': ['NNP'],
  'Newport-based': ['JJ'],
  'Newquist': ['NNP'],
  'News': ['NNP'],
  'News-American': ['NNP'],
  'NewsEdge': ['NNP'],
  'NewsHour': ['NNP'],
  'News\\\'/Retrieval': ['NNP'],
  'Newsday': ['NNP'],
  'Newshour': ['NN'],
  'Newsletter': ['NNP'],
  'Newsnight': ['NNP'],
  'Newsom': ['NNP'],
  'Newsote': ['NNP'],
  'Newspaper': ['NNP'],
  'Newspapermen': ['NNS'],
  'Newspapers': ['NNPS'],
  'Newspeak': ['NNP'],
  'Newsprint': ['NN'],
  'Newsreel': ['NNP'],
  'Newsstands': ['NNS'],
  'Newsweek': ['NNP'],
  'Newswire': ['NNP'],
  'Newt': ['NNP'],
  'Newton': ['NNP'],
  'Newton-John': ['NNP'],
  'Newtonian': ['JJ'],
  'Newtonville': ['NNP'],
  'Newtown': ['NNP'],
  'Newts': ['NNP'],
  'Next': ['JJ'],
  'Next-Most-Remarkable': ['JJ'],
  'Nezhari': ['NNP'],
  'Ng': ['NNP'],
  'Nghe': ['NNP'],
  'Ngo': ['NNP'],
  'Ngoc': ['NNP'],
  'Nguyen': ['NNP'],
  'Niagara': ['NNP'],
  'Niarchos': ['NNP'],
  'Nibble': ['NNP'],
  'Nibelungenlied': ['NNP'],
  'Nicandra': ['NNP'],
  'Nicaragua': ['NNP'],
  'Nicaraguan': ['JJ'],
  'Nicaraguans': ['NNPS'],
  'Nicastro': ['NNP'],
  'Niccolo': ['NNP'],
  'Nice': ['JJ'],
  'Niche-itis': ['NN'],
  'Nichias': ['NNP'],
  'Nichido': ['NNP'],
  'Nichol': ['NNP'],
  'Nicholas': ['NNP'],
  'Nichols': ['NNP'],
  'Nicholson': ['NNP'],
  'Nichtige': ['NN'],
  'Niciporuk': ['NNP'],
  'Nick': ['NNP'],
  'Nickel-iron': ['JJ'],
  'Nickelodeon': ['NNP'],
  'Nickelson': ['NNP'],
  'Nickerson': ['NNP'],
  'Nicki': ['NNP'],
  'Nicklaus': ['NNP'],
  'Nickle': ['NNP'],
  'Nickles': ['NNP'],
  'Nickless': ['NNP'],
  'Nico': ['NNP'],
  'Nicodemus': ['NNP'],
  'Nicol': ['NNP'],
  'Nicolas': ['NNP'],
  'Nicole': ['NNP'],
  'Nicolo': ['NNP'],
  'Nicolson': ['NNP'],
  'Nicos': ['NNP'],
  'Nicosia': ['NNP'],
  'Nidal': ['NNP'],
  'Niebuhr': ['NNP'],
  'Niedermaier': ['NNP'],
  'Niels': ['NNP'],
  'Nielsen': ['NNP'],
  'Nielson': ['NNP'],
  'Niem': ['NNP'],
  'Nieman': ['NNP'],
  'Niepce': ['NNP'],
  'Nietzsche': ['NNP'],
  'Nigel': ['NNP'],
  'Niger': ['NNP'],
  'Nigeria': ['NNP'],
  'Nigga': ['NN'],
  'Nigger': ['NN'],
  'Niggertown': ['NNP'],
  'Night': ['NNP'],
  'Nightclubs': ['NNPS'],
  'Nightingale': ['NN'],
  'Nightlife': ['NN'],
  'Nightline': ['NNP'],
  'Nightly': ['NNP'],
  'Nightmare': ['NNP'],
  'Nights': ['NNP'],
  'Nightshade': ['NNP'],
  'Nightwatch': ['NNP'],
  'Nihon': ['NNP'],
  'Nijinska': ['NNP'],
  'Nijinsky': ['NN'],
  'Nika': ['NNP'],
  'Nike': ['NNP'],
  'Nike-Zeus': ['NNP'],
  'Nikes': ['NNPS'],
  'Nikita': ['NNP'],
  'Nikitas': ['NNP'],
  'Nikka': ['NNP'],
  'Nikkei': ['NNP'],
  'Nikkhah': ['NNP'],
  'Nikko': ['NNP'],
  'Nikolai': ['NNP'],
  'Nikolais': ['NNP'],
  'Nikon': ['NNP'],
  'Nikonov': ['NNP'],
  'Nikons': ['NNPS'],
  'Nile': ['NNP'],
  'Niles': ['NNP'],
  'Nilsen': ['NNP'],
  'Nilson': ['NNP'],
  'Nilsson': ['NNP'],
  'Nimbus-7': ['NNP'],
  'Nimitz': ['NNP'],
  'Nina': ['NNP'],
  'Nine': ['CD'],
  'Nine-month': ['JJ'],
  'Nines': ['NNPS'],
  'Nineteen': ['CD'],
  'Nineteen-sixty': ['NNP'],
  'Nineteenth': ['JJ'],
  'Nineteenth-century': ['JJ'],
  'Nineties': ['NNPS'],
  'Ninety': ['CD'],
  'Ninety-Eight': ['NNP'],
  'Ninety-Two': ['NNP'],
  'Ninety-nine': ['CD'],
  'Nineveh': ['NNP'],
  'Ninja': ['NNP'],
  'Nino': ['NNP'],
  'Ninomiya': ['NNP'],
  'Nintendo': ['NNP'],
  'Nintendos': ['NNPS'],
  'Ninth': ['NNP'],
  'Niobe': ['VB'],
  'Nipe': ['NNP'],
  'Nipp': ['NNP'],
  'Nippon': ['NNP'],
  'Nipponese': ['JJ'],
  'Nippur': ['NN'],
  'Nipsco': ['NNP'],
  'Nisbet': ['NNP'],
  'Nischwitz': ['NNP'],
  'Nishi': ['NNP'],
  'Nishiki': ['NNP'],
  'Nishima': ['NNP'],
  'Nishimo': ['NNP'],
  'Nishimura': ['NNP'],
  'Nishizuka': ['NNP'],
  'Nissan': ['NNP'],
  'Nissans': ['NNPS'],
  'Nissei': ['NNP'],
  'Nisshin': ['NNP'],
  'Nisshinbo': ['NNP'],
  'Nissho': ['NNP'],
  'Nissho-Iwai': ['NNP'],
  'Nissin': ['NNP'],
  'Nite': ['NNP'],
  'Nitrogen': ['NN'],
  'Nitsuko': ['NNP'],
  'Nitto': ['NNP'],
  'Nitze': ['NNP'],
  'Niva': ['NNP'],
  'Niven': ['NNP'],
  'Nixdorf': ['NNP'],
  'Nixon': ['NNP'],
  'Nizer': ['NNP'],
  'Njust': ['NNP'],
  'Nkrumah': ['NNP'],
  'No': ['DT'],
  'No-Cal': ['NNP'],
  'No-Name': ['NNP'],
  'No-Smoking': ['NNP'],
  'No-Tobacco': ['NNP'],
  'No-o-o': ['UH'],
  'No.': ['NN'],
  'No.3': ['JJ'],
  'Noah': ['NNP'],
  'Noam': ['NNP'],
  'Nob': ['NNP'],
  'Nobel': ['NNP'],
  'Nobels': ['NNPS'],
  'Noble': ['NNP'],
  'Noblesville': ['NNP'],
  'Nobody': ['NN'],
  'Nobrega': ['NNP'],
  'Nobuto': ['NNP'],
  'Nobuya': ['NNP'],
  'Nobuyuki': ['NNP'],
  'Noces': ['NNP'],
  'Noctiluca': ['NN'],
  'Nocturne': ['NNP'],
  'Nod': ['NNP'],
  'Nodding': ['VBG'],
  'Noel': ['NNP'],
  'Noffsinger': ['NNP'],
  'Nofzinger': ['NNP'],
  'Nogales': ['NNP'],
  'Nogaret': ['NNP'],
  'Nogay': ['NNP'],
  'Nogol': ['NNP'],
  'Nokia': ['NNP'],
  'Nokomis': ['NNP'],
  'Nolan': ['NNP'],
  'Nolen': ['NNP'],
  'Noll': ['NNP'],
  'Nomani': ['NNP'],
  'Nomenklatura': ['NN'],
  'Nomi': ['NNP'],
  'Nomia': ['NNP'],
  'Nomination': ['NN'],
  'Nominations': ['NNS'],
  'Nomisma': ['NNP'],
  'Nomo': ['NNP'],
  'Nomura': ['NNP'],
  'Non': ['FW'],
  'Non-Catholics': ['NNS'],
  'Non-Dissonant': ['NNP'],
  'Non-God': ['UH'],
  'Non-Proliferation': ['NNP'],
  'Non-Smokers': ['NNP'],
  'Non-``': ['``'],
  'Non-actors': ['NNS'],
  'Non-bank': ['JJ'],
  'Non-callable': ['JJ'],
  'Non-cosmetic': ['JJ'],
  'Non-executive': ['JJ'],
  'Non-interest': ['JJ'],
  'Non-lawyers': ['NNS'],
  'Non-money': ['JJ'],
  'Non-performing': ['JJ'],
  'Non-residential': ['JJ'],
  'Non-smoking': ['NN'],
  'Non-steel': ['JJ'],
  'NonProfit': ['NNP'],
  'Nonbuilding': ['JJ'],
  'Nonconformist': ['NNP'],
  'Nonconformists': ['NNS'],
  'None': ['NN'],
  'Nonelectrical': ['JJ'],
  'Nonetheless': ['RB'],
  'Nonfat': ['NNP'],
  'Nonfinancial': ['JJ'],
  'Nonmagical': ['NNP'],
  'Nonperformers': ['NNS'],
  'Nonperforming': ['JJ'],
  'Nonprofit': ['JJ'],
  'Nonrecurring': ['JJ'],
  'Nonresident': ['JJ'],
  'Nonresidential': ['JJ'],
  'Nonsense': ['NN'],
  'Nonsexist': ['NNP'],
  'Nonsmokers': ['NNP'],
  'Nonspecific': ['JJ'],
  'Nonunion': ['NNP'],
  'Noon': ['NNP'],
  'Noonan': ['NNP'],
  'Noonday': ['NNP'],
  'Nope': ['UH'],
  'Nor': ['CC'],
  'Nora': ['NNP'],
  'Norall': ['NNP'],
  'Noranda': ['NNP'],
  'Norberg': ['NNP'],
  'Norbert': ['NNP'],
  'Norberto': ['NNP'],
  'Norborne': ['NNP'],
  'Norcen': ['NNP'],
  'Norcross': ['NNP'],
  'Nord': ['NNP'],
  'Norddeutsche': ['NNP'],
  'Nordic': ['JJ'],
  'Nordine': ['NNP'],
  'Nordmann': ['NNP'],
  'Nordson': ['NNP'],
  'Nordstrom': ['NNP'],
  'Nordyke': ['NNP'],
  'Norell': ['NNP'],
  'Norex': ['NNP'],
  'Norfolk': ['NNP'],
  'Norge': ['NNP'],
  'Norgle': ['NNP'],
  'Nori': ['NNP'],
  'Noriega': ['NNP'],
  'Noriegan': ['JJ'],
  'Noriegas': ['NNS'],
  'Norimasa': ['NNP'],
  'Norio': ['NNP'],
  'Norm': ['NNP'],
  'Norma': ['NNP'],
  'Normal': ['JJ'],
  'Normalize': ['VB'],
  'Normally': ['RB'],
  'Norman': ['NNP'],
  'Normandy': ['NNP'],
  'Norment': ['NNP'],
  'Norms': ['NNS'],
  'Normura': ['NNP'],
  'Norodom': ['NNP'],
  'Norris': ['NNP'],
  'Norris-LaGuardia': ['NNP'],
  'Norristown': ['NNP'],
  'Norsemen': ['NNPS'],
  'Norsk': ['NNP'],
  'Norske': ['NNP'],
  'Norte': ['NNP'],
  'Nortek': ['NNP'],
  'Nortex': ['NNP'],
  'North': ['NNP'],
  'North-Central': ['JJ'],
  'North-Rhine': ['NNP'],
  'Northampton': ['NNP'],
  'Northamptonshire': ['NNP'],
  'Northbrook': ['NNP'],
  'Northeast': ['NNP'],
  'Northeastern': ['JJ'],
  'Northeners': ['NNP'],
  'Northern': ['NNP'],
  'Northerner': ['NN'],
  'Northerners': ['NNPS'],
  'Northfield': ['NNP'],
  'Northgate': ['NNP'],
  'Northington': ['NNP'],
  'Northland': ['NN'],
  'Northlich': ['NNP'],
  'Northridge': ['NNP'],
  'Northrop': ['NNP'],
  'Northrup': ['NNP'],
  'Norths': ['NNPS'],
  'Northumberland': ['NN'],
  'Northview': ['NNP'],
  'Northwest': ['NNP'],
  'Northwest-Skinner': ['NNP'],
  'Northwestern': ['NNP'],
  'Northwood': ['NNP'],
  'Northy': ['NNP'],
  'Norton': ['NNP'],
  'Norville': ['NNP'],
  'Norwalk': ['NNP'],
  'Norway': ['NNP'],
  'Norwegian': ['JJ'],
  'Norwegians': ['NNPS'],
  'Norwell': ['NNP'],
  'Norwest': ['NNP'],
  'Norwich': ['NNP'],
  'Norwick': ['NNP'],
  'Norwitz': ['NNP'],
  'Norwood': ['NNP'],
  'Nos.': ['NNS'],
  'Noschese': ['NNP'],
  'Nosebleed': ['NN'],
  'Noskova': ['NNP'],
  'Nostalgia': ['NN'],
  'Nostalgic': ['JJ'],
  'Nostradamus': ['NNP'],
  'Not': ['RB'],
  'Not-Held': ['NNP'],
  'Not-held': ['JJ'],
  'Notable': ['NNP'],
  'Notably': ['RB'],
  'Notarius': ['NNP'],
  'Note': ['VB'],
  'Notebooks': ['NNP'],
  'Noted': ['JJ'],
  'Notes': ['NNS'],
  'Noteware': ['NNP'],
  'Nothing': ['NN'],
  'Notice': ['NN'],
  'Noticias': ['NNP'],
  'Noticing': ['VBG'],
  'Noting': ['VBG'],
  'Notitia': ['NNS'],
  'Notre': ['NNP'],
  'Notre-Dame': ['NNP'],
  'Nott': ['NNP'],
  'Notte': ['NNP'],
  'Notwithstanding': ['IN'],
  'Noufou': ['NNP'],
  'Nouns': ['NNS'],
  'Nourbakhsh': ['NNP'],
  'Nourishing': ['JJ'],
  'Nouveaux': ['NNP'],
  'Nouvelle': ['NNP'],
  'Nouvelle-Heloise': ['NNP'],
  'Nov': ['NNP'],
  'Nov.': ['NNP'],
  'Nov.30': ['CD'],
  'Nova': ['NNP'],
  'Novacor': ['NNP'],
  'Novak': ['NNP'],
  'Novalta': ['NNP'],
  'Novametrix': ['NNP'],
  'Novato': ['NNP'],
  'Novaya': ['NNP'],
  'Novell': ['NNP'],
  'Novello': ['NNP'],
  'November': ['NNP'],
  'November-December': ['NNP'],
  'November\\\'': ['JJ'],
  'Novick': ['NNP'],
  'Novo': ['NNP'],
  'Novo\\\'': ['NNP'],
  'Novosibirsk': ['NNP'],
  'Novosti': ['NNP'],
  'Now': ['RB'],
  'Nowacki': ['NNP'],
  'Nowadays': ['RB'],
  'Nowak': ['NNP'],
  'Nowhere': ['RB'],
  'Noxell': ['NNP'],
  'Noxema': ['NNP'],
  'Noxzema': ['NNP'],
  'Noyes': ['NNP'],
  'Noyon-la-Sainte': ['NNP'],
  'Nozze': ['FW'],
  'Nu': ['NNP'],
  'Nu-Med': ['NNP'],
  'Nu-West': ['NNP'],
  'Nucci': ['NNP'],
  'Nuclear': ['NNP'],
  'Nuclepore': ['NNP'],
  'Nucor': ['NNP'],
  'Nucor-like': ['JJ'],
  'Nude': ['NNP'],
  'Nuell': ['NNP'],
  'Nueva': ['NNP'],
  'Nuf': ['RB'],
  'Nugent': ['NNP'],
  'Nugget': ['NNP'],
  'Nuggets': ['NNPS'],
  'Nuit': ['NNP'],
  'Nujoma': ['NNP'],
  'Numb': ['JJ'],
  'Number': ['NN'],
  'Numbers': ['NNS'],
  'Numeral': ['NNP'],
  'Numerous': ['JJ'],
  'Nummi': ['NNP'],
  'Nunes': ['NNP'],
  'Nunn': ['NNP'],
  'Nunn-McCurdy': ['NNP'],
  'Nuns': ['NNPS'],
  'Nunzio': ['NNP'],
  'Nuovo': ['NNP'],
  'Nuremberg': ['NNP'],
  'Nureyev': ['NNP'],
  'Nurse': ['NNP'],
  'Nurseries': ['NNPS'],
  'Nursery': ['NNP'],
  'Nurses': ['NNS'],
  'Nursing': ['NNP'],
  'Nusbaum': ['NNP'],
  'Nussbaum': ['NNP'],
  'Nut': ['NNP'],
  'Nutcracker': ['NNP'],
  'Nutley': ['NNP'],
  'Nutmeg': ['NNP'],
  'NutraSweet': ['NNP'],
  'Nutrasweet': ['NNP'],
  'Nutrition': ['NNP'],
  'Nutritional': ['NNP'],
  'Nutritionists': ['NNS'],
  'Nutritious': ['JJ'],
  'Nutt': ['NNP'],
  'Nuttall': ['NNP'],
  'Nutting': ['NNP'],
  'Nuttle': ['NNP'],
  'Nuveen': ['NNP'],
  'Nux': ['NN'],
  'Nuys': ['NNP'],
  'Nuzhet': ['NNP'],
  'Nyack': ['NNP'],
  'Nyberg': ['NNP'],
  'Nyckeln': ['NNP'],
  'Nye': ['NNP'],
  'Nyers': ['NNP'],
  'Nyheter': ['NNP'],
  'Nyiregyhaza': ['NNP'],
  'Nykvist': ['NNP'],
  'Nylev': ['NNP'],
  'Nymagic': ['NNP'],
  'Nymark': ['NNP'],
  'Nymex': ['NNP'],
  'Nymphomaniacs': ['NNS'],
  'Nynex': ['NNP'],
  'Nyunt': ['NNP'],
  'O': ['NNP'],
  'O&Y': ['NNP'],
  'O\'Banion': ['NNP'],
  'O\'Boyle': ['NNP'],
  'O\'Brian': ['NNP'],
  'O\'Brien': ['NNP'],
  'O\'Brien\'s': ['NNP'],
  'O\'Casey': ['NNP'],
  'O\'Clock': ['NNP'],
  'O\'Connell': ['NNP'],
  'O\'Connor': ['NNP'],
  'O\'Connor\'s': ['NNP'],
  'O\'Donnell': ['NNP'],
  'O\'Donnell\'s': ['NNP'],
  'O\'Donnell-Usen': ['NNP'],
  'O\'Donovan': ['NNP'],
  'O\'Dwyer': ['NNP'],
  'O\'Dwyer\'s': ['NNP'],
  'O\'Dwyers': ['NNPS'],
  'O\'Gara': ['NNP'],
  'O\'Grady': ['NNP'],
  'O\'Hanlon': ['NNP'],
  'O\'Hara': ['NNP'],
  'O\'Hare': ['NNP'],
  'O\'Herron': ['NNP'],
  'O\'Keefe': ['NNP'],
  'O\'Kicki': ['NNP'],
  'O\'Lakes': ['NNP'],
  'O\'Linn': ['NNP'],
  'O\'Linn\'s': ['NNP'],
  'O\'Loughlin': ['NNP'],
  'O\'Malley': ['NNP'],
  'O\'Meara': ['NNP'],
  'O\'Melveny': ['NNP'],
  'O\'Neil': ['NNP'],
  'O\'Neill': ['NNP'],
  'O\'Neill\'s': ['NNP'],
  'O\'Reilly': ['NNP'],
  'O\'Rourke': ['NNP'],
  'O\'Shea': ['NNP'],
  'O\'Sullivan': ['NNP'],
  'O\'Toole': ['NNP'],
  'O*/NNP&M': ['NN'],
  'O*/NNP&Y': ['NN'],
  'O-B': ['NNP'],
  'O.': ['NNP'],
  'O.B.': ['NNP'],
  'O.E.': ['NNP'],
  'O.E.C.D.': ['NNP'],
  'O.G.': ['NNP'],
  'O.J.': ['NNP'],
  'O.K': ['UH'],
  'O.K.': ['UH'],
  'O.N.': ['NNP'],
  'O.P.': ['NNP'],
  'O.S.K.': ['NNP'],
  'O.T.': ['NNP'],
  'OAS': ['NNP'],
  'OBE': ['NNP'],
  'OBERMAIER': ['NNP'],
  'OBTS': ['NNP'],
  'OBrion': ['NNP'],
  'OCC': ['NNP'],
  'OCC-member': ['JJ'],
  'OCCIDENTAL': ['NNP'],
  'OCN-PPL': ['NNP'],
  'OCR': ['NNP'],
  'ODDITIES': ['NNS'],
  'ODI': ['NNP'],
  'OEC': ['NNP'],
  'OECD': ['NNP'],
  'OEL': ['NNP'],
  'OEP': ['NNP'],
  'OEX': ['NNP'],
  'OF': ['IN'],
  'OFF': ['IN'],
  'OFFENSIVE': ['JJ'],
  'OFFERED': ['NNP'],
  'OFFICER': ['NN'],
  'OFFICES': ['NNS'],
  'OFFICIALS': ['NNS'],
  'OGDEN': ['NNP'],
  'OGURA': ['NNP'],
  'OH': ['NN'],
  'OHIO': ['NNP'],
  'OIF': ['NNP'],
  'OIL': ['NNP'],
  'OK': ['JJ'],
  'OK.': ['UH'],
  'OKC': ['NNP'],
  'OKI': ['NNP'],
  'OKing': ['NNP'],
  'OLE': ['NNP'],
  'OLYMPIA': ['NNP'],
  'OMB': ['NNP'],
  'OME': ['NNP'],
  'OMG': ['UH'],
  'ON': ['IN'],
  'ONCE': ['RB'],
  'ONE': ['CD'],
  'ONE-DAY': ['JJ'],
  'ONEIDA': ['NNP'],
  'ONEZIE': ['NNP'],
  'OOH': ['NNP'],
  'OPA-LOCKA': ['NNP'],
  'OPEC': ['NNP'],
  'OPEN': ['JJ'],
  'OPPENHEIMER': ['NNP'],
  'OPTIONS': ['NNS'],
  'OR': ['CC'],
  'ORACLE': ['NNP'],
  'ORANGE': ['NN'],
  'ORDER': ['NNP'],
  'ORDERED': ['VBN'],
  'ORDERS': ['VBZ'],
  'ORGAN-TRANSPLANT': ['JJ'],
  'ORGANIZED': ['VBN'],
  'ORTEGA': ['NNP'],
  'OSHA': ['NNP'],
  'OST': ['NNP'],
  'OS\\\'': ['NNP'],
  'OS\\\'/2': ['NNP'],
  'OTC': ['NNP'],
  'OTC-market': ['JJ'],
  'OTS': ['NNP'],
  'OUR': ['PRP\$'],
  'OUSTED': ['VBN'],
  'OUT': ['IN'],
  'OUTLOOK': ['NNP'],
  'OUTRAGE': ['NN'],
  'OUTSIDE': ['JJ'],
  'OVER': ['IN'],
  'OVERHAUL': ['NN'],
  'OVERSEAS': ['JJ'],
  'OWI': ['NNP'],
  'OWNER': ['NNP'],
  'Oafid': ['NNP'],
  'Oak': ['NNP'],
  'Oakar': ['NNP'],
  'Oakbrook': ['NNP'],
  'Oakes': ['NNP'],
  'Oakhurst': ['NNP'],
  'Oakland': ['NNP'],
  'Oakland-Alameda': ['NNP'],
  'Oakland-Berkeley': ['NNP'],
  'Oaklanders': ['NNPS'],
  'Oakmont': ['NNP'],
  'Oaks': ['NNP'],
  'Oakwood': ['NNP'],
  'Oana': ['NNP'],
  'Oases': ['NNS'],
  'Oasis': ['NNP'],
  'Oat': ['NNP'],
  'Oatnut': ['NNP'],
  'Oats': ['NNPS'],
  'Ob-Irtysh': ['NNP'],
  'Obama': ['NNP'],
  'Obedience': ['NN'],
  'Obelisk': ['NNP'],
  'Oberhausen': ['NNP'],
  'Oberkfell': ['NNP'],
  'Oberlin': ['NNP'],
  'Obermaier': ['NNP'],
  'Oberman': ['NNP'],
  'Obernauer': ['NNP'],
  'Oberreit': ['NNP'],
  'Oberstar': ['NNP'],
  'Oberweis': ['NNP'],
  'Obesity': ['NN'],
  'Obey': ['NNP'],
  'Obeying': ['VBG'],
  'Obispo': ['NNP'],
  'Object': ['NN'],
  'Objections': ['NNS'],
  'Objects': ['NNS'],
  'Obligations': ['NNS'],
  'Obligingly': ['RB'],
  'Observations': ['NNS'],
  'Observatory': ['NNP'],
  'Observer': ['NNP'],
  'Observers': ['NNS'],
  'Observing': ['VBG'],
  'Obsolescence': ['NNP'],
  'Obstacles': ['NNS'],
  'Obviously': ['RB'],
  'Occasional': ['JJ'],
  'Occasionally': ['RB'],
  'Occident': ['NNP'],
  'Occidental': ['NNP'],
  'Occupation': ['NNP'],
  'Occupational': ['NNP'],
  'Occupational-Urgent': ['NNP'],
  'Oce': ['NNP'],
  'Oce-Van': ['NNP'],
  'Ocean': ['NNP'],
  'Oceana': ['NNP'],
  'Oceania': ['NNP'],
  'Oceanic': ['NNP'],
  'Oceanography': ['NNP'],
  'Oceans': ['NNS'],
  'Oceanside': ['NNP'],
  'Ochoa': ['NNP'],
  'Ochs': ['NNP'],
  'Ochsenschlager': ['NNP'],
  'Oct': ['NNP'],
  'Oct.': ['NNP'],
  'Oct.13': ['NNP'],
  'Octave': ['NNP'],
  'Octavia': ['NNP'],
  'Octel': ['NNP'],
  'Octet': ['NNP'],
  'October': ['NNP'],
  'October-December': ['NNP'],
  'October-March': ['NNP'],
  'Octobers': ['NNPS'],
  'Octobrists': ['NNPS'],
  'Octopus': ['NNP'],
  'Octoroon': ['NNP'],
  'Oculon': ['NNP'],
  'Oczakov': ['NNP'],
  'Odakyu': ['NNP'],
  'Odd': ['NNP'],
  'Odd-lot': ['JJ'],
  'Odd-year': ['JJ'],
  'Oddly': ['RB'],
  'Odds': ['NNS'],
  'Oddy': ['NNP'],
  'Odean': ['NNP'],
  'Odell': ['NNP'],
  'Odeon': ['NNP'],
  'Oder': ['NNP'],
  'Odessa': ['NNP'],
  'Odetics': ['NNP'],
  'Odilo': ['NNP'],
  'Odom': ['NNP'],
  'Odors': ['NNP'],
  'Odysseus': ['NNP'],
  'Odyssey': ['NNP'],
  'Oedipal': ['JJ'],
  'Oedipus': ['NNP'],
  'Oei': ['NNP'],
  'Oerlikon-Buehrle': ['NNP'],
  'Oersted': ['NNP'],
  'Oeschger': ['NNP'],
  'Oesterreichische': ['NNP'],
  'Oestreich': ['NNP'],
  'Of': ['IN'],
  'Off': ['IN'],
  'Off-Broadway': ['NNP'],
  'Off-Road': ['NNP'],
  'Off-Track': ['NNP'],
  'Off-flavor': ['NN'],
  'Off-price': ['JJ'],
  'Off-season': ['JJ'],
  'Offenbach': ['NNP'],
  'Offenses': ['NNS'],
  'Offensive': ['NNP'],
  'Offer': ['VB'],
  'Offered': ['NNP'],
  'Offering': ['NN'],
  'Offers': ['VBZ'],
  'Office': ['NNP'],
  'Office.': ['NNP'],
  'Officer': ['NNP'],
  'Officers': ['NNS'],
  'Offices': ['NNS'],
  'Official': ['JJ'],
  'Officially': ['RB'],
  'Officials': ['NNS'],
  'Officielle': ['NNP'],
  'Officine': ['NNP'],
  'Offsetting': ['VBG'],
  'Offshore': ['NNP'],
  'Offutt': ['NNP'],
  'Often': ['RB'],
  'Ogallala': ['NNP'],
  'Ogden': ['NNP'],
  'Ogilvy': ['NNP'],
  'Ogilvyspeak': ['NNP'],
  'Ogisu': ['NNP'],
  'Oglethorpe': ['NNP'],
  'Ogonyok': ['NNP'],
  'Ogunjobi': ['NNP'],
  'Ogura': ['NNP'],
  'Oh': ['UH'],
  'Oh-Hyun': ['NNP'],
  'Oh-the-pain-of-it': ['UH'],
  'Ohara': ['NNP'],
  'Ohbayashi': ['NNP'],
  'Oher': ['NNP'],
  'Ohga': ['NNP'],
  'Ohio': ['NNP'],
  'Ohio-based': ['JJ'],
  'Ohio-chartered': ['JJ'],
  'Ohioan': ['NNP'],
  'Ohioans': ['NNPS'],
  'Ohira': ['NNP'],
  'Ohkuma': ['NNP'],
  'Ohlman': ['NNP'],
  'Ohls': ['NNP'],
  'Ohmae': ['NNP'],
  'Oi': ['NNP'],
  'Oil': ['NNP'],
  'Oil-field': ['NN'],
  'Oil-related': ['JJ'],
  'Oil-tool': ['NN'],
  'Oilcloth': ['NN'],
  'Oilers': ['NNP'],
  'Oilfields': ['NNS'],
  'Oilgram': ['NNP'],
  'Oils': ['NNS'],
  'Oilwell': ['NNP'],
  'Oistrakh': ['NNP'],
  'Oji': ['NNP'],
  'Ojibwa': ['NNP'],
  'Ok': ['NNP'],
  'Oka': ['NNP'],
  'Okada': ['NNP'],
  'Okamoto': ['NNP'],
  'Okasan': ['NNP'],
  'Okay': ['UH'],
  'Okayama': ['NNP'],
  'Okies': ['NNP'],
  'Okinawa': ['NNP'],
  'Okla': ['NNP'],
  'Okla.': ['NNP'],
  'Oklahoma': ['NNP'],
  'Oklahoman': ['NNP'],
  'Okobank': ['NNP'],
  'Okrent': ['NNP'],
  'Okuma': ['NNP'],
  'Okura': ['NNP'],
  'Ol': ['JJ'],
  'Olaf': ['NNP'],
  'Olathe': ['NNP'],
  'Olatunji': ['NNP'],
  'Olav': ['NNP'],
  'Olay': ['NNP'],
  'Olayan': ['NNP'],
  'Old': ['NNP'],
  'Old-House': ['NNP'],
  'Old-time': ['JJ'],
  'Old-timers': ['NNS'],
  'Olde': ['NNP'],
  'Oldenburg': ['NNP'],
  'Older': ['JJR'],
  'Oldham': ['NNP'],
  'Olds': ['NNP'],
  'Oldsmobile': ['NNP'],
  'Ole': ['JJ'],
  'Olea': ['NNP'],
  'Olean': ['NNP'],
  'Oleanders': ['NNS'],
  'Olechowski': ['NNP'],
  'Oleg': ['NNP'],
  'Olenegorsk': ['NNP'],
  'Olerichs': ['NNPS'],
  'Olestra': ['NN'],
  'Oley': ['NNP'],
  'Olga': ['NNP'],
  'Olgivanna': ['NNP'],
  'Olick': ['NNP'],
  'Olin': ['NNP'],
  'Olissa': ['NNP'],
  'Olivares': ['NNP'],
  'Olive': ['NNP'],
  'Oliveira': ['NNP'],
  'Oliver': ['NNP'],
  'Olivet': ['NNP'],
  'Olivetti': ['NNP'],
  'Olivia': ['NNP'],
  'Olivier': ['NNP'],
  'Ollari': ['NNP'],
  'Olle': ['NNP'],
  'Ollie': ['NNP'],
  'Olney': ['NNP'],
  'Olof': ['NNP'],
  'Olsen': ['NNP'],
  'Olshan': ['NNP'],
  'Olson': ['NNP'],
  'Olsson': ['NNP'],
  'Olszewski': ['NNP'],
  'Olszewskiof': ['NNP'],
  'Olvey': ['NNP'],
  'Olympia': ['NNP'],
  'Olympian': ['JJ'],
  'Olympic': ['NNP'],
  'Olympics': ['NNPS'],
  'Olympus': ['NN'],
  'Omaha': ['NNP'],
  'Oman': ['NNP'],
  'Omani': ['JJ'],
  'Omar': ['NNP'],
  'Omega': ['NNP'],
  'OmegaSource': ['NNP'],
  'Omg': ['UH'],
  'Omission': ['NN'],
  'Omni': ['NNP'],
  'OmniBank': ['NNP'],
  'Omnibank': ['NNP'],
  'Omnibus': ['NN'],
  'Omnicare': ['NNP'],
  'Omnicom': ['NNP'],
  'Omnicorp': ['NNP'],
  'Omron': ['NNP'],
  'Omsk': ['NNP'],
  'On': ['IN'],
  'On-Broadway': ['NNP'],
  'On-Line': ['NNP'],
  'On-Site': ['NNP'],
  'On-Target': ['NNP'],
  'On-to-Spokane': ['NNP'],
  'Onan': ['NNP'],
  'Once': ['RB'],
  'Once-only': ['JJ'],
  'OncoScint': ['NNP'],
  'Oncogen': ['NNP'],
  'Oncogene': ['NNP'],
  'Oncogenes': ['NNS'],
  'Oncology': ['NNP'],
  'Oncor': ['NNP'],
  'Oncotech': ['NNP'],
  'Ondaatje': ['NNP'],
  'One': ['CD'],
  'One-Cancels-The-Other': ['NNP'],
  'One-Horse': ['JJ'],
  'One-Leg': ['NNP'],
  'One-Step': ['NNP'],
  'One-armed': ['JJ'],
  'One-day': ['JJ'],
  'One-fourth': ['NN'],
  'One-inch': ['JJ'],
  'One-third': ['NN'],
  'One-time': ['JJ'],
  'One-year': ['NNP'],
  'Onegin': ['NNP'],
  'Oneida': ['NNP'],
  'Oneita': ['NNP'],
  'Oneok': ['NNP'],
  'Ones': ['NNP'],
  'Oneupmanship': ['NN'],
  'Onex': ['NNP'],
  'Ong': ['NNP'],
  'Onidi': ['NNP'],
  'Onleh': ['RB'],
  'Online': ['NNP'],
  'Onlookers': ['NNS'],
  'Only': ['RB'],
  'Onni': ['NNP'],
  'Onno': ['NNP'],
  'Ono': ['NNP'],
  'Onondaga': ['NNP'],
  'Onset': ['NN'],
  'Onsets': ['NNS'],
  'Onstage': ['RB'],
  'Ont.': ['NNP'],
  'Ontario': ['NNP'],
  'Oooo': ['UH'],
  'Oops': ['UH'],
  'Oopsie': ['NNP'],
  'Oopsie-Cola': ['NNP'],
  'Op.': ['NNP'],
  'Opa-Locka': ['NNP'],
  'Opaque': ['JJ'],
  'Opax': ['NNP'],
  'Opel': ['NNP'],
  'Opelika': ['NNP'],
  'Open': ['NNP'],
  'Open-adoption': ['NN'],
  'Open-end': ['JJ'],
  'Open-flame': ['JJ'],
  'Opening': ['VBG'],
  'Opera': ['NNP'],
  'Operating': ['NN'],
  'Operating-profit': ['NN'],
  'Operating-system': ['JJ'],
  'Operation': ['NNP'],
  'Operational': ['JJ'],
  'Operationally': ['RB'],
  'Operations': ['NNP'],
  'Operators': ['NNP'],
  'Opere': ['NNP'],
  'Ophthalmic': ['NNP'],
  'Opinion': ['NNP'],
  'Opinions': ['NNS'],
  'Opositora': ['NNP'],
  'Oppen': ['NNP'],
  'Oppenheim': ['NNP'],
  'Oppenheimer': ['NNP'],
  'Opponents': ['NNS'],
  'Opportunities': ['NNS'],
  'Opportunity': ['NNP'],
  'Opposed': ['VBN'],
  'Opposite': ['IN'],
  'Opposition': ['NN'],
  'Oppressive': ['JJ'],
  'Oprah': ['NNP'],
  'Optek': ['NNP'],
  'Optic-Electronic': ['NNP'],
  'Optical': ['NNP'],
  'Optical-storage': ['JJ'],
  'Optics': ['NNP'],
  'Optima': ['NNP'],
  'Optimism': ['NN'],
  'Optimists': ['NNS'],
  'Option': ['NNP'],
  'Options': ['NNPS'],
  'Optique': ['NNP'],
  'Opus': ['NNP'],
  'Or': ['CC'],
  'Oracle': ['NNP'],
  'Oral': ['NNP'],
  'Oran': ['NNP'],
  'Orange': ['NNP'],
  'Orangeburg': ['NNP'],
  'Oranges': ['NNPS'],
  'Oranjemund': ['NNP'],
  'Oratory': ['NNP'],
  'Orban': ['NNP'],
  'Orbe': ['NNP'],
  'Orben': ['NNP'],
  'Orbis': ['NNP'],
  'Orbital': ['NNP'],
  'Orbiting': ['NNP'],
  'Orchard': ['NNP'],
  'Orchesis': ['NNP'],
  'Orchester': ['NNP'],
  'Orchestra': ['NNP'],
  'Orchestral': ['NNP'],
  'Orchestration': ['NNP'],
  'Orchestre': ['NNP'],
  'Orcutt': ['NNP'],
  'Ord': ['NNP'],
  'Orden': ['NNP'],
  'Order': ['NNP'],
  'Order-Entry': ['NN'],
  'Ordered': ['VBD'],
  'Orders': ['NNS'],
  'Ordinance': ['NNP'],
  'Ordinaries': ['NNPS'],
  'Ordinarily': ['RB'],
  'Ordinary': ['JJ'],
  'Ordnance': ['NNP'],
  'Ore': ['NNP'],
  'Ore.': ['NNP'],
  'Ore.-based': ['JJ'],
  'Oregon': ['NNP'],
  'Oregonian': ['NNP'],
  'Oregonians': ['NNPS'],
  'Orejuela': ['NNP'],
  'Orel': ['NNP'],
  'Orem': ['NNP'],
  'Oremland': ['NNP'],
  'Orens': ['NNP'],
  'Oreos': ['NNPS'],
  'Oresme': ['NNP'],
  'Oresteia': ['NNP'],
  'Orestes': ['NNP'],
  'Orfeo': ['NNP'],
  'Org': ['NNP'],
  'Organ': ['NN'],
  'Organic': ['NNP'],
  'Organification': ['NN'],
  'Organisation': ['NNP'],
  'Organization': ['NNP'],
  'Organizational': ['JJ'],
  'Organizations': ['NNP'],
  'Organized': ['NNP'],
  'Organizers': ['NNS'],
  'Organizing': ['NNP'],
  'Orgotein': ['NNP'],
  'Oriani': ['NNP'],
  'Orient': ['NNP'],
  'Oriental': ['JJ'],
  'Origen': ['NNP'],
  'Origin': ['NN'],
  'Original': ['NNP'],
  'Originally': ['RB'],
  'Originals': ['NNS'],
  'Origins': ['NNP'],
  'Orin': ['NNP'],
  'Orinoco': ['NNP'],
  'Oriole': ['NNP'],
  'Orioles': ['NNP'],
  'Orion': ['NNP'],
  'Orissa': ['NNP'],
  'Orix': ['NNP'],
  'Orkem': ['NNP'],
  'Orkney': ['NNP'],
  'Orlando': ['NNP'],
  'Orleans': ['NNP'],
  'Orleans-based': ['JJ'],
  'Orlick': ['NNP'],
  'Orlowski': ['NNP'],
  'Orly': ['NNP'],
  'Ormat': ['NNP'],
  'Ormoc': ['NNP'],
  'Ormsby': ['NNP'],
  'Ormstedt': ['NNP'],
  'Ornament': ['NN'],
  'Ornelas': ['NNP'],
  'Ornette': ['NNP'],
  'Ornithological': ['NNP'],
  'Ornstein': ['NNP'],
  'Orondo': ['NNP'],
  'Oros': ['NNP'],
  'Orpheus': ['NNP'],
  'Orphic': ['JJ'],
  'Orr': ['NNP'],
  'Orrick': ['NNP'],
  'Orrie': ['NNP'],
  'Orrin': ['NNP'],
  'Orso': ['NNP'],
  'Orson': ['NNP'],
  'Ortega': ['NNP'],
  'Ortegas': ['NNPS'],
  'Ortho': ['NNP'],
  'Orthodontic': ['JJ'],
  'Orthodox': ['NNP'],
  'Orthodoxy': ['NNP'],
  'Orthopedic': ['NNP'],
  'Ortiz': ['NNP'],
  'Orvil': ['NNP'],
  'Orville': ['NNP'],
  'Orvis': ['NNP'],
  'Orwell': ['NNP'],
  'Orwellian': ['JJ'],
  'Ory': ['NNP'],
  'Oryx': ['NNP'],
  'Osaka': ['NNP'],
  'Osake': ['NNP'],
  'Osamu': ['NNP'],
  'Osbert': ['NNP'],
  'Osborn': ['NNP'],
  'Osborne': ['NNP'],
  'Oscar': ['NNP'],
  'Oshinsky': ['NNP'],
  'Oshkosh': ['NNP'],
  'Oshry': ['NNP'],
  'Osipenko': ['NNP'],
  'Osis': ['NNP'],
  'Oskar': ['NNP'],
  'Osler': ['NNP'],
  'Oslo': ['NNP'],
  'Osnos': ['NNP'],
  'Oso': ['NNP'],
  'Osprey': ['NNP'],
  'Osram': ['NNP'],
  'Osric': ['NNP'],
  'Ossad': ['NNP'],
  'Ostentatious': ['JJ'],
  'Osterman': ['NNP'],
  'Osterreichische': ['NNP'],
  'Ostlandske': ['NNP'],
  'Ostpolitik': ['NNP'],
  'Ostrager': ['NNP'],
  'Ostrander': ['NNP'],
  'Ostriches': ['NNS'],
  'Ostro': ['NNP'],
  'Ostroff': ['NNP'],
  'Ostrovsky': ['NNP'],
  'Ostrowsky': ['NNP'],
  'Oswald': ['NNP'],
  'Oswego': ['NNP'],
  'Otaiba': ['NNP'],
  'Otero': ['NNP'],
  'Othello': ['NNP'],
  'Other': ['JJ'],
  'Others': ['NNS'],
  'Otherwise': ['RB'],
  'Othon': ['NNP'],
  'Otis': ['NNP'],
  'Otradovec': ['NNP'],
  'Otros': ['NNP'],
  'Otsego': ['NNP'],
  'Ottauquechee': ['NNP'],
  'Ottawa': ['NNP'],
  'Ottaway': ['NNP'],
  'Otte': ['NNP'],
  'Otterlo': ['NNP'],
  'Ottermole': ['NNP'],
  'Otto': ['NNP'],
  'Ottoman': ['NNP'],
  'Ottoni': ['NNP'],
  'Oubati': ['NNP'],
  'Ouedraogo': ['NNP'],
  'Ouellette': ['NNP'],
  'Ought': ['MD'],
  'Ouija': ['NNP'],
  'Oum': ['NNP'],
  'Our': ['PRP\$'],
  'Ouray': ['NNP'],
  'Ours': ['PRP'],
  'Ouse': ['NNP'],
  'Ousley': ['NNP'],
  'Out': ['IN'],
  'Outboard': ['NNP'],
  'Outbreaks': ['NNS'],
  'Outcome': ['NN'],
  'Outdoor': ['JJ'],
  'Outer': ['NNP'],
  'Outfielder': ['NNP'],
  'Outflows': ['NNS'],
  'Outgoing': ['JJ'],
  'Outhwaite': ['NNP'],
  'Outing': ['NNP'],
  'Outlays': ['NNS'],
  'Outlet': ['NNP'],
  'Outline': ['NN'],
  'Outlook': ['NN'],
  'Outlooks': ['NNS'],
  'Outokumpu': ['NNP'],
  'Outpatient': ['NN'],
  'Outperform': ['NNP'],
  'Outplacement': ['NN'],
  'Output': ['NN'],
  'Outputs': ['NNS'],
  'Outraged': ['JJ'],
  'Outrageous': ['NNP'],
  'Outreach': ['NNP'],
  'Outright': ['JJ'],
  'Outrunning': ['VBG'],
  'Outside': ['IN'],
  'Outsiders': ['NNS'],
  'Outstanding': ['JJ'],
  'Outsville': ['NNP'],
  'Outwardly': ['RB'],
  'Ouzo': ['NN'],
  'Oval': ['NNP'],
  'Ovalle': ['NNP'],
  'Ovcharenko': ['NNP'],
  'Ovens': ['NNS'],
  'Over': ['IN'],
  'Over-50': ['JJ'],
  'Over-achievers': ['NNS'],
  'Over-chilling': ['NN'],
  'Over-the-counter': ['JJ'],
  'Overall': ['RB'],
  'Overbuilding': ['VBG'],
  'Overbuilt': ['JJ'],
  'Overextension': ['NN'],
  'Overfall': ['NNP'],
  'Overfunding': ['VBG'],
  'Overhanging': ['VBG'],
  'Overhead': ['NN'],
  'Overland': ['NNP'],
  'Overlords': ['NNPS'],
  'Overly': ['RB'],
  'Overnight': ['RB'],
  'Overnite': ['NNP'],
  'Overpriced': ['NNP'],
  'Overreach': ['NNP'],
  'Overreacting': ['VBG'],
  'Overriding': ['NN'],
  'Overseas': ['NNP'],
  'Overseeing': ['VBG'],
  'Overseers': ['NNPS'],
  'Oversight': ['NNP'],
  'Oversized': ['JJ'],
  'Overstreet': ['NNP'],
  'Overt': ['JJ'],
  'Overtega': ['NNP'],
  'Overtones': ['NNS'],
  'Overture': ['NNP'],
  'Overturf': ['NNP'],
  'Overvalued': ['JJ'],
  'Overweight': ['JJ'],
  'Overwhelmed': ['VBN'],
  'Overwhelming': ['JJ'],
  'Ovitz': ['NNP'],
  'Ovonic': ['NNP'],
  'Owasso': ['NNP'],
  'Owego': ['NNP'],
  'Owen': ['NNP'],
  'Owens': ['NNP'],
  'Owens-Corning': ['NNP'],
  'Owens-Ilinois': ['NNP'],
  'Owens-Illinois': ['NNP'],
  'Owing': ['RB'],
  'Owings': ['NNP'],
  'Owl': ['NN'],
  'Owls': ['NNS'],
  'Own': ['JJ'],
  'Owned': ['NNP'],
  'Owner': ['NN'],
  'Owners': ['NNS'],
  'Ownership': ['NNP'],
  'Owning': ['VBG'],
  'Oxford': ['NNP'],
  'Oxfordshire': ['NNP'],
  'Oxidation': ['NN'],
  'Oxley': ['NNP'],
  'Oxnard': ['NNP'],
  'Oxy': ['NNP'],
  'Oxygen': ['NN'],
  'Oxytetracycline': ['NN'],
  'Oy': ['NNP'],
  'Oyajima': ['NNP'],
  'Oyster': ['NNP'],
  'Oz': ['NNP'],
  'Ozagen': ['NNP'],
  'Ozagenians': ['NNS'],
  'Ozal': ['NNP'],
  'Ozanne': ['NNP'],
  'Ozark': ['NNP'],
  'Ozarks': ['NNPS'],
  'Ozick': ['NNP'],
  'Ozon': ['NN'],
  'Ozone': ['NN'],
  'Ozzie': ['NNP'],
  'P': ['NN'],
  'P&C': ['NNP'],
  'P&G': ['NNP'],
  'P&S': ['NNP'],
  'P*/NNP&G': ['NN'],
  'P-11': ['NN'],
  'P-20': ['NN'],
  'P-3': ['NN'],
  'P-5-39': ['NNP'],
  'P-7A': ['NNP'],
  'P-E': ['NNP'],
  'P.': ['NNP'],
  'P.-T.A.': ['NNP'],
  'P.A.': ['NN'],
  'P.D.I.': ['NNP'],
  'P.GA': ['NNP'],
  'P.I.': ['NN'],
  'P.J.': ['NNP'],
  'P.L.': ['NNP'],
  'P.M.': ['RB'],
  'P.R.': ['JJ'],
  'P.S': ['NN'],
  'P.m': ['NN'],
  'P350': ['CD'],
  'PA': ['NNP'],
  'PABA': ['NN'],
  'PAC': ['NNP'],
  'PACIFIC': ['NNP'],
  'PACS': ['NNS'],
  'PACs': ['NNPS'],
  'PAN': ['NNP'],
  'PANDA': ['NNP'],
  'PANEL': ['NN'],
  'PANHANDLER': ['NN'],
  'PAP': ['NNP'],
  'PAPER': ['NN'],
  'PAPERS': ['NNS'],
  'PARENT': ['NN'],
  'PARENTAL': ['JJ'],
  'PARIS': ['NNP'],
  'PARK': ['NN'],
  'PARKER': ['NNP'],
  'PARS': ['NNP'],
  'PARS-Datas': ['NNP'],
  'PARTICIPATED': ['VBD'],
  'PARTNER': ['NN'],
  'PARTNERS': ['NNS'],
  'PARTNERSHIP': ['NNP'],
  'PARTS': ['NN'],
  'PARTY': ['NNP'],
  'PASOK': ['NNP'],
  'PATCO': ['NNP'],
  'PATH': ['NNP'],
  'PATIENCE': ['NN'],
  'PATOIS': ['NNP'],
  'PATRON': ['NNP'],
  'PATTON': ['NNP'],
  'PAUL': ['NNP'],
  'PAY': ['NN'],
  'PAYMENTS': ['NNS'],
  'PAYS': ['VBZ'],
  'PBS': ['NNP'],
  'PBX': ['NNP'],
  'PC': ['NN'],
  'PC-magazine': ['JJ'],
  'PC9801LX5C': ['NNP'],
  'PCBs': ['NNS'],
  'PCM': ['NNP'],
  'PCP': ['NNP'],
  'PCS': ['NNP'],
  'PCST': ['NNP'],
  'PCs': ['NNS'],
  'PDI': ['NNP'],
  'PDN': ['NNP'],
  'PDT': ['NNP'],
  'PEDAL': ['NN'],
  'PENALTY': ['NNP'],
  'PENCIL': ['NNP'],
  'PENCILS': ['NNS'],
  'PENNEY': ['NNP'],
  'PENSION': ['NN'],
  'PENTAGON': ['NNP'],
  'PEOPLE': ['NNS'],
  'PERFORMANCE': ['NN'],
  'PERIOD': ['NN'],
  'PERIPATETIC': ['JJ'],
  'PERKS': ['NNS'],
  'PERMANENTE': ['NNP'],
  'PERSUADING': ['VB'],
  'PETROLEUM': ['NNP'],
  'PETS': ['NNS'],
  'PF': ['NNP'],
  'PFC': ['NNP'],
  'PG&E': ['NNP'],
  'PG-13': ['NN'],
  'PGH': ['NNP'],
  'PGM': ['NNP'],
  'PHH': ['NNP'],
  'PHILADELPHIA': ['NNP'],
  'PHOBIA': ['NN'],
  'PHOENIX': ['NNP'],
  'PHONE': ['NNP'],
  'PHOTOGRAPH': ['NN'],
  'PHP': ['NNP'],
  'PHS': ['NNP'],
  'PHYSICIANS': ['NNS'],
  'PIC': ['NNP'],
  'PIERCE': ['NNP'],
  'PIK': ['NNP'],
  'PILGRIM': ['NNP'],
  'PILING': ['VBG'],
  'PINDLING': ['NNP'],
  'PIPELINE': ['NNP'],
  'PIPELINES': ['NNPS'],
  'PIR': ['NNP'],
  'PITCH': ['NNP'],
  'PKbanken': ['NNP'],
  'PL-480': ['NN'],
  'PLACE': ['NNP'],
  'PLAN': ['NN'],
  'PLANS': ['VBZ'],
  'PLANTS': ['NNS'],
  'PLASTIC': ['NN'],
  'PLAYER': ['NNP'],
  'PLC': ['NNP'],
  'PLC.': ['NNP'],
  'PLEA': ['NN'],
  'PLEASURE': ['NN'],
  'PLO': ['NNP'],
  'PLO-backed': ['JJ'],
  'PLODDERS': ['NNS'],
  'PLUNGED': ['VBD'],
  'PM': ['NNP'],
  'PMR': ['NNP'],
  'PMs': ['NNS'],
  'PNC': ['NNP'],
  'POINTS': ['NNPS'],
  'POLICE': ['NN'],
  'POLICY': ['NNP'],
  'POLITICAL': ['JJ'],
  'POLITICS': ['NNS'],
  'PONT': ['NNP'],
  'POOCH': ['NN'],
  'POP': ['NNP'],
  'POPs': ['NNS'],
  'PORTFOLIO': ['NN'],
  'PORTING': ['VBG'],
  'POST-TRIAL': ['NNP'],
  'POTABLES': ['NNS'],
  'POUNDED': ['VBD'],
  'POW': ['NN'],
  'POWER': ['NNP'],
  'POWERS': ['NNS'],
  'POWs': ['NNS'],
  'PPG': ['NNP'],
  'PPI': ['NNP'],
  'PPP': ['NNP'],
  'PQ': ['NN'],
  'PR': ['NNP'],
  'PR-wise': ['JJ'],
  'PRA': ['NNP'],
  'PRATT': ['NNP'],
  'PRC': ['NNP'],
  'PRECIOUS': ['JJ'],
  'PREDAWN': ['NN'],
  'PRESIDENT': ['NN'],
  'PRI': ['NNP'],
  'PRICES': ['NNS'],
  'PRICIEST': ['JJS'],
  'PRIME': ['JJ'],
  'PRIMERICA': ['NNP'],
  'PRINCE': ['NNP'],
  'PRISON': ['NN'],
  'PRISON-SHOP': ['NNP'],
  'PRIVILEGE': ['NN'],
  'PRO': ['FW'],
  'PRO-CHOICE': ['JJ'],
  'PROCEEDINGS': ['NNS'],
  'PROCTER': ['NNP'],
  'PRODUCT': ['NN'],
  'PRODUCTS': ['NNS'],
  'PROFESSOR': ['NN'],
  'PROFIT': ['NN'],
  'PROFIT-SHARING': ['NN'],
  'PROFITS': ['NNS'],
  'PROFITT': ['NNP'],
  'PROGRAM': ['NN'],
  'PROMISE': ['NN'],
  'PROMOTION': ['NNP'],
  'PROPERTIES': ['NNPS'],
  'PROPERTY': ['NN'],
  'PROPOSAL': ['NN'],
  'PROPOSALS': ['NNS'],
  'PROPOSE': ['VB'],
  'PROPOSED': ['VBD'],
  'PROSECUTIONS': ['NNS'],
  'PROSECUTOR': ['NNP'],
  'PROSECUTORS': ['NNS'],
  'PROSPECTORS': ['NNS'],
  'PROSPECTS': ['NNS'],
  'PROSPER': ['VBP'],
  'PS': ['NNP'],
  'PSA': ['NNP'],
  'PSE': ['NNP'],
  'PS\\\'': ['NN'],
  'PS\\\'/2': ['NNP'],
  'PTA': ['NNP'],
  'PTC': ['NNP'],
  'PTL': ['NNP'],
  'PUBLIC': ['JJ'],
  'PUBLICITY': ['NN'],
  'PUBLISHING': ['NN'],
  'PUNITIVE': ['JJ'],
  'PUTS': ['NNPS'],
  'PVC': ['NNP'],
  'PW-2000': ['NN'],
  'PW-4000': ['NN'],
  'PW4000': ['NNP'],
  'PW4060': ['NNP'],
  'PWA': ['NNP'],
  'PWA-owned': ['JJ'],
  'PX': ['NNP'],
  'P\\\'': ['NNP'],
  'P\\\'/E': ['NNP'],
  'Pa': ['NNP'],
  'Pa.': ['NNP'],
  'Pa.-based': ['JJ'],
  'Paata': ['NNP'],
  'Pablo': ['NNP'],
  'Pabor': ['NNP'],
  'Pabst': ['NNP'],
  'Pac': ['NNP'],
  'Pace': ['NNP'],
  'Paced': ['VBN'],
  'Pacemakers': ['NNPS'],
  'Pacheco': ['NNP'],
  'Pachelbel': ['NNP'],
  'Pachinko': ['NN'],
  'Pacholik': ['NNP'],
  'Pachyderms': ['NNPS'],
  'PacifiCare': ['NNP'],
  'Pacific': ['NNP'],
  'Pacific-listed': ['JJ'],
  'Pacify': ['VB'],
  'Pacitti': ['NNP'],
  'Pack': ['VB'],
  'Package': ['NN'],
  'Packaged-goods': ['NNS'],
  'Packages': ['NNS'],
  'Packaging': ['NNP'],
  'Packard': ['NNP'],
  'Packards': ['NNPS'],
  'Packer': ['NNP'],
  'Packers': ['NNP'],
  'Packet': ['NN'],
  'Packing': ['NNP'],
  'Packs': ['NNPS'],
  'Packwood': ['NNP'],
  'Packwood-Roth': ['NNP'],
  'Pact': ['NNP'],
  'Pacta': ['FW'],
  'Pacwest': ['NNP'],
  'Paddle': ['VB'],
  'Paddock': ['NNP'],
  'Paddy': ['NNP'],
  'Padget': ['NNP'],
  'Padgett': ['NNP'],
  'Padovan': ['NNP'],
  'Padre': ['NNP'],
  'Padres': ['NNPS'],
  'Pae': ['NNP'],
  'Paestum': ['NNP'],
  'Paev': ['NNP'],
  'Pagan': ['NNP'],
  'Paganini': ['NNS'],
  'Pagans': ['NNS'],
  'Page': ['NNP'],
  'PageAmerica': ['NNP'],
  'PageMaker': ['NNP'],
  'Pageant': ['NNP'],
  'Pageants': ['NNS'],
  'Pagemaker': ['NNP'],
  'Pages': ['NNPS'],
  'Paget': ['NNP'],
  'Paging': ['NNP'],
  'Paglieri': ['NNP'],
  'Pagliuca': ['NNP'],
  'Pagni': ['NNP'],
  'Pagnol': ['NNP'],
  'Pagones': ['NNP'],
  'Pagong': ['NNP'],
  'Pagurian': ['NNP'],
  'Pah': ['NNP'],
  'Paid': ['VBN'],
  'Pain': ['NN'],
  'Paine': ['NNP'],
  'PaineWebber': ['NNP'],
  'PaineWebber-involved': ['JJ'],
  'Painful': ['JJ'],
  'Paini': ['NNP'],
  'Pains': ['NNS'],
  'Paint': ['NN'],
  'Painter': ['NNP'],
  'Painters': ['NNS'],
  'Painting': ['VBG'],
  'Paintings': ['NNS'],
  'Paints': ['NNP'],
  'Paisley': ['NNP'],
  'Paix': ['NNP'],
  'Pak': ['NNP'],
  'Pakistan': ['NNP'],
  'Pakistani': ['JJ'],
  'Pakistanis': ['NNPS'],
  'Pal': ['NNP'],
  'Palace': ['NNP'],
  'Palaces': ['NNPS'],
  'Palache': ['NNP'],
  'Palacio': ['NNP'],
  'Paladin': ['NNP'],
  'Palamara': ['NNP'],
  'Palash': ['NNP'],
  'Palasts': ['NNPS'],
  'Palatine': ['NNP'],
  'Palazzo': ['NNP'],
  'Palcy': ['NNP'],
  'Pale': ['NNP'],
  'Palermo': ['NNP'],
  'Palestine': ['NNP'],
  'Palestine-General': ['NNP'],
  'Palestinian': ['JJ'],
  'Palestinians': ['NNPS'],
  'Paley': ['NNP'],
  'Palfrey': ['NNP'],
  'Palicka': ['NNP'],
  'Palisades': ['NNP'],
  'Pall': ['NNP'],
  'Palladian': ['NNP'],
  'Palladio': ['NNP'],
  'Pallavicini': ['NNP'],
  'Pallo': ['NNP'],
  'Palm': ['NNP'],
  'Palma': ['NNP'],
  'Palmatier': ['NNP'],
  'Palmdale': ['NNP'],
  'Palme': ['NNP'],
  'Palmer': ['NNP'],
  'Palmero': ['NNP'],
  'Palmetto': ['NNP'],
  'Palmingiano': ['NNP'],
  'Palmolive': ['NNP'],
  'Palms': ['NNPS'],
  'Palmtops': ['NNS'],
  'Palo': ['NNP'],
  'Palomar': ['NNP'],
  'Palomino': ['NNP'],
  'Palos': ['NNP'],
  'Palsy': ['NNP'],
  'Paluck': ['NNP'],
  'Palumbo': ['NNP'],
  'Pam': ['NNP'],
  'Pamasu': ['NNP'],
  'Pamela': ['NNP'],
  'Pamorex': ['NNP'],
  'Pamour': ['NNP'],
  'Pampa': ['NNP'],
  'Pampel': ['NNP'],
  'Pampers': ['NNPS'],
  'Pamphili': ['NNP'],
  'Pamplin': ['NNP'],
  'Pan': ['NNP'],
  'Pan-Alberta': ['NNP'],
  'Pan-American': ['JJ'],
  'PanAm': ['NNP'],
  'Panam': ['NNP'],
  'Panama': ['NNP'],
  'Panama-based': ['JJ'],
  'Panama-incorporated': ['JJ'],
  'Panamanian': ['JJ'],
  'Panamanians': ['NNS'],
  'Panasonic': ['NNP'],
  'Pancho': ['NNP'],
  'Pancoast': ['NNP'],
  'Pancrazio': ['NNP'],
  'Panda': ['NNP'],
  'Pandelli': ['NNP'],
  'Pandick': ['NNP'],
  'Pandora': ['NNP'],
  'Panel': ['NNP'],
  'Panelli': ['NNP'],
  'Panels': ['NNS'],
  'Panet-Raymond': ['NNP'],
  'Panetta': ['NNP'],
  'Panglossian': ['JJ'],
  'Panhandle': ['NNP'],
  'Panic': ['NN'],
  'Panicked': ['JJ'],
  'Panisse': ['NNP'],
  'Pankki': ['NNP'],
  'Pankowski': ['NNP'],
  'Pankyo': ['NNP'],
  'Panmunjom': ['NNP'],
  'Panny': ['NNP'],
  'Panorama': ['NNP'],
  'Panoz': ['NNP'],
  'Pansies': ['NNS'],
  'Pantages': ['NNS'],
  'Pantas': ['NNP'],
  'Pantasaph': ['NNP'],
  'Pantasote': ['NNP'],
  'Pantera': ['NNP'],
  'Pantheon': ['NNP'],
  'Panther': ['NNP'],
  'Panting': ['VBG'],
  'Pantyhose': ['NN'],
  'Panyotis': ['NNP'],
  'Panza': ['NNP'],
  'Panzhihua': ['NNP'],
  'Pao': ['NNP'],
  'Paolo': ['NNP'],
  'Paos': ['NNPS'],
  'Pap-pap-pap-hey': ['UH'],
  'Papa': ['NNP'],
  'Papa-san': ['NNP'],
  'Papal': ['JJ'],
  'Papandreou': ['NNP'],
  'Papanicolaou': ['NN'],
  'Papasan': ['NNP'],
  'Paper': ['NNP'],
  'Paperboard': ['NNP'],
  'Paperhouse': ['NNP'],
  'Paperin': ['NNP'],
  'Papermate': ['NNP'],
  'Papermils': ['NNP'],
  'Papers': ['NNP'],
  'Paperweight': ['NNP'],
  'Paperwork': ['NNP'],
  'Papetti': ['NNP'],
  'Papp': ['NNP'],
  'Pappas': ['NNP'],
  'Pappy': ['NNP'],
  'Paprika': ['NN'],
  'Papua': ['NNP'],
  'Papua-New': ['NNP'],
  'Paquin': ['NNP'],
  'Par': ['NNP'],
  'Paracchini': ['NNP'],
  'Parade': ['NNP'],
  'Paradise': ['NNP'],
  'Paradox': ['NNP'],
  'Paradoxically': ['RB'],
  'Paragon': ['NNP'],
  'Paragould': ['NNP'],
  'Paragraph': ['NNP'],
  'Parallel': ['JJ'],
  'Paramedics': ['NNS'],
  'Parametric': ['NNP'],
  'Paramount': ['NNP'],
  'Paramount-MCA': ['JJ'],
  'Paramus': ['NNP'],
  'Paranormal': ['NNP'],
  'Parapsychology': ['NNP'],
  'Paraquat': ['NN'],
  'Paray': ['NNP'],
  'Parc': ['NNP'],
  'Parcel': ['NNP'],
  'Pardo': ['NNP'],
  'Pardon': ['NN'],
  'Pardus': ['NNP'],
  'Paredon': ['NN'],
  'Paree': ['NNP'],
  'Parella': ['NNP'],
  'Parent': ['NNP'],
  'Parental': ['JJ'],
  'Parenthesis': ['NN'],
  'Parenthood': ['NNP'],
  'Parents': ['NNS'],
  'Pareo': ['NNP'],
  'Parfums': ['NNP'],
  'Paribas': ['NNP'],
  'Parichy': ['NNP'],
  'Parichy-Hamm': ['NNP'],
  'Parioli': ['NNP'],
  'Paris': ['NNP'],
  'Paris-based': ['JJ'],
  'Parish': ['NNP'],
  'Parisian': ['NNP'],
  'Parisians': ['NNPS'],
  'Parisien': ['NNP'],
  'Parisina': ['NNP'],
  'Parity': ['NN'],
  'Parizeau': ['NNP'],
  'Park': ['NNP'],
  'Park-affiliated': ['JJ'],
  'Parke': ['NNP'],
  'Parke-Davis': ['NNP'],
  'Parker': ['NNP'],
  'Parkersburg': ['NNP'],
  'Parkhaji': ['NNP'],
  'Parkhouse': ['NNP'],
  'Parkhurst': ['NNP'],
  'Parkinson': ['NNP'],
  'Parkland': ['NNP'],
  'Parkos': ['NNP'],
  'Parks': ['NNP'],
  'Parkshore': ['NNP'],
  'Parkway': ['NNP'],
  'Parkways': ['NNP'],
  'Parliament': ['NNP'],
  'Parliamentarians': ['NNP'],
  'Parliamentary': ['JJ'],
  'Parmer': ['NNP'],
  'Parodi': ['NNP'],
  'Parodis': ['NNS'],
  'Parretti': ['NNP'],
  'Parrillo': ['NNP'],
  'Parrino': ['NNP'],
  'Parris': ['NNP'],
  'Parrot': ['NNP'],
  'Parrott': ['NNP'],
  'Parry': ['NNP'],
  'Parsifal': ['NNP'],
  'Parsippany': ['NNP'],
  'Parsley': ['NNP'],
  'Parson': ['NNP'],
  'Parsons': ['NNP'],
  'Parsow': ['NNP'],
  'Part': ['NN'],
  'Part-time': ['JJ'],
  'Partecipazioni': ['NNP'],
  'Parthenon': ['NNP'],
  'Parti': ['NNP'],
  'Participants': ['NNS'],
  'Participating': ['VBG'],
  'Participation': ['NN'],
  'Particular': ['JJ'],
  'Particularly': ['RB'],
  'Parties': ['NNS'],
  'Partisan': ['NNP'],
  'Partisans': ['NNS'],
  'Partisanship': ['NN'],
  'Partlow': ['NNP'],
  'Partly': ['RB'],
  'Partner': ['NNP'],
  'Partners': ['NNPS'],
  'Partnership': ['NNP'],
  'Partnerships': ['NNS'],
  'Parts': ['NNS'],
  'Party': ['NNP'],
  'Party.': ['NNP'],
  'Parvenu': ['NNP'],
  'Pas': ['FW'],
  'Pasadena': ['NNP'],
  'Pasatieri': ['NNP'],
  'Pascagoula': ['NNP'],
  'Pascal': ['NNP'],
  'Pascale': ['NNP'],
  'Pascataqua': ['NNP'],
  'Paschal': ['NNP'],
  'Paschall': ['NNP'],
  'Paschi': ['NNP'],
  'Pascual': ['NNP'],
  'Pascutto': ['NNP'],
  'Pasha': ['NNP'],
  'Pasley': ['NNP'],
  'Paso': ['NNP'],
  'Pasoan': ['NNP'],
  'Pasquale': ['NNP'],
  'Pass': ['NNP'],
  'Passage': ['NN'],
  'Passaic': ['NNP'],
  'Passaic-Clifton': ['NNP'],
  'Passat': ['NNP'],
  'Passavant': ['NNP'],
  'Passed': ['VBN'],
  'Passenger': ['NN'],
  'Passengers': ['NNS'],
  'Passing': ['VBG'],
  'Passion': ['NNP'],
  'Passive': ['NNP'],
  'Passos': ['NNP'],
  'Passport': ['NN'],
  'Past': ['JJ'],
  'Pasta': ['NNP'],
  'Paster': ['NNP'],
  'Pastern': ['NNP'],
  'Pasternack': ['NNP'],
  'Pasternak': ['NNP'],
  'Pasterns': ['NNPS'],
  'Pasteur': ['NNP'],
  'Pastiche': ['NN'],
  'Pastor': ['NNP'],
  'Pasture': ['NNP'],
  'Pastures': ['NNS'],
  'Pasztor': ['NNP'],
  'Pat': ['NNP'],
  'Patagonia': ['NNP'],
  'Patagonians': ['NNPS'],
  'Patch': ['NNP'],
  'Patchen': ['NNP'],
  'Pate': ['NNP'],
  'Patel': ['NNP'],
  'Patent': ['NNP'],
  'Patentees': ['NNS'],
  'Patents': ['NNP'],
  'Pater': ['NNP'],
  'Paternelle': ['NNP'],
  'Paterson': ['NNP'],
  'Path': ['NNP'],
  'Pathans': ['NNPS'],
  'Pathe': ['NNP'],
  'Pathet': ['NNP'],
  'Pathology': ['NNP'],
  'Pati': ['FW'],
  'Patience': ['NN'],
  'Patiently': ['RB'],
  'Patients': ['NNS'],
  'Patil': ['NNP'],
  'Patman': ['NNP'],
  'Patmore': ['NNP'],
  'Patriarca': ['NNP'],
  'Patriarch': ['NNP'],
  'Patriarchy': ['NNP'],
  'Patrice': ['NNP'],
  'Patricelli': ['NNP'],
  'Patricia': ['NNP'],
  'Patrician': ['NN'],
  'Patricio': ['NNP'],
  'Patrick': ['NNP'],
  'Patricof': ['NNP'],
  'Patrimony': ['NNP'],
  'Patriot': ['NNP'],
  'Patriots': ['NNPS'],
  'Patrol': ['NNP'],
  'Patrolman': ['NNP'],
  'Patrolmen': ['NNP'],
  'Patronage': ['NN'],
  'Patsy': ['NNP'],
  'Patten': ['NNP'],
  'Pattenden': ['NNP'],
  'Pattern': ['NN'],
  'Patterns': ['NNS'],
  'Patterson': ['NNP'],
  'Patti': ['NNP'],
  'Pattison': ['NNP'],
  'Pattisson': ['NNP'],
  'Patton': ['NNP'],
  'Patty': ['NNP'],
  'Paul': ['NNP'],
  'Paul-Minneapolis': ['NNP'],
  'Paula': ['NNP'],
  'Paulah': ['NNP'],
  'Pauletta': ['NNP'],
  'Pauley': ['NNP'],
  'Pauleys': ['NNPS'],
  'Pauline': ['NNP'],
  'Pauling': ['NNP'],
  'Paulo': ['NNP'],
  'Paulus': ['NNP'],
  'Paus\'l': ['NN'],
  'Pausing': ['VBG'],
  'Pauson': ['NNP'],
  'Pautsch': ['NNP'],
  'Pavane': ['NNP'],
  'Pavarotti': ['NNP'],
  'Paved': ['VBN'],
  'Pavel': ['NNP'],
  'Pavese': ['NNP'],
  'Pavillion': ['NNP'],
  'Pavletich': ['NNP'],
  'Pavlov': ['NNP'],
  'Pavlova': ['NNP'],
  'Pavlovitch': ['NNP'],
  'Pavlovsky': ['NNP'],
  'Paw': ['NN'],
  'Pawcatuck': ['NNP'],
  'Pawley': ['NNP'],
  'Pawleys': ['NNP'],
  'Pawlowski': ['NNP'],
  'Pawtucket': ['NNP'],
  'Pawtuxet': ['NNP'],
  'Pax': ['NNP'],
  'Paxson': ['NNP'],
  'Paxton': ['NNP'],
  'Paxus': ['NNP'],
  'Pay': ['VB'],
  'Pay-Per-View': ['NNP'],
  'Payback': ['NN'],
  'Paychex': ['NNP'],
  'Payco': ['NNP'],
  'Payers': ['NNS'],
  'Paying': ['VBG'],
  'Payless': ['NNP'],
  'Payline': ['NNP'],
  'Payment': ['NN'],
  'Payments': ['NNS'],
  'Payne': ['NNP'],
  'Paynes': ['NNPS'],
  'Payola': ['NN'],
  'Payout': ['NN'],
  'Payouts': ['NNS'],
  'Payroll': ['NNP'],
  'Payson': ['NNP'],
  'Payton': ['NNP'],
  'Paz': ['NNP'],
  'Pe': ['NNP'],
  'Peabody': ['NNP'],
  'Peace': ['NNP'],
  'Peaceable': ['NNP'],
  'Peaceful': ['JJ'],
  'Peacekeeper': ['NNP'],
  'Peach': ['NNP'],
  'Peacocks': ['NNS'],
  'Peak': ['NNP'],
  'Peake': ['NNP'],
  'Peal': ['NNP'],
  'Peale': ['NNP'],
  'Peanut': ['NN'],
  'Peanuts': ['NNP'],
  'Peapack': ['NNP'],
  'Pearce': ['NNP'],
  'Pearl': ['NNP'],
  'Pearlman': ['NNP'],
  'Pearlstine': ['NNP'],
  'Pearson': ['NNP'],
  'Peasant': ['NNP'],
  'Peasants': ['NNPS'],
  'Pease': ['NNP'],
  'Peat': ['NNP'],
  'Pebworth': ['NNP'],
  'Pechiney': ['NNP'],
  'Pechman': ['NNP'],
  'Pechora': ['NNP'],
  'Pechora-class': ['JJ'],
  'Peck': ['NNP'],
  'Pecks': ['NNPS'],
  'Pecorone': ['NNP'],
  'Pecos': ['NNP'],
  'Pedde': ['NNP'],
  'Peden': ['NNP'],
  'Pedersen': ['NNP'],
  'Pederson': ['NNP'],
  'Pedestrian': ['NNP'],
  'Pediatric': ['NNP'],
  'Pediatricians': ['NNS'],
  'Pedigree': ['NNP'],
  'Pedigree-contemplating': ['VBG'],
  'Pedigrees': ['NNS'],
  'Pedone': ['NNP'],
  'Pedott': ['NNP'],
  'Pedro': ['NNP'],
  'Pedroli': ['NNP'],
  'Peduzzi': ['NNP'],
  'Pee': ['NNP'],
  'Peebles': ['NNP'],
  'Peeking': ['VBG'],
  'Peel': ['NNP'],
  'Peep': ['NNP'],
  'Peeping': ['NNP'],
  'Peepy': ['NNP'],
  'Peer': ['NNP'],
  'Peerless': ['NNP'],
  'Peery': ['NNP'],
  'Peeter': ['NNP'],
  'Peg': ['NNP'],
  'PegaSys': ['NNP'],
  'Pegasus': ['NNP'],
  'Peggy': ['NNP'],
  'Pegler': ['NNP'],
  'Pei': ['NNP'],
  'Peiping': ['NNP'],
  'Pekin': ['NNP'],
  'Peking': ['NNP'],
  'Peladeau': ['NNP'],
  'Pelham': ['NNP'],
  'Pelican': ['NNP'],
  'Pelin': ['NNP'],
  'Pell': ['NNP'],
  'Pellegrini': ['NNP'],
  'Peller': ['NNP'],
  'Pelletier': ['NNP'],
  'Pellicano': ['NNP'],
  'Pels': ['NNP'],
  'Pelto': ['NNP'],
  'Peltz': ['NNP'],
  'Pemberton': ['NNP'],
  'Pembina': ['NNP'],
  'Pembridge': ['NNP'],
  'Pembroke': ['NNP'],
  'Pemex': ['NNP'],
  'Pen': ['NNP'],
  'Pena': ['NNP'],
  'Penal': ['NNP'],
  'Penang': ['NNP'],
  'Pence': ['NNP'],
  'Pencil': ['NNP'],
  'Pencils': ['NNS'],
  'Pendant': ['NNP'],
  'Pendergast': ['NNP'],
  'Pending': ['VBG'],
  'Pendleton': ['NNP'],
  'Penelope': ['NNP'],
  'Peng': ['NNP'],
  'Pengally': ['NNP'],
  'Penguin': ['NNP'],
  'Penh': ['NNP'],
  'Peninsula': ['NNP'],
  'Penman': ['NNP'],
  'Penn': ['NNP'],
  'PennCorp': ['NNP'],
  'Penna.': ['FW'],
  'Pennell': ['NNP'],
  'Penney': ['NNP'],
  'Penniman': ['NNP'],
  'Pennington': ['NNP'],
  'Pennock': ['NNP'],
  'Pennsauken': ['NNP'],
  'Pennsylvania': ['NNP'],
  'Pennsylvania-based': ['JJ'],
  'Pennview': ['NNP'],
  'Penny': ['NNP'],
  'Pennzoil': ['NNP'],
  'Pennzoil\\\'/Texaco': ['NNP'],
  'Penrose': ['NNP'],
  'Pensacola': ['NNP'],
  'Pension': ['NN'],
  'Pension-fund': ['NN'],
  'Pensive': ['JJ'],
  'Pensupreme': ['NNP'],
  'Pentagon': ['NNP'],
  'Pentagon-related': ['JJ'],
  'Pentagonese': ['NNP'],
  'Pentecostal': ['NNP'],
  'Penthouse': ['NNP'],
  'Penutian': ['NNP'],
  'Peony': ['NNP'],
  'People': ['NNS'],
  'Peoples': ['NNPS'],
  'Peoria': ['NNP'],
  'Pepcid': ['NNP'],
  'Pepinsky': ['NNP'],
  'Pepper': ['NNP'],
  'Pepper\\\'/Seven': ['NNP'],
  'Pepperdine': ['NNP'],
  'Pepperell': ['NNP'],
  'Pepperidge': ['NNP'],
  'Peppers': ['NNP'],
  'Pepsi': ['NNP'],
  'Pepsi-Cola': ['NNP'],
  'PepsiCo': ['NNP'],
  'PepsiCola': ['NNP'],
  'Pepto-Bismol': ['NNP'],
  'Per': ['IN'],
  'Per-capita': ['JJ'],
  'Per-share': ['JJ'],
  'Peralta': ['NNP'],
  'Perasso': ['NNP'],
  'Percent': ['NN'],
  'Percentage': ['NN'],
  'Perception': ['NN'],
  'Perch': ['NNP'],
  'Perchdale': ['NNP'],
  'Perched': ['VBN'],
  'Perches': ['NNP'],
  'Percival': ['NNP'],
  'Percussion': ['NNP'],
  'Percussive': ['NNP'],
  'Percy': ['NNP'],
  'Perdido': ['NNP'],
  'Perdue': ['NNP'],
  'Pere': ['NNP'],
  'Peregrine': ['NNP'],
  'Pereira': ['NNP'],
  'Perella': ['NNP'],
  'Perelman': ['NNP'],
  'Perennial': ['JJ'],
  'Perennian': ['NNP'],
  'Peres': ['NNP'],
  'Perestroika': ['FW'],
  'Perez': ['NNP'],
  'Perfect': ['JJ'],
  'Perfecta': ['NNP'],
  'Perfection': ['NNP'],
  'Performance': ['NN'],
  'Performances': ['NNPS'],
  'Performed': ['VBN'],
  'Performers': ['NNS'],
  'Performing': ['VBG'],
  'Perfume': ['NN'],
  'Perfumes': ['NNPS'],
  'Pergamon': ['NNP'],
  'Pergolesi': ['NNP'],
  'Perham': ['NNP'],
  'Perhaps': ['RB'],
  'Pericle': ['NNP'],
  'Periclean': ['NNP'],
  'Pericles': ['NNP'],
  'Perier': ['NNP'],
  'Perignon': ['NNP'],
  'Perimeter': ['NNP'],
  'Perin': ['NNP'],
  'Perinetti': ['NNP'],
  'Period': ['NN'],
  'Periodic': ['JJ'],
  'Periodically': ['RB'],
  'Periods': ['NNS'],
  'Peripherals': ['NNPS'],
  'Perish': ['VB'],
  'Perito': ['NNP'],
  'Perk': ['NNP'],
  'Perken': ['NNP'],
  'Perkin-Elmer': ['NNP'],
  'PerkinElmer': ['NNP'],
  'Perkins': ['NNP'],
  'Perle': ['NNP'],
  'Perlman': ['NNP'],
  'Perluss': ['NNP'],
  'Permanent': ['JJ'],
  'Permanente': ['NNP'],
  'Permian': ['NNP'],
  'Permission': ['NN'],
  'Permit': ['VB'],
  'Permits': ['NNS'],
  'Permut': ['NNP'],
  'Perna': ['NNP'],
  'Pernod': ['NN'],
  'Peron': ['NNP'],
  'Peronist': ['NNP'],
  'Perot': ['NNP'],
  'Perot-EDS': ['JJ'],
  'Perozo': ['NNP'],
  'Perpetual': ['JJ'],
  'Perrier': ['NNP'],
  'Perrin': ['NNP'],
  'Perritt': ['NNP'],
  'Perro': ['NNP'],
  'Perry': ['NNP'],
  'Perse': ['NNP'],
  'Pershare': ['JJ'],
  'Pershing': ['NNP'],
  'Persia': ['NNP'],
  'Persian': ['NNP'],
  'Persianesque': ['JJ'],
  'Persians': ['NNPS'],
  'Persico': ['NNP'],
  'Persky': ['NNP'],
  'Perskys': ['NNPS'],
  'Person': ['NNP'],
  'Persona': ['NNP'],
  'Personages': ['NNS'],
  'Personal': ['JJ'],
  'Personal-computer': ['NN'],
  'Personality': ['NNP'],
  'Personally': ['RB'],
  'Personnel': ['NNP'],
  'Persons': ['NNS'],
  'Perspective': ['NNP'],
  'Persuading': ['VBG'],
  'Persuasion': ['NN'],
  'Pertamina': ['NNP'],
  'Perth': ['NNP'],
  'Perth-based': ['JJ'],
  'Pertschuk': ['NNP'],
  'Peru': ['NNP'],
  'Peruvian': ['JJ'],
  'Pervanas': ['NNP'],
  'Perzio-Biroli': ['NNP'],
  'Pesaro': ['NNP'],
  'Pesce': ['NNP'],
  'Pesqueira': ['NNP'],
  'Pestered': ['VBN'],
  'Pesticide': ['NNP'],
  'Pesticides': ['NNS'],
  'Pestillo': ['NNP'],
  'Pestle': ['NNP'],
  'Pet': ['NNP'],
  'Petaluma': ['NNP'],
  'Petco': ['NNP'],
  'Pete': ['NNP'],
  'Peter': ['NNP'],
  'Peterborough': ['NNP'],
  'Peterbroeck': ['NNP'],
  'Peterhouse': ['NNP'],
  'Peterman': ['NNP'],
  'Petermann': ['NNP'],
  'Peterpaul': ['NNP'],
  'Peters': ['NNP'],
  'Petersburg': ['NNP'],
  'Petersen': ['NNP'],
  'Peterson': ['NNP'],
  'Peterson-Kroll': ['NNP'],
  'Petery': ['NNP'],
  'Petey': ['NN'],
  'Petfoods': ['NNPS'],
  'Petipa': ['NNP'],
  'Petipa-Minkus': ['NNP'],
  'Petipa-Tschaikowsky': ['NNP'],
  'Petit': ['NNP'],
  'Petite': ['JJ'],
  'Petitio': ['NNP'],
  'Petitioner': ['NN'],
  'Petitions': ['NNS'],
  'Petrarchan': ['JJ'],
  'Petre': ['NNP'],
  'Petrie': ['NNP'],
  'Petrini': ['NNP'],
  'Petro': ['NNP'],
  'Petro-Canada': ['NNP'],
  'Petrobras': ['NNP'],
  'Petrochemical': ['NNP'],
  'Petrocorp': ['NNP'],
  'Petrofina': ['NNP'],
  'Petrograd': ['NNP'],
  'Petrolane': ['NNP'],
  'Petroleos': ['NNP'],
  'Petroles': ['NNP'],
  'Petroleum': ['NNP'],
  'Petroliam': ['NNP'],
  'Petronas': ['NNP'],
  'Petrone': ['NNP'],
  'Petrossian': ['NNP'],
  'Petrovich': ['NNP'],
  'Petruchka': ['NNP'],
  'Petrus': ['NNP'],
  'Petruzzi': ['NNP'],
  'Petry': ['NNP'],
  'Pets': ['NNS'],
  'Pettee': ['NNP'],
  'Pettersson': ['NNP'],
  'Pettibone': ['NNP'],
  'Pettigrew': ['NNP'],
  'Pettis': ['NNP'],
  'Pettit': ['NNP'],
  'Petty': ['NNP'],
  'Peugeot': ['NNP'],
  'Pew': ['NNP'],
  'Pewabic': ['NNP'],
  'Peyrelongue': ['NNP'],
  'Pezza': ['NNP'],
  'Pfaff': ['NNP'],
  'Pfau': ['NNP'],
  'Pfc.': ['NNP'],
  'Pfeiffer': ['NNP'],
  'Pfiefer': ['NNP'],
  'Pfizer': ['NNP'],
  'Pflaum': ['NNP'],
  'Pflugerville': ['NNP'],
  'Pfohl': ['NNP'],
  'Ph.': ['NNP'],
  'PhacoFlex': ['NNP'],
  'Phalanx': ['NNP'],
  'Phamaceutical': ['NNP'],
  'Phamaceuticals': ['NNPS'],
  'Phantom': ['NNP'],
  'Pharaoh': ['NNP'],
  'Pharma': ['NNP'],
  'PharmaKinetics': ['NNP'],
  'Pharmacal': ['NNP'],
  'Pharmaceutical': ['NNP'],
  'Pharmaceuticals': ['NNP'],
  'Pharmacia': ['NNP'],
  'Pharmacies': ['NNS'],
  'Pharmacopoeia': ['NN'],
  'Pharmacuetica': ['NNP'],
  'Pharmacy': ['NNP'],
  'Pharmical': ['NNP'],
  'Pharmics': ['NNP'],
  'Phase': ['NN'],
  'Phase-2': ['NN'],
  'Phase-3': ['NN'],
  'Phedre': ['NNP'],
  'Phelan': ['NNP'],
  'Phelps': ['NNP'],
  'Phenix-Transmission': ['NNP'],
  'Phenolic': ['JJ'],
  'Phenothiazine': ['NN'],
  'Pherwani': ['NNP'],
  'Phi': ['NNP'],
  'Phibro': ['NNP'],
  'Phil': ['NNP'],
  'Philadelphia': ['NNP'],
  'Philadelphia-area': ['JJ'],
  'Philadelphia-based': ['JJ'],
  'Philanthropic': ['NNP'],
  'Philco': ['NNP'],
  'Philco-sponsored': ['JJ'],
  'Philharmonic': ['NNP'],
  'Philharmonique': ['NNP'],
  'Philibert': ['NNP'],
  'Philinte': ['NNP'],
  'Philip': ['NNP'],
  'Philippe': ['NNP'],
  'Philippi': ['NNP'],
  'Philippians': ['NNS'],
  'Philippine': ['JJ'],
  'Philippine-studies': ['NN'],
  'Philippines': ['NNP'],
  'Philippines-backed': ['JJ'],
  'Philippoff': ['NNP'],
  'Philips': ['NNP'],
  'Philistines': ['NNPS'],
  'Phillies': ['NNP'],
  'Phillip': ['NNP'],
  'Phillipe': ['NNP'],
  'Phillipines': ['NNS'],
  'Phillippe-Francois': ['NNP'],
  'Phillips': ['NNP'],
  'Philly': ['RB'],
  'Philmont': ['NNP'],
  'Philo': ['NNP'],
  'Philosophic': ['JJ'],
  'Philosophical': ['NNP'],
  'Philosophies': ['NNP'],
  'Philosophy': ['NN'],
  'Phils': ['NNPS'],
  'Phineas': ['NNP'],
  'Phineoppus': ['NNP'],
  'Phipps': ['NNP'],
  'Phnom': ['NNP'],
  'Phoenician': ['JJ'],
  'Phoenicians': ['NNS'],
  'Phoenix': ['NNP'],
  'Phoenix-based': ['JJ'],
  'Phoenixville': ['NNP'],
  'Phone': ['NN'],
  'Phonemes': ['NNS'],
  'Phosphate': ['NNP'],
  'Phosphates': ['NNP'],
  'Photek': ['NNP'],
  'Photo': ['NNP'],
  'Photofinishing': ['NNP'],
  'Photofrin': ['NN'],
  'Photograph': ['NN'],
  'Photographer': ['NNP'],
  'Photographers': ['NNP'],
  'Photographic': ['JJ'],
  'Photographing': ['NNP'],
  'Photography': ['NNP'],
  'Photonics': ['NNP'],
  'Photoprotective': ['NNP'],
  'Photos': ['NNS'],
  'Phouma': ['NNP'],
  'Phrase': ['NNP'],
  'Phuong': ['NNP'],
  'Phyfe': ['NNP'],
  'Phyllis': ['NNP'],
  'Physical': ['NNP'],
  'Physically': ['RB'],
  'Physician': ['NN'],
  'Physicians': ['NNP'],
  'Physicist': ['NNP'],
  'Physicists': ['NNS'],
  'Physicochemical': ['JJ'],
  'Physics': ['NNP'],
  'Physiological': ['NNP'],
  'Physiologically': ['RB'],
  'Physiologist': ['NNP'],
  'Physiology': ['NNP'],
  'Physique': ['NN'],
  'Pi': ['NN'],
  'Pia': ['NNP'],
  'Pianists': ['NNS'],
  'Piano': ['NNP'],
  'Pianos': ['NNP'],
  'Piazza': ['NNP'],
  'Piazzo': ['NNP'],
  'Pic': ['NNP'],
  'Picasso': ['NNP'],
  'Picassos': ['NNPS'],
  'Piccadilly': ['NNP'],
  'Picchi': ['NNP'],
  'Piccolino': ['NNP'],
  'Pichia': ['NN'],
  'Pick': ['VB'],
  'Pickard': ['NNP'],
  'Pickens': ['NNP'],
  'Pickering': ['NNP'],
  'Pickett': ['NNP'],
  'Pickfair': ['NNP'],
  'Pickford': ['NNP'],
  'Pickin': ['VBG'],
  'Pickle': ['NNP'],
  'Pickman': ['NNP'],
  'Picks': ['VBZ'],
  'Pickup': ['NNP'],
  'Picon': ['NNP'],
  'Picop': ['NNP'],
  'Picoult': ['NNP'],
  'Picture': ['NNP'],
  'Pictures': ['NNPS'],
  'Picturing': ['VBG'],
  'Picus': ['NNP'],
  'Piddington': ['NNP'],
  'Pie': ['NNP'],
  'Pieces': ['NNP'],
  'Piedmont': ['NNP'],
  'Piepsam': ['NNP'],
  'Pier': ['NNP'],
  'Pierce': ['NNP'],
  'Pierluigi': ['NNP'],
  'Piero': ['NNP'],
  'Pierpont': ['NNP'],
  'Pierre': ['NNP'],
  'Pierre-Karl': ['NNP'],
  'Piers': ['NNP'],
  'Piersee': ['NNP'],
  'Pierson': ['NNP'],
  'Piet': ['NNP'],
  'Pieta': ['NNP'],
  'Pieter': ['NNP'],
  'Pietermartizburg': ['NNP'],
  'Pietism': ['NNP'],
  'Pietro': ['NNP'],
  'Pietruski': ['NNP'],
  'Pigeon': ['NNP'],
  'Piggybacking': ['VBG'],
  'Pignatelli': ['NNP'],
  'Pigs': ['NNPS'],
  'Pikaia': ['NNP'],
  'Pike': ['NNP'],
  'Pikeville': ['NNP'],
  'Pilate': ['NNP'],
  'Pile': ['NNP'],
  'Pileggi': ['NNP'],
  'Pilevsky': ['NNP'],
  'Pilferage': ['NN'],
  'Pilgrim': ['NNP'],
  'Pilgrimage': ['NNP'],
  'Pilgrims': ['NNPS'],
  'Pilgrin': ['NNP'],
  'Pilgrm': ['NNP'],
  'Pilipino': ['NN'],
  'Pilko': ['NNP'],
  'Pillay': ['NNP'],
  'Piller': ['NNP'],
  'Pillsbury': ['NNP'],
  'Pilot': ['NN'],
  'Piloting': ['VBG'],
  'Pilots': ['NNS'],
  'Pils': ['NNP'],
  'Pilson': ['NNP'],
  'Pilsudski': ['NNP'],
  'Pimen': ['NNP'],
  'Pimlott': ['NNP'],
  'Pin': ['VB'],
  'Pina': ['NNP'],
  'Pinar': ['NNP'],
  'Pincavage': ['NNP'],
  'Pincian': ['NNP'],
  'Pincus': ['NNP'],
  'Pindling': ['NNP'],
  'Pine': ['NNP'],
  'Pinel': ['NNP'],
  'Pinellas': ['NNP'],
  'Pines': ['NNP'],
  'Ping-pong': ['NN'],
  'Pinick': ['NNP'],
  'Pinion': ['NNP'],
  'Pink': ['NNP'],
  'Pinkerton': ['NNP'],
  'Pinkie': ['NN'],
  'Pinky': ['NNP'],
  'Pinnacle': ['NNP'],
  'Pinned': ['VBN'],
  'Pinola': ['NNP'],
  'Pinpoint': ['NNP'],
  'Pinscher': ['NN'],
  'Pinsk': ['NNP'],
  'Pinsoneault': ['NNP'],
  'Pinter': ['NNP'],
  'Pioneer': ['NNP'],
  'Pioneering': ['NNP'],
  'Pioneers': ['NNPS'],
  'Piovra': ['FW'],
  'Pip': ['NNP'],
  'Pipe': ['NNP'],
  'PipeLines': ['NNP'],
  'Pipeline': ['NNP'],
  'Piper': ['NNP'],
  'Pipes': ['NNP'],
  'Pipgras': ['NNP'],
  'Piping': ['NN'],
  'Piraeus': ['NNP'],
  'Pirandello': ['NNP'],
  'Piranesi': ['NNP'],
  'Piraro': ['NNP'],
  'Pirate': ['NNP'],
  'Pirates': ['NNP'],
  'Pirelli': ['NNP'],
  'Pirie': ['NNP'],
  'Pirko': ['NNP'],
  'Pirrie': ['NNP'],
  'Pisa': ['NNP'],
  'Piscataway': ['NNP'],
  'Pisces': ['NNP'],
  'Pischinger': ['NNP'],
  'Piscopo': ['NNP'],
  'Pissarro': ['NNP'],
  'Pissocra': ['NNP'],
  'Pistol-whipping': ['IN'],
  'Piszczalski': ['NNP'],
  'Pit': ['NN'],
  'Pita': ['NNP'],
  'Pitch': ['NN'],
  'Pitcher': ['NN'],
  'Pitchers': ['NNS'],
  'Pitching': ['VBG'],
  'Pitcoff': ['NNP'],
  'Pitfalls': ['NNS'],
  'Pitiful': ['NNP'],
  'Pitman': ['NNP'],
  'Pitman-Moore': ['NNP'],
  'Pitney': ['NNP'],
  'Pitney-Bowes': ['NNP'],
  'Pitt': ['NNP'],
  'Pitt-Rivers': ['NNP'],
  'Pitted': ['VBN'],
  'Pittenger': ['NNP'],
  'Pittman': ['NNP'],
  'Pittsboro': ['NNP'],
  'Pittsburg': ['NNP'],
  'Pittsburgh': ['NNP'],
  'Pittsburgh-based': ['JJ'],
  'Pittsburghers': ['NNPS'],
  'Pittston': ['NNP'],
  'Pity': ['NNP'],
  'Pitz': ['NNP'],
  'Pius': ['NNP'],
  'Pivot': ['NNP'],
  'Piwen': ['NNP'],
  'Pixley': ['NNP'],
  'Pizarro': ['NNP'],
  'Pizza': ['NNP'],
  'Pizzo': ['NNP'],
  'Place': ['NNP'],
  'Place-names': ['NNS'],
  'Placement': ['NNP'],
  'Placements': ['NNP'],
  'Placentia': ['NNP'],
  'Placer': ['NNP'],
  'Places': ['NNS'],
  'Placid': ['NNP'],
  'Placido': ['NNP'],
  'Placing': ['VBG'],
  'Plain': ['NNP'],
  'Plain-vanilla': ['JJ'],
  'Plaines': ['NNP'],
  'Plainfield': ['NNP'],
  'Plainly': ['RB'],
  'Plains': ['NNP'],
  'Plaintiffs': ['NNS'],
  'Plaintiffs``': ['``'],
  'Plainview': ['NNP'],
  'Plan': ['NNP'],
  'PlanEcon': ['NNP'],
  'Planar': ['NNP'],
  'Planck': ['NNP'],
  'Plane': ['NNP'],
  'Planes': ['NNS'],
  'Planet': ['NNP'],
  'Planeten': ['NNP'],
  'Planitzer': ['NNP'],
  'Plank': ['VB'],
  'Planned': ['NNP'],
  'Planners': ['NNS'],
  'Planning': ['NNP'],
  'Plano': ['NNP'],
  'Plans': ['NNS'],
  'Plant': ['NNP'],
  'Plantago': ['NN'],
  'Plantation': ['NNP'],
  'Plantations': ['NNS'],
  'Planter': ['NNP'],
  'Planters': ['NNP'],
  'Plants': ['NNS'],
  'Plaskett': ['NNP'],
  'Plaster': ['NNP'],
  'Plasti-Bars': ['NNP'],
  'Plastic': ['JJ'],
  'Plastics': ['NNS'],
  'Plastow': ['NNP'],
  'Plate': ['NNP'],
  'Plateadas': ['NNP'],
  'Plateau': ['NNP'],
  'Plates': ['NNS'],
  'Platform': ['NN'],
  'Plath': ['NNP'],
  'Platinum': ['NN'],
  'Plato': ['NNP'],
  'Platonic': ['JJ'],
  'Platonica': ['FW'],
  'Platonism': ['NN'],
  'Platonist': ['NN'],
  'Platoons': ['NNS'],
  'Platt': ['NNP'],
  'Platter': ['NNP'],
  'Platzer': ['NNP'],
  'Plaude': ['NNP'],
  'Plaumann': ['NNP'],
  'Play': ['NNP'],
  'Playa': ['NNP'],
  'Playback': ['NNP'],
  'Playboy': ['NNP'],
  'Playboy-Show-Biz': ['NNP'],
  'Playboy-at-Night': ['NNP'],
  'Played': ['VBN'],
  'Player': ['NNP'],
  'Players': ['NNPS'],
  'Playes': ['NNP'],
  'Playgirl': ['NNP'],
  'Playground': ['NNP'],
  'Playhouse': ['NNP'],
  'Playhouses': ['NNP'],
  'Playing': ['VBG'],
  'Playmates': ['NNPS'],
  'Plays': ['NNP'],
  'Playskool': ['NNP'],
  'Playtex': ['NNP'],
  'Playworld': ['NNP'],
  'Playwrights': ['NNP'],
  'Plaza': ['NNP'],
  'Plazek': ['NNP'],
  'Plea': ['NN'],
  'Pleas': ['NNPS'],
  'Pleasant': ['NNP'],
  'Pleasanton': ['NNP'],
  'Pleasantville': ['NNP'],
  'Please': ['VB'],
  'Pleasure': ['NN'],
  'Plebian': ['JJ'],
  'Pledge': ['NNP'],
  'Plee-Zing': ['NNP'],
  'Plekhanov': ['NNP'],
  'Plenary': ['NNP'],
  'Plenitude': ['NNP'],
  'Plenty': ['NN'],
  'Plentywood': ['NNP'],
  'Plessey': ['NNP'],
  'Plessis': ['NNP'],
  'Plews': ['NNP'],
  'Plexiglas': ['NN'],
  'Plimpton': ['NNP'],
  'Pliny': ['NN'],
  'Plot': ['NN'],
  'Plotkin': ['NNP'],
  'Plouf': ['NNP'],
  'Plow': ['NNP'],
  'Plowman': ['NN'],
  'Ploys': ['NNS'],
  'Plug-in': ['JJ'],
  'Plugging': ['VBG'],
  'Plumbing': ['NNP'],
  'Plummer': ['NNP'],
  'Plump': ['JJ'],
  'Plumrose': ['NNP'],
  'Plunge': ['NN'],
  'Plunging': ['VBG'],
  'Plunkett': ['NNP'],
  'Plunking': ['VBG'],
  'Plus': ['NNP'],
  'Plus-one': ['JJ'],
  'Pluses': ['NNS'],
  'Plutarch': ['NNP'],
  'Plymouth': ['NNP'],
  'Plympton': ['NNP'],
  'Pm': ['NN'],
  'Png': ['NNP'],
  'Po': ['NNP'],
  'Poach': ['VB'],
  'Poachers': ['NNS'],
  'Poag': ['NNP'],
  'Pocasset': ['NNP'],
  'Pocket': ['NNP'],
  'Pocketing': ['VBG'],
  'Pockets': ['NNS'],
  'Pocklington': ['NNP'],
  'Pockmanster': ['NNP'],
  'Poconos': ['NNPS'],
  'Pod': ['NNP'],
  'Podell': ['NNP'],
  'Podger': ['NNP'],
  'Podgers': ['NNS'],
  'Podolia': ['NNP'],
  'Podolsky': ['NNP'],
  'Podufaly': ['NNP'],
  'Poduska': ['NNP'],
  'Poe': ['NNP'],
  'Poehl': ['NNP'],
  'Poelker': ['NNP'],
  'Poeme': ['NNP'],
  'Poems': ['NNPS'],
  'Poesy': ['NN'],
  'Poet': ['NNP'],
  'Poetics': ['NNP'],
  'Poetrie': ['NNP'],
  'Poetry': ['NNP'],
  'Poets': ['NNS'],
  'Pogue': ['NNP'],
  'Pohl': ['NNP'],
  'Pohlad': ['NNP'],
  'Pohly': ['NNP'],
  'Pohs': ['NNP'],
  'Poindexter': ['NNP'],
  'Point': ['NNP'],
  'Point-Pepperell': ['NNP'],
  'Pointe': ['NNP'],
  'Pointer': ['NNP'],
  'Pointers': ['NNS'],
  'Pointes': ['NNP'],
  'Pointing': ['VBG'],
  'Points': ['NNPS'],
  'Poirot': ['NNP'],
  'Poised': ['NNP'],
  'Poison': ['NN'],
  'Poitrine': ['NNP'],
  'Poker': ['NN'],
  'Pokorny': ['NNP'],
  'Pol': ['NNP'],
  'Pola': ['NNP'],
  'Poland': ['NNP'],
  'Polar': ['NNP'],
  'Polaris': ['NNP'],
  'Polaroid': ['NNP'],
  'Poldowski': ['NNP'],
  'Pole': ['NNP'],
  'Poles': ['NNPS'],
  'Polevoi': ['NNP'],
  'Polian': ['NNP'],
  'Police': ['NNP'],
  'Police-man': ['NNP'],
  'Policeman': ['NNP'],
  'Policemen': ['NNS'],
  'Policies': ['NNS'],
  'Policy': ['NNP'],
  'Polimotor': ['NNP'],
  'Poling': ['NNP'],
  'Polish': ['JJ'],
  'Polished': ['JJ'],
  'Politan': ['NNP'],
  'Politburo': ['NNP'],
  'Political': ['JJ'],
  'Political-Military': ['NNP'],
  'Politically': ['RB'],
  'Politicians': ['NNS'],
  'Politics': ['NNP'],
  'Politics-ridden': ['JJ'],
  'Politizdat': ['NNP'],
  'Politrick': ['NN'],
  'Polk': ['NNP'],
  'Poll': ['NNP'],
  'Pollack': ['NNP'],
  'Pollak': ['NNP'],
  'Pollare': ['NNP'],
  'Pollen': ['NNP'],
  'Pollin': ['NNP'],
  'Pollitt': ['NNP'],
  'Pollnow': ['NNP'],
  'Pollo': ['NNP'],
  'Pollock': ['NNP'],
  'Polls': ['NNS'],
  'Pollution': ['NNP'],
  'Pollution-control': ['JJ'],
  'Polly': ['NNP'],
  'Polo': ['NNP'],
  'Polo\\\'/Ralph': ['NNP'],
  'Pololu': ['NNP'],
  'Polsky': ['NNP'],
  'Poltava': ['NNP'],
  'Poltawa': ['NNP'],
  'Poltrack': ['NNP'],
  'PolyGram': ['NNP'],
  'Polyakova': ['NNP'],
  'Polyanka': ['NNP'],
  'Polycast': ['NNP'],
  'Polychemicals': ['NNP'],
  'Polyconomics': ['NNP'],
  'Polygram': ['NNP'],
  'Polymerix': ['NNP'],
  'Polymerization': ['NN'],
  'Polyphosphates': ['NNS'],
  'Polypropylene': ['NN'],
  'Polysar': ['NNP'],
  'Polysilicon': ['NN'],
  'Polystyrene': ['NNP'],
  'Polytechnic': ['NNP'],
  'Polyurethane': ['NN'],
  'Polyvinyl': ['NN'],
  'Pomerania': ['NNP'],
  'Pomerantz': ['NNP'],
  'Pomham': ['NNP'],
  'Pomicino': ['NNP'],
  'Pomona': ['NNP'],
  'Pompadour': ['NNP'],
  'Pompano': ['NNP'],
  'Pompeii': ['NNP'],
  'Pompey': ['NNP'],
  'Pomton': ['NNP'],
  'Ponce': ['NNP'],
  'Ponchartrain': ['NNP'],
  'Ponchielli': ['NNP'],
  'Pond': ['NNP'],
  'Ponder': ['VBP'],
  'Pong': ['NNP'],
  'Ponkob': ['NNP'],
  'Ponoluu': ['NNP'],
  'Pons': ['NNP'],
  'Pont': ['NNP'],
  'Pontchartrain': ['NNP'],
  'Pontiac': ['NNP'],
  'Pontiac-Cadillac': ['NNP'],
  'Pontiff': ['NNP'],
  'Pontissara': ['NNP'],
  'Pontius': ['NNP'],
  'Pony': ['NNP'],
  'Ponzi': ['NNP'],
  'Poo': ['NNP'],
  'Poodle': ['NNP'],
  'Pooh': ['NNP'],
  'Pooh-like': ['JJ'],
  'Pool': ['NNP'],
  'Poole': ['NNP'],
  'Pooling': ['NNP'],
  'Poong': ['NNP'],
  'Poor': ['NNP'],
  'Poore': ['NNP'],
  'Poorer': ['JJR'],
  'Poorest': ['JJS'],
  'Pop': ['NN'],
  'Pope': ['NNP'],
  'Popes': ['NNPS'],
  'Popeye': ['NNP'],
  'Popish': ['NNP'],
  'Popkin': ['NNP'],
  'Popoff': ['NNP'],
  'Popolare': ['NNP'],
  'Poppea': ['FW'],
  'Poppenberg': ['NNP'],
  'Popping': ['VBG'],
  'Poppins': ['NNP'],
  'Pops': ['NNP'],
  'Populace': ['NN'],
  'Populaire': ['NNP'],
  'Populaires': ['NNP'],
  'Popular': ['NNP'],
  'Populares': ['NNP'],
  'Popularism': ['NN'],
  'Population': ['NNP'],
  'Poquet': ['NNP'],
  'Porcaro': ['NNP'],
  'Porch': ['NNP'],
  'Porche': ['NNP'],
  'Porgy': ['NNP'],
  'Pork': ['NNP'],
  'Pork-barrel': ['JJ'],
  'Porkapolis': ['NNP'],
  'Pornographer': ['NNP'],
  'Pornsen': ['NNP'],
  'Porres': ['NNP'],
  'Porretti': ['NNP'],
  'Porsche': ['NNP'],
  'Porsche-like': ['JJ'],
  'Porsches': ['NNPS'],
  'Port': ['NNP'],
  'Port-au-Prince': ['NNP'],
  'Porta': ['NNP'],
  'Porta-Potti': ['NNP'],
  'Portage': ['NNP'],
  'Portago': ['NNP'],
  'Porter': ['NNP'],
  'Porterhouse': ['NN'],
  'Porters': ['NNPS'],
  'Portfolio': ['NNP'],
  'Portfolios': ['NNPS'],
  'Portia': ['NNP'],
  'Portico': ['NNP'],
  'Portillo': ['NNP'],
  'Portland': ['NNP'],
  'Portman': ['NNP'],
  'Porto': ['NNP'],
  'Portrait': ['NN'],
  'Portraits': ['NNPS'],
  'Portrayal': ['NN'],
  'Ports': ['NNP'],
  'Portsmouth': ['NNP'],
  'Portugal': ['NNP'],
  'Portuguese': ['JJ'],
  'Portuguese-language': ['JJ'],
  'Portwatchers': ['NNPS'],
  'Porum': ['NNP'],
  'Poseidon': ['NNP'],
  'Posey': ['NNP'],
  'Posh': ['JJ'],
  'Position': ['NN'],
  'Positive': ['JJ'],
  'Posix': ['NNP'],
  'Posner': ['NNP'],
  'Possible': ['JJ'],
  'Possibly': ['RB'],
  'Post': ['NNP'],
  'Post-Dispatch': ['NNP'],
  'Post-Graduate': ['NNP'],
  'Post-Newsweek': ['NNP'],
  'Post-Serialism': ['NNP'],
  'Post-tragedy': ['RB'],
  'PostScript': ['NNP'],
  'Postal': ['NNP'],
  'Postbank': ['NNP'],
  'Posted': ['VBN'],
  'Postel': ['NNP'],
  'Postelle': ['NNP'],
  'Postels': ['NNPS'],
  'Poster': ['NNP'],
  'Posterity': ['NN'],
  'Postipankki': ['NNP'],
  'Postmaster': ['NNP'],
  'Posts': ['VBZ'],
  'Postscript': ['NNP'],
  'Postwar': ['RB'],
  'Poszgay': ['NNP'],
  'Pot': ['NNP'],
  'Potala': ['NNP'],
  'Potash': ['NNP'],
  'Potato': ['NN'],
  'Potemkin': ['NNP'],
  'Potential': ['JJ'],
  'Potentially': ['RB'],
  'Pothier': ['NNP'],
  'Pothitos': ['NNP'],
  'Potlatch': ['NNP'],
  'Potlatches': ['NNPS'],
  'Potomac': ['NNP'],
  'Potowomut': ['NNP'],
  'Potpourri': ['NNS'],
  'Potsdam': ['NNP'],
  'Pottawatomie': ['NNP'],
  'Potter': ['NNP'],
  'Pottery': ['NNP'],
  'Potts': ['NNP'],
  'Poughkeepsie': ['NNP'],
  'Pouilly-Fuisse': ['NNP'],
  'Poul': ['NNP'],
  'Poulenc': ['NNP'],
  'Poulin': ['NNP'],
  'Poultry': ['NN'],
  'Pound': ['NNP'],
  'Pounds': ['NNS'],
  'Pountain': ['NNP'],
  'Poupin': ['NNP'],
  'Pour': ['NNP'],
  'Poussin': ['NNP'],
  'Poussins': ['NNS'],
  'Poverty': ['NN'],
  'Povich': ['NNP'],
  'Powder': ['NNP'],
  'Powell': ['NNP'],
  'Power': ['NNP'],
  'Power-Seek': ['NN'],
  'Power-generation': ['JJ'],
  'Powerful': ['JJ'],
  'Powers': ['NNP'],
  'Powicke': ['NNP'],
  'Powless': ['NNP'],
  'Poxon': ['NNP'],
  'Poyne': ['NNP'],
  'Poyner': ['NNP'],
  'Poynting-Robertson': ['NNP'],
  'Pozen': ['NNP'],
  'Pozzatti': ['NNP'],
  'Pp.': ['NN'],
  'Prab': ['NNP'],
  'Prabang': ['NNP'],
  'Practical': ['JJ'],
  'Practically': ['RB'],
  'Practice': ['NNP'],
  'Practices': ['NNPS'],
  'Prado': ['NNP'],
  'Prager': ['NNP'],
  'Pragmatism': ['NN'],
  'Prague': ['NNP'],
  'Prairie': ['NNP'],
  'Praise': ['NN'],
  'Praisegod': ['NNP'],
  'Praises': ['VBZ'],
  'Pramual': ['NNP'],
  'Prandini': ['NNP'],
  'Prandtl': ['NNP'],
  'Prapas': ['NNP'],
  'Pratap': ['NNP'],
  'Prater': ['NNP'],
  'Pratt': ['NNP'],
  'Prattville': ['NNP'],
  'Pravda': ['NNP'],
  'Praver': ['NNP'],
  'Pravo': ['NNP'],
  'Prawiro': ['NNP'],
  'Praxis': ['NNP'],
  'Pray': ['NNP'],
  'Prayer': ['NNP'],
  'Prayers': ['NNS'],
  'Pre-College': ['NNP'],
  'Pre-Legislative': ['NNP'],
  'Pre-attack': ['JJ'],
  'Pre-decoration': ['NN'],
  'Pre-inaugural': ['JJ'],
  'Pre-refunded': ['JJ'],
  'Pre-shaped': ['JJ'],
  'Pre-trial': ['JJ'],
  'Preamble': ['NN'],
  'Preambles': ['NNS'],
  'Prebon': ['NNP'],
  'Prechter': ['NNP'],
  'Precinct': ['NNP'],
  'Precious': ['NNP'],
  'Precious-metals': ['NNS'],
  'Precise': ['JJ'],
  'Precisely': ['RB'],
  'Precision': ['NNP'],
  'Predictably': ['RB'],
  'Predicting': ['VBG'],
  'Predictions': ['NNS'],
  'Predispositions': ['NNS'],
  'Prednisone': ['NN'],
  'Preface': ['NNP'],
  'Prefecture': ['NNP'],
  'Preferably': ['RB'],
  'Preferences': ['NNP'],
  'Preferred': ['NNP'],
  'Preferred-dividend': ['JJ'],
  'Prego': ['NNP'],
  'Prejudice': ['NNP'],
  'Preliminary': ['JJ'],
  'Prelude': ['NNP'],
  'Preludes': ['NNPS'],
  'Premarin': ['NNP'],
  'Premark': ['NNP'],
  'Premier': ['NNP'],
  'Premiere': ['NNP'],
  'Premise': ['NNP'],
  'Premium': ['NNP'],
  'Premner': ['NNP'],
  'Premont': ['NNP'],
  'Prenatal': ['JJ'],
  'Prence': ['NNP'],
  'Prendergast': ['NNP'],
  'Prentice': ['NNP'],
  'Prentice-Hall': ['NNP'],
  'Prentiss': ['NNP'],
  'Preoccupied': ['VBN'],
  'Preparation': ['NN'],
  'Preparation-Inquirers': ['NNP'],
  'Preparations': ['NNP'],
  'Prepared': ['JJ'],
  'Preparedness': ['NN'],
  'Prepayments': ['NNS'],
  'Prepulsid': ['NN'],
  'Presbyterian': ['NNP'],
  'Presbyterian-St': ['JJ', 'NP'],
  'Presbyterianism': ['NN'],
  'Presbyterians': ['NNPS'],
  'Prescience': ['NNP'],
  'Prescott': ['NNP'],
  'Prescribed': ['VBN'],
  'Prescription': ['NNP'],
  'Prescription-drug': ['NN'],
  'Preseault': ['NNP'],
  'Presence': ['NNP'],
  'Present': ['JJ'],
  'Presentation': ['NN'],
  'Presenting': ['VBG'],
  'Presently': ['RB'],
  'Preservation': ['NNP'],
  'Preserve': ['NNP'],
  'Preserving': ['VBG'],
  'Presidency': ['NNP'],
  'President': ['NNP'],
  'President-elect': ['NNP'],
  'Presidential': ['JJ'],
  'Presidents': ['NNS'],
  'Presiding': ['NNP'],
  'Presidio': ['NNP'],
  'Presley': ['NNP'],
  'Press': ['NNP'],
  'Pressburger': ['NNP'],
  'Presse': ['NNP'],
  'Pressed': ['VBN'],
  'Presser': ['NN'],
  'Pressing': ['VBG'],
  'Pressler': ['NNP'],
  'Pressman': ['NNP'],
  'Pressure': ['NN'],
  'Pressure-happy': ['JJ'],
  'Pressured': ['VBN'],
  'Pressures': ['NNS'],
  'Prestige': ['NN'],
  'Presto': ['FW'],
  'Preston': ['NNP'],
  'Presumably': ['RB'],
  'Presupposed': ['VBN'],
  'Pretax': ['JJ'],
  'Pretend': ['VB'],
  'Pretender': ['NN'],
  'Preti': ['NNP'],
  'Pretl': ['NNP'],
  'Pretoria': ['NNP'],
  'Prettier': ['JJR'],
  'Pretty': ['RB'],
  'Prettyman': ['NNP'],
  'Preussag': ['NNP'],
  'Prevent': ['VB'],
  'Prevented': ['VBN'],
  'Prevention': ['NNP'],
  'Preventive': ['JJ'],
  'Prevents': ['VBZ'],
  'Previewing': ['VBG'],
  'Previous': ['JJ'],
  'Previously': ['RB'],
  'Prevost': ['NNP'],
  'Prevot': ['NNP'],
  'Prexy': ['NNP'],
  'Preyss': ['NNP'],
  'PriMerit': ['NNP'],
  'Priam': ['NNP'],
  'Price': ['NNP'],
  'Price-Fleming': ['NNP'],
  'Price-boosting': ['JJ'],
  'Price-earnings': ['JJ'],
  'Prices': ['NNS'],
  'Pricey': ['JJ'],
  'Pricing': ['NN'],
  'Prick': ['VB'],
  'Prickly': ['JJ'],
  'Pricor': ['NNP'],
  'Priddy': ['NNP'],
  'Pride': ['NNP'],
  'Pride-Starlette': ['NNP'],
  'Pride-Venus': ['NNP'],
  'Prideaux': ['NNP'],
  'Prielipp': ['NNP'],
  'Priem': ['NNP'],
  'Prieska': ['NNP'],
  'Priest': ['NNP'],
  'Priestess': ['NNP'],
  'Prieta': ['NNP'],
  'Prieur': ['NNP'],
  'Primakov': ['NNP'],
  'Primarily': ['RB'],
  'Primark': ['NNP'],
  'Primary': ['JJ'],
  'Primate': ['NNP'],
  'Primaxin': ['NNP'],
  'Prime': ['NNP'],
  'Prime-1': ['JJ'],
  'Prime-2': ['JJ'],
  'Prime-3': ['JJ'],
  'PrimeTime': ['NNP'],
  'Primerica': ['NNP'],
  'Primo': ['NNP'],
  'Prince': ['NNP'],
  'Princes': ['NNPS'],
  'Princess': ['NNP'],
  'Princeton': ['NNP'],
  'Princeton\\\'': ['NNP'],
  'Princeton\\\'/Newport': ['NNP'],
  'Princeton\\\'/Newport-like': ['JJ'],
  'Principal': ['NNP'],
  'Principal-only': ['JJ'],
  'Principals': ['NNS'],
  'Principia': ['NNP'],
  'Principle': ['NN'],
  'Principles': ['NNS'],
  'Pringle': ['NNP'],
  'Prins': ['NNP'],
  'Print': ['VB'],
  'Printed': ['JJ'],
  'Printemps': ['NNP'],
  'Printing': ['NNP'],
  'Printout': ['NNP'],
  'Prior': ['RB'],
  'Priorities': ['NNPS'],
  'Priory': ['NNP'],
  'Pripet': ['NNP'],
  'Prisca': ['NNP'],
  'Priscilla': ['NNP'],
  'Prism': ['NNP'],
  'Prison': ['NNP'],
  'Prisoners': ['NNP'],
  'Pritchett': ['NNP'],
  'Pritikin': ['NNP'],
  'Pritzker': ['NNP'],
  'Pritzkers': ['NNPS'],
  'Privacy': ['NN'],
  'Private': ['JJ'],
  'Private-property': ['NN'],
  'Private-sector': ['JJ'],
  'Privately': ['RB'],
  'Privatization': ['NN'],
  'Privatize': ['VB'],
  'Privatizing': ['NN'],
  'Priviet': ['NNP'],
  'Privileged': ['NNP'],
  'Privy': ['NNP'],
  'Prix': ['NNP'],
  'Prize': ['NNP'],
  'Prize-winning': ['JJ'],
  'Prizes': ['NNPS'],
  'Prizm': ['NNP'],
  'Prizms': ['NNPS'],
  'Prizzi': ['NNP'],
  'Pro': ['NNP'],
  'Pro-Am': ['NNP'],
  'Pro-Choice': ['JJ'],
  'Pro-Family': ['NNP'],
  'Pro-Iranian': ['NNP'],
  'Pro-choice': ['JJ'],
  'Pro-forma': ['JJ'],
  'Pro-life': ['JJ'],
  'Pro-rated': ['JJ'],
  'ProBody': ['NNP'],
  'ProCyte': ['NNP'],
  'Probable': ['JJ'],
  'Probably': ['RB'],
  'Probe': ['NNP'],
  'Probes': ['NNPS'],
  'Probhat': ['NNP'],
  'Probing': ['VBG'],
  'Problem': ['NNP'],
  'Problems': ['NNS'],
  'Probus': ['NNP'],
  'Procaine': ['NN'],
  'Procardia': ['NNP'],
  'Procedural': ['JJ'],
  'Procedure': ['NN'],
  'Procedures': ['NNPS'],
  'Proceeding': ['VBG'],
  'Proceedings': ['NNP'],
  'Proceeds': ['NNS'],
  'Procepe': ['NNP'],
  'Process': ['NNP'],
  'Processed': ['NNP'],
  'Processing': ['NNP'],
  'Processors': ['NNPS'],
  'Proclamation': ['NNP'],
  'Procreation': ['NN'],
  'Procter': ['NNP'],
  'Proctor': ['NNP'],
  'Procurement': ['NN'],
  'Prodded': ['VBN'],
  'Prodigall': ['NNP'],
  'Prodigy': ['NNP'],
  'Produce': ['VB'],
  'Producer': ['NN'],
  'Producer-Price': ['NNP'],
  'Producers': ['NNS'],
  'Producing': ['NNP'],
  'Product': ['NNP'],
  'Production': ['NN'],
  'Productions': ['NNPS'],
  'Productivity': ['NN'],
  'Products': ['NNPS'],
  'Proefrock': ['NNP'],
  'Prof': ['NNP'],
  'Prof.': ['NNP'],
  'Professional': ['NNP'],
  'Professionally': ['RB'],
  'Professionals': ['NNP'],
  'Professor': ['NNP'],
  'Professors': ['NNP'],
  'Profile': ['NN'],
  'Profili': ['NNP'],
  'Profit': ['NN'],
  'Profit-taking': ['NN'],
  'Profits': ['NNS'],
  'Profitt': ['NNP'],
  'Program': ['NN'],
  'Program-Trading': ['JJ'],
  'Programming': ['NNP'],
  'Programs': ['NNS'],
  'Progress': ['NN'],
  'Progressive': ['NNP'],
  'Progressivism': ['NNP'],
  'Prohibited': ['NNP'],
  'Prohibition': ['NNP'],
  'Project': ['NNP'],
  'Projected': ['VBN'],
  'Projecting': ['VBG'],
  'Projections': ['NNS'],
  'Projects': ['NNPS'],
  'Prokofieff': ['NNP'],
  'Proler': ['NNP'],
  'Proleukin': ['NNP'],
  'Prolonged': ['VBN'],
  'Prolusion': ['NNP'],
  'Promazine': ['JJ'],
  'Promenade': ['NNP'],
  'Prometheus': ['NNP'],
  'Prometrix': ['NNP'],
  'Prominent': ['JJ'],
  'Promise': ['NNP'],
  'Promised': ['JJ'],
  'Promises': ['VBZ'],
  'Promo': ['NN'],
  'Promoters': ['NNP'],
  'Promotion': ['NNP'],
  'Promotional': ['JJ'],
  'Prompt': ['NNP'],
  'Prompted': ['VBN'],
  'Promptly': ['RB'],
  'Proof': ['NN'],
  'Prop': ['NN'],
  'Prop.': ['NNP'],
  'Propaganda': ['NNP'],
  'Propane': ['NNP'],
  'Proper': ['JJ'],
  'Properly': ['RB'],
  'Properties': ['NNP'],
  'Propertius': ['NNP'],
  'Property': ['NNP'],
  'Property-tax': ['JJ'],
  'Property\\\'': ['JJ'],
  'Prophet': ['NNP'],
  'Proponents': ['NNS'],
  'Proposals': ['NNS'],
  'Proposed': ['VBN'],
  'Proposition': ['NNP'],
  'Propper': ['NNP'],
  'Proprietary': ['NNP'],
  'Proprietorship': ['NNP'],
  'Proprietorships': ['NNP'],
  'Propriety': ['NN'],
  'Propulsion': ['NNP'],
  'Propylaea': ['NNP'],
  'Propylene': ['NN'],
  'Pros': ['NNS'],
  'Prose': ['NNP'],
  'Prosecutor': ['NNP'],
  'Prosecutorial': ['JJ'],
  'Prosecutors': ['NNS'],
  'Proskauer': ['NNP'],
  'Prosopopoeia': ['NNP'],
  'Prospect': ['NNP'],
  'Prospective': ['JJ'],
  'Prospects': ['NNS'],
  'Prosperity': ['NN'],
  'Prosser': ['NNP'],
  'Prostitutes': ['NNS'],
  'Protection': ['NNP'],
  'Protectionism': ['NNP'],
  'Protectionist': ['JJ'],
  'Protective': ['JJ'],
  'Protectorate': ['NNP'],
  'Protege': ['NNP'],
  'Proteins': ['NNPS'],
  'Protestant': ['NNP'],
  'Protestant-dominated': ['JJ'],
  'Protestantism': ['NNP'],
  'Protestants': ['NNPS'],
  'Protesters': ['NNS'],
  'Protesting': ['VBG'],
  'Protests': ['NNS'],
  'Prothro': ['NNP'],
  'Protitch': ['NNP'],
  'Protocol': ['NNP'],
  'Protogeometric': ['JJ'],
  'Protons': ['NNS'],
  'Prototype': ['NN'],
  'Prototypes': ['NNS'],
  'Protracted': ['JJ'],
  'Proudfoot': ['NNP'],
  'Proudhon': ['NNP'],
  'Proust': ['NNP'],
  'Provato': ['NNP'],
  'Provenza': ['NNP'],
  'Proverbs': ['NNS'],
  'Proves': ['VBZ'],
  'Provide': ['VB'],
  'Provided': ['VBN'],
  'Providence': ['NNP'],
  'Provident': ['NNP'],
  'Providing': ['VBG'],
  'Provigo': ['NNP'],
  'Province': ['NNP'],
  'Provinces': ['NNP'],
  'Provincetown': ['NNP'],
  'Provincial': ['NNP'],
  'Provincie': ['NNP'],
  'Proving': ['NNP'],
  'Provision': ['NN'],
  'Provisional': ['NNP'],
  'Provo': ['NNP'],
  'Provost': ['NNP'],
  'Proximate': ['JJ'],
  'Proxmire': ['NNP'],
  'Proxy': ['NN'],
  'Prozac': ['NNP'],
  'Pru-Bache': ['NNP'],
  'Prucker': ['NNP'],
  'Prudence': ['NNP'],
  'Prudent': ['NNP'],
  'Prudential': ['NNP'],
  'Prudential-Bache': ['NNP'],
  'PrudentialBache': ['NNP'],
  'Prudhoe': ['NNP'],
  'Pruett': ['NNP'],
  'Prufrock': ['NNP'],
  'Prussia': ['NNP'],
  'Prussian': ['NNP'],
  'Prussin': ['NNP'],
  'Pryce': ['NNP'],
  'Pryor': ['NNP'],
  'Psalm': ['NNP'],
  'Pseudomonas': ['NNS'],
  'Psithyrus': ['NNP'],
  'Psyche': ['NNP'],
  'Psychiatric': ['NNP'],
  'Psychiatry': ['NNP'],
  'Psychical': ['JJ'],
  'Psychoanalytic': ['NNP'],
  'Psychologically': ['RB'],
  'Psychologists': ['NNS'],
  'Psychology': ['NNP'],
  'Psychotherapist': ['NN'],
  'Psychotherapy': ['NNP'],
  'Psyllium': ['NN'],
  'Pt': ['NNP'],
  'Pt.': ['NN'],
  'Ptachia': ['NNP'],
  'Pte': ['NNP'],
  'Pte.': ['NNP'],
  'Ptolemaic': ['JJ'],
  'Ptolemaists': ['NNS'],
  'Ptolemy': ['NNP'],
  'Pty.': ['NNP'],
  'Pualani': ['NNP'],
  'Public': ['NNP'],
  'Public-health': ['JJ'],
  'Public-spirited': ['JJ'],
  'Public-works': ['NNS'],
  'Publication': ['NN'],
  'Publications': ['NNPS'],
  'Publicis': ['NNP'],
  'Publicity': ['NN'],
  'Publick': ['NNP'],
  'Publicly': ['RB'],
  'Publique': ['NNP'],
  'Published': ['VBN'],
  'Publisher': ['NNP'],
  'Publishers': ['NNPS'],
  'Publishing': ['NNP'],
  'Puccini': ['NNP'],
  'Puccio': ['NNP'],
  'Puche': ['NNP'],
  'Pucik': ['NNP'],
  'Puddingstone': ['NNP'],
  'Pudwell': ['NNP'],
  'Pueblo': ['NNP'],
  'Puente': ['NNP'],
  'Pueri': ['FW'],
  'Puerto': ['NNP'],
  'Puette': ['NNP'],
  'Puffing': ['VBG'],
  'Puget': ['NNP'],
  'Pugh': ['UH'],
  'Puglisi': ['NNP'],
  'Pugo': ['NNP'],
  'Puhl': ['NNP'],
  'Pulaski': ['NNP'],
  'Pulitzer': ['NNP'],
  'Pulkova': ['NNP'],
  'Pull': ['VB'],
  'Pullen': ['NNP'],
  'Pulley': ['NNP'],
  'Pulliam': ['NNP'],
  'Pulling': ['VBG'],
  'Pullings': ['NNP'],
  'Pullman': ['NNP'],
  'Pullmans': ['NNS'],
  'Pullover': ['NNP'],
  'Pulova': ['NNP'],
  'Pulp': ['NNP'],
  'Puma': ['NN'],
  'Pumblechook': ['NNP'],
  'Pummeled': ['VBN'],
  'Pump': ['NNP'],
  'Pumpkin': ['NNP'],
  'Pumwani': ['NNP'],
  'Puna': ['NNP'],
  'Punch': ['VB'],
  'Punching': ['VBG'],
  'Pundits': ['NNS'],
  'Pune': ['NNP'],
  'Punishment': ['NN'],
  'Punitive': ['JJ'],
  'Punjab': ['NNP'],
  'Puny': ['JJ'],
  'Pupil': ['NN'],
  'Pupils': ['NNS'],
  'Puppeteer': ['NN'],
  'Puppies': ['NNS'],
  'Puppy': ['NNP'],
  'Purcell': ['NNP'],
  'Purchase': ['NNP'],
  'Purchases': ['NNS'],
  'Purchasing': ['NNP'],
  'Purdew': ['NNP'],
  'Purdie': ['NNP'],
  'Purdue': ['NNP'],
  'Purdy': ['NNP'],
  'Pure': ['NNP'],
  'Purely': ['RB'],
  'Purepac': ['NNP'],
  'Purgatory': ['NNP'],
  'Purification': ['NN'],
  'Purified': ['VBN'],
  'Purina': ['NNP'],
  'Puritan': ['NNP'],
  'Puritans': ['NNS'],
  'Purkis': ['NNP'],
  'Purloined': ['NNP'],
  'Purnick': ['NNP'],
  'Purple': ['NNP'],
  'Purpose': ['NNP'],
  'Purse': ['NNP'],
  'Pursewarden': ['NNP'],
  'Pursuing': ['VBG'],
  'Pursuit': ['NN'],
  'Purves': ['NNP'],
  'Purvis': ['NNP'],
  'Push': ['NN'],
  'Push-Pull': ['NNP'],
  'Push-ups': ['NNS'],
  'Pushing': ['VBG'],
  'Pushkin': ['NNP'],
  'Pushup': ['NNP'],
  'Put': ['VB'],
  'Putas': ['NNP'],
  'Putka': ['NNP'],
  'Putnam': ['NNP'],
  'Puts': ['VBZ'],
  'Putt': ['NNP'],
  'Puttana': ['NN'],
  'Puttin': ['NNP'],
  'Putting': ['VBG'],
  'Puttnam': ['NNP'],
  'Putty': ['NN'],
  'Putzi': ['NNP'],
  'Puzzled': ['VBN'],
  'Pye': ['NNP'],
  'Pyhrric': ['JJ'],
  'Pyle': ['NNP'],
  'Pymm': ['NNP'],
  'Pyne': ['NNP'],
  'Pyo': ['NNP'],
  'Pyongyang': ['NNP'],
  'Pyramid': ['NNP'],
  'Pyramids': ['NNPS'],
  'Pyrex': ['NNP'],
  'Pyrometer': ['NNP'],
  'Pyrrhic': ['JJ'],
  'Pysllium': ['NN'],
  'Pyszkiewicz': ['NNP'],
  'Pythagoreans': ['NNPS'],
  'Python': ['NNP'],
  'Pyxis': ['NNP'],
  'Pyzhyanov': ['NNP'],
  'Q': ['NN'],
  'Q.': ['NNP'],
  'Q3': ['CD'],
  'Q45': ['NNP'],
  'QB': ['NNP'],
  'QE': ['NNP'],
  'QFC': ['NNP'],
  'QUANTUM': ['NNP'],
  'QUARTER': ['NN'],
  'QUOTABLE': ['JJ'],
  'QVC': ['NNP'],
  'Qantas': ['NNP'],
  'Qatar': ['NNP'],
  'Qing': ['NNP'],
  'Qinghua': ['NNP'],
  'Qintex': ['NNP'],
  'Qintex-MGM\\\'/UA': ['NNP'],
  'Qizhen': ['NNP'],
  'Quack': ['NNP'],
  'Quackenbush': ['NNP'],
  'Quacks': ['NNS'],
  'Quad': ['NNP'],
  'Quadra': ['NNP'],
  'Quadrant': ['NNP'],
  'Quadrex': ['NNP'],
  'Quadrille': ['NNP'],
  'Quadrum': ['NNP'],
  'Quaid': ['NNP'],
  'Quake': ['NN'],
  'Quaker': ['NNP'],
  'Quakeress': ['NN'],
  'Quakers': ['NNS'],
  'Qualitative': ['JJ'],
  'Qualities': ['NNPS'],
  'Quality': ['NN'],
  'Qualls': ['NNP'],
  'Quant': ['NN'],
  'Quantum': ['NNP'],
  'Quarry': ['NNP'],
  'Quarter': ['NN'],
  'Quarterback': ['NNP'],
  'Quarterly': ['JJ'],
  'Quartermaster': ['NNP'],
  'Quartet': ['NNP'],
  'Quasimodo': ['NNP'],
  'Quatre': ['NNP'],
  'Quatsch': ['FW'],
  'Quattlebaum': ['NNP'],
  'Quattro': ['NNP'],
  'Quattro.': ['NNP'],
  'Quayle': ['NNP'],
  'Quebec': ['NNP'],
  'Quebecers': ['NNPS'],
  'Quebeckers': ['NNPS'],
  'Quebecois': ['NNP'],
  'Quebecor': ['NNP'],
  'Quebequois': ['NNP'],
  'Queen': ['NNP'],
  'Queenan': ['NNP'],
  'Queens': ['NNP'],
  'Queensland': ['NNP'],
  'Quek': ['NNP'],
  'Queks': ['NNPS'],
  'Quelch': ['NNP'],
  'Quell': ['NNP'],
  'Quelle': ['NNP'],
  'Quemoy': ['NNP'],
  'Quennell': ['NNP'],
  'Quentin': ['NNP'],
  'Querecho': ['NNP'],
  'Queried': ['VBN'],
  'QuesTech': ['NNP'],
  'Quesada': ['NNP'],
  'Quesadas': ['NNPS'],
  'Quest': ['NNP'],
  'Question': ['NN'],
  'Questioned': ['VBN'],
  'Questions': ['NNS'],
  'Quezon': ['NNP'],
  'Qui': ['FW'],
  'Quick': ['NNP'],
  'Quick-Wate': ['NNP'],
  'Quickening': ['VBG'],
  'Quicker': ['JJR'],
  'Quickly': ['RB'],
  'Quickview': ['NNP'],
  'Quiet': ['JJ'],
  'Quieter': ['JJR'],
  'Quietism': ['NNP'],
  'Quietist': ['NNP'],
  'Quietly': ['RB'],
  'Quigley': ['NNP'],
  'Quiksilver': ['NNP'],
  'Quill': ['NNP'],
  'Quill\\\'/William': ['NNP'],
  'Quilt': ['NNP'],
  'Quilted': ['NNP'],
  'Quina': ['NNP'],
  'Quince': ['NN'],
  'Quincy': ['NNP'],
  'Quindlen': ['NNP'],
  'Quiney': ['NNP'],
  'Quinlan': ['NNP'],
  'Quinn': ['NNP'],
  'Quint': ['NNP'],
  'Quinta': ['NNP'],
  'Quintana': ['NNP'],
  'Quintet': ['NNP'],
  'Quinton': ['NNP'],
  'Quintus': ['NNP'],
  'Quinzaine': ['NNP'],
  'Quips': ['VBZ'],
  'Quirinal': ['NNP'],
  'Quist': ['NNP'],
  'Quit': ['VB'],
  'Quite': ['RB'],
  'Quitslund': ['NNP'],
  'Quivar': ['NNP'],
  'Quixote': ['NNP'],
  'Quizzical': ['NNP'],
  'Quod': ['FW'],
  'Quota': ['NNP'],
  'Quotable': ['NNP'],
  'Quotas': ['NNS'],
  'Quotation': ['NNP'],
  'Quotations': ['NNPS'],
  'Quote': ['NN'],
  'Quotidien': ['NNP'],
  'Quoting': ['VBG'],
  'Quotron': ['NNP'],
  'Quotrons': ['NNPS'],
  'Qureshey': ['NNP'],
  'Quyne': ['NNP'],
  'Quyney': ['NN'],
  'R': ['NN'],
  'R&D': ['NN'],
  'R&M': ['NNP'],
  'R\'s': ['NNS'],
  'R-5th': ['JJ'],
  'R-6th': ['NNP'],
  'R-Bergen': ['NNP'],
  'R-Cape': ['NNP'],
  'R-Warren': ['NNP'],
  'R-shaped': ['JJ'],
  'R-stage': ['JJ'],
  'R.': ['NNP'],
  'R.,Iowa': ['NNP'],
  'R.,Vitro': ['NNP'],
  'R.A.F.': ['NNP'],
  'R.B.': ['NNP'],
  'R.C.': ['NNP'],
  'R.D.': ['NNP'],
  'R.E.': ['NNP'],
  'R.F.': ['NNP'],
  'R.G.': ['NNP'],
  'R.H.': ['NNP'],
  'R.I': ['NNP'],
  'R.I.': ['NNP'],
  'R.I.-based': ['JJ'],
  'R.J.': ['NNP'],
  'R.L.': ['NNP'],
  'R.N.': ['NNP'],
  'R.P.': ['NNP'],
  'R.R.': ['NNP'],
  'R.S.': ['NNP'],
  'R.T.': ['NNP'],
  'R.V.': ['NNP'],
  'R.W.': ['NNP'],
  'R/NNP.A.': ['NN'],
  'R/NNP.C/NNP.A.': ['NN'],
  'R/NNP.H.S.': ['NNP'],
  'R/NNP.I.': ['NN'],
  'R2-D2': ['NN'],
  'RA': ['NNP'],
  'RAAF': ['NNP'],
  'RACIST': ['JJ'],
  'RACKS': ['NNS'],
  'RADIO': ['NN'],
  'RAF': ['NNP'],
  'RAISED': ['VBD'],
  'RALLIED': ['VBD'],
  'RAND': ['NNP'],
  'RANDELL': ['NNP'],
  'RANSOM': ['NNP'],
  'RATE': ['NN'],
  'RATES': ['NNS'],
  'RATIOS': ['NNS'],
  'RATTLED': ['VBD'],
  'RAVAGES': ['NNS'],
  'RAX': ['NNP'],
  'RAYCHEM': ['NNP'],
  'RB&H': ['NNP'],
  'RBC': ['NNP'],
  'RBS': ['NNP'],
  'RBSPr': ['NNP'],
  'RC6280': ['NN'],
  'RCA': ['NNP'],
  'RCA-Victor': ['NNP'],
  'RCA\\\'/Ariola': ['NNP'],
  'RCSB': ['NNP'],
  'RD': ['NNP'],
  'RDF': ['NNP'],
  'RDW': ['NN'],
  'RDWS': ['NN'],
  'RE-ENTRY': ['NNP'],
  'REACHED': ['NNP'],
  'REACTOR': ['NN'],
  'READY': ['NNP'],
  'REAGAN': ['NNP'],
  'REAL': ['JJ'],
  'REAL-ESTATE': ['JJ'],
  'REALLY': ['NNP'],
  'REALTY': ['NNP'],
  'REAP': ['VBP'],
  'REBUFF': ['NN'],
  'RECEIVED': ['VBD'],
  'RECENT': ['JJ'],
  'RECORD': ['NNP'],
  'RECORDS': ['NNS'],
  'RECRUITING': ['NN'],
  'RECRUITS': ['VBZ'],
  'REFLECTIONS': ['NNP'],
  'REFUSED': ['VBD'],
  'REGULATIONS': ['NNS'],
  'REIGNS': ['VBZ'],
  'REINSURERS': ['NNS'],
  'REIS': ['NNP'],
  'REIT': ['NNP'],
  'REITs': ['NNS'],
  'REJECTED': ['VBN'],
  'REJECTS': ['VBZ'],
  'RELEASE': ['NN'],
  'REMEMBER': ['VB'],
  'REMIC': ['NNP'],
  'REMICs': ['NNS'],
  'REN': ['NNP'],
  'RENAISSANCE': ['NNP'],
  'RENT-A-CAR': ['NNP'],
  'REPAIR': ['NN'],
  'REPLICATION': ['NN'],
  'REPLIGEN': ['NNP'],
  'REPORTED': ['VBN'],
  'REPORTS': ['NNS'],
  'REQUESTS': ['NNS'],
  'REQUIRED': ['NNP'],
  'RESEARCH': ['NNP'],
  'RESEARCHERS': ['NNS'],
  'RESIDENTIAL': ['NNP'],
  'RESIGNATIONS': ['NNS'],
  'RESIGNED': ['VBD'],
  'RESOURCES': ['NNP'],
  'RETIREMENT': ['NNP'],
  'RETREAT': ['NN'],
  'REVENUE': ['NN'],
  'REVIEW': ['NNP'],
  'REVISED': ['VBN'],
  'RF-082': ['NN'],
  'RFM': ['NNP'],
  'RIAA': ['NNP'],
  'RICHARD': ['NNP'],
  'RICHMOND': ['NNP'],
  'RICO': ['NNP'],
  'RICO-forfeiture': ['JJ'],
  'RICOed': ['JJ'],
  'RICOing': ['NN'],
  'RID': ['VB'],
  'RIGHTS': ['NNS'],
  'RIP': ['UH'],
  'RISC': ['NNP'],
  'RISC-based': ['JJ'],
  'RISE': ['NN'],
  'RISK': ['NN'],
  'RIT': ['NNP'],
  'RIVALRIES': ['NNS'],
  'RIVER': ['NNP'],
  'RJR': ['NNP'],
  'RJR-Macdonald': ['NNP'],
  'RJR-style': ['JJ'],
  'RLLY': ['NNP'],
  'RMC': ['NNP'],
  'RMI': ['NNP'],
  'RMS': ['NNP'],
  'RMd': ['NN'],
  'RNA': ['NNP'],
  'RNA-based': ['JJ'],
  'RNAs': ['NNS'],
  'ROARED': ['VBD'],
  'ROBERT': ['NNP'],
  'RODE': ['VBD'],
  'ROFLMAO': ['UH'],
  'ROGERS': ['NNP'],
  'ROK': ['NNP'],
  'ROME': ['NNP'],
  'ROOM': ['NN'],
  'ROOSEVELT\'S': ['NNP'],
  'ROSS': ['NNP'],
  'ROSTY\'S': ['NNP'],
  'ROTC': ['NNP'],
  'ROUGH': ['JJ'],
  'ROUND': ['NN'],
  'ROY': ['NNP'],
  'RPM': ['NNP'],
  'RTC': ['NNP'],
  'RTC-appointed': ['JJ'],
  'RTC-owned': ['JJ'],
  'RTRSY': ['NNP'],
  'RTS': ['NNP'],
  'RTZ': ['NNP'],
  'RU': ['NNP'],
  'RU-486': ['NNP'],
  'RULE': ['VBP'],
  'RULERS': ['NNS'],
  'RULES': ['NNS'],
  'RULING': ['NN'],
  'RUN': ['NNP'],
  'RUSH': ['NN'],
  'RUSSIANS': ['NNS'],
  'RV': ['NN'],
  'RVs': ['NNS'],
  'RXDC': ['NNP'],
  'Rabat': ['NNP'],
  'Rabaul': ['NNP'],
  'Rabb': ['NNP'],
  'Rabbi': ['NNP'],
  'Rabbits': ['NNS'],
  'Rabble-rousing': ['JJ'],
  'Rabia': ['NNP'],
  'Rabies': ['NN'],
  'Rabin': ['NNP'],
  'Rabinowiczes': ['NNPS'],
  'Rabinowitz': ['NNP'],
  'Rabkin': ['NNP'],
  'Raboy': ['NNP'],
  'Racal': ['NNP'],
  'Raccoon': ['NNP'],
  'Raccoons': ['NNS'],
  'Race': ['NNP'],
  'Race-drivers': ['NNS'],
  'Raceway': ['NNP'],
  'Rachael': ['NNP'],
  'Rachel': ['NNP'],
  'Rachelle': ['NNP'],
  'Rachmaninoff': ['NNP'],
  'Rachwalski': ['NNP'],
  'Racial': ['JJ'],
  'Racie': ['NNP'],
  'Racin': ['NNP'],
  'Racine': ['NNP'],
  'Racing': ['NNP'],
  'Racism': ['NN'],
  'Racketeer': ['NNP'],
  'Racketeering': ['NNP'],
  'Rackmil': ['NNP'],
  'Racks': ['VBZ'],
  'Racquet': ['NNP'],
  'Radames': ['NNP'],
  'Radar': ['NNP'],
  'Radarange': ['NN'],
  'Radcliffe': ['NNP'],
  'Rademacher': ['NNP'],
  'Radetzky': ['NNP'],
  'Radha': ['NNP'],
  'Radhakrishnan': ['NNP'],
  'Radiant': ['JJ'],
  'Radiation': ['NN'],
  'Radic': ['NNP'],
  'Radical': ['NNP'],
  'Radio': ['NNP'],
  'Radio-Television': ['NNP'],
  'Radio-television': ['NN'],
  'Radio-transmitter': ['NN'],
  'Radioing': ['VBG'],
  'Radiopasteurization': ['NN'],
  'Radiosterilization': ['NN'],
  'Radius': ['NNP'],
  'Radnor': ['NNP'],
  'Radzymin': ['NNP'],
  'Rae': ['NNP'],
  'Raeder': ['NNP'],
  'Raesz': ['NNP'],
  'Raether': ['NNP'],
  'Rafael': ['NNP'],
  'Rafale': ['NNP'],
  'Rafales': ['NNPS'],
  'Rafeedie': ['NNP'],
  'Rafer': ['NNP'],
  'Raffaello': ['NNP'],
  'Rafferty': ['NNP'],
  'Rafi': ['NNP'],
  'Rafsanjani': ['NNP'],
  'Raft': ['NN'],
  'Rafter': ['NNP'],
  'Raful': ['NNP'],
  'Rag': ['NNP'],
  'Ragalyi': ['NNP'],
  'Ragan': ['NNP'],
  'Ragavan': ['NNP'],
  'Rage': ['NN'],
  'Ragged': ['JJ'],
  'Raghavan': ['NNP'],
  'Raghib': ['NNP'],
  'Ragnar': ['NNP'],
  'Ragsdale': ['NNP'],
  'Ragu': ['NNP'],
  'Raheem': ['NNP'],
  'Rahill': ['NNP'],
  'Rahman': ['NNP'],
  'Rahn': ['NNP'],
  'Rahway': ['NNP'],
  'Raich': ['NNP'],
  'Raider': ['NNP'],
  'Raiders': ['NNPS'],
  'Raiff': ['NNP'],
  'Raikes': ['NNP'],
  'Raikin': ['NNP'],
  'Rail': ['NNP'],
  'Rail-transit': ['NN'],
  'Railbikers': ['NNS'],
  'Railbikes': ['NNS'],
  'Railcar': ['NNP'],
  'Railroad': ['NNP'],
  'Railroad-rate': ['JJ'],
  'Railroads': ['NNPS'],
  'Rails': ['NNPS'],
  'Railway': ['NNP'],
  'Raimer': ['NNP'],
  'Raimondo': ['NNP'],
  'Raimu': ['NNP'],
  'Rain': ['NNP'],
  'Rainbow': ['NNP'],
  'Raine': ['NNP'],
  'Rainer': ['NNP'],
  'Raines': ['NNP'],
  'Rainey': ['NNP'],
  'Rainier': ['NNP'],
  'Rainman': ['NNP'],
  'Rainwater': ['NNP'],
  'Rainy': ['NNP'],
  'Raisa': ['NNP'],
  'Raise': ['VB'],
  'Raised': ['VBN'],
  'Raising': ['VBG'],
  'Raitt': ['NNP'],
  'Raj': ['NNP'],
  'Rajiv': ['NNP'],
  'Rajter': ['NNP'],
  'Rak': ['NNP'],
  'Rake': ['NN'],
  'Rakestraw': ['NNP'],
  'Raleigh': ['NNP'],
  'Rales': ['NNP'],
  'Rall': ['NNP'],
  'Rally': ['NNP'],
  'Ralph': ['NNP'],
  'Ralphs': ['NNP'],
  'Ralston': ['NNP'],
  'Ralston-Purina': ['NNP'],
  'Ram': ['NNP'],
  'Rama': ['NNP'],
  'Ramada': ['NNP'],
  'Ramathan': ['NNP'],
  'Ramble': ['NNP'],
  'Rambo': ['NNP'],
  'Ramcharger': ['NNP'],
  'Rameau': ['NNP'],
  'Ramesh': ['NNP'],
  'Ramey': ['NNP'],
  'Ramfis': ['NNP'],
  'Ramillies': ['NNP'],
  'Ramirez': ['NNP'],
  'Rammin': ['VBG'],
  'Ramo': ['NNP'],
  'Ramon': ['NNP'],
  'Ramona': ['NNP'],
  'Ramone': ['NNP'],
  'Ramos': ['NNP'],
  'Ramparts': ['NNS'],
  'Rampell': ['NNP'],
  'Ramseier': ['NNP'],
  'Ramsey': ['NNP'],
  'Ramsperger': ['NNP'],
  'Ramtron': ['NNP'],
  'Ran': ['VBD'],
  'Ranavan': ['NNP'],
  'Ranch': ['NNP'],
  'Rancher': ['NNP'],
  'Rancho': ['NNP'],
  'Rand': ['NNP'],
  'Randall': ['NNP'],
  'Rande': ['NNP'],
  'Randell': ['NNP'],
  'Randi': ['NNP'],
  'Randol': ['NNP'],
  'Randolph': ['NNP'],
  'Random': ['NNP'],
  'Randy': ['NNP'],
  'Range': ['NN'],
  'Rangel': ['NNP'],
  'Ranger': ['NNP'],
  'Rangers': ['NNPS'],
  'Ranging': ['VBG'],
  'Rangoni': ['NNP'],
  'Rangoon': ['NNP'],
  'Rangoon-Bangkok': ['NNP'],
  'Ranieri': ['NNP'],
  'Rank': ['NNP'],
  'Ranke': ['NNP'],
  'Ranked': ['VBN'],
  'Rankin': ['NNP'],
  'Ranking': ['NN'],
  'Rankings': ['NNS'],
  'Ranks': ['NNP'],
  'Ranney': ['NNP'],
  'Ransom': ['NNP'],
  'Ransomes': ['NNP'],
  'Ransy': ['NNP'],
  'Ranyard': ['NNP'],
  'Ranzer': ['NNP'],
  'Raos': ['NNP'],
  'Raoul': ['NNPS'],
  'Raoul-Duval': ['NNP'],
  'Rap': ['NN'],
  'Rapanelli': ['NNP'],
  'Rapatee': ['NNP'],
  'Rape': ['NNP'],
  'Raphael': ['NNP'],
  'Raphaels': ['NNS'],
  'Rapid': ['NNP'],
  'Rapids': ['NNP'],
  'Rapier': ['NN'],
  'Rapoport': ['NNP'],
  'Rapp': ['NNP'],
  'Rapping': ['VBG'],
  'Rapport': ['NNP'],
  'Raptopoulos': ['NNP'],
  'Rapture': ['NN'],
  'Rapunzel': ['NNP'],
  'Rare': ['JJ'],
  'Rarely': ['RB'],
  'Rarer': ['JJR'],
  'Rascal': ['NN'],
  'Rash': ['NNP'],
  'Rashid': ['NNP'],
  'Rashomon': ['NNP'],
  'Raskolnikov': ['NNP'],
  'Raspberry': ['NN'],
  'Rastus': ['NNP'],
  'Rat': ['NNP'],
  'Rat-face': ['NN'],
  'Ratajczak': ['NNP'],
  'Ratcliff': ['NNP'],
  'Ratcliffe': ['NNP'],
  'Rate': ['NNP'],
  'Rated': ['VBN'],
  'Rates': ['NNS'],
  'Rath': ['NNP'],
  'Rathbone': ['NNP'],
  'Rathbones': ['NNPS'],
  'Rather': ['RB'],
  'Ratican': ['NNP'],
  'Ratified': ['VBN'],
  'Rating': ['NNP'],
  'Ratings': ['NNS'],
  'Rational': ['NNP'],
  'Ratliff': ['NNP'],
  'Ratner': ['NNP'],
  'Ratners': ['NNP'],
  'Raton': ['NNP'],
  'Rats': ['NNP'],
  'Rattigan': ['NNP'],
  'Rattner': ['NNP'],
  'Ratto': ['NNP'],
  'Rattzhenfuut': ['NNP'],
  'Rauch': ['NNP'],
  'Raucher': ['NNP'],
  'Rauh': ['NNP'],
  'Raul': ['NNP'],
  'Rausch': ['NNP'],
  'Rauschenberg': ['NNP'],
  'Rauschenbusch': ['NNP'],
  'Rauscher': ['NNP'],
  'Ravel-like': ['JJ'],
  'Ravencroft': ['NNP'],
  'Ravenscroft': ['NNP'],
  'Ravenspurn': ['NNP'],
  'Ravenswood': ['NNP'],
  'Ravich': ['NNP'],
  'Ravine': ['NNP'],
  'Ravitch': ['NNP'],
  'Ravitz': ['NNP'],
  'Raw': ['JJ'],
  'Raw-steel': ['NN'],
  'Rawl': ['NNP'],
  'Rawleigh': ['NNP'],
  'Rawlings': ['NNP'],
  'Rawlins': ['NNP'],
  'Rawls': ['NNP'],
  'Rawson': ['NNP'],
  'Rax': ['NNP'],
  'Ray': ['NNP'],
  'Rayburn': ['NNP'],
  'Rayburn-Johnson': ['NNP'],
  'Raydiola': ['NNP'],
  'Rayfield': ['NNP'],
  'Rayle': ['NNP'],
  'Raymon': ['NNP'],
  'Raymond': ['NNP'],
  'Raymonda': ['NNP'],
  'Raymondville': ['NNP'],
  'Raymont': ['NNP'],
  'Raynal': ['NNP'],
  'Rayon': ['NNP'],
  'Raytheon': ['NNP'],
  'Razors': ['NNS'],
  'Rd.': ['NNP'],
  'Re': ['NNP'],
  'Re-Birth': ['NNP'],
  'Re-creating': ['VBG'],
  'Re-enactments': ['NNS'],
  'Reach': ['NNP'],
  'Reached': ['VBN'],
  'Reaching': ['VBG'],
  'Reacting': ['VBG'],
  'Reaction': ['NN'],
  'Reactionaries': ['NNS'],
  'Reactionary': ['JJ'],
  'Reactions': ['NNS'],
  'Reactors': ['NNP'],
  'Read': ['NNP'],
  'Reader': ['NNP'],
  'Readerman': ['NNP'],
  'Readers': ['NNS'],
  'Readily': ['RB'],
  'Readiness': ['NN'],
  'Reading': ['NNP'],
  'Readings': ['NNS'],
  'Ready': ['JJ'],
  'Reaffirming': ['VBG'],
  'Reagan': ['NNP'],
  'Reagan-Bush': ['JJ'],
  'Reagan-Republican': ['JJ'],
  'Reagan-era': ['NN'],
  'Reagan-like': ['JJ'],
  'Reaganauts': ['NNS'],
  'Reaganite': ['JJ'],
  'Reaganites': ['NNPS'],
  'Reaganomics': ['NNP'],
  'Real': ['JJ'],
  'Real-estate': ['NN'],
  'Realism': ['NNP'],
  'Realist': ['NNP'],
  'Reality': ['NN'],
  'Really': ['RB'],
  'Realtor': ['NN'],
  'Realtors': ['NNS'],
  'Realty': ['NNP'],
  'Reama': ['NNP'],
  'Reames': ['NNP'],
  'Rear': ['JJ'],
  'Rearding': ['VBG'],
  'Reared': ['VBN'],
  'Reason': ['NNP'],
  'Reasonable': ['JJ'],
  'Reasoner': ['NNP'],
  'Reasoning': ['NN'],
  'Reasons': ['NNS'],
  'Reavey': ['NNP'],
  'Reavis': ['NNP'],
  'Reb': ['NN'],
  'Rebaja': ['NNP'],
  'Rebates': ['NNS'],
  'Rebecca': ['NNP'],
  'Rebel': ['NN'],
  'Rebellion': ['NN'],
  'Rebels': ['NNS'],
  'Reber': ['NNP'],
  'Rebounding': ['VBG'],
  'Rebs': ['NNS'],
  'Rebuilding': ['VBG'],
  'Recall': ['VB'],
  'Recalls': ['VBZ'],
  'Recapitulation': ['NNP'],
  'Receave': ['VBP'],
  'Receipts': ['NNPS'],
  'Receivables': ['NNPS'],
  'Receiving': ['VBG'],
  'Recent': ['JJ'],
  'Recently': ['RB'],
  'Receptech': ['NNP'],
  'Reception': ['NN'],
  'Recess': ['NN'],
  'Recession': ['NN'],
  'Recessions': ['NNS'],
  'Recherche': ['NNP'],
  'Recherches': ['FW'],
  'Reciprocal': ['NNP'],
  'Recital': ['NNP'],
  'Reckitt': ['NNP'],
  'Recklessly': ['RB'],
  'Reckon': ['VB'],
  'Reclamation': ['NNP'],
  'Recognition': ['NNP'],
  'Recognize': ['VB'],
  'Recognizing': ['VBG'],
  'Recommendations': ['NNS'],
  'Reconciliation': ['NNP'],
  'Reconsider': ['VB'],
  'Reconsideration': ['NN'],
  'Reconstruction': ['NNP'],
  'Record': ['NNP'],
  'Recording': ['NNP'],
  'Recordings': ['NNP'],
  'Records': ['NNPS'],
  'Records\\\'/SONY': ['NNP'],
  'Recounting': ['VBG'],
  'Recoup': ['VB'],
  'Recovering': ['VBG'],
  'Recovery': ['NNP'],
  'Recreation': ['NNP'],
  'Recruit': ['NNP'],
  'Recruited': ['VBN'],
  'Recruiter': ['NNP'],
  'Rectangular': ['JJ'],
  'Rectifier': ['NNP'],
  'Rector': ['NNP'],
  'Rectum': ['NN'],
  'Recurring': ['VBG'],
  'Recyclers': ['NNPS'],
  'Recycling': ['NNP'],
  'Red': ['NNP'],
  'Red-Green': ['NNP'],
  'Red-Greens': ['NNPS'],
  'Red-blooded': ['JJ'],
  'Red-prone': ['JJ'],
  'Reda': ['NNP'],
  'Redbirds': ['NNP'],
  'Redbook': ['NNP'],
  'Redding': ['NNP'],
  'Reddington': ['NNP'],
  'Rede': ['NNP'],
  'Redeemable': ['NNP'],
  'Redeemer': ['NNP'],
  'Rederi': ['NNP'],
  'Redesign': ['NN'],
  'Redevelopment': ['NNP'],
  'Redfield': ['NNP'],
  'Redford': ['NNP'],
  'Redgrave': ['NNP'],
  'Redhook': ['NNP'],
  'Reding': ['NN'],
  'Redland': ['NNP'],
  'Redmond': ['NNP'],
  'Redondo': ['NNP'],
  'Redoute': ['NNP'],
  'Reds': ['NNPS'],
  'Redskins': ['NNPS'],
  'Redstone': ['NNP'],
  'Reduce': ['VB'],
  'Reduced': ['NNP'],
  'Reduces': ['VBZ'],
  'Reducing': ['VBG'],
  'Reduction': ['NNP'],
  'Reductions': ['NNS'],
  'Redundant': ['NNP'],
  'Redwood': ['NNP'],
  'Reebok': ['NNP'],
  'Reeboks': ['NNPS'],
  'Reed': ['NNP'],
  'Reeder': ['NNP'],
  'Reedville': ['NNP'],
  'Reedy': ['NNP'],
  'Reef': ['NNP'],
  'Reefs': ['NNS'],
  'Reels': ['NNPS'],
  'Reenact': ['VB'],
  'Rees': ['NNPS'],
  'Reese': ['NNP'],
  'Reeve': ['NNP'],
  'Reeves': ['NNP'],
  'Reeves-type': ['JJ'],
  'Ref.': ['NN'],
  'Refco': ['NNP'],
  'Refcorp': ['NNP'],
  'Refcorps': ['NNS'],
  'Reference': ['NNP'],
  'References': ['NNS'],
  'Referrals': ['NNS'],
  'Referring': ['VBG'],
  'Refill': ['VB'],
  'Refinancing': ['NN'],
  'Refined': ['NNP'],
  'Refinements': ['NNS'],
  'Refiners': ['NNS'],
  'Refinery': ['NN'],
  'Refining': ['NNP'],
  'Reflecting': ['VBG'],
  'Reflections': ['NNP'],
  'Reflects': ['VBZ'],
  'Reflex': ['NN'],
  'Reform': ['NNP'],
  'Reformation': ['NNP'],
  'Reformed': ['NNP'],
  'Reforms': ['NNS'],
  'Refractories': ['NNPS'],
  'Refrigeration': ['NN'],
  'Refsnes': ['NNP'],
  'Refsum': ['NNP'],
  'Refuge': ['NNP'],
  'Refugee': ['NNP'],
  'Refugees': ['NNS'],
  'Refund': ['NN'],
  'Refunds': ['NNS'],
  'Refuses': ['VBZ'],
  'Reg': ['NNP'],
  'Regaard': ['NNP'],
  'Regains': ['VBZ'],
  'Regal': ['NNP'],
  'Regalia': ['NNP'],
  'Regan': ['NNP'],
  'Regarded': ['VBN'],
  'Regarding': ['VBG'],
  'Regardless': ['RB'],
  'Regatta': ['NNP'],
  'Regency': ['NNP'],
  'Regent': ['NNP'],
  'Reggie': ['NNP'],
  'Regie': ['NNP'],
  'Regime': ['NNP'],
  'Regiment': ['NNP'],
  'Regina': ['NNP'],
  'Reginald': ['NNP'],
  'Regine': ['NNP'],
  'Region': ['NNP'],
  'Regional': ['NNP'],
  'Regionalism': ['NNP'],
  'Regionally': ['RB'],
  'Regions': ['NNS'],
  'Regis': ['NNP'],
  'Register': ['NNP'],
  'Registered': ['VBN'],
  'Registration': ['NN'],
  'Registrations': ['NNS'],
  'Registry': ['NNP'],
  'Regius': ['NNP'],
  'Regnery': ['NNP'],
  'Rego': ['NNP'],
  'Regret': ['NN'],
  'Regretfully': ['RB'],
  'Regrets': ['VBZ'],
  'Regrettably': ['RB'],
  'Regular': ['NNP'],
  'Regulars': ['NNS'],
  'Regulation': ['NN'],
  'Regulations': ['NNS'],
  'Regulative': ['JJ'],
  'Regulator': ['NNP'],
  'Regulators': ['NNS'],
  'Regulatory': ['NNP'],
  'Regulus': ['NN'],
  'Rehabilitation': ['NNP'],
  'Rehfeld': ['NNP'],
  'Rehnquist': ['NNP'],
  'Reich': ['NNP'],
  'Reichenberg': ['NNP'],
  'Reichhart': ['NNP'],
  'Reichhold': ['NNP'],
  'Reichmann': ['NNP'],
  'Reichmann-controlled': ['JJ'],
  'Reichmanns': ['NNPS'],
  'Reichstag': ['NNP'],
  'Reid': ['NNP'],
  'Reider': ['NNP'],
  'Reidy': ['NNP'],
  'Reifenrath': ['NNP'],
  'Reik': ['NNP'],
  'Reilly': ['NNP'],
  'Reily': ['NNP'],
  'Reimbursement': ['NN'],
  'Rein': ['NNP'],
  'Reina': ['NNP'],
  'Reinaldo': ['NNP'],
  'Reine': ['NNP'],
  'Reinforced': ['NNP'],
  'Reinforcements': ['NNS'],
  'Reinforcing': ['VBG'],
  'Reinhard': ['NNP'],
  'Reinhardt': ['NNP'],
  'Reinhold': ['NNP'],
  'Reinisch': ['NNP'],
  'Reinker': ['NNP'],
  'Reins': ['NNP'],
  'Reinstatement': ['NN'],
  'Reinsurance': ['NNP'],
  'Reintroducing': ['VBG'],
  'Reinvestment': ['NNP'],
  'Reis': ['NNP'],
  'Reiser': ['NNP'],
  'Reisert': ['NNP'],
  'Reiss': ['NNP'],
  'Reitman': ['NNP'],
  'Rejection': ['NN'],
  'Rejoins': ['VBZ'],
  'Rekindled': ['VBN'],
  'Related': ['NNP'],
  'Relating': ['VBG'],
  'Relation': ['NN'],
  'Relational': ['NNP'],
  'Relations': ['NNPS'],
  'Relationship': ['NNP'],
  'Relationships': ['NNPS'],
  'Relative': ['JJ'],
  'Relatively': ['RB'],
  'Relatives': ['NNS'],
  'Relativism': ['NN'],
  'Relax': ['VB'],
  'Release': ['NNP'],
  'Relentless': ['JJ'],
  'Relentlessly': ['RB'],
  'Relevant': ['JJ'],
  'Reliability': ['NN'],
  'Reliable': ['NNP'],
  'Reliance': ['NNP'],
  'Relief': ['NNP'],
  'Relieved': ['JJ'],
  'Religion': ['NN'],
  'Religione': ['NNP'],
  'Religious': ['JJ'],
  'Relishes': ['NNS'],
  'Relocation': ['NNP'],
  'Reluctant': ['JJ'],
  'Relying': ['VBG'],
  'Remain': ['VB'],
  'Remaining': ['VBG'],
  'Remains': ['NNS'],
  'Remaking': ['VBG'],
  'Remarketers': ['NNS'],
  'Remarks': ['NNS'],
  'Remarque': ['NNP'],
  'Rembrandt': ['NNP'],
  'Remember': ['VB'],
  'Remembering': ['VBG'],
  'Remembrance': ['NN'],
  'Remic': ['NNP'],
  'Remic-related': ['JJ'],
  'Remics': ['NNS'],
  'Remington': ['NNP'],
  'Remingtons': ['NNPS'],
  'Removal': ['NNP'],
  'Remove': ['VB'],
  'Removed': ['VBN'],
  'Remphan': ['NNP'],
  'Rempsberger': ['NNP'],
  'Remus': ['NNP'],
  'Remy': ['NNP'],
  'Renaissance': ['NNP'],
  'Renaissance-style': ['JJ'],
  'Renata': ['NNP'],
  'Renault': ['NNP'],
  'Renaults': ['NNPS'],
  'Rence': ['NNP'],
  'Renchard': ['NNP'],
  'Renck': ['NNP'],
  'Rendell': ['NNP'],
  'Rendering': ['VBG'],
  'Rene': ['NNP'],
  'Renee': ['NNP'],
  'Renewal': ['NNP'],
  'Renewed': ['VBN'],
  'Renfrew': ['NNP'],
  'Renfro': ['NNP'],
  'Renk': ['NNP'],
  'Rennell': ['NNP'],
  'Rennie': ['NNP'],
  'Reno': ['NNP'],
  'Reno-Lake': ['NNP', 'NP'],
  'Renoir': ['NNP'],
  'Renoirs': ['NNPS'],
  'Renovo': ['NNP'],
  'Renowned': ['VBN'],
  'Renshaw': ['NNP'],
  'Rensselaer': ['NNP'],
  'Rensselaerwyck': ['NNP'],
  'Rent': ['NNP'],
  'Rent-A-Car': ['NNP'],
  'Rent-A-Lease': ['NNP'],
  'Renta': ['NNP'],
  'Rental': ['NNP'],
  'Renton': ['NNP'],
  'Rents': ['NNS'],
  'Renville': ['NNP'],
  'Renwick': ['NNP'],
  'Renzas': ['NNP'],
  'Reorganization': ['NNP'],
  'Reorganized': ['NNP'],
  'Reorganizing': ['VBG'],
  'Rep': ['NNP'],
  'Rep.': ['NNP'],
  'Repairing': ['VBG'],
  'Repayment': ['NNP'],
  'Repeal': ['NN'],
  'Repeat': ['NN'],
  'Repeated': ['VBN'],
  'Repeatedly': ['RB'],
  'Repeating': ['VBG'],
  'Repertory': ['NNP'],
  'Replace': ['VB'],
  'Replacement': ['NN'],
  'Replacing': ['VBG'],
  'Replied': ['VBD'],
  'Replies': ['NNS'],
  'Repligen': ['NNP'],
  'Replogle': ['NNP'],
  'Reply': ['NN'],
  'Repnin': ['NNP'],
  'Report': ['NNP'],
  'Reporter': ['NNP'],
  'Reporters': ['NNS'],
  'Reporting': ['NNP'],
  'Reports': ['NNS'],
  'Repository': ['NNP'],
  'Representative': ['NNP'],
  'Representatives': ['NNPS'],
  'Representing': ['VBG'],
  'Repression': ['NN'],
  'Reprimand': ['NN'],
  'Reprinted': ['VBN'],
  'Reprints': ['NNS'],
  'Reprisals': ['NNS'],
  'Reproach': ['VB'],
  'Reproduced': ['VBN'],
  'Reproduction': ['NNP'],
  'Reproductive': ['NNP'],
  'Reps.': ['NNP'],
  'Repsol': ['NNP'],
  'Reptilian': ['NNP'],
  'Republic': ['NNP'],
  'RepublicBank': ['NNP'],
  'Republican': ['NNP'],
  'Republican-controlled': ['JJ'],
  'Republican-governor\\\'': ['JJ'],
  'Republicanism': ['NNP'],
  'Republicans': ['NNPS'],
  'Republics': ['NNPS'],
  'Reputedly': ['RB'],
  'Requests': ['NNS'],
  'Requiem': ['NNP'],
  'Require': ['VB'],
  'Required': ['VBN'],
  'Requirements': ['NNS'],
  'Rescue': ['NNP'],
  'Rescued': ['VBN'],
  'Rescues': ['NNS'],
  'Research': ['NNP'],
  'Research-and-development': ['NN'],
  'Researchers': ['NNS'],
  'Researching': ['VBG'],
  'Resentment': ['NN'],
  'Reservation': ['NNP'],
  'Reserve': ['NNP'],
  'Reserved': ['NNP'],
  'Reserves': ['NNS'],
  'Reservists': ['NNPS'],
  'Reservoir': ['NNP'],
  'Reservoirs': ['NNP'],
  'Reshaping': ['VBG'],
  'Residence': ['NNP'],
  'Resident': ['NNP'],
  'Residential': ['NNP'],
  'Residents': ['NNS'],
  'Resignedly': ['RB'],
  'Resins': ['NNPS'],
  'Resist': ['VB'],
  'Resistance': ['NNP'],
  'Resisting': ['VBG'],
  'Resistol': ['NNP'],
  'Resler': ['NNP'],
  'Resnick': ['NNP'],
  'Resnik': ['NNP'],
  'Resolute': ['NNP'],
  'Resolution': ['NNP'],
  'Resolve': ['NNP'],
  'Resolved': ['VBN'],
  'Resolves': ['NNPS'],
  'Resolving': ['NNP'],
  'Resort': ['NNP'],
  'Resorts': ['NNPS'],
  'Resource': ['NNP'],
  'Resourceful': ['JJ'],
  'Resources': ['NNPS'],
  'Resourcesrose': ['NNP'],
  'Respect': ['NN'],
  'Respectability': ['NN'],
  'Respecting': ['VBG'],
  'Respiratory': ['NNP'],
  'Respond': ['VBP'],
  'Respondents': ['NNS'],
  'Responding': ['VBG'],
  'Response': ['NNP'],
  'Responses': ['NNS'],
  'Responsibility': ['NNP'],
  'Responsible': ['JJ'],
  'Resrve': ['NNP'],
  'Ress': ['NNP'],
  'Rest': ['VB'],
  'Restaurant': ['NNP'],
  'Restaurants': ['NNP'],
  'Resting': ['VBG'],
  'Restless': ['JJ'],
  'Reston': ['NNP'],
  'Restoration': ['NNP'],
  'Restraint': ['NNP'],
  'Restrict': ['VB'],
  'Restrictive': ['JJ'],
  'Restructure': ['VBP'],
  'Restructuring': ['NN'],
  'Rests': ['VBZ'],
  'Restudy': ['VB'],
  'Result': ['NN'],
  'Results': ['NNS'],
  'Resuming': ['VBG'],
  'Ret': ['NNP'],
  'Retail': ['JJ'],
  'Retailer': ['NN'],
  'Retailers': ['NNS'],
  'Retailing': ['NN'],
  'Retails': ['NNS'],
  'Retardation': ['NNP'],
  'Retention': ['NNP'],
  'Retin-A': ['NNP'],
  'Retired': ['NNP'],
  'Retiree': ['NN'],
  'Retirement': ['NNP'],
  'Retiring': ['VBG'],
  'Retrace': ['VB'],
  'Retracing': ['VBG'],
  'Retrieval': ['NNP'],
  'Retrovir': ['NNP'],
  'Retrovirus': ['NNP'],
  'Retton': ['NNP'],
  'Return': ['NN'],
  'Returning': ['VBG'],
  'Returns': ['NNS'],
  'Reub': ['NNP'],
  'Reuben': ['NNP'],
  'Reuling': ['NNP'],
  'Reunification': ['NN'],
  'Reunion': ['NNP'],
  'Reupke': ['NNP'],
  'Reuschel': ['NNP'],
  'Reuss': ['NNP'],
  'Reuter': ['NNP'],
  'Reuters': ['NNP'],
  'Reuther': ['NNP'],
  'Reuven': ['NNP'],
  'Reuveni': ['NNP'],
  'Rev': ['NNP'],
  'Rev.': ['NNP'],
  'Reva': ['NNP'],
  'Revamps': ['NNP'],
  'Revco': ['NNP'],
  'Reveals': ['VBZ'],
  'Revelation': ['NNP'],
  'Revell': ['NNP'],
  'Revenge': ['NN'],
  'Revenue': ['NN'],
  'Revenue-short': ['JJ'],
  'Revenues': ['NNS'],
  'Reverdy': ['NNP'],
  'Revere': ['NNP'],
  'Reverend': ['NNP'],
  'Reverently': ['RB'],
  'Reversal': ['NNP'],
  'Reverse': ['VB'],
  'Reversing': ['VBG'],
  'Review': ['NNP'],
  'Reviewing': ['VBG'],
  'Reviglio': ['NNP'],
  'Revise': ['VB'],
  'Revised': ['NNP'],
  'Revising': ['VBG'],
  'Revision': ['NNP'],
  'Revisited': ['NNP'],
  'Revitalization': ['NNP'],
  'Revitalized': ['VBN'],
  'Revivals': ['NNS'],
  'Revlon': ['NNP'],
  'Revolt': ['NN'],
  'Revolution': ['NNP'],
  'Revolutionaries': ['NNS'],
  'Revolutionary': ['NNP'],
  'Revolutionibus': ['FW'],
  'Revolving': ['VBG'],
  'Revson': ['NNP'],
  'Revulsion': ['NNP'],
  'Revzin': ['NNP'],
  'Reward': ['VB'],
  'Rewarding': ['NN'],
  'Rewards': ['NNS'],
  'Rex': ['NNP'],
  'Rexall': ['NNP'],
  'Rexene': ['NNP'],
  'Rexinger': ['NNP'],
  'Rexroth': ['NNP'],
  'Rey': ['NNP'],
  'Rey-controlled': ['JJ'],
  'Reye': ['NNP'],
  'Reyes': ['NNP'],
  'Reyes-Requena': ['NNP'],
  'Reykjavik': ['NNP'],
  'Reynolds': ['NNP'],
  'Rezneck': ['NNP'],
  'Reznichenko': ['NNP'],
  'Rezsoe': ['NNP'],
  'Rh': ['NNP'],
  'Rhea': ['NNP'],
  'Rheims': ['NNP'],
  'Rheingold': ['NNP'],
  'Rheinholdt': ['NNP'],
  'Rheinstahl': ['NNP'],
  'Rheinstein': ['NNP'],
  'Rhenish': ['JJ'],
  'Rhett': ['NNP'],
  'Rheumatics': ['NN', 'NNS'],
  'Rheumatism': ['NNP'],
  'Rhin': ['NNP'],
  'Rhine': ['NNP'],
  'Rhine-Main': ['NNP'],
  'Rhine-Westphalia': ['NNP'],
  'Rhineland': ['NN'],
  'Rhinoceros': ['NNP'],
  'Rhoads': ['NNP'],
  'Rhoda': ['NNP'],
  'Rhode': ['NNP'],
  'Rhodes': ['NNP'],
  'Rhodesia': ['NNP'],
  'Rhona': ['NNP'],
  'Rhone': ['NNP'],
  'Rhone-Poulenc': ['NNP'],
  'Rhu-beb-ni-ice': ['NN'],
  'Rhyme': ['VB'],
  'Rhys': ['NNP'],
  'Rhythm': ['NN'],
  'Rhythm-Wily': ['NNP'],
  'Rhythmic': ['JJ'],
  'Rhythms': ['NNPS'],
  'Riad': ['NNP'],
  'Rianta': ['NNP'],
  'Ribas': ['NNP'],
  'Ribeiro': ['NNP'],
  'Riben': ['NNP'],
  'Ribes': ['NNP'],
  'Ribozymes': ['NNS'],
  'Rica': ['NNP'],
  'Rican': ['JJ'],
  'Rican-American': ['NNP'],
  'Ricans': ['NNS'],
  'Ricardo': ['NNP'],
  'Ricca': ['NNP'],
  'Riccardo': ['NNP'],
  'Ricci': ['NNP'],
  'Ricco': ['NNP'],
  'Rice': ['NNP'],
  'Rich': ['NNP'],
  'Rich-affiliated': ['JJ'],
  'Richard': ['NNP'],
  'Richardot': ['NNP'],
  'Richards': ['NNP'],
  'Richardson': ['NNP'],
  'Richardson-Merrell': ['NNP'],
  'Richardson-Smith': ['NNP'],
  'Richardson-Vicks': ['NNP'],
  'Richco': ['NNP'],
  'Richebourg': ['NNP'],
  'Richelieu': ['NNP'],
  'Richer': ['NNP'],
  'Richert': ['NNP'],
  'Richeson': ['NNP'],
  'Richey': ['NNP'],
  'Richfield': ['NNP'],
  'Richland': ['NNP'],
  'Richman': ['NNP'],
  'Richmond': ['NNP'],
  'Richmond-Petersburg': ['NNP'],
  'Richmond-San': ['NNP'],
  'Richmond-Watson': ['NNP'],
  'Richmond-area': ['JJ'],
  'Richstone': ['NNP'],
  'Richter': ['NNP'],
  'Richter-Haaser': ['NNP'],
  'Richterian': ['JJ'],
  'Richwhite': ['NNP'],
  'Rick': ['NNP'],
  'Rickards': ['NNP'],
  'Rickel': ['NNP'],
  'Ricken': ['NNP'],
  'Rickenbaugh': ['NNP'],
  'Ricketts': ['NNP'],
  'Rickettsia': ['NN'],
  'Rickey': ['NNP'],
  'Rickshaw': ['NNP'],
  'Rico': ['NNP'],
  'Ricoh': ['NNP'],
  'Ricostruzioni': ['NNP'],
  'Ridder': ['NNP'],
  'Riddle': ['NN'],
  'Ride': ['VB'],
  'Rider': ['NNP'],
  'Riders': ['NNPS'],
  'Ridge': ['NNP'],
  'Ridgefield': ['NNP'],
  'Ridgway': ['NNP'],
  'Ridiculing': ['VBG'],
  'Ridiculous': ['JJ'],
  'Riding': ['VBG'],
  'Ridley': ['NNP'],
  'Ridpath': ['NNP'],
  'Riedel': ['NNP'],
  'Riefenstahl': ['NNP'],
  'Riefling': ['NNP'],
  'Riegger': ['NNP'],
  'Riegle': ['NNP'],
  'Rieke': ['NNP'],
  'Riely': ['NNP'],
  'Riemann': ['NNP'],
  'Riepe': ['NNP'],
  'Ries': ['NNP'],
  'Riese': ['NNP'],
  'Rieslings': ['NNPS'],
  'Riesman': ['NNP'],
  'Rifenburgh': ['NNP'],
  'Rifkin': ['NNP'],
  'Rifkind': ['NNP'],
  'Rifkinesque': ['JJ'],
  'Rifle': ['NNP'],
  'Riflery': ['NN'],
  'Rifles': ['NNS'],
  'Rig-Veda': ['NNP'],
  'Riga': ['NNP'],
  'Riger': ['NNP'],
  'Riggs': ['NNP'],
  'Right': ['RB'],
  'Right-hander': ['JJ'],
  'Right-to-Die': ['JJ'],
  'Right-wing': ['JJ'],
  'Righteous': ['JJ'],
  'Rightly': ['RB'],
  'Rights': ['NNP'],
  'Rigid': ['JJ'],
  'Rigoletto': ['NNP'],
  'Rihanna': ['NNP'],
  'Riiiing': ['UH'],
  'Riklis': ['NNP'],
  'Riley': ['NNP'],
  'Rilke': ['NNP'],
  'Rill': ['NNP'],
  'Rilling': ['NNP'],
  'Rilly': ['NNP'],
  'Rilwanu': ['NNP'],
  'Rim': ['NNP'],
  'Rim-Fire': ['JJ'],
  'Rima': ['NNP'],
  'Rimanelli': ['NNP'],
  'Rimbaud': ['NN'],
  'Rimes': ['NNP'],
  'Rimini': ['NNP'],
  'Rimmer': ['NNP'],
  'Rimstalker': ['NNP'],
  'Rinascimento': ['NNP'],
  'Rinat': ['NNP'],
  'Rincon': ['NNP'],
  'Rindos': ['NNP'],
  'Rinehart': ['NNP'],
  'Riney': ['NNP'],
  'Ring': ['NNP'],
  'Ringel': ['NNP'],
  'Ringenbach': ['NNP'],
  'Ringer': ['NNP'],
  'Ringers': ['NNS'],
  'Ringing': ['NN'],
  'Ringler': ['NNP'],
  'Ringo': ['NNP'],
  'Ringwood': ['NNP'],
  'Rink': ['NNP'],
  'Rinker': ['NNP'],
  'Rinsing': ['VBG'],
  'Rio': ['NNP'],
  'Riordan': ['NNP'],
  'Rios': ['NNP'],
  'Rios-embryos': ['NNS'],
  'Rip': ['NNP'],
  'Ripa': ['NNP'],
  'Ripe': ['NNP'],
  'Rippe': ['NNP'],
  'Ripper': ['NNP'],
  'Ripplemeyer': ['NNP'],
  'Ripples': ['NNS'],
  'Rise': ['NN'],
  'Riserva': ['NNP'],
  'Rises': ['NNP'],
  'Rising': ['VBG'],
  'Risk': ['NN'],
  'Risking': ['NNP'],
  'Risks': ['NNS'],
  'Risky': ['NNP'],
  'Risley': ['NNP'],
  'Risparmio': ['NNP'],
  'Risques': ['NNP'],
  'Rita': ['NNP'],
  'Rita-Sue': ['NNP'],
  'Ritchie': ['NNP'],
  'Rite': ['NNP'],
  'Rito': ['NNP'],
  'Ritschl': ['NNP'],
  'Rittenhouse': ['NNP'],
  'Ritter': ['NNP'],
  'Ritterman': ['NNP'],
  'Rittlemann': ['NNP'],
  'Ritz': ['NNP'],
  'Ritz-Carlton': ['NNP'],
  'Riunite': ['NNP'],
  'Riunitie': ['NNP'],
  'Rival': ['NNP'],
  'Rivals': ['NNS'],
  'River': ['NNP'],
  'Rivera': ['NNP'],
  'Riverboat': ['NNP'],
  'Riverfront': ['NNP'],
  'Rivers': ['NNPS'],
  'Riverside': ['NNP'],
  'Riverview': ['NNP'],
  'Riverwalk': ['NNP'],
  'Riviera': ['NNP'],
  'Rivkin': ['NNP'],
  'Rivlin': ['NNP'],
  'Rivoli': ['FW'],
  'Riyadh': ['NNP'],
  'Rizopolous': ['NNP'],
  'Rizvi': ['NNP'],
  'Rizzello': ['NNP'],
  'Rizzuto': ['NNP'],
  'Roach': ['NNP'],
  'Roaco': ['NNP'],
  'Road': ['NNP'],
  'RoadRailer': ['NNP'],
  'RoadRailers': ['NNPS'],
  'RoadRailing': ['VBG'],
  'Roads': ['NNP'],
  'Roadway': ['NNP'],
  'Roald': ['NNP'],
  'Roaming': ['VBG'],
  'Roanoke': ['NNP'],
  'Roaring': ['NNP'],
  'Roark': ['NNP'],
  'Roast': ['VB'],
  'Roasters': ['NNS'],
  'Rob': ['NNP'],
  'Robards': ['NNP'],
  'Robb': ['NNP'],
  'Robbers': ['NNS'],
  'Robbery': ['NNP'],
  'Robbie': ['NNP'],
  'Robbins': ['NNP'],
  'Robby': ['NNP'],
  'Robec': ['NNP'],
  'Robert': ['NNP'],
  'Roberta': ['NNP'],
  'Roberti': ['NNP'],
  'Roberto': ['NNP'],
  'Roberts': ['NNP'],
  'RobertsCorp': ['NNP'],
  'Robertson': ['NNP'],
  'Robertsons': ['NNPS'],
  'Robeson': ['NNP'],
  'Robie': ['NNP'],
  'Robin': ['NNP'],
  'Robinowitz': ['NNP'],
  'Robins': ['NNP'],
  'Robinson': ['NNP'],
  'Robinson-Humphrey': ['NNP'],
  'Robinsonville': ['NNP'],
  'Robles': ['NNP'],
  'Robot': ['NN'],
  'Robotics': ['NNP'],
  'Robots': ['NNP'],
  'Robusta-producing': ['JJ'],
  'Rocco': ['NNP'],
  'Roch': ['NNP'],
  'Rocha': ['NNP'],
  'Rochdale': ['NNP'],
  'Roche': ['NNP'],
  'Rochelle': ['NNP'],
  'Rochester': ['NNP'],
  'Rochford': ['NNP'],
  'Rock': ['NNP'],
  'Rock\'n': ['NNP'],
  'Rockabye': ['NNP'],
  'Rockaways': ['NNPS'],
  'Rockefeller': ['NNP'],
  'Rocket': ['NNP'],
  'Rocket-powered': ['JJ'],
  'Rocketdyne': ['NNP'],
  'Rockettes': ['NNPS'],
  'Rockford': ['NNP'],
  'Rockfork': ['NNP'],
  'Rockhall': ['NNP'],
  'Rockies': ['NNPS'],
  'Rocking': ['NNP'],
  'Rockport': ['NNP'],
  'Rockville': ['NNP'],
  'Rockwell': ['NNP'],
  'Rocky': ['NNP'],
  'Rococo': ['JJ'],
  'Rod': ['NNP'],
  'Rodale': ['NNP'],
  'Rodding': ['NN'],
  'Rodent': ['NN'],
  'Rodeo': ['NNP'],
  'Rodeph': ['NNP'],
  'Roderick': ['NNP'],
  'Rodgers': ['NNP'],
  'Rodman': ['NNP'],
  'Rodney': ['NNP'],
  'Rodney-Honor': ['NNP'],
  'Rodney-Miss': ['NNP'],
  'Rodney-The': ['NNP'],
  'Rodolfo': ['NNP'],
  'Rodrigo': ['NNP'],
  'Rodriguez': ['NNP'],
  'Rodriquez': ['NNP'],
  'Roe': ['NNP'],
  'Roebuck': ['NNP'],
  'Roeck': ['NNP'],
  'Roederer': ['NNP'],
  'Roehm': ['NNP'],
  'Roemer': ['NNP'],
  'Roeser': ['NNP'],
  'Roessler': ['NNP'],
  'Roffman': ['NNP'],
  'Rogaine': ['NNP'],
  'Roger': ['NNP'],
  'Rogers': ['NNP'],
  'Rogin': ['NNP'],
  'Rognoni': ['NNP'],
  'Rogues': ['NNPS'],
  'Roh': ['NNP'],
  'Rohatyn': ['NNP'],
  'Rohm': ['NNP'],
  'Rohr': ['NNP'],
  'Rohrer': ['NNP'],
  'Rohs': ['NNP'],
  'Roine': ['NNP'],
  'Roizen': ['NNP'],
  'Rojas': ['NNP'],
  'Rojo': ['NNP'],
  'Rolaids': ['NNP'],
  'Roland': ['NNP'],
  'Role': ['NN'],
  'Roleplaying': ['NN'],
  'Roles': ['NNS'],
  'Rolette': ['NNP'],
  'Rolex': ['NNP'],
  'Rolexes': ['NNPS'],
  'Rolf': ['NNP'],
  'Rolfe': ['NNP'],
  'Rolfes': ['NNP'],
  'Roling': ['NNP'],
  'Roll': ['NNP'],
  'Rolland': ['NNP'],
  'Rolled': ['VBN'],
  'Roller': ['NNP'],
  'Rollie': ['NNP'],
  'Rollin': ['NNP'],
  'Rolling': ['NNP'],
  'Rollins': ['NNP'],
  'Rolls': ['NNP'],
  'Rolls-Royce': ['NNP'],
  'Rolls-Royces': ['NNPS'],
  'Rolm': ['NNP'],
  'Rolnick': ['NNP'],
  'Rolodex': ['NNP'],
  'Rolodexes': ['NNPS'],
  'Roloff': ['NNP'],
  'Roma': ['NNP'],
  'Romagnosi': ['NNP'],
  'Romain': ['NNP'],
  'Roman': ['NNP'],
  'Roman-camp': ['NN'],
  'Romana': ['NNP'],
  'Romances': ['NNP'],
  'Romanee-Conti': ['NNP'],
  'Romanesque': ['JJ'],
  'Romania': ['NNP'],
  'Romanian': ['JJ'],
  'Romaniuk': ['NNP'],
  'Romano': ['NNP'],
  'Romans': ['NNPS'],
  'Romantic': ['JJ'],
  'Romanza': ['NNP'],
  'Rome': ['NNP'],
  'Rome-based': ['JJ'],
  'Romeo': ['NNP'],
  'Romer': ['NNP'],
  'Romero': ['NNP'],
  'Romm': ['NNP'],
  'Rommel': ['NNP'],
  'Romo': ['NNP'],
  'Romulo': ['NNP'],
  'Ron': ['NNP'],
  'Rona': ['NNP'],
  'Ronald': ['NNP'],
  'Rondanini': ['NNP'],
  'Rondo': ['NN'],
  'Rong': ['NNP'],
  'Ronkonkoma': ['NNP'],
  'Ronnel': ['NN'],
  'Ronnie': ['NNP'],
  'Roof': ['NNP'],
  'Rooker': ['NNP'],
  'Rookie': ['NN'],
  'Room': ['NNP'],
  'Roomberg': ['NNP'],
  'Roommates': ['NNS'],
  'Rooms': ['NNS'],
  'Rooney': ['NNP'],
  'Roos': ['NNP'],
  'Roosevelt': ['NNP'],
  'Rooseveltian': ['JJ'],
  'Root': ['NN'],
  'Roots': ['NNPS'],
  'Ropart': ['NNP'],
  'Roper': ['NNP'],
  'Ropes': ['NNPS'],
  'Roquemore': ['NNP'],
  'Rorer': ['NNP'],
  'Rorschach': ['NNP'],
  'Rory': ['NNP'],
  'Rosa': ['NNP'],
  'Rosabelle': ['NNP'],
  'Rosabeth': ['NNP'],
  'Rosalco': ['NNP'],
  'Rosalie': ['NNP'],
  'Rosalind': ['NNP'],
  'Rosalyn': ['NNP'],
  'Rosalynn': ['NNP'],
  'Rosburg': ['NNP'],
  'Roscoe': ['NNP'],
  'Rose': ['NNP'],
  'Roseanne': ['NNP'],
  'Roseland': ['NNP'],
  'Rosella': ['NNP'],
  'Roselle': ['NNP'],
  'Rosemary': ['NNP'],
  'Rosemont': ['NNP'],
  'Rosen': ['NNP'],
  'Rosenau': ['NNP'],
  'Rosenbach': ['NNP'],
  'Rosenbaum': ['NNP'],
  'Rosenberg': ['NNP'],
  'Rosenblatt': ['NNP'],
  'Rosenblum': ['NNP'],
  'Rosencrants': ['NNP'],
  'Rosenfeld': ['NNP'],
  'Rosenfield': ['NNP'],
  'Rosenmueller': ['NNP'],
  'Rosenstein': ['NNP'],
  'Rosenthal': ['NNP'],
  'Rosenwald': ['NNP'],
  'Roses': ['NNPS'],
  'Rosett': ['NNP'],
  'Rosewood': ['NNP'],
  'Rosie': ['NNP'],
  'Roskind': ['NNP'],
  'Roslev': ['NNP'],
  'Roslyn': ['NNP'],
  'Rosman': ['NNP'],
  'Rosner': ['NNP'],
  'Rosoff': ['NNP'],
  'Rosow': ['NNP'],
  'Rospatch': ['NNP'],
  'Ross': ['NNP'],
  'Rosser': ['NNP'],
  'Rossi': ['NNP'],
  'Rossides': ['NNP'],
  'Rossilini': ['NNP'],
  'Rossini': ['NNP'],
  'Rosso': ['NNP'],
  'Rossoff': ['NNP'],
  'Rost': ['NNP'],
  'Rostagno': ['NNP'],
  'Rostagnos': ['NNPS'],
  'Rostenkowski': ['NNP'],
  'Rosty': ['NNP'],
  'Roswell': ['NNP'],
  'Rosy': ['NNP'],
  'Rotan': ['NNP'],
  'Rotarians': ['NNPS'],
  'Rotary': ['NNP'],
  'Rotelli': ['NNP'],
  'Rotenberg': ['NNP'],
  'Roth': ['NNP'],
  'Rotha': ['NNP'],
  'Rothamsted': ['NNP'],
  'Rothe': ['NNP'],
  'Rothenberg': ['NNP'],
  'Rothko': ['NNP'],
  'Rothman': ['NNP'],
  'Rothmans': ['NNP'],
  'Rothmeier': ['NNP'],
  'Rothschild': ['NNP'],
  'Rothschilds': ['NNPS'],
  'Rothshchild': ['NNP'],
  'Rothwell': ['NNP'],
  'Rotie': ['NNP'],
  'Rotman': ['NNP'],
  'Roto-Rooter': ['NNP'],
  'Rotonda': ['NNP'],
  'Rotondo': ['NNP'],
  'Rotorex': ['NNP'],
  'Rotterdam': ['NNP'],
  'Rottger': ['NNP'],
  'Rottosei': ['NNP'],
  'Rotunda': ['NNP'],
  'Rouben': ['NNP'],
  'Rouge': ['NNP'],
  'Rough': ['JJ'],
  'Roughly': ['RB'],
  'Roukema': ['NNP'],
  'Roulac': ['NNP'],
  'Roulet': ['NNP'],
  'Round': ['NNP'],
  'Rounded': ['JJ'],
  'Rounding': ['VBG'],
  'Rounding-off': ['NN'],
  'Roundtable': ['NNP'],
  'Roundup': ['NNP'],
  'Rourke': ['NNP'],
  'Rous': ['NNP'],
  'Rousell': ['NNP'],
  'Rousseau': ['NNP'],
  'Rousseauan': ['JJ'],
  'Roussel': ['NNP'],
  'Roussel-Uclaf': ['NNP'],
  'Roustabouts': ['NNPS'],
  'Route': ['NNP'],
  'Routine': ['JJ'],
  'Routo-Jig': ['NN'],
  'Rover': ['NNP'],
  'Row': ['NNP'],
  'Rowan': ['NNP'],
  'Rowe': ['NNP'],
  'Rowell': ['NNP'],
  'Rowland': ['NNP'],
  'Rowland-Molina': ['NNP'],
  'Rowland-Morin': ['NNP'],
  'Rowlands': ['NNP'],
  'Rowley': ['NNP'],
  'Rowman': ['NNP'],
  'Rowse': ['NNP'],
  'Rowswell': ['NNP'],
  'Roxani': ['NNP'],
  'Roxanne': ['NNP'],
  'Roxboro': ['NNP'],
  'Roxy': ['NNP'],
  'Roy': ['NNP'],
  'Royal': ['NNP'],
  'Royale': ['NNP'],
  'Royalty': ['NNP'],
  'Royaux': ['NNP'],
  'Roybal': ['NNP'],
  'Royce': ['NNP'],
  'Roylott': ['NNP'],
  'Rozella': ['NNP'],
  'Rozelle': ['NNP'],
  'Rte.': ['NNP'],
  'Ruanda-Urundi': ['NNP'],
  'Ruark': ['NNP'],
  'Rubber': ['NNP'],
  'Rubbermaid': ['NNP'],
  'Rubbish': ['NN'],
  'Rube': ['NNP'],
  'Rubega': ['NNP'],
  'Rubel': ['NNP'],
  'Rubeli': ['NNP'],
  'Rubendall': ['NNP'],
  'Rubenesquely': ['JJ'],
  'Rubens': ['NNP'],
  'Rubenstein': ['NNP'],
  'Ruberg': ['NNP'],
  'Rubicam': ['NNP'],
  'Rubik': ['NNP'],
  'Rubin': ['NNP'],
  'Rubinfien': ['NNP'],
  'Rubins': ['NNS'],
  'Rubinstein': ['NNP'],
  'Rubio': ['NNP'],
  'Ruby': ['NNP'],
  'Rucellai': ['NNP'],
  'Ruckdeschel': ['NNP'],
  'Ruckert': ['NNP'],
  'Rudder': ['NNP'],
  'Rude': ['NNP'],
  'Ruder': ['NNP'],
  'Ruderman': ['NNP'],
  'Rudi': ['NNP'],
  'Rudibaugh': ['NNP'],
  'Ruding': ['NNP'],
  'Rudkoebing': ['NNP'],
  'Rudman': ['NNP'],
  'Rudner': ['NNP'],
  'Rudnick': ['NNP'],
  'Rudoff': ['NNP'],
  'Rudolf': ['NNP'],
  'Rudolph': ['NNP'],
  'Rudy': ['NNP'],
  'Rudyard': ['NNP'],
  'Rue': ['NNP'],
  'Ruettgers': ['NNP'],
  'Rufenacht': ['NNP'],
  'Ruff': ['NNP'],
  'Ruffel': ['NNP'],
  'Ruffians': ['NNS'],
  'Ruffled': ['VBN'],
  'Ruffo': ['NNP'],
  'Rufus': ['NNP'],
  'Ruger': ['NNP'],
  'Rugeroni': ['NNP'],
  'Rugged': ['JJ'],
  'Ruggiero': ['NNP'],
  'Ruhnau': ['NNP'],
  'Ruhollah': ['NNP'],
  'Ruidoso': ['NNP'],
  'Ruined': ['VBN'],
  'Ruiz': ['NNP'],
  'Ruiz-Mateos': ['NNP'],
  'Rukeyser': ['NNP'],
  'Rul.': ['NNP'],
  'Rule': ['NNP'],
  'Ruled': ['VBN'],
  'Rulers': ['NNPS'],
  'Rules': ['NNP'],
  'Ruling': ['NN'],
  'Rullo': ['NNP'],
  'Rum': ['NNP'],
  'Rumack': ['NNP'],
  'Rumania': ['NNP'],
  'Rumanian': ['JJ'],
  'Rumanians': ['NNPS'],
  'Rumasa': ['NNP'],
  'Rumford': ['NNP'],
  'Rummaging': ['VBG'],
  'Rummel': ['NNP'],
  'Rumor': ['NN'],
  'Rumors': ['NNS'],
  'Rumpelstiltskin': ['NNP'],
  'Rumscheidt': ['NNP'],
  'Run': ['NNP'],
  'Run-down': ['JJ'],
  'Runcie': ['NNP'],
  'Rundfunk': ['NNP'],
  'Rundfunk-Sinfonie-Orchester': ['NNP'],
  'Rundfunkchor': ['NNP'],
  'Rundlett': ['NNP'],
  'Rune': ['NNP'],
  'Runge': ['NNP'],
  'Runiewicz': ['NNP'],
  'Runkel': ['NNP'],
  'Runnan': ['NNP'],
  'Runner': ['NNP'],
  'Runners': ['NNS'],
  'Running': ['VBG'],
  'Runtagh': ['NNP'],
  'Runways': ['NNS'],
  'Runyon': ['NNP'],
  'Ruoff': ['NNP'],
  'Rupert': ['NNP'],
  'Ruppert': ['NNP'],
  'Rural': ['NNP'],
  'Rus': ['NNP'],
  'Ruschkowski': ['NNP'],
  'Rush': ['NNP'],
  'Rush-Presbyterian-St': ['NNP'],
  'Rushall': ['NNP'],
  'Rushdie': ['NNP'],
  'Rushforth': ['NNP'],
  'Rushmore': ['NNP'],
  'Rusk': ['NNP'],
  'Ruskin': ['NNP'],
  'Russ': ['NNP'],
  'Russel': ['NNP'],
  'Russell': ['NNP'],
  'Russes': ['NNP'],
  'Russia': ['NNP'],
  'Russian': ['NNP'],
  'Russian-dominated': ['JJ'],
  'Russian-language': ['JJ'],
  'Russians': ['NNPS'],
  'Russo': ['NNP'],
  'Russo-American': ['JJ'],
  'Rust': ['NNP'],
  'Rustin': ['NNP'],
  'Rusting': ['VBG'],
  'Ruston': ['NNP'],
  'Rusty': ['NNP'],
  'Rutan': ['NNP'],
  'Rutgers': ['NNP'],
  'Ruth': ['NNP'],
  'Ruthann': ['NNP'],
  'Rutherford': ['NNP'],
  'Ruthlessness': ['NN'],
  'Rutstein': ['NNP'],
  'Ruttenbur': ['NNP'],
  'Ruvolo': ['NNP'],
  'Ruwe': ['NNP'],
  'Ruxpin': ['NNP'],
  'Ruys': ['NNP'],
  'Ruysch': ['NNP'],
  'Rwanda': ['NNP'],
  'Ry.': ['NNP'],
  'Ryan': ['NNP'],
  'Ryc': ['NNP'],
  'Rychard': ['NNP'],
  'Rydell': ['NNP'],
  'Ryder': ['NNP'],
  'Rye': ['NNP'],
  'Ryerson': ['NNP'],
  'Rykoff-Sexton': ['NNP'],
  'Ryland': ['NNP'],
  'Rylie': ['NNP'],
  'Rymer': ['NNP'],
  'Ryne': ['NNP'],
  'Ryosuke': ['NNP'],
  'Ryrie': ['NNP'],
  'Ryskamp': ['NNP'],
  'Ryukichi': ['NNP'],
  'Ryusenji': ['NNP'],
  'Ryutaro': ['NNP'],
  'Ryzhkov': ['NNP'],
  'S': ['NNP'],
  'S\$': ['\$'],
  'S&L': ['NNP'],
  'S&Ls': ['NNS'],
  'S&P': ['NNP'],
  'S&P-500': ['NNP'],
  'S&P-down': ['NN'],
  'S\'Mores': ['NNP'],
  'S*': ['NNP'],
  'S*/NN&L': ['NNP'],
  'S*/NNP&L': ['NN'],
  'S*/NNP&P': ['NN'],
  'S*/NNS&Ls': ['NNP'],
  'S-10': ['NNP'],
  'S-11': ['NN'],
  'S-20': ['NN'],
  'S-Cargo': ['NNP'],
  'S-D': ['NN'],
  'S-K-I': ['NNP'],
  'S-curve': ['NN'],
  'S-s-sahjunt': ['NN'],
  'S.': ['NNP'],
  'S.A': ['NNP'],
  'S.A.': ['NNP'],
  'S.A.F.E.': ['NNP'],
  'S.C': ['NNP'],
  'S.C.': ['NNP'],
  'S.C.-based': ['JJ'],
  'S.D': ['NNP'],
  'S.D.': ['NNP'],
  'S.G.': ['NNP'],
  'S.Grove': ['NNP'],
  'S.I.': ['NNP'],
  'S.J.': ['NNP'],
  'S.K.': ['NNP'],
  'S.O.B': ['NNP'],
  'S.O.B.': ['NN'],
  'S.O.B.s': ['NNS'],
  'S.P.': ['NNP'],
  'S.P.C.A.': ['NN'],
  'S.S.': ['NNP'],
  'S.S.R.': ['NNP'],
  'S.W.': ['NNP'],
  'S.p': ['NNP'],
  'S.p.A.': ['NNP'],
  'S/O': ['VB'],
  'SA': ['NNP'],
  'SA-12': ['NN'],
  'SAAMI': ['NNP'],
  'SAATCHI': ['NNP'],
  'SAB': ['NNP'],
  'SABH': ['NNP'],
  'SABLE': ['NNP'],
  'SAC': ['NNP'],
  'SAFEWAY': ['NNP'],
  'SAID': ['VBD'],
  'SAINT': ['NNP'],
  'SAKOS': ['FW'],
  'SALARIES': ['NNS'],
  'SALE': ['NN'],
  'SALES': ['NNS'],
  'SALT': ['NNP'],
  'SAME': ['JJ'],
  'SAMOS': ['NNP'],
  'SAMURAI': ['NNP'],
  'SAN': ['NNP'],
  'SANTA': ['NNP'],
  'SARK': ['NNP'],
  'SAS': ['NNP'],
  'SAT': ['NNP'],
  'SAVINGS': ['NNP'],
  'SBA': ['NNP'],
  'SBCI': ['NNP'],
  'SC': ['NNP'],
  'SCA': ['NNP'],
  'SCANDALS': ['NNS'],
  'SCE': ['NNP'],
  'SCECorp': ['NNP'],
  'SCHLOSS': ['NNP'],
  'SCHMIDT': ['NNP'],
  'SCHOOL': ['NN'],
  'SCHWAB': ['NNP'],
  'SCHWARTZ': ['NNP'],
  'SCI': ['NNP'],
  'SCIENTISTS': ['NNS'],
  'SCORE': ['NNP'],
  'SCR': ['NNP'],
  'SCRAMBLE': ['VBP'],
  'SCRAP': ['VBP'],
  'SCUD': ['NNP'],
  'SD': ['NNP'],
  'SDI': ['NNP'],
  'SE': ['NNP'],
  'SEAGATE': ['NNP'],
  'SEAQ': ['NNP'],
  'SEAT': ['NNP'],
  'SEATO': ['NNP'],
  'SEC': ['NNP'],
  'SEC.': ['NNP'],
  'SECOND': ['JJ'],
  'SECTION': ['NN'],
  'SECURITY': ['NN'],
  'SEE': ['VBP'],
  'SEEK': ['VB'],
  'SEEKING': ['VBG'],
  'SEEKS': ['VBZ'],
  'SEEQ': ['NNP'],
  'SEI': ['NNP'],
  'SELF-DESTROYED': ['VBN'],
  'SELL': ['VB'],
  'SELL-OFFS': ['NNS'],
  'SELLING': ['NNP'],
  'SEM': ['NNP'],
  'SEMICONDUCTOR': ['NNP'],
  'SENATE': ['NNP'],
  'SENIOR': ['JJ'],
  'SEPARATE': ['JJ'],
  'SEPARATED': ['VBN'],
  'SEPT.': ['NNP'],
  'SERVE': ['VBP'],
  'SERVICE': ['NN'],
  'SERVICES': ['NNP'],
  'SES': ['NNP'],
  'SESCO': ['NNP'],
  'SET': ['VBD'],
  'SETSW': ['NN'],
  'SETTING': ['VBG'],
  'SEVEN-UP': ['NNP'],
  'SE\\\'/30': ['NNP'],
  'SEi': ['NNP'],
  'SF': ['NNP'],
  'SFD': ['NNP'],
  'SFE': ['NNP'],
  'SFX': ['NNP'],
  'SFr2': ['NNP'],
  'SFr3': ['NNP'],
  'SGA': ['NNP'],
  'SGB': ['NNP'],
  'SGC': ['NNP'],
  'SH': ['NN'],
  'SH-11': ['NNP'],
  'SHAKE': ['VB'],
  'SHAREDATA': ['NNP'],
  'SHAREHOLDER': ['NN'],
  'SHEA': ['NNP'],
  'SHEARSON': ['NNP'],
  'SHEDDING': ['VBG'],
  'SHELTERS': ['NNS'],
  'SHEVARDNADZE': ['NNP'],
  'SHIBUMI': ['NNP'],
  'SHIELD': ['NNP'],
  'SHIPPING': ['NNP'],
  'SHIT': ['NN'],
  'SHOPPE': ['NNP'],
  'SHOPPERS': ['NNS'],
  'SHOPS': ['NNS'],
  'SHORT': ['JJ'],
  'SHORT-TERM': ['JJ'],
  'SHORTAGE': ['NN'],
  'SHOULD': ['MD'],
  'SHOWY': ['JJ'],
  'SHUN': ['VBP'],
  'SHUT': ['VB'],
  'SHUTTLE': ['NN'],
  'SHV': ['NNP'],
  'SIA': ['NNP'],
  'SIBV-MS': ['NNP'],
  'SICK': ['NNP'],
  'SIDE': ['NNP'],
  'SIDES': ['NNS'],
  'SIERRA': ['NNP'],
  'SIGNAL': ['NN'],
  'SIGNALED': ['VBN'],
  'SIGNED': ['VBN'],
  'SILLY': ['JJ'],
  'SIMPLIFYING': ['VBG'],
  'SINCE': ['IN'],
  'SISAL': ['NNP'],
  'SITE': ['NN'],
  'SIZING': ['NNP'],
  'SJO': ['NNP'],
  'SK': ['NNP'],
  'SKF': ['NNP'],
  'SKIDDED': ['VBD'],
  'SKIES': ['NNS'],
  'SKILLED': ['JJ'],
  'SKIRTS': ['NNP'],
  'SKr1.5': ['NNS'],
  'SKr20': ['NNS'],
  'SKr205': ['NNS'],
  'SKr225': ['NNS'],
  'SKr29': ['NNS'],
  'SLHD': ['NNP'],
  'SLIPPAGE': ['NN'],
  'SLIPS': ['VBZ'],
  'SLOGANS': ['NNS'],
  'SLORC': ['NNP'],
  'SLTI': ['NNP'],
  'SMALL': ['NNP'],
  'SMALL-BUSINESS': ['NN'],
  'SMALL-COMPANY': ['JJ'],
  'SMART': ['JJ'],
  'SMD': ['NNP'],
  'SMOKING': ['NN'],
  'SMU': ['NNP'],
  'SMYRNA': ['NNP'],
  'SNET': ['NNP'],
  'SNIA': ['NNP'],
  'SNP': ['NN'],
  'SO': ['RB'],
  'SO-CALLED': ['JJ'],
  'SOARED': ['VBD'],
  'SOARS': ['VBZ'],
  'SOCIAL': ['JJ'],
  'SOCIETY\'S': ['NNP'],
  'SOFT': ['JJ'],
  'SOFTWARE': ['NNP'],
  'SOME': ['DT'],
  'SONG': ['NNP'],
  'SONGsters': ['NNS'],
  'SORRY': ['JJ'],
  'SOS': ['NNP'],
  'SOUTH': ['NNP'],
  'SOUTHERN': ['NNP'],
  'SOUVENIRS': ['NNS'],
  'SOVIET': ['JJ'],
  'SOYBEANS': ['NNS'],
  'SP': ['NNP'],
  'SP-44001': ['LS'],
  'SP-44002': ['LS'],
  'SP-44005': ['LS'],
  'SP-44006': ['LS'],
  'SP-44007': ['LS'],
  'SP1': ['JJ'],
  'SP1-plus': ['JJ'],
  'SPAN': ['NNP'],
  'SPCA': ['NNP'],
  'SPECIALIZED': ['JJ'],
  'SPENDING': ['NN'],
  'SPENT': ['VBD'],
  'SPERANDEO': ['NNP'],
  'SPLIT-UP': ['NN'],
  'SPORTS': ['NNS'],
  'SPRINGFIELD': ['NNP'],
  'SPRUCING': ['VBG'],
  'SPWL': ['NNP'],
  'SQUARE': ['NNP'],
  'SQUIBB': ['NNP'],
  'SR': ['NNP'],
  'SRELEASE': ['NN'],
  'SRESERVE': ['NN'],
  'SRS': ['NNP'],
  'SS': ['NNP'],
  'SS-18s': ['NNS'],
  'SS-20': ['NNP'],
  'SS-20s': ['NNPS'],
  'SS-24': ['NNP'],
  'SS-24s': ['NNPS'],
  'SS-25': ['NNP'],
  'SS-25s': ['NNPS'],
  'SS.': ['NNP'],
  'SSI': ['NNP'],
  'SSMC': ['NNP'],
  'SST': ['NNP'],
  'STAGED': ['VBD'],
  'STANDARDS': ['NNPS'],
  'STANLEY': ['NNP'],
  'STAR': ['NN'],
  'STAR-STUDDED': ['JJ'],
  'STARS': ['NNP'],
  'START': ['NNP'],
  'STARTING': ['NNP'],
  'STATE': ['NNP'],
  'STATES': ['NNS'],
  'STC': ['NNP'],
  'STEEL': ['NNP'],
  'STERLING': ['NNP'],
  'STET': ['NNP'],
  'STOCK': ['NN'],
  'STOCK-INDEX': ['NN'],
  'STOCKS': ['NNS'],
  'STODGY': ['JJ'],
  'STOPPED': ['VBN'],
  'STORES': ['NNP'],
  'STREET': ['NNP'],
  'STRIP': ['VB'],
  'STRIPES': ['NNP'],
  'STRUCK': ['VBD'],
  'STRUGGLED': ['VBD'],
  'STS': ['NNP'],
  'STSN': ['NNP'],
  'STUBBED': ['VBN'],
  'STUDENTS': ['NNS'],
  'STUDIES': ['NNS'],
  'STUDY': ['NN'],
  'SU-27': ['NN'],
  'SUBURBIA': ['NN'],
  'SUES': ['VBZ'],
  'SUGAR': ['NN'],
  'SUIT': ['NN'],
  'SUN': ['NNP'],
  'SUNDSTRAND': ['NNP'],
  'SUNY': ['NNP'],
  'SUPERIOR': ['NNP'],
  'SUPERPOWERS': ['NNPS'],
  'SUPREME': ['NNP'],
  'SURGED': ['VBD'],
  'SURVEYS': ['NNS'],
  'SUSPECT': ['JJ'],
  'SUSPENDED': ['VBD'],
  'SV-10': ['NN'],
  'SW': ['NNP'],
  'SWAO': ['NNP'],
  'SWAPO': ['NNP'],
  'SWC': ['NNP'],
  'SWIFT': ['NNP'],
  'SWITCH': ['NN'],
  'SWITCHING': ['VBG'],
  'SWUNG': ['VBD'],
  'SX-21': ['NNP'],
  'SYDNEY-Qintex': ['NNP'],
  'SYSCO': ['NNP'],
  'SYSTEMS': ['NNP'],
  'Sa\'dawi': ['NNP'],
  'Sa-Duk': ['NNP'],
  'Saab': ['NNP'],
  'Saab-Scania': ['NNP'],
  'Saabye': ['NNP'],
  'Saadi': ['NNP'],
  'Saalfeld': ['NNP'],
  'Saatchi': ['NNP'],
  'Saatchis': ['NNPS'],
  'Saba': ['NNP'],
  'Sabaneta': ['NNP'],
  'Sabbath': ['NNP'],
  'Sabella': ['NNP'],
  'Sabena': ['NNP'],
  'Sabha': ['NNP'],
  'Sabhavasu': ['NNP'],
  'Sabina': ['NNP'],
  'Sabinas': ['FW'],
  'Sabine': ['NNP'],
  'Sabinson': ['NNP'],
  'Sable': ['NNP'],
  'Sabo': ['NNP'],
  'Sabol': ['NNP'],
  'Sabras': ['NNS'],
  'Sabre': ['NNP'],
  'Sabreliner': ['NNP'],
  'Sabrina': ['NN'],
  'Sacco': ['NNP'],
  'Sacheverell': ['NNP'],
  'Sachs': ['NNP'],
  'Sack': ['NNP'],
  'Saco': ['NNP'],
  'Sacramento': ['NNP'],
  'Sacramento-based': ['JJ'],
  'Sacre': ['NNP'],
  'Sacred': ['NNP'],
  'Sacremento': ['NNP'],
  'Sacrestia': ['NNP'],
  'Sacrifice': ['NN'],
  'Sacrifices': ['NNS'],
  'Sad': ['JJ'],
  'Sadakane': ['NNP'],
  'Saddam': ['NNP'],
  'Saddle': ['NNP'],
  'Sadie': ['NNP'],
  'Sadler': ['NNP'],
  'Sadly': ['RB'],
  'Safari': ['NNP'],
  'Safavids': ['NNPS'],
  'Safe': ['NNP'],
  'Safeco': ['NNP'],
  'Safeguards': ['NNS'],
  'Safely': ['RB'],
  'Safer': ['NNP'],
  'Safety': ['NNP'],
  'Safety-Kleen': ['NNP'],
  'Safeway': ['NNP'],
  'Saffer': ['NNP'],
  'Safford': ['NNP'],
  'Safi': ['NNP'],
  'Safra': ['NNP'],
  'Saftey': ['NNP'],
  'Sag': ['NNP'],
  'Saga': ['NNP'],
  'Sagami': ['NNP'],
  'Sagan': ['NNP'],
  'Sage': ['NNP'],
  'Sago': ['NNP'],
  'Sagos': ['NNS'],
  'Sahara': ['NNP'],
  'Sahjunt': ['NNP'],
  'Sahour': ['NNP'],
  'Saicheua': ['NNP'],
  'Said': ['VBD'],
  'Saigon': ['NNP'],
  'Sail': ['NNP'],
  'Sailing': ['NNP'],
  'Sailor': ['NNP'],
  'Sailors': ['NNS'],
  'Sain': ['NNP'],
  'Sainsbury': ['NNP'],
  'Saint': ['NNP'],
  'Saint-Geours': ['NNP'],
  'Saint-Saens': ['NNP'],
  'Sainte-Chapelle': ['NNP'],
  'Sainted': ['NNP'],
  'Saints': ['NNP'],
  'Saintsbury': ['NNP'],
  'Saison': ['NNP'],
  'Saitama': ['NNP'],
  'Saito': ['NNP'],
  'Saitoti': ['NNP'],
  'Sajak': ['NNP'],
  'Sakaguchi': ['NNP'],
  'Sakata': ['NNP'],
  'Sake': ['FW'],
  'Sakellariadis': ['NNP'],
  'Sakellariadises': ['NNS'],
  'Sakharov': ['NNP'],
  'Saklad': ['NNP'],
  'Sako': ['NN'],
  'Sakowitz': ['NNP'],
  'Saks': ['NNP'],
  'Sakura': ['NNP'],
  'Sal': ['NNP'],
  'SalFininistas': ['NNP'],
  'Sala': ['NNP'],
  'Salaam': ['FW'],
  'Salads': ['NNS'],
  'Salamander': ['NNP'],
  'Salang': ['NNP'],
  'Salant': ['NNP'],
  'Salaries': ['NNS'],
  'Salary': ['NN'],
  'Salazar': ['NNP'],
  'Sale': ['NNP'],
  'Saledo': ['NNP'],
  'Saleh': ['NNP'],
  'Salem': ['NNP'],
  'Salembier': ['NNP'],
  'Salerno': ['NNP'],
  'Salerno-Sonnenberg': ['NNP'],
  'Sales': ['NNS'],
  'Salesman': ['NN'],
  'Salesmanship': ['NN'],
  'Salespeople': ['NNS'],
  'Salhany': ['NNP'],
  'Salida': ['NNP'],
  'Salim': ['NNP'],
  'Salina': ['NNP'],
  'Salinas': ['NNP'],
  'Salinger': ['NNP'],
  'Salinity': ['NN'],
  'Salins': ['NNP'],
  'Salisbury': ['NNP'],
  'Salish': ['NNP'],
  'Saliva': ['NN'],
  'Salive': ['NNP'],
  'Salk': ['NNP'],
  'Salle': ['NNP'],
  'Sallie': ['NNP'],
  'Sally': ['NNP'],
  'Salman': ['NNP'],
  'Salmon': ['NNP'],
  'Salomon': ['NNP'],
  'Salomonovich': ['NNP'],
  'Salon': ['NNP'],
  'Saloojee': ['NNP'],
  'Saloon': ['NNP'],
  'Salpetriere': ['NNP'],
  'Salsich': ['NNP'],
  'Salt': ['NNP'],
  'Salted': ['JJ'],
  'Salter': ['NNP'],
  'Saltiel': ['NNP'],
  'Saltis-McErlane': ['NNP'],
  'Salton': ['NNP'],
  'Saltonstall': ['NNP'],
  'Salty': ['NNP'],
  'Saltzburg': ['NNP'],
  'Salu': ['NNP'],
  'Salvador': ['NNP'],
  'Salvadoran': ['JJ'],
  'Salvadorans': ['NNS'],
  'Salvagni': ['NNP'],
  'Salvation': ['NNP'],
  'Salvatore': ['NNP'],
  'Salvatori': ['NNP'],
  'Salvesen': ['NNP'],
  'Salwen': ['NNP'],
  'Salyer': ['NNP'],
  'Salzgitter': ['NNP'],
  'Salzman': ['NNP'],
  'Sam': ['NNP'],
  'Samakow': ['NNP'],
  'Samar': ['NNP'],
  'Samara': ['NNP'],
  'Samaritan': ['NNP'],
  'Samaritans': ['NNS'],
  'Samba': ['NNP'],
  'Sambuca': ['NNP'],
  'Same': ['JJ'],
  'Same-store': ['JJ'],
  'Sameness': ['NN'],
  'Samengo-Turner': ['NNP'],
  'Samford': ['NNP'],
  'Sammartini': ['NNP'],
  'Sammi': ['NNP'],
  'Sammy': ['NNP'],
  'Sammye': ['NNP'],
  'Samnick': ['NNP'],
  'Samoa': ['NNP'],
  'Samoilov': ['NNP'],
  'Samovar': ['NNP'],
  'Samper': ['NNP'],
  'Sample': ['NN'],
  'Samples': ['NNS'],
  'Sampson': ['NNP'],
  'Samson': ['NNP'],
  'Samsung': ['NNP'],
  'Samsung-Corning': ['NNP'],
  'Samuel': ['NNP'],
  'Samuels': ['NNP'],
  'Samuelson': ['NNP'],
  'Samurai': ['NNP'],
  'San': ['NNP'],
  'SanAntonio': ['NNP'],
  'Sanaa': ['NNP'],
  'Sanatorium': ['NNP'],
  'Sanchez': ['NNP'],
  'Sancho': ['NNP'],
  'Sancken': ['NNP'],
  'Sanctam': ['NNP'],
  'Sanctions': ['NNS'],
  'Sanctuary': ['NNP'],
  'Sand': ['NNP'],
  'Sandalphon': ['NNP'],
  'Sandalwood': ['NNP'],
  'Sandberg': ['NNP'],
  'Sandburg': ['NNP'],
  'Sandburgs': ['NNPS'],
  'Sande': ['NNP'],
  'Sander': ['NNP'],
  'Sanderoff': ['NNP'],
  'Sanders': ['NNP'],
  'Sanderson': ['NNP'],
  'Sandhills': ['NNP'],
  'Sandhurst': ['NNP'],
  'Sandia': ['NNP'],
  'Sandifer': ['NNP'],
  'Sandinista': ['NNP'],
  'Sandinistas': ['NNPS'],
  'Sandinistas...': [':'],
  'Sandip': ['NNP'],
  'Sandler': ['NNP'],
  'Sandlund': ['NNP'],
  'Sandman': ['NNP'],
  'Sandner': ['NNP'],
  'Sandor': ['NNP'],
  'Sandoz': ['NNP'],
  'Sandra': ['NNP'],
  'Sandro': ['NNP'],
  'Sands': ['NNP'],
  'Sandusky': ['NNP'],
  'Sandwich': ['NNP'],
  'Sandwiched': ['VBN'],
  'Sandwiches': ['NNS'],
  'Sandy': ['NNP'],
  'Sane': ['NNP'],
  'Sanford': ['NNP'],
  'Sang': ['NNP'],
  'Sanga': ['NNP'],
  'Sangallo': ['NNP'],
  'Sangamon': ['NNP'],
  'Sanger': ['NNP'],
  'Sanger-Harris': ['NNP'],
  'Sangetsu': ['NNP'],
  'Sangyo': ['NNP'],
  'Sanitary': ['NNP'],
  'Sanitation': ['NNP'],
  'Sanity': ['NN'],
  'Sanjay': ['NNP'],
  'Sanjiv': ['NNP'],
  'Sanka': ['NNP'],
  'Sankai': ['NNP'],
  'Sankei': ['NNP'],
  'Sankyo': ['NNP'],
  'Sanlandro': ['NNP'],
  'Sann': ['NNP'],
  'Sanraku': ['NNP'],
  'Sans': ['NNP'],
  'Sansom': ['NNP'],
  'Sansome': ['NNP'],
  'Sanson': ['NNP'],
  'Sansone': ['NNP'],
  'Sansui': ['NNP'],
  'Sant': ['NNP'],
  'Sant\'Angelo': ['NNP'],
  'Santa': ['NNP'],
  'Santacruz': ['NNP'],
  'Santamaria': ['NNP'],
  'Santas': ['NNPS'],
  'Santayana': ['NNP'],
  'Sante': ['NNP'],
  'Santiago': ['NNP'],
  'Santiveri': ['NNP'],
  'Santo': ['NNP'],
  'Santovenia': ['NNP'],
  'Santry': ['NNP'],
  'Santucci': ['NNP'],
  'Sanwa': ['NNP'],
  'Sanyo': ['NNP'],
  'Sao': ['NNP'],
  'Saouma': ['NNP'],
  'Sapanski': ['NNP'],
  'Saperstein': ['NNP'],
  'Sapio': ['NNP'],
  'Sapp': ['NNP'],
  'Sappho': ['NNP'],
  'Sapporo': ['NNP'],
  'Sara': ['NNP'],
  'Saracens': ['NNPS'],
  'Sarah': ['NNP'],
  'Saran': ['NNP'],
  'Sarandon': ['NNP'],
  'Sarasate': ['NNP'],
  'Sarason': ['NNP'],
  'Sarasota': ['NNP'],
  'Saratoga': ['NNP'],
  'Sarawak': ['NNP'],
  'Sardanapalus': ['NNP'],
  'Sardi': ['NNP'],
  'Sardina': ['NNP'],
  'Sardinia': ['NNP'],
  'Sargent': ['NNP'],
  'Sark': ['NNP'],
  'Sarkees': ['NNP'],
  'Sarmi': ['NNP'],
  'Sarney': ['NNP'],
  'Sarpsis': ['NNP'],
  'Sarrebourg': ['NNP'],
  'Sarsaparilla': ['NN'],
  'Sarti': ['NNP'],
  'Sartoris': ['NNP'],
  'Sartre': ['NNP'],
  'Sarum': ['NNP'],
  'Sary': ['NNP'],
  'Sary-Shagan': ['NNP'],
  'Sasaki': ['NNP'],
  'Sasea': ['NNP'],
  'Sasebo': ['NNP'],
  'Sasha': ['NNP'],
  'Sashimi': ['FW'],
  'Saskatchewan': ['NNP'],
  'Sass': ['NNP'],
  'Sasser': ['NNP'],
  'Sassy': ['NNP'],
  'Sat': ['VBD'],
  'Satan': ['NNP'],
  'Satanic': ['JJ'],
  'Satellite': ['NNP'],
  'Satellites': ['NNS'],
  'Satires': ['NNPS'],
  'Satis': ['NNP'],
  'Satisfaction': ['NN'],
  'Satisfactory': ['JJ'],
  'Satisfied': ['VBN'],
  'Satisfying': ['VBG'],
  'Satoh': ['NNP'],
  'Satoko': ['NNP'],
  'Satoshi': ['NNP'],
  'Satrum': ['NNP'],
  'Satterfield': ['NNP'],
  'Sattig': ['NNP'],
  'Saturated': ['JJ'],
  'Saturday': ['NNP'],
  'Saturday-night': ['JJ'],
  'Saturdays': ['NNPS'],
  'Saturn': ['NNP'],
  'Sauce': ['NNP'],
  'Saucer': ['NNP'],
  'Saucony': ['NNP'],
  'Saud': ['NNP'],
  'Saudi': ['NNP'],
  'Saudi-American': ['NNP'],
  'Saudis': ['NNPS'],
  'Sauerteig': ['NNP'],
  'Saul': ['NNP'],
  'Saull': ['NNP'],
  'Sault': ['NNP'],
  'Saunder': ['NNP'],
  'Saunders': ['NNP'],
  'Saundra': ['NNP'],
  'Saupiquet': ['NNP'],
  'Sausage': ['NNP'],
  'Sausalito': ['NNP'],
  'Sauter': ['NNP'],
  'Sauter\\\'/Piller\\\'/Percelay': ['NNP'],
  'Sauternes': ['NNP'],
  'Sauvignon': ['NNP'],
  'Savage': ['NNP'],
  'Savageau': ['NNP'],
  'Savaiko': ['NNP'],
  'Savannah': ['NNP'],
  'Savannakhet': ['NNP'],
  'Savath': ['NNP'],
  'Save': ['VB'],
  'Saved': ['NNP'],
  'Savelyeva': ['NNP'],
  'Savers': ['NNP'],
  'Saveth': ['NNP'],
  'Saville': ['NNP'],
  'Savimbi': ['NNP'],
  'Savin': ['NNP'],
  'Saving': ['VBG'],
  'Savings': ['NNP'],
  'Savior': ['NNP'],
  'Saviour': ['NNP'],
  'Savoca': ['NNP'],
  'Savona': ['NNP'],
  'Savonarola': ['NNP'],
  'Savory': ['JJ'],
  'Savoy': ['NNP'],
  'Savoyards': ['NNP'],
  'Saw': ['VBD'],
  'Sawalisch': ['NN'],
  'Sawallisch': ['NNP'],
  'Sawhill': ['NNP'],
  'Sawicki': ['NNP'],
  'Sawnders': ['NNP'],
  'Sawyer': ['NNP'],
  'Saxe': ['NNP'],
  'Saxon': ['NNP'],
  'Saxons': ['NNP'],
  'Saxony': ['NNP'],
  'Saxton': ['NNP'],
  'Say': ['VB'],
  'Sayegh': ['NNP'],
  'Sayers': ['NNP'],
  'Saying': ['VBG'],
  'Sayles': ['NNP'],
  'Saylor': ['NNP'],
  'Sayre': ['NNP'],
  'Says': ['VBZ'],
  'SbCs-type': ['JJ'],
  'Scala': ['NNP'],
  'Scale': ['NNP'],
  'Scalfaro': ['NNP'],
  'Scali': ['NNP'],
  'Scalia': ['NNP'],
  'Scam': ['NN'],
  'Scambio': ['NNP'],
  'Scampini': ['NNP'],
  'Scams': ['NNS'],
  'Scan': ['NNP'],
  'Scana': ['NNP'],
  'Scandal': ['NN'],
  'Scandalios': ['NNP'],
  'Scandanavian': ['JJ'],
  'Scandia': ['NNP'],
  'Scandinavia': ['NNP'],
  'Scandinavian': ['NNP'],
  'Scandinavians': ['NNPS'],
  'Scania': ['NNP'],
  'Scanlon': ['NNP'],
  'Scannell': ['NNP'],
  'Scanner': ['NNP'],
  'Scapin': ['NNP'],
  'Scarborough': ['NNP'],
  'Scarcity': ['NN'],
  'Scare': ['NNP'],
  'Scared': ['VBN'],
  'Scarface': ['NNP'],
  'Scaring': ['VBG'],
  'Scarlatti': ['NNP'],
  'Scarlet': ['NNP'],
  'Scarpia': ['NNP'],
  'Scarsdale': ['NNP'],
  'Scasi': ['NNP'],
  'Scattered': ['VBN'],
  'Scenario': ['NN'],
  'Scenarios': ['NNS'],
  'Scene': ['NNP'],
  'Scenes': ['NNS'],
  'Scenic': ['JJ'],
  'Schaack': ['NNP'],
  'Schaaf': ['NNP'],
  'Schabowski': ['NNP'],
  'Schacht': ['NNP'],
  'Schachter': ['NNP'],
  'Schaefer': ['NNP'],
  'Schaeffer': ['NNP'],
  'Schafer': ['NNP'],
  'Schaffner': ['NNP'],
  'Schall': ['NNP'],
  'Schang': ['NNP'],
  'Schantz': ['NNP'],
  'Schapiro': ['NNP'],
  'Schaumburg': ['NNP'],
  'Schechter': ['NNP'],
  'Schedule': ['NNP'],
  'Scheduled': ['VBN'],
  'Schedules': ['NNS'],
  'Scheetz': ['NNP'],
  'Scheherazade': ['NNP'],
  'Schein': ['NNP'],
  'Schell': ['NNP'],
  'Schelling': ['NNP'],
  'Schellke': ['NNP'],
  'Schemes': ['NNS'],
  'Schenectady': ['NNP'],
  'Schenk': ['NNP'],
  'Schenley': ['NNP'],
  'Scherer': ['NNP'],
  'Schering': ['NNP'],
  'Schering-Plough': ['NNP'],
  'ScheringPlough': ['NN'],
  'Schicchi': ['FW'],
  'Schick': ['NNP'],
  'Schieffelin': ['NNP'],
  'Schiele': ['NNP'],
  'Schiff': ['NNP'],
  'Schiffs': ['NNPS'],
  'Schilling': ['NNP'],
  'Schillinger': ['NNP'],
  'Schimberg': ['NNP'],
  'Schimmel': ['NNP'],
  'Schindler': ['NNP'],
  'Schlang': ['NNP'],
  'Schleiermacher': ['NNP'],
  'Schlek': ['NNP'],
  'Schlemmer': ['NNP'],
  'Schlesinger': ['NNP'],
  'Schleswig-Holstein': ['NNP'],
  'Schley': ['NNP'],
  'Schlieren': ['NNP'],
  'Schlitz': ['NNP'],
  'Schloss': ['NNP'],
  'Schlossberg': ['NNP'],
  'Schlumberger': ['NNP'],
  'Schmalensee': ['NNP'],
  'Schmalma': ['UH'],
  'Schmalzried': ['NNP'],
  'Schmedel': ['NNP'],
  'Schmetterer': ['NNP'],
  'Schmidl-Seeberg': ['NNP'],
  'Schmidlin': ['NNP'],
  'Schmidt': ['NNP'],
  'Schmidt-Chiari': ['NNP'],
  'Schmitt': ['NNP'],
  'Schmolka': ['NNP'],
  'Schmotter': ['NNP'],
  'Schnabel': ['NNP'],
  'Schnabel-Pro': ['NNP'],
  'Schnabelian': ['JJ'],
  'Schnacke': ['NNP'],
  'Schnader': ['NNP'],
  'Schneider': ['NNP'],
  'Schneier': ['NNP'],
  'Schnitz': ['NNP'],
  'Schnitzer': ['NNP'],
  'Schnuck': ['NNP'],
  'Schober': ['NNP'],
  'Schoch': ['NNP'],
  'Schockler': ['NNP'],
  'Schoder': ['NNP'],
  'Schoenberg': ['NNP'],
  'Schoeneman': ['NNP'],
  'Schoenfeld': ['NNP'],
  'Schoenholtz': ['NNP'],
  'Schoeppner': ['NNP'],
  'Scholar': ['NNP'],
  'Scholars': ['NNPS'],
  'Scholarship': ['NN'],
  'Scholastic': ['NNP'],
  'Scholastica': ['NNP'],
  'Scholey': ['NNP'],
  'Schonberg': ['NNP'],
  'Schone': ['NNP'],
  'School': ['NNP'],
  'Schoolmarm': ['NN'],
  'Schools': ['NNP'],
  'Schopenhauer': ['NNP'],
  'Schorr': ['NNP'],
  'Schott': ['NNP'],
  'Schottenstein': ['NNP'],
  'Schotter': ['NNP'],
  'Schraffts': ['NNP'],
  'Schrage': ['NNP'],
  'Schrager': ['NNP'],
  'Schramm': ['NNP'],
  'Schreibman': ['NNP'],
  'Schreyer': ['NNP'],
  'Schrier': ['NNP'],
  'Schroder': ['NNP'],
  'Schroders': ['NNP'],
  'Schroeder': ['NNP'],
  'Schroer': ['NNP'],
  'Schroll': ['NNP'],
  'Schrunk': ['NNP'],
  'Schubert': ['NNP'],
  'Schubert-Beethoven-Mozart': ['JJ'],
  'Schueler': ['NNP'],
  'Schuette': ['NNP'],
  'Schuler': ['NNP'],
  'Schuller': ['NNP'],
  'Schulman': ['NNP'],
  'Schulof': ['NNP'],
  'Schulte': ['NNP'],
  'Schultz': ['NNP'],
  'Schulz': ['NNP'],
  'Schulze': ['NNP'],
  'Schumacher': ['NNP'],
  'Schuman': ['NNP'],
  'Schumann': ['NNP'],
  'Schumer': ['NNP'],
  'Schumpeter': ['NNP'],
  'Schuster': ['NNP'],
  'Schutz': ['NNP'],
  'Schuyler': ['NNP'],
  'Schuylkill': ['NNP'],
  'Schwab': ['NNP'],
  'Schwada': ['NNP'],
  'Schwalbe': ['NNP'],
  'Schwartau': ['NNP'],
  'Schwartz': ['NNP'],
  'Schwartzman': ['NNP'],
  'Schwarz': ['NNP'],
  'Schwarzen': ['FW'],
  'Schwarzenberger': ['NNP'],
  'Schwarzer': ['NNP'],
  'Schwarzkopf': ['NNP'],
  'Schwarzman': ['NNP'],
  'Schwarzwaldklinik': ['NNP'],
  'Schweicker': ['NNP'],
  'Schweiker': ['NNP'],
  'Schweitzer': ['NNP'],
  'Schweitzers': ['NNPS'],
  'Schweiz': ['NNP'],
  'Schweizer': ['NNP'],
  'Schweizerische': ['NNP'],
  'Schwemer': ['NNP'],
  'Schwemm': ['NNP'],
  'Schwengel': ['NNP'],
  'Schweppes': ['NNP'],
  'Schwerdt': ['NNP'],
  'Schwerin': ['NNP'],
  'Schwinn': ['NNP'],
  'Sci-Med': ['NNP'],
  'SciMed': ['NNP'],
  'Science': ['NNP'],
  'Sciences': ['NNPS'],
  'Scientech': ['NNP'],
  'Scientific': ['NNP'],
  'Scientific-Atlanta': ['NNP'],
  'Scientifique': ['NNP'],
  'Scientists': ['NNS'],
  'Scientology': ['NNP'],
  'Scituate': ['NNP'],
  'Scobee-Frazier': ['NNP'],
  'Scofield': ['NNP'],
  'Scolatti': ['NNP'],
  'Scollard': ['NNP'],
  'Scopes': ['NNP'],
  'Scopo': ['NNP'],
  'Score': ['VB'],
  'Scorecard': ['NNP'],
  'Scores': ['NNS'],
  'Scoring': ['NNP'],
  'Scorpio': ['NNP'],
  'Scorpios': ['NNPS'],
  'Scorsese': ['NNP'],
  'Scot': ['NNP'],
  'Scotch': ['NNP'],
  'Scotch-Irish-Scandinavian': ['NNP'],
  'Scotch-and-soda': ['NN'],
  'Scotchgard': ['NNP'],
  'Scotchman': ['NN'],
  'Scotia': ['NNP'],
  'Scotia-McLeod': ['NNP'],
  'Scotian': ['NNP'],
  'Scotland': ['NNP'],
  'Scots': ['NNS'],
  'Scott': ['NNP'],
  'Scottish': ['NNP'],
  'Scottish-born': ['JJ'],
  'Scotto': ['NNP'],
  'Scotts': ['NNP'],
  'Scottsdale': ['NNP'],
  'Scotty': ['NNP'],
  'Scout': ['NNP'],
  'Scouting': ['VBG'],
  'Scouts': ['NNPS'],
  'Scowcroft': ['NNP'],
  'Scrabble': ['NNP'],
  'Scrambling': ['VBG'],
  'Scranton': ['NNP'],
  'Scrap': ['NN'],
  'Scrapings': ['NNS'],
  'Scrapiron': ['NNP'],
  'Scraps': ['NNS'],
  'Scratch': ['NN'],
  'Scratchard': ['NNP'],
  'Scratching': ['VBG'],
  'Screen': ['NN'],
  'Screenwriter': ['NN'],
  'Screvane': ['NNP'],
  'Screw': ['NNP'],
  'Screwed': ['JJ'],
  'Scribe': ['VB'],
  'Scrimgeour': ['NNP'],
  'Scripp': ['NNP'],
  'Scripps': ['NNP'],
  'Scripps-Howard': ['NNP'],
  'Scriptural': ['JJ'],
  'Scripture': ['NNP'],
  'Scriptures': ['NNPS'],
  'Scrivener': ['NNP'],
  'Scrooge-like': ['JJ'],
  'Scrub': ['VB'],
  'Scrum': ['NNP'],
  'Scrupulous': ['JJ'],
  'Scudder': ['NNP'],
  'Scull': ['NNP'],
  'Sculley': ['NNP'],
  'Scully': ['NNP'],
  'Scurlock': ['NNP'],
  'Scwhab': ['NNP'],
  'Scypher': ['NNP'],
  'Se': ['NNP'],
  'Sea': ['NNP'],
  'Sea-Land': ['NNP'],
  'Sea-road': ['NN'],
  'SeaEscape': ['NNP'],
  'SeaFest\\\'/JAC': ['NNP'],
  'Seaboard': ['NNP'],
  'Seaborg': ['NNP'],
  'Seabrook': ['NNP'],
  'Seacomb': ['NNP'],
  'Seafirst': ['NNP'],
  'Seafood': ['NN'],
  'Seaga': ['NNP'],
  'Seagate': ['NNP'],
  'Seagle': ['NNP'],
  'Seagoville': ['NNP'],
  'Seagram': ['NNP'],
  'Seagull': ['NNP'],
  'Seahorse': ['NNP'],
  'Seal': ['NNP'],
  'Sealed': ['NNP'],
  'Sealey': ['NNP'],
  'Sealtest': ['NNP'],
  'Seaman': ['NNP'],
  'Sean': ['NNP'],
  'Seaquarium': ['NNP'],
  'Sear': ['VB'],
  'Searby': ['NNP'],
  'Search': ['VB'],
  'Searching': ['VBG'],
  'Searle': ['NNP'],
  'Searles': ['NNP'],
  'Sears': ['NNP'],
  'Sears-McDonald': ['NNP'],
  'Seas': ['NNP'],
  'Seashore': ['NNP'],
  'Season': ['NN'],
  'Seasonal': ['JJ'],
  'Seasonally': ['RB'],
  'Seasoned': ['JJ'],
  'Seasonings': ['NNPS'],
  'Seasons': ['NNPS'],
  'Seat': ['NN'],
  'Seated': ['VBN'],
  'Seaton': ['NNP'],
  'Seats': ['NNS'],
  'Seattle': ['NNP'],
  'Seattle-First': ['NNP'],
  'Seattle-Northwest': ['NNP'],
  'Seattle-based': ['JJ'],
  'Seattlite': ['NNP'],
  'Seattlites': ['NNS'],
  'Sebastian': ['NNP'],
  'Sec.': ['NN'],
  'Secaucus': ['NNP'],
  'Secesh': ['NNP'],
  'Secilia': ['NNP'],
  'Seco': ['NNP'],
  'Secom': ['NNP'],
  'Secomerica': ['NNP'],
  'Second': ['JJ'],
  'Second-half': ['JJ'],
  'Second-highest': ['JJ'],
  'Second-quarter': ['NNP'],
  'Second-tier': ['JJ'],
  'Secondary': ['JJ'],
  'Secondly': ['RB'],
  'Seconds': ['NNS'],
  'Secord': ['NNP'],
  'Secrecy': ['NN'],
  'Secret': ['NNP'],
  'Secretariat': ['NNP'],
  'Secretariate': ['NNP'],
  'Secretaries': ['NNPS'],
  'Secretary': ['NNP'],
  'Secretary-General': ['NNP'],
  'Secretary-designate': ['NNP'],
  'Secretion': ['NN'],
  'Section': ['NN'],
  'Sections': ['NNS'],
  'Sector': ['NNP'],
  'Secular': ['JJ'],
  'Secure': ['VB'],
  'Secured': ['JJ'],
  'Securities': ['NNPS'],
  'Securities-trading': ['JJ'],
  'Security': ['NNP'],
  'Security-Connecticut': ['NNP'],
  'Secutities': ['NNPS'],
  'Sedan': ['NNP'],
  'Seddon': ['NNP'],
  'Sedgwick': ['NNP'],
  'Sedimentation': ['NN'],
  'Sedona': ['NNP'],
  'Seduction': ['NN'],
  'See': ['VB'],
  'See-through': ['JJ'],
  'Seebohm': ['NNP'],
  'Seed': ['NN'],
  'Seeds': ['NNS'],
  'Seeing': ['VBG'],
  'Seek': ['NNP'],
  'Seeking': ['VBG'],
  'Seekonk': ['NNP'],
  'Seeks': ['VBZ'],
  'Seelbinder': ['NNP'],
  'Seelenfreund': ['NNP'],
  'Seeley': ['NNP'],
  'Seelig': ['NNP'],
  'Seeming': ['VBG'],
  'Seemingly': ['RB'],
  'Seems': ['VBZ'],
  'Seen': ['VBN'],
  'Seerey': ['NNP'],
  'Sees': ['VBZ'],
  'Sega': ['NNP'],
  'Segal': ['NNP'],
  'Segalas': ['NNP'],
  'Segall': ['NNP'],
  'Segar': ['NNP'],
  'Seger': ['NNP'],
  'Seger-Elvekrog': ['NNP'],
  'Segnar': ['NNP'],
  'Segovia': ['NNP'],
  'Segundo': ['NNP'],
  'Segur': ['NNP'],
  'Segura': ['NNP'],
  'Seib': ['NNP'],
  'Seidel': ['NNP'],
  'Seiders': ['NNP'],
  'Seidler': ['NNP'],
  'Seidman': ['NNP'],
  'Seife': ['NNP'],
  'Seifert': ['NNP'],
  'Seigel': ['NNP'],
  'Seigner': ['NNP'],
  'Seiki': ['NNP'],
  'Seiko': ['NNP'],
  'Seikosha': ['NNP'],
  'Seiler': ['NNP'],
  'Seimei': ['NNP'],
  'Seiren': ['NNP'],
  'Seisakusho': ['NNP'],
  'Seismographic': ['NNP'],
  'Seita': ['NNP'],
  'Seitz': ['NNP'],
  'Seiyu': ['NNP'],
  'Seize': ['NNP'],
  'Seizes': ['VBZ'],
  'Seizin': ['VBG'],
  'Seizing': ['VBG'],
  'Sejm': ['NNP'],
  'Sekel': ['NNP'],
  'Sekisui': ['NNP'],
  'Seko': ['NNP'],
  'Selassie': ['NNP'],
  'Selavo': ['NNP'],
  'Selden': ['NNP'],
  'Seldes': ['NNP'],
  'Seldom': ['RB'],
  'Select': ['NNP'],
  'Selected': ['JJ'],
  'Selecting': ['VBG'],
  'Selection': ['NN'],
  'Selections': ['NNS'],
  'Selective': ['JJ'],
  'Selectives': ['NNPS'],
  'Selectmen': ['NNS'],
  'Selectol': ['NNP'],
  'Selena': ['NNP'],
  'Self': ['NNP'],
  'Self-Government': ['NNP'],
  'Self-censorship': ['NN'],
  'Self-contained': ['JJ'],
  'Self-criticism': ['NN'],
  'Self-designated': ['JJ'],
  'Self-expression': ['NN'],
  'Self-sufficiency': ['NN'],
  'Selig': ['NNP'],
  'Seligman': ['NNP'],
  'Selkin': ['NNP'],
  'Selkirk': ['NNP'],
  'Selkirkers': ['NNS'],
  'Sell': ['VB'],
  'Sellars': ['NNP'],
  'Seller': ['NN'],
  'Sellers': ['NNP'],
  'Selling': ['VBG'],
  'Sells': ['NNP'],
  'Selma': ['NNP'],
  'Selman': ['NNP'],
  'Selmer-Sande': ['NNP'],
  'Seltzer': ['NNP'],
  'Selve': ['NNP'],
  'Selway-Swift': ['NNP'],
  'Selwyn': ['NNP'],
  'Selz': ['NNP'],
  'Semegran': ['NNP'],
  'Semel': ['NNP'],
  'Semenov': ['NNP'],
  'Semi-Tech': ['NNP'],
  'Semiconductor': ['NNP'],
  'Semiconductors': ['NNPS'],
  'Semifinished': ['VBN'],
  'Seminar': ['NNP'],
  'Seminario': ['NNP'],
  'Seminary': ['NNP'],
  'Seminole': ['NNP'],
  'Semiramis': ['NNP'],
  'Semmel': ['NNP'],
  'Semmelman': ['NNP'],
  'Semmes': ['NNP'],
  'Semon': ['NNP'],
  'Semple-Lisle': ['NNP'],
  'Semra': ['NNP'],
  'Sen': ['NNP'],
  'Sen.': ['NNP'],
  'Senate': ['NNP'],
  'Senate-House': ['NNP'],
  'Senate-backed': ['JJ'],
  'Senate-passed': ['JJ'],
  'Senator': ['NNP'],
  'Senators': ['NNS'],
  'Send': ['VB'],
  'Sendler': ['NNP'],
  'Sener': ['NNP'],
  'Senesac': ['NNP'],
  'Senese': ['NNP'],
  'Seng': ['NNP'],
  'Senior': ['JJ'],
  'Seniors': ['NNS'],
  'Senium': ['FW'],
  'Senk': ['NNP'],
  'Senor': ['NNP'],
  'Senora': ['NNP'],
  'Senorita': ['NNP'],
  'Sens.': ['NNP'],
  'Sense': ['NN'],
  'Sensenbrenner': ['NNP'],
  'Senshukai': ['NNP'],
  'Sensibility': ['NN'],
  'Sensing': ['VBG'],
  'Sensitive': ['JJ'],
  'Sensor': ['NNP'],
  'Sent': ['VBN'],
  'Sentelle': ['NNP'],
  'Sentence': ['NN'],
  'Sentences': ['NNS'],
  'Sentencing': ['NN'],
  'Sentiment': ['NN'],
  'Sentiments': ['NNS'],
  'Sentor': ['NNP'],
  'Sentra': ['NNP'],
  'Sentry': ['NNP'],
  'Seoul': ['NNP'],
  'Seoul-Moscow': ['NNP'],
  'Separate': ['JJ'],
  'Separately': ['RB'],
  'Separating': ['VBG'],
  'Separation': ['NN'],
  'Sept': ['NNP'],
  'Sept.': ['NNP'],
  'Sept.1': ['NNP'],
  'Sept.30': ['CD'],
  'September': ['NNP'],
  'September-October': ['NNP'],
  'Sepulveda': ['NNP'],
  'Sequa': ['NNP'],
  'Sequent': ['NNP'],
  'Sequester': ['NN'],
  'Sequoia': ['NNP'],
  'Serafin': ['NNP'],
  'Serbantian': ['NNP'],
  'Serenade': ['NNP'],
  'Serene': ['NNP'],
  'Serenissimus': ['NNP'],
  'Serenity': ['NN'],
  'Serex': ['NNP'],
  'Serge': ['NNP'],
  'Sergeant': ['NNP'],
  'Sergei': ['NNP'],
  'Sergio': ['NNP'],
  'Sergiusz': ['NNP'],
  'Serial': ['JJ'],
  'Series': ['NNP'],
  'Serieuses': ['NNP'],
  'Serif': ['NNP'],
  'Serious': ['JJ'],
  'Serkin': ['NNP'],
  'Serlin': ['NNP'],
  'Sermon': ['NN'],
  'Serological': ['JJ'],
  'Serpentine': ['NNP'],
  'Serra': ['NNP'],
  'Serrana': ['NNP'],
  'Serum': ['NN'],
  'Serv-Air': ['NNP'],
  'Servanda': ['FW'],
  'Servant': ['NNP'],
  'ServantCor': ['NNP'],
  'Servatius': ['NNP'],
  'Serve': ['VB'],
  'Serve-Air': ['NNP'],
  'Served': ['VBN'],
  'Serves': ['VBZ'],
  'Service': ['NNP'],
  'ServiceMaster': ['NNP'],
  'Services': ['NNPS'],
  'Services\\\'/Japan': ['NNP'],
  'Servicios': ['NNP'],
  'Servifilm': ['NNP'],
  'Serving': ['VBG'],
  'Servive': ['NNP'],
  'Sesame': ['NNP'],
  'Sesit': ['NNP'],
  'Seso': ['NNP'],
  'Sesshu': ['NNP'],
  'Session': ['NN'],
  'Sessions': ['NNP'],
  'Set': ['VB'],
  'Seth': ['NNP'],
  'Sethness': ['NNP'],
  'Seto': ['NNP'],
  'Seton': ['NNP'],
  'Sets': ['NNS'],
  'Setsuo': ['NNP'],
  'Setter': ['NN'],
  'Setting': ['VBG'],
  'Settle': ['VB'],
  'Settled': ['VBN'],
  'Settlement': ['NN'],
  'Settlements': ['NNP'],
  'Seung': ['NNP'],
  'Seurat': ['NNP'],
  'Seven': ['CD'],
  'Seven-Eleven': ['NNP'],
  'Seven-Up': ['NNP'],
  'Seventeen': ['CD'],
  'Seventeenth': ['JJ'],
  'Seventh': ['NNP'],
  'Seventies': ['NNPS'],
  'Seventy': ['CD'],
  'Seventy-fourth': ['NNP'],
  'Seventy-nine': ['JJ'],
  'Seventy-seven': ['JJ'],
  'Seventy-six': ['JJ'],
  'Severa': ['NNP'],
  'Several': ['JJ'],
  'Severe': ['JJ'],
  'Severence': ['NNP'],
  'Severna': ['NNP'],
  'Severs': ['NNP'],
  'Seveso': ['NNP'],
  'Sevigli': ['NNP'],
  'Sevigny': ['NNP'],
  'Seville': ['NNP'],
  'Sevin': ['NN'],
  'Sewage': ['NNP'],
  'Sewanee': ['NNP'],
  'Seward': ['NNP'],
  'Sewell': ['NNP'],
  'Sewer': ['NNP'],
  'Sewickley': ['NNP'],
  'Sewing': ['NNP'],
  'Sex': ['NN'],
  'Sexism': ['NN'],
  'Sextet': ['NNP'],
  'Sexton': ['NN'],
  'Sextuor': ['NNP'],
  'Sexual': ['NNP'],
  'Sexy': ['JJ'],
  'Seydoux': ['NNP'],
  'Seymour': ['NNP'],
  'Seynes': ['NNP'],
  'Sez': ['NNP'],
  'Sforzt': ['NNP'],
  'Sgt.': ['NNP'],
  'Sha.': ['NNP'],
  'Shabbat': ['NNP'],
  'Shack': ['NNP'],
  'Shad': ['NNP'],
  'Shade': ['NNP'],
  'Shades': ['NNP'],
  'Shadow': ['NNP'],
  'Shady': ['NNP'],
  'Shaefer': ['NNP'],
  'Shaevitz': ['NNP'],
  'Shafer': ['NNP'],
  'Shaffer': ['NNP'],
  'Shaffner': ['NN'],
  'Shafroth': ['NNP'],
  'Shagan': ['NNP'],
  'Shah': ['NNP'],
  'Shahal': ['NNP'],
  'Shahn': ['NNP'],
  'Shahon': ['NNP'],
  'Shahrabani': ['NNP'],
  'Shahrokh': ['NNP'],
  'Shaiken': ['NNP'],
  'Shak.': ['NNP'],
  'Shakarchi': ['NNP'],
  'Shake': ['VB'],
  'Shaken': ['VBN'],
  'Shaker': ['NNP'],
  'Shakes': ['VBZ'],
  'Shakespeare': ['NNP'],
  'Shakespearean': ['JJ'],
  'Shakespearian': ['JJ'],
  'Shaking': ['VBG'],
  'Shakshuki': ['NNP'],
  'Shakya': ['NNP'],
  'Shale': ['NNP'],
  'Shales': ['NNP'],
  'Shall': ['MD'],
  'Shalom': ['NNP'],
  'Shalov': ['NNP'],
  'Shame': ['NNP'],
  'Shamir': ['NNP'],
  'Shampoo': ['NNP'],
  'Shamrock': ['NNP'],
  'Shamu': ['NNP'],
  'Shan': ['NNP'],
  'Shandong': ['NNP'],
  'Shane': ['NNP'],
  'Shanghai': ['NNP'],
  'Shanghai-born': ['JJ'],
  'Shangkun': ['NNP'],
  'Shangri-La': ['NNP'],
  'Shank': ['NNP'],
  'Shanken': ['NNP'],
  'Shanker': ['NNP'],
  'Shann': ['NNP'],
  'Shannon': ['NNP'],
  'Shansi': ['NNP'],
  'Shanties': ['NNPS'],
  'Shantou': ['NNP'],
  'Shantung': ['NNP'],
  'Shantytowns': ['NNS'],
  'Shantz': ['NNP'],
  'Shanyun': ['NNP'],
  'Shape': ['NNP'],
  'Shaped': ['JJ'],
  'Shapes': ['NNS'],
  'Shapiro': ['NNP'],
  'Shapovalov': ['NNP'],
  'Shardlow': ['NNP'],
  'Share': ['NN'],
  'ShareData': ['NNP'],
  'Sharecropping': ['NN'],
  'Shared': ['NNP'],
  'Shareholder': ['NN'],
  'Shareholders': ['NNS'],
  'Sharer': ['NNP'],
  'Shares': ['NNS'],
  'SharesBase': ['NNP'],
  'Sharfman': ['NNP'],
  'Shari': ['NNP'],
  'Sharing': ['VBG'],
  'Sharkey': ['NNP'],
  'Sharon': ['NNP'],
  'Sharp': ['NNP'],
  'Sharp-witted': ['JJ'],
  'Sharpe': ['NNP'],
  'Sharpest': ['JJS'],
  'Sharply': ['RB'],
  'Sharps': ['NNP'],
  'Sharpshooter': ['NNP'],
  'Sharpshooters': ['NNPS'],
  'Sharrock': ['NNP'],
  'Shartzer': ['NNP'],
  'Shatilov': ['NNP'],
  'Shattered': ['JJ'],
  'Shattuck': ['NNP'],
  'Shaughnessy': ['NNP'],
  'Shaver': ['NNP'],
  'Shaving': ['NNP'],
  'Shaw': ['NNP'],
  'Shaw-Crier': ['NNP'],
  'Shaw-Walker': ['NNP'],
  'Shawano': ['NNP'],
  'Shawl': ['NN'],
  'Shawmut': ['NNP'],
  'Shawn': ['NNP'],
  'Shawnee': ['NNP'],
  'Shawomet': ['NNP'],
  'Shay': ['NNP'],
  'Shayne': ['NNP'],
  'Shayol': ['NNP'],
  'Shays': ['NNP'],
  'Shcherbitsky': ['NNP'],
  'She': ['PRP'],
  'She\'arim': ['NNP'],
  'Shea': ['NNP'],
  'Shealy': ['NNP'],
  'Shearing': ['NNP'],
  'Shearman': ['NNP'],
  'Shearn': ['NNP'],
  'Shearon': ['NNP'],
  'Shearson': ['NNP'],
  'Sheboygan': ['NNP'],
  'Sheckley': ['NNP'],
  'Shedding': ['VBG'],
  'Sheehan': ['NNP'],
  'Sheehy': ['NNP'],
  'Sheen': ['NNP'],
  'Sheena': ['NNP'],
  'Sheep': ['NNP'],
  'Sheer': ['NNP'],
  'Sheeran': ['NNP'],
  'Sheet': ['NNP'],
  'Sheeting': ['NN'],
  'Sheets': ['NNP'],
  'Sheffield': ['NNP'],
  'Shegog': ['NNP'],
  'Sheik': ['NNP'],
  'Sheila': ['NNP'],
  'Sheinberg': ['NNP'],
  'Sheindlin': ['NNP'],
  'Sheiner': ['NNP'],
  'Shelagh': ['NNP'],
  'Shelby': ['NNP'],
  'Shelbyville': ['NNP'],
  'Sheldon': ['NNP'],
  'Shell': ['NNP'],
  'Sheller-Globe': ['NNP'],
  'Shelley': ['NNP'],
  'Shellpot': ['NNP'],
  'Shelly': ['NNP'],
  'Shelter': ['NN'],
  'Shelters': ['NNPS'],
  'Shelton': ['NNP'],
  'Shemiatenkov': ['NNP'],
  'Shemona': ['NNP'],
  'Shenandoah': ['NNP'],
  'Shensi': ['NNP'],
  'Shenzhen': ['NNP'],
  'Shep': ['NNP'],
  'Shepard': ['NNP'],
  'Shepherd': ['NNP'],
  'Shepherds': ['NNPS'],
  'Shepperd': ['NNP'],
  'Sheraton': ['NNP'],
  'Sheraton-Biltmore': ['NNP'],
  'Sheraton-Dallas': ['NNP'],
  'Sheraton-Pan': ['NNP'],
  'Sherblom': ['NNP'],
  'Shere': ['NNP'],
  'Sheremetyevo': ['NNP'],
  'Sheri': ['NNP'],
  'Sheridan': ['NNP'],
  'Sheriff': ['NNP'],
  'Sherlock': ['NNP'],
  'Sherlund': ['NNP'],
  'Sherman': ['NNP'],
  'Sherren': ['NNP'],
  'Sherrie': ['NNP'],
  'Sherrill': ['NNP'],
  'Sherry': ['NNP'],
  'Sherwin': ['NNP'],
  'Sherwin-Williams': ['NNP'],
  'Sherwood': ['NNP'],
  'Shevack': ['NNP'],
  'Shevardnadze': ['NNP'],
  'Shevchenko': ['NNP'],
  'Shh': ['UH'],
  'Shi\'ite': ['NNP'],
  'Shicoff': ['NNP'],
  'Shidler': ['NNP'],
  'Shield': ['NNP'],
  'Shields': ['NNP'],
  'Shietz': ['NNP'],
  'Shiflett': ['NNP'],
  'Shiftan': ['NNP'],
  'Shifte': ['NNP'],
  'Shige': ['NNP'],
  'Shigeru': ['NNP'],
  'Shigezo': ['NNP'],
  'Shih': ['NNP'],
  'Shiite': ['NNP'],
  'Shiites': ['NNPS'],
  'Shijie': ['NNP'],
  'Shikotan': ['NNP'],
  'Shilling': ['NNP'],
  'Shillong': ['NNP'],
  'Shiloh': ['NNP'],
  'Shima': ['NNP'],
  'Shimbun': ['NNP'],
  'Shimizu': ['NNP'],
  'Shimon': ['NNP'],
  'Shimson': ['NNP'],
  'Shin': ['NNP'],
  'Shin-Daiwa': ['NNP'],
  'Shinagawa': ['NNP'],
  'Shinbun': ['NNP'],
  'Shine': ['NNP'],
  'Shing': ['NNP'],
  'Shingles': ['NNS'],
  'Shining': ['NNP'],
  'Shinn': ['NNP'],
  'Shinpan': ['NNP'],
  'Shintaro': ['NNP'],
  'Shintoism': ['NNP'],
  'Shinton': ['NNP'],
  'Shiny': ['NNP'],
  'Shionogi': ['NNP'],
  'Shioya': ['NNP'],
  'Ship': ['NNP'],
  'Shipbuilders': ['NNPS'],
  'Shipbuilding': ['NNP'],
  'Shipley': ['NNP'],
  'Shipman': ['NNP'],
  'Shipments': ['NNS'],
  'Shippers': ['NNS'],
  'Shippey': ['NNP'],
  'Shippin': ['VB'],
  'Shipping': ['NNP'],
  'Shippings': ['NNS'],
  'Ships': ['NNS'],
  'Shipston': ['NNP'],
  'Shipyard': ['NNP'],
  'Shipyards': ['NNP'],
  'Shira': ['NNP'],
  'Shiremanstown': ['NNP'],
  'Shirer': ['NNP'],
  'Shires': ['NNP'],
  'Shirl': ['NNP'],
  'Shirley': ['NNP'],
  'Shirt': ['NNP'],
  'Shirwen': ['NNP'],
  'Shiseido': ['NNP'],
  'Shit': ['NN'],
  'Shitts': ['NNP'],
  'Shiu-Lok': ['NNP'],
  'Shivering': ['VBG'],
  'Shivers': ['NNP'],
  'Shizue': ['NNP'],
  'Shlaes': ['NNP'],
  'Shlenker': ['NNP'],
  'Shlomo': ['NNP'],
  'Shoals': ['NNP'],
  'Shochiku': ['NNP'],
  'Shochiku-Fuji': ['NNP'],
  'Shock': ['NN'],
  'Shocked': ['VBN'],
  'Shoe': ['NNP'],
  'Shoemaker': ['NNP'],
  'Shoettle': ['NNP'],
  'Shogun': ['NNP'],
  'Shoichi': ['NNP'],
  'Shoichiro': ['NNP'],
  'Shokubai': ['NNP'],
  'Sholom': ['NNP'],
  'Shoney': ['NNP'],
  'Shook': ['VBD'],
  'Shooter': ['NNP'],
  'Shootin': ['VBG'],
  'Shooting': ['NN'],
  'Shop': ['NNP'],
  'Shopkorn': ['NNP'],
  'Shoppers': ['NNS'],
  'Shoppes': ['NNP'],
  'Shopping': ['NNP'],
  'Shoppsers': ['NNS'],
  'Shops': ['NNPS'],
  'Shore': ['NNP'],
  'Shoreline': ['NN'],
  'Shores': ['NNP'],
  'Shorn': ['VBN'],
  'Short': ['JJ'],
  'Short-sellers': ['NNP'],
  'Short-term': ['JJ'],
  'Shortage': ['NN'],
  'Shortageflation': ['NN'],
  'Shortages': ['NNS'],
  'Shortcuts': ['NNS'],
  'Shorted': ['JJ'],
  'Shortening': ['VBG'],
  'Shorter': ['JJR'],
  'Shorting': ['NN'],
  'Shortly': ['RB'],
  'Shortridge': ['NNP'],
  'Shortstop': ['NNP'],
  'Shostakovich': ['NNP'],
  'Shot': ['VBN'],
  'Shotgun-type': ['JJ'],
  'Shotguns': ['NNS'],
  'Shots': ['NNS'],
  'Shotwell': ['NNP'],
  'Should': ['MD'],
  'Shoulder': ['NN'],
  'Shouldering': ['VBG'],
  'Shoup': ['NNP'],
  'Shoupe': ['NNP'],
  'Shout': ['VB'],
  'Shoutout': ['VB'],
  'Show': ['NNP'],
  'ShowBiz': ['NNP'],
  'Showa': ['NNP'],
  'Showalter': ['NNP'],
  'Showbiz': ['NNP'],
  'Showdown': ['NNP'],
  'Showers': ['NNP'],
  'Showing': ['VBG'],
  'Showmanship': ['NN'],
  'Showrooms': ['NNS'],
  'Shows': ['NNS'],
  'Showtime': ['NNP'],
  'Shreveport': ['NNP'],
  'Shrewd': ['JJ'],
  'Shrewsbury': ['NNP'],
  'Shribman': ['NNP'],
  'Shrieves': ['NNP'],
  'Shrine': ['NNP'],
  'Shrinking': ['VBG'],
  'Shriver': ['NNP'],
  'Shroeder': ['NNP'],
  'Shrontz': ['NNP'],
  'Shropshire': ['NNP'],
  'Shrove': ['NNP'],
  'Shrubs': ['NNS'],
  'Shrug': ['NN'],
  'Shrugged': ['VBN'],
  'Shrugs': ['NNP'],
  'Shrum': ['NNP'],
  'Shtern': ['NNP'],
  'Shtromas': ['NNP'],
  'Shu': ['NNP'],
  'Shu-tt': ['VB'],
  'Shucks': ['UH'],
  'Shugart': ['NNP'],
  'Shui': ['NNP'],
  'Shuiski': ['NNP'],
  'Shukri': ['NNP'],
  'Shulman': ['NNP'],
  'Shultis': ['NNP'],
  'Shultz': ['NNP'],
  'Shuman': ['NNP'],
  'Shun': ['NNP'],
  'Shunted': ['VBN'],
  'Shupe': ['NNP'],
  'Shurtleff': ['NNP'],
  'Shut': ['VB'],
  'Shutter': ['NNP'],
  'Shuttle': ['NNP'],
  'Shuwa': ['NNP'],
  'Shuxian': ['NNP'],
  'Shuz': ['NNP'],
  'Shvartzer': ['NNP'],
  'Shvets': ['NNP'],
  'Shy': ['JJ'],
  'Shycon': ['NNP'],
  'Shylock': ['NNP'],
  'Shylockian': ['JJ'],
  'Si': ['NNP'],
  'SiH': ['NN'],
  'Siad': ['NNP'],
  'Siam': ['NNP'],
  'Siamese': ['NNP'],
  'Siano': ['NNP'],
  'Sibaral': ['NNP'],
  'Siberia': ['NNP'],
  'Siberian': ['JJ'],
  'Sibley': ['NNP'],
  'Sibling': ['NN'],
  'Sibly': ['NNP'],
  'Sibra': ['NNP'],
  'Sibson': ['NNP'],
  'Sibylla': ['NNP'],
  'Sibyls': ['NNPS'],
  'Sic': ['FW'],
  'Sichuan': ['NNP'],
  'Sicilian': ['JJ'],
  'Siciliana': ['NNP'],
  'Sicilians': ['NNS'],
  'Sicily': ['NNP'],
  'Sick': ['NNP'],
  'Sickness': ['NN'],
  'Sicurella': ['NNP'],
  'Sid': ['NNP'],
  'Sidak': ['NNP'],
  'Siddeley': ['NNP'],
  'Siddo': ['NNP'],
  'Side': ['NNP'],
  'Sidecar': ['NN'],
  'Sidekick': ['NNP'],
  'Sider': ['NNP'],
  'Sides': ['NNP'],
  'Sidestepping': ['VBG'],
  'Sidewalk': ['NNP'],
  'Sidewalks': ['NNPS'],
  'Sidhpur': ['NNP'],
  'Sidley': ['NNP'],
  'Sidley-Ashurst': ['NNP'],
  'Sidney': ['NNP'],
  'Sidorenko': ['NNP'],
  'Sidoti': ['NNP'],
  'Sidra': ['NNP'],
  'Sie': ['FW'],
  'Siebel': ['NNP'],
  'Siebern': ['NNP'],
  'Siebert': ['NNP'],
  'Sieckman': ['NNP'],
  'Siecle': ['NNP'],
  'Siecles': ['NNPS'],
  'Siedenburg': ['NNP'],
  'Siedlungs': ['NNP'],
  'Siegal': ['NNP'],
  'Siege': ['NNP'],
  'Siegel': ['NNP'],
  'Siegfried': ['NNP'],
  'Siegler': ['NNP'],
  'Siegman': ['NNP'],
  'Siemaszko': ['NNP'],
  'Siemens': ['NNP'],
  'Siemens-GEC-Plessey': ['NNP'],
  'Siemienas': ['NNP'],
  'Siena': ['NNP'],
  'Sienkiewicz': ['NNP'],
  'Siepi': ['NNP'],
  'Sierra': ['NNP'],
  'Sierras': ['NNPS'],
  'Sietsma': ['NNP'],
  'Sieux': ['NNP'],
  'Sievers': ['NNP'],
  'Siewert': ['NNP'],
  'Sifco': ['NNP'],
  'Sifton': ['NNP'],
  'Sigemund': ['NNP'],
  'Sighing': ['VBG'],
  'Sighting': ['VBG'],
  'Sigler': ['NNP'],
  'Sigma': ['NNP'],
  'Sigman': ['NNP'],
  'Sigmen': ['NNP'],
  'Sigmund': ['NNP'],
  'Sign': ['NNP'],
  'Signal': ['NNP'],
  'Signature': ['NNP'],
  'Signed': ['VBN'],
  'Signers': ['NNS'],
  'Signet': ['NNP'],
  'Significance': ['NN'],
  'Significant': ['JJ'],
  'Significantly': ['RB'],
  'Significants': ['NNS'],
  'Signor': ['NNP'],
  'Signora': ['FW'],
  'Signore': ['NNP'],
  'Signs': ['NNS'],
  'Sigoloff': ['NNP'],
  'Sigourney': ['NNP'],
  'Sigurd': ['NNP'],
  'Sihanouk': ['NNP'],
  'Sik': ['NNP'],
  'Sikes': ['NNP'],
  'Sikh': ['NNP'],
  'Sikhs': ['NNPS'],
  'Sikkim': ['NNP'],
  'Sikorski': ['NNP'],
  'Silas': ['NNP'],
  'Silber': ['NNP'],
  'Silberberg': ['NNP'],
  'Silberman': ['NNP'],
  'Silbermann': ['NNP'],
  'Silbert': ['NNP'],
  'Silence': ['NN'],
  'Silences': ['NNS'],
  'Silent': ['NNP'],
  'Silently': ['RB'],
  'Silesia': ['NNP'],
  'Silicon': ['NNP'],
  'Silk': ['NNP'],
  'Silkworms': ['NNP'],
  'Sill': ['NNP'],
  'Sills': ['NNP'],
  'Silly': ['NNP'],
  'Silone': ['NNP'],
  'Silva': ['NNP'],
  'Silver': ['NN'],
  'Silvercrest': ['NNP'],
  'Silverman': ['NNP'],
  'Silvers': ['NNP'],
  'Silvershoe': ['NNP'],
  'Silverstein': ['NNP'],
  'Silvio': ['NNP'],
  'Sim': ['NNP'],
  'Simai': ['NNP'],
  'Simak': ['NNP'],
  'Simat': ['NNP'],
  'Simba': ['NNP'],
  'Simca': ['NNP'],
  'Simeon': ['NNP'],
  'Simes': ['NNP'],
  'Similar': ['JJ'],
  'Similarities': ['NNS'],
  'Similarly': ['RB'],
  'Simmel': ['NNP'],
  'Simmer': ['VB'],
  'Simmon': ['NNP'],
  'Simmons': ['NNP'],
  'Simmonsville': ['NNP'],
  'Simms': ['NNP'],
  'Simon': ['NNP'],
  'Simonds': ['NNP'],
  'Simonds-Gooding': ['NNP'],
  'Simonelli': ['NNP'],
  'Simonson': ['NNP'],
  'Simpkins': ['NNP'],
  'Simple': ['JJ'],
  'Simplesse': ['NNP'],
  'Simplex': ['JJ'],
  'Simplification': ['NN'],
  'Simplot': ['NNP'],
  'Simply': ['RB'],
  'Simpson': ['NNP'],
  'Simpsons': ['NNPS'],
  'Sims': ['NNP'],
  'Simsbury': ['NNP'],
  'Simulated': ['JJ'],
  'Simulation': ['NN'],
  'Simulator': ['NNP'],
  'Simultaneous': ['JJ'],
  'Simultaneously': ['RB'],
  'Sin': ['NNP'],
  'Sin\\\'/Your': ['NNP'],
  'Sinai': ['NNP'],
  'Sinan': ['NNP'],
  'Sinatra': ['NNP'],
  'Since': ['IN'],
  'Sincere': ['NNP'],
  'Sinclair': ['NNP'],
  'Sindona': ['NNP'],
  'Sinemet': ['NNP'],
  'Sinfonia': ['NNP'],
  'Sinfonica': ['NNP'],
  'Sing': ['NNP'],
  'Singapore': ['NNP'],
  'Singer': ['NNP'],
  'Singh': ['NNP'],
  'Singin': ['VBG'],
  'Singing': ['VBG'],
  'Single': ['NNP'],
  'Single-A-2': ['JJ'],
  'Single-A-3': ['JJ'],
  'Single-cell': ['JJ'],
  'Single-color': ['JJ'],
  'Single-occupancy': ['NN'],
  'Single-seeded': ['JJ'],
  'Single-subject': ['JJ'],
  'Singles': ['NNS'],
  'Singletary': ['NNP'],
  'Singleton': ['NNP'],
  'Sinhalese': ['JJ'],
  'Sinhalese-dominated': ['JJ'],
  'Sinhalese.': ['JJ'],
  'Siniscal': ['NNP'],
  'Sink': ['NNP'],
  'Sinkula': ['NNP'],
  'Sinner': ['NNP'],
  'Sino-British': ['JJ'],
  'Sino-Soviet': ['JJ'],
  'Sino-U.S.': ['JJ'],
  'Sino-foreign': ['JJ'],
  'Sinopoli': ['NNP'],
  'Sintel': ['NNP'],
  'Sintered': ['VBN'],
  'Sinton': ['NN'],
  'Sinyard': ['NNP'],
  'Sioux': ['NNP'],
  'Sipping': ['VBG'],
  'Sippl': ['NNP'],
  'Sir': ['NNP'],
  'Sirinjani': ['NNP'],
  'Sirot': ['NNP'],
  'Sirota': ['NNP'],
  'Sirowitz': ['NNP'],
  'Sirrine': ['NNP'],
  'Sirs': ['NNPS'],
  'Sis': ['NNP'],
  'Sischy': ['NNP'],
  'Sisk': ['NNP'],
  'Sisley': ['NNP'],
  'Sistemas': ['NNP'],
  'Sister': ['NN'],
  'Sisters': ['NNP'],
  'Sistine': ['NNP'],
  'Sisulu': ['NNP'],
  'Sit': ['VB'],
  'Sitco': ['NNP'],
  'Site': ['NNP'],
  'Sites': ['NNS'],
  'Sithe': ['NNP'],
  'Siti': ['NNP'],
  'Sitter': ['NNP'],
  'Sitting': ['VBG'],
  'Situated': ['VBN'],
  'Situation': ['NNP'],
  'Situations': ['NNS'],
  'Situs': ['NN'],
  'Sitwell': ['NNP'],
  'Sitz': ['NNP'],
  'Siva': ['NNP'],
  'Six': ['CD'],
  'Six-Day': ['NNP'],
  'Six-month': ['JJ'],
  'Six-year-old': ['JJ'],
  'Sixteen': ['CD'],
  'Sixteenth': ['NNP'],
  'Sixth': ['NNP'],
  'Sixties': ['NNPS'],
  'Sixty': ['CD'],
  'Sixty-eighth': ['NNP'],
  'Sixty-five': ['JJ'],
  'Sixty-seven': ['CD'],
  'Sizable': ['JJ'],
  'Size': ['NN'],
  'Sizova': ['NNP'],
  'Sizwe': ['NNP'],
  'Sizzling': ['JJ'],
  'Skadden': ['NNP'],
  'Skaggs': ['NNP'],
  'Skala': ['NNP'],
  'Skandia': ['NNP'],
  'Skandinaviska': ['NNP'],
  'Skanska': ['NNP'],
  'Skase': ['NNP'],
  'Skates': ['NNP'],
  'Skating': ['NNP'],
  'Skeletal': ['JJ'],
  'Skelly': ['NNP'],
  'Skelton': ['NNP'],
  'Skeoch': ['NNP'],
  'Skepticism': ['NN'],
  'Skeptics': ['NNS'],
  'Ski': ['NNP'],
  'Skid': ['NNP'],
  'Skidmore': ['NNP'],
  'Skies': ['NNPS'],
  'Skiing': ['NN'],
  'Skill': ['JJ'],
  'Skilled': ['JJ'],
  'Skillman': ['NNP'],
  'Skills': ['NNS'],
  'Skilton': ['NNP'],
  'Skim': ['JJ'],
  'Skinner': ['NNP'],
  'Skinnerish': ['JJ'],
  'Skinny': ['NNP'],
  'Skip': ['VB'],
  'Skipjack': ['NNP'],
  'Skipper': ['NNP'],
  'Skipping': ['VBG'],
  'Skippy': ['NNP'],
  'Skittish': ['JJ'],
  'Skiway': ['NNP'],
  'Skoal': ['NNP'],
  'Skokie': ['NNP'],
  'Skolkau': ['NNP'],
  'Skolman': ['NNP'],
  'Skolniks': ['NNP'],
  'Skolovsky': ['NNP'],
  'Skopas': ['NNP'],
  'Skopbank': ['NNP'],
  'Skorich': ['NNP'],
  'Skrunda': ['NNP'],
  'Skubal': ['NNP'],
  'Skulls': ['NNS'],
  'Sky': ['NNP'],
  'Sky-god': ['NNP'],
  'SkyWest': ['NNP'],
  'Skybolt': ['NN'],
  'Skydome': ['NNP'],
  'Skye': ['NNP'],
  'Skylark': ['NNP'],
  'Skyline': ['NNP'],
  'Skypak': ['NNP'],
  'Skyros': ['NNP'],
  'Skywalker': ['NNP'],
  'Skywave': ['NNP'],
  'Skyway': ['NNP'],
  'Slab': ['NN'],
  'Slack': ['NNP'],
  'Slackened': ['VBN'],
  'Slash': ['VB'],
  'Slash-B': ['NNP'],
  'Slate': ['NNP'],
  'Slated': ['VBN'],
  'Slater': ['NNP'],
  'Slatkin': ['NNP'],
  'Slaughter': ['NNP'],
  'Slavery': ['NN'],
  'Slavic': ['NNP'],
  'Slavin': ['NNP'],
  'Slavs': ['NNPS'],
  'Slay': ['VBP'],
  'Sleep': ['NN'],
  'Sleep-disorder': ['JJ'],
  'Sleeper': ['NNP'],
  'Sleepers': ['NNP'],
  'Sleepily': ['RB'],
  'Sleepinal': ['NNP'],
  'Sleeping': ['NNP'],
  'Sleepwalkers': ['NNS'],
  'Sleepwalking': ['NN'],
  'Sleepy-eyed': ['JJ'],
  'Sleight': ['NNP'],
  'Slemrod': ['NNP'],
  'Slenczynka': ['NNP'],
  'Slender': ['JJ'],
  'Slice': ['NN'],
  'Slick': ['JJ'],
  'Slickers': ['NNPS'],
  'Slider': ['NNP'],
  'Slides': ['NNS'],
  'Slight': ['JJ'],
  'Slightam': ['NNP'],
  'Slightly': ['RB'],
  'Slim': ['NNP'],
  'Slim-Fast': ['NNP'],
  'Slims': ['NNPS'],
  'Slippery': ['NNP'],
  'Slipping': ['VBG'],
  'Slivka': ['NNP'],
  'Slo-Flo': ['NNP'],
  'Sloan': ['NNP'],
  'Sloanaker': ['NNP'],
  'Sloane': ['NNP'],
  'Slobodin': ['NNP'],
  'Slocum': ['NNP'],
  'Slogan': ['NNP'],
  'Slope': ['NNP'],
  'Slosberg': ['NNP'],
  'Slote': ['NNP'],
  'Slotnick': ['NNP'],
  'Slough': ['NNP'],
  'Slovakia': ['NNP'],
  'Slovenia': ['NNP'],
  'Slovenian': ['JJ'],
  'Sloves': ['NNP'],
  'Slow': ['JJ'],
  'Slower': ['JJR'],
  'Slowing': ['VBG'],
  'Slowly': ['RB'],
  'Sludge': ['NNP'],
  'Slug': ['VB'],
  'Slugger': ['NNP'],
  'Sluggish': ['JJ'],
  'Slums': ['NNP'],
  'Slutsky': ['NNP'],
  'Slyke': ['NNP'],
  'Smaby': ['NNP'],
  'Smaedt': ['NNP'],
  'Smale': ['NNP'],
  'Small': ['JJ'],
  'Small-business': ['NN'],
  'Small-company': ['JJ'],
  'Small-lot': ['JJ'],
  'Small-stock': ['NN'],
  'Smaller': ['JJR'],
  'Smaller-stock': ['JJR'],
  'Smalling': ['NNP'],
  'Smallwood': ['NNP'],
  'Smart': ['NNP'],
  'Smarter': ['RB'],
  'Smartt': ['NNP'],
  'Smeal': ['NNP'],
  'Smedes': ['NNP'],
  'Smelov': ['NNP'],
  'Smelting': ['NNP'],
  'Smerdyakov': ['NNP'],
  'Smetek': ['NNP'],
  'Smilin': ['NNP'],
  'Smiling': ['VBG'],
  'Smirnoff': ['NNP'],
  'Smith': ['NNP'],
  'Smith-Colmer': ['NNP'],
  'Smith-Hughes': ['NNP'],
  'Smith-Kline': ['NNP'],
  'SmithKline': ['NNP'],
  'Smith\\\'/Greenland': ['NNP'],
  'Smithfield': ['NNP'],
  'Smiths': ['NNPS'],
  'Smithson': ['NNP'],
  'Smithsonian': ['NNP'],
  'Smithtown': ['NNP'],
  'Smitty': ['NNP'],
  'Smoak': ['NNP'],
  'Smoke': ['NNP'],
  'Smokers': ['NNS'],
  'Smokey': ['NNP'],
  'Smokies': ['NNPS'],
  'Smoking': ['NNP'],
  'Smoky': ['NNP'],
  'Smoldering': ['VBG'],
  'Smolensk': ['NNP'],
  'Smoot-Hawley': ['NNP'],
  'Smorgon': ['NNP'],
  'Smug': ['JJ'],
  'Smukler': ['NNP'],
  'Smurfit': ['NNP'],
  'Smuzynski': ['NNP'],
  'Smyrna': ['NNP'],
  'Smyth': ['NNP'],
  'Smythe': ['NNP'],
  'Snack-food': ['NN'],
  'Snacking': ['NN'],
  'Snake': ['NNP'],
  'Snakes': ['NNS'],
  'Snap-On': ['NNP'],
  'Snapped': ['VBD'],
  'Snaresbrook': ['NNP'],
  'Snatchers': ['NNPS'],
  'Snatching': ['VBG'],
  'Snead': ['NNP'],
  'Sneaker': ['NNP'],
  'Snecma': ['NNP'],
  'Snedaker': ['NNP'],
  'Snedeker': ['NNP'],
  'Sneed': ['NNP'],
  'Snelling': ['NNP'],
  'Snellville': ['NNP'],
  'Snezak': ['NNP'],
  'Sniffing': ['VBG'],
  'Sniffle': ['NNP'],
  'Sniper': ['NNP'],
  'Snodgrass': ['NNP'],
  'Snook': ['NNP'],
  'Snoopy': ['NNP'],
  'Snoozing': ['VBG'],
  'Snopes': ['NNP'],
  'Snow': ['NNP'],
  'Snowball': ['NN'],
  'Snowmass': ['NNP'],
  'Snuff': ['NNP'],
  'Snug-Grip': ['NNP'],
  'Snuggle': ['NNP'],
  'Snyder': ['NNP'],
  'So': ['RB'],
  'So-Ho': ['NNP'],
  'So-called': ['JJ'],
  'So-so': ['NN'],
  'SoHo': ['NNP'],
  'Soak': ['VB'],
  'Soap': ['NNP'],
  'Soapy': ['JJ'],
  'Soares-Kemp': ['NNP'],
  'Soaring': ['VBG'],
  'Soba': ['FW'],
  'Sobel': ['NNP'],
  'Sober': ['NNP'],
  'Sobey': ['NNP'],
  'Sobibor': ['NNP'],
  'Soccer': ['NNP'],
  'Sochaux': ['NNP'],
  'Sochi': ['NNP'],
  'Social': ['NNP'],
  'Socialism': ['NN'],
  'Socialist': ['NNP'],
  'Socialist-led': ['JJ'],
  'Socialists': ['NNS'],
  'Socialization': ['NN'],
  'Societa': ['NNP'],
  'Societe': ['NNP'],
  'Societies': ['NNS'],
  'Society': ['NNP'],
  'Socinianism': ['NNP'],
  'Sociological': ['JJ'],
  'Sock': ['VB'],
  'Socola': ['NNP'],
  'Soconoco': ['NNP'],
  'Socrates': ['NNP'],
  'Soda': ['NNP'],
  'Soderblom': ['NNP'],
  'Sodium': ['NN'],
  'Soeren': ['NNP'],
  'Soering': ['NNP'],
  'Sofia': ['NNP'],
  'Sofitel': ['NNP'],
  'Soft': ['JJ'],
  'Soft-Sell': ['JJ'],
  'Soft-drink': ['NN'],
  'Soft-spoken': ['JJ'],
  'SoftLetter': ['NNP'],
  'Softener': ['NN'],
  'Softer': ['JJR'],
  'Softer-than-expected': ['JJ'],
  'Softletter': ['NNP'],
  'Softly': ['RB'],
  'Softness': ['NN'],
  'Softsoap': ['NNP'],
  'Software': ['NNP'],
  'Sogo': ['NNP'],
  'Sohmer': ['NNP'],
  'Sohn': ['NNP'],
  'Soho': ['NNP'],
  'Soichiro': ['NNP'],
  'Soifer': ['NNP'],
  'Soignee': ['FW'],
  'Soil': ['NN'],
  'Soir': ['NNP'],
  'Soiree': ['NNP'],
  'Sojourner': ['NNP'],
  'Sojuzpushnina': ['NNP'],
  'Sokol': ['NNP'],
  'Sokolev': ['NNP'],
  'Sokolov': ['NNP'],
  'Sokolsky': ['NNP'],
  'Sol': ['NNP'],
  'Solaia': ['NNP'],
  'Solana': ['NNP'],
  'Solano': ['NNP'],
  'Solar': ['NNP'],
  'Solar-powered': ['JJ'],
  'Solarz': ['NNP'],
  'Solchaga': ['NNP'],
  'Sold': ['VBN'],
  'Soldado': ['NNP'],
  'Soldatenko': ['NNP'],
  'Solder': ['VB'],
  'Soldier': ['NNP'],
  'Soldiers': ['NNS'],
  'Sole': ['NNP'],
  'Solebury': ['NNP'],
  'Soleil': ['NNP'],
  'Solel': ['NNP'],
  'Solemnis': ['NNP'],
  'Solemnly': ['RB'],
  'Soler': ['NNP'],
  'Solesmes': ['NNP'],
  'Solicitor': ['NNP'],
  'Solid': ['JJ'],
  'Solidarity': ['NNP'],
  'Solidarity-led': ['JJ'],
  'Solidarityled': ['NNP'],
  'Solihull': ['NNP'],
  'Solis-Cohen': ['NNP'],
  'Solitudinem': ['FW'],
  'Soliz': ['NNP'],
  'Soll': ['NNP'],
  'Solloway': ['NNP'],
  'Solly': ['NNP'],
  'Solna': ['NNP'],
  'Solo': ['NNP'],
  'Solodar': ['NNP'],
  'Solomon': ['NNP'],
  'Solomon-like': ['JJ'],
  'Solomonic': ['JJ'],
  'Solomons': ['NNPS'],
  'Solon': ['NNP'],
  'Soloviev': ['NNP'],
  'Soloviev-Sedoi': ['NNP'],
  'Solovyov': ['NNP'],
  'Solow': ['NNP'],
  'Solution': ['NNP'],
  'Solutions': ['NNPS'],
  'Solvay': ['NNP'],
  'Solved': ['VBD'],
  'Solving': ['VBG'],
  'Solzhenitsyn': ['NNP'],
  'Somali': ['JJ'],
  'Somalia': ['NNP'],
  'Somalis': ['NNPS'],
  'Somay': ['NNP'],
  'Sombrotto': ['NNP'],
  'Some': ['DT'],
  'Somebody': ['NN'],
  'Someday': ['RB'],
  'Somehow': ['RB'],
  'Someone': ['NN'],
  'Somers': ['NNP'],
  'Somersaults': ['NNS'],
  'Somerset': ['NNP'],
  'Somerville': ['NNP'],
  'Something': ['NN'],
  'Sometime': ['RB'],
  'Sometimes': ['RB'],
  'Somewhat': ['RB'],
  'Somewhere': ['RB'],
  'Sommer': ['NNP'],
  'Sommers': ['NNP'],
  'Somoza': ['NNP'],
  'Son': ['NNP'],
  'Son-of-DAT': ['NNP'],
  'Sonambula': ['NNP'],
  'Sonar': ['NN'],
  'Sonata': ['NNP'],
  'Sonatas': ['NNS'],
  'Sonates': ['NNPS'],
  'Sondheim': ['NNP'],
  'Sonenberg': ['NNP'],
  'Sonet': ['NNP'],
  'Sonet-based': ['JJ'],
  'Sonet-compatible': ['JJ'],
  'Song': ['NNP'],
  'Song-sam': ['NNP'],
  'Songau': ['NNP'],
  'Songbag': ['NNP'],
  'Songs': ['NNPS'],
  'Sonia': ['NNP'],
  'Sonic': ['JJ'],
  'Sonja': ['NNP'],
  'Sonnenschein': ['NNP'],
  'Sonnett': ['NNP'],
  'Sonni': ['NNP'],
  'Sonntag': ['FW'],
  'Sonny': ['NNP'],
  'Sonoma': ['NNP'],
  'Sonora': ['NN'],
  'Sons': ['NNP'],
  'Sontag': ['NNP'],
  'Sonuvabitch': ['UH'],
  'Sony': ['NNP'],
  'Sony-Columbia': ['JJ'],
  'Sony-owned': ['JJ'],
  'Sony\\\'/Columbia': ['NNP'],
  'Soo': ['NNP'],
  'Soon': ['RB'],
  'Sooner': ['RB'],
  'Sooraji': ['NNP'],
  'Soothing': ['VBG'],
  'Soothsayer': ['NNP'],
  'Sophia': ['NNP'],
  'Sophias': ['NNP'],
  'Sophie': ['NNP'],
  'Sophisticated': ['JJ'],
  'Sophoclean': ['NNP'],
  'Sophocles': ['NNP'],
  'Sophomore': ['NN'],
  'Sophomores': ['NNS'],
  'Sopsaisana': ['NNP'],
  'Sorbus': ['NNP'],
  'Sore': ['JJ'],
  'Sorecom': ['NNP'],
  'Soren': ['NNP'],
  'Sorenson': ['NNP'],
  'Sorge': ['NNP'],
  'Soria': ['NNP'],
  'Sorkin': ['NNP'],
  'Soros': ['NNP'],
  'Sorrell': ['NNP'],
  'Sorrentine': ['NNP'],
  'Sorrentino': ['NNP'],
  'Sorrow': ['NNP'],
  'Sorry': ['JJ'],
  'Sort': ['NN'],
  'Sorting': ['VBG'],
  'Sosnick': ['NNP'],
  'Sosnoff': ['NNP'],
  'Sosuke': ['NNP'],
  'Sotela': ['NNP'],
  'Sotheby': ['NNP'],
  'Sotnikov': ['NNP'],
  'Soto': ['NNP'],
  'Sotun': ['NNP'],
  'Souci': ['NNP'],
  'Soucy': ['NNP'],
  'Soukhouma': ['NNP'],
  'Soul': ['NNP'],
  'Soule': ['NNP'],
  'Sound': ['NNP'],
  'SoundView': ['NNP'],
  'Sounder': ['NNP'],
  'Sounds': ['VBZ'],
  'Soundview': ['NNP'],
  'Sounion': ['NNP'],
  'Soup': ['NNP'],
  'Souper': ['NNP'],
  'Souphanouvong': ['NNP'],
  'Soups': ['NNP'],
  'Soupy': ['JJ'],
  'Sour': ['NNP'],
  'Source': ['NN'],
  'Source:New': ['NNP'],
  'Sources': ['NNS'],
  'Sourcing': ['VBG'],
  'Sousa': ['NNP'],
  'South': ['NNP'],
  'South-Asian': ['NNP'],
  'South-East': ['NNP'],
  'Southam': ['NNP'],
  'Southampton': ['NNP'],
  'Southbrook': ['NNP'],
  'Southdown': ['NNP'],
  'Southeast': ['NNP'],
  'Southeastern': ['NNP'],
  'Southern': ['NNP'],
  'Southern-Republican': ['NNP'],
  'Southerner': ['NNP'],
  'Southerners': ['NNPS'],
  'Southey': ['NNP'],
  'Southfield': ['NNP'],
  'Southgate': ['NNP'],
  'Southhampton': ['NNP'],
  'Southlake': ['NNP'],
  'Southland': ['NNP'],
  'Southlife': ['NNP'],
  'Southmark': ['NNP'],
  'Southmark-sponsored': ['JJ'],
  'Southmark-supported': ['JJ'],
  'Southmark\\\'/Envicon': ['NNP'],
  'Southon': ['NNP'],
  'Southport': ['NNP'],
  'Souths': ['NNPS'],
  'Southwest': ['NNP'],
  'Southwestern': ['NNP'],
  'Southwide': ['NNP'],
  'Southwood': ['NNP'],
  'Souvanna': ['NNP'],
  'Souza': ['NNP'],
  'Sovereign': ['NNP'],
  'Soviet': ['JJ'],
  'Soviet-American': ['JJ'],
  'Soviet-Chinese': ['NNP'],
  'Soviet-Finnish': ['JJ'],
  'Soviet-German': ['NNP'],
  'Soviet-Israeli': ['JJ'],
  'Soviet-Korean': ['JJ'],
  'Soviet-Western': ['NNP'],
  'Soviet-accredited': ['JJ'],
  'Soviet-backed': ['JJ'],
  'Soviet-bloc': ['JJ'],
  'Soviet-built': ['JJ'],
  'Soviet-controlled': ['JJ'],
  'Soviet-finished': ['JJ'],
  'Soviet-made': ['JJ'],
  'Soviet-style': ['JJ'],
  'Soviet-supplied': ['JJ'],
  'Soviet-trained': ['JJ'],
  'Sovietized': ['JJ'],
  'Sovietologist': ['NN'],
  'Soviets': ['NNPS'],
  'Sovietskaya': ['NNP'],
  'Sovran': ['NNP'],
  'Sovtransavto': ['NNP'],
  'Sowell': ['NNP'],
  'Soweto': ['NNP'],
  'Sows': ['NNS'],
  'Sox': ['NNP'],
  'Soxhlet': ['NN'],
  'Soya': ['NNP'],
  'Soybean': ['NN'],
  'Soybeans': ['NNS'],
  'Soyuz': ['NNP'],
  'Soyuzgoscirk': ['NNP'],
  'Sp': ['NNP'],
  'SpA': ['NNP'],
  'Spa': ['NNP'],
  'Spaarbank': ['NNP'],
  'Space': ['NNP'],
  'Space-net': ['NNP'],
  'Spaced': ['NNP'],
  'Spacenet': ['NNP'],
  'Spaces': ['NNPS'],
  'Spada': ['NNP'],
  'Spadafora': ['NNP'],
  'Spade': ['NNP'],
  'Spady': ['NNP'],
  'Spaeth': ['NNP'],
  'Spaghetti': ['NNP'],
  'Spagna': ['FW'],
  'Spago': ['NNP'],
  'Spahn': ['NNP'],
  'Spahnie': ['NN'],
  'Spahr': ['NNP'],
  'Spain': ['NNP'],
  'Spalding': ['NNP'],
  'Spalsbury': ['NNP'],
  'Spam': ['NNP'],
  'Span': ['NN'],
  'Spanberg': ['NNP'],
  'Spangenberg': ['NNP'],
  'Spangled': ['NNP'],
  'Spanish': ['JJ'],
  'Spanish-American': ['NNP'],
  'Spanish-born': ['JJ'],
  'Spanish-language': ['JJ'],
  'Spanish-speaking': ['JJ'],
  'Spanos': ['NNP'],
  'Spar': ['NNP'],
  'Sparc': ['NNP'],
  'Sparcstation': ['NNP'],
  'Spare': ['JJ'],
  'Spark': ['NNP'],
  'Sparkling': ['NNP'],
  'Sparkman': ['NNP'],
  'Sparks': ['NNP'],
  'Sparky': ['NNP'],
  'Sparling': ['NNP'],
  'Sparrow-size': ['NNP'],
  'Sparrows': ['NNP'],
  'Sparta': ['NNP'],
  'Spartan': ['NNP'],
  'Spatial': ['JJ'],
  'Spatiality': ['NN'],
  'Spaulding': ['NNP'],
  'Spaull': ['NNP'],
  'Speak': ['VB'],
  'Speaker': ['NNP'],
  'Speakers': ['NNS'],
  'Speakership': ['NNP'],
  'Speaking': ['VBG'],
  'Spear': ['NNP'],
  'Spec.': ['NN'],
  'Special': ['JJ'],
  'Special-election': ['NN'],
  'Special-interest': ['JJ'],
  'Specialist': ['NNP'],
  'Specialists': ['NNS'],
  'Specialized': ['NNP'],
  'Specially': ['RB'],
  'Specialties': ['NNP'],
  'Specialty': ['NNP'],
  'Species': ['NNP'],
  'Specific': ['JJ'],
  'Specific-Time': ['NNP'],
  'Specifically': ['RB'],
  'Specifications': ['NNS'],
  'Specifics': ['NNS'],
  'Specimens': ['NNS'],
  'Spectator': ['NNP'],
  'Spectators': ['NNS'],
  'Specter': ['NNP'],
  'Specthrie': ['NNP'],
  'Spector': ['NNP'],
  'Spectra': ['NNS'],
  'Spectradyne': ['NNP'],
  'Spectrum': ['NNP'],
  'Speculation': ['NN'],
  'Speculative': ['JJ'],
  'Speculators': ['NNS'],
  'Speeches': ['NNS'],
  'Speed': ['NN'],
  'Speedup': ['NN'],
  'Speedway': ['NNP'],
  'Speedy': ['NNP'],
  'Speer': ['NNP'],
  'Spegititgninino': ['NNP'],
  'Speidel': ['NNP'],
  'SpellRight': ['NNP'],
  'Spelling': ['NNP'],
  'Spelman': ['NNP'],
  'Spence': ['NNP'],
  'Spencer': ['NNP'],
  'Spencerian': ['JJ'],
  'Spend': ['VB'],
  'Spending': ['NN'],
  'Spendthrift': ['NNP'],
  'Spengler': ['NNP'],
  'Spenglerian': ['JJ'],
  'Spenser': ['NNP'],
  'Sperandeo': ['NNP'],
  'Sperling': ['NNP'],
  'Sperry': ['NNP'],
  'Spethmann': ['NNP'],
  'Spherical': ['JJ'],
  'Sphinx': ['NNP'],
  'Spic': ['NNP'],
  'Spice-Nice': ['NNP'],
  'Spicer': ['NNP'],
  'Spider': ['NNP'],
  'Spiegel': ['NNP'],
  'Spiegelman': ['NNP'],
  'Spielberg': ['NNP'],
  'Spielvogel': ['NNP'],
  'Spierer': ['NNP'],
  'Spievack': ['NNP'],
  'Spike': ['NNP'],
  'Spike-haired': ['JJ'],
  'Spikes': ['NNP'],
  'Spill': ['NN'],
  'Spillane': ['NNP'],
  'Spiller': ['NNP'],
  'Spilman': ['NNP'],
  'Spin': ['NNP'],
  'Spinco': ['NNP'],
  'Spinelli': ['NNP'],
  'Spinley': ['NNP'],
  'Spinnaker': ['NNP'],
  'Spinners': ['NNPS'],
  'Spinney': ['NNP'],
  'Spinning': ['VBG'],
  'Spinoffs': ['NNS'],
  'Spinola': ['NNP'],
  'Spinrad': ['NNP'],
  'Spiotto': ['NNP'],
  'Spirit': ['NNP'],
  'Spirited': ['JJ'],
  'Spirito': ['NNP'],
  'Spirits': ['NNP'],
  'Spiritual': ['JJ'],
  'Spirituals': ['NNS'],
  'Spiro': ['NNP'],
  'Spirrison': ['NNP'],
  'Spitalnick': ['NNP'],
  'Spitler': ['NNP'],
  'Spitzenburg': ['NNP'],
  'Splendid': ['JJ'],
  'Splendide': ['NNP'],
  'Splendor': ['NN'],
  'Splenomegaly': ['NN'],
  'Splinting': ['NNP'],
  'Split': ['VBN'],
  'Splits': ['NNS'],
  'Spofford': ['NNP'],
  'Spogli': ['NNP'],
  'Spoilage': ['NN'],
  'Spokane': ['NNP'],
  'Spoken': ['NNP'],
  'Spokesman': ['NNP'],
  'Spokesmen': ['NNS'],
  'Spokespersons': ['NNS'],
  'Spokeswomen': ['NNS'],
  'Sponge': ['NNP'],
  'Sponsor': ['NNP'],
  'Sponsored': ['VBN'],
  'Sponsors': ['NNS'],
  'Spontaneity': ['NN'],
  'Spontex': ['NNP'],
  'Spook': ['VBP'],
  'Spooked': ['VBN'],
  'Spoon': ['NNP'],
  'Sporadic': ['JJ'],
  'Sporkin': ['NNP'],
  'Sport': ['NNP'],
  'Sport-King': ['NN'],
  'Sportdom': ['NN'],
  'Sportin': ['VBG'],
  'Sporting': ['NNP'],
  'Sporto': ['NNP'],
  'Sports': ['NNPS'],
  'Sportscasters': ['NNS'],
  'Sportscreme': ['NNP'],
  'Sportsman': ['NNP'],
  'Sportsmen': ['NNS'],
  'Sportswear': ['NNP'],
  'Sportswriters': ['NNS'],
  'Sposato': ['NNP'],
  'Spot': ['NN'],
  'Spotlight': ['NNP'],
  'Spots': ['NNS'],
  'Spotted': ['VBN'],
  'Spouse': ['NN'],
  'Sprague': ['NNP'],
  'Spraying': ['VBG'],
  'Spread': ['VB'],
  'Spreading': ['NNP'],
  'Spreads': ['NNS'],
  'Sprecher': ['NNP'],
  'Sprenger': ['NNP'],
  'Spring': ['NNP'],
  'Springdale': ['NNP'],
  'Springerville': ['NNP'],
  'Springfield': ['NNP'],
  'Springing': ['VBG'],
  'Springs': ['NNP'],
  'Sprinkel': ['NNP'],
  'Sprinkle': ['VB'],
  'Sprinkled': ['VBN'],
  'Sprint': ['NNP'],
  'Sprite': ['NNP'],
  'Sprizzo': ['NNP'],
  'Sprouted': ['VBN'],
  'Sprouting': ['NN'],
  'Spruce': ['NNP'],
  'Spruell': ['NNP'],
  'Spruill': ['NNP'],
  'Sprung': ['NNP'],
  'Spumoni': ['NNS'],
  'Spurdle': ['NNP'],
  'Spurgeon': ['NNP'],
  'Spurred': ['VBN'],
  'Sputnik': ['NNP'],
  'Spuyten': ['NNP'],
  'Spy': ['NNP'],
  'Spycatcher': ['NN'],
  'Spycket': ['NNP'],
  'Squad': ['NN'],
  'Squadron': ['NNP'],
  'Squadrons': ['NNP'],
  'Square': ['NNP'],
  'Squaresville': ['NNP'],
  'Squat-style': ['JJ'],
  'Squats': ['NNS'],
  'Squatting': ['VBG'],
  'Squeezed': ['VBN'],
  'Squeezing': ['VBG'],
  'Squibb': ['NNP'],
  'Squier': ['NNP'],
  'Squint': ['NN'],
  'Squire': ['NNP'],
  'Squires': ['NNP'],
  'Sr': ['NNP'],
  'Sr.': ['NNP'],
  'Sri': ['NNP'],
  'SsangYong': ['NNP'],
  'Ssmc': ['NN'],
  'Sssshoo': ['NN'],
  'St': ['NNP'],
  'St-Laurent': ['NNP'],
  'St-story': ['NN'],
  'St.': ['NNP'],
  'St.-Pol': ['NNP'],
  'Staar': ['NNP'],
  'Stabat': ['NNP'],
  'Stabbert': ['NNP'],
  'Stabenau': ['NNP'],
  'Stabilizing': ['VBG'],
  'Stacey': ['NNP'],
  'Stack': ['NNP'],
  'Stacked': ['JJ'],
  'Stackup': ['NNP'],
  'Stacy': ['NNP'],
  'Stadium': ['NNP'],
  'Stadiums': ['NNS'],
  'Stadt': ['NNP'],
  'Stadtisches': ['NNP'],
  'Stadtmauer': ['NNP'],
  'Staff': ['NNP'],
  'Staffe': ['NNP'],
  'Staffers': ['NNS'],
  'Staffing': ['NNP'],
  'Stafford': ['NNP'],
  'Staffordshire': ['NNP'],
  'Staffs': ['NNS'],
  'Stag': ['NNP'],
  'Stage': ['NNP'],
  'Stagecoach': ['NNP'],
  'Staged': ['VBN'],
  'Staggeringly': ['RB'],
  'Stahl': ['NNP'],
  'Staiger': ['NNP'],
  'Stained': ['VBN'],
  'Staining': ['VBG'],
  'Stainless': ['NNP'],
  'Stains': ['NNS'],
  'Staircase': ['NN'],
  'Stairs': ['NNP'],
  'Stake': ['VB'],
  'Stakes': ['NNP'],
  'Stalag': ['NNP'],
  'Stale': ['JJ'],
  'Staley': ['NNP'],
  'Stalin': ['NNP'],
  'Stalingr': ['NNP'],
  'Stalinism': ['NNP'],
  'Stalinist': ['JJ'],
  'Stalinist-corrupted': ['JJ'],
  'Stalinists': ['NNPS'],
  'Stalins': ['NNPS'],
  'Stalk': ['NNP'],
  'Stalker': ['NNP'],
  'Stall': ['NN'],
  'Stallard': ['NNP'],
  'Stalled': ['VBN'],
  'Stalling': ['VBG'],
  'Stallings': ['NNP'],
  'Stallkamp': ['NNP'],
  'Stallone': ['NNP'],
  'Staloff': ['NNP'],
  'Stalone': ['NNP'],
  'Stals': ['NNP'],
  'Stamford': ['NNP'],
  'Stammering': ['NN'],
  'Stan': ['NNP'],
  'Stanbury': ['NNP'],
  'Stancs': ['NNP'],
  'Stand': ['VB'],
  'Standard': ['NNP'],
  'Standard-Times': ['NNP'],
  'Standard-issue': ['JJ'],
  'Standardization': ['NN'],
  'Standardized': ['JJ'],
  'Standards': ['NNPS'],
  'Standing': ['VBG'],
  'Stands': ['NNP'],
  'Stanford': ['NNP'],
  'Stanford-Idec': ['NNP'],
  'Stanger': ['NNP'],
  'Stanhope': ['NNP'],
  'Stanislas': ['NNP'],
  'Stanislav': ['NNP'],
  'Stanislaw': ['NNP'],
  'Staniszkis': ['NNP'],
  'Stanley': ['NNP'],
  'Stannard': ['NNP'],
  'Stans': ['NNP'],
  'Stansbery': ['NNP'],
  'Stansfield': ['NNP'],
  'Stanton': ['NNP'],
  'Stanwick': ['NNP'],
  'Stanza': ['NNP'],
  'Stapf': ['NNP'],
  'Staples': ['NNP'],
  'Stapleton': ['NNP'],
  'Star': ['NNP'],
  'Star-Spangled': ['NNP'],
  'Starbird': ['NNP'],
  'Starch': ['NNP'],
  'Stardel': ['NNP'],
  'Stardent': ['NNP'],
  'Stardust': ['NN'],
  'Staring': ['VBG'],
  'Stark': ['NNP'],
  'Starke': ['NNP'],
  'Starkey': ['NNP'],
  'Starkov': ['NNP'],
  'Starks': ['NNP'],
  'Starling': ['NNP'],
  'Starlings': ['NNS'],
  'Starpointe': ['NNP'],
  'Starr': ['NNP'],
  'Stars': ['NNP'],
  'Start': ['VB'],
  'Start-up': ['JJ'],
  'Started': ['VBN'],
  'Starter': ['NNP'],
  'Starting': ['VBG'],
  'Startled': ['VBN'],
  'Starts': ['VBZ'],
  'Starve': ['NNP'],
  'Starzl': ['NNP'],
  'Stash': ['NNP'],
  'Stat.': ['NNP'],
  'State': ['NNP'],
  'State-Local': ['NNP'],
  'State-capitol': ['NN'],
  'State-controlled': ['JJ'],
  'State-financed': ['JJ'],
  'State-owned': ['JJ'],
  'State-run': ['JJ'],
  'Stated': ['VBN'],
  'Statehood': ['NNP'],
  'Statehouse': ['NN'],
  'Statements': ['NNS'],
  'Staten': ['NNP'],
  'Stater': ['NNP'],
  'States': ['NNPS'],
  'States-Yugoslav': ['NNP'],
  'StatesWest': ['NNP'],
  'Statesman': ['NNP'],
  'Stateswest': ['NNP'],
  'Station': ['NNP'],
  'Stations': ['NNS'],
  'Statistical': ['NNP'],
  'Statistically': ['RB'],
  'Statistics': ['NNP'],
  'Statistique': ['NNP'],
  'Statue': ['NNP'],
  'Statues': ['NNS'],
  'Stature': ['NN'],
  'Status': ['NN'],
  'Status-roles': ['NNS'],
  'Statute': ['NN'],
  'Statutes': ['NNS'],
  'Statuto': ['NN'],
  'Stauffer': ['NNP'],
  'Staunton': ['NNP'],
  'Stavropoulos': ['NNP'],
  'Stay': ['VB'],
  'Ste.': ['NNP'],
  'Steady': ['JJ'],
  'Steak': ['NNP'],
  'Stealth': ['NNP'],
  'Steam': ['NN'],
  'Steamboat': ['NNP'],
  'Steamed': ['VBN'],
  'Steamship': ['NNP'],
  'Stearn': ['NNP'],
  'Stearns': ['NNP'],
  'Steckles': ['NNP'],
  'Stedt': ['NNP'],
  'Steel': ['NNP'],
  'Steele': ['NNP'],
  'Steelers': ['NNP'],
  'Steelmakers': ['NNS'],
  'Steelmaking': ['NN'],
  'Steels': ['NNP'],
  'Steelton': ['NNP'],
  'Steelworkers': ['NNPS'],
  'Steen': ['NNP'],
  'Steep': ['NNP'],
  'Steer': ['VB'],
  'Steeves': ['NNP'],
  'Stefan': ['NNP'],
  'Steffens': ['NNP'],
  'Steffes': ['NNP'],
  'Stegemeier': ['NNP'],
  'Stehelin': ['NNP'],
  'Stehlin': ['NNP'],
  'Steichen': ['NNP'],
  'Steidtmann': ['NNP'],
  'Steiger': ['NNP'],
  'Stein': ['NNP'],
  'Steinbach': ['NNP'],
  'Steinbeck': ['NNP'],
  'Steinbecks': ['NNPS'],
  'Steinberg': ['NNP'],
  'Steinbergs': ['NNP'],
  'Steinbrenner': ['NNP'],
  'Steiner': ['NNP'],
  'Steiners': ['NNPS'],
  'Steinhager': ['NNP'],
  'Steinhardt': ['NNP'],
  'Steinhart': ['NNP'],
  'Steinkerque': ['NNP'],
  'Steinkrauss': ['NNP'],
  'Steinkuehler': ['NNP'],
  'Steinkuhler': ['NNP'],
  'Steinman': ['NNP'],
  'Steinmetz': ['NNP'],
  'Stelco': ['NNP'],
  'Stella': ['NNP'],
  'Stellar': ['NNP'],
  'Stelzer': ['NNP'],
  'Stempel': ['NNP'],
  'Stems': ['NNS'],
  'Stena': ['NNP'],
  'Stena-Tiphook': ['NNP'],
  'Stendhal': ['NNP'],
  'Stendler': ['NNP'],
  'Stenexport': ['NNP'],
  'Stengel': ['NNP'],
  'Stenhach': ['NNP'],
  'Stenhachs': ['NNPS'],
  'Stenholm': ['NNP'],
  'Stennett': ['NNP'],
  'Stennis': ['NNP'],
  'Stensrud': ['NNP'],
  'Stenton': ['NNP'],
  'Step': ['NN'],
  'Stepanian': ['NNP'],
  'Stepanova': ['NNP'],
  'Stepanovich': ['NNP'],
  'Stephan': ['NNP'],
  'Stephane': ['NNP'],
  'Stephanie': ['NNP'],
  'Stephen': ['NNP'],
  'Stephens': ['NNP'],
  'Stephenson': ['NNP'],
  'Steppan': ['NNP'],
  'Steppel': ['NNP'],
  'Steppenwolf': ['NNP'],
  'Steppers': ['NNPS'],
  'Steps': ['NNPS'],
  'Stepson': ['NNP'],
  'Steptoe': ['NNP'],
  'Sterba': ['NNP'],
  'Sterbas': ['NNPS'],
  'Sterile': ['NNP'],
  'Sterilized': ['JJ'],
  'Sterling': ['NNP'],
  'Sterlings': ['NNPS'],
  'Stern': ['NNP'],
  'Stern-faced': ['JJ'],
  'Sternbach': ['NNP'],
  'Sternberg': ['NNP'],
  'Sternenberg': ['NNP'],
  'Steroids': ['NNS'],
  'Stertz': ['NNP'],
  'Stetson': ['NNP'],
  'Stetsons': ['NNPS'],
  'Stettin': ['NNP'],
  'Steuben': ['NNP'],
  'Steudler': ['NNP'],
  'Steve': ['NNP'],
  'Steven': ['NNP'],
  'Stevens': ['NNP'],
  'Stevenses': ['NNPS'],
  'Stevenson': ['NNP'],
  'Stevie': ['NNP'],
  'Stevric': ['NNP'],
  'Steward': ['NN'],
  'Stewart': ['NNP'],
  'Stibel': ['NNP'],
  'Stick': ['NNP'],
  'Sticker': ['NN'],
  'Stickers': ['NNS'],
  'Sticking': ['NNP'],
  'Stickler': ['NN'],
  'Stickney': ['NNP'],
  'Sticks': ['NNP'],
  'Stidger': ['NNP'],
  'Stieglitz': ['NNP'],
  'Stiemerling': ['NNP'],
  'Stifel': ['NNP'],
  'Stiff': ['JJ'],
  'Stifter': ['NNP'],
  'Stigmata': ['NNS'],
  'Stikeman': ['NNP'],
  'Stileman': ['NNP'],
  'Stiles': ['NNP'],
  'Stiling': ['NNP'],
  'Still': ['RB'],
  'Stiller': ['NNP'],
  'Stillerman': ['NNP'],
  'Stillwater': ['NNP'],
  'Stillwell': ['NNP'],
  'Stilts': ['NNP'],
  'Stimson': ['NNP'],
  'Stimulates': ['VBZ'],
  'Stimulating': ['VBG'],
  'Sting': ['NNP'],
  'Stinger': ['NNP'],
  'Stingers': ['NNPS'],
  'Stinky': ['NNP'],
  'Stinnett': ['NNP'],
  'Stinson': ['NNP'],
  'Stiritz': ['NNP'],
  'Stirlen': ['NNP'],
  'Stirling': ['NNP'],
  'Stirring': ['VBG'],
  'Stirs': ['VBZ'],
  'Stitched': ['VBN'],
  'Stjernsward': ['NNP'],
  'Stober': ['NNP'],
  'Stock': ['NNP'],
  'Stock-Index': ['NN'],
  'Stock-fund': ['JJ'],
  'Stock-index': ['NN'],
  'Stock-loan': ['NN'],
  'Stock-market': ['NN'],
  'Stockard': ['NNP'],
  'Stockbrokers': ['NNS'],
  'Stockdale': ['NNP'],
  'Stockgrowers': ['NNPS'],
  'Stockhausen': ['NNP'],
  'Stockholder': ['NN'],
  'Stockholders': ['NNS'],
  'Stockholm': ['NNP'],
  'Stockman': ['NNP'],
  'Stocks': ['NNS'],
  'Stocks\\\'/Mutual': ['NNP'],
  'Stockton': ['NNP'],
  'Stoddard': ['NNP'],
  'Stoeckel': ['NNP'],
  'Stoecker': ['NNP'],
  'Stoecklin': ['NNP'],
  'Stoic': ['NNP'],
  'Stoic-patristic': ['JJ'],
  'Stoicism': ['NN'],
  'Stoics': ['NNS'],
  'Stokely': ['NNP'],
  'Stolen': ['NNP'],
  'Stolichnaya': ['NNP'],
  'Stoll': ['NNP'],
  'Stoller': ['NNP'],
  'Stolley': ['NNP'],
  'Stoltenberg': ['NNP'],
  'Stoltz': ['NNP'],
  'Stoltzman': ['NNP'],
  'Stolz': ['NNP'],
  'Stolzenbach': ['NNP'],
  'Stolzman': ['NNP'],
  'Stomach': ['NNP'],
  'Stone': ['NNP'],
  'Stone-Consolidated': ['NNP'],
  'Stonehenge': ['NNP'],
  'Stoneman': ['NNP'],
  'Stoner': ['NNP'],
  'Stoneridge': ['NNP'],
  'Stones': ['NNP'],
  'Stonestown': ['NNP'],
  'Stonewall': ['NNP'],
  'Stoneware': ['JJ'],
  'Stony': ['NNP'],
  'Stooges': ['NNPS'],
  'Stookey': ['NNP'],
  'Stoops': ['NNP'],
  'Stop': ['VB'],
  'Stop-Limit': ['NNP'],
  'Stop-close-only': ['JJ'],
  'Stop-limit': ['JJ'],
  'Stop-loss': ['NN'],
  'Stoppard': ['NNP'],
  'Stopped': ['VBN'],
  'Stopping': ['VBG'],
  'Stops': ['NNP'],
  'Storage': ['NNP'],
  'Store': ['NNP'],
  'Storehouse': ['NNP'],
  'Storekeepers': ['NNS'],
  'Storer': ['NNP'],
  'Storeria': ['NNP'],
  'Stores': ['NNPS'],
  'Stories': ['NNP'],
  'Stork': ['NNP'],
  'Storm': ['NN'],
  'Stormy': ['NNP'],
  'Story': ['NNP'],
  'Storyboard': ['NNP'],
  'Storyteller': ['NNP'],
  'Stotler': ['NNP'],
  'Stott': ['NNP'],
  'Stouffer': ['NNP'],
  'Stout': ['NNP'],
  'Stoutt': ['NNP'],
  'Stovall': ['NNP'],
  'Stover': ['NNP'],
  'Stowe': ['NNP'],
  'Stowey': ['NNP'],
  'Stoyer': ['NNP'],
  'Strafaci': ['NNP'],
  'Straight': ['JJ'],
  'Straight-Arm': ['NNP'],
  'Straighten': ['VB'],
  'Straightened': ['VBN'],
  'Straightening': ['VBG'],
  'Straights': ['NNS'],
  'Strait': ['NNP'],
  'Straits': ['NNPS'],
  'Stram': ['NNP'],
  'Stranahan': ['NNP'],
  'Strand': ['NNP'],
  'Strang': ['NNP'],
  'Strange': ['JJ'],
  'Strangelove': ['NNP'],
  'Strangely': ['RB'],
  'Stranger': ['JJR'],
  'Strangfeld': ['NNP'],
  'Strangler': ['NNP'],
  'Straniera': ['NNP'],
  'Strapless': ['NNP'],
  'Strasbourg': ['NNP'],
  'Strasny': ['NNP'],
  'Strasser': ['NNP'],
  'Strassner': ['NNP'],
  'Straszheim': ['NNP'],
  'Stratagene': ['NNP'],
  'Stratas': ['NNP'],
  'Strategic': ['NNP'],
  'Strategies': ['NNS'],
  'Strategists': ['NNS'],
  'Strategy': ['NN'],
  'Stratford': ['NNP'],
  'Stratforde': ['NNP'],
  'Stratton': ['NNP'],
  'Stratus': ['NNP'],
  'Straub': ['NNP'],
  'Straus': ['NNP'],
  'Strauss': ['NNP'],
  'Stravinsky': ['NNP'],
  'Strawberry': ['NNP'],
  'Strawbridge': ['NNP'],
  'Streak': ['NNP'],
  'Stream': ['NNP'],
  'Streep': ['NNP'],
  'Street': ['NNP'],
  'Street-inspired': ['JJ'],
  'Street-style': ['JJ'],
  'Streeter': ['NNP'],
  'Streeters': ['NNP'],
  'Streets': ['NNP'],
  'Streetspeak': ['NNP'],
  'Strehler': ['NNP'],
  'Streisand': ['NNP'],
  'Strekel': ['NNP'],
  'Strenger': ['NNP'],
  'Strength': ['NN'],
  'Strenuous': ['JJ'],
  'Streptococcus': ['NN'],
  'Stress': ['NN'],
  'Stressed': ['VBN'],
  'Stressed-out': ['JJ'],
  'Stretch': ['NNP'],
  'Stretching': ['VBG'],
  'Stricken': ['NNP'],
  'Strickland': ['NNP'],
  'Strict': ['JJ'],
  'Strictly': ['RB'],
  'Stride': ['NNP'],
  'Strident': ['JJ'],
  'Strieber': ['NNP'],
  'Strike': ['VB'],
  'Strikes': ['NNS'],
  'Striking': ['VBG'],
  'Strindberg': ['NNP'],
  'String': ['NNP'],
  'Stringer': ['NNP'],
  'Stringfellow': ['NNP'],
  'Stringing': ['VBG'],
  'Strings': ['NNPS'],
  'Strip': ['NNP'],
  'Stripes': ['NNP'],
  'Strippers': ['NNS'],
  'Strips': ['NNS'],
  'Stritch': ['NNP'],
  'Strivers': ['NNPS'],
  'Strobel': ['NNP'],
  'Stroh': ['NNP'],
  'Strohman': ['NNP'],
  'Stroked': ['VBD'],
  'Strokes': ['NNS'],
  'Stroking': ['VBG'],
  'Strolling': ['VBG'],
  'Strom': ['NNP'],
  'Stromeyer': ['NNP'],
  'Stronach': ['NNP'],
  'Strong': ['JJ'],
  'Strong-earnings': ['NNS'],
  'Stronger': ['JJR'],
  'Strongheart': ['NNP'],
  'Stronghold': ['JJ'],
  'Strongin': ['NNP'],
  'Strongly': ['RB'],
  'Strother': ['NNP'],
  'Stroud': ['NNP'],
  'Strouds': ['NNP'],
  'Stroup': ['NNP'],
  'Strub': ['NNP'],
  'Structural': ['NNP'],
  'Structures': ['NNS'],
  'Struggle': ['NNP'],
  'Struggles': ['NNP'],
  'Struggling': ['VBG'],
  'Strukturbericht': ['NNP'],
  'Strum': ['NNP'],
  'Strumwasser': ['NNP'],
  'Strut': ['VB'],
  'Struthers': ['NNP'],
  'Stuart': ['NNP'],
  'Stuart-James': ['NNP'],
  'Stuart-family': ['NN'],
  'Stubblefield': ['NNP'],
  'Stubblefields': ['NNPS'],
  'Stubbs': ['NNP'],
  'Stuck-up': ['NN'],
  'Stuckert': ['NNP'],
  'Stuckey': ['NNP'],
  'Studach': ['NNP'],
  'Studds': ['NNP'],
  'Studds-Miller': ['NNP'],
  'Studebaker': ['NNP'],
  'Student': ['NNP'],
  'Students': ['NNS'],
  'Studies': ['NNS'],
  'Studio': ['NNP'],
  'Studio-City': ['NNP'],
  'Studios': ['NNP'],
  'Studwell': ['NNP'],
  'Study': ['NNP'],
  'Studying': ['VBG'],
  'Stuecker': ['NNP'],
  'Stuff': ['NN'],
  'Stuffing': ['VBG'],
  'Stumbles': ['VBZ'],
  'Stumbling': ['JJ'],
  'Stumpf': ['NNP'],
  'Stung': ['VBN'],
  'Stunned': ['VBN'],
  'Stupid': ['JJ'],
  'Sturbridge': ['NNP'],
  'Sturch': ['NNP'],
  'Sturdy': ['JJ'],
  'Sture': ['NNP'],
  'Sturge': ['NNP'],
  'Sturges': ['NNP'],
  'Sturgess': ['NNP'],
  'Sturley': ['NNP'],
  'Stuttgart': ['NNP'],
  'Stuttgart-based': ['JJ'],
  'Stygian': ['JJ'],
  'Styka': ['NNP'],
  'Style': ['NNP'],
  'Styles': ['NNS'],
  'Styrofoam': ['NNP'],
  'Styron': ['NNP'],
  'Su': ['NNP'],
  'Suarez': ['NNP'],
  'Sub': ['NNP'],
  'Sub-Saharan': ['NNP'],
  'Subaru': ['NNP'],
  'Subcommittee': ['NNP'],
  'Subcontractors': ['NNS'],
  'Subdivision': ['NNP'],
  'Subdued': ['JJ'],
  'Subgroups': ['NNS'],
  'Subic': ['NNP'],
  'Subject': ['NN'],
  'Subjects': ['NNS'],
  'Submarines': ['NNS'],
  'Subpoenas': ['NNS'],
  'Subroto': ['NNP'],
  'Subs': ['NNP'],
  'Subscribers': ['NNS'],
  'Subscribing': ['VBG'],
  'Subsequent': ['JJ'],
  'Subsequently': ['RB'],
  'Subsidiaries': ['NNS'],
  'Subsidiary': ['NN'],
  'Subsidies': ['NNS'],
  'Subsidizing': ['VBG'],
  'Subsistencias': ['NNP'],
  'Substance': ['NN'],
  'Substances': ['NNS'],
  'Substantial': ['JJ'],
  'Substantive': ['NNP'],
  'Substitute': ['JJ'],
  'Substituting': ['VBG'],
  'Subsystems': ['NNS'],
  'Subtitled': ['VBN'],
  'Subtle': ['JJ'],
  'Suburban': ['NNP'],
  'Suburbs': ['NNP'],
  'Subverts': ['NNP'],
  'Subway': ['NNP'],
  'Subways': ['NNS'],
  'Succasunna': ['NNP'],
  'Succeed': ['NNP'],
  'Succeeding': ['VBG'],
  'Success': ['NN'],
  'Successful': ['JJ'],
  'Succession': ['NN'],
  'Successive': ['JJ'],
  'Successors': ['NNS'],
  'Such': ['JJ'],
  'Suchard': ['NNP'],
  'Suchocki': ['NNP'],
  'Suckow': ['NNP'],
  'Sucks': ['NNS'],
  'Sucre': ['NNP'],
  'Sucrerie': ['NNP'],
  'Sudan': ['NNP'],
  'Sudanese': ['NNP'],
  'Sudden': ['JJ'],
  'Suddenly': ['RB'],
  'Sudier': ['NNP'],
  'Sudikoff': ['NNP'],
  'Sudol': ['NNP'],
  'Sue': ['NNP'],
  'Suemeg': ['NNP'],
  'Suez': ['NNP'],
  'Suez-Hungary': ['NNP'],
  'Suffer': ['VB'],
  'Suffering': ['VBG'],
  'Suffers': ['VBZ'],
  'Suffice': ['VB'],
  'Sufficient': ['JJ'],
  'Suffolk': ['NNP'],
  'Sufi': ['JJ'],
  'Sugar': ['NNP'],
  'Sugarman': ['NNP'],
  'Sugarman-led': ['JJ'],
  'Sugars': ['NNPS'],
  'Sugary': ['JJ'],
  'Suggest': ['VB'],
  'Suggested': ['VBN'],
  'Suggestion': ['NNP'],
  'Suggestions': ['NNS'],
  'Suggests': ['NNS'],
  'Suggs': ['NNP'],
  'Suh': ['NNP'],
  'Suhey': ['NNP'],
  'Suhler': ['NNP'],
  'Suicide': ['NN'],
  'Suisse': ['NNP'],
  'Suisse-First': ['NNP'],
  'Suit': ['NN'],
  'Suitable': ['JJ'],
  'Suite': ['NN'],
  'Suites': ['NNPS'],
  'Suitors': ['NNS'],
  'Suits': ['NNS'],
  'Suiza': ['NNP'],
  'Sukarno': ['NNP'],
  'Sukhoi': ['NNP'],
  'Sukio': ['NNP'],
  'Sukle': ['NNP'],
  'Sukuma': ['NNP'],
  'Sulaiman': ['NNP'],
  'Sulamite': ['NN'],
  'Sulamith': ['NNP'],
  'Sulcer': ['NNP'],
  'Sulfaquinoxaline': ['NN'],
  'Sulgrave': ['NNP'],
  'Suliman': ['NNP'],
  'Sulka': ['NNP'],
  'Sullam': ['NNP'],
  'Sullivan': ['NNP'],
  'Sully': ['NNP'],
  'Sulphur': ['NN'],
  'Sultan': ['NNP'],
  'Sultanate': ['NNP'],
  'Sultane': ['NNP'],
  'Sultanov': ['NNP'],
  'Sultans': ['NNS'],
  'Sulya': ['NNP'],
  'Sulzberger': ['NNP'],
  'Sulzer': ['NNP'],
  'Sum': ['NNP'],
  'Sumarlin': ['NNP'],
  'Sumat': ['NNP'],
  'Sumatra': ['NNP'],
  'Sumita': ['NNP'],
  'Sumitomo': ['NNP'],
  'Summa': ['NNP'],
  'Summarizing': ['VBG'],
  'Summary': ['NNP'],
  'Summaryof': ['NNP'],
  'Summcorp': ['NNP'],
  'Summer': ['NNP'],
  'Summerdale': ['NN'],
  'Summerfolk': ['NNP'],
  'Summerland': ['NNP'],
  'Summers': ['NNP'],
  'Summerspace': ['NNP'],
  'Summertime': ['NN'],
  'Summit': ['NNP'],
  'Sumner': ['NNP'],
  'Sumo': ['NN'],
  'Sumter': ['NNP'],
  'Sun': ['NNP'],
  'Sun-3\\\'': ['NNP'],
  'Sun-3\\\'/50': ['NNP'],
  'Sun-Times': ['NNP'],
  'SunAmerica': ['NNP'],
  'SunCor': ['NNP'],
  'SunGard': ['NNP'],
  'SunTrust': ['NNP'],
  'Sunay': ['NNP'],
  'Sunbelt': ['NNP'],
  'Sunbird': ['NNP'],
  'Sunburst': ['NNP'],
  'Sunbury': ['NNP'],
  'Suncor': ['NNP'],
  'Sunda': ['NNP'],
  'Sundance': ['NNP'],
  'Sundance-based': ['JJ'],
  'Sundarji': ['NNP'],
  'Sunday': ['NNP'],
  'Sunday-Tuesday': ['NNP'],
  'Sunday-newspaper': ['NNP'],
  'Sunday-school': ['JJ'],
  'Sundays': ['NNPS'],
  'Sundome': ['NNP'],
  'Sundor': ['NNP'],
  'Sundstrand': ['NNP'],
  'Sunflowers': ['NNS'],
  'Sung': ['NNP'],
  'Sung-Shan': ['NNP'],
  'Sung-il': ['NNP'],
  'Sungene': ['NNP'],
  'Sunken': ['NNP'],
  'Sunkist': ['NNP'],
  'Sunlight': ['NNP'],
  'Sunman': ['NNP'],
  'Sunni': ['NNP'],
  'Sunny': ['NNP'],
  'Sunnyvale': ['NNP'],
  'Sunoco': ['NNP'],
  'Sunrise': ['NNP'],
  'Suns': ['NNPS'],
  'Sunset': ['NNP'],
  'Sunshine': ['NNP'],
  'Suntory': ['NNP'],
  'Suntrust': ['NNP'],
  'Sununu': ['NNP'],
  'Sunward': ['NNP'],
  'Suominen': ['NNP'],
  'Suor': ['FW'],
  'Supavud': ['NNP'],
  'Super': ['NNP'],
  'Super-NOW': ['NNP'],
  'Super-Protein': ['NNP'],
  'Super-Set': ['NNP'],
  'Super-Sets': ['NNP'],
  'SuperDot': ['NNP'],
  'Supercomputers': ['NNPS'],
  'Superconcentrates': ['NNS'],
  'Superconductivity': ['NN'],
  'Superconductor': ['NNP'],
  'Superconductors': ['NNS'],
  'Supercritical': ['NNP'],
  'Superdome': ['NNP'],
  'Superfund': ['NNP'],
  'Superintendent': ['NNP'],
  'Superintendents': ['NNS'],
  'Superior': ['NNP'],
  'Superlative': ['NNP'],
  'Superman': ['NNP'],
  'Supermarket': ['NN'],
  'Supermarkets': ['NNS'],
  'Supermatic': ['JJ'],
  'Superposed': ['VBD'],
  'Superslim': ['NNP'],
  'Superslims': ['NNPS'],
  'Superstar': ['NNP'],
  'Superstate': ['NNP'],
  'Superstation': ['NNP'],
  'Superstition': ['NN'],
  'Superstitions': ['NNPS'],
  'Superstores': ['NNPS'],
  'Supervision': ['NNP'],
  'Supervisor': ['NNP'],
  'Supervisors': ['NNPS'],
  'Supper': ['NNP'],
  'Supplee': ['NNP'],
  'Supplement': ['NNP'],
  'Supplemental': ['NNP'],
  'Supplementary': ['NNP'],
  'Supplementing': ['VBG'],
  'Suppliers': ['NNS'],
  'Supplies': ['NNS'],
  'Supply': ['NNP'],
  'Supply-sider': ['NNP'],
  'Support': ['NNP'],
  'Supported': ['VBN'],
  'Supporters': ['NNS'],
  'Supporting': ['VBG'],
  'Supportive': ['JJ'],
  'Supports': ['VBZ'],
  'Suppose': ['VB'],
  'Supposedly': ['RB'],
  'Supposing': ['VBG'],
  'Suppression': ['NN'],
  'Supra-Expressionism': ['NNP'],
  'Supremacy': ['NN'],
  'Supreme': ['NNP'],
  'Supt.': ['NNP'],
  'Sur': ['FW'],
  'Surcliffe': ['NNP'],
  'Surcliffes': ['NNPS'],
  'Sure': ['RB'],
  'Sure-sure': ['JJ'],
  'Surely': ['RB'],
  'Suresh': ['NNP'],
  'Surety': ['NNP'],
  'Surface': ['NN'],
  'Surge': ['NNP'],
  'Surgeon': ['NNP'],
  'Surgeons': ['NNPS'],
  'Surgery': ['NNP'],
  'Surgical': ['NNP'],
  'Surging': ['VBG'],
  'Surlyn': ['NNP'],
  'Surmanek': ['NNP'],
  'Surplus': ['NNP'],
  'Surprise': ['NN'],
  'Surprised': ['VBN'],
  'Surprises': ['NNS'],
  'Surprising': ['JJ'],
  'Surprisingly': ['RB'],
  'Surrealists': ['NNS'],
  'Surrender': ['VB'],
  'Surrendering': ['VBG'],
  'Surrey': ['NNP'],
  'Surrounded': ['VBN'],
  'Surrounding': ['VBG'],
  'Survanta': ['NNP'],
  'Surveillance': ['NN'],
  'Survey': ['NNP'],
  'Surveying': ['VBG'],
  'Surveys': ['NNS'],
  'Survivability': ['NN'],
  'Survival': ['NNP'],
  'Survive': ['VB'],
  'Survived': ['VBD'],
  'Surviving': ['NNP'],
  'Survivors': ['NNS'],
  'Susan': ['NNP'],
  'Sushi': ['NN'],
  'Susie': ['NNP'],
  'Susitna': ['NNP'],
  'Suspect': ['JJ'],
  'Suspected': ['VBN'],
  'Suspecting': ['VBG'],
  'Suspension': ['NNP'],
  'Suspicion': ['NN'],
  'Susquehanna': ['NNP'],
  'Sussex': ['NNP'],
  'Sussman': ['NNP'],
  'Sustaining': ['VBG'],
  'Susumu': ['NNP'],
  'Sut': ['NNP'],
  'Sutcliffe': ['NNP'],
  'Sutermeister': ['NNP'],
  'Sutherland': ['NNP'],
  'Sutpen': ['NNP'],
  'Sutra': ['NN'],
  'Sutro': ['NNP'],
  'Suttle': ['NNP'],
  'Sutton': ['NNP'],
  'Sutz': ['NNP'],
  'Suu': ['NNP'],
  'Suvorov': ['NNP'],
  'Suzanne': ['NNP'],
  'Suzman': ['NNP'],
  'Suzuka': ['NNP'],
  'Suzuki': ['NNP'],
  'Suzy': ['NNP'],
  'Sven': ['NNP'],
  'Svensk': ['NNP'],
  'Svenska': ['NNP'],
  'Svenskarna': ['FW'],
  'Sventek': ['NNP'],
  'Sverdlovsk': ['NNP'],
  'Svevo': ['NNP'],
  'Swadesh': ['NNP'],
  'Swaggart': ['NNP'],
  'Swahili': ['NNP'],
  'Swaine': ['NNP'],
  'Swallow': ['NNP'],
  'Swallow-Barn': ['NNP'],
  'Swamped': ['VBN'],
  'Swan': ['NNP'],
  'Swank': ['NNP'],
  'Swansea': ['NNP'],
  'Swanson': ['NNP'],
  'Swapo': ['NNP'],
  'Swaps': ['NNS'],
  'Swartz': ['NNP'],
  'Swasey': ['NNP'],
  'Swavely': ['NNP'],
  'Sweanor': ['NNP'],
  'Swearingen': ['NNP'],
  'Swears': ['VBZ'],
  'Sweat': ['NN'],
  'Sweathouse': ['NN'],
  'Sweating': ['VBG'],
  'Sweaty': ['JJ'],
  'Sweazey': ['NNP'],
  'Swed': ['NNP'],
  'SwedBank': ['NNP'],
  'Swede': ['NN'],
  'Sweden': ['NNP'],
  'Swedes': ['NNPS'],
  'Swedish': ['JJ'],
  'Swedish-Swiss': ['JJ'],
  'Sween': ['NNP'],
  'Sweeney': ['NNP'],
  'Sweeneys': ['NNPS'],
  'Sweeping': ['VBG'],
  'Sweepstakes': ['NNP'],
  'Sweet': ['NNP'],
  'Sweet-scented': ['JJ'],
  'Sweet-sour': ['JJ'],
  'Sweetener': ['NNP'],
  'Sweezey': ['NNP'],
  'Sweig': ['NNP'],
  'Swelling': ['JJ'],
  'Swenson': ['NNP'],
  'Swept': ['VBN'],
  'Swift': ['NNP'],
  'Swiftly': ['RB'],
  'Swifts': ['NNPS'],
  'Swiggett': ['NNP'],
  'Swim': ['NNP'],
  'Swinburne': ['NNP'],
  'Swine': ['JJ'],
  'Swing': ['NNP'],
  'Swingin': ['NNP'],
  'Swinging': ['VBG'],
  'Swink': ['NNP'],
  'Swire': ['NNP'],
  'Swirsky': ['NNP'],
  'Swisher': ['NNP'],
  'Swiss': ['JJ'],
  'Swiss-German': ['JJ'],
  'Swiss-based': ['JJ'],
  'Swiss-born': ['JJ'],
  'Swiss-cheese': ['NN'],
  'Swiss-franc': ['NN'],
  'Swissair': ['NNP'],
  'Swissmade': ['JJ'],
  'Switch': ['NN'],
  'Switches': ['NNS'],
  'Switchgear': ['NNP'],
  'Switzer': ['NNP'],
  'Switzerland': ['NNP'],
  'Switzerland-based': ['JJ'],
  'Swiveling': ['VBG'],
  'Sword': ['NNP'],
  'Sy': ['NNP'],
  'Syb': ['NNP'],
  'Sybase': ['NNP'],
  'Sybert': ['NNP'],
  'Sybil': ['NNP'],
  'Sybron': ['NNP'],
  'Sydney': ['NNP'],
  'Sydney-based': ['JJ'],
  'Syed': ['NNP'],
  'Syferd': ['NNP'],
  'Sykes': ['NNP'],
  'Syllabicity': ['NN'],
  'Syllabification': ['NN'],
  'Syllables': ['NNS'],
  'Sylmar': ['NNP'],
  'Sylphide': ['NNP'],
  'Sylvan': ['NNP'],
  'Sylvania': ['NNP'],
  'Sylvester': ['NNP'],
  'Sylvia': ['NNP'],
  'Sylvie': ['NNP'],
  'Sylvio': ['NNP'],
  'Symantec': ['NNP'],
  'Symbion': ['NNP'],
  'Symbol': ['NN'],
  'Symbol:HRB': ['NNP'],
  'Symbolist': ['NNP'],
  'Symbolizing': ['VBG'],
  'Symes': ['NNP'],
  'Symington': ['NNP'],
  'Symms': ['NNP'],
  'Symonds': ['NNP'],
  'Symons': ['NNP'],
  'Sympathy': ['NN'],
  'Symphony': ['NNP'],
  'Symposium': ['NNP'],
  'Symptomatic': ['JJ'],
  'Syms': ['NNP'],
  'SynOptics': ['NNPS'],
  'Synar': ['NNP'],
  'Synbiotics': ['NNP'],
  'Sync': ['NN'],
  'Synchronized': ['VBN'],
  'Syncor': ['NNP'],
  'Syndic': ['NNP'],
  'Syndicate': ['NNP'],
  'Syndicated': ['NNP'],
  'Syndicates': ['NNS'],
  'Syndication': ['NNP'],
  'Syndrome': ['NNP'],
  'Synergistics': ['NNP'],
  'Synod': ['NNP'],
  'Syntex': ['NNP'],
  'Synthelabo': ['NNP'],
  'Synthetic': ['JJ'],
  'Syracuse': ['NNP'],
  'Syrdarya': ['NNP'],
  'Syria': ['NNP'],
  'Syrian': ['JJ'],
  'Syrian-backed': ['JJ'],
  'Syrians': ['NNPS'],
  'Sysco': ['NNP'],
  'Syse': ['NNP'],
  'System': ['NNP'],
  'System-specific': ['JJ'],
  'SystemOne': ['NNP'],
  'Systematically': ['RB'],
  'Systeme': ['NNP'],
  'Systemic': ['JJ'],
  'Systems': ['NNPS'],
  'Systemwide': ['JJ'],
  'Systran': ['NNP'],
  'Szabad': ['NNP'],
  'Szanton': ['NNP'],
  'Szelenyi': ['NNP'],
  'Szeto': ['NNP'],
  'Szocs': ['NNP'],
  'Szold': ['NNP'],
  'Szolds': ['NNPS'],
  'Szuros': ['NNP'],
  'T': ['NN'],
  'T\'ai-Shan': ['NNP'],
  'T\'ien': ['NNP'],
  'T-1000': ['NNP'],
  'T-1600': ['NNP'],
  'T-34': ['NN'],
  'T-37': ['NN'],
  'T-38': ['NN'],
  'T-45': ['NNP'],
  'T-72': ['NN'],
  'T-Max': ['NNP'],
  'T-Mobile': ['NNP'],
  'T-bill': ['NN'],
  'T-bills': ['NNS'],
  'T-bond': ['JJ'],
  'T-cell': ['NN'],
  'T-helper': ['NN'],
  'T-shirt': ['NN'],
  'T-shirts': ['NNS'],
  'T.': ['NNP'],
  'T.B.': ['NNP'],
  'T.D.': ['NNP'],
  'T.E.': ['NNP'],
  'T.F.': ['NNP'],
  'T.H.': ['NNP'],
  'T.J.': ['NNP'],
  'T.M.B.': ['NNP'],
  'T.R.': ['NNP'],
  'T.S.': ['NNP'],
  'T.T.': ['NNP'],
  'T.V.': ['NNP'],
  'T.W.': ['NNP'],
  'T34C': ['CD'],
  'T4': ['CD'],
  'T8': ['NNP'],
  'TA': ['NNP'],
  'TAINTS': ['VBZ'],
  'TAKEOVER': ['NN'],
  'TAKING': ['VBG'],
  'TALENT': ['NN'],
  'TALK': ['NNP'],
  'TALKS': ['VBZ'],
  'TAMMY': ['NNP'],
  'TAMPA': ['NNP'],
  'TANDEM': ['NNP'],
  'TARP': ['NNP'],
  'TASS': ['NNP'],
  'TASTY': ['JJ'],
  'TAX': ['NN'],
  'TAXPAYERS': ['NNS'],
  'TB': ['NN'],
  'TBS': ['NNP'],
  'TBWA': ['NNP'],
  'TC': ['NNP'],
  'TCF': ['NNP'],
  'TCI': ['NNP'],
  'TCMP': ['NNP'],
  'TCR': ['NNP'],
  'TCU': ['NNP'],
  'TD': ['NNP'],
  'TDK': ['NNP'],
  'TEA': ['NNP'],
  'TEACH': ['VB'],
  'TEACHERS': ['NNP'],
  'TEAMSTERS': ['NNPS'],
  'TECHNOLOGIES': ['NNP'],
  'TECHNOLOGY': ['NNP'],
  'TECO': ['NNP'],
  'TED': ['NNP'],
  'TEDs': ['NNS'],
  'TEK': ['NNP'],
  'TELESIS': ['NNP'],
  'TELEVISION': ['NN'],
  'TELV': ['NNP'],
  'TEMPORARY': ['JJ'],
  'TEP': ['NNP'],
  'TESTS': ['NNS'],
  'TEXAS': ['NNP'],
  'TGS': ['NNP'],
  'THACHER': ['NNP'],
  'THAN': ['IN'],
  'THANK': ['VB'],
  'THANKS': ['NNS'],
  'THAT': ['WDT'],
  'THC': ['NNP'],
  'THE': ['DT'],
  'THERE\'S': ['VB'],
  'THF': ['NNP'],
  'THIDIU': ['NNP'],
  'THIEVES': ['NNS'],
  'THINK': ['VB'],
  'THIS': ['PRP'],
  'THOSE': ['DT'],
  'THR': ['NNP'],
  'THREAT': ['NN'],
  'THREE': ['CD'],
  'THROUGHOUT': ['IN'],
  'THYSELF': ['PRP'],
  'TI': ['NNP'],
  'TIGRs': ['NNP'],
  'TILT': ['NN'],
  'TIME': ['NN'],
  'TIMES': ['NNP'],
  'TINTING': ['NN'],
  'TIP': ['NN'],
  'TIPS': ['NNS'],
  'TIRED': ['JJ'],
  'TIRES': ['NNS'],
  'TML': ['NNP'],
  'TND.B': ['NNP'],
  'TNF': ['NNP'],
  'TNN': ['NNP'],
  'TNT': ['NNP'],
  'TO': ['TO'],
  'TODAY': ['NNP'],
  'TOOK': ['NNP'],
  'TOOLWORKS': ['NNP'],
  'TOP': ['NNP'],
  'TOPAZ': ['NNP'],
  'TOPIC': ['NN'],
  'TOURISM': ['NN'],
  'TOW': ['NN'],
  'TOYOTA\'S': ['NNP'],
  'TPA': ['NNP'],
  'TPS': ['NNP'],
  'TR': ['NNP'],
  'TR.': ['NNP'],
  'TRACY-LOCKE': ['NNP'],
  'TRADE': ['NN'],
  'TRADING': ['NN'],
  'TRANSAMERICA': ['NNP'],
  'TRANSCANADA': ['NNP'],
  'TRANSFER': ['NN'],
  'TRANSPLANT': ['NNP'],
  'TRANSPORTATION': ['NNP'],
  'TRAVEL': ['NN'],
  'TRAVELS': ['VBZ'],
  'TRC': ['NNP'],
  'TREASURY': ['NNP'],
  'TREAT': ['NN'],
  'TREATING': ['VBG'],
  'TREND-SETTER': ['NN'],
  'TRIAD': ['NNP'],
  'TRIAL': ['NN'],
  'TRIMMING': ['VBG'],
  'TRIPS': ['NNS'],
  'TRO': ['NN'],
  'TROUBLES': ['NNS'],
  'TROs': ['NNS'],
  'TRS-80': ['NNP'],
  'TRT': ['NNP'],
  'TRUCK': ['NNP'],
  'TRUE': ['JJ'],
  'TRUST': ['NNP'],
  'TRUSTEE': ['NN'],
  'TRUSTS': ['NNS'],
  'TRV': ['NNP'],
  'TRW': ['NNP'],
  'TSB': ['NNP'],
  'TSEM': ['NN'],
  'TSH': ['NNP'],
  'TSH-treated': ['JJ'],
  'TUC': ['NNP'],
  'TUCSON': ['NNP'],
  'TUMBLE': ['JJ'],
  'TURMOIL': ['NN'],
  'TURNS': ['VBZ'],
  'TV': ['NN'],
  'TV-Cable': ['NNP'],
  'TV-production': ['JJ'],
  'TVA': ['NNP'],
  'TVS': ['NNP'],
  'TVSM': ['NNP'],
  'TVX': ['NNP'],
  'TVs': ['NNS'],
  'TVwhich': ['NNP'],
  'TW': ['NNP'],
  'TWA': ['NNP'],
  'TWO': ['CD'],
  'TWO-A-DAY': ['JJ'],
  'TWX': ['NNP'],
  'TXO': ['NNP'],
  'T\\\'/A': ['NNP'],
  'Ta-Hu-Wa-Hu-Wai': ['NNP'],
  'Tabacs': ['NNP'],
  'Tabak': ['NNP'],
  'Tabarro': ['FW'],
  'Tabb': ['NNP'],
  'Tabellen': ['FW'],
  'Taber': ['NNP'],
  'Tabernacle': ['NNP'],
  'Tabit': ['NNP'],
  'Table': ['NN'],
  'Tables': ['NNS'],
  'Tabs': ['NNS'],
  'Tabuchi': ['NNP'],
  'Taccetta': ['NNP'],
  'Tache': ['NNP'],
  'Tacit': ['NNP'],
  'Tacitus': ['NNP'],
  'Tack': ['NN'],
  'Tack-solder': ['VB'],
  'Tacker': ['NNP'],
  'Tackle': ['NNP'],
  'Tackles': ['VBZ'],
  'Tacloban': ['NNP'],
  'Taco': ['NNP'],
  'Tacoma': ['NNP'],
  'Taconic': ['NNP'],
  'Tact': ['NN'],
  'Tactical': ['NNP'],
  'Tactically': ['RB'],
  'Tactics': ['NNS'],
  'Tad': ['NNP'],
  'Tadahiko': ['NNP'],
  'Tadashi': ['NNP'],
  'Tadeusz': ['NNP'],
  'Tadzhikistan': ['NNP'],
  'Tae': ['NNP'],
  'Taek': ['NNP'],
  'Taff': ['NNP'],
  'Taffner': ['NNP'],
  'Taft': ['NNP'],
  'Taft-Hartley': ['NNP'],
  'Tagalog': ['NNP'],
  'Tagamet': ['NNP'],
  'Tagg': ['NNP'],
  'Tagliabue': ['NNP'],
  'Tahiti': ['NNP'],
  'Tahitian': ['JJ'],
  'Tahoe': ['NNP'],
  'Tahse': ['NNP'],
  'Tai': ['NNP'],
  'Taif': ['NNP'],
  'Taikisha': ['NNP'],
  'Tail': ['NNP'],
  'Tailback': ['NNP'],
  'Tailin': ['NN'],
  'Tailors': ['NNP'],
  'Taipei': ['NNP'],
  'Taisei': ['NNP'],
  'Taisho': ['NNP'],
  'Tait': ['NNP'],
  'Taito': ['NNP'],
  'Taittinger': ['NNP'],
  'Taiwan': ['NNP'],
  'Taiwan-born': ['JJ'],
  'Taiwanese': ['JJ'],
  'Taiyo': ['NNP'],
  'Taizo': ['NNP'],
  'Taj': ['NNP'],
  'Takaezu': ['NNP'],
  'Takagi': ['NNP'],
  'Takahashi': ['NNP'],
  'Takako': ['NNP'],
  'Takakura': ['NNP'],
  'Takamori': ['NNP'],
  'Takanashi': ['NNP'],
  'Takanori': ['NNP'],
  'Takao': ['NNP'],
  'Takasago': ['NNP'],
  'Takashi': ['NNP'],
  'Takashima': ['NNP'],
  'Takashimaya': ['NNP'],
  'Takayama': ['NNP'],
  'Take': ['VB'],
  'Take-up': ['JJ'],
  'Taken': ['VBN'],
  'Takeover': ['NN'],
  'Takeover-stock': ['JJ'],
  'Takeovers': ['NNS'],
  'Takes': ['VBZ'],
  'Takeshi': ['NNP'],
  'Takihyo': ['NNP'],
  'Takimura': ['NNP'],
  'Taking': ['VBG'],
  'Takoma': ['NNP'],
  'Taksim': ['NNP'],
  'Takuma': ['NNP'],
  'Takuro': ['NNP'],
  'Takushoku': ['NNP'],
  'Talbot': ['NNP'],
  'Talbott': ['NNP'],
  'Talcott': ['NNP'],
  'Tale': ['NN'],
  'Talent': ['NN'],
  'Tales': ['NNS'],
  'Taliesin': ['NNP'],
  'Talk': ['NN'],
  'Talking': ['VBG'],
  'Talks': ['NNS'],
  'Tall': ['JJ'],
  'Tallahassee': ['NNP'],
  'Tallahatchie': ['NNP'],
  'Tallahoosa': ['NNP'],
  'Tallarico': ['NNP'],
  'Tallchief': ['NNP'],
  'Talley': ['NNP'],
  'Talleyrand': ['NNP'],
  'Talmadge': ['NNP'],
  'Talmo': ['NNP'],
  'Talmud': ['NNP'],
  'Talon': ['NNP'],
  'Talsky': ['NNP'],
  'Talton': ['NNP'],
  'Talyzin': ['NNP'],
  'Tama': ['NNP'],
  'Tamales': ['NNPS'],
  'Tamar': ['NNP'],
  'Tamara': ['NNP'],
  'Tamarijn': ['NNP'],
  'Tambo': ['NNP'],
  'Tambrands': ['NNP'],
  'Tamerlane': ['NNP'],
  'Tamil': ['NNP'],
  'Taming': ['VBG'],
  'Tamiris': ['NNP'],
  'Tamiris-Daniel': ['NNP'],
  'Tamm': ['NNP'],
  'Tammany': ['NNP'],
  'Tammen': ['NNP'],
  'Tammy': ['NNP'],
  'Tamotsu': ['NNP'],
  'Tampa': ['NNP'],
  'Tampa-based': ['JJ'],
  'Tampa.': ['NNP'],
  'Tampering': ['VBG'],
  'Tan': ['NNP'],
  'Tana': ['NNP'],
  'Tanabe': ['NNP'],
  'Tanaka': ['NNP'],
  'Tancred': ['NNP'],
  'Tandem': ['NNP'],
  'Tandler': ['NNP'],
  'Tandy': ['NNP'],
  'Taney': ['NNP'],
  'Tanganika': ['NNP'],
  'Tangible': ['JJ'],
  'Tango': ['NNP'],
  'Tanii': ['NNP'],
  'Tanin': ['FW'],
  'Tank': ['NNP'],
  'Tanker': ['NNP'],
  'Tankers': ['NNS'],
  'Tanks': ['NNS'],
  'Tannenbaum': ['NNP'],
  'Tanner': ['NNP'],
  'Tannhaeuser': ['NNP'],
  'Tanny': ['NNP'],
  'Tanqueray': ['NNP'],
  'Tanzi': ['NNP'],
  'Tanzman': ['NNP'],
  'Tao': ['NNP'],
  'Taoism': ['NNP'],
  'Taoist': ['NNP'],
  'Taoists': ['NNP'],
  'Taos': ['NNP'],
  'Tap': ['VB'],
  'Tape': ['NN'],
  'Taped': ['VBN'],
  'Taper': ['NNP'],
  'Tapley': ['NNP'],
  'Tappan': ['NNP'],
  'Tappets': ['NNS'],
  'Taps': ['VBZ'],
  'Tar': ['NNP'],
  'Tara': ['NNP'],
  'Taraday': ['NNP'],
  'Tarantino': ['NNP'],
  'Taras': ['NNP'],
  'Taras-Tchaikovsky': ['NNP'],
  'Tarboro': ['NNP'],
  'Tardily': ['RB'],
  'Tareytown': ['NNP'],
  'Target': ['NNP'],
  'Targets': ['VBZ'],
  'Targetted': ['NNP'],
  'Targo': ['JJ'],
  'Tarheelia': ['NNP'],
  'Tariff': ['NN'],
  'Tariffs': ['NNPS'],
  'Tarkeshian': ['NNP'],
  'Tarkington': ['NNP'],
  'Tarmac': ['NNP'],
  'Tarnoff': ['NNP'],
  'Tarnopol': ['NNP'],
  'Tarot-like': ['JJ'],
  'Tarrant': ['NNP'],
  'Tarrytown': ['NNP'],
  'Tartaglia': ['NNP'],
  'Tartan': ['NNP'],
  'Tartar': ['JJ'],
  'Tartarughe': ['NNP'],
  'Tartary': ['NNP'],
  'Tarter': ['NNP'],
  'Tartikoff': ['NNP'],
  'Tartuffe': ['NNP'],
  'Taruffi': ['NNP'],
  'Tarwhine': ['NNP'],
  'Tarzan': ['NNP'],
  'Tarzana': ['NNP'],
  'Tasaki': ['NNP'],
  'Tasaki-Riger': ['NNP'],
  'Tascher': ['NNP'],
  'Taschereau': ['NNP'],
  'Tash': ['NNP'],
  'Tashi': ['NNP'],
  'Tashjian': ['NNP'],
  'Tashkent': ['NNP'],
  'Task': ['NNP'],
  'Tasmania': ['NNP'],
  'Tass': ['NNP'],
  'Tassel': ['NNP'],
  'Tassinari': ['NNP'],
  'Tasso': ['NNP'],
  'Taste': ['NN'],
  'Taster': ['NNP'],
  'Tastes': ['NNPS'],
  'Tasti-Freeze': ['NNP'],
  'Tasuku': ['NNP'],
  'Tasurinchi': ['NNP'],
  'Tata': ['NNP'],
  'Tatanga': ['NNP'],
  'Tate': ['NNP'],
  'Tateishi': ['NNP'],
  'Tateisi': ['NNP'],
  'Tatian': ['NNP'],
  'Tatler': ['NNP'],
  'Tatman': ['NNP'],
  'Tator': ['NNP'],
  'Tatras': ['NNS'],
  'Tatsuhara': ['NNP'],
  'Tatsunori': ['NNP'],
  'Tattingers': ['NNPS'],
  'Tatzel': ['NNP'],
  'Tau': ['NNP'],
  'Taubman': ['NNP'],
  'Taught': ['VBN'],
  'Taui': ['NNP'],
  'Tauke': ['NNP'],
  'Taunton': ['NNP'],
  'Taurida': ['NNP'],
  'Taurog': ['NNP'],
  'Taurus': ['NNP'],
  'Taussig': ['NNP'],
  'Taviani': ['NNP'],
  'Tavoy': ['NNP'],
  'Tawana': ['NNP'],
  'Tawes': ['NNP'],
  'Tawney': ['NNP'],
  'Tax': ['NNP'],
  'Tax-exempt': ['JJ'],
  'Tax-exempts': ['NNS'],
  'Tax-free': ['JJ'],
  'Tax-loss': ['NN'],
  'Taxable': ['NNP'],
  'Taxation': ['NNP'],
  'Taxes': ['NNS'],
  'Taxi': ['NN'],
  'Taxing': ['VBG'],
  'Taxonomists': ['NNS'],
  'Taxpayer': ['NN'],
  'Taxpayers': ['NNS'],
  'Taylor': ['NNP'],
  'Taylors': ['NNPS'],
  'Tbilisi': ['NNP'],
  'Tbond': ['JJ'],
  'Tchaikovsky': ['NNP'],
  'Tchalo': ['FW'],
  'Tea': ['NNP'],
  'Teach': ['VBP'],
  'Teacher': ['NN'],
  'Teachers': ['NNPS'],
  'Teaching': ['NN'],
  'Teagan': ['NNP'],
  'Teagarden': ['NNP'],
  'Teague': ['NNP'],
  'Team': ['NNP'],
  'Teams': ['NNS'],
  'Teamsters': ['NNPS'],
  'Teaneck': ['NNP'],
  'Tearle': ['NNP'],
  'Tears': ['NNS'],
  'Teatime': ['NN'],
  'Teatro': ['NNP'],
  'Tebuthiuron': ['NN'],
  'Tech': ['NNP'],
  'Tech-Sym': ['NNP'],
  'TechDesign': ['NNP'],
  'Techcorps': ['NNP'],
  'Technical': ['NNP'],
  'Technical-chart': ['JJ'],
  'Technically': ['RB'],
  'Technician': ['NNP'],
  'Technicians': ['NNPS'],
  'Technik': ['NNP'],
  'Technique': ['NN'],
  'Techniques': ['NNPS'],
  'Technodyne': ['NNP'],
  'Technological': ['NNP'],
  'Technologies': ['NNP'],
  'Technology': ['NNP'],
  'Technomic': ['NNP'],
  'Teck': ['NNP'],
  'Tecumseh': ['NNP'],
  'Ted': ['NNP'],
  'Teddy': ['NNP'],
  'Tedi': ['NNP'],
  'Tee': ['NNP'],
  'Tee-wah': ['NNP'],
  'Teeley': ['NNP'],
  'Teen': ['NNPS'],
  'Teen-age': ['JJ'],
  'Teen-agers': ['NNS'],
  'Teenage': ['NNP'],
  'Teens': ['NNS'],
  'Teerlink': ['NNP'],
  'Teeter': ['NNP'],
  'Teeth': ['NNS'],
  'Teferi': ['NNP'],
  'Teflon': ['NNP'],
  'Tegal': ['NNP'],
  'Tegner': ['NNP'],
  'Tegretol': ['NNP'],
  'Tegucigalpa': ['NNP'],
  'Teheran': ['NNP'],
  'Tehran': ['NNP'],
  'Teich': ['NNP'],
  'Teijin': ['NNP'],
  'Teikoku': ['NNP'],
  'Teipel': ['NNP'],
  'Teito': ['NNP'],
  'Teixeira': ['NNP'],
  'Teknowledge': ['NNP'],
  'Tektronix': ['NNP'],
  'Tel': ['NNP'],
  'Tela': ['NNP'],
  'Telaction': ['NNP'],
  'Tele-Communications': ['NNP'],
  'Tele1st': ['NNP'],
  'TeleCable': ['NNP'],
  'TeleVideo': ['NNP'],
  'Telecharge': ['NNP'],
  'Telecom': ['NNP'],
  'Telecommuncations': ['NNPS'],
  'Telecommunications': ['NNPS'],
  'Telectronics': ['NNP'],
  'Telecussed': ['VBD'],
  'Teleflora': ['NNP'],
  'Telefonica': ['NNP'],
  'Telefonos': ['NNP'],
  'Telefunken': ['NN'],
  'Telegraaf': ['NNP'],
  'Telegraph': ['NNP'],
  'Telegraphers': ['NNS'],
  'Telegraphie': ['NNP'],
  'Telelawyer': ['NNP'],
  'Telemann': ['NNP'],
  'Telemedia': ['NNP'],
  'Telemetries': ['NNPS'],
  'Telemunchen': ['NNP'],
  'Telemundo': ['NNP'],
  'Telenet': ['NNP'],
  'Telephone': ['NNP'],
  'Telephone-operations': ['NNS'],
  'Telephones': ['NNP'],
  'Telepictures': ['NNPS'],
  'Teleport': ['NNP'],
  'Teleprompter': ['NNP'],
  'Telerama': ['NNP'],
  'Telerate': ['NNP'],
  'Telescope': ['NNP'],
  'Telesis': ['NNP'],
  'Telesphere': ['NNP'],
  'Telesystems': ['NNP'],
  'Teletrac': ['NNP'],
  'Teletypes': ['NNS'],
  'Television': ['NNP'],
  'Television-Electronics': ['NNP'],
  'Telex': ['NN'],
  'Telford': ['NNP'],
  'Telford-made': ['JJ'],
  'Tell': ['VB'],
  'Teller': ['NNP'],
  'Telli': ['NNP'],
  'Tellier': ['NNP'],
  'Telling': ['VBG'],
  'Tells': ['VBZ'],
  'Telmex': ['NNP'],
  'Telos': ['NNP'],
  'Telsmith': ['NNP'],
  'Telxon': ['NNP'],
  'Telzrow': ['NNP'],
  'Tempe': ['NNP'],
  'Temper': ['NN'],
  'Temperature': ['NN'],
  'Temperatures': ['NNS'],
  'Tempering': ['VBG'],
  'Tempesst': ['NNP'],
  'Tempest': ['NNP'],
  'Temple': ['NNP'],
  'Temple-Inland': ['NNP'],
  'Templeman': ['NNP'],
  'Templeton': ['NNP'],
  'Tempo': ['NNP'],
  'Temporary': ['JJ'],
  'Tempos': ['NNS'],
  'Temptation': ['NN'],
  'Tempter': ['NNP'],
  'Ten': ['CD'],
  'Ten-thousand-dollar': ['JJ'],
  'Ten-year': ['JJ'],
  'Ten-year-old': ['NNP'],
  'Tenants': ['NNPS'],
  'Tend': ['VBP'],
  'Tenda': ['NNP'],
  'Tender': ['NN'],
  'Tendered': ['JJ'],
  'Tenderfoot': ['NN'],
  'Tenderloin': ['NNP'],
  'Tenderly': ['RB'],
  'Tenders': ['NNS'],
  'Tenements': ['NNS'],
  'Teniente': ['NNP'],
  'Tenite': ['NNP'],
  'Tenn': ['NNP'],
  'Tenn.': ['NNP'],
  'Tenn.-based': ['JJ'],
  'Tennant': ['NNP'],
  'Tenneco': ['NNP'],
  'Tennenbaum': ['NNP'],
  'Tennesse': ['NNP'],
  'Tennessean': ['NNP'],
  'Tennessee': ['NNP'],
  'Tenney': ['NNP'],
  'Tennis': ['NNP'],
  'Tennyson': ['NNP'],
  'Tens': ['NNS'],
  'Tensile': ['JJ'],
  'Tensing': ['NNP'],
  'Tension': ['NN'],
  'Tensions': ['NNPS'],
  'Tentative': ['JJ'],
  'Tenth': ['NNP'],
  'Tenure': ['NN'],
  'Teodorani': ['NNP'],
  'Teodulo': ['NNP'],
  'Tepid': ['NNP'],
  'Tepper': ['NNP'],
  'Tequila': ['NNP'],
  'Ter-Arutunian': ['NNP'],
  'Ter-Stepanova': ['NNP'],
  'Ter.': ['NN'],
  'Teraoka': ['NNP'],
  'Tercel': ['NNP'],
  'Terence': ['NNP'],
  'Teresa': ['NNP'],
  'Terex': ['NNP'],
  'Terg-O-Tometer': ['NNP'],
  'Term': ['NN'],
  'Terminal': ['NNP'],
  'Terminaling': ['NNP'],
  'Terminals': ['NNS'],
  'Terminating': ['VBG'],
  'Termination': ['NN'],
  'Terminator': ['NNP'],
  'Terminiello': ['NNP'],
  'Terms': ['NNS'],
  'Terpers': ['NNPS'],
  'Terra': ['NNP'],
  'Terrace': ['NNP'],
  'Terral': ['NNP'],
  'Terramycin': ['NN'],
  'Terranomics': ['NNS'],
  'Terree': ['NNP'],
  'Terrell': ['NNP'],
  'Terrence': ['NNP'],
  'Terrible': ['NNP'],
  'Terrier': ['NNP'],
  'Territorial': ['NNP'],
  'Territories': ['NNP'],
  'Territory': ['NNP'],
  'Terrizzi': ['NNP'],
  'Terror': ['NN'],
  'Terrorism': ['NNP'],
  'Terrours': ['NNS'],
  'Terry': ['NNP'],
  'Tertre': ['NNP'],
  'Teschner': ['NNP'],
  'Tesco': ['NNP'],
  'Tese': ['NNP'],
  'Teslik': ['NNP'],
  'Tesoro': ['NNP'],
  'Tess': ['NNP'],
  'Tessie': ['NNP'],
  'Tessler': ['NNP'],
  'Test': ['NNP'],
  'Test-preparation': ['JJ'],
  'Testa': ['NNP'],
  'Testament': ['NNP'],
  'Testament-style': ['JJ'],
  'Testaments': ['NNP'],
  'Testicular': ['NNP'],
  'Testifies': ['VBZ'],
  'Testifying': ['VBG'],
  'Testimony': ['NN'],
  'Testing': ['NN'],
  'Tests': ['NNS'],
  'Testy': ['JJ'],
  'Tet': ['NNP'],
  'Tetanus': ['NN'],
  'Teter': ['NNP'],
  'Tetley': ['NNP'],
  'Tetrameron': ['NNP'],
  'Tetris': ['NN'],
  'Tettamanti': ['NNP'],
  'Teutonic': ['JJ'],
  'Tevye': ['NNP'],
  'Tewary': ['NNP'],
  'Tewfik': ['NNP'],
  'Tewksbury': ['NNP'],
  'Tex': ['NNP'],
  'Tex-Mex': ['NNP'],
  'Tex.': ['NNP'],
  'Texaco': ['NNP'],
  'Texan': ['NNP'],
  'Texans': ['NNPS'],
  'Texas': ['NNP'],
  'Texas-Louisiana': ['NNP'],
  'Texas-based': ['JJ'],
  'Texasness': ['NN'],
  'Texoma': ['NNP'],
  'Text': ['NN'],
  'Textbook': ['NN'],
  'Textbooks': ['NNS'],
  'Textile': ['NNP'],
  'Textiles': ['NNP'],
  'Textron': ['NNP'],
  'Texts': ['NNS'],
  'Thacher': ['NNP'],
  'Thackeray': ['NNP'],
  'Thad': ['NNP'],
  'Thaddeus': ['NNP'],
  'Thai': ['NNP'],
  'Thai-Cambodian': ['JJ'],
  'Thailand': ['NNP'],
  'Thais': ['NNPS'],
  'Thakhek': ['NNP'],
  'Thal': ['NNP'],
  'Thalbergs': ['NNPS'],
  'Thaler': ['NNP'],
  'Thalmann': ['NNP'],
  'Thames': ['NNP'],
  'Thamnophis': ['NNS'],
  'Than': ['IN'],
  'Thanh': ['NNP'],
  'Thank': ['VB'],
  'Thankful': ['JJ'],
  'Thanks': ['NNS'],
  'Thanksgiving': ['NNP'],
  'Thant': ['NNP'],
  'Tharp': ['NNP'],
  'That': ['DT'],
  'That\'s': ['VBZ'],
  'That-a-way': ['RB'],
  'Thatcher': ['NNP'],
  'Thatcher-style': ['JJ'],
  'Thatcherian': ['JJ'],
  'Thatcherism': ['NNP'],
  'Thatcherite': ['JJ'],
  'Thaxter': ['NNP'],
  'Thaxters': ['NNPS'],
  'Thay': ['NN'],
  'Thayer': ['NNP'],
  'The': ['DT'],
  'The\'burbs': ['NNPS'],
  'The\'lock-in': ['JJ'],
  'The\'separatist': ['NN'],
  'The\'takeover': ['JJR'],
  'Thea': ['NNP'],
  'Theater': ['NNP'],
  'Theaters': ['NNS'],
  'Theatre': ['NNP'],
  'Theatre-by-the-Sea': ['NNP'],
  'Theatres': ['NNP'],
  'Thee': ['PRP'],
  'Theft': ['NN'],
  'Thefts': ['NNS'],
  'Their': ['PRP\$'],
  'Theirs': ['JJ'],
  'Thelma': ['NNP'],
  'Them': ['PRP'],
  'Thema': ['NNP'],
  'Then': ['RB'],
  'Then-Navy': ['NNP'],
  'Thence': ['RB'],
  'Thenceforth': ['NN'],
  'Theo': ['NNP'],
  'Theo-Dur': ['NNP'],
  'Theocracy': ['NN'],
  'Theodor': ['NNP'],
  'Theodore': ['NNP'],
  'Theodosian': ['JJ'],
  'Theodosius': ['NNP'],
  'Theological': ['NNP'],
  'Theology': ['NNP'],
  'Theon': ['NNP'],
  'Theorem': ['NN'],
  'Theoretical': ['JJ'],
  'Theoretically': ['RB'],
  'Theories': ['NNPS'],
  'Theorists': ['NNS'],
  'Theory': ['NNP'],
  'Theran': ['NNP'],
  'Therapeutics': ['NNPS'],
  'Therapy': ['NNP'],
  'There': ['EX'],
  'There\'a': ['NN'],
  'There\'s': ['NNS'],
  'Thereafter': ['RB'],
  'Thereby': ['RB'],
  'Therefore': ['RB'],
  'Theresa': ['NNP'],
  'Therese': ['NNP'],
  'Thereupon': ['RB'],
  'Thermal': ['JJ'],
  'Thermedics': ['NNP'],
  'Thermo': ['NNP'],
  'Thermoforming': ['VBG'],
  'Thermogravimetric': ['JJ'],
  'Thermometer': ['NNP'],
  'Thermopylae': ['NNP'],
  'These': ['DT'],
  'Thesis': ['NN'],
  'Thevenot': ['NNP'],
  'Thevenow': ['NNP'],
  'They': ['PRP'],
  'They\'re': ['VB'],
  'Thi': ['NNP'],
  'Thiebaud': ['NNP'],
  'Thief': ['NN'],
  'Thiele': ['NNP'],
  'Thielsch': ['NNP'],
  'Thieme': ['NNP'],
  'Thiep': ['NNP'],
  'Thierry': ['NNP'],
  'Thieu': ['NNP'],
  'Thieves': ['NNS'],
  'Thin': ['JJ'],
  'Thing': ['NNP'],
  'Things': ['NNS'],
  'Think': ['VBP'],
  'Thinking': ['VBG'],
  'Thiokol': ['NNP'],
  'Thiot': ['NNP'],
  'Third': ['NNP'],
  'Third-Period': ['JJ'],
  'Third-Quarter': ['JJ'],
  'Third-party': ['JJ'],
  'Third-period': ['JJ'],
  'Third-quarter': ['JJ'],
  'Thirdly': ['RB'],
  'Thirteen': ['CD'],
  'Thirties': ['NNS'],
  'Thirty': ['CD'],
  'Thirty-eighth': ['NNP'],
  'Thirty-five': ['CD'],
  'Thirty-four': ['CD'],
  'Thirty-fourth': ['NNP'],
  'Thirty-month': ['NNP'],
  'Thirty-ninth': ['NNP'],
  'Thirty-one': ['JJ'],
  'Thirty-six': ['CD'],
  'Thirty-three': ['NNP'],
  'This': ['DT'],
  'Thistle': ['NNP'],
  'Tho': ['RB'],
  'Thom': ['NNP'],
  'Thoma': ['NNP'],
  'Thomae': ['NNP'],
  'Thomajan': ['NNP'],
  'Thomas': ['NNP'],
  'Thomases': ['NNP'],
  'Thomasini': ['NNP'],
  'Thomp': ['NN'],
  'Thompson': ['NNP'],
  'Thompson-CSF': ['NNP'],
  'Thomson': ['NNP'],
  'Thomson-CSF': ['NNP'],
  'Thor': ['NNP'],
  'Thoreau': ['NNP'],
  'Thorn': ['NNP'],
  'Thorn-EMI': ['NNP'],
  'Thornburg': ['NNP'],
  'Thornburgh': ['NNP'],
  'Thorndike': ['NNP'],
  'Thorne': ['NNP'],
  'Thornton': ['NNP'],
  'Thoroughbred': ['NNP'],
  'Thoroughly': ['NNP'],
  'Thorp': ['NNP'],
  'Thorpe': ['NNP'],
  'Thorstein': ['NNP'],
  'Thortec': ['NNP'],
  'Those': ['DT'],
  'Thou': ['PRP'],
  'Though': ['IN'],
  'Thought': ['NNP'],
  'Thoughts': ['NNP'],
  'Thousand': ['NNP'],
  'Thousands': ['NNS'],
  'Thrall': ['NNP'],
  'Thread': ['VB'],
  'Threaded': ['VBN'],
  'Threadgill': ['NNP'],
  'Threads': ['NNS'],
  'Threat': ['NN'],
  'Threatened': ['VBD'],
  'Threatening': ['VBG'],
  'Threats': ['NNS'],
  'Three': ['CD'],
  'Three-and-a-half': ['JJ'],
  'Three-day': ['JJ'],
  'Three-fourths': ['NNS'],
  'Three-month': ['JJ'],
  'Three-part': ['JJ'],
  'Three-quarters': ['NNS'],
  'Three-year-old': ['JJ'],
  'Threepenny': ['NN'],
  'Threlkeld': ['NNP'],
  'Threshold': ['NNP'],
  'Thrice': ['RB'],
  'Thrift': ['NNP'],
  'Thrifts': ['NNS'],
  'Thrifty': ['NNP'],
  'Thrive': ['VBP'],
  'Thriving': ['JJ'],
  'Throat': ['NNP'],
  'Thrombinar': ['NNP'],
  'Throne': ['NN'],
  'Throneberry': ['NNP'],
  'Through': ['IN'],
  'Throughout': ['IN'],
  'Throw': ['VB'],
  'Throwing': ['VBG'],
  'Throws': ['VBZ'],
  'Thru': ['IN'],
  'Thrush': ['NNP'],
  'Thruston': ['NNP'],
  'Thuggee': ['NNP'],
  'Thule': ['NNP'],
  'Thun': ['NNP'],
  'Thunder': ['NN'],
  'Thunderbird': ['NNP'],
  'Thunderbirds': ['NNPS'],
  'Thurber': ['NNP'],
  'Thurday': ['NNP'],
  'Thurgood': ['NNP'],
  'Thurman': ['NNP'],
  'Thurmond': ['NNP'],
  'Thurow': ['NNP'],
  'Thursday': ['NNP'],
  'Thursday-night': ['JJ'],
  'Thursdays': ['NNPS'],
  'Thus': ['RB'],
  'Thutmose': ['NNP'],
  'Thy': ['PRP'],
  'Thygerson': ['NNP'],
  'Thynne': ['NNP'],
  'Thynnes': ['NNPS'],
  'Thyroglobulin': ['NN'],
  'Thyroid': ['NN'],
  'Thyssen': ['NNP'],
  'Ti': ['NNP'],
  'Tiananmen': ['NNP'],
  'Tiant': ['NNP'],
  'Tiao': ['NNP'],
  'Tibbs': ['NNP'],
  'Tiber': ['NNP'],
  'Tibet': ['NNP'],
  'Tibetan': ['JJ'],
  'Tibetan-like': ['JJ'],
  'Tiburon': ['NNP'],
  'Tic-Tac-Toe': ['NNP'],
  'Tichenor': ['NNP'],
  'Tichy': ['NNP'],
  'Tickell': ['NNP'],
  'Ticker': ['NNP'],
  'Ticket': ['NN'],
  'Ticketron': ['NNP'],
  'Tickets': ['NNS'],
  'Ticonderoga': ['NNP'],
  'Ticor': ['NNP'],
  'Tidal': ['NNP'],
  'Tide': ['NNP'],
  'Tidewatch': ['NNP'],
  'Tidewater': ['NNP'],
  'Tie': ['VB'],
  'Tie-vole-ee': ['NN'],
  'Tieck': ['NNP'],
  'Tieken': ['NNP'],
  'Tiempo': ['NNP'],
  'Tien': ['NNP'],
  'Tiepolo': ['NNP'],
  'Tiernan': ['NNP'],
  'Tierney': ['NNP'],
  'Tierno': ['NNP'],
  'Ties': ['NNPS'],
  'Tietmeyer': ['NNP'],
  'Tiffany': ['NNP'],
  'Tift': ['NNP'],
  'Tigard': ['NNP'],
  'Tiger': ['NNP'],
  'Tiger-Heli': ['NNP'],
  'Tiger-turned-Federal': ['JJ'],
  'Tigers': ['NNP'],
  'Tigershark': ['NNP'],
  'Tigert': ['NNP'],
  'Tight': ['JJ'],
  'Tightened': ['JJ'],
  'Tigre': ['NNP'],
  'Tigrean': ['JJ'],
  'Tigreans': ['NNPS'],
  'Tigris': ['NNP'],
  'Tigue': ['NNP'],
  'Tijd': ['NNP'],
  'Tijuana': ['NNP'],
  'Tikopia': ['NNP'],
  'Tiles': ['NNS'],
  'Tilghman': ['NNP'],
  'Till': ['IN'],
  'Tillery': ['NNP'],
  'Tillet': ['NNP'],
  'Tillich': ['NNP'],
  'Tillie': ['NNP'],
  'Tillinghast': ['NNP'],
  'Tillotson': ['NNP'],
  'Tilly': ['NNP'],
  'Tilted': ['NNP'],
  'Tim': ['NNP'],
  'Timber': ['NN'],
  'Timberlake': ['NNP'],
  'Timbers': ['NNP'],
  'Timbuktu': ['NNP'],
  'Time': ['NNP'],
  'Time-Life': ['NNP'],
  'Time-Mynah': ['NNP'],
  'Time-Olivette': ['NNP'],
  'Time-Warner': ['NNP'],
  'Time-servers': ['NNS'],
  'Timen': ['NNP'],
  'Times': ['NNP'],
  'Times-Mirror': ['NNP'],
  'Times-Picayune': ['NNP'],
  'Times-Stock': ['NNP'],
  'Timex': ['NNP'],
  'Timidly': ['RB'],
  'Timing': ['NN'],
  'Timken': ['NNP'],
  'Timmy': ['NNP'],
  'Timna': ['NNP'],
  'Timon': ['NNP'],
  'Timony': ['NNP'],
  'Timor': ['NNP'],
  'Timothy': ['NNP'],
  'Timpanogos': ['NNP'],
  'Tims': ['NNP'],
  'Tin': ['NNP'],
  'Tina': ['NNP'],
  'Tindal': ['NNP'],
  'Tineo': ['NNP'],
  'Ting': ['NNP'],
  'Tingley': ['NNP'],
  'Tinker': ['NNP'],
  'Tinseltown': ['NNP'],
  'Tinsman': ['NNP'],
  'Tintoretto': ['NNP'],
  'Tiny': ['NNP'],
  'Tip': ['NNP'],
  'Tipasa': ['NNP'],
  'Tiphook': ['NNP'],
  'Tipoff': ['NNP'],
  'Tippecanoe': ['NNP'],
  'Tipperary': ['NNP'],
  'Tippet': ['NNP'],
  'Tippett': ['NNP'],
  'Tipping': ['NN'],
  'Tips': ['NNP'],
  'Tipton': ['NNP'],
  'Tiptonville': ['NNP'],
  'Tire': ['NNP'],
  'Tired': ['JJ'],
  'Tirello': ['NNP'],
  'Tires': ['NNS'],
  'Tirpak': ['NNP'],
  'Tisch': ['NNP'],
  'Tishman': ['NNP'],
  'Tissues': ['NNPS'],
  'Titan': ['NNP'],
  'Titanic': ['NNP'],
  'Titanium': ['NNP'],
  'Titans': ['NNS'],
  'Titche': ['NNP'],
  'Tithing': ['NN'],
  'Titian': ['NNP'],
  'Title': ['NN'],
  'Titled': ['VBN'],
  'Titles': ['NNPS'],
  'Tito': ['NNP'],
  'Tittabawassee': ['NNP'],
  'Titus': ['NNP'],
  'Tiveden': ['NNP'],
  'Tivoli': ['NNP'],
  'Tizard': ['NNP'],
  'Tjokorda': ['NNP'],
  'To': ['TO'],
  'To\'read': ['VB'],
  'Toa': ['NNP'],
  'Toagosei': ['NNP'],
  'Toalster': ['NNP'],
  'Toast': ['NNP'],
  'Toasting': ['VBG'],
  'Tobacco': ['NNP'],
  'Tobias': ['NNP'],
  'Tobin': ['NNP'],
  'Tobishima': ['NNP'],
  'Tobruk': ['NNP'],
  'Toby': ['NNP'],
  'Toccata': ['NNP'],
  'Toch': ['NNP'],
  'Tockman': ['NNP'],
  'Tocqueville': ['NNP'],
  'Today': ['NN'],
  'Todays': ['NNP'],
  'Todd': ['NNP'],
  'Todman': ['NNP'],
  'Todt': ['NNP'],
  'Toe': ['NNP'],
  'Toensing': ['NNP'],
  'Toepfer': ['NNP'],
  'Toffenetti': ['NNP'],
  'Together': ['RB'],
  'Togs': ['NNP'],
  'Tohmatsu': ['NNP'],
  'Toho': ['NNP'],
  'Toi': ['NNP'],
  'Toil': ['NN'],
  'Toit': ['NNP'],
  'Tojos': ['NNPS'],
  'Tok': ['NNP'],
  'Tokai': ['NNP'],
  'Tokio': ['NNP'],
  'Toklas': ['NNP'],
  'Tokoi': ['NNP'],
  'Tokuo': ['NNP'],
  'Tokuyama': ['NNP'],
  'Tokyo': ['NNP'],
  'Tokyo-based': ['JJ'],
  'Tokyu': ['NNP'],
  'Toland': ['NNP'],
  'Told': ['VBN'],
  'Toledo': ['NNP'],
  'Tolek': ['NNP'],
  'Tolentino': ['NNP'],
  'Toler': ['NNP'],
  'Tolerance': ['NN'],
  'Toll': ['NN'],
  'Tolley': ['NNP'],
  'Tollman-Hundley': ['NNP'],
  'Tolls': ['NNS'],
  'Tolstoy': ['NNP'],
  'Tolubeyev': ['NNP'],
  'Tom': ['NNP'],
  'Tom-and-Jerry': ['NNP'],
  'Toman': ['NNP'],
  'Tomas': ['NNP'],
  'Tomash': ['NNP'],
  'Tomaso': ['NNP'],
  'Tomato': ['NNP'],
  'Tombigbee': ['NNP'],
  'Tombrello': ['NNP'],
  'Tomczak': ['NNP'],
  'Tomilson': ['NNP'],
  'Tomkin': ['NNP'],
  'Tomkins': ['NNP'],
  'Tomlin': ['NNP'],
  'Tommie': ['NNP'],
  'Tommy': ['NNP'],
  'Tomonggong': ['NNP'],
  'Tomorrow': ['NN'],
  'Tomoshige': ['NNP'],
  'Tompkins': ['NNP'],
  'Toms': ['NNP'],
  'Tomsho': ['NNP'],
  'Tonal': ['JJ'],
  'Tonawanda': ['NNP'],
  'Tone': ['NN'],
  'Tones': ['NNPS'],
  'Toney': ['NNP'],
  'Tong': ['NNP'],
  'Tong\'Il': ['NNP'],
  'Toni': ['NNP'],
  'Tonight': ['NNP'],
  'Tonio': ['NNP'],
  'Tonka': ['NNP'],
  'Tonkin': ['NNP'],
  'Tons': ['NNS'],
  'Tony': ['NNP'],
  'Too': ['RB'],
  'Toobin': ['NNP'],
  'Toodle': ['NNP'],
  'Took': ['VBD'],
  'Tool': ['NNP'],
  'Toole': ['NNP'],
  'Tooling': ['VBG'],
  'Tools': ['NNPS'],
  'Toomey': ['NNP'],
  'Toonker': ['NNP'],
  'Toornstra': ['NNP'],
  'Toot': ['NNP'],
  'Toot-toot': ['UH'],
  'Tootal': ['NNP'],
  'Tooth': ['NN'],
  'Tooth-hurty': ['NN'],
  'Tootsie': ['NNP'],
  'Top': ['JJ'],
  'Top-20': ['JJ'],
  'Top-of-the-Line': ['JJ'],
  'Topaz': ['NNP'],
  'Topeka': ['NNP'],
  'Topic': ['NNP'],
  'Topix': ['NNP'],
  'Topkapi': ['NNP'],
  'Topography': ['NN'],
  'Topper': ['NNP'],
  'Toppers': ['NNP'],
  'Topping': ['VBG'],
  'Topps': ['NNP'],
  'Topton': ['NNP'],
  'Tora': ['NNP'],
  'Torah': ['NNP'],
  'Torbjoern': ['NNP'],
  'Torch': ['NNP'],
  'Torchmark': ['NNP'],
  'Tordella': ['NNP'],
  'Torell': ['NNP'],
  'Tories': ['NNPS'],
  'Torino': ['NNP'],
  'Torme': ['NNP'],
  'Tornado': ['NNP'],
  'Toro': ['NNP'],
  'Toronado': ['NNP'],
  'Toronto': ['NNP'],
  'Toronto-Dominion': ['NNP'],
  'Toronto-area': ['JJ'],
  'Toronto-based': ['JJ'],
  'Toros': ['NNP'],
  'Torpetius': ['NNP'],
  'Torquato': ['NNP'],
  'Torquemada': ['NNP'],
  'Torrance': ['NNP'],
  'Torrence': ['NNP'],
  'Torres': ['NNP'],
  'Torresi': ['NNP'],
  'Torrey': ['NNP'],
  'Torrid': ['NNP'],
  'Torrid-Adios': ['NNP'],
  'Torrid-Breeze': ['NNP'],
  'Torrid-Mighty': ['NNP'],
  'Torrijos': ['NNP'],
  'Torrington': ['NNP'],
  'Torrio': ['NNP'],
  'Torrio-Capone': ['JJ'],
  'Torstar': ['NNP'],
  'Torsten': ['NNP'],
  'Tort': ['NNP'],
  'Tortillas': ['NNPS'],
  'Tortoises': ['NNPS'],
  'Tortola': ['NNP'],
  'Tortorello': ['NNP'],
  'Tortoriello': ['NNP'],
  'Torts': ['NNP'],
  'Tory': ['NNP'],
  'Tosca': ['NNP'],
  'Toscanini': ['NNP'],
  'Tosco': ['NNP'],
  'Tose': ['NNP'],
  'Toseland': ['NNP'],
  'Toshiba': ['NNP'],
  'Toshiichi': ['NNP'],
  'Toshiki': ['NNP'],
  'Toshiko': ['NNP'],
  'Toshimitsu': ['NNP'],
  'Toshio': ['NNP'],
  'Toshiyuki': ['NNP'],
  'Toss': ['VB'],
  'Tossing': ['VBG'],
  'Total': ['JJ'],
  'Total-Cie': ['NNP'],
  'Totaling': ['VBG'],
  'Totalitarianism': ['NNP'],
  'Totally': ['RB'],
  'Toth': ['NNP'],
  'Toto': ['NNP'],
  'Tots': ['NNP'],
  'Totten': ['NNP'],
  'Toubro': ['NNP'],
  'Touch': ['NNP'],
  'Touche': ['NNP'],
  'Touches': ['VBZ'],
  'Touchstone': ['NNP'],
  'Toufexis': ['NNP'],
  'Tougas': ['NNP'],
  'Tough': ['JJ'],
  'Tougher': ['JJR'],
  'Toughest': ['NNP'],
  'Toujours': ['FW'],
  'Toulouse': ['NNP'],
  'Toulouse-Lautrec': ['NNP'],
  'Tour': ['NNP'],
  'Touring': ['VBG'],
  'Tourism': ['NNP'],
  'Tourist': ['NNP'],
  'Tournament': ['NNP'],
  'Tournier': ['NNP'],
  'Tours': ['NNPS'],
  'Toussie': ['NNP'],
  'Touted': ['VBN'],
  'Touting': ['VBG'],
  'Toward': ['IN'],
  'Towards': ['NNP'],
  'Tower': ['NNP'],
  'Towering': ['VBG'],
  'Towers': ['NNP'],
  'Towing': ['NNP'],
  'Towle': ['NNP'],
  'Town': ['NNP'],
  'Towne': ['NNP'],
  'Townes': ['NNP'],
  'Townley': ['NNP'],
  'Towns': ['NNP'],
  'Townsend': ['NNP'],
  'Township': ['NNP'],
  'Towsley': ['NNP'],
  'Towson': ['NNP'],
  'Toxic': ['JJ'],
  'Toxicology': ['NNP'],
  'Toxics': ['NNP'],
  'Toy': ['NNP'],
  'Toying': ['VBG'],
  'Toyko': ['NNP'],
  'Toynbee': ['NNP'],
  'Toyo': ['NNP'],
  'Toyobo': ['NNP'],
  'Toyoda': ['NNP'],
  'Toyota': ['NNP'],
  'Toyotas': ['NNS'],
  'Toys': ['NNPS'],
  'Trabants': ['NNPS'],
  'Trabb': ['NNP'],
  'Trabold': ['NNP'],
  'Trac': ['NNP'],
  'Trace': ['NNP'],
  'Tracer': ['NNP'],
  'Tracers': ['NNP'],
  'Traces': ['NNS'],
  'Tracey': ['NNP'],
  'Trachea': ['NN'],
  'Tracinda': ['NNP'],
  'Tracing': ['VBG'],
  'Track': ['NNP'],
  'Trackdown': ['NNP'],
  'Tracking': ['NNP'],
  'Tracks': ['NNS'],
  'Tracor': ['NNP'],
  'Tract': ['NNP'],
  'Tractarians': ['NNS'],
  'Tractebel': ['NNP'],
  'Tractor': ['NNP'],
  'Tracy': ['NNP'],
  'Tracy-Locke': ['NNP'],
  'Tracys': ['NNP'],
  'Trade': ['NNP'],
  'Traded': ['NNP'],
  'Trader': ['NNP'],
  'Traders': ['NNS'],
  'Trades': ['NNPS'],
  'Trading': ['NN'],
  'Tradition': ['NN'],
  'Traditional': ['JJ'],
  'Traditionalism': ['NN'],
  'Traditionalist': ['NN'],
  'Traditionalists': ['NNPS'],
  'Traditionally': ['RB'],
  'Traffic': ['NNP'],
  'Trafficking': ['NN'],
  'Traficant': ['NNP'],
  'Trafton': ['NNP'],
  'Tragedy': ['NN'],
  'Trager': ['NNP'],
  'Tragically': ['RB'],
  'Trail': ['NNP'],
  'Trailer': ['NNP'],
  'Trailing': ['VBG'],
  'Train': ['NNP'],
  'Trained': ['VBN'],
  'Trainer': ['NNP'],
  'Training': ['NNP'],
  'Trains': ['NNS'],
  'Traitor': ['NN'],
  'Traits': ['NNP'],
  'Trammell': ['NNP'],
  'Tramp': ['NNP'],
  'Tranportation': ['NNP'],
  'Tranquility': ['NN'],
  'Trans': ['NNP'],
  'Trans-Alaska': ['NNP'],
  'Trans-Mediterranean': ['NNP'],
  'Trans-Pacific': ['NNP'],
  'Trans-Pecos': ['NNP'],
  'Trans-illuminated': ['JJ'],
  'TransAmerican': ['NNP'],
  'TransAtlantic': ['NNP'],
  'TransCanada': ['NNP'],
  'TransNet': ['NNP'],
  'TransTechnology': ['NNP'],
  'Transactions': ['NNS'],
  'Transamerica': ['NNP'],
  'Transatlantic': ['NNP'],
  'Transcat': ['NNP'],
  'Transcaucasian': ['JJ'],
  'Transcaucasus': ['NNP'],
  'Transcendental': ['JJ'],
  'Transcendentalism': ['NNP'],
  'Transcendentalists': ['NNPS'],
  'Transco': ['NNP'],
  'Transcontinental': ['NNP'],
  'Transfer': ['NN'],
  'Transfers': ['NNS'],
  'Transformers': ['NNPS'],
  'Transgenic': ['NNP'],
  'Transgenics': ['NNP'],
  'Transit': ['NNP'],
  'Transition': ['NN'],
  'Transitional': ['JJ'],
  'Transkei': ['NNP'],
  'Translant': ['NNP'],
  'Translated': ['VBN'],
  'Translation': ['NNP'],
  'Translink': ['NNP'],
  'Translocations': ['NNS'],
  'Transmanche-Link': ['NNP'],
  'TransmancheLink': ['NNP'],
  'Transmation': ['NNP'],
  'Transmission': ['NNP'],
  'Transol': ['NNP'],
  'Transparent': ['JJ'],
  'Transpiration': ['NN'],
  'Transplantation': ['NNP'],
  'Transport': ['NNP'],
  'Transportation': ['NNP'],
  'Transportek': ['NNP'],
  'Transporting': ['VBG'],
  'Transports': ['NNS'],
  'Transtar': ['NNP'],
  'Transvaal': ['NNP'],
  'Transwestern': ['NNP'],
  'Transylvania': ['NNP'],
  'Trap': ['NNP'],
  'Trapp': ['FW'],
  'Trapped': ['VBN'],
  'Trappings': ['NNP'],
  'Trappist': ['JJ'],
  'Traps': ['NNS'],
  'Trash': ['NNP'],
  'Trastevere': ['NNP'],
  'Traub': ['NNP'],
  'Travancore': ['NNP'],
  'Travel': ['NNP'],
  'Travel-Holiday': ['NNP'],
  'Traveler': ['NNP'],
  'Travelers': ['NNP'],
  'Traveling': ['VBG'],
  'Travellers': ['NNS'],
  'Travelling': ['VBG'],
  'Travels': ['NNP'],
  'Traverse': ['NNP'],
  'Traverso': ['NNP'],
  'Traviata': ['NNP'],
  'Travis': ['NNP'],
  'Traxel': ['NNP'],
  'Traxler': ['NNP'],
  'Tray': ['NNP'],
  'Traynor': ['NNP'],
  'Treadway': ['NNP'],
  'Treadwell': ['NNP'],
  'Treasonable': ['JJ'],
  'Treasure': ['NNP'],
  'Treasurer': ['NNP'],
  'Treasurers': ['NNS'],
  'Treasures': ['NNS'],
  'Treasury': ['NNP'],
  'Treasury-Fed': ['NNP'],
  'Treasury-bill': ['NN'],
  'Treasury-bond': ['JJ'],
  'Treasurys': ['NNPS'],
  'Treat': ['VB'],
  'Treating': ['VBG'],
  'Treatment': ['NNP'],
  'Treaty': ['NNP'],
  'Treausry': ['NNP'],
  'Treble': ['NNP'],
  'Trecker': ['NNP'],
  'Tredding': ['NNP'],
  'Tredegar': ['NNP'],
  'Tredici': ['NNP'],
  'Tredyffrin': ['NNP'],
  'Tree': ['NNP'],
  'Treece': ['NNP'],
  'Trees': ['NNP'],
  'Tregnums': ['NNPS'],
  'Trego': ['NNP'],
  'Treiger': ['NNP'],
  'Treitel': ['NNP'],
  'Trek': ['NNP'],
  'Trelleborg': ['NNP'],
  'Tremblay': ['NNP'],
  'Tremdine': ['NNP'],
  'Tremendae': ['NNP'],
  'Trempler': ['NNP'],
  'Trenchard': ['NNP'],
  'Trend': ['NNP'],
  'Trend-following': ['JJ'],
  'Trends': ['NNP'],
  'Trendy': ['JJ'],
  'Trent': ['NNP'],
  'Trenton': ['NNP'],
  'Trepp': ['NNP'],
  'Trettien': ['NNP'],
  'Trevelyan': ['NNP'],
  'Trevino': ['NNP'],
  'Trevor': ['NNP'],
  'Trexler': ['NNP'],
  'Treybig': ['NNP'],
  'Tri-Star': ['NNP'],
  'Tri-State': ['NNP'],
  'TriStar': ['NNP'],
  'Triad': ['NNP'],
  'Trial': ['NN'],
  'Triamcinolone': ['NN'],
  'Triandos': ['NNP'],
  'Triangle': ['NNP'],
  'Trianon': ['NNP'],
  'Trib': ['NNP'],
  'Tribal': ['NNP'],
  'Tribe': ['NNP'],
  'Tribes': ['NNS'],
  'Triborough': ['NNP'],
  'Tribou': ['NNP'],
  'Tribuna': ['NNP'],
  'Tribunal': ['NNP'],
  'Tribune': ['NNP'],
  'Tribune-Democrat': ['NNP'],
  'Trichieri': ['NNP'],
  'Trichinella': ['NN'],
  'Trichrome': ['JJ'],
  'Tricia': ['NNP'],
  'Tricks': ['NNPS'],
  'Trickster': ['NNP'],
  'Trident': ['NNP'],
  'Tridex': ['NNP'],
  'Trifari': ['NNP'],
  'Trig': ['NNP'],
  'Trigg': ['NNP'],
  'Triggering': ['VBG'],
  'Trikojus': ['NNP'],
  'Triland': ['NNP'],
  'Trim': ['VB'],
  'Trim-your-own-franks': ['VB'],
  'Trimble': ['NNP'],
  'Trimedyne': ['NNP'],
  'Trimmer': ['NNP'],
  'Trinen': ['NNP'],
  'Trinidad': ['NNP'],
  'Trinitarian': ['NNP'],
  'Trinitarians': ['NNP'],
  'Trinitron': ['NNP'],
  'Trinity': ['NNP'],
  'Trinkaus': ['NNP'],
  'Trinova': ['NNP'],
  'Trio': ['NNP'],
  'Triomphe': ['NNP'],
  'Tripartite': ['NNP'],
  'Tripe': ['NNP'],
  'Triple': ['NNP'],
  'Triple-A': ['NNP'],
  'Tripod': ['NNP'],
  'Tripod-Laing': ['NNP'],
  'Tripoli': ['NNP'],
  'Triptych': ['NNP'],
  'Tris': ['NNP'],
  'Trish': ['NNP'],
  'Tristan': ['NNP'],
  'Tristano': ['NNP'],
  'Tristars': ['NNPS'],
  'Trite': ['JJ'],
  'Tritium': ['NN'],
  'Triton': ['NNP'],
  'Trittico': ['FW'],
  'Trivelpiece': ['NNP'],
  'Trivest': ['NNP'],
  'Trivia': ['NNP'],
  'Trizec': ['NNP'],
  'Trockenbeerenauslesen': ['NNP'],
  'Troeltsch': ['NNP'],
  'Trofeo': ['NNP'],
  'Trohan': ['NNP'],
  'Trojan': ['NNP'],
  'Trompe': ['FW'],
  'Troop': ['NNP'],
  'Trooper': ['NNP'],
  'Troopers': ['NNS'],
  'Troops': ['NNS'],
  'Trop': ['NNP'],
  'Tropez': ['NNP'],
  'Trophy': ['NNP'],
  'Tropic': ['NNP'],
  'Tropical': ['NNP'],
  'Tropicana': ['NNP'],
  'Tropics': ['NNPS'],
  'Tropidoclonion': ['NNP'],
  'Tropworld': ['NNP'],
  'Trotsky': ['NNP'],
  'Trotter': ['NNP'],
  'Trotting': ['VBG'],
  'Trouble': ['NN'],
  'Trouble-free': ['JJ'],
  'Troubled': ['JJ'],
  'Troup': ['NNP'],
  'Trout': ['NNP'],
  'Troutman': ['NNP'],
  'Trovatore': ['NNP'],
  'Troy': ['NNP'],
  'Troyes': ['NNP'],
  'Truck': ['NNP'],
  'Truckee': ['NNP'],
  'Truckers': ['NNS'],
  'Trucking': ['NNP'],
  'Trucks': ['NNS'],
  'Trud': ['NNP'],
  'Trudeau': ['NNP'],
  'True': ['JJ'],
  'Truell': ['NNP'],
  'Truesdell': ['NNP'],
  'Truffaut': ['NNP'],
  'Trujillo': ['NNP'],
  'Trujillos': ['NNPS'],
  'Truly': ['NNP'],
  'Truman': ['NNP'],
  'Trumbull': ['NNP'],
  'Trumka': ['NNP'],
  'Trump': ['NNP'],
  'Trump-watchers': ['NNS'],
  'Trumped': ['VBN'],
  'Trumplane': ['NNP'],
  'Trumps': ['NNPS'],
  'Trunk': ['NN'],
  'Trunkline': ['NNP'],
  'Trupin': ['NNP'],
  'Trupin-related': ['JJ'],
  'Trupins': ['NNPS'],
  'Trusk': ['NNP'],
  'Trust': ['NNP'],
  'Trustco': ['NNP'],
  'Trustcorp': ['NNP'],
  'Trustee': ['NNP'],
  'Trustees': ['NNS'],
  'Trusthouse': ['NNP'],
  'Truth': ['NN'],
  'Try': ['VB'],
  'Trygve': ['NNP'],
  'Tryin': ['VBG'],
  'Trying': ['VBG'],
  'Tryon': ['NNP'],
  'Tsai': ['NNP'],
  'Tsao': ['NNP'],
  'Tsar': ['NNP'],
  'Tsarevich': ['NNP'],
  'Tsarism': ['NNP'],
  'Tschilwyk': ['NNP'],
  'Tschoegl': ['NNP'],
  'Tse-tung': ['NNP'],
  'Tshombe': ['NNP'],
  'Tshombe-Gizenga-Goa-Ghana': ['NNP'],
  'Tsitouris': ['NNP'],
  'Tsk': ['UH'],
  'Tsou': ['NNP'],
  'Tsunami': ['NNS'],
  'Tsunozaki': ['NNP'],
  'Tsur': ['NNP'],
  'Tsuruo': ['NNP'],
  'Tsvetkov': ['NNP'],
  'Tu': ['NNP'],
  'TuHulHulZote': ['NNP'],
  'Tualatin': ['NNP'],
  'Tube': ['NNP'],
  'Tuberculosis': ['NNP'],
  'Tuborg': ['NNP'],
  'Tuchman': ['NNP'],
  'Tuck': ['NNP'],
  'Tucked': ['VBN'],
  'Tucker': ['NNP'],
  'Tucson': ['NNP'],
  'Tudor': ['NNP'],
  'Tudor-style': ['JJ'],
  'Tuesday': ['NNP'],
  'Tuesdays': ['NNPS'],
  'Tufts': ['NNP'],
  'Tugaru': ['NN'],
  'Tuitions': ['NNS'],
  'Tulane': ['NNP'],
  'Tulip': ['NNP'],
  'Tullio': ['NNP'],
  'Tulln': ['NNP'],
  'Tullock': ['NNP'],
  'Tully': ['NNP'],
  'Tulsa': ['NNP'],
  'Tumazos': ['NNP'],
  'Tumbling': ['JJ'],
  'Tumor': ['NNP'],
  'Tune': ['NNP'],
  'Tunica': ['NNP'],
  'Tunick': ['NNP'],
  'Tunis': ['NNP'],
  'Tunisia': ['NNP'],
  'Tunisian': ['NNP'],
  'Tunnard': ['NNP'],
  'Tunnel': ['NNP'],
  'Tuohy': ['NNP'],
  'Tupelev-144': ['NNP'],
  'Tupolev': ['NNP'],
  'Tupper': ['NNP'],
  'Tupperware': ['NNP'],
  'Turandot': ['NNP'],
  'Turben': ['NNP'],
  'Turbin': ['NNP'],
  'Turbine': ['NNP'],
  'Turbinen': ['NNP'],
  'Turbinen-Union': ['NNP'],
  'Turbofan': ['NN'],
  'Turbulence': ['NN'],
  'Turbulent': ['JJ'],
  'Turbyfill': ['NNP'],
  'Turchin': ['NNP'],
  'Turf': ['NNP'],
  'Turgut': ['NNP'],
  'Turin': ['NNP'],
  'Turin-based': ['JJ'],
  'Turk': ['NNP'],
  'Turkey': ['NNP'],
  'Turkey.': ['NNP'],
  'Turkish': ['JJ'],
  'Turkmenia': ['NNP'],
  'Turks': ['NNPS'],
  'Turn': ['VB'],
  'Turnaround': ['NNP'],
  'Turnbull': ['NNP'],
  'Turned': ['VBN'],
  'Turner': ['NNP'],
  'Turning': ['VBG'],
  'Turnkey': ['NNP'],
  'Turnock': ['NNP'],
  'Turnout': ['NN'],
  'Turnover': ['NN'],
  'Turnpike': ['NNP'],
  'Turnpike-widening': ['JJ'],
  'Turns': ['VBZ'],
  'Turpin': ['NNP'],
  'Turtle': ['NNP'],
  'Turtles': ['NNPS'],
  'Tuscany': ['NNP'],
  'Tuskegee': ['NNP'],
  'Tussard': ['NNP'],
  'Tussle': ['NNP'],
  'Tustin': ['NNP'],
  'Tut': ['NNP'],
  'Tuttle': ['NNP'],
  'Tutu': ['NNP'],
  'Tutunik': ['NNP'],
  'Tuxapoka': ['NNP'],
  'Twain': ['NNP'],
  'Twaron': ['NNP'],
  'Tweed': ['NNP'],
  'Tweet': ['VB'],
  'Twelve': ['CD'],
  'Twenties': ['NNP'],
  'Twentieth': ['NNP'],
  'Twentieth-Century': ['NNP'],
  'Twenty': ['CD'],
  'Twenty-First': ['NNP'],
  'Twenty-eight': ['CD'],
  'Twenty-five': ['CD'],
  'Twenty-four': ['CD'],
  'Twenty-nine': ['CD'],
  'Twenty-one': ['CD'],
  'Twenty-one-year-old': ['NN'],
  'Twenty-second': ['NNP'],
  'Twenty-seven': ['JJ'],
  'Twenty-six': ['JJ'],
  'Twenty-two': ['CD'],
  'Twenty-year-old': ['JJ'],
  'Twice': ['RB'],
  'Twiggy': ['NNP'],
  'Twigs': ['NNS'],
  'Twilight': ['NNP'],
  'Twin': ['NNP'],
  'Twinkies': ['NNPS'],
  'Twins': ['NNP'],
  'Twinsburg': ['NNP'],
  'Twist': ['NN'],
  'Twitter': ['NNP'],
  'Two': ['CD'],
  'Two-Head': ['NNP'],
  'Two-Stem': ['JJ'],
  'Two-Way': ['NNP'],
  'Two-Year': ['JJ'],
  'Two-day': ['JJ'],
  'Two-income': ['NN'],
  'Two-month': ['JJ'],
  'Two-part': ['JJ'],
  'Two-thirds': ['NNS'],
  'Two-year': ['JJ'],
  'Twomey': ['NNP'],
  'Ty': ['NNP'],
  'Tyburn': ['NN'],
  'Tyco': ['NNP'],
  'Tygartis': ['NNP'],
  'Tylan': ['NNP'],
  'Tylenol': ['NNP'],
  'Tylenol-tampering': ['JJ'],
  'Tyler': ['NNP'],
  'Tymnet': ['NNP'],
  'Tyndall': ['NNP'],
  'Tyne': ['NNP'],
  'Tyner': ['NNP'],
  'Type': ['NN'],
  'Type-O': ['JJ'],
  'Types': ['NNS'],
  'Typical': ['JJ'],
  'Typically': ['RB'],
  'Typing': ['NN'],
  'Tyrannosaurus': ['NNP'],
  'Tyranny': ['NNP'],
  'Tyre': ['NNP'],
  'Tyson': ['NNP'],
  'Tyson-Spinks': ['JJ'],
  'Tyszkiewicz': ['NNP'],
  'Tzora': ['NNP'],
  'U': ['NNP'],
  'U-2': ['NNP'],
  'U-I': ['NNP'],
  'U-Save': ['NNP'],
  'U-turn': ['NN'],
  'U.': ['NNP'],
  'U.B.U.': ['NNP'],
  'U.Cal-Davis': ['NNP'],
  'U.K': ['NNP'],
  'U.K.': ['NNP'],
  'U.K.-based': ['JJ'],
  'U.LLO': ['NNP'],
  'U.M.C.I.A.': ['NNP'],
  'U.M.T.': ['NN'],
  'U.N': ['NNP'],
  'U.N.': ['NNP'],
  'U.N.-backed': ['JJ'],
  'U.N.-chartered': ['JJ'],
  'U.N.-monitored': ['JJ'],
  'U.N.-sponsored': ['JJ'],
  'U.N.-supervised': ['JJ'],
  'U.N.C.L.E': ['NNP'],
  'U.N.F.P': ['NNP'],
  'U.N.F.P.': ['NNP'],
  'U.N.F.P./NNP.': ['JJ'],
  'U.S': ['NNP'],
  'U.S-based': ['JJ'],
  'U.S.': ['NNP'],
  'U.S.\$': ['\$'],
  'U.S.-Canada': ['NNP'],
  'U.S.-Canadian': ['JJ'],
  'U.S.-China': ['NNP'],
  'U.S.-Czech': ['JJ'],
  'U.S.-European': ['JJ'],
  'U.S.-German': ['JJ'],
  'U.S.-Israel-Egyptian': ['JJ'],
  'U.S.-Japan': ['JJ'],
  'U.S.-Japanese': ['JJ'],
  'U.S.-Korean': ['JJ'],
  'U.S.-Mexican': ['JJ'],
  'U.S.-Mexico': ['JJ'],
  'U.S.-Philippine': ['JJ'],
  'U.S.-SOVIET': ['JJ'],
  'U.S.-South': ['JJ'],
  'U.S.-Soviet': ['JJ'],
  'U.S.-U.K.': ['JJ'],
  'U.S.-U.S.S.R.': ['NNP'],
  'U.S.-about': ['IN'],
  'U.S.-backed': ['JJ'],
  'U.S.-based': ['JJ'],
  'U.S.-built': ['JJ'],
  'U.S.-developed': ['JJ'],
  'U.S.-dollar': ['NN'],
  'U.S.-dominated': ['JJ'],
  'U.S.-donated': ['JJ'],
  'U.S.-endorsed': ['JJ'],
  'U.S.-grown': ['JJ'],
  'U.S.-led': ['JJ'],
  'U.S.-made': ['JJ'],
  'U.S.-owned': ['JJ'],
  'U.S.-produced': ['JJ'],
  'U.S.-style': ['JJ'],
  'U.S.-supplied': ['JJ'],
  'U.S.56': ['CD'],
  'U.S.A': ['NNP'],
  'U.S.A.': ['NNP'],
  'U.S.C.': ['NNP'],
  'U.S.Japan': ['JJ'],
  'U.S.S.R': ['NNP'],
  'U.S.S.R.': ['NNP'],
  'U.S.backed': ['JJ'],
  'U.S.based': ['JJ'],
  'U.S.concerns': ['NNS'],
  'U.S.investors': ['NNS'],
  'U.S.that': ['NN'],
  'U.s': ['NNP'],
  'U/NNP.S.C.': ['NNP'],
  'UAE': ['NNP'],
  'UAL': ['NNP'],
  'UAL\'S': ['NNP'],
  'UAP': ['NNP'],
  'UAW': ['NNP'],
  'UBS': ['NNP'],
  'UBS-Phillips': ['NNP'],
  'UCC': ['NNP'],
  'UCLA': ['NNP'],
  'UCSF': ['NNP'],
  'UDAG': ['NNP'],
  'UDC': ['NNP'],
  'UEP': ['NNP'],
  'UFO': ['NNP'],
  'UFOs': ['NNS'],
  'UGF': ['NNP'],
  'UGI': ['NNP'],
  'UH': ['NNP'],
  'UH-60A': ['NNP'],
  'UIC': ['NNP'],
  'UJB': ['NNP'],
  'UK': ['NNP'],
  'UKRAINIANS': ['NNS'],
  'ULI': ['NNP'],
  'UMNO': ['NNP'],
  'UMW': ['NNP'],
  'UN': ['NNP'],
  'UNA': ['NNP'],
  'UNC': ['NNP'],
  'UNCERTAINTY': ['NN'],
  'UNDEFINED': ['JJ'],
  'UNDER': ['IN'],
  'UNESCO': ['NNP'],
  'UNFLUORIDATED': ['JJ'],
  'UNIFIED': ['JJ'],
  'UNIFIRST': ['NNP'],
  'UNION': ['NN'],
  'UNITED': ['NNP'],
  'UNIX': ['NNP'],
  'UNR': ['NNP'],
  'UNRESOLVED': ['JJ'],
  'UNVEILED': ['VBD'],
  'UP': ['IN'],
  'UPHELD': ['VBN'],
  'UPI': ['NNP'],
  'UPJOHN': ['NNP'],
  'UPS': ['NNP'],
  'URGED': ['VBD'],
  'US': ['PRP'],
  'US\$': ['\$'],
  'US-Travel': ['NNP'],
  'US116.7': ['CD'],
  'US45.9': ['CD'],
  'US72.3': ['CD'],
  'US8.9': ['CD'],
  'USA': ['NNP'],
  'USAA': ['NNP'],
  'USACafes': ['NNP'],
  'USAF': ['NNP'],
  'USAir': ['NNP'],
  'USC': ['NNP'],
  'USDA': ['NNP'],
  'USDA-sponsored': ['JJ'],
  'USED': ['VBD'],
  'USED-CAR': ['NN'],
  'USF&G': ['NNP'],
  'USFL': ['NNP'],
  'USG': ['NNP'],
  'USGA': ['NNP'],
  'USI': ['NNP'],
  'USIA': ['NNP'],
  'USIS': ['NNP'],
  'USN': ['NNP'],
  'USN.': ['NNP'],
  'USO': ['NNP'],
  'USOM': ['NNP'],
  'USP': ['NNP'],
  'USS': ['NNP'],
  'USSR': ['NNP'],
  'UST': ['NNP'],
  'USW': ['NNP'],
  'USX': ['NNP'],
  'UTA': ['NNP'],
  'UTILITIES': ['NNP'],
  'UTL': ['JJ'],
  'UTLs': ['NNS'],
  'UV-B': ['NN'],
  'UVB': ['NN'],
  'Ubberroth': ['NNP'],
  'Ubermenschen': ['NNPS'],
  'Uchida': ['NNP'],
  'Uclaf': ['NNP'],
  'Udall': ['NNP'],
  'Udayan': ['NNP'],
  'Udvar-Hazy': ['NNP'],
  'Ueberroth': ['NNP'],
  'Uerkesh': ['NNP'],
  'Ugh': ['UH'],
  'Ugly': ['JJ'],
  'Uh': ['UH'],
  'Uh-huh': ['UH'],
  'Uh-uh': ['UH'],
  'Uhhu': ['UH'],
  'Uhl': ['NNP'],
  'Uhles': ['NNP'],
  'Uhlmann': ['NNP'],
  'Uhr': ['NNP'],
  'Ukiah': ['NNP'],
  'Ukraine': ['NNP'],
  'Ukrainian': ['JJ'],
  'Ukrainians': ['NNPS'],
  'Ukranians': ['NNPS'],
  'Ukropina': ['NNP'],
  'Ulanys': ['NNP'],
  'Ulbricht': ['NNP'],
  'Ulisse': ['NNP'],
  'Ullman': ['NNP'],
  'Ulric': ['NNP'],
  'Ulrich': ['NNP'],
  'Ultimate': ['NNP'],
  'Ultimately': ['RB'],
  'Ultra': ['NNP'],
  'Ultracentrifugation': ['NN'],
  'Ultramar': ['NNP'],
  'Ultraviolet': ['NN'],
  'Ulyate': ['NNP'],
  'Ulysses': ['NNP'],
  'Um': ['UH'],
  'Umberson': ['NNP'],
  'Umberto': ['NNP'],
  'Umkhonto': ['NNP'],
  'Umm': ['UH'],
  'Umpire': ['NN'],
  'Umschlagplatz': ['NNP'],
  'Un-American': ['NNP'],
  'Unable': ['JJ'],
  'Unam': ['NNP'],
  'Unamused': ['JJ'],
  'Unanalyzed': ['JJ'],
  'Unanimity': ['NN'],
  'Unanimously': ['RB'],
  'Unbelievable': ['JJ'],
  'Uncas': ['NNP'],
  'Uncertain': ['NNP'],
  'Uncertainty': ['NN'],
  'Unckle': ['NNP'],
  'Uncle': ['NNP'],
  'Uncomfortably': ['RB'],
  'Uncommon': ['JJ'],
  'Unconcerned': ['JJ'],
  'Unconfirmed': ['JJ'],
  'Unconscionable': ['JJ'],
  'Unconscious': ['NNP'],
  'Unconsciously': ['RB'],
  'Unconstitutional': ['JJ'],
  'Uncontrolled': ['JJ'],
  'Undaunted': ['JJ'],
  'Undead': ['NN'],
  'Under': ['IN'],
  'Underage': ['JJ'],
  'Underberg': ['NNP'],
  'Underclass': ['JJ'],
  'Undergraduates': ['NNS'],
  'Underground': ['JJ'],
  'Underhill': ['NNP'],
  'Underlying': ['VBG'],
  'Underneath': ['IN'],
  'Underperform': ['NNP'],
  'Underscoring': ['VBG'],
  'Underseas': ['NNP'],
  'Undersecretary': ['NNP'],
  'Underserved': ['NNP'],
  'Understandably': ['RB'],
  'Understanding': ['VBG'],
  'Undertaken': ['VBN'],
  'Underwater': ['NNP'],
  'Underwear': ['NN'],
  'Underwood': ['NNP'],
  'Underwoods': ['NNPS'],
  'Underwriter': ['NNP'],
  'Underwriters': ['NNS'],
  'Underwriting': ['NN'],
  'Undeterred': ['JJ'],
  'Undismayed': ['JJ'],
  'Undoubtedly': ['RB'],
  'Undugu': ['NNP'],
  'Unease': ['NN'],
  'Uneasiness': ['NN'],
  'Unemployed': ['JJ'],
  'Unemployment': ['NN'],
  'Uneven': ['JJ'],
  'Unexpected': ['JJ'],
  'Unfilled': ['JJ'],
  'Unflattering': ['JJ'],
  'Unfortunately': ['RB'],
  'Unfriendly': ['JJ'],
  'Unfurling': ['VBG'],
  'Ungaretti': ['NNP'],
  'Ungava': ['NNP'],
  'Unger': ['NNP'],
  'Ungermann-Bass': ['NNP'],
  'Unglazed': ['VBN'],
  'Ungrateful': ['JJ'],
  'Unhappily': ['RB'],
  'UniFirst': ['NNP'],
  'UniHealth': ['NNP'],
  'Uniate': ['NNP'],
  'Unice': ['NNP'],
  'Unico': ['NNP'],
  'Uniconer': ['NNP'],
  'Unicorp': ['NNP'],
  'Unida': ['NNP'],
  'Unification': ['NNP'],
  'Unificationism': ['NNP'],
  'Unificationist': ['JJ'],
  'Unificationists': ['NNS'],
  'Unified': ['NNP'],
  'Unifil': ['NNP'],
  'Uniform': ['JJ'],
  'Unify': ['VB'],
  'Unigesco': ['NNP'],
  'Unilab': ['NNP'],
  'Unilever': ['NNP'],
  'Unimin': ['NNP'],
  'Unimpressed': ['JJ'],
  'Unincorporated': ['NNP'],
  'Uninhibited': ['NNP'],
  'Union': ['NNP'],
  'Union.': ['NNP'],
  'UnionFed': ['NNP'],
  'Uniondale': ['NNP'],
  'Unione': ['NNP'],
  'Unionized': ['VBN'],
  'Unions': ['NNS'],
  'Unique': ['JJ'],
  'Uniqueness': ['NNP'],
  'Uniroyal': ['NNP'],
  'Uniroyal-Goodrich': ['NNP'],
  'Uniroyal\\\'': ['NNP'],
  'Unisys': ['NNP'],
  'Unit': ['NN'],
  'Unitarian': ['NNP'],
  'Unitarianism': ['NNP'],
  'Unitarians': ['NNPS'],
  'Unitas': ['NNP'],
  'United': ['NNP'],
  'Unitel': ['NNP'],
  'Unitholders': ['NNS'],
  'Unitika': ['NNP'],
  'Unitil': ['NNP'],
  'Unitours': ['NNPS'],
  'Unitrode': ['NNP'],
  'Units': ['NNP'],
  'Unity': ['NNP'],
  'Universal': ['NNP'],
  'Universal-International': ['NNP'],
  'Universal-Morning': ['NNP'],
  'Universal-Rundle': ['NNP'],
  'Universe': ['NNP'],
  'Universities': ['NNS'],
  'University': ['NNP'],
  'University-EPA': ['NNP'],
  'University-based': ['JJ'],
  'Univest': ['NNP'],
  'Univision': ['NNP'],
  'Unix': ['NNP'],
  'Unknown': ['JJ'],
  'Unleaded': ['JJ'],
  'Unless': ['IN'],
  'Unlike': ['IN'],
  'Unlikely': ['RB'],
  'Unlimited': ['NNP'],
  'Unlisted': ['NNP'],
  'Unloading': ['VBG'],
  'Unloved': ['NNP'],
  'Unmanned': ['JJ'],
  'Unmarried': ['JJ'],
  'Uno': ['NNP'],
  'Uno-Ven': ['NNP'],
  'Unocal': ['NNP'],
  'Unoccupied': ['JJ'],
  'Unofficial': ['JJ'],
  'Unpaid': ['JJ'],
  'Unpleasant': ['JJ'],
  'Unpopular': ['JJ'],
  'Unprovable': ['JJ'],
  'Unpublished': ['JJ'],
  'Unquestionably': ['RB'],
  'Unreported': ['JJ'],
  'Unresolved': ['JJ'],
  'Unruh': ['NNP'],
  'Unruly': ['JJ'],
  'Unseasonably': ['RB'],
  'Unsecured': ['JJ'],
  'Unsettling': ['JJ'],
  'Unsinkable': ['NNP'],
  'Unsolved': ['NNP'],
  'Unspeakable': ['JJ'],
  'Unstained': ['JJ'],
  'Unsuccessful': ['JJ'],
  'Unsuspecting': ['JJ'],
  'Untch': ['NNP'],
  'Until': ['IN'],
  'Untold': ['JJ'],
  'Untouchables': ['NNPS'],
  'Unum': ['NNP'],
  'Unused': ['JJ'],
  'Unusual': ['JJ'],
  'Unveiled': ['VBN'],
  'Unveiling': ['VBG'],
  'Unwanted': ['JJ'],
  'Unwarranted': ['JJ'],
  'Unwholesome': ['JJ'],
  'Unwilling': ['JJ'],
  'Unwinding': ['VBG'],
  'Up': ['IN'],
  'Upchurch': ['NNP'],
  'Update': ['NNP'],
  'Updike': ['NNP'],
  'Upgrades': ['NNS'],
  'Upham': ['NNP'],
  'Uphoff': ['NNP'],
  'Upholds': ['VBZ'],
  'Upjohn': ['NNP'],
  'Uplands': ['NNPS'],
  'Upon': ['IN'],
  'Upped': ['VBN'],
  'Upper': ['NNP'],
  'Upping': ['VBG'],
  'Uppsala': ['NNP'],
  'Uprising': ['NNP'],
  'Ups': ['VBZ'],
  'Upsala': ['NNP'],
  'Upset': ['VBN'],
  'Upson': ['NNP'],
  'Upstairs': ['NN'],
  'Uptick': ['NN'],
  'Upton': ['NNP'],
  'Ur': ['VBP'],
  'Ural': ['NNP'],
  'Urals': ['NNPS'],
  'Uranium': ['NNP'],
  'Urban': ['NNP'],
  'Urbana': ['NNP'],
  'Urbanization': ['NN'],
  'Urbano': ['NNP'],
  'Urbanski': ['NNP'],
  'Urben': ['NNP'],
  'Urdis': ['NNP'],
  'Urethane': ['NN'],
  'Urge': ['VB'],
  'Urged': ['VBN'],
  'Urging': ['NNP'],
  'Urich': ['NNP'],
  'Urielites': ['NNPS'],
  'Urien': ['NNP'],
  'Urmstom': ['NNP'],
  'Urn': ['NNP'],
  'Urraca': ['NNP'],
  'Urs': ['NNP'],
  'Ursa': ['NNP'],
  'Urstadt': ['NNP'],
  'Ursuline': ['NNP'],
  'Uruguay': ['NNP'],
  'Us': ['NNP'],
  'Use': ['VB'],
  'Used': ['VBN'],
  'User-friendly': ['JJ'],
  'Users': ['NNS'],
  'Usery': ['NNP'],
  'Uses': ['NNS'],
  'Usha': ['NNP'],
  'Ushikubo': ['NNP'],
  'Ushuaia': ['NNP'],
  'Usines': ['NNP'],
  'Using': ['VBG'],
  'Usinor': ['NNP'],
  'Usinor-Sacilor': ['NNP'],
  'Uspensky': ['NNP'],
  'Usually': ['RB'],
  'Usurpations': ['NNS'],
  'Utah': ['NNP'],
  'Utahans': ['NNPS'],
  'UtiliCorp': ['NNP'],
  'Utilities': ['NNP'],
  'Utility': ['NNP'],
  'Utilization': ['NN'],
  'Utley': ['NNP'],
  'Uto-Aztecan': ['NNP'],
  'Utopia': ['NNP'],
  'Utopian': ['NNP'],
  'Utopians': ['NNPS'],
  'Utrecht': ['NNP'],
  'Utsumi': ['NNP'],
  'Utsunomiya': ['NNP'],
  'Utt': ['NNP'],
  'Utter': ['NNP'],
  'Uxbridge': ['NNP'],
  'Uyl': ['NNP'],
  'Uzbekistan': ['NNP'],
  'Uzi': ['NNP'],
  'Uzi-model': ['JJ'],
  'V': ['NN'],
  'V-1': ['NNP'],
  'V-22': ['NNP'],
  'V-2500': ['NN'],
  'V-6': ['NNP'],
  'V-6-equipped': ['JJ'],
  'V-8': ['JJ'],
  'V-shaped': ['JJ'],
  'V.': ['NNP'],
  'V.E.': ['NNP'],
  'V.H.': ['NNP'],
  'V.O.': ['NNP'],
  'VA': ['NNP'],
  'VA-backed': ['JJ'],
  'VALLEY': ['NNP'],
  'VARIAN': ['NNP'],
  'VAT': ['NNP'],
  'VATICAN': ['NNP'],
  'VAX': ['NNP'],
  'VAX9000': ['NN'],
  'VAX\\\'': ['NNP'],
  'VAXstation': ['NNP'],
  'VCOR': ['NNP'],
  'VCR': ['NNP'],
  'VCRs': ['NNS'],
  'VENTURE': ['NN'],
  'VF': ['NNP'],
  'VGA': ['NNP'],
  'VH-1': ['NNP'],
  'VI': ['NNP'],
  'VIACOM': ['NNP'],
  'VICTIMS': ['NNS'],
  'VICTOR': ['NNP'],
  'VICTORIES': ['NNS'],
  'VIDEO': ['NN'],
  'VIETNAM': ['NNP'],
  'VII': ['NNP'],
  'VIII': ['NNP'],
  'VIP': ['NNP'],
  'VISA': ['NNP'],
  'VISTA': ['NNP'],
  'VISUALIZING': ['VBG'],
  'VISX': ['NNP'],
  'VISystems': ['NNPS'],
  'VITRO': ['NNP'],
  'VLSI': ['NNP'],
  'VNR': ['NNP'],
  'VO5': ['NNP'],
  'VOA': ['NNP'],
  'VOLUME': ['NN'],
  'VOLUNTARISM': ['NN'],
  'VOTED': ['VBD'],
  'VS': ['NNP'],
  'VTC': ['NNP'],
  'VTOL': ['NNP'],
  'VTX': ['NNP'],
  'VW': ['NNP'],
  'VWR': ['NNP'],
  'Va': ['NNP'],
  'Va.': ['NNP'],
  'Va.-based': ['JJ'],
  'VacSYN\\\'': ['NNP'],
  'Vacancies': ['NNS'],
  'Vacancy': ['NN'],
  'Vacation': ['NN'],
  'Vacations': ['NNS'],
  'Vacaville': ['NNP'],
  'Vachell': ['NNP'],
  'Vaclav': ['NNP'],
  'Vacuum': ['NNP'],
  'Vadar': ['NNP'],
  'Vadas': ['NNP'],
  'Vadehra': ['NNP'],
  'Vader': ['NNP'],
  'Vadies': ['NNP'],
  'Vadim': ['NNP'],
  'Vadstena': ['NNP'],
  'Vaezi': ['NNP'],
  'Vagabond': ['NNP'],
  'Vagabonds': ['NNPS'],
  'Vague': ['JJ'],
  'Vahid': ['NNP'],
  'Vaikule': ['NNP'],
  'Vail': ['NNP'],
  'Vajna': ['NNP'],
  'Val': ['NNP'],
  'Valais': ['NNP'],
  'Valdemar': ['NNP'],
  'Valdese': ['NNP'],
  'Valdez': ['NNP'],
  'Valdiserri': ['NNP'],
  'Vale': ['NNP'],
  'Vale\\\'': ['IN'],
  'Valedictorian': ['NNP'],
  'Valen': ['NNP'],
  'Valencia': ['NNP'],
  'Valens': ['NNP'],
  'Valente': ['NNP'],
  'Valenti': ['NNP'],
  'Valentin': ['NNP'],
  'Valentina': ['NNP'],
  'Valentine': ['NNP'],
  'Valentino': ['NNP'],
  'Valeri': ['NNP'],
  'Valerie': ['NNP'],
  'Valero': ['NNP'],
  'Valery': ['NNP'],
  'Valhalla': ['NNP'],
  'Valhi': ['NNP'],
  'Valiant': ['NNP'],
  'Valin': ['NNP'],
  'Valium': ['NNP'],
  'Valladolid': ['NNP'],
  'Valle': ['NNP'],
  'Vallecas': ['NNP'],
  'Vallee': ['NNP'],
  'Valley': ['NNP'],
  'Valleyfair': ['NNP'],
  'Vallfart': ['NNP'],
  'Valmet': ['NN'],
  'Valois': ['NNP'],
  'Valparaiso': ['NNP'],
  'Valrico': ['NNP'],
  'Valspar': ['NNP'],
  'Valu': ['NNP'],
  'Valuable': ['NNP'],
  'Value': ['NNP'],
  'Valued': ['VBN'],
  'Values': ['NNPS'],
  'Valvoline': ['NNP'],
  'Vamp': ['NNP'],
  'Van': ['NNP'],
  'VanSant': ['NNP'],
  'Vance': ['NNP'],
  'Vancouver': ['NNP'],
  'Vancouver-based': ['JJ'],
  'Vanden': ['NNP'],
  'VandenBerg': ['NNP'],
  'Vandenberg': ['NNP'],
  'Vander': ['NNP'],
  'Vanderbilt': ['NNP'],
  'Vanderbilts': ['NNS'],
  'Vandervoort': ['NNP'],
  'Vandiver': ['NNP'],
  'Vandringsar': ['NNP'],
  'Vane': ['NNP'],
  'Vanessa': ['NNP'],
  'Vanguard': ['NNP'],
  'Vanguardia': ['NNP'],
  'Vanities': ['NNS'],
  'Vanity': ['NNP'],
  'Vanourek': ['NNP'],
  'Vanous': ['NNP'],
  'Vantage': ['NNP'],
  'Vanuatu': ['NNP'],
  'Vapor': ['NN'],
  'Vappenfabrikk': ['NNP'],
  'Varadero': ['NNP'],
  'Varalli': ['NNP'],
  'Varani': ['NNP'],
  'Varese': ['NNP'],
  'Varga': ['NNP'],
  'Vargas': ['NNP'],
  'Varian': ['NNP'],
  'Variations': ['NNPS'],
  'Variety': ['NNP'],
  'Varigrad': ['NNP'],
  'Various': ['JJ'],
  'Varitronic': ['NNP'],
  'Varity': ['NNP'],
  'Varlaam': ['NNP'],
  'Varmus': ['NNP'],
  'Varnell': ['NNP'],
  'Varner': ['NNP'],
  'Varnessa': ['NNP'],
  'Varo': ['NNP'],
  'Varvara': ['NNP'],
  'Varviso': ['NNP'],
  'Vary': ['VBP'],
  'Varying': ['JJ'],
  'Vasa': ['NNP'],
  'Vasady': ['NNP'],
  'Vaseretic': ['NNP'],
  'Vases': ['NNS'],
  'Vasilenko': ['NNP'],
  'Vasilievitch': ['NNP'],
  'Vaska': ['NNP'],
  'Vasotec': ['NNP'],
  'Vasquez': ['NNP'],
  'Vass': ['NNP'],
  'Vassiliades': ['NNP'],
  'Vasso': ['NNP'],
  'Vast': ['JJ'],
  'Vastly': ['RB'],
  'Vasvani': ['NNP'],
  'Vatican': ['NNP'],
  'Vattern': ['NNP'],
  'Vaudois': ['NNP'],
  'Vaughan': ['NNP'],
  'Vaughn': ['NNP'],
  'Vault': ['NNP'],
  'Vaux': ['NNP'],
  'Vauxhall': ['NNP'],
  'Vauxhill': ['NNP'],
  'Vax': ['NNP'],
  'VaxSyn': ['NNP'],
  'Veatch': ['NNP'],
  'Veba': ['NNP'],
  'Veblen': ['NNP'],
  'VecTrol': ['NNP'],
  'Vecchio': ['NNP'],
  'Vector': ['NNP'],
  'Vectra': ['NNP'],
  'Vedder': ['NNP'],
  'Vedrine': ['NNP'],
  'Veeck': ['NNP'],
  'Vega': ['NNP'],
  'Vegans': ['NNPS'],
  'Vegas': ['NNP'],
  'Vegas-based': ['JJ'],
  'Vegetable': ['NN'],
  'Vegetables': ['NNS'],
  'Vehicle': ['NNP'],
  'Vehicles': ['NNPS'],
  'Veil': ['NNP'],
  'Veiling': ['VBG'],
  'Veille': ['NNP'],
  'Veilleux': ['NNP'],
  'Velasco': ['NNP'],
  'Velasquez': ['NNP'],
  'Velazquez': ['NNP'],
  'Velcro': ['NN'],
  'Vellante': ['NNP'],
  'VeloBind': ['NNP'],
  'Velon': ['NNP'],
  'Veltri': ['NNP'],
  'Velveeta': ['NNP'],
  'Venable': ['NNP'],
  'Vencor': ['NNP'],
  'Vending': ['NN'],
  'Vendome': ['NNP'],
  'Vendors': ['NNS'],
  'Venerable': ['NNP'],
  'Venetian': ['NNP'],
  'Veneto': ['NNP'],
  'Venetoen': ['NNP'],
  'Venezuela': ['NNP'],
  'Venezuelan': ['JJ'],
  'Venezuelans': ['NNPS'],
  'Veniamin': ['NNP'],
  'Venice': ['NNP'],
  'Venit': ['NNP'],
  'Venn': ['NNP'],
  'Venneboerger': ['NNP'],
  'Vent': ['NN'],
  'Ventes': ['NNP'],
  'Venti': ['NNP'],
  'Ventilation': ['NN'],
  'Vento': ['NNP'],
  'Ventres': ['NNP'],
  'Ventspils': ['NNP'],
  'Ventura': ['NNP'],
  'Venture': ['NNP'],
  'Ventured': ['NNP'],
  'Ventures': ['NNP'],
  'Venturesome': ['JJ'],
  'Venturi': ['NNP'],
  'Venus': ['NNP'],
  'Venusians': ['NNPS'],
  'Vera': ['NNP'],
  'Veracruz': ['NNP'],
  'Veraguas': ['NNP'],
  'Veraldi': ['NNP'],
  'Verbal': ['JJ'],
  'Verbatim': ['JJ'],
  'Verbindungstechnik': ['NNP'],
  'Verboort': ['NN'],
  'Verbrugge': ['NNP'],
  'Verde': ['NNP'],
  'Verdes': ['NNP'],
  'Verdi': ['NNP'],
  'Vere': ['NNP'],
  'Vereinsbank': ['NNP'],
  'Verey': ['NNP'],
  'Verfahrenstechnik': ['NNP'],
  'Verges': ['NNP'],
  'Vergessen': ['FW'],
  'Verification': ['NN'],
  'Verit': ['NNP'],
  'Veritrac': ['NNP'],
  'Verloop': ['NNP'],
  'Vermeersch': ['NNP'],
  'Vermejo': ['NNP'],
  'Vermes': ['NNP'],
  'Vermont': ['NNP'],
  'Vermont-Slauson': ['NNP'],
  'Vermont-based': ['JJ'],
  'Vermonters': ['NNPS'],
  'Vermouth': ['NNP'],
  'Vern': ['NNP'],
  'Vernava': ['NNP'],
  'Verne': ['NNP'],
  'Verner': ['NNP'],
  'Vernier': ['NNP'],
  'Vernitron': ['NNP'],
  'Vernon': ['NNP'],
  'Vernor': ['NNP'],
  'Vero': ['NNP'],
  'Veronica': ['NN'],
  'Veronique': ['NNP'],
  'Veronis': ['NNP'],
  'Verplanck': ['NNP'],
  'Verreau': ['NNP'],
  'Verret': ['NNP'],
  'Verrone': ['NNP'],
  'Versailles': ['NNP'],
  'Verses': ['NNS'],
  'Versicherung': ['NNP'],
  'Versicherungs': ['NNP'],
  'Version': ['NNP'],
  'Verstandig': ['NNP'],
  'Verwoerd': ['NNP'],
  'Very': ['RB'],
  'Veryfine': ['NNP'],
  'Vesco': ['NNP'],
  'Vescos': ['NNPS'],
  'Veselich': ['NNP'],
  'Veslefrikk': ['NNP'],
  'Vesoft': ['NNP'],
  'Vesole': ['NNP'],
  'Vessel': ['NNP'],
  'Vestar': ['NNP'],
  'Vesuvio': ['NNP'],
  'Veteran': ['JJ'],
  'Veterans': ['NNP'],
  'Vetere': ['NNP'],
  'Veteri': ['NNP'],
  'Veterinary': ['NNP'],
  'Vevay': ['NNP'],
  'Vevey': ['NNP'],
  'Via': ['NNP'],
  'Viacom': ['NNP'],
  'Viag': ['NNP'],
  'Viaje': ['NNP'],
  'Viale': ['NNP'],
  'Viall': ['NNP'],
  'Viande': ['NNP'],
  'Viareggio': ['NNP'],
  'Viatech': ['NNP'],
  'Viator': ['NNP'],
  'Vibrometer': ['NN'],
  'Vic': ['NNP'],
  'Vical': ['NNP'],
  'Vicar': ['NNP'],
  'Vice': ['NNP'],
  'Vice-President': ['NNP'],
  'Vice-president': ['NN'],
  'Vicenza': ['NNP'],
  'Viceroy': ['NNP'],
  'Vichy': ['NNP'],
  'Vickers': ['NNP'],
  'Vickery': ['NNP'],
  'Vicki': ['NNP'],
  'Vickie': ['NNP'],
  'Vicks': ['NNP'],
  'Vicksburg': ['NNP'],
  'Vickstrom': ['NNP'],
  'Vicky': ['NNP'],
  'Vicolo': ['NNP'],
  'Vicon': ['NNP'],
  'Victim': ['NN'],
  'Victimization': ['NN'],
  'Victims': ['NNS'],
  'Victoire': ['NNP'],
  'Victor': ['NNP'],
  'Victor-Butler': ['NNP'],
  'Victor-brand': ['JJ'],
  'Victoria': ['NNP'],
  'Victorian': ['JJ'],
  'Victorians': ['NNS'],
  'Victory': ['NNP'],
  'Victrola': ['NN'],
  'Vida': ['NNP'],
  'Vidal': ['NNP'],
  'Video': ['NNP'],
  'Videos': ['NNPS'],
  'Videotron': ['NNP'],
  'Videoway': ['NNP'],
  'Vidunas': ['NNP'],
  'Vie': ['NNP'],
  'Vieira': ['NNP'],
  'Vienna': ['NNP'],
  'Vienne': ['NNP'],
  'Viennese': ['JJ'],
  'Vienot': ['NNP'],
  'Vientiane': ['NNP'],
  'Viet': ['NNP'],
  'Vieth': ['NNP'],
  'Vietnam': ['NNP'],
  'Vietnam-veteran': ['JJ'],
  'Vietnamese': ['JJ'],
  'Vietnamese-backed': ['JJ'],
  'Vietor': ['NNP'],
  'Vieux': ['NNP'],
  'View': ['NNP'],
  'Viewed': ['VBN'],
  'Viewer': ['NNP'],
  'Viewers': ['NNS'],
  'Viewing': ['VBG'],
  'Viewmaster': ['NNP'],
  'Viewmaster-Ideal': ['NNP'],
  'Viewpoint': ['NNP'],
  'Views': ['NNS'],
  'Vif': ['NNP'],
  'Vigdor': ['NNP'],
  'Viggo': ['NNP'],
  'Vigier': ['NNP'],
  'Vignola': ['NNP'],
  'Vigorous': ['JJ'],
  'Vigreux': ['NNP'],
  'Vihon': ['NNP'],
  'Vikes': ['NNPS'],
  'Viking': ['NNP'],
  'Viking\\\'/Penguin': ['NN'],
  'Vikings': ['NNPS'],
  'Viktor': ['NNP'],
  'Vikulov': ['NNP'],
  'Vila': ['NNP'],
  'Vilaplana': ['NNP'],
  'Vilas': ['NNP'],
  'Vilgrain': ['NNP'],
  'Villa': ['NNP'],
  'Village': ['NNP'],
  'Villagers': ['NNS'],
  'Villages': ['NNS'],
  'Villalobos': ['NNP'],
  'Villamiel': ['NNP'],
  'Villanova': ['NNP'],
  'Villanueva': ['NNP'],
  'Villard': ['NNP'],
  'Ville': ['NNP'],
  'Vilnius': ['NNP'],
  'Vince': ['NNP'],
  'Vincent': ['NNP'],
  'Vindication': ['NNP'],
  'Vinegar': ['NNP'],
  'Vineland': ['NNP'],
  'Vineyard': ['NNP'],
  'Vineyards': ['NNS'],
  'Vining': ['NNP'],
  'Vinken': ['NNP'],
  'Vinnicum': ['NNP'],
  'Vinnin': ['NNP'],
  'Vinogradoff': ['NNP'],
  'Vinson': ['NNP'],
  'Vintage': ['NN'],
  'Viola': ['NNP'],
  'Violence': ['NNP'],
  'Violent': ['JJ'],
  'Violet': ['NNP'],
  'Violeta': ['NNP'],
  'Violetta': ['NNP'],
  'Violin': ['NNP'],
  'Viper': ['NNP'],
  'Viphakone': ['NNP'],
  'Virdon': ['NNP'],
  'Viren': ['NNP'],
  'Virgil': ['NNP'],
  'Virgilia': ['NNP'],
  'Virgilio': ['NNP'],
  'Virgin': ['NNP'],
  'Virginia': ['NNP'],
  'Virginian': ['NNP'],
  'Virginians': ['NNPS'],
  'Virgins': ['NNPS'],
  'Virnich': ['NNP'],
  'Virology': ['NNP'],
  'Viroqua': ['NNP'],
  'Virsaladze': ['NNP'],
  'Virtually': ['RB'],
  'Virtue': ['NNP'],
  'Virus': ['NN'],
  'Viruscan': ['NNP'],
  'Viruses': ['NNS'],
  'Visa': ['NNP'],
  'Viscera': ['NNPS'],
  'Viscerally': ['RB'],
  'Viscount': ['NNP'],
  'Visher': ['NNP'],
  'Vishwanath': ['NNP'],
  'Visibility': ['NN'],
  'Visigoths': ['NNPS'],
  'Vision': ['NNP'],
  'VisionQuest': ['NNP'],
  'Visitation': ['NNP'],
  'Visiting': ['VBG'],
  'Visitors': ['NNS'],
  'Visits': ['NNS'],
  'Visker': ['NNP'],
  'Viss': ['NNP'],
  'Visscher': ['NNP'],
  'Vista': ['NNP'],
  'Vistoso': ['NNP'],
  'Visual': ['JJ'],
  'Visualize': ['VB'],
  'Visually': ['RB'],
  'Visx': ['NNP'],
  'Vita': ['NNP'],
  'Vital': ['JJ'],
  'Vitale': ['NNP'],
  'Vitalie': ['NNP'],
  'Vitaly': ['NNP'],
  'Vitamin': ['NN'],
  'Vitamins': ['NNS'],
  'Vitarine': ['NNP'],
  'Vitro': ['NNP'],
  'Vitro-Anchor': ['NNP'],
  'Vittoria': ['NNP'],
  'Vittorio': ['NNP'],
  'Vitulli': ['NNP'],
  'Vitus': ['NNP'],
  'Vitzhum': ['NNP'],
  'Viva': ['FW'],
  'Vivacious': ['JJ'],
  'Vivaldi': ['NNP'],
  'Vivaldi-at-brunch': ['JJ'],
  'Vive': ['FW'],
  'Vivian': ['NNP'],
  'Vivien': ['NNP'],
  'Vivier': ['NNP'],
  'Viyella': ['NNP'],
  'Vizas': ['NNP'],
  'Vizcaya': ['NNP'],
  'Vizeversa': ['NNP'],
  'Vladilen': ['NNP'],
  'Vladimir': ['NNP'],
  'Vladivostok': ['NNP'],
  'Vlasi': ['NNP'],
  'Vnet': ['NNP'],
  'Vocabularianism': ['NNP'],
  'Vocabulary': ['NNP'],
  'Vocal': ['NN'],
  'Vocational': ['NNP'],
  'Voegelin': ['NNP'],
  'Voegtli': ['NNP'],
  'Voell': ['NNP'],
  'Vogel': ['NNP'],
  'Vogelstein': ['NNP'],
  'Vogtle': ['NNP'],
  'Vogue': ['NNP'],
  'Voice': ['NNP'],
  'Voices': ['NNS'],
  'Voicetek': ['NNP'],
  'Void': ['NN'],
  'Voiture': ['NNP'],
  'Vol.': ['NNP'],
  'Volare': ['NNP'],
  'Volatile': ['JJ'],
  'Volatility': ['NN'],
  'Volcker': ['NNP'],
  'Volga': ['NNP'],
  'Volgograd': ['NNP'],
  'Volio': ['NNP'],
  'Volk': ['NNP'],
  'Volkenstein': ['NNP'],
  'Volker': ['NNP'],
  'Volksgeist': ['FW'],
  'Volkswagen': ['NNP'],
  'Volkswagens': ['NNPS'],
  'Volland': ['NNP'],
  'Vollard': ['NNP'],
  'Vollrath': ['NNP'],
  'Volney': ['NNP'],
  'Volokh': ['NNP'],
  'Volokhs': ['NNPS'],
  'Volpe': ['NNP'],
  'Volstead': ['JJ'],
  'Volta': ['NNP'],
  'Voltaire': ['NNP'],
  'Volume': ['NN'],
  'Volumes': ['NNS'],
  'Voluntary': ['NNP'],
  'Volunteer': ['NNP'],
  'Volunteers': ['NNPS'],
  'Volvo': ['NNP'],
  'Volvo-Renault': ['NNP'],
  'Volz': ['NNP'],
  'Volzhsky': ['NNP'],
  'Vom': ['NNP'],
  'Von': ['NNP'],
  'Vonnegut': ['NNP'],
  'Vons': ['NNPS'],
  'Voorhees': ['NNP'],
  'Voorhes': ['NNP'],
  'Voroba': ['NNP'],
  'Voronezh': ['NNP'],
  'Vorontsov': ['NNP'],
  'Voroshilov': ['NNP'],
  'Vortex': ['NNP'],
  'Vos': ['NNP'],
  'Vose': ['NNP'],
  'Vosges': ['NNPS'],
  'Voss': ['NNP'],
  'Vote': ['NN'],
  'Voter': ['NN'],
  'Voters': ['NNS'],
  'Votes': ['NNS'],
  'Voting': ['NNP'],
  'Vouillemont': ['NNP'],
  'Vous': ['FW'],
  'Voute': ['NNP'],
  'Voutila': ['NNP'],
  'Vowel': ['NNP'],
  'Vowel-Length': ['NN'],
  'Vowels': ['NNS'],
  'Vowing': ['VBG'],
  'Voyager': ['NNP'],
  'Voyagers': ['NNPS'],
  'Voyagers.': ['NNPS'],
  'Voyles': ['NNP'],
  'Vranian': ['NNP'],
  'Vries': ['NNP'],
  'Vrilium': ['NNP'],
  'Vroman': ['NNP'],
  'Vroom': ['NNP'],
  'Vs.': ['FW'],
  'Vt': ['NNP'],
  'Vt.': ['NNP'],
  'Vt.-based': ['JJ'],
  'Vu': ['NNP'],
  'Vue': ['NNP'],
  'Vuitton': ['NNP'],
  'Vulcan': ['NNP'],
  'Vulture': ['NN'],
  'Vulturidae': ['NNS'],
  'Vyacheslav': ['NNP'],
  'Vyas': ['NNP'],
  'Vyquest': ['NNP'],
  'W': ['NNP'],
  'W&D': ['NNP'],
  'W-2': ['NN'],
  'W-2s': ['NNS'],
  'W-region': ['NN'],
  'W.': ['NNP'],
  'W.A.': ['NNP'],
  'W.B.': ['NNP'],
  'W.C.': ['NNP'],
  'W.D.': ['NNP'],
  'W.E.': ['NNP'],
  'W.F.': ['NNP'],
  'W.G.': ['NNP'],
  'W.H.': ['NNP'],
  'W.I.': ['NNP'],
  'W.I.L.D': ['NNP'],
  'W.J.': ['NNP'],
  'W.L.': ['NNP'],
  'W.M.': ['NNP'],
  'W.N.': ['NNP'],
  'W.O.': ['NNP'],
  'W.R.': ['NNP'],
  'W.S.': ['NNP'],
  'W.T.': ['NNP'],
  'W.Va': ['NNP'],
  'W.Va.': ['NNP'],
  'W.W.': ['NNP'],
  'W/NNP.A.': ['NN'],
  'W/NNP.B/NNP.I.': ['NN'],
  'W/NNP.R.G.': ['NNP'],
  'WABC': ['NNP'],
  'WAC': ['NNP'],
  'WACS': ['NNPS'],
  'WAFA': ['NNP'],
  'WAGE': ['NN'],
  'WAIT': ['VB'],
  'WALL': ['NNP'],
  'WANES': ['VBZ'],
  'WANT': ['VBP'],
  'WAO': ['NNP'],
  'WAR': ['NNP'],
  'WARNED': ['VBD'],
  'WARNER-LAMBERT': ['NNP'],
  'WARS': ['NNS'],
  'WAS': ['VBD'],
  'WASHINGTON': ['NNP'],
  'WATCH': ['VB'],
  'WATKINS-JOHNSON': ['NNP'],
  'WAVE': ['NNP'],
  'WAZ': ['NNP'],
  'WB': ['NNP'],
  'WBAI': ['NNP'],
  'WBBM-TV': ['NNP'],
  'WBZ': ['NNP'],
  'WCI': ['NNP'],
  'WCRS': ['NNP'],
  'WCRS-Eurocom': ['NNP'],
  'WCRS\\\'/Boston': ['NNP'],
  'WCVB': ['NNP'],
  'WD-40': ['NNP'],
  'WDB': ['NN'],
  'WE': ['PRP'],
  'WEDTECH': ['NNP'],
  'WEEI': ['NNP'],
  'WEEK': ['NN'],
  'WEFA': ['NNP'],
  'WEIRTON': ['NNP'],
  'WELLS': ['NNP'],
  'WENT': ['VBD'],
  'WESLEY': ['NNP'],
  'WEST': ['NNP'],
  'WESTWOOD': ['NNP'],
  'WFAA': ['NNP'],
  'WFAA-TV': ['NNP'],
  'WFC': ['NNP'],
  'WFRR': ['NNP'],
  'WFXT': ['NNP'],
  'WFXT-TV': ['NNP'],
  'WGBH': ['NNP'],
  'WGP': ['NNP'],
  'WHAS': ['NNP'],
  'WHAT': ['WP'],
  'WHEC-TV': ['NNP'],
  'WHEN': ['WRB'],
  'WHICH': ['WDT'],
  'WHIRLPOOL': ['NN'],
  'WHISPER': ['NN'],
  'WHITMAN': ['NNP'],
  'WHO': ['WP'],
  'WHO\'S': ['JJ'],
  'WHOOPS': ['NNP'],
  'WHX': ['NNP'],
  'WHY': ['WRB'],
  'WIC': ['NNP'],
  'WILL': ['MD'],
  'WIN': ['NNP'],
  'WINDOW': ['NN'],
  'WINS': ['VBZ'],
  'WINSTON-SALEM': ['NNP'],
  'WIN\\\'': ['NNP'],
  'WIT': ['IN'],
  'WITH': ['IN'],
  'WITHHELD': ['VBN'],
  'WITHHOLDING': ['NN'],
  'WKRP': ['NNP'],
  'WLF': ['NNP'],
  'WLIB': ['NNP'],
  'WMB': ['NNP'],
  'WNBC': ['NNP'],
  'WNBC-TV': ['NNP'],
  'WNET': ['NNP'],
  'WNYC': ['NNP'],
  'WNYC-FM': ['NNP'],
  'WNYW': ['NNP'],
  'WNYW-TV': ['NNP'],
  'WOLFSON': ['NNP'],
  'WOMEN': ['NNS'],
  'WON': ['VBP'],
  'WON\'T': ['NNP'],
  'WOODSTOCK': ['NNP'],
  'WORD': ['NN'],
  'WORK': ['VBP'],
  'WORKERS': ['NNS'],
  'WORKING': ['VBG'],
  'WORKS': ['NNP'],
  'WORLD': ['NN'],
  'WORLDLY': ['JJ'],
  'WOULDN\'T': ['NNP'],
  'WPA': ['NNP'],
  'WPP': ['NNP'],
  'WPPSS': ['NNP'],
  'WPS': ['NNP'],
  'WRC': ['NNP'],
  'WSJ': ['NNP'],
  'WSJ\\\'': ['NNP'],
  'WSJ\\\'/NBC': ['NNP'],
  'WSY': ['NNP'],
  'WTBS': ['NNP'],
  'WTD': ['NNP'],
  'WTI': ['NNP'],
  'WTPI-FM': ['NNP'],
  'WTV': ['NNP'],
  'WTVJ': ['NNP'],
  'WTXF': ['NNP'],
  'WW': ['NNP'],
  'WWL': ['NNP'],
  'WWOR': ['NNP'],
  'WWRL': ['NNP'],
  'WXRK': ['NNP'],
  'WXRK-FM': ['NNP'],
  'WYSE': ['NNP'],
  'W\\\'/O': ['NNP'],
  'Wa': ['NNP'],
  'Waal': ['NNP'],
  'Waban': ['NNP'],
  'Wabash': ['NNP'],
  'Wachovia': ['NNP'],
  'Wachsman': ['NNP'],
  'Wachtel': ['NNP'],
  'Wachtell': ['NNP'],
  'Wachter': ['NNP'],
  'Wachtler': ['NNP'],
  'Wackenhut': ['NNP'],
  'Wacker': ['NNP'],
  'Wackers': ['NNPS'],
  'Wacklin': ['NNP'],
  'Wacky': ['NNP'],
  'Waco': ['NNP'],
  'Wacoal': ['NNP'],
  'Wada': ['NNP'],
  'Waddell': ['NNP'],
  'Wade': ['NNP'],
  'Wade-Evans': ['NNP'],
  'Wadsworth': ['NNP'],
  'Waertsilae': ['NNP'],
  'Wafaa': ['NNP'],
  'Waffen': ['NNP'],
  'Wage': ['NN'],
  'Wage-price': ['JJ'],
  'Wage-settlement': ['JJ'],
  'Wagg': ['NNP'],
  'Waggin': ['NNP'],
  'Waggoner': ['NNP'],
  'Wagner': ['NNP'],
  'Wagner-Peyser': ['NNP'],
  'Wagnerian': ['JJ'],
  'Wagon': ['NNP'],
  'Wagoneer': ['NNP'],
  'Wagons': ['NNS'],
  'Wah': ['NNP'],
  'Waigel': ['NNP'],
  'Waikiki': ['NNP'],
  'Waikikians': ['NNPS'],
  'Waikoloa': ['NNP'],
  'Wailbri': ['NNP'],
  'Wain': ['NNP'],
  'Wainaina': ['NNP'],
  'Wainwright': ['NNP'],
  'Waist-High': ['JJ'],
  'Wait': ['VB'],
  'Waite': ['NNP'],
  'Waited': ['VBN'],
  'Waiting': ['VBG'],
  'Wakabayashi': ['NNP'],
  'Wakako': ['NNP'],
  'Wakayama': ['NNP'],
  'Wake': ['VB'],
  'Wake-Up': ['NNP'],
  'Wakefield': ['NNP'],
  'Wakeman': ['NNP'],
  'Wakes': ['NNP'],
  'Waking': ['VBG'],
  'Wako': ['NNP'],
  'Waksman': ['NNP'],
  'Wakui': ['NNP'],
  'Wal-Mart': ['NNP'],
  'Walbancke': ['NNP'],
  'Walbrecher': ['NNP'],
  'Walbridge': ['NNP'],
  'Walcott': ['NNP'],
  'Wald': ['NNP'],
  'Waldbaum': ['NNP'],
  'Walden': ['NNP'],
  'Waldenbooks': ['NNP'],
  'Waldensian': ['JJ'],
  'Waldheim': ['NNP'],
  'Waldholz': ['NNP'],
  'Waldman': ['NNP'],
  'Waldo': ['NNP'],
  'Waldorf': ['NNP'],
  'Waldorf-Astoria': ['NNP'],
  'Waldron': ['NNP'],
  'Wales': ['NNP'],
  'Walesa': ['NNP'],
  'Waleson': ['NNP'],
  'Walford': ['NNP'],
  'Walgreen': ['NNP'],
  'Walinsky': ['NNP'],
  'Walinsky-Rubinstein': ['NNP'],
  'Walitzee': ['NNP'],
  'Walk': ['VB'],
  'Walk-in': ['JJ'],
  'Walker': ['NNP'],
  'Walkers': ['NNPS'],
  'Walkin': ['NNP'],
  'Walking': ['VBG'],
  'Walkman': ['NNP'],
  'Walkman-style': ['JJ'],
  'Walkmen': ['NNP'],
  'Wall': ['NNP'],
  'Wall-Tex': ['NN'],
  'Walla': ['NNP'],
  'Wallace': ['NNP'],
  'Wallach': ['NNP'],
  'Wallachs': ['NNP'],
  'Walle': ['NNP'],
  'Wallenberg': ['NNP'],
  'Wallenstein': ['NNP'],
  'Wallingford': ['NNP'],
  'Walloons': ['NNPS'],
  'Wallop': ['NNP'],
  'Walls': ['NNS'],
  'Wallstreet': ['NNP'],
  'Wally': ['NNP'],
  'Walmart': ['NNP'],
  'Walnut': ['NNP'],
  'Walpole': ['NNP'],
  'Walsh': ['NNP'],
  'Walsifer': ['NNP'],
  'Walt': ['NNP'],
  'Waltana': ['NNP'],
  'Waltch': ['NNP'],
  'Walter': ['NNP'],
  'Waltermire': ['NNP'],
  'Walters': ['NNP'],
  'Walters-Donaldson': ['NNP'],
  'Waltham': ['NNP'],
  'Walther': ['NNP'],
  'Walton': ['NNP'],
  'Walzer': ['NNP'],
  'Wambui': ['NNP'],
  'Wames': ['NNP'],
  'Wamre': ['NNP'],
  'Wan': ['NNP'],
  'Wanda': ['NNP'],
  'Wander': ['VB'],
  'Wander-Years': ['NNP'],
  'Wanderjahr': ['NN'],
  'Wanders': ['NNP'],
  'Wang': ['NNP'],
  'Wangemans': ['NNPS'],
  'Wangenheim': ['NNP'],
  'Wanger': ['NNP'],
  'Waning': ['JJ'],
  'Wankui': ['NNP'],
  'Wanna': ['VB'],
  'Wanniski': ['NNP'],
  'Wansee': ['NNP'],
  'Wansley': ['NNP'],
  'Want': ['VB'],
  'Wanted': ['VBN'],
  'Wants': ['VBZ'],
  'Wappinger': ['NNP'],
  'War': ['NNP'],
  'War-era': ['NNP'],
  'War-related': ['JJ'],
  'Warburg': ['NNP'],
  'Warburgs': ['NNPS'],
  'Ward': ['NNP'],
  'Wardair': ['NNP'],
  'Warden': ['NNP'],
  'Wards': ['NNP'],
  'Wardwell': ['NNP'],
  'Ware': ['NNP'],
  'Warehouse': ['NNP'],
  'Warfield': ['NNP'],
  'Warhol': ['NNP'],
  'Waring': ['NNP'],
  'Warm': ['JJ'],
  'Warman': ['NNP'],
  'Warming': ['VBG'],
  'Warmly': ['RB'],
  'Warmongering': ['VBG'],
  'Warnaco': ['NNP'],
  'Warned': ['VBD'],
  'Warner': ['NNP'],
  'Warner-Chilcott': ['NNP'],
  'Warner-Lambart': ['NNP'],
  'Warner-Lambert': ['NNP'],
  'Warners': ['NNS'],
  'Warning': ['NNP'],
  'Warnke': ['NNP'],
  'Warnock': ['NNP'],
  'Warranties': ['NNS'],
  'Warrants': ['NNS'],
  'Warren': ['NNP'],
  'Warrens': ['NNS'],
  'Warrenton': ['NNP'],
  'Warrick': ['NNP'],
  'Warring': ['NNP'],
  'Warrior': ['NNP'],
  'Warriors': ['NNP'],
  'Wars': ['NNPS'],
  'Warsaw': ['NNP'],
  'Warshaw': ['NNP'],
  'Wartburgs': ['NNPS'],
  'Wartzman': ['NNP'],
  'Warwick': ['NNP'],
  'Warwickshire': ['NNP'],
  'Wary': ['JJ'],
  'Was': ['VBD'],
  'Wasatch': ['NNP'],
  'Waseda': ['NNP'],
  'Wash': ['NNP'],
  'Wash.': ['NNP'],
  'Wash.-based': ['JJ'],
  'Washburn': ['NNP'],
  'Washed': ['VBN'],
  'Washing': ['NN'],
  'Washington': ['NNP'],
  'Washington-Alexandria': ['NNP'],
  'Washington-Oregon': ['NNP'],
  'Washington-area': ['JJ'],
  'Washington-based': ['JJ'],
  'Washingtons': ['NNPS'],
  'Washizu': ['NNP'],
  'Washoe': ['NNP'],
  'Waslic': ['NNP'],
  'Wasserstein': ['NNP'],
  'Wassily': ['NNP'],
  'Wasson': ['NNP'],
  'Waste': ['NNP'],
  'Waste-management': ['NN'],
  'Wastewater': ['NNP'],
  'Wastrel': ['NN'],
  'Watanabe': ['NNP'],
  'Watch': ['NN'],
  'Watchers': ['NNPS'],
  'Watches': ['NNS'],
  'Watching': ['VBG'],
  'Watchmen': ['NNP'],
  'Water': ['NNP'],
  'Water-soluble': ['JJ'],
  'Waterbury': ['NNP'],
  'Watercolor': ['NNP'],
  'Waterford': ['NNP'],
  'Watergate': ['NNP'],
  'Watergate-beleaguered': ['JJ'],
  'Waterhouse': ['NNP'],
  'Waterloo': ['NN'],
  'Waterman': ['NNP'],
  'Waters': ['NNP'],
  'Waterseller': ['NNP'],
  'Waterston': ['NNP'],
  'Watertown': ['NNP'],
  'Waterville': ['NNP'],
  'Watervliet': ['NNP'],
  'Waterways': ['NNS'],
  'Wathen': ['NNP'],
  'Watkins': ['NNP'],
  'Watkins-Johnson': ['NNP'],
  'Watling': ['NNP'],
  'Watrous': ['NNP'],
  'Watson': ['NNP'],
  'Watson-Watt': ['NNP'],
  'Watsonville': ['NNP'],
  'Watt': ['NNP'],
  'Wattenberg': ['NNP'],
  'Watterson': ['NNP'],
  'Wattie': ['NNP'],
  'Wattley': ['NNP'],
  'Watts': ['NNP'],
  'Waugh': ['NNP'],
  'Waukegan': ['NNP'],
  'Waukesha': ['NNP'],
  'Wave': ['NNP'],
  'Waveland': ['NNP'],
  'Waverly': ['NNP'],
  'Waving': ['VBG'],
  'Wavy': ['JJ'],
  'Waxman': ['NNP'],
  'Waxworks': ['NNP'],
  'Way': ['NN'],
  'WayMar': ['NNP'],
  'Waycross': ['NNP'],
  'Wayland': ['NNP'],
  'Waymire': ['NNP'],
  'Waymouth': ['NNP'],
  'Wayne': ['NNP'],
  'Ways': ['NNPS'],
  'Wazir': ['NNP'],
  'We': ['PRP'],
  'We\'ll': ['MD'],
  'We\'ve': ['NN'],
  'Weak': ['JJ'],
  'Weaken': ['VB'],
  'Weakening': ['VBG'],
  'Weakens': ['VBZ'],
  'Weakest': ['JJS'],
  'Weakness': ['NN'],
  'Wealth': ['NNP'],
  'Wealthy': ['NNP'],
  'Weaning': ['NNP'],
  'Weapon': ['NNP'],
  'Weapons': ['NNP'],
  'Wear': ['VB'],
  'Wearing': ['VBG'],
  'Weart': ['NNP'],
  'Weary': ['JJ'],
  'Weasel': ['NNP'],
  'Weather': ['NNP'],
  'Weatherford': ['NNP'],
  'Weatherly': ['NNP'],
  'Weathers': ['NNPS'],
  'Weaver': ['NNP'],
  'Weavers': ['NNS'],
  'Weaving': ['VBG'],
  'Web': ['NNP'],
  'Webb': ['NNP'],
  'Webber': ['NNP'],
  'Weber': ['NNP'],
  'Weber-controlled': ['JJ'],
  'Webern': ['NNP'],
  'Webster': ['NNP'],
  'Webster\\\'': ['NNP'],
  'Webster\\\'/Eagle': ['NNP'],
  'Websterville': ['NNP'],
  'Wechsler': ['NNP'],
  'Weckel': ['NNP'],
  'Wedbush': ['NNP'],
  'Wedd': ['NNP'],
  'Wedding': ['NN'],
  'Wedel': ['NNP'],
  'Wedged': ['VBN'],
  'Wedgeworth': ['NNP'],
  'Wedgwood': ['NNP'],
  'Wednesday': ['NNP'],
  'Wednesdays': ['NNS'],
  'Wedtech': ['NNP'],
  'Wee': ['NNP'],
  'Weede': ['NNP'],
  'Weedon': ['NNP'],
  'Weeds': ['NNS'],
  'Week': ['NNP'],
  'Week-e': ['NN'],
  'Week-end': ['NN'],
  'Week-r': ['NN'],
  'Weekend': ['NNP'],
  'Weekes': ['NNP'],
  'Weekly': ['NNP'],
  'Weeks': ['NNP'],
  'Weems': ['NNP'],
  'Weep': ['VB'],
  'Weerasinghe': ['NNP'],
  'Weevil': ['NNP'],
  'Wegener': ['NNP'],
  'Wei': ['NNP'],
  'Weichern': ['NNP'],
  'Weici': ['NNP'],
  'Weickerian': ['JJ'],
  'Weidenfeld': ['NNP'],
  'Weider': ['NNP'],
  'Weidman': ['NNP'],
  'Weigand': ['NNP'],
  'Weigel': ['NNP'],
  'Weighing': ['VBG'],
  'Weight': ['NN'],
  'Weighted': ['NNP'],
  'Weigle': ['NNP'],
  'Weil': ['NNP'],
  'Weiler': ['NNP'],
  'Weill': ['NNP'],
  'Weill\\\'/Bertolt': ['NNP'],
  'Weimar': ['NNP'],
  'Wein': ['NNP'],
  'Weinbach': ['NNP'],
  'Weinberg': ['NNP'],
  'Weinberger': ['NNP'],
  'Weiner': ['NNP'],
  'Weingarten': ['NNP'],
  'Weingarten-Siegel': ['NNP'],
  'Weinroth': ['NNP'],
  'Weinshienk': ['NNP'],
  'Weinstein': ['NNP'],
  'Weir': ['NNP'],
  'Weird': ['JJ'],
  'Weirton': ['NNP'],
  'Weisberg': ['NNP'],
  'Weisbord': ['NNP'],
  'Weisbrod': ['NNP'],
  'Weisel': ['NNP'],
  'Weisfield': ['NNP'],
  'Weisman': ['NNP'],
  'Weisner': ['NNP'],
  'Weiss': ['NNP'],
  'Weissman': ['NNP'],
  'Weissmuller': ['NNP'],
  'Weithas': ['NNP'],
  'Weitz': ['NNP'],
  'Weitzel': ['NNP'],
  'Weitzen': ['NNP'],
  'Weizsacker': ['NNP'],
  'Weizsaecker': ['NNP'],
  'Weksel': ['NNP'],
  'Welborn': ['NNP'],
  'Welby': ['NNP'],
  'Welch': ['NNP'],
  'Welcome': ['NNP'],
  'Weld': ['NNP'],
  'Weldon': ['NNP'],
  'Weldwood': ['NNP'],
  'Welfare': ['NNP'],
  'Welko': ['NNP'],
  'Well': ['UH'],
  'Well-Seasoned': ['JJ'],
  'Well-Tempered': ['JJ'],
  'Well-educated': ['JJ'],
  'Well-intentioned': ['JJ'],
  'Well-received': ['JJ'],
  'Well-stretched': ['JJ'],
  'Well-to-Do': ['JJ'],
  'Well-trained': ['JJ'],
  'Well-wishers': ['NNS'],
  'Welland': ['NNP'],
  'Wellcome': ['NNP'],
  'Weller': ['NNP'],
  'Welles': ['NNP'],
  'Wellesley': ['NNP'],
  'Welling': ['NNP'],
  'Wellington': ['NNP'],
  'Wellman': ['NNP'],
  'Wells': ['NNP'],
  'Wellsley': ['NNP'],
  'Wellsville': ['NNP'],
  'Welmers': ['NNS'],
  'Welsh': ['NNP'],
  'Welt': ['NNP'],
  'Weltanschauung': ['NN'],
  'Welton': ['NNP'],
  'Welty': ['NNP'],
  'Wemmick': ['NNP'],
  'Wempner': ['NNP'],
  'Wenberg': ['NNP'],
  'Wenceslas': ['NNP'],
  'Wendee': ['NNP'],
  'Wendel': ['NNP'],
  'Wendell': ['NNP'],
  'Wendells': ['NNPS'],
  'Wendler': ['NNP'],
  'Wendy': ['NNP'],
  'Wenger': ['NNP'],
  'Wenham': ['NNP'],
  'Went': ['VBD'],
  'Wentworth': ['NNP'],
  'Wenz': ['NNP'],
  'Werdell': ['NNP'],
  'Were': ['VBD'],
  'Wergeland': ['NNP'],
  'Werke': ['NNP'],
  'Werkstell': ['NNP'],
  'Werner': ['NNP'],
  'Wert': ['NNP'],
  'Werter': ['NNP'],
  'Wertheim': ['NNP'],
  'Wertheimer': ['NNP'],
  'Werther': ['NNP'],
  'Wes': ['NNP'],
  'Wesco': ['NNP'],
  'Wesker': ['NNP'],
  'Wesley': ['NNP'],
  'Wesleyan': ['NNP'],
  'Weslock': ['NNP'],
  'Wessel': ['NNP'],
  'Wessels': ['NNP'],
  'Wesson': ['NNP'],
  'West': ['NNP'],
  'West-End': ['NNP'],
  'West-German': ['JJ'],
  'West-Point': ['NNP'],
  'West...': [':'],
  'WestAir': ['NNP'],
  'WestLB': ['NNP'],
  'Westamerica': ['NNP'],
  'Westboro': ['NNP'],
  'Westborough': ['NNP'],
  'Westbound': ['NNP'],
  'Westbrook': ['NNP'],
  'Westburne': ['NNP'],
  'Westchester': ['NNP'],
  'Westcoast': ['NNP'],
  'Westcom': ['NNP'],
  'Westdeutsche': ['NNP'],
  'Westendorf': ['NNP'],
  'Westerly': ['NNP'],
  'Western': ['JJ'],
  'Western-Central': ['JJ'],
  'Western-Mobile': ['NNP'],
  'Western-owned': ['JJ'],
  'Western-style': ['JJ'],
  'Westerner': ['NNP'],
  'Westerners': ['NNPS'],
  'Westerns': ['NNS'],
  'Westfield': ['NNP'],
  'Westford': ['NNP'],
  'Westhampton': ['NNP'],
  'Westheimer': ['NNP'],
  'Westin': ['NNP'],
  'Westinghouse': ['NNP'],
  'Westinghouse-Mitsubishi': ['NNP'],
  'Westlake': ['NNP'],
  'Westland': ['NNP'],
  'Westmin': ['NNP'],
  'Westminister': ['NNP'],
  'Westminster': ['NNP'],
  'Westmore': ['NNP'],
  'Westmoreland': ['NNP'],
  'Weston': ['NNP'],
  'Westpac': ['NNP'],
  'Westphalia': ['NNP'],
  'Westpheldt': ['NNP'],
  'Westport': ['NNP'],
  'Westridge': ['NNP'],
  'Westside': ['NNP'],
  'Westvaco': ['NNP'],
  'Westview': ['NNP'],
  'Westwood': ['NNP'],
  'Wet': ['JJ'],
  'Wetherell': ['NNP'],
  'Wetherill': ['NNP'],
  'Wetten': ['FW'],
  'Wetter': ['NNP'],
  'Wetzel': ['NNP'],
  'Wetzler': ['NNP'],
  'Wexler': ['NNP'],
  'Weybosset': ['NNP'],
  'Weyerhaeuser': ['NNP'],
  'Weyerhauser': ['NNP'],
  'Weymouth': ['NNP'],
  'Wha': ['WP'],
  'Whah': ['WRB'],
  'Whaler': ['NNP'],
  'Whaley': ['NNP'],
  'Wham': ['UH'],
  'Whampoa': ['NNP'],
  'Wharf': ['NNP'],
  'Wharton': ['NNP'],
  'What': ['WP'],
  'What\'s': ['VBZ'],
  'Whatever': ['WDT'],
  'Whatman': ['NNP'],
  'Wheat': ['NNP'],
  'Wheat-germ': ['NN'],
  'Wheatena': ['NNP'],
  'Wheatfield': ['NNP'],
  'Wheaties': ['NNPS'],
  'Wheaties-box': ['JJ'],
  'Wheatley': ['NNP'],
  'Wheaton': ['NNP'],
  'Whee': ['NNP'],
  'Wheel': ['NNP'],
  'Wheelabrator': ['NNP'],
  'Wheelan': ['NNP'],
  'Wheeland': ['NNP'],
  'Wheeler': ['NNP'],
  'Wheeling': ['NNP'],
  'Wheeling-Pittsburgh': ['NNP'],
  'Wheelock': ['NNP'],
  'Wheels': ['NNP'],
  'Whelan': ['NNP'],
  'Whelen': ['NNP'],
  'When': ['WRB'],
  'Whence': ['WRB'],
  'Whenever': ['WRB'],
  'Where': ['WRB'],
  'Where\'s': ['VBZ'],
  'Whereas': ['IN'],
  'Wherefore': ['NN'],
  'Wherever': ['WRB'],
  'Whether': ['IN'],
  'Which': ['WDT'],
  'Whichever': ['WDT'],
  'Whig': ['NN'],
  'Whigs': ['NNPS'],
  'While': ['IN'],
  'Whimsey': ['NNP'],
  'Whinney': ['NNP'],
  'Whip': ['NNP'],
  'Whippet': ['NNP'],
  'Whipple': ['NNP'],
  'Whipsawed': ['JJ'],
  'Whipsnade': ['NNP'],
  'Whirling': ['JJ'],
  'Whirlpool': ['NNP'],
  'Whirlwind': ['NNP'],
  'Whirpool': ['NNP'],
  'Whiskey': ['NNP'],
  'Whisky': ['NN'],
  'Whisper': ['NNP'],
  'Whit': ['NNP'],
  'Whitaker': ['NNP'],
  'Whitbread': ['NNP'],
  'Whitby': ['NNP'],
  'Whitcomb': ['NNP'],
  'White': ['NNP'],
  'White-collar': ['JJ'],
  'White-haired': ['JJ'],
  'White-shirted': ['JJ'],
  'Whiteboard': ['NNP'],
  'Whitefish': ['NNP'],
  'Whiteford': ['NNP'],
  'Whitehall': ['NNP'],
  'Whitehead': ['NNP'],
  'Whitehouse': ['NNP'],
  'Whiteleaf': ['NNP'],
  'Whiteley': ['NNP'],
  'Whitelock': ['NNP'],
  'Whiteman': ['NNP'],
  'Whitemarsh': ['NNP'],
  'Whitey': ['NNP'],
  'Whitfield': ['NNP'],
  'Whitford': ['NNP'],
  'Whiting': ['NNP'],
  'Whitley': ['NNP'],
  'Whitlock': ['NNP'],
  'Whitlow': ['NNP'],
  'Whitman': ['NNP'],
  'Whitmore': ['NNP'],
  'Whitney': ['NNP'],
  'Whitrow': ['NNP'],
  'Whittaker': ['NNP'],
  'Whitten': ['NNP'],
  'Whittenburg': ['NNP'],
  'Whittier': ['NNP'],
  'Whittington': ['NNP'],
  'Whittle': ['NNP'],
  'Whittlesey': ['NNP'],
  'Whiz': ['NNP'],
  'Who': ['WP'],
  'Who\'s': ['VBZ'],
  'Whoa': ['UH'],
  'Whoever': ['WP'],
  'Whole': ['JJ'],
  'Wholesale': ['JJ'],
  'Wholesaler-Distributors': ['NNP'],
  'Wholesalers': ['NNS'],
  'Wholesome': ['JJ'],
  'Whom': ['WP'],
  'Whoopee': ['NN'],
  'Whose': ['WP\$'],
  'Whosever': ['WP'],
  'Whosoever': ['NN'],
  'Why': ['WRB'],
  'Why\'n': ['WRB'],
  'Wichita': ['NNP'],
  'Wichterle': ['NNP'],
  'Wick': ['NNP'],
  'Wickcliffe': ['NNP'],
  'Wicked': ['NNP'],
  'Wickersham': ['NNP'],
  'Wickes': ['NNP'],
  'Wickham': ['NNP'],
  'Wickhams': ['NNP'],
  'Wickliffe': ['NNP'],
  'Wide': ['NNP'],
  'Widely': ['NN'],
  'Widen': ['VB'],
  'Widened': ['VBD'],
  'Widener': ['NNP'],
  'Wider': ['JJR'],
  'Widespread': ['JJ'],
  'Widget': ['NNP'],
  'Widmark': ['NNP'],
  'Widow': ['NN'],
  'Widowers': ['NNS'],
  'Widsith': ['NNP'],
  'Widuri': ['NNP'],
  'Wiedemann': ['NNP'],
  'Wieden': ['NNP'],
  'Wiederaufbau': ['NNP'],
  'Wiegers': ['NNP'],
  'Wieland': ['NNP'],
  'Wiener': ['NNP'],
  'Wierton': ['NNP'],
  'Wiesbaden': ['NNP'],
  'Wiesel': ['NNP'],
  'Wiesenthal': ['NNP'],
  'Wieslawa': ['NNP'],
  'Wiess': ['NNP'],
  'Wife': ['NN'],
  'Wiggins': ['NNP'],
  'Wigglesworth': ['NNP'],
  'Wight': ['NNP'],
  'Wigs': ['NNS'],
  'Wilber': ['NNP'],
  'Wilberforce': ['NNP'],
  'Wilbur': ['NNP'],
  'Wilcher': ['NNP'],
  'Wilcke': ['NNP'],
  'Wilcock': ['NNP'],
  'Wilcox': ['NNP'],
  'Wild': ['NNP'],
  'Wildbad': ['NNP'],
  'Wildcat': ['NNP'],
  'Wilde': ['NNP'],
  'Wildenstein': ['NNP'],
  'Wilder': ['NNP'],
  'Wilderness': ['NN'],
  'Wildhack': ['NNP'],
  'Wildlife': ['NNP'],
  'Wildly': ['RB'],
  'Wildman': ['NNP'],
  'Wildwater': ['NNP'],
  'Wildwood': ['NNP'],
  'Wile': ['NNP'],
  'Wiley': ['NNP'],
  'Wilfred': ['NNP'],
  'Wilfrid': ['NNP'],
  'Wilhelm': ['NNP'],
  'Wilhelmina': ['NNP'],
  'Wilhite': ['NNP'],
  'Wiligis': ['NNP'],
  'Wilk': ['NNP'],
  'Wilke': ['NNP'],
  'Wilkes': ['VBZ'],
  'Wilkes-Barre': ['NNP'],
  'Wilkey': ['NNP'],
  'Wilkins': ['NNP'],
  'Wilkinson': ['NNP'],
  'Wilks': ['NNP'],
  'Will': ['MD'],
  'Willa': ['NNP'],
  'Willam': ['NNP'],
  'Willamette': ['NNP'],
  'Willard': ['NNP'],
  'Willcox': ['NNP'],
  'Willem': ['NNP'],
  'Willens': ['NNP'],
  'Willenson': ['NNP'],
  'Willett': ['NNP'],
  'Willetts': ['NNP'],
  'William': ['NNP'],
  'Williams': ['NNP'],
  'Williamsburg': ['NNP'],
  'Williamsesque': ['JJ'],
  'Williamson': ['NNP'],
  'Williamstown': ['NNP'],
  'Willie': ['NNP'],
  'Willing': ['JJ'],
  'Willingness': ['NN'],
  'Willings': ['NNP'],
  'Willis': ['NNP'],
  'Willkie': ['NNP'],
  'Willman': ['NNP'],
  'Willmott': ['NNP'],
  'Willoughby': ['NNP'],
  'Willow': ['NNP'],
  'Willowbridge': ['NNP'],
  'Willows': ['NNS'],
  'Wills': ['NNP'],
  'Willson': ['NNP'],
  'Willy': ['NNP'],
  'Wilm': ['NNP'],
  'Wilma': ['NNP'],
  'Wilmer': ['NNP'],
  'Wilmette': ['NNP'],
  'Wilmington': ['NNP'],
  'Wilmot': ['NNP'],
  'Wilmouth': ['NNP'],
  'Wilms': ['NNP'],
  'Wilpers': ['NNP'],
  'Wilshire': ['NNP'],
  'Wilson': ['NNP'],
  'Wilson-to-Jim': ['JJ'],
  'Wilsonian': ['JJ'],
  'Wilton': ['NNP'],
  'Wimbledon': ['NNP'],
  'Wimpy': ['NNP'],
  'Wimpys': ['NNP'],
  'Wimsatt': ['NNP'],
  'Win': ['NNP'],
  'Winawer': ['NNP'],
  'Winch': ['NNP'],
  'Winchell': ['NNP'],
  'Winchester': ['NNP'],
  'Wind': ['NNP'],
  'Windahall': ['NNP'],
  'Windels': ['NNP'],
  'Windex': ['NNP'],
  'Windfall': ['NN'],
  'Windflower': ['NNP'],
  'Windham': ['NNP'],
  'Windheim': ['NNP'],
  'Windhoek': ['NNP'],
  'Windle': ['NNP'],
  'Windmere': ['NNP'],
  'Window': ['NN'],
  'Windows': ['NNP'],
  'Winds': ['NNP'],
  'Windsor': ['NNP'],
  'Windy': ['NNP'],
  'Wine': ['NNP'],
  'Winery': ['NNP'],
  'Wines': ['NNP'],
  'Winfield': ['NNP'],
  'Winfrey': ['NNP'],
  'Wing': ['NNP'],
  'Wingback': ['NNP'],
  'Winger': ['NNP'],
  'Wingman': ['NN'],
  'Wings': ['NNPS'],
  'Winiarski': ['NNP'],
  'Wink': ['NNP'],
  'Winking': ['VBG'],
  'Winkler': ['NNP'],
  'Winn': ['NNP'],
  'Winn-Dixie': ['NNP'],
  'Winnebago': ['NNP'],
  'Winner': ['NNP'],
  'Winners': ['NNS'],
  'Winnetka': ['NNP'],
  'Winnick': ['NNP'],
  'Winnie': ['NNP'],
  'Winning': ['VBG'],
  'Winnipeg': ['NNP'],
  'Winnipesaukee': ['NNP'],
  'Winooski': ['NNP'],
  'Winsett': ['NNP'],
  'Winslow': ['NNP'],
  'Winsor': ['NNP'],
  'Winston': ['NNP'],
  'Winston-Salem': ['NNP'],
  'Winter': ['NNP'],
  'Winterhalder': ['NNP'],
  'Winters': ['NNP'],
  'Winterthur-based': ['JJ'],
  'Winthrop': ['NNP'],
  'Winthrop-University': ['NNP'],
  'Winton': ['NNP'],
  'Wintour': ['NNP'],
  'Winzer': ['NNP'],
  'Wipe': ['VB'],
  'Wire': ['NNP'],
  'Wireless': ['NNP'],
  'Wires': ['NNS'],
  'Wirth': ['NNP'],
  'Wirthlin': ['NNP'],
  'Wirtz': ['NNP'],
  'Wiry': ['JJ'],
  'Wis': ['NNP'],
  'Wis.': ['NNP'],
  'Wis.-based': ['JJ'],
  'Wisconsin': ['NNP'],
  'Wisdom': ['NNP'],
  'Wise': ['NNP'],
  'Wised': ['NNP'],
  'Wiseguy': ['NNP'],
  'Wisely': ['RB'],
  'Wiseman': ['NNP'],
  'Wish': ['VB'],
  'Wish-List': ['NN'],
  'Wishart': ['NNP'],
  'Wishes': ['NNS'],
  'Wishing': ['VBG'],
  'Wisman': ['NNP'],
  'Wisner': ['NNP'],
  'Wissahickon': ['NNP'],
  'Wister': ['NNP'],
  'Witcher': ['NNP'],
  'With': ['IN'],
  'Withdrawals': ['NNS'],
  'Witherspoon': ['NNP'],
  'Withhold': ['VB'],
  'Withholding': ['NN'],
  'Within': ['IN'],
  'Without': ['IN'],
  'Withrow': ['NNP'],
  'Withuhn': ['NNP'],
  'Witkin': ['NNP'],
  'Witman': ['NNP'],
  'Witness': ['VB'],
  'Witnesses': ['NNS'],
  'Witnessing': ['VBG'],
  'Witold': ['NNP'],
  'Witt': ['NNP'],
  'Witten': ['NNP'],
  'Wittenberg': ['NNP'],
  'Witter': ['NNP'],
  'Wittgreen': ['NNP'],
  'Wives': ['NNPS'],
  'Wixom': ['NNP'],
  'Wizard': ['NNP'],
  'Wizards': ['NNPS'],
  'Wm.': ['NNP'],
  'Wo': ['MD'],
  'Woburn': ['NNP'],
  'Wockenfuss': ['NNP'],
  'Woe': ['NN'],
  'Woessner': ['NNP'],
  'Wogan': ['NNP'],
  'Wohlstetter': ['NNP'],
  'Wolcott': ['NNP'],
  'Wolcyrz': ['NNP'],
  'Wolder': ['NNP'],
  'Wolf': ['NNP'],
  'Wolfe': ['NNP'],
  'Wolfes': ['NNPS'],
  'Wolff': ['NNP'],
  'Wolfgang': ['NNP'],
  'Wolfsburg': ['NNP'],
  'Wolfson': ['NNP'],
  'Wolkind': ['NNP'],
  'Wollaeger': ['NNP'],
  'Wollman': ['NNP'],
  'Wollo': ['NNP'],
  'Wolohan': ['NNP'],
  'Wolpe': ['NNP'],
  'Wolstenholme': ['NNP'],
  'Wolters-Kluwer': ['NNP'],
  'Wolverine': ['NNP'],
  'Wolverton': ['NNP'],
  'Wolzein': ['NNP'],
  'Womack': ['NNP'],
  'Woman': ['NNP'],
  'Woman\\\'/McCall': ['NNP'],
  'Women': ['NNP'],
  'Won': ['NNP'],
  'Wonda': ['NNP'],
  'Wonder': ['NNP'],
  'Wonderful': ['JJ'],
  'Wondering': ['VBG'],
  'Wonderland': ['NNP'],
  'Wong': ['NNP'],
  'Wonham': ['NNP'],
  'Wonjerika': ['NNP'],
  'Woo': ['NNP'],
  'Wood': ['NNP'],
  'Wood-products': ['NNS'],
  'WoodMac': ['NNP'],
  'Woodberry': ['NNP'],
  'Woodbridge': ['NNP'],
  'Woodbury': ['NNP'],
  'Woodcliff': ['NNP'],
  'Woodcock': ['NNP'],
  'Wooded': ['JJ'],
  'Wooden': ['JJ'],
  'Woodhaven': ['NNP'],
  'Woodin': ['NNP'],
  'Woodland': ['NNP'],
  'Woodmac': ['NNP'],
  'Woodman': ['NNP'],
  'Woodrow': ['NNP'],
  'Woodruff': ['NNP'],
  'Woods': ['NNP'],
  'Woodside': ['NNP'],
  'Woodstream': ['NNP'],
  'Woodward': ['NNP'],
  'Woodwards': ['NNP'],
  'Woodwell': ['NNP'],
  'Woodworth': ['NNP'],
  'Woody': ['NNP'],
  'Woodyard': ['NNP'],
  'Woolard': ['NNP'],
  'Woolen': ['NNP'],
  'Woollcott': ['NNP'],
  'Woolsey': ['NNP'],
  'Woolworth': ['NNP'],
  'Woonasquatucket': ['NNP'],
  'Woong': ['NNP'],
  'Woonsocket': ['NNP'],
  'Woos': ['VBZ'],
  'Wooten': ['NNP'],
  'Wootton': ['NNP'],
  'Worcester': ['NNP'],
  'Worcestershire': ['JJ'],
  'Word': ['NNP'],
  'WordStar': ['NNP'],
  'Words': ['NNS'],
  'Wordsworth': ['NNP'],
  'Work': ['NN'],
  'Work-outs': ['NNS'],
  'Worker': ['NNP'],
  'Workers': ['NNPS'],
  'Workforce': ['NNP'],
  'Working': ['NNP'],
  'Workmen': ['NNS'],
  'Workplace': ['NN'],
  'Workplaces': ['NNS'],
  'Works': ['NNP'],
  'Worksheets': ['NNS'],
  'Workshop': ['NNP'],
  'Workshops': ['NNS'],
  'Workstations': ['NNS'],
  'World': ['NNP'],
  'World\'s': ['NNS'],
  'World-Journal-Tribune': ['NNP'],
  'World-Telegram': ['NNP'],
  'World-Wide': ['NNP'],
  'World-wide': ['JJ'],
  'Worlders': ['NNPS'],
  'Worldly': ['RB'],
  'Worlds': ['NNPS'],
  'Worldscope': ['NNP'],
  'Worldwatch': ['NNP'],
  'Worldwide': ['NNP'],
  'Worms': ['NNPS'],
  'Worn': ['VBN'],
  'Woronoff': ['NNP'],
  'Worrell': ['NNP'],
  'Worried': ['VBN'],
  'Worriers': ['NNS'],
  'Worries': ['NNS'],
  'Worry': ['NN'],
  'Worse': ['JJR'],
  'Worship': ['NNP'],
  'Worst': ['JJS'],
  'Worth': ['NNP'],
  'Worth-based': ['JJ'],
  'Wortham': ['NNP'],
  'Worthington': ['NNP'],
  'Worthless': ['JJ'],
  'Worthy': ['NNP'],
  'Would': ['MD'],
  'Would-be': ['JJ'],
  'Wound-tumor': ['NN'],
  'Woven': ['VBN'],
  'Wow': ['UH'],
  'Wozniak': ['NNP'],
  'Wozzek': ['NNP'],
  'Wragge': ['NNP'],
  'Wrangham': ['NNP'],
  'Wrangle': ['VB'],
  'Wrangler': ['NNP'],
  'Wrangling': ['VBG'],
  'Wrap': ['NNP'],
  'Wrath': ['NN'],
  'Wratten': ['NNP'],
  'Wray': ['NNP'],
  'Wreckage': ['NN'],
  'Wrecking': ['NN'],
  'Wrecks': ['VBZ'],
  'Wrestlemania': ['NNP'],
  'Wright': ['NNP'],
  'Wright-style': ['JJ'],
  'Wrighting': ['NN'],
  'Wrightson': ['NNP'],
  'Wrigley': ['NNP'],
  'Wrist': ['NN'],
  'Write': ['VB'],
  'Write-offs': ['NNS'],
  'Writer': ['NNP'],
  'Writers': ['NNP'],
  'Writes': ['NNP'],
  'Writing': ['VBG'],
  'Written': ['VBN'],
  'Wrong': ['JJ'],
  'Wrongdoers': ['NNS'],
  'Wrongs': ['NNS'],
  'Wrote': ['VBD'],
  'Wu': ['NNP'],
  'Wuer': ['NNP'],
  'Wunderman': ['NNP'],
  'Wuon': ['NNP'],
  'Wurm': ['NNP'],
  'Wurtzel': ['NNP'],
  'Wussler': ['NNP'],
  'Wustman': ['NNP'],
  'Wyatt': ['NNP'],
  'Wyche': ['NNP'],
  'Wyckoff': ['NNP'],
  'Wycliffe': ['NNP'],
  'Wycoff': ['NNP'],
  'Wycombe': ['NNP'],
  'Wyden': ['NNP'],
  'Wyeth': ['NNP'],
  'Wyeth-Ayerst': ['NNP'],
  'Wylie': ['NNP'],
  'Wyly': ['NNP'],
  'Wyman': ['NNP'],
  'Wyn': ['NNP'],
  'Wyndham': ['NNP'],
  'Wynn': ['NNP'],
  'Wynston': ['NNP'],
  'Wyo': ['NNP'],
  'Wyo.': ['NNP'],
  'Wyoming': ['NNP'],
  'Wyse': ['NNP'],
  'Wyser-Pratte': ['NNP'],
  'Wyss': ['NNP'],
  'Wyvern': ['NNP'],
  'X': ['NN'],
  'X-MP': ['NNP'],
  'X-Tru-Coat': ['NNP'],
  'X-chromosome': ['NN'],
  'X-gyro': ['NN'],
  'X-linked': ['JJ'],
  'X-marked': ['JJ'],
  'X-rated': ['JJ'],
  'X-ray': ['NN'],
  'X-ray-proof': ['JJ'],
  'X-rayed': ['VBN'],
  'X-rays': ['NNS'],
  'X-region': ['NN'],
  'X-tend': ['NN'],
  'X.': ['NNP'],
  'XA2000': ['NNP'],
  'XCEL': ['NNP'],
  'XD': ['SYM'],
  'XFI': ['NNP'],
  'XIII': ['NNP'],
  'XJ6': ['NNP'],
  'XL': ['NNP'],
  'XL\\\'/Datacomp': ['NNP'],
  'XR-7': ['NNP'],
  'XR4Ti': ['NNP'],
  'XRAL': ['NNP'],
  'XRELEASE': ['NN'],
  'XRESERVE': ['NN'],
  'XYLOGICS': ['NNP'],
  'XYVISION': ['NNP'],
  'Xanadu': ['NNP'],
  'Xanax': ['NNP'],
  'Xavier': ['NNP'],
  'Xenia': ['NNP'],
  'Xerox': ['NNP'],
  'Xia': ['NNP'],
  'Xiang': ['NNP'],
  'Xiangyang': ['NNP'],
  'Xiao': ['NNP'],
  'Xiaobo': ['NNP'],
  'Xiaoping': ['NNP'],
  'Xiaoqing': ['NNP'],
  'Xidex': ['NNP'],
  'Ximenez-Vargas': ['NNP'],
  'Xinhua': ['NNP'],
  'Xoma': ['NNP'],
  'Xomen-E5': ['NNP'],
  'Xtra': ['NNP'],
  'Xu': ['NNP'],
  'Xuanping': ['NNP'],
  'Xydis': ['NNP'],
  'Xylogics': ['NNP'],
  'Xyvision': ['NNP'],
  'Y': ['NNP'],
  'Y&R': ['NNP'],
  'Y\'all': ['DT'],
  'Y\'r': ['PRP', 'VBP'],
  'Y-MP': ['NNP'],
  'Y-MP8-232': ['NNP'],
  'Y-MP\\\'/832': ['NNP'],
  'Y-Teen': ['NNP'],
  'Y-cell': ['NN'],
  'Y-cells': ['NNS'],
  'Y-gyro': ['NN'],
  'Y-region': ['NN'],
  'Y-regions': ['NNS'],
  'Y.': ['NNP'],
  'Y.J.': ['NNP'],
  'Y.M.C.A.': ['NNP'],
  'Y.M.H.A.': ['NNP'],
  'Y.S.': ['NNP'],
  'Y.W.C.A.': ['NNP'],
  'YALE': ['NNP'],
  'YEARS': ['NNS'],
  'YEEECH': ['UH'],
  'YEEEEEECH': ['UH'],
  'YES': ['NNP'],
  'YMCA': ['NNP'],
  'YO': ['UH'],
  'YOM': ['NNP'],
  'YORK': ['NNP'],
  'YORK\'S': ['NNP'],
  'YOU': ['PRP'],
  'YOU\'RE': ['PRP'],
  'YOUNG': ['JJ'],
  'YOUR': ['JJ'],
  'YUP': ['UH'],
  'YWCA': ['NNP'],
  'Yaaba': ['NNP'],
  'Yacht': ['NNP'],
  'Yachtel': ['NN'],
  'Yachtsman': ['NNP'],
  'Yacos': ['NNP'],
  'Yaddo': ['NNP'],
  'Yaffe': ['NNP'],
  'Yahoo': ['NNP'],
  'Yahwe': ['NNP'],
  'Yair': ['NNP'],
  'Yak': ['NNP'],
  'Yakima': ['NNP'],
  'Yakkety': ['NNP'],
  'Yaklin': ['NNP'],
  'Yakov': ['NNP'],
  'Yakovlevich': ['NNP'],
  'Yalagaloo': ['UH'],
  'Yale': ['NNP'],
  'Yale-Army': ['NNP'],
  'Yale-New': ['NNP'],
  'Yalies': ['NNS'],
  'Yall': ['PRP'],
  'Yalobusha': ['NNP'],
  'Yalta': ['NNP'],
  'Yamabe': ['NNP'],
  'Yamada': ['NNP'],
  'Yamaguchi': ['NNP'],
  'Yamaichi': ['NNP'],
  'Yamamoto': ['NNP'],
  'Yamane': ['NNP'],
  'Yamanouchi': ['NNP'],
  'Yamashita': ['NNP'],
  'Yamata': ['NNP'],
  'Yamatake': ['NNP'],
  'Yamatake-Honeywell': ['NNP'],
  'Yamatane': ['NNP'],
  'Yan': ['NNP'],
  'Yancey-6': ['NN'],
  'Yancy-6': ['NN'],
  'Yanes': ['NNP'],
  'Yang': ['NNP'],
  'Yaniv': ['NNP'],
  'Yank': ['NN'],
  'Yank-oriented': ['JJ'],
  'Yankee': ['NNP'],
  'Yankee-come-lately': ['JJ'],
  'Yankee-hatred': ['NN'],
  'Yankeefication': ['NNP'],
  'Yankees': ['NNP'],
  'Yankees-Brooklyn': ['NNP'],
  'Yankees-Mets': ['JJ'],
  'Yankelovich': ['NNP'],
  'Yanks': ['NNS'],
  'Yankton': ['NNP'],
  'Yankus': ['NNP'],
  'Yao': ['NNP'],
  'Yaobang': ['NNP'],
  'Yaohan': ['NNP'],
  'Yaqui': ['NNP'],
  'Yarchoan': ['NNP'],
  'Yard': ['NNP'],
  'Yardeni': ['NNP'],
  'Yards': ['NNP'],
  'Yardumian': ['NNP'],
  'Yarnell': ['NNP'],
  'Yarrow': ['NNP'],
  'Yass': ['NNP'],
  'Yasser': ['NNP'],
  'Yastrow': ['NNP'],
  'Yastrzemski': ['NNP'],
  'Yasuda': ['NNP'],
  'Yasumichi': ['NNP'],
  'Yasuo': ['NNP'],
  'Yasushige': ['NNP'],
  'Yasutomi': ['NNP'],
  'Yates': ['NNP'],
  'Yavapai': ['NNP'],
  'Yazov': ['NNP'],
  'Ye': ['NNP'],
  'Yea': ['UH'],
  'Yeager': ['NNP'],
  'Yeah': ['UH'],
  'Year': ['NN'],
  'Year-End': ['JJ'],
  'Year-ago': ['JJ'],
  'Year-earlier': ['JJ'],
  'Year-round': ['RB'],
  'Year-to-date': ['JJ'],
  'Yearbook': ['NNP'],
  'Yeargin': ['NNP'],
  'Yearly': ['NNP'],
  'Years': ['NNS'],
  'Yeast': ['NN'],
  'Yeats': ['NNP'],
  'Yedisan': ['NNP'],
  'Yegor': ['NNP'],
  'Yeh': ['NNP'],
  'Yehhh': ['UH'],
  'Yehuda': ['NNP'],
  'Yehudi': ['NNP'],
  'Yell': ['NNP'],
  'Yellen': ['NNP'],
  'Yeller': ['JJ'],
  'Yellow': ['NNP'],
  'Yellow-pages': ['NN'],
  'Yellowknife': ['NNP'],
  'Yemelyanenko': ['NNP'],
  'Yemen': ['NNP'],
  'Yemeni': ['JJ'],
  'Yemenis': ['NNPS'],
  'Yemens': ['NNPS'],
  'Yemma': ['NNP'],
  'Yen': ['NNP'],
  'Yenakiyevo': ['NNP'],
  'Yeni': ['NNP'],
  'Yeres': ['NNP'],
  'Yerevan': ['NNP'],
  'Yes': ['UH'],
  'Yesiree': ['UH'],
  'Yesterday': ['NN'],
  'Yet': ['RB'],
  'Yetnikoff': ['NNP'],
  'Yeung': ['NNP'],
  'Yeutter': ['NNP'],
  'Yevgeny': ['NNP'],
  'Yew': ['NNP'],
  'Yewaisis': ['NNP'],
  'Yff': ['IN'],
  'Yiddish': ['NNP'],
  'Yield': ['NNP'],
  'Yields': ['NNS'],
  'Yigal': ['NNP'],
  'Yilin': ['NNP'],
  'Yin': ['NNP'],
  'Yin-Yang': ['NNP'],
  'Ying-shek': ['NNP'],
  'Yinger': ['NNP'],
  'Yippies': ['NNPS'],
  'Yiren': ['NNP'],
  'Yitzhak': ['NNP'],
  'Yizi': ['NNP'],
  'Yo': ['NNP'],
  'Yocam': ['NNP'],
  'Yocum': ['NNP'],
  'Yoder': ['NNP'],
  'Yogi': ['NNP'],
  'Yoichi': ['NNP'],
  'Yok.': ['NNP'],
  'Yokel': ['NNP'],
  'Yokich': ['NNP'],
  'Yoknapatawpha': ['NNP'],
  'Yokogawa': ['NNP'],
  'Yokohama': ['NNP'],
  'Yokosuka': ['NNP'],
  'Yokum': ['NNP'],
  'Yokuts': ['NNP'],
  'Yom': ['NNP'],
  'Yoneda': ['NNP'],
  'Yonehara': ['NNP'],
  'Yoneyama': ['NNP'],
  'Yongjian': ['NNP'],
  'Yonkers': ['NNP'],
  'Yontz': ['NNP'],
  'Yooee': ['UH'],
  'Yoon': ['NNP'],
  'Yoorick': ['NNP'],
  'Yoran': ['NNP'],
  'Yorba': ['NNP'],
  'York': ['NNP'],
  'York-Moscow': ['NNP'],
  'York-Pennsylvania': ['NNP'],
  'York-SF': ['NNP'],
  'York-area': ['JJ'],
  'York-based': ['JJ'],
  'York-born': ['NNP', 'VBN'],
  'York-mind': ['NNP', 'NN'],
  'Yorker': ['NNP'],
  'Yorkers': ['NNPS'],
  'Yorkshire': ['NNP'],
  'Yorkshire-based': ['JJ'],
  'Yorktown': ['NNP'],
  'Yosemite': ['NNP'],
  'Yoshi': ['NNP'],
  'Yoshiaki': ['NNP'],
  'Yoshida': ['NNP'],
  'Yoshiharu': ['NNP'],
  'Yoshihashi': ['NNP'],
  'Yoshihisa': ['NNP'],
  'Yoshimoto': ['NNP'],
  'Yoshio': ['NNP'],
  'Yoshiro': ['NNP'],
  'Yoshitoki': ['NNP'],
  'Yoshiyuki': ['NNP'],
  'Yoshizawa': ['NNP'],
  'Yosi': ['NNP'],
  'Yost': ['NNP'],
  'You': ['PRP'],
  'You\'re': ['VBP'],
  'You\'ve': ['NN'],
  'YouTube': ['NNP'],
  'Young': ['NNP'],
  'Young-Jin': ['NNP'],
  'Youngberg': ['NNP'],
  'Youngblood': ['NNP'],
  'Younger': ['JJR'],
  'Youngest': ['JJS'],
  'Youngish': ['JJ'],
  'Youngsters': ['NNS'],
  'Youngstown': ['NNP'],
  'Younis': ['NNP'],
  'Younkers': ['NNP'],
  'Your': ['PRP\$'],
  'Yours': ['PRP'],
  'Youth': ['NNP'],
  'Youths': ['NNP'],
  'Yquem': ['NNP'],
  'Yr': ['NN'],
  'Yu': ['NNP'],
  'Yuan': ['NNP'],
  'Yuba': ['NNP'],
  'Yucaipa': ['NNP'],
  'Yucatan': ['NNP'],
  'Yuen': ['NNP'],
  'Yugolsavia': ['NNP'],
  'Yugoslav': ['NNP'],
  'Yugoslav-born': ['JJ'],
  'Yugoslavia': ['NNP'],
  'Yugoslavs': ['NNS'],
  'Yujobo': ['NNP'],
  'Yuk-sui': ['NNP'],
  'Yuki': ['NNP'],
  'Yukihiro': ['NNP'],
  'Yukio': ['NNP'],
  'Yuko': ['NNP'],
  'Yukon': ['NNP'],
  'Yuli': ['NNP'],
  'Yum-Yum': ['NNP'],
  'Yumiko': ['NNP'],
  'Yun': ['NNP'],
  'Yunian': ['NNP'],
  'Yup': ['UH'],
  'Yuppie': ['NNP'],
  'Yuppies': ['NNS'],
  'Yuppily': ['RB'],
  'Yurek': ['NNP'],
  'Yuri': ['NNP'],
  'Yurochka': ['NNP'],
  'Yusaku': ['NNP'],
  'Yusen': ['NNP'],
  'Yutaka': ['NNP'],
  'Yuzek': ['NNP'],
  'Yuzuru': ['NNP'],
  'Yves': ['NNP'],
  'Yvette': ['NNP'],
  'Yvon': ['NNP'],
  'Z': ['NNP'],
  'Z-axis': ['NN'],
  'Z-gyro': ['NN'],
  'Z.': ['NNP'],
  'ZBB': ['NNP'],
  'ZDF': ['NNP'],
  'ZENITH': ['NNP'],
  'ZZZZ': ['NNP'],
  'Zabel': ['NNP'],
  'Zach': ['NNP'],
  'Zacharias': ['NNP'],
  'Zachau': ['NNP'],
  'Zachrisson': ['NNP'],
  'Zack': ['NNP'],
  'Zacks': ['NNP'],
  'Zadel': ['NNP'],
  'Zaffarano': ['NNP'],
  'Zaffius': ['NNP'],
  'Zaffuto': ['NNP'],
  'Zafris': ['NNP'],
  'Zagaria': ['NNP'],
  'Zagros': ['NNP'],
  'Zaharah': ['NNP'],
  'Zainuddin': ['NNP'],
  'Zaire': ['NNP'],
  'Zairean': ['JJ'],
  'Zaishuo': ['NNP'],
  'Zaita': ['NNP'],
  'Zajick': ['NNP'],
  'Zakes': ['NNP'],
  'Zalles': ['NNP'],
  'Zalubice': ['NNP'],
  'Zama': ['NNP'],
  'Zambia': ['NNP'],
  'Zambian': ['JJ'],
  'Zambon': ['NNP'],
  'Zambrano': ['NNP'],
  'Zamiatin': ['NNP'],
  'Zamislov': ['NNP'],
  'Zamora': ['NNP'],
  'Zamya': ['NNP'],
  'Zane': ['NNP'],
  'Zantac': ['NNP'],
  'Zanzibar': ['JJ'],
  'Zapala': ['NNP'],
  'Zapata': ['NNP'],
  'Zapfel': ['NNP'],
  'Zaporogian': ['NNP'],
  'Zapotec': ['JJ'],
  'Zappa': ['NNP'],
  'Zara': ['NNP'],
  'Zarett': ['NNP'],
  'Zarnowitz': ['NNP'],
  'Zaroubin': ['NNP'],
  'Zaves': ['NNP'],
  'Zawia': ['NNP'],
  'Zayadi': ['NNP'],
  'Zayed': ['NNP'],
  'Zayre': ['NNP'],
  'Zbigniew': ['NNP'],
  'Zeal': ['NNP'],
  'Zealand': ['NNP'],
  'Zealand-based': ['JJ'],
  'Zealand-dollar': ['NN'],
  'Zealander': ['NNP'],
  'Zebek': ['NNP'],
  'Zedmark': ['NNP'],
  'Zeffirelli': ['NNP'],
  'Zehnder': ['NNP'],
  'Zeidner': ['NNP'],
  'Zeien': ['NNP'],
  'Zeiger': ['NNP'],
  'Zeising': ['NNP'],
  'Zeisler': ['NNP'],
  'Zeiss': ['NNP'],
  'Zeitgeist': ['NNP'],
  'Zeitung': ['NNP'],
  'Zeke': ['NNP'],
  'Zel': ['NNP'],
  'Zela': ['NNP'],
  'Zelda': ['NNP'],
  'Zelig': ['NNP'],
  'Zell': ['NNP'],
  'Zeller': ['NNP'],
  'Zellerbach': ['NNP'],
  'Zellers': ['NNP'],
  'Zeme': ['NNP'],
  'Zemin': ['NNP'],
  'Zemlinsky': ['NNP'],
  'Zemlya': ['NNP'],
  'Zen': ['NNP'],
  'Zen-like': ['JJ'],
  'Zenaida': ['NNP'],
  'Zend-Avesta': ['NNP'],
  'Zendo': ['NNP'],
  'Zenith': ['NNP'],
  'Zennist': ['NN'],
  'Zeon': ['NNP'],
  'Zermatt': ['NNP'],
  'Zero': ['NN'],
  'Zero-Based': ['NNP'],
  'Zero-coupon': ['JJ'],
  'Zeron': ['NNP'],
  'Zeros': ['NNS'],
  'Zeta': ['NNP'],
  'Zey': ['PRP'],
  'Zhang': ['NNP'],
  'Zhao': ['NNP'],
  'Zhaoxing': ['NNP'],
  'Zhejiang': ['NNP'],
  'Zhijie': ['NNP'],
  'Zhitkov': ['NNP'],
  'Zhitzhakli': ['NNP'],
  'Zhok': ['NNP'],
  'Zhong': ['NNP'],
  'Zhongshan': ['NNP'],
  'Zhu': ['NNP'],
  'Zia': ['NNP'],
  'Ziari': ['NNP'],
  'Zicklin': ['NNP'],
  'Ziebarth': ['NNP'],
  'Ziegfeld': ['NNP'],
  'Ziegler': ['NNP'],
  'Zielinski': ['NNP'],
  'Ziff': ['NNP'],
  'Ziff-Davis': ['NNP'],
  'Ziffren': ['NNP'],
  'Zigarlick': ['NNP'],
  'Ziggy': ['NNP'],
  'Zilligen': ['NNP'],
  'Zimbabwe': ['NNP'],
  'Zimbabwean': ['NNP'],
  'Zimbalist': ['NNP'],
  'Zimet': ['NNP'],
  'Ziminska-Sygietynska': ['NNP'],
  'Zimmer': ['NNP'],
  'Zimmerman': ['NNP'],
  'Zinc': ['NN'],
  'Zing': ['NNP'],
  'Zingggg-O': ['UH'],
  'Zink': ['NNP'],
  'Zinman': ['NNP'],
  'Zinser': ['NNP'],
  'Zion': ['NNP'],
  'Zionism': ['NNP'],
  'Zionist': ['JJ'],
  'Zionists': ['NNPS'],
  'Zipper': ['NNP'],
  'Zipperstein': ['NNP'],
  'Zipser': ['NNP'],
  'Ziraldo': ['NNP'],
  'Zirbel': ['NNP'],
  'Zita': ['NNP'],
  'Zitin': ['NNP'],
  'Zivley': ['NNP'],
  'Ziyang': ['NNP'],
  'Znaniye': ['NNP'],
  'Zodiacal': ['JJ'],
  'Zoe': ['NNP'],
  'Zoeller': ['NNP'],
  'Zoellick': ['NNP'],
  'Zoete': ['NNP'],
  'Zoghby': ['NNP'],
  'Zola': ['NNP'],
  'Zoladex': ['NNP'],
  'Zollinger-Ellison': ['NNP'],
  'Zolo': ['NNP'],
  'Zomax': ['NNP'],
  'Zombie': ['NNP'],
  'Zone': ['NNP'],
  'Zones': ['NNS'],
  'Zoning': ['NNP'],
  'Zoo': ['NNP'],
  'Zooey': ['NNP'],
  'Zorn': ['NNP'],
  'Zorro': ['NNP'],
  'Zosen': ['NNP'],
  'Zsa': ['NNP'],
  'Zubin': ['NNP'],
  'Zubkovskaya': ['NNP'],
  'Zucker': ['NNP'],
  'Zuckerman': ['NNP'],
  'Zuercher': ['NNP'],
  'Zug': ['NNP'],
  'Zukin': ['NNP'],
  'Zulu': ['NNP'],
  'Zumbrunn': ['NNP'],
  'Zuni': ['NNP'],
  'Zupan': ['NNP'],
  'Zur': ['FW'],
  'Zuratas': ['NNP'],
  'Zurcher': ['NNP'],
  'Zurek': ['NNP'],
  'Zurich': ['NNP'],
  'Zurich-based': ['JJ'],
  'Zurkuhlen': ['NNP'],
  'Zurn': ['NNP'],
  'Zvi': ['NNP'],
  'Zwei': ['NNP'],
  'Zweibel': ['NNP'],
  'Zweig': ['NNP'],
  'Zwelakhe': ['NNP'],
  'Zwiren': ['NNP'],
  'Zworykin': ['NNP'],
  'Zycher': ['NNP'],
  'Zygmunt': ['NNP'],
  '[': ['('],
  '\\\'*': ['SYM'],
  '\\\'*\\\'*': ['SYM'],
  '\\\'*\\\'*\\\'*': ['SYM'],
  ']': [')'],
  ']*': ['NN'],
  ']:': ['SYM'],
  '^_^': ['SYM'],
  '`': ['``'],
  '``': ['``'],
  '``...': [':'],
  '```': ['NN'],
  'a': ['DT'],
  'a\'back-to-basics': ['JJ'],
  'a\'break-up': ['NN'],
  'a\'junk-junk': ['JJ'],
  'a\'mea': ['FW'],
  'a\'muddle': ['VB'],
  'a\'show': ['VB'],
  'a\'skip-a-month': ['JJ'],
  'a\'to-whom-er': ['NN'],
  'a-Average': ['JJ'],
  'a-Discounted': ['JJ'],
  'a-Ex-dividend': ['NN'],
  'a-GM': ['NNP'],
  'a-Includes': ['VBZ'],
  'a-Monthly': ['JJ'],
  'a-Totals': ['NNS'],
  'a-coming': ['VBG'],
  'a-crowing': ['VBG'],
  'a-drinking': ['NN'],
  'a-gracious': ['JJ'],
  'a-la-Aristotle': ['NN'],
  'a-raising': ['VBG'],
  'a-reflects': ['VBZ'],
  'a-stoopin': ['VBG'],
  'a-tall': ['JJ'],
  'a-wing': ['NN'],
  'a.': ['NN'],
  'a.k.a': ['JJ'],
  'a.k.a.': ['JJ'],
  'a.m': ['RB'],
  'a.m.': ['NN'],
  'a.m.-10': ['CD'],
  'a.m.-1:30': ['CD'],
  'a.m.-6': ['CD'],
  'a.m.-7': ['CD'],
  'a.m.-8': ['CD'],
  'a\\\'/k\\\'/a': ['NN'],
  'aahs': ['NNS'],
  'ab': ['NN'],
  'aback': ['RB'],
  'abacuses': ['NNS'],
  'abalone': ['NN'],
  'abandon': ['VB'],
  'abandoned': ['VBN'],
  'abandoning': ['VBG'],
  'abandonment': ['NN'],
  'abandons': ['VBZ'],
  'abaringe': ['NN'],
  'abasement': ['NN'],
  'abashed': ['JJ'],
  'abate': ['VB'],
  'abated': ['VBN'],
  'abatement': ['NN'],
  'abates': ['VBZ'],
  'abating': ['VBG'],
  'abberations': ['NNS'],
  'abbey': ['NN'],
  'abbot': ['NN'],
  'abbreviated': ['JJ'],
  'abbreviation': ['NN'],
  'abbreviations': ['NNS'],
  'abdicate': ['VBP'],
  'abdomen': ['NN'],
  'abdomens': ['NNS'],
  'abdominal': ['JJ'],
  'abdominis': ['NN'],
  'abducted': ['VBN'],
  'abduction': ['NN'],
  'abed': ['RB'],
  'aber': ['FW'],
  'aberrant': ['JJ'],
  'aberrantly': ['RB'],
  'aberration': ['NN'],
  'aberrations': ['NNS'],
  'abetted': ['VBN'],
  'abetting': ['VBG'],
  'abeyance': ['NN'],
  'abhor': ['VB'],
  'abhorred': ['VBD'],
  'abhorrent': ['JJ'],
  'abhorrently': ['RB'],
  'abide': ['VB'],
  'abides': ['VBZ'],
  'abiding': ['JJ'],
  'abilities': ['NNS'],
  'ability': ['NN'],
  'ability...': [':'],
  'abject': ['JJ'],
  'abjection': ['NN'],
  'abjectly': ['RB'],
  'ablated': ['VBN'],
  'ablation': ['NN'],
  'ablaze': ['JJ'],
  'able': ['JJ'],
  'able-bodied': ['JJ'],
  'abler': ['JJR'],
  'ably': ['RB'],
  'abnormal': ['JJ'],
  'abnormalities': ['NNS'],
  'abnormality': ['NN'],
  'abnormally': ['RB'],
  'aboard': ['IN'],
  'abode': ['NN'],
  'abolish': ['VB'],
  'abolished': ['VBN'],
  'abolishing': ['VBG'],
  'abolition': ['NN'],
  'abolitionist': ['NN'],
  'abolitionists': ['NNS'],
  'abominable': ['JJ'],
  'abomination': ['NN'],
  'aboriginal': ['JJ'],
  'aborigine': ['NN'],
  'aborigines': ['NNS'],
  'aborning': ['RB'],
  'abort': ['VB'],
  'aborted': ['JJ'],
  'abortifacient': ['NN'],
  'aborting': ['VBG'],
  'abortion': ['NN'],
  'abortion-funding': ['JJ'],
  'abortion-related': ['JJ'],
  'abortion-rights': ['NNS'],
  'abortionist': ['NN'],
  'abortions': ['NNS'],
  'abortive': ['JJ'],
  'abound': ['VBP'],
  'abounded': ['VBD'],
  'abounding': ['VBG'],
  'abounds': ['VBZ'],
  'about': ['IN'],
  'about-face': ['NN'],
  'about-faced': ['VBD'],
  'above': ['IN'],
  'above-average': ['JJ'],
  'above-ceiling': ['NN'],
  'above-ground': ['JJ'],
  'above-market': ['JJ'],
  'above-mentioned': ['JJ'],
  'above-normal': ['JJ'],
  'above-noted': ['JJ'],
  'above-target': ['JJ'],
  'above-water': ['JJ'],
  'aboveboard': ['JJ'],
  'aboveground': ['JJ'],
  'abrasion-resistant': ['NN'],
  'abrasive': ['JJ'],
  'abrasives': ['NNS'],
  'abreaction': ['NN'],
  'abreast': ['RB'],
  'abridged': ['VBN'],
  'abridges': ['VBZ'],
  'abridging': ['VBG'],
  'abridgment': ['NN'],
  'abroad': ['RB'],
  'abroade': ['RB'],
  'abrogate': ['VB'],
  'abrogated': ['VBN'],
  'abrupt': ['JJ'],
  'abruptly': ['RB'],
  'abruptness': ['NN'],
  'abscess': ['NN'],
  'abscesses': ['NNS'],
  'abscissa': ['NN'],
  'absence': ['NN'],
  'absences': ['NNS'],
  'absense': ['NN'],
  'absent': ['JJ'],
  'absent-minded': ['JJ'],
  'absent-mindedly': ['RB'],
  'absented': ['VBD'],
  'absentee': ['JJ'],
  'absentee-ballot': ['NN'],
  'absenteeism': ['NN'],
  'absentees': ['NNS'],
  'absentia': ['FW'],
  'absently': ['RB'],
  'absentmindedly': ['RB'],
  'absinthe': ['NN'],
  'absolute': ['JJ'],
  'absolutely': ['RB'],
  'absoluteness': ['NN'],
  'absolutes': ['NNS'],
  'absolution': ['NN'],
  'absolutism': ['NN'],
  'absolve': ['VBP'],
  'absolved': ['VBD'],
  'absolving': ['VBG'],
  'absorb': ['VB'],
  'absorbed': ['VBN'],
  'absorbedthe': ['VB'],
  'absorbency': ['NN'],
  'absorbent': ['JJ'],
  'absorber': ['NN'],
  'absorbers': ['NNS'],
  'absorbing': ['VBG'],
  'absorbs': ['VBZ'],
  'absorption': ['NN'],
  'absorptions': ['NNS'],
  'absorptive': ['JJ'],
  'abstain': ['VB'],
  'abstained': ['VBD'],
  'abstaining': ['VBG'],
  'abstention': ['NN'],
  'abstentions': ['NNS'],
  'abstinence': ['NN'],
  'abstract': ['JJ'],
  'abstracted': ['JJ'],
  'abstractedness': ['NN'],
  'abstracting': ['VBG'],
  'abstraction': ['NN'],
  'abstractionism': ['NN'],
  'abstractionists': ['NNS'],
  'abstractions': ['NNS'],
  'abstractive': ['JJ'],
  'abstractly': ['RB'],
  'abstractors': ['NNS'],
  'abstracts': ['NNS'],
  'abstruse': ['JJ'],
  'abstrusenesses': ['NNS'],
  'absurd': ['JJ'],
  'absurdist': ['JJ'],
  'absurdities': ['NNS'],
  'absurdity': ['NN'],
  'absurdly': ['RB'],
  'abt': ['IN'],
  'abundance': ['NN'],
  'abundant': ['JJ'],
  'abundantly': ['RB'],
  'abusable': ['JJ'],
  'abuse': ['NN'],
  'abused': ['VBN'],
  'abuser': ['NN'],
  'abusers': ['NNS'],
  'abuses': ['NNS'],
  'abusing': ['VBG'],
  'abusive': ['JJ'],
  'abutments': ['NNS'],
  'abuzz': ['JJ'],
  'abysmal': ['JJ'],
  'abyss': ['NN'],
  'acacia': ['NN'],
  'academe': ['NN'],
  'academeh': ['NN'],
  'academia': ['NN'],
  'academic': ['JJ'],
  'academically': ['RB'],
  'academician': ['NN'],
  'academics': ['NNS'],
  'academies': ['NNS'],
  'academy': ['NN'],
  'acccounting': ['NN'],
  'accede': ['VB'],
  'acceded': ['VBD'],
  'accelerate': ['VB'],
  'accelerated': ['VBN'],
  'accelerates': ['VBZ'],
  'accelerating': ['VBG'],
  'acceleration': ['NN'],
  'accelerations': ['NNS'],
  'accelerator': ['NN'],
  'accelerators': ['NNS'],
  'accelerometer': ['NN'],
  'accelerometers': ['NNS'],
  'accent': ['NN'],
  'accented': ['VBN'],
  'accenting': ['NN'],
  'accents': ['NNS'],
  'accentual': ['JJ'],
  'accentuate': ['VB'],
  'accentuated': ['VBN'],
  'accentuates': ['VBZ'],
  'accept': ['VB'],
  'acceptability': ['NN'],
  'acceptable': ['JJ'],
  'acceptance': ['NN'],
  'acceptances': ['NNS'],
  'accepted': ['VBN'],
  'accepting': ['VBG'],
  'accepts': ['VBZ'],
  'accesory': ['NN'],
  'access': ['NN'],
  'accessed': ['VBN'],
  'accesses': ['NNS'],
  'accessibility': ['NN'],
  'accessible': ['JJ'],
  'accessions': ['NNS'],
  'accessories': ['NNS'],
  'accessory': ['NN'],
  'accident': ['NN'],
  'accidental': ['JJ'],
  'accidental-war': ['NN'],
  'accidentally': ['RB'],
  'accidently': ['RB'],
  'accidents': ['NNS'],
  'acclaim': ['NN'],
  'acclaimed': ['VBN'],
  'acclaims': ['VBZ'],
  'acclamation': ['NN'],
  'acclimatized': ['VBN'],
  'accolade': ['NN'],
  'accolades': ['NNS'],
  'accommodate': ['VB'],
  'accommodated': ['VBN'],
  'accommodates': ['VBZ'],
  'accommodating': ['VBG'],
  'accommodation': ['NN'],
  'accommodations': ['NNS'],
  'accommodative': ['JJ'],
  'accomodate': ['VB'],
  'accomodations': ['NNS'],
  'accompanied': ['VBN'],
  'accompanies': ['VBZ'],
  'accompaniment': ['NN'],
  'accompaniments': ['NNS'],
  'accompanist': ['NN'],
  'accompanists': ['NNS'],
  'accompany': ['VB'],
  'accompanying': ['VBG'],
  'accompli': ['NN'],
  'accomplice': ['NN'],
  'accomplices': ['NNS'],
  'accomplish': ['VB'],
  'accomplished': ['VBN'],
  'accomplishes': ['VBZ'],
  'accomplishing': ['VBG'],
  'accomplishment': ['NN'],
  'accomplishments': ['NNS'],
  'accompnaying': ['VBG'],
  'accord': ['NN'],
  'accordance': ['NN'],
  'accorded': ['VBN'],
  'according': ['VBG'],
  'accordingly': ['RB'],
  'accordion': ['NN'],
  'accordion-folding': ['JJ'],
  'accords': ['NNS'],
  'accosted': ['VBN'],
  'accosting': ['VBG'],
  'account': ['NN'],
  'account-churning': ['NN'],
  'accountability': ['NN'],
  'accountable': ['JJ'],
  'accountant': ['NN'],
  'accountants': ['NNS'],
  'accountants...': [':'],
  'accounted': ['VBD'],
  'accounting': ['NN'],
  'accounting-rules': ['JJ'],
  'accounts': ['NNS'],
  'accouterments': ['NNS'],
  'accreditation': ['NN'],
  'accredited': ['VBD'],
  'accrediting': ['NN'],
  'accreted': ['VBN'],
  'accretion': ['NN'],
  'accretions': ['NNS'],
  'accrual': ['NN'],
  'accruals': ['NNS'],
  'accrue': ['VB'],
  'accrued': ['VBN'],
  'accrues': ['VBZ'],
  'accruing': ['VBG'],
  'acculturated': ['VBN'],
  'acculturation': ['NN'],
  'accumulate': ['VB'],
  'accumulated': ['VBN'],
  'accumulates': ['VBZ'],
  'accumulating': ['VBG'],
  'accumulation': ['NN'],
  'accumulator': ['NN'],
  'accuracy': ['NN'],
  'accurate': ['JJ'],
  'accurately': ['RB'],
  'accusation': ['NN'],
  'accusations': ['NNS'],
  'accusatory': ['JJ'],
  'accuse': ['VB'],
  'accused': ['VBN'],
  'accuser': ['NN'],
  'accusers': ['NNS'],
  'accuses': ['VBZ'],
  'accusing': ['VBG'],
  'accusingly': ['RB'],
  'accustomed': ['VBN'],
  'accustoms': ['VBZ'],
  'ace': ['NN'],
  'acerbic': ['JJ'],
  'aces': ['NNS'],
  'acetate': ['NN'],
  'acetominophen': ['NN'],
  'acetone': ['NN'],
  'acetonemia': ['NN'],
  'acetylene': ['NN'],
  'acetylene-fueled': ['JJ'],
  'ache': ['NN'],
  'ached': ['VBD'],
  'aches': ['NNS'],
  'achievable': ['JJ'],
  'achieve': ['VB'],
  'achieved': ['VBN'],
  'achievement': ['NN'],
  'achievement-test': ['NN'],
  'achievements': ['NNS'],
  'achieves': ['VBZ'],
  'achieving': ['VBG'],
  'aching': ['VBG'],
  'acid': ['NN'],
  'acid-fast': ['JJ'],
  'acid-rain': ['NN'],
  'acidified': ['VBN'],
  'acidity': ['NN'],
  'acidly': ['RB'],
  'acids': ['NNS'],
  'acidulous': ['JJ'],
  'aciduria': ['NN'],
  'acknowledge': ['VBP'],
  'acknowledged': ['VBD'],
  'acknowledgement': ['NN'],
  'acknowledges': ['VBZ'],
  'acknowledging': ['VBG'],
  'acknowledgment': ['NN'],
  'acknowledgments': ['NNS'],
  'acknowleged': ['VBD'],
  'acne': ['NN'],
  'acolyte': ['NN'],
  'aconte': ['NN'],
  'acorns': ['NNS'],
  'acoustic': ['JJ'],
  'acoustical': ['JJ'],
  'acoustically': ['RB'],
  'acoustics': ['NNS'],
  'acquaint': ['VB'],
  'acquaintance': ['NN'],
  'acquainted': ['VBN'],
  'acquiesce': ['VB'],
  'acquiesced': ['VBD'],
  'acquiescence': ['NN'],
  'acquiesence': ['NN'],
  'acquire': ['VB'],
  'acquired': ['VBN'],
  'acquirer': ['NN'],
  'acquirers': ['NNS'],
  'acquires': ['VBZ'],
  'acquiring': ['VBG'],
  'acquisition': ['NN'],
  'acquisition-hungry': ['JJ'],
  'acquisition-minded': ['JJ'],
  'acquisition-proof': ['JJ'],
  'acquisition...': [':'],
  'acquisitions': ['NNS'],
  'acquisitions.s': ['NNS'],
  'acquisitive': ['JJ'],
  'acquisitiveness': ['NN'],
  'acquisiton': ['NN'],
  'acquistion': ['NN'],
  'acquit': ['VB'],
  'acquittal': ['NN'],
  'acquitted': ['VBN'],
  'acre': ['NN'],
  'acre-feet': ['NN'],
  'acreage': ['NN'],
  'acres': ['NNS'],
  'acrid': ['JJ'],
  'acrimonious': ['JJ'],
  'acrimony': ['NN'],
  'acrobacy': ['NN'],
  'acrobat': ['NN'],
  'acrobatic': ['JJ'],
  'acrobatics': ['NNS'],
  'acrobats': ['NNS'],
  'acronym': ['NN'],
  'across': ['IN'],
  'across-the-board': ['JJ'],
  'across-the-board-cuts': ['NNS'],
  'acrylic': ['NN'],
  'acrylic-fiber': ['JJ'],
  'act': ['NN'],
  'act...': [':'],
  'acted': ['VBD'],
  'acting': ['VBG'],
  'actinometer': ['NN'],
  'action': ['NN'],
  'action-adventure': ['JJ'],
  'action-oriented': ['JJ'],
  'action-packed': ['JJ'],
  'action-results': ['NNS'],
  'action\\\'': ['JJ'],
  'actionable': ['JJ'],
  'actions': ['NNS'],
  'activate': ['VBP'],
  'activated': ['VBN'],
  'activating': ['VBG'],
  'activation': ['NN'],
  'active': ['JJ'],
  'active-matrix': ['JJ'],
  'active-player': ['NN'],
  'actively': ['RB'],
  'actives': ['NNS'],
  'activism': ['NN'],
  'activist': ['NN'],
  'activists': ['NNS'],
  'activities': ['NNS'],
  'activity': ['NN'],
  'actor': ['NN'],
  'actors': ['NNS'],
  'actress': ['NN'],
  'actress\\\'': ['JJ'],
  'actresses': ['NNS'],
  'acts': ['NNS'],
  'acts...': [':'],
  'actual': ['JJ'],
  'actualities': ['NNS'],
  'actuality': ['NN'],
  'actually': ['RB'],
  'actuarial': ['JJ'],
  'actuarially': ['RB'],
  'actuaries': ['NNS'],
  'actuary': ['NN'],
  'actuate': ['VB'],
  'actuated': ['VBN'],
  'actuators': ['NNS'],
  'acumen': ['NN'],
  'acupuncture': ['NN'],
  'acupuncturist': ['NN'],
  'acute': ['JJ'],
  'acute-care': ['NN'],
  'acutely': ['RB'],
  'ad': ['NN'],
  'ad-agency': ['NN'],
  'ad-free': ['JJ'],
  'ad-hoc': ['JJ'],
  'ad-lib': ['NN'],
  'ad-rate': ['NN'],
  'ad-supported': ['JJ'],
  'adage': ['NN'],
  'adagio': ['NN'],
  'adagios': ['NNS'],
  'adamant': ['JJ'],
  'adamantly': ['RB'],
  'adapt': ['VB'],
  'adaptability': ['NN'],
  'adaptable': ['JJ'],
  'adaptation': ['NN'],
  'adaptations': ['NNS'],
  'adapted': ['VBN'],
  'adapter': ['NN'],
  'adapters': ['NNS'],
  'adapting': ['VBG'],
  'adaptor': ['NN'],
  'adapts': ['VBZ'],
  'add': ['VB'],
  'add-on': ['JJ'],
  'add-ons': ['NNS'],
  'added': ['VBD'],
  'added-value': ['JJ'],
  'added:``': ['``'],
  'addict': ['NN'],
  'addicted': ['VBN'],
  'addiction': ['NN'],
  'addiction-treatment': ['JJ'],
  'addictions': ['NNS'],
  'addictive': ['JJ'],
  'addicts': ['NNS'],
  'adding': ['VBG'],
  'addition': ['NN'],
  'additional': ['JJ'],
  'additionally': ['RB'],
  'additions': ['NNS'],
  'additive': ['NN'],
  'additives': ['NNS'],
  'addle-brained': ['JJ'],
  'addled': ['JJ'],
  'address': ['NN'],
  'addressed': ['VBN'],
  'addressee': ['NN'],
  'addressees': ['NNS'],
  'addresses': ['NNS'],
  'addressing': ['VBG'],
  'addresss': ['NNS'],
  'adds': ['VBZ'],
  'adduce': ['VB'],
  'adenocard': ['NN'],
  'adenomas': ['NN'],
  'adept': ['JJ'],
  'adepts': ['NNS'],
  'adequacy': ['NN'],
  'adequate': ['JJ'],
  'adequately': ['RB'],
  'adhere': ['VB'],
  'adhered': ['VBN'],
  'adherence': ['NN'],
  'adherent': ['JJ'],
  'adherents': ['NNS'],
  'adheres': ['VBZ'],
  'adhering': ['VBG'],
  'adhesion': ['NN'],
  'adhesive': ['JJ'],
  'adhesives': ['NNS'],
  'adieu': ['FW'],
  'adipic': ['JJ'],
  'adjacent': ['JJ'],
  'adjectival': ['JJ'],
  'adjective': ['NN'],
  'adjectives': ['NNS'],
  'adjoined': ['VBD'],
  'adjoining': ['VBG'],
  'adjoins': ['VBZ'],
  'adjourn': ['VB'],
  'adjourned': ['VBD'],
  'adjourning': ['NN'],
  'adjournment': ['NN'],
  'adjourns': ['VBZ'],
  'adjudged': ['VBN'],
  'adjudging': ['VBG'],
  'adjudicate': ['VB'],
  'adjudication': ['NN'],
  'adjudicator': ['NN'],
  'adjudicators': ['NNS'],
  'adjunct': ['NN'],
  'adjuncts': ['NNS'],
  'adjust': ['VB'],
  'adjustable': ['JJ'],
  'adjustable-rate': ['JJ'],
  'adjustablerate': ['NN'],
  'adjustables': ['NNS'],
  'adjusted': ['VBN'],
  'adjuster': ['NN'],
  'adjusters': ['NNS'],
  'adjusting': ['VBG'],
  'adjustment': ['NN'],
  'adjustments': ['NNS'],
  'adjusts': ['VBZ'],
  'adman': ['NN'],
  'admen': ['NNS'],
  'administer': ['VB'],
  'administered': ['VBN'],
  'administering': ['VBG'],
  'administers': ['VBZ'],
  'administrate': ['VB'],
  'administration': ['NN'],
  'administration-Fed': ['JJ'],
  'administration...': [':'],
  'administrations': ['NNS'],
  'administrative': ['JJ'],
  'administratively': ['RB'],
  'administrator': ['NN'],
  'administrator-general': ['NN'],
  'administrators': ['NNS'],
  'adminstration': ['NN'],
  'adminstrative': ['JJ'],
  'admirable': ['JJ'],
  'admirably': ['RB'],
  'admiral': ['NN'],
  'admirals': ['NNS'],
  'admiralty': ['NN'],
  'admiration': ['NN'],
  'admire': ['VB'],
  'admired': ['VBD'],
  'admirer': ['NN'],
  'admirers': ['NNS'],
  'admires': ['VBZ'],
  'admiring': ['VBG'],
  'admiringly': ['RB'],
  'admissible': ['JJ'],
  'admission': ['NN'],
  'admissions': ['NNS'],
  'admit': ['VB'],
  'admits': ['VBZ'],
  'admittance': ['NN'],
  'admittances': ['NNS'],
  'admitted': ['VBD'],
  'admittedly': ['RB'],
  'admittees': ['NNS'],
  'admitting': ['VBG'],
  'admixed': ['VBN'],
  'admonished': ['VBD'],
  'admonishing': ['VBG'],
  'admonishments': ['NNS'],
  'admonition': ['NN'],
  'admonitions': ['NNS'],
  'ado': ['NN'],
  'adobe': ['NN'],
  'adolescence': ['NN'],
  'adolescent': ['NN'],
  'adolescents': ['NNS'],
  'adopt': ['VB'],
  'adoptable': ['JJ'],
  'adopted': ['VBN'],
  'adoptee': ['NN'],
  'adoptees': ['NNS'],
  'adopters': ['NNS'],
  'adopting': ['VBG'],
  'adoption': ['NN'],
  'adoption-assistance': ['JJ'],
  'adoption-business': ['NN'],
  'adoptions': ['NNS'],
  'adoptive': ['JJ'],
  'adopts': ['VBZ'],
  'adorable': ['JJ'],
  'adore': ['VBP'],
  'adored': ['VBD'],
  'adores': ['VBZ'],
  'adoring': ['VBG'],
  'adorn': ['VB'],
  'adorned': ['VBN'],
  'adornments': ['NNS'],
  'adorns': ['VBZ'],
  'adrenal': ['JJ'],
  'adrenaline': ['NN'],
  'adrift': ['RB'],
  'adroit': ['JJ'],
  'adroitly': ['RB'],
  'adroitness': ['NN'],
  'ads': ['NNS'],
  'adsorbed': ['VBN'],
  'adsorbs': ['VBZ'],
  'adulation': ['NN'],
  'adult': ['NN'],
  'adult-literacy': ['NN'],
  'adult-training': ['JJ'],
  'adulterate': ['VB'],
  'adulterated': ['VBN'],
  'adulterers': ['NNS'],
  'adulterous': ['JJ'],
  'adultery': ['NN'],
  'adulthood': ['NN'],
  'adults': ['NNS'],
  'advance': ['NN'],
  'advance-purchase': ['JJ'],
  'advanced': ['VBD'],
  'advanced-ceramics': ['NN'],
  'advanced-materials': ['JJ'],
  'advanced-technology': ['JJ'],
  'advancement': ['NN'],
  'advancements': ['NNS'],
  'advancer': ['NN'],
  'advancers': ['NNS'],
  'advances': ['NNS'],
  'advancing': ['VBG'],
  'advantage': ['NN'],
  'advantageous': ['JJ'],
  'advantageously': ['RB'],
  'advantages': ['NNS'],
  'advent': ['NN'],
  'adventitious': ['JJ'],
  'adventure': ['NN'],
  'adventure-based': ['JJ'],
  'adventure-loving': ['JJ'],
  'adventurer': ['NN'],
  'adventurers': ['NNS'],
  'adventures': ['NNS'],
  'adventuresome': ['JJ'],
  'adventuring': ['NN'],
  'adventurism': ['NN'],
  'adventurist': ['JJ'],
  'adventurous': ['JJ'],
  'adventurously': ['RB'],
  'adverb': ['NN'],
  'adverbial': ['JJ'],
  'adverbs': ['NNS'],
  'adversarial': ['JJ'],
  'adversaries': ['NNS'],
  'adversary': ['NN'],
  'adverse': ['JJ'],
  'adversely': ['RB'],
  'adversities': ['NNS'],
  'adversity': ['NN'],
  'advert': ['NN'],
  'advertise': ['VB'],
  'advertised': ['VBN'],
  'advertisement': ['NN'],
  'advertisements': ['NNS'],
  'advertiser': ['NN'],
  'advertiser-bankrolled': ['JJ'],
  'advertiser-programming': ['NN'],
  'advertiser-sponsored': ['JJ'],
  'advertisers': ['NNS'],
  'advertises': ['VBZ'],
  'advertising': ['NN'],
  'advertising-backed': ['JJ'],
  'advertising-conscious': ['JJ'],
  'advertorial': ['JJ'],
  'advice': ['NN'],
  'advisability': ['NN'],
  'advisable': ['JJ'],
  'advise': ['VB'],
  'advised': ['VBN'],
  'advisedly': ['RB'],
  'advisement': ['NN'],
  'adviser': ['NN'],
  'advisers': ['NNS'],
  'advises': ['VBZ'],
  'advising': ['VBG'],
  'advisor': ['NN'],
  'advisories': ['NNS'],
  'advisors': ['NNS'],
  'advisory': ['JJ'],
  'advocacy': ['NN'],
  'advocate': ['NN'],
  'advocated': ['VBN'],
  'advocates': ['NNS'],
  'advocating': ['VBG'],
  'aegis': ['NN'],
  'aeon': ['NN'],
  'aerate': ['VB'],
  'aerated': ['VBN'],
  'aerates': ['VBZ'],
  'aeration': ['NN'],
  'aerator': ['NN'],
  'aerial': ['JJ'],
  'aerialists': ['NNS'],
  'aerials': ['NNS'],
  'aerobic': ['JJ'],
  'aerobics': ['NN'],
  'aerodynamic': ['JJ'],
  'aerogenes': ['NNS'],
  'aeromedical': ['JJ'],
  'aeronautical': ['JJ'],
  'aerosal': ['NN'],
  'aerosol': ['NN'],
  'aerosolized': ['VBN'],
  'aerosols': ['NNS'],
  'aerospace': ['NN'],
  'aerospace-industry': ['NN'],
  'aesthetes': ['NNS'],
  'aesthetic': ['JJ'],
  'aesthetically': ['RB'],
  'aesthetics': ['NNS'],
  'aeterna': ['FW'],
  'aeternitatis': ['FW'],
  'afar': ['RB'],
  'affable': ['JJ'],
  'affadavit': ['NN'],
  'affair': ['NN'],
  'affairs': ['NNS'],
  'affect': ['VB'],
  'affectation': ['NN'],
  'affectations': ['NNS'],
  'affected': ['VBN'],
  'affecting': ['VBG'],
  'affectingly': ['RB'],
  'affection': ['NN'],
  'affectionate': ['JJ'],
  'affectionately': ['RB'],
  'affections': ['NNS'],
  'affects': ['VBZ'],
  'afferent': ['JJ'],
  'affianced': ['VBN'],
  'affidavit': ['NN'],
  'affidavits': ['NNS'],
  'affied': ['VBD'],
  'affilates': ['NNS'],
  'affiliate': ['NN'],
  'affiliated': ['VBN'],
  'affiliates': ['NNS'],
  'affiliating': ['VBG'],
  'affiliation': ['NN'],
  'affiliations': ['NNS'],
  'affilliate': ['NN'],
  'affinities': ['NNS'],
  'affinity': ['NN'],
  'affirm': ['VB'],
  'affirmation': ['NN'],
  'affirmations': ['NNS'],
  'affirmative': ['JJ'],
  'affirmative-action': ['NN'],
  'affirmed': ['VBD'],
  'affirming': ['VBG'],
  'affirms': ['VBZ'],
  'affix': ['VB'],
  'affixed': ['VBN'],
  'afflict': ['VB'],
  'afflicted': ['VBN'],
  'afflicting': ['VBG'],
  'affliction': ['NN'],
  'afflictions': ['NNS'],
  'afflicts': ['VBZ'],
  'affluence': ['NN'],
  'affluent': ['JJ'],
  'afford': ['VB'],
  'affordability': ['NN'],
  'affordable': ['JJ'],
  'afforded': ['VBN'],
  'affording': ['VBG'],
  'affords': ['VBZ'],
  'affront': ['NN'],
  'affronted': ['VBN'],
  'affronting': ['VBG'],
  'afghan': ['NN'],
  'aficionado': ['NN'],
  'afield': ['RB'],
  'afire': ['RB'],
  'aflame': ['JJ'],
  'aflatoxin': ['NN'],
  'aflatoxin-free': ['JJ'],
  'aflatoxin-producing': ['JJ'],
  'aflatoxin-related': ['JJ'],
  'afloat': ['RB'],
  'afoot': ['RB'],
  'aforementioned': ['JJ'],
  'aforesaid': ['JJ'],
  'aforethought': ['JJ'],
  'afoul': ['RB'],
  'afraid': ['JJ'],
  'afresh': ['RB'],
  'aft': ['JJ'],
  'after': ['IN'],
  'after-dinner': ['JJ'],
  'after-duty': ['JJ'],
  'after-effects': ['NNS'],
  'after-hours': ['JJ'],
  'after-run': ['JJ'],
  'after-school': ['JJ'],
  'after-tax': ['JJ'],
  'afterburners': ['NNS'],
  'aftereffects': ['NNS'],
  'afterglow': ['NN'],
  'aftermarket': ['JJ'],
  'aftermath': ['NN'],
  'aftermaths': ['NNS'],
  'afternoon': ['NN'],
  'afternoons': ['NNS'],
  'aftershave': ['NN'],
  'aftershock': ['NN'],
  'aftershock-damping': ['JJ'],
  'aftershock-resistant': ['JJ'],
  'aftershocks': ['NNS'],
  'aftertax': ['JJ'],
  'afterthought': ['NN'],
  'afterward': ['RB'],
  'afterwards': ['RB'],
  'aftuh': ['RB'],
  'ag': ['NN'],
  'again': ['RB'],
  'against': ['IN'],
  'againt': ['NN'],
  'agates': ['NNS'],
  'agave': ['NN'],
  'agayne': ['RB'],
  'age': ['NN'],
  'age-and-sex': ['JJ'],
  'age-bias': ['JJ'],
  'age-discrimination': ['JJ'],
  'age-old': ['JJ'],
  'age-specific': ['JJ'],
  'aged': ['VBN'],
  'aged-care': ['NN'],
  'ageless': ['JJ'],
  'agencies': ['NNS'],
  'agency': ['NN'],
  'agency-dealing': ['JJ'],
  'agenda': ['NN'],
  'agenda-setter': ['NN'],
  'agendas': ['NNS'],
  'agent': ['NN'],
  'agents': ['NNS'],
  'agents-in-training': ['NNS'],
  'ages': ['NNS'],
  'agglomerate': ['NN'],
  'agglomeration': ['NN'],
  'agglutinating': ['VBG'],
  'agglutination': ['NN'],
  'agglutinin': ['NN'],
  'agglutinins': ['NNS'],
  'aggrandizing': ['VBG'],
  'aggravate': ['VBP'],
  'aggravated': ['VBN'],
  'aggravates': ['VBZ'],
  'aggravating': ['VBG'],
  'aggregate': ['JJ'],
  'aggregates': ['NNS'],
  'aggregation': ['NN'],
  'aggregations': ['NNS'],
  'aggression': ['NN'],
  'aggressions': ['NNS'],
  'aggressive': ['JJ'],
  'aggressively': ['RB'],
  'aggressiveness': ['NN'],
  'aggressor': ['NN'],
  'aggrieved': ['VBN'],
  'aghast': ['JJ'],
  'agile': ['JJ'],
  'agilely': ['RB'],
  'agility': ['NN'],
  'agin': ['IN'],
  'aging': ['VBG'],
  'agitate': ['VBP'],
  'agitated': ['VBD'],
  'agitating': ['VBG'],
  'agitation': ['NN'],
  'agitator': ['NN'],
  'agitators': ['NNS'],
  'agleam': ['JJ'],
  'aglimmering': ['VBG'],
  'agnomen': ['NN'],
  'agnostics': ['NNS'],
  'ago': ['RB'],
  'ago,\'crack': ['NN'],
  'ago.': ['RB'],
  'agonies': ['NNS'],
  'agonize': ['VB'],
  'agonized': ['VBD'],
  'agonizes': ['VBZ'],
  'agonizing': ['JJ'],
  'agony': ['NN'],
  'agranulocytosis': ['NN'],
  'agrarian': ['JJ'],
  'agrarian-reform': ['JJ'],
  'agree': ['VB'],
  'agree.': ['VB'],
  'agreeable': ['JJ'],
  'agreeableness': ['NN'],
  'agreeably': ['RB'],
  'agreed': ['VBD'],
  'agreed-on': ['JJ'],
  'agreed-to': ['JJ'],
  'agreed-upon': ['IN'],
  'agreeement': ['NN'],
  'agreeing': ['VBG'],
  'agreement': ['NN'],
  'agreements': ['NNS'],
  'agrees': ['VBZ'],
  'agressive': ['JJ'],
  'agribusiness': ['NN'],
  'agricolas': ['FW'],
  'agricole': ['FW'],
  'agriculteurs': ['FW'],
  'agricultural': ['JJ'],
  'agricultural-research': ['JJ'],
  'agriculturally': ['RB'],
  'agriculturals': ['NNS'],
  'agriculture': ['NN'],
  'agriculture-based': ['JJ'],
  'agriculture-chemicals': ['NNS'],
  'agriculture-extension': ['NN'],
  'agriculture-related': ['JJ'],
  'agriproducts': ['NNS'],
  'agro-chemicals': ['NNS'],
  'agro-industrial': ['JJ'],
  'agro-industry': ['JJ'],
  'agrochemical': ['NN'],
  'agronomist': ['NN'],
  'aground': ['RB'],
  'ague': ['NN'],
  'ah': ['UH'],
  'aha': ['UH'],
  'ahdawam': ['UH'],
  'ahead': ['RB'],
  'ahem': ['UH'],
  'ahs': ['UH'],
  'ai': ['VBP'],
  'aid': ['NN'],
  'aid-to-education': ['NN'],
  'aide': ['NN'],
  'aide-de-camp': ['NN'],
  'aided': ['VBN'],
  'aides': ['NNS'],
  'aiding': ['VBG'],
  'aids': ['NNS'],
  'aikido': ['FW'],
  'ailerons': ['NNS'],
  'ailing': ['VBG'],
  'ailment': ['NN'],
  'ailments': ['NNS'],
  'ails': ['NNS'],
  'aim': ['NN'],
  'aimed': ['VBN'],
  'aiming': ['VBG'],
  'aimless': ['JJ'],
  'aimlessly': ['RB'],
  'aims': ['VBZ'],
  'ain\'t': ['VB'],
  'ain\'t-it-great-to-be-a-Texan': ['JJ'],
  'aint': ['VBZ'],
  'air': ['NN'],
  'air-cargo': ['NN'],
  'air-cell': ['JJ'],
  'air-charter': ['JJ'],
  'air-conditioned': ['JJ'],
  'air-conditioner': ['NN'],
  'air-conditioners': ['NNS'],
  'air-conditioning': ['NN'],
  'air-defense': ['JJ'],
  'air-express': ['NN'],
  'air-frame': ['NN'],
  'air-freight': ['NN'],
  'air-freight-forwarding': ['JJ'],
  'air-injection': ['NN'],
  'air-interdiction': ['NN'],
  'air-launched': ['JJ'],
  'air-passenger': ['NN'],
  'air-pollution': ['NN'],
  'air-quality': ['NN'],
  'air-separation': ['NN'],
  'air-service': ['NN'],
  'air-tickets': ['NNS'],
  'air-to-air': ['JJ'],
  'air-to-ground': ['JJ'],
  'air-to-surface': ['JJ'],
  'air-traffic': ['NN'],
  'air-traffic-control': ['NN'],
  'air-water': ['JJ'],
  'air-waybill': ['JJ'],
  'airbags': ['NNS'],
  'airborne': ['JJ'],
  'airborne-radar': ['NN'],
  'airconditioner': ['JJR'],
  'aircraft': ['NN'],
  'aircraft-electronics': ['NN'],
  'aircraft-engine': ['JJ'],
  'aircraft-engine-maintenance': ['JJ'],
  'aircraft-navigation': ['NN'],
  'aircraft-test': ['JJ'],
  'airdrops': ['NNS'],
  'aired': ['VBN'],
  'airfare': ['NN'],
  'airfield': ['NN'],
  'airfields': ['NNS'],
  'airflow': ['NN'],
  'airframe': ['NN'],
  'airframes': ['NNS'],
  'airheads': ['NNS'],
  'airily': ['RB'],
  'airing': ['VBG'],
  'airings': ['NNS'],
  'airless': ['JJ'],
  'airlift': ['NN'],
  'airlifted': ['VBN'],
  'airlifting': ['VBG'],
  'airline': ['NN'],
  'airline-acquisition': ['JJ'],
  'airline-crash': ['JJ'],
  'airline-deregulation': ['NN'],
  'airline-financed': ['JJ'],
  'airline-hostess': ['NN'],
  'airline-industry': ['NN'],
  'airline-interior': ['JJ'],
  'airline-landing': ['JJ'],
  'airline-related': ['JJ'],
  'airliner': ['NN'],
  'airliners': ['NNS'],
  'airlines': ['NNS'],
  'airlock': ['NN'],
  'airmail': ['NN'],
  'airmailed': ['VBD'],
  'airman': ['NN'],
  'airmen': ['NNS'],
  'airplane': ['NN'],
  'airplanes': ['NNS'],
  'airplay': ['NN'],
  'airport': ['NN'],
  'airports': ['NNS'],
  'airs': ['NNS'],
  'airspeed': ['NN'],
  'airstrip': ['NN'],
  'airstrips': ['NNS'],
  'airtime': ['NN'],
  'airwaves': ['NNS'],
  'airway': ['NN'],
  'airways': ['NNS'],
  'airworthiness': ['NN'],
  'airy': ['JJ'],
  'aisle': ['NN'],
  'aisles': ['NNS'],
  'ajar': ['RB'],
  'ajury': ['NN'],
  'akin': ['JJ'],
  'aku': ['FW'],
  'al': ['NNS'],
  'al-Assad': ['NNP'],
  'al-Faisal': ['NNP'],
  'al-Husseini': ['NNP'],
  'al.': ['NNS'],
  'alabaster': ['NN'],
  'alai': ['FW'],
  'alarm': ['NN'],
  'alarmed': ['VBN'],
  'alarming': ['JJ'],
  'alarmingly': ['RB'],
  'alarmism': ['NN'],
  'alarmist': ['JJ'],
  'alarms': ['NNS'],
  'alas': ['UH'],
  'albatross': ['NN'],
  'albeit': ['IN'],
  'albicans': ['NNS'],
  'albino': ['NN'],
  'album': ['NN'],
  'albumin': ['NN'],
  'albums': ['NNS'],
  'alchemists': ['NNS'],
  'alchemy': ['NN'],
  'alcohol': ['NN'],
  'alcohol-powered': ['JJ'],
  'alcohol-producing': ['JJ'],
  'alcohol-related': ['JJ'],
  'alcoholic': ['JJ'],
  'alcoholic-beverage': ['NN'],
  'alcoholics': ['NNS'],
  'alcoholism': ['NN'],
  'alcohols': ['NNS'],
  'alcoves': ['NNS'],
  'alderman': ['NN'],
  'aldermen': ['NNS'],
  'alders': ['NNS'],
  'ale': ['NN'],
  'aleck': ['NN'],
  'alert': ['JJ'],
  'alerted': ['VBD'],
  'alerting': ['VBG'],
  'alertly': ['RB'],
  'alertness': ['NN'],
  'alerts': ['VBZ'],
  'alfalfa': ['NN'],
  'alfresco': ['JJ'],
  'algae': ['NNS'],
  'algaecide': ['NN'],
  'algebra': ['NN'],
  'algebraic': ['JJ'],
  'algebraically': ['RB'],
  'alginates': ['NNS'],
  'algorithm': ['NN'],
  'alia': ['FW'],
  'alias': ['NN'],
  'alibi': ['NN'],
  'alibis': ['NNS'],
  'alien': ['JJ'],
  'alienate': ['VB'],
  'alienated': ['VBN'],
  'alienates': ['VBZ'],
  'alienating': ['VBG'],
  'alienation': ['NN'],
  'aliens': ['NNS'],
  'alight': ['JJ'],
  'align': ['VB'],
  'aligned': ['VBN'],
  'alignment': ['NN'],
  'alignments': ['NNS'],
  'alike': ['RB'],
  'alimony': ['NN'],
  'aliquots': ['NNS'],
  'alive': ['JJ'],
  'alizarin': ['NN'],
  'alkali': ['NNS'],
  'alkaline': ['JJ'],
  'alkalis': ['NNS'],
  'alkaloids': ['NNS'],
  'alky': ['NN'],
  'alkylarysulfonate': ['NN'],
  'alkylbenzenesulfonates': ['NNS'],
  'all': ['DT'],
  'all-America': ['JJ'],
  'all-American': ['JJ'],
  'all-American-boy': ['NN'],
  'all-Copland': ['JJ'],
  'all-Negro': ['JJ'],
  'all-New': ['NNP'],
  'all-Spanish': ['JJ'],
  'all-around': ['JJ'],
  'all-automatic': ['JJ'],
  'all-black': ['JJ'],
  'all-cargo': ['JJ'],
  'all-cash': ['JJ'],
  'all-college': ['NN'],
  'all-consuming': ['JJ'],
  'all-county': ['JJ'],
  'all-day': ['JJ'],
  'all-employee': ['JJ'],
  'all-exclusive': ['JJ'],
  'all-expenses-paid': ['JJ'],
  'all-federal': ['JJ'],
  'all-female': ['JJ'],
  'all-important': ['JJ'],
  'all-in-all': ['RB'],
  'all-inclusive': ['JJ'],
  'all-knowing': ['JJ'],
  'all-lesbian': ['JJ'],
  'all-married': ['JJ'],
  'all-natural': ['JJ'],
  'all-new': ['JJ'],
  'all-news': ['JJ'],
  'all-night': ['JJ'],
  'all-nighters': ['NNS'],
  'all-options': ['JJ'],
  'all-out': ['JJ'],
  'all-over': ['IN'],
  'all-paper': ['JJ'],
  'all-pervading': ['JJ'],
  'all-powerful': ['JJ'],
  'all-purpose': ['JJ'],
  'all-round': ['JJ'],
  'all-something-or-the-other': ['JJ'],
  'all-star': ['JJ'],
  'all-stock': ['JJ'],
  'all-student': ['JJ'],
  'all-terrain': ['JJ'],
  'all-time': ['JJ'],
  'all-too-brief': ['JJ'],
  'all-too-familiar': ['JJ'],
  'all-too-sincere': ['JJ'],
  'all-victorious': ['JJ'],
  'all-weather': ['JJ'],
  'all-white': ['JJ'],
  'all-woman': ['JJ'],
  'allay': ['VB'],
  'allayed': ['VBN'],
  'allaying': ['VBG'],
  'allegation': ['NN'],
  'allegations': ['NNS'],
  'allege': ['VBP'],
  'alleged': ['VBN'],
  'allegedly': ['RB'],
  'alleges': ['VBZ'],
  'allegiance': ['NN'],
  'allegiances': ['NNS'],
  'alleging': ['VBG'],
  'allegoric': ['JJ'],
  'allegorical': ['JJ'],
  'allegory': ['NN'],
  'allegro': ['JJ'],
  'allergic': ['JJ'],
  'allergies': ['NNS'],
  'allergy': ['NN'],
  'alleviate': ['VB'],
  'alleviates': ['VBZ'],
  'alleviating': ['VBG'],
  'alleviation': ['NN'],
  'alley': ['NN'],
  'alleys': ['NNS'],
  'alleyways': ['NNS'],
  'allgedly': ['RB'],
  'alliance': ['NN'],
  'alliances': ['NNS'],
  'allied': ['VBN'],
  'allies': ['NNS'],
  'alligator': ['NN'],
  'alligatored': ['VBN'],
  'alligators': ['NNS'],
  'alliteration': ['NN'],
  'alliterative': ['JJ'],
  'allnight': ['JJ'],
  'allocable': ['JJ'],
  'allocate': ['VB'],
  'allocated': ['VBN'],
  'allocates': ['VBZ'],
  'allocating': ['VBG'],
  'allocation': ['NN'],
  'allocations': ['NNS'],
  'allocator': ['NN'],
  'allot': ['VB'],
  'alloted': ['VBN'],
  'allotment': ['NN'],
  'allotments': ['NNS'],
  'allotted': ['VBN'],
  'allotting': ['VBG'],
  'allout': ['JJ'],
  'allow': ['VB'],
  'allowable': ['JJ'],
  'allowance': ['NN'],
  'allowances': ['NNS'],
  'allowed': ['VBN'],
  'allowing': ['VBG'],
  'allows': ['VBZ'],
  'alloy': ['NN'],
  'alloys': ['NNS'],
  'allrightniks': ['NNS'],
  'alltime': ['NN'],
  'alluded': ['VBD'],
  'alludes': ['VBZ'],
  'alluding': ['VBG'],
  'allure': ['NN'],
  'allurement': ['NN'],
  'alluring': ['JJ'],
  'allusion': ['NN'],
  'allusions': ['NNS'],
  'allusiveness': ['NN'],
  'alluvial': ['JJ'],
  'ally': ['NN'],
  'allying': ['VBG'],
  'alma': ['JJ'],
  'almanac': ['NN'],
  'almond': ['NN'],
  'almonds': ['NNS'],
  'almost': ['RB'],
  'almost-industry': ['NN'],
  'aloes': ['NN'],
  'aloft': ['RB'],
  'alone': ['RB'],
  'alone...': [':'],
  'aloneness': ['NN'],
  'along': ['IN'],
  'alongside': ['IN'],
  'aloof': ['JJ'],
  'aloofness': ['NN'],
  'alors': ['FW'],
  'aloud': ['RB'],
  'alpenglow': ['NN'],
  'alpha': ['JJ'],
  'alpha-beta-gammas': ['NNS'],
  'alphabet': ['NN'],
  'alphabetic': ['JJ'],
  'alphabetical': ['JJ'],
  'alphabetically': ['RB'],
  'alphabetized': ['VBD'],
  'alreadeh': ['RB'],
  'already': ['RB'],
  'already-developed': ['JJ'],
  'already-expensive': ['JJ'],
  'already-identified': ['JJ'],
  'already-known': ['JJ'],
  'already-nervous': ['NN'],
  'already-reluctant': ['JJ'],
  'already-shaky': ['JJ'],
  'already-sizable': ['JJ'],
  'already-strained': ['JJ'],
  'already-tense': ['JJ'],
  'alright': ['UH'],
  'also': ['RB'],
  'also-ran': ['NN'],
  'altar': ['NN'],
  'alter': ['VB'],
  'alter-ego': ['NN'],
  'alter-parents': ['NNS'],
  'alteration': ['NN'],
  'alterations': ['NNS'],
  'altercation': ['NN'],
  'altered': ['VBN'],
  'altering': ['VBG'],
  'alternate': ['JJ'],
  'alternated': ['VBD'],
  'alternately': ['RB'],
  'alternates': ['VBZ'],
  'alternating': ['VBG'],
  'alternation': ['NN'],
  'alternative': ['NN'],
  'alternative-energy': ['JJ'],
  'alternative-fueled': ['JJ'],
  'alternative-fuels': ['JJ'],
  'alternative-operator': ['NN'],
  'alternative...': [':'],
  'alternatively': ['RB'],
  'alternatives': ['NNS'],
  'alters': ['VBZ'],
  'altho': ['IN'],
  'although': ['IN'],
  'altitude': ['NN'],
  'altitude-azimuth-mounted': ['JJ'],
  'altitudes': ['NNS'],
  'alto': ['NN'],
  'altogether': ['RB'],
  'altruism': ['NN'],
  'altruistic': ['JJ'],
  'altruistically': ['RB'],
  'altruists': ['NNS'],
  'alum': ['NN'],
  'alumina': ['NN'],
  'aluminum': ['NN'],
  'aluminum-hulled': ['JJ'],
  'aluminum-industry': ['NN'],
  'aluminum-makers': ['NNS'],
  'alumnae': ['NNS'],
  'alumni': ['NNS'],
  'alumnus': ['NN'],
  'alundum': ['NN'],
  'alveolar': ['NN'],
  'alveoli': ['NNS'],
  'alveolus': ['NN'],
  'always': ['RB'],
  'always-present': ['JJ'],
  'am': ['VBP'],
  'amahs': ['NNS'],
  'amalgam': ['NN'],
  'amalgamate': ['VB'],
  'amalgamated': ['VBN'],
  'amalgamation': ['NN'],
  'amalgamations': ['NNS'],
  'amanuensis': ['NN'],
  'amass': ['VB'],
  'amassed': ['VBN'],
  'amasses': ['VBZ'],
  'amassing': ['NN'],
  'amateur': ['NN'],
  'amateurish': ['JJ'],
  'amateurishness': ['NN'],
  'amateurism': ['NN'],
  'amateurs': ['NNS'],
  'amatory': ['JJ'],
  'amaze': ['VB'],
  'amazed': ['VBN'],
  'amazement': ['NN'],
  'amazing': ['JJ'],
  'amazingly': ['RB'],
  'amazons': ['NNS'],
  'ambassador': ['NN'],
  'ambassadors': ['NNS'],
  'amber': ['JJ'],
  'ambiance': ['NN'],
  'ambidextrous': ['JJ'],
  'ambiguities': ['NNS'],
  'ambiguity': ['NN'],
  'ambiguous': ['JJ'],
  'ambition': ['NN'],
  'ambitions': ['NNS'],
  'ambitious': ['JJ'],
  'ambitiously': ['RB'],
  'ambivalence': ['NN'],
  'ambivalent': ['JJ'],
  'amble': ['VB'],
  'ambled': ['VBD'],
  'ambling': ['VBG'],
  'ambrosial': ['JJ'],
  'ambulance': ['NN'],
  'ambulatory': ['JJ'],
  'ambuscade': ['NN'],
  'ambush': ['NN'],
  'ambushed': ['VBD'],
  'amelioration': ['NN'],
  'amen': ['UH'],
  'amenable': ['JJ'],
  'amend': ['VB'],
  'amendatory': ['JJ'],
  'amended': ['VBN'],
  'amending': ['VBG'],
  'amendment': ['NN'],
  'amendments': ['NNS'],
  'amenities': ['NNS'],
  'amethystine': ['JJ'],
  'amiable': ['JJ'],
  'amicable': ['JJ'],
  'amicably': ['RB'],
  'amici': ['FW'],
  'amicus': ['NN'],
  'amid': ['IN'],
  'amide': ['NN'],
  'amidst': ['IN'],
  'amigo': ['FW'],
  'amines': ['NNS'],
  'amino': ['JJ'],
  'amiss': ['JJ'],
  'amity': ['NN'],
  'ammo': ['NN'],
  'ammonia': ['NN'],
  'ammoniac': ['JJ'],
  'ammonium': ['NN'],
  'ammunition': ['NN'],
  'amnesty': ['NN'],
  'amnesty.': ['NN'],
  'amniotic': ['JJ'],
  'amok': ['RB'],
  'among': ['IN'],
  'amongst': ['IN'],
  'amor': ['FW'],
  'amoral': ['JJ'],
  'amorality': ['NN'],
  'amorist': ['NN'],
  'amorous': ['JJ'],
  'amorphous': ['JJ'],
  'amorphously': ['RB'],
  'amortization': ['NN'],
  'amortize': ['VB'],
  'amortized': ['VBN'],
  'amortizing': ['JJ'],
  'amount': ['NN'],
  'amounted': ['VBD'],
  'amounting': ['VBG'],
  'amounts': ['NNS'],
  'amours': ['FW'],
  'amp': ['NN'],
  'amphetamines': ['NNS'],
  'amphibious': ['JJ'],
  'amphibology': ['NN'],
  'amphitheater': ['NN'],
  'amphobiles': ['NNS'],
  'ample': ['JJ'],
  'amplification': ['NN'],
  'amplified': ['VBN'],
  'amplifier': ['NN'],
  'amplifiers': ['NNS'],
  'amplifies': ['VBZ'],
  'amplify': ['VB'],
  'amplifying': ['VBG'],
  'amplitude': ['NN'],
  'amply': ['RB'],
  'amps': ['NNS'],
  'amputated': ['VBN'],
  'amputation': ['NN'],
  'amputations': ['NNS'],
  'amulet': ['NN'],
  'amulets': ['NNS'],
  'amuse': ['VB'],
  'amused': ['VBN'],
  'amusedly': ['RB'],
  'amusement': ['NN'],
  'amusement\\\'/theme': ['NN'],
  'amusements': ['NNS'],
  'amusing': ['JJ'],
  'amusingly': ['RB'],
  'an': ['DT'],
  'an\'advertising': ['DT', 'NN'],
  'anachronism': ['NN'],
  'anachronisms': ['NNS'],
  'anachronistic': ['JJ'],
  'anachronistically': ['RB'],
  'anaconda': ['NN'],
  'anacondas': ['NNS'],
  'anaerobic': ['JJ'],
  'anaesthesia': ['NN'],
  'anagram': ['NN'],
  'analeptic': ['JJ'],
  'analgesic': ['JJ'],
  'analog': ['NN'],
  'analogies': ['NNS'],
  'analogous': ['JJ'],
  'analogously': ['RB'],
  'analogue': ['NN'],
  'analogues': ['NNS'],
  'analogy': ['NN'],
  'analysed': ['VBN'],
  'analyses': ['NNS'],
  'analysis': ['NN'],
  'analyst': ['NN'],
  'analystics': ['NNS'],
  'analysts': ['NNS'],
  'analytic': ['JJ'],
  'analytical': ['JJ'],
  'analytical-instruments': ['JJ'],
  'analytically': ['RB'],
  'analyticity': ['NN'],
  'analyzable': ['JJ'],
  'analyze': ['VB'],
  'analyzed': ['VBN'],
  'analyzer': ['NN'],
  'analyzes': ['VBZ'],
  'analyzing': ['VBG'],
  'anaplasmosis': ['NN'],
  'anaprapath': ['NN'],
  'anarchic': ['JJ'],
  'anarchical': ['JJ'],
  'anarchist': ['NN'],
  'anarchist-adventurers': ['NNS'],
  'anarchy': ['NN'],
  'anastomoses': ['NNS'],
  'anastomosis': ['NN'],
  'anastomotic': ['JJ'],
  'anathema': ['NN'],
  'anatomic': ['JJ'],
  'anatomical': ['JJ'],
  'anatomically': ['RB'],
  'anatomicals': ['NNS'],
  'anatomy': ['NN'],
  'ancestor': ['NN'],
  'ancestors': ['NNS'],
  'ancestral': ['JJ'],
  'ancestry': ['NN'],
  'anchor': ['NN'],
  'anchorage': ['NN'],
  'anchorages': ['NNS'],
  'anchored': ['VBN'],
  'anchoring': ['VBG'],
  'anchorite': ['NN'],
  'anchoritism': ['NN'],
  'anchorman': ['NN'],
  'anchormen': ['NNS'],
  'anchors': ['NNS'],
  'anchorwoman': ['NN'],
  'anchovy': ['NN'],
  'ancient': ['JJ'],
  'anciently': ['RB'],
  'ancients': ['NNS'],
  'ancillary': ['JJ'],
  'and': ['CC'],
  'and\'boiler': ['NN'],
  'and\'divine': ['JJ'],
  'and...': [':'],
  'and\\\'': ['CC'],
  'and\\\'/or': ['NN'],
  'andrenas': ['NNPS'],
  'anecdotal': ['JJ'],
  'anecdote': ['NN'],
  'anecdotes': ['NNS'],
  'anemated': ['VBN'],
  'anemia': ['NN'],
  'anemias': ['NNS'],
  'anemic': ['JJ'],
  'anemics': ['NNS'],
  'anesthetic': ['NN'],
  'anesthetically': ['RB'],
  'anesthetics': ['NNS'],
  'anesthetized': ['JJ'],
  'anew': ['RB'],
  'angel': ['NN'],
  'angelfish': ['NN'],
  'angelic': ['JJ'],
  'angelica': ['NN'],
  'angels': ['NNS'],
  'anger': ['NN'],
  'angered': ['VBN'],
  'angering': ['VBG'],
  'angers': ['VBZ'],
  'angina': ['NN'],
  'angiotensin': ['NN'],
  'angle': ['NN'],
  'angler': ['NN'],
  'angles': ['NNS'],
  'angling': ['VBG'],
  'angora': ['NN'],
  'angriest': ['JJS'],
  'angrily': ['RB'],
  'angry': ['JJ'],
  'angst': ['NN'],
  'anguish': ['NN'],
  'anguished': ['JJ'],
  'angular': ['JJ'],
  'anhemolyticus': ['NN'],
  'anhydrous': ['JJ'],
  'anhydrously': ['RB'],
  'ani': ['JJ'],
  'aniline': ['NN'],
  'animal': ['NN'],
  'animal-based': ['JJ'],
  'animal-health': ['NN'],
  'animal-human': ['NN'],
  'animal-like': ['JJ'],
  'animal-protection': ['NN'],
  'animal-rights': ['NNS'],
  'animalcare': ['JJ'],
  'animals': ['NNS'],
  'animate': ['JJ'],
  'animated': ['JJ'],
  'animates': ['VBZ'],
  'animation': ['NN'],
  'animism': ['NN'],
  'animized': ['VBN'],
  'animosities': ['NNS'],
  'animosity': ['NN'],
  'animosity...': [':'],
  'anion': ['NN'],
  'anionic': ['JJ'],
  'anionics': ['NNS'],
  'anions': ['NNS'],
  'anise': ['NN'],
  'aniseikonic': ['JJ'],
  'anisotropy': ['NN'],
  'ankle': ['NN'],
  'ankle-deep': ['JJ'],
  'ankles': ['NNS'],
  'anlayst': ['NN'],
  'annals': ['NNS'],
  'annee': ['FW'],
  'annex': ['NN'],
  'annexation': ['NN'],
  'annexed': ['VBD'],
  'annihilate': ['VB'],
  'annihilation': ['NN'],
  'anniversaries': ['NNS'],
  'anniversary': ['NN'],
  'annnouncement': ['NN'],
  'annointed': ['VBN'],
  'annotated': ['VBN'],
  'announce': ['VB'],
  'announced': ['VBD'],
  'announced.': ['VBN'],
  'announcement': ['NN'],
  'announcements': ['NNS'],
  'announcer': ['NN'],
  'announcers': ['NNS'],
  'announces': ['VBZ'],
  'announcing': ['VBG'],
  'announcment': ['NN'],
  'annoy': ['VB'],
  'annoyance': ['NN'],
  'annoyances': ['NNS'],
  'annoyed': ['VBN'],
  'annoying': ['JJ'],
  'annoys': ['VBZ'],
  'annual': ['JJ'],
  'annual-income': ['NN'],
  'annualized': ['VBN'],
  'annually': ['RB'],
  'annuities': ['NNS'],
  'annuity': ['NN'],
  'annulled': ['VBD'],
  'annum': ['NN'],
  'annunciated': ['VBN'],
  'anode': ['NN'],
  'anodes': ['NNS'],
  'anoint': ['VB'],
  'anointing': ['VBG'],
  'anomalies': ['NNS'],
  'anomalous': ['JJ'],
  'anomaly': ['NN'],
  'anomic': ['JJ'],
  'anomie': ['FW'],
  'anonymity': ['NN'],
  'anonymous': ['JJ'],
  'anonymously': ['RB'],
  'anorexia': ['NN'],
  'anorthic': ['JJ'],
  'another': ['DT'],
  'another...': [':'],
  'ansuh': ['VB'],
  'answer': ['NN'],
  'answerable': ['JJ'],
  'answered': ['VBD'],
  'answering': ['VBG'],
  'answers': ['NNS'],
  'ant': ['NN'],
  'antacid': ['NN'],
  'antagonised': ['VBN'],
  'antagonism': ['NN'],
  'antagonisms': ['NNS'],
  'antagonist': ['NN'],
  'antagonistic': ['JJ'],
  'antagonists': ['NNS'],
  'antagonize': ['VB'],
  'ante': ['NN'],
  'ante-bellum': ['FW'],
  'anteater': ['NN'],
  'anteaters': ['NNS'],
  'antebellum': ['JJ'],
  'antecedent': ['NN'],
  'antecedents': ['NNS'],
  'antelope': ['NN'],
  'antenna': ['NN'],
  'antennae': ['NNS'],
  'antennas': ['NNS'],
  'anterior': ['JJ'],
  'anteriors': ['NNS'],
  'anthem': ['NN'],
  'anthems': ['NNS'],
  'anthers': ['NNS'],
  'anthology': ['NN'],
  'anthrax': ['NN'],
  'anthropic': ['JJ'],
  'anthropological': ['JJ'],
  'anthropological-religious': ['JJ'],
  'anthropologist': ['NN'],
  'anthropologists': ['NNS'],
  'anthropology': ['NN'],
  'anthropomorphic': ['JJ'],
  'anti': ['IN'],
  'anti-A': ['NNP'],
  'anti-AIDS': ['JJ'],
  'anti-American': ['JJ'],
  'anti-Americanism': ['NN'],
  'anti-B': ['NNP'],
  'anti-Bork': ['JJ'],
  'anti-Castro': ['JJ'],
  'anti-Catholic': ['JJ'],
  'anti-Catholicism': ['NN'],
  'anti-China': ['JJ'],
  'anti-Christian': ['JJ'],
  'anti-Colmer': ['JJ'],
  'anti-Communism': ['NN'],
  'anti-Communist': ['JJ'],
  'anti-Communists': ['NNPS'],
  'anti-European': ['JJ'],
  'anti-Fascist': ['JJ'],
  'anti-French': ['JJ'],
  'anti-Galileo': ['JJ'],
  'anti-Honecker': ['JJ'],
  'anti-Japanese': ['JJ'],
  'anti-Kabul': ['JJ'],
  'anti-Kennedy': ['JJ'],
  'anti-LDP': ['JJ'],
  'anti-Moscow': ['JJ'],
  'anti-NATO': ['JJ'],
  'anti-Nazi': ['JJ'],
  'anti-Nazis': ['NNPS'],
  'anti-Negro': ['JJ'],
  'anti-Newtonian': ['JJ'],
  'anti-Noriega': ['JJ'],
  'anti-Phnom': ['NNP'],
  'anti-Rh': ['NNP'],
  'anti-Sandinista': ['JJ'],
  'anti-Semites': ['NNS'],
  'anti-Semitic': ['JJ'],
  'anti-Semitism': ['NN'],
  'anti-Somoza': ['JJ'],
  'anti-Sony': ['JJ'],
  'anti-South': ['JJ'],
  'anti-Soviet': ['JJ'],
  'anti-Stalinist': ['JJ'],
  'anti-Turkish': ['JJ'],
  'anti-U.S.': ['JJ'],
  'anti-Western': ['JJ'],
  'anti-Yankee': ['JJ'],
  'anti-abortion': ['JJ'],
  'anti-abortionist': ['NN'],
  'anti-abortionists': ['NNS'],
  'anti-acne': ['NN'],
  'anti-aircraft': ['JJ'],
  'anti-airline': ['NN'],
  'anti-airline-takeover': ['JJ'],
  'anti-alcohol': ['JJ'],
  'anti-androgen': ['JJ'],
  'anti-androgens': ['NNS'],
  'anti-anemia': ['NN'],
  'anti-apartheid': ['JJ'],
  'anti-army': ['JJ'],
  'anti-assignment': ['JJ'],
  'anti-authoritarian': ['JJ'],
  'anti-ballistic-missile': ['JJ'],
  'anti-bike': ['JJ'],
  'anti-business': ['JJ'],
  'anti-cancer': ['JJ'],
  'anti-cartel': ['JJ'],
  'anti-choice': ['JJ'],
  'anti-cholesterol': ['JJ'],
  'anti-cigarette': ['JJ'],
  'anti-clericalism': ['JJ'],
  'anti-clotting': ['JJ'],
  'anti-communist': ['JJ'],
  'anti-competitive': ['JJ'],
  'anti-conservation': ['JJ'],
  'anti-contamination': ['JJ'],
  'anti-convulsive': ['JJ'],
  'anti-crime': ['JJ'],
  'anti-debt': ['JJ'],
  'anti-deer': ['JJ'],
  'anti-defense': ['JJ'],
  'anti-democratic': ['JJ'],
  'anti-depressant': ['JJ'],
  'anti-development': ['JJ'],
  'anti-diabetes': ['JJ'],
  'anti-diarrheal': ['JJ'],
  'anti-dilutive': ['JJ'],
  'anti-discrimination': ['JJ'],
  'anti-discriminatory': ['JJ'],
  'anti-drug': ['JJ'],
  'anti-drug-law': ['NN'],
  'anti-dumping': ['JJ'],
  'anti-epilepsy': ['JJ'],
  'anti-epileptic': ['JJ'],
  'anti-extortion': ['NN'],
  'anti-flag-burning': ['JJ'],
  'anti-foreign': ['JJ'],
  'anti-foreigner': ['NN'],
  'anti-fraud': ['JJ'],
  'anti-freeze': ['JJ'],
  'anti-fungal': ['JJ'],
  'anti-gay': ['JJ'],
  'anti-generic': ['JJ'],
  'anti-government': ['JJ'],
  'anti-growth': ['JJ'],
  'anti-heroes': ['NNS'],
  'anti-homosexual': ['JJ'],
  'anti-hooligan': ['JJ'],
  'anti-human': ['JJ'],
  'anti-hypertensive': ['JJ'],
  'anti-idiotypes': ['NNS'],
  'anti-infective': ['JJ'],
  'anti-infectives': ['NNS'],
  'anti-inflation': ['JJ'],
  'anti-inflationary': ['JJ'],
  'anti-intellectual': ['JJ'],
  'anti-intellectualism': ['JJ'],
  'anti-leak': ['JJ'],
  'anti-liquor': ['JJ'],
  'anti-lobbying': ['JJ'],
  'anti-lobbyist': ['NN'],
  'anti-lock': ['JJ'],
  'anti-management': ['JJ'],
  'anti-market': ['JJ'],
  'anti-men': ['JJ'],
  'anti-militarists': ['NNS'],
  'anti-miscarriage': ['JJ'],
  'anti-missile': ['JJ'],
  'anti-monopoly': ['JJ'],
  'anti-morning-sickness': ['JJ'],
  'anti-nausea': ['JJ'],
  'anti-nuclear': ['JJ'],
  'anti-oil': ['JJ'],
  'anti-opera': ['NN'],
  'anti-organization': ['JJ'],
  'anti-outsider': ['NN'],
  'anti-party': ['JJ'],
  'anti-personality': ['JJ'],
  'anti-pesticide': ['JJ'],
  'anti-plaque': ['JJ'],
  'anti-pocketbook': ['JJ'],
  'anti-polio': ['JJ'],
  'anti-pollution': ['JJ'],
  'anti-price-fixing': ['JJ'],
  'anti-productive': ['JJ'],
  'anti-profiteering': ['JJ'],
  'anti-program': ['JJ'],
  'anti-program-trading': ['JJ'],
  'anti-programmers': ['NNS'],
  'anti-prostitution': ['JJ'],
  'anti-psychotic': ['JJ'],
  'anti-racketeering': ['JJ'],
  'anti-recession': ['JJ'],
  'anti-reformers': ['NNS'],
  'anti-rejection': ['JJ'],
  'anti-rightist': ['JJ'],
  'anti-science': ['JJ'],
  'anti-scientific': ['JJ'],
  'anti-secrecy': ['JJ'],
  'anti-seizure': ['JJ'],
  'anti-semite': ['NN'],
  'anti-shock': ['JJ'],
  'anti-shoplifting': ['JJ'],
  'anti-slavery': ['JJ'],
  'anti-smokers': ['NNS'],
  'anti-smoking': ['JJ'],
  'anti-social': ['JJ'],
  'anti-socialist': ['JJ'],
  'anti-state': ['JJ'],
  'anti-statist': ['NN'],
  'anti-submarine': ['JJ'],
  'anti-switching': ['JJ'],
  'anti-takeover': ['JJ'],
  'anti-tax': ['JJ'],
  'anti-tax-shelter': ['JJ'],
  'anti-terrorism': ['JJ'],
  'anti-toxic': ['JJ'],
  'anti-trust': ['JJ'],
  'anti-ulcer': ['JJ'],
  'anti-union': ['JJ'],
  'anti-viral': ['JJ'],
  'anti-virus': ['JJ'],
  'anti-vivisectionists': ['NNS'],
  'anti-war': ['JJ'],
  'anti-war-related': ['JJ'],
  'anti-white': ['JJ'],
  'anti-wrinkling': ['JJ'],
  'antiCommunist': ['JJ'],
  'antiSony': ['JJ'],
  'antianemia': ['JJ'],
  'antibacterial': ['JJ'],
  'antibiotic': ['NN'],
  'antibiotics': ['NNS'],
  'antibodies': ['NNS'],
  'antibody': ['NN'],
  'antibody-based': ['JJ'],
  'antibody-making': ['JJ'],
  'antibody-producing': ['JJ'],
  'antic': ['JJ'],
  'anticipate': ['VB'],
  'anticipated': ['VBN'],
  'anticipates': ['VBZ'],
  'anticipating': ['VBG'],
  'anticipation': ['NN'],
  'anticipations': ['NNS'],
  'anticipatory': ['JJ'],
  'anticoagulant': ['NN'],
  'anticoagulants': ['NNS'],
  'anticoagulation': ['NN'],
  'anticompetitive': ['JJ'],
  'anticorruption': ['NN'],
  'antics': ['NNS'],
  'anticult': ['NN'],
  'anticus': ['NN'],
  'antidepressant': ['NN'],
  'antidote': ['NN'],
  'antifraud': ['NN'],
  'antifreeze': ['NN'],
  'antifundamentalist': ['JJ'],
  'antigen': ['NN'],
  'antihero': ['NN'],
  'antihistamine': ['NN'],
  'antihistorical': ['JJ'],
  'antilock': ['JJ'],
  'antimaterialism': ['NN'],
  'antimissile': ['JJ'],
  'antimonide': ['NN'],
  'antipathies': ['NNS'],
  'antipathy': ['NN'],
  'antiphonal': ['JJ'],
  'antipodes': ['NNS'],
  'antiquarian': ['JJ'],
  'antiquarians': ['NNS'],
  'antiquated': ['JJ'],
  'antique': ['JJ'],
  'antique-car': ['NN'],
  'antiques': ['NNS'],
  'antiquities': ['NNS'],
  'antiquity': ['NN'],
  'antirealistic': ['JJ'],
  'antiredeposition': ['NN'],
  'antiseptic': ['JJ'],
  'antisera': ['NN'],
  'antiserum': ['NN'],
  'antislavery': ['JJ'],
  'antismoking': ['JJ'],
  'antisocial': ['JJ'],
  'antisubmarine': ['JJ'],
  'antitakeover': ['JJR'],
  'antithesis': ['NN'],
  'antithetical': ['JJ'],
  'antithyroid': ['JJ'],
  'antitrust': ['JJ'],
  'antitrust-law': ['JJ'],
  'antiviral': ['JJ'],
  'antiwar': ['JJ'],
  'ants': ['NNS'],
  'antsy': ['JJ'],
  'anvil': ['NN'],
  'anxieties': ['NNS'],
  'anxiety': ['NN'],
  'anxiety-free': ['JJ'],
  'anxiety-released': ['NN'],
  'anxious': ['JJ'],
  'anxiously': ['RB'],
  'any': ['DT'],
  'anybody': ['NN'],
  'anye': ['JJ'],
  'anyhow': ['RB'],
  'anylabel': ['NN'],
  'anymore': ['RB'],
  'anyone': ['NN'],
  'anyplace': ['RB'],
  'anythin': ['NN'],
  'anything': ['NN'],
  'anytime': ['RB'],
  'anyway': ['RB'],
  'anyways': ['UH'],
  'anywhere': ['RB'],
  'aorta': ['NN'],
  'apace': ['RB'],
  'aparently': ['RB'],
  'apart': ['RB'],
  'apartheid': ['NN'],
  'apartment': ['NN'],
  'apartment-building': ['NN'],
  'apartments': ['NNS'],
  'apathetic': ['JJ'],
  'apathy': ['NN'],
  'ape': ['NN'],
  'aperture': ['NN'],
  'apex': ['NN'],
  'aphorisms': ['NNS'],
  'apiece': ['RB'],
  'aping': ['VBG'],
  'aplenty': ['JJ'],
  'aplomb': ['NN'],
  'apocalypse': ['NN'],
  'apocalyptic': ['JJ'],
  'apocalyptics': ['NNS'],
  'apocryphal': ['JJ'],
  'apogee': ['NN'],
  'apologetic': ['JJ'],
  'apologetically': ['RB'],
  'apologies': ['NNS'],
  'apologist': ['NN'],
  'apologists': ['NNS'],
  'apologize': ['VB'],
  'apologized': ['VBD'],
  'apologizes': ['VBZ'],
  'apologizing': ['VBG'],
  'apology': ['NN'],
  'apoplectic': ['JJ'],
  'apostates': ['NNS'],
  'apostle': ['NN'],
  'apostles': ['NNS'],
  'apostolic': ['JJ'],
  'apothecary': ['NN'],
  'apotheosis': ['NN'],
  'app': ['NN'],
  'appall': ['VBP'],
  'appalled': ['VBN'],
  'appalling': ['JJ'],
  'appallingly': ['RB'],
  'appalls': ['VBZ'],
  'appanage': ['NN'],
  'apparat': ['NN'],
  'apparatchiks': ['FW'],
  'apparatus': ['NN'],
  'apparel': ['NN'],
  'apparel-maker': ['NN'],
  'appareled': ['VBN'],
  'apparency': ['NN'],
  'apparent': ['JJ'],
  'apparently': ['RB'],
  'apparition': ['NN'],
  'apparitions': ['NNS'],
  'appartus': ['NN'],
  'appeal': ['NN'],
  'appealed': ['VBD'],
  'appealing': ['JJ'],
  'appeals': ['NNS'],
  'appeals-court': ['NN'],
  'appeals.': ['NNS'],
  'appear': ['VB'],
  'appearance': ['NN'],
  'appearances': ['NNS'],
  'appeared': ['VBD'],
  'appearin': ['VBG'],
  'appearing': ['VBG'],
  'appears': ['VBZ'],
  'appease': ['VB'],
  'appeased': ['VBN'],
  'appeasement': ['NN'],
  'appeasing': ['NN'],
  'appellant': ['FW'],
  'appellate': ['JJ'],
  'appellate-court': ['NN'],
  'appellate-litigation': ['NN', 'JJ'],
  'append': ['VB'],
  'appendages': ['NNS'],
  'appended': ['VBN'],
  'appestat': ['NN'],
  'appetite': ['NN'],
  'appetites': ['NNS'],
  'appetizer': ['NN'],
  'appetizing': ['JJ'],
  'applaud': ['VBP'],
  'applauded': ['VBD'],
  'applauding': ['VBG'],
  'applauds': ['VBZ'],
  'applause': ['NN'],
  'applause-happy': ['JJ'],
  'apple': ['NN'],
  'apple-flavored': ['JJ'],
  'apple-industry': ['NN'],
  'apple-pie': ['NN'],
  'apple-tree': ['NN'],
  'applejack': ['NN'],
  'applelike': ['JJ'],
  'apples': ['NNS'],
  'appliance': ['NN'],
  'appliance-controls': ['NN'],
  'appliances': ['NNS'],
  'applicability': ['NN'],
  'applicable': ['JJ'],
  'applicant': ['NN'],
  'applicants': ['NNS'],
  'application': ['NN'],
  'applications': ['NNS'],
  'applicator': ['NN'],
  'applicators': ['NNS'],
  'applied': ['VBN'],
  'applies': ['VBZ'],
  'appliques': ['NNS'],
  'apply': ['VB'],
  'applying': ['VBG'],
  'appoint': ['VB'],
  'appointed': ['VBN'],
  'appointee': ['NN'],
  'appointees': ['NNS'],
  'appointing': ['VBG'],
  'appointment': ['NN'],
  'appointments': ['NNS'],
  'appoints': ['VBZ'],
  'apportion': ['VB'],
  'apportioned': ['VBN'],
  'apportionment': ['NN'],
  'apportionments': ['NNS'],
  'appraisal': ['NN'],
  'appraisals': ['NNS'],
  'appraise': ['VB'],
  'appraised': ['VBN'],
  'appraiser': ['NN'],
  'appraisers': ['NNS'],
  'appraising': ['VBG'],
  'appraisingly': ['RB'],
  'appreciable': ['JJ'],
  'appreciably': ['RB'],
  'appreciate': ['VB'],
  'appreciated': ['VBN'],
  'appreciates': ['VBZ'],
  'appreciating': ['VBG'],
  'appreciation': ['NN'],
  'appreciations': ['NNS'],
  'appreciative': ['JJ'],
  'appreciatively': ['RB'],
  'apprehend': ['VB'],
  'apprehended': ['VBN'],
  'apprehending': ['VBG'],
  'apprehension': ['NN'],
  'apprehensions': ['NNS'],
  'apprehensive': ['JJ'],
  'apprehensively': ['RB'],
  'apprentice': ['NN'],
  'apprenticed': ['VBN'],
  'apprentices': ['NNS'],
  'apprenticeship': ['NN'],
  'apprised': ['VBN'],
  'approach': ['NN'],
  'approachable': ['JJ'],
  'approached': ['VBD'],
  'approaches': ['NNS'],
  'approaching': ['VBG'],
  'appropriate': ['JJ'],
  'appropriated': ['VBN'],
  'appropriately': ['RB'],
  'appropriateness': ['NN'],
  'appropriates': ['VBZ'],
  'appropriating': ['VBG'],
  'appropriation': ['NN'],
  'appropriations': ['NNS'],
  'appropriators': ['NNS'],
  'approval': ['NN'],
  'approvals': ['NNS'],
  'approve': ['VB'],
  'approved': ['VBD'],
  'approves': ['VBZ'],
  'approving': ['VBG'],
  'approvingly': ['RB'],
  'approximate': ['JJ'],
  'approximated': ['VBN'],
  'approximately': ['RB'],
  'approximates': ['VBZ'],
  'approximation': ['NN'],
  'approximations': ['NNS'],
  'apricot': ['NN'],
  'april': ['NNP'],
  'apron': ['NN'],
  'aprons': ['NNS'],
  'apses': ['NNS'],
  'apt': ['JJ'],
  'aptitude': ['NN'],
  'aptitudes': ['NNS'],
  'aptly': ['RB'],
  'aptness': ['NN'],
  'aqua-lung': ['NN'],
  'aquam': ['FW'],
  'aquamarine': ['NN'],
  'aquarium': ['NN'],
  'aquatic': ['JJ'],
  'aqueducts': ['NNS'],
  'aqueous': ['JJ'],
  'aquifer': ['NN'],
  'aquifers': ['NNS'],
  'aquisition': ['NN'],
  'aquisitions': ['NNS'],
  'arabesque': ['NN'],
  'arabic': ['JJ'],
  'arable': ['JJ'],
  'arak': ['FW'],
  'aramid': ['NN'],
  'arb': ['NN'],
  'arbiter': ['NN'],
  'arbitrage': ['NN'],
  'arbitrage-related': ['JJ'],
  'arbitrage``': ['``'],
  'arbitrager': ['NN'],
  'arbitragers': ['NNS'],
  'arbitrageur': ['NN'],
  'arbitrageurs': ['NNS'],
  'arbitraging': ['VBG'],
  'arbitrarily': ['RB'],
  'arbitrary': ['JJ'],
  'arbitrate': ['VB'],
  'arbitrated': ['VBN'],
  'arbitrates': ['VBZ'],
  'arbitrating': ['VBG'],
  'arbitration': ['NN'],
  'arbitration-eligibility': ['NN'],
  'arbitration.': ['NN'],
  'arbitrator': ['NN'],
  'arbitrators': ['NNS'],
  'arboreal': ['JJ'],
  'arborists': ['NNS'],
  'arbs': ['NNS'],
  'arc': ['NN'],
  'arcade': ['NN'],
  'arcaded': ['JJ'],
  'arcades': ['NNS'],
  'arcane': ['JJ'],
  'arch': ['NN'],
  'arch-enemy': ['NN'],
  'arch-heretic': ['NN'],
  'arch-opponent': ['NN'],
  'arch-rival': ['JJ'],
  'archaeological': ['JJ'],
  'archaeologist': ['NN'],
  'archaeologists': ['NNS'],
  'archaeology': ['NN'],
  'archaic': ['JJ'],
  'archaism': ['NN'],
  'archaized': ['VBD'],
  'archangels': ['NNS'],
  'archbishop': ['NN'],
  'archdiocese': ['NN'],
  'arched': ['JJ'],
  'archenemy': ['NN'],
  'archeological': ['JJ'],
  'archery': ['NN'],
  'arches': ['NNS'],
  'archetype': ['NN'],
  'archetypes': ['NNS'],
  'archetypical': ['JJ'],
  'archfool': ['NN'],
  'arching': ['VBG'],
  'archipelago': ['NN'],
  'architect': ['NN'],
  'architect-developer': ['NN'],
  'architectonic': ['JJ'],
  'architects': ['NNS'],
  'architectural': ['JJ'],
  'architecturally': ['RB'],
  'architecture': ['NN'],
  'architectures': ['NNS'],
  'archival': ['JJ'],
  'archive': ['NN'],
  'archives': ['NNS'],
  'archivist': ['NN'],
  'archness': ['NN'],
  'archrival': ['JJ'],
  'archtype': ['NN'],
  'arclike': ['JJ'],
  'arcs': ['NNS'],
  'arctic': ['JJ'],
  'arcus': ['NN'],
  'ardent': ['JJ'],
  'ardently': ['RB'],
  'ardor': ['NN'],
  'arduous': ['JJ'],
  'are': ['VBP'],
  'are...': [':'],
  'area': ['NN'],
  'area-code': ['JJ'],
  'area-sales': ['JJ'],
  'area-wide': ['JJ'],
  'areas': ['NNS'],
  'areaways': ['NNS'],
  'aren\'t': ['VB'],
  'arena': ['NN'],
  'arenas': ['NNS'],
  'areosol': ['NN'],
  'argon': ['NN'],
  'argot': ['NN'],
  'argriculture': ['NN'],
  'arguably': ['RB'],
  'argue': ['VBP'],
  'argued': ['VBD'],
  'argues': ['VBZ'],
  'argues...': [':'],
  'arguing': ['VBG'],
  'argument': ['NN'],
  'argumentation': ['NN'],
  'arguments': ['NNS'],
  'aria': ['NN'],
  'arias': ['NNS'],
  'arid': ['JJ'],
  'aridity': ['NN'],
  'arise': ['VB'],
  'arisen': ['VBN'],
  'arises': ['VBZ'],
  'arising': ['VBG'],
  'aristocracy': ['NN'],
  'aristocrat': ['NN'],
  'aristocratic': ['JJ'],
  'aristocratically': ['RB'],
  'aristocrats': ['NNS'],
  'arithmetic': ['NN'],
  'arithmetical': ['JJ'],
  'arithmetized': ['VBN'],
  'arkylbenzene': ['NN'],
  'arm': ['NN'],
  'arm-elevation': ['NN'],
  'arm-levitation': ['NN'],
  'arm-rise': ['NN'],
  'arm-twisting': ['NNP'],
  'armadillo': ['NN'],
  'armadillos': ['NNS'],
  'armament': ['NN'],
  'armaments': ['NNS'],
  'armata': ['NNP'],
  'armchair': ['NN'],
  'armchairs': ['NNS'],
  'armed': ['VBN'],
  'armful': ['NN'],
  'armhole': ['NN'],
  'armies': ['NNS'],
  'arming': ['NN'],
  'armistice': ['NN'],
  'armload': ['NN'],
  'armoire': ['NN'],
  'armor': ['NN'],
  'armored': ['JJ'],
  'armored-vehicle': ['JJ'],
  'armory': ['NN'],
  'armpit': ['NN'],
  'armpits': ['NNS'],
  'arms': ['NNS'],
  'arms-control': ['NN'],
  'arms-export': ['JJ'],
  'arms-kickback': ['NN'],
  'arms-making': ['NN'],
  'arms-production': ['NN'],
  'arms-reduction': ['NN'],
  'arms-sales': ['JJ'],
  'army': ['NN'],
  'arnica': ['NN'],
  'aroma': ['NN'],
  'aromas': ['NNS'],
  'aromatic': ['JJ'],
  'aromatick': ['JJ'],
  'aromatics': ['NNS'],
  'arose': ['VBD'],
  'around': ['IN'],
  'around-the-clock': ['JJ'],
  'around-the-world': ['JJ'],
  'around...': [':'],
  'arousal': ['JJ'],
  'arouse': ['VB'],
  'aroused': ['VBN'],
  'arouses': ['VBZ'],
  'arousing': ['VBG'],
  'arpeggios': ['NNS'],
  'arraigned': ['VBD'],
  'arraigning': ['VBG'],
  'arrange': ['VB'],
  'arranged': ['VBN'],
  'arrangement': ['NN'],
  'arrangements': ['NNS'],
  'arrangers': ['NNS'],
  'arranges': ['VBZ'],
  'arranging': ['VBG'],
  'array': ['NN'],
  'arrayed': ['VBN'],
  'arrays': ['NNS'],
  'arrearage': ['NN'],
  'arrearages': ['NNS'],
  'arrears': ['NNS'],
  'arrest': ['NN'],
  'arrested': ['VBN'],
  'arresting': ['VBG'],
  'arrests': ['NNS'],
  'arrival': ['NN'],
  'arrivals': ['NNS'],
  'arrive': ['VB'],
  'arrived': ['VBD'],
  'arrives': ['VBZ'],
  'arriving': ['VBG'],
  'arrogance': ['NN'],
  'arrogant': ['JJ'],
  'arrogantly': ['RB'],
  'arrogate': ['VB'],
  'arrogating': ['VBG'],
  'arrow': ['NN'],
  'arrowed': ['JJ'],
  'arrowheads': ['NNS'],
  'arrows': ['NNS'],
  'arroyo': ['NN'],
  'arsenal': ['NN'],
  'arsenals': ['NNS'],
  'arsenic': ['NN'],
  'arsenide': ['NN'],
  'arside': ['NN'],
  'arsines': ['NNS'],
  'arson': ['NN'],
  'arsonist': ['NN'],
  'art': ['NN'],
  'art-acquisition': ['JJ'],
  'art-auction': ['NN'],
  'art-dealing': ['JJ'],
  'art-filled': ['JJ'],
  'art-historian': ['NN'],
  'art-historical': ['JJ'],
  'art-nouveau': ['JJ'],
  'art-shop': ['NN'],
  'art-world': ['NN'],
  'artemisia': ['NN'],
  'arterial': ['JJ'],
  'arteries': ['NNS'],
  'arteriolar': ['JJ'],
  'arteriolar-pulmonary': ['JJ'],
  'arterioles': ['NNS'],
  'arteriolosclerosis': ['NN'],
  'arteriosclerosis': ['NN'],
  'artery': ['NN'],
  'artery-clogging': ['NN'],
  'artery-pulmonary': ['NN'],
  'artful': ['JJ'],
  'artfully': ['RB'],
  'artfulness': ['NN'],
  'arthritic': ['JJ'],
  'arthritis': ['NN'],
  'artichoke': ['NN'],
  'article': ['NN'],
  'articles': ['NNS'],
  'articulate': ['JJ'],
  'articulated': ['VBN'],
  'articulation': ['NN'],
  'articulations': ['NNS'],
  'artifact': ['NN'],
  'artifacts': ['NNS'],
  'artifical': ['JJ'],
  'artifically': ['RB'],
  'artifice': ['NN'],
  'artificial': ['JJ'],
  'artificial-heart': ['JJ'],
  'artificiality': ['NN'],
  'artificially': ['RB'],
  'artillerist': ['NN'],
  'artillerists': ['NNS'],
  'artillery': ['NN'],
  'artisan': ['NN'],
  'artisans': ['NNS'],
  'artist': ['NN'],
  'artist-author': ['NN'],
  'artist-nature': ['NN'],
  'artistas': ['NNS'],
  'artistic': ['JJ'],
  'artistically': ['RB'],
  'artistry': ['NN'],
  'artists': ['NNS'],
  'artless': ['JJ'],
  'arts': ['NNS'],
  'artsy': ['JJ'],
  'artwork': ['NN'],
  'artworks': ['NNS'],
  'arty': ['JJ'],
  'aryl': ['NN'],
  'arylesterase': ['NN'],
  'arylesterases': ['NNS'],
  'as': ['IN'],
  'as\'housing': ['VBG'],
  'as-Sa\'dawi': ['NNP'],
  'as-it-were': ['RB'],
  'as-yet': ['RB'],
  'asbestos': ['NN'],
  'asbestos-abatement': ['JJ'],
  'asbestos-containing': ['JJ'],
  'asbestos-disease': ['NN'],
  'asbestos-related': ['JJ'],
  'asbestos-removal': ['NN'],
  'asbestosis': ['NN'],
  'ascend': ['VB'],
  'ascendancy': ['NN'],
  'ascended': ['VBD'],
  'ascendency': ['NN'],
  'ascending': ['VBG'],
  'ascension': ['NN'],
  'ascent': ['NN'],
  'ascents': ['NNS'],
  'ascertain': ['VB'],
  'ascertainable': ['JJ'],
  'ascertained': ['VBN'],
  'ascetic': ['NN'],
  'asceticism': ['NN'],
  'ascetics': ['NNS'],
  'ascribe': ['VBP'],
  'ascribed': ['VBN'],
  'ascribes': ['VBZ'],
  'aseptic': ['JJ'],
  'aseptically': ['RB'],
  'ash': ['NN'],
  'ash-blonde': ['JJ'],
  'asham': ['JJ'],
  'ashamed': ['JJ'],
  'ashare': ['NN'],
  'ashen': ['JJ'],
  'ashes': ['NNS'],
  'ashore': ['RB'],
  'ashtrays': ['NNS'],
  'aside': ['RB'],
  'asides': ['NNS'],
  'asinine': ['JJ'],
  'ask': ['VB'],
  'askance': ['RB'],
  'asked': ['VBD'],
  'asked...': [':'],
  'askew': ['RB'],
  'askin': ['VBG'],
  'asking': ['VBG'],
  'asks': ['VBZ'],
  'asleep': ['RB'],
  'asocial': ['JJ'],
  'asparagus': ['NN'],
  'aspect': ['NN'],
  'aspects': ['NNS'],
  'aspen': ['NN'],
  'aspens': ['NNS'],
  'aspersion': ['NN'],
  'aspersions': ['NNS'],
  'asphalt': ['NN'],
  'asphalt-hard': ['JJ'],
  'asphyxia': ['NN'],
  'aspirant': ['NN'],
  'aspirants': ['NNS'],
  'aspiration': ['NN'],
  'aspirational': ['JJ'],
  'aspirations': ['NNS'],
  'aspire': ['VB'],
  'aspired': ['VBD'],
  'aspires': ['VBZ'],
  'aspirin': ['NN'],
  'aspiring': ['JJ'],
  'ass': ['NN'],
  'assai': ['FW'],
  'assail': ['VB'],
  'assailant': ['NN'],
  'assailants': ['NNS'],
  'assailed': ['VBN'],
  'assailing': ['VBG'],
  'assails': ['VBZ'],
  'assassin': ['NN'],
  'assassinate': ['VB'],
  'assassinated': ['VBN'],
  'assassinating': ['VBG'],
  'assassination': ['NN'],
  'assassinations': ['NNS'],
  'assassins': ['NNS'],
  'assault': ['NN'],
  'assault-weapons': ['JJ'],
  'assaulted': ['VBD'],
  'assaulting': ['VBG'],
  'assaults': ['NNS'],
  'assay': ['NN'],
  'assayed': ['VBN'],
  'assaying': ['VBG'],
  'assays': ['NNS'],
  'asseet': ['NN'],
  'assemblage': ['NN'],
  'assemblages': ['NNS'],
  'assemble': ['VB'],
  'assembled': ['VBN'],
  'assembles': ['VBZ'],
  'assemblies': ['NNS'],
  'assembling': ['VBG'],
  'assembly': ['NN'],
  'assembly-line': ['NN'],
  'assent': ['NN'],
  'assented': ['VBD'],
  'assert': ['VB'],
  'asserted': ['VBD'],
  'assertedly': ['RB'],
  'asserting': ['VBG'],
  'assertion': ['NN'],
  'assertions': ['NNS'],
  'assertive': ['JJ'],
  'assertiveness': ['NN'],
  'asserts': ['VBZ'],
  'asses': ['NNS'],
  'assesment': ['NN'],
  'assess': ['VB'],
  'assessed': ['VBN'],
  'assesses': ['VBZ'],
  'assessing': ['VBG'],
  'assessment': ['NN'],
  'assessments': ['NNS'],
  'assessor': ['NN'],
  'assessories': ['NNS'],
  'assessors': ['NNS'],
  'asset': ['NN'],
  'asset-allocation': ['JJ'],
  'asset-backed': ['JJ'],
  'asset-based': ['JJ'],
  'asset-forfeiture': ['NN'],
  'asset-growth': ['NN'],
  'asset-liability': ['JJ'],
  'asset-management': ['NN'],
  'asset-quality': ['JJ'],
  'asset-rich': ['JJ'],
  'asset-sale': ['JJ'],
  'asset-stripping': ['JJ'],
  'asset-trading': ['NN'],
  'asset-valuation': ['NN'],
  'assets': ['NNS'],
  'assets*': ['NNS'],
  'assiduity': ['NN'],
  'assiduously': ['RB'],
  'assign': ['VB'],
  'assigned': ['VBN'],
  'assigned-risk': ['NN'],
  'assignee': ['NN'],
  'assigning': ['VBG'],
  'assignment': ['NN'],
  'assignments': ['NNS'],
  'assigns': ['VBZ'],
  'assimilable': ['JJ'],
  'assimilate': ['VB'],
  'assimilated': ['VBN'],
  'assimilating': ['VBG'],
  'assimilation': ['NN'],
  'assist': ['VB'],
  'assistance': ['NN'],
  'assistant': ['NN'],
  'assistants': ['NNS'],
  'assisted': ['VBN'],
  'assisted-living': ['JJ'],
  'assisting': ['VBG'],
  'assists': ['VBZ'],
  'associaitons': ['NNS'],
  'associate': ['JJ'],
  'associate-label': ['JJ'],
  'associated': ['VBN'],
  'associates': ['NNS'],
  'associating': ['VBG'],
  'association': ['NN'],
  'association...': [':'],
  'associations': ['NNS'],
  'associatively': ['RB'],
  'assorted': ['JJ'],
  'assortment': ['NN'],
  'assortments': ['NNS'],
  'assuage': ['VB'],
  'assuaged': ['VBN'],
  'assuaging': ['VBG'],
  'assume': ['VB'],
  'assumed': ['VBN'],
  'assumes': ['VBZ'],
  'assuming': ['VBG'],
  'assumption': ['NN'],
  'assumptions': ['NNS'],
  'assurance': ['NN'],
  'assurances': ['NNS'],
  'assure': ['VB'],
  'assured': ['VBN'],
  'assuredly': ['RB'],
  'assures': ['VBZ'],
  'assuring': ['VBG'],
  'ast': ['JJ'],
  'asterisks': ['NNS'],
  'asteroid': ['JJ'],
  'asteroids': ['NNS'],
  'asters': ['NNS'],
  'asthma': ['NN'],
  'astigmatism': ['NN'],
  'astir': ['JJ'],
  'astonished': ['VBN'],
  'astonishing': ['JJ'],
  'astonishingly': ['RB'],
  'astonishment': ['NN'],
  'astound': ['VB'],
  'astounded': ['VBN'],
  'astounding': ['JJ'],
  'astoundingly': ['RB'],
  'astounds': ['VBZ'],
  'astral': ['JJ'],
  'astray': ['RB'],
  'astride': ['IN'],
  'astringency': ['NN'],
  'astringent': ['JJ'],
  'astrological': ['JJ'],
  'astrology': ['NN'],
  'astronaut': ['NN'],
  'astronauts': ['NNS'],
  'astronomer': ['NN'],
  'astronomical': ['JJ'],
  'astronomically': ['RB'],
  'astronomy': ['NN'],
  'astrophysicist': ['NN'],
  'astrophysics': ['NNS'],
  'astute': ['JJ'],
  'astuteness': ['NN'],
  'asunder': ['RB'],
  'asw': ['NN'],
  'asylum': ['NN'],
  'asymmetric': ['JJ'],
  'asymmetrically': ['RB'],
  'asymmetry': ['NN'],
  'asymptomatic': ['JJ'],
  'asymptotic': ['JJ'],
  'asymptotically': ['RB'],
  'asynchrony': ['NN'],
  'at': ['IN'],
  'at-bat': ['NN'],
  'at-bats': ['NNS'],
  'at-home': ['JJ'],
  'at-large': ['JJ'],
  'at-market': ['JJ'],
  'at-risk': ['JJ'],
  'atCrcial': ['NNP'],
  'atavistic': ['JJ'],
  'ataxia': ['NN'],
  'ate': ['VBD'],
  'atelier': ['NN'],
  'atheism': ['NN'],
  'atheist': ['JJ'],
  'atheistic': ['JJ'],
  'atheists': ['NNS'],
  'atheromatous': ['JJ'],
  'athlete': ['NN'],
  'athlete-payoff': ['JJ'],
  'athlete-s': ['NN'],
  'athlete-student': ['NN'],
  'athletes': ['NNS'],
  'athletic': ['JJ'],
  'athletic-shoe': ['JJ'],
  'athletically': ['RB'],
  'athleticism': ['NN'],
  'athletics': ['NNS'],
  'atm': ['NN'],
  'atmosphere': ['NN'],
  'atmospheres': ['NNS'],
  'atmospheric': ['JJ'],
  'atolls': ['NNS'],
  'atom': ['NN'],
  'atom-like': ['JJ'],
  'atom-smashing': ['NN'],
  'atomic': ['JJ'],
  'atomisation': ['NN'],
  'atoms': ['NNS'],
  'atonal': ['JJ'],
  'atonally': ['RB'],
  'atone': ['VB'],
  'atonement': ['NN'],
  'atop': ['IN'],
  'atrium': ['NN'],
  'atrocious': ['JJ'],
  'atrociously': ['RB'],
  'atrocities': ['NNS'],
  'atrocity': ['NN'],
  'atrophic': ['JJ'],
  'atrophied': ['VBN'],
  'atrophy': ['NN'],
  'atrun': ['JJ'],
  'att': ['IN'],
  'attach': ['VB'],
  'attache': ['NN'],
  'attached': ['VBN'],
  'attaches': ['VBZ'],
  'attaching': ['VBG'],
  'attachment': ['NN'],
  'attachments': ['NNS'],
  'attack': ['NN'],
  'attacked': ['VBN'],
  'attacker': ['NN'],
  'attackers': ['NNS'],
  'attacking': ['VBG'],
  'attacks': ['NNS'],
  'attacks.': ['NN'],
  'attactive': ['JJ'],
  'attain': ['VB'],
  'attainable': ['JJ'],
  'attained': ['VBD'],
  'attaining': ['VBG'],
  'attainment': ['NN'],
  'attainments': ['NNS'],
  'attains': ['VBZ'],
  'attarcks': ['NNS'],
  'attempt': ['NN'],
  'attempted': ['VBD'],
  'attempting': ['VBG'],
  'attempts': ['NNS'],
  'attend': ['VB'],
  'attendance': ['NN'],
  'attendant': ['NN'],
  'attendants': ['NNS'],
  'attended': ['VBD'],
  'attendee': ['NN'],
  'attendees': ['NNS'],
  'attendent': ['NN'],
  'attendents': ['NNS'],
  'attending': ['VBG'],
  'attends': ['VBZ'],
  'attention': ['NN'],
  'attention-grabbing': ['JJ'],
  'attention...': [':'],
  'attentions': ['NNS'],
  'attentive': ['JJ'],
  'attentively': ['RB'],
  'attest': ['VB'],
  'attested': ['VBN'],
  'attesting': ['VBG'],
  'attests': ['VBZ'],
  'attic': ['NN'],
  'attics': ['NNS'],
  'attire': ['NN'],
  'attired': ['JJ'],
  'attis': ['NN'],
  'attitude': ['NN'],
  'attitudes': ['NNS'],
  'attitudinizing': ['NN'],
  'attorney': ['NN'],
  'attorney-client': ['JJ'],
  'attorney-consultant': ['NN'],
  'attorney-disciplinary': ['JJ'],
  'attorneys': ['NNS'],
  'attract': ['VB'],
  'attractant': ['NN'],
  'attracted': ['VBN'],
  'attracting': ['VBG'],
  'attraction': ['NN'],
  'attractions': ['NNS'],
  'attractive': ['JJ'],
  'attractively': ['RB'],
  'attractiveness': ['NN'],
  'attracts': ['VBZ'],
  'attributable': ['JJ'],
  'attribute': ['VBP'],
  'attributed': ['VBD'],
  'attributes': ['NNS'],
  'attributing': ['VBG'],
  'attributions': ['NNS'],
  'attrition': ['NN'],
  'attuned': ['VBN'],
  'atune': ['NN'],
  'atypical': ['JJ'],
  'au': ['FW'],
  'auburn': ['JJ'],
  'auction': ['NN'],
  'auction-fee': ['JJ'],
  'auction-house': ['NN'],
  'auctioned': ['VBN'],
  'auctioneer': ['NN'],
  'auctioning': ['NN'],
  'auctions': ['NNS'],
  'audacious': ['JJ'],
  'audacity': ['NN'],
  'audible': ['JJ'],
  'audibly': ['RB'],
  'audience': ['NN'],
  'audience-friendly': ['JJ'],
  'audiences': ['NNS'],
  'audio': ['JJ'],
  'audio-specialty': ['NN'],
  'audio-visual': ['JJ'],
  'audio\\\'/visual': ['JJ'],
  'audiocassettes': ['NNS'],
  'audiophiles': ['NNS'],
  'audiotex': ['NN'],
  'audiovisual': ['JJ'],
  'audit': ['NN'],
  'audited': ['VBN'],
  'auditing': ['NN'],
  'audition': ['NN'],
  'auditioning': ['VBG'],
  'auditions': ['NNS'],
  'auditor': ['NN'],
  'auditor-general': ['NN'],
  'auditorium': ['NN'],
  'auditors': ['NNS'],
  'audits': ['NN'],
  'audivi': ['FW'],
  'auf': ['FW'],
  'augen': ['FW'],
  'augment': ['VB'],
  'augmented': ['VBN'],
  'augmenting': ['VBG'],
  'augur': ['VBP'],
  'augurs': ['VBZ'],
  'august': ['JJ'],
  'aujourd\'hui': ['FW'],
  'aunt': ['NN'],
  'aunts': ['NNS'],
  'aura': ['NN'],
  'aural': ['JJ'],
  'aurally': ['RB'],
  'aureus': ['NN'],
  'auspices': ['NNS'],
  'auspicious': ['JJ'],
  'auspiciously': ['RB'],
  'austere': ['JJ'],
  'austerely': ['RB'],
  'austerity': ['NN'],
  'authentic': ['JJ'],
  'authentically': ['RB'],
  'authenticate': ['VBP'],
  'authentication': ['NN'],
  'authentications': ['NNS'],
  'authenticator': ['NN'],
  'authenticity': ['NN'],
  'author': ['NN'],
  'authored': ['VBN'],
  'authoring': ['VBG'],
  'authoritarian': ['JJ'],
  'authoritarianism': ['NN'],
  'authoritative': ['JJ'],
  'authoritatively': ['RB'],
  'authorities': ['NNS'],
  'authority': ['NN'],
  'authorization': ['NN'],
  'authorizations': ['NNS'],
  'authorize': ['VB'],
  'authorized': ['VBN'],
  'authorizes': ['VBZ'],
  'authorizing': ['VBG'],
  'authors': ['NNS'],
  'authorship': ['NN'],
  'autions': ['NNS'],
  'autism': ['NN'],
  'autistic': ['JJ'],
  'auto': ['NN'],
  'auto-assembly': ['NN'],
  'auto-buying': ['NN'],
  'auto-dealer': ['NN'],
  'auto-emission': ['NN'],
  'auto-emissions': ['NNS'],
  'auto-financing': ['NN'],
  'auto-immune': ['JJ'],
  'auto-industry': ['NN'],
  'auto-insurance': ['NN'],
  'auto-limitation': ['NN'],
  'auto-loaders': ['NNS'],
  'auto-loan': ['JJ'],
  'auto-maker': ['NN'],
  'auto-making': ['NN'],
  'auto-market': ['NN'],
  'auto-obscuria': ['NN'],
  'auto-parts': ['JJ'],
  'auto-repair': ['JJ'],
  'auto-safety': ['JJ'],
  'auto-sales': ['NNS'],
  'auto-strop': ['JJ'],
  'auto\\\'/homeowners': ['NNS'],
  'autobiographic': ['JJ'],
  'autobiographical': ['JJ'],
  'autobiography': ['NN'],
  'autoclave': ['NN'],
  'autocollimator': ['NN'],
  'autocracies': ['NNS'],
  'autocracy': ['NN'],
  'autocrat': ['NN'],
  'autocratic': ['JJ'],
  'autocrats': ['NNS'],
  'autofluorescence': ['NN'],
  'autograph': ['NN'],
  'autographed': ['VBN'],
  'autographer': ['NN'],
  'autographs': ['NNS'],
  'autoimmune': ['JJ'],
  'autoloader': ['NN'],
  'automaker': ['NN'],
  'automakers': ['NNS'],
  'automate': ['VB'],
  'automated': ['VBN'],
  'automated-pit-trading': ['NN'],
  'automated-quotation': ['NN'],
  'automated-teller': ['JJ'],
  'automated-teller-machine': ['JJ'],
  'automated-trading': ['NN'],
  'automates': ['VBZ'],
  'automatic': ['JJ'],
  'automatically': ['RB'],
  'automating': ['VBG'],
  'automation': ['NN'],
  'automaton': ['NN'],
  'automobile': ['NN'],
  'automobile-manufacturing': ['JJ'],
  'automobile-parts': ['JJ'],
  'automobile-tire': ['JJ'],
  'automobiles': ['NNS'],
  'automotive': ['JJ'],
  'automotive-emissions-testing': ['JJ'],
  'automotive-industry': ['NN'],
  'automotive-lighting': ['JJ'],
  'automotive-parts': ['JJ'],
  'automotive-product': ['NN'],
  'autonavigator': ['NN'],
  'autonomic': ['JJ'],
  'autonomic-somatic': ['JJ'],
  'autonomous': ['JJ'],
  'autonomously': ['RB'],
  'autonomy': ['NN'],
  'autopsied': ['VBN'],
  'autopsies': ['NNS'],
  'autopsy': ['NN'],
  'autos': ['NNS'],
  'autumn': ['NN'],
  'autumn-touched': ['JJ'],
  'autumnal': ['JJ'],
  'autumns': ['NNS'],
  'aux': ['FW'],
  'auxiliaries': ['NNS'],
  'auxiliary': ['JJ'],
  'avail': ['NN'],
  'availabilities': ['NNS'],
  'availability': ['NN'],
  'available': ['JJ'],
  'availed': ['VBD'],
  'availing': ['VBG'],
  'avalanche': ['NN'],
  'avaliable': ['JJ'],
  'avant': ['FW'],
  'avant-garde': ['JJ'],
  'avarice': ['NN'],
  'avaricious': ['JJ'],
  'avatar': ['NN'],
  'avec': ['NNP'],
  'avenge': ['VB'],
  'avenger': ['NN'],
  'avenging': ['JJ'],
  'avenue': ['NN'],
  'avenues': ['NNS'],
  'average': ['JJ'],
  'averaged': ['VBD'],
  'averages': ['NNS'],
  'averaging': ['VBG'],
  'averred': ['VBD'],
  'averse': ['JJ'],
  'aversion': ['NN'],
  'avert': ['VB'],
  'averted': ['VBN'],
  'averting': ['VBG'],
  'averts': ['VBZ'],
  'avian': ['JJ'],
  'aviary': ['NN'],
  'aviation': ['NN'],
  'aviation-services': ['NNS'],
  'aviator': ['NN'],
  'aviators': ['NNS'],
  'avid': ['JJ'],
  'avidity': ['NN'],
  'avidly': ['RB'],
  'avionics': ['NNS'],
  'avions': ['FW'],
  'avocado': ['NN'],
  'avocados': ['NNS'],
  'avocation': ['NN'],
  'avoid': ['VB'],
  'avoidable': ['JJ'],
  'avoidance': ['NN'],
  'avoided': ['VBN'],
  'avoiding': ['VBG'],
  'avoids': ['VBZ'],
  'avowed': ['JJ'],
  'avowedly': ['RB'],
  'avuncular': ['JJ'],
  'aw': ['UH'],
  'await': ['VB'],
  'awaited': ['VBD'],
  'awaiting': ['VBG'],
  'awaits': ['VBZ'],
  'awake': ['JJ'],
  'awaken': ['VB'],
  'awakened': ['VBN'],
  'awakening': ['VBG'],
  'awakens': ['VBZ'],
  'award': ['NN'],
  'award-winning': ['JJ'],
  'awarded': ['VBN'],
  'awarding': ['VBG'],
  'awards': ['NNS'],
  'aware': ['JJ'],
  'awareness': ['NN'],
  'awash': ['JJ'],
  'away': ['RB'],
  'away-from-home': ['JJ'],
  'awaye': ['RB'],
  'awe': ['NN'],
  'awe-inspiring': ['JJ'],
  'awed': ['VBN'],
  'awes': ['VBZ'],
  'awesome': ['JJ'],
  'awful': ['JJ'],
  'awfully': ['RB'],
  'awfulness': ['NN'],
  'awhile': ['RB'],
  'awkward': ['JJ'],
  'awkwardly': ['RB'],
  'awkwardness': ['NN'],
  'awnings': ['NNS'],
  'awoke': ['VBD'],
  'awry': ['RB'],
  'ax': ['NN'],
  'axe': ['NN'],
  'axes': ['NNS'],
  'axial': ['JJ'],
  'axially': ['RB'],
  'axiological': ['JJ'],
  'axiom': ['NN'],
  'axiomatic': ['JJ'],
  'axioms': ['NNS'],
  'axis': ['NN'],
  'axle': ['NN'],
  'axle-breaking': ['JJ'],
  'axles': ['NNS'],
  'aya': ['NN'],
  'ayatollah': ['NN'],
  'aye': ['RB'],
  'ayes': ['NNS'],
  'ayni': ['NNS'],
  'azalea': ['NN'],
  'azaleas': ['NNS'],
  'azure': ['JJ'],
  'b': ['NN'],
  'b-5,196,232': ['CD'],
  'b-As': ['IN'],
  'b-Based': ['VBN'],
  'b-Current': ['JJ'],
  'b-Includes': ['VBZ'],
  'b-Percent': ['NN'],
  'b-Week': ['NN'],
  'b-day': ['NN'],
  'b-plane': ['NN'],
  'b-reflects': ['VBZ'],
  'b/c': ['IN'],
  'ba-a-a': ['UH'],
  'babbino': ['FW'],
  'babbiting': ['NN'],
  'babble': ['NN'],
  'babbled': ['VBD'],
  'babel': ['NN'],
  'babes': ['NNS'],
  'babies': ['NNS'],
  'baboon': ['NN'],
  'baboons': ['NNS'],
  'baby': ['NN'],
  'baby-boomers': ['NNS'],
  'baby-faced': ['JJ'],
  'baby-food': ['JJ'],
  'baby-products': ['JJ'],
  'baby-sitter': ['NN'],
  'babyhood': ['NN'],
  'baccalaureate': ['NN'],
  'bachelor': ['NN'],
  'bachelor-type': ['JJ'],
  'bachelors': ['NNS'],
  'baci': ['NNS'],
  'back': ['RB'],
  'back-alley': ['JJ'],
  'back-dating': ['VBG'],
  'back-disability': ['NN'],
  'back-door': ['JJ'],
  'back-end': ['JJ'],
  'back-issue': ['JJ'],
  'back-lighted': ['JJ'],
  'back-of-the-envelope': ['JJ'],
  'back-office': ['NN'],
  'back-offices': ['NNS'],
  'back-on-terra-firma': ['JJ'],
  'back-pain': ['NN'],
  'back-pay': ['NN'],
  'back-room': ['NN'],
  'back-slapping': ['JJ'],
  'back-to-back': ['JJ'],
  'back-to-school': ['JJ'],
  'back-up': ['NN'],
  'back-ups': ['NNS'],
  'back-yard': ['JJ'],
  'back...': [':'],
  'backbeat': ['NN'],
  'backbench': ['JJ'],
  'backbend': ['NN'],
  'backbends': ['NNS'],
  'backbone': ['NN'],
  'backdated': ['VBD'],
  'backdoor': ['JJ'],
  'backdrop': ['NN'],
  'backed': ['VBN'],
  'backed-up': ['JJ'],
  'backer': ['NN'],
  'backers': ['NNS'],
  'backfield': ['NN'],
  'backfire': ['VB'],
  'backfired': ['VBD'],
  'backfires': ['VBZ'],
  'backfiring': ['VBG'],
  'backflips': ['VBZ'],
  'background': ['NN'],
  'backgrounds': ['NNS'],
  'backhand': ['NN'],
  'backhanded': ['JJ'],
  'backhoe': ['NN'],
  'backhome': ['NN'],
  'backing': ['VBG'],
  'backlash': ['NN'],
  'backlit': ['JJ'],
  'backlog': ['NN'],
  'backlogs': ['NNS'],
  'backlots': ['NNS'],
  'backpack': ['NN'],
  'backpackers': ['NNS'],
  'backpacks': ['NNS'],
  'backpedal': ['VB'],
  'backpedaling': ['VBG'],
  'backroom': ['NN'],
  'backrooms': ['NNS'],
  'backs': ['NNS'],
  'backside': ['NN'],
  'backsides': ['NNS'],
  'backslapping': ['VBG'],
  'backstage': ['RB'],
  'backstitch': ['NN'],
  'backstop': ['NN'],
  'backtracking': ['NN'],
  'backup': ['NN'],
  'backups': ['NNS'],
  'backward': ['RB'],
  'backwardness': ['NN'],
  'backwards': ['RB'],
  'backwater': ['NN'],
  'backwoods': ['NNS'],
  'backwoods-and-sand-hill': ['JJ'],
  'backyard': ['NN'],
  'backyards': ['NNS'],
  'bacon': ['NN'],
  'bacteria': ['NNS'],
  'bacteria-based': ['JJ'],
  'bacteria-contaminated': ['JJ'],
  'bacteria-free': ['JJ'],
  'bacterial': ['JJ'],
  'bacterium': ['NN'],
  'bad': ['JJ'],
  'bad-cop': ['JJ'],
  'bad-debt': ['JJ'],
  'bad-expectations': ['JJ'],
  'bad-fitting': ['JJ'],
  'bad-law': ['NN'],
  'bad-neighbor': ['JJ'],
  'bad-news': ['JJ'],
  'bad-risk': ['JJ'],
  'bad-smelling': ['JJ'],
  'baddebt': ['JJ'],
  'bade': ['VBD'],
  'badge': ['NN'],
  'badge-toter': ['NN'],
  'badgered': ['VBD'],
  'badgering': ['VBG'],
  'badges': ['NNS'],
  'badinage': ['NN'],
  'badly': ['RB'],
  'badly-needed': ['JJ'],
  'badmen': ['NNS'],
  'badminton': ['NN'],
  'badness': ['NN'],
  'bads': ['NNS'],
  'baffle': ['VB'],
  'baffled': ['VBN'],
  'baffling': ['JJ'],
  'bag': ['NN'],
  'bag\'em': ['NN'],
  'bagel': ['NN'],
  'bagels': ['NNS'],
  'baggage': ['NN'],
  'bagged': ['VBD'],
  'baggy': ['JJ'],
  'bagpipe': ['NN'],
  'bags': ['NNS'],
  'baguette': ['FW'],
  'bail': ['VB'],
  'bail-jumping': ['NN'],
  'bailed': ['VBD'],
  'bailiff': ['NN'],
  'bailing': ['VBG'],
  'bailout': ['NN'],
  'bailouts': ['NNS'],
  'bait': ['NN'],
  'baited': ['VBN'],
  'bake': ['JJ'],
  'bake-offs': ['NNS'],
  'bake-oven': ['NN'],
  'baked': ['JJ'],
  'baker': ['NN'],
  'bakeries': ['NNS'],
  'bakers': ['NNS'],
  'bakery': ['NN'],
  'bakery-mix': ['JJ'],
  'bakes': ['VBZ'],
  'bakeware': ['NN'],
  'baking': ['NN'],
  'baklava': ['NN'],
  'baksheesh': ['NN'],
  'balance': ['NN'],
  'balance-of-payments': ['NNS'],
  'balance-sheet': ['NN'],
  'balance-wise': ['JJ'],
  'balanced': ['JJ'],
  'balanced-budget': ['JJ'],
  'balances': ['NNS'],
  'balancing': ['NN'],
  'balconies': ['NNS'],
  'balcony': ['NN'],
  'bald': ['JJ'],
  'bald-faced': ['JJ'],
  'balding': ['JJ'],
  'baldish': ['JJ'],
  'baldness': ['NN'],
  'bale': ['NN'],
  'baleful': ['JJ'],
  'bales': ['NNS'],
  'balk': ['VB'],
  'balk.': ['VBP'],
  'balkanized': ['JJ'],
  'balked': ['VBD'],
  'balkiness': ['NN'],
  'balking': ['VBG'],
  'balks': ['VBZ'],
  'ball': ['NN'],
  'ball-bearing': ['NN'],
  'ball-carriers': ['NNS'],
  'ball-hawking': ['JJ'],
  'ballad': ['NN'],
  'ballads': ['NNS'],
  'ballards': ['NNS'],
  'ballast': ['NN'],
  'balled': ['VBN'],
  'ballerina': ['NN'],
  'ballerinas': ['NNS'],
  'ballet': ['NN'],
  'balletic': ['JJ'],
  'balletomane': ['NN'],
  'ballets': ['NNS'],
  'ballfields': ['NNS'],
  'ballgowns': ['NNS'],
  'balling': ['VBG'],
  'ballistic': ['JJ'],
  'ballistics': ['NNS'],
  'balloon': ['NN'],
  'ballooned': ['VBN'],
  'ballooning': ['NN'],
  'balloonists': ['NNS'],
  'balloons': ['NNS'],
  'ballot': ['NN'],
  'ballot-burning': ['JJ'],
  'balloting': ['NN'],
  'ballots': ['NNS'],
  'ballpark': ['NN'],
  'ballparks': ['NNS'],
  'ballplayer': ['NN'],
  'ballplayers': ['NNS'],
  'ballroom': ['NN'],
  'balls': ['NNS'],
  'ballyhoo': ['NN'],
  'ballyhooed': ['VBN'],
  'ballyhooey': ['NN'],
  'balm': ['NN'],
  'balm-of-Gilead': ['NN'],
  'balmy': ['JJ'],
  'baloney': ['NN'],
  'balsams': ['NNS'],
  'balustrade': ['NN'],
  'bam': ['UH'],
  'bambino': ['NN'],
  'bamboo': ['NN'],
  'bamboozled': ['VBN'],
  'ban': ['NN'],
  'banal': ['JJ'],
  'banalities': ['NNS'],
  'banalization': ['NN'],
  'banana': ['NN'],
  'banana-exporting': ['JJ'],
  'bananas': ['NNS'],
  'band': ['NN'],
  'band-wagon': ['JJ'],
  'bandage': ['NN'],
  'bandaged': ['VBN'],
  'bandages': ['NNS'],
  'banded': ['VBN'],
  'bandied': ['VBN'],
  'banding': ['VBG'],
  'bandit': ['NN'],
  'banditos': ['NNS'],
  'bandits': ['NNS'],
  'bandoleers': ['NNS'],
  'bands': ['NNS'],
  'bandstand': ['NN'],
  'bandwagon': ['NN'],
  'bandwidth': ['NN'],
  'bane': ['NN'],
  'baneful': ['JJ'],
  'bang': ['NN'],
  'bang-sashes': ['NNS'],
  'banged': ['VBD'],
  'banging': ['VBG'],
  'bangish': ['JJ'],
  'bangs': ['NNS'],
  'banish': ['VB'],
  'banished': ['VBN'],
  'banishes': ['VBZ'],
  'banishing': ['VBG'],
  'banishment': ['NN'],
  'banister': ['NN'],
  'banisters': ['NNS'],
  'banjo': ['NN'],
  'bank': ['NN'],
  'bank-affiliated': ['JJ'],
  'bank-backed': ['JJ'],
  'bank-baiting': ['JJ'],
  'bank-branch': ['JJ'],
  'bank-credit': ['NN'],
  'bank-debt': ['NN'],
  'bank-director': ['NN'],
  'bank-embezzlement': ['JJ'],
  'bank-fraud': ['NN'],
  'bank-holding': ['JJ'],
  'bank-looting': ['JJ'],
  'bank-owned': ['JJ'],
  'bank-sponsored': ['JJ'],
  'bank-teller': ['NN'],
  'banked': ['VBD'],
  'banker': ['NN'],
  'banker-editor': ['NN'],
  'bankers': ['NNS'],
  'bankholding': ['VBG'],
  'banking': ['NN'],
  'banking-related': ['JJ'],
  'bankroll': ['VB'],
  'bankrolled': ['VBD'],
  'bankrolling': ['VBG'],
  'bankrupcy': ['NN'],
  'bankrupt': ['JJ'],
  'bankruptcies': ['NNS'],
  'bankruptcy': ['NN'],
  'bankruptcy-court': ['NN'],
  'bankruptcy-law': ['NN'],
  'bankruptcy-proceedings': ['NNS'],
  'bankruptcy-reorganization': ['NN'],
  'bankruptcylaw': ['NN'],
  'bankrupts': ['VBZ'],
  'bankrupty-law': ['NN'],
  'banks': ['NNS'],
  'banned': ['VBN'],
  'banner': ['NN'],
  'banners': ['NNS'],
  'banning': ['VBG'],
  'bannnnnng': ['VB'],
  'banquet': ['NN'],
  'banquet-hall': ['NN'],
  'banquetings': ['NNS'],
  'banquets': ['NNS'],
  'bans': ['NNS'],
  'banshee': ['NN'],
  'banshees': ['NNS'],
  'banter': ['NN'],
  'bantered': ['VBN'],
  'bantering': ['VBG'],
  'baptism': ['NN'],
  'baptismal': ['JJ'],
  'baptisms': ['NNS'],
  'baptistery': ['NN'],
  'baptized': ['VBN'],
  'bar': ['NN'],
  'bar\'l': ['NN'],
  'bar-buddy': ['NN'],
  'bar-code': ['JJ'],
  'bar-staged': ['JJ'],
  'barb': ['NN'],
  'barbarian': ['NN'],
  'barbarians': ['NNS'],
  'barbaric': ['JJ'],
  'barbarisms': ['NNS'],
  'barbarous': ['JJ'],
  'barbecue': ['NN'],
  'barbecued': ['VBN'],
  'barbecues': ['NNS'],
  'barbed': ['JJ'],
  'barbed-wire': ['JJ'],
  'barbell': ['NN'],
  'barbequed': ['JJ'],
  'barber': ['NN'],
  'barbers': ['NNS'],
  'barbital': ['NN'],
  'barbiturate': ['NN'],
  'barbs': ['NNS'],
  'bard': ['NN'],
  'bards': ['NNS'],
  'bare': ['JJ'],
  'bare-armed': ['JJ'],
  'bare-bones': ['JJ'],
  'bare-footed': ['JJ'],
  'bared': ['VBD'],
  'barefoot': ['RB'],
  'barefooted': ['JJ'],
  'barely': ['RB'],
  'barest': ['JJS'],
  'barflies': ['NNS'],
  'bargain': ['NN'],
  'bargain-basement': ['JJ'],
  'bargain-buying': ['JJ'],
  'bargain-hunt': ['VB'],
  'bargain-hunters': ['NNS'],
  'bargain-hunting': ['NN'],
  'bargain-priced': ['JJ'],
  'bargained': ['VBD'],
  'bargaining': ['NN'],
  'bargaining-chip': ['NN'],
  'bargains': ['NNS'],
  'barge': ['NN'],
  'barged': ['VBN'],
  'bargelike': ['JJ'],
  'bargen': ['VBP'],
  'barges': ['NNS'],
  'barging': ['VBG'],
  'baring': ['VBG'],
  'baritone': ['NN'],
  'barium': ['NN'],
  'bark': ['NN'],
  'bark-nibbling': ['JJ'],
  'barked': ['VBD'],
  'barkeep': ['NN'],
  'barking': ['VBG'],
  'barks': ['VBZ'],
  'barley': ['NN'],
  'barn': ['NN'],
  'barn-burner': ['NN'],
  'barnacles': ['NNS'],
  'barns': ['NNS'],
  'barnsful': ['NN'],
  'barnstormer': ['NN'],
  'barnyard': ['NN'],
  'barnyards': ['NNS'],
  'barometer': ['NN'],
  'barometers': ['NNS'],
  'barometric': ['JJ'],
  'baron': ['NN'],
  'baroness': ['NN'],
  'baronial': ['JJ'],
  'barons': ['NNS'],
  'barony': ['NN'],
  'baroque': ['JJ'],
  'baroreceptor': ['NN'],
  'barrack': ['NN'],
  'barracks': ['NN'],
  'barrage': ['NN'],
  'barred': ['VBN'],
  'barrel': ['NN'],
  'barrel-a-day': ['JJ'],
  'barrel-chested': ['JJ'],
  'barrel-per-day': ['JJ'],
  'barrel-vaulted': ['JJ'],
  'barrel-wide': ['JJ'],
  'barreling': ['VBG'],
  'barrels': ['NNS'],
  'barrels-a-day': ['JJ'],
  'barren': ['JJ'],
  'barricade': ['NN'],
  'barricades': ['NNS'],
  'barrier': ['NN'],
  'barrier-free': ['JJ'],
  'barrier-island': ['NN'],
  'barriers': ['NNS'],
  'barring': ['VBG'],
  'barrio': ['NN'],
  'barrister': ['NN'],
  'barristers': ['NNS'],
  'barroom': ['NN'],
  'barrow': ['NN'],
  'bars': ['NNS'],
  'bartender': ['NN'],
  'bartenders': ['NNS'],
  'barter': ['NN'],
  'bartered': ['VBN'],
  'bartering': ['NN'],
  'bas-relief': ['NN'],
  'bas-reliefs': ['NNS'],
  'bascially': ['RB'],
  'base': ['NN'],
  'base-metal': ['NN'],
  'base-metals': ['NNS'],
  'base-price': ['NN'],
  'base-rate': ['JJ'],
  'base-runner': ['NN'],
  'base-stealing': ['JJ'],
  'base-wage': ['JJ'],
  'baseball': ['NN'],
  'baseball-card': ['JJ'],
  'baseball-loving': ['JJ'],
  'baseball-watching': ['JJ'],
  'baseballight': ['NN'],
  'baseballs': ['NNS'],
  'based': ['VBN'],
  'based-CAE': ['JJ', 'NP'],
  'based.': ['VBN'],
  'baseless': ['JJ'],
  'baseline': ['NN'],
  'baseman': ['NN'],
  'basement': ['NN'],
  'basements': ['NNS'],
  'baser': ['JJR'],
  'bases': ['NNS'],
  'bash': ['NN'],
  'bashed': ['VBD'],
  'basher': ['NN'],
  'bashes': ['NNS'],
  'bashful': ['JJ'],
  'bashing': ['JJ'],
  'basic': ['JJ'],
  'basic-cable': ['JJ'],
  'basically': ['RB'],
  'basics': ['NNS'],
  'basil': ['NN'],
  'basileis': ['NNS'],
  'basin': ['NN'],
  'basing': ['VBG'],
  'basins': ['NNS'],
  'basis': ['NN'],
  'basis-point': ['NN'],
  'basked': ['VBD'],
  'basket': ['NN'],
  'basketball': ['NN'],
  'basketball-cutback': ['NN'],
  'basketball-playing': ['NN'],
  'baskets': ['NNS'],
  'basking': ['VBG'],
  'basophilic': ['JJ'],
  'bass': ['NN'],
  'basses': ['NNS'],
  'bassinet': ['NN'],
  'bassist': ['NN'],
  'basso': ['NN'],
  'bassoon': ['NN'],
  'bastard': ['NN'],
  'bastards': ['NNS'],
  'basting': ['NN'],
  'bastion': ['NN'],
  'bastions': ['NNS'],
  'bat': ['NN'],
  'bat-roost': ['JJ'],
  'batch': ['NN'],
  'batches': ['NNS'],
  'bateau': ['JJ'],
  'bated': ['JJ'],
  'bath': ['NN'],
  'bath-supplies': ['NNS'],
  'bathe': ['VB'],
  'bathed': ['VBN'],
  'bathers': ['NNS'],
  'bathing': ['NN'],
  'bathos': ['NN'],
  'bathrobe': ['NN'],
  'bathrobes': ['NNS'],
  'bathroom': ['NN'],
  'bathrooms': ['NNS'],
  'baths': ['NNS'],
  'bathtub': ['NN'],
  'bathtubs': ['NNS'],
  'bathwater': ['NN'],
  'batmobile': ['NN'],
  'baton': ['NN'],
  'bats': ['NNS'],
  'batsman': ['NN'],
  'battalion': ['NN'],
  'battalions': ['NNS'],
  'batted': ['VBD'],
  'batten': ['NN'],
  'battens': ['NNS'],
  'batter': ['NN'],
  'battered': ['VBN'],
  'batterie': ['NN'],
  'batteries': ['NNS'],
  'battering': ['VBG'],
  'batters': ['NNS'],
  'battery': ['NN'],
  'battery-driven': ['JJ'],
  'battery-operated': ['JJ'],
  'battery-powered': ['JJ'],
  'batting': ['VBG'],
  'battle': ['NN'],
  'battle-ax': ['NN'],
  'battle-cries': ['NN'],
  'battle-cry': ['NN'],
  'battle-shattered': ['JJ'],
  'battled': ['VBD'],
  'battlefield': ['NN'],
  'battlefield-electronic': ['JJ'],
  'battlefields': ['NNS'],
  'battlefront': ['NN'],
  'battleground': ['NN'],
  'battlegrounds': ['NNS'],
  'battlegroups': ['NNS'],
  'battlements': ['NNS'],
  'battles': ['NNS'],
  'battling': ['VBG'],
  'batwings': ['NNS'],
  'bauble': ['NN'],
  'baubles': ['NNS'],
  'bawdy': ['JJ'],
  'bawh': ['NN'],
  'bawhs': ['NNS'],
  'bawled': ['VBD'],
  'bawling': ['VBG'],
  'bay': ['NN'],
  'bayed': ['VBD'],
  'baying': ['NN'],
  'bayleefe': ['NN'],
  'bayly': ['NN'],
  'bayonet': ['NN'],
  'bayonets': ['NNS'],
  'bays': ['NNS'],
  'bazaar': ['NN'],
  'bazaars': ['NNS'],
  'bc': ['IN'],
  'bd': ['NNS'],
  'be': ['VB'],
  'be\'greenlined': ['VBN'],
  'be\'somewhat': ['VB'],
  'be\'your': ['NN'],
  'be-that': ['VB'],
  'be-thonged': ['JJ'],
  'be...': [':'],
  'be....': [':'],
  'beach': ['NN'],
  'beach-drift': ['NN'],
  'beach-head': ['NN'],
  'beach-house': ['NN'],
  'beach-party': ['NN'],
  'beached': ['JJ'],
  'beaches': ['NNS'],
  'beachfront': ['NN'],
  'beachhead': ['NN'],
  'beaching': ['VBG'],
  'beacon': ['NN'],
  'bead-like': ['JJ'],
  'beaded': ['VBN'],
  'beadle': ['NN'],
  'beads': ['NNS'],
  'beadsman': ['NN'],
  'beadwork': ['NN'],
  'beady': ['JJ'],
  'beak': ['NN'],
  'beaker': ['NN'],
  'beakers': ['NNS'],
  'beam': ['NN'],
  'beamed': ['VBN'],
  'beaming': ['VBG'],
  'beams': ['NNS'],
  'bean': ['NN'],
  'bean-counting': ['NN'],
  'beanballs': ['NNS'],
  'beans': ['NNS'],
  'beanstalk': ['NN'],
  'bear': ['VB'],
  'bear-like': ['JJ'],
  'bear-market': ['NN'],
  'bearable': ['JJ'],
  'beard': ['NN'],
  'bearded': ['JJ'],
  'beardless': ['JJ'],
  'beardown': ['JJ'],
  'beards': ['NNS'],
  'bearer': ['NN'],
  'bearing': ['VBG'],
  'bearings': ['NNS'],
  'bearish': ['JJ'],
  'bearishly': ['RB'],
  'bearishness': ['NN'],
  'bears': ['VBZ'],
  'beast': ['NN'],
  'beasties': ['NNS'],
  'beastly': ['JJ'],
  'beasts': ['NNS'],
  'beat': ['VB'],
  'beat-up': ['JJ'],
  'beaten': ['VBN'],
  'beatific': ['JJ'],
  'beatification': ['NN'],
  'beating': ['VBG'],
  'beatings': ['NNS'],
  'beatnik': ['NN'],
  'beatniks': ['NNS'],
  'beats': ['VBZ'],
  'beau': ['NN'],
  'beauteous': ['JJ'],
  'beauticians': ['NNS'],
  'beauties': ['NNS'],
  'beautiful': ['JJ'],
  'beautifully': ['RB'],
  'beautifully-built': ['JJ'],
  'beautifully-tapered': ['JJ'],
  'beautify': ['VBP'],
  'beautifying': ['VBG'],
  'beauty': ['NN'],
  'beauty-care': ['JJ'],
  'beauty-idiom': ['NN'],
  'beaver': ['NN'],
  'beavered': ['VBD'],
  'beavers': ['NNS'],
  'beavertail': ['NN'],
  'bebop': ['NN'],
  'becalmed': ['JJ'],
  'became': ['VBD'],
  'becase': ['IN'],
  'because': ['IN'],
  'beckon': ['VBP'],
  'beckoned': ['VBD'],
  'beckoning': ['VBG'],
  'beckons': ['VBZ'],
  'become': ['VB'],
  'becomed': ['VBN'],
  'becomes': ['VBZ'],
  'becometh': ['VBZ'],
  'becomin': ['VBG'],
  'becoming': ['VBG'],
  'bed': ['NN'],
  'bed-and-breakfast': ['JJ'],
  'bed-hopped': ['VBD'],
  'bed-liner': ['NN'],
  'bed-time': ['NN'],
  'bed-type': ['JJ'],
  'bedazzled': ['VBN'],
  'bedazzlement': ['NN'],
  'bedded': ['VBN'],
  'bedding': ['NN'],
  'bedevil': ['VB'],
  'bedeviled': ['VBN'],
  'bedfast': ['JJ'],
  'bedfellows': ['NNS'],
  'bedground': ['NN'],
  'bedlam': ['NN'],
  'bedpans': ['NNS'],
  'bedpost': ['NN'],
  'bedraggled': ['JJ'],
  'bedridden': ['JJ'],
  'bedrock': ['NN'],
  'bedroom': ['NN'],
  'bedrooms': ['NNS'],
  'beds': ['NNS'],
  'bedside': ['NN'],
  'bedspread': ['NN'],
  'bedsprings': ['NNS'],
  'bedstraw': ['NN'],
  'bedtime': ['NN'],
  'bee': ['NN'],
  'beebread': ['NN'],
  'beech': ['NN'],
  'beef': ['NN'],
  'beef-fat': ['JJ'],
  'beef-feeding': ['JJ'],
  'beef-hungry': ['JJ'],
  'beef-import': ['JJ'],
  'beef-jerky': ['NN'],
  'beefed': ['VBN'],
  'beefed-up': ['JJ'],
  'beefing': ['VBG'],
  'beefore': ['IN'],
  'beefs': ['VBZ'],
  'beefsteak': ['NN'],
  'beefy': ['JJ'],
  'beehive': ['NN'],
  'been': ['VBN'],
  'beep': ['NN'],
  'beeped': ['VBN'],
  'beeper': ['NN'],
  'beepers': ['NNS'],
  'beeping': ['VBG'],
  'beeps': ['NNS'],
  'beer': ['NN'],
  'beer-bellied': ['JJ'],
  'beer-belly': ['NN'],
  'beer-cooling': ['VBG'],
  'beer-distribution': ['NN'],
  'beer-drinker': ['NN'],
  'beer-guzzling': ['JJ'],
  'beer-industry': ['NN'],
  'beer-related': ['JJ'],
  'beer-runner': ['NN'],
  'beer-runners': ['NNS'],
  'beer-running': ['NN'],
  'beer-tax': ['JJ'],
  'beers': ['NNS'],
  'bees': ['NNS'],
  'beeswax': ['NN'],
  'beet': ['NN'],
  'beetle': ['NN'],
  'beetle-browed': ['JJ'],
  'beetles': ['NNS'],
  'beetling': ['JJ'],
  'beets': ['NNS'],
  'befall': ['VB'],
  'befallen': ['VBN'],
  'befell': ['VBD'],
  'befits': ['VBZ'],
  'befitting': ['VBG'],
  'befogged': ['JJ'],
  'befoh': ['RB'],
  'before': ['IN'],
  'before-and-after': ['JJ'],
  'before-school': ['JJ'],
  'before-tax': ['JJ'],
  'beforehand': ['RB'],
  'befouled': ['VBN'],
  'befriended': ['VBD'],
  'befriends': ['VBZ'],
  'befuddled': ['VBD'],
  'befuddles': ['VBZ'],
  'befuddling': ['VBG'],
  'beg': ['VBP'],
  'began': ['VBD'],
  'begat': ['VBD'],
  'beget': ['VB'],
  'begets': ['VBZ'],
  'beggar': ['NN'],
  'beggar-thy-neighbor': ['JJ'],
  'beggars': ['NNS'],
  'beggary': ['NN'],
  'begged': ['VBD'],
  'begging': ['VBG'],
  'begin': ['VB'],
  'begining': ['NN'],
  'beginner': ['NN'],
  'beginners': ['NNS'],
  'beginning': ['VBG'],
  'beginnings': ['NNS'],
  'begins': ['VBZ'],
  'begonia': ['NN'],
  'begot': ['VBD'],
  'begotten': ['VBN'],
  'begrudge': ['VB'],
  'begs': ['VBZ'],
  'beguile': ['VBP'],
  'beguiled': ['VBN'],
  'beguiling': ['JJ'],
  'begun': ['VBN'],
  'behahn': ['RB'],
  'behalf': ['NN'],
  'behave': ['VB'],
  'behaved': ['VBD'],
  'behaves': ['VBZ'],
  'behaving': ['VBG'],
  'behavior': ['NN'],
  'behavior-modification': ['NN'],
  'behavioral': ['JJ'],
  'behaviorally': ['RB'],
  'behaviors': ['NNS'],
  'behaviour': ['NN'],
  'beheaded': ['VBD'],
  'beheading': ['NN'],
  'beheld': ['VBD'],
  'behemoth': ['NN'],
  'behemoths': ['NNS'],
  'behest': ['NN'],
  'behind': ['IN'],
  'behind-schedule': ['JJ'],
  'behind-the-scenes': ['JJ'],
  'behold': ['VB'],
  'beholden': ['JJ'],
  'beholder': ['NN'],
  'beholds': ['VBZ'],
  'behooves': ['VBZ'],
  'behynde': ['IN'],
  'beige': ['JJ'],
  'bein': ['VBG'],
  'being': ['VBG'],
  'being\'imprinted': ['VBN'],
  'beinge': ['VBG'],
  'beings': ['NNS'],
  'bel': ['FW'],
  'belaboring': ['VBG'],
  'belated': ['JJ'],
  'belatedly': ['RB'],
  'belch': ['NN'],
  'belched': ['VBD'],
  'belching': ['NN'],
  'beleaguered': ['JJ'],
  'belfries': ['NNS'],
  'belfry': ['NN'],
  'belie': ['VBP'],
  'belied': ['VBD'],
  'belief': ['NN'],
  'beliefs': ['NNS'],
  'belies': ['VBZ'],
  'believability': ['NN'],
  'believable': ['JJ'],
  'believably': ['RB'],
  'believe': ['VBP'],
  'believed': ['VBD'],
  'believer': ['NN'],
  'believers': ['NNS'],
  'believes': ['VBZ'],
  'believeth': ['VBZ'],
  'believing': ['VBG'],
  'belittle': ['VBP'],
  'belittled': ['JJ'],
  'belittling': ['VBG'],
  'bell': ['NN'],
  'bell-ringer': ['NN'],
  'bell-ringers': ['NNS'],
  'bell-ringing': ['JJ'],
  'bellboy': ['NN'],
  'bellboys': ['NNS'],
  'belle': ['FW'],
  'belled': ['JJ'],
  'belles': ['NNS'],
  'bellhops': ['NNS'],
  'bellicosity': ['NN'],
  'bellies': ['NNS'],
  'belligerence': ['NN'],
  'belligerent': ['JJ'],
  'belligerently': ['RB'],
  'bellow': ['NN'],
  'bellowed': ['VBD'],
  'bellowing': ['VBG'],
  'bellows': ['VBZ'],
  'bellringers': ['NNS'],
  'bells': ['NNS'],
  'bellwether': ['NN'],
  'bellwethers': ['NNS'],
  'belly': ['NN'],
  'belly-flopped': ['VBD'],
  'belly-up': ['JJ'],
  'bellyaching': ['NN'],
  'bellyfull': ['NN'],
  'belong': ['VB'],
  'belonged': ['VBD'],
  'belonging': ['VBG'],
  'belongings': ['NNS'],
  'belongs': ['VBZ'],
  'beloved': ['JJ'],
  'below': ['IN'],
  'below-average': ['JJ'],
  'below-investment': ['JJ'],
  'below-investment-grade': ['JJ'],
  'below-market': ['JJ'],
  'belowground': ['NN'],
  'belt': ['NN'],
  'belt-driven': ['JJ'],
  'belt-tightening': ['NNS'],
  'belted': ['VBD'],
  'belting': ['NN'],
  'belts': ['NNS'],
  'beltway': ['NN'],
  'beluga': ['NN'],
  'belying': ['VBG'],
  'bemaddening': ['VBG'],
  'bemoan': ['VB'],
  'bemoaned': ['VBD'],
  'bemoaning': ['VBG'],
  'bemoans': ['VBZ'],
  'bemused': ['JJ'],
  'bench': ['NN'],
  'bench...': [':'],
  'benches': ['NNS'],
  'benchmark': ['NN'],
  'benchmarks': ['NNS'],
  'bend': ['VB'],
  'bending': ['VBG'],
  'bends': ['NNS'],
  'beneath': ['IN'],
  'benediction': ['NN'],
  'benefactor': ['NN'],
  'benefactors': ['NNS'],
  'beneficence': ['NN'],
  'beneficial': ['JJ'],
  'beneficially': ['RB'],
  'beneficiaries': ['NNS'],
  'beneficiary': ['NN'],
  'beneficient': ['JJ'],
  'benefit': ['NN'],
  'benefit-plan': ['JJ'],
  'benefit-seeking': ['NN'],
  'benefited': ['VBD'],
  'benefiting': ['VBG'],
  'benefits': ['NNS'],
  'benefits-consulting': ['JJ'],
  'benefits-for-all': ['JJ'],
  'benefits-services': ['JJ'],
  'benevolence': ['NN'],
  'benevolent': ['JJ'],
  'benighted': ['JJ'],
  'benign': ['JJ'],
  'benignant': ['JJ'],
  'bent': ['VBD'],
  'benzene': ['NN'],
  'benzodiazepines': ['NNS'],
  'bequeath': ['VB'],
  'bequeathed': ['VBN'],
  'bequest': ['NN'],
  'bequests': ['NNS'],
  'berated': ['VBN'],
  'bereavement': ['NN'],
  'bereavements': ['NNS'],
  'bereft': ['JJ'],
  'beret': ['NN'],
  'bergs': ['NNS'],
  'beribboned': ['JJ'],
  'beriberi': ['NN'],
  'berms': ['NNS'],
  'berries': ['NNS'],
  'berry': ['NN'],
  'berserk': ['JJ'],
  'berth': ['NN'],
  'berths': ['NNS'],
  'beryllium': ['NN'],
  'beseech': ['VBP'],
  'beseiged': ['VBN'],
  'beset': ['VBN'],
  'besets': ['VBZ'],
  'besetting': ['VBG'],
  'beside': ['IN'],
  'besides': ['IN'],
  'besiege': ['VB'],
  'besieged': ['VBN'],
  'besiegers': ['NNS'],
  'besieging': ['VBG'],
  'besmirch': ['VB'],
  'besmirched': ['VBD'],
  'besmirching': ['VBG'],
  'bespeak': ['VBP'],
  'bespeaks': ['VBZ'],
  'bespectacled': ['JJ'],
  'best': ['JJS'],
  'best-case': ['JJ'],
  'best-educated': ['JJ'],
  'best-financed': ['JJ'],
  'best-gaited': ['JJ'],
  'best-hearted': ['JJ'],
  'best-known': ['JJ'],
  'best-laid': ['JJ'],
  'best-looking': ['JJ'],
  'best-managed': ['JJ'],
  'best-of-seven': ['JJ'],
  'best-performing': ['JJ'],
  'best-pitcher': ['JJ'],
  'best-preserved': ['JJ'],
  'best-run': ['JJS'],
  'best-seller': ['NN'],
  'best-sellers': ['NNS'],
  'best-selling': ['JJ'],
  'best-tempered': ['JJ'],
  'bested': ['VBN'],
  'bestes': ['NNS'],
  'bestial': ['JJ'],
  'bestiary': ['NN'],
  'besting': ['VBG'],
  'bestioles': ['NNS'],
  'bestirred': ['VBN'],
  'bestow': ['VB'],
  'bestowal': ['NN'],
  'bestowed': ['VBN'],
  'bestows': ['VBZ'],
  'bestseller': ['NN'],
  'bestsellers': ['NNS'],
  'bestselling': ['JJ'],
  'bestubbled': ['JJ'],
  'besuboru': ['FW'],
  'bet': ['NN'],
  'beta': ['NN'],
  'beta-blocker': ['NN'],
  'beta-thalassemia': ['NN'],
  'betas': ['NNS'],
  'bete': ['JJ'],
  'betel-stained': ['JJ'],
  'bethought': ['VB'],
  'betide': ['VB'],
  'betray': ['VB'],
  'betrayal': ['NN'],
  'betrayed': ['VBN'],
  'betrayer': ['NN'],
  'betraying': ['VBG'],
  'betrays': ['VBZ'],
  'betrothal': ['JJ'],
  'betrothed': ['VBD'],
  'bets': ['NNS'],
  'better': ['JJR'],
  'better-capitalized': ['JJ'],
  'better-educated': ['JJ'],
  'better-known': ['JJ'],
  'better-off': ['JJR'],
  'better-paying': ['JJ'],
  'better-prepared': ['JJ'],
  'better-quality': ['JJ'],
  'better-remembered': ['JJ'],
  'better-safe-than': ['JJ'],
  'better-selling': ['JJ'],
  'better-than-average': ['JJ'],
  'better-than-expected': ['JJ'],
  'better-than-thou': ['JJ'],
  'bettered': ['VBD'],
  'bettering': ['VBG'],
  'betterment': ['NN'],
  'betters': ['NNS'],
  'betties': ['NNS'],
  'betting': ['VBG'],
  'between': ['IN'],
  'betwen': ['NN'],
  'bevel': ['VB'],
  'beveled': ['VBN'],
  'beveling': ['VBG'],
  'bevels': ['NNS'],
  'beverage': ['NN'],
  'beverages': ['NNS'],
  'bevor': ['FW'],
  'bevy': ['NN'],
  'bewail': ['VB'],
  'beware': ['VB'],
  'beween': ['NN'],
  'bewhiskered': ['JJ'],
  'bewildered': ['VBN'],
  'bewilderedly': ['RB'],
  'bewildering': ['VBG'],
  'bewilderingly': ['RB'],
  'bewilderment': ['NN'],
  'bewilders': ['VBZ'],
  'bewitched': ['VBN'],
  'bewitching': ['VBG'],
  'bewteen': ['IN'],
  'beyond': ['IN'],
  'beyond-normal': ['JJ'],
  'bhoy': ['NN'],
  'bi': ['IN'],
  'bi-modal': ['JJ'],
  'bi-monthly': ['JJ'],
  'bi-polar': ['JJ'],
  'bi-regional': ['JJ'],
  'bianco': ['NN'],
  'biannual': ['JJ'],
  'bias': ['NN'],
  'biased': ['VBN'],
  'biases': ['NNS'],
  'bib': ['NN'],
  'bible': ['JJ'],
  'bibles': ['NNS'],
  'biblical': ['JJ'],
  'bibliographical': ['JJ'],
  'bibliographies': ['NNS'],
  'bibliography': ['NN'],
  'bibliophiles': ['NNS'],
  'bibs': ['NNS'],
  'bibulous': ['JJ'],
  'bicameral': ['JJ'],
  'bicarbonate': ['NN'],
  'bicentennial': ['NN'],
  'bicep': ['NN'],
  'biceps': ['NNS'],
  'bich': ['NN'],
  'biches': ['NNS'],
  'bickered': ['VBN'],
  'bickering': ['NN'],
  'biconcave': ['JJ'],
  'bicycle': ['NN'],
  'bicycle-auto': ['JJ'],
  'bicycles': ['NNS'],
  'bicycling': ['NN'],
  'bicyclist': ['NN'],
  'bid': ['NN'],
  'bid-asked': ['JJ'],
  'bid-rigging': ['NN'],
  'bid-to-cover': ['JJ'],
  'bid-wanted': ['JJ'],
  'bidder': ['NN'],
  'bidders': ['NNS'],
  'biddies': ['NNS'],
  'bidding': ['NN'],
  'bide': ['VB'],
  'bided': ['VBN'],
  'bids': ['NNS'],
  'bids...': [':'],
  'bieber': ['NNP'],
  'bien': ['FW'],
  'biennial': ['JJ'],
  'biennium': ['NN'],
  'bifocal': ['JJ'],
  'bifocals': ['NNS'],
  'bifurcate': ['VB'],
  'bifurcated': ['JJ'],
  'big': ['JJ'],
  'big-boned': ['JJ'],
  'big-borrowing': ['JJ'],
  'big-bucks': ['JJ'],
  'big-budget': ['JJ'],
  'big-business': ['JJ'],
  'big-chested': ['JJ'],
  'big-city': ['JJ'],
  'big-company': ['JJ'],
  'big-daddy': ['JJ'],
  'big-deposit': ['JJ'],
  'big-fee': ['JJ'],
  'big-game': ['JJ'],
  'big-hearted': ['JJ'],
  'big-large': ['NN'],
  'big-league': ['JJ'],
  'big-money': ['JJ'],
  'big-name': ['JJ'],
  'big-risk': ['JJ'],
  'big-selling': ['JJ'],
  'big-shouldered': ['JJ'],
  'big-souled': ['JJ'],
  'big-stage': ['JJ'],
  'big-stakes': ['JJ'],
  'big-stock': ['JJ'],
  'big-ticket': ['JJ'],
  'big-time': ['JJ'],
  'big-town': ['JJ'],
  'big-tube': ['JJ'],
  'bigger': ['JJR'],
  'bigger-than-expected': ['JJ'],
  'biggest': ['JJS'],
  'biggest-ever': ['JJ'],
  'biggest-selling': ['JJ'],
  'biggie': ['NN'],
  'bigness': ['NN'],
  'bigoted': ['JJ'],
  'bigotry': ['NN'],
  'bigots': ['NNS'],
  'bigticket': ['NN'],
  'bijouterie': ['FW'],
  'bike': ['NN'],
  'biker': ['NN'],
  'bikers': ['NNS'],
  'bikes': ['NNS'],
  'biking': ['NN'],
  'bikini': ['NN'],
  'bikinis': ['NNS'],
  'bilateral': ['JJ'],
  'bile': ['NN'],
  'bilevel': ['JJ'],
  'bilge': ['NN'],
  'bilges': ['NNS'],
  'bilharziasis': ['NN'],
  'bilinear': ['JJ'],
  'bilingual': ['JJ'],
  'bilious': ['JJ'],
  'bilk': ['VB'],
  'bilked': ['VBN'],
  'bilking': ['VBG'],
  'bill': ['NN'],
  'bill-introduced': ['NN'],
  'billable': ['JJ'],
  'billboard': ['NN'],
  'billboards': ['NNS'],
  'billed': ['VBN'],
  'billet': ['NN'],
  'billets': ['NNS'],
  'billfold': ['NN'],
  'billiard': ['NN'],
  'billiards': ['NN'],
  'billing': ['NN'],
  'billings': ['NNS'],
  'billion': ['CD'],
  'billion-a': ['JJ'],
  'billion-a-year': ['JJ'],
  'billion-asset': ['JJ'],
  'billion-dollar': ['JJ'],
  'billion-franc': ['NN'],
  'billion-peso': ['JJ'],
  'billion-plus': ['JJ'],
  'billion-pound': ['JJ'],
  'billion-share': ['JJ'],
  'billion-yen': ['JJ'],
  'billionaire': ['NN'],
  'billionaires': ['NNS'],
  'billionnaire': ['NN'],
  'billions': ['NNS'],
  'billon': ['NN'],
  'billowed': ['VBD'],
  'billowing': ['VBG'],
  'billows': ['NNS'],
  'bills': ['NNS'],
  'bills-measures': ['JJ'],
  'bimbos': ['NNS'],
  'bimolecular': ['JJ'],
  'bimonthly': ['JJ'],
  'bin': ['NN'],
  'binary': ['JJ'],
  'binational': ['JJ'],
  'bind': ['NN'],
  'binder': ['NN'],
  'binders': ['NNS'],
  'binding': ['NN'],
  'bindle': ['NN'],
  'binds': ['VBZ'],
  'binge': ['NN'],
  'binges': ['NNS'],
  'bingo': ['NN'],
  'bingo-like': ['JJ'],
  'binoculars': ['NNS'],
  'binomial': ['NN'],
  'bins': ['NNS'],
  'binuclear': ['JJ'],
  'bio': ['NN'],
  'bio-analytical': ['JJ'],
  'bio-assay': ['NN'],
  'bio-medical': ['JJ'],
  'bio-medicine': ['NN'],
  'bio-research': ['NN'],
  'bioTechnology': ['NNP'],
  'biochemical': ['JJ'],
  'biochemicals': ['NNS'],
  'biochemist': ['NN'],
  'biochemistry': ['NN'],
  'biochemists': ['NNS'],
  'biodegradable': ['JJ'],
  'bioengineer': ['VB'],
  'bioengineers': ['NNS'],
  'bioequivalence-therapeutic-equivalence': ['JJ'],
  'bioequivalent': ['JJ'],
  'biofeedback': ['NN'],
  'biographer': ['NN'],
  'biographer\\\'': ['NN'],
  'biographers': ['NNS'],
  'biographical': ['JJ'],
  'biographies': ['NNS'],
  'biography': ['NN'],
  'bioherbicide': ['NN'],
  'bioinsecticides': ['NNS'],
  'biologic': ['JJ'],
  'biological': ['JJ'],
  'biologically': ['RB'],
  'biologist': ['NN'],
  'biologists': ['NNS'],
  'biology': ['NN'],
  'biomedical': ['JJ'],
  'biomedical-products': ['NNS'],
  'biopesticide': ['NN'],
  'biopharmaceutical': ['JJ'],
  'biophysical': ['JJ'],
  'biophysicist': ['NN'],
  'biophysics': ['NNS'],
  'biopsies': ['NNS'],
  'biopsy': ['NN'],
  'bioresearch': ['NN'],
  'biosynthesized': ['VBN'],
  'biotech': ['JJ'],
  'biotechnology': ['NN'],
  'biotechnology-based': ['JJ'],
  'bipartisan': ['JJ'],
  'bipartisanship': ['NN'],
  'biped': ['NN'],
  'biplane': ['NN'],
  'biplanes': ['NNS'],
  'biracial': ['JJ'],
  'birch': ['NN'],
  'birch-paneled': ['JJ'],
  'birches': ['NNS'],
  'bird': ['NN'],
  'bird\'s-eye': ['JJ'],
  'bird-brain': ['NN'],
  'birdbath': ['NN'],
  'birdcage': ['NN'],
  'birdie': ['NN'],
  'birdied': ['VBD'],
  'birdies': ['NNS'],
  'birdlike': ['JJ'],
  'birds': ['NNS'],
  'birefringence': ['NN'],
  'birth': ['NN'],
  'birth-control': ['NN'],
  'birth-defect': ['NN'],
  'birth-prevention': ['NN'],
  'birthcontrol': ['NN'],
  'birthday': ['NN'],
  'birthdays': ['NNS'],
  'birthed': ['VBN'],
  'birthmark': ['NN'],
  'birthplace': ['NN'],
  'birthrate': ['NN'],
  'birthright': ['NN'],
  'births': ['NNS'],
  'biscotti': ['NNS'],
  'biscuit': ['NN'],
  'biscuits': ['NNS'],
  'bisexual': ['JJ'],
  'bishop': ['NN'],
  'bishopry': ['NN'],
  'bishops': ['NNS'],
  'bison': ['NN'],
  'bisque': ['NN'],
  'bistros': ['NNS'],
  'bit': ['NN'],
  'bit-like': ['JJ'],
  'bitch': ['NN'],
  'bitches': ['NNS'],
  'bitchy': ['JJ'],
  'bite': ['VB'],
  'bite-sized': ['JJ'],
  'bitee': ['NN'],
  'biter': ['NN'],
  'bites': ['NNS'],
  'biting': ['VBG'],
  'bitingly': ['RB'],
  'bits': ['NNS'],
  'bitten': ['VBN'],
  'bitter': ['JJ'],
  'bitterest': ['JJS'],
  'bitterly': ['RB'],
  'bitterness': ['NN'],
  'bitters': ['NNS'],
  'bittersweet': ['JJ'],
  'bituminous': ['JJ'],
  'bivouac': ['NN'],
  'biwa': ['FW'],
  'biweekly': ['JJ'],
  'biz': ['NN'],
  'bizarre': ['JJ'],
  'bizarrely': ['RB'],
  'blabbed': ['VBD'],
  'blabs': ['VBZ'],
  'black': ['JJ'],
  'black-and-orange': ['JJ'],
  'black-and-white': ['JJ'],
  'black-and-yellow': ['JJ'],
  'black-balled': ['VBN'],
  'black-bearded': ['JJ'],
  'black-body': ['JJ'],
  'black-clad': ['JJ'],
  'black-consumer': ['NN'],
  'black-crowned': ['JJ'],
  'black-draped': ['JJ'],
  'black-eyed': ['JJ'],
  'black-figured': ['JJ'],
  'black-haired': ['JJ'],
  'black-majority': ['JJ'],
  'black-market': ['JJ'],
  'black-on-black': ['JJ'],
  'black-owned': ['JJ'],
  'black-robed': ['JJ'],
  'black-tie': ['JJ'],
  'black-tipped': ['JJ'],
  'black-white': ['JJ'],
  'blackballed': ['VBN'],
  'blackberry': ['NN'],
  'blackberry-basil': ['NN'],
  'blackbird': ['NN'],
  'blackbirds': ['NNS'],
  'blackboard': ['NN'],
  'blacked': ['VBN'],
  'blacked-in': ['JJ'],
  'blacked-out': ['JJ'],
  'blackened': ['VBN'],
  'blackening': ['NN'],
  'blacker': ['JJR'],
  'blackest': ['JJS'],
  'blacking': ['NN'],
  'blackjack': ['NN'],
  'blacklist': ['VB'],
  'blacklisting': ['NN'],
  'blackmail': ['NN'],
  'blackmailed': ['VBN'],
  'blackmailer': ['NN'],
  'blackmailers': ['NNS'],
  'blackmailing': ['VBG'],
  'blackness': ['NN'],
  'blackout': ['NN'],
  'blackouts': ['NNS'],
  'blacks': ['NNS'],
  'blacksmith': ['NN'],
  'bladder': ['NN'],
  'blade': ['NN'],
  'blades': ['NNS'],
  'blame': ['VB'],
  'blamed': ['VBD'],
  'blames': ['VBZ'],
  'blaming': ['VBG'],
  'blanche': ['JJ'],
  'blanching': ['VBG'],
  'bland': ['JJ'],
  'blander': ['JJR'],
  'blandly': ['RB'],
  'blandness': ['NN'],
  'blank': ['JJ'],
  'blank-faced': ['JJ'],
  'blanket': ['NN'],
  'blanketed': ['VBD'],
  'blankets': ['NNS'],
  'blanks': ['NNS'],
  'blared': ['VBD'],
  'blares': ['VBZ'],
  'blaring': ['VBG'],
  'blarney': ['NN'],
  'blase': ['JJ'],
  'blasphemed': ['VBD'],
  'blasphemers': ['NNS'],
  'blasphemies': ['NNS'],
  'blasphemous': ['JJ'],
  'blasphemy': ['NN'],
  'blast': ['NN'],
  'blastdown': ['NN'],
  'blasted': ['VBD'],
  'blasting': ['VBG'],
  'blasts': ['NNS'],
  'blatancy': ['NN'],
  'blatant': ['JJ'],
  'blatantly': ['RB'],
  'blaze': ['NN'],
  'blazed': ['VBD'],
  'blazer': ['NN'],
  'blazing': ['VBG'],
  'blazon': ['VB'],
  'bleach': ['NN'],
  'bleached': ['JJ'],
  'bleacher': ['NN'],
  'bleacher-type': ['JJ'],
  'bleachers': ['NNS'],
  'bleaching': ['VBG'],
  'bleak': ['JJ'],
  'bleaker': ['JJR'],
  'bleakly': ['RB'],
  'bleary': ['JJ'],
  'bleat': ['NN'],
  'bleating': ['VBG'],
  'bleats': ['NNS'],
  'blebs': ['NNS'],
  'bled': ['VBD'],
  'bleed': ['VB'],
  'bleeders': ['NNS'],
  'bleeding': ['VBG'],
  'bleedings': ['NNS'],
  'bleeps': ['NNS'],
  'blem': ['NN'],
  'blemish': ['NN'],
  'blemishes': ['NNS'],
  'blend': ['NN'],
  'blended': ['JJ'],
  'blender': ['NN'],
  'blenders': ['NNS'],
  'blending': ['VBG'],
  'blends': ['NNS'],
  'bless': ['VB'],
  'blessed': ['VBN'],
  'blessing': ['NN'],
  'blessings': ['NNS'],
  'blest': ['VB'],
  'blew': ['VBD'],
  'blight': ['NN'],
  'blighted': ['VBN'],
  'blind': ['JJ'],
  'blind-folded': ['JJ'],
  'blind-pool': ['JJ'],
  'blind-sided': ['JJ'],
  'blinded': ['VBN'],
  'blindfold': ['NN'],
  'blindfolded': ['VBN'],
  'blinding': ['JJ'],
  'blindly': ['RB'],
  'blindness': ['NN'],
  'blinds': ['NNS'],
  'blindsided': ['VBN'],
  'blini': ['NNS'],
  'blink': ['VB'],
  'blinked': ['VBD'],
  'blinkers': ['NNS'],
  'blinking': ['JJ'],
  'blinks': ['VBZ'],
  'blip': ['NN'],
  'blips': ['NNS'],
  'bliss': ['NN'],
  'blissful': ['JJ'],
  'blissfully': ['RB'],
  'blister': ['NN'],
  'blistered': ['VBN'],
  'blistering': ['VBG'],
  'blisters': ['NNS'],
  'blithe': ['JJ'],
  'blithely': ['RB'],
  'blitz': ['NN'],
  'blitzes': ['NNS'],
  'blitzing': ['VBG'],
  'blitzkrieg': ['NN'],
  'blizzard': ['NN'],
  'blizzards': ['NNS'],
  'bloat': ['NN'],
  'bloated': ['JJ'],
  'bloating': ['NN'],
  'blob': ['NN'],
  'blobby': ['JJ'],
  'bloc': ['NN'],
  'block': ['NN'],
  'block-buster': ['NN'],
  'block-grant': ['JJ'],
  'block-trading': ['NN'],
  'blockade': ['NN'],
  'blockading': ['VBG'],
  'blockages': ['NNS'],
  'blockbuster': ['NN'],
  'blockbusters': ['NNS'],
  'blocked': ['VBN'],
  'blocker': ['NN'],
  'blockhouse': ['NN'],
  'blocking': ['VBG'],
  'blocks': ['NNS'],
  'blocky': ['JJ'],
  'blocs': ['NNS'],
  'blog': ['NN'],
  'bloke': ['NN'],
  'blokes': ['NNS'],
  'blond': ['JJ'],
  'blonde': ['JJ'],
  'blonde-haired': ['JJ'],
  'blonde-headed': ['JJ'],
  'blondes': ['NNS'],
  'blood': ['NN'],
  'blood-alcohol': ['NN'],
  'blood-and-guts': ['JJ'],
  'blood-bought': ['JJ'],
  'blood-cell': ['NN'],
  'blood-chilling': ['JJ'],
  'blood-clot': ['NN'],
  'blood-clotting': ['JJ'],
  'blood-filled': ['JJ'],
  'blood-flecked': ['JJ'],
  'blood-flow': ['NNS'],
  'blood-forming': ['JJ'],
  'blood-in-the-streets': ['NNS'],
  'blood-kinship': ['NN'],
  'blood-letting': ['NN'],
  'blood-lust': ['NN'],
  'blood-pressure': ['JJ'],
  'blood-red': ['NN'],
  'blood-soaked': ['JJ'],
  'blood-specked': ['JJ'],
  'blood-sport': ['JJ'],
  'blood-stained': ['JJ'],
  'blood-thirsty': ['JJ'],
  'bloodbath': ['NN'],
  'blooded': ['VBN'],
  'bloodhounds': ['NNS'],
  'bloodied': ['JJ'],
  'bloodiest': ['JJS'],
  'bloodless': ['JJ'],
  'bloodletting': ['VBG'],
  'bloodlust': ['NN'],
  'bloodroot': ['NN'],
  'bloods': ['NNS'],
  'bloodshed': ['NN'],
  'bloodshot': ['JJ'],
  'bloodspots': ['NNS'],
  'bloodstained': ['JJ'],
  'bloodstains': ['NNS'],
  'bloodstream': ['NN'],
  'bloodsucking': ['VBG'],
  'bloodthirsty': ['JJ'],
  'bloody': ['JJ'],
  'bloody-minded': ['JJ'],
  'bloom': ['NN'],
  'bloomed': ['VBD'],
  'blooming': ['VBG'],
  'blooms': ['NNS'],
  'blooper': ['NN'],
  'bloops': ['NNS'],
  'blossom': ['VB'],
  'blossomed': ['VBD'],
  'blossoms': ['NNS'],
  'blot': ['NN'],
  'blot-appearance': ['NN'],
  'blot-like': ['JJ'],
  'blotch': ['NN'],
  'blotches': ['NNS'],
  'blots': ['NNS'],
  'blotted': ['VBD'],
  'blotting': ['VBG'],
  'blouse': ['NN'],
  'blouses': ['NNS'],
  'blow': ['NN'],
  'blow-up': ['NN'],
  'blower': ['NN'],
  'blowfish': ['NN'],
  'blowing': ['VBG'],
  'blown': ['VBN'],
  'blown-up': ['VBN'],
  'blowout': ['NN'],
  'blows': ['NNS'],
  'blowtorch': ['NN'],
  'blowup': ['NN'],
  'blubber': ['NN'],
  'bludgeon': ['VB'],
  'bludgeoned': ['VBN'],
  'bludgeoned\'em': ['NN'],
  'blue': ['JJ'],
  'blue-black': ['JJ'],
  'blue-blood': ['JJ'],
  'blue-blooded': ['JJ'],
  'blue-carpeted': ['JJ'],
  'blue-chip': ['JJ'],
  'blue-chips': ['NNS'],
  'blue-collar': ['JJ'],
  'blue-collar-mail': ['JJ'],
  'blue-draped': ['JJ'],
  'blue-eyed': ['JJ'],
  'blue-eyes': ['NNS'],
  'blue-glazed': ['JJ'],
  'blue-green': ['JJ'],
  'blue-ribbon': ['JJ'],
  'blue-sky': ['JJ'],
  'blue-uniformed': ['JJ'],
  'blueberries': ['NNS'],
  'blueberry': ['NN'],
  'bluebloods': ['NNS'],
  'bluebonnets': ['NNS'],
  'bluebook': ['NN'],
  'bluebush': ['NN'],
  'bluechip': ['JJ'],
  'bluefish': ['NNS'],
  'blueprint': ['NN'],
  'blueprints': ['NNS'],
  'blues': ['NNS'],
  'bluest': ['JJS'],
  'bluestocking': ['NN'],
  'bluesy': ['JJ'],
  'bluff': ['NN'],
  'bluffing': ['VBG'],
  'bluffs': ['NNS'],
  'bluing': ['NN'],
  'bluish': ['JJ'],
  'blunder': ['NN'],
  'blundered': ['VBD'],
  'blunderings': ['NNS'],
  'blunders': ['NNS'],
  'blunt': ['VB'],
  'blunted': ['VBD'],
  'blunter': ['NN'],
  'bluntest': ['RBS'],
  'bluntly': ['RB'],
  'bluntness': ['NN'],
  'blunts': ['VBZ'],
  'blur': ['NN'],
  'blurred': ['VBN'],
  'blurring': ['VBG'],
  'blurry': ['JJ'],
  'blurt': ['NN'],
  'blurted': ['VBD'],
  'blurting': ['VBG'],
  'blush': ['NN'],
  'blushed': ['VBD'],
  'blushes': ['NNS'],
  'blushing': ['VBG'],
  'bluster': ['NN'],
  'blustered': ['VBD'],
  'blustery': ['JJ'],
  'blutwurst': ['NN'],
  'bo\'sun\'s': ['NN'],
  'boa': ['NN'],
  'boar': ['NNS'],
  'board': ['NN'],
  'board-level': ['JJ'],
  'boarded': ['VBD'],
  'boarder': ['NN'],
  'boarding': ['VBG'],
  'boarding-home': ['NN'],
  'boardinghouses': ['NNS'],
  'boardings': ['NNS'],
  'boardroom': ['NN'],
  'boardrooms': ['NNS'],
  'boards': ['NNS'],
  'boast': ['VBP'],
  'boasted': ['VBD'],
  'boastful': ['JJ'],
  'boastfully': ['RB'],
  'boasting': ['VBG'],
  'boastings': ['NNS'],
  'boasts': ['VBZ'],
  'boat': ['NN'],
  'boat-building': ['JJ'],
  'boat-rocker...': [':'],
  'boat-yard': ['NN'],
  'boatels': ['NNS'],
  'boaters': ['NNS'],
  'boathouses': ['NNS'],
  'boating': ['NN'],
  'boatload': ['NN'],
  'boatloads': ['NNS'],
  'boatman': ['NN'],
  'boats': ['NNS'],
  'boatsmen': ['NNS'],
  'boatswain': ['NN'],
  'boatyards': ['NNS'],
  'bobbed': ['VBD'],
  'bobbin-to-cone': ['JJ'],
  'bobbing': ['VBG'],
  'bobbins': ['NNS'],
  'bobbles': ['NNS'],
  'bobby': ['NN'],
  'bobby-sox': ['NN'],
  'bobby-soxer': ['NN'],
  'bockwurst': ['NN'],
  'bodacious': ['JJ'],
  'bode': ['VB'],
  'boded': ['VBD'],
  'bodegas': ['NNS'],
  'bodes': ['VBZ'],
  'bodice': ['NN'],
  'bodied': ['JJ'],
  'bodies': ['NNS'],
  'bodily': ['JJ'],
  'bods': ['NNS'],
  'body': ['NN'],
  'body-and-assembly': ['JJ'],
  'body-numbing': ['JJ'],
  'body-tissue': ['NN'],
  'bodybuilder': ['NN'],
  'bodybuilders': ['NNS'],
  'bodybuilding': ['NN'],
  'bodyguard': ['NN'],
  'bodyguards': ['NNS'],
  'bodyweight': ['NN'],
  'bodyworkers': ['NNS'],
  'bog': ['VB'],
  'bogey': ['NN'],
  'bogey-symbol': ['NN'],
  'bogeyed': ['VBD'],
  'bogeymen': ['NNS'],
  'bogeys': ['NNS'],
  'bogged': ['VBD'],
  'bogging': ['VBG'],
  'boggled': ['VBD'],
  'bogies': ['NNS'],
  'bogs': ['VBZ'],
  'bogus': ['JJ'],
  'bogy': ['NN'],
  'bohemian': ['JJ'],
  'boies': ['NNS'],
  'boil': ['VB'],
  'boiled': ['VBN'],
  'boiler': ['NN'],
  'boiler-burner': ['NN'],
  'boiler-room': ['NN'],
  'boilerplate': ['NN'],
  'boilers': ['NNS'],
  'boiling': ['VBG'],
  'boils': ['VBZ'],
  'bois': ['FW'],
  'boisterous': ['JJ'],
  'boite': ['NNP'],
  'boites': ['NNS'],
  'bold': ['JJ'],
  'bolder': ['JJR'],
  'boldest': ['JJS'],
  'boldly': ['RB'],
  'boldness': ['NN'],
  'boll': ['NN'],
  'bolo': ['NN'],
  'bolognaise': ['FW'],
  'bolster': ['VB'],
  'bolstered': ['VBN'],
  'bolstering': ['VBG'],
  'bolsters': ['VBZ'],
  'bolt': ['NN'],
  'bolt-action': ['JJ'],
  'bolted': ['VBN'],
  'bolting': ['VBG'],
  'bolts': ['NNS'],
  'bomb': ['NN'],
  'bomb-detection': ['JJ'],
  'bomb-plant': ['JJ'],
  'bomb-proof': ['JJ'],
  'bombard': ['VB'],
  'bombarded': ['VBD'],
  'bombarding': ['VBG'],
  'bombardment': ['NN'],
  'bombardments': ['NNS'],
  'bombast': ['NN'],
  'bombastic': ['JJ'],
  'bombed': ['VBN'],
  'bomber': ['NN'],
  'bombers': ['NNS'],
  'bombing': ['NN'],
  'bombings': ['NNS'],
  'bomblets': ['NNS'],
  'bombproof': ['NN'],
  'bombs': ['NNS'],
  'bombshell': ['NN'],
  'bon': ['FW'],
  'bona': ['FW'],
  'bonanza': ['NN'],
  'bonanzas': ['NNS'],
  'bond': ['NN'],
  'bond-equivalent': ['JJ'],
  'bond-financed': ['JJ'],
  'bond-fund': ['NN'],
  'bond-futures': ['NNS'],
  'bond-holders': ['NNS'],
  'bond-insurance': ['JJ'],
  'bond-market': ['JJ'],
  'bond-price': ['JJ'],
  'bond-rating': ['JJ'],
  'bond-trading': ['JJ'],
  'bond-underwriting': ['JJ'],
  'bondage': ['NN'],
  'bonded': ['VBN'],
  'bondholder': ['NN'],
  'bondholders': ['NNS'],
  'bondholdings': ['NNS'],
  'bonding': ['VBG'],
  'bondmarket': ['NN'],
  'bonds': ['NNS'],
  'bondsman': ['NN'],
  'bone': ['NN'],
  'bone-deep': ['JJ'],
  'bone-loss': ['NN'],
  'bone-marrow': ['NN'],
  'bone-weary': ['JJ'],
  'boned': ['VBN'],
  'bones': ['NNS'],
  'bonfire': ['NN'],
  'bonfires': ['NNS'],
  'bongo': ['NN'],
  'bonheur': ['NN'],
  'bonkers': ['JJ'],
  'bonnet': ['NN'],
  'bonnets': ['NNS'],
  'bono': ['FW'],
  'bonus': ['NN'],
  'bonuses': ['NNS'],
  'bony': ['JJ'],
  'bonzes': ['NNS'],
  'boo': ['VB'],
  'boobify': ['VB'],
  'booboo': ['NN'],
  'booboos': ['NNS'],
  'booby': ['JJ'],
  'booby-trap': ['NN'],
  'boodleoo': ['UH'],
  'booed': ['VBD'],
  'boogie': ['NN'],
  'boogieman': ['NN'],
  'booing': ['VBG'],
  'book': ['NN'],
  'book-breaking': ['JJ'],
  'book-burning': ['JJ'],
  'book-buying': ['JJ'],
  'book-entry': ['JJ'],
  'book-flogging': ['JJ'],
  'book-lined': ['JJ'],
  'book-publishing': ['NN'],
  'book-review': ['NN'],
  'book-selection': ['NN'],
  'book-to-bill': ['JJ'],
  'bookcase': ['NN'],
  'bookcases': ['NNS'],
  'booked': ['VBN'],
  'booker': ['NN'],
  'bookers': ['NNS'],
  'bookies': ['NNS'],
  'booking': ['NN'],
  'bookings': ['NNS'],
  'bookish': ['JJ'],
  'bookkeeper': ['NN'],
  'bookkeeping': ['NN'],
  'booklet': ['NN'],
  'booklets': ['NNS'],
  'booklists': ['NNS'],
  'books': ['NNS'],
  'bookseller': ['NN'],
  'bookshelf': ['NN'],
  'bookshelves': ['NNS'],
  'bookstore': ['NN'],
  'bookstores': ['NNS'],
  'boom': ['NN'],
  'boom-and-bust': ['JJ'],
  'boom-boom-boom': ['JJ'],
  'boom-boxes': ['NNS'],
  'boom-or-bust': ['JJ'],
  'boomed': ['VBD'],
  'boomerang': ['NN'],
  'boomerangs': ['NNS'],
  'boomers': ['NNS'],
  'booming': ['JJ'],
  'booms': ['NNS'],
  'boomtown': ['NN'],
  'boon': ['NN'],
  'boondoggle': ['NN'],
  'boondoggler': ['NN'],
  'boondoggles': ['NNS'],
  'boorish': ['JJ'],
  'boors': ['NNS'],
  'boos': ['NNS'],
  'boost': ['VB'],
  'boosted': ['VBD'],
  'booster': ['NN'],
  'boosters': ['NNS'],
  'boosting': ['VBG'],
  'boosts': ['NNS'],
  'boot': ['NN'],
  'boot-stomping': ['JJ'],
  'boot-wearer': ['JJ'],
  'booted': ['VBN'],
  'booth': ['NN'],
  'booths': ['NNS'],
  'booting': ['VBG'],
  'bootleg': ['JJ'],
  'bootlegged': ['VBN'],
  'bootlegger': ['NN'],
  'bootleggers': ['NNS'],
  'bootlegging': ['NN'],
  'boots': ['NNS'],
  'booty': ['NN'],
  'booze': ['NN'],
  'boozed-out': ['JJ'],
  'boozing': ['VBG'],
  'bop': ['NN'],
  'borates': ['NNS'],
  'borax': ['NN'],
  'border': ['NN'],
  'bordered': ['VBN'],
  'bordering': ['VBG'],
  'borderlands': ['NNS'],
  'borderline': ['JJ'],
  'borders': ['NNS'],
  'bore': ['VBD'],
  'bore\\\'': ['VBP'],
  'bored': ['VBN'],
  'boredom': ['NN'],
  'borer': ['NN'],
  'borers': ['NNS'],
  'bores': ['NNS'],
  'boring': ['JJ'],
  'boringly': ['RB'],
  'born': ['VBN'],
  'born-again': ['JJ'],
  'born-to-shop': ['JJ'],
  'borne': ['VBN'],
  'borough': ['NN'],
  'boroughs': ['NNS'],
  'borrow': ['VB'],
  'borrowed': ['VBN'],
  'borrower': ['NN'],
  'borrowers': ['NNS'],
  'borrowing': ['NN'],
  'borrowings': ['NNS'],
  'borrows': ['VBZ'],
  'bosom': ['NN'],
  'bosoms': ['NNS'],
  'bosons': ['NNS'],
  'boss': ['NN'],
  'bossed': ['VBN'],
  'bosses': ['NNS'],
  'bossman': ['NN'],
  'botanical': ['JJ'],
  'botanist': ['NN'],
  'botanists': ['NNS'],
  'botany': ['NN'],
  'botched': ['VBN'],
  'both': ['DT'],
  'bother': ['VB'],
  'bothered': ['VBN'],
  'bothering': ['VBG'],
  'bothers': ['VBZ'],
  'bothersome': ['JJ'],
  'bottle': ['NN'],
  'bottled': ['JJ'],
  'bottled-water': ['JJ'],
  'bottleneck': ['NN'],
  'bottlenecks': ['NNS'],
  'bottler': ['NN'],
  'bottlers': ['NNS'],
  'bottles': ['NNS'],
  'bottling': ['NN'],
  'bottom': ['NN'],
  'bottom-down': ['JJ'],
  'bottom-dwelling': ['JJ'],
  'bottom-fishers': ['NNS'],
  'bottom-fishing': ['NN'],
  'bottom-line': ['JJ'],
  'bottom-living': ['JJ'],
  'bottom-of-the-barrel': ['JJ'],
  'bottomed': ['VBN'],
  'bottoming': ['VBG'],
  'bottomless': ['JJ'],
  'bottoms': ['NNS'],
  'botulinum': ['NN'],
  'bouanahsha': ['FW'],
  'boucle': ['NN'],
  'bouffant': ['JJ'],
  'bouffe': ['NN'],
  'bough': ['NN'],
  'boughs': ['NNS'],
  'bought': ['VBD'],
  'boulder': ['NN'],
  'boulders': ['NNS'],
  'boulevard': ['NN'],
  'boulevards': ['NNS'],
  'boun': ['NN'],
  'bounce': ['VB'],
  'bounced': ['VBD'],
  'bounces': ['VBZ'],
  'bouncing': ['VBG'],
  'bouncy': ['JJ'],
  'bound': ['VBN'],
  'boundaries': ['NNS'],
  'boundary': ['NN'],
  'bounded': ['VBN'],
  'bounding': ['VBG'],
  'boundless': ['JJ'],
  'bounds': ['NNS'],
  'bounty': ['NN'],
  'bounty-hunting': ['NN'],
  'bountyhunters': ['NNS'],
  'bouquet': ['NN'],
  'bouquets': ['NNS'],
  'bourbon': ['NN'],
  'bourbons': ['NNS'],
  'bourgeois': ['JJ'],
  'bourgeois-bashing': ['JJ'],
  'bourgeoisie': ['NNS'],
  'bourses': ['NNS'],
  'bout': ['NN'],
  'bout-de-souffle': ['FW'],
  'boutique': ['NN'],
  'boutique-lined': ['JJ'],
  'boutique-store': ['NN'],
  'boutiques': ['NNS'],
  'bouts': ['NNS'],
  'bovine': ['JJ'],
  'bovines': ['NNS'],
  'bow': ['NN'],
  'bow-tied': ['JJ'],
  'bowed': ['VBD'],
  'bowel': ['NN'],
  'bowels': ['NNS'],
  'bower': ['NN'],
  'bowing': ['VBG'],
  'bowl': ['NN'],
  'bowl-shaped': ['JJ'],
  'bowled': ['VBN'],
  'bowling': ['NN'],
  'bowling-league': ['NN'],
  'bowling-related': ['JJ'],
  'bowls': ['NNS'],
  'bows': ['NNS'],
  'bowstring': ['NN'],
  'box': ['NN'],
  'box-office': ['NN'],
  'box-sized': ['JJ'],
  'boxcar': ['NN'],
  'boxcars': ['NNS'],
  'boxed': ['VBN'],
  'boxed-in': ['JJ'],
  'boxer': ['NN'],
  'boxes': ['NNS'],
  'boxing': ['NN'],
  'boxy': ['JJ'],
  'boy': ['NN'],
  'boy-furiendo': ['NN'],
  'boy-manager': ['NN'],
  'boy-meets-girl': ['NN'],
  'boy-name': ['NN'],
  'boyars': ['NNS'],
  'boycott': ['NN'],
  'boycotted': ['VBN'],
  'boycotting': ['VBG'],
  'boycotts': ['NNS'],
  'boyfriend': ['NN'],
  'boyfriends': ['NNS'],
  'boyhood': ['NN'],
  'boyish': ['JJ'],
  'boyish-looking': ['JJ'],
  'boys': ['NNS'],
  'bra': ['NN'],
  'brace': ['NN'],
  'braced': ['VBN'],
  'bracelet': ['NN'],
  'braces': ['NNS'],
  'brachii': ['NNS'],
  'bracing': ['VBG'],
  'bracket': ['NN'],
  'brackets': ['NNS'],
  'brackish': ['JJ'],
  'brad': ['NN'],
  'bradykinin': ['NN'],
  'brag': ['VB'],
  'braggadocio': ['NN'],
  'bragged': ['VBD'],
  'bragging': ['VBG'],
  'brags': ['VBZ'],
  'brah': ['FW'],
  'braided': ['JJ'],
  'braiding': ['VBG'],
  'braids': ['NNS'],
  'brain': ['NN'],
  'brain-damaged': ['JJ'],
  'brain-wave': ['JJ'],
  'brain-wracking': ['JJ'],
  'brainchild': ['NN'],
  'brainlessly': ['RB'],
  'brainpower': ['NN'],
  'brains': ['NNS'],
  'brainstorm': ['NN'],
  'brainwashed': ['VBN'],
  'brainwashing': ['NN'],
  'brainy': ['JJ'],
  'braised': ['VBN'],
  'brake': ['NN'],
  'brakes': ['NNS'],
  'braking': ['VBG'],
  'brambles': ['NNS'],
  'bran': ['NN'],
  'bran-processing': ['JJ'],
  'branch': ['NN'],
  'branch-by-branch': ['RB'],
  'branched': ['VBN'],
  'branches': ['NNS'],
  'branching': ['VBG'],
  'branchline': ['JJ'],
  'brand': ['NN'],
  'brand-loyal': ['JJ'],
  'brand-name': ['JJ'],
  'brand-new': ['JJ'],
  'branded': ['VBN'],
  'brandin': ['NN'],
  'brandished': ['VBD'],
  'brandishes': ['VBZ'],
  'brandishing': ['VBG'],
  'brands': ['NNS'],
  'brandy': ['NN'],
  'brash': ['JJ'],
  'brashest': ['JJS'],
  'brashness': ['NN'],
  'brass': ['NN'],
  'brass-bound': ['JJ'],
  'brasses': ['NNS'],
  'brassiere': ['NN'],
  'brassieres': ['NNS'],
  'brassiness': ['NN'],
  'brassy': ['JJ'],
  'brat': ['NN'],
  'brats': ['NNS'],
  'bratwurst': ['NN'],
  'bravado': ['NN'],
  'brave': ['JJ'],
  'braved': ['VBD'],
  'bravely': ['RB'],
  'braver': ['JJR'],
  'bravery': ['NN'],
  'bravest': ['JJS'],
  'bravest-feathered': ['JJ'],
  'braving': ['VBG'],
  'bravura': ['NN'],
  'braweling': ['VBG'],
  'brawl': ['NN'],
  'brawle': ['NN'],
  'brawling': ['NN'],
  'brawny': ['JJ'],
  'braying': ['JJ'],
  'brazen': ['JJ'],
  'brazenly': ['RB'],
  'brazenness': ['NN'],
  'brazier': ['NN'],
  'brazil': ['NN'],
  'breach': ['NN'],
  'breach-of-contract': ['JJ'],
  'breached': ['VBD'],
  'breaches': ['NNS'],
  'breaching': ['VBG'],
  'bread': ['NN'],
  'bread-and-butter': ['JJ'],
  'breadbasket': ['NN'],
  'breadbox': ['NN'],
  'breaded': ['VBN'],
  'breadth': ['NN'],
  'break': ['VB'],
  'break-away': ['NN'],
  'break-down': ['NN'],
  'break-even': ['JJ'],
  'break-in': ['NN'],
  'break-neck': ['JJ'],
  'break-the-rules': ['JJ'],
  'break-through': ['NN'],
  'break-up': ['NN'],
  'break.': ['NN'],
  'breakables': ['NNS'],
  'breakage': ['NN'],
  'breakaway': ['NN'],
  'breakdown': ['NN'],
  'breakdowns': ['NNS'],
  'breaker': ['NN'],
  'breakers': ['NNS'],
  'breakeven': ['JJ'],
  'breakfast': ['NN'],
  'breakfast-table': ['NN'],
  'breakfasted': ['VBD'],
  'breakfasts': ['NNS'],
  'breakin': ['VBG'],
  'breaking': ['VBG'],
  'breaking-out': ['NN'],
  'breakneck': ['JJ'],
  'breakoff': ['JJ'],
  'breaks': ['NNS'],
  'breakthrough': ['NN'],
  'breakthroughs': ['NNS'],
  'breakup': ['NN'],
  'breakups': ['NNS'],
  'breakwater': ['NN'],
  'breakwaters': ['NNS'],
  'breast': ['NN'],
  'breast-cancer': ['NN'],
  'breasts': ['NNS'],
  'breastworks': ['NNS'],
  'breath': ['NN'],
  'breath-taking': ['JJ'],
  'breathalyzer': ['NN'],
  'breathe': ['VB'],
  'breathed': ['VBD'],
  'breather': ['NN'],
  'breathes': ['VBZ'],
  'breathing': ['NN'],
  'breathless': ['JJ'],
  'breathlessly': ['RB'],
  'breaths': ['NNS'],
  'breathtaking': ['JJ'],
  'breathy': ['JJ'],
  'bred': ['VBN'],
  'breeches': ['NNS'],
  'breed': ['NN'],
  'breeder': ['NN'],
  'breeders': ['NNS'],
  'breeding': ['VBG'],
  'breeds': ['NNS'],
  'breeze': ['NN'],
  'breezes': ['NNS'],
  'breezier': ['JJR'],
  'breezy': ['JJ'],
  'brethren': ['NNS'],
  'brevity': ['NN'],
  'brew': ['NN'],
  'brewed': ['VBN'],
  'brewer': ['NN'],
  'breweries': ['NNS'],
  'brewers': ['NNS'],
  'brewery': ['NN'],
  'brewery-scion-turned-banker': ['NN'],
  'brewing': ['NN'],
  'brewing-assets': ['NNS'],
  'brews': ['VBZ'],
  'bribe': ['NN'],
  'bribed': ['VBD'],
  'bribers': ['NNS'],
  'bribery': ['NN'],
  'bribery-related': ['JJ'],
  'bribes': ['NNS'],
  'bribing': ['VBG'],
  'bric-a-brac': ['NN'],
  'brick': ['NN'],
  'brick-and-mortar': ['JJ'],
  'bricklayers': ['NNS'],
  'bricklaying': ['NN'],
  'bricks': ['NNS'],
  'bridal': ['JJ'],
  'bride': ['NN'],
  'bride-gift': ['NN'],
  'bridegroom': ['NN'],
  'brides': ['NNS'],
  'bridesmaids': ['NNS'],
  'bridge': ['NN'],
  'bridge-financing': ['JJ'],
  'bridge-lending': ['JJ'],
  'bridge-loan': ['JJ'],
  'bridged-T': ['NNP'],
  'bridgehead': ['NN'],
  'bridgeheads': ['NNS'],
  'bridges': ['NNS'],
  'bridgework': ['NN'],
  'bridging': ['VBG'],
  'bridle': ['NN'],
  'bridled': ['VBN'],
  'brie': ['NN'],
  'brief': ['JJ'],
  'briefcase': ['NN'],
  'briefcases': ['NNS'],
  'briefed': ['VBN'],
  'briefer': ['JJR'],
  'briefest': ['JJS'],
  'briefing': ['NN'],
  'briefings': ['NNS'],
  'briefly': ['NN'],
  'briefly-illumed': ['VBN'],
  'briefs': ['NNS'],
  'brig': ['NN'],
  'brigade': ['NN'],
  'brigades': ['NNS'],
  'brigadier': ['NN'],
  'brigands': ['NNS'],
  'bright': ['JJ'],
  'bright-eyed': ['JJ'],
  'bright-green': ['JJ'],
  'bright-looking': ['JJ'],
  'bright-red': ['JJ'],
  'brighten': ['VB'],
  'brightened': ['VBD'],
  'brightener': ['NN'],
  'brightening': ['VBG'],
  'brightens': ['VBZ'],
  'brighter': ['JJR'],
  'brightest': ['JJS'],
  'brightly': ['RB'],
  'brightness': ['NN'],
  'brilliance': ['NN'],
  'brilliant': ['JJ'],
  'brilliantly': ['RB'],
  'brim': ['NN'],
  'brimful': ['JJ'],
  'brimmed': ['VBD'],
  'brimming': ['VBG'],
  'brimstone': ['NN'],
  'brindle': ['NN'],
  'brine': ['NN'],
  'bring': ['VB'],
  'bringing': ['VBG'],
  'brings': ['VBZ'],
  'brink': ['NN'],
  'brinkmanship': ['NN'],
  'brinksmanship': ['NN'],
  'briny': ['JJ'],
  'briquette': ['NN'],
  'briquettes': ['NNS'],
  'brisk': ['JJ'],
  'brisker': ['JJR'],
  'briskly': ['RB'],
  'briskness': ['NN'],
  'bristle': ['VBP'],
  'bristled': ['VBD'],
  'bristles': ['VBZ'],
  'bristling': ['VBG'],
  'brittle': ['JJ'],
  'bro': ['NN'],
  'broach': ['VB'],
  'broached': ['VBN'],
  'broad': ['JJ'],
  'broad-appeal': ['JJ'],
  'broad-based': ['JJ'],
  'broad-brimmed': ['JJ'],
  'broad-nibbed': ['JJ'],
  'broad-scale': ['JJ'],
  'broad-scaled': ['JJ'],
  'broadcast': ['NN'],
  'broadcast-and-cable': ['JJ'],
  'broadcaster': ['NN'],
  'broadcasters': ['NNS'],
  'broadcasting': ['NN'],
  'broadcastings': ['NNS'],
  'broadcasts': ['NNS'],
  'broaden': ['VB'],
  'broadened': ['VBN'],
  'broadening': ['VBG'],
  'broadens': ['VBZ'],
  'broader': ['JJR'],
  'broader-based': ['JJ'],
  'broadest': ['JJS'],
  'broadly': ['RB'],
  'broadside': ['JJ'],
  'brocade': ['NN'],
  'brocaded': ['JJ'],
  'broccoli': ['NNS'],
  'brochure': ['NN'],
  'brochures': ['NNS'],
  'brockle': ['NN'],
  'broil': ['NN'],
  'broiled': ['VBN'],
  'broiler': ['NN'],
  'broiling': ['VBG'],
  'brok': ['VBD'],
  'broke': ['VBD'],
  'broken': ['VBN'],
  'broken-backed': ['JJ'],
  'broken-down': ['JJ'],
  'broken-nosed': ['JJ'],
  'brokenly': ['RB'],
  'broker': ['NN'],
  'broker-dealer': ['NN'],
  'broker-dealers': ['NNS'],
  'broker-sold': ['JJ'],
  'brokerage': ['NN'],
  'brokerage-by-brokerage': ['JJ'],
  'brokerage-firm': ['JJ'],
  'brokerage-house': ['NN'],
  'brokerage-stock': ['NN'],
  'brokerages': ['NNS'],
  'brokered': ['JJ'],
  'brokering': ['VBG'],
  'brokers': ['NNS'],
  'bromides': ['NNS'],
  'bromphenol': ['NN'],
  'bronc': ['NN'],
  'bronchi': ['NNS'],
  'bronchial': ['JJ'],
  'bronchiolar': ['JJ'],
  'bronchiole': ['NN'],
  'bronchioles': ['NNS'],
  'bronchiolitis': ['NN'],
  'bronchitis': ['NN'],
  'bronchus': ['NN'],
  'broncs': ['NNS'],
  'bronze': ['NN'],
  'bronzed': ['JJ'],
  'bronzes': ['NNS'],
  'bronzy-green-gold': ['JJ'],
  'brooch': ['NN'],
  'brood': ['NN'],
  'brooded': ['VBD'],
  'brooding': ['VBG'],
  'broods': ['NNS'],
  'broody': ['JJ'],
  'brook': ['NN'],
  'brooked': ['VBD'],
  'brooken': ['VBN'],
  'broom': ['NN'],
  'broth': ['NN'],
  'brothel': ['NN'],
  'brothels': ['NNS'],
  'brother': ['NN'],
  'brother-in-law': ['NN'],
  'brotherhood': ['NN'],
  'brotherism': ['NN'],
  'brotherly': ['JJ'],
  'brothers': ['NNS'],
  'brought': ['VBN'],
  'brouhaha': ['NN'],
  'brow': ['NN'],
  'brow-beating': ['NN'],
  'browbeat': ['VB'],
  'browbeaten': ['VBN'],
  'brown': ['JJ'],
  'brown-black': ['JJ'],
  'brown-coal': ['NN'],
  'brown-edged': ['JJ'],
  'brown-paper': ['JJ'],
  'brown-tobacco': ['JJ'],
  'browned': ['VBN'],
  'brownies': ['NNS'],
  'browning': ['VBG'],
  'brownish': ['JJ'],
  'brownouts': ['NNS'],
  'browny': ['JJ'],
  'browny-haired': ['JJ'],
  'brows': ['NNS'],
  'browse': ['VB'],
  'browser': ['NN'],
  'browsing': ['VBG'],
  'browsing.': ['NN'],
  'brucellosis': ['NN'],
  'bruddah': ['FW'],
  'bruh': ['NN'],
  'bruinish': ['JJ'],
  'bruise': ['NN'],
  'bruised': ['VBN'],
  'bruises': ['NNS'],
  'bruising': ['JJ'],
  'bruited': ['VBN'],
  'brunch': ['NN'],
  'brunches': ['NNS'],
  'brunette': ['JJ'],
  'brunettes': ['NNS'],
  'brunt': ['NN'],
  'brush': ['NN'],
  'brushbacks': ['NNS'],
  'brushcut': ['NN'],
  'brushed': ['VBD'],
  'brushes': ['NNS'],
  'brushfire': ['NN'],
  'brushing': ['VBG'],
  'brushlike': ['JJ'],
  'brushoff': ['NN'],
  'brushwork': ['NN'],
  'brushy': ['JJ'],
  'brusquely': ['RB'],
  'brutal': ['JJ'],
  'brutal-and': ['JJ', 'CC'],
  'brutalism': ['NN'],
  'brutalities': ['NNS'],
  'brutality': ['NN'],
  'brutalized': ['VBN'],
  'brutally': ['RB'],
  'brute': ['NN'],
  'brutes': ['NNS'],
  'brutish': ['JJ'],
  'brynge': ['VBP'],
  'bubble': ['NN'],
  'bubbled': ['VBN'],
  'bubblelike': ['JJ'],
  'bubbles': ['NNS'],
  'bubbling': ['VBG'],
  'bubbly': ['JJ'],
  'buccaneers': ['NNS'],
  'buccolic': ['JJ'],
  'buck': ['NN'],
  'buckaroos': ['NNS'],
  'buckboard': ['NN'],
  'buckboards': ['NNS'],
  'bucked': ['VBD'],
  'bucket': ['NN'],
  'bucket-shop': ['JJ'],
  'buckets': ['NNS'],
  'bucking': ['VBG'],
  'bucking-up': ['NN'],
  'buckle': ['VB'],
  'buckle-on': ['JJ'],
  'buckled': ['VBD'],
  'buckles': ['NNS'],
  'buckling': ['VBG'],
  'bucks': ['NNS'],
  'buckshot': ['NN'],
  'buckskin': ['NN'],
  'buckskins': ['NNS'],
  'buckwheat': ['NN'],
  'bucolic': ['JJ'],
  'bud': ['NN'],
  'budded': ['VBD'],
  'buddies': ['NNS'],
  'budding': ['VBG'],
  'buddy': ['NN'],
  'budge': ['VB'],
  'budged': ['VBD'],
  'budget': ['NN'],
  'budget\$': ['\$'],
  'budget-altering': ['JJ'],
  'budget-cutting': ['NN'],
  'budget-hotel': ['NN'],
  'budget-making': ['JJ'],
  'budget-priced': ['JJ'],
  'budget-reconciliation': ['JJ'],
  'budget-reduction': ['JJ'],
  'budget-sensitive': ['JJ'],
  'budget-strapped': ['JJ'],
  'budget-wise': ['JJ'],
  'budgetary': ['JJ'],
  'budgeted': ['VBN'],
  'budgeteers': ['NNS'],
  'budgeting': ['NN'],
  'budgets': ['NNS'],
  'buds': ['NNS'],
  'budworm': ['NN'],
  'buff': ['NN'],
  'buffalo': ['NN'],
  'buffaloes': ['NNS'],
  'buffer': ['NN'],
  'buffered': ['VBN'],
  'buffet': ['NN'],
  'buffeted': ['VBN'],
  'buffetings': ['NNS'],
  'buffets': ['NNS'],
  'buffetted': ['VBN'],
  'buffetting': ['NN'],
  'buffing': ['VBG'],
  'buffoon': ['NN'],
  'buffoons': ['NNS'],
  'buffs': ['NNS'],
  'bug': ['NN'],
  'bug-free': ['JJ'],
  'bugaboo': ['NN'],
  'bugaboos': ['NNS'],
  'bugeyed': ['JJ'],
  'bugged': ['VBN'],
  'buggers': ['NNS'],
  'buggies': ['NNS'],
  'bugging': ['NN'],
  'buggy': ['NN'],
  'bugle': ['NN'],
  'bugler': ['NN'],
  'bugless': ['JJ'],
  'buglike': ['JJ'],
  'bugs': ['NNS'],
  'build': ['VB'],
  'build\'em': ['VBP', 'PP'],
  'build-better-for-less': ['JJ'],
  'build-up': ['NN'],
  'build-ups': ['NNS'],
  'builder': ['NN'],
  'builder-dealer': ['JJ'],
  'builders': ['NNS'],
  'buildin': ['VBG'],
  'building': ['NN'],
  'building-control': ['NN'],
  'building-materials': ['NNS'],
  'building-products': ['NNS'],
  'building-related': ['JJ'],
  'building-society': ['JJ'],
  'building-supplies': ['NNS'],
  'buildings': ['NNS'],
  'builds': ['VBZ'],
  'buildup': ['NN'],
  'built': ['VBN'],
  'built-detergent': ['JJ'],
  'built-from-kit': ['JJ'],
  'built-in': ['JJ'],
  'built-soap': ['NN'],
  'builtin': ['JJ'],
  'bulb': ['NN'],
  'bulb-making': ['JJ'],
  'bulbs': ['NNS'],
  'bulge': ['NN'],
  'bulged': ['VBD'],
  'bulging': ['VBG'],
  'bulk': ['NN'],
  'bulk-buying': ['JJ'],
  'bulk-chemical': ['NN', 'JJ'],
  'bulk-mail': ['NN'],
  'bulked': ['VBD'],
  'bulked-up': ['JJ'],
  'bulkhead': ['NN'],
  'bulkheads': ['NNS'],
  'bulking': ['VBG'],
  'bulks': ['VBZ'],
  'bulky': ['JJ'],
  'bull': ['NN'],
  'bull\'s-eye': ['NN'],
  'bull\'s-eyes': ['NNS'],
  'bull-headed': ['JJ'],
  'bull-like': ['JJ'],
  'bull-m