## 小程序

## 说说提高微信小程序的应用速度的手段有哪些

- 控制代码包的大小
- 分包加载
- 首屏体验（预请求，利用缓存，避免白屏，及时反馈

小程序渲染性能：

- 避免不当的使用 setData
- 使用自定义组件

## 微信小程序登陆具体实现的逻辑

- 通过 wx.login() 获取到用户的 code 判断用户是否授权读取用户信息，调用 wx.getUserInfo 读取用户数据
- 由于小程序后台授权域名无法授权微信的域名，所以需要自身后端调用微信服务器获取用户信息
- 通过 wx.request() 方法请求业务方服务器，后端把 appid , appsecret 和 code 一起发送到微信服务器。 appid 和 appsecret 都是微信提供的，可以在管理员后台找到
- 微信服务器返回了 openid 及本次登录的会话密钥 session_key
- 后端从数据库中查找 openid ，如果没有查到记录，说明该用户没有注册，如果有记录，则继续往下走
- session_key 是对用户数据进行加密签名的密钥。为了自身应用安全，session_key 不应该在网络上传输
- 然后生成 session 并返回给小程序
- 小程序把 session 存到 storage 里面
- 下次请求时，先从 storage 里面读取，然后带给服务端
- 服务端对比 session 对应的记录，然后校验有效期

实际业务中，我们还需要登录态是否过期，通常的做法是在登录态（临时令牌）中保存有效期数据，该有效期数据应该在服务端校验登录态时和约定的时间（如服务端本地的系统时间或时间服务器上的标准时间）做对比

这种方法需要将本地存储的登录态发送到小程序的服务端，服务端判断为无效登录态时再返回需重新执行登录过程的消息给小程

另一种方式可以通过调用 wx.checkSession 检查微信登陆态是否过期：

- 如果过期，则发起完整的登录流程
- 如果不过期，则继续使用本地保存的自定义登录态

这种方式的好处是不需要小程序服务端来参与校验，而是在小程序端调用

## 小程序的微信授权流程

- 什么是小程序的微信授权流程？说人话：用微信账号登录自家服务器
- 在小程序端 wx.login()得到登录码 code
- 小程序请求自家的登录接口，携带登录码 code
- 自家服务器请求微信服务器，使用 appid+appSecret+code 换回 session_key 与 openid
- 自家服务器将 session_key 与 openid 重新换算为自家的登录信息(如 token)
- 小程序在后续请求自家服务器的过程中都携带该 token,自家服务器就知道小程序端已经登录过了

## 微信支付流程

- 用户点击下单；
- 调用 wx.login 获取临时登录凭证 code，发送到后端换取 openId；
- 将商品信息（id、数量等）+ 用户的 openId 一并通过购买接口发送服务端；
- 服务器综合以上信息生成订单+签名（根据微信支付 SDK 要求生成），向微信支付后台发送支付请求，获取其返回的预付款订单 id(prepay_id)，同时再次根据微信支付 SDK 要求生成预付款订单签名，二者一并响应给小程序端；
- 小程序端调用 wx.requestPayment()发起微信支付，此时微信内部的支付窗口被唤醒，用户输入支付密码或指纹；
- 微信支付后台处理支付，将结果同时推送给小程序端和我们自己的服务端；
