# 场景 和 某些解决方案

## 常见的登录鉴权方式有哪些

::: details
前端登录鉴权的方式主要有以下几种：

- 基于 `Session Cookie` 的鉴权：

  - cookie: 用户在登录成功后，服务器会生成一个包含用户信息的 Cookie，并返回给前端。前端在后续的请求中会自动携带这个 Cookie，在服务器端进行验证和识别用户身份。
  - Session: 用户登录成功后，服务器会在后端保存用户的登录状态信息，并生成一个唯一的 Session ID，将这个 Session ID 返回给前端。前端在后续的请求中需要携带这个 Session ID，服务器通过 Session ID 来验证用户身份。

- `单点登录（Single Sign-On，SSO）`：

  单点登录是一种将多个应用系统进行集成的认证方式。用户只需登录一次，即可在多个系统中完成认证，避免了重复登录的麻烦。常见的单点登录协议有 CAS（Central Authentication Service）、SAML（Security Assertion Markup Language）等。

- `OpenID Connect（OIDC）`：

  OIDC 是基于 OAuth2.0 的身份验证协议，通过在认证和授权过程中引入身份提供者，使得用户可以使用第三方身份提供者（如 Google、Facebook 等）进行登录和授权，从而实现用户身份验证和授权的功能。

- `OAuth2.0`：

  OAuth2.0 是一个授权框架，用于授权第三方应用访问用户的资源。它通过授权服务器颁发令牌（Token），使得第三方应用可以代表用户获取资源的权限，而无需知道用户的真实凭证。

- `LDAP（Lightweight Directory Access Protocol）`

  LDAP 是一种用于访问和维护分布式目录服务的协议。在登录鉴权中，LDAP 常用于验证用户的身份信息，如用户名和密码，通过与 LDAP 服务器进行通信来进行用户身份验证。

- `2FA（Two-Factor Authentication）`：
  二次验证是一种提供额外安全层的身份验证方式。与传统的用户名和密码登录不同，2FA 需要用户提供第二个验证因素，如手机验证码、指纹识别、硬件令牌等，以提高账户的安全性。
  :::

## 单点登录是如何实现的

单点登录：Single Sign On，简称 SSO。用户只要登录一次，就可以访问所有相关信任应用的资源。企业里面用的会比较多，有很多内网平台，但是只要在一个系统登录就可以。
::: details 实现方案

- 单一域名：可以把 `cookie 种在根域名`下实现单点登录
- 多域名：常用 CAS 来解决，新增一个`认证中心`的服务。CAS（Central Authentication Service）是实现 SSO 单点登录的框架

**CAS 实现单点登录的流程：**

1. 用户访问系统 A，判断未登录，则直接跳到认证中心页面
2. 在认证中心页面输入账号，密码，生成令牌，重定向到 系统 A
3. 在系统 A 拿到令牌到认证中心去认证，认证通过，则建立对话
4. 用户访问系统 B，发现没有有效会话，则重定向到认证中心
5. 认证中心发现有全局会话，新建令牌，重定向到系统 B
6. 在系统 B 使用令牌去认证中心验证，验证成功后，建议系统 B 的局部会话。

:::

## 扫码登录的实现方式

核心原理是实现一个中转站，该中转站通常由提供商提供，用于维护手机和 PC 之间的会话状态。扫码登录是一种基于二维码的身份验证方式，用户通过扫描二维码完成登录。

常见的扫码登录方式有：

::: details

1. **基于二维码的登录**：用户在移动设备上打开应用，点击登录按钮，应用会生成一个二维码，用户使用手机扫描二维码，应用会自动登录。
2. **基于短信验证码的登录**：用户在移动设备上打开应用，点击登录按钮，应用会发送一条短信验证码到用户的手机，用户输入验证码后，应用会自动登录。

整个扫码登录的流程如下：

1. 用户选择扫码登录；应用生成一个随机的认证码，该认证码通过二维码形式显示在 PC 端页面上
2. 用户打开手机应用选择扫码登录，应用打开手机端相机进行扫描
3. 一旦扫描二维码，手机应用会向应用提供商的中转站发送请求（该请求包含之前生成的随机认证码和手机端会话的 ID）
4. 中转站验证认证码和 ID 是否匹配，匹配成功将用户身份信息发给应用，并创建一个 PC 短和 APP 端之间的会话状态
5. 应用拿到信息与用户信息进行认证，并创建一个关联该用户的会话状态。同时返回一个通过认证的响应给中转站
6. 中转站将该响应返回给 APP 端应用，并携带一个用于表示该会话的令牌，此时手机和 PC 间的认证流程完成
7. 当用户在 PC 端进行其他操作时，应用将回话令牌附加在请求中，并通过中转站向手机应用发起请求

:::

## 关于白屏问题，排查思路

逐步排查：

1. 网络问题：检查网络
2. 服务端问题：未正确相应用户请求，检查日志，服务器状态等
3. 前端代码问题：前端代码错误，导致无法渲染，开发者工具调试、断点等
4. 浏览器兼容性：开发者工具下调试，看不同浏览器下的表现
5. 第三方资源加载：检查第三方资源是否加载成功，如 CDN、JS脚本等
6. 缓存问题：旧页面或资源缓存导致新版本无法加载，尝试清除强制刷新
7. 其他：安全策略、跨域、DNS解析等

## 参考

- [2024 年第一波常见面试题汇总](https://juejin.cn/post/7319311129867010111)——晴小篆
