# 综合整理

> 浏览器相关的，不知道杂细分类的都放这了

## 如何实现浏览器多个标签通信

::: details 通过中介者模式实现：

标签页和中介者进行通信，然后让这个中介者来进行消息的转发。通
信方法如下：

- 使用 `websocket` 协议，因为 websocket 协议可以实现服务器推送。所以服务器就可以用来当做这个中介者。标签页通过向服务器发送数据，然后由服务器向其他标签页推送转发。

- 使用 `ShareWorker` 的方式，shareWorker 会在页面存在的生命周期内创建一个唯一的线程，并且开启多个页面也只会使用同一个线程。这个时候共享线程就可以充当中介者的角色。标签页间通过共享一个线程，然后通过这个共享的线程来实现数据的交换。

- 使用 `localStorage` 的方式，我们可以在一个标签页对 localStorage 的变化事件进行监听，然后当另一个标签页修改数据的时候，我们就可以通过这个监听事件来获取到数据。这个时候 localStorage 对象就是充当的中介者的角色。

- 使用 `postMessage` 方法，如果我们能够获得对应标签页的引用，就可以使用 postMessage 方法，进行通信。

:::

## 说下浏览器常见内核

::: details

- Trident 早期 IE
- Gecko Firefox
- Presto Opera
- `Webkit` Webkit 是 `Safari` 采用的内核，是 KHTML 的一个开源的分支
- `Blink` 谷歌在 `Chromium` 项目中研发 Blink 渲染引
  擎（即浏览器核心），内置于 Chrome 浏览器之中

:::

## 前端存储方式有哪些

::: details

- cookies 优点：兼容性好，请求头⾃带；缺点是⼤⼩只有 4k，⾃动请求头加⼊ cookie 浪费流量，domain 限制 20 个，使用麻烦；

- `localStorage` 优点是操作⽅便，永久性储存（除非⼿动删除），大小为 5M

- sessionStorage 与 localStorage 基本类似，区别是 sessionStorage 页面关闭后失效，而且与 cookie、localStorage 不同，不能在所有同源窗⼝中共享，是会话级别的储存⽅式

- IndexedDB 正式纳⼊ HTML5 标准的数据库储存方案，它是 NoSQL 数据库，⽤键值对进行储存，可以进行快速读取操作。

:::

## GC

### 说一下 JavaScript 的垃圾回收机制

::: details
JavaScript 具有自动垃圾收集机制（GC：GarbageCollecation），也就是说，执行环境会负责管理代码执行过程中使用的内存。

JS 环境中分配的内存一般有如下生命周期：

- `内存分配`：当我们申明变量、函数、对象,并执行的时候，系统会自动为他们分配内存
- `内存使用`：即读写内存，也就是使用变量、函数等
- `内存回收`：使用完毕，由垃圾回收机制自动回收不再使用的内存

浏览器会定期从全局对象中扫描内存中的对象，根据是否需要使用，将内存回收。

常见的垃圾回收策略：

- 引用计数 老 IE，无法处理循环引用
- 标记清除 无法从根对象查询到的对象都将被清除，积累内存碎片较多
- V8 算法

| 回收算法     | Mark-Sweep   | Mark-Compact | Scavenge           |
| ------------ | ------------ | ------------ | ------------------ |
| 速度         | 中等         | 最慢         | 最快               |
| 空间开销     | 少（有碎片） | 少（无碎片） | 双倍空间（无碎片） |
| 是否移动对象 | 否           | 是           | 是                 |

:::
