# 经典题

[直击概念 - 浏览器工作原理](../../%E7%9B%B4%E5%87%BB%E6%A6%82%E5%BF%B5/12broswer/s_bw_1-broswer.md)

## 从浏览器输入 url 到页面渲染经历了什么

> 先来精简版，见招拆招，避免说一大堆不到重点，面试官若想深究细节，自然会问的

::: details

1. 先通过 DNS 解析，拿到 url 对应 IP 地址
2. 与服务器 “三次握手” 建立 HTTP 连接
3. 发送 HTTP 请求返 HTML 给浏览器
4. 判断缓存情况，最终拿到 HTML
5. 解析 HTML -> 构建 DOM 树
6. 解析 CSS -> 构建 CSSOM 树
7. 下载所需 CSS、JS、图片等资源
8. Layout 布局，确定渲染树中所有节点的宽度、高度和位置
9. RenderTree 绘制 将各个节点绘制到屏幕上
10. 等待交互
    :::

::: warning 注意
构建 DOM 树，构建 CSSOM 树，及下载所需资源这几步没有严格的先后顺序
:::

### DNS 怎么解析的

::: details DNS 是应用层协议，用于将用户提供的主机名解析为 ip 地址。具体过程如下：

1. **浏览器缓存**：当用户通过浏览器访问某域名时，浏览器首先会在自己的缓存中查找是否有该域名对应的 IP 地址（若曾经访问过该域名且没有清空，缓存便存在）

2. **系统缓存**：当浏览器缓存中无域名对应 IP 则会检查用户计算机系统 Hosts 文件 DNS 缓存是否有该域名对应的 IP

3. **路由器缓存**：当浏览器及系统缓存中均无域名对应 IP 则进入路由器缓存中检查，以上三步均为客户端的 DNS 查询

4. **ISP（互联网服务提供商）DNS 缓存**：当在客户端查找不到域名对应 IP 地址，则进入 ISP DNS 缓存中查询

5. **根域名服务器**：以上均未完成，则进入根服务器进行查询

6. **顶级域名服务器**：顶级域名服务器收到请求后查看区域文件记录，若无则将其管辖范围内主域名服务器的 IP 地址告诉本地 DNS 服务器

7. **主域名服务器**：主域名服务器接受到请求后查询自己的缓存，如果没有则进入下一级域名服务器进行查找，并重复该步骤直至找到正确记录

8. **保存结果至缓存**：本地域名服务器把返回的结果保存到缓存，以备下一次使用，同时将该结果反馈给客户端，客户端通过这个 IP 地址与 web 服务器建立链接

:::

### 说一下三次握手

::: details

1. 客户端发送一个 TCP 的 SYN=1，Seq=X 的包到服务器端口

2. 服务器发回 SYN=1， ACK=X+1， Seq=Y 的响应包

3. 客户端发送 ACK=Y+1， Seq=Z

:::

TCP 链接建立后发送 HTTP 请求

### 说一下四次挥手

::: details 关闭 TCP 连接的四次挥手如下：

浏览器接收 HTTP 响应，然后根据情况选择关闭 TCP 连接或者保留重用：

1. 客户端 -> 发送释放请求 FIN -> 服务端
2. 服务端 -> 发送 ACK -> 客户端
3. 服务端 -> FIN -> 客户端
4. 客户端 -> ACK + 1 -> 服务端确认并关闭
   :::

### 浏览器是如何解析 JavaScript 脚本的

::: details

1. 浏览器`创建 Document 对象`并`解析 HTML`，将解析到的元素和文本节点`添加到文档`中，此时 `document.readystate` 为 `loading`

2. HTML 解析器遇到没有 async 和 defer 的 script 时，将他们添加到文档中，然后执行行内或外部脚本：

- 这些脚本会`同步执行`，并且在脚本下载和执行时解析器会暂停。
- 这样就可以用 document.write()把文本插入到输入流中。
- 同步脚本经常简单定义函数和注册事件处理程序，他们可以遍历和操作 script 和他们之前的文档内容

3. 当解析器遇到设置了 async 属性的 script 时，开始`下载`脚本并`继续解析`文档：

- 脚本会在它下载完成后尽快执行，但是解析器不会停下来等它下载。
- 异步脚本禁止使用 document.write()，它们可以访问自己 script 和之前的文档元素

4. 当文档完成解析，`document.readState` 变成 `interactive`

5. 所有 `defer` 脚本会按照在文档出现的`顺序执行`，延迟脚本能访问完整文档树，禁止使用 document.write()

6. 浏览器在 Document 对象上触发 `DOMContentLoaded` 事件

7. 此时文档完全解析完成，浏览器可能还在等待如图片等内容加载，
   等这些内容完成载入并且所有异步脚本完成载入和执行，`document.readState` 变为 `complete`，window 触发 `load` 事件

:::

完成以上，最后显示页面（HTML 解析过程中会逐步显示页面）

### 浏览器是如何进行渲染的

::: details
1. 解析HTML，生成DOM树和CSSOM树
2. 样式计算 - Computed Style
3. 布局，生成 Layout 树
4. 分层 - Layer
5. 绘制 - Paint
6. 分块 - Compositing
7. 光栅化 - Raster
8. 呈现 - Draw
:::