# Vue 其他

可能涉及相关概念，如 MVVM，Virtual DOM，与其他几家的比较。先都放一起了

## 谈谈对 MVVM 的理解

::: details

- Model-View-ViewModel
- MVVM 是一种设计思想（设计模式）
- 对 ViewModel 通过双向数据绑定把 View 层和 Model 层连接了起来，而 View 和 Model 之间的 同步工作完全是自动的
- 只需关注业务逻辑，复杂的数据状态维护完全由 MVVM 来统一管理
  :::

## Vitual DOM - 虚拟 DOM 的解析过程

::: details 虚拟 DOM 的解析过程：

1. 首先对将要插入到文档中的 `DOM 树结构进行分析`，使`用 js 对象将其表示`出来
2. 然后将这个 js 对象树给保存下来，最后再`将 DOM 片段插入到文档中`
3. 当页面的状态发生改变，根据变更的状态，`重新构建起虚拟的 DOM 树`
4. 将新旧对象树进行比较（`Diff算法`），记录差异
5. 最后将差异部分应用（`Patch`）到真正的 DOM 树中去
6. 以上过程完成后`视图就对应更新`了

:::

## Diff 算法原理

::: details
在新老虚拟 DOM 对比时，对比节点本身，判断如下：

- 如果不为相同节点，则删除该节点重新创建节点进行替换

- 如果为相同节点，进行 patchVnode，判断如何对该节点的子节点进行处理：

  1. 先判断 A 有子节点 B 没有子节点的情况（如果新的 children 没有子节点，将旧的子节点移除）
  2. 比较都有子节点，则进行 updateChildren，判断如何对这些新老节点的子节点进行操作（`diff 核心`）。

- 匹配时，**找到相同的子节点**，`递归比较子节点`：

在 `diff 中，只对同层的子节点进行比较`，放弃跨级的节点比较，使得时间复杂从 O(n^3)降低值 O(n)，也就是说，只有**当新旧 children 都为多个子节点时才需要用核心的 Diff 算法进行同层级比较**。
:::

## Vue 与 React 对比

### 相同点

::: details

- 提倡组件化思想
- 支持服务端渲染
- 都有 Virtual DOM 虚拟 DOM
- 数据驱动视图
- 支持 Native 方案 weex、React Native
- 构建工具，各自的完整生态圈
  :::

### 区别

::: details

- `数据流向`不同。React 推崇单向数据流；而 Vue 是双向数据流
- `数据变化实现原理`不同。React 使用不可变数据；而 Vue 使用可变数据
- `组件通信方式`不同。React 中通过回调函数进行通信；而 Vue 中子组件通过事件和回调函数来通信
- `Diff算法`不同。React 使用 diff 队列保存需要更新哪些 DOM，得到 patch 树，再统一操作批量更新；Vue 使用双向指针，边对比，边更新 DOM。
  :::

## 谈谈 Vue 的优点

::: details

- 数据驱动视图，渐进式框架
- 响应式编程，通过 MVVM 思想实现数据的双向绑定，更关注逻辑处理
- 组件化开发，提高开发效率，方便重用，利于单元测试，提升可维护性
- 虚拟 DOM，有效提高 DOM 操作性能，利于服务端渲染
  :::

## template 和 jsx 的区别

::: details

- template 和 jsx 的都是 render 函数的一种表现形式，不同的是：JSX 具有更高的灵活性，在复杂的组件中，更具有优势，而 template 在代码结构上`更符合视图与逻辑分离`的习惯，更`简单、更直观、更好维护`。

- 在 webpack 中，使用 vue-loader 编译.vue 文件，内部依赖的 vue-template-compiler 模块`将 template 预编译成 render 函数`。在添加了 jsx 的语法糖解析器 babel-plugin-transform-vue-jsx 之后，就可以直接手写 render 函数。
  :::

## 对组件化和模块化的理解

::: details

- 模块化：是`从代码逻辑角度进行划分`的，保证每个模块的职能单一；比如登录页的登录功能，就是一个模块，注册功能又算一个模块。
- 组件化：是`从 UI 界面的角度划分`的；页面上的每个独立的区域，都可以视为一个组件，前端组件化开发，便于 UI 组件的复用，减少编码量。
  其实组件化是 UI 界面层面，模块化是代码逻辑层面。
- 为什么要使用组件化和模块化
  1. `开发和调试效率高`：随着代码结构越发复杂，要修改某一个功能，可能要把所有相同的地方都修改一遍，浪费时间和人力；使用组件化，每个相同的功能结构都调用同一个组件，只需要修改这个组件。
  2. `可维护性强`：便于后期代码查找和维护
  3. `避免阻断`：模块化是可以独立运行的，如果一个模块产生了 bug，不会影响其他模块的调用。
  4. `版本管理更容易`，如果由多人协作开发，可以避免代码覆盖和冲突。
:::


## 参考

- [2023 前端 vue 面试题及答案](https://juejin.cn/post/7204844328111374391)
- [高频前端面试题汇总之Vue篇 （上）](https://juejin.cn/post/7205882403948560444)
