# 常见性能优化策略

优化方式整合：

- DNS 预解析 `rel="dns-prefetch"`
- CDN 结合缓存策略

## 如何优化 CSS

### 加载性能

- CSS 打包压缩，减小文件体积
- CSS 使用单一样式

  background-image 优于 background，margin-left: 0 优于 margin: 0；

- 减少 @import（等待页面加载完成才解析）；建议使用 link（页面加载时一起解析）

### 选择器性能

1. 关键选择器（key selector）。选择器的最后面的部分为关键
   选择器（即用来匹配目标元素的部分）。CSS 选择符是从右到左进行
   匹配的。当使用后代选择器的时候，浏览器会遍历所有子元素来确定
   是否是指定的元素等等；

2. 如果规则拥有 ID 选择器作为其关键选择器，则不要为规则增加
   标签。过滤掉无关的规则

3. 避免使用通配规则，如 `* {}` 计算次数惊人，只对需要用到的元素进行选择
4. 尽量少的去对标签进行选择，而是用 class
5. 尽量少的去使用后代选择器，降低选择器的权重值。后代选择
   器的开销是最高的，尽量将选择器的深度降到最低，最高不要超过三
   层，更多的使用类来关联每一个标签元素。
6. 了解哪些属性是可以通过继承而来的，然后避免对这些属性重
   复指定规则。

### 渲染性能

1. 慎用高消耗布局属性：Table、浮动、定位；
2. 尽量减少页面重排、重绘；
3. 去除空规则：`{}` (预留样式，可通过 webpack 等去除)
4. 属性值为 0 时，可不加单位；
5. 正确使用 display: none 和 visibility: hidden
6. 正确使用 display 的属性，因 display 的设置某些样式组合会无效，徒增样式体积的同时也影响解析性能。
7. 不滥用 web 字体。web fonts 通常体积庞大，而且一些浏览器在下载 web fonts 时会阻塞页面渲染损伤性能。

### 其他考量：可维护性、健壮性

- 将具有相同属性的样式抽离出来，整合并通过 class 在页面中
  进行使用，提高 css 的可维护性。
- 样式与内容分离：将 css 代码定义到外部 css 中。

## 参考

- [前端性能优化系列——DNS 预解析和优化 ⚡](https://juejin.cn/post/7285915718667124771)
- [全面了解高性能利器——CDN（内容分发网络）](https://juejin.cn/post/7287913415804600331)

作者：前端掘金者 H
