# Node.js 基础

## 说一下 Node.js 的主要优点

::: details

- `异步编程模型`：Node.js 采用了事件驱动、非阻塞 I/O 模型，使其能够在大量连接的情况下保持高性能和稳定性。

- `单一编程语言`：Node.js 使用的是 `JavaScript`，这是一种被广大开发者所熟悉的语言，能够大大降低学习成本。

- `开源社区活跃`：Node.js 有一个非常活跃的开源社区，有大量的模块可供使用，极大地提高了开发效率。

- `跨平台性`：Node.js 可以在多种操作系统上运行，如 Windows、Linux、macOS 等。

- `高性能`：由于 Node.js 的`非阻塞 I/O 模型`，使其在处理大量并发请求时具有极高的性能。

- `数据密集型`应用：Node.js 擅长处理数据密集型应用，如`实时通信`、`实时流媒体`、实时游戏等。

综上所述，Node.js 凭借其独特的`异步编程模型`和强大的社区支持，成为了一种优秀的`服务器端`技术选择。

:::

## Node.js 的事件循环

### 浏览器的时间循环处理

<Image src="../../public/05node/eventloop-bw.png" alt="浏览器的事件循环"/>

### Node 的事件循环处理

<Image src="../../public/05node/eventloop-node.png" alt="Node的事件循环"/>

- `timers` 阶段

在 timers 阶段会执行已经被  setTimeout()  和  setInterval()  的调度回调函数。

- `pending callbacks` 阶段

上一次循环队列中，还未执行完毕的会在这个阶段进行执行。比如延迟到下一个 Loop 之中的 I/O 操作。

- `idle` 、 `prepare`

其实这一步我们不需要过多的关系，它仅仅是在 NodeJs 内部调用。我们无法进行操作这一步，所以我们仅仅了解存在 idle prepare 这一层即可。

- `poll`

这一阶段被称为轮询阶段，它主要会检测新的 I/O 相关的回调，需要注意的是这一阶段会存在阻塞（也就意味着这之后的阶段可能不会被执行）

- `check`

check 阶段会检测 setImmediate()  回调函数在这个阶段进行执行。

- `close callbacks`

这个阶段会执行一系列关闭的回调函数，比如如：socket.on('close', ...)。
其实 NodeJs 中的事件循环机制主要就是基于以上几个阶段，但是对于我们比较重要的来说仅仅只有 timers、poll 和 check 阶段，因为这三个阶段影响着我们代码书写的执行顺序。

至于 pending callbacks、idle, prepare 、close callbacks 其实对于我们代码的执行顺序并不存在什么强耦合，甚至有些时候我们完全不必在意他们。

## 如何在 Node.js 中处理 HTTP 请求和响应

::: details
在 Node.js 中处理 HTTP 请求和响应的基本流程如下：

1. 创建 HTTP 服务端程序。首先需要使用 http 模块创建一个 HTTP 服务端程序，并设置相应的回调函数。
2. 监听 HTTP 请求事件。然后需要使用 http.createServer() 方法创建一个 HTTP 服务实例，并监听 request 事件接收客户端发送来的 HTTP 请求。
3. 处理 HTTP 请求。当接收到 HTTP 请求时，需要解析请求头、查询字符串以及请求体中的数据，并根据请求的方法和路径来确定具体的响应内容。
4. 设置响应头和状态码。接着需要设置响应头和状态码，并将响应内容写入响应体中。
5. 发送响应到客户端。最后需要使用 `response.end()` 方法将响应发送回客户端。

通过以上步骤，可以在 Node.js 中有效地处理 HTTP 请求和响应，为用户提供丰富的 Web 功能和服务。
需要注意的是，由于 Node.js 是`单线程模型`，因此在`同一时刻`只能`处理一个`请求。为了能够同时处理多个请求，可以通过`集群`、`负载均衡`等方式将多个请求分发到不同的 Node.js 进程中进行处理。

:::

## 说说 Node.js的集群化工作模式

::: details

Node.js 的集群化工作模式是一种`利用多个进程`同时运行 Node.js 应用来`实现负载均衡`的技术。它可以充分利用`多核 CPU 的计算能力`，并且可以`减少单个进程的压力`，从而**提高应用的可用性和性能**。

在 Node.js 中，可以使用内置的 `cluster` 模块来创建多个子进程，每个子进程都可以独立地运行 Node.js 应用。在主进程中，可以使用 `cluster.fork()` 方法创建一个新的子进程，并将其绑定到一个端口上。当有新的连接请求到达时，Node.js 会根据当前的负载情况将请求分发到一个空闲的子进程中进行处理。

此外，Node.js 还提供了一些`内置的策略`来实现负载均衡，如 `round-robin` 和 `least-connections` 等。用户可以根据自己的实际需求选择合适的负载均衡策略，以达到最佳的效果。

总之，Node.js 的集群化工作模式可以有效地提高应用的性能和可用性，特别是在处理大量并发请求时尤其有用。

:::

## 参考

- [面试宝典-NodeJs 面试题合集](https://juejin.cn/post/7309158181841829938)
- [「多图详解」NodeJs 中 EventLoop 与浏览器下的差异性](https://juejin.cn/post/7077122129107353636?searchId=20240307121644574CCF4D4A751480DB31)——19 组清风
