# 事件 Event

温故知新 [直击概念 - 事件 Event](../../%E7%9B%B4%E5%87%BB%E6%A6%82%E5%BF%B5/02js/s_js_5-event.md)

## 事件机制

### 说一下 JS 的事件机制

::: details

- 事件发生时会在元素节点之间按照特定的顺序传播，就是 DOM 事件流。
- 通常，一个事件会从父元素开始向目标元素传播，然后它将被传播回父元素。
- 包括三个阶段：事件捕获阶段、处于目标阶段、事件冒泡阶段。
  
:::

### 什么是事件捕获

::: details

事件捕获（event capturing）： 当鼠标点击或者触发 dom 事件时（被触发 dom 事件的这个元素被叫作事件源），浏览器会从根节点 => 事件源 `由外到内进行事件传播`。

事件捕获与事件冒泡是比较类似的，最大的不同在于事件传播的方向。

:::

### 什么是事件冒泡

::: details
事件冒泡（dubbed bubbling）：当一个元素接收到事件的时候，会把他接收到的事件传给自己的父级，一直到 window （注意这里传递的仅仅是事件，例如 click、focus 等等这些事件，  并不传递所绑定的事件函数。）

事件源 => 根节点 `由内到外进行事件传播`。

:::

### 什么是事件委托

::: details
事件委托也称为事件代理。就是`利用事件冒泡，把子元素的事件都绑定到父元素上`。如果子元素阻止了事件冒泡，那么委托就无法实现。

**优点：**

1. **替代循环绑定事件的操作，减少内存消耗，提高性能**。比如：

   - 在 table 上代理所有 td 的 click 事件。
   - 在 ul 上代理所有 li 的 click 事件。

2. **简化了 dom 节点更新时，相应事件的更新**。比如：

   - 不用在新添加的 li 上绑定 click 事件。
   - 当删除某个 li 时，不用移解绑上面的 click 事件。

**缺点：**

1. `事件委托基于冒泡`，对于不冒泡的事件不支持。
2. 层级过多，冒泡过程中，可能会被某层阻止掉。
3. 理论上委托会导致浏览器`频繁调用处理函数`，虽然很可能不需要处理。所以建议`就近委托`，比如在 table 上代理 td，而不是在 document 上代理 td。

:::

## 参考

- [JS 中的事件冒泡、事件捕获、事件委托](https://juejin.cn/post/7192584563799883832)
