# Sticky 粘黏布局

<script setup>
import Sticky from './sticky.vue';
</script>

## position: sticky 

**如果不考虑兼容性情况下，强烈建议使用css实现，少写好多代码**

<Sticky />

## 传统实现

- 监听scroll事件，当滚动距离达到要吸顶的条件时（基于导航栏的offsetTop进行计算判断），导航栏设置为position: fixed；
- 记录每个导航对应的内容的offsetTop，一般当滚动距离大于等于对应内容的offsetTop时，设置导航栏的选中状态；
- 点击导航栏的导航，设置滚动容器的scrollTop，一般是设置成内容的offsetTop；

上面是一个最简单的思路。当然中间会有很多细节需要注意的，我们在下面一步步实现中去了解这些细节：

::: details 具体实现细节：

- 当引起滚动的容器，不是导航对应的内容的offsetParent（后面解释offsetParent），所以在判断scrollTop与内容的offsetTop时，要加额外的一些计算。
- 当导航栏并不是像顶部导航那种在页面dom结构中比较顶层的，且宽是屏幕宽度长的这种典型的情况时，如在页面dom树中比较里层的某个div下的小导航，要进行吸顶时，由于设置了position:fixed;，宽高值如果是相对值，如百分比时，相对的基准就发生了变化了，就要处理好它的宽高情况了。
- 当页面上的内容发生了变化，如加载数据，页面发生重排重绘，此时就要更新导航栏自身以及每个导航对应内容所在容器的offsetTop，不然会影响后续的计算判断。这点是比较重要的，毕竟现在很多页面已经不是静态的了，也不是整个页面进行刷新的，都是局部刷新的了。
- 当浏览器屏幕发生变化时（resize）,由于可能引起重排重绘，所以还是要更新导航栏自身以及每个导航对应内容所在容器的offsetTop，不然会影响后续的计算判断。
- 当滚动条到达底部，如果还不到导航栏最后一个导航被选择的条件时，就要强制选中最后一个导航。这点是交互上的小优化。
:::

## 参考资料

- [jsbin - demo](https://jsbin.com/wekudat/edit?html,css,js,output)

- [滚动导航+吸顶合并方案（含 sticky 详解）](https://juejin.cn/post/6844904085603221518)
