# 浏览器进程模型

## 什么是进程

进程是操作系统资源分配的最小单元。

<Image src="/12bw/pc1.webp" alt="进程图例" />

程序运行需要有它自己专属的内存空间，可以把这块内存空间简单理解为进程。

每个应用至少有一个进程，进程之间相互独立，即使要通信，也需要双方同意。

## 什么是线程

> 线程是操作系统能够进行`运算调度的最小单元`，是`进程中实际运行的单位`。

<Image src="/12bw/pc2.webp" alt="线程图例" />

有了进程之后，就可以运行程序的代码了，运行代码的「人」称之为「线程」。一个进程至少有一个线程，所以在进程开启后会自动创建一个线程来运行代码，该线程称之为主线程。
如果程序需要同时执行多块代码，主线程就会启动更多的线程来执行代码，所以一个进程中可以包含多个线程。

## 浏览器有哪些进程和线程

浏览器是一个`多进程多线程`的应用程序，浏览器内部工作极其复杂。

为了避免相互影响，为了减少连环崩溃的几率，当启动浏览器后，它会自动启动多个进程。

<Image src="/12bw/pc3.webp" alt="浏览器运行图例" />

其中，最主要的进程有：

- **浏览器进程**

  主要负责界面显示、用户交互、子进程管理等，浏览器进程内部会启动多个线程处理不同的任务。

- **网络进程**

  负责加载网络资源。网络进程内部会启动多个线程来处理不同的网络任务。

- **渲染进程**

  渲染进程启动后，会开启一个渲染主线程，主线程负责执行 HTML、CSS、JS 代码。默认情况下，**浏览器会为每个标签页开启一个新的渲染进程**，以保证不同的标签页之间互不影响。

## 渲染主线程是如何工作的

渲染主线程是浏览器中最繁忙的线程，需要它处理的任务包括但不限于：

- 解析 HTML
- 解析 CSS
- 计算样式
- 布局
- 处理图层
- 每秒把页面画 60 次 （帧绘制）
- 执行全局 JS 代码
- 执行事件处理函数
- 执行计时器的回调函数
- 其他

要处理这么多的任务，主线程遇到了一个前所未有的难题：**如何调度任务**

渲染主线程想出了一个绝妙的主意来处理这个问题：**[任务队列及事件循环](./s_bw_2-eventloop.md)**

<Image src="/12bw/pc4.webp" alt="渲染主线程工作" />

1. 一旦浏览器开始工作，渲染主线程会进入轮询中
2. 每次循环会检查消息队列中是否有任务存在。如果有，就取出第一个任务执行，执行完一个后进入下一次循环；如果没有，则进入休眠状态。
3. 其他所有线程（包括其他进程的线程）可以随时向消息队列添加任务。新任务会加到消息队列的末尾。在添加新任务时，如果主线程是休眠状态，则会将其唤醒以继续循环拿取任务
4. 这样一来，可以让每个任务有条不紊的、持续的进行下去了，整个过程，被称之为`事件循环`。

通常，我们编写的 HTML、CSS、JavaScript 等文件，经过浏览器运行之后就会显示出页面，那他们是如何转化为页面的？这背后的原理是什么？这个过程就是浏览器的渲染进程来操作实现的。浏览器的渲染进程的主要任务就是将静态资源转化为可视化界面。

下一篇我们再来探讨这个过程是怎么实现的，以及具体的细节！

## 参考

- [从「浏览器进程模型」到「浏览器渲染原理」](https://juejin.cn/post/7295255958195716115)——前端掘金者 H
