# 浏览器的工作原理

了解如何提升性能和感知性能，有助于了解浏览器的工作原理。

快速响应的网站提供更好的用户体验。用户期待内容快速加载和交互流畅的 Web 体验。
`等待资源加载`时间和大部分情况下的`浏览器单线程执行`是**影响 Web 性能的两大主要原因**。

等待时间是需要去克服来让浏览器快速加载资源的主要威胁。为了实现快速加载，开发者的目标就是尽可能快的发送请求的信息。网络等待时间是在链路上传送二进制到电脑端所消耗的链路传输时间。Web 性能优化需要做的就是**尽可能快的使页面加载完成**。

大部分情况下，浏览器是单线程执行的。为了有流畅的交互，开发者的目标是确保网站从流畅的页面滚动到点击响应的交互性能。`渲染时间`是关键要素，确保主线程可以完成所有给它的任务并且仍然一直可以处理用户的交互。通过**了解浏览器单线程的本质与最小化主线程的责任**可以`优化 Web 性能`，来确保`渲染的流畅`和`交互响应的及时`。

[浏览器进程模型](./s_bw_4-process.md)

## 导航

导航是加载 web 页面的第一步。它发生在以下情形：用户通过在地址栏输入一个 URL、点击一个链接、提交表单或者是其他的行为。

> Web 性能优化的目标之一就是缩短导航完成所花费的时间，在理想情况下，它通常不会花费太多的时间，但是等待时间和带宽会导致它的延时。

### DNS 查询

浏览器向名称服务器**发起 `DNS` 查询请求**，最终得到一个 IP 地址。第一次请求之后，这个 IP 地址可能会被缓存一段时间，这样可以通过从缓存里面检索 IP 地址而不是再通过名称服务器进行查询来加速后续的请求。

通过主机名加载一个页面通常仅需要一次 DNS 查询。但是，对于页面指向的不同的主机名，则需要多次 DNS 查询。如果字体（font）、图像（image）、脚本（script）、广告（ads）和网站统计（metric）都有不同的主机名，则需要对每一个主机名进行 DNS 查询。

<Image src="https://developer.mozilla.org/zh-CN/docs/Web/Performance/How_browsers_work/latency.jpg" alt="DNS查询" />

DNS 查询可能存在性能问题，**特别是对于移动网络**。当一个用户使用了移动网络，每一个 DNS 查询必须从手机发送到基站，然后到达一个认证的 DNS 服务器。手机、信号塔、名称服务器之间的距离可能是一个大的时间等待。

### TCP 握手

一旦获取到服务器 IP 地址，**浏览器就会通过 TCP “三次握手” 与服务器建立连接**。这个机制的是用来让两端尝试进行通信——在浏览器和服务器通过上层协议 `HTTPS` 发送数据之前，可以协商网络 TCP 套接字连接的一些参数。

TCP 的“三次握手”技术经常被称为“SYN-SYN-ACK”——更确切的说是 `SYN`、`SYN-ACK`、`ACK`——因为通过 TCP 首先发送了三个消息进行协商，然后在两台电脑之间开始一个 TCP 会话。是的，这意味着终端与每台服务器之间还要来回发送三条消息，而请求尚未发出。

### TLS 协商

对于通过 HTTPS 建立的安全连接，还需要另一次 "握手"。这种握手，或者说 **TLS 协商，决定使用哪种密码对通信进行加密，验证服务器**，并在开始实际数据传输前建立安全连接。这就需要在实际发送内容请求之前，再往返服务器五次。

<Image src="https://developer.mozilla.org/zh-CN/docs/Web/Performance/How_browsers_work/ssl.jpg" alt="HTTPS 多一次握手" />

虽然建立安全连接对增加了加载页面的等待时间，对于建立一个`安全的连接`来说，以`增加等待时间为代价`是值得的，因为在浏览器和 web 服务器之间传输的数据不可以被第三方解密。

经过 8 次往返，浏览器终于可以发出请求。

## 响应

一旦我们建立了到 web 服务器的连接，浏览器就代表用户发送一个初始的 `HTTP GET` 请求，对于网站来说，这个请求通常是一个 HTML 文件。一旦服务器收到请求，它将使用相关的响应头和 HTML 的内容进行回复。

初始请求的响应包含所接收数据的第一个字节。`首字节时间`（TTFB）是用户通过点击链接进行请求与收到第一个 HTML 数据包之间的时间。第一个内容分块通常是 14KB 的数据。直到浏览器在解析阶段遇到链接时才会去请求链接的资源，下面有进行描述。

### 拥塞控制 / TCP 慢启动

TCP 数据包在传输过程中被分成若干段。由于 `TCP 保证数据包的顺序`，因此服务器在发送一定数量的数据包后，必须以 ACK 数据包的形式收到客户端的确认。

如果服务器在每个网段后都等待 ACK，则会导致客户端频繁发出 ACK，即使在网络负荷较低的情况下也会增加传输时间。

另一方面，一次性发送过多网段可能会导致这样的问题：在繁忙的网络中，客户端无法接收到网段，只能长时间不停地回应 ACK，服务器不得不不断重新发送网段。

为了平衡传输段的数量，TCP 慢启动算法用于逐渐增加传输数据量，直到确定最大网络带宽，并在网络负载较高时减少传输数据量。

**传输段的数量由拥塞窗口（CWND）的值控制**，该值可初始化为 1、2、4 或 10 MSS（以太网协议中的 MSS 为 1500 字节）。该值是发送的字节数，客户端收到后必须发送 ACK。

如果收到 ACK，那么 CWND 值将加倍，这样服务器下次就能发送更多的数据段。相反，如果没有收到 ACK，那么 CWND 值将减半。因此，这种机制在发送过多网段和过少网段之间取得了平衡。

## 解析

一旦浏览器收到数据的第一块，它就可以开始解析收到的信息。**“解析”是浏览器将 通过网络接收的数据转换为 DOM 和 CSSOM 的步骤**，通过渲染器把 DOM 和 CSSOM 在屏幕上绘制成页面。

DOM 是浏览器标记的内部表示。DOM 也是被暴露的，可以通过 JavaScript 中的各种 API 进行 DOM 操作。

即使请求页面的 HTML 大于初始的 14KB 数据包，浏览器也将开始解析并尝试根据其拥有的数据进行渲染。这就是为什么在前 14KB 中包含浏览器开始渲染页面所需的所有内容，或者至少包含页面模板（`第一次渲染所需的 CSS 和 HTML`）对于 web 性能优化来说是重要的。但是在渲染到屏幕上面之前，HTML、CSS、JavaScript 必须被解析完成。

### 构建 DOM 树

**1. 第一步是处理 HTML 标记并构造 DOM 树。**

HTML 解析涉及到符号化和树的构造。HTML 标记包括开始和结束标记，以及属性名和值。如果文档格式良好，则解析它会简单而快速。解析器将标记化的输入解析到文档中，构建文档树。

<Image src="https://developer.mozilla.org/zh-CN/docs/Web/Performance/How_browsers_work/dom.gif" alt="解析并构造 DOM 树" />

当解析器发现非阻塞资源，例如一张图片，浏览器会请求这些资源并且继续解析。当遇到一个 CSS 文件时，解析也可以继续进行，但是对于 `<script>` 标签`会阻塞渲染并停止 HTML 的解析`。尽管浏览器的预加载扫描器加速了这个过程，但过多的脚本仍然是一个重要的瓶颈。

::: warning
若 `<script>` 有 async 或者 defer 属性的，`不会阻塞 HTML 解析`，但有`可能阻塞 HTML 的渲染`。
:::

### 预加载扫描器

浏览器构建 DOM 树时，这个过程占用了主线程。当这种情况发生时，预加载扫描仪将解析可用的内容并请求高优先级资源，如 CSS、JavaScript 和 web 字体。

> 多亏了预加载扫描器，我们不必等到解析器找到对外部资源的引用来请求它。它将在后台检索资源，以便在主 HTML 解析器到达请求的资源时，它们可能已经在运行，或者已经被下载。预加载扫描仪提供的优化减少了阻塞。

```html
<link
  rel="stylesheet"
  href="styles.css" />
<script
  src="myscript.js"
  async></script>
<img
  src="myimage.jpg"
  alt="图像描述" />
<script
  src="anotherscript.js"
  async></script>
```

在这个例子中，当主线程在解析 HTML 和 CSS 时，预加载扫描器将找到脚本和图像，并开始下载它们。为了确保脚本不会阻塞进程，当 JavaScript 解析和执行顺序不重要时，可以添加 async 属性或 defer 属性。

等待获取 CSS 不会阻塞 HTML 的解析或者下载，但是它确实会阻塞 JavaScript，因为 JavaScript 经常用于查询元素的 CSS 属性。

### 构建 CSSOM 树

**2. 第二步是处理 CSS 并构建 CSSOM 树。**

CSS 对象模型和 DOM 是相似的。DOM 和 CSSOM 是两棵树。它们是独立的数据结构。**浏览器将 CSS 规则转换为可以理解和使用的样式映射**。浏览器遍历 CSS 中的每个规则集，根据 CSS 选择器创建具有父、子和兄弟关系的节点树。

与 HTML 一样，浏览器需要将接收到的 CSS 规则转换为可以使用的内容。因此，它重复了 HTML 到对象的过程，但对于 CSS，CSSOM 树包括来自用户代理样式表的样式。浏览器从适用于节点的最通用规则开始，并通过应用更具体的规则递归地优化计算的样式。换句话说，它`级联属性值`。

构建 CSSOM 非常快，并且在当前的开发工具中没有以独特的颜色显示。相反，开发人员工具中的“重新计算样式”显示解析 CSS、构建 CSSOM 树和递归计算计算样式所需的总时间。在 web 性能优化方面，它是可轻易实现的，**因为创建 CSSOM 的总时间通常小于一次 DNS 查询所需的时间**。

### JavaScript 编译

在解析 CSS 和创建 CSSOM 的同时，包括 JavaScript 文件在内的`其他资源也在下载`（这要归功于预加载扫描器）。JavaScript 会被解析、编译和解释为 `AST 抽象语法树`。有些浏览器引擎会将抽象语法树输入编译器，输出字节码。这就是所谓的 JavaScript 编译。大部分代码都是在主线程上解释的，但也有例外，例如在 web worker 中运行的代码。

// todo: html5 web worker

**构建无障碍树**

浏览器还构建辅助设备用于分析和解释内容的无障碍树。无障碍对象模型（AOM）类似于 DOM 的语义版本。当 DOM 更新时，浏览器会更新辅助功能树。辅助技术本身无法修改无障碍树。

## 渲染

渲染步骤包括：

- 样式
- 布局
- 绘制
- 合成（在某些情况下还包括合成）

在解析步骤中创建的 CSSOM 树和 DOM 树组合成一个渲染树，然后用于计算每个可见元素的布局，然后将其绘制到屏幕上。在某些情况下，可以将内容提升到它们自己的层并进行合成，通过在 GPU 而不是 CPU 上绘制屏幕的一部分来提高性能，从而释放主线程。

### 样式

**3. 第三步是将 DOM 和 CSSOM 组合成渲染树。**

计算样式树或渲染树的构建从 DOM 树的根开始，遍历每个可见节点。
不会被显示的元素，如 `<head>` 元素及其子元素，以及任何带有 display: none 的节点，如用户代理样式表中的 script { `display: none;` }，都`不会包含在渲染树中`，因为它们不会出现在渲染输出中。应用了 **visibility: hidden 的节点会包含在渲染树中**，因为它们会占用空间。由于我们没有给出任何指令来覆盖用户代理默认值，因此上述代码示例中的 script 节点不会包含在渲染树中。

每个可见节点都应用了 CSSOM 规则。**渲染树包含所有可见节点的内容和计算样式，将所有相关样式与 DOM 树中的每个可见节点匹配起来，并根据 CSS 级联，确定每个节点的计算样式**。

### 布局

**4. 第四步是在渲染树上运行布局以计算每个节点的几何体。**

**布局是确定渲染树中所有节点的宽度、高度和位置，以及确定页面上每个对象的大小和位置的过程**。回流是对页面的任何部分或整个文档的任何后续大小和位置的确定。

构建渲染树后，开始布局。渲染树标识显示哪些节点（即使不可见）及其计算样式，但不标识每个节点的尺寸或位置。为了确定每个对象的确切大小和位置，**浏览器从渲染树的根开始遍历**它。

在网页上，大多数东西都是一个盒子。不同的设备和不同的桌面意味着无限数量的不同的视区大小。在此阶段，考虑到视口大小，浏览器将确定屏幕上所有不同框的尺寸。以视口的大小为基础，布局通常从 body 开始，用每个元素的框模型属性排列所有 body 的子孙元素的尺寸，为不知道其尺寸的替换元素（例如图像）提供占位符空间。

**`第一次`确定节点的大小和位置称为`布局`**。**随后对节点大小和位置的`重新计算`称为`回流`**。在我们的示例中，假设初始布局发生在返回图像之前。由于我们没有声明图像的尺寸，因此一旦知道图像的尺寸，就会出现回流。

### 绘制

**5. 最后一步是将各个节点绘制到屏幕上**

第一次出现的节点称为 first meaningful paint。在绘制或光栅化阶段，浏览器将在布局阶段计算的每个框转换为屏幕上的实际像素。绘画包括将元素的每个可视部分绘制到屏幕上，包括文本、颜色、边框、阴影和替换的元素（如按钮和图像）。浏览器需要非常快地完成这项工作。

**为了确保平滑滚动和动画，占据主线程的所有内容，包括计算样式，以及回流和绘制，必须让浏览器在 `16.67 毫秒`内完成**。在 2048x1536 分辨率的 iPad 上，有超过 314.5 万像素将被绘制到屏幕上。那是很多像素需要快速绘制。为了确保重绘的速度比初始绘制的速度更快，屏幕上的绘图通常被分解成数层。如果发生这种情况，则需要进行合成。

**绘制可以将布局树中的元素分解为多个层**。将内容提升到 `GPU` 上的层（而不是 CPU 上的主线程）可以**提高绘制和重新绘制性能**。

有一些特定的属性和元素可以实例化一个层：

- `<video>`
- `<canvas>`，
- 任何 CSS 属性为 `opacity`、`3D transform`、`will-change` 的元素
- 还有一些其他元素。

这些节点将与子节点一起绘制到它们自己的层上，除非子节点由于上述一个（或多个）原因需要自己的层。分层确实可以提高性能，但是它`以内存管理为代价`，**因此不应作为 web 性能优化策略的一部分过度使用**。

### 合成

当文档的各个部分以不同的层绘制，相互重叠时，必须进行合成，以确保它们以正确的顺序绘制到屏幕上，并正确显示内容。

当页面继续加载资源时，可能会发生回流（回想一下我们迟到的示例图像），`回流会触发重新绘制和重新组合`。如果我们定义了图像的大小，就不需要重新绘制，`只需要重新绘制需要重新绘制的层，并在必要时进行合成`。

> 但我们没有包括图像大小！从服务器获取图像后，渲染过程将返回到布局步骤并从那里重新开始。

## 等待交互

一旦主线程绘制页面完成，你会认为我们已经“准备好了”，但事实并非如此。如果加载包含 JavaScript（并且延迟到 onload 事件触发后执行），则主线程可能很忙，无法用于滚动、触摸和其他交互。

[可交互时间（TTI）](https://developer.mozilla.org/en-US/docs/Glossary/Time_to_interactive) **是测量从第一个请求导致 DNS 查询和 SSL 连接到页面可交互时所用的时间**

而可交互是 First Contentful Paint 之后的时间点，**页面在 50ms 内响应用户的交互**。如果主线程正在解析、编译和执行 JavaScript，则它不可用，因此无法及时（小于 50ms）响应用户交互。

在我们的示例中，可能图像加载很快，但 anotherscript.js 文件可能是 2MB，而且用户的网络连接很慢。在这种情况下，用户可以非常快地看到页面，但是在下载、解析和执行脚本之前，就无法滚动。这不是一个好的用户体验。避免占用主线程，如下面的网页测试示例所示：

<Image src="https://developer.mozilla.org/zh-CN/docs/Web/Performance/How_browsers_work/visa_network.png" alt="查看性能" />

在本例中，DOM 内容加载过程花费了超过 1.5 秒的时间，主线程在这段时间内完全被占用，对单击事件或屏幕点击没有响应。

## 自测

看看面试官会问你啥 [从浏览器输入 url 到页面渲染经历了什么](../../%E9%9D%A2%E8%AF%95%E5%AE%98%E9%97%AE/12broswer/q_bw_1-fromurl.md)

## 参考

- [web 性能](https://developer.mozilla.org/zh-CN/docs/Web/Performance)
- [渲染页面：浏览器的工作原理](https://developer.mozilla.org/zh-CN/docs/Web/Performance/How_browsers_work#%E5%AF%BC%E8%88%AA)
