# Webpack

## Webpack 是什么

webpack 是一个模块打包器。webpack 的主要目标是将 JavaScript 文件打包在一起，打包后的文件用于在浏览器中使用，但它也能够胜任转换(transform)、打包(bundle)。

## webpack 原理

### 核心概念

- entry：一个可执行模块或者库的入口。
- chunk：多个文件组成一个代码块。可以将可执行的模块和他所依赖的模块组合成一个 chunk，这是打包。
- loader：文件转换器。例如把 es6 转为 es5，scss 转为 css 等
- plugin：扩展 webpack 功能的插件。在 webpack 构建的生命周期节点上加入扩展 hook，添加功能。
- output：编译结果文件输出

### 构建流程

Webpack 的运行流程是⼀个`串行`的过程，从启动到结束会`依次执行`以下流程：

1. **初始化参数**：解析 webpack 配置参数，合并 shell 传入和 webpack.config.js 文件配置的参数，形成最后的配置结果。
2. **开始编译**：上一步得到的参数初始化`compiler`对象，注册所有配置的插件，插件监听 webpack 构建生命周期的事件节点，做出相应的反应，执行对象的 run 方法开始执行编译。
3. **确定入口**：从配置的`entry`入口，开始`解析文件`构建 AST 语法树，`找出依赖`，`递归`下去。
4. **编译模块**：递归中根据`文件类型`和`loader配置`，调用所有配置的 loader 对`文件转换`，再找出该`模块依赖`的模块，再递归本步骤直到所有入口依赖的文件都经过了本步骤的处理。
5. **完成模块编译**：在经过第 4 步使⽤ Loader 翻译完所有模块后，得到了每个模块被翻译后的`最终内容`以`及它们之间的依赖关系`；
6. **输出资源**：根据⼊⼝和模块之间的依赖关系，组装成⼀个个包含多个模块的 `Chunk`，再把每个 Chunk 转换成⼀个单独的⽂件加⼊到输出列表，这步是可以修改输出内容的最后机会；
7. **输出完成**：在确定好输出内容后，根据配置确定输出的路径和⽂件名，把⽂件内容`写⼊到⽂件`系统。

::: tip
在以上过程中，Webpack 会在特定的时间点，⼴播出特定的事件，插件在监听到感兴趣的事件后，会执行特定的逻辑。并且插件可以调⽤ Webpack 提供的 API ，改变 Webpack 的运行结果。比如UglifyPlugin，会在loader转换递归完，对结果使用UglifyJs压缩，覆盖之前的结果。
:::

## Webpack 基本配置

其他看文章吧

## 自测

[面试官问 - Webpack](s_webpack_1-webpack.md)

## 转载自

- [webpack 系列](https://juejin.cn/post/7140769906080874504)——何逸轩
