# List Virtualization

列表虚拟化

在这份指南中，我们将讨论列表虚拟化（也称为窗口化）。这是一种只渲染动态列表中的可见内容行的思想，而不是整个列表。渲染的行只是全列表的一个小部分，随着用户的滚动，可见内容（窗口）会移动。这可以提高渲染性能。如果你使用 React 并且需要高效地显示大量数据列表，你可能会熟悉 react-virtualized。

虚拟化项目列表涉及维护一个窗口并在列表周围移动该窗口。在 react-virtualized 中进行窗口操作的工作原理如下： 有一个具有相对定位（窗口）的小容器 DOM 元素（例如`<ul>`）；有一个用于滚动的大 DOM 元素；在容器内部绝对定位子元素，并为其设置顶部、左侧、宽度和高度样式。虚拟化并不专注于一次性渲染数千个列表元素（这可能会导致初始渲染速度较慢或影响滚动性能），而是专注于渲染仅对用户可见的元素。

<Image src="/06opt/ListVirtualization.png" alt="List Virtualization" />

这可以帮助在中低端设备上保持列表渲染的快速性。随着用户滚动，可以获取/显示更多项，将前面的条目卸载并用新条目替换。这种方法有效地管理了内存和渲染性能。

### Web 平台的改进

现代浏览器现在支持 **CSS content-visibility**。属性 `content-visibility: auto` 允许浏览器跳过渲染和绘制不在视口中的内容，直到需要时才渲染。如果您在处理需要大量渲染的长 HTML 文档，可以考虑使用此属性。

对于动态内容列表的渲染，我仍然推荐使用像 React-Window 这样的库。使用 `content-visibility: hidden` 来实现高效渲染将很具挑战性，相比之下，许多虚拟化库使用的 agresive DOM 节点移除策略更有效。

具体的还是参考掘金文章了 原文图和视频挂了
