# 多媒体

媒体，即图片和视频，占据了平均网站下载字节的 70% 以上。从下载性能的角度来看，消除媒体和减少文件大小是最容易解决的问题。本文将介绍优化图像和视频以改善网页性能的方法。

::: details 为何优化多媒体?

对于一般网站而言，其带宽的 51% 来自图像，其次是视频占 25%，因此可以说处理和优化多媒体内容非常重要。

你需要考虑数据使用情况。许多人使用的是有限流量套餐，甚至是按使用量付费，每兆字节都要付费。这不仅仅是新兴市场的问题。截至 2018 年，英国仍有 24% 的用户使用按使用量付费。

你还需要考虑内存问题，因为许多移动设备的 RAM 有限。请记住，当图像下载后，它们需要存储在内存中。

:::

## 优化图像传递

尽管图像下载是带宽消耗最大的部分，但其对感知性能的影响远低于许多人的预期（主要是因为页面文本内容可以立即下载，用户可以在图像到达时看到它们被渲染）。

### 加载策略

对于大多数网站来说，最大的改进之一是`延迟加载可视区域以下的图像`，而不是在初始页面加载时，无论访客是否滚动查看，都下载所有这些内容。

除了加载一部分图像之外，接下来你应该考虑图像本身的格式：

- 你是否加载了最优的文件格式？
- 你是否对图像进行了良好的压缩？
- 你是否加载了正确的尺寸？

**最优格式**

最优的文件格式通常取决于图像的特点。

- PNG 24 位色 + 8 位透明度——提供全色准确性和平滑透明度，以牺牲大小为代价。你可能希望为了避免这种组合，而选择 `WebP`。

> WebP 提供比 PNG 或 JPEG 更好的压缩，支持更高的色深、动画帧和透明度等（但不支持渐进式显示）

- 8 位色 + 8 位透明度——提供不超过 255 种颜色，但保持平滑的透明度。大小不太大。这些可能是你想要的 `PNG`。
- 8 位色 + 1 位透明度——提供不超过 255 种颜色，并仅为每个像素提供无或完全透明度，这使透明边界看起来生硬并且有锯齿。尺寸小，但视觉保真度付出了代价。你可能选择 `SVG` 作为替代。
- 对于不具有透明度的摄影素材，要谨慎行事，那么你应该选择压缩良好的渐进式 `JPEG`

> 渐进式 JPEG 与普通 JPEG 不同，它们是渐进式显示的（因此得名），这意味着用户先看到的是一个低分辨率的图像版本，随着图像下载而逐渐清晰，而不是图像以全分辨率从上到下加载，或者只有在完全下载后才显示。

- 最后，如果你想在页面中包含动图，那么请知道 Safari 允许在 `<img>` 和 `<picture>` 元素中使用视频文件。这样，你还可以为所有其他现代浏览器添加`动态 WebP`。

| 特性       | JPG                        | PNG                        | WebP           |
| ---------- | -------------------------- | -------------------------- | -------------- |
| 压缩算法   | 有损压缩                   | 无损压缩                   | 有损压缩       |
| 透明度     | 不支持透明度               | 支持透明度                 | 支持透明度     |
| 图片质量   | 可调整质量                 | 无法调整质量               | 可调整质量     |
| 文件大小   | 相对较小                   | 相对较大                   | 相对较小       |
| 浏览器支持 | 支持在所有主流浏览器上显示 | 支持在所有主流浏览器上显示 | 部分浏览器支持 |
| 动画支持   | 不支持动画                 | 不支持动画                 | 支持动画       |
| 兼容性     | 兼容性较好                 | 兼容性较好                 | 兼容性较差     |

::: warning
这个表格只是对这些格式的一般特征进行了总结，并不代表所有情况。实际情况可能因图像内容、压缩设置和浏览器支持等因素而有所不同。因此，在选择图像格式时，您应根据具体要求和应用场景进行评估和选择
:::

### 提供最佳尺寸

对于较小的屏幕，你希望提供更低分辨率的图像，而对于较大的屏幕则相反。
此外，你还希望为那些具有高 `DPI` 屏幕（例如“Retina”）的设备`提供更高分辨率的图像`。因此，除了创建许多中间图像变体之外，你还需要一种方法将正确的文件提供给正确的浏览器。

### 控制下载图像的优先级（和顺序）

将最重要的图像优先展示给访问者会提供更好的感知性能。

首先，检查你的内容图像是否使用 `<img>` 或 `<picture>` 元素，并且你的背景图像是否在 CSS 中使用 background-image 定义

**img 元素中引用的图像比背景图像具有更高的加载优先级。**

其次，通过采用优先级提示（Priority Hints），你可以进一步控制优先级，只需在图像标签中添加 `fetchPriority` 属性即可。图像优先级提示的一个示例用例是幻灯片轮播，其中第一张图像的优先级高于后续的图像。

### 渲染策略：在加载图像时避免卡顿

由于`图像是异步加载`的，并且在`第一次绘制后继续加载`，**如果在加载之前未定义其尺寸，它们可能会导致页面内容重新布局**。例如，当图像加载时，文本会被推到页面下方。因此，你需要设置 `width` 和 `height` 属性，以便浏览器可以在布局中为它们预留空间。

当在 HTML `<img>` 元素上包含图像的 `width` 和 `height` 属性时，浏览器可以在图像加载之前计算图像的宽高比。在图像下载和绘制到屏幕时，这个宽高比用于预留显示图像所需的空间，从而减少或甚至防止布局变化。减少布局变化是良好用户体验和 web 性能的重要组成部分。

浏览器在解析 HTML 时开始渲染内容，通常在下载所有资源（包括图像）之前。包括尺寸使浏览器可以为每个图像预留一个正确尺寸的占位框，以便在首次渲染页面时显示图像。

<Image src="https://developer.mozilla.org/zh-CN/docs/Learn/Performance/Multimedia/ar-guide.jpg" alt="为每个图像预留一个正确尺寸的占位框" :inline="false"/>

没有 width 和 height 属性，将不会创建占位空间，导致页面在渲染后加载图片时出现明显的卡顿或布局移动。页面的重新布局和重绘是性能和可用性问题。

### 浏览器加载图片

::: warning 注意
虽然在响应式布局中很有用，但如果不包括宽度和高度信息，就会导致卡顿。如果在解析 `<img>` 元素时没有提供高度信息，则在图片加载之前，此 CSS 实际上将高度设置为 0。当页面在初始显示到屏幕后加载图片时，页面会重新布局和重绘，为新确定的高度创建空间，从而导致布局移动。
:::

浏览器在实际加载图像之前有一种调整图像大小的机制。当 `<img>`、`<video>` 或 `<input type="button">` 元素设置了 width 和 height 属性时，它的宽高比会在加载前计算出来，并使用提供的尺寸提供给浏览器。

接着，根据宽高比计算出图片的高度，并将正确的尺寸赋给 `<img>` 元素。这样做的好处是，当图片加载时，就不会出现之前提到的卡顿，或者即使列出的尺寸不太精确，卡顿程度也会降到最低。

宽高比仅在图片加载时用于保留空间。一旦图片加载完成，将使用加载的图片的实际宽高比，而不是属性中的宽高比。这确保即使属性尺寸不准确，图片也会以正确的宽高比显示。

对于任何背景图片，很重要的是设置 background-color 值，以便在图片加载之前，任何叠加在上面的内容仍然可读。

## 优化视频传输

下面的小节描述了以下优化技术：

### 压缩所有视频

压缩视频并导出多种视频格式，包括 WebM、MPEG-4/H.264 和 Ogg/Theora。

### 优化 source 顺序

按从小到大的顺序排序视频源。例如，给定三种分别压缩为 10 MB、12 MB 和 13 MB 的不同格式的视频，先声明最小的，最后声明最大的：

```html
<video
  width="400"
  height="300"
  controls="controls">
  <!-- WebM: 10 MB -->
  <source
    src="video.webm"
    type="video/webm" />
  <!-- MPEG-4/H.264: 12 MB -->
  <source
    src="video.mp4"
    type="video/mp4" />
  <!-- Ogg/Theora: 13 MB -->
  <source
    src="video.ogv"
    type="video/ogv" />
</video>
```

### 视频自动播放

要确保背景视频自动循环播放，你必须在视频标签中添加几个属性：autoplay、muted 和 playsinline。

```html
<video
  autoplay=""
  loop=""
  muted="true"
  playsinline=""
  src="backgroundvideo.mp4"></video>
```

虽然 loop 和 autoplay 足以使视频循环和自动播放，但想要在移动浏览器中自动播放的话，muted 属性是必需的。

Playsinline 对于移动 Safari 浏览器来说是必需的，它允许视频播放时不强制全屏模式。

### 从静音的视频中移除音频

对于 hero 视频或者其他没有音频的视频，移除音频是明智的选择。

```html
<video
  autoplay=""
  loop=""
  muted="true"
  playsinline=""
  id="hero-video">
  <source
    src="banner_video.webm"
    type='video/webm; codecs="vp8, vorbis"' />
  <source
    src="web_banner.mp4"
    type="video/mp4" />
</video>
```

没有理由在永远静音的视频中提供音频。**删除音频可以节省 20% 的带宽。**

根据你选择的软件，你可能可以在导出和压缩过程中移除音频。如果不能，一个名为 FFmpeg 的免费工具可以帮你做到。这是用 FFmpeg 移除音频的命令字符串：

```bash
ffmpeg -i original.mp4 -an -c:v copy audioFreeVersion.mp4
```

### 优化视频预加载

预加载属性有三个可用选项：auto|metadata|none。`默认设置是 metadata`。这些设置控制了在页面加载时下载多少视频文件。你可以通过延迟下载较少受欢迎的视频来节省数据。

**设置 preload="none" 的结果是在播放开始之前，视频不会被下载**。这会延迟启动，但对于播放概率较低的视频，可以节省大量数据。

**为了更适度的带宽节省，可以设置 preload="metadata"**，这可能会在页面加载时下载视频的 3%。这对于一些小型或中等大小的文件来说是一个有用的选项。

将设置改为 auto 告诉浏览器自动下载整个视频。只有当播放可能性非常高时才这样做。否则，这将浪费大量的带宽。

### 考虑流媒体

视频流媒体允许适当的视频大小和带宽（基于网络速度）被传送到最终用户。类似于响应式图像，正确大小的视频被传送到浏览器，确保视频快速启动、缓冲少以及播放优化。

## 总结

- 图片和视频占据了平均网站下载字节的 70% 以上。从下载性能的角度来看，消除媒体和减少文件大小是最容易解决的问题
- 优化视频有可能显著提高网站性能。视频文件相比其他网站文件相对较大，因此始终值得关注。

## 参考

- <https://developer.mozilla.org/zh-CN/docs/Learn/Performance/video>
- <https://developer.mozilla.org/zh-CN/docs/Learn/Performance/Multimedia>
