# HTTPS

超文本传输`安全`协议（HyperText Transfer Protocol Secure）是一种通过计算机网络进行安全通信的`传输协议`。HTTPS 经由 HTTP 进行通信，但利用 `SSL/TLS` 来`加密数据包`。

HTTPS 开发的主要目的，是**提供对网站服务器的身份认证，保护交换资料的隐私与完整性**。这个协议由网景公司（Netscape）在 1994 年首次提出，随后扩展到互联网上。

## 主要作用

HTTPS 的主要作用是在不安全的网络上创建一个安全信道，并可在`使用适当的加密包`和`服务器证书`可被验证且可被信任时，对窃听和中间人攻击`提供合理的防护`。

HTTPS 的信任基于预先安装在操作系统中的证书颁发机构（CA）。因此，与一个网站之间的 HTTPS 连线仅在这些情况下可被信任：

- 浏览器正确地实现了 HTTPS 且操作系统中安装了正确且受信任的证书颁发机构；
- 证书颁发机构仅信任合法的网站；
- 被访问的网站提供了一个有效的证书，也就是说它是一个由操作系统信任的证书颁发机构签发的（大部分浏览器会对无效的证书发出警告）；
- 该证书正确地验证了被访问的网站（例如，访问 `https://example.com` 时收到了签发给`example.com`而不是其它域名的证书）；
- 此协议的加密层（SSL/TLS）能够有效地提供认证和高强度的加密。

::: tip
不应将 HTTPS 和在[RFC 2660](https://tools.ietf.org/html/rfc2660)中定义的[安全超文本传输协议（S-HTTP）](https://zh.wikipedia.org/wiki/%E5%AE%89%E5%85%A8%E8%B6%85%E6%96%87%E6%9C%AC%E4%BC%A0%E8%BE%93%E5%8D%8F%E8%AE%AE)相混淆
:::

## HTTPS 与 HTTP 的差异

### 端口不同

HTTP 的 URL 是由`http://` 起始与默认使用端口 80，而 HTTPS 的 URL 则是由 `https://` 起始与默认使用端口 443。

### 安全性

HTTP 不是安全的，而且攻击者可以通过监听和中间人攻击等手段，获取网站帐户和敏感信息等。HTTPS 的设计可以防止前述攻击，在正确配置时是安全的。

### 协议层

HTTP 协议和安全协议同属于应用层（[OSI 模型](./s_http_0-osi.md)的最高层），具体来讲，**安全协议工作在 HTTP 之下，传输层之上**：

安全协议向运行 HTTP 的进程提供一个类似于 TCP 的套接字，供进程向其中注入报文，安全协议将报文加密并注入运输层套接字；或是从运输层获取加密报文，解密后交给对应的进程。

严格地讲，HTTPS 并不是一个单独的协议，而是对工作在一加密连接（TLS 或 SSL）上的常规 HTTP 协议的称呼。

HTTPS 报文中的任何东西都被加密，包括所有报头和荷载。除了可能的选择密文攻击（参见局限小节）之外，一个攻击者所能知道的只有在两者之间有一连接这一事实。

### 服务器设置

要使一网络服务器准备好接受 HTTPS 连接，管理员必须创建一数字证书，并交由证书颁发机构签名以使浏览器接受。证书颁发机构会验证数字证书持有人和其声明的为同一人。浏览器通常都预装了证书颁发机构的证书，所以他们可以验证该签名。

### 局限

TLS 有两种策略：简单策略和交互策略。交互策略更为安全，但需要用户在他们的浏览器中安装个人的证书来进行认证。

不管使用了哪种策略，协议所能提供的保护总强烈地`依赖`于`浏览器的实现`和`服务器`软件所`支持的加密算法`。

HTTPS 并不能防止站点被网络爬虫抓取。在某些情形中，被加密资源的 URL 可仅通过截获请求和响应的大小推得，这就可使攻击者同时知道明文（公开的静态内容）和密文（被加密过的明文），从而使选择密文攻击成为可能。

## 参考资料

- [维基百科https](https://zh.wikipedia.org/wiki/%E8%B6%85%E6%96%87%E6%9C%AC%E4%BC%A0%E8%BE%93%E5%AE%89%E5%85%A8%E5%8D%8F%E8%AE%AE)
