# 数组 Array

一种线性表数据结构。它使用一组连续的内存空间，来存储一组具有相同类型的数据。

简单来说，「数组」 是实现线性表的顺序结构存储的基础。

以整数数组为例，数组的存储方式如下图所示。

<Image src="/03algo/array.png" />

我们还可以从两个方面来解释一下数组的定义。

- **线性表：** 线性表就是所有数据元素排成像一条线一样的结构，线性表上的数据元素都是相同类型，且每个数据元素最多只有前、后两个方向。数组就是一种线性表结构，此外，栈、队列、链表都是线性表结构。

- **连续的内存空间：** 线性表有两种存储结构：「顺序存储结构」和「链式存储结构」。其中，「顺序存储结构」是指占用的内存空间是连续的，相邻数据元素之间，物理内存上的存储位置也相邻。数组也是采用了顺序存储结构，并且存储的数据都是相同类型的。

## 数组基本操作（JavaScript）

### 访问元素

「访问数组元素」的操作不依赖于数组中元素个数，因此，「访问数组元素」的时间复杂度为 O(n)。

### 插入元素

- push
- shift

### 改变元素

- splice

### 删除元素

- pop
- unshift

## 总结

数组是最基础、最简单的数据结构。数组是实现线性表的顺序结构存储的基础。它使用一组连续的内存空间，来存储一组具有相同类型的数据。

数组的最大特点的支持随机访问。访问数组元素、改变数组元素的时间复杂度为 `O(1)`，在数组尾部插入、删除元素的时间复杂度也是 `O(1)`，普通情况下插入、删除元素的时间复杂度为 `O(n)`。

## 参考

- [算法通关手册 - 数组](https://algo.itcharge.cn/01.Array/01.Array-Basic/01.Array-Basic/)
