# 队列

与栈类似，队列也是一个线性数据结构。与栈不同的是，队列只删除最先添加的数据。

> 为了帮助你明白队列是如何工作的，让我们花点时间举个例子。我们可以把队列想象成为熟食店的售票系统。每个顾客拿一张票，当他们的号码被呼叫时接受服务。持第一张票的顾客首先接受服务。

队列的一个更实际的例子是 Web 浏览器的事件循环。当触发不同事件时，例如单击某个按钮，点击事件将被添加到事件循环队列中，并按照它们进入队列的顺序进行处理。

## 队列的操作

现在我们具有了队列的概念，接下来就要定义它的操作。你会注意到，队列的操作和栈非常相似。区别就在被删除的数据在什么地方。

- enqueue(data) 将数据添加到队列中。
- dequeue 删除最早加入队列的数据。

<Image src="/03algo/queue.png" alt="队列的基本操作"/>

## 队列的属性

- `oldestIndex`
- `newestIndex`
- `storage`

## 队列的完整实现

::: tip 跳转到编写代码
[队列的实现 Queue](../../编写代码/03algo/c_algo_2-queue/c_algo_2-queue.md)
:::

## 参考

- [用 JavaScript 实现栈与队列](https://juejin.cn/post/6844903758887911431)
- [算法通关手册 - 队列基础知识](https://algo.itcharge.cn/04.Queue/01.Queue-Basic/01.Queue-Basic/)
