# 内容模版格式参考

```md
# h1 模块标题 - 必须

为了更好的 local search 和目录结构，需要添加 `<h1>`

## 主标题 

请为你的内容添加 主标题

### 副标题

若需要可继续添加 副标题，让该页具有良好的目录结构。

## 参考资料

例：

- HTTPS <https://developer.mozilla.org/zh-CN/docs/Glossary/HTTPS>
```

## 一些注意事项

请务必确保页面中只有一个`<h1>`标签。如果存在多个`<h1>`标签，您应该考虑将内容拆分到新的文档中。

本页的导航会根据`<h2>`、`<h3>`和`<h4>`标签来生成大纲，因此请确保标题清晰简洁，以便用户能够轻松理解内容结构。

## 关于图片引用

如果你的文档涉及复杂的流程、业务逻辑或难以理解的概念，我强烈建议配上相关图片。

1. 你可以直接将图片放到`public/[类别]`目录下，但请确保在压缩的情况下图像依然清晰。

2. 更推荐的做法是引用图片地址，但需要注意安全性和有效性，请确保外部链接能够正常访问。

3. 我自己曾经因为服务器长时间停机的缘故遇到了问题，因此，如果你的站点是个人站点或者静态服务器的话，我建议将图片存放在本地。



## 文件命名规范

\[模块_类型_创作编号\]-文件标题

如：

- q_http_2-http_header
- s_http_2-http_header
- c_js_1-promise

只有上面 直击概念、面试官问、编写代码 三个版块这么分，其他就不用了。

分割号 `-` 后的才是文件名，但这样的好处是有个清晰的类别。`这不挺像函数作用域嘛` 不然容易有同样的命名，易写错。

特别是http的，这样就能有效地区分了




### 关于我的idea

为什么这么命名，其实就是整理到一半突然有了个`idea`，但我知道想短期内实现估计很困难 = = 算埋下个种子吧，万一以后真实现了呢

```ts
function handleFilename(filename: FilenameType) {
  const types = filename.split('-')[0]  
  const keywords = filename.split('-')[1]['_']
  // ...

  // 以后若面经多了，可提取关键词 和 question 里的 keyword 做匹配
  // 或者 再扩展下设计权重啥的

  // 再弄个通用 template

  // render -> generatge
}
```

若是有必要，后续可能会将这些 .mjs 改成 .ts 啊 = = 后面再说吧