# 目录结构说明

贡献时，希望您根据现有模块，不改动目前的文件结构。重要改动请提 issue，否则可能不会通过合并。

**目录只与首页强相关** 若你想增加分类，可考虑下首页是否还要增加类别 ~ 反正我觉得基本够了

## 本站的几大版块分类

### 直击概念

添加的内容尽量把这个东西说清楚即可，思路：是什么，什么背景下，做了什么 ~

> index 只与创建时间有关（为了方便找文件，sidebar和nav顺序 在config里可调整不冲突）

### 面试官问

可先浏览下该模块，尽量不添加重复问题。避免为堆内容而堆内容

> index 只与创建时间有关（为了方便找文件，sidebar和nav顺序 在config里可调整不冲突）

### 编写代码

和面试官问的唯一区别就是，一个口述，一个实操。涉及到代码，请尽量提交可运行的代码。

可写思路，这样便于学习，可添加 `::: details` 或是 `::: code-group` 渐进式能更好的帮助我们理解。

::: tip 
代码没有标准答案。若有更好的思路和解法，会提高展示优先级，还请理解。
:::

### 网友面经

按范例一样，直接写过程就好了。不用写答案

当然，如果您愿意附答案那再好不过了。

可适当提炼关键词，结合本站搜索，附带 直击概念 或是 其他版块的链接

### 相关准备

我自己加的，毕竟和面试配套，有个简历也说得过去，可继续完善

### 参与贡献

啰嗦了一堆后才发现开源真的不易，细节太多了 ~ 

`站在巨人的肩膀上，致敬和感谢前辈们！`


## 文件命名规范

\[模块_类型_创作编号\]-文件标题

如：

- q_http_2-http_header
- s_http_2-http_header
- c_js_1-promise

只有上面 直击概念、面试官问、编写代码 三个版块这么分，其他就不用了。

分割号 `-` 后的才是文件名，但这样的好处是有个清晰的类别。`这不挺像函数作用域嘛` 不然容易有同样的命名，易写错。

特别是http的，这样就能有效地区分了




### 关于我的idea

为什么这么命名，其实就是整理到一半突然有了个`idea`，但我知道想短期内实现估计很困难 = = 算埋下个种子吧，万一以后真实现了呢

```ts
function handleFilename(filename: FilenameType) {
  const types = filename.split('-')[0]  
  const keywords = filename.split('-')[1]['_']
  // ...

  // 以后若面经多了，可提取关键词 和 question 里的 keyword 做匹配
  // 或者 再扩展下设计权重啥的

  // 再弄个通用 template

  // render -> generatge
}
```

若是有必要，后续可能会将这些 .mjs 改成 .ts 啊 = = 后面再说吧