---
# https://vitepress.dev/reference/default-theme-home-page
layout: home

hero:
  name: 'FE-prepare-interview'
  text: '前端必备的知识宝典'
  tagline: 整理搜集自互联网 —— by 霪霖笙箫
  actions:
    - theme: brand
      text: 直击概念
      link: /直击概念/index
    - theme: alt
      text: 面试官问
      link: /面试官问/index
    - theme: alt
      text: 编写代码
      link: /编写代码/index
    - theme: brand
      text: 网友面经
      link: /网友面经/三月后再删
    - theme: alt
      text: 简历模版
      link: /相关准备/index

features:
  - title: HTML & CSS
    icon: <svg t="1706693589152" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="4248" width="200" height="200"><path d="M89.088 59.392l62.464 803.84c1.024 12.288 9.216 22.528 20.48 25.6L502.784 993.28c6.144 2.048 12.288 2.048 18.432 0l330.752-104.448c11.264-4.096 19.456-14.336 20.48-25.6l62.464-803.84c1.024-17.408-12.288-31.744-29.696-31.744H118.784c-17.408 0-31.744 14.336-29.696 31.744z" fill="#FC490B" p-id="4249"></path><path d="M774.144 309.248h-409.6l12.288 113.664h388.096l-25.6 325.632-227.328 71.68-227.328-71.68-13.312-169.984h118.784v82.944l124.928 33.792 123.904-33.792 10.24-132.096H267.264L241.664 204.8h540.672z" fill="#FFFFFF" p-id="4250"></path></svg>
    details: Web前端开发者必须掌握的HTML、CSS知识，为避免分散就整合到一起
    link: /直击概念/01htmlcss/intro
  - title: JavaScript
    icon: <svg t="1706693696736" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="6236" width="200" height="200"><path d="M0 0h1024v1024H0V0z m940.117 779.776c-7.466-46.72-37.888-85.973-128.128-122.581-31.402-14.72-66.304-24.96-76.672-48.64-3.882-14.08-4.48-21.76-1.962-30.08 6.4-27.563 39.04-35.84 64.64-28.16 16.64 5.12 32 17.92 41.642 38.4 44.118-28.843 44.118-28.843 74.88-48-11.52-17.92-17.237-25.643-25.002-33.28-26.88-30.08-62.678-45.44-120.918-44.118l-30.08 3.798c-28.842 7.04-56.32 22.4-72.96 42.88-48.64 55.082-34.602 151.082 24.278 190.762 58.24 43.52 143.402 53.078 154.282 94.08 10.24 49.92-37.12 65.92-83.882 60.16-34.603-7.68-53.76-25.002-74.88-57.002l-78.08 44.842c8.96 20.48 19.2 29.398 34.56 47.318 74.24 74.922 259.84 71.082 293.162-42.838 1.238-3.84 10.24-30.08 3.158-70.4l1.962 2.859z m-383.274-309.12h-95.915c0 82.688-0.384 164.864-0.384 247.68 0 52.565 2.688 100.821-5.888 115.67-14.08 29.397-50.347 25.642-66.816 20.48-16.896-8.363-25.472-19.883-35.413-36.48-2.688-4.48-4.694-8.363-5.419-8.363l-77.867 48c13.014 26.88 32 50.005 56.491 64.725 36.48 21.76 85.504 28.8 136.832 17.28 33.408-9.643 62.208-29.483 77.27-60.203 21.76-39.68 17.151-88.32 16.938-142.762 0.512-87.638 0-175.318 0-263.638l0.17-2.389z" fill="#EA9518" p-id="6237"></path></svg>
    details: Web前端开发者必须掌握的JavaScript知识
    link: /直击概念/02js/intro

  - title: 数据结构与算法
    icon: <svg t="1706805491482" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="4737" width="200" height="200"><path d="M511.82 512.5v435L888.54 730l-0.02-435z" fill="#C3D2FB" p-id="4738"></path><path d="M135.1 295l376.72 217.5v435L135.1 730z" fill="#3D4265" p-id="4739"></path><path d="M511.82 512.5L888.54 295 511.82 77.5 135.1 295z" fill="#386BF3" p-id="4740"></path></svg>
    details: 非科班薄弱点。这里整理一些前端需了解的基础和考察点
    link: /直击概念/03algo/intro

  - title: HTTP 相关
    icon: <svg t="1708572979302" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="13185" width="200" height="200"><path d="M879.872 128H143.936A79.68 79.68 0 0 0 64 207.296v613.888a79.648 79.648 0 0 0 79.936 79.232h736.128A79.616 79.616 0 0 0 960 821.184V207.296A79.808 79.808 0 0 0 879.872 128zM398.432 271.616c0.672-21.888 19.968-40.64 41.664-40.64 22.88 0 42.336 20.16 41.696 43.296a41.344 41.344 0 0 1-41.696 40.128 41.6 41.6 0 0 1-41.664-42.784z m-121.152-1.024c1.024-21.664 21.184-40.48 42.688-39.648 23.04 0.704 42.016 21.504 40.672 44.352a41.728 41.728 0 0 1-42.688 39.104 41.6 41.6 0 0 1-40.64-43.84z m-121.632 0.64c0.832-21.792 20.32-40.448 42.016-40.288 22.688 0.192 42.208 20.48 41.344 43.648a41.44 41.44 0 0 1-42.016 39.808 41.728 41.728 0 0 1-41.376-42.112v-1.024z m770.496 549.952a46.048 46.048 0 0 1-46.272 45.664H143.936c-25.44 0-46.048-20.48-46.08-45.664v-396.48h828.288v396.48z m-701.024-72H172.256v-234.464h52.864v92h48.384v-92h52.864v234.432H273.536V641.92H225.12v107.232z m281.792-200.608h-53.248v200.576H400.32v-200.576H347.52v-33.856h159.36v33.856z m173.6 0h-53.28v200.576h-53.216v-200.576h-52.896v-33.856h159.392v33.856z m74.464 200.576h-53.28v-234.432h106.496c1.6 0 8.544 0 14.24 0.992 17.088 3.008 25.216 11.968 28.064 16.64 6.112 9.952 6.112 24.864 6.112 35.2v30.88c0 21.92-1.216 32.512-10.176 41.504-8.544 8.608-20.736 11.616-46.72 11.616h-44.768v97.6z m0-199.872v68.704h25.6c10.976 0 17.088-0.96 20.32-4.64 3.648-3.968 3.648-11.616 3.648-16.256v-23.904c0-6.656 1.216-13.632-4.032-18.912-6.112-6.336-17.504-4.992-19.52-4.992h-26.016z" fill="#008CFF" p-id="13186"></path></svg>
    details: 从OSI 七层模型，HTTP、HTTPS，到缓存策略等常考知识点
    link: /直击概念/04http/intro

  - title: 浏览器相关
    icon: <svg t="1706694570469" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="15957" width="200" height="200"><path d="M985.68448 320.093H511.61748c-105.937-0.116-191.93 85.597-192.023 191.442a191.674 191.674 0 0 0 24.483 93.882L107.04548 199.145C279.68248-24.064 600.79948-65.21 824.24148 107.264a510.79 510.79 0 0 1 161.443 212.83z m0 0" fill="#F44336" p-id="15958"></path><path d="M1023.19948 511.72c-0.232 282.136-229.143 510.79-511.58 511.023a455.82 455.82 0 0 1-63.954-4.259l230.214-410.95a192 192 0 0 0-70.33-261.91 190.208 190.208 0 0 0-95.488-25.554H985.70748a503.901 503.901 0 0 1 37.492 191.65z m0 0" fill="#FFC107" p-id="15959"></path><path d="M677.87948 607.535l-230.214 410.95h-0.419C167.11248 983.132-31.31052 727.621 4.08648 447.766a510.37 510.37 0 0 1 102.96-248.622L344.07748 605.417l1.28 2.14c52.852 91.742 170.147 123.276 261.958 70.47a191.628 191.628 0 0 0 70.563-70.492z m0 0" fill="#4CAF50" p-id="15960"></path><path d="M677.87948 607.535c-52.853 91.74-170.147 123.275-261.958 70.47a191.907 191.907 0 0 1-70.563-70.47l-1.28-2.142a191.535 191.535 0 0 1 73.565-260.864 191.767 191.767 0 0 1 93.975-24.46h0.42a190.138 190.138 0 0 1 95.487 25.554 192 192 0 0 1 70.354 261.912z m0 0" fill="#2196F3" p-id="15961"></path><path d="M510.89748 724.643a211.48 211.48 0 0 1-105.844-28.37 213.876 213.876 0 0 1-78.15-78.103c-58.857-101.841-23.925-232.075 78.01-290.862a213.295 213.295 0 0 1 106.705-28.533c117.714-0.093 213.225 95.162 213.318 212.76a212.876 212.876 0 0 1-28.555 106.635A214.342 214.342 0 0 1 510.89748 724.643z m1.117-383.255a170.403 170.403 0 0 0-85.737 318.045 170.752 170.752 0 0 0 233.1-62.51 170.263 170.263 0 0 0-62.418-232.705 170.752 170.752 0 0 0-84.922-22.83h-0.023z m0 0" fill="#FAFAFA" p-id="15962"></path></svg>
    details: 从经典的浏览器输入url开篇，到事件循环，垃圾回收等
    link: /直击概念/12broswer/intro

  - title: 现代化构建
    icon: <svg t="1706694770564" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="17934" width="200" height="200"><path d="M882.23288889 749.45422222L526.90488889 950.38577778V793.94133333l221.41155556-121.856 133.91644444 77.36888889z m24.34844444-22.07288889V307.08622222l-129.93422222 75.09333333v270.22222223l129.93422222 74.97955555z m-766.17955555 22.07288889l355.328 201.04533333V793.94133333L274.20444445 672.08533333l-133.80266667 77.36888889zM116.05333333 727.38133333V307.08622222l129.93422222 75.09333333v270.22222223L116.05333333 727.38133333z m15.24622222-447.60177778l364.43022223-206.16533333v151.32444445L262.144 353.39377778l-1.82044445 1.024c0 0.11377778-129.024-74.63822222-129.024-74.63822223z m760.03555556 0L526.90488889 73.728v151.32444445l233.472 128.34133333 1.82044444 1.024 129.13777778-74.63822223z" fill="#8ED6FB" p-id="17935"></path><path d="M495.72977778 758.21511111l-218.45333333-120.14933333V400.15644445l218.45333333 126.17955555v231.87911111z m31.17511111 0l218.45333333-120.03555556V400.15644445l-218.45333333 126.17955555v231.87911111zM291.95377778 372.62222222l219.24977777-120.49066667L730.45333333 372.62222222 511.31733333 499.25688889 291.95377778 372.62222222z" fill="#1C78C0" p-id="17936"></path></svg>
    details: 项目构建相关，Webpack、Vite等打包工具及优化实践
    link: /直击概念/09build/intro

  - title: 性能优化
    icon: 🚀
    details: Web前端性能优化实践
    link: /直击概念/06opt/intro

  - title: 前端安全
    icon: 👀
    details: 你应该知道的前端安全知识
    link: /直击概念/10safe/intro

  - title: TypeScript
    icon: <svg t="1708479716283" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="5103" width="200" height="200"><path d="M0 512v512h1024V0H0z m825.216-40.8a127.424 127.424 0 0 1 64.032 36.896c9.44 10.08 23.424 28.416 24.544 32.864 0.352 1.28-44.192 31.136-71.168 47.904-0.992 0.64-4.896-3.584-9.248-10.08-13.216-19.2-27.008-27.488-48.128-28.928-31.072-2.144-51.04 14.112-50.848 41.248l-0.032 1.6c0 6.432 1.632 12.512 4.48 17.824l-0.096-0.192c6.816 14.112 19.552 22.624 59.296 39.808 73.344 31.584 104.704 52.352 124.192 81.92 21.76 32.992 26.656 85.664 11.872 124.832-16.224 42.592-56.544 71.52-113.28 81.056-17.536 3.104-59.136 2.656-77.984-0.768-41.12-7.328-80.128-27.648-104.192-54.304-9.44-10.368-27.808-37.536-26.656-39.456 0.48-0.672 4.704-3.296 9.376-6.016 4.608-2.592 21.792-12.544 38.048-21.984l29.44-17.056 6.176 9.12c8.608 13.152 27.424 31.2 38.816 37.216 32.672 17.248 77.536 14.816 99.616-5.024a37.6 37.6 0 0 0 13.344-30.784v0.096c0-11.872-1.504-17.056-7.68-26.016-7.936-11.36-24.192-20.896-70.368-40.96-52.832-22.752-75.552-36.864-96.384-59.296a134.88 134.88 0 0 1-27.872-50.24l-0.256-0.96c-3.872-14.464-4.864-50.72-1.792-65.312 10.88-51.072 49.408-86.624 104.992-97.184 18.048-3.424 60-2.144 77.696 2.272z m-240.384 42.752l0.352 41.952H451.84v378.72h-94.304V555.904H224.32v-41.12c0-22.784 0.48-41.824 1.12-42.24 0.512-0.672 81.632-1.024 179.936-0.864l178.976 0.512z" fill="#007ACC" p-id="5104"></path></svg>
    details: 任何时候学习TS都不会晚
    link: /直击概念/11ts/intro

  - title: Node.js
    icon: <svg t="1706771457155" class="icon" viewBox="0 0 1611 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="10252" width="200" height="200"><path d="M1107.167513 0c-8.316751 0-15.593909 7.277157-15.593909 15.593909V301.482234l-64.454822-37.425381a23.598782 23.598782 0 0 0-25.989848 0l-155.939086 90.44467c-8.316751 4.158376-13.514721 13.514721-13.514721 22.871066v181.928934c0 9.356345 5.19797 17.673096 13.514721 22.871066l155.939086 90.44467c8.316751 5.19797 18.71269 5.19797 25.989848 0l155.939086-90.44467c8.316751-4.158376 13.514721-13.514721 13.514721-22.871066V64.454822c0-9.356345-5.19797-17.673096-12.475127-22.871066l-69.652792-39.504568S1109.246701 0 1107.167513 0z m-509.401016 259.898477s-9.356345 1.039594-13.51472 3.118782l-155.939087 90.44467c-8.316751 4.158376-13.514721 13.514721-13.51472 22.871066v181.928934c0 9.356345 5.19797 17.673096 13.51472 22.871066l155.939087 90.44467c8.316751 5.19797 18.71269 5.19797 25.989847 0l155.939087-90.44467c8.316751-4.158376 13.514721-13.514721 13.51472-22.871066V376.332995a27.029442 27.029442 0 0 0-13.51472-22.871066l-155.939087-90.44467s-8.316751-3.118782-13.51472-3.118782z m831.675127 0s-9.356345 1.039594-13.51472 3.118782l-155.939087 90.44467c-8.316751 4.158376-13.514721 13.514721-13.514721 22.871066v181.928934c0 9.356345 5.19797 17.673096 13.514721 22.871066l150.741117 91.484264c8.316751 5.19797 18.71269 5.19797 27.029442 0l73.811167-42.62335c5.19797-3.118782 7.277157-10.395939 4.158376-15.593909 0-2.079188-2.079188-3.118782-4.158376-4.158376l-161.137056-94.603045v-93.563452l77.969543-45.742132 77.969544 45.742132v64.454822c0 8.316751 7.277157 10.395939 12.475127 7.277158 25.989848-15.593909 53.019289-30.148223 79.009137-45.742132 8.316751-4.158376 12.475127-13.514721 12.475126-22.871066v-48.860914a27.029442 27.029442 0 0 0-13.51472-22.871066l-155.939087-90.44467s-8.316751-3.118782-13.51472-3.118782z m-1247.51269 0s-9.356345 1.039594-13.514721 3.118782l-154.899492 91.484264a27.029442 27.029442 0 0 0-13.514721 22.871066v231.829441c0 11.435533 12.475127 18.71269 21.831472 12.475127l68.613198-40.544162c8.316751-4.158376 12.475127-13.514721 12.475127-22.871066V421.035533l77.969543-45.742132 77.969543 45.742132v137.226396c0 9.356345 5.19797 17.673096 12.475127 22.871066l68.613198 40.544162c7.277157 4.158376 15.593909 2.079188 19.752284-5.197969 1.039594-2.079188 2.079188-5.19797 2.079188-7.277158V377.372589a27.029442 27.029442 0 0 0-13.514721-22.871066l-155.939086-90.44467s-8.316751-3.118782-13.514721-3.118782z m831.675127 116.434518l77.969543 45.742132v92.523858l-77.969543 45.742132L935.634518 514.598985v-92.523858l77.969543-45.742132z m415.837563 39.504568l-44.702538 25.989848v51.979696l44.702538 25.989847 44.702538-25.989847v-51.979696L1429.441624 415.837563zM800.48731 623.756345c-5.19797 0-10.395939 1.039594-15.593909 4.158376l-146.582741 84.207106c-9.356345 5.19797-15.593909 15.593909-15.593909 27.029442v168.414213c0 10.395939 6.237563 20.791878 15.593909 27.029442l38.464975 21.831472c18.71269 9.356345 24.950254 9.356345 33.267005 9.356345 27.029442 0 43.662944-16.633503 43.662944-45.742132v-166.335025s-2.079188-4.158376-4.158376-4.158376h-18.71269s-4.158376 2.079188-4.158376 4.158376v166.335025c0 12.475127-13.514721 25.989848-35.346193 14.554315l-40.544162-22.871066s-2.079188-2.079188-2.079188-4.158376V739.151269s0-3.118782 2.079188-4.158376l146.582741-84.207106h4.158376l146.582741 84.207106s2.079188 2.079188 2.079187 4.158376v168.414213s0 3.118782-2.079187 4.158376l-146.582741 84.207106h-4.158376l-37.425381-21.831472h-3.118782c-7.277157 4.158376-14.554315 7.277157-21.831472 10.395939-2.079188 0-6.237563 2.079188 1.039594 6.237564l48.860914 29.108629s10.395939 4.158376 15.593909 4.158376c5.19797 0 10.395939-1.039594 15.593908-4.158376L962.663959 935.634518c9.356345-5.19797 15.593909-15.593909 15.593909-27.029442V740.190863c0-11.435533-6.237563-20.791878-15.593909-27.029442l-146.582741-84.207106s-10.395939-4.158376-15.593908-4.158376z m227.671066 77.969543c-15.593909 0-28.069036 12.475127-28.069036 28.069036s12.475127 28.069036 28.069036 28.069035 28.069036-12.475127 28.069035-28.069035-12.475127-28.069036-28.069035-28.069036z m0 4.158376c13.514721 0 23.91066 10.395939 23.91066 23.91066s-10.395939 23.91066-23.91066 23.91066-23.91066-10.395939-23.91066-23.91066 10.395939-23.91066 23.91066-23.91066z m-10.395939 7.277157v31.187818h6.237563v-12.475127h5.19797s3.118782 0 3.118781 3.118781c0 0 0 8.316751 1.039594 10.395939H1039.593909s-1.039594-5.19797-1.039594-8.316751c0-4.158376 0-7.277157-5.19797-7.277157 2.079188 0 6.237563-2.079188 6.237564-7.277158 0-8.316751-7.277157-8.316751-11.435533-8.316751h-10.395939z m6.237563 5.19797h5.19797s4.158376 0 4.158375 4.158375c0 2.079188 0 5.19797-5.197969 4.158376h-5.19797V717.319797z m-184.008122 25.989848c-41.583756 0-66.53401 17.673096-66.53401 46.781725 0 32.227411 24.950254 40.544162 64.454822 44.702539 47.82132 5.19797 51.979695 11.435533 51.979696 20.791878 0 16.633503-13.514721 22.871066-43.662944 22.871066-38.464975 0-46.781726-9.356345-49.900508-29.10863 0-2.079188-2.079188-3.118782-4.158376-3.118781h-18.71269s-4.158376 2.079188-4.158376 4.158375c0 24.950254 13.514721 54.058883 76.92995 54.058883 46.781726 0 73.811168-18.71269 73.811167-49.900507s-20.791878-40.544162-66.53401-45.742132c-45.742132-6.237563-49.900508-9.356345-49.900508-19.752284 0-9.356345 4.158376-20.791878 37.425381-20.791879 30.148223 0 41.583756 6.237563 45.742132 27.029442 0 2.079188 2.079188 3.118782 4.158376 3.118782h18.71269s2.079188 0 3.118782-1.039594c0 0 1.039594-2.079188 1.039594-3.118782-3.118782-35.346193-25.989848-50.940102-72.771574-50.940101z" p-id="10253" fill="#14831c"></path></svg>
    details: 前端通往全栈的必经之路，应该学习和掌握
    link: /直击概念/05node/intro

  - title: Vue
    icon: <svg xmlns="http://www.w3.org/2000/svg" width="38" viewBox="0 0 256 220.8"><path fill="#41B883" d="M204.8 0H256L128 220.8 0 0h97.92L128 51.2 157.44 0h47.36Z"></path><path fill="#41B883" d="m0 0 128 220.8L256 0h-51.2L128 132.48 50.56 0H0Z"></path><path fill="#35495E" d="M50.56 0 128 133.12 204.8 0h-47.36L128 51.2 97.92 0H50.56Z"></path></svg>
    details: 整理Vue知识点，深度看个人掌握情况，量力而行
    link: /直击概念/07vue/intro

  - title: React
    icon: <svg t="1706695025273" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="19045" width="200" height="200"><path d="M854.256 371.344c-16.896-6.544-35.388-12.696-55.012-18.304 5.028-20.036 9.02-39.348 11.868-57.44 16.16-102.476-1.64-174.532-50.108-202.896-14.144-8.28-30.36-12.48-48.188-12.48-42.688 0-94.628 24.188-150.208 69.944-14.04 11.556-28.544 24.712-43.144 39.136-14.616-14.44-29.12-27.6-43.14-39.14-55.584-45.752-107.532-69.936-150.216-69.936-17.828 0-34.04 4.2-48.196 12.48-48.468 28.36-66.26 100.42-50.1 202.888 2.848 18.092 6.84 37.408 11.864 57.448-19.628 5.6-38.12 11.76-55.02 18.308-95.624 37.052-148.292 88.7-148.292 145.432 0 56.724 52.668 108.376 148.296 145.432 16.888 6.544 35.388 12.696 55.016 18.308-5.02 20.004-9.012 39.32-11.864 57.44-16.164 102.476 1.628 174.528 50.1 202.896 14.144 8.28 30.36 12.476 48.188 12.476 42.688 0 94.628-24.18 150.212-69.94 14.036-11.548 28.54-24.708 43.152-39.14 14.6 14.42 29.104 27.576 43.148 39.136 55.58 45.752 107.52 69.944 150.212 69.944 17.828 0 34.04-4.2 48.188-12.48 48.468-28.36 66.26-100.42 50.104-202.896-2.852-18.112-6.844-37.432-11.864-57.44 19.6-5.6 38.096-11.756 55.008-18.304 95.628-37.056 148.292-88.704 148.292-145.432 0-56.736-52.668-108.388-148.296-145.44z m-141.708-251.72c11.112 0 20.88 2.42 29.032 7.188 40.228 23.54 47.988 106.416 20.368 216.572-40.94-9.524-85.272-16.544-131.832-20.872-26.976-38.708-55.14-74.12-83.752-105.3 62.824-62.048 123.308-97.588 166.184-97.588zM349.14 616.448a1265.72 1265.72 0 0 0 31.44 52.192c-32.564-3.96-63.856-9.352-93.12-16.06 8.892-29.032 19.928-59.2 32.84-89.776 9.18 18.116 18.8 36 28.84 53.648z m-61.68-235.468c29.28-6.712 60.568-12.108 93.12-16.06a1263.48 1263.48 0 0 0-31.444 52.188 1265.2 1265.2 0 0 0-28.84 53.644c-12.896-30.564-23.928-60.724-32.832-89.776z m53.528 135.792a1242.72 1242.72 0 0 1 41.8-79.976 1240.016 1240.016 0 0 1 47.456-76.72c29.692-2.188 59.448-3.28 89.216-3.264 30.112 0 60.12 1.1 89.224 3.268a1238.588 1238.588 0 0 1 47.448 76.716 1243.88 1243.88 0 0 1 41.808 79.984 1242.016 1242.016 0 0 1-41.804 79.984 1238.476 1238.476 0 0 1-47.456 76.72c-29.096 2.172-59.108 3.264-89.22 3.264-30.108 0-60.116-1.092-89.212-3.264a1241.064 1241.064 0 0 1-47.452-76.72 1241.584 1241.584 0 0 1-41.808-79.996z m348.792 99.68a1256.72 1256.72 0 0 0 28.84-53.652c12.912 30.58 23.952 60.752 32.848 89.78-29.268 6.708-60.56 12.1-93.128 16.06a1263.92 1263.92 0 0 0 31.44-52.188z m0-199.348a1263.328 1263.328 0 0 0-31.44-52.18c32.56 3.952 63.852 9.352 93.128 16.06-8.908 29.052-19.944 59.216-32.844 89.776a1262.48 1262.48 0 0 0-28.84-53.656z m-110.052-98.168a1226.096 1226.096 0 0 0-60.268-1.508c-19.768 0-40.016 0.508-60.26 1.508 19.676-26.62 39.92-51.384 60.264-73.688 20.348 22.32 40.596 47.076 60.264 73.688z m-282.388-192.12c8.152-4.768 17.92-7.188 29.032-7.188 42.876 0 103.368 35.54 166.188 97.592-28.608 31.176-56.772 66.584-83.748 105.296-46.568 4.328-90.9 11.348-131.832 20.868-27.624-110.16-19.868-193.028 20.36-216.568z m-222.12 389.96c0-47.14 66.92-95.4 174.84-126.216 12.332 40.72 28.508 83.168 48.1 126.22-19.588 43.048-35.764 85.496-48.1 126.216-107.92-30.816-174.84-79.08-174.84-126.216z m251.148 397.152c-11.112 0-20.88-2.416-29.028-7.188-40.232-23.54-47.988-106.412-20.368-216.572 40.948 9.528 85.284 16.548 131.84 20.876 26.968 38.696 55.132 74.108 83.748 105.288-62.824 62.056-123.316 97.6-166.192 97.6z m132.84-199.308c20.24 1 40.484 1.516 60.252 1.516 19.772 0 40.02-0.512 60.264-1.516-19.656 26.6-39.904 51.36-60.26 73.688-20.348-22.316-40.592-47.076-60.26-73.688z m282.368 192.12c-8.152 4.772-17.92 7.188-29.028 7.188-42.876 0-103.36-35.54-166.188-97.596 28.616-31.18 56.78-66.592 83.748-105.288 46.568-4.328 90.904-11.352 131.84-20.88 27.624 110.168 19.864 193.036-20.372 216.576z m47.292-263.744c-12.34-40.74-28.52-83.192-48.108-126.216 19.596-43.064 35.772-85.512 48.104-126.216 107.904 30.816 174.832 79.08 174.832 126.22-0.004 47.128-66.928 95.392-174.828 126.212z" fill="#00BDFF" p-id="19046"></path><path d="M431.344 516.696v0.008c0 48.388 38.7 87.616 86.44 87.616 47.736 0 86.432-39.228 86.432-87.616v-0.028c0-48.388-38.696-87.616-86.436-87.616-47.736 0-86.44 39.228-86.44 87.616v0.02z" fill="#00BDFF" p-id="19047"></path></svg>
    details: 整理React相关知识点，深度看个人掌握情况，量力而行
    link: /直击概念/08react/intro

  - title: 你应了解的 Patterns
    icon: <svg t="1723540549403" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="5546" width="200" height="200"><path d="M126.030769 0h220.553846A126.030769 126.030769 0 0 1 472.615385 126.030769v220.553846A126.030769 126.030769 0 0 1 346.584615 472.615385H126.030769A126.030769 126.030769 0 0 1 0 346.584615V126.030769A126.030769 126.030769 0 0 1 126.030769 0z m551.384616 0h220.553846A126.030769 126.030769 0 0 1 1024 126.030769v220.553846A126.030769 126.030769 0 0 1 897.969231 472.615385H677.415385A126.030769 126.030769 0 0 1 551.384615 346.584615V126.030769A126.030769 126.030769 0 0 1 677.415385 0z m-551.384616 551.384615h220.553846A126.030769 126.030769 0 0 1 472.615385 677.415385v220.553846A126.030769 126.030769 0 0 1 346.584615 1024H126.030769A126.030769 126.030769 0 0 1 0 897.969231V677.415385A126.030769 126.030769 0 0 1 126.030769 551.384615z m551.384616 0h220.553846A126.030769 126.030769 0 0 1 1024 677.415385v220.553846a126.030769 126.030769 0 0 1-126.030769 126.030769H677.415385A126.030769 126.030769 0 0 1 551.384615 897.969231V677.415385A126.030769 126.030769 0 0 1 677.415385 551.384615z m23.630769 78.769231a70.892308 70.892308 0 0 0-70.892308 70.892308v173.292308a70.892308 70.892308 0 0 0 70.892308 70.892307h173.292308a70.892308 70.892308 0 0 0 70.892307-70.892307V701.046154a70.892308 70.892308 0 0 0-70.892307-70.892308H701.046154z" fill="#000000" p-id="5547"></path></svg>
    details: 整理翻译自 www.patterns.dev 学习可去官网
    link: /直击概念/16patterns/intro
---

<script setup>
import TeamPage from './templates/TeamPage/TeamPage.vue'
</script>

<TeamPage />
