#!/bin/bash
#
#  Dummy script which expects particular inputs mimicing a NT password change using the ntlm_auth helper script
#
read username
if [ "$username" != 'username: john' ]; then
  echo "Invalid username input: $username"
  exit 1
fi
read domain
if [ "$domain" != 'nt-domain: example' ]; then
  echo "Invalid domain input: $domain"
  exit 1
fi
read newpwd
if [ "$newpwd" != 'new-nt-password-blob: 010203040506070809101112131415161718192021222324252627282930313233343536373839404142434445464748495051525354555657585960616263646566676869707172737475767778798081828384858687888990919293949596979899000102030405060708091011121314151617181920212223242526272829303132333435363738394041424344454647484950515253545556575859606162636465666768697071727374757677787980818283848586878889909192939495969798990001020304050607080910111213141516010203040506070809101112131415161718192021222324252627282930313233343536373839404142434445464748495051525354555657585960616263646566676869707172737475767778798081828384858687888990919293949596979899000102030405060708091011121314151617181920212223242526272829303132333435363738394041424344454647484950515253545556575859606162636465666768697071727374757677787980818283848586878889909192939495969798990001020304050607080910111213141516171819202122232425262728293031323334353637383940414243444546474849505152535455565758596061626364656667686970717273747576777879808182838485868788899091929394959697989900' ]; then
  echo "Invalid new NT password input: $newpwd"
  exit 1
fi
read oldhash
if [ "$oldhash" != 'old-nt-hash-blob: 01020304050607080910111213141516' ]; then
  echo "Invalid old NT password input: $oldhash"
  exit 1
fi
read newlm
if [ "$newlm" != 'new-lm-password-blob: 000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000' ]; then
  echo "Invalid new LM password input: $newlm"
  exit 1
fi
read oldlm
if [ "$oldlm" != 'old-lm-hash-blob: 00000000000000000000000000000000' ]; then
  echo "Invalid old LM password input: $oldlm"
  exit 1
fi
read dot
if [ "$dot" != '.' ]; then
  echo "Invalid dot input: $dot"
  exit 1
fi
echo "Password-Change: Yes"

