#pragma once
/*
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

/**
 * $Id: dc473da84f96256f412b7d7d4c0b1c0d01c1900a $
 * @file src/protocols/dns/attrs.h
 * @brief DHCP attributes
 *
 * @copyright 2018 The FreeRADIUS project
 * @copyright 2018 Arran Cudbard-Bell (a.cudbardb@freeradius.org)
 */
RCSIDH(dns_attrs_h, "$Id: dc473da84f96256f412b7d7d4c0b1c0d01c1900a $")

#include <freeradius-devel/util/dict.h>

extern HIDDEN fr_dict_t const *dict_dns;

extern HIDDEN fr_dict_attr_t const *attr_packet_type;
extern HIDDEN fr_dict_attr_t const *attr_dns_packet;
extern HIDDEN fr_dict_attr_t const *attr_dns_question;
extern HIDDEN fr_dict_attr_t const *attr_dns_rr;
extern HIDDEN fr_dict_attr_t const *attr_dns_ns;
extern HIDDEN fr_dict_attr_t const *attr_dns_ar;
