#pragma once

/*
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

/** Functions for establishing and managing low level sockets
 *
 * @file src/lib/util/sem.h
 *
 * @copyright 2021 Arran Cudbard-Bell (a.cudbardb@freeradius.org)
 */
RCSIDH(sem_h, "$Id: a89712d8ca126423874ad3b0b2b6e1d4bbfd35ae $")

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __EMSCRIPTEN__
#define HAVE_SEMAPHORES

int	fr_sem_pid(pid_t *pid, int sem_id);

int	fr_sem_uid(uid_t *uid, int sem_id);

int	fr_sem_gid(uid_t *gid, int sem_id);

int	fr_sem_cuid(uid_t *uid, int sem_id);

int	fr_sem_cgid(gid_t *gid, int sem_id);

int	fr_sem_post(int sem_id, char const *file, bool undo_on_exit);

int	fr_sem_take(int sem_id, char const *file, bool undo_on_exit);

int	fr_sem_wait(int sem_id, char const *file, bool undo_on_exit, bool nonblock);

int	fr_sem_close(int sem_id, char const *file);

int	fr_sem_get(char const *file, int proj_id, uid_t uid, gid_t gid, bool check_perm, bool must_exist);
#endif

#ifdef __cplusplus
}
#endif

