#pragma once
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

/** Functions for getting information about the system architecture
 *
 * @file src/lib/util/hw.h
 *
 * @author Arran Cudbard-Bell (a.cudbardb@freeradius.org)
 * @copyright 2020 Arran Cudbard-Bell (a.cudbardb@freeradius.org)
 */
RCSIDH(hw_h, "$Id: 8398c932167888cef5ad1ee600b59d07c8d3ed87 $")

#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>
#include <stdint.h>

size_t		fr_hw_cache_line_size(void);

uint32_t	fr_hw_num_cores_active(void);

#ifdef __cplusplus
}
#endif
